# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ....core.datetime_utils import serialize_datetime
from .google_service_account_credential import GoogleServiceAccountCredential

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class SinkGoogleSecurityOperations(pydantic.BaseModel):
    """
    Configuration for Google Security Operations (formerly Google Chronicle) as a Sink Provider.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/google-security-operations-sink-setup)
    """

    credential: GoogleServiceAccountCredential = pydantic.Field()
    """
    Credentials used for accessing the Google SecOps instance.
    """

    customer_id: str = pydantic.Field()
    """
    The customer ID of the Google SecOps instance
    """

    project_id: str = pydantic.Field()
    """
    The project ID of the Google SecOps instance.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The region of the Google SecOps instance. Usually `us` or `eu`.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The base URL for the Google SecOps API.
    """

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        extra = pydantic.Extra.allow
        json_encoders = {dt.datetime: serialize_datetime}
