    # # # This source code is subject to the license referenced at
    # # # https://github.com/NRLMMD-GEOIPS.

GeoIPS Base Package
====================

The GeoIPS Base Package provides a Python 3 based architecture supporting a wide variety of
satellite and weather data processing. The modular nature of the GeoIPS base infrastructure also allows
plug-and-play capability for user-specified custom functionality.

Installation
------------
See the
installation guide ([linux](./docs/source/getting-started/installing/linux_with_conda.rst),
[mac](./docs/source/getting-started/installing/mac_with_conda.rst),
[windows](./docs/source/getting-started/installing/windows_with_conda.rst))
within the source code documentation for installation instructions. GeoIPS has a fully supported
exhaustive installation process, including a full conda environment, as well as a more basic
pip based installation for "expert" users.

Creating your own GeoIPS Plugin
-------------------------------

See the instructions to
[setup a new plugin](./docs/source/devguide/dev_setup.rst)
if you are interested in creating your own functionality using the GeoIPS
infrastructure.

Contributing
-------------
Are you interested in
1. Notifying the geoips team of bugs?
2. Submitting a fix to a known bug?
3. Contributing new functionality to the main geoips code base?
4. Creating your own geoips-compatible plugin?

We welcome all feedback and contributions!

Please review our
[contributors guide](./docs/source/devguide/contributors.rst)
for more information.

Contact
----------
Please contact geoips@nrlmry.navy.mil with any questions comments or concerns, and
for additional information about our regular user/developer meetings, Slack channel,
and other forms of communication.

Slack Channel
----------
For those interested in contributing to GeoIPS, have informal feature requests, or
have lingering questions not answered by the documentation, feel free to join our
[Slack Channel](https://geoips.slack.com/). If you are not permitted to join, email
geoips@nrlmry.navy.mil to request access.

Acknowledgments and Citations
------------------------------
Please display the following acknowledgment within all published research using this software:

    "This work uses the GeoIPS(R) software package written and
    developed by the Naval Research Laboratory Marine Meteorology Division.
    https://github.com/NRLMMD-GEOIPS/"

See [GeoIPS LICENSE](https://github.com/NRLMMD-GEOIPS/geoips/blob/main/LICENSE) for
more information.

* https://github.com/NRLMMD-GEOIPS/geoips/blob/main/LICENSE

Documentation
------------------------------
The documentation can be found at:

https://nrlmmd-geoips.github.io/geoips/ 
