import * as apigatewayv2 from "aws-cdk-lib/aws-apigatewayv2";
import * as acm from "aws-cdk-lib/aws-certificatemanager";
import * as lambda from "aws-cdk-lib/aws-lambda";
import * as logs from "aws-cdk-lib/aws-logs";
import * as route53 from "aws-cdk-lib/aws-route53";
import { Construct } from "constructs";
import { WebSocketApiGatewayToLambdaProps, WebSocketRoute } from "./websocket-interface";
export declare class WebSocketApiGatewayToLambda extends Construct {
    readonly webSocketApi: apigatewayv2.WebSocketApi;
    readonly webSocketStage: apigatewayv2.WebSocketStage;
    readonly apiGatewayLogGroup?: logs.LogGroup;
    readonly lambdaFunction: lambda.IFunction;
    readonly aRecord?: route53.ARecord;
    readonly certificate?: acm.ICertificate;
    readonly domain?: apigatewayv2.DomainName;
    constructor(scope: Construct, id: string, props: WebSocketApiGatewayToLambdaProps);
    /**
     * Add custom routes to the WebSocket API
     */
    private addCustomRoutes;
    /**
     * Setup custom domain with certificate and Route53 record
     */
    private setupCustomDomain;
    /**
     * Add a custom route after construction (for dynamic route addition)
     */
    addRoute(route: WebSocketRoute): apigatewayv2.WebSocketRoute;
    /**
     * Get the WebSocket API URL (useful for outputs)
     */
    get webSocketUrl(): string;
}
