# VGD Counterfactuals

**VGD Counterfactuals** is a Python library for the generation and visualization of **counterfactual explanations** for **Graph Neural Networks (GNNs)** based around the [Visual Graph Datasets](https://github.com/awa59kst120df/visual_graph_datasets) format.

## What are Counterfactuals?

Counterfactuals are a method of explaining the predictions of complex machine learning models. For a certain prediction of a model, a counterfactual is an input element that is as similar as possible to the original input, but causes the largest possible deviation with respect to the original model output prediction.

They are sort of "counter examples" for the behavior of a model and can help to understand the decision boundary of the model.

The subject of this package are **graph counterfactuals**. They are generated by maximizing a customizable distance function in regards to the prediction output over all immediate neighbors of the original graph with respect to the allowed, domain-specific graph edit operations.

## Key Features

- 🎯 **Counterfactual Generation**: Generate meaningful counterfactual explanations for GNN predictions
- 📊 **Easy Visualization**: Built-in visualization capabilities for graph counterfactuals
- 🔧 **Flexible Framework**: Customizable distance functions and neighborhood definitions
- 🧪 **Domain Support**: Special support for molecular graphs and other domains
- 📈 **VGD Integration**: Seamless integration with Visual Graph Datasets

## Quick Navigation

- **[Installation](installation.md)** - Get started with installing VGD Counterfactuals
- **[Get Started](get_started_core.md)** - Learn the basics with a simple example
- **[Tutorials](tutorials.md)** - Dive deeper with comprehensive tutorials

## Requirements

- Python 3.9-3.12
- Visual Graph Datasets
- Compatible GNN models implementing the PredictGraph interface

## License

This project is licensed under the MIT License.

