from datetime import datetime

from asyncwhois.parse import BaseParser


def test_dateparsers():  # noqa
    date_and_time_examples = [
        "2010-07-04 04:18:23 +03:00",
        "2024-02-19 01:30:15.927683+11",
        "2008-08-31 04:14:06 KST",
        "2024/01/01 01:05:04 (JST)",
        "07 Aug 2024",
    ]
    date_and_time_examples += [
        "02-jan-2000",
        "11-February-2000",
        "20-10-2000",
        "2000-01-02",
        "2.1.2000",
        "2000.01.02",
        "2000/01/02",
        "2011/06/01 01:05:01",
        "2011/06/01 01:05:01 (+0900)",
        "20170209",
        "20110908 14:44:51",
        "02/01/2013",
        "2000. 01. 02.",
        "2014.03.08 10:28:24",
        "24-Jul-2009 13:20:03 UTC",
        "Tue Jun 21 23:59:59 GMT 2011",
        "2007-01-26T19:10:31",
        "2007-01-26T19:10:31Z",
        "2007-01-26T19:10:31Z[UTC]",  # extra
        "2018-12-01T16:17:30.568Z",  # extra
        "2011-09-08T14:44:51.622265+03:00",
        "2013-12-06T08:17:22-0800",
        "1970-01-01T02:00:00+02:00Z",  # extra
        "2011-09-08t14:44:51.622265",
        "2007-01-26T19:10:31",
        "2007-01-26T19:10:31Z",
        "2007-01-26t19:10:31.00z",  # extra
        "2011-03-30T19:36:27+0200",
        "2011-09-08T14:44:51.622265+03:00",
        "2000-08-22 18:55:20Z",  # extra
        "2000-08-22 18:55:20",
        "08 Apr 2013 05:44:00",
        "23/04/2015 12:00:07",
        "23/04/2015 12:00:07 EEST",
        "23/04/2015 12:00:07.619546 EEST",
        "2015-04-23 12:00:07.619546",
        "August 14 2017",
        "08.03.2014 10:28:24",
        "Tue Dec 12 2000",
        "before aug-1996",  # extra
        "2017-09-26 11:38:29 (GMT+00:00)",
    ]

    bp = BaseParser()

    for dt in date_and_time_examples:
        result = bp._parse_date(dt)
        assert isinstance(result, datetime), f"Failed to parse date string: {dt}"
