"""Add_usergroup_and_linkusergroup_table

Revision ID: 091b01f51f88
Revises: 5bf02391cfef
Create Date: 2024-09-09 13:17:51.008231

"""
import sqlalchemy as sa
import sqlmodel
from alembic import op


# revision identifiers, used by Alembic.
revision = "091b01f51f88"
down_revision = "5bf02391cfef"
branch_labels = None
depends_on = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "usergroup",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sqlmodel.sql.sqltypes.AutoString(), nullable=False),
        sa.Column(
            "timestamp_created", sa.DateTime(timezone=True), nullable=False
        ),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "linkusergroup",
        sa.Column("group_id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["group_id"],
            ["usergroup.id"],
        ),
        sa.ForeignKeyConstraint(
            ["user_id"],
            ["user_oauth.id"],
        ),
        sa.PrimaryKeyConstraint("group_id", "user_id"),
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("linkusergroup")
    op.drop_table("usergroup")
    # ### end Alembic commands ###
