# html2pic Examples

This directory contains practical examples demonstrating html2pic functionality.

## Running the Examples

Each example is a standalone Python script. Run them from this directory:

```bash
python 01_quick_start.py
python 02_flexbox_card.py
python 04_shadows_and_effects.py
python 05_background_images.py
```

## Examples Overview

### 1. Quick Start (`01_quick_start.py`)
**Basic card layout demonstrating core functionality**

![Quick Start Example](01_quick_start_output.png)

Simple flexbox card with centered content, demonstrating:
- Basic HTML structure
- Flexbox layout 
- Padding and margins
- Colors and typography

### 2. Flexbox Card (`02_flexbox_card.py`)
**User card with avatar and information**

![Flexbox Card Example](02_flexbox_card_output.png)

Social media style user card showing:
- Horizontal flexbox layout
- Gap between elements
- Border radius for circular avatar
- Different text styles and colors

### 3. Shadows and Effects (`04_shadows_and_effects.py`)
**Advanced visual effects**

![Shadows and Effects Example](04_shadows_and_effects_output.png)

Showcase of advanced styling features:
- Text shadows with RGBA colors
- Box shadows with blur and opacity
- Absolute positioning
- Multiple shadow effects

### 4. Background Images (`05_background_images.py`)
**Background image handling**

![Background Images Example](05_background_images_output.png)

Demonstrates background-image support:
- Different background-size modes
- Cover, contain, and tile options
- Fallback to background colors
- Text overlay on backgrounds

## Image Results

All examples generate PNG output files that you can view to see the actual rendered results. The images showcase html2pic's ability to create high-quality graphics from HTML and CSS.

## Notes

- Examples include encoding fixes for Windows console output
- Warning messages show css properties with limited support