# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_diagnosis_information import ClientFacingDiagnosisInformation
from ..types.client_facing_payor_search_response import ClientFacingPayorSearchResponse
from ..types.client_facing_payor_search_response_deprecated import ClientFacingPayorSearchResponseDeprecated
from ..types.payor_code_external_provider import PayorCodeExternalProvider
from .raw_client import AsyncRawInsuranceClient, RawInsuranceClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class InsuranceClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInsuranceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInsuranceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInsuranceClient
        """
        return self._raw_client

    def search_get_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = None,
        provider: typing.Optional[PayorCodeExternalProvider] = None,
        provider_payor_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingPayorSearchResponse]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingPayorSearchResponse]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.insurance.search_get_payor_info()
        """
        _response = self._raw_client.search_get_payor_info(
            insurance_name=insurance_name,
            provider=provider,
            provider_payor_id=provider_payor_id,
            request_options=request_options,
        )
        return _response.data

    def search_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = OMIT,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingPayorSearchResponseDeprecated]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingPayorSearchResponseDeprecated]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.insurance.search_payor_info()
        """
        _response = self._raw_client.search_payor_info(
            insurance_name=insurance_name, provider=provider, provider_id=provider_id, request_options=request_options
        )
        return _response.data

    def search_diagnosis(
        self, *, diagnosis_query: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingDiagnosisInformation]:
        """
        Parameters
        ----------
        diagnosis_query : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingDiagnosisInformation]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.insurance.search_diagnosis(diagnosis_query='diagnosis_query', )
        """
        _response = self._raw_client.search_diagnosis(diagnosis_query=diagnosis_query, request_options=request_options)
        return _response.data


class AsyncInsuranceClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInsuranceClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInsuranceClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInsuranceClient
        """
        return self._raw_client

    async def search_get_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = None,
        provider: typing.Optional[PayorCodeExternalProvider] = None,
        provider_payor_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingPayorSearchResponse]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_payor_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingPayorSearchResponse]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.insurance.search_get_payor_info()
        asyncio.run(main())
        """
        _response = await self._raw_client.search_get_payor_info(
            insurance_name=insurance_name,
            provider=provider,
            provider_payor_id=provider_payor_id,
            request_options=request_options,
        )
        return _response.data

    async def search_payor_info(
        self,
        *,
        insurance_name: typing.Optional[str] = OMIT,
        provider: typing.Optional[PayorCodeExternalProvider] = OMIT,
        provider_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[ClientFacingPayorSearchResponseDeprecated]:
        """
        Parameters
        ----------
        insurance_name : typing.Optional[str]

        provider : typing.Optional[PayorCodeExternalProvider]

        provider_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingPayorSearchResponseDeprecated]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.insurance.search_payor_info()
        asyncio.run(main())
        """
        _response = await self._raw_client.search_payor_info(
            insurance_name=insurance_name, provider=provider, provider_id=provider_id, request_options=request_options
        )
        return _response.data

    async def search_diagnosis(
        self, *, diagnosis_query: str, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingDiagnosisInformation]:
        """
        Parameters
        ----------
        diagnosis_query : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingDiagnosisInformation]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.insurance.search_diagnosis(diagnosis_query='diagnosis_query', )
        asyncio.run(main())
        """
        _response = await self._raw_client.search_diagnosis(
            diagnosis_query=diagnosis_query, request_options=request_options
        )
        return _response.data
