# This file was auto-generated by Fern from our API Definition.

import contextlib
import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.datetime_utils import serialize_datetime
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.allowed_radius import AllowedRadius
from ..types.ao_e_answer import AoEAnswer
from ..types.appointment_availability_slots import AppointmentAvailabilitySlots
from ..types.appointment_booking_request import AppointmentBookingRequest
from ..types.appointment_provider import AppointmentProvider
from ..types.appointment_reschedule_request import AppointmentRescheduleRequest
from ..types.area_info import AreaInfo
from ..types.billing import Billing
from ..types.client_facing_appointment import ClientFacingAppointment
from ..types.client_facing_appointment_cancellation_reason import ClientFacingAppointmentCancellationReason
from ..types.client_facing_lab import ClientFacingLab
from ..types.client_facing_lab_test import ClientFacingLabTest
from ..types.client_facing_labs import ClientFacingLabs
from ..types.client_facing_marker import ClientFacingMarker
from ..types.client_facing_order import ClientFacingOrder
from ..types.consent import Consent
from ..types.get_markers_response import GetMarkersResponse
from ..types.get_orders_response import GetOrdersResponse
from ..types.health_insurance_create_request import HealthInsuranceCreateRequest
from ..types.http_validation_error import HttpValidationError
from ..types.interpretation import Interpretation
from ..types.lab_results_metadata import LabResultsMetadata
from ..types.lab_results_raw import LabResultsRaw
from ..types.lab_test_collection_method import LabTestCollectionMethod
from ..types.lab_test_generation_method_filter import LabTestGenerationMethodFilter
from ..types.lab_test_resources_response import LabTestResourcesResponse
from ..types.lab_test_status import LabTestStatus
from ..types.order_activation_type import OrderActivationType
from ..types.order_low_level_status import OrderLowLevelStatus
from ..types.order_set_request import OrderSetRequest
from ..types.order_status import OrderStatus
from ..types.patient_address import PatientAddress
from ..types.patient_address_with_validation import PatientAddressWithValidation
from ..types.patient_details_with_validation import PatientDetailsWithValidation
from ..types.physician_create_request import PhysicianCreateRequest
from ..types.post_order_response import PostOrderResponse
from ..types.psc_info import PscInfo
from ..types.simulation_flags import SimulationFlags
from ..types.us_address import UsAddress
from .types.lab_tests_get_orders_request_order_direction import LabTestsGetOrdersRequestOrderDirection
from .types.lab_tests_get_orders_request_order_key import LabTestsGetOrdersRequestOrderKey
from .types.lab_tests_get_paginated_request_order_direction import LabTestsGetPaginatedRequestOrderDirection
from .types.lab_tests_get_paginated_request_order_key import LabTestsGetPaginatedRequestOrderKey
from .types.lab_tests_get_request_order_direction import LabTestsGetRequestOrderDirection
from .types.lab_tests_get_request_order_key import LabTestsGetRequestOrderKey

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawLabTestsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        *,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingLabTest]]:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingLabTest]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/lab_tests",
            method="GET",
            params={
                "generation_method": generation_method,
                "lab_slug": lab_slug,
                "collection_method": collection_method,
                "status": status,
                "marker_ids": marker_ids,
                "provider_ids": provider_ids,
                "name": name,
                "order_key": order_key,
                "order_direction": order_direction,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingLabTest],
                    parse_obj_as(
                        type_=typing.List[ClientFacingLabTest],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        name: str,
        method: LabTestCollectionMethod,
        description: str,
        marker_ids: typing.Optional[typing.Sequence[int]] = OMIT,
        provider_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        fasting: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingLabTest]:
        """
        Parameters
        ----------
        name : str

        method : LabTestCollectionMethod

        description : str

        marker_ids : typing.Optional[typing.Sequence[int]]

        provider_ids : typing.Optional[typing.Sequence[str]]

        fasting : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingLabTest]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/lab_tests",
            method="POST",
            json={
                "marker_ids": marker_ids,
                "provider_ids": provider_ids,
                "name": name,
                "method": method,
                "description": description,
                "fasting": fasting,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingLabTest,
                    parse_obj_as(
                        type_=ClientFacingLabTest,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_by_id(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingLabTest]:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingLabTest]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_test_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingLabTest,
                    parse_obj_as(
                        type_=ClientFacingLabTest,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_lab_test(
        self,
        lab_test_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingLabTest]:
        """
        Parameters
        ----------
        lab_test_id : str

        name : typing.Optional[str]

        active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingLabTest]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_test_id)}",
            method="PATCH",
            json={
                "name": name,
                "active": active,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingLabTest,
                    parse_obj_as(
                        type_=ClientFacingLabTest,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_markers(
        self,
        *,
        lab_id: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        name: typing.Optional[str] = None,
        a_la_carte_enabled: typing.Optional[bool] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetMarkersResponse]:
        """
        GET all the markers for the given lab.

        Parameters
        ----------
        lab_id : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            The identifier Vital assigned to a lab partner.

        name : typing.Optional[str]
            The name or test code of an individual biomarker or a panel.

        a_la_carte_enabled : typing.Optional[bool]

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetMarkersResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/lab_tests/markers",
            method="GET",
            params={
                "lab_id": lab_id,
                "name": name,
                "a_la_carte_enabled": a_la_carte_enabled,
                "page": page,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetMarkersResponse,
                    parse_obj_as(
                        type_=GetMarkersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_markers_for_order_set(
        self,
        *,
        request: OrderSetRequest,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetMarkersResponse]:
        """
        Parameters
        ----------
        request : OrderSetRequest

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetMarkersResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/lab_tests/list_order_set_markers",
            method="POST",
            params={
                "page": page,
                "size": size,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetMarkersResponse,
                    parse_obj_as(
                        type_=GetMarkersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_markers_for_lab_test(
        self,
        lab_test_id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetMarkersResponse]:
        """
        Parameters
        ----------
        lab_test_id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetMarkersResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_test_id)}/markers",
            method="GET",
            params={
                "page": page,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetMarkersResponse,
                    parse_obj_as(
                        type_=GetMarkersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_markers_by_lab_and_provider_id(
        self, provider_id: str, lab_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingMarker]:
        """
        GET a specific marker for the given lab and provider_id

        Parameters
        ----------
        provider_id : str

        lab_id : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingMarker]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_id)}/markers/{jsonable_encoder(provider_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingMarker,
                    parse_obj_as(
                        type_=ClientFacingMarker,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_labs(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ClientFacingLab]]:
        """
        GET all the labs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingLab]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/lab_tests/labs",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingLab],
                    parse_obj_as(
                        type_=typing.List[ClientFacingLab],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_paginated(
        self,
        *,
        lab_test_limit: typing.Optional[int] = None,
        next_cursor: typing.Optional[str] = None,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetPaginatedRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetPaginatedRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[LabTestResourcesResponse]:
        """
        GET lab tests the team has access to as a paginated list.

        Parameters
        ----------
        lab_test_limit : typing.Optional[int]

        next_cursor : typing.Optional[str]

        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetPaginatedRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetPaginatedRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[LabTestResourcesResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/lab_test",
            method="GET",
            params={
                "lab_test_limit": lab_test_limit,
                "next_cursor": next_cursor,
                "generation_method": generation_method,
                "lab_slug": lab_slug,
                "collection_method": collection_method,
                "status": status,
                "marker_ids": marker_ids,
                "provider_ids": provider_ids,
                "name": name,
                "order_key": order_key,
                "order_direction": order_direction,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LabTestResourcesResponse,
                    parse_obj_as(
                        type_=LabTestResourcesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def get_lab_test_collection_instruction_pdf(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        GET collection instructions for a lab test

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            PDF with collection instructions
        """
        with self._client_wrapper.httpx_client.stream(
            f"v3/lab_test/{jsonable_encoder(lab_test_id)}/collection_instruction_pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            def stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield stream()

    def get_phlebotomy_appointment_availability(
        self,
        *,
        request: UsAddress,
        start_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AppointmentAvailabilitySlots]:
        """
        Return the available time slots to book an appointment with a phlebotomist
        for the given address and order.

        Parameters
        ----------
        request : UsAddress

        start_date : typing.Optional[str]
            Start date for appointment availability

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AppointmentAvailabilitySlots]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/phlebotomy/appointment/availability",
            method="POST",
            params={
                "start_date": start_date,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AppointmentAvailabilitySlots,
                    parse_obj_as(
                        type_=AppointmentAvailabilitySlots,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def book_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Book an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/book",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def request_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        address: UsAddress,
        provider: AppointmentProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Request an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        address : UsAddress
            At-home phlebotomy appointment address.

        provider : AppointmentProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/request",
            method="POST",
            json={
                "address": address,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def reschedule_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Reschedule a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/reschedule",
            method="PATCH",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cancel_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        notes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Cancel a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        notes : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/cancel",
            method="PATCH",
            json={
                "cancellation_reason_id": cancellation_reason_id,
                "notes": notes,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_phlebotomy_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]:
        """
        Get the list of reasons for cancelling an at-home phlebotomy appointment.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/phlebotomy/appointment/cancellation-reasons",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingAppointmentCancellationReason],
                    parse_obj_as(
                        type_=typing.List[ClientFacingAppointmentCancellationReason],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_phlebotomy_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_area_info(
        self,
        *,
        zip_code: str,
        radius: typing.Optional[AllowedRadius] = None,
        lab: typing.Optional[ClientFacingLabs] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AreaInfo]:
        """
        GET information about an area with respect to lab-testing.

        Information returned:
        * Whether a given zip code is served by our Phlebotomy network.
        * List of Lab locations in the area.

        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        lab : typing.Optional[ClientFacingLabs]
            Lab to check for PSCs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AreaInfo]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/area/info",
            method="GET",
            params={
                "zip_code": zip_code,
                "radius": radius,
                "lab": lab,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AreaInfo,
                    parse_obj_as(
                        type_=AreaInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_psc_info(
        self,
        *,
        zip_code: str,
        lab_id: int,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PscInfo]:
        """
        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        lab_id : int
            Lab ID to check for PSCs

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PscInfo]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/psc/info",
            method="GET",
            params={
                "zip_code": zip_code,
                "lab_id": lab_id,
                "radius": radius,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PscInfo,
                    parse_obj_as(
                        type_=PscInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_order_psc_info(
        self,
        order_id: str,
        *,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PscInfo]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PscInfo]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/info",
            method="GET",
            params={
                "radius": radius,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PscInfo,
                    parse_obj_as(
                        type_=PscInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def get_result_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        This endpoint returns the lab results for the order.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            PDF with results
        """
        with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/result/pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            def stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield stream()

    def get_result_metadata(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[LabResultsMetadata]:
        """
        Return metadata related to order results, such as lab metadata,
        provider and sample dates.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[LabResultsMetadata]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/result/metadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LabResultsMetadata,
                    parse_obj_as(
                        type_=LabResultsMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_result_raw(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[LabResultsRaw]:
        """
        Return both metadata and raw json test data

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[LabResultsRaw]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/result",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LabResultsRaw,
                    parse_obj_as(
                        type_=LabResultsRaw,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def get_labels_pdf(
        self,
        order_id: str,
        *,
        collection_date: dt.datetime,
        number_of_labels: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        This endpoint returns the printed labels for the order.

        Parameters
        ----------
        order_id : str

        collection_date : dt.datetime
            Collection date

        number_of_labels : typing.Optional[int]
            Number of labels to generate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            PDF with labels
        """
        with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/labels/pdf",
            method="GET",
            params={
                "number_of_labels": number_of_labels,
                "collection_date": serialize_datetime(collection_date),
            },
            request_options=request_options,
        ) as _response:

            def stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield stream()

    def get_psc_appointment_availability(
        self,
        *,
        start_date: typing.Optional[str] = None,
        site_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        zip_code: typing.Optional[str] = None,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[AppointmentAvailabilitySlots]:
        """
        Parameters
        ----------
        start_date : typing.Optional[str]
            Start date for appointment availability

        site_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of site codes to fetch availability for

        zip_code : typing.Optional[str]
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search. (meters)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[AppointmentAvailabilitySlots]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/psc/appointment/availability",
            method="POST",
            params={
                "lab": "quest",
                "start_date": start_date,
                "site_codes": site_codes,
                "zip_code": zip_code,
                "radius": radius,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AppointmentAvailabilitySlots,
                    parse_obj_as(
                        type_=AppointmentAvailabilitySlots,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def book_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment/book",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def reschedule_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment/reschedule",
            method="PATCH",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cancel_psc_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        note : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment/cancel",
            method="PATCH",
            json={
                "cancellationReasonId": cancellation_reason_id,
                "note": note,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_psc_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/psc/appointment/cancellation-reasons",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingAppointmentCancellationReason],
                    parse_obj_as(
                        type_=typing.List[ClientFacingAppointmentCancellationReason],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_psc_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingAppointment]:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.contextmanager
    def get_order_collection_instruction_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        GET collection instructions for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            PDF with collection instructions
        """
        with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/collection_instruction_pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            def stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield stream()

    @contextlib.contextmanager
    def get_order_requistion_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        GET requisition pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            PDF with requisition form
        """
        with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/requisition/pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            def stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield stream()

    @contextlib.contextmanager
    def get_order_abn_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Iterator[HttpResponse[typing.Iterator[bytes]]]:
        """
        GET ABN pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.Iterator[HttpResponse[typing.Iterator[bytes]]]
            PDF with ABN form
        """
        with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/abn_pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            def stream() -> HttpResponse[typing.Iterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return HttpResponse(
                            response=_response, data=(_chunk for _chunk in _response.iter_bytes(chunk_size=_chunk_size))
                        )
                    _response.read()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield stream()

    def get_order(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ClientFacingOrder]:
        """
        GET individual order by ID.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ClientFacingOrder]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingOrder,
                    parse_obj_as(
                        type_=ClientFacingOrder,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_order(
        self,
        *,
        user_id: str,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddressWithValidation,
        lab_test_id: typing.Optional[str] = OMIT,
        order_set: typing.Optional[OrderSetRequest] = OMIT,
        collection_method: typing.Optional[LabTestCollectionMethod] = OMIT,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        health_insurance: typing.Optional[HealthInsuranceCreateRequest] = OMIT,
        priority: typing.Optional[bool] = OMIT,
        billing_type: typing.Optional[Billing] = OMIT,
        icd_codes: typing.Optional[typing.Sequence[str]] = OMIT,
        consents: typing.Optional[typing.Sequence[Consent]] = OMIT,
        activate_by: typing.Optional[str] = OMIT,
        aoe_answers: typing.Optional[typing.Sequence[AoEAnswer]] = OMIT,
        passthrough: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostOrderResponse]:
        """
        Parameters
        ----------
        user_id : str

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddressWithValidation

        lab_test_id : typing.Optional[str]

        order_set : typing.Optional[OrderSetRequest]

        collection_method : typing.Optional[LabTestCollectionMethod]

        physician : typing.Optional[PhysicianCreateRequest]

        health_insurance : typing.Optional[HealthInsuranceCreateRequest]

        priority : typing.Optional[bool]
            Defines whether order is priority or not. For some labs, this refers to a STAT order.

        billing_type : typing.Optional[Billing]

        icd_codes : typing.Optional[typing.Sequence[str]]

        consents : typing.Optional[typing.Sequence[Consent]]

        activate_by : typing.Optional[str]
            Schedule an Order to be processed in a future date.

        aoe_answers : typing.Optional[typing.Sequence[AoEAnswer]]

        passthrough : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order",
            method="POST",
            json={
                "user_id": user_id,
                "lab_test_id": lab_test_id,
                "order_set": order_set,
                "collection_method": collection_method,
                "physician": physician,
                "health_insurance": health_insurance,
                "priority": priority,
                "billing_type": billing_type,
                "icd_codes": icd_codes,
                "consents": consents,
                "activate_by": activate_by,
                "aoe_answers": aoe_answers,
                "passthrough": passthrough,
                "patient_details": patient_details,
                "patient_address": patient_address,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def import_order(
        self,
        *,
        user_id: str,
        billing_type: Billing,
        order_set: OrderSetRequest,
        collection_method: LabTestCollectionMethod,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddress,
        sample_id: str,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostOrderResponse]:
        """
        Parameters
        ----------
        user_id : str

        billing_type : Billing

        order_set : OrderSetRequest

        collection_method : LabTestCollectionMethod

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddress

        sample_id : str

        physician : typing.Optional[PhysicianCreateRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/order/import",
            method="POST",
            json={
                "user_id": user_id,
                "billing_type": billing_type,
                "order_set": order_set,
                "collection_method": collection_method,
                "physician": physician,
                "patient_details": patient_details,
                "patient_address": patient_address,
                "sample_id": sample_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cancel_order(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PostOrderResponse]:
        """
        POST cancel order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/cancel",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def simulate_order_process(
        self,
        order_id: str,
        *,
        final_status: typing.Optional[OrderStatus] = None,
        delay: typing.Optional[int] = None,
        request: typing.Optional[SimulationFlags] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Get available test kits.

        Parameters
        ----------
        order_id : str

        final_status : typing.Optional[OrderStatus]

        delay : typing.Optional[int]

        request : typing.Optional[SimulationFlags]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/test",
            method="POST",
            params={
                "final_status": final_status,
                "delay": delay,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_on_site_collection_order_draw_completed(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PostOrderResponse]:
        """
        PATCH update on site collection order when draw is completed

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/draw_completed",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_orders(
        self,
        *,
        search_input: typing.Optional[str] = None,
        start_date: typing.Optional[dt.datetime] = None,
        end_date: typing.Optional[dt.datetime] = None,
        updated_start_date: typing.Optional[dt.datetime] = None,
        updated_end_date: typing.Optional[dt.datetime] = None,
        status: typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]] = None,
        order_key: typing.Optional[LabTestsGetOrdersRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetOrdersRequestOrderDirection] = None,
        order_type: typing.Optional[
            typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]
        ] = None,
        is_critical: typing.Optional[bool] = None,
        interpretation: typing.Optional[Interpretation] = None,
        order_activation_types: typing.Optional[
            typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]
        ] = None,
        user_id: typing.Optional[str] = None,
        patient_name: typing.Optional[str] = None,
        shipping_recipient_name: typing.Optional[str] = None,
        order_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GetOrdersResponse]:
        """
        GET many orders with filters.

        Parameters
        ----------
        search_input : typing.Optional[str]
            Search by order id, user id, patient name, shipping dob, or shipping recipient name.

        start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        updated_start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        updated_end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        status : typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]]
            Filter by low level status.

        order_key : typing.Optional[LabTestsGetOrdersRequestOrderKey]
            Order key to sort by.

        order_direction : typing.Optional[LabTestsGetOrdersRequestOrderDirection]
            Order direction to sort by.

        order_type : typing.Optional[typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]]
            Filter by method used to perform the lab test.

        is_critical : typing.Optional[bool]
            Filter by critical order status.

        interpretation : typing.Optional[Interpretation]
            Filter by result interpretation of the lab test.

        order_activation_types : typing.Optional[typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]]
            Filter by activation type.

        user_id : typing.Optional[str]
            Filter by user ID.

        patient_name : typing.Optional[str]
            Filter by patient name.

        shipping_recipient_name : typing.Optional[str]
            Filter by shipping recipient name.

        order_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by order ids.

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetOrdersResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "v3/orders",
            method="GET",
            params={
                "search_input": search_input,
                "start_date": serialize_datetime(start_date) if start_date is not None else None,
                "end_date": serialize_datetime(end_date) if end_date is not None else None,
                "updated_start_date": serialize_datetime(updated_start_date)
                if updated_start_date is not None
                else None,
                "updated_end_date": serialize_datetime(updated_end_date) if updated_end_date is not None else None,
                "status": status,
                "order_key": order_key,
                "order_direction": order_direction,
                "order_type": order_type,
                "is_critical": is_critical,
                "interpretation": interpretation,
                "order_activation_types": order_activation_types,
                "user_id": user_id,
                "patient_name": patient_name,
                "shipping_recipient_name": shipping_recipient_name,
                "order_ids": order_ids,
                "page": page,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetOrdersResponse,
                    parse_obj_as(
                        type_=GetOrdersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawLabTestsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        *,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingLabTest]]:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingLabTest]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/lab_tests",
            method="GET",
            params={
                "generation_method": generation_method,
                "lab_slug": lab_slug,
                "collection_method": collection_method,
                "status": status,
                "marker_ids": marker_ids,
                "provider_ids": provider_ids,
                "name": name,
                "order_key": order_key,
                "order_direction": order_direction,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingLabTest],
                    parse_obj_as(
                        type_=typing.List[ClientFacingLabTest],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        name: str,
        method: LabTestCollectionMethod,
        description: str,
        marker_ids: typing.Optional[typing.Sequence[int]] = OMIT,
        provider_ids: typing.Optional[typing.Sequence[str]] = OMIT,
        fasting: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingLabTest]:
        """
        Parameters
        ----------
        name : str

        method : LabTestCollectionMethod

        description : str

        marker_ids : typing.Optional[typing.Sequence[int]]

        provider_ids : typing.Optional[typing.Sequence[str]]

        fasting : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingLabTest]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/lab_tests",
            method="POST",
            json={
                "marker_ids": marker_ids,
                "provider_ids": provider_ids,
                "name": name,
                "method": method,
                "description": description,
                "fasting": fasting,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingLabTest,
                    parse_obj_as(
                        type_=ClientFacingLabTest,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_by_id(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingLabTest]:
        """
        GET all the lab tests the team has access to.

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingLabTest]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_test_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingLabTest,
                    parse_obj_as(
                        type_=ClientFacingLabTest,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_lab_test(
        self,
        lab_test_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        active: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingLabTest]:
        """
        Parameters
        ----------
        lab_test_id : str

        name : typing.Optional[str]

        active : typing.Optional[bool]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingLabTest]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_test_id)}",
            method="PATCH",
            json={
                "name": name,
                "active": active,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingLabTest,
                    parse_obj_as(
                        type_=ClientFacingLabTest,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_markers(
        self,
        *,
        lab_id: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        name: typing.Optional[str] = None,
        a_la_carte_enabled: typing.Optional[bool] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetMarkersResponse]:
        """
        GET all the markers for the given lab.

        Parameters
        ----------
        lab_id : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            The identifier Vital assigned to a lab partner.

        name : typing.Optional[str]
            The name or test code of an individual biomarker or a panel.

        a_la_carte_enabled : typing.Optional[bool]

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetMarkersResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/lab_tests/markers",
            method="GET",
            params={
                "lab_id": lab_id,
                "name": name,
                "a_la_carte_enabled": a_la_carte_enabled,
                "page": page,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetMarkersResponse,
                    parse_obj_as(
                        type_=GetMarkersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_markers_for_order_set(
        self,
        *,
        request: OrderSetRequest,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetMarkersResponse]:
        """
        Parameters
        ----------
        request : OrderSetRequest

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetMarkersResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/lab_tests/list_order_set_markers",
            method="POST",
            params={
                "page": page,
                "size": size,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetMarkersResponse,
                    parse_obj_as(
                        type_=GetMarkersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_markers_for_lab_test(
        self,
        lab_test_id: str,
        *,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetMarkersResponse]:
        """
        Parameters
        ----------
        lab_test_id : str

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetMarkersResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_test_id)}/markers",
            method="GET",
            params={
                "page": page,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetMarkersResponse,
                    parse_obj_as(
                        type_=GetMarkersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_markers_by_lab_and_provider_id(
        self, provider_id: str, lab_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingMarker]:
        """
        GET a specific marker for the given lab and provider_id

        Parameters
        ----------
        provider_id : str

        lab_id : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingMarker]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/lab_tests/{jsonable_encoder(lab_id)}/markers/{jsonable_encoder(provider_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingMarker,
                    parse_obj_as(
                        type_=ClientFacingMarker,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_labs(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ClientFacingLab]]:
        """
        GET all the labs.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingLab]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/lab_tests/labs",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingLab],
                    parse_obj_as(
                        type_=typing.List[ClientFacingLab],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_paginated(
        self,
        *,
        lab_test_limit: typing.Optional[int] = None,
        next_cursor: typing.Optional[str] = None,
        generation_method: typing.Optional[LabTestGenerationMethodFilter] = None,
        lab_slug: typing.Optional[str] = None,
        collection_method: typing.Optional[LabTestCollectionMethod] = None,
        status: typing.Optional[LabTestStatus] = None,
        marker_ids: typing.Optional[typing.Union[int, typing.Sequence[int]]] = None,
        provider_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        name: typing.Optional[str] = None,
        order_key: typing.Optional[LabTestsGetPaginatedRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetPaginatedRequestOrderDirection] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[LabTestResourcesResponse]:
        """
        GET lab tests the team has access to as a paginated list.

        Parameters
        ----------
        lab_test_limit : typing.Optional[int]

        next_cursor : typing.Optional[str]

        generation_method : typing.Optional[LabTestGenerationMethodFilter]
            Filter on whether auto-generated lab tests created by Vital, manually created lab tests, or all lab tests should be returned.

        lab_slug : typing.Optional[str]
            Filter by the slug of the lab for these lab tests.

        collection_method : typing.Optional[LabTestCollectionMethod]
            Filter by the collection method for these lab tests.

        status : typing.Optional[LabTestStatus]
            Filter by the status of these lab tests.

        marker_ids : typing.Optional[typing.Union[int, typing.Sequence[int]]]
            Filter to only include lab tests containing these marker IDs.

        provider_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter to only include lab tests containing these provider IDs.

        name : typing.Optional[str]
            Filter by the name of the lab test (a case-insensitive substring search).

        order_key : typing.Optional[LabTestsGetPaginatedRequestOrderKey]

        order_direction : typing.Optional[LabTestsGetPaginatedRequestOrderDirection]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[LabTestResourcesResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/lab_test",
            method="GET",
            params={
                "lab_test_limit": lab_test_limit,
                "next_cursor": next_cursor,
                "generation_method": generation_method,
                "lab_slug": lab_slug,
                "collection_method": collection_method,
                "status": status,
                "marker_ids": marker_ids,
                "provider_ids": provider_ids,
                "name": name,
                "order_key": order_key,
                "order_direction": order_direction,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LabTestResourcesResponse,
                    parse_obj_as(
                        type_=LabTestResourcesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def get_lab_test_collection_instruction_pdf(
        self, lab_test_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        GET collection instructions for a lab test

        Parameters
        ----------
        lab_test_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            PDF with collection instructions
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v3/lab_test/{jsonable_encoder(lab_test_id)}/collection_instruction_pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            async def stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await stream()

    async def get_phlebotomy_appointment_availability(
        self,
        *,
        request: UsAddress,
        start_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AppointmentAvailabilitySlots]:
        """
        Return the available time slots to book an appointment with a phlebotomist
        for the given address and order.

        Parameters
        ----------
        request : UsAddress

        start_date : typing.Optional[str]
            Start date for appointment availability

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AppointmentAvailabilitySlots]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/phlebotomy/appointment/availability",
            method="POST",
            params={
                "start_date": start_date,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AppointmentAvailabilitySlots,
                    parse_obj_as(
                        type_=AppointmentAvailabilitySlots,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def book_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Book an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/book",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def request_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        address: UsAddress,
        provider: AppointmentProvider,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Request an at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        address : UsAddress
            At-home phlebotomy appointment address.

        provider : AppointmentProvider

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/request",
            method="POST",
            json={
                "address": address,
                "provider": provider,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def reschedule_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Reschedule a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/reschedule",
            method="PATCH",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cancel_phlebotomy_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        notes: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Cancel a previously booked at-home phlebotomy appointment.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        notes : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment/cancel",
            method="PATCH",
            json={
                "cancellation_reason_id": cancellation_reason_id,
                "notes": notes,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_phlebotomy_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]:
        """
        Get the list of reasons for cancelling an at-home phlebotomy appointment.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/phlebotomy/appointment/cancellation-reasons",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingAppointmentCancellationReason],
                    parse_obj_as(
                        type_=typing.List[ClientFacingAppointmentCancellationReason],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_phlebotomy_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/phlebotomy/appointment",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_area_info(
        self,
        *,
        zip_code: str,
        radius: typing.Optional[AllowedRadius] = None,
        lab: typing.Optional[ClientFacingLabs] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AreaInfo]:
        """
        GET information about an area with respect to lab-testing.

        Information returned:
        * Whether a given zip code is served by our Phlebotomy network.
        * List of Lab locations in the area.

        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        lab : typing.Optional[ClientFacingLabs]
            Lab to check for PSCs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AreaInfo]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/area/info",
            method="GET",
            params={
                "zip_code": zip_code,
                "radius": radius,
                "lab": lab,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AreaInfo,
                    parse_obj_as(
                        type_=AreaInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_psc_info(
        self,
        *,
        zip_code: str,
        lab_id: int,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PscInfo]:
        """
        Parameters
        ----------
        zip_code : str
            Zip code of the area to check

        lab_id : int
            Lab ID to check for PSCs

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PscInfo]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/psc/info",
            method="GET",
            params={
                "zip_code": zip_code,
                "lab_id": lab_id,
                "radius": radius,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PscInfo,
                    parse_obj_as(
                        type_=PscInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_order_psc_info(
        self,
        order_id: str,
        *,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PscInfo]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        radius : typing.Optional[AllowedRadius]
            Radius in which to search in miles

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PscInfo]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/info",
            method="GET",
            params={
                "radius": radius,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PscInfo,
                    parse_obj_as(
                        type_=PscInfo,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def get_result_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        This endpoint returns the lab results for the order.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            PDF with results
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/result/pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            async def stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await stream()

    async def get_result_metadata(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[LabResultsMetadata]:
        """
        Return metadata related to order results, such as lab metadata,
        provider and sample dates.

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[LabResultsMetadata]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/result/metadata",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LabResultsMetadata,
                    parse_obj_as(
                        type_=LabResultsMetadata,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_result_raw(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[LabResultsRaw]:
        """
        Return both metadata and raw json test data

        Parameters
        ----------
        order_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[LabResultsRaw]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/result",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    LabResultsRaw,
                    parse_obj_as(
                        type_=LabResultsRaw,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def get_labels_pdf(
        self,
        order_id: str,
        *,
        collection_date: dt.datetime,
        number_of_labels: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        This endpoint returns the printed labels for the order.

        Parameters
        ----------
        order_id : str

        collection_date : dt.datetime
            Collection date

        number_of_labels : typing.Optional[int]
            Number of labels to generate

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            PDF with labels
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/labels/pdf",
            method="GET",
            params={
                "number_of_labels": number_of_labels,
                "collection_date": serialize_datetime(collection_date),
            },
            request_options=request_options,
        ) as _response:

            async def stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await stream()

    async def get_psc_appointment_availability(
        self,
        *,
        start_date: typing.Optional[str] = None,
        site_codes: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        zip_code: typing.Optional[str] = None,
        radius: typing.Optional[AllowedRadius] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[AppointmentAvailabilitySlots]:
        """
        Parameters
        ----------
        start_date : typing.Optional[str]
            Start date for appointment availability

        site_codes : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            List of site codes to fetch availability for

        zip_code : typing.Optional[str]
            Zip code of the area to check

        radius : typing.Optional[AllowedRadius]
            Radius in which to search. (meters)

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[AppointmentAvailabilitySlots]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/psc/appointment/availability",
            method="POST",
            params={
                "lab": "quest",
                "start_date": start_date,
                "site_codes": site_codes,
                "zip_code": zip_code,
                "radius": radius,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    AppointmentAvailabilitySlots,
                    parse_obj_as(
                        type_=AppointmentAvailabilitySlots,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def book_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentBookingRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentBookingRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment/book",
            method="POST",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def reschedule_psc_appointment(
        self,
        order_id: str,
        *,
        request: AppointmentRescheduleRequest,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        request : AppointmentRescheduleRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment/reschedule",
            method="PATCH",
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cancel_psc_appointment(
        self,
        order_id: str,
        *,
        cancellation_reason_id: str,
        note: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Parameters
        ----------
        order_id : str
            Your Order ID.

        cancellation_reason_id : str

        note : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment/cancel",
            method="PATCH",
            json={
                "cancellationReasonId": cancellation_reason_id,
                "note": note,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_psc_appointment_cancellation_reason(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingAppointmentCancellationReason]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/psc/appointment/cancellation-reasons",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingAppointmentCancellationReason],
                    parse_obj_as(
                        type_=typing.List[ClientFacingAppointmentCancellationReason],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_psc_appointment(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingAppointment]:
        """
        Get the appointment associated with an order.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingAppointment]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/psc/appointment",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingAppointment,
                    parse_obj_as(
                        type_=ClientFacingAppointment,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    @contextlib.asynccontextmanager
    async def get_order_collection_instruction_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        GET collection instructions for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            PDF with collection instructions
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/collection_instruction_pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            async def stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await stream()

    @contextlib.asynccontextmanager
    async def get_order_requistion_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        GET requisition pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            PDF with requisition form
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/requisition/pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            async def stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await stream()

    @contextlib.asynccontextmanager
    async def get_order_abn_pdf(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]:
        """
        GET ABN pdf for an order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration. You can pass in configuration such as `chunk_size`, and more to customize the request and response.

        Returns
        -------
        typing.AsyncIterator[AsyncHttpResponse[typing.AsyncIterator[bytes]]]
            PDF with ABN form
        """
        async with self._client_wrapper.httpx_client.stream(
            f"v3/order/{jsonable_encoder(order_id)}/abn_pdf",
            method="GET",
            request_options=request_options,
        ) as _response:

            async def stream() -> AsyncHttpResponse[typing.AsyncIterator[bytes]]:
                try:
                    if 200 <= _response.status_code < 300:
                        _chunk_size = request_options.get("chunk_size", None) if request_options is not None else None
                        return AsyncHttpResponse(
                            response=_response,
                            data=(_chunk async for _chunk in _response.aiter_bytes(chunk_size=_chunk_size)),
                        )
                    await _response.aread()
                    if _response.status_code == 422:
                        raise UnprocessableEntityError(
                            headers=dict(_response.headers),
                            body=typing.cast(
                                HttpValidationError,
                                parse_obj_as(
                                    type_=HttpValidationError,  # type: ignore
                                    object_=_response.json(),
                                ),
                            ),
                        )
                    _response_json = _response.json()
                except JSONDecodeError:
                    raise ApiError(
                        status_code=_response.status_code, headers=dict(_response.headers), body=_response.text
                    )
                raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

            yield await stream()

    async def get_order(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ClientFacingOrder]:
        """
        GET individual order by ID.

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ClientFacingOrder]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ClientFacingOrder,
                    parse_obj_as(
                        type_=ClientFacingOrder,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_order(
        self,
        *,
        user_id: str,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddressWithValidation,
        lab_test_id: typing.Optional[str] = OMIT,
        order_set: typing.Optional[OrderSetRequest] = OMIT,
        collection_method: typing.Optional[LabTestCollectionMethod] = OMIT,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        health_insurance: typing.Optional[HealthInsuranceCreateRequest] = OMIT,
        priority: typing.Optional[bool] = OMIT,
        billing_type: typing.Optional[Billing] = OMIT,
        icd_codes: typing.Optional[typing.Sequence[str]] = OMIT,
        consents: typing.Optional[typing.Sequence[Consent]] = OMIT,
        activate_by: typing.Optional[str] = OMIT,
        aoe_answers: typing.Optional[typing.Sequence[AoEAnswer]] = OMIT,
        passthrough: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostOrderResponse]:
        """
        Parameters
        ----------
        user_id : str

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddressWithValidation

        lab_test_id : typing.Optional[str]

        order_set : typing.Optional[OrderSetRequest]

        collection_method : typing.Optional[LabTestCollectionMethod]

        physician : typing.Optional[PhysicianCreateRequest]

        health_insurance : typing.Optional[HealthInsuranceCreateRequest]

        priority : typing.Optional[bool]
            Defines whether order is priority or not. For some labs, this refers to a STAT order.

        billing_type : typing.Optional[Billing]

        icd_codes : typing.Optional[typing.Sequence[str]]

        consents : typing.Optional[typing.Sequence[Consent]]

        activate_by : typing.Optional[str]
            Schedule an Order to be processed in a future date.

        aoe_answers : typing.Optional[typing.Sequence[AoEAnswer]]

        passthrough : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order",
            method="POST",
            json={
                "user_id": user_id,
                "lab_test_id": lab_test_id,
                "order_set": order_set,
                "collection_method": collection_method,
                "physician": physician,
                "health_insurance": health_insurance,
                "priority": priority,
                "billing_type": billing_type,
                "icd_codes": icd_codes,
                "consents": consents,
                "activate_by": activate_by,
                "aoe_answers": aoe_answers,
                "passthrough": passthrough,
                "patient_details": patient_details,
                "patient_address": patient_address,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def import_order(
        self,
        *,
        user_id: str,
        billing_type: Billing,
        order_set: OrderSetRequest,
        collection_method: LabTestCollectionMethod,
        patient_details: PatientDetailsWithValidation,
        patient_address: PatientAddress,
        sample_id: str,
        physician: typing.Optional[PhysicianCreateRequest] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostOrderResponse]:
        """
        Parameters
        ----------
        user_id : str

        billing_type : Billing

        order_set : OrderSetRequest

        collection_method : LabTestCollectionMethod

        patient_details : PatientDetailsWithValidation

        patient_address : PatientAddress

        sample_id : str

        physician : typing.Optional[PhysicianCreateRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/order/import",
            method="POST",
            json={
                "user_id": user_id,
                "billing_type": billing_type,
                "order_set": order_set,
                "collection_method": collection_method,
                "physician": physician,
                "patient_details": patient_details,
                "patient_address": patient_address,
                "sample_id": sample_id,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cancel_order(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PostOrderResponse]:
        """
        POST cancel order

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/cancel",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def simulate_order_process(
        self,
        order_id: str,
        *,
        final_status: typing.Optional[OrderStatus] = None,
        delay: typing.Optional[int] = None,
        request: typing.Optional[SimulationFlags] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Get available test kits.

        Parameters
        ----------
        order_id : str

        final_status : typing.Optional[OrderStatus]

        delay : typing.Optional[int]

        request : typing.Optional[SimulationFlags]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/test",
            method="POST",
            params={
                "final_status": final_status,
                "delay": delay,
            },
            json=request,
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_on_site_collection_order_draw_completed(
        self, order_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PostOrderResponse]:
        """
        PATCH update on site collection order when draw is completed

        Parameters
        ----------
        order_id : str
            Your Order ID.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostOrderResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v3/order/{jsonable_encoder(order_id)}/draw_completed",
            method="PATCH",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostOrderResponse,
                    parse_obj_as(
                        type_=PostOrderResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_orders(
        self,
        *,
        search_input: typing.Optional[str] = None,
        start_date: typing.Optional[dt.datetime] = None,
        end_date: typing.Optional[dt.datetime] = None,
        updated_start_date: typing.Optional[dt.datetime] = None,
        updated_end_date: typing.Optional[dt.datetime] = None,
        status: typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]] = None,
        order_key: typing.Optional[LabTestsGetOrdersRequestOrderKey] = None,
        order_direction: typing.Optional[LabTestsGetOrdersRequestOrderDirection] = None,
        order_type: typing.Optional[
            typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]
        ] = None,
        is_critical: typing.Optional[bool] = None,
        interpretation: typing.Optional[Interpretation] = None,
        order_activation_types: typing.Optional[
            typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]
        ] = None,
        user_id: typing.Optional[str] = None,
        patient_name: typing.Optional[str] = None,
        shipping_recipient_name: typing.Optional[str] = None,
        order_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        page: typing.Optional[int] = None,
        size: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GetOrdersResponse]:
        """
        GET many orders with filters.

        Parameters
        ----------
        search_input : typing.Optional[str]
            Search by order id, user id, patient name, shipping dob, or shipping recipient name.

        start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        updated_start_date : typing.Optional[dt.datetime]
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        updated_end_date : typing.Optional[dt.datetime]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        status : typing.Optional[typing.Union[OrderLowLevelStatus, typing.Sequence[OrderLowLevelStatus]]]
            Filter by low level status.

        order_key : typing.Optional[LabTestsGetOrdersRequestOrderKey]
            Order key to sort by.

        order_direction : typing.Optional[LabTestsGetOrdersRequestOrderDirection]
            Order direction to sort by.

        order_type : typing.Optional[typing.Union[LabTestCollectionMethod, typing.Sequence[LabTestCollectionMethod]]]
            Filter by method used to perform the lab test.

        is_critical : typing.Optional[bool]
            Filter by critical order status.

        interpretation : typing.Optional[Interpretation]
            Filter by result interpretation of the lab test.

        order_activation_types : typing.Optional[typing.Union[OrderActivationType, typing.Sequence[OrderActivationType]]]
            Filter by activation type.

        user_id : typing.Optional[str]
            Filter by user ID.

        patient_name : typing.Optional[str]
            Filter by patient name.

        shipping_recipient_name : typing.Optional[str]
            Filter by shipping recipient name.

        order_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            Filter by order ids.

        page : typing.Optional[int]

        size : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetOrdersResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v3/orders",
            method="GET",
            params={
                "search_input": search_input,
                "start_date": serialize_datetime(start_date) if start_date is not None else None,
                "end_date": serialize_datetime(end_date) if end_date is not None else None,
                "updated_start_date": serialize_datetime(updated_start_date)
                if updated_start_date is not None
                else None,
                "updated_end_date": serialize_datetime(updated_end_date) if updated_end_date is not None else None,
                "status": status,
                "order_key": order_key,
                "order_direction": order_direction,
                "order_type": order_type,
                "is_critical": is_critical,
                "interpretation": interpretation,
                "order_activation_types": order_activation_types,
                "user_id": user_id,
                "patient_name": patient_name,
                "shipping_recipient_name": shipping_recipient_name,
                "order_ids": order_ids,
                "page": page,
                "size": size,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetOrdersResponse,
                    parse_obj_as(
                        type_=GetOrdersResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
