# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_provider_detailed import ClientFacingProviderDetailed
from .raw_client import AsyncRawProvidersClient, RawProvidersClient


class ProvidersClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawProvidersClient
        """
        return self._raw_client

    def get_all(
        self, *, source_type: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingProviderDetailed]:
        """
        Get Provider list

        Parameters
        ----------
        source_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingProviderDetailed]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.providers.get_all()
        """
        _response = self._raw_client.get_all(source_type=source_type, request_options=request_options)
        return _response.data


class AsyncProvidersClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawProvidersClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawProvidersClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawProvidersClient
        """
        return self._raw_client

    async def get_all(
        self, *, source_type: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingProviderDetailed]:
        """
        Get Provider list

        Parameters
        ----------
        source_type : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingProviderDetailed]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.providers.get_all()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_all(source_type=source_type, request_options=request_options)
        return _response.data
