# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_physician import ClientFacingPhysician
from ..types.client_facing_team import ClientFacingTeam
from ..types.client_facing_user import ClientFacingUser
from ..types.priority_resource import PriorityResource
from .raw_client import AsyncRawTeamClient, RawTeamClient


class TeamClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTeamClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTeamClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTeamClient
        """
        return self._raw_client

    def get_link_config(
        self, *, vital_link_token: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Post teams.

        Parameters
        ----------
        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.team.get_link_config()
        """
        _response = self._raw_client.get_link_config(vital_link_token=vital_link_token, request_options=request_options)
        return _response.data

    def get(self, team_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ClientFacingTeam:
        """
        Get team.

        Parameters
        ----------
        team_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingTeam
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.team.get(team_id='team_id', )
        """
        _response = self._raw_client.get(team_id, request_options=request_options)
        return _response.data

    def get_user_by_id(
        self, *, query_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingUser]:
        """
        Search team users by user_id

        Parameters
        ----------
        query_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingUser]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.team.get_user_by_id()
        """
        _response = self._raw_client.get_user_by_id(query_id=query_id, request_options=request_options)
        return _response.data

    def get_svix_url(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.team.get_svix_url()
        """
        _response = self._raw_client.get_svix_url(request_options=request_options)
        return _response.data

    def get_source_priorities(
        self,
        *,
        data_type: typing.Optional[PriorityResource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        GET source priorities.

        Parameters
        ----------
        data_type : typing.Optional[PriorityResource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.team.get_source_priorities()
        """
        _response = self._raw_client.get_source_priorities(data_type=data_type, request_options=request_options)
        return _response.data

    def update_source_priorities(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        Patch source priorities.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.team.update_source_priorities()
        """
        _response = self._raw_client.update_source_priorities(request_options=request_options)
        return _response.data

    def get_physicians(
        self, team_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingPhysician]:
        """
        Parameters
        ----------
        team_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingPhysician]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.team.get_physicians(team_id='team_id', )
        """
        _response = self._raw_client.get_physicians(team_id, request_options=request_options)
        return _response.data


class AsyncTeamClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTeamClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTeamClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTeamClient
        """
        return self._raw_client

    async def get_link_config(
        self, *, vital_link_token: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Post teams.

        Parameters
        ----------
        vital_link_token : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.team.get_link_config()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_link_config(
            vital_link_token=vital_link_token, request_options=request_options
        )
        return _response.data

    async def get(self, team_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ClientFacingTeam:
        """
        Get team.

        Parameters
        ----------
        team_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingTeam
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.team.get(team_id='team_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(team_id, request_options=request_options)
        return _response.data

    async def get_user_by_id(
        self, *, query_id: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingUser]:
        """
        Search team users by user_id

        Parameters
        ----------
        query_id : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingUser]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.team.get_user_by_id()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_user_by_id(query_id=query_id, request_options=request_options)
        return _response.data

    async def get_svix_url(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.Optional[typing.Any]]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.team.get_svix_url()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_svix_url(request_options=request_options)
        return _response.data

    async def get_source_priorities(
        self,
        *,
        data_type: typing.Optional[PriorityResource] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.List[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        GET source priorities.

        Parameters
        ----------
        data_type : typing.Optional[PriorityResource]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.team.get_source_priorities()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_source_priorities(data_type=data_type, request_options=request_options)
        return _response.data

    async def update_source_priorities(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[typing.Dict[str, typing.Optional[typing.Any]]]:
        """
        Patch source priorities.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[typing.Dict[str, typing.Optional[typing.Any]]]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.team.update_source_priorities()
        asyncio.run(main())
        """
        _response = await self._raw_client.update_source_priorities(request_options=request_options)
        return _response.data

    async def get_physicians(
        self, team_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.List[ClientFacingPhysician]:
        """
        Parameters
        ----------
        team_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.List[ClientFacingPhysician]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.team.get_physicians(team_id='team_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_physicians(team_id, request_options=request_options)
        return _response.data
