# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .parent_biomarker_data import ParentBiomarkerData
from .result_type import ResultType


class BiomarkerResult(UniversalBaseModel):
    """
    Represent the schema for an individual biomarker result.
    """

    name: str
    slug: typing.Optional[str] = None
    value: float
    result: str
    type: ResultType
    unit: typing.Optional[str] = None
    timestamp: typing.Optional[dt.datetime] = None
    notes: typing.Optional[str] = None
    reference_range: typing.Optional[str] = None
    min_range_value: typing.Optional[float] = None
    max_range_value: typing.Optional[float] = None
    is_above_max_range: typing.Optional[bool] = None
    is_below_min_range: typing.Optional[bool] = None
    interpretation: typing.Optional[str] = None
    loinc: typing.Optional[str] = None
    loinc_slug: typing.Optional[str] = None
    provider_id: typing.Optional[str] = None
    source_markers: typing.Optional[typing.List[ParentBiomarkerData]] = None
    performing_laboratory: typing.Optional[str] = None
    source_sample_id: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
