# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .basal_body_temperature_entry import BasalBodyTemperatureEntry
from .cervical_mucus_entry import CervicalMucusEntry
from .client_facing_menstrual_cycle_source_provider import ClientFacingMenstrualCycleSourceProvider
from .client_facing_menstrual_cycle_source_type import ClientFacingMenstrualCycleSourceType
from .client_facing_source import ClientFacingSource
from .contraceptive_entry import ContraceptiveEntry
from .detected_deviation_entry import DetectedDeviationEntry
from .home_pregnancy_test_entry import HomePregnancyTestEntry
from .home_progesterone_test_entry import HomeProgesteroneTestEntry
from .intermenstrual_bleeding_entry import IntermenstrualBleedingEntry
from .menstrual_flow_entry import MenstrualFlowEntry
from .ovulation_test_entry import OvulationTestEntry
from .sexual_activity_entry import SexualActivityEntry


class ClientFacingMenstrualCycle(UniversalBaseModel):
    id: str
    period_start: str
    period_end: typing.Optional[str] = None
    cycle_end: typing.Optional[str] = None
    is_predicted: typing.Optional[bool] = None
    menstrual_flow: typing.Optional[typing.List[MenstrualFlowEntry]] = None
    cervical_mucus: typing.Optional[typing.List[CervicalMucusEntry]] = None
    intermenstrual_bleeding: typing.Optional[typing.List[IntermenstrualBleedingEntry]] = None
    contraceptive: typing.Optional[typing.List[ContraceptiveEntry]] = None
    detected_deviations: typing.Optional[typing.List[DetectedDeviationEntry]] = None
    ovulation_test: typing.Optional[typing.List[OvulationTestEntry]] = None
    home_pregnancy_test: typing.Optional[typing.List[HomePregnancyTestEntry]] = None
    home_progesterone_test: typing.Optional[typing.List[HomeProgesteroneTestEntry]] = None
    sexual_activity: typing.Optional[typing.List[SexualActivityEntry]] = None
    basal_body_temperature: typing.Optional[typing.List[BasalBodyTemperatureEntry]] = None
    source_provider: ClientFacingMenstrualCycleSourceProvider
    source_type: ClientFacingMenstrualCycleSourceType = pydantic.Field()
    """
    ℹ️ This enum is non-exhaustive.
    """

    source_app_id: typing.Optional[str] = None
    source_device_id: typing.Optional[str] = None
    created_at: dt.datetime
    updated_at: dt.datetime
    user_id: str
    source: ClientFacingSource

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
