# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .ethnicity import Ethnicity
from .gender_identity import GenderIdentity
from .guarantor_details import GuarantorDetails
from .race import Race
from .sexual_orientation import SexualOrientation


class ClientFacingPatientDetailsCompatible(UniversalBaseModel):
    first_name: typing.Optional[str] = None
    last_name: typing.Optional[str] = None
    dob: dt.datetime
    gender: str
    phone_number: typing.Optional[str] = None
    email: typing.Optional[str] = None
    medical_proxy: typing.Optional[GuarantorDetails] = pydantic.Field(default=None)
    """
    Parent/medical_proxy details. Required if patient is a minor.
    """

    race: typing.Optional[Race] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    ethnicity: typing.Optional[Ethnicity] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    sexual_orientation: typing.Optional[SexualOrientation] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    gender_identity: typing.Optional[GenderIdentity] = pydantic.Field(default=None)
    """
    If not provided, will be set to 'Not Specified'
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
