# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_source import ClientFacingSource
from .client_facing_sport import ClientFacingSport


class ClientFacingShallowWorkoutStream(UniversalBaseModel):
    user_id: str = pydantic.Field()
    """
    User id returned by vital create user request. This id should be stored in your database against the user and used for all interactions with the vital api.
    """

    workout_id: str
    provider_id: str
    message: typing.Optional[str] = None
    source: ClientFacingSource = pydantic.Field()
    """
    Source the data has come from.
    """

    sport: typing.Optional[ClientFacingSport] = pydantic.Field(default=None)
    """
    Sport's name
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
