# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .health_insurance_create_request_back_image import HealthInsuranceCreateRequestBackImage
from .health_insurance_create_request_front_image import HealthInsuranceCreateRequestFrontImage
from .health_insurance_create_request_patient_signature_image import HealthInsuranceCreateRequestPatientSignatureImage
from .responsible_relationship import ResponsibleRelationship
from .vital_core_schemas_db_schemas_lab_test_health_insurance_person_details import (
    VitalCoreSchemasDbSchemasLabTestHealthInsurancePersonDetails,
)


class HealthInsuranceCreateRequest(UniversalBaseModel):
    front_image: typing.Optional[HealthInsuranceCreateRequestFrontImage] = pydantic.Field(default=None)
    """
    An image of the front of the patient insurance card.
    """

    back_image: typing.Optional[HealthInsuranceCreateRequestBackImage] = pydantic.Field(default=None)
    """
    An image of the back of the patient insurance card.
    """

    patient_signature_image: typing.Optional[HealthInsuranceCreateRequestPatientSignatureImage] = pydantic.Field(
        default=None
    )
    """
    An image of the patient signature for health insurance billing.
    """

    subjective: typing.Optional[str] = pydantic.Field(default=None)
    """
    Textual description of what are the patient symptoms and attempted treatments.
    """

    assessment_plan: typing.Optional[str] = pydantic.Field(default=None)
    """
    Textual description of what are the physician assessments and testing plans.
    """

    payor_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique identifier representing a specific Health Insurance.
    """

    insurance_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Insurance unique number assigned to a patient, usually present on the insurance card.
    """

    responsible_relationship: typing.Optional[ResponsibleRelationship] = pydantic.Field(default=None)
    """
    Relationship between the patient and the insurance contractor. Values can be (Self, Spouse, Other Relationship).
    """

    responsible_details: typing.Optional[VitalCoreSchemasDbSchemasLabTestHealthInsurancePersonDetails] = pydantic.Field(
        default=None
    )
    """
    Responsible details when the value of responsible_relationship is not 'Self'.
    """

    diagnosis_codes: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Diagnosis codes for insurance billing.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
