# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .client_facing_provider import ClientFacingProvider
from .resource_availability import ResourceAvailability


class ProviderConnectionCreated(UniversalBaseModel):
    user_id: str
    source: ClientFacingProvider = pydantic.Field()
    """
    Deprecated. Use `provider` instead. Subject to removal after 1 Jan 2024.
    """

    provider: ClientFacingProvider
    external_user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    
    The unique identifier of the associated external data provider user.
    
    * OAuth Providers: User unique identifier; provider-specific formats
    * Password Providers: Username
    * Email Providers: Email
    * Junction Mobile SDK Providers: `null` (not available)
    """

    resource_availability: typing.Dict[str, ResourceAvailability]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
