# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.address import Address
from ..types.client_facing_insurance import ClientFacingInsurance
from ..types.client_facing_provider_with_status import ClientFacingProviderWithStatus
from ..types.client_facing_user import ClientFacingUser
from ..types.client_facing_user_key import ClientFacingUserKey
from ..types.ethnicity import Ethnicity
from ..types.gender_identity import GenderIdentity
from ..types.guarantor_details import GuarantorDetails
from ..types.metrics_result import MetricsResult
from ..types.paginated_users_response import PaginatedUsersResponse
from ..types.providers import Providers
from ..types.race import Race
from ..types.responsible_relationship import ResponsibleRelationship
from ..types.sexual_orientation import SexualOrientation
from ..types.user_info import UserInfo
from ..types.user_refresh_success_response import UserRefreshSuccessResponse
from ..types.user_sign_in_token_response import UserSignInTokenResponse
from ..types.user_success_response import UserSuccessResponse
from ..types.vital_core_schemas_db_schemas_lab_test_insurance_person_details import (
    VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails,
)
from .raw_client import AsyncRawUserClient, RawUserClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UserClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUserClient
        """
        return self._raw_client

    def get_all(
        self,
        *,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedUsersResponse:
        """
        GET All users for team.

        Parameters
        ----------
        offset : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedUsersResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get_all()
        """
        _response = self._raw_client.get_all(offset=offset, limit=limit, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        client_user_id: str,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingUserKey:
        """
        POST Create a Vital user given a client_user_id and returns the user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingUserKey
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.create(client_user_id='client_user_id', )
        """
        _response = self._raw_client.create(
            client_user_id=client_user_id,
            fallback_time_zone=fallback_time_zone,
            fallback_birth_date=fallback_birth_date,
            ingestion_start=ingestion_start,
            ingestion_end=ingestion_end,
            request_options=request_options,
        )
        return _response.data

    def get_team_metrics(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetricsResult:
        """
        GET metrics for team.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricsResult
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get_team_metrics()
        """
        _response = self._raw_client.get_team_metrics(request_options=request_options)
        return _response.data

    def get_user_sign_in_token(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserSignInTokenResponse:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSignInTokenResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get_user_sign_in_token(user_id='user_id', )
        """
        _response = self._raw_client.get_user_sign_in_token(user_id, request_options=request_options)
        return _response.data

    def get_connected_providers(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]:
        """
        GET Users connected providers

        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get_connected_providers(user_id='user_id', )
        """
        _response = self._raw_client.get_connected_providers(user_id, request_options=request_options)
        return _response.data

    def get(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ClientFacingUser:
        """
        GET User details given the user_id.

        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingUser
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get(user_id='user_id', )
        """
        _response = self._raw_client.get(user_id, request_options=request_options)
        return _response.data

    def delete(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> UserSuccessResponse:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSuccessResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.delete(user_id='user_id', )
        """
        _response = self._raw_client.delete(user_id, request_options=request_options)
        return _response.data

    def patch(
        self,
        user_id: str,
        *,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        client_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        user_id : str

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        client_user_id : typing.Optional[str]
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.patch(user_id='user_id', )
        """
        _response = self._raw_client.patch(
            user_id,
            fallback_time_zone=fallback_time_zone,
            fallback_birth_date=fallback_birth_date,
            ingestion_start=ingestion_start,
            ingestion_end=ingestion_end,
            client_user_id=client_user_id,
            request_options=request_options,
        )
        return _response.data

    def get_latest_user_info(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserInfo:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserInfo
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get_latest_user_info(user_id='user_id', )
        """
        _response = self._raw_client.get_latest_user_info(user_id, request_options=request_options)
        return _response.data

    def create_insurance(
        self,
        user_id: str,
        *,
        payor_code: str,
        member_id: str,
        relationship: ResponsibleRelationship,
        insured: VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails,
        group_id: typing.Optional[str] = OMIT,
        guarantor: typing.Optional[GuarantorDetails] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingInsurance:
        """
        Parameters
        ----------
        user_id : str

        payor_code : str

        member_id : str

        relationship : ResponsibleRelationship

        insured : VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails

        group_id : typing.Optional[str]

        guarantor : typing.Optional[GuarantorDetails]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingInsurance
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import ResponsibleRelationship
        from vital import VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails
        from vital import Gender
        from vital import Address
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.create_insurance(user_id='user_id', payor_code='payor_code', member_id='member_id', relationship=ResponsibleRelationship.SELF, insured=VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails(first_name='first_name', last_name='last_name', gender=Gender.FEMALE, address=Address(first_line='first_line', country='country', zip='zip', city='city', state='state', ), dob='dob', email='email', phone_number='phone_number', ), )
        """
        _response = self._raw_client.create_insurance(
            user_id,
            payor_code=payor_code,
            member_id=member_id,
            relationship=relationship,
            insured=insured,
            group_id=group_id,
            guarantor=guarantor,
            request_options=request_options,
        )
        return _response.data

    def get_latest_insurance(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingInsurance:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingInsurance
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get_latest_insurance(user_id='user_id', )
        """
        _response = self._raw_client.get_latest_insurance(user_id, request_options=request_options)
        return _response.data

    def upsert_user_info(
        self,
        user_id: str,
        *,
        first_name: str,
        last_name: str,
        email: str,
        phone_number: str,
        gender: str,
        dob: str,
        address: Address,
        medical_proxy: typing.Optional[GuarantorDetails] = OMIT,
        race: typing.Optional[Race] = OMIT,
        ethnicity: typing.Optional[Ethnicity] = OMIT,
        sexual_orientation: typing.Optional[SexualOrientation] = OMIT,
        gender_identity: typing.Optional[GenderIdentity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserInfo:
        """
        Parameters
        ----------
        user_id : str

        first_name : str

        last_name : str

        email : str

        phone_number : str

        gender : str

        dob : str

        address : Address

        medical_proxy : typing.Optional[GuarantorDetails]

        race : typing.Optional[Race]

        ethnicity : typing.Optional[Ethnicity]

        sexual_orientation : typing.Optional[SexualOrientation]

        gender_identity : typing.Optional[GenderIdentity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserInfo
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import Address
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.upsert_user_info(user_id='user_id', first_name='first_name', last_name='last_name', email='email', phone_number='phone_number', gender='gender', dob='dob', address=Address(first_line='first_line', country='country', zip='zip', city='city', state='state', ), )
        """
        _response = self._raw_client.upsert_user_info(
            user_id,
            first_name=first_name,
            last_name=last_name,
            email=email,
            phone_number=phone_number,
            gender=gender,
            dob=dob,
            address=address,
            medical_proxy=medical_proxy,
            race=race,
            ethnicity=ethnicity,
            sexual_orientation=sexual_orientation,
            gender_identity=gender_identity,
            request_options=request_options,
        )
        return _response.data

    def get_by_client_user_id(
        self, client_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingUser:
        """
        GET user_id from client_user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID number from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingUser
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.get_by_client_user_id(client_user_id='client_user_id', )
        """
        _response = self._raw_client.get_by_client_user_id(client_user_id, request_options=request_options)
        return _response.data

    def deregister_provider(
        self, user_id: str, provider: Providers, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserSuccessResponse:
        """
        Parameters
        ----------
        user_id : str

        provider : Providers
            Provider slug. e.g., `oura`, `fitbit`, `garmin`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSuccessResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        from vital import Providers
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.deregister_provider(user_id='user_id', provider=Providers.OURA, )
        """
        _response = self._raw_client.deregister_provider(user_id, provider, request_options=request_options)
        return _response.data

    def undo_delete(
        self,
        *,
        user_id: typing.Optional[str] = None,
        client_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserSuccessResponse:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to undo deletion. Mutually exclusive with `client_user_id`.

        client_user_id : typing.Optional[str]
            Client User ID to undo deletion. Mutually exclusive with `user_id`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSuccessResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.undo_delete()
        """
        _response = self._raw_client.undo_delete(
            user_id=user_id, client_user_id=client_user_id, request_options=request_options
        )
        return _response.data

    def refresh(
        self,
        user_id: str,
        *,
        timeout: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserRefreshSuccessResponse:
        """
        Trigger a manual refresh for a specific user

        Parameters
        ----------
        user_id : str

        timeout : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserRefreshSuccessResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.user.refresh(user_id='user_id', )
        """
        _response = self._raw_client.refresh(user_id, timeout=timeout, request_options=request_options)
        return _response.data


class AsyncUserClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUserClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUserClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUserClient
        """
        return self._raw_client

    async def get_all(
        self,
        *,
        offset: typing.Optional[int] = None,
        limit: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PaginatedUsersResponse:
        """
        GET All users for team.

        Parameters
        ----------
        offset : typing.Optional[int]

        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PaginatedUsersResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get_all()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_all(offset=offset, limit=limit, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        client_user_id: str,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingUserKey:
        """
        POST Create a Vital user given a client_user_id and returns the user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingUserKey
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.create(client_user_id='client_user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            client_user_id=client_user_id,
            fallback_time_zone=fallback_time_zone,
            fallback_birth_date=fallback_birth_date,
            ingestion_start=ingestion_start,
            ingestion_end=ingestion_end,
            request_options=request_options,
        )
        return _response.data

    async def get_team_metrics(self, *, request_options: typing.Optional[RequestOptions] = None) -> MetricsResult:
        """
        GET metrics for team.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        MetricsResult
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get_team_metrics()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_team_metrics(request_options=request_options)
        return _response.data

    async def get_user_sign_in_token(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserSignInTokenResponse:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSignInTokenResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get_user_sign_in_token(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_user_sign_in_token(user_id, request_options=request_options)
        return _response.data

    async def get_connected_providers(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]:
        """
        GET Users connected providers

        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Dict[str, typing.List[ClientFacingProviderWithStatus]]
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get_connected_providers(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_connected_providers(user_id, request_options=request_options)
        return _response.data

    async def get(self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> ClientFacingUser:
        """
        GET User details given the user_id.

        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingUser
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(user_id, request_options=request_options)
        return _response.data

    async def delete(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserSuccessResponse:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSuccessResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.delete(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.delete(user_id, request_options=request_options)
        return _response.data

    async def patch(
        self,
        user_id: str,
        *,
        fallback_time_zone: typing.Optional[str] = OMIT,
        fallback_birth_date: typing.Optional[str] = OMIT,
        ingestion_start: typing.Optional[str] = OMIT,
        ingestion_end: typing.Optional[str] = OMIT,
        client_user_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        user_id : str

        fallback_time_zone : typing.Optional[str]

                Fallback time zone of the user, in the form of a valid IANA tzdatabase identifier (e.g., `Europe/London` or `America/Los_Angeles`).
                Used when pulling data from sources that are completely time zone agnostic (e.g., all time is relative to UTC clock, without any time zone attributions on data points).


        fallback_birth_date : typing.Optional[str]
            Fallback date of birth of the user, in YYYY-mm-dd format. Used for calculating max heartrate for providers that don not provide users' age.

        ingestion_start : typing.Optional[str]
            Starting bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        ingestion_end : typing.Optional[str]
            Ending bound for user [data ingestion bounds](https://docs.tryvital.io/wearables/providers/data-ingestion-bounds).

        client_user_id : typing.Optional[str]
            A unique ID representing the end user. Typically this will be a user ID from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.patch(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.patch(
            user_id,
            fallback_time_zone=fallback_time_zone,
            fallback_birth_date=fallback_birth_date,
            ingestion_start=ingestion_start,
            ingestion_end=ingestion_end,
            client_user_id=client_user_id,
            request_options=request_options,
        )
        return _response.data

    async def get_latest_user_info(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserInfo:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserInfo
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get_latest_user_info(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_latest_user_info(user_id, request_options=request_options)
        return _response.data

    async def create_insurance(
        self,
        user_id: str,
        *,
        payor_code: str,
        member_id: str,
        relationship: ResponsibleRelationship,
        insured: VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails,
        group_id: typing.Optional[str] = OMIT,
        guarantor: typing.Optional[GuarantorDetails] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientFacingInsurance:
        """
        Parameters
        ----------
        user_id : str

        payor_code : str

        member_id : str

        relationship : ResponsibleRelationship

        insured : VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails

        group_id : typing.Optional[str]

        guarantor : typing.Optional[GuarantorDetails]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingInsurance
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import ResponsibleRelationship
        from vital import VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails
        from vital import Gender
        from vital import Address
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.create_insurance(user_id='user_id', payor_code='payor_code', member_id='member_id', relationship=ResponsibleRelationship.SELF, insured=VitalCoreSchemasDbSchemasLabTestInsurancePersonDetails(first_name='first_name', last_name='last_name', gender=Gender.FEMALE, address=Address(first_line='first_line', country='country', zip='zip', city='city', state='state', ), dob='dob', email='email', phone_number='phone_number', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.create_insurance(
            user_id,
            payor_code=payor_code,
            member_id=member_id,
            relationship=relationship,
            insured=insured,
            group_id=group_id,
            guarantor=guarantor,
            request_options=request_options,
        )
        return _response.data

    async def get_latest_insurance(
        self, user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingInsurance:
        """
        Parameters
        ----------
        user_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingInsurance
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get_latest_insurance(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_latest_insurance(user_id, request_options=request_options)
        return _response.data

    async def upsert_user_info(
        self,
        user_id: str,
        *,
        first_name: str,
        last_name: str,
        email: str,
        phone_number: str,
        gender: str,
        dob: str,
        address: Address,
        medical_proxy: typing.Optional[GuarantorDetails] = OMIT,
        race: typing.Optional[Race] = OMIT,
        ethnicity: typing.Optional[Ethnicity] = OMIT,
        sexual_orientation: typing.Optional[SexualOrientation] = OMIT,
        gender_identity: typing.Optional[GenderIdentity] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserInfo:
        """
        Parameters
        ----------
        user_id : str

        first_name : str

        last_name : str

        email : str

        phone_number : str

        gender : str

        dob : str

        address : Address

        medical_proxy : typing.Optional[GuarantorDetails]

        race : typing.Optional[Race]

        ethnicity : typing.Optional[Ethnicity]

        sexual_orientation : typing.Optional[SexualOrientation]

        gender_identity : typing.Optional[GenderIdentity]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserInfo
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import Address
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.upsert_user_info(user_id='user_id', first_name='first_name', last_name='last_name', email='email', phone_number='phone_number', gender='gender', dob='dob', address=Address(first_line='first_line', country='country', zip='zip', city='city', state='state', ), )
        asyncio.run(main())
        """
        _response = await self._raw_client.upsert_user_info(
            user_id,
            first_name=first_name,
            last_name=last_name,
            email=email,
            phone_number=phone_number,
            gender=gender,
            dob=dob,
            address=address,
            medical_proxy=medical_proxy,
            race=race,
            ethnicity=ethnicity,
            sexual_orientation=sexual_orientation,
            gender_identity=gender_identity,
            request_options=request_options,
        )
        return _response.data

    async def get_by_client_user_id(
        self, client_user_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingUser:
        """
        GET user_id from client_user_id.

        Parameters
        ----------
        client_user_id : str
            A unique ID representing the end user. Typically this will be a user ID number from your application. Personally identifiable information, such as an email address or phone number, should not be used in the client_user_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingUser
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.get_by_client_user_id(client_user_id='client_user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_client_user_id(client_user_id, request_options=request_options)
        return _response.data

    async def deregister_provider(
        self, user_id: str, provider: Providers, *, request_options: typing.Optional[RequestOptions] = None
    ) -> UserSuccessResponse:
        """
        Parameters
        ----------
        user_id : str

        provider : Providers
            Provider slug. e.g., `oura`, `fitbit`, `garmin`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSuccessResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        from vital import Providers
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.deregister_provider(user_id='user_id', provider=Providers.OURA, )
        asyncio.run(main())
        """
        _response = await self._raw_client.deregister_provider(user_id, provider, request_options=request_options)
        return _response.data

    async def undo_delete(
        self,
        *,
        user_id: typing.Optional[str] = None,
        client_user_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserSuccessResponse:
        """
        Parameters
        ----------
        user_id : typing.Optional[str]
            User ID to undo deletion. Mutually exclusive with `client_user_id`.

        client_user_id : typing.Optional[str]
            Client User ID to undo deletion. Mutually exclusive with `user_id`.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserSuccessResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.undo_delete()
        asyncio.run(main())
        """
        _response = await self._raw_client.undo_delete(
            user_id=user_id, client_user_id=client_user_id, request_options=request_options
        )
        return _response.data

    async def refresh(
        self,
        user_id: str,
        *,
        timeout: typing.Optional[float] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UserRefreshSuccessResponse:
        """
        Trigger a manual refresh for a specific user

        Parameters
        ----------
        user_id : str

        timeout : typing.Optional[float]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UserRefreshSuccessResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.user.refresh(user_id='user_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.refresh(user_id, timeout=timeout, request_options=request_options)
        return _response.data
