# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.client_facing_stream import ClientFacingStream
from ..types.client_workout_response import ClientWorkoutResponse
from ..types.raw_workout import RawWorkout
from .raw_client import AsyncRawWorkoutsClient, RawWorkoutsClient


class WorkoutsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWorkoutsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWorkoutsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWorkoutsClient
        """
        return self._raw_client

    def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientWorkoutResponse:
        """
        Get workout summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientWorkoutResponse
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.workouts.get(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def get_raw(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawWorkout:
        """
        Get raw workout summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawWorkout
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.workouts.get_raw(user_id='user_id', start_date='start_date', )
        """
        _response = self._raw_client.get_raw(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    def get_by_workout_id(
        self, workout_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingStream:
        """
        Parameters
        ----------
        workout_id : str
            The Vital ID for the workout

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingStream
            Successful Response

        Examples
        --------
        from vital import Vital
        client = Vital(api_key="YOUR_API_KEY", )
        client.workouts.get_by_workout_id(workout_id='workout_id', )
        """
        _response = self._raw_client.get_by_workout_id(workout_id, request_options=request_options)
        return _response.data


class AsyncWorkoutsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWorkoutsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWorkoutsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWorkoutsClient
        """
        return self._raw_client

    async def get(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ClientWorkoutResponse:
        """
        Get workout summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientWorkoutResponse
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.workouts.get(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def get_raw(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RawWorkout:
        """
        Get raw workout summary for user_id

        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RawWorkout
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.workouts.get_raw(user_id='user_id', start_date='start_date', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_raw(
            user_id, start_date=start_date, provider=provider, end_date=end_date, request_options=request_options
        )
        return _response.data

    async def get_by_workout_id(
        self, workout_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ClientFacingStream:
        """
        Parameters
        ----------
        workout_id : str
            The Vital ID for the workout

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ClientFacingStream
            Successful Response

        Examples
        --------
        from vital import AsyncVital
        import asyncio
        client = AsyncVital(api_key="YOUR_API_KEY", )
        async def main() -> None:
            await client.workouts.get_by_workout_id(workout_id='workout_id', )
        asyncio.run(main())
        """
        _response = await self._raw_client.get_by_workout_id(workout_id, request_options=request_options)
        return _response.data
