# Pocket-Agent Documentation

Welcome to the comprehensive documentation for the Pocket-Agent framework! This documentation is organized into focused sections to help you find the information you need quickly.

## 📚 Documentation Sections

### [Getting Started](01_getting-started.md)
- Quick start guide for creating your first Pocket-Agent
- Basic examples and configuration
- Essential concepts for beginners

### [Core Concepts](02_core-concepts.md)
- PocketAgent base class and parameters
- The step method and execution flow
- Message management and conversation history

### [Hooks and Events](03_hooks-and-events.md)
- Hook system for customizing agent behavior
- Event system for frontend integration
- Custom hook implementations

### [Multi-Model Support](04_multi-model-support.md)
- Working with different LLM providers
- LiteLLM Router integration
- Model configuration and switching

### [PocketAgentClient](05_client.md)
- Client wrapper for MCP protocol
- Custom query parameters
- Tool error handling and custom parsers
- Server-initiated events

### [Multi-Agent Systems](06_multi-agent.md)
- Building complex multi-agent architectures
- Sub-agent tool integration
- Orchestrating multiple specialized agents

### [Agent-as-a-Server](07_agent-as-a-server.md)
- Using Pocket-Agent as an MCP server
- Integration with external frameworks
- Server setup and configuration

### [Testing](08_testing.md)
- Test suite overview
- Running tests with different options
- Coverage reporting
