"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerConfigSecret = exports.TlsSecret = exports.ServiceAccountTokenSecret = exports.SshAuthSecret = exports.BasicAuthSecret = exports.Secret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const base_1 = require("./base");
const k8s = require("./imports/k8s");
/**
 * Kubernetes Secrets let you store and manage sensitive information, such as
 * passwords, OAuth tokens, and ssh keys. Storing confidential information in a
 * Secret is safer and more flexible than putting it verbatim in a Pod
 * definition or in a container image.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret
 */
class Secret extends base_1.Resource {
    constructor(scope, id, props = {}) {
        var _g;
        super(scope, id);
        this.stringData = (_g = props.stringData) !== null && _g !== void 0 ? _g : {};
        this.apiObject = new k8s.KubeSecret(this, 'Resource', {
            metadata: props.metadata,
            type: props.type,
            stringData: this.stringData,
        });
    }
    /**
     * Imports a secret from the cluster as a reference.
     * @param name The name of the secret to reference.
     */
    static fromSecretName(name) {
        return { name };
    }
    /**
     * Adds a string data field to the secert.
     * @param key Key
     * @param value Value
     */
    addStringData(key, value) {
        this.stringData[key] = value;
    }
    /**
     * Gets a string data by key or undefined
     * @param key Key
     */
    getStringData(key) {
        return this.stringData[key];
    }
}
exports.Secret = Secret;
_a = JSII_RTTI_SYMBOL_1;
Secret[_a] = { fqn: "cdk8s-plus-22.Secret", version: "1.0.0-beta.163" };
/**
 * Create a secret for basic authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#basic-authentication-secret
 */
class BasicAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/basic-auth',
            stringData: {
                username: props.username,
                password: props.password,
            },
        });
    }
}
exports.BasicAuthSecret = BasicAuthSecret;
_b = JSII_RTTI_SYMBOL_1;
BasicAuthSecret[_b] = { fqn: "cdk8s-plus-22.BasicAuthSecret", version: "1.0.0-beta.163" };
/**
 * Create a secret for ssh authentication.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#ssh-authentication-secrets
 */
class SshAuthSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/ssh-auth',
            stringData: {
                'ssh-privatekey': props.sshPrivateKey,
            },
        });
    }
}
exports.SshAuthSecret = SshAuthSecret;
_c = JSII_RTTI_SYMBOL_1;
SshAuthSecret[_c] = { fqn: "cdk8s-plus-22.SshAuthSecret", version: "1.0.0-beta.163" };
/**
 * Create a secret for a service account token.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#service-account-token-secrets
 */
class ServiceAccountTokenSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/service-account-token',
            metadata: {
                annotations: {
                    'kubernetes.io/service-account.name': props.serviceAccount.name,
                },
            },
        });
    }
}
exports.ServiceAccountTokenSecret = ServiceAccountTokenSecret;
_d = JSII_RTTI_SYMBOL_1;
ServiceAccountTokenSecret[_d] = { fqn: "cdk8s-plus-22.ServiceAccountTokenSecret", version: "1.0.0-beta.163" };
/**
 * Create a secret for storing a TLS certificate and its associated key.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#tls-secrets
 */
class TlsSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/tls',
            stringData: {
                'tls.crt': props.tlsCert,
                'tls.key': props.tlsKey,
            },
        });
    }
}
exports.TlsSecret = TlsSecret;
_e = JSII_RTTI_SYMBOL_1;
TlsSecret[_e] = { fqn: "cdk8s-plus-22.TlsSecret", version: "1.0.0-beta.163" };
/**
 * Create a secret for storing credentials for accessing a container image
 * registry.
 *
 * @see https://kubernetes.io/docs/concepts/configuration/secret/#docker-config-secrets
 */
class DockerConfigSecret extends Secret {
    constructor(scope, id, props) {
        super(scope, id, {
            type: 'kubernetes.io/dockerconfigjson',
            stringData: {
                '.dockerconfigjson': JSON.stringify(props.data),
            },
        });
    }
}
exports.DockerConfigSecret = DockerConfigSecret;
_f = JSII_RTTI_SYMBOL_1;
DockerConfigSecret[_f] = { fqn: "cdk8s-plus-22.DockerConfigSecret", version: "1.0.0-beta.163" };
//# sourceMappingURL=data:application/json;base64,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