"""
Hex2Vec filter.

This module contains the OSM tags filter that was used in Hex2Vec [1].

References:
    1. https://dl.acm.org/doi/10.1145/3486635.3491076
"""

from srai.loaders.osm_loaders.filters import OsmTagsFilter

HEX2VEC_FILTER: OsmTagsFilter = {
    "aeroway": [
        "aerodrome",
        "apron",
        "gate",
        "hangar",
        "helipad",
        "heliport",
        "navigationaid",
        "runway",
        "taxiway",
        "terminal",
        "windsock",
    ],
    "amenity": [
        "animal_boarding",
        "animal_breeding",
        "animal_shelter",
        "arts_centre",
        "atm",
        "baby_hatch",
        "bank",
        "bar",
        "bbq",
        "bench",
        "bicycle_parking",
        "bicycle_rental",
        "bicycle_repair_station",
        "biergarten",
        "boat_rental",
        "boat_sharing",
        "brothel",
        "bureau_de_change",
        "bus_station",
        "cafe",
        "car_rental",
        "car_sharing",
        "car_wash",
        "casino",
        "charging_station",
        "childcare",
        "cinema",
        "clinic",
        "clock",
        "college",
        "community_centre",
        "conference_centre",
        "courthouse",
        "crematorium",
        "dentist",
        "dive_centre",
        "doctors",
        "dog_toilet",
        "drinking_water",
        "driving_school",
        "embassy",
        "events_venue",
        "fast_food",
        "ferry_terminal",
        "fire_station",
        "food_court",
        "fountain",
        "fuel",
        "funeral_hall",
        "gambling",
        "give_box",
        "grave_yard",
        "grit_bin",
        "gym",
        "hospital",
        "hunting_stand",
        "ice_cream",
        "internet_cafe",
        "kindergarten",
        "kitchen",
        "kneipp_water_cure",
        "language_school",
        "library",
        "lounger",
        "love_hotel",
        "marketplace",
        "monastery",
        "motorcycle_parking",
        "music_school",
        "nightclub",
        "nursing_home",
        "parking",
        "parking_entrance",
        "parking_space",
        "pharmacy",
        "photo_booth",
        "place_of_mourning",
        "place_of_worship",
        "planetarium",
        "police",
        "post_box",
        "post_depot",
        "post_office",
        "prison",
        "pub",
        "public_bath",
        "public_bookcase",
        "ranger_station",
        "recycling",
        "refugee_site",
        "restaurant",
        "sanitary_dump_station",
        "school",
        "shelter",
        "shower",
        "social_centre",
        "social_facility",
        "stripclub",
        "studio",
        "swingerclub",
        "taxi",
        "telephone",
        "theatre",
        "toilets",
        "townhall",
        "toy_library",
        "university",
        "vehicle_inspection",
        "vending_machine",
        "veterinary",
        "waste_disposal",
        "waste_transfer_station",
        "water_point",
        "watering_place",
    ],
    "building": [
        "apartments",
        "bakehouse",
        "barn",
        "bridge",
        "bungalow",
        "bunker",
        "cabin",
        "carport",
        "cathedral",
        "chapel",
        "church",
        "civic",
        "college",
        "commercial",
        "conservatory",
        "construction",
        "container",
        "cowshed",
        "detached",
        "dormitory",
        "farm",
        "farm_auxiliary",
        "fire_station",
        "garage",
        "garages",
        "gatehouse",
        "government",
        "grandstand",
        "greenhouse",
        "hangar",
        "hospital",
        "hotel",
        "house",
        "houseboat",
        "hut",
        "industrial",
        "kindergarten",
        "kiosk",
        "military",
        "monastery",
        "mosque",
        "office",
        "parking",
        "pavilion",
        "presbytery",
        "public",
        "religious",
        "residential",
        "retail",
        "riding_hall",
        "roof",
        "ruins",
        "school",
        "semidetached_house",
        "service",
        "shed",
        "shrine",
        "sports_hall",
        "stable",
        "stadium",
        "static_caravan",
        "sty",
        "supermarket",
        "synagogue",
        "temple",
        "terrace",
        "toilets",
        "train_station",
        "transformer_tower",
        "transportation",
        "tree_house",
        "university",
        "warehouse",
        "water_tower",
        "yes",
    ],
    "healthcare": [
        "alternative",
        "audiologist",
        "birthing_center",
        "blood_bank",
        "blood_donation",
        "counselling",
        "dialysis",
        "hospice",
        "laboratory",
        "midwife",
        "nurse",
        "occupational_therapist",
        "optometrist",
        "physiotherapist",
        "podiatrist",
        "psychotherapist",
        "rehabilitation",
        "sample_collection",
        "speech_therapist",
        "vaccination_centre",
    ],
    "historic": [
        "aircraft",
        "aqueduct",
        "archaeological_site",
        "battlefield",
        "bomb_crater",
        "boundary_stone",
        "building",
        "cannon",
        "castle",
        "castle_wall",
        "charcoal_pile",
        "church",
        "city_gate",
        "citywalls",
        "farm",
        "fort",
        "highwater_mark",
        "locomotive",
        "manor",
        "memorial",
        "milestone",
        "monastery",
        "monument",
        "pillory",
        "railway_car",
        "ruins",
        "rune_stone",
        "ship",
        "tank",
        "tower",
        "wayside_cross",
        "wayside_shrine",
        "wreck",
        "yes",
    ],
    "landuse": [
        "allotments",
        "basin",
        "brownfield",
        "cemetery",
        "commercial",
        "conservation",
        "construction",
        "depot",
        "farmland",
        "farmyard",
        "flowerbed",
        "forest",
        "garages",
        "greenfield",
        "greenhouse_horticulture",
        "industrial",
        "landfill",
        "meadow",
        "military",
        "orchard",
        "plant_nursery",
        "port",
        "quarry",
        "railway",
        "recreation_ground",
        "religious",
        "reservoir",
        "residential",
        "retail",
        "village_green",
        "vineyard",
        "winter_sports",
    ],
    "leisure": [
        "adult_gaming_centre",
        "amusement_arcade",
        "bandstand",
        "beach_resort",
        "bird_hide",
        "common",
        "dance",
        "disc_golf_course",
        "dog_park",
        "escape_game",
        "firepit",
        "fishing",
        "fitness_centre",
        "fitness_station",
        "garden",
        "hackerspace",
        "horse_riding",
        "ice_rink",
        "marina",
        "miniature_golf",
        "nature_reserve",
        "park",
        "picnic_table",
        "pitch",
        "playground",
        "slipway",
        "sports_centre",
        "stadium",
        "summer_camp",
        "swimming_area",
        "swimming_pool",
        "track",
        "water_park",
    ],
    "military": [
        "airfield",
        "barracks",
        "bunker",
        "checkpoint",
        "danger_area",
        "naval_base",
        "obstacle_course",
        "office",
        "range",
        "training_area",
        "trench",
    ],
    "natural": [
        "arete",
        "bare_rock",
        "bay",
        "beach",
        "cape",
        "cave_entrance",
        "cliff",
        "coastline",
        "dune",
        "fell",
        "grassland",
        "heath",
        "hot_spring",
        "isthmus",
        "mud",
        "peak",
        "peninsula",
        "reef",
        "ridge",
        "rock",
        "saddle",
        "sand",
        "scree",
        "scrub",
        "shingle",
        "sinkhole",
        "spring",
        "stone",
        "strait",
        "water",
        "wetland",
        "wood",
    ],
    "office": [
        "accountant",
        "advertising_agency",
        "architect",
        "association",
        "charity",
        "company",
        "consulting",
        "courier",
        "coworking",
        "diplomatic",
        "educational_institution",
        "employment_agency",
        "energy_supplier",
        "engineer",
        "estate_agent",
        "financial",
        "financial_advisor",
        "forestry",
        "foundation",
        "government",
        "guide",
        "insurance",
        "it",
        "lawyer",
        "logistics",
        "moving_company",
        "newspaper",
        "ngo",
        "notary",
        "political_party",
        "property_management",
        "quango",
        "religion",
        "research",
        "surveyor",
        "tax_advisor",
        "telecommunication",
        "visa",
        "water_utility",
        "yes",
    ],
    "shop": [
        "agrarian",
        "alcohol",
        "anime",
        "antiques",
        "appliance",
        "art",
        "atv",
        "baby_goods",
        "bag",
        "bakery",
        "bathroom_furnishing",
        "beauty",
        "bed",
        "beverages",
        "bicycle",
        "boat",
        "bookmaker",
        "books",
        "boutique",
        "brewing_supplies",
        "butcher",
        "camera",
        "candles",
        "cannabis",
        "car",
        "car_parts",
        "car_repair",
        "caravan",
        "carpet",
        "charity",
        "cheese",
        "chemist",
        "chocolate",
        "clothes",
        "coffee",
        "collector",
        "computer",
        "confectionery",
        "convenience",
        "copyshop",
        "cosmetics",
        "craft",
        "curtain",
        "dairy",
        "deli",
        "department_store",
        "doityourself",
        "doors",
        "drugstore",
        "dry_cleaning",
        "electrical",
        "electronics",
        "energy",
        "erotic",
        "fabric",
        "farm",
        "fashion",
        "fashion_accessories",
        "fireplace",
        "fishing",
        "flooring",
        "florist",
        "frame",
        "frozen_food",
        "fuel",
        "funeral_directors",
        "furniture",
        "games",
        "garden_centre",
        "garden_furniture",
        "gas",
        "general",
        "gift",
        "glaziery",
        "golf",
        "greengrocer",
        "groundskeeping",
        "hairdresser",
        "hairdresser_supply",
        "hardware",
        "health_food",
        "hearing_aids",
        "herbalist",
        "hifi",
        "household_linen",
        "houseware",
        "hunting",
        "ice_cream",
        "interior_decoration",
        "jewelry",
        "kiosk",
        "kitchen",
        "lamps",
        "laundry",
        "leather",
        "lighting",
        "locksmith",
        "lottery",
        "mall",
        "massage",
        "medical_supply",
        "military_surplus",
        "mobile_phone",
        "model",
        "money_lender",
        "motorcycle",
        "music",
        "musical_instrument",
        "newsagent",
        "nutrition_supplements",
        "optician",
        "organic",
        "outdoor",
        "outpost",
        "paint",
        "party",
        "pasta",
        "pastry",
        "pawnbroker",
        "perfumery",
        "pest_control",
        "pet",
        "pet_grooming",
        "photo",
        "pyrotechnics",
        "radiotechnics",
        "religion",
        "scuba_diving",
        "seafood",
        "second_hand",
        "security",
        "sewing",
        "shoes",
        "ski",
        "spices",
        "sports",
        "stationery",
        "storage_rental",
        "supermarket",
        "swimming_pool",
        "tailor",
        "tattoo",
        "tea",
        "ticket",
        "tiles",
        "tobacco",
        "toys",
        "trade",
        "travel_agency",
        "trophy",
        "tyres",
        "vacant",
        "vacuum_cleaner",
        "variety_store",
        "video",
        "video_games",
        "watches",
        "water",
        "weapons",
        "wholesale",
        "window_blind",
        "windows",
        "wine",
        "wool",
    ],
    "sport": [
        "10pin",
        "9pin",
        "aikido",
        "american_football",
        "archery",
        "athletics",
        "badminton",
        "bandy",
        "baseball",
        "basketball",
        "beachvolleyball",
        "biathlon",
        "billiards",
        "bmx",
        "bobsleigh",
        "boules",
        "bowls",
        "boxing",
        "bullfighting",
        "canadian_football",
        "canoe",
        "chess",
        "cliff_diving",
        "climbing",
        "climbing_adventure",
        "cricket",
        "croquet",
        "crossfit",
        "curling",
        "cycling",
        "darts",
        "dog_agility",
        "dog_racing",
        "equestrian",
        "fencing",
        "field_hockey",
        "fitness",
        "floorball",
        "free_flying",
        "futsal",
        "gaelic_games",
        "golf",
        "gymnastics",
        "handball",
        "hapkido",
        "horse_racing",
        "horseshoes",
        "ice_hockey",
        "ice_skating",
        "ice_stock",
        "judo",
        "karate",
        "karting",
        "kickboxing",
        "kitesurfing",
        "korfball",
        "lacrosse",
        "martial_arts",
        "miniature_golf",
        "model_aerodrome",
        "motocross",
        "motor",
        "multi",
        "netball",
        "obstacle_course",
        "orienteering",
        "paddle_tennis",
        "padel",
        "parachuting",
        "parkour",
        "pelota",
        "pickleball",
        "pilates",
        "pole_dance",
        "racquet",
        "rc_car",
        "roller_skating",
        "rowing",
        "rugby_league",
        "rugby_union",
        "running",
        "sailing",
        "scuba_diving",
        "shooting",
        "skateboard",
        "ski_jumping",
        "skiing",
        "snooker",
        "soccer",
        "speedway",
        "squash",
        "surfing",
        "swimming",
        "table_soccer",
        "table_tennis",
        "taekwondo",
        "tennis",
        "toboggan",
        "volleyball",
        "wakeboarding",
        "water_polo",
        "water_ski",
        "weightlifting",
        "wrestling",
        "yoga",
    ],
    "tourism": [
        "alpine_hut",
        "apartment",
        "aquarium",
        "artwork",
        "attraction",
        "camp_pitch",
        "camp_site",
        "caravan_site",
        "chalet",
        "gallery",
        "guest_house",
        "hostel",
        "hotel",
        "information",
        "motel",
        "museum",
        "picnic_site",
        "theme_park",
        "viewpoint",
        "wilderness_hut",
        "yes",
        "zoo",
    ],
    "water": [
        "basin",
        "canal",
        "ditch",
        "fish_pass",
        "lagoon",
        "lake",
        "lock",
        "moat",
        "oxbow",
        "pond",
        "reflecting_pool",
        "reservoir",
        "river",
        "wastewater",
    ],
    "waterway": [
        "boatyard",
        "canal",
        "dam",
        "ditch",
        "dock",
        "drain",
        "fairway",
        "fuel",
        "lock_gate",
        "pressurised",
        "river",
        "riverbank",
        "stream",
        "tidal_channel",
        "turning_point",
        "water_point",
        "waterfall",
        "weir",
    ],
}
