# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.boosting_profile import BoostingProfile
from rapidata.api_client.models.campaign_status import CampaignStatus
from typing import Optional, Set
from typing_extensions import Self

class CampaignQueryResult(BaseModel):
    """
    CampaignQueryResult
    """ # noqa: E501
    id: StrictStr
    owner_mail: StrictStr = Field(alias="ownerMail")
    name: StrictStr
    status: CampaignStatus
    priority: StrictInt
    boosting_profile: BoostingProfile = Field(alias="boostingProfile")
    requires_booster: Optional[StrictBool] = Field(default=None, alias="requiresBooster")
    created_at: datetime = Field(alias="createdAt")
    __properties: ClassVar[List[str]] = ["id", "ownerMail", "name", "status", "priority", "boostingProfile", "requiresBooster", "createdAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CampaignQueryResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "requires_booster",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of boosting_profile
        if self.boosting_profile:
            _dict['boostingProfile'] = self.boosting_profile.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CampaignQueryResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "ownerMail": obj.get("ownerMail"),
            "name": obj.get("name"),
            "status": obj.get("status"),
            "priority": obj.get("priority"),
            "boostingProfile": BoostingProfile.from_dict(obj["boostingProfile"]) if obj.get("boostingProfile") is not None else None,
            "requiresBooster": obj.get("requiresBooster"),
            "createdAt": obj.get("createdAt")
        })
        return _obj


