# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.compare_workflow_model1_pair_maker_information import CompareWorkflowModel1PairMakerInformation
from rapidata.api_client.models.compare_workflow_model1_referee import CompareWorkflowModel1Referee
from rapidata.api_client.models.elo_config import EloConfig
from rapidata.api_client.models.get_validation_rapids_result_asset import GetValidationRapidsResultAsset
from typing import Optional, Set
from typing_extensions import Self

class CompareWorkflowModel1(BaseModel):
    """
    CompareWorkflowModel1
    """ # noqa: E501
    t: StrictStr = Field(description="Discriminator value for CompareWorkflowModel", alias="_t")
    id: StrictStr
    referee: CompareWorkflowModel1Referee
    pair_maker_information: CompareWorkflowModel1PairMakerInformation = Field(alias="pairMakerInformation")
    state: StrictStr
    criteria: StrictStr
    name: StrictStr
    elo_config: EloConfig = Field(alias="eloConfig")
    context: Optional[StrictStr] = None
    context_asset: Optional[GetValidationRapidsResultAsset] = Field(default=None, alias="contextAsset")
    owner_mail: Optional[StrictStr] = Field(default=None, alias="ownerMail")
    __properties: ClassVar[List[str]] = ["_t", "id", "referee", "pairMakerInformation", "state", "criteria", "name", "eloConfig", "context", "contextAsset", "ownerMail"]

    @field_validator('t')
    def t_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['CompareWorkflowModel']):
            raise ValueError("must be one of enum values ('CompareWorkflowModel')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CompareWorkflowModel1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of referee
        if self.referee:
            _dict['referee'] = self.referee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pair_maker_information
        if self.pair_maker_information:
            _dict['pairMakerInformation'] = self.pair_maker_information.to_dict()
        # override the default output from pydantic by calling `to_dict()` of elo_config
        if self.elo_config:
            _dict['eloConfig'] = self.elo_config.to_dict()
        # override the default output from pydantic by calling `to_dict()` of context_asset
        if self.context_asset:
            _dict['contextAsset'] = self.context_asset.to_dict()
        # set to None if context (nullable) is None
        # and model_fields_set contains the field
        if self.context is None and "context" in self.model_fields_set:
            _dict['context'] = None

        # set to None if context_asset (nullable) is None
        # and model_fields_set contains the field
        if self.context_asset is None and "context_asset" in self.model_fields_set:
            _dict['contextAsset'] = None

        # set to None if owner_mail (nullable) is None
        # and model_fields_set contains the field
        if self.owner_mail is None and "owner_mail" in self.model_fields_set:
            _dict['ownerMail'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CompareWorkflowModel1 from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_t": obj.get("_t") if obj.get("_t") is not None else 'CompareWorkflowModel',
            "id": obj.get("id"),
            "referee": CompareWorkflowModel1Referee.from_dict(obj["referee"]) if obj.get("referee") is not None else None,
            "pairMakerInformation": CompareWorkflowModel1PairMakerInformation.from_dict(obj["pairMakerInformation"]) if obj.get("pairMakerInformation") is not None else None,
            "state": obj.get("state"),
            "criteria": obj.get("criteria"),
            "name": obj.get("name"),
            "eloConfig": EloConfig.from_dict(obj["eloConfig"]) if obj.get("eloConfig") is not None else None,
            "context": obj.get("context"),
            "contextAsset": GetValidationRapidsResultAsset.from_dict(obj["contextAsset"]) if obj.get("contextAsset") is not None else None,
            "ownerMail": obj.get("ownerMail")
        })
        return _obj


