# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.classify_payload import ClassifyPayload
from rapidata.api_client.models.create_demographic_rapid_model_asset import CreateDemographicRapidModelAsset
from rapidata.api_client.models.create_demographic_rapid_model_context_asset import CreateDemographicRapidModelContextAsset
from rapidata.api_client.models.feature_flag import FeatureFlag
from typing import Optional, Set
from typing_extensions import Self

class CreateDemographicRapidModel(BaseModel):
    """
    The model for creating a demographic rapid.
    """ # noqa: E501
    key: StrictStr = Field(description="The identifier of the demographic classification.")
    payload: ClassifyPayload
    feature_flags: Optional[List[FeatureFlag]] = Field(default=None, description="Optional feature flags to apply to the rapid.", alias="featureFlags")
    asset: Optional[CreateDemographicRapidModelAsset] = None
    context: Optional[StrictStr] = Field(default=None, description="An optional text context to show to the user.")
    context_asset: Optional[CreateDemographicRapidModelContextAsset] = Field(default=None, alias="contextAsset")
    __properties: ClassVar[List[str]] = ["key", "payload", "featureFlags", "asset", "context", "contextAsset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateDemographicRapidModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in feature_flags (list)
        _items = []
        if self.feature_flags:
            for _item_feature_flags in self.feature_flags:
                if _item_feature_flags:
                    _items.append(_item_feature_flags.to_dict())
            _dict['featureFlags'] = _items
        # override the default output from pydantic by calling `to_dict()` of asset
        if self.asset:
            _dict['asset'] = self.asset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of context_asset
        if self.context_asset:
            _dict['contextAsset'] = self.context_asset.to_dict()
        # set to None if feature_flags (nullable) is None
        # and model_fields_set contains the field
        if self.feature_flags is None and "feature_flags" in self.model_fields_set:
            _dict['featureFlags'] = None

        # set to None if asset (nullable) is None
        # and model_fields_set contains the field
        if self.asset is None and "asset" in self.model_fields_set:
            _dict['asset'] = None

        # set to None if context (nullable) is None
        # and model_fields_set contains the field
        if self.context is None and "context" in self.model_fields_set:
            _dict['context'] = None

        # set to None if context_asset (nullable) is None
        # and model_fields_set contains the field
        if self.context_asset is None and "context_asset" in self.model_fields_set:
            _dict['contextAsset'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateDemographicRapidModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "key": obj.get("key"),
            "payload": ClassifyPayload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "featureFlags": [FeatureFlag.from_dict(_item) for _item in obj["featureFlags"]] if obj.get("featureFlags") is not None else None,
            "asset": CreateDemographicRapidModelAsset.from_dict(obj["asset"]) if obj.get("asset") is not None else None,
            "context": obj.get("context"),
            "contextAsset": CreateDemographicRapidModelContextAsset.from_dict(obj["contextAsset"]) if obj.get("contextAsset") is not None else None
        })
        return _obj


