# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.completed_rapid_model import CompletedRapidModel
from rapidata.api_client.models.get_workflow_progress_result import GetWorkflowProgressResult
from rapidata.api_client.models.in_progress_rapid_model import InProgressRapidModel
from rapidata.api_client.models.not_started_rapid_model import NotStartedRapidModel
from typing import Optional, Set
from typing_extensions import Self

class GetAttachCategoryWorkflowResultOverviewResult(BaseModel):
    """
    GetAttachCategoryWorkflowResultOverviewResult
    """ # noqa: E501
    state: StrictStr
    progress: GetWorkflowProgressResult
    rapid_type: StrictStr = Field(alias="rapidType")
    not_started_rapids: List[NotStartedRapidModel] = Field(alias="notStartedRapids")
    hidden_not_started_count: StrictInt = Field(alias="hiddenNotStartedCount")
    in_progress_rapids: List[InProgressRapidModel] = Field(alias="inProgressRapids")
    hidden_in_progress_rapids_count: StrictInt = Field(alias="hiddenInProgressRapidsCount")
    completed_rapids: List[CompletedRapidModel] = Field(alias="completedRapids")
    hidden_completed_rapids_count: StrictInt = Field(alias="hiddenCompletedRapidsCount")
    result_type: Optional[StrictStr] = Field(default=None, alias="resultType")
    occurrences_by_category: Dict[str, StrictInt] = Field(alias="occurrencesByCategory")
    __properties: ClassVar[List[str]] = ["state", "progress", "rapidType", "notStartedRapids", "hiddenNotStartedCount", "inProgressRapids", "hiddenInProgressRapidsCount", "completedRapids", "hiddenCompletedRapidsCount", "resultType", "occurrencesByCategory"]

    @field_validator('state')
    def state_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['Created', 'Started', 'Labeling', 'Paused', 'Done', 'Failed']):
            raise ValueError("must be one of enum values ('Created', 'Started', 'Labeling', 'Paused', 'Done', 'Failed')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetAttachCategoryWorkflowResultOverviewResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "result_type",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of progress
        if self.progress:
            _dict['progress'] = self.progress.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in not_started_rapids (list)
        _items = []
        if self.not_started_rapids:
            for _item_not_started_rapids in self.not_started_rapids:
                if _item_not_started_rapids:
                    _items.append(_item_not_started_rapids.to_dict())
            _dict['notStartedRapids'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in in_progress_rapids (list)
        _items = []
        if self.in_progress_rapids:
            for _item_in_progress_rapids in self.in_progress_rapids:
                if _item_in_progress_rapids:
                    _items.append(_item_in_progress_rapids.to_dict())
            _dict['inProgressRapids'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in completed_rapids (list)
        _items = []
        if self.completed_rapids:
            for _item_completed_rapids in self.completed_rapids:
                if _item_completed_rapids:
                    _items.append(_item_completed_rapids.to_dict())
            _dict['completedRapids'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetAttachCategoryWorkflowResultOverviewResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "state": obj.get("state"),
            "progress": GetWorkflowProgressResult.from_dict(obj["progress"]) if obj.get("progress") is not None else None,
            "rapidType": obj.get("rapidType"),
            "notStartedRapids": [NotStartedRapidModel.from_dict(_item) for _item in obj["notStartedRapids"]] if obj.get("notStartedRapids") is not None else None,
            "hiddenNotStartedCount": obj.get("hiddenNotStartedCount"),
            "inProgressRapids": [InProgressRapidModel.from_dict(_item) for _item in obj["inProgressRapids"]] if obj.get("inProgressRapids") is not None else None,
            "hiddenInProgressRapidsCount": obj.get("hiddenInProgressRapidsCount"),
            "completedRapids": [CompletedRapidModel.from_dict(_item) for _item in obj["completedRapids"]] if obj.get("completedRapids") is not None else None,
            "hiddenCompletedRapidsCount": obj.get("hiddenCompletedRapidsCount"),
            "resultType": obj.get("resultType"),
            "occurrencesByCategory": obj.get("occurrencesByCategory")
        })
        return _obj


