# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.datapoint_model_asset import DatapointModelAsset
from rapidata.api_client.models.get_validation_rapids_result_asset import GetValidationRapidsResultAsset
from rapidata.api_client.models.get_validation_rapids_result_payload import GetValidationRapidsResultPayload
from rapidata.api_client.models.rapid_response import RapidResponse
from rapidata.api_client.models.rapid_state import RapidState
from typing import Optional, Set
from typing_extensions import Self

class GetWorkflowResultsResult(BaseModel):
    """
    GetWorkflowResultsResult
    """ # noqa: E501
    rapid_id: StrictStr = Field(alias="rapidId")
    payload: GetValidationRapidsResultPayload
    asset: DatapointModelAsset
    responses: List[RapidResponse]
    state: RapidState
    context: Optional[StrictStr] = None
    context_asset: Optional[GetValidationRapidsResultAsset] = Field(default=None, alias="contextAsset")
    __properties: ClassVar[List[str]] = ["rapidId", "payload", "asset", "responses", "state", "context", "contextAsset"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of GetWorkflowResultsResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asset
        if self.asset:
            _dict['asset'] = self.asset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in responses (list)
        _items = []
        if self.responses:
            for _item_responses in self.responses:
                if _item_responses:
                    _items.append(_item_responses.to_dict())
            _dict['responses'] = _items
        # override the default output from pydantic by calling `to_dict()` of context_asset
        if self.context_asset:
            _dict['contextAsset'] = self.context_asset.to_dict()
        # set to None if context (nullable) is None
        # and model_fields_set contains the field
        if self.context is None and "context" in self.model_fields_set:
            _dict['context'] = None

        # set to None if context_asset (nullable) is None
        # and model_fields_set contains the field
        if self.context_asset is None and "context_asset" in self.model_fields_set:
            _dict['contextAsset'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of GetWorkflowResultsResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "rapidId": obj.get("rapidId"),
            "payload": GetValidationRapidsResultPayload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "asset": DatapointModelAsset.from_dict(obj["asset"]) if obj.get("asset") is not None else None,
            "responses": [RapidResponse.from_dict(_item) for _item in obj["responses"]] if obj.get("responses") is not None else None,
            "state": obj.get("state"),
            "context": obj.get("context"),
            "contextAsset": GetValidationRapidsResultAsset.from_dict(obj["contextAsset"]) if obj.get("contextAsset") is not None else None
        })
        return _obj


