# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from rapidata.api_client.models.file_asset_metadata_value import FileAssetMetadataValue
from typing import Optional, Set
from typing_extensions import Self

class ProxyFileWrapper(BaseModel):
    """
    ProxyFileWrapper
    """ # noqa: E501
    t: StrictStr = Field(description="Discriminator value for ProxyFileWrapper", alias="_t")
    name: Optional[StrictStr] = None
    content_length: Optional[StrictInt] = Field(default=None, alias="contentLength")
    content_type: Optional[StrictStr] = Field(default=None, alias="contentType")
    is_in_memory: Optional[StrictBool] = Field(default=None, alias="isInMemory")
    metadata: Optional[Dict[str, FileAssetMetadataValue]] = None
    __properties: ClassVar[List[str]] = ["_t", "name", "contentLength", "contentType", "isInMemory", "metadata"]

    @field_validator('t')
    def t_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['ProxyFileWrapper']):
            raise ValueError("must be one of enum values ('ProxyFileWrapper')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ProxyFileWrapper from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * OpenAPI `readOnly` fields are excluded.
        """
        excluded_fields: Set[str] = set([
            "is_in_memory",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in metadata (dict)
        _field_dict = {}
        if self.metadata:
            for _key_metadata in self.metadata:
                if self.metadata[_key_metadata]:
                    _field_dict[_key_metadata] = self.metadata[_key_metadata].to_dict()
            _dict['metadata'] = _field_dict
        # set to None if content_length (nullable) is None
        # and model_fields_set contains the field
        if self.content_length is None and "content_length" in self.model_fields_set:
            _dict['contentLength'] = None

        # set to None if content_type (nullable) is None
        # and model_fields_set contains the field
        if self.content_type is None and "content_type" in self.model_fields_set:
            _dict['contentType'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ProxyFileWrapper from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "_t": obj.get("_t") if obj.get("_t") is not None else 'ProxyFileWrapper',
            "name": obj.get("name"),
            "contentLength": obj.get("contentLength"),
            "contentType": obj.get("contentType"),
            "isInMemory": obj.get("isInMemory"),
            "metadata": dict(
                (_k, FileAssetMetadataValue.from_dict(_v))
                for _k, _v in obj["metadata"].items()
            )
            if obj.get("metadata") is not None
            else None
        })
        return _obj


