# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from rapidata.api_client.models.datapoint_model_asset import DatapointModelAsset
from rapidata.api_client.models.get_validation_rapids_result_payload import GetValidationRapidsResultPayload
from rapidata.api_client.models.get_validation_rapids_result_truth import GetValidationRapidsResultTruth
from rapidata.api_client.models.rapid_model_referee import RapidModelReferee
from rapidata.api_client.models.rapid_state import RapidState
from typing import Optional, Set
from typing_extensions import Self

class RapidModel(BaseModel):
    """
    RapidModel
    """ # noqa: E501
    id: StrictStr
    payload: GetValidationRapidsResultPayload
    referee: RapidModelReferee
    asset: DatapointModelAsset
    state: RapidState
    has_responses: StrictBool = Field(alias="hasResponses")
    should_accept_incorrect: StrictBool = Field(alias="shouldAcceptIncorrect")
    truth: Optional[GetValidationRapidsResultTruth] = None
    explanation: Optional[StrictStr] = None
    random_correct_probability: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, alias="randomCorrectProbability")
    key: Optional[StrictStr] = None
    completed_at: Optional[datetime] = Field(default=None, alias="completedAt")
    __properties: ClassVar[List[str]] = ["id", "payload", "referee", "asset", "state", "hasResponses", "shouldAcceptIncorrect", "truth", "explanation", "randomCorrectProbability", "key", "completedAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RapidModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of payload
        if self.payload:
            _dict['payload'] = self.payload.to_dict()
        # override the default output from pydantic by calling `to_dict()` of referee
        if self.referee:
            _dict['referee'] = self.referee.to_dict()
        # override the default output from pydantic by calling `to_dict()` of asset
        if self.asset:
            _dict['asset'] = self.asset.to_dict()
        # override the default output from pydantic by calling `to_dict()` of truth
        if self.truth:
            _dict['truth'] = self.truth.to_dict()
        # set to None if truth (nullable) is None
        # and model_fields_set contains the field
        if self.truth is None and "truth" in self.model_fields_set:
            _dict['truth'] = None

        # set to None if explanation (nullable) is None
        # and model_fields_set contains the field
        if self.explanation is None and "explanation" in self.model_fields_set:
            _dict['explanation'] = None

        # set to None if random_correct_probability (nullable) is None
        # and model_fields_set contains the field
        if self.random_correct_probability is None and "random_correct_probability" in self.model_fields_set:
            _dict['randomCorrectProbability'] = None

        # set to None if key (nullable) is None
        # and model_fields_set contains the field
        if self.key is None and "key" in self.model_fields_set:
            _dict['key'] = None

        # set to None if completed_at (nullable) is None
        # and model_fields_set contains the field
        if self.completed_at is None and "completed_at" in self.model_fields_set:
            _dict['completedAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RapidModel from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "payload": GetValidationRapidsResultPayload.from_dict(obj["payload"]) if obj.get("payload") is not None else None,
            "referee": RapidModelReferee.from_dict(obj["referee"]) if obj.get("referee") is not None else None,
            "asset": DatapointModelAsset.from_dict(obj["asset"]) if obj.get("asset") is not None else None,
            "state": obj.get("state"),
            "hasResponses": obj.get("hasResponses"),
            "shouldAcceptIncorrect": obj.get("shouldAcceptIncorrect"),
            "truth": GetValidationRapidsResultTruth.from_dict(obj["truth"]) if obj.get("truth") is not None else None,
            "explanation": obj.get("explanation"),
            "randomCorrectProbability": obj.get("randomCorrectProbability"),
            "key": obj.get("key"),
            "completedAt": obj.get("completedAt")
        })
        return _obj


