# coding: utf-8

"""
    Rapidata.Dataset

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: v1
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from rapidata.api_client.models.confidence_interval import ConfidenceInterval
from rapidata.api_client.models.standing_status import StandingStatus
from typing import Optional, Set
from typing_extensions import Self

class StandingByBenchmark(BaseModel):
    """
    StandingByBenchmark
    """ # noqa: E501
    id: StrictStr
    name: StrictStr
    benchmark_id: StrictStr = Field(alias="benchmarkId")
    status: StandingStatus
    score: Optional[Union[StrictFloat, StrictInt]] = None
    wins: Union[StrictFloat, StrictInt]
    total_matches: Union[StrictFloat, StrictInt] = Field(alias="totalMatches")
    is_disabled: StrictBool = Field(alias="isDisabled")
    confidence_interval: Optional[ConfidenceInterval] = Field(default=None, alias="confidenceInterval")
    __properties: ClassVar[List[str]] = ["id", "name", "benchmarkId", "status", "score", "wins", "totalMatches", "isDisabled", "confidenceInterval"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of StandingByBenchmark from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of confidence_interval
        if self.confidence_interval:
            _dict['confidenceInterval'] = self.confidence_interval.to_dict()
        # set to None if score (nullable) is None
        # and model_fields_set contains the field
        if self.score is None and "score" in self.model_fields_set:
            _dict['score'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of StandingByBenchmark from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "benchmarkId": obj.get("benchmarkId"),
            "status": obj.get("status"),
            "score": obj.get("score"),
            "wins": obj.get("wins"),
            "totalMatches": obj.get("totalMatches"),
            "isDisabled": obj.get("isDisabled"),
            "confidenceInterval": ConfidenceInterval.from_dict(obj["confidenceInterval"]) if obj.get("confidenceInterval") is not None else None
        })
        return _obj


