# rapidata.api-client
No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

The `rapidata.api_client` package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v1
- Package version: 1.0.0
- Generator version: 7.9.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage

This python library package is generated without supporting files like setup.py or requirements files

To be able to use it, you will need these dependencies in your own package that uses this library:

* urllib3 >= 1.25.3, < 3.0.0
* python-dateutil >= 2.8.2
* pydantic >= 2
* typing-extensions >= 4.7.1

## Getting Started

In your own code, to use this library to connect and interact with rapidata.api-client,
you can run the following:

```python

import rapidata.api_client
from rapidata.api_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = rapidata.api_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: bearer
configuration.api_key['bearer'] = os.environ["API_KEY"]

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['bearer'] = 'Bearer'


# Enter a context with an instance of the API client
with rapidata.api_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = rapidata.api_client.AssetApi(api_client)
    file_name = 'file_name_example' # str | The name of the file to retrieve metadata for.

    try:
        # Gets the metadata for an asset by file name.
        api_response = api_instance.asset_file_name_metadata_get(file_name)
        print("The response of AssetApi->asset_file_name_metadata_get:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AssetApi->asset_file_name_metadata_get: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AssetApi* | [**asset_file_name_metadata_get**](rapidata/api_client/docs/AssetApi.md#asset_file_name_metadata_get) | **GET** /asset/{fileName}/metadata | Gets the metadata for an asset by file name.
*AssetApi* | [**asset_file_post**](rapidata/api_client/docs/AssetApi.md#asset_file_post) | **POST** /asset/file | Uploads a single asset to S3 and returns the asset details.
*AssetApi* | [**asset_url_post**](rapidata/api_client/docs/AssetApi.md#asset_url_post) | **POST** /asset/url | Uploads a single asset to S3 and returns the asset details.
*BenchmarkApi* | [**benchmark_benchmark_id_delete**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_delete) | **DELETE** /benchmark/{benchmarkId} | Deletes a single benchmark.
*BenchmarkApi* | [**benchmark_benchmark_id_fork_post**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_fork_post) | **POST** /benchmark/{benchmarkId}/fork | Creates a copy of a public benchmark and all of its related entities
*BenchmarkApi* | [**benchmark_benchmark_id_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_get) | **GET** /benchmark/{benchmarkId} | Returns a single benchmark by its ID.
*BenchmarkApi* | [**benchmark_benchmark_id_leaderboards_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_leaderboards_get) | **GET** /benchmark/{benchmarkId}/leaderboards | Queries all leaderboards for the current user&#39;s benchmarks.
*BenchmarkApi* | [**benchmark_benchmark_id_participants_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_participants_get) | **GET** /benchmark/{benchmarkId}/participants | Query all participants within a benchmark
*BenchmarkApi* | [**benchmark_benchmark_id_participants_post**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_participants_post) | **POST** /benchmark/{benchmarkId}/participants | Creates a participant in a benchmark.
*BenchmarkApi* | [**benchmark_benchmark_id_patch**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_patch) | **PATCH** /benchmark/{benchmarkId} | Updates a benchmark using patch semantics.
*BenchmarkApi* | [**benchmark_benchmark_id_prompt_post**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_prompt_post) | **POST** /benchmark/{benchmarkId}/prompt | Adds a new prompt to a benchmark.
*BenchmarkApi* | [**benchmark_benchmark_id_prompts_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_prompts_get) | **GET** /benchmark/{benchmarkId}/prompts | Returns the paged prompts of a benchmark by its ID.
*BenchmarkApi* | [**benchmark_benchmark_id_samples_identifier_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_samples_identifier_get) | **GET** /benchmark/{benchmarkId}/samples/{identifier} | Returns the paged prompts of a benchmark by its ID.
*BenchmarkApi* | [**benchmark_benchmark_id_standings_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_standings_get) | **GET** /benchmark/{benchmarkId}/standings | Queries all the standings for a benchmark by its ID.
*BenchmarkApi* | [**benchmark_benchmark_id_tags_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_benchmark_id_tags_get) | **GET** /benchmark/{benchmarkId}/tags | Query all tags within a benchmark
*BenchmarkApi* | [**benchmark_post**](rapidata/api_client/docs/BenchmarkApi.md#benchmark_post) | **POST** /benchmark | Creates a benchmark
*BenchmarkApi* | [**benchmarks_get**](rapidata/api_client/docs/BenchmarkApi.md#benchmarks_get) | **GET** /benchmarks | Queries all benchmarks of the user.
*CampaignApi* | [**campaign_boost_put**](rapidata/api_client/docs/CampaignApi.md#campaign_boost_put) | **PUT** /campaign/boost | Updates the boost with manual boosts.
*CampaignApi* | [**campaign_boost_status_get**](rapidata/api_client/docs/CampaignApi.md#campaign_boost_status_get) | **GET** /campaign/boost/status | Gets the status of the boost.
*CampaignApi* | [**campaign_campaign_id_patch**](rapidata/api_client/docs/CampaignApi.md#campaign_campaign_id_patch) | **PATCH** /campaign/{campaignId} | Updates a campaign.
*CampaignApi* | [**campaign_campaign_id_pause_post**](rapidata/api_client/docs/CampaignApi.md#campaign_campaign_id_pause_post) | **POST** /campaign/{campaignId}/pause | Pauses a campaign.
*CampaignApi* | [**campaign_campaign_id_resume_post**](rapidata/api_client/docs/CampaignApi.md#campaign_campaign_id_resume_post) | **POST** /campaign/{campaignId}/resume | Resumes a campaign.
*CampaignApi* | [**campaign_monitor_get**](rapidata/api_client/docs/CampaignApi.md#campaign_monitor_get) | **GET** /campaign/monitor | The monitor endpoint is used to monitor the health of the service
*CampaignApi* | [**campaigns_get**](rapidata/api_client/docs/CampaignApi.md#campaigns_get) | **GET** /campaigns | Queries orders based on a filter, page, and sort criteria.
*ClientApi* | [**client_client_id_delete**](rapidata/api_client/docs/ClientApi.md#client_client_id_delete) | **DELETE** /client/{clientId} | Deletes a customers&#39; client.
*ClientApi* | [**client_client_id_get**](rapidata/api_client/docs/ClientApi.md#client_client_id_get) | **GET** /client/{clientId} | Gets a specific client by its ID.
*ClientApi* | [**client_post**](rapidata/api_client/docs/ClientApi.md#client_post) | **POST** /client | Creates a new client for the current customer.
*ClientApi* | [**client_register_post**](rapidata/api_client/docs/ClientApi.md#client_register_post) | **POST** /client/register | Registers a new client dynamically.
*ClientApi* | [**clients_get**](rapidata/api_client/docs/ClientApi.md#clients_get) | **GET** /clients | Queries the clients for the current customer.
*CompareWorkflowApi* | [**workflow_compare_workflow_id_results_get**](rapidata/api_client/docs/CompareWorkflowApi.md#workflow_compare_workflow_id_results_get) | **GET** /workflow/compare/{workflowId}/results | Get the result overview for a compare workflow.
*CustomerRapidApi* | [**rapid_correlation_id_validation_potential_get**](rapidata/api_client/docs/CustomerRapidApi.md#rapid_correlation_id_validation_potential_get) | **GET** /rapid/{correlationId}/validation-potential | Queries rapids that are potentially eligible for validation set creation.
*CustomerRapidApi* | [**rapid_demographic_post**](rapidata/api_client/docs/CustomerRapidApi.md#rapid_demographic_post) | **POST** /rapid/demographic | Creates a new Demographic Rapid with JSON body.
*CustomerRapidApi* | [**rapid_global_responses_get**](rapidata/api_client/docs/CustomerRapidApi.md#rapid_global_responses_get) | **GET** /rapid/global-responses | A public endpoint to query the most recent responses globally
*CustomerRapidApi* | [**rapid_rapid_id_delete**](rapidata/api_client/docs/CustomerRapidApi.md#rapid_rapid_id_delete) | **DELETE** /rapid/{rapidId} | Deletes a rapid.
*CustomerRapidApi* | [**rapid_rapid_id_responses_get**](rapidata/api_client/docs/CustomerRapidApi.md#rapid_rapid_id_responses_get) | **GET** /rapid/{rapidId}/responses | Gets all responses for a given rapid.
*CustomerRapidApi* | [**rapid_rapid_id_unflag_post**](rapidata/api_client/docs/CustomerRapidApi.md#rapid_rapid_id_unflag_post) | **POST** /rapid/{rapidId}/unflag | Unflags a flagged rapid. This will add the rapid back to the active labeling pool and prevent it from being flagged again.
*CustomerRapidApi* | [**rapid_validation_rapid_id_patch**](rapidata/api_client/docs/CustomerRapidApi.md#rapid_validation_rapid_id_patch) | **PATCH** /rapid/validation/{rapidId} | Updates the validation information of a Rapid.
*CustomerRapidApi* | [**rapids_flagged_get**](rapidata/api_client/docs/CustomerRapidApi.md#rapids_flagged_get) | **GET** /rapids/flagged | Allows querying all rapids that have been flagged.
*DatapointApi* | [**datapoint_datapoint_id_delete**](rapidata/api_client/docs/DatapointApi.md#datapoint_datapoint_id_delete) | **DELETE** /datapoint/{datapointId} | Deletes a datapoint by its id.
*DatapointApi* | [**datapoint_datapoint_id_get**](rapidata/api_client/docs/DatapointApi.md#datapoint_datapoint_id_get) | **GET** /datapoint/{datapointId} | Gets a datapoint by its id.
*DatasetApi* | [**dataset_dataset_id_datapoint_post**](rapidata/api_client/docs/DatasetApi.md#dataset_dataset_id_datapoint_post) | **POST** /dataset/{datasetId}/datapoint | Creates a datapoint with JSON body.
*DatasetApi* | [**dataset_dataset_id_datapoints_failed_get**](rapidata/api_client/docs/DatasetApi.md#dataset_dataset_id_datapoints_failed_get) | **GET** /dataset/{datasetId}/datapoints/failed | Gets a list of all datapoints that failed to upload.
*DatasetApi* | [**dataset_dataset_id_datapoints_get**](rapidata/api_client/docs/DatasetApi.md#dataset_dataset_id_datapoints_get) | **GET** /dataset/{datasetId}/datapoints | Gets all datapoints of a dataset.
*DatasetApi* | [**dataset_dataset_id_get**](rapidata/api_client/docs/DatasetApi.md#dataset_dataset_id_get) | **GET** /dataset/{datasetId} | Gets a dataset by its id.
*DatasetApi* | [**dataset_dataset_id_name_patch**](rapidata/api_client/docs/DatasetApi.md#dataset_dataset_id_name_patch) | **PATCH** /dataset/{datasetId}/name | Updates the name of a dataset.
*DatasetApi* | [**dataset_dataset_id_progress_get**](rapidata/api_client/docs/DatasetApi.md#dataset_dataset_id_progress_get) | **GET** /dataset/{datasetId}/progress | Gets the upload progress of a dataset.
*EvaluationWorkflowApi* | [**workflow_evaluation_workflow_id_results_get**](rapidata/api_client/docs/EvaluationWorkflowApi.md#workflow_evaluation_workflow_id_results_get) | **GET** /workflow/evaluation/{workflowId}/results | Get the results for an evaluation workflow.
*FeedbackApi* | [**feedback_post**](rapidata/api_client/docs/FeedbackApi.md#feedback_post) | **POST** /feedback | Submits feedback about our services.
*GroupedRankingWorkflowApi* | [**workflow_grouped_ranking_workflow_id_results_get**](rapidata/api_client/docs/GroupedRankingWorkflowApi.md#workflow_grouped_ranking_workflow_id_results_get) | **GET** /workflow/grouped-ranking/{workflowId}/results | Get the result overview for a multi compare workflow.
*IdentityApi* | [**identity_bridge_token_get**](rapidata/api_client/docs/IdentityApi.md#identity_bridge_token_get) | **GET** /identity/bridge-token | Tries to read the bridge token keys for a given read key. The read key is used to retrieve the authentication result written by the write key.
*IdentityApi* | [**identity_bridge_token_post**](rapidata/api_client/docs/IdentityApi.md#identity_bridge_token_post) | **POST** /identity/bridge-token | Creates a pair of read and write keys for a client. The write key is used to store the authentication result. The read key is used to retrieve the authentication result.
*IdentityApi* | [**identity_google_one_tap_post**](rapidata/api_client/docs/IdentityApi.md#identity_google_one_tap_post) | **POST** /identity/google-one-tap | Signs in a user using a token received from Google One Tap.
*IdentityApi* | [**identity_referrer_post**](rapidata/api_client/docs/IdentityApi.md#identity_referrer_post) | **POST** /identity/referrer | Sets the referrer for the current customer.
*LeaderboardApi* | [**benchmark_standing_leaderboard_id_participant_id_get**](rapidata/api_client/docs/LeaderboardApi.md#benchmark_standing_leaderboard_id_participant_id_get) | **GET** /benchmark/standing/{leaderboardId}/{participantId} | Gets a standing by leaderboardId and participantId.
*LeaderboardApi* | [**leaderboard_leaderboard_id_boost_post**](rapidata/api_client/docs/LeaderboardApi.md#leaderboard_leaderboard_id_boost_post) | **POST** /leaderboard/{leaderboardId}/boost | Boosts a subset of participants within a leaderboard.
*LeaderboardApi* | [**leaderboard_leaderboard_id_delete**](rapidata/api_client/docs/LeaderboardApi.md#leaderboard_leaderboard_id_delete) | **DELETE** /leaderboard/{leaderboardId} | Deletes a leaderboard by its ID.
*LeaderboardApi* | [**leaderboard_leaderboard_id_get**](rapidata/api_client/docs/LeaderboardApi.md#leaderboard_leaderboard_id_get) | **GET** /leaderboard/{leaderboardId} | Gets a leaderboard by its ID.
*LeaderboardApi* | [**leaderboard_leaderboard_id_patch**](rapidata/api_client/docs/LeaderboardApi.md#leaderboard_leaderboard_id_patch) | **PATCH** /leaderboard/{leaderboardId} | Updates the response config of a leaderboard.
*LeaderboardApi* | [**leaderboard_leaderboard_id_runs_get**](rapidata/api_client/docs/LeaderboardApi.md#leaderboard_leaderboard_id_runs_get) | **GET** /leaderboard/{leaderboardId}/runs | Gets the runs related to a leaderboard
*LeaderboardApi* | [**leaderboard_leaderboard_id_standings_get**](rapidata/api_client/docs/LeaderboardApi.md#leaderboard_leaderboard_id_standings_get) | **GET** /leaderboard/{leaderboardId}/standings | queries all the participants connected to leaderboard by its ID.
*LeaderboardApi* | [**leaderboard_post**](rapidata/api_client/docs/LeaderboardApi.md#leaderboard_post) | **POST** /leaderboard | Creates a new leaderboard with the specified name and criteria.
*LeaderboardApi* | [**leaderboards_get**](rapidata/api_client/docs/LeaderboardApi.md#leaderboards_get) | **GET** /leaderboards | Queries all leaderboards for a specific benchmark.
*NewsletterApi* | [**newsletter_subscribe_post**](rapidata/api_client/docs/NewsletterApi.md#newsletter_subscribe_post) | **POST** /newsletter/subscribe | Signs a user up to the newsletter.
*NewsletterApi* | [**newsletter_unsubscribe_post**](rapidata/api_client/docs/NewsletterApi.md#newsletter_unsubscribe_post) | **POST** /newsletter/unsubscribe | Unsubscribes a user from the newsletter.
*OrderApi* | [**order_complex_post**](rapidata/api_client/docs/OrderApi.md#order_complex_post) | **POST** /order/complex | Creates a new order with a custom pipeline.
*OrderApi* | [**order_order_id_approve_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_approve_post) | **POST** /order/{orderId}/approve | Approves an order that has been submitted for manual approval.
*OrderApi* | [**order_order_id_clone_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_clone_post) | **POST** /order/{orderId}/clone | Clones an existing order.
*OrderApi* | [**order_order_id_delete**](rapidata/api_client/docs/OrderApi.md#order_order_id_delete) | **DELETE** /order/{orderId} | Deletes an order.
*OrderApi* | [**order_order_id_demo_patch**](rapidata/api_client/docs/OrderApi.md#order_order_id_demo_patch) | **PATCH** /order/{orderId}/demo | Updates whether an order is a demo or not.
*OrderApi* | [**order_order_id_download_results_get**](rapidata/api_client/docs/OrderApi.md#order_order_id_download_results_get) | **GET** /order/{orderId}/download-results | Aggregates the results of an order and returns it as a file attachment.
*OrderApi* | [**order_order_id_get**](rapidata/api_client/docs/OrderApi.md#order_order_id_get) | **GET** /order/{orderId} | Retrieves an order by its id.
*OrderApi* | [**order_order_id_name_patch**](rapidata/api_client/docs/OrderApi.md#order_order_id_name_patch) | **PATCH** /order/{orderId}/name | Updates the name of an order.
*OrderApi* | [**order_order_id_pause_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_pause_post) | **POST** /order/{orderId}/pause | Pauses an order that is processing. Meaning all campaigns in the order will be paused.
*OrderApi* | [**order_order_id_preview_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_preview_post) | **POST** /order/{orderId}/preview | Puts the order into preview mode, where one can inspect what our labelers receive.
*OrderApi* | [**order_order_id_results_get**](rapidata/api_client/docs/OrderApi.md#order_order_id_results_get) | **GET** /order/{orderId}/results | Aggregates the results of an order and returns the result as a json body.
*OrderApi* | [**order_order_id_resume_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_resume_post) | **POST** /order/{orderId}/resume | Resumes a paused order. Meaning all campaigns in the order will be resumed.
*OrderApi* | [**order_order_id_retry_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_retry_post) | **POST** /order/{orderId}/retry | Retries a failed order.
*OrderApi* | [**order_order_id_share_patch**](rapidata/api_client/docs/OrderApi.md#order_order_id_share_patch) | **PATCH** /order/{orderId}/share | Updates whether an order is public or not.
*OrderApi* | [**order_order_id_submit_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_submit_post) | **POST** /order/{orderId}/submit | Submits an order for approval.
*OrderApi* | [**order_order_id_unlock_post**](rapidata/api_client/docs/OrderApi.md#order_order_id_unlock_post) | **POST** /order/{orderId}/unlock | Unlocks a newly cloned order.
*OrderApi* | [**order_post**](rapidata/api_client/docs/OrderApi.md#order_post) | **POST** /order | Used to create a new order.
*OrderApi* | [**order_unsupported_post**](rapidata/api_client/docs/OrderApi.md#order_unsupported_post) | **POST** /order/unsupported | Notifies the admins that a user wants to create an order with an unsupported label type or data type.
*OrderApi* | [**orders_aggregated_overview_get**](rapidata/api_client/docs/OrderApi.md#orders_aggregated_overview_get) | **GET** /orders/aggregated-overview | Retrieves the orders aggregated by customer, with total amounts and most recent order informations.
*OrderApi* | [**orders_get**](rapidata/api_client/docs/OrderApi.md#orders_get) | **GET** /orders | Queries orders based on a filter, page, and sort criteria.
*OrderApi* | [**orders_public_get**](rapidata/api_client/docs/OrderApi.md#orders_public_get) | **GET** /orders/public | Retrieves orders that are public and can be cloned by any user.
*ParticipantApi* | [**participant_participant_id_delete**](rapidata/api_client/docs/ParticipantApi.md#participant_participant_id_delete) | **DELETE** /participant/{participantId} | Deletes a participant on a benchmark.
*ParticipantApi* | [**participant_participant_id_disable_post**](rapidata/api_client/docs/ParticipantApi.md#participant_participant_id_disable_post) | **POST** /participant/{participantId}/disable | This endpoint disables a participant in a benchmark. this means that the participant will no longer actively be matched up against other participants and not collect further results. It will still be visible in the leaderboard.
*ParticipantApi* | [**participant_participant_id_get**](rapidata/api_client/docs/ParticipantApi.md#participant_participant_id_get) | **GET** /participant/{participantId} | Gets a participant by it&#39;s Id.
*ParticipantApi* | [**participant_participant_id_patch**](rapidata/api_client/docs/ParticipantApi.md#participant_participant_id_patch) | **PATCH** /participant/{participantId} | Updates a participant using patch semantics.
*ParticipantApi* | [**participant_participant_id_sample_post**](rapidata/api_client/docs/ParticipantApi.md#participant_participant_id_sample_post) | **POST** /participant/{participantId}/sample | Adds a sample to a participant.
*ParticipantApi* | [**participant_participant_id_samples_get**](rapidata/api_client/docs/ParticipantApi.md#participant_participant_id_samples_get) | **GET** /participant/{participantId}/samples | Queries all samples of a participant.
*ParticipantApi* | [**participant_sample_sample_id_delete**](rapidata/api_client/docs/ParticipantApi.md#participant_sample_sample_id_delete) | **DELETE** /participant-sample/{sampleId} | Deletes a sample.
*ParticipantApi* | [**participants_participant_id_submit_post**](rapidata/api_client/docs/ParticipantApi.md#participants_participant_id_submit_post) | **POST** /participants/{participantId}/submit | Submits a participant to a benchmark.
*PipelineApi* | [**pipeline_pipeline_id_get**](rapidata/api_client/docs/PipelineApi.md#pipeline_pipeline_id_get) | **GET** /pipeline/{pipelineId} | Gets a pipeline by its id.
*PipelineApi* | [**pipeline_pipeline_id_preliminary_download_post**](rapidata/api_client/docs/PipelineApi.md#pipeline_pipeline_id_preliminary_download_post) | **POST** /pipeline/{pipelineId}/preliminary-download | Initiates a preliminary download of the pipeline.
*PipelineApi* | [**pipeline_preliminary_download_preliminary_download_id_get**](rapidata/api_client/docs/PipelineApi.md#pipeline_preliminary_download_preliminary_download_id_get) | **GET** /pipeline/preliminary-download/{preliminaryDownloadId} | Gets the preliminary download.
*PromptApi* | [**benchmark_prompt_prompt_id_tags_put**](rapidata/api_client/docs/PromptApi.md#benchmark_prompt_prompt_id_tags_put) | **PUT** /benchmark-prompt/{promptId}/tags | Updates the tags associated with a prompt.
*RapidataIdentityAPIApi* | [**root_get**](rapidata/api_client/docs/RapidataIdentityAPIApi.md#root_get) | **GET** / | 
*SampleApi* | [**benchmark_sample_sample_id_get**](rapidata/api_client/docs/SampleApi.md#benchmark_sample_sample_id_get) | **GET** /benchmark-sample/{sampleId} | Gets a sample by its Id.
*SimpleWorkflowApi* | [**workflow_simple_workflow_id_results_get**](rapidata/api_client/docs/SimpleWorkflowApi.md#workflow_simple_workflow_id_results_get) | **GET** /workflow/simple/{workflowId}/results | Get the result overview for a simple workflow.
*SurveyApi* | [**identity_survey_post**](rapidata/api_client/docs/SurveyApi.md#identity_survey_post) | **POST** /identity/survey | Sends a survey.
*UserInfoApi* | [**connect_userinfo_get**](rapidata/api_client/docs/UserInfoApi.md#connect_userinfo_get) | **GET** /connect/userinfo | Retrieves information about the authenticated user.
*UserRapidApi* | [**rapid_rapid_bag_is_valid_get**](rapidata/api_client/docs/UserRapidApi.md#rapid_rapid_bag_is_valid_get) | **GET** /rapid/rapid-bag/is-valid | Validates that the rapids associated with the current user are active.
*UserRapidApi* | [**rapid_rapid_id_report_post**](rapidata/api_client/docs/UserRapidApi.md#rapid_rapid_id_report_post) | **POST** /rapid/{rapidId}/report | Used to report an issue with a rapid.
*UserRapidApi* | [**rapid_report_report_id_get**](rapidata/api_client/docs/UserRapidApi.md#rapid_report_report_id_get) | **GET** /rapid/report/{reportId} | Inspects a report&#39;s dump. Can be used to restore zustand state or anything alike.
*UserRapidApi* | [**rapid_response_post**](rapidata/api_client/docs/UserRapidApi.md#rapid_response_post) | **POST** /rapid/response | Submits a response for a Rapid.
*UserRapidApi* | [**rapid_skip_post**](rapidata/api_client/docs/UserRapidApi.md#rapid_skip_post) | **POST** /rapid/skip | Skips a Rapid for the user.
*ValidationSetApi* | [**validation_set_post**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_post) | **POST** /validation-set | Creates a new empty validation set.
*ValidationSetApi* | [**validation_set_recommended_get**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_recommended_get) | **GET** /validation-set/recommended | Gets a validation set that is available to the user and best matches the provided parameters.
*ValidationSetApi* | [**validation_set_validation_set_id_delete**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_delete) | **DELETE** /validation-set/{validationSetId} | Gets a validation set by the id.
*ValidationSetApi* | [**validation_set_validation_set_id_export_get**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_export_get) | **GET** /validation-set/{validationSetId}/export | Exports all rapids of a validation-set to a file.
*ValidationSetApi* | [**validation_set_validation_set_id_get**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_get) | **GET** /validation-set/{validationSetId} | Gets a validation set by the id.
*ValidationSetApi* | [**validation_set_validation_set_id_patch**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_patch) | **PATCH** /validation-set/{validationSetId} | Updates different characteristics of a validation set.
*ValidationSetApi* | [**validation_set_validation_set_id_rapid_post**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_rapid_post) | **POST** /validation-set/{validationSetId}/rapid | Adds a new validation rapid to the validation set using JSON body.
*ValidationSetApi* | [**validation_set_validation_set_id_rapids_get**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_rapids_get) | **GET** /validation-set/{validationSetId}/rapids | Queries the validation rapids for a specific validation set.
*ValidationSetApi* | [**validation_set_validation_set_id_update_labeling_hints_post**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_update_labeling_hints_post) | **POST** /validation-set/{validationSetId}/update-labeling-hints | Refreshes the labeling hints for a validation set.
*ValidationSetApi* | [**validation_set_validation_set_id_visibility_patch**](rapidata/api_client/docs/ValidationSetApi.md#validation_set_validation_set_id_visibility_patch) | **PATCH** /validation-set/{validationSetId}/visibility | Updates the visibility of a validation set.
*ValidationSetApi* | [**validation_sets_available_get**](rapidata/api_client/docs/ValidationSetApi.md#validation_sets_available_get) | **GET** /validation-sets/available | Gets the available validation sets for the current user.
*ValidationSetApi* | [**validation_sets_get**](rapidata/api_client/docs/ValidationSetApi.md#validation_sets_get) | **GET** /validation-sets | Queries available validation sets based on the provided filter, paging and sorting criteria.
*WorkflowApi* | [**workflow_delete_delete**](rapidata/api_client/docs/WorkflowApi.md#workflow_delete_delete) | **DELETE** /workflow/delete | Deletes a workflow.
*WorkflowApi* | [**workflow_workflow_id_compare_ab_summary_get**](rapidata/api_client/docs/WorkflowApi.md#workflow_workflow_id_compare_ab_summary_get) | **GET** /workflow/{workflowId}/compare-ab-summary | Calculates a summary of the results for a simple compare workflow. The summary includes the number of times an asset at each index was the winner.
*WorkflowApi* | [**workflow_workflow_id_get**](rapidata/api_client/docs/WorkflowApi.md#workflow_workflow_id_get) | **GET** /workflow/{workflowId} | Get a workflow by its ID.
*WorkflowApi* | [**workflow_workflow_id_progress_get**](rapidata/api_client/docs/WorkflowApi.md#workflow_workflow_id_progress_get) | **GET** /workflow/{workflowId}/progress | Get the progress of a workflow.
*WorkflowApi* | [**workflow_workflow_id_responses_get**](rapidata/api_client/docs/WorkflowApi.md#workflow_workflow_id_responses_get) | **GET** /workflow/{workflowId}/responses | Gets the limit most recent or oldest responses for a workflow. The responses are not guaranteed to be of any specific rapid. Instead, this endpoint returns all responses to any rapid in the workflow.
*WorkflowApi* | [**workflows_get**](rapidata/api_client/docs/WorkflowApi.md#workflows_get) | **GET** /workflows | Queries workflows based on the provided filter, page, and sort criteria.


## Documentation For Models

 - [AbTestSelection](rapidata/api_client/docs/AbTestSelection.md)
 - [AbTestSelectionAInner](rapidata/api_client/docs/AbTestSelectionAInner.md)
 - [AddUserResponseResult](rapidata/api_client/docs/AddUserResponseResult.md)
 - [AddValidationRapidModel](rapidata/api_client/docs/AddValidationRapidModel.md)
 - [AddValidationRapidModelAsset](rapidata/api_client/docs/AddValidationRapidModelAsset.md)
 - [AddValidationRapidModelContextAsset](rapidata/api_client/docs/AddValidationRapidModelContextAsset.md)
 - [AddValidationRapidModelPayload](rapidata/api_client/docs/AddValidationRapidModelPayload.md)
 - [AddValidationRapidModelTruth](rapidata/api_client/docs/AddValidationRapidModelTruth.md)
 - [AddValidationRapidNewModel](rapidata/api_client/docs/AddValidationRapidNewModel.md)
 - [AgeUserFilterModel](rapidata/api_client/docs/AgeUserFilterModel.md)
 - [AgeUserFilterModelAgeGroup](rapidata/api_client/docs/AgeUserFilterModelAgeGroup.md)
 - [AggregatedOrdersModel](rapidata/api_client/docs/AggregatedOrdersModel.md)
 - [AggregatorType](rapidata/api_client/docs/AggregatorType.md)
 - [AndFilter](rapidata/api_client/docs/AndFilter.md)
 - [AndFilterFiltersInner](rapidata/api_client/docs/AndFilterFiltersInner.md)
 - [AndUserFilterModel](rapidata/api_client/docs/AndUserFilterModel.md)
 - [AndUserFilterModelFiltersInner](rapidata/api_client/docs/AndUserFilterModelFiltersInner.md)
 - [AreRapidsActiveResult](rapidata/api_client/docs/AreRapidsActiveResult.md)
 - [AttachCategoryRapidBlueprint](rapidata/api_client/docs/AttachCategoryRapidBlueprint.md)
 - [AttachCategoryRapidBlueprintCategory](rapidata/api_client/docs/AttachCategoryRapidBlueprintCategory.md)
 - [AttachCategoryResult](rapidata/api_client/docs/AttachCategoryResult.md)
 - [AttachCategoryTruth](rapidata/api_client/docs/AttachCategoryTruth.md)
 - [BenchmarkQueryResult](rapidata/api_client/docs/BenchmarkQueryResult.md)
 - [BoostLeaderboardModel](rapidata/api_client/docs/BoostLeaderboardModel.md)
 - [BoostQueryResult](rapidata/api_client/docs/BoostQueryResult.md)
 - [BoostQueryResultBoostMode](rapidata/api_client/docs/BoostQueryResultBoostMode.md)
 - [BoostQueryResultBoostStatus](rapidata/api_client/docs/BoostQueryResultBoostStatus.md)
 - [BoostingProfile](rapidata/api_client/docs/BoostingProfile.md)
 - [BoundingBoxPayload](rapidata/api_client/docs/BoundingBoxPayload.md)
 - [BoundingBoxRapidBlueprint](rapidata/api_client/docs/BoundingBoxRapidBlueprint.md)
 - [BoundingBoxResult](rapidata/api_client/docs/BoundingBoxResult.md)
 - [BoundingBoxTruth](rapidata/api_client/docs/BoundingBoxTruth.md)
 - [BoxShape](rapidata/api_client/docs/BoxShape.md)
 - [CampaignArtifactModel](rapidata/api_client/docs/CampaignArtifactModel.md)
 - [CampaignFilter](rapidata/api_client/docs/CampaignFilter.md)
 - [CampaignQueryResult](rapidata/api_client/docs/CampaignQueryResult.md)
 - [CampaignStatus](rapidata/api_client/docs/CampaignStatus.md)
 - [CampaignUserFilterModel](rapidata/api_client/docs/CampaignUserFilterModel.md)
 - [CappedSelection](rapidata/api_client/docs/CappedSelection.md)
 - [ChangeBoostModel](rapidata/api_client/docs/ChangeBoostModel.md)
 - [ClassificationMetadata](rapidata/api_client/docs/ClassificationMetadata.md)
 - [ClassificationMetadataModel](rapidata/api_client/docs/ClassificationMetadataModel.md)
 - [ClassifyPayload](rapidata/api_client/docs/ClassifyPayload.md)
 - [ClassifyPayloadCategory](rapidata/api_client/docs/ClassifyPayloadCategory.md)
 - [ClientModel](rapidata/api_client/docs/ClientModel.md)
 - [ClientsQueryResult](rapidata/api_client/docs/ClientsQueryResult.md)
 - [ClientsQueryResultPagedResult](rapidata/api_client/docs/ClientsQueryResultPagedResult.md)
 - [CloneDatasetModel](rapidata/api_client/docs/CloneDatasetModel.md)
 - [CloneOrderModel](rapidata/api_client/docs/CloneOrderModel.md)
 - [CloneOrderResult](rapidata/api_client/docs/CloneOrderResult.md)
 - [ComparePayload](rapidata/api_client/docs/ComparePayload.md)
 - [CompareRapidBlueprint](rapidata/api_client/docs/CompareRapidBlueprint.md)
 - [CompareResult](rapidata/api_client/docs/CompareResult.md)
 - [CompareTruth](rapidata/api_client/docs/CompareTruth.md)
 - [CompareWorkflowConfig](rapidata/api_client/docs/CompareWorkflowConfig.md)
 - [CompareWorkflowConfigContextAsset](rapidata/api_client/docs/CompareWorkflowConfigContextAsset.md)
 - [CompareWorkflowConfigPairMakerConfig](rapidata/api_client/docs/CompareWorkflowConfigPairMakerConfig.md)
 - [CompareWorkflowModel](rapidata/api_client/docs/CompareWorkflowModel.md)
 - [CompareWorkflowModel1](rapidata/api_client/docs/CompareWorkflowModel1.md)
 - [CompareWorkflowModel1PairMakerInformation](rapidata/api_client/docs/CompareWorkflowModel1PairMakerInformation.md)
 - [CompareWorkflowModel1Referee](rapidata/api_client/docs/CompareWorkflowModel1Referee.md)
 - [CompareWorkflowModelContextAsset](rapidata/api_client/docs/CompareWorkflowModelContextAsset.md)
 - [CompareWorkflowModelMetadataInner](rapidata/api_client/docs/CompareWorkflowModelMetadataInner.md)
 - [CompareWorkflowModelPairMakerConfig](rapidata/api_client/docs/CompareWorkflowModelPairMakerConfig.md)
 - [ComparisonOperator](rapidata/api_client/docs/ComparisonOperator.md)
 - [ConditionalValidationSelection](rapidata/api_client/docs/ConditionalValidationSelection.md)
 - [ConditionalValidationSelectionValidationChance](rapidata/api_client/docs/ConditionalValidationSelectionValidationChance.md)
 - [ConfidenceInterval](rapidata/api_client/docs/ConfidenceInterval.md)
 - [CountMetadata](rapidata/api_client/docs/CountMetadata.md)
 - [CountMetadataModel](rapidata/api_client/docs/CountMetadataModel.md)
 - [CountryFilter](rapidata/api_client/docs/CountryFilter.md)
 - [CountryUserFilterModel](rapidata/api_client/docs/CountryUserFilterModel.md)
 - [CreateBenchmarkModel](rapidata/api_client/docs/CreateBenchmarkModel.md)
 - [CreateBenchmarkParticipantModel](rapidata/api_client/docs/CreateBenchmarkParticipantModel.md)
 - [CreateBenchmarkParticipantResult](rapidata/api_client/docs/CreateBenchmarkParticipantResult.md)
 - [CreateBenchmarkPromptResult](rapidata/api_client/docs/CreateBenchmarkPromptResult.md)
 - [CreateBenchmarkResult](rapidata/api_client/docs/CreateBenchmarkResult.md)
 - [CreateBridgeTokenResult](rapidata/api_client/docs/CreateBridgeTokenResult.md)
 - [CreateClientModel](rapidata/api_client/docs/CreateClientModel.md)
 - [CreateComplexOrderModel](rapidata/api_client/docs/CreateComplexOrderModel.md)
 - [CreateComplexOrderModelPipeline](rapidata/api_client/docs/CreateComplexOrderModelPipeline.md)
 - [CreateComplexOrderResult](rapidata/api_client/docs/CreateComplexOrderResult.md)
 - [CreateCustomerClientResult](rapidata/api_client/docs/CreateCustomerClientResult.md)
 - [CreateDatapointModel](rapidata/api_client/docs/CreateDatapointModel.md)
 - [CreateDatapointModelAsset](rapidata/api_client/docs/CreateDatapointModelAsset.md)
 - [CreateDatapointModelContextAsset](rapidata/api_client/docs/CreateDatapointModelContextAsset.md)
 - [CreateDatapointModelMetadataInner](rapidata/api_client/docs/CreateDatapointModelMetadataInner.md)
 - [CreateDatapointResult](rapidata/api_client/docs/CreateDatapointResult.md)
 - [CreateDatasetArtifactModel](rapidata/api_client/docs/CreateDatasetArtifactModel.md)
 - [CreateDatasetArtifactModelDataset](rapidata/api_client/docs/CreateDatasetArtifactModelDataset.md)
 - [CreateDemographicRapidModel](rapidata/api_client/docs/CreateDemographicRapidModel.md)
 - [CreateDemographicRapidModelAsset](rapidata/api_client/docs/CreateDemographicRapidModelAsset.md)
 - [CreateDemographicRapidModelContextAsset](rapidata/api_client/docs/CreateDemographicRapidModelContextAsset.md)
 - [CreateEmptyValidationSetResult](rapidata/api_client/docs/CreateEmptyValidationSetResult.md)
 - [CreateLeaderboardModel](rapidata/api_client/docs/CreateLeaderboardModel.md)
 - [CreateLeaderboardResult](rapidata/api_client/docs/CreateLeaderboardResult.md)
 - [CreateOrderModel](rapidata/api_client/docs/CreateOrderModel.md)
 - [CreateOrderModelReferee](rapidata/api_client/docs/CreateOrderModelReferee.md)
 - [CreateOrderModelWorkflow](rapidata/api_client/docs/CreateOrderModelWorkflow.md)
 - [CreateOrderResult](rapidata/api_client/docs/CreateOrderResult.md)
 - [CreateRapidResult](rapidata/api_client/docs/CreateRapidResult.md)
 - [CreateSampleModel](rapidata/api_client/docs/CreateSampleModel.md)
 - [CreateSampleModelAsset](rapidata/api_client/docs/CreateSampleModelAsset.md)
 - [CreateSimplePipelineModel](rapidata/api_client/docs/CreateSimplePipelineModel.md)
 - [CreateSimplePipelineModelArtifactsInner](rapidata/api_client/docs/CreateSimplePipelineModelArtifactsInner.md)
 - [CreateSimplePipelineModelPipelineStepsInner](rapidata/api_client/docs/CreateSimplePipelineModelPipelineStepsInner.md)
 - [CreateUnsupportedOrderModel](rapidata/api_client/docs/CreateUnsupportedOrderModel.md)
 - [CreateValidationSetModel](rapidata/api_client/docs/CreateValidationSetModel.md)
 - [CustomUserFilterModel](rapidata/api_client/docs/CustomUserFilterModel.md)
 - [DatapointModel](rapidata/api_client/docs/DatapointModel.md)
 - [DatapointModelAsset](rapidata/api_client/docs/DatapointModelAsset.md)
 - [DatapointState](rapidata/api_client/docs/DatapointState.md)
 - [DatasetArtifactModel](rapidata/api_client/docs/DatasetArtifactModel.md)
 - [DatasetEvaluationStepModel](rapidata/api_client/docs/DatasetEvaluationStepModel.md)
 - [DemographicFilter](rapidata/api_client/docs/DemographicFilter.md)
 - [DemographicSelection](rapidata/api_client/docs/DemographicSelection.md)
 - [DynamicClientRegistrationRequest](rapidata/api_client/docs/DynamicClientRegistrationRequest.md)
 - [EarlyStoppingRefereeModel](rapidata/api_client/docs/EarlyStoppingRefereeModel.md)
 - [EffortCappedSelection](rapidata/api_client/docs/EffortCappedSelection.md)
 - [EloConfig](rapidata/api_client/docs/EloConfig.md)
 - [EloConfigModel](rapidata/api_client/docs/EloConfigModel.md)
 - [EmptyValidationTruth](rapidata/api_client/docs/EmptyValidationTruth.md)
 - [EvaluationWorkflowConfig](rapidata/api_client/docs/EvaluationWorkflowConfig.md)
 - [EvaluationWorkflowModel](rapidata/api_client/docs/EvaluationWorkflowModel.md)
 - [EvaluationWorkflowModel1](rapidata/api_client/docs/EvaluationWorkflowModel1.md)
 - [ExistingAssetInput](rapidata/api_client/docs/ExistingAssetInput.md)
 - [FeatureFlag](rapidata/api_client/docs/FeatureFlag.md)
 - [FeatureFlagModel](rapidata/api_client/docs/FeatureFlagModel.md)
 - [FeedbackModel](rapidata/api_client/docs/FeedbackModel.md)
 - [FileArtifactModel](rapidata/api_client/docs/FileArtifactModel.md)
 - [FileAsset](rapidata/api_client/docs/FileAsset.md)
 - [FileAssetMetadataValue](rapidata/api_client/docs/FileAssetMetadataValue.md)
 - [FileAssetModel](rapidata/api_client/docs/FileAssetModel.md)
 - [FileAssetModelMetadataValue](rapidata/api_client/docs/FileAssetModelMetadataValue.md)
 - [FileType](rapidata/api_client/docs/FileType.md)
 - [FileTypeMetadata](rapidata/api_client/docs/FileTypeMetadata.md)
 - [FileTypeMetadataModel](rapidata/api_client/docs/FileTypeMetadataModel.md)
 - [Filter](rapidata/api_client/docs/Filter.md)
 - [FilterOperator](rapidata/api_client/docs/FilterOperator.md)
 - [ForkBenchmarkResult](rapidata/api_client/docs/ForkBenchmarkResult.md)
 - [FreeTextPayload](rapidata/api_client/docs/FreeTextPayload.md)
 - [FreeTextRapidBlueprint](rapidata/api_client/docs/FreeTextRapidBlueprint.md)
 - [FreeTextResult](rapidata/api_client/docs/FreeTextResult.md)
 - [GenderUserFilterModel](rapidata/api_client/docs/GenderUserFilterModel.md)
 - [GenderUserFilterModelGender](rapidata/api_client/docs/GenderUserFilterModelGender.md)
 - [GetAvailableValidationSetsResult](rapidata/api_client/docs/GetAvailableValidationSetsResult.md)
 - [GetBenchmarkByIdResult](rapidata/api_client/docs/GetBenchmarkByIdResult.md)
 - [GetCompareAbSummaryResult](rapidata/api_client/docs/GetCompareAbSummaryResult.md)
 - [GetCompareWorkflowResultsModel](rapidata/api_client/docs/GetCompareWorkflowResultsModel.md)
 - [GetCompareWorkflowResultsResult](rapidata/api_client/docs/GetCompareWorkflowResultsResult.md)
 - [GetDatapointByIdResult](rapidata/api_client/docs/GetDatapointByIdResult.md)
 - [GetDatasetByIdResult](rapidata/api_client/docs/GetDatasetByIdResult.md)
 - [GetDatasetProgressResult](rapidata/api_client/docs/GetDatasetProgressResult.md)
 - [GetEvaluationWorkflowResultsModel](rapidata/api_client/docs/GetEvaluationWorkflowResultsModel.md)
 - [GetFailedDatapointsResult](rapidata/api_client/docs/GetFailedDatapointsResult.md)
 - [GetFailedDatapointsResultDatapoint](rapidata/api_client/docs/GetFailedDatapointsResultDatapoint.md)
 - [GetGroupedRankingWorkflowResultsModel](rapidata/api_client/docs/GetGroupedRankingWorkflowResultsModel.md)
 - [GetGroupedRankingWorkflowResultsResult](rapidata/api_client/docs/GetGroupedRankingWorkflowResultsResult.md)
 - [GetLeaderboardByIdResult](rapidata/api_client/docs/GetLeaderboardByIdResult.md)
 - [GetOrderByIdResult](rapidata/api_client/docs/GetOrderByIdResult.md)
 - [GetParticipantByIdResult](rapidata/api_client/docs/GetParticipantByIdResult.md)
 - [GetPipelineByIdResult](rapidata/api_client/docs/GetPipelineByIdResult.md)
 - [GetPipelineByIdResultArtifactsValue](rapidata/api_client/docs/GetPipelineByIdResultArtifactsValue.md)
 - [GetPublicOrdersResult](rapidata/api_client/docs/GetPublicOrdersResult.md)
 - [GetPublicResponsesResult](rapidata/api_client/docs/GetPublicResponsesResult.md)
 - [GetRapidResponsesResult](rapidata/api_client/docs/GetRapidResponsesResult.md)
 - [GetRecommendedValidationSetResult](rapidata/api_client/docs/GetRecommendedValidationSetResult.md)
 - [GetResponsesResult](rapidata/api_client/docs/GetResponsesResult.md)
 - [GetSampleByIdResult](rapidata/api_client/docs/GetSampleByIdResult.md)
 - [GetSimpleWorkflowResultsModel](rapidata/api_client/docs/GetSimpleWorkflowResultsModel.md)
 - [GetStandingByIdResult](rapidata/api_client/docs/GetStandingByIdResult.md)
 - [GetValidationRapidsResult](rapidata/api_client/docs/GetValidationRapidsResult.md)
 - [GetValidationRapidsResultAsset](rapidata/api_client/docs/GetValidationRapidsResultAsset.md)
 - [GetValidationRapidsResultPayload](rapidata/api_client/docs/GetValidationRapidsResultPayload.md)
 - [GetValidationRapidsResultTruth](rapidata/api_client/docs/GetValidationRapidsResultTruth.md)
 - [GetValidationSetByIdResult](rapidata/api_client/docs/GetValidationSetByIdResult.md)
 - [GetWorkflowByIdResult](rapidata/api_client/docs/GetWorkflowByIdResult.md)
 - [GetWorkflowByIdResultWorkflow](rapidata/api_client/docs/GetWorkflowByIdResultWorkflow.md)
 - [GetWorkflowProgressResult](rapidata/api_client/docs/GetWorkflowProgressResult.md)
 - [GetWorkflowResultsResult](rapidata/api_client/docs/GetWorkflowResultsResult.md)
 - [GoogleOneTapLoginModel](rapidata/api_client/docs/GoogleOneTapLoginModel.md)
 - [GroupedRankingWorkflowConfig](rapidata/api_client/docs/GroupedRankingWorkflowConfig.md)
 - [GroupedRankingWorkflowModel](rapidata/api_client/docs/GroupedRankingWorkflowModel.md)
 - [GroupedRankingWorkflowModel1](rapidata/api_client/docs/GroupedRankingWorkflowModel1.md)
 - [ImageDimensionMetadata](rapidata/api_client/docs/ImageDimensionMetadata.md)
 - [ImageDimensionMetadataModel](rapidata/api_client/docs/ImageDimensionMetadataModel.md)
 - [InquireFileMetadataResult](rapidata/api_client/docs/InquireFileMetadataResult.md)
 - [InspectReportResult](rapidata/api_client/docs/InspectReportResult.md)
 - [JsonWebKey](rapidata/api_client/docs/JsonWebKey.md)
 - [JsonWebKeySet](rapidata/api_client/docs/JsonWebKeySet.md)
 - [LabelingSelection](rapidata/api_client/docs/LabelingSelection.md)
 - [LanguageFilter](rapidata/api_client/docs/LanguageFilter.md)
 - [LanguageUserFilterModel](rapidata/api_client/docs/LanguageUserFilterModel.md)
 - [LeaderboardQueryResult](rapidata/api_client/docs/LeaderboardQueryResult.md)
 - [LinePayload](rapidata/api_client/docs/LinePayload.md)
 - [LineRapidBlueprint](rapidata/api_client/docs/LineRapidBlueprint.md)
 - [LineResult](rapidata/api_client/docs/LineResult.md)
 - [LineResultLine](rapidata/api_client/docs/LineResultLine.md)
 - [LineResultLinePoint](rapidata/api_client/docs/LineResultLinePoint.md)
 - [LineTruth](rapidata/api_client/docs/LineTruth.md)
 - [LocateBoxTruth](rapidata/api_client/docs/LocateBoxTruth.md)
 - [LocateCoordinate](rapidata/api_client/docs/LocateCoordinate.md)
 - [LocatePayload](rapidata/api_client/docs/LocatePayload.md)
 - [LocateRapidBlueprint](rapidata/api_client/docs/LocateRapidBlueprint.md)
 - [LocateResult](rapidata/api_client/docs/LocateResult.md)
 - [LocationMetadata](rapidata/api_client/docs/LocationMetadata.md)
 - [LocationMetadataModel](rapidata/api_client/docs/LocationMetadataModel.md)
 - [LogicOperator](rapidata/api_client/docs/LogicOperator.md)
 - [MetadataPromptAssetMetadataInput](rapidata/api_client/docs/MetadataPromptAssetMetadataInput.md)
 - [MetadataPromptMetadataInput](rapidata/api_client/docs/MetadataPromptMetadataInput.md)
 - [MetadataTranscriptionMetadataInput](rapidata/api_client/docs/MetadataTranscriptionMetadataInput.md)
 - [MultiAsset](rapidata/api_client/docs/MultiAsset.md)
 - [MultiAssetAssetsInner](rapidata/api_client/docs/MultiAssetAssetsInner.md)
 - [MultiAssetInput](rapidata/api_client/docs/MultiAssetInput.md)
 - [MultiAssetInputAssetsInner](rapidata/api_client/docs/MultiAssetInputAssetsInner.md)
 - [MultiAssetModel](rapidata/api_client/docs/MultiAssetModel.md)
 - [MultiCompareTruth](rapidata/api_client/docs/MultiCompareTruth.md)
 - [NaiveRefereeConfig](rapidata/api_client/docs/NaiveRefereeConfig.md)
 - [NaiveRefereeInfo](rapidata/api_client/docs/NaiveRefereeInfo.md)
 - [NaiveRefereeModel](rapidata/api_client/docs/NaiveRefereeModel.md)
 - [NamedClassification](rapidata/api_client/docs/NamedClassification.md)
 - [NamedEntityPayload](rapidata/api_client/docs/NamedEntityPayload.md)
 - [NamedEntityRapidBlueprint](rapidata/api_client/docs/NamedEntityRapidBlueprint.md)
 - [NamedEntityResult](rapidata/api_client/docs/NamedEntityResult.md)
 - [NamedEntityTruth](rapidata/api_client/docs/NamedEntityTruth.md)
 - [NeverEndingRefereeConfig](rapidata/api_client/docs/NeverEndingRefereeConfig.md)
 - [NeverEndingRefereeInfo](rapidata/api_client/docs/NeverEndingRefereeInfo.md)
 - [NewUserFilter](rapidata/api_client/docs/NewUserFilter.md)
 - [NewUserFilterModel](rapidata/api_client/docs/NewUserFilterModel.md)
 - [NewsletterModel](rapidata/api_client/docs/NewsletterModel.md)
 - [NotAvailableYetResult](rapidata/api_client/docs/NotAvailableYetResult.md)
 - [NotFilter](rapidata/api_client/docs/NotFilter.md)
 - [NotUserFilterModel](rapidata/api_client/docs/NotUserFilterModel.md)
 - [NullAsset](rapidata/api_client/docs/NullAsset.md)
 - [NullAssetModel](rapidata/api_client/docs/NullAssetModel.md)
 - [OnlinePairMakerConfig](rapidata/api_client/docs/OnlinePairMakerConfig.md)
 - [OnlinePairMakerConfigModel](rapidata/api_client/docs/OnlinePairMakerConfigModel.md)
 - [OnlinePairMakerInformation](rapidata/api_client/docs/OnlinePairMakerInformation.md)
 - [OrFilter](rapidata/api_client/docs/OrFilter.md)
 - [OrUserFilterModel](rapidata/api_client/docs/OrUserFilterModel.md)
 - [OrderModel](rapidata/api_client/docs/OrderModel.md)
 - [OrderState](rapidata/api_client/docs/OrderState.md)
 - [OriginalFilenameMetadata](rapidata/api_client/docs/OriginalFilenameMetadata.md)
 - [OriginalFilenameMetadataModel](rapidata/api_client/docs/OriginalFilenameMetadataModel.md)
 - [PageInfo](rapidata/api_client/docs/PageInfo.md)
 - [PagedResultAggregatedOrdersModel](rapidata/api_client/docs/PagedResultAggregatedOrdersModel.md)
 - [PagedResultBenchmarkQueryResult](rapidata/api_client/docs/PagedResultBenchmarkQueryResult.md)
 - [PagedResultCampaignQueryResult](rapidata/api_client/docs/PagedResultCampaignQueryResult.md)
 - [PagedResultDatapointModel](rapidata/api_client/docs/PagedResultDatapointModel.md)
 - [PagedResultGetCompareWorkflowResultsResult](rapidata/api_client/docs/PagedResultGetCompareWorkflowResultsResult.md)
 - [PagedResultGetGroupedRankingWorkflowResultsResult](rapidata/api_client/docs/PagedResultGetGroupedRankingWorkflowResultsResult.md)
 - [PagedResultGetValidationRapidsResult](rapidata/api_client/docs/PagedResultGetValidationRapidsResult.md)
 - [PagedResultGetWorkflowResultsResult](rapidata/api_client/docs/PagedResultGetWorkflowResultsResult.md)
 - [PagedResultIWorkflowModel](rapidata/api_client/docs/PagedResultIWorkflowModel.md)
 - [PagedResultLeaderboardQueryResult](rapidata/api_client/docs/PagedResultLeaderboardQueryResult.md)
 - [PagedResultOrderModel](rapidata/api_client/docs/PagedResultOrderModel.md)
 - [PagedResultParticipantByBenchmark](rapidata/api_client/docs/PagedResultParticipantByBenchmark.md)
 - [PagedResultPotentialValidationRapid](rapidata/api_client/docs/PagedResultPotentialValidationRapid.md)
 - [PagedResultPromptByBenchmarkResult](rapidata/api_client/docs/PagedResultPromptByBenchmarkResult.md)
 - [PagedResultRapidModel](rapidata/api_client/docs/PagedResultRapidModel.md)
 - [PagedResultRunsByLeaderboardResult](rapidata/api_client/docs/PagedResultRunsByLeaderboardResult.md)
 - [PagedResultSampleByIdentifier](rapidata/api_client/docs/PagedResultSampleByIdentifier.md)
 - [PagedResultSampleByParticipant](rapidata/api_client/docs/PagedResultSampleByParticipant.md)
 - [PagedResultStandingByLeaderboard](rapidata/api_client/docs/PagedResultStandingByLeaderboard.md)
 - [PagedResultValidationSetModel](rapidata/api_client/docs/PagedResultValidationSetModel.md)
 - [ParticipantByBenchmark](rapidata/api_client/docs/ParticipantByBenchmark.md)
 - [ParticipantStatus](rapidata/api_client/docs/ParticipantStatus.md)
 - [PolygonPayload](rapidata/api_client/docs/PolygonPayload.md)
 - [PolygonRapidBlueprint](rapidata/api_client/docs/PolygonRapidBlueprint.md)
 - [PolygonResult](rapidata/api_client/docs/PolygonResult.md)
 - [PolygonResultCoordinate](rapidata/api_client/docs/PolygonResultCoordinate.md)
 - [PolygonResultShape](rapidata/api_client/docs/PolygonResultShape.md)
 - [PolygonTruth](rapidata/api_client/docs/PolygonTruth.md)
 - [PotentialValidationRapid](rapidata/api_client/docs/PotentialValidationRapid.md)
 - [PotentialValidationRapidTruth](rapidata/api_client/docs/PotentialValidationRapidTruth.md)
 - [PreliminaryDownloadModel](rapidata/api_client/docs/PreliminaryDownloadModel.md)
 - [PreliminaryDownloadResult](rapidata/api_client/docs/PreliminaryDownloadResult.md)
 - [PreviewOrderModel](rapidata/api_client/docs/PreviewOrderModel.md)
 - [ProbabilisticAttachCategoryRefereeConfig](rapidata/api_client/docs/ProbabilisticAttachCategoryRefereeConfig.md)
 - [ProbabilisticAttachCategoryRefereeInfo](rapidata/api_client/docs/ProbabilisticAttachCategoryRefereeInfo.md)
 - [ProblemDetails](rapidata/api_client/docs/ProblemDetails.md)
 - [PromptAssetMetadataInput](rapidata/api_client/docs/PromptAssetMetadataInput.md)
 - [PromptAssetMetadataInputAsset](rapidata/api_client/docs/PromptAssetMetadataInputAsset.md)
 - [PromptByBenchmarkResult](rapidata/api_client/docs/PromptByBenchmarkResult.md)
 - [PromptMetadataInput](rapidata/api_client/docs/PromptMetadataInput.md)
 - [PublicOrderModel](rapidata/api_client/docs/PublicOrderModel.md)
 - [PublicRapidResponse](rapidata/api_client/docs/PublicRapidResponse.md)
 - [QueryModel](rapidata/api_client/docs/QueryModel.md)
 - [QueryValidationRapidEligibilityModelQueryValidationModel](rapidata/api_client/docs/QueryValidationRapidEligibilityModelQueryValidationModel.md)
 - [RapidIssue](rapidata/api_client/docs/RapidIssue.md)
 - [RapidModel](rapidata/api_client/docs/RapidModel.md)
 - [RapidModelReferee](rapidata/api_client/docs/RapidModelReferee.md)
 - [RapidResponse](rapidata/api_client/docs/RapidResponse.md)
 - [RapidResponseResult](rapidata/api_client/docs/RapidResponseResult.md)
 - [RapidResultModel](rapidata/api_client/docs/RapidResultModel.md)
 - [RapidResultModelResult](rapidata/api_client/docs/RapidResultModelResult.md)
 - [RapidSkippedModel](rapidata/api_client/docs/RapidSkippedModel.md)
 - [RapidState](rapidata/api_client/docs/RapidState.md)
 - [ReadBridgeTokenKeysResult](rapidata/api_client/docs/ReadBridgeTokenKeysResult.md)
 - [ReportModel](rapidata/api_client/docs/ReportModel.md)
 - [ResponseCountFilter](rapidata/api_client/docs/ResponseCountFilter.md)
 - [ResponseCountUserFilterModel](rapidata/api_client/docs/ResponseCountUserFilterModel.md)
 - [RetrievalMode](rapidata/api_client/docs/RetrievalMode.md)
 - [RootFilter](rapidata/api_client/docs/RootFilter.md)
 - [RunStatus](rapidata/api_client/docs/RunStatus.md)
 - [RunsByLeaderboardResult](rapidata/api_client/docs/RunsByLeaderboardResult.md)
 - [SampleByIdentifier](rapidata/api_client/docs/SampleByIdentifier.md)
 - [SampleByParticipant](rapidata/api_client/docs/SampleByParticipant.md)
 - [ScrubPayload](rapidata/api_client/docs/ScrubPayload.md)
 - [ScrubRange](rapidata/api_client/docs/ScrubRange.md)
 - [ScrubRapidBlueprint](rapidata/api_client/docs/ScrubRapidBlueprint.md)
 - [ScrubResult](rapidata/api_client/docs/ScrubResult.md)
 - [ScrubTruth](rapidata/api_client/docs/ScrubTruth.md)
 - [SendCompletionMailStepModel](rapidata/api_client/docs/SendCompletionMailStepModel.md)
 - [SendSurveyModel](rapidata/api_client/docs/SendSurveyModel.md)
 - [ShufflingSelection](rapidata/api_client/docs/ShufflingSelection.md)
 - [SimpleWorkflowConfig](rapidata/api_client/docs/SimpleWorkflowConfig.md)
 - [SimpleWorkflowModel](rapidata/api_client/docs/SimpleWorkflowModel.md)
 - [SimpleWorkflowModel1](rapidata/api_client/docs/SimpleWorkflowModel1.md)
 - [SimpleWorkflowModelBlueprint](rapidata/api_client/docs/SimpleWorkflowModelBlueprint.md)
 - [SkipResult](rapidata/api_client/docs/SkipResult.md)
 - [SkipTruth](rapidata/api_client/docs/SkipTruth.md)
 - [SortCriterion](rapidata/api_client/docs/SortCriterion.md)
 - [SortDirection](rapidata/api_client/docs/SortDirection.md)
 - [SourceUrlMetadata](rapidata/api_client/docs/SourceUrlMetadata.md)
 - [SourceUrlMetadataModel](rapidata/api_client/docs/SourceUrlMetadataModel.md)
 - [StandingByBenchmark](rapidata/api_client/docs/StandingByBenchmark.md)
 - [StandingByLeaderboard](rapidata/api_client/docs/StandingByLeaderboard.md)
 - [StandingStatus](rapidata/api_client/docs/StandingStatus.md)
 - [StandingsByBenchmarkResult](rapidata/api_client/docs/StandingsByBenchmarkResult.md)
 - [StandingsByLeaderboardResult](rapidata/api_client/docs/StandingsByLeaderboardResult.md)
 - [StaticSelection](rapidata/api_client/docs/StaticSelection.md)
 - [StickyState](rapidata/api_client/docs/StickyState.md)
 - [StreamsMetadata](rapidata/api_client/docs/StreamsMetadata.md)
 - [StreamsMetadataModel](rapidata/api_client/docs/StreamsMetadataModel.md)
 - [SubmitOrderModel](rapidata/api_client/docs/SubmitOrderModel.md)
 - [SubmitParticipantResult](rapidata/api_client/docs/SubmitParticipantResult.md)
 - [SubmitPromptModel](rapidata/api_client/docs/SubmitPromptModel.md)
 - [TagsByBenchmarkResult](rapidata/api_client/docs/TagsByBenchmarkResult.md)
 - [TextAsset](rapidata/api_client/docs/TextAsset.md)
 - [TextAssetInput](rapidata/api_client/docs/TextAssetInput.md)
 - [TextAssetModel](rapidata/api_client/docs/TextAssetModel.md)
 - [TextMetadata](rapidata/api_client/docs/TextMetadata.md)
 - [TextMetadataModel](rapidata/api_client/docs/TextMetadataModel.md)
 - [TranscriptionMetadataInput](rapidata/api_client/docs/TranscriptionMetadataInput.md)
 - [TranscriptionPayload](rapidata/api_client/docs/TranscriptionPayload.md)
 - [TranscriptionRapidBlueprint](rapidata/api_client/docs/TranscriptionRapidBlueprint.md)
 - [TranscriptionResult](rapidata/api_client/docs/TranscriptionResult.md)
 - [TranscriptionTruth](rapidata/api_client/docs/TranscriptionTruth.md)
 - [TranscriptionWord](rapidata/api_client/docs/TranscriptionWord.md)
 - [TranslatedString](rapidata/api_client/docs/TranslatedString.md)
 - [UnlockOrderResult](rapidata/api_client/docs/UnlockOrderResult.md)
 - [UpdateBenchmarkModel](rapidata/api_client/docs/UpdateBenchmarkModel.md)
 - [UpdateBenchmarkNameModel](rapidata/api_client/docs/UpdateBenchmarkNameModel.md)
 - [UpdateCampaignModel](rapidata/api_client/docs/UpdateCampaignModel.md)
 - [UpdateDatasetNameModel](rapidata/api_client/docs/UpdateDatasetNameModel.md)
 - [UpdateDimensionsModel](rapidata/api_client/docs/UpdateDimensionsModel.md)
 - [UpdateLeaderboardModel](rapidata/api_client/docs/UpdateLeaderboardModel.md)
 - [UpdateLeaderboardNameModel](rapidata/api_client/docs/UpdateLeaderboardNameModel.md)
 - [UpdateLeaderboardResponseConfigModel](rapidata/api_client/docs/UpdateLeaderboardResponseConfigModel.md)
 - [UpdateOrderNameModel](rapidata/api_client/docs/UpdateOrderNameModel.md)
 - [UpdateParticipantModel](rapidata/api_client/docs/UpdateParticipantModel.md)
 - [UpdateParticipantNameModel](rapidata/api_client/docs/UpdateParticipantNameModel.md)
 - [UpdatePriorityModel](rapidata/api_client/docs/UpdatePriorityModel.md)
 - [UpdatePromptTagsModel](rapidata/api_client/docs/UpdatePromptTagsModel.md)
 - [UpdateShouldAlertModel](rapidata/api_client/docs/UpdateShouldAlertModel.md)
 - [UpdateValidationRapidModel](rapidata/api_client/docs/UpdateValidationRapidModel.md)
 - [UpdateValidationRapidModelContextAsset](rapidata/api_client/docs/UpdateValidationRapidModelContextAsset.md)
 - [UpdateValidationRapidModelTruth](rapidata/api_client/docs/UpdateValidationRapidModelTruth.md)
 - [UpdateValidationSetModel](rapidata/api_client/docs/UpdateValidationSetModel.md)
 - [UploadFileResult](rapidata/api_client/docs/UploadFileResult.md)
 - [UserActionRestriction](rapidata/api_client/docs/UserActionRestriction.md)
 - [UserActionRestrictionFilter](rapidata/api_client/docs/UserActionRestrictionFilter.md)
 - [UserScoreFilter](rapidata/api_client/docs/UserScoreFilter.md)
 - [UserScoreUserFilterModel](rapidata/api_client/docs/UserScoreUserFilterModel.md)
 - [UserState](rapidata/api_client/docs/UserState.md)
 - [UserStateFilter](rapidata/api_client/docs/UserStateFilter.md)
 - [ValidationSelection](rapidata/api_client/docs/ValidationSelection.md)
 - [ValidationSetModel](rapidata/api_client/docs/ValidationSetModel.md)
 - [ValidationSetOverviewModel](rapidata/api_client/docs/ValidationSetOverviewModel.md)
 - [VideoDurationMetadata](rapidata/api_client/docs/VideoDurationMetadata.md)
 - [VideoDurationMetadataModel](rapidata/api_client/docs/VideoDurationMetadataModel.md)
 - [WorkflowAggregationStepModel](rapidata/api_client/docs/WorkflowAggregationStepModel.md)
 - [WorkflowArtifactModel](rapidata/api_client/docs/WorkflowArtifactModel.md)
 - [WorkflowConfigArtifactModel](rapidata/api_client/docs/WorkflowConfigArtifactModel.md)
 - [WorkflowConfigArtifactModelWorkflowConfig](rapidata/api_client/docs/WorkflowConfigArtifactModelWorkflowConfig.md)
 - [WorkflowLabelingStepModel](rapidata/api_client/docs/WorkflowLabelingStepModel.md)
 - [WorkflowState](rapidata/api_client/docs/WorkflowState.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearer"></a>
### bearer

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

<a id="oauth2"></a>
### oauth2



## Author




