from types import SimpleNamespace

# key: element class tag; value: element type
ELE_TYPE_TAGS = {
    1: "Subdomain",
    2: "TAGS_WrapperElement",
    3: "ElasticBeam2d",
    4: "ModElasticBeam2d",
    5: "ElasticBeam3d",
    5001: "ElasticBeamWarping3d",
    6: "Beam2d",
    7: "beam2d02",
    8: "beam2d03",
    9: "beam2d04",
    10: "beam3d01",
    11: "beam3d02",
    12: "Truss",
    13: "TrussSection",
    14: "CorotTruss",
    15: "CorotTrussSection",
    16: "fElmt05",
    17: "fElmt02",
    18: "MyTruss",
    19: "ZeroLength",
    20: "ZeroLengthSection",
    21: "ZeroLengthND",
    22: "ZeroLengthContact2D",
    23: "ZeroLengthContact3D",
    24: "ZeroLengthContactNTS2D",
    25: "ZeroLengthInterface2D",
    26: "CoupledZeroLength",
    2626: "BiaxialZeroLength",
    27: "ZeroLengthRocking",
    28: "NLBeamColumn2d",
    29: "NLBeamColumn3d",
    30: "LargeDispBeamColumn3d",
    31: "FourNodeQuad",
    32: "FourNodeQuad3d",
    33: "Tri31",
    34: "BeamWithHinges2d",
    35: "BeamWithHinges3d",
    36: "EightNodeBrick",
    37: "TwentyNodeBrick",
    38: "EightNodeBrick_u_p_U",
    39: "TwentyNodeBrick_u_p_U",
    40: "FourNodeQuadUP",
    41: "TotalLagrangianFD20NodeBrick",
    42: "TotalLagrangianFD8NodeBrick",
    43: "EightNode_LDBrick_u_p",
    44: "EightNode_Brick_u_p",
    45: "TwentySevenNodeBrick",
    46: "BrickUP",
    47: "Nine_Four_Node_QuadUP",
    48: "Twenty_Eight_Node_BrickUP",
    49: "Twenty_Node_Brick",
    50: "BBarFourNodeQuadUP",
    51: "BBarBrickUP",
    52: "PlateMITC4",
    53: "ShellMITC4",
    54: "ShellMITC9",
    55: "Plate1",
    56: "Brick",
    57: "BbarBrick",
    58: "FLBrick",
    59: "EnhancedQuad",
    60: "ConstantPressureVolumeQuad",
    61: "NineNodeMixedQuad",
    62: "DispBeamColumn2d",
    621: "DispBeamColumnNL2d",
    63: "TimoshenkoBeamColumn2d",
    631: "TimoshenkoBeamColumn3d",
    64: "DispBeamColumn3d",
    640: "DispBeamColumnNL3d",
    641: "DispBeamColumnWarping3d",
    642: "DispBeamColumnAsym3d",
    65: "HingedBeam2d",
    66: "HingedBeam3d",
    67: "TwoPointHingedBeam2d",
    68: "TwoPointHingedBeam3d",
    69: "OnePointHingedBeam2d",
    70: "OnePointHingedBeam3d",
    71: "BeamColumnJoint2d",
    72: "BeamColumnJoint3d",
    73: "ForceBeamColumn2d",
    731: "ForceBeamColumnWarping2d",
    74: "ForceBeamColumn3d",
    75: "ElasticForceBeamColumn2d",
    751: "ElasticForceBeamColumnWarping2d",
    76: "ElasticForceBeamColumn3d",
    77: "ForceBeamColumnCBDI2d",
    78: "ForceBeamColumnCBDI3d",
    30766: "MixedBeamColumn2d",
    30765: "MixedBeamColumn3d",
    30767: "MixedBeamColumnAsym3d",
    79: "DispBeamColumn2dInt",
    80: "InternalSpring",
    81: "SimpleJoint2D",
    8181: "LehighJoint2d",
    82: "Joint2D",
    83: "Joint3D",
    84: "ElastomericBearingPlasticity3d",
    85: "ElastomericBearingPlasticity2d",
    86: "TwoNodeLink",
    87: "ActuatorCorot",
    88: "Actuator",
    89: "Adapter",
    90: "ElastomericBearingBoucWen2d",
    91: "ElastomericBearingBoucWen3d",
    92: "FlatSliderSimple2d",
    93: "FlatSliderSimple3d",
    94: "FlatSlider2d",
    95: "FlatSlider3d",
    96: "SingleFPSimple2d",
    97: "SingleFPSimple3d",
    98: "SingleFP2d",
    99: "SingleFP3d",
    100: "DoubleFPSimple2d",
    101: "DoubleFPSimple3d",
    102: "DoubleFP2d",
    103: "DoubleFP3d",
    104: "TripleFPSimple2d",
    105: "TripleFPSimple3d",
    106: "TripleFP2d",
    107: "TripleFP3d",
    108: "MultiFP2d",
    109: "MultiFP3d",
    110: "GenericClient",
    111: "GenericCopy",
    112: "PY_MACRO2D",
    113: "SimpleContact2D",
    114: "SimpleContact3D",
    115: "BeamContact3D",
    116: "SurfaceLoad",
    117: "BeamContact2D",
    118: "BeamEndContact3D",
    119: "SSPquad",
    120: "SSPquadUP",
    121: "SSPbrick",
    122: "SSPbrickUP",
    123: "BeamContact2Dp",
    124: "BeamContact3Dp",
    125: "BeamEndContact3Dp",
    126: "Quad4FiberOverlay",
    127: "Brick8FiberOverlay",
    128: "DispBeamColumn2dThermal",
    129: "TPB1D",
    130: "TFP_Bearing",
    131: "TFP_Bearing2d",
    132: "TripleFrictionPendulum",
    133: "PFEMElement2D",
    134: "FourNodeQuad02",
    135: "cont2d01",
    136: "cont2d02",
    137: "CST",
    138: "Truss2",
    139: "CorotTruss2",
    140: "ZeroLengthImpact3D",
    141: "PFEMElement3D",
    142: "PFEMElement2DCompressible",
    143: "PFEMElement2DBubble",
    144: "PFEMElement2Dmini",
    145: "ElasticTimoshenkoBeam2d",
    146: "ElasticTimoshenkoBeam3d",
    147: "ElastomericBearingUFRP2d",
    148: "ElastomericBearingUFRP3d",
    149: "RJWatsonEQS2d",
    150: "RJWatsonEQS3d",
    151: "HDR",
    152: "ElastomericX",
    153: "LeadRubberX",
    154: "PileToe3D",
    155: "N4BiaxialTruss",
    156: "ShellDKGQ",
    157: "ShellNLDKGQ",
    158: "MultipleShearSpring",
    159: "MultipleNormalSpring",
    160: "KikuchiBearing",
    161: "YamamotoBiaxialHDR",
    162: "MVLEM",
    163: "SFI_MVLEM",
    164: "PFEMElement2DFIC",
    165: "ElastomericBearingBoucWenMod3d",
    166: "FPBearingPTV",
    167: "ShellDKGT",
    168: "ShellNLDKGT",
    169: "CatenaryCable",
    170: "DispBeamColumn3dThermal",
    171: "ForceBeamColumn2dThermal",
    172: "ForceBeamColumn3dThermal",
    173: "ShellMITC4Thermal",
    174: "ShellNLDKGQThermal",
    268: "ShellNLDKGTThermal",
    175: "ShellANDeS",
    178: "AxEqDispBeamColumn2d",
    179: "FourNodeTetrahedron",
    180: "TriSurfaceLoad",
    181: "QuadBeamEmbedContact",
    182: "EmbeddedBeamInterfaceL",
    183: "EmbeddedBeamInterfaceP",
    184: "EmbeddedEPBeamInterface",
    185: "LysmerTriangle",
    186: "TaylorHood2D",
    187: "PFEMElement2DQuasi",
    188: "MINI",
    189: "PFEMElement3DBubble",
    190: "LinearElasticSpring",
    191: "Inerter",
    192: "GradientInelasticBeamColumn2d",
    193: "GradientInelasticBeamColumn3d",
    194: "CohesiveZoneQuad",
    195: "ComponentElement2d",
    195195: "ComponentElement3d",
    196: "InerterElement",
    197: "BeamColumn2DwLHNMYS",
    198: "BeamColumn3DwLHNMYS",
    199: "PFEMLink",
    200: "PFEMContact2D",
    201: "PML3D",
    202: "PML2D",
    203: "ASDShellQ4",
    204: "ASDShellT3",
    205: "WheelRail",
    206: "DispBeamColumn3dID",
    207: "NineNodeQuad",
    208: "EightNodeQuad",
    209: "SixNodeTri",
    210: "RockingBC",
    211: "BeamColumn2DwLHNMYS_Damage",
    212: "MVLEM_3D",
    213: "SFI_MVLEM_3D",
    214: "BeamGT",
    215: "MasonPan12",
    216: "MasonPan3D",
    217: "ASDEmbeddedNodeElement",
    218: "InertiaTruss",
    219: "ASDAbsorbingBoundary2D",
    220: "ASDAbsorbingBoundary3D",
    221: "ZeroLengthContactASDimplex",
    250: "IGALinePatch",
    251: "IGASurfacePatch",
    252: "IGAVolumePatch",
    253: "IGAKLShell",
    254: "IGAKLShell_BendingStrip",
    255: "PFEMContact3D",
    256: "TenNodeTetrahedron",
    257: "E_SFI",
    258: "TripleFrictionPendulumX",
    99990: "ExternalElement",
    259259: "E_SFI_MVLEM_3D",
    259: "PML2D_3",
    260: "PML2D_5",
    261: "PML2D_12",
    262: "PML2DVISCOUS",
    # Sensitivity element
    100000011: "FourNodeQuadWithSensitivity",
    1984587234: "BbarBrickWithSensitivity",
    102030: "DispBeamColumn2dWithSensitivity",
    1110000: "DispBeamColumn3dWithSensitivity",
    100003: "VS3D4QuadWithSensitivity",
    100009: "AV3D4QuadWithSensitivity",
    100001: "AC3D8HexWithSensitivity",
    100002: "ASI3D8QuadWithSensitivity",
}
# ELE_TAG_TYPE = {value: key for key, value in ELE_TYPE_TAGS.items()}

# The element class Tag in OpenSees, which is used to determine the element type
# see ...\SRC\classTags.h
ELE_TAG_Truss = [
    12,  # Truss
    13,  # TrussSection
    14,  # CorotTruss
    15,  # CorotTrussSection
    16,  # fElmt05
    17,  # fElmt02
    18,  # MyTruss
    138,  # Truss2
    139,  # CorotTruss2
    155,  # N4BiaxialTrus
    169,  # CatenaryCable
    218,  # InertiaTruss
]
ELE_TAG_Cable = [169]
ELE_TAG_Link = [
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    2626,
    27,  # zeroLength
    86,  # twoNodeLink
    84,
    85,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    130,
    131,
    132,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    158,
    159,
    160,
    161,
    165,
    166,
    258,
]  # Bearing
ELE_TAG_Beam = [
    3,
    4,
    5,
    5001,
    6,
    7,
    8,
    9,
    10,
    11,
    162,  # "MVLEM"
    163,  # "SFI_MVLEM"
    257,  # "E_SFI"
    28,
    29,
    30,
    34,
    35,
    62,
    621,
    63,
    631,
    64,
    640,
    641,
    642,
    65,
    66,
    67,
    68,
    69,
    70,
    73,
    731,
    74,
    75,
    751,
    76,
    77,
    78,
    30766,
    30765,
    30767,
    79,
    145,  # ElasticTimoshenkoBeam2d
    146,  # ElasticTimoshenkoBeam3d
    192,  # GradientInelasticBeamColumn2d
    193,  # GradientInelasticBeamColumn3d
    128,  # DispBeamColumn2dThermal
    170,  # DispBeamColumn3dThermal
    171,  # ForceBeamColumn2dThermal
    172,  # ForceBeamColumn3dThermal
    197,  # BeamColumn2DwLHNMYS
    198,  # BeamColumn3DwLHNMYS
    206,  # DispBeamColumn3dID
    211,  # BeamColumn2DwLHNMYS_Damage
    257,  # E_SFI
    102030,  # ELE_TAG_DispBeamColumn2dWithSensitivity
    1110000,  # ELE_TAG_DispBeamColumn3dWithSensitivity
]
ELE_TAG_Plane = [
    31,
    32,
    33,
    40,
    47,
    50,
    59,
    60,
    61,
    # 116,  # QuadSurfaceLoad
    119,
    120,
    126,
    134,
    # 180, # TriSurfaceLoad
    207,
    208,
    209,
    219,
    100000011,  # FourNodeQuadWithSensitivity
    100003,  # ELE_TAG_VS3D4QuadWithSensitivity
    100009,  # ELE_TAG_AV3D4QuadWithSensitivity
    100002,  # ELE_TAG_ASI3D8QuadWithSensitivity
    133,  # PFEMElement2D
    142,  # PFEMElement2DCompressible
    143,  # PFEMElement2DBubble
    144,  # PFEMElement2Dmini
    164,  # PFEMElement2DFIC
    187,  # PFEMElement2DQuasi
]
ELE_TAG_SURFACE_LOAD = [116, 180]
ELE_TAG_Shell = [
    52,
    53,
    54,
    55,
    156,
    157,
    167,
    168,
    175,
    203,
    204,
    212,  # MVLEM_3D
    213,  # SFI_MVLEM_3D
    259259,  # MVLEM_3D
    173,  # ShellMITC4Thermal
    174,  # ShellNLDKGQThermal
    268,  # ShellNLDKGTThermal
]
ELE_TAG_Wall = [212, 213, 259259, 162, 163, 257]  # 162-MVLEM2D, 163-SFI_MVLEM2D, 257-E_SFI2D
ELE_TAG_Joint = [71, 72, 81, 8181, 82, 83]
ELE_TAG_Tetrahedron = [179, 256, 189]  # four, ten, 189-FEMBubble
ELE_TAG_Brick = [
    36,
    37,
    38,
    39,
    41,
    42,
    43,
    44,
    45,
    46,
    48,
    49,
    51,
    56,
    57,
    58,
    121,
    122,
    127,
    220,
    1984587234,  # ELE_TAG_BbarBrickWithSensitivity
    100001,  # ELE_TAG_AC3D8HexWithSensitivity
]
ELE_TAG_PFEM = [133, 141, 142, 143, 144, 164, 187, 189, 199, 200, 255]
ELE_TAG_UP = [40, 46, 47, 48, 50, 51, 120, 122]
ELE_TAG_CONTACT = [22, 23, 24, 25, 113, 114, 115, 117, 118, 123, 124, 125, 140, 221]

OPS_ELE_TAGS = SimpleNamespace(
    Types=ELE_TYPE_TAGS,
    Beam=ELE_TAG_Beam,
    Tet=ELE_TAG_Tetrahedron,
    Link=ELE_TAG_Link,
    Truss=ELE_TAG_Truss,
    PFEM=ELE_TAG_PFEM,
    Brick=ELE_TAG_Brick,
    Solid=ELE_TAG_Tetrahedron + ELE_TAG_Brick,
    Joint=ELE_TAG_Joint,
    Plane=ELE_TAG_Plane,
    Shell=ELE_TAG_Shell,
    Wall=ELE_TAG_Wall,
    SurfaceLoad=ELE_TAG_SURFACE_LOAD,
    # solid-fluid coupled elements, solid displacement (u) and fluid pressure (p)
    UP=ELE_TAG_UP,
    Contact=ELE_TAG_CONTACT,
)
OPS_ELE_CLASSTAG2TYPE = ELE_TYPE_TAGS

OPS_ELE_TYPES = {}
for attr, value in vars(OPS_ELE_TAGS).items():
    if attr != "Types":
        OPS_ELE_TYPES[attr] = [ELE_TYPE_TAGS[tag] for tag in value]
OPS_ELE_TYPES = SimpleNamespace(**OPS_ELE_TYPES)
