# This document was created from CSiBridge version 24.0.0

# Units: KN, m, C

from collections import namedtuple
import openseespy.opensees as ops


def Dam():
    # Destroy all constructed objects,
    # i.e. all components of the model, all components of the analysis and all recorders.
    ops.wipe()
    # Set the default model dimensions and number of dofs.
    ops.model('basic', '-ndm', 3, '-ndf', 3)

    # Mechanical properties of material
    MatProp_df = dict()
    # UnitMass-Mass Density; E-Elastic Modulus; G-Shear Modulus; v-Poisson's ratio; rho-Thermal expansion coefficient
    MatProp = namedtuple('MatProp', ('UnitMass', 'E', 'G', 'v', 'rho'))
    MatProp_df["4000Psi"] = MatProp._make(
        (2.40276960558926, 24855578.0600518, 10356490.8583549, 0.2, 9.89999952793124e-06))
    MatProp_df["A709Gr50"] = MatProp._make(
        (7.84904737995992, 199947978.795958, 76903068.767676, 0.3, 1.16999994421006e-05))

    # Create OpenSees node.
    ops.node(1, *[18.1845453532451, 21.2913670368009, 0.0])
    ops.node(2, *[19.7989898732233, 19.7989898732233, 0.0])
    ops.node(3, *[20.7823375465659, 24.332990899201, 0.0])
    ops.node(4, *[22.6274169979695, 22.6274169979695, 0.0])
    ops.node(5, *[18.7041037919093, 21.8996918092809, 2.0])
    ops.node(6, *[20.3646752981726, 20.3646752981726, 2.0])
    ops.node(7, *[21.1287098390086, 24.738540747521, 2.0])
    ops.node(8, *[23.0045406146023, 23.0045406146023, 2.0])
    ops.node(9, *[16.4579870641892, 22.6524758424985, 0.0])
    ops.node(10, *[18.8091280733591, 25.8885438199983, 0.0])
    ops.node(11, *[16.9282152660232, 23.2996894379985, 2.0])
    ops.node(12, *[19.1226135412485, 26.3200195503316, 2.0])
    ops.node(13, *[14.6299598120466, 23.8739246019146, 0.0])
    ops.node(14, *[16.7199540709104, 27.2844852593309, 0.0])
    ops.node(15, *[15.0479586638193, 24.5560367333979, 2.0])
    ops.node(16, *[16.9986199720922, 27.7392266803198, 2.0])
    ops.node(17, *[12.7117339927073, 24.9481826772743, 0.0])
    ops.node(18, *[14.5276959916655, 28.5122087740278, 0.0])
    ops.node(19, *[13.0749263924989, 25.660987896625, 2.0])
    ops.node(20, *[14.7698242581933, 28.9874122535949, 2.0])
    ops.node(21, *[10.7151361062225, 25.868626910316, 0.0])
    ops.node(22, *[12.2458698356829, 29.5641450403612, 0.0])
    ops.node(23, *[11.0212828521146, 26.6077305363251, 2.0])
    ops.node(24, *[12.4499676662776, 30.0568807910339, 2.0])
    ops.node(25, *[8.65247584249853, 26.6295824562643, 0.0])
    ops.node(26, *[9.88854381999832, 30.4338085214449, 0.0])
    ops.node(27, *[8.89968943799849, 27.3904276693004, 2.0])
    ops.node(28, *[10.053352883665, 30.941038663469, 2.0])
    ops.node(29, *[6.53647018796535, 27.2263577711349, 0.0])
    ops.node(30, *[7.47025164338898, 31.1158374527256, 0.0])
    ops.node(31, *[6.72322647905008, 28.0042537074531, 2.0])
    ops.node(32, *[7.59475583744546, 31.6344347436044, 2.0])
    ops.node(33, *[4.38016502112647, 27.6552735366639, 0.0])
    ops.node(34, *[5.00590288128739, 31.6060268990444, 0.0])
    ops.node(35, *[4.50531259315865, 28.44542420914, 2.0])
    ops.node(36, *[5.08933459597551, 32.1327940140285, 2.0])
    ops.node(37, *[2.19685468037966, 27.9136853445276, 0.0])
    ops.node(38, *[2.51069106329104, 31.9013546794601, 0.0])
    ops.node(39, *[2.25962195696194, 28.7112192115141, 2.0])
    ops.node(40, *[2.55253591434589, 32.4330439241178, 2.0])
    ops.node(41, *[1.71444889535133e-15, 28.0, 0.0])
    ops.node(42, *[1.9593701661158e-15, 32.0, 0.0])
    ops.node(43, *[1.76343314950422e-15, 28.8, 2.0])
    ops.node(44, *[1.99202633555107e-15, 32.5333333333333, 2.0])
    ops.node(45, *[-2.19685468037966, 27.9136853445276, 0.0])
    ops.node(46, *[-2.51069106329104, 31.9013546794601, 0.0])
    ops.node(47, *[-2.25962195696193, 28.7112192115141, 2.0])
    ops.node(48, *[-2.55253591434589, 32.4330439241178, 2.0])
    ops.node(49, *[-4.38016502112647, 27.6552735366639, 0.0])
    ops.node(50, *[-5.00590288128739, 31.6060268990444, 0.0])
    ops.node(51, *[-4.50531259315865, 28.44542420914, 2.0])
    ops.node(52, *[-5.08933459597552, 32.1327940140285, 2.0])
    ops.node(53, *[-6.53647018796534, 27.2263577711349, 0.0])
    ops.node(54, *[-7.47025164338896, 31.1158374527257, 0.0])
    ops.node(55, *[-6.72322647905007, 28.0042537074531, 2.0])
    ops.node(56, *[-7.59475583744545, 31.6344347436044, 2.0])
    ops.node(57, *[-8.65247584249853, 26.6295824562643, 0.0])
    ops.node(58, *[-9.88854381999831, 30.4338085214449, 0.0])
    ops.node(59, *[-8.89968943799848, 27.3904276693004, 2.0])
    ops.node(60, *[-10.053352883665, 30.941038663469, 2.0])
    ops.node(61, *[-10.7151361062225, 25.868626910316, 0.0])
    ops.node(62, *[-12.2458698356829, 29.5641450403612, 0.0])
    ops.node(63, *[-11.0212828521146, 26.6077305363251, 2.0])
    ops.node(64, *[-12.4499676662776, 30.0568807910339, 2.0])
    ops.node(65, *[-12.7117339927073, 24.9481826772743, 0.0])
    ops.node(66, *[-14.5276959916655, 28.5122087740278, 0.0])
    ops.node(67, *[-13.0749263924989, 25.660987896625, 2.0])
    ops.node(68, *[-14.7698242581933, 28.9874122535949, 2.0])
    ops.node(69, *[-14.6299598120466, 23.8739246019146, 0.0])
    ops.node(70, *[-16.7199540709104, 27.284485259331, 0.0])
    ops.node(71, *[-15.0479586638193, 24.5560367333979, 2.0])
    ops.node(72, *[-16.9986199720922, 27.7392266803198, 2.0])
    ops.node(73, *[-16.4579870641892, 22.6524758424985, 0.0])
    ops.node(74, *[-18.8091280733591, 25.8885438199983, 0.0])
    ops.node(75, *[-16.9282152660232, 23.2996894379985, 2.0])
    ops.node(76, *[-19.1226135412485, 26.3200195503316, 2.0])
    ops.node(77, *[-18.1845453532451, 21.2913670368009, 0.0])
    ops.node(78, *[-20.7823375465659, 24.332990899201, 0.0])
    ops.node(79, *[-18.7041037919093, 21.8996918092809, 2.0])
    ops.node(80, *[-21.1287098390086, 24.738540747521, 2.0])
    ops.node(81, *[-19.7989898732233, 19.7989898732233, 0.0])
    ops.node(82, *[-22.6274169979695, 22.6274169979695, 0.0])
    ops.node(83, *[-20.3646752981726, 20.3646752981726, 2.0])
    ops.node(84, *[-23.0045406146023, 23.0045406146023, 2.0])
    ops.node(85, *[23.3801297398866, 27.3746147616011, 0.0])
    ops.node(86, *[25.4558441227157, 25.4558441227157, 0.0])
    ops.node(87, *[23.553315886108, 27.5773896857611, 2.0])
    ops.node(88, *[25.6444059310321, 25.6444059310321, 2.0])
    ops.node(89, *[21.160269082529, 29.1246117974981, 0.0])
    ops.node(90, *[21.3170118164737, 29.3403496626648, 2.0])
    ops.node(91, *[18.8099483297742, 30.6950459167473, 0.0])
    ops.node(92, *[18.9492812803651, 30.9224166272417, 2.0])
    ops.node(93, *[16.3436579906237, 32.0762348707812, 0.0])
    ops.node(94, *[16.4647221238876, 32.3138366105648, 2.0])
    ops.node(95, *[13.7766035651432, 33.2596631704063, 0.0])
    ops.node(96, *[13.8786524804406, 33.5060310457427, 2.0])
    ops.node(97, *[11.1246117974981, 34.2380345866255, 0.0])
    ops.node(98, *[11.2070163293314, 34.4916496576376, 2.0])
    ops.node(99, *[8.4040330988126, 35.0053171343164, 0.0])
    ops.node(100, *[8.46628519584084, 35.2646157797557, 2.0])
    ops.node(101, *[5.63164074144831, 35.556780261425, 0.0])
    ops.node(102, *[5.67335659879237, 35.820163818917, 2.0])
    ops.node(103, *[2.82452744620242, 35.8890240143926, 0.0])
    ops.node(104, *[2.84544987172985, 36.1548686367214, 2.0])
    ops.node(105, *[2.20429143688028e-15, 36.0, 0.0])
    ops.node(106, *[2.22061952159791e-15, 36.2666666666667, 2.0])
    ops.node(107, *[-2.82452744620242, 35.8890240143926, 0.0])
    ops.node(108, *[-2.84544987172984, 36.1548686367214, 2.0])
    ops.node(109, *[-5.63164074144832, 35.556780261425, 0.0])
    ops.node(110, *[-5.67335659879238, 35.820163818917, 2.0])
    ops.node(111, *[-8.40403309881258, 35.0053171343164, 0.0])
    ops.node(112, *[-8.46628519584083, 35.2646157797557, 2.0])
    ops.node(113, *[-11.1246117974981, 34.2380345866255, 0.0])
    ops.node(114, *[-11.2070163293314, 34.4916496576376, 2.0])
    ops.node(115, *[-13.7766035651432, 33.2596631704063, 0.0])
    ops.node(116, *[-13.8786524804406, 33.5060310457427, 2.0])
    ops.node(117, *[-16.3436579906237, 32.0762348707812, 0.0])
    ops.node(118, *[-16.4647221238876, 32.3138366105648, 2.0])
    ops.node(119, *[-18.8099483297742, 30.6950459167473, 0.0])
    ops.node(120, *[-18.9492812803651, 30.9224166272417, 2.0])
    ops.node(121, *[-21.160269082529, 29.1246117974981, 0.0])
    ops.node(122, *[-21.3170118164737, 29.3403496626648, 2.0])
    ops.node(123, *[-23.3801297398866, 27.3746147616011, 0.0])
    ops.node(124, *[-23.553315886108, 27.5773896857611, 2.0])
    ops.node(125, *[-25.4558441227157, 25.4558441227157, 0.0])
    ops.node(126, *[-25.6444059310321, 25.6444059310321, 2.0])
    ops.node(127, *[25.9779219332073, 30.4162386240012, 0.0])
    ops.node(128, *[28.2842712474619, 28.2842712474619, 0.0])
    ops.node(129, *[25.9779219332073, 30.4162386240012, 2.0])
    ops.node(130, *[28.2842712474619, 28.2842712474619, 2.0])
    ops.node(131, *[23.5114100916989, 32.3606797749979, 0.0])
    ops.node(132, *[23.5114100916989, 32.3606797749979, 2.0])
    ops.node(133, *[20.899942588638, 34.1056065741637, 0.0])
    ops.node(134, *[20.899942588638, 34.1056065741637, 2.0])
    ops.node(135, *[18.1596199895819, 35.6402609675347, 0.0])
    ops.node(136, *[18.1596199895819, 35.6402609675347, 2.0])
    ops.node(137, *[15.3073372946036, 36.9551813004515, 0.0])
    ops.node(138, *[15.3073372946036, 36.9551813004515, 2.0])
    ops.node(139, *[12.3606797749979, 38.0422606518061, 0.0])
    ops.node(140, *[12.3606797749979, 38.0422606518061, 2.0])
    ops.node(141, *[9.33781455423622, 38.8947968159071, 0.0])
    ops.node(142, *[9.33781455423622, 38.8947968159071, 2.0])
    ops.node(143, *[6.25737860160924, 39.5075336238055, 0.0])
    ops.node(144, *[6.25737860160924, 39.5075336238055, 2.0])
    ops.node(145, *[3.1383638291138, 39.8766933493251, 0.0])
    ops.node(146, *[3.1383638291138, 39.8766933493251, 2.0])
    ops.node(147, *[2.44921270764475e-15, 40.0, 0.0])
    ops.node(148, *[2.44921270764475e-15, 40.0, 2.0])
    ops.node(149, *[-3.13836382911379, 39.8766933493251, 0.0])
    ops.node(150, *[-3.13836382911379, 39.8766933493251, 2.0])
    ops.node(151, *[-6.25737860160924, 39.5075336238055, 0.0])
    ops.node(152, *[-6.25737860160924, 39.5075336238055, 2.0])
    ops.node(153, *[-9.33781455423621, 38.8947968159071, 0.0])
    ops.node(154, *[-9.33781455423621, 38.8947968159071, 2.0])
    ops.node(155, *[-12.3606797749979, 38.0422606518061, 0.0])
    ops.node(156, *[-12.3606797749979, 38.0422606518061, 2.0])
    ops.node(157, *[-15.3073372946036, 36.9551813004515, 0.0])
    ops.node(158, *[-15.3073372946036, 36.9551813004515, 2.0])
    ops.node(159, *[-18.1596199895819, 35.6402609675347, 0.0])
    ops.node(160, *[-18.1596199895819, 35.6402609675347, 2.0])
    ops.node(161, *[-20.899942588638, 34.1056065741637, 0.0])
    ops.node(162, *[-20.899942588638, 34.1056065741637, 2.0])
    ops.node(163, *[-23.5114100916989, 32.3606797749979, 0.0])
    ops.node(164, *[-23.5114100916989, 32.3606797749979, 2.0])
    ops.node(165, *[-25.9779219332073, 30.4162386240012, 0.0])
    ops.node(166, *[-25.9779219332073, 30.4162386240012, 2.0])
    ops.node(167, *[-28.2842712474619, 28.2842712474619, 0.0])
    ops.node(168, *[-28.2842712474619, 28.2842712474619, 2.0])
    ops.node(169, *[19.2236622305734, 22.5080165817609, 4.0])
    ops.node(170, *[20.9303607231218, 20.9303607231218, 4.0])
    ops.node(171, *[21.4750821314514, 25.144090595841, 4.0])
    ops.node(172, *[23.3816642312352, 23.3816642312352, 4.0])
    ops.node(173, *[17.3984434678572, 23.9469030334984, 4.0])
    ops.node(174, *[19.4360990091378, 26.7514952806649, 4.0])
    ops.node(175, *[15.4659575155921, 25.2381488648811, 4.0])
    ops.node(176, *[17.277285873274, 28.1939681013087, 4.0])
    ops.node(177, *[13.4381187922906, 26.3737931159757, 4.0])
    ops.node(178, *[15.011952524721, 29.462615733162, 4.0])
    ops.node(179, *[11.3274295980067, 27.3468341623341, 4.0])
    ops.node(180, *[12.6540654968723, 30.5496165417066, 4.0])
    ops.node(181, *[9.14690303349844, 28.1512728823365, 4.0])
    ops.node(182, *[10.2181619473316, 31.4482688054931, 4.0])
    ops.node(183, *[6.9099827701348, 28.7821496437712, 4.0])
    ops.node(184, *[7.71926003150194, 32.1530320344832, 4.0])
    ops.node(185, *[4.63046016519084, 29.2355748816161, 4.0])
    ops.node(186, *[5.17276631066364, 32.6595611290126, 4.0])
    ops.node(187, *[2.32238923354421, 29.5087530785006, 4.0])
    ops.node(188, *[2.59438076540074, 32.9647331687754, 4.0])
    ops.node(189, *[1.81241740365712e-15, 29.6, 4.0])
    ops.node(190, *[2.02468250498633e-15, 33.0666666666667, 4.0])
    ops.node(191, *[-2.32238923354421, 29.5087530785006, 4.0])
    ops.node(192, *[-2.59438076540074, 32.9647331687754, 4.0])
    ops.node(193, *[-4.63046016519084, 29.2355748816161, 4.0])
    ops.node(194, *[-5.17276631066364, 32.6595611290126, 4.0])
    ops.node(195, *[-6.90998277013479, 28.7821496437712, 4.0])
    ops.node(196, *[-7.71926003150193, 32.1530320344832, 4.0])
    ops.node(197, *[-9.14690303349844, 28.1512728823365, 4.0])
    ops.node(198, *[-10.2181619473316, 31.4482688054931, 4.0])
    ops.node(199, *[-11.3274295980067, 27.3468341623341, 4.0])
    ops.node(200, *[-12.6540654968723, 30.5496165417066, 4.0])
    ops.node(201, *[-13.4381187922906, 26.3737931159757, 4.0])
    ops.node(202, *[-15.011952524721, 29.462615733162, 4.0])
    ops.node(203, *[-15.4659575155921, 25.2381488648811, 4.0])
    ops.node(204, *[-17.277285873274, 28.1939681013087, 4.0])
    ops.node(205, *[-17.3984434678572, 23.9469030334984, 4.0])
    ops.node(206, *[-19.4360990091378, 26.7514952806649, 4.0])
    ops.node(207, *[-19.2236622305734, 22.5080165817609, 4.0])
    ops.node(208, *[-21.4750821314514, 25.144090595841, 4.0])
    ops.node(209, *[-20.9303607231218, 20.9303607231218, 4.0])
    ops.node(210, *[-23.3816642312352, 23.3816642312352, 4.0])
    ops.node(211, *[23.7265020323294, 27.7801646099211, 4.0])
    ops.node(212, *[25.8329677393485, 25.8329677393485, 4.0])
    ops.node(213, *[21.4737545504184, 29.5560875278314, 4.0])
    ops.node(214, *[19.088614230956, 31.1497873377362, 4.0])
    ops.node(215, *[16.5857862571514, 32.5514383503484, 4.0])
    ops.node(216, *[13.980701395738, 33.752398921079, 4.0])
    ops.node(217, *[11.2894208611647, 34.7452647286496, 4.0])
    ops.node(218, *[8.52853729286908, 35.5239144251951, 4.0])
    ops.node(219, *[5.71507245613644, 36.083547376409, 4.0])
    ops.node(220, *[2.86637229725727, 36.4207132590503, 4.0])
    ops.node(221, *[2.23694760631554e-15, 36.5333333333333, 4.0])
    ops.node(222, *[-2.86637229725727, 36.4207132590503, 4.0])
    ops.node(223, *[-5.71507245613644, 36.083547376409, 4.0])
    ops.node(224, *[-8.52853729286907, 35.5239144251951, 4.0])
    ops.node(225, *[-11.2894208611647, 34.7452647286496, 4.0])
    ops.node(226, *[-13.9807013957379, 33.752398921079, 4.0])
    ops.node(227, *[-16.5857862571514, 32.5514383503484, 4.0])
    ops.node(228, *[-19.088614230956, 31.1497873377362, 4.0])
    ops.node(229, *[-21.4737545504184, 29.5560875278314, 4.0])
    ops.node(230, *[-23.7265020323294, 27.7801646099211, 4.0])
    ops.node(231, *[-25.8329677393485, 25.8329677393485, 4.0])
    ops.node(232, *[25.9779219332073, 30.4162386240012, 4.0])
    ops.node(233, *[28.2842712474619, 28.2842712474619, 4.0])
    ops.node(234, *[23.5114100916989, 32.3606797749979, 4.0])
    ops.node(235, *[20.899942588638, 34.1056065741637, 4.0])
    ops.node(236, *[18.1596199895819, 35.6402609675347, 4.0])
    ops.node(237, *[15.3073372946036, 36.9551813004515, 4.0])
    ops.node(238, *[12.3606797749979, 38.0422606518061, 4.0])
    ops.node(239, *[9.33781455423622, 38.8947968159071, 4.0])
    ops.node(240, *[6.25737860160924, 39.5075336238055, 4.0])
    ops.node(241, *[3.1383638291138, 39.8766933493251, 4.0])
    ops.node(242, *[2.44921270764475e-15, 40.0, 4.0])
    ops.node(243, *[-3.13836382911379, 39.8766933493251, 4.0])
    ops.node(244, *[-6.25737860160924, 39.5075336238055, 4.0])
    ops.node(245, *[-9.33781455423621, 38.8947968159071, 4.0])
    ops.node(246, *[-12.3606797749979, 38.0422606518061, 4.0])
    ops.node(247, *[-15.3073372946036, 36.9551813004515, 4.0])
    ops.node(248, *[-18.1596199895819, 35.6402609675347, 4.0])
    ops.node(249, *[-20.899942588638, 34.1056065741637, 4.0])
    ops.node(250, *[-23.5114100916989, 32.3606797749979, 4.0])
    ops.node(251, *[-25.9779219332073, 30.4162386240012, 4.0])
    ops.node(252, *[-28.2842712474619, 28.2842712474619, 4.0])
    ops.node(253, *[19.7432206692376, 23.1163413542409, 6.0])
    ops.node(254, *[21.496046148071, 21.496046148071, 6.0])
    ops.node(255, *[21.8214544238942, 25.549640444161, 6.0])
    ops.node(256, *[23.758787847868, 23.758787847868, 6.0])
    ops.node(257, *[17.8686716696912, 24.5941166289984, 6.0])
    ops.node(258, *[19.7495844770271, 27.1829710109982, 6.0])
    ops.node(259, *[15.8839563673648, 25.9202609963644, 6.0])
    ops.node(260, *[17.5559517744559, 28.6487095222975, 6.0])
    ops.node(261, *[13.8013111920822, 27.0865983353264, 6.0])
    ops.node(262, *[15.2540807912488, 29.9378192127292, 6.0])
    ops.node(263, *[11.6335763438987, 28.0859377883431, 6.0])
    ops.node(264, *[12.858163327467, 31.0423522923792, 6.0])
    ops.node(265, *[9.3941166289984, 28.9121180953727, 6.0])
    ops.node(266, *[10.3829710109982, 31.9554989475172, 6.0])
    ops.node(267, *[7.09673906121953, 29.5600455800894, 6.0])
    ops.node(268, *[7.84376422555842, 32.6716293253619, 6.0])
    ops.node(269, *[4.75560773722302, 30.0257255540922, 6.0])
    ops.node(270, *[5.25619802535176, 33.1863282439966, 6.0])
    ops.node(271, *[2.38515651012649, 30.3062869454871, 6.0])
    ops.node(272, *[2.63622561645559, 33.4964224134331, 6.0])
    ops.node(273, *[1.86140165781001e-15, 30.4, 6.0])
    ops.node(274, *[2.05733867442159e-15, 33.6, 6.0])
    ops.node(275, *[-2.38515651012648, 30.3062869454871, 6.0])
    ops.node(276, *[-2.63622561645559, 33.4964224134331, 6.0])
    ops.node(277, *[-4.75560773722302, 30.0257255540922, 6.0])
    ops.node(278, *[-5.25619802535176, 33.1863282439966, 6.0])
    ops.node(279, *[-7.09673906121952, 29.5600455800894, 6.0])
    ops.node(280, *[-7.84376422555841, 32.6716293253619, 6.0])
    ops.node(281, *[-9.3941166289984, 28.9121180953727, 6.0])
    ops.node(282, *[-10.3829710109982, 31.9554989475172, 6.0])
    ops.node(283, *[-11.6335763438987, 28.0859377883431, 6.0])
    ops.node(284, *[-12.858163327467, 31.0423522923792, 6.0])
    ops.node(285, *[-13.8013111920822, 27.0865983353264, 6.0])
    ops.node(286, *[-15.2540807912488, 29.9378192127292, 6.0])
    ops.node(287, *[-15.8839563673648, 25.9202609963644, 6.0])
    ops.node(288, *[-17.5559517744559, 28.6487095222975, 6.0])
    ops.node(289, *[-17.8686716696912, 24.5941166289984, 6.0])
    ops.node(290, *[-19.7495844770271, 27.1829710109982, 6.0])
    ops.node(291, *[-19.7432206692376, 23.1163413542409, 6.0])
    ops.node(292, *[-21.8214544238942, 25.549640444161, 6.0])
    ops.node(293, *[-21.496046148071, 21.496046148071, 6.0])
    ops.node(294, *[-23.758787847868, 23.758787847868, 6.0])
    ops.node(295, *[23.8996881785508, 27.9829395340811, 6.0])
    ops.node(296, *[26.021529547665, 26.021529547665, 6.0])
    ops.node(297, *[21.630497284363, 29.7718253929981, 6.0])
    ops.node(298, *[19.2279471815469, 31.3771580482306, 6.0])
    ops.node(299, *[16.7068503904153, 32.7890400901319, 6.0])
    ops.node(300, *[14.0827503110353, 33.9987667964154, 6.0])
    ops.node(301, *[11.3718253929981, 34.9988797996617, 6.0])
    ops.node(302, *[8.59078938989732, 35.7832130706345, 6.0])
    ops.node(303, *[5.7567883134805, 36.3469309339011, 6.0])
    ops.node(304, *[2.8872947227847, 36.6865578813791, 6.0])
    ops.node(305, *[2.25327569103317e-15, 36.8, 6.0])
    ops.node(306, *[-2.88729472278469, 36.6865578813791, 6.0])
    ops.node(307, *[-5.7567883134805, 36.3469309339011, 6.0])
    ops.node(308, *[-8.59078938989731, 35.7832130706345, 6.0])
    ops.node(309, *[-11.3718253929981, 34.9988797996617, 6.0])
    ops.node(310, *[-14.0827503110353, 33.9987667964154, 6.0])
    ops.node(311, *[-16.7068503904153, 32.7890400901319, 6.0])
    ops.node(312, *[-19.2279471815469, 31.3771580482306, 6.0])
    ops.node(313, *[-21.630497284363, 29.7718253929981, 6.0])
    ops.node(314, *[-23.8996881785508, 27.9829395340811, 6.0])
    ops.node(315, *[-26.021529547665, 26.021529547665, 6.0])
    ops.node(316, *[25.9779219332073, 30.4162386240012, 6.0])
    ops.node(317, *[28.2842712474619, 28.2842712474619, 6.0])
    ops.node(318, *[23.5114100916989, 32.3606797749979, 6.0])
    ops.node(319, *[20.899942588638, 34.1056065741637, 6.0])
    ops.node(320, *[18.1596199895819, 35.6402609675347, 6.0])
    ops.node(321, *[15.3073372946036, 36.9551813004515, 6.0])
    ops.node(322, *[12.3606797749979, 38.0422606518061, 6.0])
    ops.node(323, *[9.33781455423622, 38.8947968159071, 6.0])
    ops.node(324, *[6.25737860160924, 39.5075336238055, 6.0])
    ops.node(325, *[3.1383638291138, 39.8766933493251, 6.0])
    ops.node(326, *[2.44921270764475e-15, 40.0, 6.0])
    ops.node(327, *[-3.13836382911379, 39.8766933493251, 6.0])
    ops.node(328, *[-6.25737860160924, 39.5075336238055, 6.0])
    ops.node(329, *[-9.33781455423621, 38.8947968159071, 6.0])
    ops.node(330, *[-12.3606797749979, 38.0422606518061, 6.0])
    ops.node(331, *[-15.3073372946036, 36.9551813004515, 6.0])
    ops.node(332, *[-18.1596199895819, 35.6402609675347, 6.0])
    ops.node(333, *[-20.899942588638, 34.1056065741637, 6.0])
    ops.node(334, *[-23.5114100916989, 32.3606797749979, 6.0])
    ops.node(335, *[-25.9779219332073, 30.4162386240012, 6.0])
    ops.node(336, *[-28.2842712474619, 28.2842712474619, 6.0])
    ops.node(337, *[20.2627791079017, 23.724666126721, 8.0])
    ops.node(338, *[22.0617315730203, 22.0617315730203, 8.0])
    ops.node(339, *[22.1678267163369, 25.9551902924811, 8.0])
    ops.node(340, *[24.1359114645008, 24.1359114645008, 8.0])
    ops.node(341, *[18.3388998715252, 25.2413302244984, 8.0])
    ops.node(342, *[20.0630699449164, 27.6144467413315, 8.0])
    ops.node(343, *[16.3019552191376, 26.6023731278477, 8.0])
    ops.node(344, *[17.8346176756377, 29.1034509432863, 8.0])
    ops.node(345, *[14.1645035918739, 27.7994035546771, 8.0])
    ops.node(346, *[15.4962090577765, 30.4130226922963, 8.0])
    ops.node(347, *[11.9397230897908, 28.8250414143521, 8.0])
    ops.node(348, *[13.0622611580617, 31.5350880430519, 8.0])
    ops.node(349, *[9.64133022449836, 29.6729633084088, 8.0])
    ops.node(350, *[10.5477800746649, 32.4627290895412, 8.0])
    ops.node(351, *[7.28349535230425, 30.3379415164075, 8.0])
    ops.node(352, *[7.96826841961491, 33.1902266162407, 8.0])
    ops.node(353, *[4.8807553092552, 30.8158762265683, 8.0])
    ops.node(354, *[5.33962974003988, 33.7130953589807, 8.0])
    ops.node(355, *[2.44792378670876, 31.1038208124736, 8.0])
    ops.node(356, *[2.67807046751044, 34.0281116580908, 8.0])
    ops.node(357, *[1.91038591196291e-15, 31.2, 8.0])
    ops.node(358, *[2.08999484385686e-15, 34.1333333333333, 8.0])
    ops.node(359, *[-2.44792378670876, 31.1038208124736, 8.0])
    ops.node(360, *[-2.67807046751044, 34.0281116580908, 8.0])
    ops.node(361, *[-4.88075530925521, 30.8158762265683, 8.0])
    ops.node(362, *[-5.33962974003989, 33.7130953589807, 8.0])
    ops.node(363, *[-7.28349535230424, 30.3379415164075, 8.0])
    ops.node(364, *[-7.96826841961489, 33.1902266162407, 8.0])
    ops.node(365, *[-9.64133022449836, 29.6729633084088, 8.0])
    ops.node(366, *[-10.5477800746649, 32.4627290895412, 8.0])
    ops.node(367, *[-11.9397230897908, 28.8250414143521, 8.0])
    ops.node(368, *[-13.0622611580617, 31.5350880430519, 8.0])
    ops.node(369, *[-14.1645035918739, 27.7994035546771, 8.0])
    ops.node(370, *[-15.4962090577765, 30.4130226922963, 8.0])
    ops.node(371, *[-16.3019552191376, 26.6023731278477, 8.0])
    ops.node(372, *[-17.8346176756377, 29.1034509432864, 8.0])
    ops.node(373, *[-18.3388998715252, 25.2413302244984, 8.0])
    ops.node(374, *[-20.0630699449164, 27.6144467413315, 8.0])
    ops.node(375, *[-20.2627791079017, 23.724666126721, 8.0])
    ops.node(376, *[-22.1678267163369, 25.9551902924811, 8.0])
    ops.node(377, *[-22.0617315730203, 22.0617315730203, 8.0])
    ops.node(378, *[-24.1359114645008, 24.1359114645008, 8.0])
    ops.node(379, *[24.0728743247721, 28.1857144582411, 8.0])
    ops.node(380, *[26.2100913559814, 26.2100913559814, 8.0])
    ops.node(381, *[21.7872400183077, 29.9875632581647, 8.0])
    ops.node(382, *[19.3672801321378, 31.604528758725, 8.0])
    ops.node(383, *[16.8279145236792, 33.0266418299155, 8.0])
    ops.node(384, *[14.1847992263327, 34.2451346717517, 8.0])
    ops.node(385, *[11.4542299248314, 35.2524948706737, 8.0])
    ops.node(386, *[8.65304148692556, 36.0425117160739, 8.0])
    ops.node(387, *[5.79850417082456, 36.6103144913931, 8.0])
    ops.node(388, *[2.90821714831212, 36.9524025037079, 8.0])
    ops.node(389, *[2.26960377575081e-15, 37.0666666666667, 8.0])
    ops.node(390, *[-2.90821714831212, 36.9524025037079, 8.0])
    ops.node(391, *[-5.79850417082456, 36.6103144913931, 8.0])
    ops.node(392, *[-8.65304148692555, 36.0425117160739, 8.0])
    ops.node(393, *[-11.4542299248314, 35.2524948706737, 8.0])
    ops.node(394, *[-14.1847992263327, 34.2451346717517, 8.0])
    ops.node(395, *[-16.8279145236792, 33.0266418299155, 8.0])
    ops.node(396, *[-19.3672801321378, 31.604528758725, 8.0])
    ops.node(397, *[-21.7872400183077, 29.9875632581647, 8.0])
    ops.node(398, *[-24.0728743247721, 28.1857144582411, 8.0])
    ops.node(399, *[-26.2100913559814, 26.2100913559814, 8.0])
    ops.node(400, *[25.9779219332073, 30.4162386240012, 8.0])
    ops.node(401, *[28.2842712474619, 28.2842712474619, 8.0])
    ops.node(402, *[23.5114100916989, 32.3606797749979, 8.0])
    ops.node(403, *[20.899942588638, 34.1056065741637, 8.0])
    ops.node(404, *[18.1596199895819, 35.6402609675347, 8.0])
    ops.node(405, *[15.3073372946036, 36.9551813004515, 8.0])
    ops.node(406, *[12.3606797749979, 38.0422606518061, 8.0])
    ops.node(407, *[9.33781455423622, 38.8947968159071, 8.0])
    ops.node(408, *[6.25737860160924, 39.5075336238055, 8.0])
    ops.node(409, *[3.1383638291138, 39.8766933493251, 8.0])
    ops.node(410, *[2.44921270764475e-15, 40.0, 8.0])
    ops.node(411, *[-3.13836382911379, 39.8766933493251, 8.0])
    ops.node(412, *[-6.25737860160924, 39.5075336238055, 8.0])
    ops.node(413, *[-9.33781455423621, 38.8947968159071, 8.0])
    ops.node(414, *[-12.3606797749979, 38.0422606518061, 8.0])
    ops.node(415, *[-15.3073372946036, 36.9551813004515, 8.0])
    ops.node(416, *[-18.1596199895819, 35.6402609675347, 8.0])
    ops.node(417, *[-20.899942588638, 34.1056065741637, 8.0])
    ops.node(418, *[-23.5114100916989, 32.3606797749979, 8.0])
    ops.node(419, *[-25.9779219332073, 30.4162386240012, 8.0])
    ops.node(420, *[-28.2842712474619, 28.2842712474619, 8.0])
    ops.node(421, *[20.7823375465659, 24.332990899201, 10.0])
    ops.node(422, *[22.6274169979695, 22.6274169979695, 10.0])
    ops.node(423, *[22.5141990087797, 26.3607401408011, 10.0])
    ops.node(424, *[24.5130350811336, 24.5130350811336, 10.0])
    ops.node(425, *[18.8091280733591, 25.8885438199983, 10.0])
    ops.node(426, *[20.3765554128057, 28.0459224716648, 10.0])
    ops.node(427, *[16.7199540709104, 27.2844852593309, 10.0])
    ops.node(428, *[18.1132835768196, 29.5581923642752, 10.0])
    ops.node(429, *[14.5276959916655, 28.5122087740278, 10.0])
    ops.node(430, *[15.7383373243043, 30.8882261718634, 10.0])
    ops.node(431, *[12.2458698356829, 29.5641450403612, 10.0])
    ops.node(432, *[13.2663589886564, 32.0278237937246, 10.0])
    ops.node(433, *[9.88854381999832, 30.4338085214449, 10.0])
    ops.node(434, *[10.7125891383315, 32.9699592315653, 10.0])
    ops.node(435, *[7.47025164338898, 31.1158374527256, 10.0])
    ops.node(436, *[8.09277261367139, 33.7088239071195, 10.0])
    ops.node(437, *[5.00590288128739, 31.6060268990444, 10.0])
    ops.node(438, *[5.42306145472801, 34.2398624739648, 10.0])
    ops.node(439, *[2.51069106329104, 31.9013546794601, 10.0])
    ops.node(440, *[2.71991531856529, 34.5598009027484, 10.0])
    ops.node(441, *[1.9593701661158e-15, 32.0, 10.0])
    ops.node(442, *[2.12265101329212e-15, 34.6666666666667, 10.0])
    ops.node(443, *[-2.51069106329104, 31.9013546794601, 10.0])
    ops.node(444, *[-2.71991531856529, 34.5598009027484, 10.0])
    ops.node(445, *[-5.00590288128739, 31.6060268990444, 10.0])
    ops.node(446, *[-5.42306145472801, 34.2398624739648, 10.0])
    ops.node(447, *[-7.47025164338896, 31.1158374527257, 10.0])
    ops.node(448, *[-8.09277261367138, 33.7088239071195, 10.0])
    ops.node(449, *[-9.88854381999831, 30.4338085214449, 10.0])
    ops.node(450, *[-10.7125891383315, 32.9699592315653, 10.0])
    ops.node(451, *[-12.2458698356829, 29.5641450403612, 10.0])
    ops.node(452, *[-13.2663589886564, 32.0278237937246, 10.0])
    ops.node(453, *[-14.5276959916655, 28.5122087740278, 10.0])
    ops.node(454, *[-15.7383373243043, 30.8882261718634, 10.0])
    ops.node(455, *[-16.7199540709104, 27.284485259331, 10.0])
    ops.node(456, *[-18.1132835768196, 29.5581923642752, 10.0])
    ops.node(457, *[-18.8091280733591, 25.8885438199983, 10.0])
    ops.node(458, *[-20.3765554128057, 28.0459224716648, 10.0])
    ops.node(459, *[-20.7823375465659, 24.332990899201, 10.0])
    ops.node(460, *[-22.5141990087797, 26.3607401408011, 10.0])
    ops.node(461, *[-22.6274169979695, 22.6274169979695, 10.0])
    ops.node(462, *[-24.5130350811336, 24.5130350811336, 10.0])
    ops.node(463, *[24.2460604709935, 28.3884893824012, 10.0])
    ops.node(464, *[26.3986531642978, 26.3986531642978, 10.0])
    ops.node(465, *[21.9439827522523, 30.2033011233314, 10.0])
    ops.node(466, *[19.5066130827288, 31.8318994692194, 10.0])
    ops.node(467, *[16.9489786569431, 33.2642435696991, 10.0])
    ops.node(468, *[14.28684814163, 34.491502547088, 10.0])
    ops.node(469, *[11.5366344566647, 35.5061099416857, 10.0])
    ops.node(470, *[8.7152935839538, 36.3018103615133, 10.0])
    ops.node(471, *[5.84022002816862, 36.8736980488851, 10.0])
    ops.node(472, *[2.92913957383955, 37.2182471260368, 10.0])
    ops.node(473, *[2.28593186046844e-15, 37.3333333333333, 10.0])
    ops.node(474, *[-2.92913957383954, 37.2182471260368, 10.0])
    ops.node(475, *[-5.84022002816862, 36.8736980488851, 10.0])
    ops.node(476, *[-8.71529358395379, 36.3018103615133, 10.0])
    ops.node(477, *[-11.5366344566647, 35.5061099416857, 10.0])
    ops.node(478, *[-14.28684814163, 34.491502547088, 10.0])
    ops.node(479, *[-16.9489786569431, 33.2642435696991, 10.0])
    ops.node(480, *[-19.5066130827288, 31.8318994692194, 10.0])
    ops.node(481, *[-21.9439827522523, 30.2033011233314, 10.0])
    ops.node(482, *[-24.2460604709935, 28.3884893824012, 10.0])
    ops.node(483, *[-26.3986531642978, 26.3986531642978, 10.0])
    ops.node(484, *[25.9779219332073, 30.4162386240012, 10.0])
    ops.node(485, *[28.2842712474619, 28.2842712474619, 10.0])
    ops.node(486, *[23.5114100916989, 32.3606797749979, 10.0])
    ops.node(487, *[20.899942588638, 34.1056065741637, 10.0])
    ops.node(488, *[18.1596199895819, 35.6402609675347, 10.0])
    ops.node(489, *[15.3073372946036, 36.9551813004515, 10.0])
    ops.node(490, *[12.3606797749979, 38.0422606518061, 10.0])
    ops.node(491, *[9.33781455423622, 38.8947968159071, 10.0])
    ops.node(492, *[6.25737860160924, 39.5075336238055, 10.0])
    ops.node(493, *[3.1383638291138, 39.8766933493251, 10.0])
    ops.node(494, *[2.44921270764475e-15, 40.0, 10.0])
    ops.node(495, *[-3.13836382911379, 39.8766933493251, 10.0])
    ops.node(496, *[-6.25737860160924, 39.5075336238055, 10.0])
    ops.node(497, *[-9.33781455423621, 38.8947968159071, 10.0])
    ops.node(498, *[-12.3606797749979, 38.0422606518061, 10.0])
    ops.node(499, *[-15.3073372946036, 36.9551813004515, 10.0])
    ops.node(500, *[-18.1596199895819, 35.6402609675347, 10.0])
    ops.node(501, *[-20.899942588638, 34.1056065741637, 10.0])
    ops.node(502, *[-23.5114100916989, 32.3606797749979, 10.0])
    ops.node(503, *[-25.9779219332073, 30.4162386240012, 10.0])
    ops.node(504, *[-28.2842712474619, 28.2842712474619, 10.0])
    ops.node(505, *[21.30189598523, 24.941315671681, 12.0])
    ops.node(506, *[23.1931024229188, 23.1931024229188, 12.0])
    ops.node(507, *[22.8605713012225, 26.7662899891211, 12.0])
    ops.node(508, *[24.8901586977665, 24.8901586977665, 12.0])
    ops.node(509, *[19.2793562751931, 26.5357574154983, 12.0])
    ops.node(510, *[20.6900408806951, 28.4773982019981, 12.0])
    ops.node(511, *[17.1379529226831, 27.9665973908142, 12.0])
    ops.node(512, *[18.3919494780014, 30.012933785264, 12.0])
    ops.node(513, *[14.8908883914571, 29.2250139933785, 12.0])
    ops.node(514, *[15.980465590832, 31.3634296514305, 12.0])
    ops.node(515, *[12.5520165815749, 30.3032486663702, 12.0])
    ops.node(516, *[13.4704568192512, 32.5205595443973, 12.0])
    ops.node(517, *[10.1357574154983, 31.194653734481, 12.0])
    ops.node(518, *[10.8773982019981, 33.4771893735894, 12.0])
    ops.node(519, *[7.6570079344737, 31.8937333890438, 12.0])
    ops.node(520, *[8.21727680772787, 34.2274211979982, 12.0])
    ops.node(521, *[5.13105045331957, 32.3961775715205, 12.0])
    ops.node(522, *[5.50649316941613, 34.7666295889488, 12.0])
    ops.node(523, *[2.57345833987332, 32.6988885464466, 12.0])
    ops.node(524, *[2.76176016962014, 35.0914901474061, 12.0])
    ops.node(525, *[2.0083544202687e-15, 32.8, 12.0])
    ops.node(526, *[2.15530718272738e-15, 35.2, 12.0])
    ops.node(527, *[-2.57345833987331, 32.6988885464466, 12.0])
    ops.node(528, *[-2.76176016962014, 35.0914901474061, 12.0])
    ops.node(529, *[-5.13105045331958, 32.3961775715205, 12.0])
    ops.node(530, *[-5.50649316941613, 34.7666295889488, 12.0])
    ops.node(531, *[-7.65700793447369, 31.8937333890438, 12.0])
    ops.node(532, *[-8.21727680772786, 34.2274211979982, 12.0])
    ops.node(533, *[-10.1357574154983, 31.194653734481, 12.0])
    ops.node(534, *[-10.8773982019981, 33.4771893735894, 12.0])
    ops.node(535, *[-12.5520165815749, 30.3032486663702, 12.0])
    ops.node(536, *[-13.4704568192512, 32.5205595443973, 12.0])
    ops.node(537, *[-14.8908883914571, 29.2250139933785, 12.0])
    ops.node(538, *[-15.980465590832, 31.3634296514305, 12.0])
    ops.node(539, *[-17.1379529226831, 27.9665973908142, 12.0])
    ops.node(540, *[-18.3919494780014, 30.012933785264, 12.0])
    ops.node(541, *[-19.2793562751931, 26.5357574154983, 12.0])
    ops.node(542, *[-20.690040880695, 28.4773982019981, 12.0])
    ops.node(543, *[-21.30189598523, 24.941315671681, 12.0])
    ops.node(544, *[-22.8605713012225, 26.7662899891211, 12.0])
    ops.node(545, *[-23.1931024229188, 23.1931024229188, 12.0])
    ops.node(546, *[-24.8901586977665, 24.8901586977665, 12.0])
    ops.node(547, *[24.4192466172149, 28.5912643065612, 12.0])
    ops.node(548, *[26.5872149726142, 26.5872149726142, 12.0])
    ops.node(549, *[22.100725486197, 30.419038988498, 12.0])
    ops.node(550, *[19.6459460333197, 32.0592701797139, 12.0])
    ops.node(551, *[17.070042790207, 33.5018453094826, 12.0])
    ops.node(552, *[14.3888970569274, 34.7378704224244, 12.0])
    ops.node(553, *[11.619038988498, 35.7597250126978, 12.0])
    ops.node(554, *[8.77754568098204, 36.5611090069526, 12.0])
    ops.node(555, *[5.88193588551268, 37.1370816063772, 12.0])
    ops.node(556, *[2.95006199936697, 37.4840917483656, 12.0])
    ops.node(557, *[2.30225994518607e-15, 37.6, 12.0])
    ops.node(558, *[-2.95006199936697, 37.4840917483656, 12.0])
    ops.node(559, *[-5.88193588551269, 37.1370816063772, 12.0])
    ops.node(560, *[-8.77754568098203, 36.5611090069526, 12.0])
    ops.node(561, *[-11.619038988498, 35.7597250126978, 12.0])
    ops.node(562, *[-14.3888970569274, 34.7378704224244, 12.0])
    ops.node(563, *[-17.070042790207, 33.5018453094826, 12.0])
    ops.node(564, *[-19.6459460333197, 32.0592701797139, 12.0])
    ops.node(565, *[-22.100725486197, 30.419038988498, 12.0])
    ops.node(566, *[-24.4192466172149, 28.5912643065612, 12.0])
    ops.node(567, *[-26.5872149726142, 26.5872149726142, 12.0])
    ops.node(568, *[25.9779219332073, 30.4162386240012, 12.0])
    ops.node(569, *[28.2842712474619, 28.2842712474619, 12.0])
    ops.node(570, *[23.5114100916989, 32.3606797749979, 12.0])
    ops.node(571, *[20.899942588638, 34.1056065741637, 12.0])
    ops.node(572, *[18.1596199895819, 35.6402609675347, 12.0])
    ops.node(573, *[15.3073372946036, 36.9551813004515, 12.0])
    ops.node(574, *[12.3606797749979, 38.0422606518061, 12.0])
    ops.node(575, *[9.33781455423622, 38.8947968159071, 12.0])
    ops.node(576, *[6.25737860160924, 39.5075336238055, 12.0])
    ops.node(577, *[3.1383638291138, 39.8766933493251, 12.0])
    ops.node(578, *[2.44921270764475e-15, 40.0, 12.0])
    ops.node(579, *[-3.13836382911379, 39.8766933493251, 12.0])
    ops.node(580, *[-6.25737860160924, 39.5075336238055, 12.0])
    ops.node(581, *[-9.3378145542362, 38.8947968159071, 12.0])
    ops.node(582, *[-12.3606797749979, 38.0422606518061, 12.0])
    ops.node(583, *[-15.3073372946036, 36.9551813004515, 12.0])
    ops.node(584, *[-18.1596199895819, 35.6402609675347, 12.0])
    ops.node(585, *[-20.8999425886379, 34.1056065741637, 12.0])
    ops.node(586, *[-23.5114100916989, 32.3606797749979, 12.0])
    ops.node(587, *[-25.9779219332073, 30.4162386240012, 12.0])
    ops.node(588, *[-28.2842712474619, 28.2842712474619, 12.0])
    ops.node(589, *[21.8214544238942, 25.549640444161, 14.0])
    ops.node(590, *[23.758787847868, 23.758787847868, 14.0])
    ops.node(591, *[23.2069435936652, 27.1718398374411, 14.0])
    ops.node(592, *[25.2672823143993, 25.2672823143993, 14.0])
    ops.node(593, *[19.7495844770271, 27.1829710109982, 14.0])
    ops.node(594, *[21.0035263485844, 28.9088739323315, 14.0])
    ops.node(595, *[17.5559517744559, 28.6487095222975, 14.0])
    ops.node(596, *[18.6706153791832, 30.4676752062529, 14.0])
    ops.node(597, *[15.2540807912488, 29.9378192127292, 14.0])
    ops.node(598, *[16.2225938573598, 31.8386331309977, 14.0])
    ops.node(599, *[12.858163327467, 31.0423522923792, 14.0])
    ops.node(600, *[13.6745546498459, 33.01329529507, 14.0])
    ops.node(601, *[10.3829710109982, 31.9554989475172, 14.0])
    ops.node(602, *[11.0422072656648, 33.9844195156135, 14.0])
    ops.node(603, *[7.84376422555842, 32.6716293253619, 14.0])
    ops.node(604, *[8.34178100178435, 34.746018488877, 14.0])
    ops.node(605, *[5.25619802535176, 33.1863282439966, 14.0])
    ops.node(606, *[5.58992488410425, 35.2933967039329, 14.0])
    ops.node(607, *[2.63622561645559, 33.4964224134331, 14.0])
    ops.node(608, *[2.80360502067499, 35.6231793920638, 14.0])
    ops.node(609, *[2.05733867442159e-15, 33.6, 14.0])
    ops.node(610, *[2.18796335216265e-15, 35.7333333333333, 14.0])
    ops.node(611, *[-2.63622561645559, 33.4964224134331, 14.0])
    ops.node(612, *[-2.80360502067499, 35.6231793920638, 14.0])
    ops.node(613, *[-5.25619802535176, 33.1863282439966, 14.0])
    ops.node(614, *[-5.58992488410426, 35.2933967039329, 14.0])
    ops.node(615, *[-7.84376422555841, 32.6716293253619, 14.0])
    ops.node(616, *[-8.34178100178434, 34.746018488877, 14.0])
    ops.node(617, *[-10.3829710109982, 31.9554989475172, 14.0])
    ops.node(618, *[-11.0422072656648, 33.9844195156135, 14.0])
    ops.node(619, *[-12.858163327467, 31.0423522923792, 14.0])
    ops.node(620, *[-13.6745546498459, 33.01329529507, 14.0])
    ops.node(621, *[-15.2540807912488, 29.9378192127292, 14.0])
    ops.node(622, *[-16.2225938573598, 31.8386331309977, 14.0])
    ops.node(623, *[-17.5559517744559, 28.6487095222975, 14.0])
    ops.node(624, *[-18.6706153791832, 30.4676752062529, 14.0])
    ops.node(625, *[-19.7495844770271, 27.1829710109982, 14.0])
    ops.node(626, *[-21.0035263485844, 28.9088739323315, 14.0])
    ops.node(627, *[-21.8214544238942, 25.549640444161, 14.0])
    ops.node(628, *[-23.2069435936652, 27.1718398374411, 14.0])
    ops.node(629, *[-23.758787847868, 23.758787847868, 14.0])
    ops.node(630, *[-25.2672823143993, 25.2672823143993, 14.0])
    ops.node(631, *[24.5924327634363, 28.7940392307212, 14.0])
    ops.node(632, *[26.7757767809306, 26.7757767809306, 14.0])
    ops.node(633, *[22.2574682201417, 30.6347768536647, 14.0])
    ops.node(634, *[19.7852789839106, 32.2866408902083, 14.0])
    ops.node(635, *[17.1911069234708, 33.7394470492662, 14.0])
    ops.node(636, *[14.4909459722247, 34.9842382977607, 14.0])
    ops.node(637, *[11.7014435203313, 36.0133400837098, 14.0])
    ops.node(638, *[8.83979777801029, 36.820407652392, 14.0])
    ops.node(639, *[5.92365174285674, 37.4004651638692, 14.0])
    ops.node(640, *[2.9709844248944, 37.7499363706944, 14.0])
    ops.node(641, *[2.3185880299037e-15, 37.8666666666667, 14.0])
    ops.node(642, *[-2.97098442489439, 37.7499363706944, 14.0])
    ops.node(643, *[-5.92365174285675, 37.4004651638692, 14.0])
    ops.node(644, *[-8.83979777801027, 36.820407652392, 14.0])
    ops.node(645, *[-11.7014435203313, 36.0133400837098, 14.0])
    ops.node(646, *[-14.4909459722247, 34.9842382977607, 14.0])
    ops.node(647, *[-17.1911069234708, 33.7394470492662, 14.0])
    ops.node(648, *[-19.7852789839106, 32.2866408902083, 14.0])
    ops.node(649, *[-22.2574682201416, 30.6347768536647, 14.0])
    ops.node(650, *[-24.5924327634363, 28.7940392307212, 14.0])
    ops.node(651, *[-26.7757767809306, 26.7757767809306, 14.0])
    ops.node(652, *[25.9779219332073, 30.4162386240012, 14.0])
    ops.node(653, *[28.2842712474619, 28.2842712474619, 14.0])
    ops.node(654, *[23.5114100916989, 32.3606797749979, 14.0])
    ops.node(655, *[20.899942588638, 34.1056065741637, 14.0])
    ops.node(656, *[18.1596199895819, 35.6402609675347, 14.0])
    ops.node(657, *[15.3073372946036, 36.9551813004515, 14.0])
    ops.node(658, *[12.3606797749979, 38.0422606518061, 14.0])
    ops.node(659, *[9.33781455423622, 38.8947968159071, 14.0])
    ops.node(660, *[6.25737860160924, 39.5075336238055, 14.0])
    ops.node(661, *[3.1383638291138, 39.8766933493251, 14.0])
    ops.node(662, *[2.44921270764475e-15, 40.0, 14.0])
    ops.node(663, *[-3.13836382911379, 39.8766933493251, 14.0])
    ops.node(664, *[-6.25737860160924, 39.5075336238055, 14.0])
    ops.node(665, *[-9.33781455423621, 38.8947968159071, 14.0])
    ops.node(666, *[-12.3606797749979, 38.0422606518061, 14.0])
    ops.node(667, *[-15.3073372946036, 36.9551813004515, 14.0])
    ops.node(668, *[-18.1596199895819, 35.6402609675347, 14.0])
    ops.node(669, *[-20.899942588638, 34.1056065741637, 14.0])
    ops.node(670, *[-23.5114100916989, 32.3606797749979, 14.0])
    ops.node(671, *[-25.9779219332073, 30.4162386240012, 14.0])
    ops.node(672, *[-28.2842712474619, 28.2842712474619, 14.0])
    ops.node(673, *[22.3410128625583, 26.1579652166411, 16.0])
    ops.node(674, *[24.3244732728172, 24.3244732728172, 16.0])
    ops.node(675, *[23.553315886108, 27.5773896857611, 16.0])
    ops.node(676, *[25.6444059310321, 25.6444059310321, 16.0])
    ops.node(677, *[20.2198126788611, 27.8301846064982, 16.0])
    ops.node(678, *[21.3170118164737, 29.3403496626648, 16.0])
    ops.node(679, *[17.9739506262286, 29.3308216537808, 16.0])
    ops.node(680, *[18.9492812803651, 30.9224166272417, 16.0])
    ops.node(681, *[15.6172731910404, 30.6506244320799, 16.0])
    ops.node(682, *[16.4647221238876, 32.3138366105648, 16.0])
    ops.node(683, *[13.1643100733591, 31.7814559183883, 16.0])
    ops.node(684, *[13.8786524804406, 33.5060310457427, 16.0])
    ops.node(685, *[10.6301846064982, 32.7163441605533, 16.0])
    ops.node(686, *[11.2070163293314, 34.4916496576376, 16.0])
    ops.node(687, *[8.03052051664315, 33.4495252616801, 16.0])
    ops.node(688, *[8.46628519584084, 35.2646157797557, 16.0])
    ops.node(689, *[5.38134559738394, 33.9764789164727, 16.0])
    ops.node(690, *[5.67335659879237, 35.820163818917, 16.0])
    ops.node(691, *[2.69899289303787, 34.2939562804196, 16.0])
    ops.node(692, *[2.84544987172985, 36.1548686367214, 16.0])
    ops.node(693, *[2.10632292857449e-15, 34.4, 16.0])
    ops.node(694, *[2.22061952159791e-15, 36.2666666666667, 16.0])
    ops.node(695, *[-2.69899289303786, 34.2939562804196, 16.0])
    ops.node(696, *[-2.84544987172984, 36.1548686367214, 16.0])
    ops.node(697, *[-5.38134559738395, 33.9764789164727, 16.0])
    ops.node(698, *[-5.67335659879238, 35.820163818917, 16.0])
    ops.node(699, *[-8.03052051664314, 33.4495252616801, 16.0])
    ops.node(700, *[-8.46628519584083, 35.2646157797557, 16.0])
    ops.node(701, *[-10.6301846064982, 32.7163441605533, 16.0])
    ops.node(702, *[-11.2070163293314, 34.4916496576376, 16.0])
    ops.node(703, *[-13.1643100733591, 31.7814559183883, 16.0])
    ops.node(704, *[-13.8786524804406, 33.5060310457427, 16.0])
    ops.node(705, *[-15.6172731910404, 30.6506244320799, 16.0])
    ops.node(706, *[-16.4647221238876, 32.3138366105648, 16.0])
    ops.node(707, *[-17.9739506262286, 29.3308216537808, 16.0])
    ops.node(708, *[-18.9492812803651, 30.9224166272417, 16.0])
    ops.node(709, *[-20.2198126788611, 27.8301846064982, 16.0])
    ops.node(710, *[-21.3170118164737, 29.3403496626648, 16.0])
    ops.node(711, *[-22.3410128625583, 26.1579652166411, 16.0])
    ops.node(712, *[-23.553315886108, 27.5773896857611, 16.0])
    ops.node(713, *[-24.3244732728172, 24.3244732728172, 16.0])
    ops.node(714, *[-25.6444059310321, 25.6444059310321, 16.0])
    ops.node(715, *[24.7656189096577, 28.9968141548812, 16.0])
    ops.node(716, *[26.964338589247, 26.964338589247, 16.0])
    ops.node(717, *[22.4142109540863, 30.8505147188313, 16.0])
    ops.node(718, *[19.9246119345015, 32.5140116007027, 16.0])
    ops.node(719, *[17.3121710567347, 33.9770487890498, 16.0])
    ops.node(720, *[14.5929948875221, 35.2306061730971, 16.0])
    ops.node(721, *[11.7838480521647, 36.2669551547219, 16.0])
    ops.node(722, *[8.90204987503853, 37.0797062978314, 16.0])
    ops.node(723, *[5.96536760020081, 37.6638487213613, 16.0])
    ops.node(724, *[2.99190685042182, 38.0157809930233, 16.0])
    ops.node(725, *[2.33491611462133e-15, 38.1333333333333, 16.0])
    ops.node(726, *[-2.99190685042182, 38.0157809930233, 16.0])
    ops.node(727, *[-5.96536760020081, 37.6638487213612, 16.0])
    ops.node(728, *[-8.90204987503851, 37.0797062978314, 16.0])
    ops.node(729, *[-11.7838480521647, 36.2669551547219, 16.0])
    ops.node(730, *[-14.5929948875221, 35.2306061730971, 16.0])
    ops.node(731, *[-17.3121710567347, 33.9770487890498, 16.0])
    ops.node(732, *[-19.9246119345015, 32.5140116007027, 16.0])
    ops.node(733, *[-22.4142109540863, 30.8505147188313, 16.0])
    ops.node(734, *[-24.7656189096577, 28.9968141548812, 16.0])
    ops.node(735, *[-26.964338589247, 26.964338589247, 16.0])
    ops.node(736, *[25.9779219332073, 30.4162386240012, 16.0])
    ops.node(737, *[28.2842712474619, 28.2842712474619, 16.0])
    ops.node(738, *[23.5114100916989, 32.3606797749979, 16.0])
    ops.node(739, *[20.899942588638, 34.1056065741637, 16.0])
    ops.node(740, *[18.1596199895819, 35.6402609675347, 16.0])
    ops.node(741, *[15.3073372946036, 36.9551813004515, 16.0])
    ops.node(742, *[12.3606797749979, 38.0422606518061, 16.0])
    ops.node(743, *[9.33781455423622, 38.8947968159071, 16.0])
    ops.node(744, *[6.25737860160924, 39.5075336238055, 16.0])
    ops.node(745, *[3.1383638291138, 39.8766933493251, 16.0])
    ops.node(746, *[2.44921270764475e-15, 40.0, 16.0])
    ops.node(747, *[-3.13836382911379, 39.8766933493251, 16.0])
    ops.node(748, *[-6.25737860160924, 39.5075336238055, 16.0])
    ops.node(749, *[-9.33781455423621, 38.8947968159071, 16.0])
    ops.node(750, *[-12.3606797749979, 38.0422606518061, 16.0])
    ops.node(751, *[-15.3073372946036, 36.9551813004515, 16.0])
    ops.node(752, *[-18.1596199895819, 35.6402609675347, 16.0])
    ops.node(753, *[-20.899942588638, 34.1056065741637, 16.0])
    ops.node(754, *[-23.5114100916989, 32.3606797749979, 16.0])
    ops.node(755, *[-25.9779219332073, 30.4162386240012, 16.0])
    ops.node(756, *[-28.2842712474619, 28.2842712474619, 16.0])
    ops.node(757, *[22.8605713012225, 26.7662899891211, 18.0])
    ops.node(758, *[24.8901586977665, 24.8901586977665, 18.0])
    ops.node(759, *[23.8996881785508, 27.9829395340811, 18.0])
    ops.node(760, *[26.021529547665, 26.021529547665, 18.0])
    ops.node(761, *[20.6900408806951, 28.4773982019982, 18.0])
    ops.node(762, *[21.630497284363, 29.7718253929981, 18.0])
    ops.node(763, *[18.3919494780014, 30.012933785264, 18.0])
    ops.node(764, *[19.2279471815469, 31.3771580482306, 18.0])
    ops.node(765, *[15.980465590832, 31.3634296514306, 18.0])
    ops.node(766, *[16.7068503904153, 32.7890400901319, 18.0])
    ops.node(767, *[13.4704568192512, 32.5205595443973, 18.0])
    ops.node(768, *[14.0827503110353, 33.9987667964154, 18.0])
    ops.node(769, *[10.8773982019982, 33.4771893735894, 18.0])
    ops.node(770, *[11.3718253929981, 34.9988797996617, 18.0])
    ops.node(771, *[8.21727680772787, 34.2274211979982, 18.0])
    ops.node(772, *[8.59078938989732, 35.7832130706345, 18.0])
    ops.node(773, *[5.50649316941613, 34.7666295889489, 18.0])
    ops.node(774, *[5.7567883134805, 36.3469309339011, 18.0])
    ops.node(775, *[2.76176016962014, 35.0914901474061, 18.0])
    ops.node(776, *[2.8872947227847, 36.6865578813791, 18.0])
    ops.node(777, *[2.15530718272738e-15, 35.2, 18.0])
    ops.node(778, *[2.25327569103317e-15, 36.8, 18.0])
    ops.node(779, *[-2.76176016962014, 35.0914901474061, 18.0])
    ops.node(780, *[-2.88729472278469, 36.6865578813791, 18.0])
    ops.node(781, *[-5.50649316941613, 34.7666295889488, 18.0])
    ops.node(782, *[-5.7567883134805, 36.3469309339011, 18.0])
    ops.node(783, *[-8.21727680772786, 34.2274211979982, 18.0])
    ops.node(784, *[-8.59078938989731, 35.7832130706345, 18.0])
    ops.node(785, *[-10.8773982019981, 33.4771893735894, 18.0])
    ops.node(786, *[-11.3718253929981, 34.9988797996617, 18.0])
    ops.node(787, *[-13.4704568192512, 32.5205595443973, 18.0])
    ops.node(788, *[-14.0827503110353, 33.9987667964154, 18.0])
    ops.node(789, *[-15.980465590832, 31.3634296514306, 18.0])
    ops.node(790, *[-16.7068503904153, 32.7890400901319, 18.0])
    ops.node(791, *[-18.3919494780014, 30.012933785264, 18.0])
    ops.node(792, *[-19.2279471815469, 31.3771580482306, 18.0])
    ops.node(793, *[-20.6900408806951, 28.4773982019982, 18.0])
    ops.node(794, *[-21.630497284363, 29.7718253929981, 18.0])
    ops.node(795, *[-22.8605713012225, 26.7662899891211, 18.0])
    ops.node(796, *[-23.8996881785508, 27.9829395340811, 18.0])
    ops.node(797, *[-24.8901586977665, 24.8901586977665, 18.0])
    ops.node(798, *[-26.021529547665, 26.021529547665, 18.0])
    ops.node(799, *[24.9388050558791, 29.1995890790412, 18.0])
    ops.node(800, *[27.1529003975634, 27.1529003975634, 18.0])
    ops.node(801, *[22.570953688031, 31.066252583998, 18.0])
    ops.node(802, *[20.0639448850924, 32.7413823111971, 18.0])
    ops.node(803, *[17.4332351899986, 34.2146505288333, 18.0])
    ops.node(804, *[14.6950438028195, 35.4769740484334, 18.0])
    ops.node(805, *[11.866252583998, 36.5205702257339, 18.0])
    ops.node(806, *[8.96430197206677, 37.3390049432708, 18.0])
    ops.node(807, *[6.00708345754487, 37.9272322788533, 18.0])
    ops.node(808, *[3.01282927594925, 38.2816256153521, 18.0])
    ops.node(809, *[2.35124419933896e-15, 38.4, 18.0])
    ops.node(810, *[-3.01282927594924, 38.2816256153521, 18.0])
    ops.node(811, *[-6.00708345754487, 37.9272322788533, 18.0])
    ops.node(812, *[-8.96430197206676, 37.3390049432708, 18.0])
    ops.node(813, *[-11.866252583998, 36.5205702257339, 18.0])
    ops.node(814, *[-14.6950438028194, 35.4769740484334, 18.0])
    ops.node(815, *[-17.4332351899986, 34.2146505288333, 18.0])
    ops.node(816, *[-20.0639448850924, 32.7413823111971, 18.0])
    ops.node(817, *[-22.570953688031, 31.066252583998, 18.0])
    ops.node(818, *[-24.9388050558791, 29.1995890790412, 18.0])
    ops.node(819, *[-27.1529003975634, 27.1529003975634, 18.0])
    ops.node(820, *[25.9779219332073, 30.4162386240012, 18.0])
    ops.node(821, *[28.2842712474619, 28.2842712474619, 18.0])
    ops.node(822, *[23.5114100916989, 32.3606797749979, 18.0])
    ops.node(823, *[20.899942588638, 34.1056065741637, 18.0])
    ops.node(824, *[18.1596199895819, 35.6402609675347, 18.0])
    ops.node(825, *[15.3073372946036, 36.9551813004515, 18.0])
    ops.node(826, *[12.3606797749979, 38.0422606518061, 18.0])
    ops.node(827, *[9.33781455423622, 38.8947968159071, 18.0])
    ops.node(828, *[6.25737860160924, 39.5075336238055, 18.0])
    ops.node(829, *[3.1383638291138, 39.8766933493251, 18.0])
    ops.node(830, *[2.44921270764475e-15, 40.0, 18.0])
    ops.node(831, *[-3.1383638291138, 39.8766933493251, 18.0])
    ops.node(832, *[-6.25737860160924, 39.5075336238055, 18.0])
    ops.node(833, *[-9.33781455423621, 38.8947968159071, 18.0])
    ops.node(834, *[-12.3606797749979, 38.0422606518062, 18.0])
    ops.node(835, *[-15.3073372946036, 36.9551813004515, 18.0])
    ops.node(836, *[-18.1596199895819, 35.6402609675347, 18.0])
    ops.node(837, *[-20.899942588638, 34.1056065741637, 18.0])
    ops.node(838, *[-23.5114100916989, 32.3606797749979, 18.0])
    ops.node(839, *[-25.9779219332073, 30.4162386240012, 18.0])
    ops.node(840, *[-28.2842712474619, 28.2842712474619, 18.0])
    ops.node(841, *[23.3801297398866, 27.3746147616011, 20.0])
    ops.node(842, *[25.4558441227157, 25.4558441227157, 20.0])
    ops.node(843, *[24.2460604709935, 28.3884893824012, 20.0])
    ops.node(844, *[26.3986531642978, 26.3986531642978, 20.0])
    ops.node(845, *[21.160269082529, 29.1246117974981, 20.0])
    ops.node(846, *[21.9439827522523, 30.2033011233314, 20.0])
    ops.node(847, *[18.8099483297742, 30.6950459167473, 20.0])
    ops.node(848, *[19.5066130827288, 31.8318994692194, 20.0])
    ops.node(849, *[16.3436579906237, 32.0762348707812, 20.0])
    ops.node(850, *[16.9489786569431, 33.2642435696991, 20.0])
    ops.node(851, *[13.7766035651432, 33.2596631704063, 20.0])
    ops.node(852, *[14.28684814163, 34.491502547088, 20.0])
    ops.node(853, *[11.1246117974981, 34.2380345866255, 20.0])
    ops.node(854, *[11.5366344566647, 35.5061099416857, 20.0])
    ops.node(855, *[8.4040330988126, 35.0053171343164, 20.0])
    ops.node(856, *[8.71529358395381, 36.3018103615133, 20.0])
    ops.node(857, *[5.63164074144831, 35.556780261425, 20.0])
    ops.node(858, *[5.84022002816862, 36.8736980488851, 20.0])
    ops.node(859, *[2.82452744620242, 35.8890240143926, 20.0])
    ops.node(860, *[2.92913957383955, 37.2182471260368, 20.0])
    ops.node(861, *[2.20429143688028e-15, 36.0, 20.0])
    ops.node(862, *[2.28593186046844e-15, 37.3333333333333, 20.0])
    ops.node(863, *[-2.82452744620242, 35.8890240143926, 20.0])
    ops.node(864, *[-2.92913957383954, 37.2182471260368, 20.0])
    ops.node(865, *[-5.63164074144832, 35.556780261425, 20.0])
    ops.node(866, *[-5.84022002816863, 36.8736980488851, 20.0])
    ops.node(867, *[-8.40403309881258, 35.0053171343164, 20.0])
    ops.node(868, *[-8.71529358395379, 36.3018103615133, 20.0])
    ops.node(869, *[-11.1246117974981, 34.2380345866255, 20.0])
    ops.node(870, *[-11.5366344566647, 35.5061099416857, 20.0])
    ops.node(871, *[-13.7766035651432, 33.2596631704063, 20.0])
    ops.node(872, *[-14.28684814163, 34.491502547088, 20.0])
    ops.node(873, *[-16.3436579906237, 32.0762348707812, 20.0])
    ops.node(874, *[-16.9489786569431, 33.2642435696991, 20.0])
    ops.node(875, *[-18.8099483297742, 30.6950459167473, 20.0])
    ops.node(876, *[-19.5066130827288, 31.8318994692194, 20.0])
    ops.node(877, *[-21.160269082529, 29.1246117974981, 20.0])
    ops.node(878, *[-21.9439827522523, 30.2033011233314, 20.0])
    ops.node(879, *[-23.3801297398866, 27.3746147616011, 20.0])
    ops.node(880, *[-24.2460604709935, 28.3884893824012, 20.0])
    ops.node(881, *[-25.4558441227157, 25.4558441227157, 20.0])
    ops.node(882, *[-26.3986531642978, 26.3986531642978, 20.0])
    ops.node(883, *[25.1119912021004, 29.4023640032012, 20.0])
    ops.node(884, *[27.3414622058798, 27.3414622058798, 20.0])
    ops.node(885, *[22.7276964219756, 31.2819904491646, 20.0])
    ops.node(886, *[20.2032778356834, 32.9687530216916, 20.0])
    ops.node(887, *[17.5542993232625, 34.4522522686169, 20.0])
    ops.node(888, *[14.7970927181168, 35.7233419237698, 20.0])
    ops.node(889, *[11.9486571158313, 36.7741852967459, 20.0])
    ops.node(890, *[9.02655406909501, 37.5983035887102, 20.0])
    ops.node(891, *[6.04879931488893, 38.1906158363453, 20.0])
    ops.node(892, *[3.03375170147667, 38.547470237681, 20.0])
    ops.node(893, *[2.3675722840566e-15, 38.6666666666667, 20.0])
    ops.node(894, *[-3.03375170147667, 38.547470237681, 20.0])
    ops.node(895, *[-6.04879931488893, 38.1906158363453, 20.0])
    ops.node(896, *[-9.026554069095, 37.5983035887102, 20.0])
    ops.node(897, *[-11.9486571158313, 36.7741852967459, 20.0])
    ops.node(898, *[-14.7970927181168, 35.7233419237698, 20.0])
    ops.node(899, *[-17.5542993232625, 34.4522522686169, 20.0])
    ops.node(900, *[-20.2032778356834, 32.9687530216916, 20.0])
    ops.node(901, *[-22.7276964219756, 31.2819904491646, 20.0])
    ops.node(902, *[-25.1119912021004, 29.4023640032012, 20.0])
    ops.node(903, *[-27.3414622058798, 27.3414622058798, 20.0])
    ops.node(904, *[25.9779219332073, 30.4162386240012, 20.0])
    ops.node(905, *[28.2842712474619, 28.2842712474619, 20.0])
    ops.node(906, *[23.5114100916989, 32.3606797749979, 20.0])
    ops.node(907, *[20.899942588638, 34.1056065741637, 20.0])
    ops.node(908, *[18.1596199895819, 35.6402609675347, 20.0])
    ops.node(909, *[15.3073372946036, 36.9551813004515, 20.0])
    ops.node(910, *[12.3606797749979, 38.0422606518061, 20.0])
    ops.node(911, *[9.33781455423622, 38.8947968159071, 20.0])
    ops.node(912, *[6.25737860160924, 39.5075336238055, 20.0])
    ops.node(913, *[3.1383638291138, 39.8766933493251, 20.0])
    ops.node(914, *[2.44921270764475e-15, 40.0, 20.0])
    ops.node(915, *[-3.13836382911379, 39.8766933493251, 20.0])
    ops.node(916, *[-6.25737860160924, 39.5075336238055, 20.0])
    ops.node(917, *[-9.33781455423621, 38.8947968159071, 20.0])
    ops.node(918, *[-12.3606797749979, 38.0422606518061, 20.0])
    ops.node(919, *[-15.3073372946036, 36.9551813004515, 20.0])
    ops.node(920, *[-18.1596199895819, 35.6402609675347, 20.0])
    ops.node(921, *[-20.899942588638, 34.1056065741637, 20.0])
    ops.node(922, *[-23.5114100916989, 32.3606797749979, 20.0])
    ops.node(923, *[-25.9779219332073, 30.4162386240012, 20.0])
    ops.node(924, *[-28.2842712474619, 28.2842712474619, 20.0])
    ops.node(925, *[23.3801297398866, 27.3746147616011, 22.0])
    ops.node(926, *[25.4558441227157, 25.4558441227157, 22.0])
    ops.node(927, *[24.2460604709935, 28.3884893824012, 22.0])
    ops.node(928, *[26.3986531642978, 26.3986531642978, 22.0])
    ops.node(929, *[21.160269082529, 29.1246117974981, 22.0])
    ops.node(930, *[21.9439827522523, 30.2033011233314, 22.0])
    ops.node(931, *[18.8099483297742, 30.6950459167473, 22.0])
    ops.node(932, *[19.5066130827288, 31.8318994692194, 22.0])
    ops.node(933, *[16.3436579906237, 32.0762348707812, 22.0])
    ops.node(934, *[16.9489786569431, 33.2642435696991, 22.0])
    ops.node(935, *[13.7766035651432, 33.2596631704063, 22.0])
    ops.node(936, *[14.28684814163, 34.491502547088, 22.0])
    ops.node(937, *[11.1246117974981, 34.2380345866255, 22.0])
    ops.node(938, *[11.5366344566647, 35.5061099416857, 22.0])
    ops.node(939, *[8.4040330988126, 35.0053171343164, 22.0])
    ops.node(940, *[8.71529358395381, 36.3018103615133, 22.0])
    ops.node(941, *[5.63164074144831, 35.556780261425, 22.0])
    ops.node(942, *[5.84022002816862, 36.8736980488851, 22.0])
    ops.node(943, *[2.82452744620242, 35.8890240143926, 22.0])
    ops.node(944, *[2.92913957383955, 37.2182471260368, 22.0])
    ops.node(945, *[2.20429143688028e-15, 36.0, 22.0])
    ops.node(946, *[2.28593186046844e-15, 37.3333333333333, 22.0])
    ops.node(947, *[-2.82452744620242, 35.8890240143926, 22.0])
    ops.node(948, *[-2.92913957383954, 37.2182471260368, 22.0])
    ops.node(949, *[-5.63164074144832, 35.556780261425, 22.0])
    ops.node(950, *[-5.84022002816863, 36.8736980488851, 22.0])
    ops.node(951, *[-8.40403309881258, 35.0053171343164, 22.0])
    ops.node(952, *[-8.71529358395379, 36.3018103615133, 22.0])
    ops.node(953, *[-11.1246117974981, 34.2380345866255, 22.0])
    ops.node(954, *[-11.5366344566647, 35.5061099416857, 22.0])
    ops.node(955, *[-13.7766035651432, 33.2596631704063, 22.0])
    ops.node(956, *[-14.28684814163, 34.491502547088, 22.0])
    ops.node(957, *[-16.3436579906237, 32.0762348707812, 22.0])
    ops.node(958, *[-16.9489786569431, 33.2642435696991, 22.0])
    ops.node(959, *[-18.8099483297742, 30.6950459167473, 22.0])
    ops.node(960, *[-19.5066130827288, 31.8318994692194, 22.0])
    ops.node(961, *[-21.160269082529, 29.1246117974981, 22.0])
    ops.node(962, *[-21.9439827522523, 30.2033011233314, 22.0])
    ops.node(963, *[-23.3801297398866, 27.3746147616011, 22.0])
    ops.node(964, *[-24.2460604709935, 28.3884893824012, 22.0])
    ops.node(965, *[-25.4558441227157, 25.4558441227157, 22.0])
    ops.node(966, *[-26.3986531642978, 26.3986531642978, 22.0])
    ops.node(967, *[25.1119912021004, 29.4023640032012, 22.0])
    ops.node(968, *[27.3414622058798, 27.3414622058798, 22.0])
    ops.node(969, *[22.7276964219756, 31.2819904491646, 22.0])
    ops.node(970, *[20.2032778356834, 32.9687530216916, 22.0])
    ops.node(971, *[17.5542993232625, 34.4522522686169, 22.0])
    ops.node(972, *[14.7970927181168, 35.7233419237698, 22.0])
    ops.node(973, *[11.9486571158313, 36.7741852967459, 22.0])
    ops.node(974, *[9.02655406909501, 37.5983035887102, 22.0])
    ops.node(975, *[6.04879931488893, 38.1906158363453, 22.0])
    ops.node(976, *[3.03375170147667, 38.547470237681, 22.0])
    ops.node(977, *[2.3675722840566e-15, 38.6666666666667, 22.0])
    ops.node(978, *[-3.03375170147667, 38.547470237681, 22.0])
    ops.node(979, *[-6.04879931488893, 38.1906158363453, 22.0])
    ops.node(980, *[-9.026554069095, 37.5983035887102, 22.0])
    ops.node(981, *[-11.9486571158313, 36.7741852967459, 22.0])
    ops.node(982, *[-14.7970927181168, 35.7233419237698, 22.0])
    ops.node(983, *[-17.5542993232625, 34.4522522686169, 22.0])
    ops.node(984, *[-20.2032778356834, 32.9687530216916, 22.0])
    ops.node(985, *[-22.7276964219756, 31.2819904491646, 22.0])
    ops.node(986, *[-25.1119912021004, 29.4023640032012, 22.0])
    ops.node(987, *[-27.3414622058798, 27.3414622058798, 22.0])
    ops.node(988, *[25.9779219332073, 30.4162386240012, 22.0])
    ops.node(989, *[28.2842712474619, 28.2842712474619, 22.0])
    ops.node(990, *[23.5114100916989, 32.3606797749979, 22.0])
    ops.node(991, *[20.899942588638, 34.1056065741637, 22.0])
    ops.node(992, *[18.1596199895819, 35.6402609675347, 22.0])
    ops.node(993, *[15.3073372946036, 36.9551813004515, 22.0])
    ops.node(994, *[12.3606797749979, 38.0422606518061, 22.0])
    ops.node(995, *[9.33781455423622, 38.8947968159071, 22.0])
    ops.node(996, *[6.25737860160924, 39.5075336238055, 22.0])
    ops.node(997, *[3.1383638291138, 39.8766933493251, 22.0])
    ops.node(998, *[2.44921270764475e-15, 40.0, 22.0])
    ops.node(999, *[-3.13836382911379, 39.8766933493251, 22.0])
    ops.node(1000, *[-6.25737860160924, 39.5075336238055, 22.0])
    ops.node(1001, *[-9.33781455423621, 38.8947968159071, 22.0])
    ops.node(1002, *[-12.3606797749979, 38.0422606518061, 22.0])
    ops.node(1003, *[-15.3073372946036, 36.9551813004515, 22.0])
    ops.node(1004, *[-18.1596199895819, 35.6402609675347, 22.0])
    ops.node(1005, *[-20.899942588638, 34.1056065741637, 22.0])
    ops.node(1006, *[-23.5114100916989, 32.3606797749979, 22.0])
    ops.node(1007, *[-25.9779219332073, 30.4162386240012, 22.0])
    ops.node(1008, *[-28.2842712474619, 28.2842712474619, 22.0])
    ops.node(1009, *[23.3801297398866, 27.3746147616011, 24.0])
    ops.node(1010, *[25.4558441227157, 25.4558441227157, 24.0])
    ops.node(1011, *[24.2460604709935, 28.3884893824012, 24.0])
    ops.node(1012, *[26.3986531642978, 26.3986531642978, 24.0])
    ops.node(1013, *[21.160269082529, 29.1246117974981, 24.0])
    ops.node(1014, *[21.9439827522523, 30.2033011233314, 24.0])
    ops.node(1015, *[18.8099483297742, 30.6950459167473, 24.0])
    ops.node(1016, *[19.5066130827288, 31.8318994692194, 24.0])
    ops.node(1017, *[16.3436579906237, 32.0762348707812, 24.0])
    ops.node(1018, *[16.9489786569431, 33.2642435696991, 24.0])
    ops.node(1019, *[13.7766035651432, 33.2596631704063, 24.0])
    ops.node(1020, *[14.28684814163, 34.491502547088, 24.0])
    ops.node(1021, *[11.1246117974981, 34.2380345866255, 24.0])
    ops.node(1022, *[11.5366344566647, 35.5061099416857, 24.0])
    ops.node(1023, *[8.4040330988126, 35.0053171343164, 24.0])
    ops.node(1024, *[8.71529358395381, 36.3018103615133, 24.0])
    ops.node(1025, *[5.63164074144831, 35.556780261425, 24.0])
    ops.node(1026, *[5.84022002816862, 36.8736980488851, 24.0])
    ops.node(1027, *[2.82452744620242, 35.8890240143926, 24.0])
    ops.node(1028, *[2.92913957383955, 37.2182471260368, 24.0])
    ops.node(1029, *[2.20429143688028e-15, 36.0, 24.0])
    ops.node(1030, *[2.28593186046844e-15, 37.3333333333333, 24.0])
    ops.node(1031, *[-2.82452744620242, 35.8890240143926, 24.0])
    ops.node(1032, *[-2.92913957383954, 37.2182471260368, 24.0])
    ops.node(1033, *[-5.63164074144832, 35.556780261425, 24.0])
    ops.node(1034, *[-5.84022002816863, 36.8736980488851, 24.0])
    ops.node(1035, *[-8.40403309881258, 35.0053171343164, 24.0])
    ops.node(1036, *[-8.71529358395379, 36.3018103615133, 24.0])
    ops.node(1037, *[-11.1246117974981, 34.2380345866255, 24.0])
    ops.node(1038, *[-11.5366344566647, 35.5061099416857, 24.0])
    ops.node(1039, *[-13.7766035651432, 33.2596631704063, 24.0])
    ops.node(1040, *[-14.28684814163, 34.491502547088, 24.0])
    ops.node(1041, *[-16.3436579906237, 32.0762348707812, 24.0])
    ops.node(1042, *[-16.9489786569431, 33.2642435696991, 24.0])
    ops.node(1043, *[-18.8099483297742, 30.6950459167473, 24.0])
    ops.node(1044, *[-19.5066130827288, 31.8318994692194, 24.0])
    ops.node(1045, *[-21.160269082529, 29.1246117974981, 24.0])
    ops.node(1046, *[-21.9439827522523, 30.2033011233314, 24.0])
    ops.node(1047, *[-23.3801297398866, 27.3746147616011, 24.0])
    ops.node(1048, *[-24.2460604709935, 28.3884893824012, 24.0])
    ops.node(1049, *[-25.4558441227157, 25.4558441227157, 24.0])
    ops.node(1050, *[-26.3986531642978, 26.3986531642978, 24.0])
    ops.node(1051, *[25.1119912021004, 29.4023640032012, 24.0])
    ops.node(1052, *[27.3414622058798, 27.3414622058798, 24.0])
    ops.node(1053, *[22.7276964219756, 31.2819904491646, 24.0])
    ops.node(1054, *[20.2032778356834, 32.9687530216916, 24.0])
    ops.node(1055, *[17.5542993232625, 34.4522522686169, 24.0])
    ops.node(1056, *[14.7970927181168, 35.7233419237698, 24.0])
    ops.node(1057, *[11.9486571158313, 36.7741852967459, 24.0])
    ops.node(1058, *[9.02655406909501, 37.5983035887102, 24.0])
    ops.node(1059, *[6.04879931488893, 38.1906158363453, 24.0])
    ops.node(1060, *[3.03375170147667, 38.547470237681, 24.0])
    ops.node(1061, *[2.3675722840566e-15, 38.6666666666667, 24.0])
    ops.node(1062, *[-3.03375170147667, 38.547470237681, 24.0])
    ops.node(1063, *[-6.04879931488893, 38.1906158363453, 24.0])
    ops.node(1064, *[-9.026554069095, 37.5983035887102, 24.0])
    ops.node(1065, *[-11.9486571158313, 36.7741852967459, 24.0])
    ops.node(1066, *[-14.7970927181168, 35.7233419237698, 24.0])
    ops.node(1067, *[-17.5542993232625, 34.4522522686169, 24.0])
    ops.node(1068, *[-20.2032778356834, 32.9687530216916, 24.0])
    ops.node(1069, *[-22.7276964219756, 31.2819904491646, 24.0])
    ops.node(1070, *[-25.1119912021004, 29.4023640032012, 24.0])
    ops.node(1071, *[-27.3414622058798, 27.3414622058798, 24.0])
    ops.node(1072, *[25.9779219332073, 30.4162386240012, 24.0])
    ops.node(1073, *[28.2842712474619, 28.2842712474619, 24.0])
    ops.node(1074, *[23.5114100916989, 32.3606797749979, 24.0])
    ops.node(1075, *[20.899942588638, 34.1056065741637, 24.0])
    ops.node(1076, *[18.1596199895819, 35.6402609675347, 24.0])
    ops.node(1077, *[15.3073372946036, 36.9551813004515, 24.0])
    ops.node(1078, *[12.3606797749979, 38.0422606518061, 24.0])
    ops.node(1079, *[9.33781455423622, 38.8947968159071, 24.0])
    ops.node(1080, *[6.25737860160924, 39.5075336238055, 24.0])
    ops.node(1081, *[3.1383638291138, 39.8766933493251, 24.0])
    ops.node(1082, *[2.44921270764475e-15, 40.0, 24.0])
    ops.node(1083, *[-3.13836382911379, 39.8766933493251, 24.0])
    ops.node(1084, *[-6.25737860160924, 39.5075336238055, 24.0])
    ops.node(1085, *[-9.33781455423621, 38.8947968159071, 24.0])
    ops.node(1086, *[-12.3606797749979, 38.0422606518061, 24.0])
    ops.node(1087, *[-15.3073372946036, 36.9551813004515, 24.0])
    ops.node(1088, *[-18.1596199895819, 35.6402609675347, 24.0])
    ops.node(1089, *[-20.899942588638, 34.1056065741637, 24.0])
    ops.node(1090, *[-23.5114100916989, 32.3606797749979, 24.0])
    ops.node(1091, *[-25.9779219332073, 30.4162386240012, 24.0])
    ops.node(1092, *[-28.2842712474619, 28.2842712474619, 24.0])
    ops.node(1093, *[23.3801297398866, 27.3746147616011, 26.0])
    ops.node(1094, *[25.4558441227157, 25.4558441227157, 26.0])
    ops.node(1095, *[24.2460604709935, 28.3884893824012, 26.0])
    ops.node(1096, *[26.3986531642978, 26.3986531642978, 26.0])
    ops.node(1097, *[21.160269082529, 29.1246117974981, 26.0])
    ops.node(1098, *[21.9439827522523, 30.2033011233314, 26.0])
    ops.node(1099, *[18.8099483297742, 30.6950459167473, 26.0])
    ops.node(1100, *[19.5066130827288, 31.8318994692194, 26.0])
    ops.node(1101, *[16.3436579906237, 32.0762348707812, 26.0])
    ops.node(1102, *[16.9489786569431, 33.2642435696991, 26.0])
    ops.node(1103, *[13.7766035651432, 33.2596631704063, 26.0])
    ops.node(1104, *[14.28684814163, 34.491502547088, 26.0])
    ops.node(1105, *[11.1246117974981, 34.2380345866255, 26.0])
    ops.node(1106, *[11.5366344566647, 35.5061099416857, 26.0])
    ops.node(1107, *[8.4040330988126, 35.0053171343164, 26.0])
    ops.node(1108, *[8.71529358395381, 36.3018103615133, 26.0])
    ops.node(1109, *[5.63164074144831, 35.556780261425, 26.0])
    ops.node(1110, *[5.84022002816862, 36.8736980488851, 26.0])
    ops.node(1111, *[2.82452744620242, 35.8890240143926, 26.0])
    ops.node(1112, *[2.92913957383955, 37.2182471260368, 26.0])
    ops.node(1113, *[2.20429143688028e-15, 36.0, 26.0])
    ops.node(1114, *[2.28593186046844e-15, 37.3333333333333, 26.0])
    ops.node(1115, *[-2.82452744620242, 35.8890240143926, 26.0])
    ops.node(1116, *[-2.92913957383954, 37.2182471260368, 26.0])
    ops.node(1117, *[-5.63164074144832, 35.556780261425, 26.0])
    ops.node(1118, *[-5.84022002816863, 36.8736980488851, 26.0])
    ops.node(1119, *[-8.40403309881258, 35.0053171343164, 26.0])
    ops.node(1120, *[-8.71529358395379, 36.3018103615133, 26.0])
    ops.node(1121, *[-11.1246117974981, 34.2380345866255, 26.0])
    ops.node(1122, *[-11.5366344566647, 35.5061099416857, 26.0])
    ops.node(1123, *[-13.7766035651432, 33.2596631704063, 26.0])
    ops.node(1124, *[-14.28684814163, 34.491502547088, 26.0])
    ops.node(1125, *[-16.3436579906237, 32.0762348707812, 26.0])
    ops.node(1126, *[-16.9489786569431, 33.2642435696991, 26.0])
    ops.node(1127, *[-18.8099483297742, 30.6950459167473, 26.0])
    ops.node(1128, *[-19.5066130827288, 31.8318994692194, 26.0])
    ops.node(1129, *[-21.160269082529, 29.1246117974981, 26.0])
    ops.node(1130, *[-21.9439827522523, 30.2033011233314, 26.0])
    ops.node(1131, *[-23.3801297398866, 27.3746147616011, 26.0])
    ops.node(1132, *[-24.2460604709935, 28.3884893824012, 26.0])
    ops.node(1133, *[-25.4558441227157, 25.4558441227157, 26.0])
    ops.node(1134, *[-26.3986531642978, 26.3986531642978, 26.0])
    ops.node(1135, *[25.1119912021004, 29.4023640032012, 26.0])
    ops.node(1136, *[27.3414622058798, 27.3414622058798, 26.0])
    ops.node(1137, *[22.7276964219756, 31.2819904491646, 26.0])
    ops.node(1138, *[20.2032778356834, 32.9687530216916, 26.0])
    ops.node(1139, *[17.5542993232625, 34.4522522686169, 26.0])
    ops.node(1140, *[14.7970927181168, 35.7233419237698, 26.0])
    ops.node(1141, *[11.9486571158313, 36.7741852967459, 26.0])
    ops.node(1142, *[9.02655406909501, 37.5983035887102, 26.0])
    ops.node(1143, *[6.04879931488893, 38.1906158363453, 26.0])
    ops.node(1144, *[3.03375170147667, 38.547470237681, 26.0])
    ops.node(1145, *[2.3675722840566e-15, 38.6666666666667, 26.0])
    ops.node(1146, *[-3.03375170147667, 38.547470237681, 26.0])
    ops.node(1147, *[-6.04879931488893, 38.1906158363453, 26.0])
    ops.node(1148, *[-9.026554069095, 37.5983035887102, 26.0])
    ops.node(1149, *[-11.9486571158313, 36.7741852967459, 26.0])
    ops.node(1150, *[-14.7970927181168, 35.7233419237698, 26.0])
    ops.node(1151, *[-17.5542993232625, 34.4522522686169, 26.0])
    ops.node(1152, *[-20.2032778356834, 32.9687530216916, 26.0])
    ops.node(1153, *[-22.7276964219756, 31.2819904491646, 26.0])
    ops.node(1154, *[-25.1119912021004, 29.4023640032012, 26.0])
    ops.node(1155, *[-27.3414622058798, 27.3414622058798, 26.0])
    ops.node(1156, *[25.9779219332073, 30.4162386240012, 26.0])
    ops.node(1157, *[28.2842712474619, 28.2842712474619, 26.0])
    ops.node(1158, *[23.5114100916989, 32.3606797749979, 26.0])
    ops.node(1159, *[20.899942588638, 34.1056065741637, 26.0])
    ops.node(1160, *[18.1596199895819, 35.6402609675347, 26.0])
    ops.node(1161, *[15.3073372946036, 36.9551813004515, 26.0])
    ops.node(1162, *[12.3606797749979, 38.0422606518061, 26.0])
    ops.node(1163, *[9.33781455423622, 38.8947968159071, 26.0])
    ops.node(1164, *[6.25737860160924, 39.5075336238055, 26.0])
    ops.node(1165, *[3.1383638291138, 39.8766933493251, 26.0])
    ops.node(1166, *[2.44921270764475e-15, 40.0, 26.0])
    ops.node(1167, *[-3.13836382911379, 39.8766933493251, 26.0])
    ops.node(1168, *[-6.25737860160924, 39.5075336238055, 26.0])
    ops.node(1169, *[-9.33781455423621, 38.8947968159071, 26.0])
    ops.node(1170, *[-12.3606797749979, 38.0422606518061, 26.0])
    ops.node(1171, *[-15.3073372946036, 36.9551813004515, 26.0])
    ops.node(1172, *[-18.1596199895819, 35.6402609675347, 26.0])
    ops.node(1173, *[-20.899942588638, 34.1056065741637, 26.0])
    ops.node(1174, *[-23.5114100916989, 32.3606797749979, 26.0])
    ops.node(1175, *[-25.9779219332073, 30.4162386240012, 26.0])
    ops.node(1176, *[-28.2842712474619, 28.2842712474619, 26.0])
    ops.node(1177, *[23.3801297398866, 27.3746147616011, 28.0])
    ops.node(1178, *[25.4558441227157, 25.4558441227157, 28.0])
    ops.node(1179, *[24.2460604709935, 28.3884893824012, 28.0])
    ops.node(1180, *[26.3986531642978, 26.3986531642978, 28.0])
    ops.node(1181, *[21.160269082529, 29.1246117974981, 28.0])
    ops.node(1182, *[21.9439827522523, 30.2033011233314, 28.0])
    ops.node(1183, *[18.8099483297742, 30.6950459167473, 28.0])
    ops.node(1184, *[19.5066130827288, 31.8318994692194, 28.0])
    ops.node(1185, *[16.3436579906237, 32.0762348707812, 28.0])
    ops.node(1186, *[16.9489786569431, 33.2642435696991, 28.0])
    ops.node(1187, *[13.7766035651432, 33.2596631704063, 28.0])
    ops.node(1188, *[14.28684814163, 34.491502547088, 28.0])
    ops.node(1189, *[11.1246117974981, 34.2380345866255, 28.0])
    ops.node(1190, *[11.5366344566647, 35.5061099416857, 28.0])
    ops.node(1191, *[8.4040330988126, 35.0053171343164, 28.0])
    ops.node(1192, *[8.71529358395381, 36.3018103615133, 28.0])
    ops.node(1193, *[5.63164074144831, 35.556780261425, 28.0])
    ops.node(1194, *[5.84022002816862, 36.8736980488851, 28.0])
    ops.node(1195, *[2.82452744620242, 35.8890240143926, 28.0])
    ops.node(1196, *[2.92913957383955, 37.2182471260368, 28.0])
    ops.node(1197, *[2.20429143688028e-15, 36.0, 28.0])
    ops.node(1198, *[2.28593186046844e-15, 37.3333333333333, 28.0])
    ops.node(1199, *[-2.82452744620242, 35.8890240143926, 28.0])
    ops.node(1200, *[-2.92913957383954, 37.2182471260368, 28.0])
    ops.node(1201, *[-5.63164074144832, 35.556780261425, 28.0])
    ops.node(1202, *[-5.84022002816863, 36.8736980488851, 28.0])
    ops.node(1203, *[-8.40403309881258, 35.0053171343164, 28.0])
    ops.node(1204, *[-8.71529358395379, 36.3018103615133, 28.0])
    ops.node(1205, *[-11.1246117974981, 34.2380345866255, 28.0])
    ops.node(1206, *[-11.5366344566647, 35.5061099416857, 28.0])
    ops.node(1207, *[-13.7766035651432, 33.2596631704063, 28.0])
    ops.node(1208, *[-14.28684814163, 34.491502547088, 28.0])
    ops.node(1209, *[-16.3436579906237, 32.0762348707812, 28.0])
    ops.node(1210, *[-16.9489786569431, 33.2642435696991, 28.0])
    ops.node(1211, *[-18.8099483297742, 30.6950459167473, 28.0])
    ops.node(1212, *[-19.5066130827288, 31.8318994692194, 28.0])
    ops.node(1213, *[-21.160269082529, 29.1246117974981, 28.0])
    ops.node(1214, *[-21.9439827522523, 30.2033011233314, 28.0])
    ops.node(1215, *[-23.3801297398866, 27.3746147616011, 28.0])
    ops.node(1216, *[-24.2460604709935, 28.3884893824012, 28.0])
    ops.node(1217, *[-25.4558441227157, 25.4558441227157, 28.0])
    ops.node(1218, *[-26.3986531642978, 26.3986531642978, 28.0])
    ops.node(1219, *[25.1119912021004, 29.4023640032012, 28.0])
    ops.node(1220, *[27.3414622058798, 27.3414622058798, 28.0])
    ops.node(1221, *[22.7276964219756, 31.2819904491646, 28.0])
    ops.node(1222, *[20.2032778356834, 32.9687530216916, 28.0])
    ops.node(1223, *[17.5542993232625, 34.4522522686169, 28.0])
    ops.node(1224, *[14.7970927181168, 35.7233419237698, 28.0])
    ops.node(1225, *[11.9486571158313, 36.7741852967459, 28.0])
    ops.node(1226, *[9.02655406909501, 37.5983035887102, 28.0])
    ops.node(1227, *[6.04879931488893, 38.1906158363453, 28.0])
    ops.node(1228, *[3.03375170147667, 38.547470237681, 28.0])
    ops.node(1229, *[2.3675722840566e-15, 38.6666666666667, 28.0])
    ops.node(1230, *[-3.03375170147667, 38.547470237681, 28.0])
    ops.node(1231, *[-6.04879931488893, 38.1906158363453, 28.0])
    ops.node(1232, *[-9.026554069095, 37.5983035887102, 28.0])
    ops.node(1233, *[-11.9486571158313, 36.7741852967459, 28.0])
    ops.node(1234, *[-14.7970927181168, 35.7233419237698, 28.0])
    ops.node(1235, *[-17.5542993232625, 34.4522522686169, 28.0])
    ops.node(1236, *[-20.2032778356834, 32.9687530216916, 28.0])
    ops.node(1237, *[-22.7276964219756, 31.2819904491646, 28.0])
    ops.node(1238, *[-25.1119912021004, 29.4023640032012, 28.0])
    ops.node(1239, *[-27.3414622058798, 27.3414622058798, 28.0])
    ops.node(1240, *[25.9779219332073, 30.4162386240012, 28.0])
    ops.node(1241, *[28.2842712474619, 28.2842712474619, 28.0])
    ops.node(1242, *[23.5114100916989, 32.3606797749979, 28.0])
    ops.node(1243, *[20.899942588638, 34.1056065741637, 28.0])
    ops.node(1244, *[18.1596199895819, 35.6402609675347, 28.0])
    ops.node(1245, *[15.3073372946036, 36.9551813004515, 28.0])
    ops.node(1246, *[12.3606797749979, 38.0422606518061, 28.0])
    ops.node(1247, *[9.33781455423622, 38.8947968159071, 28.0])
    ops.node(1248, *[6.25737860160924, 39.5075336238055, 28.0])
    ops.node(1249, *[3.1383638291138, 39.8766933493251, 28.0])
    ops.node(1250, *[2.44921270764475e-15, 40.0, 28.0])
    ops.node(1251, *[-3.13836382911379, 39.8766933493251, 28.0])
    ops.node(1252, *[-6.25737860160924, 39.5075336238055, 28.0])
    ops.node(1253, *[-9.33781455423621, 38.8947968159071, 28.0])
    ops.node(1254, *[-12.3606797749979, 38.0422606518061, 28.0])
    ops.node(1255, *[-15.3073372946036, 36.9551813004515, 28.0])
    ops.node(1256, *[-18.1596199895819, 35.6402609675347, 28.0])
    ops.node(1257, *[-20.899942588638, 34.1056065741637, 28.0])
    ops.node(1258, *[-23.5114100916989, 32.3606797749979, 28.0])
    ops.node(1259, *[-25.9779219332073, 30.4162386240012, 28.0])
    ops.node(1260, *[-28.2842712474619, 28.2842712474619, 28.0])
    ops.node(1261, *[23.3801297398866, 27.3746147616011, 30.0])
    ops.node(1262, *[25.4558441227157, 25.4558441227157, 30.0])
    ops.node(1263, *[24.2460604709935, 28.3884893824012, 30.0])
    ops.node(1264, *[26.3986531642978, 26.3986531642978, 30.0])
    ops.node(1265, *[21.160269082529, 29.1246117974981, 30.0])
    ops.node(1266, *[21.9439827522523, 30.2033011233314, 30.0])
    ops.node(1267, *[18.8099483297742, 30.6950459167473, 30.0])
    ops.node(1268, *[19.5066130827288, 31.8318994692194, 30.0])
    ops.node(1269, *[16.3436579906237, 32.0762348707812, 30.0])
    ops.node(1270, *[16.9489786569431, 33.2642435696991, 30.0])
    ops.node(1271, *[13.7766035651432, 33.2596631704063, 30.0])
    ops.node(1272, *[14.28684814163, 34.491502547088, 30.0])
    ops.node(1273, *[11.1246117974981, 34.2380345866255, 30.0])
    ops.node(1274, *[11.5366344566647, 35.5061099416857, 30.0])
    ops.node(1275, *[8.4040330988126, 35.0053171343164, 30.0])
    ops.node(1276, *[8.71529358395381, 36.3018103615133, 30.0])
    ops.node(1277, *[5.63164074144831, 35.556780261425, 30.0])
    ops.node(1278, *[5.84022002816862, 36.8736980488851, 30.0])
    ops.node(1279, *[2.82452744620242, 35.8890240143926, 30.0])
    ops.node(1280, *[2.92913957383955, 37.2182471260368, 30.0])
    ops.node(1281, *[2.20429143688028e-15, 36.0, 30.0])
    ops.node(1282, *[2.28593186046844e-15, 37.3333333333333, 30.0])
    ops.node(1283, *[-2.82452744620242, 35.8890240143926, 30.0])
    ops.node(1284, *[-2.92913957383954, 37.2182471260368, 30.0])
    ops.node(1285, *[-5.63164074144832, 35.556780261425, 30.0])
    ops.node(1286, *[-5.84022002816863, 36.8736980488851, 30.0])
    ops.node(1287, *[-8.40403309881258, 35.0053171343164, 30.0])
    ops.node(1288, *[-8.71529358395379, 36.3018103615133, 30.0])
    ops.node(1289, *[-11.1246117974981, 34.2380345866255, 30.0])
    ops.node(1290, *[-11.5366344566647, 35.5061099416857, 30.0])
    ops.node(1291, *[-13.7766035651432, 33.2596631704063, 30.0])
    ops.node(1292, *[-14.28684814163, 34.491502547088, 30.0])
    ops.node(1293, *[-16.3436579906237, 32.0762348707812, 30.0])
    ops.node(1294, *[-16.9489786569431, 33.2642435696991, 30.0])
    ops.node(1295, *[-18.8099483297742, 30.6950459167473, 30.0])
    ops.node(1296, *[-19.5066130827288, 31.8318994692194, 30.0])
    ops.node(1297, *[-21.160269082529, 29.1246117974981, 30.0])
    ops.node(1298, *[-21.9439827522523, 30.2033011233314, 30.0])
    ops.node(1299, *[-23.3801297398866, 27.3746147616011, 30.0])
    ops.node(1300, *[-24.2460604709935, 28.3884893824012, 30.0])
    ops.node(1301, *[-25.4558441227157, 25.4558441227157, 30.0])
    ops.node(1302, *[-26.3986531642978, 26.3986531642978, 30.0])
    ops.node(1303, *[25.1119912021004, 29.4023640032012, 30.0])
    ops.node(1304, *[27.3414622058798, 27.3414622058798, 30.0])
    ops.node(1305, *[22.7276964219756, 31.2819904491646, 30.0])
    ops.node(1306, *[20.2032778356834, 32.9687530216916, 30.0])
    ops.node(1307, *[17.5542993232625, 34.4522522686169, 30.0])
    ops.node(1308, *[14.7970927181168, 35.7233419237698, 30.0])
    ops.node(1309, *[11.9486571158313, 36.7741852967459, 30.0])
    ops.node(1310, *[9.02655406909501, 37.5983035887102, 30.0])
    ops.node(1311, *[6.04879931488893, 38.1906158363453, 30.0])
    ops.node(1312, *[3.03375170147667, 38.547470237681, 30.0])
    ops.node(1313, *[2.3675722840566e-15, 38.6666666666667, 30.0])
    ops.node(1314, *[-3.03375170147667, 38.547470237681, 30.0])
    ops.node(1315, *[-6.04879931488893, 38.1906158363453, 30.0])
    ops.node(1316, *[-9.026554069095, 37.5983035887102, 30.0])
    ops.node(1317, *[-11.9486571158313, 36.7741852967459, 30.0])
    ops.node(1318, *[-14.7970927181168, 35.7233419237698, 30.0])
    ops.node(1319, *[-17.5542993232625, 34.4522522686169, 30.0])
    ops.node(1320, *[-20.2032778356834, 32.9687530216916, 30.0])
    ops.node(1321, *[-22.7276964219756, 31.2819904491646, 30.0])
    ops.node(1322, *[-25.1119912021004, 29.4023640032012, 30.0])
    ops.node(1323, *[-27.3414622058798, 27.3414622058798, 30.0])
    ops.node(1324, *[25.9779219332073, 30.4162386240012, 30.0])
    ops.node(1325, *[28.2842712474619, 28.2842712474619, 30.0])
    ops.node(1326, *[23.5114100916989, 32.3606797749979, 30.0])
    ops.node(1327, *[20.899942588638, 34.1056065741637, 30.0])
    ops.node(1328, *[18.1596199895819, 35.6402609675347, 30.0])
    ops.node(1329, *[15.3073372946036, 36.9551813004515, 30.0])
    ops.node(1330, *[12.3606797749979, 38.0422606518061, 30.0])
    ops.node(1331, *[9.33781455423622, 38.8947968159071, 30.0])
    ops.node(1332, *[6.25737860160924, 39.5075336238055, 30.0])
    ops.node(1333, *[3.1383638291138, 39.8766933493251, 30.0])
    ops.node(1334, *[2.44921270764475e-15, 40.0, 30.0])
    ops.node(1335, *[-3.13836382911379, 39.8766933493251, 30.0])
    ops.node(1336, *[-6.25737860160924, 39.5075336238055, 30.0])
    ops.node(1337, *[-9.33781455423621, 38.8947968159071, 30.0])
    ops.node(1338, *[-12.3606797749979, 38.0422606518061, 30.0])
    ops.node(1339, *[-15.3073372946036, 36.9551813004515, 30.0])
    ops.node(1340, *[-18.1596199895819, 35.6402609675347, 30.0])
    ops.node(1341, *[-20.899942588638, 34.1056065741637, 30.0])
    ops.node(1342, *[-23.5114100916989, 32.3606797749979, 30.0])
    ops.node(1343, *[-25.9779219332073, 30.4162386240012, 30.0])
    ops.node(1344, *[-28.2842712474619, 28.2842712474619, 30.0])

    # Fix the node.
    ops.fix(1, *[1, 1, 1, 1, 1, 1])
    ops.fix(2, *[1, 1, 1, 1, 1, 1])
    ops.fix(3, *[1, 1, 1, 1, 1, 1])
    ops.fix(4, *[1, 1, 1, 1, 1, 1])
    ops.fix(6, *[1, 1, 0, 1, 1, 1])
    ops.fix(8, *[1, 1, 0, 1, 1, 1])
    ops.fix(9, *[1, 1, 1, 1, 1, 1])
    ops.fix(10, *[1, 1, 1, 1, 1, 1])
    ops.fix(13, *[1, 1, 1, 1, 1, 1])
    ops.fix(14, *[1, 1, 1, 1, 1, 1])
    ops.fix(17, *[1, 1, 1, 1, 1, 1])
    ops.fix(18, *[1, 1, 1, 1, 1, 1])
    ops.fix(21, *[1, 1, 1, 1, 1, 1])
    ops.fix(22, *[1, 1, 1, 1, 1, 1])
    ops.fix(25, *[1, 1, 1, 1, 1, 1])
    ops.fix(26, *[1, 1, 1, 1, 1, 1])
    ops.fix(29, *[1, 1, 1, 1, 1, 1])
    ops.fix(30, *[1, 1, 1, 1, 1, 1])
    ops.fix(33, *[1, 1, 1, 1, 1, 1])
    ops.fix(34, *[1, 1, 1, 1, 1, 1])
    ops.fix(37, *[1, 1, 1, 1, 1, 1])
    ops.fix(38, *[1, 1, 1, 1, 1, 1])
    ops.fix(41, *[1, 1, 1, 1, 1, 1])
    ops.fix(42, *[1, 1, 1, 1, 1, 1])
    ops.fix(45, *[1, 1, 1, 1, 1, 1])
    ops.fix(46, *[1, 1, 1, 1, 1, 1])
    ops.fix(49, *[1, 1, 1, 1, 1, 1])
    ops.fix(50, *[1, 1, 1, 1, 1, 1])
    ops.fix(53, *[1, 1, 1, 1, 1, 1])
    ops.fix(54, *[1, 1, 1, 1, 1, 1])
    ops.fix(57, *[1, 1, 1, 1, 1, 1])
    ops.fix(58, *[1, 1, 1, 1, 1, 1])
    ops.fix(61, *[1, 1, 1, 1, 1, 1])
    ops.fix(62, *[1, 1, 1, 1, 1, 1])
    ops.fix(65, *[1, 1, 1, 1, 1, 1])
    ops.fix(66, *[1, 1, 1, 1, 1, 1])
    ops.fix(69, *[1, 1, 1, 1, 1, 1])
    ops.fix(70, *[1, 1, 1, 1, 1, 1])
    ops.fix(73, *[1, 1, 1, 1, 1, 1])
    ops.fix(74, *[1, 1, 1, 1, 1, 1])
    ops.fix(77, *[1, 1, 1, 1, 1, 1])
    ops.fix(78, *[1, 1, 1, 1, 1, 1])
    ops.fix(81, *[1, 1, 1, 1, 1, 1])
    ops.fix(82, *[1, 1, 1, 1, 1, 1])
    ops.fix(83, *[1, 1, 0, 1, 1, 1])
    ops.fix(84, *[1, 1, 0, 1, 1, 1])
    ops.fix(85, *[1, 1, 1, 1, 1, 1])
    ops.fix(86, *[1, 1, 1, 1, 1, 1])
    ops.fix(88, *[1, 1, 0, 1, 1, 1])
    ops.fix(89, *[1, 1, 1, 1, 1, 1])
    ops.fix(91, *[1, 1, 1, 1, 1, 1])
    ops.fix(93, *[1, 1, 1, 1, 1, 1])
    ops.fix(95, *[1, 1, 1, 1, 1, 1])
    ops.fix(97, *[1, 1, 1, 1, 1, 1])
    ops.fix(99, *[1, 1, 1, 1, 1, 1])
    ops.fix(101, *[1, 1, 1, 1, 1, 1])
    ops.fix(103, *[1, 1, 1, 1, 1, 1])
    ops.fix(105, *[1, 1, 1, 1, 1, 1])
    ops.fix(107, *[1, 1, 1, 1, 1, 1])
    ops.fix(109, *[1, 1, 1, 1, 1, 1])
    ops.fix(111, *[1, 1, 1, 1, 1, 1])
    ops.fix(113, *[1, 1, 1, 1, 1, 1])
    ops.fix(115, *[1, 1, 1, 1, 1, 1])
    ops.fix(117, *[1, 1, 1, 1, 1, 1])
    ops.fix(119, *[1, 1, 1, 1, 1, 1])
    ops.fix(121, *[1, 1, 1, 1, 1, 1])
    ops.fix(123, *[1, 1, 1, 1, 1, 1])
    ops.fix(125, *[1, 1, 1, 1, 1, 1])
    ops.fix(126, *[1, 1, 0, 1, 1, 1])
    ops.fix(127, *[1, 1, 1, 1, 1, 1])
    ops.fix(128, *[1, 1, 1, 1, 1, 1])
    ops.fix(130, *[1, 1, 0, 1, 1, 1])
    ops.fix(131, *[1, 1, 1, 1, 1, 1])
    ops.fix(133, *[1, 1, 1, 1, 1, 1])
    ops.fix(135, *[1, 1, 1, 1, 1, 1])
    ops.fix(137, *[1, 1, 1, 1, 1, 1])
    ops.fix(139, *[1, 1, 1, 1, 1, 1])
    ops.fix(141, *[1, 1, 1, 1, 1, 1])
    ops.fix(143, *[1, 1, 1, 1, 1, 1])
    ops.fix(145, *[1, 1, 1, 1, 1, 1])
    ops.fix(147, *[1, 1, 1, 1, 1, 1])
    ops.fix(149, *[1, 1, 1, 1, 1, 1])
    ops.fix(151, *[1, 1, 1, 1, 1, 1])
    ops.fix(153, *[1, 1, 1, 1, 1, 1])
    ops.fix(155, *[1, 1, 1, 1, 1, 1])
    ops.fix(157, *[1, 1, 1, 1, 1, 1])
    ops.fix(159, *[1, 1, 1, 1, 1, 1])
    ops.fix(161, *[1, 1, 1, 1, 1, 1])
    ops.fix(163, *[1, 1, 1, 1, 1, 1])
    ops.fix(165, *[1, 1, 1, 1, 1, 1])
    ops.fix(167, *[1, 1, 1, 1, 1, 1])
    ops.fix(168, *[1, 1, 0, 1, 1, 1])
    ops.fix(170, *[1, 1, 0, 1, 1, 1])
    ops.fix(172, *[1, 1, 0, 1, 1, 1])
    ops.fix(209, *[1, 1, 0, 1, 1, 1])
    ops.fix(210, *[1, 1, 0, 1, 1, 1])
    ops.fix(212, *[1, 1, 0, 1, 1, 1])
    ops.fix(231, *[1, 1, 0, 1, 1, 1])
    ops.fix(233, *[1, 1, 0, 1, 1, 1])
    ops.fix(252, *[1, 1, 0, 1, 1, 1])
    ops.fix(254, *[1, 1, 0, 1, 1, 1])
    ops.fix(256, *[1, 1, 0, 1, 1, 1])
    ops.fix(293, *[1, 1, 0, 1, 1, 1])
    ops.fix(294, *[1, 1, 0, 1, 1, 1])
    ops.fix(296, *[1, 1, 0, 1, 1, 1])
    ops.fix(315, *[1, 1, 0, 1, 1, 1])
    ops.fix(317, *[1, 1, 0, 1, 1, 1])
    ops.fix(336, *[1, 1, 0, 1, 1, 1])
    ops.fix(338, *[1, 1, 0, 1, 1, 1])
    ops.fix(340, *[1, 1, 0, 1, 1, 1])
    ops.fix(377, *[1, 1, 0, 1, 1, 1])
    ops.fix(378, *[1, 1, 0, 1, 1, 1])
    ops.fix(380, *[1, 1, 0, 1, 1, 1])
    ops.fix(399, *[1, 1, 0, 1, 1, 1])
    ops.fix(401, *[1, 1, 0, 1, 1, 1])
    ops.fix(420, *[1, 1, 0, 1, 1, 1])
    ops.fix(422, *[1, 1, 0, 1, 1, 1])
    ops.fix(424, *[1, 1, 0, 1, 1, 1])
    ops.fix(461, *[1, 1, 0, 1, 1, 1])
    ops.fix(462, *[1, 1, 0, 1, 1, 1])
    ops.fix(464, *[1, 1, 0, 1, 1, 1])
    ops.fix(483, *[1, 1, 0, 1, 1, 1])
    ops.fix(485, *[1, 1, 0, 1, 1, 1])
    ops.fix(504, *[1, 1, 0, 1, 1, 1])
    ops.fix(506, *[1, 1, 0, 1, 1, 1])
    ops.fix(508, *[1, 1, 0, 1, 1, 1])
    ops.fix(545, *[1, 1, 0, 1, 1, 1])
    ops.fix(546, *[1, 1, 0, 1, 1, 1])
    ops.fix(548, *[1, 1, 0, 1, 1, 1])
    ops.fix(567, *[1, 1, 0, 1, 1, 1])
    ops.fix(569, *[1, 1, 0, 1, 1, 1])
    ops.fix(588, *[1, 1, 0, 1, 1, 1])
    ops.fix(590, *[1, 1, 0, 1, 1, 1])
    ops.fix(592, *[1, 1, 0, 1, 1, 1])
    ops.fix(629, *[1, 1, 0, 1, 1, 1])
    ops.fix(630, *[1, 1, 0, 1, 1, 1])
    ops.fix(632, *[1, 1, 0, 1, 1, 1])
    ops.fix(651, *[1, 1, 0, 1, 1, 1])
    ops.fix(653, *[1, 1, 0, 1, 1, 1])
    ops.fix(672, *[1, 1, 0, 1, 1, 1])
    ops.fix(674, *[1, 1, 0, 1, 1, 1])
    ops.fix(676, *[1, 1, 0, 1, 1, 1])
    ops.fix(713, *[1, 1, 0, 1, 1, 1])
    ops.fix(714, *[1, 1, 0, 1, 1, 1])
    ops.fix(716, *[1, 1, 0, 1, 1, 1])
    ops.fix(735, *[1, 1, 0, 1, 1, 1])
    ops.fix(737, *[1, 1, 0, 1, 1, 1])
    ops.fix(756, *[1, 1, 0, 1, 1, 1])
    ops.fix(758, *[1, 1, 0, 1, 1, 1])
    ops.fix(760, *[1, 1, 0, 1, 1, 1])
    ops.fix(797, *[1, 1, 0, 1, 1, 1])
    ops.fix(798, *[1, 1, 0, 1, 1, 1])
    ops.fix(800, *[1, 1, 0, 1, 1, 1])
    ops.fix(819, *[1, 1, 0, 1, 1, 1])
    ops.fix(821, *[1, 1, 0, 1, 1, 1])
    ops.fix(840, *[1, 1, 0, 1, 1, 1])
    ops.fix(842, *[1, 1, 0, 1, 1, 1])
    ops.fix(844, *[1, 1, 0, 1, 1, 1])
    ops.fix(881, *[1, 1, 0, 1, 1, 1])
    ops.fix(882, *[1, 1, 0, 1, 1, 1])
    ops.fix(884, *[1, 1, 0, 1, 1, 1])
    ops.fix(903, *[1, 1, 0, 1, 1, 1])
    ops.fix(905, *[1, 1, 0, 1, 1, 1])
    ops.fix(924, *[1, 1, 0, 1, 1, 1])
    ops.fix(926, *[1, 1, 0, 1, 1, 1])
    ops.fix(928, *[1, 1, 0, 1, 1, 1])
    ops.fix(965, *[1, 1, 0, 1, 1, 1])
    ops.fix(966, *[1, 1, 0, 1, 1, 1])
    ops.fix(968, *[1, 1, 0, 1, 1, 1])
    ops.fix(987, *[1, 1, 0, 1, 1, 1])
    ops.fix(989, *[1, 1, 0, 1, 1, 1])
    ops.fix(1008, *[1, 1, 0, 1, 1, 1])
    ops.fix(1010, *[1, 1, 0, 1, 1, 1])
    ops.fix(1012, *[1, 1, 0, 1, 1, 1])
    ops.fix(1049, *[1, 1, 0, 1, 1, 1])
    ops.fix(1050, *[1, 1, 0, 1, 1, 1])
    ops.fix(1052, *[1, 1, 0, 1, 1, 1])
    ops.fix(1071, *[1, 1, 0, 1, 1, 1])
    ops.fix(1073, *[1, 1, 0, 1, 1, 1])
    ops.fix(1092, *[1, 1, 0, 1, 1, 1])
    ops.fix(1094, *[1, 1, 0, 1, 1, 1])
    ops.fix(1096, *[1, 1, 0, 1, 1, 1])
    ops.fix(1133, *[1, 1, 0, 1, 1, 1])
    ops.fix(1134, *[1, 1, 0, 1, 1, 1])
    ops.fix(1136, *[1, 1, 0, 1, 1, 1])
    ops.fix(1155, *[1, 1, 0, 1, 1, 1])
    ops.fix(1157, *[1, 1, 0, 1, 1, 1])
    ops.fix(1176, *[1, 1, 0, 1, 1, 1])
    ops.fix(1178, *[1, 1, 0, 1, 1, 1])
    ops.fix(1180, *[1, 1, 0, 1, 1, 1])
    ops.fix(1217, *[1, 1, 0, 1, 1, 1])
    ops.fix(1218, *[1, 1, 0, 1, 1, 1])
    ops.fix(1220, *[1, 1, 0, 1, 1, 1])
    ops.fix(1239, *[1, 1, 0, 1, 1, 1])
    ops.fix(1241, *[1, 1, 0, 1, 1, 1])
    ops.fix(1260, *[1, 1, 0, 1, 1, 1])
    ops.fix(1262, *[1, 1, 0, 1, 1, 1])
    ops.fix(1264, *[1, 1, 0, 1, 1, 1])
    ops.fix(1301, *[1, 1, 0, 1, 1, 1])
    ops.fix(1302, *[1, 1, 0, 1, 1, 1])
    ops.fix(1304, *[1, 1, 0, 1, 1, 1])
    ops.fix(1323, *[1, 1, 0, 1, 1, 1])
    ops.fix(1325, *[1, 1, 0, 1, 1, 1])
    ops.fix(1344, *[1, 1, 0, 1, 1, 1])

    # Mechanical properties DataFrame of sec
    FrameSecProp_df = dict()
    FrameSecProp = namedtuple(
        'FrameSecProp', ('matName', 'A', 'J', 'I33', 'I22', 'AS2', 'AS3'))

    # Create OpenSees elements.
    # element('elasticBeamColumn', eleTag, *eleNodes, Area, E_mod, G_mod,
    # Jxx, Iy, Iz, transfTag, <'-mass', mass>, <'-cMass'>)

    # Plate_Shell element.
    # Create Plate_Shell element.

    # Solid element.
    ops.model('basic', '-ndm', 3, '-ndf', 3)

    ops.nDMaterial('ElasticIsotropic', 2, 24855578.0600518, 0.2)
    # Create Solid element.
    ops.element('stdBrick', 1, *[4, 3, 1, 2, 8, 7, 5, 6], 2)
    ops.element('stdBrick', 2, *[3, 10, 9, 1, 7, 12, 11, 5], 2)
    ops.element('stdBrick', 3, *[10, 14, 13, 9, 12, 16, 15, 11], 2)
    ops.element('stdBrick', 4, *[14, 18, 17, 13, 16, 20, 19, 15], 2)
    ops.element('stdBrick', 5, *[18, 22, 21, 17, 20, 24, 23, 19], 2)
    ops.element('stdBrick', 6, *[22, 26, 25, 21, 24, 28, 27, 23], 2)
    ops.element('stdBrick', 7, *[26, 30, 29, 25, 28, 32, 31, 27], 2)
    ops.element('stdBrick', 8, *[30, 34, 33, 29, 32, 36, 35, 31], 2)
    ops.element('stdBrick', 9, *[34, 38, 37, 33, 36, 40, 39, 35], 2)
    ops.element('stdBrick', 10, *[38, 42, 41, 37, 40, 44, 43, 39], 2)
    ops.element('stdBrick', 11, *[42, 46, 45, 41, 44, 48, 47, 43], 2)
    ops.element('stdBrick', 12, *[45, 46, 50, 49, 47, 48, 52, 51], 2)
    ops.element('stdBrick', 13, *[49, 50, 54, 53, 51, 52, 56, 55], 2)
    ops.element('stdBrick', 14, *[53, 54, 58, 57, 55, 56, 60, 59], 2)
    ops.element('stdBrick', 15, *[57, 58, 62, 61, 59, 60, 64, 63], 2)
    ops.element('stdBrick', 16, *[61, 62, 66, 65, 63, 64, 68, 67], 2)
    ops.element('stdBrick', 17, *[65, 66, 70, 69, 67, 68, 72, 71], 2)
    ops.element('stdBrick', 18, *[69, 70, 74, 73, 71, 72, 76, 75], 2)
    ops.element('stdBrick', 19, *[73, 74, 78, 77, 75, 76, 80, 79], 2)
    ops.element('stdBrick', 20, *[77, 78, 82, 81, 79, 80, 84, 83], 2)
    ops.element('stdBrick', 21, *[86, 85, 3, 4, 88, 87, 7, 8], 2)
    ops.element('stdBrick', 22, *[85, 89, 10, 3, 87, 90, 12, 7], 2)
    ops.element('stdBrick', 23, *[89, 91, 14, 10, 90, 92, 16, 12], 2)
    ops.element('stdBrick', 24, *[91, 93, 18, 14, 92, 94, 20, 16], 2)
    ops.element('stdBrick', 25, *[93, 95, 22, 18, 94, 96, 24, 20], 2)
    ops.element('stdBrick', 26, *[95, 97, 26, 22, 96, 98, 28, 24], 2)
    ops.element('stdBrick', 27, *[97, 99, 30, 26, 98, 100, 32, 28], 2)
    ops.element('stdBrick', 28, *[99, 101, 34, 30, 100, 102, 36, 32], 2)
    ops.element('stdBrick', 29, *[101, 103, 38, 34, 102, 104, 40, 36], 2)
    ops.element('stdBrick', 30, *[103, 105, 42, 38, 104, 106, 44, 40], 2)
    ops.element('stdBrick', 31, *[105, 107, 46, 42, 106, 108, 48, 44], 2)
    ops.element('stdBrick', 32, *[46, 107, 109, 50, 48, 108, 110, 52], 2)
    ops.element('stdBrick', 33, *[50, 109, 111, 54, 52, 110, 112, 56], 2)
    ops.element('stdBrick', 34, *[54, 111, 113, 58, 56, 112, 114, 60], 2)
    ops.element('stdBrick', 35, *[58, 113, 115, 62, 60, 114, 116, 64], 2)
    ops.element('stdBrick', 36, *[62, 115, 117, 66, 64, 116, 118, 68], 2)
    ops.element('stdBrick', 37, *[66, 117, 119, 70, 68, 118, 120, 72], 2)
    ops.element('stdBrick', 38, *[70, 119, 121, 74, 72, 120, 122, 76], 2)
    ops.element('stdBrick', 39, *[74, 121, 123, 78, 76, 122, 124, 80], 2)
    ops.element('stdBrick', 40, *[78, 123, 125, 82, 80, 124, 126, 84], 2)
    ops.element('stdBrick', 41, *[128, 127, 85, 86, 130, 129, 87, 88], 2)
    ops.element('stdBrick', 42, *[127, 131, 89, 85, 129, 132, 90, 87], 2)
    ops.element('stdBrick', 43, *[131, 133, 91, 89, 132, 134, 92, 90], 2)
    ops.element('stdBrick', 44, *[133, 135, 93, 91, 134, 136, 94, 92], 2)
    ops.element('stdBrick', 45, *[135, 137, 95, 93, 136, 138, 96, 94], 2)
    ops.element('stdBrick', 46, *[137, 139, 97, 95, 138, 140, 98, 96], 2)
    ops.element('stdBrick', 47, *[139, 141, 99, 97, 140, 142, 100, 98], 2)
    ops.element('stdBrick', 48, *[141, 143, 101, 99, 142, 144, 102, 100], 2)
    ops.element('stdBrick', 49, *[143, 145, 103, 101, 144, 146, 104, 102], 2)
    ops.element('stdBrick', 50, *[145, 147, 105, 103, 146, 148, 106, 104], 2)
    ops.element('stdBrick', 51, *[147, 149, 107, 105, 148, 150, 108, 106], 2)
    ops.element('stdBrick', 52, *[107, 149, 151, 109, 108, 150, 152, 110], 2)
    ops.element('stdBrick', 53, *[109, 151, 153, 111, 110, 152, 154, 112], 2)
    ops.element('stdBrick', 54, *[111, 153, 155, 113, 112, 154, 156, 114], 2)
    ops.element('stdBrick', 55, *[113, 155, 157, 115, 114, 156, 158, 116], 2)
    ops.element('stdBrick', 56, *[115, 157, 159, 117, 116, 158, 160, 118], 2)
    ops.element('stdBrick', 57, *[117, 159, 161, 119, 118, 160, 162, 120], 2)
    ops.element('stdBrick', 58, *[119, 161, 163, 121, 120, 162, 164, 122], 2)
    ops.element('stdBrick', 59, *[121, 163, 165, 123, 122, 164, 166, 124], 2)
    ops.element('stdBrick', 60, *[123, 165, 167, 125, 124, 166, 168, 126], 2)
    ops.element('stdBrick', 61, *[8, 7, 5, 6, 172, 171, 169, 170], 2)
    ops.element('stdBrick', 62, *[7, 12, 11, 5, 171, 174, 173, 169], 2)
    ops.element('stdBrick', 63, *[12, 16, 15, 11, 174, 176, 175, 173], 2)
    ops.element('stdBrick', 64, *[16, 20, 19, 15, 176, 178, 177, 175], 2)
    ops.element('stdBrick', 65, *[20, 24, 23, 19, 178, 180, 179, 177], 2)
    ops.element('stdBrick', 66, *[24, 28, 27, 23, 180, 182, 181, 179], 2)
    ops.element('stdBrick', 67, *[28, 32, 31, 27, 182, 184, 183, 181], 2)
    ops.element('stdBrick', 68, *[32, 36, 35, 31, 184, 186, 185, 183], 2)
    ops.element('stdBrick', 69, *[36, 40, 39, 35, 186, 188, 187, 185], 2)
    ops.element('stdBrick', 70, *[40, 44, 43, 39, 188, 190, 189, 187], 2)
    ops.element('stdBrick', 71, *[44, 48, 47, 43, 190, 192, 191, 189], 2)
    ops.element('stdBrick', 72, *[47, 48, 52, 51, 191, 192, 194, 193], 2)
    ops.element('stdBrick', 73, *[51, 52, 56, 55, 193, 194, 196, 195], 2)
    ops.element('stdBrick', 74, *[55, 56, 60, 59, 195, 196, 198, 197], 2)
    ops.element('stdBrick', 75, *[59, 60, 64, 63, 197, 198, 200, 199], 2)
    ops.element('stdBrick', 76, *[63, 64, 68, 67, 199, 200, 202, 201], 2)
    ops.element('stdBrick', 77, *[67, 68, 72, 71, 201, 202, 204, 203], 2)
    ops.element('stdBrick', 78, *[71, 72, 76, 75, 203, 204, 206, 205], 2)
    ops.element('stdBrick', 79, *[75, 76, 80, 79, 205, 206, 208, 207], 2)
    ops.element('stdBrick', 80, *[79, 80, 84, 83, 207, 208, 210, 209], 2)
    ops.element('stdBrick', 81, *[88, 87, 7, 8, 212, 211, 171, 172], 2)
    ops.element('stdBrick', 82, *[87, 90, 12, 7, 211, 213, 174, 171], 2)
    ops.element('stdBrick', 83, *[90, 92, 16, 12, 213, 214, 176, 174], 2)
    ops.element('stdBrick', 84, *[92, 94, 20, 16, 214, 215, 178, 176], 2)
    ops.element('stdBrick', 85, *[94, 96, 24, 20, 215, 216, 180, 178], 2)
    ops.element('stdBrick', 86, *[96, 98, 28, 24, 216, 217, 182, 180], 2)
    ops.element('stdBrick', 87, *[98, 100, 32, 28, 217, 218, 184, 182], 2)
    ops.element('stdBrick', 88, *[100, 102, 36, 32, 218, 219, 186, 184], 2)
    ops.element('stdBrick', 89, *[102, 104, 40, 36, 219, 220, 188, 186], 2)
    ops.element('stdBrick', 90, *[104, 106, 44, 40, 220, 221, 190, 188], 2)
    ops.element('stdBrick', 91, *[106, 108, 48, 44, 221, 222, 192, 190], 2)
    ops.element('stdBrick', 92, *[48, 108, 110, 52, 192, 222, 223, 194], 2)
    ops.element('stdBrick', 93, *[52, 110, 112, 56, 194, 223, 224, 196], 2)
    ops.element('stdBrick', 94, *[56, 112, 114, 60, 196, 224, 225, 198], 2)
    ops.element('stdBrick', 95, *[60, 114, 116, 64, 198, 225, 226, 200], 2)
    ops.element('stdBrick', 96, *[64, 116, 118, 68, 200, 226, 227, 202], 2)
    ops.element('stdBrick', 97, *[68, 118, 120, 72, 202, 227, 228, 204], 2)
    ops.element('stdBrick', 98, *[72, 120, 122, 76, 204, 228, 229, 206], 2)
    ops.element('stdBrick', 99, *[76, 122, 124, 80, 206, 229, 230, 208], 2)
    ops.element('stdBrick', 100, *[80, 124, 126, 84, 208, 230, 231, 210], 2)
    ops.element('stdBrick', 101, *[130, 129, 87, 88, 233, 232, 211, 212], 2)
    ops.element('stdBrick', 102, *[129, 132, 90, 87, 232, 234, 213, 211], 2)
    ops.element('stdBrick', 103, *[132, 134, 92, 90, 234, 235, 214, 213], 2)
    ops.element('stdBrick', 104, *[134, 136, 94, 92, 235, 236, 215, 214], 2)
    ops.element('stdBrick', 105, *[136, 138, 96, 94, 236, 237, 216, 215], 2)
    ops.element('stdBrick', 106, *[138, 140, 98, 96, 237, 238, 217, 216], 2)
    ops.element('stdBrick', 107, *[140, 142, 100, 98, 238, 239, 218, 217], 2)
    ops.element('stdBrick', 108, *[142, 144, 102, 100, 239, 240, 219, 218], 2)
    ops.element('stdBrick', 109, *[144, 146, 104, 102, 240, 241, 220, 219], 2)
    ops.element('stdBrick', 110, *[146, 148, 106, 104, 241, 242, 221, 220], 2)
    ops.element('stdBrick', 111, *[148, 150, 108, 106, 242, 243, 222, 221], 2)
    ops.element('stdBrick', 112, *[108, 150, 152, 110, 222, 243, 244, 223], 2)
    ops.element('stdBrick', 113, *[110, 152, 154, 112, 223, 244, 245, 224], 2)
    ops.element('stdBrick', 114, *[112, 154, 156, 114, 224, 245, 246, 225], 2)
    ops.element('stdBrick', 115, *[114, 156, 158, 116, 225, 246, 247, 226], 2)
    ops.element('stdBrick', 116, *[116, 158, 160, 118, 226, 247, 248, 227], 2)
    ops.element('stdBrick', 117, *[118, 160, 162, 120, 227, 248, 249, 228], 2)
    ops.element('stdBrick', 118, *[120, 162, 164, 122, 228, 249, 250, 229], 2)
    ops.element('stdBrick', 119, *[122, 164, 166, 124, 229, 250, 251, 230], 2)
    ops.element('stdBrick', 120, *[124, 166, 168, 126, 230, 251, 252, 231], 2)
    ops.element('stdBrick', 121, *[172, 171, 169, 170, 256, 255, 253, 254], 2)
    ops.element('stdBrick', 122, *[171, 174, 173, 169, 255, 258, 257, 253], 2)
    ops.element('stdBrick', 123, *[174, 176, 175, 173, 258, 260, 259, 257], 2)
    ops.element('stdBrick', 124, *[176, 178, 177, 175, 260, 262, 261, 259], 2)
    ops.element('stdBrick', 125, *[178, 180, 179, 177, 262, 264, 263, 261], 2)
    ops.element('stdBrick', 126, *[180, 182, 181, 179, 264, 266, 265, 263], 2)
    ops.element('stdBrick', 127, *[182, 184, 183, 181, 266, 268, 267, 265], 2)
    ops.element('stdBrick', 128, *[184, 186, 185, 183, 268, 270, 269, 267], 2)
    ops.element('stdBrick', 129, *[186, 188, 187, 185, 270, 272, 271, 269], 2)
    ops.element('stdBrick', 130, *[188, 190, 189, 187, 272, 274, 273, 271], 2)
    ops.element('stdBrick', 131, *[190, 192, 191, 189, 274, 276, 275, 273], 2)
    ops.element('stdBrick', 132, *[191, 192, 194, 193, 275, 276, 278, 277], 2)
    ops.element('stdBrick', 133, *[193, 194, 196, 195, 277, 278, 280, 279], 2)
    ops.element('stdBrick', 134, *[195, 196, 198, 197, 279, 280, 282, 281], 2)
    ops.element('stdBrick', 135, *[197, 198, 200, 199, 281, 282, 284, 283], 2)
    ops.element('stdBrick', 136, *[199, 200, 202, 201, 283, 284, 286, 285], 2)
    ops.element('stdBrick', 137, *[201, 202, 204, 203, 285, 286, 288, 287], 2)
    ops.element('stdBrick', 138, *[203, 204, 206, 205, 287, 288, 290, 289], 2)
    ops.element('stdBrick', 139, *[205, 206, 208, 207, 289, 290, 292, 291], 2)
    ops.element('stdBrick', 140, *[207, 208, 210, 209, 291, 292, 294, 293], 2)
    ops.element('stdBrick', 141, *[212, 211, 171, 172, 296, 295, 255, 256], 2)
    ops.element('stdBrick', 142, *[211, 213, 174, 171, 295, 297, 258, 255], 2)
    ops.element('stdBrick', 143, *[213, 214, 176, 174, 297, 298, 260, 258], 2)
    ops.element('stdBrick', 144, *[214, 215, 178, 176, 298, 299, 262, 260], 2)
    ops.element('stdBrick', 145, *[215, 216, 180, 178, 299, 300, 264, 262], 2)
    ops.element('stdBrick', 146, *[216, 217, 182, 180, 300, 301, 266, 264], 2)
    ops.element('stdBrick', 147, *[217, 218, 184, 182, 301, 302, 268, 266], 2)
    ops.element('stdBrick', 148, *[218, 219, 186, 184, 302, 303, 270, 268], 2)
    ops.element('stdBrick', 149, *[219, 220, 188, 186, 303, 304, 272, 270], 2)
    ops.element('stdBrick', 150, *[220, 221, 190, 188, 304, 305, 274, 272], 2)
    ops.element('stdBrick', 151, *[221, 222, 192, 190, 305, 306, 276, 274], 2)
    ops.element('stdBrick', 152, *[192, 222, 223, 194, 276, 306, 307, 278], 2)
    ops.element('stdBrick', 153, *[194, 223, 224, 196, 278, 307, 308, 280], 2)
    ops.element('stdBrick', 154, *[196, 224, 225, 198, 280, 308, 309, 282], 2)
    ops.element('stdBrick', 155, *[198, 225, 226, 200, 282, 309, 310, 284], 2)
    ops.element('stdBrick', 156, *[200, 226, 227, 202, 284, 310, 311, 286], 2)
    ops.element('stdBrick', 157, *[202, 227, 228, 204, 286, 311, 312, 288], 2)
    ops.element('stdBrick', 158, *[204, 228, 229, 206, 288, 312, 313, 290], 2)
    ops.element('stdBrick', 159, *[206, 229, 230, 208, 290, 313, 314, 292], 2)
    ops.element('stdBrick', 160, *[208, 230, 231, 210, 292, 314, 315, 294], 2)
    ops.element('stdBrick', 161, *[233, 232, 211, 212, 317, 316, 295, 296], 2)
    ops.element('stdBrick', 162, *[232, 234, 213, 211, 316, 318, 297, 295], 2)
    ops.element('stdBrick', 163, *[234, 235, 214, 213, 318, 319, 298, 297], 2)
    ops.element('stdBrick', 164, *[235, 236, 215, 214, 319, 320, 299, 298], 2)
    ops.element('stdBrick', 165, *[236, 237, 216, 215, 320, 321, 300, 299], 2)
    ops.element('stdBrick', 166, *[237, 238, 217, 216, 321, 322, 301, 300], 2)
    ops.element('stdBrick', 167, *[238, 239, 218, 217, 322, 323, 302, 301], 2)
    ops.element('stdBrick', 168, *[239, 240, 219, 218, 323, 324, 303, 302], 2)
    ops.element('stdBrick', 169, *[240, 241, 220, 219, 324, 325, 304, 303], 2)
    ops.element('stdBrick', 170, *[241, 242, 221, 220, 325, 326, 305, 304], 2)
    ops.element('stdBrick', 171, *[242, 243, 222, 221, 326, 327, 306, 305], 2)
    ops.element('stdBrick', 172, *[222, 243, 244, 223, 306, 327, 328, 307], 2)
    ops.element('stdBrick', 173, *[223, 244, 245, 224, 307, 328, 329, 308], 2)
    ops.element('stdBrick', 174, *[224, 245, 246, 225, 308, 329, 330, 309], 2)
    ops.element('stdBrick', 175, *[225, 246, 247, 226, 309, 330, 331, 310], 2)
    ops.element('stdBrick', 176, *[226, 247, 248, 227, 310, 331, 332, 311], 2)
    ops.element('stdBrick', 177, *[227, 248, 249, 228, 311, 332, 333, 312], 2)
    ops.element('stdBrick', 178, *[228, 249, 250, 229, 312, 333, 334, 313], 2)
    ops.element('stdBrick', 179, *[229, 250, 251, 230, 313, 334, 335, 314], 2)
    ops.element('stdBrick', 180, *[230, 251, 252, 231, 314, 335, 336, 315], 2)
    ops.element('stdBrick', 181, *[256, 255, 253, 254, 340, 339, 337, 338], 2)
    ops.element('stdBrick', 182, *[255, 258, 257, 253, 339, 342, 341, 337], 2)
    ops.element('stdBrick', 183, *[258, 260, 259, 257, 342, 344, 343, 341], 2)
    ops.element('stdBrick', 184, *[260, 262, 261, 259, 344, 346, 345, 343], 2)
    ops.element('stdBrick', 185, *[262, 264, 263, 261, 346, 348, 347, 345], 2)
    ops.element('stdBrick', 186, *[264, 266, 265, 263, 348, 350, 349, 347], 2)
    ops.element('stdBrick', 187, *[266, 268, 267, 265, 350, 352, 351, 349], 2)
    ops.element('stdBrick', 188, *[268, 270, 269, 267, 352, 354, 353, 351], 2)
    ops.element('stdBrick', 189, *[270, 272, 271, 269, 354, 356, 355, 353], 2)
    ops.element('stdBrick', 190, *[272, 274, 273, 271, 356, 358, 357, 355], 2)
    ops.element('stdBrick', 191, *[274, 276, 275, 273, 358, 360, 359, 357], 2)
    ops.element('stdBrick', 192, *[275, 276, 278, 277, 359, 360, 362, 361], 2)
    ops.element('stdBrick', 193, *[277, 278, 280, 279, 361, 362, 364, 363], 2)
    ops.element('stdBrick', 194, *[279, 280, 282, 281, 363, 364, 366, 365], 2)
    ops.element('stdBrick', 195, *[281, 282, 284, 283, 365, 366, 368, 367], 2)
    ops.element('stdBrick', 196, *[283, 284, 286, 285, 367, 368, 370, 369], 2)
    ops.element('stdBrick', 197, *[285, 286, 288, 287, 369, 370, 372, 371], 2)
    ops.element('stdBrick', 198, *[287, 288, 290, 289, 371, 372, 374, 373], 2)
    ops.element('stdBrick', 199, *[289, 290, 292, 291, 373, 374, 376, 375], 2)
    ops.element('stdBrick', 200, *[291, 292, 294, 293, 375, 376, 378, 377], 2)
    ops.element('stdBrick', 201, *[296, 295, 255, 256, 380, 379, 339, 340], 2)
    ops.element('stdBrick', 202, *[295, 297, 258, 255, 379, 381, 342, 339], 2)
    ops.element('stdBrick', 203, *[297, 298, 260, 258, 381, 382, 344, 342], 2)
    ops.element('stdBrick', 204, *[298, 299, 262, 260, 382, 383, 346, 344], 2)
    ops.element('stdBrick', 205, *[299, 300, 264, 262, 383, 384, 348, 346], 2)
    ops.element('stdBrick', 206, *[300, 301, 266, 264, 384, 385, 350, 348], 2)
    ops.element('stdBrick', 207, *[301, 302, 268, 266, 385, 386, 352, 350], 2)
    ops.element('stdBrick', 208, *[302, 303, 270, 268, 386, 387, 354, 352], 2)
    ops.element('stdBrick', 209, *[303, 304, 272, 270, 387, 388, 356, 354], 2)
    ops.element('stdBrick', 210, *[304, 305, 274, 272, 388, 389, 358, 356], 2)
    ops.element('stdBrick', 211, *[305, 306, 276, 274, 389, 390, 360, 358], 2)
    ops.element('stdBrick', 212, *[276, 306, 307, 278, 360, 390, 391, 362], 2)
    ops.element('stdBrick', 213, *[278, 307, 308, 280, 362, 391, 392, 364], 2)
    ops.element('stdBrick', 214, *[280, 308, 309, 282, 364, 392, 393, 366], 2)
    ops.element('stdBrick', 215, *[282, 309, 310, 284, 366, 393, 394, 368], 2)
    ops.element('stdBrick', 216, *[284, 310, 311, 286, 368, 394, 395, 370], 2)
    ops.element('stdBrick', 217, *[286, 311, 312, 288, 370, 395, 396, 372], 2)
    ops.element('stdBrick', 218, *[288, 312, 313, 290, 372, 396, 397, 374], 2)
    ops.element('stdBrick', 219, *[290, 313, 314, 292, 374, 397, 398, 376], 2)
    ops.element('stdBrick', 220, *[292, 314, 315, 294, 376, 398, 399, 378], 2)
    ops.element('stdBrick', 221, *[317, 316, 295, 296, 401, 400, 379, 380], 2)
    ops.element('stdBrick', 222, *[316, 318, 297, 295, 400, 402, 381, 379], 2)
    ops.element('stdBrick', 223, *[318, 319, 298, 297, 402, 403, 382, 381], 2)
    ops.element('stdBrick', 224, *[319, 320, 299, 298, 403, 404, 383, 382], 2)
    ops.element('stdBrick', 225, *[320, 321, 300, 299, 404, 405, 384, 383], 2)
    ops.element('stdBrick', 226, *[321, 322, 301, 300, 405, 406, 385, 384], 2)
    ops.element('stdBrick', 227, *[322, 323, 302, 301, 406, 407, 386, 385], 2)
    ops.element('stdBrick', 228, *[323, 324, 303, 302, 407, 408, 387, 386], 2)
    ops.element('stdBrick', 229, *[324, 325, 304, 303, 408, 409, 388, 387], 2)
    ops.element('stdBrick', 230, *[325, 326, 305, 304, 409, 410, 389, 388], 2)
    ops.element('stdBrick', 231, *[326, 327, 306, 305, 410, 411, 390, 389], 2)
    ops.element('stdBrick', 232, *[306, 327, 328, 307, 390, 411, 412, 391], 2)
    ops.element('stdBrick', 233, *[307, 328, 329, 308, 391, 412, 413, 392], 2)
    ops.element('stdBrick', 234, *[308, 329, 330, 309, 392, 413, 414, 393], 2)
    ops.element('stdBrick', 235, *[309, 330, 331, 310, 393, 414, 415, 394], 2)
    ops.element('stdBrick', 236, *[310, 331, 332, 311, 394, 415, 416, 395], 2)
    ops.element('stdBrick', 237, *[311, 332, 333, 312, 395, 416, 417, 396], 2)
    ops.element('stdBrick', 238, *[312, 333, 334, 313, 396, 417, 418, 397], 2)
    ops.element('stdBrick', 239, *[313, 334, 335, 314, 397, 418, 419, 398], 2)
    ops.element('stdBrick', 240, *[314, 335, 336, 315, 398, 419, 420, 399], 2)
    ops.element('stdBrick', 241, *[340, 339, 337, 338, 424, 423, 421, 422], 2)
    ops.element('stdBrick', 242, *[339, 342, 341, 337, 423, 426, 425, 421], 2)
    ops.element('stdBrick', 243, *[342, 344, 343, 341, 426, 428, 427, 425], 2)
    ops.element('stdBrick', 244, *[344, 346, 345, 343, 428, 430, 429, 427], 2)
    ops.element('stdBrick', 245, *[346, 348, 347, 345, 430, 432, 431, 429], 2)
    ops.element('stdBrick', 246, *[348, 350, 349, 347, 432, 434, 433, 431], 2)
    ops.element('stdBrick', 247, *[350, 352, 351, 349, 434, 436, 435, 433], 2)
    ops.element('stdBrick', 248, *[352, 354, 353, 351, 436, 438, 437, 435], 2)
    ops.element('stdBrick', 249, *[354, 356, 355, 353, 438, 440, 439, 437], 2)
    ops.element('stdBrick', 250, *[356, 358, 357, 355, 440, 442, 441, 439], 2)
    ops.element('stdBrick', 251, *[358, 360, 359, 357, 442, 444, 443, 441], 2)
    ops.element('stdBrick', 252, *[359, 360, 362, 361, 443, 444, 446, 445], 2)
    ops.element('stdBrick', 253, *[361, 362, 364, 363, 445, 446, 448, 447], 2)
    ops.element('stdBrick', 254, *[363, 364, 366, 365, 447, 448, 450, 449], 2)
    ops.element('stdBrick', 255, *[365, 366, 368, 367, 449, 450, 452, 451], 2)
    ops.element('stdBrick', 256, *[367, 368, 370, 369, 451, 452, 454, 453], 2)
    ops.element('stdBrick', 257, *[369, 370, 372, 371, 453, 454, 456, 455], 2)
    ops.element('stdBrick', 258, *[371, 372, 374, 373, 455, 456, 458, 457], 2)
    ops.element('stdBrick', 259, *[373, 374, 376, 375, 457, 458, 460, 459], 2)
    ops.element('stdBrick', 260, *[375, 376, 378, 377, 459, 460, 462, 461], 2)
    ops.element('stdBrick', 261, *[380, 379, 339, 340, 464, 463, 423, 424], 2)
    ops.element('stdBrick', 262, *[379, 381, 342, 339, 463, 465, 426, 423], 2)
    ops.element('stdBrick', 263, *[381, 382, 344, 342, 465, 466, 428, 426], 2)
    ops.element('stdBrick', 264, *[382, 383, 346, 344, 466, 467, 430, 428], 2)
    ops.element('stdBrick', 265, *[383, 384, 348, 346, 467, 468, 432, 430], 2)
    ops.element('stdBrick', 266, *[384, 385, 350, 348, 468, 469, 434, 432], 2)
    ops.element('stdBrick', 267, *[385, 386, 352, 350, 469, 470, 436, 434], 2)
    ops.element('stdBrick', 268, *[386, 387, 354, 352, 470, 471, 438, 436], 2)
    ops.element('stdBrick', 269, *[387, 388, 356, 354, 471, 472, 440, 438], 2)
    ops.element('stdBrick', 270, *[388, 389, 358, 356, 472, 473, 442, 440], 2)
    ops.element('stdBrick', 271, *[389, 390, 360, 358, 473, 474, 444, 442], 2)
    ops.element('stdBrick', 272, *[360, 390, 391, 362, 444, 474, 475, 446], 2)
    ops.element('stdBrick', 273, *[362, 391, 392, 364, 446, 475, 476, 448], 2)
    ops.element('stdBrick', 274, *[364, 392, 393, 366, 448, 476, 477, 450], 2)
    ops.element('stdBrick', 275, *[366, 393, 394, 368, 450, 477, 478, 452], 2)
    ops.element('stdBrick', 276, *[368, 394, 395, 370, 452, 478, 479, 454], 2)
    ops.element('stdBrick', 277, *[370, 395, 396, 372, 454, 479, 480, 456], 2)
    ops.element('stdBrick', 278, *[372, 396, 397, 374, 456, 480, 481, 458], 2)
    ops.element('stdBrick', 279, *[374, 397, 398, 376, 458, 481, 482, 460], 2)
    ops.element('stdBrick', 280, *[376, 398, 399, 378, 460, 482, 483, 462], 2)
    ops.element('stdBrick', 281, *[401, 400, 379, 380, 485, 484, 463, 464], 2)
    ops.element('stdBrick', 282, *[400, 402, 381, 379, 484, 486, 465, 463], 2)
    ops.element('stdBrick', 283, *[402, 403, 382, 381, 486, 487, 466, 465], 2)
    ops.element('stdBrick', 284, *[403, 404, 383, 382, 487, 488, 467, 466], 2)
    ops.element('stdBrick', 285, *[404, 405, 384, 383, 488, 489, 468, 467], 2)
    ops.element('stdBrick', 286, *[405, 406, 385, 384, 489, 490, 469, 468], 2)
    ops.element('stdBrick', 287, *[406, 407, 386, 385, 490, 491, 470, 469], 2)
    ops.element('stdBrick', 288, *[407, 408, 387, 386, 491, 492, 471, 470], 2)
    ops.element('stdBrick', 289, *[408, 409, 388, 387, 492, 493, 472, 471], 2)
    ops.element('stdBrick', 290, *[409, 410, 389, 388, 493, 494, 473, 472], 2)
    ops.element('stdBrick', 291, *[410, 411, 390, 389, 494, 495, 474, 473], 2)
    ops.element('stdBrick', 292, *[390, 411, 412, 391, 474, 495, 496, 475], 2)
    ops.element('stdBrick', 293, *[391, 412, 413, 392, 475, 496, 497, 476], 2)
    ops.element('stdBrick', 294, *[392, 413, 414, 393, 476, 497, 498, 477], 2)
    ops.element('stdBrick', 295, *[393, 414, 415, 394, 477, 498, 499, 478], 2)
    ops.element('stdBrick', 296, *[394, 415, 416, 395, 478, 499, 500, 479], 2)
    ops.element('stdBrick', 297, *[395, 416, 417, 396, 479, 500, 501, 480], 2)
    ops.element('stdBrick', 298, *[396, 417, 418, 397, 480, 501, 502, 481], 2)
    ops.element('stdBrick', 299, *[397, 418, 419, 398, 481, 502, 503, 482], 2)
    ops.element('stdBrick', 300, *[398, 419, 420, 399, 482, 503, 504, 483], 2)
    ops.element('stdBrick', 301, *[424, 423, 421, 422, 508, 507, 505, 506], 2)
    ops.element('stdBrick', 302, *[423, 426, 425, 421, 507, 510, 509, 505], 2)
    ops.element('stdBrick', 303, *[426, 428, 427, 425, 510, 512, 511, 509], 2)
    ops.element('stdBrick', 304, *[428, 430, 429, 427, 512, 514, 513, 511], 2)
    ops.element('stdBrick', 305, *[430, 432, 431, 429, 514, 516, 515, 513], 2)
    ops.element('stdBrick', 306, *[432, 434, 433, 431, 516, 518, 517, 515], 2)
    ops.element('stdBrick', 307, *[434, 436, 435, 433, 518, 520, 519, 517], 2)
    ops.element('stdBrick', 308, *[436, 438, 437, 435, 520, 522, 521, 519], 2)
    ops.element('stdBrick', 309, *[438, 440, 439, 437, 522, 524, 523, 521], 2)
    ops.element('stdBrick', 310, *[440, 442, 441, 439, 524, 526, 525, 523], 2)
    ops.element('stdBrick', 311, *[442, 444, 443, 441, 526, 528, 527, 525], 2)
    ops.element('stdBrick', 312, *[443, 444, 446, 445, 527, 528, 530, 529], 2)
    ops.element('stdBrick', 313, *[445, 446, 448, 447, 529, 530, 532, 531], 2)
    ops.element('stdBrick', 314, *[447, 448, 450, 449, 531, 532, 534, 533], 2)
    ops.element('stdBrick', 315, *[449, 450, 452, 451, 533, 534, 536, 535], 2)
    ops.element('stdBrick', 316, *[451, 452, 454, 453, 535, 536, 538, 537], 2)
    ops.element('stdBrick', 317, *[453, 454, 456, 455, 537, 538, 540, 539], 2)
    ops.element('stdBrick', 318, *[455, 456, 458, 457, 539, 540, 542, 541], 2)
    ops.element('stdBrick', 319, *[457, 458, 460, 459, 541, 542, 544, 543], 2)
    ops.element('stdBrick', 320, *[459, 460, 462, 461, 543, 544, 546, 545], 2)
    ops.element('stdBrick', 321, *[464, 463, 423, 424, 548, 547, 507, 508], 2)
    ops.element('stdBrick', 322, *[463, 465, 426, 423, 547, 549, 510, 507], 2)
    ops.element('stdBrick', 323, *[465, 466, 428, 426, 549, 550, 512, 510], 2)
    ops.element('stdBrick', 324, *[466, 467, 430, 428, 550, 551, 514, 512], 2)
    ops.element('stdBrick', 325, *[467, 468, 432, 430, 551, 552, 516, 514], 2)
    ops.element('stdBrick', 326, *[468, 469, 434, 432, 552, 553, 518, 516], 2)
    ops.element('stdBrick', 327, *[469, 470, 436, 434, 553, 554, 520, 518], 2)
    ops.element('stdBrick', 328, *[470, 471, 438, 436, 554, 555, 522, 520], 2)
    ops.element('stdBrick', 329, *[471, 472, 440, 438, 555, 556, 524, 522], 2)
    ops.element('stdBrick', 330, *[472, 473, 442, 440, 556, 557, 526, 524], 2)
    ops.element('stdBrick', 331, *[473, 474, 444, 442, 557, 558, 528, 526], 2)
    ops.element('stdBrick', 332, *[444, 474, 475, 446, 528, 558, 559, 530], 2)
    ops.element('stdBrick', 333, *[446, 475, 476, 448, 530, 559, 560, 532], 2)
    ops.element('stdBrick', 334, *[448, 476, 477, 450, 532, 560, 561, 534], 2)
    ops.element('stdBrick', 335, *[450, 477, 478, 452, 534, 561, 562, 536], 2)
    ops.element('stdBrick', 336, *[452, 478, 479, 454, 536, 562, 563, 538], 2)
    ops.element('stdBrick', 337, *[454, 479, 480, 456, 538, 563, 564, 540], 2)
    ops.element('stdBrick', 338, *[456, 480, 481, 458, 540, 564, 565, 542], 2)
    ops.element('stdBrick', 339, *[458, 481, 482, 460, 542, 565, 566, 544], 2)
    ops.element('stdBrick', 340, *[460, 482, 483, 462, 544, 566, 567, 546], 2)
    ops.element('stdBrick', 341, *[485, 484, 463, 464, 569, 568, 547, 548], 2)
    ops.element('stdBrick', 342, *[484, 486, 465, 463, 568, 570, 549, 547], 2)
    ops.element('stdBrick', 343, *[486, 487, 466, 465, 570, 571, 550, 549], 2)
    ops.element('stdBrick', 344, *[487, 488, 467, 466, 571, 572, 551, 550], 2)
    ops.element('stdBrick', 345, *[488, 489, 468, 467, 572, 573, 552, 551], 2)
    ops.element('stdBrick', 346, *[489, 490, 469, 468, 573, 574, 553, 552], 2)
    ops.element('stdBrick', 347, *[490, 491, 470, 469, 574, 575, 554, 553], 2)
    ops.element('stdBrick', 348, *[491, 492, 471, 470, 575, 576, 555, 554], 2)
    ops.element('stdBrick', 349, *[492, 493, 472, 471, 576, 577, 556, 555], 2)
    ops.element('stdBrick', 350, *[493, 494, 473, 472, 577, 578, 557, 556], 2)
    ops.element('stdBrick', 351, *[494, 495, 474, 473, 578, 579, 558, 557], 2)
    ops.element('stdBrick', 352, *[474, 495, 496, 475, 558, 579, 580, 559], 2)
    ops.element('stdBrick', 353, *[475, 496, 497, 476, 559, 580, 581, 560], 2)
    ops.element('stdBrick', 354, *[476, 497, 498, 477, 560, 581, 582, 561], 2)
    ops.element('stdBrick', 355, *[477, 498, 499, 478, 561, 582, 583, 562], 2)
    ops.element('stdBrick', 356, *[478, 499, 500, 479, 562, 583, 584, 563], 2)
    ops.element('stdBrick', 357, *[479, 500, 501, 480, 563, 584, 585, 564], 2)
    ops.element('stdBrick', 358, *[480, 501, 502, 481, 564, 585, 586, 565], 2)
    ops.element('stdBrick', 359, *[481, 502, 503, 482, 565, 586, 587, 566], 2)
    ops.element('stdBrick', 360, *[482, 503, 504, 483, 566, 587, 588, 567], 2)
    ops.element('stdBrick', 361, *[508, 507, 505, 506, 592, 591, 589, 590], 2)
    ops.element('stdBrick', 362, *[507, 510, 509, 505, 591, 594, 593, 589], 2)
    ops.element('stdBrick', 363, *[510, 512, 511, 509, 594, 596, 595, 593], 2)
    ops.element('stdBrick', 364, *[512, 514, 513, 511, 596, 598, 597, 595], 2)
    ops.element('stdBrick', 365, *[514, 516, 515, 513, 598, 600, 599, 597], 2)
    ops.element('stdBrick', 366, *[516, 518, 517, 515, 600, 602, 601, 599], 2)
    ops.element('stdBrick', 367, *[518, 520, 519, 517, 602, 604, 603, 601], 2)
    ops.element('stdBrick', 368, *[520, 522, 521, 519, 604, 606, 605, 603], 2)
    ops.element('stdBrick', 369, *[522, 524, 523, 521, 606, 608, 607, 605], 2)
    ops.element('stdBrick', 370, *[524, 526, 525, 523, 608, 610, 609, 607], 2)
    ops.element('stdBrick', 371, *[526, 528, 527, 525, 610, 612, 611, 609], 2)
    ops.element('stdBrick', 372, *[527, 528, 530, 529, 611, 612, 614, 613], 2)
    ops.element('stdBrick', 373, *[529, 530, 532, 531, 613, 614, 616, 615], 2)
    ops.element('stdBrick', 374, *[531, 532, 534, 533, 615, 616, 618, 617], 2)
    ops.element('stdBrick', 375, *[533, 534, 536, 535, 617, 618, 620, 619], 2)
    ops.element('stdBrick', 376, *[535, 536, 538, 537, 619, 620, 622, 621], 2)
    ops.element('stdBrick', 377, *[537, 538, 540, 539, 621, 622, 624, 623], 2)
    ops.element('stdBrick', 378, *[539, 540, 542, 541, 623, 624, 626, 625], 2)
    ops.element('stdBrick', 379, *[541, 542, 544, 543, 625, 626, 628, 627], 2)
    ops.element('stdBrick', 380, *[543, 544, 546, 545, 627, 628, 630, 629], 2)
    ops.element('stdBrick', 381, *[548, 547, 507, 508, 632, 631, 591, 592], 2)
    ops.element('stdBrick', 382, *[547, 549, 510, 507, 631, 633, 594, 591], 2)
    ops.element('stdBrick', 383, *[549, 550, 512, 510, 633, 634, 596, 594], 2)
    ops.element('stdBrick', 384, *[550, 551, 514, 512, 634, 635, 598, 596], 2)
    ops.element('stdBrick', 385, *[551, 552, 516, 514, 635, 636, 600, 598], 2)
    ops.element('stdBrick', 386, *[552, 553, 518, 516, 636, 637, 602, 600], 2)
    ops.element('stdBrick', 387, *[553, 554, 520, 518, 637, 638, 604, 602], 2)
    ops.element('stdBrick', 388, *[554, 555, 522, 520, 638, 639, 606, 604], 2)
    ops.element('stdBrick', 389, *[555, 556, 524, 522, 639, 640, 608, 606], 2)
    ops.element('stdBrick', 390, *[556, 557, 526, 524, 640, 641, 610, 608], 2)
    ops.element('stdBrick', 391, *[557, 558, 528, 526, 641, 642, 612, 610], 2)
    ops.element('stdBrick', 392, *[528, 558, 559, 530, 612, 642, 643, 614], 2)
    ops.element('stdBrick', 393, *[530, 559, 560, 532, 614, 643, 644, 616], 2)
    ops.element('stdBrick', 394, *[532, 560, 561, 534, 616, 644, 645, 618], 2)
    ops.element('stdBrick', 395, *[534, 561, 562, 536, 618, 645, 646, 620], 2)
    ops.element('stdBrick', 396, *[536, 562, 563, 538, 620, 646, 647, 622], 2)
    ops.element('stdBrick', 397, *[538, 563, 564, 540, 622, 647, 648, 624], 2)
    ops.element('stdBrick', 398, *[540, 564, 565, 542, 624, 648, 649, 626], 2)
    ops.element('stdBrick', 399, *[542, 565, 566, 544, 626, 649, 650, 628], 2)
    ops.element('stdBrick', 400, *[544, 566, 567, 546, 628, 650, 651, 630], 2)
    ops.element('stdBrick', 401, *[569, 568, 547, 548, 653, 652, 631, 632], 2)
    ops.element('stdBrick', 402, *[568, 570, 549, 547, 652, 654, 633, 631], 2)
    ops.element('stdBrick', 403, *[570, 571, 550, 549, 654, 655, 634, 633], 2)
    ops.element('stdBrick', 404, *[571, 572, 551, 550, 655, 656, 635, 634], 2)
    ops.element('stdBrick', 405, *[572, 573, 552, 551, 656, 657, 636, 635], 2)
    ops.element('stdBrick', 406, *[573, 574, 553, 552, 657, 658, 637, 636], 2)
    ops.element('stdBrick', 407, *[574, 575, 554, 553, 658, 659, 638, 637], 2)
    ops.element('stdBrick', 408, *[575, 576, 555, 554, 659, 660, 639, 638], 2)
    ops.element('stdBrick', 409, *[576, 577, 556, 555, 660, 661, 640, 639], 2)
    ops.element('stdBrick', 410, *[577, 578, 557, 556, 661, 662, 641, 640], 2)
    ops.element('stdBrick', 411, *[578, 579, 558, 557, 662, 663, 642, 641], 2)
    ops.element('stdBrick', 412, *[558, 579, 580, 559, 642, 663, 664, 643], 2)
    ops.element('stdBrick', 413, *[559, 580, 581, 560, 643, 664, 665, 644], 2)
    ops.element('stdBrick', 414, *[560, 581, 582, 561, 644, 665, 666, 645], 2)
    ops.element('stdBrick', 415, *[561, 582, 583, 562, 645, 666, 667, 646], 2)
    ops.element('stdBrick', 416, *[562, 583, 584, 563, 646, 667, 668, 647], 2)
    ops.element('stdBrick', 417, *[563, 584, 585, 564, 647, 668, 669, 648], 2)
    ops.element('stdBrick', 418, *[564, 585, 586, 565, 648, 669, 670, 649], 2)
    ops.element('stdBrick', 419, *[565, 586, 587, 566, 649, 670, 671, 650], 2)
    ops.element('stdBrick', 420, *[566, 587, 588, 567, 650, 671, 672, 651], 2)
    ops.element('stdBrick', 421, *[592, 591, 589, 590, 676, 675, 673, 674], 2)
    ops.element('stdBrick', 422, *[591, 594, 593, 589, 675, 678, 677, 673], 2)
    ops.element('stdBrick', 423, *[594, 596, 595, 593, 678, 680, 679, 677], 2)
    ops.element('stdBrick', 424, *[596, 598, 597, 595, 680, 682, 681, 679], 2)
    ops.element('stdBrick', 425, *[598, 600, 599, 597, 682, 684, 683, 681], 2)
    ops.element('stdBrick', 426, *[600, 602, 601, 599, 684, 686, 685, 683], 2)
    ops.element('stdBrick', 427, *[602, 604, 603, 601, 686, 688, 687, 685], 2)
    ops.element('stdBrick', 428, *[604, 606, 605, 603, 688, 690, 689, 687], 2)
    ops.element('stdBrick', 429, *[606, 608, 607, 605, 690, 692, 691, 689], 2)
    ops.element('stdBrick', 430, *[608, 610, 609, 607, 692, 694, 693, 691], 2)
    ops.element('stdBrick', 431, *[610, 612, 611, 609, 694, 696, 695, 693], 2)
    ops.element('stdBrick', 432, *[611, 612, 614, 613, 695, 696, 698, 697], 2)
    ops.element('stdBrick', 433, *[613, 614, 616, 615, 697, 698, 700, 699], 2)
    ops.element('stdBrick', 434, *[615, 616, 618, 617, 699, 700, 702, 701], 2)
    ops.element('stdBrick', 435, *[617, 618, 620, 619, 701, 702, 704, 703], 2)
    ops.element('stdBrick', 436, *[619, 620, 622, 621, 703, 704, 706, 705], 2)
    ops.element('stdBrick', 437, *[621, 622, 624, 623, 705, 706, 708, 707], 2)
    ops.element('stdBrick', 438, *[623, 624, 626, 625, 707, 708, 710, 709], 2)
    ops.element('stdBrick', 439, *[625, 626, 628, 627, 709, 710, 712, 711], 2)
    ops.element('stdBrick', 440, *[627, 628, 630, 629, 711, 712, 714, 713], 2)
    ops.element('stdBrick', 441, *[632, 631, 591, 592, 716, 715, 675, 676], 2)
    ops.element('stdBrick', 442, *[631, 633, 594, 591, 715, 717, 678, 675], 2)
    ops.element('stdBrick', 443, *[633, 634, 596, 594, 717, 718, 680, 678], 2)
    ops.element('stdBrick', 444, *[634, 635, 598, 596, 718, 719, 682, 680], 2)
    ops.element('stdBrick', 445, *[635, 636, 600, 598, 719, 720, 684, 682], 2)
    ops.element('stdBrick', 446, *[636, 637, 602, 600, 720, 721, 686, 684], 2)
    ops.element('stdBrick', 447, *[637, 638, 604, 602, 721, 722, 688, 686], 2)
    ops.element('stdBrick', 448, *[638, 639, 606, 604, 722, 723, 690, 688], 2)
    ops.element('stdBrick', 449, *[639, 640, 608, 606, 723, 724, 692, 690], 2)
    ops.element('stdBrick', 450, *[640, 641, 610, 608, 724, 725, 694, 692], 2)
    ops.element('stdBrick', 451, *[641, 642, 612, 610, 725, 726, 696, 694], 2)
    ops.element('stdBrick', 452, *[612, 642, 643, 614, 696, 726, 727, 698], 2)
    ops.element('stdBrick', 453, *[614, 643, 644, 616, 698, 727, 728, 700], 2)
    ops.element('stdBrick', 454, *[616, 644, 645, 618, 700, 728, 729, 702], 2)
    ops.element('stdBrick', 455, *[618, 645, 646, 620, 702, 729, 730, 704], 2)
    ops.element('stdBrick', 456, *[620, 646, 647, 622, 704, 730, 731, 706], 2)
    ops.element('stdBrick', 457, *[622, 647, 648, 624, 706, 731, 732, 708], 2)
    ops.element('stdBrick', 458, *[624, 648, 649, 626, 708, 732, 733, 710], 2)
    ops.element('stdBrick', 459, *[626, 649, 650, 628, 710, 733, 734, 712], 2)
    ops.element('stdBrick', 460, *[628, 650, 651, 630, 712, 734, 735, 714], 2)
    ops.element('stdBrick', 461, *[653, 652, 631, 632, 737, 736, 715, 716], 2)
    ops.element('stdBrick', 462, *[652, 654, 633, 631, 736, 738, 717, 715], 2)
    ops.element('stdBrick', 463, *[654, 655, 634, 633, 738, 739, 718, 717], 2)
    ops.element('stdBrick', 464, *[655, 656, 635, 634, 739, 740, 719, 718], 2)
    ops.element('stdBrick', 465, *[656, 657, 636, 635, 740, 741, 720, 719], 2)
    ops.element('stdBrick', 466, *[657, 658, 637, 636, 741, 742, 721, 720], 2)
    ops.element('stdBrick', 467, *[658, 659, 638, 637, 742, 743, 722, 721], 2)
    ops.element('stdBrick', 468, *[659, 660, 639, 638, 743, 744, 723, 722], 2)
    ops.element('stdBrick', 469, *[660, 661, 640, 639, 744, 745, 724, 723], 2)
    ops.element('stdBrick', 470, *[661, 662, 641, 640, 745, 746, 725, 724], 2)
    ops.element('stdBrick', 471, *[662, 663, 642, 641, 746, 747, 726, 725], 2)
    ops.element('stdBrick', 472, *[642, 663, 664, 643, 726, 747, 748, 727], 2)
    ops.element('stdBrick', 473, *[643, 664, 665, 644, 727, 748, 749, 728], 2)
    ops.element('stdBrick', 474, *[644, 665, 666, 645, 728, 749, 750, 729], 2)
    ops.element('stdBrick', 475, *[645, 666, 667, 646, 729, 750, 751, 730], 2)
    ops.element('stdBrick', 476, *[646, 667, 668, 647, 730, 751, 752, 731], 2)
    ops.element('stdBrick', 477, *[647, 668, 669, 648, 731, 752, 753, 732], 2)
    ops.element('stdBrick', 478, *[648, 669, 670, 649, 732, 753, 754, 733], 2)
    ops.element('stdBrick', 479, *[649, 670, 671, 650, 733, 754, 755, 734], 2)
    ops.element('stdBrick', 480, *[650, 671, 672, 651, 734, 755, 756, 735], 2)
    ops.element('stdBrick', 481, *[676, 675, 673, 674, 760, 759, 757, 758], 2)
    ops.element('stdBrick', 482, *[675, 678, 677, 673, 759, 762, 761, 757], 2)
    ops.element('stdBrick', 483, *[678, 680, 679, 677, 762, 764, 763, 761], 2)
    ops.element('stdBrick', 484, *[680, 682, 681, 679, 764, 766, 765, 763], 2)
    ops.element('stdBrick', 485, *[682, 684, 683, 681, 766, 768, 767, 765], 2)
    ops.element('stdBrick', 486, *[684, 686, 685, 683, 768, 770, 769, 767], 2)
    ops.element('stdBrick', 487, *[686, 688, 687, 685, 770, 772, 771, 769], 2)
    ops.element('stdBrick', 488, *[688, 690, 689, 687, 772, 774, 773, 771], 2)
    ops.element('stdBrick', 489, *[690, 692, 691, 689, 774, 776, 775, 773], 2)
    ops.element('stdBrick', 490, *[692, 694, 693, 691, 776, 778, 777, 775], 2)
    ops.element('stdBrick', 491, *[694, 696, 695, 693, 778, 780, 779, 777], 2)
    ops.element('stdBrick', 492, *[695, 696, 698, 697, 779, 780, 782, 781], 2)
    ops.element('stdBrick', 493, *[697, 698, 700, 699, 781, 782, 784, 783], 2)
    ops.element('stdBrick', 494, *[699, 700, 702, 701, 783, 784, 786, 785], 2)
    ops.element('stdBrick', 495, *[701, 702, 704, 703, 785, 786, 788, 787], 2)
    ops.element('stdBrick', 496, *[703, 704, 706, 705, 787, 788, 790, 789], 2)
    ops.element('stdBrick', 497, *[705, 706, 708, 707, 789, 790, 792, 791], 2)
    ops.element('stdBrick', 498, *[707, 708, 710, 709, 791, 792, 794, 793], 2)
    ops.element('stdBrick', 499, *[709, 710, 712, 711, 793, 794, 796, 795], 2)
    ops.element('stdBrick', 500, *[711, 712, 714, 713, 795, 796, 798, 797], 2)
    ops.element('stdBrick', 501, *[716, 715, 675, 676, 800, 799, 759, 760], 2)
    ops.element('stdBrick', 502, *[715, 717, 678, 675, 799, 801, 762, 759], 2)
    ops.element('stdBrick', 503, *[717, 718, 680, 678, 801, 802, 764, 762], 2)
    ops.element('stdBrick', 504, *[718, 719, 682, 680, 802, 803, 766, 764], 2)
    ops.element('stdBrick', 505, *[719, 720, 684, 682, 803, 804, 768, 766], 2)
    ops.element('stdBrick', 506, *[720, 721, 686, 684, 804, 805, 770, 768], 2)
    ops.element('stdBrick', 507, *[721, 722, 688, 686, 805, 806, 772, 770], 2)
    ops.element('stdBrick', 508, *[722, 723, 690, 688, 806, 807, 774, 772], 2)
    ops.element('stdBrick', 509, *[723, 724, 692, 690, 807, 808, 776, 774], 2)
    ops.element('stdBrick', 510, *[724, 725, 694, 692, 808, 809, 778, 776], 2)
    ops.element('stdBrick', 511, *[725, 726, 696, 694, 809, 810, 780, 778], 2)
    ops.element('stdBrick', 512, *[696, 726, 727, 698, 780, 810, 811, 782], 2)
    ops.element('stdBrick', 513, *[698, 727, 728, 700, 782, 811, 812, 784], 2)
    ops.element('stdBrick', 514, *[700, 728, 729, 702, 784, 812, 813, 786], 2)
    ops.element('stdBrick', 515, *[702, 729, 730, 704, 786, 813, 814, 788], 2)
    ops.element('stdBrick', 516, *[704, 730, 731, 706, 788, 814, 815, 790], 2)
    ops.element('stdBrick', 517, *[706, 731, 732, 708, 790, 815, 816, 792], 2)
    ops.element('stdBrick', 518, *[708, 732, 733, 710, 792, 816, 817, 794], 2)
    ops.element('stdBrick', 519, *[710, 733, 734, 712, 794, 817, 818, 796], 2)
    ops.element('stdBrick', 520, *[712, 734, 735, 714, 796, 818, 819, 798], 2)
    ops.element('stdBrick', 521, *[737, 736, 715, 716, 821, 820, 799, 800], 2)
    ops.element('stdBrick', 522, *[736, 738, 717, 715, 820, 822, 801, 799], 2)
    ops.element('stdBrick', 523, *[738, 739, 718, 717, 822, 823, 802, 801], 2)
    ops.element('stdBrick', 524, *[739, 740, 719, 718, 823, 824, 803, 802], 2)
    ops.element('stdBrick', 525, *[740, 741, 720, 719, 824, 825, 804, 803], 2)
    ops.element('stdBrick', 526, *[741, 742, 721, 720, 825, 826, 805, 804], 2)
    ops.element('stdBrick', 527, *[742, 743, 722, 721, 826, 827, 806, 805], 2)
    ops.element('stdBrick', 528, *[743, 744, 723, 722, 827, 828, 807, 806], 2)
    ops.element('stdBrick', 529, *[744, 745, 724, 723, 828, 829, 808, 807], 2)
    ops.element('stdBrick', 530, *[745, 746, 725, 724, 829, 830, 809, 808], 2)
    ops.element('stdBrick', 531, *[746, 747, 726, 725, 830, 831, 810, 809], 2)
    ops.element('stdBrick', 532, *[726, 747, 748, 727, 810, 831, 832, 811], 2)
    ops.element('stdBrick', 533, *[727, 748, 749, 728, 811, 832, 833, 812], 2)
    ops.element('stdBrick', 534, *[728, 749, 750, 729, 812, 833, 834, 813], 2)
    ops.element('stdBrick', 535, *[729, 750, 751, 730, 813, 834, 835, 814], 2)
    ops.element('stdBrick', 536, *[730, 751, 752, 731, 814, 835, 836, 815], 2)
    ops.element('stdBrick', 537, *[731, 752, 753, 732, 815, 836, 837, 816], 2)
    ops.element('stdBrick', 538, *[732, 753, 754, 733, 816, 837, 838, 817], 2)
    ops.element('stdBrick', 539, *[733, 754, 755, 734, 817, 838, 839, 818], 2)
    ops.element('stdBrick', 540, *[734, 755, 756, 735, 818, 839, 840, 819], 2)
    ops.element('stdBrick', 541, *[760, 759, 757, 758, 844, 843, 841, 842], 2)
    ops.element('stdBrick', 542, *[759, 762, 761, 757, 843, 846, 845, 841], 2)
    ops.element('stdBrick', 543, *[762, 764, 763, 761, 846, 848, 847, 845], 2)
    ops.element('stdBrick', 544, *[764, 766, 765, 763, 848, 850, 849, 847], 2)
    ops.element('stdBrick', 545, *[766, 768, 767, 765, 850, 852, 851, 849], 2)
    ops.element('stdBrick', 546, *[768, 770, 769, 767, 852, 854, 853, 851], 2)
    ops.element('stdBrick', 547, *[770, 772, 771, 769, 854, 856, 855, 853], 2)
    ops.element('stdBrick', 548, *[772, 774, 773, 771, 856, 858, 857, 855], 2)
    ops.element('stdBrick', 549, *[774, 776, 775, 773, 858, 860, 859, 857], 2)
    ops.element('stdBrick', 550, *[776, 778, 777, 775, 860, 862, 861, 859], 2)
    ops.element('stdBrick', 551, *[778, 780, 779, 777, 862, 864, 863, 861], 2)
    ops.element('stdBrick', 552, *[779, 780, 782, 781, 863, 864, 866, 865], 2)
    ops.element('stdBrick', 553, *[781, 782, 784, 783, 865, 866, 868, 867], 2)
    ops.element('stdBrick', 554, *[783, 784, 786, 785, 867, 868, 870, 869], 2)
    ops.element('stdBrick', 555, *[785, 786, 788, 787, 869, 870, 872, 871], 2)
    ops.element('stdBrick', 556, *[787, 788, 790, 789, 871, 872, 874, 873], 2)
    ops.element('stdBrick', 557, *[789, 790, 792, 791, 873, 874, 876, 875], 2)
    ops.element('stdBrick', 558, *[791, 792, 794, 793, 875, 876, 878, 877], 2)
    ops.element('stdBrick', 559, *[793, 794, 796, 795, 877, 878, 880, 879], 2)
    ops.element('stdBrick', 560, *[795, 796, 798, 797, 879, 880, 882, 881], 2)
    ops.element('stdBrick', 561, *[800, 799, 759, 760, 884, 883, 843, 844], 2)
    ops.element('stdBrick', 562, *[799, 801, 762, 759, 883, 885, 846, 843], 2)
    ops.element('stdBrick', 563, *[801, 802, 764, 762, 885, 886, 848, 846], 2)
    ops.element('stdBrick', 564, *[802, 803, 766, 764, 886, 887, 850, 848], 2)
    ops.element('stdBrick', 565, *[803, 804, 768, 766, 887, 888, 852, 850], 2)
    ops.element('stdBrick', 566, *[804, 805, 770, 768, 888, 889, 854, 852], 2)
    ops.element('stdBrick', 567, *[805, 806, 772, 770, 889, 890, 856, 854], 2)
    ops.element('stdBrick', 568, *[806, 807, 774, 772, 890, 891, 858, 856], 2)
    ops.element('stdBrick', 569, *[807, 808, 776, 774, 891, 892, 860, 858], 2)
    ops.element('stdBrick', 570, *[808, 809, 778, 776, 892, 893, 862, 860], 2)
    ops.element('stdBrick', 571, *[809, 810, 780, 778, 893, 894, 864, 862], 2)
    ops.element('stdBrick', 572, *[780, 810, 811, 782, 864, 894, 895, 866], 2)
    ops.element('stdBrick', 573, *[782, 811, 812, 784, 866, 895, 896, 868], 2)
    ops.element('stdBrick', 574, *[784, 812, 813, 786, 868, 896, 897, 870], 2)
    ops.element('stdBrick', 575, *[786, 813, 814, 788, 870, 897, 898, 872], 2)
    ops.element('stdBrick', 576, *[788, 814, 815, 790, 872, 898, 899, 874], 2)
    ops.element('stdBrick', 577, *[790, 815, 816, 792, 874, 899, 900, 876], 2)
    ops.element('stdBrick', 578, *[792, 816, 817, 794, 876, 900, 901, 878], 2)
    ops.element('stdBrick', 579, *[794, 817, 818, 796, 878, 901, 902, 880], 2)
    ops.element('stdBrick', 580, *[796, 818, 819, 798, 880, 902, 903, 882], 2)
    ops.element('stdBrick', 581, *[821, 820, 799, 800, 905, 904, 883, 884], 2)
    ops.element('stdBrick', 582, *[820, 822, 801, 799, 904, 906, 885, 883], 2)
    ops.element('stdBrick', 583, *[822, 823, 802, 801, 906, 907, 886, 885], 2)
    ops.element('stdBrick', 584, *[823, 824, 803, 802, 907, 908, 887, 886], 2)
    ops.element('stdBrick', 585, *[824, 825, 804, 803, 908, 909, 888, 887], 2)
    ops.element('stdBrick', 586, *[825, 826, 805, 804, 909, 910, 889, 888], 2)
    ops.element('stdBrick', 587, *[826, 827, 806, 805, 910, 911, 890, 889], 2)
    ops.element('stdBrick', 588, *[827, 828, 807, 806, 911, 912, 891, 890], 2)
    ops.element('stdBrick', 589, *[828, 829, 808, 807, 912, 913, 892, 891], 2)
    ops.element('stdBrick', 590, *[829, 830, 809, 808, 913, 914, 893, 892], 2)
    ops.element('stdBrick', 591, *[830, 831, 810, 809, 914, 915, 894, 893], 2)
    ops.element('stdBrick', 592, *[810, 831, 832, 811, 894, 915, 916, 895], 2)
    ops.element('stdBrick', 593, *[811, 832, 833, 812, 895, 916, 917, 896], 2)
    ops.element('stdBrick', 594, *[812, 833, 834, 813, 896, 917, 918, 897], 2)
    ops.element('stdBrick', 595, *[813, 834, 835, 814, 897, 918, 919, 898], 2)
    ops.element('stdBrick', 596, *[814, 835, 836, 815, 898, 919, 920, 899], 2)
    ops.element('stdBrick', 597, *[815, 836, 837, 816, 899, 920, 921, 900], 2)
    ops.element('stdBrick', 598, *[816, 837, 838, 817, 900, 921, 922, 901], 2)
    ops.element('stdBrick', 599, *[817, 838, 839, 818, 901, 922, 923, 902], 2)
    ops.element('stdBrick', 600, *[818, 839, 840, 819, 902, 923, 924, 903], 2)
    ops.element('stdBrick', 601, *[844, 843, 841, 842, 928, 927, 925, 926], 2)
    ops.element('stdBrick', 602, *[843, 846, 845, 841, 927, 930, 929, 925], 2)
    ops.element('stdBrick', 603, *[846, 848, 847, 845, 930, 932, 931, 929], 2)
    ops.element('stdBrick', 604, *[848, 850, 849, 847, 932, 934, 933, 931], 2)
    ops.element('stdBrick', 605, *[850, 852, 851, 849, 934, 936, 935, 933], 2)
    ops.element('stdBrick', 606, *[852, 854, 853, 851, 936, 938, 937, 935], 2)
    ops.element('stdBrick', 607, *[854, 856, 855, 853, 938, 940, 939, 937], 2)
    ops.element('stdBrick', 608, *[856, 858, 857, 855, 940, 942, 941, 939], 2)
    ops.element('stdBrick', 609, *[858, 860, 859, 857, 942, 944, 943, 941], 2)
    ops.element('stdBrick', 610, *[860, 862, 861, 859, 944, 946, 945, 943], 2)
    ops.element('stdBrick', 611, *[862, 864, 863, 861, 946, 948, 947, 945], 2)
    ops.element('stdBrick', 612, *[863, 864, 866, 865, 947, 948, 950, 949], 2)
    ops.element('stdBrick', 613, *[865, 866, 868, 867, 949, 950, 952, 951], 2)
    ops.element('stdBrick', 614, *[867, 868, 870, 869, 951, 952, 954, 953], 2)
    ops.element('stdBrick', 615, *[869, 870, 872, 871, 953, 954, 956, 955], 2)
    ops.element('stdBrick', 616, *[871, 872, 874, 873, 955, 956, 958, 957], 2)
    ops.element('stdBrick', 617, *[873, 874, 876, 875, 957, 958, 960, 959], 2)
    ops.element('stdBrick', 618, *[875, 876, 878, 877, 959, 960, 962, 961], 2)
    ops.element('stdBrick', 619, *[877, 878, 880, 879, 961, 962, 964, 963], 2)
    ops.element('stdBrick', 620, *[879, 880, 882, 881, 963, 964, 966, 965], 2)
    ops.element('stdBrick', 621, *[884, 883, 843, 844, 968, 967, 927, 928], 2)
    ops.element('stdBrick', 622, *[883, 885, 846, 843, 967, 969, 930, 927], 2)
    ops.element('stdBrick', 623, *[885, 886, 848, 846, 969, 970, 932, 930], 2)
    ops.element('stdBrick', 624, *[886, 887, 850, 848, 970, 971, 934, 932], 2)
    ops.element('stdBrick', 625, *[887, 888, 852, 850, 971, 972, 936, 934], 2)
    ops.element('stdBrick', 626, *[888, 889, 854, 852, 972, 973, 938, 936], 2)
    ops.element('stdBrick', 627, *[889, 890, 856, 854, 973, 974, 940, 938], 2)
    ops.element('stdBrick', 628, *[890, 891, 858, 856, 974, 975, 942, 940], 2)
    ops.element('stdBrick', 629, *[891, 892, 860, 858, 975, 976, 944, 942], 2)
    ops.element('stdBrick', 630, *[892, 893, 862, 860, 976, 977, 946, 944], 2)
    ops.element('stdBrick', 631, *[893, 894, 864, 862, 977, 978, 948, 946], 2)
    ops.element('stdBrick', 632, *[864, 894, 895, 866, 948, 978, 979, 950], 2)
    ops.element('stdBrick', 633, *[866, 895, 896, 868, 950, 979, 980, 952], 2)
    ops.element('stdBrick', 634, *[868, 896, 897, 870, 952, 980, 981, 954], 2)
    ops.element('stdBrick', 635, *[870, 897, 898, 872, 954, 981, 982, 956], 2)
    ops.element('stdBrick', 636, *[872, 898, 899, 874, 956, 982, 983, 958], 2)
    ops.element('stdBrick', 637, *[874, 899, 900, 876, 958, 983, 984, 960], 2)
    ops.element('stdBrick', 638, *[876, 900, 901, 878, 960, 984, 985, 962], 2)
    ops.element('stdBrick', 639, *[878, 901, 902, 880, 962, 985, 986, 964], 2)
    ops.element('stdBrick', 640, *[880, 902, 903, 882, 964, 986, 987, 966], 2)
    ops.element('stdBrick', 641, *[905, 904, 883, 884, 989, 988, 967, 968], 2)
    ops.element('stdBrick', 642, *[904, 906, 885, 883, 988, 990, 969, 967], 2)
    ops.element('stdBrick', 643, *[906, 907, 886, 885, 990, 991, 970, 969], 2)
    ops.element('stdBrick', 644, *[907, 908, 887, 886, 991, 992, 971, 970], 2)
    ops.element('stdBrick', 645, *[908, 909, 888, 887, 992, 993, 972, 971], 2)
    ops.element('stdBrick', 646, *[909, 910, 889, 888, 993, 994, 973, 972], 2)
    ops.element('stdBrick', 647, *[910, 911, 890, 889, 994, 995, 974, 973], 2)
    ops.element('stdBrick', 648, *[911, 912, 891, 890, 995, 996, 975, 974], 2)
    ops.element('stdBrick', 649, *[912, 913, 892, 891, 996, 997, 976, 975], 2)
    ops.element('stdBrick', 650, *[913, 914, 893, 892, 997, 998, 977, 976], 2)
    ops.element('stdBrick', 651, *[914, 915, 894, 893, 998, 999, 978, 977], 2)
    ops.element('stdBrick', 652, *[894, 915, 916, 895, 978, 999, 1000, 979], 2)
    ops.element('stdBrick', 653, *
                [895, 916, 917, 896, 979, 1000, 1001, 980], 2)
    ops.element('stdBrick', 654, *
                [896, 917, 918, 897, 980, 1001, 1002, 981], 2)
    ops.element('stdBrick', 655, *
                [897, 918, 919, 898, 981, 1002, 1003, 982], 2)
    ops.element('stdBrick', 656, *
                [898, 919, 920, 899, 982, 1003, 1004, 983], 2)
    ops.element('stdBrick', 657, *
                [899, 920, 921, 900, 983, 1004, 1005, 984], 2)
    ops.element('stdBrick', 658, *
                [900, 921, 922, 901, 984, 1005, 1006, 985], 2)
    ops.element('stdBrick', 659, *
                [901, 922, 923, 902, 985, 1006, 1007, 986], 2)
    ops.element('stdBrick', 660, *
                [902, 923, 924, 903, 986, 1007, 1008, 987], 2)
    ops.element('stdBrick', 661, *[928, 927, 925,
                926, 1012, 1011, 1009, 1010], 2)
    ops.element('stdBrick', 662, *[927, 930, 929,
                925, 1011, 1014, 1013, 1009], 2)
    ops.element('stdBrick', 663, *[930, 932, 931,
                929, 1014, 1016, 1015, 1013], 2)
    ops.element('stdBrick', 664, *[932, 934, 933,
                931, 1016, 1018, 1017, 1015], 2)
    ops.element('stdBrick', 665, *[934, 936, 935,
                933, 1018, 1020, 1019, 1017], 2)
    ops.element('stdBrick', 666, *[936, 938, 937,
                935, 1020, 1022, 1021, 1019], 2)
    ops.element('stdBrick', 667, *[938, 940, 939,
                937, 1022, 1024, 1023, 1021], 2)
    ops.element('stdBrick', 668, *[940, 942, 941,
                939, 1024, 1026, 1025, 1023], 2)
    ops.element('stdBrick', 669, *[942, 944, 943,
                941, 1026, 1028, 1027, 1025], 2)
    ops.element('stdBrick', 670, *[944, 946, 945,
                943, 1028, 1030, 1029, 1027], 2)
    ops.element('stdBrick', 671, *[946, 948, 947,
                945, 1030, 1032, 1031, 1029], 2)
    ops.element('stdBrick', 672, *[947, 948, 950,
                949, 1031, 1032, 1034, 1033], 2)
    ops.element('stdBrick', 673, *[949, 950, 952,
                951, 1033, 1034, 1036, 1035], 2)
    ops.element('stdBrick', 674, *[951, 952, 954,
                953, 1035, 1036, 1038, 1037], 2)
    ops.element('stdBrick', 675, *[953, 954, 956,
                955, 1037, 1038, 1040, 1039], 2)
    ops.element('stdBrick', 676, *[955, 956, 958,
                957, 1039, 1040, 1042, 1041], 2)
    ops.element('stdBrick', 677, *[957, 958, 960,
                959, 1041, 1042, 1044, 1043], 2)
    ops.element('stdBrick', 678, *[959, 960, 962,
                961, 1043, 1044, 1046, 1045], 2)
    ops.element('stdBrick', 679, *[961, 962, 964,
                963, 1045, 1046, 1048, 1047], 2)
    ops.element('stdBrick', 680, *[963, 964, 966,
                965, 1047, 1048, 1050, 1049], 2)
    ops.element('stdBrick', 681, *[968, 967, 927,
                928, 1052, 1051, 1011, 1012], 2)
    ops.element('stdBrick', 682, *[967, 969, 930,
                927, 1051, 1053, 1014, 1011], 2)
    ops.element('stdBrick', 683, *[969, 970, 932,
                930, 1053, 1054, 1016, 1014], 2)
    ops.element('stdBrick', 684, *[970, 971, 934,
                932, 1054, 1055, 1018, 1016], 2)
    ops.element('stdBrick', 685, *[971, 972, 936,
                934, 1055, 1056, 1020, 1018], 2)
    ops.element('stdBrick', 686, *[972, 973, 938,
                936, 1056, 1057, 1022, 1020], 2)
    ops.element('stdBrick', 687, *[973, 974, 940,
                938, 1057, 1058, 1024, 1022], 2)
    ops.element('stdBrick', 688, *[974, 975, 942,
                940, 1058, 1059, 1026, 1024], 2)
    ops.element('stdBrick', 689, *[975, 976, 944,
                942, 1059, 1060, 1028, 1026], 2)
    ops.element('stdBrick', 690, *[976, 977, 946,
                944, 1060, 1061, 1030, 1028], 2)
    ops.element('stdBrick', 691, *[977, 978, 948,
                946, 1061, 1062, 1032, 1030], 2)
    ops.element('stdBrick', 692, *[948, 978, 979,
                950, 1032, 1062, 1063, 1034], 2)
    ops.element('stdBrick', 693, *[950, 979, 980,
                952, 1034, 1063, 1064, 1036], 2)
    ops.element('stdBrick', 694, *[952, 980, 981,
                954, 1036, 1064, 1065, 1038], 2)
    ops.element('stdBrick', 695, *[954, 981, 982,
                956, 1038, 1065, 1066, 1040], 2)
    ops.element('stdBrick', 696, *[956, 982, 983,
                958, 1040, 1066, 1067, 1042], 2)
    ops.element('stdBrick', 697, *[958, 983, 984,
                960, 1042, 1067, 1068, 1044], 2)
    ops.element('stdBrick', 698, *[960, 984, 985,
                962, 1044, 1068, 1069, 1046], 2)
    ops.element('stdBrick', 699, *[962, 985, 986,
                964, 1046, 1069, 1070, 1048], 2)
    ops.element('stdBrick', 700, *[964, 986, 987,
                966, 1048, 1070, 1071, 1050], 2)
    ops.element('stdBrick', 701, *[989, 988, 967,
                968, 1073, 1072, 1051, 1052], 2)
    ops.element('stdBrick', 702, *[988, 990, 969,
                967, 1072, 1074, 1053, 1051], 2)
    ops.element('stdBrick', 703, *[990, 991, 970,
                969, 1074, 1075, 1054, 1053], 2)
    ops.element('stdBrick', 704, *[991, 992, 971,
                970, 1075, 1076, 1055, 1054], 2)
    ops.element('stdBrick', 705, *[992, 993, 972,
                971, 1076, 1077, 1056, 1055], 2)
    ops.element('stdBrick', 706, *[993, 994, 973,
                972, 1077, 1078, 1057, 1056], 2)
    ops.element('stdBrick', 707, *[994, 995, 974,
                973, 1078, 1079, 1058, 1057], 2)
    ops.element('stdBrick', 708, *[995, 996, 975,
                974, 1079, 1080, 1059, 1058], 2)
    ops.element('stdBrick', 709, *[996, 997, 976,
                975, 1080, 1081, 1060, 1059], 2)
    ops.element('stdBrick', 710, *[997, 998, 977,
                976, 1081, 1082, 1061, 1060], 2)
    ops.element('stdBrick', 711, *[998, 999, 978,
                977, 1082, 1083, 1062, 1061], 2)
    ops.element('stdBrick', 712, *
                [978, 999, 1000, 979, 1062, 1083, 1084, 1063], 2)
    ops.element('stdBrick', 713, *[979, 1000, 1001,
                980, 1063, 1084, 1085, 1064], 2)
    ops.element('stdBrick', 714, *[980, 1001, 1002,
                981, 1064, 1085, 1086, 1065], 2)
    ops.element('stdBrick', 715, *[981, 1002, 1003,
                982, 1065, 1086, 1087, 1066], 2)
    ops.element('stdBrick', 716, *[982, 1003, 1004,
                983, 1066, 1087, 1088, 1067], 2)
    ops.element('stdBrick', 717, *[983, 1004, 1005,
                984, 1067, 1088, 1089, 1068], 2)
    ops.element('stdBrick', 718, *[984, 1005, 1006,
                985, 1068, 1089, 1090, 1069], 2)
    ops.element('stdBrick', 719, *[985, 1006, 1007,
                986, 1069, 1090, 1091, 1070], 2)
    ops.element('stdBrick', 720, *[986, 1007, 1008,
                987, 1070, 1091, 1092, 1071], 2)
    ops.element('stdBrick', 721, *[1012, 1011, 1009,
                1010, 1096, 1095, 1093, 1094], 2)
    ops.element('stdBrick', 722, *[1011, 1014, 1013,
                1009, 1095, 1098, 1097, 1093], 2)
    ops.element('stdBrick', 723, *[1014, 1016, 1015,
                1013, 1098, 1100, 1099, 1097], 2)
    ops.element('stdBrick', 724, *[1016, 1018, 1017,
                1015, 1100, 1102, 1101, 1099], 2)
    ops.element('stdBrick', 725, *[1018, 1020, 1019,
                1017, 1102, 1104, 1103, 1101], 2)
    ops.element('stdBrick', 726, *[1020, 1022, 1021,
                1019, 1104, 1106, 1105, 1103], 2)
    ops.element('stdBrick', 727, *[1022, 1024, 1023,
                1021, 1106, 1108, 1107, 1105], 2)
    ops.element('stdBrick', 728, *[1024, 1026, 1025,
                1023, 1108, 1110, 1109, 1107], 2)
    ops.element('stdBrick', 729, *[1026, 1028, 1027,
                1025, 1110, 1112, 1111, 1109], 2)
    ops.element('stdBrick', 730, *[1028, 1030, 1029,
                1027, 1112, 1114, 1113, 1111], 2)
    ops.element('stdBrick', 731, *[1030, 1032, 1031,
                1029, 1114, 1116, 1115, 1113], 2)
    ops.element('stdBrick', 732, *[1031, 1032, 1034,
                1033, 1115, 1116, 1118, 1117], 2)
    ops.element('stdBrick', 733, *[1033, 1034, 1036,
                1035, 1117, 1118, 1120, 1119], 2)
    ops.element('stdBrick', 734, *[1035, 1036, 1038,
                1037, 1119, 1120, 1122, 1121], 2)
    ops.element('stdBrick', 735, *[1037, 1038, 1040,
                1039, 1121, 1122, 1124, 1123], 2)
    ops.element('stdBrick', 736, *[1039, 1040, 1042,
                1041, 1123, 1124, 1126, 1125], 2)
    ops.element('stdBrick', 737, *[1041, 1042, 1044,
                1043, 1125, 1126, 1128, 1127], 2)
    ops.element('stdBrick', 738, *[1043, 1044, 1046,
                1045, 1127, 1128, 1130, 1129], 2)
    ops.element('stdBrick', 739, *[1045, 1046, 1048,
                1047, 1129, 1130, 1132, 1131], 2)
    ops.element('stdBrick', 740, *[1047, 1048, 1050,
                1049, 1131, 1132, 1134, 1133], 2)
    ops.element('stdBrick', 741, *[1052, 1051, 1011,
                1012, 1136, 1135, 1095, 1096], 2)
    ops.element('stdBrick', 742, *[1051, 1053, 1014,
                1011, 1135, 1137, 1098, 1095], 2)
    ops.element('stdBrick', 743, *[1053, 1054, 1016,
                1014, 1137, 1138, 1100, 1098], 2)
    ops.element('stdBrick', 744, *[1054, 1055, 1018,
                1016, 1138, 1139, 1102, 1100], 2)
    ops.element('stdBrick', 745, *[1055, 1056, 1020,
                1018, 1139, 1140, 1104, 1102], 2)
    ops.element('stdBrick', 746, *[1056, 1057, 1022,
                1020, 1140, 1141, 1106, 1104], 2)
    ops.element('stdBrick', 747, *[1057, 1058, 1024,
                1022, 1141, 1142, 1108, 1106], 2)
    ops.element('stdBrick', 748, *[1058, 1059, 1026,
                1024, 1142, 1143, 1110, 1108], 2)
    ops.element('stdBrick', 749, *[1059, 1060, 1028,
                1026, 1143, 1144, 1112, 1110], 2)
    ops.element('stdBrick', 750, *[1060, 1061, 1030,
                1028, 1144, 1145, 1114, 1112], 2)
    ops.element('stdBrick', 751, *[1061, 1062, 1032,
                1030, 1145, 1146, 1116, 1114], 2)
    ops.element('stdBrick', 752, *[1032, 1062, 1063,
                1034, 1116, 1146, 1147, 1118], 2)
    ops.element('stdBrick', 753, *[1034, 1063, 1064,
                1036, 1118, 1147, 1148, 1120], 2)
    ops.element('stdBrick', 754, *[1036, 1064, 1065,
                1038, 1120, 1148, 1149, 1122], 2)
    ops.element('stdBrick', 755, *[1038, 1065, 1066,
                1040, 1122, 1149, 1150, 1124], 2)
    ops.element('stdBrick', 756, *[1040, 1066, 1067,
                1042, 1124, 1150, 1151, 1126], 2)
    ops.element('stdBrick', 757, *[1042, 1067, 1068,
                1044, 1126, 1151, 1152, 1128], 2)
    ops.element('stdBrick', 758, *[1044, 1068, 1069,
                1046, 1128, 1152, 1153, 1130], 2)
    ops.element('stdBrick', 759, *[1046, 1069, 1070,
                1048, 1130, 1153, 1154, 1132], 2)
    ops.element('stdBrick', 760, *[1048, 1070, 1071,
                1050, 1132, 1154, 1155, 1134], 2)
    ops.element('stdBrick', 761, *[1073, 1072, 1051,
                1052, 1157, 1156, 1135, 1136], 2)
    ops.element('stdBrick', 762, *[1072, 1074, 1053,
                1051, 1156, 1158, 1137, 1135], 2)
    ops.element('stdBrick', 763, *[1074, 1075, 1054,
                1053, 1158, 1159, 1138, 1137], 2)
    ops.element('stdBrick', 764, *[1075, 1076, 1055,
                1054, 1159, 1160, 1139, 1138], 2)
    ops.element('stdBrick', 765, *[1076, 1077, 1056,
                1055, 1160, 1161, 1140, 1139], 2)
    ops.element('stdBrick', 766, *[1077, 1078, 1057,
                1056, 1161, 1162, 1141, 1140], 2)
    ops.element('stdBrick', 767, *[1078, 1079, 1058,
                1057, 1162, 1163, 1142, 1141], 2)
    ops.element('stdBrick', 768, *[1079, 1080, 1059,
                1058, 1163, 1164, 1143, 1142], 2)
    ops.element('stdBrick', 769, *[1080, 1081, 1060,
                1059, 1164, 1165, 1144, 1143], 2)
    ops.element('stdBrick', 770, *[1081, 1082, 1061,
                1060, 1165, 1166, 1145, 1144], 2)
    ops.element('stdBrick', 771, *[1082, 1083, 1062,
                1061, 1166, 1167, 1146, 1145], 2)
    ops.element('stdBrick', 772, *[1062, 1083, 1084,
                1063, 1146, 1167, 1168, 1147], 2)
    ops.element('stdBrick', 773, *[1063, 1084, 1085,
                1064, 1147, 1168, 1169, 1148], 2)
    ops.element('stdBrick', 774, *[1064, 1085, 1086,
                1065, 1148, 1169, 1170, 1149], 2)
    ops.element('stdBrick', 775, *[1065, 1086, 1087,
                1066, 1149, 1170, 1171, 1150], 2)
    ops.element('stdBrick', 776, *[1066, 1087, 1088,
                1067, 1150, 1171, 1172, 1151], 2)
    ops.element('stdBrick', 777, *[1067, 1088, 1089,
                1068, 1151, 1172, 1173, 1152], 2)
    ops.element('stdBrick', 778, *[1068, 1089, 1090,
                1069, 1152, 1173, 1174, 1153], 2)
    ops.element('stdBrick', 779, *[1069, 1090, 1091,
                1070, 1153, 1174, 1175, 1154], 2)
    ops.element('stdBrick', 780, *[1070, 1091, 1092,
                1071, 1154, 1175, 1176, 1155], 2)
    ops.element('stdBrick', 781, *[1096, 1095, 1093,
                1094, 1180, 1179, 1177, 1178], 2)
    ops.element('stdBrick', 782, *[1095, 1098, 1097,
                1093, 1179, 1182, 1181, 1177], 2)
    ops.element('stdBrick', 783, *[1098, 1100, 1099,
                1097, 1182, 1184, 1183, 1181], 2)
    ops.element('stdBrick', 784, *[1100, 1102, 1101,
                1099, 1184, 1186, 1185, 1183], 2)
    ops.element('stdBrick', 785, *[1102, 1104, 1103,
                1101, 1186, 1188, 1187, 1185], 2)
    ops.element('stdBrick', 786, *[1104, 1106, 1105,
                1103, 1188, 1190, 1189, 1187], 2)
    ops.element('stdBrick', 787, *[1106, 1108, 1107,
                1105, 1190, 1192, 1191, 1189], 2)
    ops.element('stdBrick', 788, *[1108, 1110, 1109,
                1107, 1192, 1194, 1193, 1191], 2)
    ops.element('stdBrick', 789, *[1110, 1112, 1111,
                1109, 1194, 1196, 1195, 1193], 2)
    ops.element('stdBrick', 790, *[1112, 1114, 1113,
                1111, 1196, 1198, 1197, 1195], 2)
    ops.element('stdBrick', 791, *[1114, 1116, 1115,
                1113, 1198, 1200, 1199, 1197], 2)
    ops.element('stdBrick', 792, *[1115, 1116, 1118,
                1117, 1199, 1200, 1202, 1201], 2)
    ops.element('stdBrick', 793, *[1117, 1118, 1120,
                1119, 1201, 1202, 1204, 1203], 2)
    ops.element('stdBrick', 794, *[1119, 1120, 1122,
                1121, 1203, 1204, 1206, 1205], 2)
    ops.element('stdBrick', 795, *[1121, 1122, 1124,
                1123, 1205, 1206, 1208, 1207], 2)
    ops.element('stdBrick', 796, *[1123, 1124, 1126,
                1125, 1207, 1208, 1210, 1209], 2)
    ops.element('stdBrick', 797, *[1125, 1126, 1128,
                1127, 1209, 1210, 1212, 1211], 2)
    ops.element('stdBrick', 798, *[1127, 1128, 1130,
                1129, 1211, 1212, 1214, 1213], 2)
    ops.element('stdBrick', 799, *[1129, 1130, 1132,
                1131, 1213, 1214, 1216, 1215], 2)
    ops.element('stdBrick', 800, *[1131, 1132, 1134,
                1133, 1215, 1216, 1218, 1217], 2)
    ops.element('stdBrick', 801, *[1136, 1135, 1095,
                1096, 1220, 1219, 1179, 1180], 2)
    ops.element('stdBrick', 802, *[1135, 1137, 1098,
                1095, 1219, 1221, 1182, 1179], 2)
    ops.element('stdBrick', 803, *[1137, 1138, 1100,
                1098, 1221, 1222, 1184, 1182], 2)
    ops.element('stdBrick', 804, *[1138, 1139, 1102,
                1100, 1222, 1223, 1186, 1184], 2)
    ops.element('stdBrick', 805, *[1139, 1140, 1104,
                1102, 1223, 1224, 1188, 1186], 2)
    ops.element('stdBrick', 806, *[1140, 1141, 1106,
                1104, 1224, 1225, 1190, 1188], 2)
    ops.element('stdBrick', 807, *[1141, 1142, 1108,
                1106, 1225, 1226, 1192, 1190], 2)
    ops.element('stdBrick', 808, *[1142, 1143, 1110,
                1108, 1226, 1227, 1194, 1192], 2)
    ops.element('stdBrick', 809, *[1143, 1144, 1112,
                1110, 1227, 1228, 1196, 1194], 2)
    ops.element('stdBrick', 810, *[1144, 1145, 1114,
                1112, 1228, 1229, 1198, 1196], 2)
    ops.element('stdBrick', 811, *[1145, 1146, 1116,
                1114, 1229, 1230, 1200, 1198], 2)
    ops.element('stdBrick', 812, *[1116, 1146, 1147,
                1118, 1200, 1230, 1231, 1202], 2)
    ops.element('stdBrick', 813, *[1118, 1147, 1148,
                1120, 1202, 1231, 1232, 1204], 2)
    ops.element('stdBrick', 814, *[1120, 1148, 1149,
                1122, 1204, 1232, 1233, 1206], 2)
    ops.element('stdBrick', 815, *[1122, 1149, 1150,
                1124, 1206, 1233, 1234, 1208], 2)
    ops.element('stdBrick', 816, *[1124, 1150, 1151,
                1126, 1208, 1234, 1235, 1210], 2)
    ops.element('stdBrick', 817, *[1126, 1151, 1152,
                1128, 1210, 1235, 1236, 1212], 2)
    ops.element('stdBrick', 818, *[1128, 1152, 1153,
                1130, 1212, 1236, 1237, 1214], 2)
    ops.element('stdBrick', 819, *[1130, 1153, 1154,
                1132, 1214, 1237, 1238, 1216], 2)
    ops.element('stdBrick', 820, *[1132, 1154, 1155,
                1134, 1216, 1238, 1239, 1218], 2)
    ops.element('stdBrick', 821, *[1157, 1156, 1135,
                1136, 1241, 1240, 1219, 1220], 2)
    ops.element('stdBrick', 822, *[1156, 1158, 1137,
                1135, 1240, 1242, 1221, 1219], 2)
    ops.element('stdBrick', 823, *[1158, 1159, 1138,
                1137, 1242, 1243, 1222, 1221], 2)
    ops.element('stdBrick', 824, *[1159, 1160, 1139,
                1138, 1243, 1244, 1223, 1222], 2)
    ops.element('stdBrick', 825, *[1160, 1161, 1140,
                1139, 1244, 1245, 1224, 1223], 2)
    ops.element('stdBrick', 826, *[1161, 1162, 1141,
                1140, 1245, 1246, 1225, 1224], 2)
    ops.element('stdBrick', 827, *[1162, 1163, 1142,
                1141, 1246, 1247, 1226, 1225], 2)
    ops.element('stdBrick', 828, *[1163, 1164, 1143,
                1142, 1247, 1248, 1227, 1226], 2)
    ops.element('stdBrick', 829, *[1164, 1165, 1144,
                1143, 1248, 1249, 1228, 1227], 2)
    ops.element('stdBrick', 830, *[1165, 1166, 1145,
                1144, 1249, 1250, 1229, 1228], 2)
    ops.element('stdBrick', 831, *[1166, 1167, 1146,
                1145, 1250, 1251, 1230, 1229], 2)
    ops.element('stdBrick', 832, *[1146, 1167, 1168,
                1147, 1230, 1251, 1252, 1231], 2)
    ops.element('stdBrick', 833, *[1147, 1168, 1169,
                1148, 1231, 1252, 1253, 1232], 2)
    ops.element('stdBrick', 834, *[1148, 1169, 1170,
                1149, 1232, 1253, 1254, 1233], 2)
    ops.element('stdBrick', 835, *[1149, 1170, 1171,
                1150, 1233, 1254, 1255, 1234], 2)
    ops.element('stdBrick', 836, *[1150, 1171, 1172,
                1151, 1234, 1255, 1256, 1235], 2)
    ops.element('stdBrick', 837, *[1151, 1172, 1173,
                1152, 1235, 1256, 1257, 1236], 2)
    ops.element('stdBrick', 838, *[1152, 1173, 1174,
                1153, 1236, 1257, 1258, 1237], 2)
    ops.element('stdBrick', 839, *[1153, 1174, 1175,
                1154, 1237, 1258, 1259, 1238], 2)
    ops.element('stdBrick', 840, *[1154, 1175, 1176,
                1155, 1238, 1259, 1260, 1239], 2)
    ops.element('stdBrick', 841, *[1180, 1179, 1177,
                1178, 1264, 1263, 1261, 1262], 2)
    ops.element('stdBrick', 842, *[1179, 1182, 1181,
                1177, 1263, 1266, 1265, 1261], 2)
    ops.element('stdBrick', 843, *[1182, 1184, 1183,
                1181, 1266, 1268, 1267, 1265], 2)
    ops.element('stdBrick', 844, *[1184, 1186, 1185,
                1183, 1268, 1270, 1269, 1267], 2)
    ops.element('stdBrick', 845, *[1186, 1188, 1187,
                1185, 1270, 1272, 1271, 1269], 2)
    ops.element('stdBrick', 846, *[1188, 1190, 1189,
                1187, 1272, 1274, 1273, 1271], 2)
    ops.element('stdBrick', 847, *[1190, 1192, 1191,
                1189, 1274, 1276, 1275, 1273], 2)
    ops.element('stdBrick', 848, *[1192, 1194, 1193,
                1191, 1276, 1278, 1277, 1275], 2)
    ops.element('stdBrick', 849, *[1194, 1196, 1195,
                1193, 1278, 1280, 1279, 1277], 2)
    ops.element('stdBrick', 850, *[1196, 1198, 1197,
                1195, 1280, 1282, 1281, 1279], 2)
    ops.element('stdBrick', 851, *[1198, 1200, 1199,
                1197, 1282, 1284, 1283, 1281], 2)
    ops.element('stdBrick', 852, *[1199, 1200, 1202,
                1201, 1283, 1284, 1286, 1285], 2)
    ops.element('stdBrick', 853, *[1201, 1202, 1204,
                1203, 1285, 1286, 1288, 1287], 2)
    ops.element('stdBrick', 854, *[1203, 1204, 1206,
                1205, 1287, 1288, 1290, 1289], 2)
    ops.element('stdBrick', 855, *[1205, 1206, 1208,
                1207, 1289, 1290, 1292, 1291], 2)
    ops.element('stdBrick', 856, *[1207, 1208, 1210,
                1209, 1291, 1292, 1294, 1293], 2)
    ops.element('stdBrick', 857, *[1209, 1210, 1212,
                1211, 1293, 1294, 1296, 1295], 2)
    ops.element('stdBrick', 858, *[1211, 1212, 1214,
                1213, 1295, 1296, 1298, 1297], 2)
    ops.element('stdBrick', 859, *[1213, 1214, 1216,
                1215, 1297, 1298, 1300, 1299], 2)
    ops.element('stdBrick', 860, *[1215, 1216, 1218,
                1217, 1299, 1300, 1302, 1301], 2)
    ops.element('stdBrick', 861, *[1220, 1219, 1179,
                1180, 1304, 1303, 1263, 1264], 2)
    ops.element('stdBrick', 862, *[1219, 1221, 1182,
                1179, 1303, 1305, 1266, 1263], 2)
    ops.element('stdBrick', 863, *[1221, 1222, 1184,
                1182, 1305, 1306, 1268, 1266], 2)
    ops.element('stdBrick', 864, *[1222, 1223, 1186,
                1184, 1306, 1307, 1270, 1268], 2)
    ops.element('stdBrick', 865, *[1223, 1224, 1188,
                1186, 1307, 1308, 1272, 1270], 2)
    ops.element('stdBrick', 866, *[1224, 1225, 1190,
                1188, 1308, 1309, 1274, 1272], 2)
    ops.element('stdBrick', 867, *[1225, 1226, 1192,
                1190, 1309, 1310, 1276, 1274], 2)
    ops.element('stdBrick', 868, *[1226, 1227, 1194,
                1192, 1310, 1311, 1278, 1276], 2)
    ops.element('stdBrick', 869, *[1227, 1228, 1196,
                1194, 1311, 1312, 1280, 1278], 2)
    ops.element('stdBrick', 870, *[1228, 1229, 1198,
                1196, 1312, 1313, 1282, 1280], 2)
    ops.element('stdBrick', 871, *[1229, 1230, 1200,
                1198, 1313, 1314, 1284, 1282], 2)
    ops.element('stdBrick', 872, *[1200, 1230, 1231,
                1202, 1284, 1314, 1315, 1286], 2)
    ops.element('stdBrick', 873, *[1202, 1231, 1232,
                1204, 1286, 1315, 1316, 1288], 2)
    ops.element('stdBrick', 874, *[1204, 1232, 1233,
                1206, 1288, 1316, 1317, 1290], 2)
    ops.element('stdBrick', 875, *[1206, 1233, 1234,
                1208, 1290, 1317, 1318, 1292], 2)
    ops.element('stdBrick', 876, *[1208, 1234, 1235,
                1210, 1292, 1318, 1319, 1294], 2)
    ops.element('stdBrick', 877, *[1210, 1235, 1236,
                1212, 1294, 1319, 1320, 1296], 2)
    ops.element('stdBrick', 878, *[1212, 1236, 1237,
                1214, 1296, 1320, 1321, 1298], 2)
    ops.element('stdBrick', 879, *[1214, 1237, 1238,
                1216, 1298, 1321, 1322, 1300], 2)
    ops.element('stdBrick', 880, *[1216, 1238, 1239,
                1218, 1300, 1322, 1323, 1302], 2)
    ops.element('stdBrick', 881, *[1241, 1240, 1219,
                1220, 1325, 1324, 1303, 1304], 2)
    ops.element('stdBrick', 882, *[1240, 1242, 1221,
                1219, 1324, 1326, 1305, 1303], 2)
    ops.element('stdBrick', 883, *[1242, 1243, 1222,
                1221, 1326, 1327, 1306, 1305], 2)
    ops.element('stdBrick', 884, *[1243, 1244, 1223,
                1222, 1327, 1328, 1307, 1306], 2)
    ops.element('stdBrick', 885, *[1244, 1245, 1224,
                1223, 1328, 1329, 1308, 1307], 2)
    ops.element('stdBrick', 886, *[1245, 1246, 1225,
                1224, 1329, 1330, 1309, 1308], 2)
    ops.element('stdBrick', 887, *[1246, 1247, 1226,
                1225, 1330, 1331, 1310, 1309], 2)
    ops.element('stdBrick', 888, *[1247, 1248, 1227,
                1226, 1331, 1332, 1311, 1310], 2)
    ops.element('stdBrick', 889, *[1248, 1249, 1228,
                1227, 1332, 1333, 1312, 1311], 2)
    ops.element('stdBrick', 890, *[1249, 1250, 1229,
                1228, 1333, 1334, 1313, 1312], 2)
    ops.element('stdBrick', 891, *[1250, 1251, 1230,
                1229, 1334, 1335, 1314, 1313], 2)
    ops.element('stdBrick', 892, *[1230, 1251, 1252,
                1231, 1314, 1335, 1336, 1315], 2)
    ops.element('stdBrick', 893, *[1231, 1252, 1253,
                1232, 1315, 1336, 1337, 1316], 2)
    ops.element('stdBrick', 894, *[1232, 1253, 1254,
                1233, 1316, 1337, 1338, 1317], 2)
    ops.element('stdBrick', 895, *[1233, 1254, 1255,
                1234, 1317, 1338, 1339, 1318], 2)
    ops.element('stdBrick', 896, *[1234, 1255, 1256,
                1235, 1318, 1339, 1340, 1319], 2)
    ops.element('stdBrick', 897, *[1235, 1256, 1257,
                1236, 1319, 1340, 1341, 1320], 2)
    ops.element('stdBrick', 898, *[1236, 1257, 1258,
                1237, 1320, 1341, 1342, 1321], 2)
    ops.element('stdBrick', 899, *[1237, 1258, 1259,
                1238, 1321, 1342, 1343, 1322], 2)
    ops.element('stdBrick', 900, *[1238, 1259, 1260,
                1239, 1322, 1343, 1344, 1323], 2)

    # Set the mass at a node.
    ops.mass(1, *[11.054203237135827, 11.054203237135827, 11.054203237135827])
    ops.mass(2, *[5.5271016185679285, 5.5271016185679285, 5.5271016185679285])
    ops.mass(3, *[23.518250282787594, 23.518250282787594, 23.518250282787594])
    ops.mass(4, *[11.759125141393827, 11.759125141393827, 11.759125141393827])
    ops.mass(5, *[21.5721742808583, 21.5721742808583, 21.5721742808583])
    ops.mass(6, *[10.786087140429181, 10.786087140429181, 10.786087140429181])
    ops.mass(7, *[45.776354911053794, 45.776354911053794, 45.776354911053794])
    ops.mass(8, *[22.88817745552696, 22.88817745552696, 22.88817745552696])
    ops.mass(9, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(10, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(11, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(12, *[45.77635491105367, 45.77635491105367, 45.77635491105367])
    ops.mass(13, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(14, *[23.518250282787562, 23.518250282787562, 23.518250282787562])
    ops.mass(15, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(16, *[45.77635491105373, 45.77635491105373, 45.77635491105373])
    ops.mass(17, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(18, *[23.518250282787566, 23.518250282787566, 23.518250282787566])
    ops.mass(19, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(20, *[45.77635491105377, 45.77635491105377, 45.77635491105377])
    ops.mass(21, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(22, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(23, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(24, *[45.776354911053744, 45.776354911053744, 45.776354911053744])
    ops.mass(25, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(26, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(27, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(28, *[45.77635491105371, 45.77635491105371, 45.77635491105371])
    ops.mass(29, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(30, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(31, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(32, *[45.77635491105367, 45.77635491105367, 45.77635491105367])
    ops.mass(33, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(34, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(35, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(36, *[45.77635491105367, 45.77635491105367, 45.77635491105367])
    ops.mass(37, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(38, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(39, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(40, *[45.7763549110537, 45.7763549110537, 45.7763549110537])
    ops.mass(41, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(42, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(43, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(44, *[45.776354911053744, 45.776354911053744, 45.776354911053744])
    ops.mass(45, *[11.054203237135827, 11.054203237135827, 11.054203237135827])
    ops.mass(46, *[23.518250282787594, 23.518250282787594, 23.518250282787594])
    ops.mass(47, *[21.57217428085827, 21.57217428085827, 21.57217428085827])
    ops.mass(48, *[45.7763549110538, 45.7763549110538, 45.7763549110538])
    ops.mass(49, *[11.054203237135795, 11.054203237135795, 11.054203237135795])
    ops.mass(50, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(51, *[21.572174280858206, 21.572174280858206, 21.572174280858206])
    ops.mass(52, *[45.77635491105365, 45.77635491105365, 45.77635491105365])
    ops.mass(53, *[11.054203237135795, 11.054203237135795, 11.054203237135795])
    ops.mass(54, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(55, *[21.572174280858206, 21.572174280858206, 21.572174280858206])
    ops.mass(56, *[45.776354911053645, 45.776354911053645, 45.776354911053645])
    ops.mass(57, *[11.054203237135827, 11.054203237135827, 11.054203237135827])
    ops.mass(58, *[23.518250282787623, 23.518250282787623, 23.518250282787623])
    ops.mass(59, *[21.57217428085827, 21.57217428085827, 21.57217428085827])
    ops.mass(60, *[45.77635491105383, 45.77635491105383, 45.77635491105383])
    ops.mass(61, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(62, *[23.518250282787566, 23.518250282787566, 23.518250282787566])
    ops.mass(63, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(64, *[45.77635491105374, 45.77635491105374, 45.77635491105374])
    ops.mass(65, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(66, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(67, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(68, *[45.77635491105367, 45.77635491105367, 45.77635491105367])
    ops.mass(69, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(70, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(71, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(72, *[45.77635491105367, 45.77635491105367, 45.77635491105367])
    ops.mass(73, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(74, *[23.518250282787534, 23.518250282787534, 23.518250282787534])
    ops.mass(75, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(76, *[45.77635491105367, 45.77635491105367, 45.77635491105367])
    ops.mass(77, *[11.054203237135797, 11.054203237135797, 11.054203237135797])
    ops.mass(78, *[23.518250282787562, 23.518250282787562, 23.518250282787562])
    ops.mass(79, *[21.572174280858242, 21.572174280858242, 21.572174280858242])
    ops.mass(80, *[45.77635491105373, 45.77635491105373, 45.77635491105373])
    ops.mass(81, *[5.527101618567898, 5.527101618567898, 5.527101618567898])
    ops.mass(82, *[11.759125141393797, 11.759125141393797, 11.759125141393797])
    ops.mass(83, *[10.786087140429121, 10.786087140429121, 10.786087140429121])
    ops.mass(84, *[22.8881774555269, 22.8881774555269, 22.8881774555269])
    ops.mass(85, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(86, *[13.168968949909768, 13.168968949909768, 13.168968949909768])
    ops.mass(87, *[51.0403676097282, 51.0403676097282, 51.0403676097282])
    ops.mass(88, *[25.52018380486416, 25.52018380486416, 25.52018380486416])
    ops.mass(89, *[26.337937899819448, 26.337937899819448, 26.337937899819448])
    ops.mass(90, *[51.04036760972811, 51.04036760972811, 51.04036760972811])
    ops.mass(91, *[26.337937899819508, 26.337937899819508, 26.337937899819508])
    ops.mass(92, *[51.04036760972822, 51.04036760972822, 51.04036760972822])
    ops.mass(93, *[26.337937899819508, 26.337937899819508, 26.337937899819508])
    ops.mass(94, *[51.04036760972829, 51.04036760972829, 51.04036760972829])
    ops.mass(95, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(96, *[51.040367609728264, 51.040367609728264, 51.040367609728264])
    ops.mass(97, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(98, *[51.04036760972823, 51.04036760972823, 51.04036760972823])
    ops.mass(99, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(100, *[51.04036760972819, 51.04036760972819, 51.04036760972819])
    ops.mass(101, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(102, *[51.04036760972819, 51.04036760972819, 51.04036760972819])
    ops.mass(103, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(104, *[51.04036760972822, 51.04036760972822, 51.04036760972822])
    ops.mass(105, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(106, *[51.040367609728264,
             51.040367609728264, 51.040367609728264])
    ops.mass(107, *[26.337937899819508,
             26.337937899819508, 26.337937899819508])
    ops.mass(108, *[51.04036760972829, 51.04036760972829, 51.04036760972829])
    ops.mass(109, *[26.33793789981942, 26.33793789981942, 26.33793789981942])
    ops.mass(110, *[51.04036760972808, 51.04036760972808, 51.04036760972808])
    ops.mass(111, *[26.33793789981942, 26.33793789981942, 26.33793789981942])
    ops.mass(112, *[51.04036760972808, 51.04036760972808, 51.04036760972808])
    ops.mass(113, *[26.337937899819536,
             26.337937899819536, 26.337937899819536])
    ops.mass(114, *[51.04036760972832, 51.04036760972832, 51.04036760972832])
    ops.mass(115, *[26.337937899819508,
             26.337937899819508, 26.337937899819508])
    ops.mass(116, *[51.04036760972826, 51.04036760972826, 51.04036760972826])
    ops.mass(117, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(118, *[51.04036760972819, 51.04036760972819, 51.04036760972819])
    ops.mass(119, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(120, *[51.04036760972819, 51.04036760972819, 51.04036760972819])
    ops.mass(121, *[26.33793789981945, 26.33793789981945, 26.33793789981945])
    ops.mass(122, *[51.040367609728136,
             51.040367609728136, 51.040367609728136])
    ops.mass(123, *[26.33793789981948, 26.33793789981948, 26.33793789981948])
    ops.mass(124, *[51.04036760972819, 51.04036760972819, 51.04036760972819])
    ops.mass(125, *[13.168968949909768,
             13.168968949909768, 13.168968949909768])
    ops.mass(126, *[25.52018380486416, 25.52018380486416, 25.52018380486416])
    ops.mass(127, *[13.873890854167712,
             13.873890854167712, 13.873890854167712])
    ops.mass(128, *[6.93694542708387, 6.93694542708387, 6.93694542708387])
    ops.mass(129, *[26.836186979532705,
             26.836186979532705, 26.836186979532705])
    ops.mass(130, *[13.418093489766381,
             13.418093489766381, 13.418093489766381])
    ops.mass(131, *[13.873890854167712,
             13.873890854167712, 13.873890854167712])
    ops.mass(132, *[26.83618697953267, 26.83618697953267, 26.83618697953267])
    ops.mass(133, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(134, *[26.83618697953273, 26.83618697953273, 26.83618697953273])
    ops.mass(135, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(136, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(137, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(138, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(139, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(140, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(141, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(142, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(143, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(144, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(145, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(146, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(147, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(148, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(149, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(150, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(151, *[13.87389085416768, 13.87389085416768, 13.87389085416768])
    ops.mass(152, *[26.83618697953264, 26.83618697953264, 26.83618697953264])
    ops.mass(153, *[13.87389085416768, 13.87389085416768, 13.87389085416768])
    ops.mass(154, *[26.83618697953264, 26.83618697953264, 26.83618697953264])
    ops.mass(155, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(156, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(157, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(158, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(159, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(160, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(161, *[13.87389085416774, 13.87389085416774, 13.87389085416774])
    ops.mass(162, *[26.836186979532762,
             26.836186979532762, 26.836186979532762])
    ops.mass(163, *[13.873890854167712,
             13.873890854167712, 13.873890854167712])
    ops.mass(164, *[26.836186979532705,
             26.836186979532705, 26.836186979532705])
    ops.mass(165, *[13.873890854167712,
             13.873890854167712, 13.873890854167712])
    ops.mass(166, *[26.8361869795327, 26.8361869795327, 26.8361869795327])
    ops.mass(167, *[6.93694542708387, 6.93694542708387, 6.93694542708387])
    ops.mass(168, *[13.418093489766381,
             13.418093489766381, 13.418093489766381])
    ops.mass(169, *[20.466195381943237,
             20.466195381943237, 20.466195381943237])
    ops.mass(170, *[10.233097690971633,
             10.233097690971633, 10.233097690971633])
    ops.mass(171, *[43.20244038266966, 43.20244038266966, 43.20244038266966])
    ops.mass(172, *[21.60122019133487, 21.60122019133487, 21.60122019133487])
    ops.mass(173, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(174, *[43.202440382669565,
             43.202440382669565, 43.202440382669565])
    ops.mass(175, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(176, *[43.20244038266962, 43.20244038266962, 43.20244038266962])
    ops.mass(177, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(178, *[43.20244038266968, 43.20244038266968, 43.20244038266968])
    ops.mass(179, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(180, *[43.20244038266968, 43.20244038266968, 43.20244038266968])
    ops.mass(181, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(182, *[43.20244038266965, 43.20244038266965, 43.20244038266965])
    ops.mass(183, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(184, *[43.20244038266962, 43.20244038266962, 43.20244038266962])
    ops.mass(185, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(186, *[43.20244038266962, 43.20244038266962, 43.20244038266962])
    ops.mass(187, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(188, *[43.20244038266965, 43.20244038266965, 43.20244038266965])
    ops.mass(189, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(190, *[43.20244038266968, 43.20244038266968, 43.20244038266968])
    ops.mass(191, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(192, *[43.20244038266968, 43.20244038266968, 43.20244038266968])
    ops.mass(193, *[20.466195381943145,
             20.466195381943145, 20.466195381943145])
    ops.mass(194, *[43.202440382669536,
             43.202440382669536, 43.202440382669536])
    ops.mass(195, *[20.466195381943145,
             20.466195381943145, 20.466195381943145])
    ops.mass(196, *[43.202440382669536,
             43.202440382669536, 43.202440382669536])
    ops.mass(197, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(198, *[43.20244038266968, 43.20244038266968, 43.20244038266968])
    ops.mass(199, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(200, *[43.20244038266962, 43.20244038266962, 43.20244038266962])
    ops.mass(201, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(202, *[43.20244038266959, 43.20244038266959, 43.20244038266959])
    ops.mass(203, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(204, *[43.20244038266962, 43.20244038266962, 43.20244038266962])
    ops.mass(205, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(206, *[43.20244038266962, 43.20244038266962, 43.20244038266962])
    ops.mass(207, *[20.466195381943205,
             20.466195381943205, 20.466195381943205])
    ops.mass(208, *[43.20244038266965, 43.20244038266965, 43.20244038266965])
    ops.mass(209, *[10.233097690971602,
             10.233097690971602, 10.233097690971602])
    ops.mass(210, *[21.60122019133484, 21.60122019133484, 21.60122019133484])
    ops.mass(211, *[47.742539620236045,
             47.742539620236045, 47.742539620236045])
    ops.mass(212, *[23.871269810118086,
             23.871269810118086, 23.871269810118086])
    ops.mass(213, *[47.74253962023593, 47.74253962023593, 47.74253962023593])
    ops.mass(214, *[47.742539620236016,
             47.742539620236016, 47.742539620236016])
    ops.mass(215, *[47.7425396202361, 47.7425396202361, 47.7425396202361])
    ops.mass(216, *[47.7425396202361, 47.7425396202361, 47.7425396202361])
    ops.mass(217, *[47.74253962023607, 47.74253962023607, 47.74253962023607])
    ops.mass(218, *[47.742539620236045,
             47.742539620236045, 47.742539620236045])
    ops.mass(219, *[47.742539620236045,
             47.742539620236045, 47.742539620236045])
    ops.mass(220, *[47.74253962023607, 47.74253962023607, 47.74253962023607])
    ops.mass(221, *[47.7425396202361, 47.7425396202361, 47.7425396202361])
    ops.mass(222, *[47.74253962023614, 47.74253962023614, 47.74253962023614])
    ops.mass(223, *[47.74253962023596, 47.74253962023596, 47.74253962023596])
    ops.mass(224, *[47.74253962023596, 47.74253962023596, 47.74253962023596])
    ops.mass(225, *[47.742539620236144,
             47.742539620236144, 47.742539620236144])
    ops.mass(226, *[47.742539620236045,
             47.742539620236045, 47.742539620236045])
    ops.mass(227, *[47.742539620236016,
             47.742539620236016, 47.742539620236016])
    ops.mass(228, *[47.742539620236045,
             47.742539620236045, 47.742539620236045])
    ops.mass(229, *[47.742539620236016,
             47.742539620236016, 47.742539620236016])
    ops.mass(230, *[47.742539620236045,
             47.742539620236045, 47.742539620236045])
    ops.mass(231, *[23.871269810118054,
             23.871269810118054, 23.871269810118054])
    ops.mass(232, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(233, *[12.503147309754844,
             12.503147309754844, 12.503147309754844])
    ops.mass(234, *[25.00629461950957, 25.00629461950957, 25.00629461950957])
    ops.mass(235, *[25.0062946195096, 25.0062946195096, 25.0062946195096])
    ops.mass(236, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(237, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(238, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(239, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(240, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(241, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(242, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(243, *[25.00629461950966, 25.00629461950966, 25.00629461950966])
    ops.mass(244, *[25.00629461950957, 25.00629461950957, 25.00629461950957])
    ops.mass(245, *[25.006294619509575,
             25.006294619509575, 25.006294619509575])
    ops.mass(246, *[25.00629461950966, 25.00629461950966, 25.00629461950966])
    ops.mass(247, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(248, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(249, *[25.006294619509628,
             25.006294619509628, 25.006294619509628])
    ops.mass(250, *[25.0062946195096, 25.0062946195096, 25.0062946195096])
    ops.mass(251, *[25.0062946195096, 25.0062946195096, 25.0062946195096])
    ops.mass(252, *[12.503147309754816,
             12.503147309754816, 12.503147309754816])
    ops.mass(253, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(254, *[9.646593729425751, 9.646593729425751, 9.646593729425751])
    ops.mass(255, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(256, *[20.260639707801467,
             20.260639707801467, 20.260639707801467])
    ops.mass(257, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(258, *[40.52127941560281, 40.52127941560281, 40.52127941560281])
    ops.mass(259, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(260, *[40.52127941560284, 40.52127941560284, 40.52127941560284])
    ops.mass(261, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(262, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(263, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(264, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(265, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(266, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(267, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(268, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(269, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(270, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(271, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(272, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(273, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(274, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(275, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(276, *[40.5212794156029, 40.5212794156029, 40.5212794156029])
    ops.mass(277, *[19.293187458851442,
             19.293187458851442, 19.293187458851442])
    ops.mass(278, *[40.521279415602784,
             40.521279415602784, 40.521279415602784])
    ops.mass(279, *[19.293187458851442,
             19.293187458851442, 19.293187458851442])
    ops.mass(280, *[40.521279415602784,
             40.521279415602784, 40.521279415602784])
    ops.mass(281, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(282, *[40.5212794156029, 40.5212794156029, 40.5212794156029])
    ops.mass(283, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(284, *[40.52127941560284, 40.52127941560284, 40.52127941560284])
    ops.mass(285, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(286, *[40.52127941560284, 40.52127941560284, 40.52127941560284])
    ops.mass(287, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(288, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(289, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(290, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(291, *[19.293187458851502,
             19.293187458851502, 19.293187458851502])
    ops.mass(292, *[40.52127941560287, 40.52127941560287, 40.52127941560287])
    ops.mass(293, *[9.646593729425751, 9.646593729425751, 9.646593729425751])
    ops.mass(294, *[20.260639707801435,
             20.260639707801435, 20.260639707801435])
    ops.mass(295, *[44.391088411402606,
             44.391088411402606, 44.391088411402606])
    ops.mass(296, *[22.195544205701367,
             22.195544205701367, 22.195544205701367])
    ops.mass(297, *[44.39108841140248, 44.39108841140248, 44.39108841140248])
    ops.mass(298, *[44.39108841140252, 44.39108841140252, 44.39108841140252])
    ops.mass(299, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(300, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(301, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(302, *[44.391088411402585,
             44.391088411402585, 44.391088411402585])
    ops.mass(303, *[44.39108841140258, 44.39108841140258, 44.39108841140258])
    ops.mass(304, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(305, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(306, *[44.39108841140264, 44.39108841140264, 44.39108841140264])
    ops.mass(307, *[44.39108841140252, 44.39108841140252, 44.39108841140252])
    ops.mass(308, *[44.39108841140252, 44.39108841140252, 44.39108841140252])
    ops.mass(309, *[44.391088411402635,
             44.391088411402635, 44.391088411402635])
    ops.mass(310, *[44.39108841140252, 44.39108841140252, 44.39108841140252])
    ops.mass(311, *[44.39108841140252, 44.39108841140252, 44.39108841140252])
    ops.mass(312, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(313, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(314, *[44.39108841140255, 44.39108841140255, 44.39108841140255])
    ops.mass(315, *[22.195544205701275,
             22.195544205701275, 22.195544205701275])
    ops.mass(316, *[23.16299645465124, 23.16299645465124, 23.16299645465124])
    ops.mass(317, *[11.58149822732565, 11.58149822732565, 11.58149822732565])
    ops.mass(318, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(319, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(320, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(321, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(322, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(323, *[23.162996454651207,
             23.162996454651207, 23.162996454651207])
    ops.mass(324, *[23.16299645465121, 23.16299645465121, 23.16299645465121])
    ops.mass(325, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(326, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(327, *[23.162996454651243,
             23.162996454651243, 23.162996454651243])
    ops.mass(328, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(329, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(330, *[23.16299645465124, 23.16299645465124, 23.16299645465124])
    ops.mass(331, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(332, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(333, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(334, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(335, *[23.16299645465118, 23.16299645465118, 23.16299645465118])
    ops.mass(336, *[11.58149822732559, 11.58149822732559, 11.58149822732559])
    ops.mass(337, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(338, *[9.026575255791563, 9.026575255791563, 9.026575255791563])
    ops.mass(339, *[37.73287200985339, 37.73287200985339, 37.73287200985339])
    ops.mass(340, *[18.86643600492674, 18.86643600492674, 18.86643600492674])
    ops.mass(341, *[18.053150511583066,
             18.053150511583066, 18.053150511583066])
    ops.mass(342, *[37.7328720098533, 37.7328720098533, 37.7328720098533])
    ops.mass(343, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(344, *[37.73287200985337, 37.73287200985337, 37.73287200985337])
    ops.mass(345, *[18.053150511583127,
             18.053150511583127, 18.053150511583127])
    ops.mass(346, *[37.732872009853395,
             37.732872009853395, 37.732872009853395])
    ops.mass(347, *[18.053150511583127,
             18.053150511583127, 18.053150511583127])
    ops.mass(348, *[37.73287200985337, 37.73287200985337, 37.73287200985337])
    ops.mass(349, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(350, *[37.73287200985333, 37.73287200985333, 37.73287200985333])
    ops.mass(351, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(352, *[37.73287200985334, 37.73287200985334, 37.73287200985334])
    ops.mass(353, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(354, *[37.73287200985333, 37.73287200985333, 37.73287200985333])
    ops.mass(355, *[18.053150511583066,
             18.053150511583066, 18.053150511583066])
    ops.mass(356, *[37.7328720098533, 37.7328720098533, 37.7328720098533])
    ops.mass(357, *[18.053150511583066,
             18.053150511583066, 18.053150511583066])
    ops.mass(358, *[37.7328720098533, 37.7328720098533, 37.7328720098533])
    ops.mass(359, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(360, *[37.732872009853395,
             37.732872009853395, 37.732872009853395])
    ops.mass(361, *[18.053150511583038,
             18.053150511583038, 18.053150511583038])
    ops.mass(362, *[37.7328720098533, 37.7328720098533, 37.7328720098533])
    ops.mass(363, *[18.053150511583034,
             18.053150511583034, 18.053150511583034])
    ops.mass(364, *[37.7328720098533, 37.7328720098533, 37.7328720098533])
    ops.mass(365, *[18.053150511583127,
             18.053150511583127, 18.053150511583127])
    ops.mass(366, *[37.73287200985342, 37.73287200985342, 37.73287200985342])
    ops.mass(367, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(368, *[37.73287200985333, 37.73287200985333, 37.73287200985333])
    ops.mass(369, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(370, *[37.73287200985334, 37.73287200985334, 37.73287200985334])
    ops.mass(371, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(372, *[37.73287200985333, 37.73287200985333, 37.73287200985333])
    ops.mass(373, *[18.053150511583066,
             18.053150511583066, 18.053150511583066])
    ops.mass(374, *[37.7328720098533, 37.7328720098533, 37.7328720098533])
    ops.mass(375, *[18.053150511583098,
             18.053150511583098, 18.053150511583098])
    ops.mass(376, *[37.73287200985337, 37.73287200985337, 37.73287200985337])
    ops.mass(377, *[9.026575255791563, 9.026575255791563, 9.026575255791563])
    ops.mass(378, *[18.86643600492671, 18.86643600492671, 18.86643600492671])
    ops.mass(379, *[40.986013983227785,
             40.986013983227785, 40.986013983227785])
    ops.mass(380, *[20.49300699161394, 20.49300699161394, 20.49300699161394])
    ops.mass(381, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(382, *[40.98601398322773, 40.98601398322773, 40.98601398322773])
    ops.mass(383, *[40.98601398322773, 40.98601398322773, 40.98601398322773])
    ops.mass(384, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(385, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(386, *[40.98601398322773, 40.98601398322773, 40.98601398322773])
    ops.mass(387, *[40.98601398322773, 40.98601398322773, 40.98601398322773])
    ops.mass(388, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(389, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(390, *[40.98601398322782, 40.98601398322782, 40.98601398322782])
    ops.mass(391, *[40.98601398322773, 40.98601398322773, 40.98601398322773])
    ops.mass(392, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(393, *[40.986013983227785,
             40.986013983227785, 40.986013983227785])
    ops.mass(394, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(395, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(396, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(397, *[40.9860139832277, 40.9860139832277, 40.9860139832277])
    ops.mass(398, *[40.98601398322773, 40.98601398322773, 40.98601398322773])
    ops.mass(399, *[20.493006991613882,
             20.493006991613882, 20.493006991613882])
    ops.mass(400, *[21.306292484957496,
             21.306292484957496, 21.306292484957496])
    ops.mass(401, *[10.653146242478762,
             10.653146242478762, 10.653146242478762])
    ops.mass(402, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(403, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(404, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(405, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(406, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(407, *[21.306292484957496,
             21.306292484957496, 21.306292484957496])
    ops.mass(408, *[21.306292484957496,
             21.306292484957496, 21.306292484957496])
    ops.mass(409, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(410, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(411, *[21.306292484957524,
             21.306292484957524, 21.306292484957524])
    ops.mass(412, *[21.306292484957464,
             21.306292484957464, 21.306292484957464])
    ops.mass(413, *[21.30629248495743, 21.30629248495743, 21.30629248495743])
    ops.mass(414, *[21.306292484957496,
             21.306292484957496, 21.306292484957496])
    ops.mass(415, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(416, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(417, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(418, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(419, *[21.30629248495746, 21.30629248495746, 21.30629248495746])
    ops.mass(420, *[10.653146242478732,
             10.653146242478732, 10.653146242478732])
    ops.mass(421, *[16.746084540138025,
             16.746084540138025, 16.746084540138025])
    ops.mass(422, *[8.373042270069043, 8.373042270069043, 8.373042270069043])
    ops.mass(423, *[34.83721816542123, 34.83721816542123, 34.83721816542123])
    ops.mass(424, *[17.41860908271067, 17.41860908271067, 17.41860908271067])
    ops.mass(425, *[16.746084540137964,
             16.746084540137964, 16.746084540137964])
    ops.mass(426, *[34.8372181654211, 34.8372181654211, 34.8372181654211])
    ops.mass(427, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(428, *[34.83721816542116, 34.83721816542116, 34.83721816542116])
    ops.mass(429, *[16.746084540138025,
             16.746084540138025, 16.746084540138025])
    ops.mass(430, *[34.83721816542119, 34.83721816542119, 34.83721816542119])
    ops.mass(431, *[16.746084540138025,
             16.746084540138025, 16.746084540138025])
    ops.mass(432, *[34.83721816542116, 34.83721816542116, 34.83721816542116])
    ops.mass(433, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(434, *[34.837218165421135,
             34.837218165421135, 34.837218165421135])
    ops.mass(435, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(436, *[34.837218165421135,
             34.837218165421135, 34.837218165421135])
    ops.mass(437, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(438, *[34.837218165421135,
             34.837218165421135, 34.837218165421135])
    ops.mass(439, *[16.746084540137964,
             16.746084540137964, 16.746084540137964])
    ops.mass(440, *[34.8372181654211, 34.8372181654211, 34.8372181654211])
    ops.mass(441, *[16.746084540137964,
             16.746084540137964, 16.746084540137964])
    ops.mass(442, *[34.8372181654211, 34.8372181654211, 34.8372181654211])
    ops.mass(443, *[16.74608454013803, 16.74608454013803, 16.74608454013803])
    ops.mass(444, *[34.83721816542122, 34.83721816542122, 34.83721816542122])
    ops.mass(445, *[16.746084540137964,
             16.746084540137964, 16.746084540137964])
    ops.mass(446, *[34.837218165421135,
             34.837218165421135, 34.837218165421135])
    ops.mass(447, *[16.746084540137964,
             16.746084540137964, 16.746084540137964])
    ops.mass(448, *[34.83721816542113, 34.83721816542113, 34.83721816542113])
    ops.mass(449, *[16.746084540138053,
             16.746084540138053, 16.746084540138053])
    ops.mass(450, *[34.837218165421255,
             34.837218165421255, 34.837218165421255])
    ops.mass(451, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(452, *[34.837218165421135,
             34.837218165421135, 34.837218165421135])
    ops.mass(453, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(454, *[34.837218165421135,
             34.837218165421135, 34.837218165421135])
    ops.mass(455, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(456, *[34.837218165421135,
             34.837218165421135, 34.837218165421135])
    ops.mass(457, *[16.746084540137964,
             16.746084540137964, 16.746084540137964])
    ops.mass(458, *[34.8372181654211, 34.8372181654211, 34.8372181654211])
    ops.mass(459, *[16.746084540137996,
             16.746084540137996, 16.746084540137996])
    ops.mass(460, *[34.83721816542116, 34.83721816542116, 34.83721816542116])
    ops.mass(461, *[8.37304227006901, 8.37304227006901, 8.37304227006901])
    ops.mass(462, *[17.41860908271061, 17.41860908271061, 17.41860908271061])
    ops.mass(463, *[37.52731633571159, 37.52731633571159, 37.52731633571159])
    ops.mass(464, *[18.763658167855837,
             18.763658167855837, 18.763658167855837])
    ops.mass(465, *[37.527316335711504,
             37.527316335711504, 37.527316335711504])
    ops.mass(466, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(467, *[37.52731633571156, 37.52731633571156, 37.52731633571156])
    ops.mass(468, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(469, *[37.527316335711504,
             37.527316335711504, 37.527316335711504])
    ops.mass(470, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(471, *[37.52731633571156, 37.52731633571156, 37.52731633571156])
    ops.mass(472, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(473, *[37.527316335711504,
             37.527316335711504, 37.527316335711504])
    ops.mass(474, *[37.527316335711625,
             37.527316335711625, 37.527316335711625])
    ops.mass(475, *[37.52731633571156, 37.52731633571156, 37.52731633571156])
    ops.mass(476, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(477, *[37.527316335711625,
             37.527316335711625, 37.527316335711625])
    ops.mass(478, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(479, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(480, *[37.52731633571156, 37.52731633571156, 37.52731633571156])
    ops.mass(481, *[37.52731633571153, 37.52731633571153, 37.52731633571153])
    ops.mass(482, *[37.52731633571156, 37.52731633571156, 37.52731633571156])
    ops.mass(483, *[18.76365816785581, 18.76365816785581, 18.76365816785581])
    ops.mass(484, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(485, *[9.718091355214213, 9.718091355214213, 9.718091355214213])
    ops.mass(486, *[19.436182710428366,
             19.436182710428366, 19.436182710428366])
    ops.mass(487, *[19.436182710428366,
             19.436182710428366, 19.436182710428366])
    ops.mass(488, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(489, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(490, *[19.436182710428366,
             19.436182710428366, 19.436182710428366])
    ops.mass(491, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(492, *[19.436182710428426,
             19.436182710428426, 19.436182710428426])
    ops.mass(493, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(494, *[19.436182710428366,
             19.436182710428366, 19.436182710428366])
    ops.mass(495, *[19.436182710428426,
             19.436182710428426, 19.436182710428426])
    ops.mass(496, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(497, *[19.436182710428366,
             19.436182710428366, 19.436182710428366])
    ops.mass(498, *[19.436182710428426,
             19.436182710428426, 19.436182710428426])
    ops.mass(499, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(500, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(501, *[19.436182710428426,
             19.436182710428426, 19.436182710428426])
    ops.mass(502, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(503, *[19.436182710428398,
             19.436182710428398, 19.436182710428398])
    ops.mass(504, *[9.718091355214213, 9.718091355214213, 9.718091355214213])
    ops.mass(505, *[15.371989544516282,
             15.371989544516282, 15.371989544516282])
    ops.mass(506, *[7.685994772258157, 7.685994772258157, 7.685994772258157])
    ops.mass(507, *[31.834317882306415,
             31.834317882306415, 31.834317882306415])
    ops.mass(508, *[15.91715894115325, 15.91715894115325, 15.91715894115325])
    ops.mass(509, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(510, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(511, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(512, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(513, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(514, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(515, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(516, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(517, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(518, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(519, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(520, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(521, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(522, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(523, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(524, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(525, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(526, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(527, *[15.371989544516282,
             15.371989544516282, 15.371989544516282])
    ops.mass(528, *[31.83431788230641, 31.83431788230641, 31.83431788230641])
    ops.mass(529, *[15.371989544516225,
             15.371989544516225, 15.371989544516225])
    ops.mass(530, *[31.834317882306326,
             31.834317882306326, 31.834317882306326])
    ops.mass(531, *[15.371989544516225,
             15.371989544516225, 15.371989544516225])
    ops.mass(532, *[31.834317882306326,
             31.834317882306326, 31.834317882306326])
    ops.mass(533, *[15.371989544516282,
             15.371989544516282, 15.371989544516282])
    ops.mass(534, *[31.834317882306443,
             31.834317882306443, 31.834317882306443])
    ops.mass(535, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(536, *[31.83431788230635, 31.83431788230635, 31.83431788230635])
    ops.mass(537, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(538, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(539, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(540, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(541, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(542, *[31.834317882306323,
             31.834317882306323, 31.834317882306323])
    ops.mass(543, *[15.371989544516252,
             15.371989544516252, 15.371989544516252])
    ops.mass(544, *[31.83431788230635, 31.83431788230635, 31.83431788230635])
    ops.mass(545, *[7.685994772258127, 7.685994772258127, 7.685994772258127])
    ops.mass(546, *[15.91715894115319, 15.91715894115319, 15.91715894115319])
    ops.mass(547, *[34.01499546885408, 34.01499546885408, 34.01499546885408])
    ops.mass(548, *[17.007497734427098,
             17.007497734427098, 17.007497734427098])
    ops.mass(549, *[34.01499546885396, 34.01499546885396, 34.01499546885396])
    ops.mass(550, *[34.01499546885396, 34.01499546885396, 34.01499546885396])
    ops.mass(551, *[34.014995468854025,
             34.014995468854025, 34.014995468854025])
    ops.mass(552, *[34.014995468854025,
             34.014995468854025, 34.014995468854025])
    ops.mass(553, *[34.01499546885399, 34.01499546885399, 34.01499546885399])
    ops.mass(554, *[34.01499546885405, 34.01499546885405, 34.01499546885405])
    ops.mass(555, *[34.01499546885408, 34.01499546885408, 34.01499546885408])
    ops.mass(556, *[34.014995468854025,
             34.014995468854025, 34.014995468854025])
    ops.mass(557, *[34.01499546885396, 34.01499546885396, 34.01499546885396])
    ops.mass(558, *[34.01499546885408, 34.01499546885408, 34.01499546885408])
    ops.mass(559, *[34.01499546885405, 34.01499546885405, 34.01499546885405])
    ops.mass(560, *[34.01499546885405, 34.01499546885405, 34.01499546885405])
    ops.mass(561, *[34.01499546885417, 34.01499546885417, 34.01499546885417])
    ops.mass(562, *[34.01499546885405, 34.01499546885405, 34.01499546885405])
    ops.mass(563, *[34.014995468854025,
             34.014995468854025, 34.014995468854025])
    ops.mass(564, *[34.01499546885408, 34.01499546885408, 34.01499546885408])
    ops.mass(565, *[34.014995468854025,
             34.014995468854025, 34.014995468854025])
    ops.mass(566, *[34.01499546885405, 34.01499546885405, 34.01499546885405])
    ops.mass(567, *[17.00749773442707, 17.00749773442707, 17.00749773442707])
    ops.mass(568, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(569, *[8.776333565532003, 8.776333565532003, 8.776333565532003])
    ops.mass(570, *[17.552667131063888,
             17.552667131063888, 17.552667131063888])
    ops.mass(571, *[17.552667131063888,
             17.552667131063888, 17.552667131063888])
    ops.mass(572, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(573, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(574, *[17.552667131063917,
             17.552667131063917, 17.552667131063917])
    ops.mass(575, *[17.552667131063977,
             17.552667131063977, 17.552667131063977])
    ops.mass(576, *[17.55266713106401, 17.55266713106401, 17.55266713106401])
    ops.mass(577, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(578, *[17.552667131063888,
             17.552667131063888, 17.552667131063888])
    ops.mass(579, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(580, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(581, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(582, *[17.55266713106401, 17.55266713106401, 17.55266713106401])
    ops.mass(583, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(584, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(585, *[17.55266713106401, 17.55266713106401, 17.55266713106401])
    ops.mass(586, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(587, *[17.55266713106395, 17.55266713106395, 17.55266713106395])
    ops.mass(588, *[8.776333565532003, 8.776333565532003, 8.776333565532003])
    ops.mass(589, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(590, *[6.965432762358937, 6.965432762358937, 6.965432762358937])
    ops.mass(591, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(592, *[14.362085580254488,
             14.362085580254488, 14.362085580254488])
    ops.mass(593, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(594, *[28.72417116050886, 28.72417116050886, 28.72417116050886])
    ops.mass(595, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(596, *[28.724171160508888,
             28.724171160508888, 28.724171160508888])
    ops.mass(597, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(598, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(599, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(600, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(601, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(602, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(603, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(604, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(605, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(606, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(607, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(608, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(609, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(610, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(611, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(612, *[28.724171160508945,
             28.724171160508945, 28.724171160508945])
    ops.mass(613, *[13.930865524717815,
             13.930865524717815, 13.930865524717815])
    ops.mass(614, *[28.72417116050886, 28.72417116050886, 28.72417116050886])
    ops.mass(615, *[13.930865524717815,
             13.930865524717815, 13.930865524717815])
    ops.mass(616, *[28.72417116050886, 28.72417116050886, 28.72417116050886])
    ops.mass(617, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(618, *[28.724171160508977,
             28.724171160508977, 28.724171160508977])
    ops.mass(619, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(620, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(621, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(622, *[28.724171160508888,
             28.724171160508888, 28.724171160508888])
    ops.mass(623, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(624, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(625, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(626, *[28.724171160508917,
             28.724171160508917, 28.724171160508917])
    ops.mass(627, *[13.930865524717873,
             13.930865524717873, 13.930865524717873])
    ops.mass(628, *[28.724171160508945,
             28.724171160508945, 28.724171160508945])
    ops.mass(629, *[6.965432762358937, 6.965432762358937, 6.965432762358937])
    ops.mass(630, *[14.362085580254488,
             14.362085580254488, 14.362085580254488])
    ops.mass(631, *[30.449051382655227,
             30.449051382655227, 30.449051382655227])
    ops.mass(632, *[15.224525691327655,
             15.224525691327655, 15.224525691327655])
    ops.mass(633, *[30.449051382655135,
             30.449051382655135, 30.449051382655135])
    ops.mass(634, *[30.449051382655163,
             30.449051382655163, 30.449051382655163])
    ops.mass(635, *[30.44905138265522, 30.44905138265522, 30.44905138265522])
    ops.mass(636, *[30.44905138265522, 30.44905138265522, 30.44905138265522])
    ops.mass(637, *[30.44905138265522, 30.44905138265522, 30.44905138265522])
    ops.mass(638, *[30.44905138265525, 30.44905138265525, 30.44905138265525])
    ops.mass(639, *[30.44905138265525, 30.44905138265525, 30.44905138265525])
    ops.mass(640, *[30.44905138265522, 30.44905138265522, 30.44905138265522])
    ops.mass(641, *[30.449051382655192,
             30.449051382655192, 30.449051382655192])
    ops.mass(642, *[30.44905138265525, 30.44905138265525, 30.44905138265525])
    ops.mass(643, *[30.449051382655195,
             30.449051382655195, 30.449051382655195])
    ops.mass(644, *[30.449051382655185,
             30.449051382655185, 30.449051382655185])
    ops.mass(645, *[30.449051382655313,
             30.449051382655313, 30.449051382655313])
    ops.mass(646, *[30.449051382655227,
             30.449051382655227, 30.449051382655227])
    ops.mass(647, *[30.449051382655192,
             30.449051382655192, 30.449051382655192])
    ops.mass(648, *[30.44905138265525, 30.44905138265525, 30.44905138265525])
    ops.mass(649, *[30.44905138265522, 30.44905138265522, 30.44905138265522])
    ops.mass(650, *[30.44905138265525, 30.44905138265525, 30.44905138265525])
    ops.mass(651, *[15.224525691327655,
             15.224525691327655, 15.224525691327655])
    ops.mass(652, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(653, *[7.827872873432104, 7.827872873432104, 7.827872873432104])
    ops.mass(654, *[15.655745746864149,
             15.655745746864149, 15.655745746864149])
    ops.mass(655, *[15.655745746864149,
             15.655745746864149, 15.655745746864149])
    ops.mass(656, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(657, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(658, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(659, *[15.655745746864207,
             15.655745746864207, 15.655745746864207])
    ops.mass(660, *[15.655745746864207,
             15.655745746864207, 15.655745746864207])
    ops.mass(661, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(662, *[15.655745746864149,
             15.655745746864149, 15.655745746864149])
    ops.mass(663, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(664, *[15.655745746864147,
             15.655745746864147, 15.655745746864147])
    ops.mass(665, *[15.655745746864147,
             15.655745746864147, 15.655745746864147])
    ops.mass(666, *[15.655745746864207,
             15.655745746864207, 15.655745746864207])
    ops.mass(667, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(668, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(669, *[15.655745746864207,
             15.655745746864207, 15.655745746864207])
    ops.mass(670, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(671, *[15.655745746864177,
             15.655745746864177, 15.655745746864177])
    ops.mass(672, *[7.827872873432104, 7.827872873432104, 7.827872873432104])
    ops.mass(673, *[12.422712480742824,
             12.422712480742824, 12.422712480742824])
    ops.mass(674, *[6.211356240371418, 6.211356240371418, 6.211356240371418])
    ops.mass(675, *[25.50677800002878, 25.50677800002878, 25.50677800002878])
    ops.mass(676, *[12.75338900001441, 12.75338900001441, 12.75338900001441])
    ops.mass(677, *[12.422712480742812,
             12.422712480742812, 12.422712480742812])
    ops.mass(678, *[25.50677800002874, 25.50677800002874, 25.50677800002874])
    ops.mass(679, *[12.422712480742817,
             12.422712480742817, 12.422712480742817])
    ops.mass(680, *[25.50677800002877, 25.50677800002877, 25.50677800002877])
    ops.mass(681, *[12.422712480742822,
             12.422712480742822, 12.422712480742822])
    ops.mass(682, *[25.506778000028806,
             25.506778000028806, 25.506778000028806])
    ops.mass(683, *[12.42271248074282, 12.42271248074282, 12.42271248074282])
    ops.mass(684, *[25.506778000028806,
             25.506778000028806, 25.506778000028806])
    ops.mass(685, *[12.422712480742822,
             12.422712480742822, 12.422712480742822])
    ops.mass(686, *[25.506778000028806,
             25.506778000028806, 25.506778000028806])
    ops.mass(687, *[12.422712480742819,
             12.422712480742819, 12.422712480742819])
    ops.mass(688, *[25.506778000028802,
             25.506778000028802, 25.506778000028802])
    ops.mass(689, *[12.422712480742819,
             12.422712480742819, 12.422712480742819])
    ops.mass(690, *[25.506778000028802,
             25.506778000028802, 25.506778000028802])
    ops.mass(691, *[12.422712480742819,
             12.422712480742819, 12.422712480742819])
    ops.mass(692, *[25.506778000028802,
             25.506778000028802, 25.506778000028802])
    ops.mass(693, *[12.422712480742819,
             12.422712480742819, 12.422712480742819])
    ops.mass(694, *[25.506778000028802,
             25.506778000028802, 25.506778000028802])
    ops.mass(695, *[12.422712480742828,
             12.422712480742828, 12.422712480742828])
    ops.mass(696, *[25.506778000028813,
             25.506778000028813, 25.506778000028813])
    ops.mass(697, *[12.422712480742781,
             12.422712480742781, 12.422712480742781])
    ops.mass(698, *[25.506778000028703,
             25.506778000028703, 25.506778000028703])
    ops.mass(699, *[12.422712480742778,
             12.422712480742778, 12.422712480742778])
    ops.mass(700, *[25.506778000028703,
             25.506778000028703, 25.506778000028703])
    ops.mass(701, *[12.422712480742828,
             12.422712480742828, 12.422712480742828])
    ops.mass(702, *[25.506778000028813,
             25.506778000028813, 25.506778000028813])
    ops.mass(703, *[12.422712480742815,
             12.422712480742815, 12.422712480742815])
    ops.mass(704, *[25.50677800002877, 25.50677800002877, 25.50677800002877])
    ops.mass(705, *[12.42271248074281, 12.42271248074281, 12.42271248074281])
    ops.mass(706, *[25.506778000028767,
             25.506778000028767, 25.506778000028767])
    ops.mass(707, *[12.422712480742815,
             12.422712480742815, 12.422712480742815])
    ops.mass(708, *[25.5067780000288, 25.5067780000288, 25.5067780000288])
    ops.mass(709, *[12.422712480742819,
             12.422712480742819, 12.422712480742819])
    ops.mass(710, *[25.506778000028802,
             25.506778000028802, 25.506778000028802])
    ops.mass(711, *[12.42271248074282, 12.42271248074282, 12.42271248074282])
    ops.mass(712, *[25.506778000028806,
             25.506778000028806, 25.506778000028806])
    ops.mass(713, *[6.211356240371412, 6.211356240371412, 6.211356240371412])
    ops.mass(714, *[12.753389000014405,
             12.753389000014405, 12.753389000014405])
    ops.mass(715, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(716, *[13.414742038557566,
             13.414742038557566, 13.414742038557566])
    ops.mass(717, *[26.829484077115012,
             26.829484077115012, 26.829484077115012])
    ops.mass(718, *[26.829484077115044,
             26.829484077115044, 26.829484077115044])
    ops.mass(719, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(720, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(721, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(722, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(723, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(724, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(725, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(726, *[26.8294840771151, 26.8294840771151, 26.8294840771151])
    ops.mass(727, *[26.829484077115012,
             26.829484077115012, 26.829484077115012])
    ops.mass(728, *[26.829484077114984,
             26.829484077114984, 26.829484077114984])
    ops.mass(729, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(730, *[26.829484077115044,
             26.829484077115044, 26.829484077115044])
    ops.mass(731, *[26.829484077115044,
             26.829484077115044, 26.829484077115044])
    ops.mass(732, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(733, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(734, *[26.829484077115072,
             26.829484077115072, 26.829484077115072])
    ops.mass(735, *[13.414742038557536,
             13.414742038557536, 13.414742038557536])
    ops.mass(736, *[13.745418557829115,
             13.745418557829115, 13.745418557829115])
    ops.mass(737, *[6.872709278914573, 6.872709278914573, 6.872709278914573])
    ops.mass(738, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(739, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(740, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(741, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(742, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(743, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(744, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(745, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(746, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(747, *[13.745418557829115,
             13.745418557829115, 13.745418557829115])
    ops.mass(748, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(749, *[13.745418557829057,
             13.745418557829057, 13.745418557829057])
    ops.mass(750, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(751, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(752, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(753, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(754, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(755, *[13.745418557829087,
             13.745418557829087, 13.745418557829087])
    ops.mass(756, *[6.872709278914543, 6.872709278914543, 6.872709278914543])
    ops.mass(757, *[10.847530412591096,
             10.847530412591096, 10.847530412591096])
    ops.mass(758, *[5.423765206295556, 5.423765206295556, 5.423765206295556])
    ops.mass(759, *[22.18213840086598, 22.18213840086598, 22.18213840086598])
    ops.mass(760, *[11.091069200433004,
             11.091069200433004, 11.091069200433004])
    ops.mass(761, *[10.847530412591073,
             10.847530412591073, 10.847530412591073])
    ops.mass(762, *[22.182138400865945,
             22.182138400865945, 22.182138400865945])
    ops.mass(763, *[10.84753041259108, 10.84753041259108, 10.84753041259108])
    ops.mass(764, *[22.18213840086596, 22.18213840086596, 22.18213840086596])
    ops.mass(765, *[10.847530412591091,
             10.847530412591091, 10.847530412591091])
    ops.mass(766, *[22.182138400865977,
             22.182138400865977, 22.182138400865977])
    ops.mass(767, *[10.847530412591095,
             10.847530412591095, 10.847530412591095])
    ops.mass(768, *[22.182138400865984,
             22.182138400865984, 22.182138400865984])
    ops.mass(769, *[10.847530412591095,
             10.847530412591095, 10.847530412591095])
    ops.mass(770, *[22.18213840086598, 22.18213840086598, 22.18213840086598])
    ops.mass(771, *[10.847530412591086,
             10.847530412591086, 10.847530412591086])
    ops.mass(772, *[22.182138400865966,
             22.182138400865966, 22.182138400865966])
    ops.mass(773, *[10.847530412591084,
             10.847530412591084, 10.847530412591084])
    ops.mass(774, *[22.182138400865973,
             22.182138400865973, 22.182138400865973])
    ops.mass(775, *[10.847530412591087,
             10.847530412591087, 10.847530412591087])
    ops.mass(776, *[22.182138400865973,
             22.182138400865973, 22.182138400865973])
    ops.mass(777, *[10.847530412591087,
             10.847530412591087, 10.847530412591087])
    ops.mass(778, *[22.182138400865973,
             22.182138400865973, 22.182138400865973])
    ops.mass(779, *[10.847530412591107,
             10.847530412591107, 10.847530412591107])
    ops.mass(780, *[22.182138400866002,
             22.182138400866002, 22.182138400866002])
    ops.mass(781, *[10.847530412591073,
             10.847530412591073, 10.847530412591073])
    ops.mass(782, *[22.182138400865924,
             22.182138400865924, 22.182138400865924])
    ops.mass(783, *[10.847530412591066,
             10.847530412591066, 10.847530412591066])
    ops.mass(784, *[22.18213840086591, 22.18213840086591, 22.18213840086591])
    ops.mass(785, *[10.847530412591102,
             10.847530412591102, 10.847530412591102])
    ops.mass(786, *[22.182138400866, 22.182138400866, 22.182138400866])
    ops.mass(787, *[10.847530412591079,
             10.847530412591079, 10.847530412591079])
    ops.mass(788, *[22.182138400865973,
             22.182138400865973, 22.182138400865973])
    ops.mass(789, *[10.84753041259107, 10.84753041259107, 10.84753041259107])
    ops.mass(790, *[22.182138400865952,
             22.182138400865952, 22.182138400865952])
    ops.mass(791, *[10.84753041259108, 10.84753041259108, 10.84753041259108])
    ops.mass(792, *[22.182138400865966,
             22.182138400865966, 22.182138400865966])
    ops.mass(793, *[10.847530412591084,
             10.847530412591084, 10.847530412591084])
    ops.mass(794, *[22.18213840086597, 22.18213840086597, 22.18213840086597])
    ops.mass(795, *[10.847530412591091,
             10.847530412591091, 10.847530412591091])
    ops.mass(796, *[22.182138400865973,
             22.182138400865973, 22.182138400865973])
    ops.mass(797, *[5.423765206295547, 5.423765206295547, 5.423765206295547])
    ops.mass(798, *[11.091069200432994,
             11.091069200432994, 11.091069200432994])
    ops.mass(799, *[23.15629355223358, 23.15629355223358, 23.15629355223358])
    ops.mass(800, *[11.578146776116817,
             11.578146776116817, 11.578146776116817])
    ops.mass(801, *[23.156293552233535,
             23.156293552233535, 23.156293552233535])
    ops.mass(802, *[23.156293552233546,
             23.156293552233546, 23.156293552233546])
    ops.mass(803, *[23.15629355223355, 23.15629355223355, 23.15629355223355])
    ops.mass(804, *[23.156293552233553,
             23.156293552233553, 23.156293552233553])
    ops.mass(805, *[23.156293552233546,
             23.156293552233546, 23.156293552233546])
    ops.mass(806, *[23.156293552233546,
             23.156293552233546, 23.156293552233546])
    ops.mass(807, *[23.15629355223355, 23.15629355223355, 23.15629355223355])
    ops.mass(808, *[23.156293552233546,
             23.156293552233546, 23.156293552233546])
    ops.mass(809, *[23.15629355223354, 23.15629355223354, 23.15629355223354])
    ops.mass(810, *[23.15629355223359, 23.15629355223359, 23.15629355223359])
    ops.mass(811, *[23.15629355223354, 23.15629355223354, 23.15629355223354])
    ops.mass(812, *[23.156293552233507,
             23.156293552233507, 23.156293552233507])
    ops.mass(813, *[23.15629355223357, 23.15629355223357, 23.15629355223357])
    ops.mass(814, *[23.156293552233553,
             23.156293552233553, 23.156293552233553])
    ops.mass(815, *[23.156293552233546,
             23.156293552233546, 23.156293552233546])
    ops.mass(816, *[23.156293552233546,
             23.156293552233546, 23.156293552233546])
    ops.mass(817, *[23.156293552233542,
             23.156293552233542, 23.156293552233542])
    ops.mass(818, *[23.15629355223355, 23.15629355223355, 23.15629355223355])
    ops.mass(819, *[11.57814677611678, 11.57814677611678, 11.57814677611678])
    ops.mass(820, *[11.821685563958699,
             11.821685563958699, 11.821685563958699])
    ops.mass(821, *[5.910842781979369, 5.910842781979369, 5.910842781979369])
    ops.mass(822, *[11.821685563958663,
             11.821685563958663, 11.821685563958663])
    ops.mass(823, *[11.821685563958663,
             11.821685563958663, 11.821685563958663])
    ops.mass(824, *[11.82168556395866, 11.82168556395866, 11.82168556395866])
    ops.mass(825, *[11.82168556395866, 11.82168556395866, 11.82168556395866])
    ops.mass(826, *[11.82168556395866, 11.82168556395866, 11.82168556395866])
    ops.mass(827, *[11.821685563958663,
             11.821685563958663, 11.821685563958663])
    ops.mass(828, *[11.821685563958663,
             11.821685563958663, 11.821685563958663])
    ops.mass(829, *[11.82168556395866, 11.82168556395866, 11.82168556395866])
    ops.mass(830, *[11.821685563958656,
             11.821685563958656, 11.821685563958656])
    ops.mass(831, *[11.821685563958695,
             11.821685563958695, 11.821685563958695])
    ops.mass(832, *[11.821685563958688,
             11.821685563958688, 11.821685563958688])
    ops.mass(833, *[11.821685563958656,
             11.821685563958656, 11.821685563958656])
    ops.mass(834, *[11.821685563958672,
             11.821685563958672, 11.821685563958672])
    ops.mass(835, *[11.821685563958663,
             11.821685563958663, 11.821685563958663])
    ops.mass(836, *[11.82168556395866, 11.82168556395866, 11.82168556395866])
    ops.mass(837, *[11.82168556395866, 11.82168556395866, 11.82168556395866])
    ops.mass(838, *[11.821685563958663,
             11.821685563958663, 11.821685563958663])
    ops.mass(839, *[11.821685563958667,
             11.821685563958667, 11.821685563958667])
    ops.mass(840, *[5.910842781979333, 5.910842781979333, 5.910842781979333])
    ops.mass(841, *[9.629836473381589, 9.629836473381589, 9.629836473381589])
    ops.mass(842, *[4.814918236690801, 4.814918236690801, 4.814918236690801])
    ops.mass(843, *[19.63056688054075, 19.63056688054075, 19.63056688054075])
    ops.mass(844, *[9.815283440270395, 9.815283440270395, 9.815283440270395])
    ops.mass(845, *[9.629836473381573, 9.629836473381573, 9.629836473381573])
    ops.mass(846, *[19.63056688054071, 19.63056688054071, 19.63056688054071])
    ops.mass(847, *[9.629836473381584, 9.629836473381584, 9.629836473381584])
    ops.mass(848, *[19.630566880540734,
             19.630566880540734, 19.630566880540734])
    ops.mass(849, *[9.629836473381594, 9.629836473381594, 9.629836473381594])
    ops.mass(850, *[19.630566880540762,
             19.630566880540762, 19.630566880540762])
    ops.mass(851, *[9.629836473381605, 9.629836473381605, 9.629836473381605])
    ops.mass(852, *[19.630566880540773,
             19.630566880540773, 19.630566880540773])
    ops.mass(853, *[9.629836473381605, 9.629836473381605, 9.629836473381605])
    ops.mass(854, *[19.630566880540766,
             19.630566880540766, 19.630566880540766])
    ops.mass(855, *[9.629836473381589, 9.629836473381589, 9.629836473381589])
    ops.mass(856, *[19.630566880540748,
             19.630566880540748, 19.630566880540748])
    ops.mass(857, *[9.629836473381586, 9.629836473381586, 9.629836473381586])
    ops.mass(858, *[19.63056688054075, 19.63056688054075, 19.63056688054075])
    ops.mass(859, *[9.62983647338159, 9.62983647338159, 9.62983647338159])
    ops.mass(860, *[19.630566880540755,
             19.630566880540755, 19.630566880540755])
    ops.mass(861, *[9.629836473381594, 9.629836473381594, 9.629836473381594])
    ops.mass(862, *[19.630566880540755,
             19.630566880540755, 19.630566880540755])
    ops.mass(863, *[9.629836473381609, 9.629836473381609, 9.629836473381609])
    ops.mass(864, *[19.630566880540794,
             19.630566880540794, 19.630566880540794])
    ops.mass(865, *[9.629836473381577, 9.629836473381577, 9.629836473381577])
    ops.mass(866, *[19.63056688054074, 19.63056688054074, 19.63056688054074])
    ops.mass(867, *[9.629836473381566, 9.629836473381566, 9.629836473381566])
    ops.mass(868, *[19.630566880540727,
             19.630566880540727, 19.630566880540727])
    ops.mass(869, *[9.629836473381598, 9.629836473381598, 9.629836473381598])
    ops.mass(870, *[19.63056688054079, 19.63056688054079, 19.63056688054079])
    ops.mass(871, *[9.629836473381586, 9.629836473381586, 9.629836473381586])
    ops.mass(872, *[19.630566880540762,
             19.630566880540762, 19.630566880540762])
    ops.mass(873, *[9.62983647338158, 9.62983647338158, 9.62983647338158])
    ops.mass(874, *[19.630566880540748,
             19.630566880540748, 19.630566880540748])
    ops.mass(875, *[9.629836473381584, 9.629836473381584, 9.629836473381584])
    ops.mass(876, *[19.630566880540755,
             19.630566880540755, 19.630566880540755])
    ops.mass(877, *[9.629836473381586, 9.629836473381586, 9.629836473381586])
    ops.mass(878, *[19.630566880540744,
             19.630566880540744, 19.630566880540744])
    ops.mass(879, *[9.629836473381589, 9.629836473381589, 9.629836473381589])
    ops.mass(880, *[19.63056688054075, 19.63056688054075, 19.63056688054075])
    ops.mass(881, *[4.814918236690794, 4.814918236690794, 4.814918236690794])
    ops.mass(882, *[9.815283440270383, 9.815283440270383, 9.815283440270383])
    ops.mass(883, *[20.372354748095866,
             20.372354748095866, 20.372354748095866])
    ops.mass(884, *[10.186177374047956,
             10.186177374047956, 10.186177374047956])
    ops.mass(885, *[20.37235474809583, 20.37235474809583, 20.37235474809583])
    ops.mass(886, *[20.37235474809585, 20.37235474809585, 20.37235474809585])
    ops.mass(887, *[20.37235474809586, 20.37235474809586, 20.37235474809586])
    ops.mass(888, *[20.37235474809586, 20.37235474809586, 20.37235474809586])
    ops.mass(889, *[20.372354748095848,
             20.372354748095848, 20.372354748095848])
    ops.mass(890, *[20.372354748095855,
             20.372354748095855, 20.372354748095855])
    ops.mass(891, *[20.372354748095866,
             20.372354748095866, 20.372354748095866])
    ops.mass(892, *[20.37235474809585, 20.37235474809585, 20.37235474809585])
    ops.mass(893, *[20.372354748095837,
             20.372354748095837, 20.372354748095837])
    ops.mass(894, *[20.37235474809588, 20.37235474809588, 20.37235474809588])
    ops.mass(895, *[20.37235474809584, 20.37235474809584, 20.37235474809584])
    ops.mass(896, *[20.372354748095834,
             20.372354748095834, 20.372354748095834])
    ops.mass(897, *[20.372354748095898,
             20.372354748095898, 20.372354748095898])
    ops.mass(898, *[20.37235474809587, 20.37235474809587, 20.37235474809587])
    ops.mass(899, *[20.372354748095855,
             20.372354748095855, 20.372354748095855])
    ops.mass(900, *[20.372354748095862,
             20.372354748095862, 20.372354748095862])
    ops.mass(901, *[20.37235474809585, 20.37235474809585, 20.37235474809585])
    ops.mass(902, *[20.372354748095855,
             20.372354748095855, 20.372354748095855])
    ops.mass(903, *[10.186177374047938,
             10.186177374047938, 10.186177374047938])
    ops.mass(904, *[10.371624340936703,
             10.371624340936703, 10.371624340936703])
    ops.mass(905, *[5.1858121704683615,
             5.1858121704683615, 5.1858121704683615])
    ops.mass(906, *[10.371624340936693,
             10.371624340936693, 10.371624340936693])
    ops.mass(907, *[10.371624340936695,
             10.371624340936695, 10.371624340936695])
    ops.mass(908, *[10.371624340936693,
             10.371624340936693, 10.371624340936693])
    ops.mass(909, *[10.37162434093669, 10.37162434093669, 10.37162434093669])
    ops.mass(910, *[10.371624340936686,
             10.371624340936686, 10.371624340936686])
    ops.mass(911, *[10.371624340936698,
             10.371624340936698, 10.371624340936698])
    ops.mass(912, *[10.371624340936702,
             10.371624340936702, 10.371624340936702])
    ops.mass(913, *[10.371624340936688,
             10.371624340936688, 10.371624340936688])
    ops.mass(914, *[10.371624340936679,
             10.371624340936679, 10.371624340936679])
    ops.mass(915, *[10.371624340936696,
             10.371624340936696, 10.371624340936696])
    ops.mass(916, *[10.371624340936677,
             10.371624340936677, 10.371624340936677])
    ops.mass(917, *[10.371624340936677,
             10.371624340936677, 10.371624340936677])
    ops.mass(918, *[10.371624340936707,
             10.371624340936707, 10.371624340936707])
    ops.mass(919, *[10.371624340936693,
             10.371624340936693, 10.371624340936693])
    ops.mass(920, *[10.371624340936686,
             10.371624340936686, 10.371624340936686])
    ops.mass(921, *[10.37162434093669, 10.37162434093669, 10.37162434093669])
    ops.mass(922, *[10.371624340936693,
             10.371624340936693, 10.371624340936693])
    ops.mass(923, *[10.371624340936695,
             10.371624340936695, 10.371624340936695])
    ops.mass(924, *[5.185812170468349, 5.185812170468349, 5.185812170468349])
    ops.mass(925, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(926, *[4.608245412146067, 4.608245412146067, 4.608245412146067])
    ops.mass(927, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(928, *[9.384063384733818, 9.384063384733818, 9.384063384733818])
    ops.mass(929, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(930, *[18.76812676946756, 18.76812676946756, 18.76812676946756])
    ops.mass(931, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(932, *[18.768126769467585,
             18.768126769467585, 18.768126769467585])
    ops.mass(933, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(934, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(935, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(936, *[18.768126769467624,
             18.768126769467624, 18.768126769467624])
    ops.mass(937, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(938, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(939, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(940, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(941, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(942, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(943, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(944, *[18.768126769467603,
             18.768126769467603, 18.768126769467603])
    ops.mass(945, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(946, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(947, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(948, *[18.768126769467653,
             18.768126769467653, 18.768126769467653])
    ops.mass(949, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(950, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(951, *[9.216490824292098, 9.216490824292098, 9.216490824292098])
    ops.mass(952, *[18.768126769467578,
             18.768126769467578, 18.768126769467578])
    ops.mass(953, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(954, *[18.768126769467646,
             18.768126769467646, 18.768126769467646])
    ops.mass(955, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(956, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(957, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(958, *[18.768126769467607,
             18.768126769467607, 18.768126769467607])
    ops.mass(959, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(960, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(961, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(962, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(963, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(964, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(965, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(966, *[9.384063384733805, 9.384063384733805, 9.384063384733805])
    ops.mass(967, *[19.438417011234254,
             19.438417011234254, 19.438417011234254])
    ops.mass(968, *[9.71920850561715, 9.71920850561715, 9.71920850561715])
    ops.mass(969, *[19.438417011234222,
             19.438417011234222, 19.438417011234222])
    ops.mass(970, *[19.43841701123424, 19.43841701123424, 19.43841701123424])
    ops.mass(971, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(972, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(973, *[19.438417011234232,
             19.438417011234232, 19.438417011234232])
    ops.mass(974, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(975, *[19.43841701123426, 19.43841701123426, 19.43841701123426])
    ops.mass(976, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(977, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(978, *[19.438417011234275,
             19.438417011234275, 19.438417011234275])
    ops.mass(979, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(980, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(981, *[19.43841701123429, 19.43841701123429, 19.43841701123429])
    ops.mass(982, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(983, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(984, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(985, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(986, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(987, *[9.719208505617132, 9.719208505617132, 9.719208505617132])
    ops.mass(988, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(989, *[4.943390533029398, 4.943390533029398, 4.943390533029398])
    ops.mass(990, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(991, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(992, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(993, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(994, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(995, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(996, *[9.886781066058784, 9.886781066058784, 9.886781066058784])
    ops.mass(997, *[9.886781066058763, 9.886781066058763, 9.886781066058763])
    ops.mass(998, *[9.88678106605875, 9.88678106605875, 9.88678106605875])
    ops.mass(999, *[9.886781066058768, 9.886781066058768, 9.886781066058768])
    ops.mass(1000, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1001, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1002, *[9.88678106605878, 9.88678106605878, 9.88678106605878])
    ops.mass(1003, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1004, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(1005, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1006, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1007, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1008, *[4.943390533029387, 4.943390533029387, 4.943390533029387])
    ops.mass(1009, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(1010, *[4.608245412146067, 4.608245412146067, 4.608245412146067])
    ops.mass(1011, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1012, *[9.384063384733818, 9.384063384733818, 9.384063384733818])
    ops.mass(1013, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(1014, *[18.76812676946756, 18.76812676946756, 18.76812676946756])
    ops.mass(1015, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(1016, *[18.768126769467585,
             18.768126769467585, 18.768126769467585])
    ops.mass(1017, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1018, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1019, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1020, *[18.768126769467624,
             18.768126769467624, 18.768126769467624])
    ops.mass(1021, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1022, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(1023, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1024, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1025, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1026, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1027, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1028, *[18.768126769467603,
             18.768126769467603, 18.768126769467603])
    ops.mass(1029, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1030, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1031, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1032, *[18.768126769467653,
             18.768126769467653, 18.768126769467653])
    ops.mass(1033, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(1034, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1035, *[9.216490824292098, 9.216490824292098, 9.216490824292098])
    ops.mass(1036, *[18.768126769467578,
             18.768126769467578, 18.768126769467578])
    ops.mass(1037, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1038, *[18.768126769467646,
             18.768126769467646, 18.768126769467646])
    ops.mass(1039, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1040, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(1041, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1042, *[18.768126769467607,
             18.768126769467607, 18.768126769467607])
    ops.mass(1043, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1044, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1045, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1046, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1047, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1048, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1049, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1050, *[9.384063384733805, 9.384063384733805, 9.384063384733805])
    ops.mass(1051, *[19.438417011234254,
             19.438417011234254, 19.438417011234254])
    ops.mass(1052, *[9.71920850561715, 9.71920850561715, 9.71920850561715])
    ops.mass(1053, *[19.438417011234222,
             19.438417011234222, 19.438417011234222])
    ops.mass(1054, *[19.43841701123424, 19.43841701123424, 19.43841701123424])
    ops.mass(1055, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(1056, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1057, *[19.438417011234232,
             19.438417011234232, 19.438417011234232])
    ops.mass(1058, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(1059, *[19.43841701123426, 19.43841701123426, 19.43841701123426])
    ops.mass(1060, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(1061, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(1062, *[19.438417011234275,
             19.438417011234275, 19.438417011234275])
    ops.mass(1063, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(1064, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(1065, *[19.43841701123429, 19.43841701123429, 19.43841701123429])
    ops.mass(1066, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(1067, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1068, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(1069, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1070, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1071, *[9.719208505617132, 9.719208505617132, 9.719208505617132])
    ops.mass(1072, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(1073, *[4.943390533029398, 4.943390533029398, 4.943390533029398])
    ops.mass(1074, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1075, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(1076, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(1077, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1078, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(1079, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(1080, *[9.886781066058784, 9.886781066058784, 9.886781066058784])
    ops.mass(1081, *[9.886781066058763, 9.886781066058763, 9.886781066058763])
    ops.mass(1082, *[9.88678106605875, 9.88678106605875, 9.88678106605875])
    ops.mass(1083, *[9.886781066058768, 9.886781066058768, 9.886781066058768])
    ops.mass(1084, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1085, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1086, *[9.88678106605878, 9.88678106605878, 9.88678106605878])
    ops.mass(1087, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1088, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(1089, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1090, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1091, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1092, *[4.943390533029387, 4.943390533029387, 4.943390533029387])
    ops.mass(1093, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(1094, *[4.608245412146067, 4.608245412146067, 4.608245412146067])
    ops.mass(1095, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1096, *[9.384063384733818, 9.384063384733818, 9.384063384733818])
    ops.mass(1097, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(1098, *[18.76812676946756, 18.76812676946756, 18.76812676946756])
    ops.mass(1099, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(1100, *[18.768126769467585,
             18.768126769467585, 18.768126769467585])
    ops.mass(1101, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1102, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1103, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1104, *[18.768126769467624,
             18.768126769467624, 18.768126769467624])
    ops.mass(1105, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1106, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(1107, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1108, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1109, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1110, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1111, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1112, *[18.768126769467603,
             18.768126769467603, 18.768126769467603])
    ops.mass(1113, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1114, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1115, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1116, *[18.768126769467653,
             18.768126769467653, 18.768126769467653])
    ops.mass(1117, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(1118, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1119, *[9.216490824292098, 9.216490824292098, 9.216490824292098])
    ops.mass(1120, *[18.768126769467578,
             18.768126769467578, 18.768126769467578])
    ops.mass(1121, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1122, *[18.768126769467646,
             18.768126769467646, 18.768126769467646])
    ops.mass(1123, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1124, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(1125, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1126, *[18.768126769467607,
             18.768126769467607, 18.768126769467607])
    ops.mass(1127, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1128, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1129, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1130, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1131, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1132, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1133, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1134, *[9.384063384733805, 9.384063384733805, 9.384063384733805])
    ops.mass(1135, *[19.438417011234254,
             19.438417011234254, 19.438417011234254])
    ops.mass(1136, *[9.71920850561715, 9.71920850561715, 9.71920850561715])
    ops.mass(1137, *[19.438417011234222,
             19.438417011234222, 19.438417011234222])
    ops.mass(1138, *[19.43841701123424, 19.43841701123424, 19.43841701123424])
    ops.mass(1139, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(1140, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1141, *[19.438417011234232,
             19.438417011234232, 19.438417011234232])
    ops.mass(1142, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(1143, *[19.43841701123426, 19.43841701123426, 19.43841701123426])
    ops.mass(1144, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(1145, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(1146, *[19.438417011234275,
             19.438417011234275, 19.438417011234275])
    ops.mass(1147, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(1148, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(1149, *[19.43841701123429, 19.43841701123429, 19.43841701123429])
    ops.mass(1150, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(1151, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1152, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(1153, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1154, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1155, *[9.719208505617132, 9.719208505617132, 9.719208505617132])
    ops.mass(1156, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(1157, *[4.943390533029398, 4.943390533029398, 4.943390533029398])
    ops.mass(1158, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1159, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(1160, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(1161, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1162, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(1163, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(1164, *[9.886781066058784, 9.886781066058784, 9.886781066058784])
    ops.mass(1165, *[9.886781066058763, 9.886781066058763, 9.886781066058763])
    ops.mass(1166, *[9.88678106605875, 9.88678106605875, 9.88678106605875])
    ops.mass(1167, *[9.886781066058768, 9.886781066058768, 9.886781066058768])
    ops.mass(1168, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1169, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1170, *[9.88678106605878, 9.88678106605878, 9.88678106605878])
    ops.mass(1171, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1172, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(1173, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1174, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1175, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1176, *[4.943390533029387, 4.943390533029387, 4.943390533029387])
    ops.mass(1177, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(1178, *[4.608245412146067, 4.608245412146067, 4.608245412146067])
    ops.mass(1179, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1180, *[9.384063384733818, 9.384063384733818, 9.384063384733818])
    ops.mass(1181, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(1182, *[18.76812676946756, 18.76812676946756, 18.76812676946756])
    ops.mass(1183, *[9.216490824292123, 9.216490824292123, 9.216490824292123])
    ops.mass(1184, *[18.768126769467585,
             18.768126769467585, 18.768126769467585])
    ops.mass(1185, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1186, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1187, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1188, *[18.768126769467624,
             18.768126769467624, 18.768126769467624])
    ops.mass(1189, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1190, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(1191, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1192, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1193, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1194, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1195, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1196, *[18.768126769467603,
             18.768126769467603, 18.768126769467603])
    ops.mass(1197, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1198, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1199, *[9.216490824292146, 9.216490824292146, 9.216490824292146])
    ops.mass(1200, *[18.768126769467653,
             18.768126769467653, 18.768126769467653])
    ops.mass(1201, *[9.21649082429211, 9.21649082429211, 9.21649082429211])
    ops.mass(1202, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1203, *[9.216490824292098, 9.216490824292098, 9.216490824292098])
    ops.mass(1204, *[18.768126769467578,
             18.768126769467578, 18.768126769467578])
    ops.mass(1205, *[9.216490824292134, 9.216490824292134, 9.216490824292134])
    ops.mass(1206, *[18.768126769467646,
             18.768126769467646, 18.768126769467646])
    ops.mass(1207, *[9.216490824292126, 9.216490824292126, 9.216490824292126])
    ops.mass(1208, *[18.768126769467617,
             18.768126769467617, 18.768126769467617])
    ops.mass(1209, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1210, *[18.768126769467607,
             18.768126769467607, 18.768126769467607])
    ops.mass(1211, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1212, *[18.76812676946761, 18.76812676946761, 18.76812676946761])
    ops.mass(1213, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1214, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1215, *[9.216490824292121, 9.216490824292121, 9.216490824292121])
    ops.mass(1216, *[18.7681267694676, 18.7681267694676, 18.7681267694676])
    ops.mass(1217, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1218, *[9.384063384733805, 9.384063384733805, 9.384063384733805])
    ops.mass(1219, *[19.438417011234254,
             19.438417011234254, 19.438417011234254])
    ops.mass(1220, *[9.71920850561715, 9.71920850561715, 9.71920850561715])
    ops.mass(1221, *[19.438417011234222,
             19.438417011234222, 19.438417011234222])
    ops.mass(1222, *[19.43841701123424, 19.43841701123424, 19.43841701123424])
    ops.mass(1223, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(1224, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1225, *[19.438417011234232,
             19.438417011234232, 19.438417011234232])
    ops.mass(1226, *[19.43841701123425, 19.43841701123425, 19.43841701123425])
    ops.mass(1227, *[19.43841701123426, 19.43841701123426, 19.43841701123426])
    ops.mass(1228, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(1229, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(1230, *[19.438417011234275,
             19.438417011234275, 19.438417011234275])
    ops.mass(1231, *[19.438417011234236,
             19.438417011234236, 19.438417011234236])
    ops.mass(1232, *[19.438417011234225,
             19.438417011234225, 19.438417011234225])
    ops.mass(1233, *[19.43841701123429, 19.43841701123429, 19.43841701123429])
    ops.mass(1234, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(1235, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1236, *[19.438417011234257,
             19.438417011234257, 19.438417011234257])
    ops.mass(1237, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1238, *[19.438417011234243,
             19.438417011234243, 19.438417011234243])
    ops.mass(1239, *[9.719208505617132, 9.719208505617132, 9.719208505617132])
    ops.mass(1240, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(1241, *[4.943390533029398, 4.943390533029398, 4.943390533029398])
    ops.mass(1242, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1243, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(1244, *[9.886781066058774, 9.886781066058774, 9.886781066058774])
    ops.mass(1245, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1246, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(1247, *[9.886781066058779, 9.886781066058779, 9.886781066058779])
    ops.mass(1248, *[9.886781066058784, 9.886781066058784, 9.886781066058784])
    ops.mass(1249, *[9.886781066058763, 9.886781066058763, 9.886781066058763])
    ops.mass(1250, *[9.88678106605875, 9.88678106605875, 9.88678106605875])
    ops.mass(1251, *[9.886781066058768, 9.886781066058768, 9.886781066058768])
    ops.mass(1252, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1253, *[9.886781066058749, 9.886781066058749, 9.886781066058749])
    ops.mass(1254, *[9.88678106605878, 9.88678106605878, 9.88678106605878])
    ops.mass(1255, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1256, *[9.886781066058761, 9.886781066058761, 9.886781066058761])
    ops.mass(1257, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1258, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1259, *[9.886781066058766, 9.886781066058766, 9.886781066058766])
    ops.mass(1260, *[4.943390533029387, 4.943390533029387, 4.943390533029387])
    ops.mass(1261, *[4.608245412146061, 4.608245412146061, 4.608245412146061])
    ops.mass(1262, *[2.3041227060730334,
             2.3041227060730334, 2.3041227060730334])
    ops.mass(1263, *[9.3840633847338, 9.3840633847338, 9.3840633847338])
    ops.mass(1264, *[4.692031692366909, 4.692031692366909, 4.692031692366909])
    ops.mass(1265, *[4.608245412146055, 4.608245412146055, 4.608245412146055])
    ops.mass(1266, *[9.384063384733782, 9.384063384733782, 9.384063384733782])
    ops.mass(1267, *[4.608245412146061, 4.608245412146061, 4.608245412146061])
    ops.mass(1268, *[9.384063384733794, 9.384063384733794, 9.384063384733794])
    ops.mass(1269, *[4.608245412146067, 4.608245412146067, 4.608245412146067])
    ops.mass(1270, *[9.384063384733805, 9.384063384733805, 9.384063384733805])
    ops.mass(1271, *[4.608245412146073, 4.608245412146073, 4.608245412146073])
    ops.mass(1272, *[9.38406338473381, 9.38406338473381, 9.38406338473381])
    ops.mass(1273, *[4.608245412146073, 4.608245412146073, 4.608245412146073])
    ops.mass(1274, *[9.384063384733809, 9.384063384733809, 9.384063384733809])
    ops.mass(1275, *[4.608245412146063, 4.608245412146063, 4.608245412146063])
    ops.mass(1276, *[9.3840633847338, 9.3840633847338, 9.3840633847338])
    ops.mass(1277, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1278, *[9.3840633847338, 9.3840633847338, 9.3840633847338])
    ops.mass(1279, *[4.608245412146063, 4.608245412146063, 4.608245412146063])
    ops.mass(1280, *[9.384063384733802, 9.384063384733802, 9.384063384733802])
    ops.mass(1281, *[4.608245412146067, 4.608245412146067, 4.608245412146067])
    ops.mass(1282, *[9.384063384733805, 9.384063384733805, 9.384063384733805])
    ops.mass(1283, *[4.608245412146073, 4.608245412146073, 4.608245412146073])
    ops.mass(1284, *[9.384063384733826, 9.384063384733826, 9.384063384733826])
    ops.mass(1285, *[4.608245412146055, 4.608245412146055, 4.608245412146055])
    ops.mass(1286, *[9.3840633847338, 9.3840633847338, 9.3840633847338])
    ops.mass(1287, *[4.608245412146049, 4.608245412146049, 4.608245412146049])
    ops.mass(1288, *[9.384063384733787, 9.384063384733787, 9.384063384733787])
    ops.mass(1289, *[4.608245412146067, 4.608245412146067, 4.608245412146067])
    ops.mass(1290, *[9.384063384733821, 9.384063384733821, 9.384063384733821])
    ops.mass(1291, *[4.608245412146063, 4.608245412146063, 4.608245412146063])
    ops.mass(1292, *[9.384063384733807, 9.384063384733807, 9.384063384733807])
    ops.mass(1293, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1294, *[9.384063384733802, 9.384063384733802, 9.384063384733802])
    ops.mass(1295, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1296, *[9.384063384733805, 9.384063384733805, 9.384063384733805])
    ops.mass(1297, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1298, *[9.3840633847338, 9.3840633847338, 9.3840633847338])
    ops.mass(1299, *[4.6082454121460605,
             4.6082454121460605, 4.6082454121460605])
    ops.mass(1300, *[9.3840633847338, 9.3840633847338, 9.3840633847338])
    ops.mass(1301, *[2.3041227060730303,
             2.3041227060730303, 2.3041227060730303])
    ops.mass(1302, *[4.6920316923669025,
             4.6920316923669025, 4.6920316923669025])
    ops.mass(1303, *[9.719208505617127, 9.719208505617127, 9.719208505617127])
    ops.mass(1304, *[4.859604252808575, 4.859604252808575, 4.859604252808575])
    ops.mass(1305, *[9.719208505617111, 9.719208505617111, 9.719208505617111])
    ops.mass(1306, *[9.71920850561712, 9.71920850561712, 9.71920850561712])
    ops.mass(1307, *[9.719208505617125, 9.719208505617125, 9.719208505617125])
    ops.mass(1308, *[9.719208505617122, 9.719208505617122, 9.719208505617122])
    ops.mass(1309, *[9.719208505617116, 9.719208505617116, 9.719208505617116])
    ops.mass(1310, *[9.719208505617125, 9.719208505617125, 9.719208505617125])
    ops.mass(1311, *[9.71920850561713, 9.71920850561713, 9.71920850561713])
    ops.mass(1312, *[9.71920850561712, 9.71920850561712, 9.71920850561712])
    ops.mass(1313, *[9.719208505617114, 9.719208505617114, 9.719208505617114])
    ops.mass(1314, *[9.719208505617138, 9.719208505617138, 9.719208505617138])
    ops.mass(1315, *[9.719208505617118, 9.719208505617118, 9.719208505617118])
    ops.mass(1316, *[9.719208505617113, 9.719208505617113, 9.719208505617113])
    ops.mass(1317, *[9.719208505617145, 9.719208505617145, 9.719208505617145])
    ops.mass(1318, *[9.719208505617129, 9.719208505617129, 9.719208505617129])
    ops.mass(1319, *[9.719208505617122, 9.719208505617122, 9.719208505617122])
    ops.mass(1320, *[9.719208505617129, 9.719208505617129, 9.719208505617129])
    ops.mass(1321, *[9.719208505617122, 9.719208505617122, 9.719208505617122])
    ops.mass(1322, *[9.719208505617122, 9.719208505617122, 9.719208505617122])
    ops.mass(1323, *[4.859604252808566, 4.859604252808566, 4.859604252808566])
    ops.mass(1324, *[4.9433905330293895,
             4.9433905330293895, 4.9433905330293895])
    ops.mass(1325, *[2.471695266514699, 2.471695266514699, 2.471695266514699])
    ops.mass(1326, *[4.943390533029383, 4.943390533029383, 4.943390533029383])
    ops.mass(1327, *[4.943390533029387, 4.943390533029387, 4.943390533029387])
    ops.mass(1328, *[4.943390533029387, 4.943390533029387, 4.943390533029387])
    ops.mass(1329, *[4.943390533029383, 4.943390533029383, 4.943390533029383])
    ops.mass(1330, *[4.943390533029381, 4.943390533029381, 4.943390533029381])
    ops.mass(1331, *[4.9433905330293895,
             4.9433905330293895, 4.9433905330293895])
    ops.mass(1332, *[4.943390533029392, 4.943390533029392, 4.943390533029392])
    ops.mass(1333, *[4.9433905330293815,
             4.9433905330293815, 4.9433905330293815])
    ops.mass(1334, *[4.943390533029375, 4.943390533029375, 4.943390533029375])
    ops.mass(1335, *[4.943390533029384, 4.943390533029384, 4.943390533029384])
    ops.mass(1336, *[4.943390533029374, 4.943390533029374, 4.943390533029374])
    ops.mass(1337, *[4.943390533029374, 4.943390533029374, 4.943390533029374])
    ops.mass(1338, *[4.94339053302939, 4.94339053302939, 4.94339053302939])
    ops.mass(1339, *[4.943390533029383, 4.943390533029383, 4.943390533029383])
    ops.mass(1340, *[4.943390533029381, 4.943390533029381, 4.943390533029381])
    ops.mass(1341, *[4.943390533029383, 4.943390533029383, 4.943390533029383])
    ops.mass(1342, *[4.943390533029383, 4.943390533029383, 4.943390533029383])
    ops.mass(1343, *[4.943390533029383, 4.943390533029383, 4.943390533029383])
    ops.mass(1344, *[2.4716952665146934,
             2.4716952665146934, 2.4716952665146934])
