# !-*- coding:utf-8 -*-

# This document was created from Midas2OPS version 0.01

from collections import namedtuple
import openseespy.opensees as ops


def Igloo():
    ops.wipe()
    # Set the default model dimensions and number of dofs.
    ops.model('basic', '-ndm', 3, '-ndf', 3)

    # Mechanical properties of material
    # E-Elastic Modulus; G-Shear Modulus; v-Poisson's ratio; rho-Mass Density;
    # gamma-unit weight; r: expansion coefficient
    mat_props = namedtuple(
        'mat_props', ['mat_name', 'E', 'v', 'G', 'r', 'gamma', 'rho'])
    MatProps = dict()
    MatProps[1] = mat_props._make(
        ('C280', 2824300.0, 0.18, 1196737.2881355933, 1e-05, 2.5, 0.0))

    # Create OpenSees node.
    ops.node(135, 0.5, -0.99, 0.75)
    ops.node(136, 0.375, -0.99, 0.8625)
    ops.node(137, 0.25, -0.99, 0.975)
    ops.node(138, 0.125, -0.99, 1.0875)
    ops.node(139, 0.0, -0.99, 1.2)
    ops.node(140, 0.0, -0.848571, 1.2)
    ops.node(141, 0.0, -0.707143, 1.2)
    ops.node(142, 0.0, -0.565714, 1.2)
    ops.node(143, 0.0, -0.424286, 1.2)
    ops.node(144, 0.0, -0.282857, 1.2)
    ops.node(145, 0.0, -0.141429, 1.2)
    ops.node(146, 0.0, 0.0, 1.2)
    ops.node(147, 0.016184, -0.15709, 1.185434)
    ops.node(148, 0.036456, -0.312762, 1.16719)
    ops.node(149, 0.078783, -0.460777, 1.129095)
    ops.node(150, 0.139037, -0.596871, 1.074867)
    ops.node(151, 0.212748, -0.719905, 1.008527)
    ops.node(152, 0.298532, -0.827709, 0.931321)
    ops.node(153, 0.394847, -0.91832, 0.844638)
    ops.node(154, 0.146474, -0.811457, 1.068174)
    ops.node(155, 0.020588, -0.203745, 0.908294)
    ops.node(156, 0.072287, -0.430391, 0.870226)
    ops.node(157, 0.176023, -0.656108, 0.787226)
    ops.node(158, 0.316725, -0.83914, 0.659681)
    ops.node(159, 0.024067, -0.242125, 0.633495)
    ops.node(160, 0.090984, -0.47696, 0.568932)
    ops.node(161, 0.205228, -0.692626, 0.500958)
    ops.node(162, 0.352833, -0.870278, 0.407162)
    ops.node(163, 0.035084, -0.284644, 0.315303)
    ops.node(164, 0.127908, -0.544146, 0.275501)
    ops.node(165, 0.250751, -0.745506, 0.235051)
    ops.node(166, 0.384634, -0.891957, 0.176882)
    ops.node(167, 0.0, 0.0, 0.0)
    ops.node(168, 0.021462, -0.228777, 0.0)
    ops.node(169, 0.085098, -0.449572, 0.0)
    ops.node(170, 0.188687, -0.654679, 0.0)
    ops.node(171, 0.328615, -0.836941, 0.0)
    ops.node(172, 0.5, -0.99, 0.0)
    ops.node(173, 0.5, -0.99, 0.5)
    ops.node(174, 0.5, -0.99, 0.25)
    ops.node(175, 0.0, 0.0, 0.24)
    ops.node(176, 0.0, 0.0, 0.48)
    ops.node(177, 0.0, 0.0, 0.72)
    ops.node(178, 0.0, 0.0, 0.96)
    ops.node(179, 0.391747, -1.0525, 0.8625)
    ops.node(180, 0.4375, -1.098253, 0.8625)
    ops.node(181, 0.5, -1.115, 0.8625)
    ops.node(182, 0.283494, -1.115, 0.975)
    ops.node(183, 0.375, -1.206506, 0.975)
    ops.node(184, 0.5, -1.24, 0.975)
    ops.node(185, 0.175241, -1.1775, 1.0875)
    ops.node(186, 0.3125, -1.314759, 1.0875)
    ops.node(187, 0.5, -1.365, 1.0875)
    ops.node(188, 0.066988, -1.24, 1.2)
    ops.node(189, 0.25, -1.423013, 1.2)
    ops.node(190, 0.5, -1.49, 1.2)
    ops.node(212, 0.8, -0.99, -0.2)
    ops.node(213, 0.8, -0.99, -0.01)
    ops.node(214, 0.658905, -0.99, 0.179584)
    ops.node(215, 0.8, -0.99, 0.18)
    ops.node(216, 0.64578, -0.99, 0.402929)
    ops.node(217, 0.8, -0.99, 0.37)
    ops.node(218, 0.644389, -0.99, 0.605506)
    ops.node(219, 0.8, -0.99, 0.56)
    ops.node(220, 0.8, -0.99, 0.75)
    ops.node(221, 0.6, -0.99, 0.0)
    ops.node(222, 0.58, -0.99, 0.75)
    ops.node(223, 0.58, -1.156667, 0.9)
    ops.node(224, 0.58, -1.323333, 1.05)
    ops.node(225, 0.58, -1.49, 1.2)
    ops.node(229, 0.793334, -1.156667, 0.9)
    ops.node(230, 0.786667, -1.323333, 1.05)
    ops.node(231, 0.78, -1.49, 1.2)
    ops.node(232, 0.945753, -1.323855, 1.05047)
    ops.node(233, 0.950465, -1.157194, 0.900474)
    ops.node(234, 1.109, -0.99, 0.75)
    ops.node(235, 0.9545, -0.99, 0.75)
    ops.node(236, 1.106244, -1.156667, 0.9)
    ops.node(237, 1.103488, -1.323333, 1.05)
    ops.node(238, 1.100732, -1.49, 1.2)
    ops.node(239, 0.940366, -1.49, 1.2)
    ops.node(240, 1.109, -0.99, -0.2)
    ops.node(241, 1.109, -0.99, -0.01)
    ops.node(242, 1.109, -0.99, 0.18)
    ops.node(243, 1.109, -0.99, 0.37)
    ops.node(244, 1.109, -0.99, 0.56)
    ops.node(245, 0.9545, -0.99, -0.2)
    ops.node(246, 0.9545, -0.99, 0.007545)
    ops.node(247, 0.9545, -0.99, 0.248612)
    ops.node(248, 0.9545, -0.99, 0.449422)
    ops.node(249, 0.9545, -0.99, 0.625278)
    ops.node(250, 1.555272, -1.198312, 1.2)
    ops.node(251, 1.677152, -0.399318, 0.75)
    ops.node(252, 1.498383, -1.120278, 1.100366)
    ops.node(253, 1.477513, -0.935756, 0.984064)
    ops.node(254, 1.513603, -0.711785, 0.872963)
    ops.node(255, 1.496813, -0.505365, 0.75)
    ops.node(256, 1.362472, -1.215356, 1.085487)
    ops.node(257, 1.357962, -1.031315, 0.979212)
    ops.node(258, 1.366285, -0.835755, 0.872646)
    ops.node(259, 1.33867, -0.642328, 0.75)
    ops.node(260, 1.217849, -1.331624, 1.101565)
    ops.node(261, 1.233332, -1.12796, 0.973784)
    ops.node(262, 1.216846, -0.940375, 0.843059)
    ops.node(263, 1.207957, -0.805675, 0.75)
    ops.node(264, 1.579648, -1.038514, 1.11)
    ops.node(265, 1.604024, -0.878715, 1.02)
    ops.node(266, 1.6284, -0.718916, 0.93)
    ops.node(267, 1.652776, -0.559117, 0.84)
    ops.node(268, 1.286358, -1.454266, 1.2)
    ops.node(269, 1.445451, -1.352173, 1.2)
    ops.node(270, 1.207957, -0.805675, -0.2)
    ops.node(271, 1.216079, -0.795526, -0.070189)
    ops.node(272, 1.209527, -0.803714, 0.106593)
    ops.node(273, 1.213368, -0.798914, 0.330555)
    ops.node(274, 1.181845, -0.854313, 0.546153)
    ops.node(275, 1.33867, -0.642328, -0.2)
    ops.node(276, 1.36884, -0.616199, 0.003455)
    ops.node(277, 1.321129, -0.664249, 0.190831)
    ops.node(278, 1.357591, -0.625942, 0.348987)
    ops.node(279, 1.313023, -0.674379, 0.541291)
    ops.node(280, 1.496813, -0.505365, -0.2)
    ops.node(281, 1.544145, -0.477532, 0.000799)
    ops.node(282, 1.488795, -0.512309, 0.213414)
    ops.node(283, 1.493273, -0.508431, 0.438038)
    ops.node(284, 1.486192, -0.514563, 0.617625)
    ops.node(285, 1.677152, -0.399318, -0.2)
    ops.node(286, 1.677152, -0.399318, -0.01)
    ops.node(287, 1.677152, -0.399318, 0.18)
    ops.node(288, 1.677152, -0.399318, 0.37)
    ops.node(289, 1.677152, -0.399318, 0.56)
    ops.node(290, 1.762202, -0.803614, 1.082494)
    ops.node(291, 1.756276, -0.68395, 0.979231)
    ops.node(292, 1.814355, -0.523249, 0.879648)
    ops.node(293, 1.847145, -0.342361, 0.75)
    ops.node(294, 1.985239, -0.716976, 1.104178)
    ops.node(295, 1.968705, -0.576438, 0.975953)
    ops.node(296, 2.008675, -0.415261, 0.843055)
    ops.node(297, 2.021427, -0.305921, 0.75)
    ops.node(298, 2.2, -0.79, 1.2)
    ops.node(299, 2.2, -0.29, 0.75)
    ops.node(300, 2.2, -0.456667, 0.9)
    ops.node(301, 2.2, -0.623333, 1.05)
    ops.node(302, 2.001553, -0.819605, 1.2)
    ops.node(303, 1.8171, -0.89857, 1.2)
    ops.node(304, 1.666866, -1.031565, 1.2)
    ops.node(305, 2.2, -0.29, -0.2)
    ops.node(306, 2.2, -0.29, -0.01)
    ops.node(307, 2.2, -0.29, 0.18)
    ops.node(308, 2.2, -0.29, 0.37)
    ops.node(309, 2.2, -0.29, 0.56)
    ops.node(310, 2.021427, -0.305921, -0.2)
    ops.node(311, 2.013411, -0.306636, -0.069679)
    ops.node(312, 2.013198, -0.306655, 0.11008)
    ops.node(313, 2.022819, -0.305797, 0.313364)
    ops.node(314, 2.041391, -0.304141, 0.53838)
    ops.node(315, 1.847145, -0.342361, -0.2)
    ops.node(316, 1.827862, -0.348821, 0.007854)
    ops.node(317, 1.845967, -0.342755, 0.230427)
    ops.node(318, 1.855432, -0.339584, 0.434388)
    ops.node(319, 1.855276, -0.339636, 0.617329)
    ops.node(320, 2.9, -0.79, 1.2)
    ops.node(321, 2.725, -0.79, 1.2)
    ops.node(322, 2.55, -0.79, 1.2)
    ops.node(323, 2.375, -0.79, 1.2)
    ops.node(324, 2.9, -0.623333, 1.05)
    ops.node(325, 2.777354, -0.616358, 1.043723)
    ops.node(326, 2.603978, -0.618696, 1.045827)
    ops.node(327, 2.396926, -0.640353, 1.065318)
    ops.node(328, 2.9, -0.456667, 0.9)
    ops.node(329, 2.705274, -0.439608, 0.884647)
    ops.node(330, 2.499208, -0.461482, 0.904333)
    ops.node(331, 2.324792, -0.464166, 0.906749)
    ops.node(332, 2.9, -0.29, 0.75)
    ops.node(333, 2.725, -0.29, 0.75)
    ops.node(334, 2.55, -0.29, 0.75)
    ops.node(335, 2.375, -0.29, 0.75)
    ops.node(336, 2.375, -0.29, -0.2)
    ops.node(337, 2.55, -0.29, -0.2)
    ops.node(338, 2.725, -0.29, -0.2)
    ops.node(339, 2.9, -0.29, -0.2)
    ops.node(340, 2.327952, -0.29, 0.002168)
    ops.node(341, 2.514764, -0.29, 0.006471)
    ops.node(342, 2.713168, -0.29, -0.06855)
    ops.node(343, 2.9, -0.29, -0.01)
    ops.node(344, 2.381644, -0.29, 0.215571)
    ops.node(345, 2.57027, -0.29, 0.195553)
    ops.node(346, 2.721008, -0.29, 0.109604)
    ops.node(347, 2.9, -0.29, 0.18)
    ops.node(348, 2.37702, -0.29, 0.439912)
    ops.node(349, 2.526239, -0.29, 0.353389)
    ops.node(350, 2.715678, -0.29, 0.33329)
    ops.node(351, 2.9, -0.29, 0.37)
    ops.node(352, 2.385828, -0.29, 0.61849)
    ops.node(353, 2.583025, -0.29, 0.543236)
    ops.node(354, 2.770428, -0.29, 0.547078)
    ops.node(355, 2.9, -0.29, 0.56)
    ops.node(356, 4.095, -1.385, 0.75)
    ops.node(357, 3.93, -1.384, 0.9)
    ops.node(358, 3.839712, -1.122965, 0.926459)
    ops.node(359, 3.744608, -0.877469, 0.901108)
    ops.node(360, 3.632513, -0.691358, 0.867859)
    ops.node(361, 3.439664, -0.592256, 0.89813)
    ops.node(362, 3.203364, -0.506248, 0.907412)
    ops.node(363, 3.765, -1.383, 1.05)
    ops.node(364, 3.681074, -1.204757, 1.086569)
    ops.node(365, 3.609288, -1.00208, 1.060878)
    ops.node(366, 3.51202, -0.808148, 1.01488)
    ops.node(367, 3.300541, -0.724796, 1.056788)
    ops.node(368, 3.075355, -0.646371, 1.056634)
    ops.node(369, 3.6, -1.382, 1.2)
    ops.node(370, 3.360397, -0.955464, 1.2)
    ops.node(371, 4.051912, -1.132652, 0.75)
    ops.node(372, 3.954955, -0.896136, 0.75)
    ops.node(373, 3.808856, -0.686666, 0.75)
    ops.node(374, 3.62062, -0.514182, 0.75)
    ops.node(375, 3.399211, -0.386898, 0.75)
    ops.node(376, 3.155144, -0.310927, 0.75)
    ops.node(377, 3.145124, -0.831202, 1.2)
    ops.node(378, 3.518674, -1.147118, 1.2)
    ops.node(379, 4.095, -1.385, -0.2)
    ops.node(380, 4.051912, -1.132652, -0.2)
    ops.node(381, 3.954955, -0.896136, -0.2)
    ops.node(382, 3.808856, -0.686666, -0.2)
    ops.node(383, 3.62062, -0.514182, -0.2)
    ops.node(384, 3.399211, -0.386898, -0.2)
    ops.node(385, 3.155144, -0.310927, -0.2)
    ops.node(386, 4.095, -1.385, 0.0375)
    ops.node(387, 4.070065, -1.213978, 0.05247)
    ops.node(388, 4.004854, -0.999743, 0.040214)
    ops.node(389, 3.885708, -0.779503, 0.026925)
    ops.node(390, 3.721613, -0.590007, 0.034493)
    ops.node(391, 3.500625, -0.4357, 0.036234)
    ops.node(392, 3.212778, -0.325828, 0.049133)
    ops.node(393, 4.095, -1.385, 0.275)
    ops.node(394, 4.046385, -1.117041, 0.321374)
    ops.node(395, 3.951632, -0.890539, 0.240733)
    ops.node(396, 3.820598, -0.699753, 0.270786)
    ops.node(397, 3.63151, -0.522358, 0.271477)
    ops.node(398, 3.3997, -0.387133, 0.271544)
    ops.node(399, 3.150203, -0.30965, 0.29668)
    ops.node(400, 4.095, -1.385, 0.5125)
    ops.node(401, 4.046396, -1.117073, 0.574233)
    ops.node(402, 3.92943, -0.853144, 0.494212)
    ops.node(403, 3.745441, -0.615988, 0.508765)
    ops.node(404, 3.532534, -0.451055, 0.509375)
    ops.node(405, 3.304062, -0.349429, 0.51498)
    ops.node(406, 3.093003, -0.301111, 0.505155)
    ops.node(407, 4.2, -1.49, 0.75)
    ops.node(408, 3.708, -1.49, 1.2)
    ops.node(409, 3.872, -1.49, 1.05)
    ops.node(410, 4.036, -1.49, 0.9)
    ops.node(411, 4.2, -1.49, -0.2)
    ops.node(412, 4.2, -1.49, 0.0375)
    ops.node(413, 4.2, -1.49, 0.275)
    ops.node(414, 4.2, -1.49, 0.5125)
    ops.node(415, 0.0, -0.99, 1.4475)
    ops.node(416, 0.0, -0.724724, 1.466814)
    ops.node(417, 0.0, -0.452302, 1.46153)
    ops.node(418, 0.0, -0.218121, 1.444249)
    ops.node(419, 0.0, 0.0, 1.4475)
    ops.node(420, 0.0, -0.99, 1.695)
    ops.node(421, 0.0, -0.7425, 1.695)
    ops.node(422, 0.0, -0.495, 1.695)
    ops.node(423, 0.0, -0.2475, 1.695)
    ops.node(424, 0.0, 0.0, 1.695)
    ops.node(431, 0.040016, -1.174884, 1.461521)
    ops.node(432, 0.171032, -1.362418, 1.440117)
    ops.node(433, 0.352484, -1.465463, 1.437795)
    ops.node(434, 0.5, -1.49, 1.4475)
    ops.node(435, 0.042013, -1.179705, 1.695)
    ops.node(436, 0.146447, -1.343553, 1.695)
    ops.node(437, 0.310296, -1.447988, 1.695)
    ops.node(438, 0.5, -1.49, 1.695)
    ops.node(439, 0.58, -1.49, 1.695)
    ops.node(440, 0.58, -1.49, 1.4475)
    ops.node(441, 0.78, -1.49, 1.5)
    ops.node(442, 0.78, -1.49, 1.35)
    ops.node(443, 1.100732, -1.49, 1.35)
    ops.node(444, 0.940366, -1.49, 1.35)
    ops.node(445, 1.100732, -1.49, 1.5)
    ops.node(446, 0.940366, -1.49, 1.5)
    ops.node(447, 1.296692, -1.448946, 1.35)
    ops.node(448, 1.475368, -1.317716, 1.35)
    ops.node(449, 1.555272, -1.198312, 1.35)
    ops.node(450, 1.286358, -1.454266, 1.5)
    ops.node(451, 1.445451, -1.352173, 1.5)
    ops.node(452, 1.555272, -1.198312, 1.5)
    ops.node(453, 2.2, -0.79, 1.35)
    ops.node(454, 1.985068, -0.824279, 1.35)
    ops.node(455, 1.764277, -0.939621, 1.35)
    ops.node(456, 1.624575, -1.07998, 1.35)
    ops.node(457, 2.2, -0.79, 1.5)
    ops.node(458, 2.001553, -0.819605, 1.5)
    ops.node(459, 1.8171, -0.89857, 1.5)
    ops.node(460, 1.666866, -1.031565, 1.5)
    ops.node(461, 2.9, -0.79, 1.35)
    ops.node(462, 2.710117, -0.79, 1.35)
    ops.node(463, 2.49189, -0.79, 1.35)
    ops.node(464, 2.319162, -0.79, 1.35)
    ops.node(465, 2.9, -0.79, 1.5)
    ops.node(466, 2.725, -0.79, 1.5)
    ops.node(467, 2.55, -0.79, 1.5)
    ops.node(468, 2.375, -0.79, 1.5)
    ops.node(469, 3.6, -1.382, 1.35)
    ops.node(470, 3.542581, -1.200285, 1.359828)
    ops.node(471, 3.412503, -1.008183, 1.346824)
    ops.node(472, 3.236276, -0.873477, 1.34578)
    ops.node(473, 3.045087, -0.805042, 1.345346)
    ops.node(474, 3.6, -1.382, 1.5)
    ops.node(475, 3.539143, -1.192639, 1.5)
    ops.node(476, 3.430568, -1.02646, 1.5)
    ops.node(477, 3.278736, -0.898054, 1.5)
    ops.node(478, 3.096837, -0.818574, 1.5)
    ops.node(479, 3.708, -1.49, 1.35)
    ops.node(480, 3.708, -1.49, 1.5)
    ops.node(481, 4.4, -1.49, -0.2)
    ops.node(482, 4.4, -1.49, 0.225)
    ops.node(483, 4.4, -1.49, 0.65)
    ops.node(484, 4.4, -1.49, 1.075)
    ops.node(485, 4.4, -1.49, 1.5)
    ops.node(486, 4.054, -1.49, 1.5)
    ops.node(487, 3.81, -1.49, 1.32)
    ops.node(488, 4.167071, -1.49, 1.155431)
    ops.node(489, 4.240615, -1.49, 0.906086)
    ops.node(490, 4.5, -1.39, 1.5)
    ops.node(491, 4.5, -1.39, 1.075)
    ops.node(492, 4.5, -1.39, 0.65)
    ops.node(493, 4.5, -1.39, 0.225)
    ops.node(494, 4.5, -1.39, -0.2)
    ops.node(509, 4.5, -0.926667, 1.5)
    ops.node(510, 4.5, -0.463333, 1.5)
    ops.node(511, 4.5, 0.0, 1.5)
    ops.node(512, 4.5, 0.0, 0.933333)
    ops.node(513, 4.5, 0.0, 0.366667)
    ops.node(514, 4.5, 0.0, -0.2)
    ops.node(515, 4.5, -0.463333, -0.2)
    ops.node(516, 4.5, -0.926667, -0.2)
    ops.node(517, 4.5, -0.885096, 0.821332)
    ops.node(518, 4.5, -0.616801, 0.307776)
    ops.node(519, 4.5, -0.389159, 0.717315)
    ops.node(520, 4.5, -1.0417130000000001, 0.360822)
    ops.node(521, 4.5, -0.444042, 1.161997)
    ops.node(522, 0.279748, -1.04049, 1.695)
    ops.node(523, 0.25242, -0.761953, 1.695)
    ops.node(524, 0.250249, -0.50145, 1.695)
    ops.node(525, 0.250107, -0.249368, 1.695)
    ops.node(526, 0.25, 0.0, 1.695)
    ops.node(527, 0.5, -1.241667, 1.695)
    ops.node(528, 0.5, -0.993333, 1.695)
    ops.node(529, 0.5, -0.745, 1.695)
    ops.node(530, 0.5, -0.496667, 1.695)
    ops.node(531, 0.5, -0.248333, 1.695)
    ops.node(532, 0.5, 0.0, 1.695)
    ops.node(533, 0.58, -1.241667, 1.695)
    ops.node(534, 0.58, -0.993333, 1.695)
    ops.node(535, 0.58, -0.745, 1.695)
    ops.node(536, 0.58, -0.496667, 1.695)
    ops.node(537, 0.58, -0.248333, 1.695)
    ops.node(538, 0.58, 0.0, 1.695)
    ops.node(545, 0.78, -1.277143, 1.5)
    ops.node(546, 0.78, -1.064286, 1.5)
    ops.node(547, 0.78, -0.851429, 1.5)
    ops.node(548, 0.78, -0.638571, 1.5)
    ops.node(549, 0.78, -0.425714, 1.5)
    ops.node(550, 0.78, -0.212857, 1.5)
    ops.node(551, 0.78, 0.0, 1.5)
    ops.node(601, 1.100732, -1.241667, 1.5)
    ops.node(602, 1.100732, -0.993333, 1.5)
    ops.node(603, 1.100732, -0.745, 1.5)
    ops.node(604, 1.100732, -0.496667, 1.5)
    ops.node(605, 1.100732, -0.248333, 1.5)
    ops.node(606, 1.100732, 0.0, 1.5)
    ops.node(607, 1.331598, -0.994256, 1.5)
    ops.node(608, 1.327523, -0.65862, 1.5)
    ops.node(609, 1.326003, -0.395985, 1.5)
    ops.node(610, 1.291637, -0.182155, 1.5)
    ops.node(611, 1.555272, 0.0, 1.5)
    ops.node(612, 1.328002, 0.0, 1.5)
    ops.node(613, 1.555272, -0.95865, 1.5)
    ops.node(614, 1.555272, -0.718987, 1.5)
    ops.node(615, 1.555272, -0.479325, 1.5)
    ops.node(616, 1.555272, -0.239662, 1.5)
    ops.node(617, 1.918244, -0.209774, 1.5)
    ops.node(618, 1.986444, -0.482627, 1.5)
    ops.node(619, 1.763056, -0.400458, 1.5)
    ops.node(620, 1.785627, -0.638869, 1.5)
    ops.node(621, 2.2, 0.0, 1.5)
    ops.node(622, 1.985091, 0.0, 1.5)
    ops.node(623, 1.770181, 0.0, 1.5)
    ops.node(624, 2.2, -0.526667, 1.5)
    ops.node(625, 2.2, -0.263333, 1.5)
    ops.node(626, 2.9, -0.526667, 1.5)
    ops.node(627, 2.659171, -0.476621, 1.5)
    ops.node(628, 2.437986, -0.555331, 1.5)
    ops.node(629, 2.9, -0.263333, 1.5)
    ops.node(630, 2.657414, -0.194111, 1.5)
    ops.node(631, 2.410045, -0.284863, 1.5)
    ops.node(632, 2.9, 0.0, 1.5)
    ops.node(633, 2.666667, 0.0, 1.5)
    ops.node(634, 2.433334, 0.0, 1.5)
    ops.node(645, 3.390141, -0.225154, 1.5)
    ops.node(646, 3.335746, -0.677472, 1.5)
    ops.node(647, 3.35464, -0.450829, 1.5)
    ops.node(648, 3.162395, -0.259688, 1.5)
    ops.node(649, 3.100265, -0.5331, 1.5)
    ops.node(650, 3.6, 0.0, 1.5)
    ops.node(651, 3.425, 0.0, 1.5)
    ops.node(652, 3.25, 0.0, 1.5)
    ops.node(653, 3.075, 0.0, 1.5)
    ops.node(654, 3.6, -1.184571, 1.5)
    ops.node(655, 3.6, -0.987143, 1.5)
    ops.node(656, 3.6, -0.789714, 1.5)
    ops.node(657, 3.6, -0.592286, 1.5)
    ops.node(658, 3.6, -0.394857, 1.5)
    ops.node(659, 3.6, -0.197429, 1.5)
    ops.node(660, 3.708, -1.277143, 1.5)
    ops.node(661, 3.708, -1.064286, 1.5)
    ops.node(662, 3.708, -0.851429, 1.5)
    ops.node(663, 3.708, -0.638571, 1.5)
    ops.node(664, 3.708, -0.425714, 1.5)
    ops.node(665, 3.708, -0.212857, 1.5)
    ops.node(666, 3.708, 0.0, 1.5)
    ops.node(667, 4.4, -1.241667, 1.5)
    ops.node(668, 4.177049, -1.214384, 1.5)
    ops.node(669, 3.908927, -1.267842, 1.5)
    ops.node(670, 4.4, -0.993333, 1.5)
    ops.node(671, 4.174892, -0.907927, 1.5)
    ops.node(672, 3.949714, -1.018059, 1.5)
    ops.node(673, 4.4, -0.745, 1.5)
    ops.node(674, 4.174201, -0.644122, 1.5)
    ops.node(675, 3.94744, -0.766971, 1.5)
    ops.node(676, 4.4, -0.496667, 1.5)
    ops.node(677, 4.171766, -0.39737, 1.5)
    ops.node(678, 3.944588, -0.524877, 1.5)
    ops.node(679, 4.4, -0.248333, 1.5)
    ops.node(680, 4.166403, -0.167607, 1.5)
    ops.node(681, 3.940558, -0.27952, 1.5)
    ops.node(682, 4.4, 0.0, 1.5)
    ops.node(683, 4.169334, 0.0, 1.5)
    ops.node(684, 3.938667, 0.0, 1.5)
    ops.node(702, 0.22966, -0.172576, 0.0)
    ops.node(703, 0.234021, -0.40573, 0.0)
    ops.node(704, 0.441387, -0.146923, 0.0)
    ops.node(705, 0.412877, -0.333076, 0.0)
    ops.node(706, 0.411186, -0.586265, 0.0)
    ops.node(707, 0.6, -0.792, 0.0)
    ops.node(708, 0.6, -0.594, 0.0)
    ops.node(709, 0.6, -0.396, 0.0)
    ops.node(710, 0.6, -0.198, 0.0)
    ops.node(711, 0.6, 0.0, 0.0)
    ops.node(712, 0.4, 0.0, 0.0)
    ops.node(713, 0.2, 0.0, 0.0)
    ops.node(714, 0.8, -0.792, -0.2)
    ops.node(715, 0.8, -0.594, -0.2)
    ops.node(716, 0.8, -0.396, -0.2)
    ops.node(717, 0.8, -0.198, -0.2)
    ops.node(718, 0.8, 0.0, -0.2)
    ops.node(719, 1.109, -0.792, -0.2)
    ops.node(720, 1.109, -0.594, -0.2)
    ops.node(721, 1.109, -0.396, -0.2)
    ops.node(722, 1.109, -0.198, -0.2)
    ops.node(723, 1.109, 0.0, -0.2)
    ops.node(724, 0.9545, -0.773716, -0.2)
    ops.node(725, 0.9545, -0.522499, -0.2)
    ops.node(726, 0.9545, -0.313234, -0.2)
    ops.node(727, 0.9545, -0.129973, -0.2)
    ops.node(728, 0.9545, 0.0, -0.2)
    ops.node(729, 1.305312, -0.425847, -0.2)
    ops.node(730, 1.25578, -0.210402, -0.2)
    ops.node(731, 1.298384, 0.0, -0.2)
    ops.node(732, 1.47718, -0.22872, -0.2)
    ops.node(733, 1.487768, 0.0, -0.2)
    ops.node(734, 1.677152, 0.0, -0.2)
    ops.node(735, 1.677152, -0.199659, -0.2)
    ops.node(736, 1.860454, -0.151322, -0.2)
    ops.node(737, 2.2, 0.0, -0.2)
    ops.node(738, 2.025717, 0.0, -0.2)
    ops.node(739, 1.851435, 0.0, -0.2)
    ops.node(740, 2.375, 0.0, -0.2)
    ops.node(741, 2.55, 0.0, -0.2)
    ops.node(742, 2.725, 0.0, -0.2)
    ops.node(743, 2.9, 0.0, -0.2)
    ops.node(744, 3.856837, -0.454308, -0.2)
    ops.node(745, 3.907043, -0.249094, -0.2)
    ops.node(746, 3.670159, -0.241154, -0.2)
    ops.node(747, 4.095, 0.0, -0.2)
    ops.node(748, 3.895834, 0.0, -0.2)
    ops.node(749, 3.696667, 0.0, -0.2)
    ops.node(750, 3.4975, 0.0, -0.2)
    ops.node(751, 3.298334, 0.0, -0.2)
    ops.node(752, 3.099167, 0.0, -0.2)
    ops.node(753, 4.095, -1.187143, -0.2)
    ops.node(754, 4.095, -0.989286, -0.2)
    ops.node(755, 4.095, -0.791429, -0.2)
    ops.node(756, 4.095, -0.593571, -0.2)
    ops.node(757, 4.095, -0.395714, -0.2)
    ops.node(758, 4.095, -0.197857, -0.2)
    ops.node(759, 4.2, 0.0, -0.2)
    ops.node(760, 4.2, -0.212857, -0.2)
    ops.node(761, 4.2, -0.425714, -0.2)
    ops.node(762, 4.2, -0.638571, -0.2)
    ops.node(763, 4.2, -0.851429, -0.2)
    ops.node(764, 4.2, -1.064286, -0.2)
    ops.node(765, 4.2, -1.277143, -0.2)
    ops.node(766, 4.4, -1.277143, -0.2)
    ops.node(767, 4.4, -1.064286, -0.2)
    ops.node(768, 4.4, -0.851429, -0.2)
    ops.node(769, 4.4, -0.638571, -0.2)
    ops.node(770, 4.4, -0.425714, -0.2)
    ops.node(771, 4.4, -0.212857, -0.2)
    ops.node(772, 4.4, 0.0, -0.2)
    ops.node(1121, 3.531202, 0.0, 0.633107)
    ops.node(1122, 2.460504, 0.0, 0.61138)
    ops.node(1123, 1.576415, 0.0, 0.67697)
    ops.node(1124, 3.0552, 0.0, 0.383384)
    ops.node(1125, 2.997914, 0.0, 0.920265)
    ops.node(1126, 3.817006, 0.0, 0.999955)
    ops.node(1127, 1.171078, 0.0, 0.291265)
    ops.node(1128, 2.123931, 0.0, 0.311788)
    ops.node(1129, 3.737151, 0.0, 0.234848)
    ops.node(1130, 0.645203, 0.0, 0.765601)
    ops.node(1131, 2.096071, 0.0, 0.9695)
    ops.node(1132, 3.286764, 0.0, 1.148296)
    ops.node(1133, 2.678114, 0.0, 0.170616)
    ops.node(1134, 4.182124, 0.0, 0.13957)
    ops.node(1135, 1.142727, 0.0, 0.961148)
    ops.node(1136, 1.580641, 0.0, 0.134383)
    ops.node(1137, 2.584291, 0.0, 1.095652)
    ops.node(1138, 1.654519, 0.0, 1.099888)
    ops.node(1139, 3.361709, 0.0, 0.119672)
    ops.node(1140, 0.359541, 0.0, 1.300863)
    ops.node(1141, 0.459328, 0.0, 0.422537)
    ops.node(1142, 2.291738, 0.0, 0.003055)
    ops.node(1143, 3.010872, 0.0, -0.010777)
    ops.node(1144, 1.940718, 0.0, 0.016391)
    ops.node(1145, 3.636752, 0.0, 1.266618)
    ops.node(1146, 3.988021, 0.0, 1.206503)
    ops.node(1147, 1.001768, 0.0, 0.05517)
    ops.node(1148, 2.974047, 0.0, 1.301754)
    ops.node(1149, 0.301536, 0.0, 0.86789)
    ops.node(1150, 4.155757, 0.0, 0.703402)
    ops.node(1151, 1.405569, 0.0, -0.007937)
    ops.node(1152, 2.362085, 0.0, 1.278877)
    ops.node(1153, 3.576228, 0.0, 0.024002)
    ops.node(1154, 1.843672, 0.0, 1.280883)
    ops.node(1155, 0.96099, 0.0, 1.24375)
    ops.node(1156, 1.474372, 0.0, 1.285754)
    ops.node(1157, 0.263085, 0.0, 0.265386)
    ops.node(1158, 4.353618, 0.0, 1.303832)
    ops.node(1159, 4.323778, 0.0, -0.025433)
    ops.node(1160, 3.356621, 0.0, 1.335305)
    ops.node(1161, 2.613765, 0.0, -0.02522)
    ops.node(1162, 3.217236, 0.0, -0.027514)
    ops.node(1163, 3.140686, 0.0, 0.160422)
    ops.node(1164, 3.251135, 0.0, 0.485876)
    ops.node(1165, 2.910895, 0.0, 0.176583)
    ops.node(1166, 2.675219, 0.0, 0.540706)
    ops.node(1167, 3.744357, 0.0, 1.377307)
    ops.node(1168, 3.523716, 0.0, 1.364102)
    ops.node(1169, 4.019277, 0.0, -0.019222)
    ops.node(1170, 0.223559, 0.0, 0.505969)
    ops.node(1171, 2.116359, 0.0, -0.04923)
    ops.node(1172, 0.542563, 0.0, 1.498164)
    ops.node(1173, 1.260785, 0.0, -0.085619)
    ops.node(1174, 1.732055, 0.0, -0.017246)
    ops.node(1175, 2.756886, 0.0, 1.300917)
    ops.node(1176, 2.860964, 0.0, 1.096635)
    ops.node(1177, 2.758517, 0.0, 0.859817)
    ops.node(1178, 2.945515, 0.0, 0.734791)
    ops.node(1179, 3.082654, 0.0, 1.12353)
    ops.node(1180, 3.277227, 0.0, 0.795193)
    ops.node(1181, 2.560652, 0.0, 1.335089)
    ops.node(1182, 2.30856, 0.0, 1.025797)
    ops.node(1183, 2.227877, 0.0, 0.763956)
    ops.node(1184, 1.970887, 0.0, 0.805987)
    ops.node(1185, 2.496617, 0.0, 0.841339)
    ops.node(1186, 2.235248, 0.0, 0.480523)
    ops.node(1187, 2.513598, 0.0, 0.364034)
    ops.node(1188, 2.050759, 0.0, 0.618273)
    ops.node(1189, 1.831326, 0.0, 0.377486)
    ops.node(1190, 0.238408, 0.0, 1.073084)
    ops.node(1191, 0.507806, 0.0, 1.043583)
    ops.node(1192, 2.460497, 0.0, -0.057595)
    ops.node(1193, 2.806441, 0.0, -0.0148)
    ops.node(1194, 2.099313, 0.0, 1.227345)
    ops.node(1195, 1.901451, 0.0, 1.038952)
    ops.node(1196, 1.659603, 0.0, 1.333305)
    ops.node(1197, 2.475478, 0.0, 0.116798)
    ops.node(1198, 2.293936, 0.0, 0.235101)
    ops.node(1199, 1.576637, 0.0, -0.05816)
    ops.node(1200, 1.776023, 0.0, 0.193439)
    ops.node(1201, 1.619086, 0.0, 0.394908)
    ops.node(1202, 1.345224, 0.0, 0.518015)
    ops.node(1203, 1.370119, 0.0, 0.798253)
    ops.node(1204, 0.955689, 0.0, 0.745799)
    ops.node(1205, 1.550831, 0.0, 0.892977)
    ops.node(1206, 1.391964, 0.0, 0.232683)
    ops.node(1207, 3.390202, 0.0, -0.056768)
    ops.node(1208, 1.073903, 0.0, 0.518382)
    ops.node(1209, 0.926821, 0.0, 0.319607)
    ops.node(1210, 0.765554, 0.0, 0.150584)
    ops.node(1211, 0.690952, 0.0, 0.363265)
    ops.node(1212, 3.170848, 0.0, 1.318147)
    ops.node(1213, 3.814809, 0.0, 0.006915)
    ops.node(1214, 0.818438, 0.0, 0.543092)
    ops.node(1215, 0.813809, 0.0, 1.003581)
    ops.node(1216, 1.235947, 0.0, 1.255053)
    ops.node(1217, 3.50774, 0.0, 0.268144)
    ops.node(1218, 3.633172, 0.0, 0.452258)
    ops.node(1219, 3.427895, 0.0, 0.466124)
    ops.node(1220, 3.86534, 0.0, 0.762997)
    ops.node(1221, 3.88532, 0.0, 0.480038)
    ops.node(1222, 4.004976, 0.0, 0.951737)
    ops.node(1223, 3.630657, 0.0, 0.835794)
    ops.node(1224, 0.374614, 0.0, 0.637983)
    ops.node(1225, 3.342482, 0.0, 0.629937)
    ops.node(1226, 3.125961, 0.0, 0.624826)
    ops.node(1227, 1.827469, 0.0, 0.595069)
    ops.node(1228, 0.52982, 0.0, 0.200295)
    ops.node(1229, 4.195284, 0.0, 1.099801)
    ops.node(1230, 1.965864, 0.0, 0.245877)
    ops.node(1231, 1.404752, 0.0, 1.048846)
    ops.node(1232, 0.660785, 0.0, 1.26499)
    ops.node(1233, 2.005766, 0.0, 0.438169)
    ops.node(1234, 3.44103, 0.0, 0.773219)
    ops.node(1235, 3.42082, 0.0, 0.967156)
    ops.node(1236, 3.629543, 0.0, 1.080655)
    ops.node(1237, 3.109852, 0.0, 0.806516)
    ops.node(1238, 0.16249, 0.0, 1.479147)
    ops.node(1239, 4.164036, 0.0, -0.061017)
    ops.node(1240, 1.746929, 0.0, 0.851641)
    ops.node(1241, 2.893777, 0.0, 0.552081)
    ops.node(1242, 1.223361, 0.0, 0.047594)
    ops.node(1243, 2.634532, 0.0, 0.703419)
    ops.node(1244, 3.475703, 0.0, 1.193689)
    ops.node(1245, 2.7878, 0.0, 0.364567)
    ops.node(1246, 4.13738, 0.0, 0.378308)
    ops.node(1247, 3.290727, 0.0, 0.313937)
    ops.node(1248, 3.195872, 0.0, 0.960159)
    ops.node(1249, 0.362919, 0.0, 1.533635)
    ops.node(1250, 2.781512, 0.0, 0.678163)
    ops.node(1251, 1.177532, 0.0, 0.708319)
    ops.node(1252, 0.824365, 0.0, -0.038849)
    ops.node(1253, 2.122091, 0.0, 0.127164)
    ops.node(1254, 3.642565, 0.0, 1.401605)
    ops.node(1255, 0.597707, 0.0, 0.546496)
    ops.node(1256, 3.709138, 0.0, 0.632839)
    ops.node(1257, 3.792391, 0.0, 1.238506)
    ops.node(1258, 3.962677, 0.0, 0.203409)
    ops.node(1259, 3.625241, -0.081953, 1.433006)
    ops.node(1260, 0.903665, -0.6244, -0.110719)
    ops.node(1261, 0.240769, -1.048296, 1.110627)
    ops.node(1262, 2.315595, -0.153355, 0.516913)
    ops.node(1263, 4.077743, -0.402271, 0.209921)
    ops.node(1264, 0.964597, -0.075564, -0.090147)
    ops.node(1265, 4.252855, -0.240859, 1.406842)
    ops.node(1266, 3.515065, -0.681622, 1.412818)
    ops.node(1267, 1.32248, -0.220208, 1.014267)
    ops.node(1268, 0.767186, -0.708531, 0.756489)
    ops.node(1269, 0.408611, -1.001158, 1.004084)
    ops.node(1270, 0.115026, -0.122111, 1.307736)
    ops.node(1271, 0.525318, -0.95472, 0.884381)
    ops.node(1272, 0.5385, -0.828698, 0.696608)
    ops.node(1273, 0.514488, -1.214059, 1.160988)
    ops.node(1274, 3.671986, -0.139617, 1.349023)
    ops.node(1275, 0.12247, -0.368753, 1.294275)
    ops.node(1276, 1.504554, -1.03958, 1.240157)
    ops.node(1277, 0.52505, -1.31794, 1.281779)
    ops.node(1278, 3.767812, -1.328328, 1.385107)
    ops.node(1279, 0.358512, -1.120424, 1.118396)
    ops.node(1280, 0.263528, -0.709411, 1.158791)
    ops.node(1281, 0.532339, -1.116149, 1.551812)
    ops.node(1282, 2.234121, -0.610688, 1.313379)
    ops.node(1283, 0.529289, -0.861521, 1.534058)
    ops.node(1284, 1.474195, -0.863369, 1.176335)
    ops.node(1285, 1.006128, -0.82636, 0.70659)
    ops.node(1286, 4.109343, -0.86303, -0.01512)
    ops.node(1287, 4.158943, -0.219197, -0.007158)
    ops.node(1288, 3.634251, -0.272264, 1.347217)
    ops.node(1289, 1.651801, -0.651673, 1.098467)
    ops.node(1290, 1.504103, -0.693564, 1.11007)
    ops.node(1291, 0.524347, -0.598838, 1.527223)
    ops.node(1292, 3.634738, -0.475366, 1.342381)
    ops.node(1293, 0.554164, -0.402464, 1.525147)
    ops.node(1294, 3.675051, -0.981891, 1.347543)
    ops.node(1295, 3.634451, -0.676926, 1.338925)
    ops.node(1296, 0.554405, -1.336765, 1.519655)
    ops.node(1297, 3.497154, -0.145402, 1.273702)
    ops.node(1298, 0.177889, -0.540707, 1.250775)
    ops.node(1299, 1.427941, -1.118798, 1.384055)
    ops.node(1300, 4.166241, -0.485976, 0.026064)
    ops.node(1301, 2.977648, -0.614901, 1.287275)
    ops.node(1302, 1.297222, -0.170368, -0.017073)
    ops.node(1303, 4.122936, -0.69575, 0.000867)
    ops.node(1304, 2.072466, -0.136699, -0.100972)
    ops.node(1305, 0.888556, -1.316443, 1.253903)
    ops.node(1306, 1.736608, -0.204693, 0.707116)
    ops.node(1307, 1.414543, -0.110649, -0.099089)
    ops.node(1308, 2.695734, -0.159035, 0.627745)
    ops.node(1309, 1.925927, -0.235846, 0.898872)
    ops.node(1310, 1.084126, -0.878626, 0.899408)
    ops.node(1311, 1.049583, -0.174495, -0.024126)
    ops.node(1312, 4.379438, -1.208111, 0.019416)
    ops.node(1313, 1.049947, -1.322217, 1.313051)
    ops.node(1314, 1.409635, -0.98317, 1.117007)
    ops.node(1315, 3.355156, -0.182999, 0.727394)
    ops.node(1316, 2.393896, -0.626482, 1.297831)
    ops.node(1317, 1.0575, -0.719905, -0.060851)
    ops.node(1318, 0.151396, -0.969507, 1.285672)
    ops.node(1319, 2.055873, -0.661418, 1.31614)
    ops.node(1320, 2.548502, -0.164774, -0.099328)
    ops.node(1321, 1.260885, -1.29076, 1.251116)
    ops.node(1322, 2.699337, -0.616669, 1.243695)
    ops.node(1323, 1.323365, -1.08601, 1.180895)
    ops.node(1324, 1.247545, -0.909237, 1.052416)
    ops.node(1325, 1.155546, -0.272719, -0.050157)
    ops.node(1326, 0.272384, -0.929732, 1.150234)
    ops.node(1327, 1.184043, -0.726541, 0.907974)
    ops.node(1328, 1.138401, -1.179932, 1.159842)
    ops.node(1329, 2.865708, -0.436874, 1.129308)
    ops.node(1330, 1.0575, -0.504166, -0.052836)
    ops.node(1331, 0.164015, -0.788679, 1.273707)
    ops.node(1332, 1.627096, -0.839097, 1.230536)
    ops.node(1333, 0.77699, -0.787681, 0.112988)
    ops.node(1334, 1.695497, -0.504349, 1.009245)
    ops.node(1335, 3.795064, -1.311895, 1.219246)
    ops.node(1336, 2.241326, -0.405512, 1.077705)
    ops.node(1337, 0.906972, -0.818455, 0.544121)
    ops.node(1338, 1.483353, -0.29674, 0.700466)
    ops.node(1339, 0.8515, -0.302411, -0.04249)
    ops.node(1340, 3.409294, -0.197427, 0.556675)
    ops.node(1341, 3.018021, -0.181371, 0.815829)
    ops.node(1342, 1.322957, -0.423038, 0.707538)
    ops.node(1343, 1.564032, -0.411609, 0.903361)
    ops.node(1344, 0.748093, -0.823209, 0.639642)
    ops.node(1345, 0.8515, -0.504166, -0.038792)
    ops.node(1346, 0.497424, -0.26005, 0.147678)
    ops.node(1347, 0.711034, -1.325162, 1.250404)
    ops.node(1348, 3.684924, -0.17094, 1.195433)
    ops.node(1349, 0.844613, -0.729924, -0.015872)
    ops.node(1350, 0.744389, -0.804652, 0.434708)
    ops.node(1351, 2.375326, -0.171473, -0.085594)
    ops.node(1352, 4.346552, -0.32203, 0.039588)
    ops.node(1353, 1.036341, -0.979579, 0.981768)
    ops.node(1354, 3.329268, -0.185882, -0.065838)
    ops.node(1355, 0.324733, -1.226271, 1.244633)
    ops.node(1356, 0.596723, -0.811733, 0.502812)
    ops.node(1357, 1.62937, -0.168122, 0.020259)
    ops.node(1358, 0.231538, -1.106592, 1.246253)
    ops.node(1359, 0.827363, -0.794688, 0.252323)
    ops.node(1360, 1.421328, -0.787337, 1.023562)
    ops.node(1361, 2.059722, -0.171044, 0.031442)
    ops.node(1362, 3.202213, -0.665445, 1.313936)
    ops.node(1363, 1.002285, -0.812657, 0.355347)
    ops.node(1364, 2.605423, -0.616934, 1.380324)
    ops.node(1365, 3.239933, -0.167696, 1.397119)
    ops.node(1366, 3.372703, -0.172848, 1.225641)
    ops.node(1367, 1.79611, -0.59141, 1.122493)
    ops.node(1368, 3.825138, -0.16983, 1.371938)
    ops.node(1369, 1.749446, -0.331795, 0.910961)
    ops.node(1370, 0.451712, -0.742023, 0.814545)
    ops.node(1371, 0.902376, -1.09911, 1.082557)
    ops.node(1372, 2.602014, -0.118252, 0.103876)
    ops.node(1373, 3.449262, -0.780786, 1.27171)
    ops.node(1374, 0.847933, -0.991248, 0.972424)
    ops.node(1375, 3.513331, -0.181592, 0.754643)
    ops.node(1376, 0.335406, -0.628123, 0.870342)
    ops.node(1377, 1.834004, -0.676575, 1.254852)
    ops.node(1378, 1.899282, -0.403272, 0.999788)
    ops.node(1379, 3.969159, -1.261317, 1.099536)
    ops.node(1380, 4.35827, -1.085739, 1.212882)
    ops.node(1381, 2.776758, -0.224882, 0.922646)
    ops.node(1382, 3.645914, -0.194589, 0.553493)
    ops.node(1383, 1.373752, -0.586215, 0.951675)
    ops.node(1384, 3.586217, -0.928695, 1.230665)
    ops.node(1385, 4.268772, -0.988212, -0.050206)
    ops.node(1386, 3.481274, -0.195941, 0.056942)
    ops.node(1387, 0.576306, -0.813899, 0.307306)
    ops.node(1388, 2.288518, -0.222779, 0.914978)
    ops.node(1389, 3.199429, -0.171091, 1.051538)
    ops.node(1390, 3.303252, -0.176171, 0.901482)
    ops.node(1391, 1.014399, -0.801064, 0.138129)
    ops.node(1392, 3.034608, -0.153513, 0.584222)
    ops.node(1393, 3.684653, -1.165098, 1.243675)
    ops.node(1394, 1.939266, -0.146242, 0.636069)
    ops.node(1395, 2.473547, -0.237411, 0.925958)
    ops.node(1396, 0.219631, -0.356711, 1.056796)
    ops.node(1397, 0.508489, -0.649397, 0.20499)
    ops.node(1398, 3.075989, -0.183611, 1.247441)
    ops.node(1399, 1.257847, -0.453399, 0.245401)
    ops.node(1400, 1.669494, -0.186921, 0.261648)
    ops.node(1401, 2.124003, -0.280377, 0.949832)
    ops.node(1402, 0.254714, -0.291552, 0.164101)
    ops.node(1403, 2.699941, -0.423635, 1.120958)
    ops.node(1404, 1.732416, -0.167832, 0.539529)
    ops.node(1405, 2.406975, -0.409815, 1.08345)
    ops.node(1406, 0.582662, -0.189786, 0.444099)
    ops.node(1407, 0.648889, -1.164436, 1.114824)
    ops.node(1408, 2.001553, -0.495399, 1.21916)
    ops.node(1409, 1.713962, -0.182773, 1.365018)
    ops.node(1410, 3.424191, -0.178767, 0.334723)
    ops.node(1411, 3.508688, -0.176903, 1.0805)
    ops.node(1412, 0.651111, -0.999338, 0.963081)
    ops.node(1413, 1.153579, -0.573907, 0.094034)
    ops.node(1414, 3.275477, -0.182833, 0.167557)
    ops.node(1415, 3.95296, -0.366372, -0.037265)
    ops.node(1416, 3.958667, -0.132755, -0.055363)
    ops.node(1417, 1.833592, -0.176475, 0.10256)
    ops.node(1418, 1.269591, -0.4595, 0.491252)
    ops.node(1419, 1.14782, -0.596447, 0.68043)
    ops.node(1420, 1.24052, -0.276546, 1.313372)
    ops.node(1421, 3.61767, -0.492496, 0.987379)
    ops.node(1422, 0.442667, -0.463717, 0.197916)
    ops.node(1423, 2.970898, -0.229959, 1.011193)
    ops.node(1424, 3.807884, -0.532721, 1.304051)
    ops.node(1425, 3.827595, -0.661366, 0.974862)
    ops.node(1426, 3.828306, -0.725872, 1.332716)
    ops.node(1427, 0.414995, -0.209854, 1.486412)
    ops.node(1428, 1.357973, -0.373675, -0.027565)
    ops.node(1429, 3.73388, -0.203694, 0.74461)
    ops.node(1430, 1.49907, -0.256078, 0.472317)
    ops.node(1431, 2.844371, -0.229425, 1.246823)
    ops.node(1432, 1.488656, -0.213437, 0.885299)
    ops.node(1433, 1.56123, -0.198615, 1.195014)
    ops.node(1434, 1.471807, -0.27581, 0.140471)
    ops.node(1435, 3.669601, -0.226651, 0.320133)
    ops.node(1436, 3.445832, -0.347971, 1.326997)
    ops.node(1437, 4.060046, -0.196516, 0.123046)
    ops.node(1438, 0.304821, -0.226228, 0.54125)
    ops.node(1439, 0.667766, -0.210561, 0.230381)
    ops.node(1440, 1.650759, -0.20324, 0.948168)
    ops.node(1441, 1.624533, -0.373149, 1.313516)
    ops.node(1442, 3.690047, -0.202882, 0.970709)
    ops.node(1443, 1.077995, -0.660444, 0.479212)
    ops.node(1444, 2.633943, -0.202714, 1.243886)
    ops.node(1445, 3.720851, -0.803005, 1.139212)
    ops.node(1446, 3.809146, -1.051021, 1.143685)
    ops.node(1447, 3.894734, -0.226072, 0.903595)
    ops.node(1448, 4.116626, -0.270722, 1.283415)
    ops.node(1449, 1.854263, -0.508827, 1.318119)
    ops.node(1450, 3.485359, -0.608088, 1.133315)
    ops.node(1451, 3.885002, -0.207496, 1.153076)
    ops.node(1452, 3.838212, -0.200148, 0.148391)
    ops.node(1453, 0.81207, -0.207034, 0.408655)
    ops.node(1454, 0.687116, -0.208517, 0.618396)
    ops.node(1455, 3.430129, -0.573529, 1.325636)
    ops.node(1456, 1.069092, -0.222058, 0.656687)
    ops.node(1457, 2.966755, -0.441033, 1.305895)
    ops.node(1458, 2.070271, -0.144448, 0.241857)
    ops.node(1459, 3.855547, -1.116729, 1.322988)
    ops.node(1460, 4.022076, -0.645324, 1.312287)
    ops.node(1461, 1.656228, -0.618163, 1.302912)
    ops.node(1462, 4.144396, -1.242886, 0.919873)
    ops.node(1463, 1.454646, -0.625166, 1.31863)
    ops.node(1464, 3.234187, -0.507506, 1.153288)
    ops.node(1465, 4.302451, -1.240237, 0.608829)
    ops.node(1466, 1.262134, -0.212129, 0.190514)
    ops.node(1467, 2.270015, -0.358288, 1.303971)
    ops.node(1468, 0.311477, -1.244772, 1.544267)
    ops.node(1469, 4.016821, -0.903052, 1.295121)
    ops.node(1470, 3.920231, -0.578182, -0.02323)
    ops.node(1471, 2.01912, -0.235677, 1.094831)
    ops.node(1472, 2.270015, -0.182732, 1.300184)
    ops.node(1473, 0.588629, -0.740729, 1.421041)
    ops.node(1474, 0.587566, -1.183686, 1.415916)
    ops.node(1475, 1.230126, -0.220035, 0.822574)
    ops.node(1476, 1.178518, -1.078226, 1.300417)
    ops.node(1477, 1.175373, -0.667458, 1.282556)
    ops.node(1478, 0.607422, -0.970949, 1.425543)
    ops.node(1479, 0.457853, -0.666349, 0.52981)
    ops.node(1480, 1.080284, -0.226463, 0.387376)
    ops.node(1481, 0.933996, -0.155901, 0.16747)
    ops.node(1482, 0.138407, -0.203174, 1.077407)
    ops.node(1483, 3.391661, -0.410275, 1.057791)
    ops.node(1484, 1.177688, -0.910863, 1.292844)
    ops.node(1485, 3.698898, -0.362489, -0.023338)
    ops.node(1486, 1.357769, -0.206137, 1.190784)
    ops.node(1487, 1.799881, -0.213468, 1.139908)
    ops.node(1488, 0.348375, -0.598412, 1.537538)
    ops.node(1489, 2.506039, -0.427181, 1.295347)
    ops.node(1490, 0.34925, -0.228782, 0.994852)
    ops.node(1491, 0.240284, -1.073531, 1.41558)
    ops.node(1492, 3.205767, -0.414539, 1.308562)
    ops.node(1493, 4.158594, -0.245667, 1.013885)
    ops.node(1494, 4.28102, -0.81754, 1.233975)
    ops.node(1495, 0.316565, -0.472741, 0.902571)
    ops.node(1496, 3.058458, -0.40177, 1.120632)
    ops.node(1497, 3.899213, -0.447245, 0.699777)
    ops.node(1498, 0.319561, -0.826735, 1.55911)
    ops.node(1499, 0.401274, -0.593308, 0.37587)
    ops.node(1500, 3.872369, -0.446545, 0.203487)
    ops.node(1501, 3.934111, -0.904772, 1.040263)
    ops.node(1502, 0.878456, -0.739766, 1.270837)
    ops.node(1503, 0.904158, -0.295382, 1.29578)
    ops.node(1504, 1.418257, -0.771963, 1.31664)
    ops.node(1505, 0.886911, -0.969683, 1.293664)
    ops.node(1506, 0.895213, -0.515594, 1.265789)
    ops.node(1507, 3.771949, -0.354962, 0.433824)
    ops.node(1508, 0.204545, -0.222699, 1.214258)
    ops.node(1509, 3.958036, -0.245528, 0.347281)
    ops.node(1510, 0.262656, -0.240327, 0.799607)
    ops.node(1511, 2.063507, -0.350143, 1.290758)
    ops.node(1512, 2.418312, -0.223555, 1.133442)
    ops.node(1513, 0.352316, -0.470217, 0.629381)
    ops.node(1514, 0.959469, -1.148811, 1.283953)
    ops.node(1515, 0.155671, -0.932976, 1.538637)
    ops.node(1516, 4.096832, -0.629322, 0.327043)
    ops.node(1517, 4.265261, -0.923939, 0.202032)
    ops.node(1518, 4.093585, -0.667732, 0.668107)
    ops.node(1519, 0.476394, -0.210543, 1.211748)
    ops.node(1520, 4.258061, -1.30849, 1.242759)
    ops.node(1521, 4.256182, -1.220479, 0.224344)
    ops.node(1522, 0.8049, -0.239035, 0.838327)
    ops.node(1523, 0.31094, -0.35718, 0.398197)
    ops.node(1524, 1.113221, -0.242411, 1.153317)
    ops.node(1525, 4.018552, -0.188077, 0.57561)
    ops.node(1526, 4.265442, -0.311021, 0.29075)
    ops.node(1527, 4.246318, -1.270261, -0.058403)
    ops.node(1528, 4.164274, -1.06545, 1.144437)
    ops.node(1529, 3.709049, -1.169972, 1.392897)
    ops.node(1530, 0.501918, -0.880342, 1.041558)
    ops.node(1531, 1.004216, -0.87917, -0.084362)
    ops.node(1532, 0.521726, -1.075191, 1.039967)
    ops.node(1533, 1.547552, -0.531977, 1.157408)
    ops.node(1534, 0.535237, -1.106965, 1.270434)
    ops.node(1535, 1.38982, -0.613817, 1.157268)
    ops.node(1536, 0.975495, -0.871892, 1.104086)
    ops.node(1537, 1.089447, -1.039732, 1.107459)
    ops.node(1538, 0.386869, -1.032827, 1.260491)
    ops.node(1539, 1.372404, -1.201044, 1.253747)
    ops.node(1540, 0.376203, -0.74539, 1.071994)
    ops.node(1541, 0.685936, -0.908857, 0.851836)
    ops.node(1542, 0.301846, -0.851078, 1.333221)
    ops.node(1543, 3.543283, -0.317454, 1.168072)
    ops.node(1544, 0.405422, -0.996694, 1.456022)
    ops.node(1545, 0.406277, -0.737226, 1.426703)
    ops.node(1546, 0.870096, -0.824741, 0.865326)
    ops.node(1547, 1.857186, -0.149541, -0.077989)
    ops.node(1548, 0.935061, -0.661412, 0.903637)
    ops.node(1549, 0.312407, -0.527363, 1.107441)
    ops.node(1550, 3.690422, -0.565092, 1.166847)
    ops.node(1551, 1.570724, -0.920286, 1.368792)
    ops.node(1552, 2.800699, -0.606527, 1.385411)
    ops.node(1553, 0.708721, -0.635806, 0.534413)
    ops.node(1554, 1.664402, -0.358714, 1.093307)
    ops.node(1555, 0.385007, -1.237246, 1.434234)
    ops.node(1556, 0.338133, -0.409456, 1.251078)
    ops.node(1557, 0.953196, -0.614313, 0.269715)
    ops.node(1558, 2.094527, -0.42568, 1.032637)
    ops.node(1559, 0.798425, -1.154694, 1.187166)
    ops.node(1560, 0.88698, -0.650424, 0.638549)
    ops.node(1561, 3.783184, -0.3651, 1.370956)
    ops.node(1562, 1.321451, -0.803434, 1.186382)
    ops.node(1563, 1.252804, -1.295851, 1.398275)
    ops.node(1564, 2.085313, -0.152235, 0.836148)
    ops.node(1565, 1.15011, -0.574089, 0.294538)
    ops.node(1566, 0.252421, -0.457415, 1.449922)
    ops.node(1567, 0.506923, -0.552179, 1.340183)
    ops.node(1568, 3.296452, -0.303432, 1.129946)
    ops.node(1569, 0.73774, -0.635068, 0.207887)
    ops.node(1570, 1.056123, -0.332342, 0.122042)
    ops.node(1571, 2.214895, -0.158611, 0.667524)
    ops.node(1572, 2.729814, -0.39274, 1.315277)
    ops.node(1573, 4.281526, -0.766265, 0.030886)
    ops.node(1574, 2.215051, -0.179035, 1.122737)
    ops.node(1575, 0.882556, -0.635977, 0.451767)
    ops.node(1576, 0.373387, -0.387851, 1.574012)
    ops.node(1577, 1.933179, -0.188808, 0.457022)
    ops.node(1578, 0.688759, -0.441826, 0.158511)
    ops.node(1579, 3.741331, -0.14722, -0.065735)
    ops.node(1580, 0.194664, -0.700819, 1.467193)
    ops.node(1581, 1.176006, -0.524048, 0.891841)
    ops.node(1582, 3.180237, -0.165868, 0.419921)
    ops.node(1583, 0.972181, -0.593827, 0.103321)
    ops.node(1584, 1.302388, -0.455859, 1.156127)
    ops.node(1585, 3.735948, -0.368687, 1.154619)
    ops.node(1586, 0.599174, -0.388945, 0.297382)
    ops.node(1587, 0.677706, -0.395124, 0.479339)
    ops.node(1588, 0.616179, -0.62964, 0.715356)
    ops.node(1589, 1.289339, -0.234158, 0.565229)
    ops.node(1590, 3.025255, -0.152648, 0.127574)
    ops.node(1591, 0.706479, -0.849513, 1.277269)
    ops.node(1592, 3.748368, -0.415664, 0.868954)
    ops.node(1593, 2.489122, -0.189499, 1.374349)
    ops.node(1594, 3.878288, -0.644492, 1.155508)
    ops.node(1595, 3.196025, -0.153953, 0.679761)
    ops.node(1596, 0.682473, -0.347012, 1.308578)
    ops.node(1597, 4.105929, -1.088407, 1.360395)
    ops.node(1598, 1.46184, -0.139039, 1.366192)
    ops.node(1599, 0.388608, -0.172864, 0.276602)
    ops.node(1600, 3.898458, -0.443275, 1.031363)
    ops.node(1601, 3.978191, -1.346871, 1.237963)
    ops.node(1602, 2.733904, -0.131167, -0.088132)
    ops.node(1603, 0.67389, -0.554375, 1.312874)
    ops.node(1604, 1.02126, -0.443271, 0.544036)
    ops.node(1605, 1.528571, -0.2977, -0.064364)
    ops.node(1606, 2.761889, -0.160447, 0.422534)
    ops.node(1607, 0.887274, -0.391634, 0.322175)
    ops.node(1608, 0.492247, -0.340546, 0.812059)
    ops.node(1609, 1.262551, -0.386087, 0.974426)
    ops.node(1610, 1.093752, -0.453764, 1.19631)
    ops.node(1611, 2.586884, -0.144389, 0.419603)
    ops.node(1612, 3.147522, -0.335587, 0.942339)
    ops.node(1613, 4.061419, -0.694321, 0.928619)
    ops.node(1614, 4.140218, -0.423172, 0.838515)
    ops.node(1615, 1.003622, -0.218823, 0.958986)
    ops.node(1616, 4.209967, -0.964217, 0.589271)
    ops.node(1617, 0.512451, -0.86518, 1.305158)
    ops.node(1618, 0.611432, -0.968263, 1.159982)
    ops.node(1619, 0.413563, -0.652311, 1.234116)
    ops.node(1620, 1.238743, -0.634239, 1.061316)
    ops.node(1621, 0.718179, -0.803564, 1.019952)
    ops.node(1622, 0.533577, -0.629547, 0.977396)
    ops.node(1623, 0.789173, -0.945998, 1.154591)
    ops.node(1624, 0.647392, -0.766638, 0.874429)
    ops.node(1625, 0.262464, -0.258428, 1.373741)
    ops.node(1626, 0.275242, -0.628998, 1.322678)
    ops.node(1627, 3.957496, -0.413924, 1.266799)
    ops.node(1628, 0.434434, -0.829743, 1.167452)
    ops.node(1629, 0.593148, -0.609888, 0.378362)
    ops.node(1630, 0.832735, -0.439606, 0.557774)
    ops.node(1631, 3.496878, -0.330317, 0.887138)
    ops.node(1632, 3.638771, -0.677233, 1.067831)
    ops.node(1633, 1.237009, -0.435802, 0.062606)
    ops.node(1634, 1.122, -0.803141, 1.132631)
    ops.node(1635, 0.568657, -0.446003, 1.162608)
    ops.node(1636, 0.739203, -1.10557, 1.336592)
    ops.node(1637, 1.432389, -0.397038, 1.337319)
    ops.node(1638, 1.474591, -0.368566, 1.072367)
    ops.node(1639, 0.484799, -0.325541, 0.60597)
    ops.node(1640, 0.786185, -0.607328, 1.101743)
    ops.node(1641, 0.535537, -0.536984, 0.824543)
    ops.node(1642, 1.034918, -0.641887, 1.081653)
    ops.node(1643, 0.829972, -0.382902, 1.096305)
    ops.node(1644, 0.973533, -0.464153, 0.77434)
    ops.node(1645, 0.715247, -0.444089, 0.704276)
    ops.node(1646, 0.619056, -0.241217, 0.951228)
    ops.node(1647, 4.188033, -0.395246, 0.555559)
    ops.node(1648, 0.73751, -0.197911, 1.157799)
    ops.node(1649, 4.208146, -0.525709, 1.182561)
    ops.node(1650, 4.136549, -0.947631, 0.884527)
    ops.node(1651, 1.224586, -0.55404, -0.100205)
    ops.node(1652, 0.612651, -0.721415, 1.167525)
    ops.node(1653, 0.756661, -0.562881, 0.852078)
    ops.node(1654, 0.528098, -0.492696, 0.569917)
    ops.node(1655, 0.988471, -0.456731, 0.985984)
    ops.node(1656, 0.279693, -0.566714, 0.127883)
    ops.node(1657, 1.747651, -0.269434, -0.102771)
    ops.node(1658, 2.892236, -0.147178, -0.089725)
    ops.node(1659, 2.260974, -0.142453, 0.095778)
    ops.node(1660, 2.483059, -0.141388, 0.69747)
    ops.node(1661, 2.798269, -0.14761, 0.16234)
    ops.node(1662, 3.044519, -0.682784, 1.412493)
    ops.node(1663, 3.57292, -1.068827, 1.389171)
    ops.node(1664, 4.118981, -1.158996, -0.083531)
    ops.node(1665, 0.410424, -1.321209, 1.191067)
    ops.node(1666, 3.980305, -0.773321, -0.093721)
    ops.node(1667, 2.650625, -0.150054, 0.802994)
    ops.node(1668, 3.082216, -0.149936, -0.081703)
    ops.node(1669, 2.407684, -0.140863, 0.304525)
    ops.node(1670, 2.08843, -0.145203, 0.475499)
    ops.node(1671, 2.853925, -0.15718, 0.665479)
    ops.node(1672, 0.432259, -0.762605, 0.113656)
    ops.node(1673, 0.530743, -0.115353, 1.584093)
    ops.node(1674, 0.212213, -0.463179, 0.728067)
    ops.node(1675, 2.938337, -0.111362, 1.392451)
    ops.node(1676, 3.536688, -0.126325, 1.41427)
    ops.node(1677, 3.605154, -0.360672, 0.657024)
    ops.node(1678, 1.197903, -0.109963, -0.111621)
    ops.node(1679, 2.55616, -0.541825, 1.172888)
    ops.node(1680, 3.355013, -0.552122, 1.035403)
    ops.node(1681, 3.564787, -0.311268, 0.18062)
    ops.node(1682, 1.804771, -0.796631, 1.360811)
    ops.node(1683, 1.396367, -0.425357, 0.859467)
    ops.node(1684, 1.920495, -0.657198, 1.386003)
    ops.node(1685, 4.000078, -1.088665, 1.041124)
    ops.node(1686, 4.129151, -0.099982, -0.131249)
    ops.node(1687, 3.510398, -0.919672, 1.394688)
    ops.node(1688, 0.59949, -0.205534, 1.471901)
    ops.node(1689, 3.999173, -1.250653, 1.340444)
    ops.node(1690, 3.518356, -0.208, -0.091813)
    ops.node(1691, 0.099977, -0.600706, 1.578002)
    ops.node(1692, 1.711692, -0.511111, 1.405754)
    ops.node(1693, 1.264119, -0.519344, 1.386676)
    ops.node(1694, 3.820363, -0.936533, 1.383632)
    ops.node(1695, 1.24989, -0.788923, 1.384016)
    ops.node(1696, 2.360314, -0.475538, 1.365785)
    ops.node(1697, 0.998745, -0.84969, 1.365548)
    ops.node(1698, 0.983136, -0.629044, 1.37925)
    ops.node(1699, 4.021174, -0.137038, 1.402015)
    ops.node(1700, 4.095508, -0.506742, 1.397753)
    ops.node(1701, 1.894365, -0.360907, 1.405032)
    ops.node(1702, 4.336999, -0.614262, 1.407415)
    ops.node(1703, 0.750949, -0.20436, 0.087458)
    ops.node(1704, 3.669077, -0.828515, 1.359)
    ops.node(1705, 0.822318, -0.139922, -0.03342)
    ops.node(1706, 2.274094, -0.491102, 1.204243)
    ops.node(1707, 4.279167, -1.068086, 1.369628)
    ops.node(1708, 2.215288, -0.151517, -0.053698)
    ops.node(1709, 1.959776, -0.156703, 1.30092)
    ops.node(1710, 0.955827, -0.404588, -0.04773)
    ops.node(1711, 1.518054, -0.537812, 1.012134)
    ops.node(1712, 1.327888, -0.983411, 1.264251)
    ops.node(1713, 0.747699, -1.078461, 1.044133)
    ops.node(1714, 2.596993, -0.343933, 0.998039)
    ops.node(1715, 1.707126, -0.487793, 1.215522)
    ops.node(1716, 2.706608, -0.184816, 1.074588)
    ops.node(1717, 1.862746, -0.437736, 1.167796)
    ops.node(1718, 1.374867, -0.348546, 0.348803)
    ops.node(1719, 0.437116, -0.16271, 0.729589)
    ops.node(1720, 3.813372, -0.889164, 1.243294)
    ops.node(1721, 0.359637, -0.627766, 0.692223)
    ops.node(1722, 0.874108, -0.215146, 0.637141)
    ops.node(1723, 0.879911, -0.461646, 0.133364)
    ops.node(1724, 4.011824, -0.794928, 1.128737)
    ops.node(1725, 0.441145, -0.406165, 1.406941)
    ops.node(1726, 1.894164, -0.167901, 0.287677)
    ops.node(1727, 1.099069, -0.413892, 0.316587)
    ops.node(1728, 0.444951, -0.382388, 1.043968)
    ops.node(1729, 0.866205, -0.768812, 1.096537)
    ops.node(1730, 0.764904, -0.542745, 0.354908)
    ops.node(1731, 0.659937, -0.49732, 0.972611)
    ops.node(1732, 4.424944, -0.61287, 1.345327)
    ops.node(1733, 4.417363, -0.614958, 0.026878)
    ops.node(1734, 4.397518, -0.318653, 1.347394)
    ops.node(1735, 0.531885, -0.906938, 0.159737)
    ops.node(1736, 3.581255, -1.196728, 1.432741)
    ops.node(1737, 1.175058, -1.011569, 0.985098)
    ops.node(1738, 4.274731, -0.560105, -0.105058)
    ops.node(1739, 2.890958, -0.614134, 1.175365)
    ops.node(1740, 0.611816, -0.835562, 0.122112)
    ops.node(1741, 2.903694, -0.132173, 0.472409)
    ops.node(1742, 0.44484, -1.21509, 1.06011)
    ops.node(1743, 0.148028, -0.107154, 0.098788)
    ops.node(1744, 1.04411, -1.173958, 1.041032)
    ops.node(1745, 0.423339, -0.921242, 1.602716)
    ops.node(1746, 4.051912, 1.132652, 0.75)
    ops.node(1747, 4.144396, 1.242886, 0.919873)
    ops.node(1748, 3.839712, 1.122965, 0.926459)
    ops.node(1749, 3.93, 1.384, 0.9)
    ops.node(1750, 1.262134, 0.212129, 0.190514)
    ops.node(1751, 3.536688, 0.126325, 1.41427)
    ops.node(1752, 3.390141, 0.225154, 1.5)
    ops.node(1753, 3.497154, 0.145402, 1.273702)
    ops.node(1754, 3.445832, 0.347971, 1.326997)
    ops.node(1755, 0.847933, 0.991248, 0.972424)
    ops.node(1756, 0.793334, 1.156667, 0.9)
    ops.node(1757, 0.950465, 1.157194, 0.900474)
    ops.node(1758, 0.902376, 1.09911, 1.082557)
    ops.node(1759, 2.695734, 0.159035, 0.627745)
    ops.node(1760, 3.741331, 0.14722, -0.065735)
    ops.node(1761, 3.907043, 0.249094, -0.2)
    ops.node(1762, 3.95296, 0.366372, -0.037265)
    ops.node(1763, 3.698898, 0.362489, -0.023338)
    ops.node(1764, 1.695497, 0.504349, 1.009245)
    ops.node(1765, 1.79611, 0.59141, 1.122493)
    ops.node(1766, 1.756276, 0.68395, 0.979231)
    ops.node(1767, 1.814355, 0.523249, 0.879648)
    ops.node(1768, 2.596993, 0.343933, 0.998039)
    ops.node(1769, 2.603978, 0.618696, 1.045827)
    ops.node(1770, 2.705274, 0.439608, 0.884647)
    ops.node(1771, 2.699941, 0.423635, 1.120958)
    ops.node(1772, 1.0575, 0.504166, -0.052836)
    ops.node(1773, 0.9545, 0.522499, -0.2)
    ops.node(1774, 1.109, 0.396, -0.2)
    ops.node(1775, 1.109, 0.594, -0.2)
    ops.node(1776, 2.407684, 0.140863, 0.304525)
    ops.node(1777, 2.57027, 0.29, 0.195553)
    ops.node(1778, 2.381644, 0.29, 0.215571)
    ops.node(1779, 2.602014, 0.118252, 0.103876)
    ops.node(1780, 4.158943, 0.219197, -0.007158)
    ops.node(1781, 4.060046, 0.196516, 0.123046)
    ops.node(1782, 1.6284, 0.718916, 0.93)
    ops.node(1783, 1.652776, 0.559117, 0.84)
    ops.node(1784, 4.265261, 0.923939, 0.202032)
    ops.node(1785, 3.92943, 0.853144, 0.494212)
    ops.node(1786, 3.951632, 0.890539, 0.240733)
    ops.node(1787, 4.046385, 1.117041, 0.321374)
    ops.node(1788, 0.44484, 1.21509, 1.06011)
    ops.node(1789, 0.3125, 1.314759, 1.0875)
    ops.node(1790, 0.358512, 1.120424, 1.118396)
    ops.node(1791, 0.375, 1.206506, 0.975)
    ops.node(1792, 3.709049, 1.169972, 1.392897)
    ops.node(1793, 3.542581, 1.200285, 1.359828)
    ops.node(1794, 3.6, 1.382, 1.35)
    ops.node(1795, 3.708, 1.277143, 1.5)
    ops.node(1796, 2.085313, 0.152235, 0.836148)
    ops.node(1797, 2.214895, 0.158611, 0.667524)
    ops.node(1798, 2.021427, 0.305921, 0.75)
    ops.node(1799, 1.939266, 0.146242, 0.636069)
    ops.node(1800, 1.014399, 0.801064, 0.138129)
    ops.node(1801, 0.8, 0.99, 0.18)
    ops.node(1802, 0.9545, 0.99, 0.248612)
    ops.node(1803, 0.827363, 0.794688, 0.252323)
    ops.node(1804, 1.04411, 1.173958, 1.041032)
    ops.node(1805, 1.233332, 1.12796, 0.973784)
    ops.node(1806, 1.089447, 1.039732, 1.107459)
    ops.node(1807, 1.138401, 1.179932, 1.159842)
    ops.node(1808, 3.082216, 0.149936, -0.081703)
    ops.node(1809, 0.388608, 0.172864, 0.276602)
    ops.node(1810, 0.667766, 0.210561, 0.230381)
    ops.node(1811, 0.582662, 0.189786, 0.444099)
    ops.node(1812, 4.095, 1.385, -0.2)
    ops.node(1813, 4.2, 1.277143, -0.2)
    ops.node(1814, 4.246318, 1.270261, -0.058403)
    ops.node(1815, 4.2, 1.49, -0.2)
    ops.node(1816, 4.095, 1.385, 0.0375)
    ops.node(1817, 4.118981, 1.158996, -0.083531)
    ops.node(1818, 1.894164, 0.167901, 0.287677)
    ops.node(1819, 2.070271, 0.144448, 0.241857)
    ops.node(1820, 2.013198, 0.306655, 0.11008)
    ops.node(1821, 1.833592, 0.176475, 0.10256)
    ops.node(1822, 0.4375, 1.098253, 0.8625)
    ops.node(1823, 0.521726, 1.075191, 1.039967)
    ops.node(1824, 0.408611, 1.001158, 1.004084)
    ops.node(1825, 1.732416, 0.167832, 0.539529)
    ops.node(1826, 1.677152, 0.399318, 0.56)
    ops.node(1827, 1.855432, 0.339584, 0.434388)
    ops.node(1828, 1.855276, 0.339636, 0.617329)
    ops.node(1829, 0.596723, 0.811733, 0.502812)
    ops.node(1830, 0.744389, 0.804652, 0.434708)
    ops.node(1831, 0.64578, 0.99, 0.402929)
    ops.node(1832, 0.576306, 0.813899, 0.307306)
    ops.node(1833, 0.955827, 0.404588, -0.04773)
    ops.node(1834, 1.155546, 0.272719, -0.050157)
    ops.node(1835, 1.049583, 0.174495, -0.024126)
    ops.node(1836, 1.056123, 0.332342, 0.122042)
    ops.node(1837, 0.423339, 0.921242, 1.602716)
    ops.node(1838, 0.279748, 1.04049, 1.695)
    ops.node(1839, 0.5, 0.993333, 1.695)
    ops.node(1840, 0.5, 0.745, 1.695)
    ops.node(1841, 3.920231, 0.578182, -0.02323)
    ops.node(1842, 3.872369, 0.446545, 0.203487)
    ops.node(1843, 3.820598, 0.699753, 0.270786)
    ops.node(1844, 4.096832, 0.629322, 0.327043)
    ops.node(1845, 0.644389, 0.99, 0.605506)
    ops.node(1846, 0.5, 0.99, 0.5)
    ops.node(1847, 2.938337, 0.111362, 1.392451)
    ops.node(1848, 2.9, 0.263333, 1.5)
    ops.node(1849, 3.162395, 0.259688, 1.5)
    ops.node(1850, 3.6, 1.382, 1.5)
    ops.node(1851, 0.973533, 0.464153, 0.77434)
    ops.node(1852, 1.02126, 0.443271, 0.544036)
    ops.node(1853, 1.069092, 0.222058, 0.656687)
    ops.node(1854, 1.322957, 0.423038, 0.707538)
    ops.node(1855, 1.518054, 0.537812, 1.012134)
    ops.node(1856, 1.373752, 0.586215, 0.951675)
    ops.node(1857, 1.504103, 0.693564, 1.11007)
    ops.node(1858, 1.38982, 0.613817, 1.157268)
    ops.node(1859, 0.73751, 0.197911, 1.157799)
    ops.node(1860, 0.8049, 0.239035, 0.838327)
    ops.node(1861, 1.003622, 0.218823, 0.958986)
    ops.node(1862, 0.164015, 0.788679, 1.273707)
    ops.node(1863, 0.146474, 0.811457, 1.068174)
    ops.node(1864, 0.0, 0.707143, 1.2)
    ops.node(1865, 0.263528, 0.709411, 1.158791)
    ops.node(1866, 3.838212, 0.200148, 0.148391)
    ops.node(1867, 3.296452, 0.303432, 1.129946)
    ops.node(1868, 3.391661, 0.410275, 1.057791)
    ops.node(1869, 3.303252, 0.176171, 0.901482)
    ops.node(1870, 3.508688, 0.176903, 1.0805)
    ops.node(1871, 1.252804, 1.295851, 1.398275)
    ops.node(1872, 1.100732, 1.241667, 1.5)
    ops.node(1873, 1.100732, 1.49, 1.5)
    ops.node(1874, 1.286358, 1.454266, 1.5)
    ops.node(1875, 0.514488, 1.214059, 1.160988)
    ops.node(1876, 0.58, 1.323333, 1.05)
    ops.node(1877, 0.5, 1.24, 0.975)
    ops.node(1878, 0.648889, 1.164436, 1.114824)
    ops.node(1879, 3.275477, 0.182833, 0.167557)
    ops.node(1880, 3.481274, 0.195941, 0.056942)
    ops.node(1881, 3.212778, 0.325828, 0.049133)
    ops.node(1882, 3.329268, 0.185882, -0.065838)
    ops.node(1883, 2.489122, 0.189499, 1.374349)
    ops.node(1884, 4.268772, 0.988212, -0.050206)
    ops.node(1885, 4.070065, 1.213978, 0.05247)
    ops.node(1886, 2.001553, 0.495399, 1.21916)
    ops.node(1887, 2.2, 0.623333, 1.05)
    ops.node(1888, 1.985239, 0.716976, 1.104178)
    ops.node(1889, 1.968705, 0.576438, 0.975953)
    ops.node(1890, 0.272384, 0.929732, 1.150234)
    ops.node(1891, 0.476394, 0.210543, 1.211748)
    ops.node(1892, 0.414995, 0.209854, 1.486412)
    ops.node(1893, 4.129151, 0.099982, -0.131249)
    ops.node(1894, 4.2, 0.212857, -0.2)
    ops.node(1895, 1.396367, 0.425357, 0.859467)
    ops.node(1896, 1.33867, 0.642328, 0.75)
    ops.node(1897, 1.496813, 0.505365, 0.75)
    ops.node(1898, 3.958036, 0.245528, 0.347281)
    ops.node(1899, 0.155671, 0.932976, 1.538637)
    ops.node(1900, 0.040016, 1.174884, 1.461521)
    ops.node(1901, 0.151396, 0.969507, 1.285672)
    ops.node(1902, 0.240284, 1.073531, 1.41558)
    ops.node(1903, 3.564787, 0.311268, 0.18062)
    ops.node(1904, 3.500625, 0.4357, 0.036234)
    ops.node(1905, 2.059722, 0.171044, 0.031442)
    ops.node(1906, 2.013411, 0.306636, -0.069679)
    ops.node(1907, 2.2, 0.29, -0.01)
    ops.node(1908, 1.504554, 1.03958, 1.240157)
    ops.node(1909, 1.579648, 1.038514, 1.11)
    ops.node(1910, 1.555272, 1.198312, 1.2)
    ops.node(1911, 1.498383, 1.120278, 1.100366)
    ops.node(1912, 1.409635, 0.98317, 1.117007)
    ops.node(1913, 4.018552, 0.188077, 0.57561)
    ops.node(1914, 0.099977, 0.600706, 1.578002)
    ops.node(1915, 0.250249, 0.50145, 1.695)
    ops.node(1916, 0.25242, 0.761953, 1.695)
    ops.node(1917, 0.348375, 0.598412, 1.537538)
    ops.node(1918, 1.474195, 0.863369, 1.176335)
    ops.node(1919, 1.666866, 1.031565, 1.2)
    ops.node(1920, 1.834004, 0.676575, 1.254852)
    ops.node(1921, 1.762202, 0.803614, 1.082494)
    ops.node(1922, 1.8171, 0.89857, 1.2)
    ops.node(1923, 0.250107, 0.249368, 1.695)
    ops.node(1924, 1.627096, 0.839097, 1.230536)
    ops.node(1925, 1.570724, 0.920286, 1.368792)
    ops.node(1926, 4.379438, 1.208111, 0.019416)
    ops.node(1927, 4.5, 1.39, 0.225)
    ops.node(1928, 4.5, 0.926667, -0.2)
    ops.node(1929, 4.5, 1.0417130000000001, 0.360822)
    ops.node(1930, 0.715247, 0.444089, 0.704276)
    ops.node(1931, 0.88698, 0.650424, 0.638549)
    ops.node(1932, 0.708721, 0.635806, 0.534413)
    ops.node(1933, 0.832735, 0.439606, 0.557774)
    ops.node(1934, 0.764904, 0.542745, 0.354908)
    ops.node(1935, 0.887274, 0.391634, 0.322175)
    ops.node(1936, 0.677706, 0.395124, 0.479339)
    ops.node(1937, 1.925927, 0.235846, 0.898872)
    ops.node(1938, 4.274731, 0.560105, -0.105058)
    ops.node(1939, 4.2, 0.638571, -0.2)
    ops.node(1940, 4.4, 0.638571, -0.2)
    ops.node(1941, 4.281526, 0.766265, 0.030886)
    ops.node(1942, 2.473547, 0.237411, 0.925958)
    ops.node(1943, 2.288518, 0.222779, 0.914978)
    ops.node(1944, 2.375, 0.29, 0.75)
    ops.node(1945, 2.324792, 0.464166, 0.906749)
    ops.node(1946, 1.372404, 1.201044, 1.253747)
    ops.node(1947, 1.475368, 1.317716, 1.35)
    ops.node(1948, 1.427941, 1.118798, 1.384055)
    ops.node(1949, 1.080284, 0.226463, 0.387376)
    ops.node(1950, 0.0, 0.724724, 1.466814)
    ops.node(1951, 0.0, 0.99, 1.4475)
    ops.node(1952, 3.669601, 0.226651, 0.320133)
    ops.node(1953, 3.645914, 0.194589, 0.553493)
    ops.node(1954, 3.532534, 0.451055, 0.509375)
    ops.node(1955, 3.771949, 0.354962, 0.433824)
    ops.node(1956, 2.55616, 0.541825, 1.172888)
    ops.node(1957, 2.55, 0.79, 1.2)
    ops.node(1958, 2.699337, 0.616669, 1.243695)
    ops.node(1959, 2.396926, 0.640353, 1.065318)
    ops.node(1960, 3.885708, 0.779503, 0.026925)
    ops.node(1961, 4.122936, 0.69575, 0.000867)
    ops.node(1962, 0.352484, 1.465463, 1.437795)
    ops.node(1963, 0.52505, 1.31794, 1.281779)
    ops.node(1964, 0.554405, 1.336765, 1.519655)
    ops.node(1965, 0.5, 1.49, 1.4475)
    ops.node(1966, 0.747699, 1.078461, 1.044133)
    ops.node(1967, 0.58, 1.156667, 0.9)
    ops.node(1968, 0.786667, 1.323333, 1.05)
    ops.node(1969, 4.164274, 1.06545, 1.144437)
    ops.node(1970, 4.258061, 1.30849, 1.242759)
    ops.node(1971, 3.999173, 1.250653, 1.340444)
    ops.node(1972, 3.969159, 1.261317, 1.099536)
    ops.node(1973, 0.568657, 0.446003, 1.162608)
    ops.node(1974, 0.829972, 0.382902, 1.096305)
    ops.node(1975, 0.619056, 0.241217, 0.951228)
    ops.node(1976, 3.543283, 0.317454, 1.168072)
    ops.node(1977, 3.634251, 0.272264, 1.347217)
    ops.node(1978, 3.684924, 0.17094, 1.195433)
    ops.node(1979, 4.417363, 0.614958, 0.026878)
    ops.node(1980, 4.209967, 0.964217, 0.589271)
    ops.node(1981, 4.093585, 0.667732, 0.668107)
    ops.node(1982, 3.980305, 0.773321, -0.093721)
    ops.node(1983, 3.954955, 0.896136, -0.2)
    ops.node(1984, 3.808856, 0.686666, -0.2)
    ops.node(1985, 4.095, 0.791429, -0.2)
    ops.node(1986, 1.651801, 0.651673, 1.098467)
    ops.node(1987, 1.604024, 0.878715, 1.02)
    ops.node(1988, 3.958667, 0.132755, -0.055363)
    ops.node(1989, 3.669077, 0.828515, 1.359)
    ops.node(1990, 3.708, 0.638571, 1.5)
    ops.node(1991, 3.708, 0.851429, 1.5)
    ops.node(1992, 3.828306, 0.725872, 1.332716)
    ops.node(1993, 0.756661, 0.562881, 0.852078)
    ops.node(1994, 0.616179, 0.62964, 0.715356)
    ops.node(1995, 0.647392, 0.766638, 0.874429)
    ops.node(1996, 0.535537, 0.536984, 0.824543)
    ops.node(1997, 1.197903, 0.109963, -0.111621)
    ops.node(1998, 1.297222, 0.170368, -0.017073)
    ops.node(1999, 0.484799, 0.325541, 0.60597)
    ops.node(2000, 0.599174, 0.388945, 0.297382)
    ops.node(2001, 3.202213, 0.665445, 1.313936)
    ops.node(2002, 3.449262, 0.780786, 1.27171)
    ops.node(2003, 3.300541, 0.724796, 1.056788)
    ops.node(2004, 3.430129, 0.573529, 1.325636)
    ops.node(2005, 3.670159, 0.241154, -0.2)
    ops.node(2006, 0.441145, 0.406165, 1.406941)
    ops.node(2007, 0.682473, 0.347012, 1.308578)
    ops.node(2008, 0.506923, 0.552179, 1.340183)
    ops.node(2009, 3.180237, 0.165868, 0.419921)
    ops.node(2010, 0.554164, 0.402464, 1.525147)
    ops.node(2011, 2.072466, 0.136699, -0.100972)
    ops.node(2012, 2.094527, 0.42568, 1.032637)
    ops.node(2013, 2.01912, 0.235677, 1.094831)
    ops.node(2014, 2.241326, 0.405512, 1.077705)
    ops.node(2015, 2.124003, 0.280377, 0.949832)
    ops.node(2016, 3.147522, 0.335587, 0.942339)
    ops.node(2017, 2.9, 0.456667, 0.9)
    ops.node(2018, 3.203364, 0.506248, 0.907412)
    ops.node(2019, 3.058458, 0.40177, 1.120632)
    ops.node(2020, 3.155144, 0.310927, 0.75)
    ops.node(2021, 2.260974, 0.142453, 0.095778)
    ops.node(2022, 2.514764, 0.29, 0.006471)
    ops.node(2023, 2.327952, 0.29, 0.002168)
    ops.node(2024, 2.375326, 0.171473, -0.085594)
    ops.node(2025, 1.15011, 0.574089, 0.294538)
    ops.node(2026, 0.953196, 0.614313, 0.269715)
    ops.node(2027, 1.002285, 0.812657, 0.355347)
    ops.node(2028, 0.391747, 1.0525, 0.8625)
    ops.node(2029, 0.375, 0.99, 0.8625)
    ops.node(2030, 0.525318, 0.95472, 0.884381)
    ops.node(2031, 4.256182, 1.220479, 0.224344)
    ops.node(2032, 4.2, 1.49, 0.0375)
    ops.node(2033, 4.4, 1.49, 0.225)
    ops.node(2034, 4.2, 1.49, 0.275)
    ops.node(2035, 4.240615, 1.49, 0.906086)
    ops.node(2036, 4.036, 1.49, 0.9)
    ops.node(2037, 4.095, 1.385, 0.75)
    ops.node(2038, 4.2, 1.49, 0.75)
    ops.node(2039, 0.531885, 0.906938, 0.159737)
    ops.node(2040, 0.5, 0.99, 0.25)
    ops.node(2041, 0.384634, 0.891957, 0.176882)
    ops.node(2042, 0.5, 0.99, 0.0)
    ops.node(2043, 1.213368, 0.798914, 0.330555)
    ops.node(2044, 4.004854, 0.999743, 0.040214)
    ops.node(2045, 2.9, 0.29, -0.01)
    ops.node(2046, 3.025255, 0.152648, 0.127574)
    ops.node(2047, 2.892236, 0.147178, -0.089725)
    ops.node(2048, 3.424191, 0.178767, 0.334723)
    ops.node(2049, 3.304062, 0.349429, 0.51498)
    ops.node(2050, 3.3997, 0.387133, 0.271544)
    ops.node(2051, 2.506039, 0.427181, 1.295347)
    ops.node(2052, 2.410045, 0.284863, 1.5)
    ops.node(2053, 2.437986, 0.555331, 1.5)
    ops.node(2054, 2.659171, 0.476621, 1.5)
    ops.node(2055, 4.302451, 1.240237, 0.608829)
    ops.node(2056, 4.4, 1.49, 0.65)
    ops.node(2057, 2.605423, 0.616934, 1.380324)
    ops.node(2058, 0.748093, 0.823209, 0.639642)
    ops.node(2059, 0.5385, 0.828698, 0.696608)
    ops.node(2060, 1.24989, 0.788923, 1.384016)
    ops.node(2061, 1.177688, 0.910863, 1.292844)
    ops.node(2062, 1.100732, 0.993333, 1.5)
    ops.node(2063, 0.998745, 0.84969, 1.365548)
    ops.node(2064, 0.115026, 0.122111, 1.307736)
    ops.node(2065, 2.483059, 0.141388, 0.69747)
    ops.node(2066, 2.55, 0.29, 0.75)
    ops.node(2067, 2.583025, 0.29, 0.543236)
    ops.node(2068, 1.669494, 0.186921, 0.261648)
    ops.node(2069, 1.677152, 0.399318, 0.18)
    ops.node(2070, 1.62937, 0.168122, 0.020259)
    ops.node(2071, 3.496878, 0.330317, 0.887138)
    ops.node(2072, 3.690047, 0.202882, 0.970709)
    ops.node(2073, 3.73388, 0.203694, 0.74461)
    ops.node(2074, 3.513331, 0.181592, 0.754643)
    ops.node(2075, 3.638771, 0.677233, 1.067831)
    ops.node(2076, 3.485359, 0.608088, 1.133315)
    ops.node(2077, 3.51202, 0.808148, 1.01488)
    ops.node(2078, 3.199429, 0.171091, 1.051538)
    ops.node(2079, 3.809146, 1.051021, 1.143685)
    ops.node(2080, 3.934111, 0.904772, 1.040263)
    ops.node(2081, 3.744608, 0.877469, 0.901108)
    ops.node(2082, 3.609288, 1.00208, 1.060878)
    ops.node(2083, 3.372703, 0.172848, 1.225641)
    ops.node(2084, 3.239933, 0.167696, 1.397119)
    ops.node(2085, 0.319561, 0.826735, 1.55911)
    ops.node(2086, 0.405422, 0.996694, 1.456022)
    ops.node(2087, 0.234021, 0.40573, 0.0)
    ops.node(2088, 0.442667, 0.463717, 0.197916)
    ops.node(2089, 0.411186, 0.586265, 0.0)
    ops.node(2090, 0.412877, 0.333076, 0.0)
    ops.node(2091, 0.8, 0.99, 0.37)
    ops.node(2092, 0.658905, 0.99, 0.179584)
    ops.node(2093, 1.327888, 0.983411, 1.264251)
    ops.node(2094, 1.321451, 0.803434, 1.186382)
    ops.node(2095, 1.418257, 0.771963, 1.31664)
    ops.node(2096, 0.798425, 1.154694, 1.187166)
    ops.node(2097, 0.611432, 0.968263, 1.159982)
    ops.node(2098, 0.262656, 0.240327, 0.799607)
    ops.node(2099, 0.024067, 0.242125, 0.633495)
    ops.node(2100, 0.376203, 0.74539, 1.071994)
    ops.node(2101, 0.298532, 0.827709, 0.931321)
    ops.node(2102, 0.451712, 0.742023, 0.814545)
    ops.node(2103, 0.501918, 0.880342, 1.041558)
    ops.node(2104, 1.933179, 0.188808, 0.457022)
    ops.node(2105, 2.721008, 0.29, 0.109604)
    ops.node(2106, 2.715678, 0.29, 0.33329)
    ops.node(2107, 1.099069, 0.413892, 0.316587)
    ops.node(2108, 0.432259, 0.762605, 0.113656)
    ops.node(2109, 0.250751, 0.745506, 0.235051)
    ops.node(2110, 0.352833, 0.870278, 0.407162)
    ops.node(2111, 0.508489, 0.649397, 0.20499)
    ops.node(2112, 0.685936, 0.908857, 0.851836)
    ops.node(2113, 0.870096, 0.824741, 0.865326)
    ops.node(2114, 4.166241, 0.485976, 0.026064)
    ops.node(2115, 2.022819, 0.305797, 0.313364)
    ops.node(2116, 0.335406, 0.628123, 0.870342)
    ops.node(2117, 3.6, 0.394857, 1.5)
    ops.node(2118, 3.708, 0.212857, 1.5)
    ops.node(2119, 3.6, 0.197429, 1.5)
    ops.node(2120, 0.81207, 0.207034, 0.408655)
    ops.node(2121, 0.529289, 0.861521, 1.534058)
    ops.node(2122, 0.58, 0.993333, 1.695)
    ops.node(2123, 0.78, 0.851429, 1.5)
    ops.node(2124, 0.58, 0.745, 1.695)
    ops.node(2125, 0.906972, 0.818455, 0.544121)
    ops.node(2126, 0.9545, 0.99, 0.625278)
    ops.node(2127, 0.9545, 0.99, 0.449422)
    ops.node(2128, 1.109, 0.99, 0.56)
    ops.node(2129, 3.61767, 0.492496, 0.987379)
    ops.node(2130, 3.62062, 0.514182, 0.75)
    ops.node(2131, 3.632513, 0.691358, 0.867859)
    ops.node(2132, 3.439664, 0.592256, 0.89813)
    ops.node(2133, 0.304821, 0.226228, 0.54125)
    ops.node(2134, 0.035084, 0.284644, 0.315303)
    ops.node(2135, 0.31094, 0.35718, 0.398197)
    ops.node(2136, 2.021427, 0.305921, -0.2)
    ops.node(2137, 2.2, 0.29, -0.2)
    ops.node(2138, 4.105929, 1.088407, 1.360395)
    ops.node(2139, 3.855547, 1.116729, 1.322988)
    ops.node(2140, 4.016821, 0.903052, 1.295121)
    ops.node(2141, 4.095, 1.187143, -0.2)
    ops.node(2142, 1.488656, 0.213437, 0.885299)
    ops.node(2143, 1.736608, 0.204693, 0.707116)
    ops.node(2144, 1.483353, 0.29674, 0.700466)
    ops.node(2145, 1.289339, 0.234158, 0.565229)
    ops.node(2146, 1.486192, 0.514563, 0.617625)
    ops.node(2147, 1.49907, 0.256078, 0.472317)
    ops.node(2148, 1.677152, 0.399318, 0.75)
    ops.node(2149, 1.847145, 0.342361, 0.75)
    ops.node(2150, 3.690422, 0.565092, 1.166847)
    ops.node(2151, 3.720851, 0.803005, 1.139212)
    ops.node(2152, 3.634451, 0.676926, 1.338925)
    ops.node(2153, 2.729814, 0.39274, 1.315277)
    ops.node(2154, 2.633943, 0.202714, 1.243886)
    ops.node(2155, 1.331598, 0.994256, 1.5)
    ops.node(2156, 1.445451, 1.352173, 1.5)
    ops.node(2157, 1.14782, 0.596447, 0.68043)
    ops.node(2158, 1.181845, 0.854313, 0.546153)
    ops.node(2159, 1.207957, 0.805675, 0.75)
    ops.node(2160, 1.006128, 0.82636, 0.70659)
    ops.node(2161, 4.2, 1.064286, -0.2)
    ops.node(2162, 4.4, 1.064286, -0.2)
    ops.node(2163, 4.4, 1.277143, -0.2)
    ops.node(2164, 0.148028, 0.107154, 0.098788)
    ops.node(2165, 0.021462, 0.228777, 0.0)
    ops.node(2166, 0.22966, 0.172576, 0.0)
    ops.node(2167, 0.254714, 0.291552, 0.164101)
    ops.node(2168, 1.077995, 0.660444, 0.479212)
    ops.node(2169, 3.957496, 0.413924, 1.266799)
    ops.node(2170, 4.116626, 0.270722, 1.283415)
    ops.node(2171, 4.158594, 0.245667, 1.013885)
    ops.node(2172, 3.885002, 0.207496, 1.153076)
    ops.node(2173, 1.184043, 0.726541, 0.907974)
    ops.node(2174, 0.386869, 1.032827, 1.260491)
    ops.node(2175, 0.324733, 1.226271, 1.244633)
    ops.node(2176, 0.231538, 1.106592, 1.246253)
    ops.node(2177, 2.55, 0.29, -0.2)
    ops.node(2178, 2.733904, 0.131167, -0.088132)
    ops.node(2179, 2.713168, 0.29, -0.06855)
    ops.node(2180, 2.725, 0.29, -0.2)
    ops.node(2181, 0.9545, 0.313234, -0.2)
    ops.node(2182, 0.9545, 0.129973, -0.2)
    ops.node(2183, 1.109, 0.198, -0.2)
    ops.node(2184, 0.959469, 1.148811, 1.283953)
    ops.node(2185, 1.049947, 1.322217, 1.313051)
    ops.node(2186, 1.178518, 1.078226, 1.300417)
    ops.node(2187, 4.4, 1.49, 1.5)
    ops.node(2188, 4.5, 1.39, 1.5)
    ops.node(2189, 4.4, 1.241667, 1.5)
    ops.node(2190, 2.315595, 0.153355, 0.516913)
    ops.node(2191, 2.385828, 0.29, 0.61849)
    ops.node(2192, 0.588629, 0.740729, 1.421041)
    ops.node(2193, 0.524347, 0.598838, 1.527223)
    ops.node(2194, 0.78, 0.638571, 1.5)
    ops.node(2195, 0.12247, 0.368753, 1.294275)
    ops.node(2196, 0.036456, 0.312762, 1.16719)
    ops.node(2197, 0.078783, 0.460777, 1.129095)
    ops.node(2198, 0.0, 0.424286, 1.2)
    ops.node(2199, 0.177889, 0.540707, 1.250775)
    ops.node(2200, 0.0, 0.452302, 1.46153)
    ops.node(2201, 0.0, 0.565714, 1.2)
    ops.node(2202, 0.78, 0.212857, 1.5)
    ops.node(2203, 0.78, 0.425714, 1.5)
    ops.node(2204, 0.904158, 0.295382, 1.29578)
    ops.node(2205, 1.555272, 0.95865, 1.5)
    ops.node(2206, 1.555272, 1.198312, 1.5)
    ops.node(2207, 1.624575, 1.07998, 1.35)
    ops.node(2208, 2.360314, 0.475538, 1.365785)
    ops.node(2209, 2.274094, 0.491102, 1.204243)
    ops.node(2210, 2.393896, 0.626482, 1.297831)
    ops.node(2211, 2.234121, 0.610688, 1.313379)
    ops.node(2212, 1.555272, 1.198312, 1.35)
    ops.node(2213, 4.000078, 1.088665, 1.041124)
    ops.node(2214, 4.136549, 0.947631, 0.884527)
    ops.node(2215, 0.204545, 0.222699, 1.214258)
    ops.node(2216, 0.016184, 0.15709, 1.185434)
    ops.node(2217, 0.0, 0.282857, 1.2)
    ops.node(2218, 0.0, 0.218121, 1.444249)
    ops.node(2219, 0.688759, 0.441826, 0.158511)
    ops.node(2220, 0.879911, 0.461646, 0.133364)
    ops.node(2221, 0.612651, 0.721415, 1.167525)
    ops.node(2222, 0.67389, 0.554375, 1.312874)
    ops.node(2223, 3.684653, 1.165098, 1.243675)
    ops.node(2224, 3.586217, 0.928695, 1.230665)
    ops.node(2225, 2.418312, 0.223555, 1.133442)
    ops.node(2226, 2.270015, 0.358288, 1.303971)
    ops.node(2227, 2.406975, 0.409815, 1.08345)
    ops.node(2228, 0.822318, 0.139922, -0.03342)
    ops.node(2229, 0.933996, 0.155901, 0.16747)
    ops.node(2230, 0.8515, 0.302411, -0.04249)
    ops.node(2231, 0.385007, 1.237246, 1.434234)
    ops.node(2232, 0.171032, 1.362418, 1.440117)
    ops.node(2233, 0.311477, 1.244772, 1.544267)
    ops.node(2234, 2.657414, 0.194111, 1.5)
    ops.node(2235, 0.964597, 0.075564, -0.090147)
    ops.node(2236, 4.265442, 0.311021, 0.29075)
    ops.node(2237, 4.188033, 0.395246, 0.555559)
    ops.node(2238, 4.5, 0.389159, 0.717315)
    ops.node(2239, 0.983136, 0.629044, 1.37925)
    ops.node(2240, 1.034918, 0.641887, 1.081653)
    ops.node(2241, 0.878456, 0.739766, 1.270837)
    ops.node(2242, 0.895213, 0.515594, 1.265789)
    ops.node(2243, 2.977648, 0.614901, 1.287275)
    ops.node(2244, 3.075355, 0.646371, 1.056634)
    ops.node(2245, 3.234187, 0.507506, 1.153288)
    ops.node(2246, 2.2, 0.456667, 0.9)
    ops.node(2247, 2.008675, 0.415261, 0.843055)
    ops.node(2248, 2.865708, 0.436874, 1.129308)
    ops.node(2249, 2.777354, 0.616358, 1.043723)
    ops.node(2250, 0.020588, 0.203745, 0.908294)
    ops.node(2251, 0.138407, 0.203174, 1.077407)
    ops.node(2252, 2.9, 0.79, 1.2)
    ops.node(2253, 2.710117, 0.79, 1.35)
    ops.node(2254, 2.725, 0.79, 1.2)
    ops.node(2255, 0.34925, 0.228782, 0.994852)
    ops.node(2256, 3.196025, 0.153953, 0.679761)
    ops.node(2257, 3.093003, 0.301111, 0.505155)
    ops.node(2258, 3.034608, 0.153513, 0.584222)
    ops.node(2259, 3.625241, 0.081953, 1.433006)
    ops.node(2260, 1.237009, 0.435802, 0.062606)
    ops.node(2261, 1.257847, 0.453399, 0.245401)
    ops.node(2262, 0.0, 0.848571, 1.2)
    ops.node(2263, 1.749446, 0.331795, 0.910961)
    ops.node(2264, 1.899282, 0.403272, 0.999788)
    ops.node(2265, 4.4, 0.851429, -0.2)
    ops.node(2266, 2.650625, 0.150054, 0.802994)
    ops.node(2267, 2.2, 0.29, 0.75)
    ops.node(2268, 2.2, 0.29, 0.56)
    ops.node(2269, 3.820363, 0.936533, 1.383632)
    ops.node(2270, 3.708, 1.064286, 1.5)
    ops.node(2271, 3.675051, 0.981891, 1.347543)
    ops.node(2272, 0.535237, 1.106965, 1.270434)
    ops.node(2273, 0.711034, 1.325162, 1.250404)
    ops.node(2274, 2.800699, 0.606527, 1.385411)
    ops.node(2275, 2.9, 0.29, 0.37)
    ops.node(2276, 1.217849, 1.331624, 1.101565)
    ops.node(2277, 1.260885, 1.29076, 1.251116)
    ops.node(2278, 0.0, 0.2475, 1.695)
    ops.node(2279, 3.236276, 0.873477, 1.34578)
    ops.node(2280, 3.335746, 0.677472, 1.5)
    ops.node(2281, 3.096837, 0.818574, 1.5)
    ops.node(2282, 3.278736, 0.898054, 1.5)
    ops.node(2283, 0.528098, 0.492696, 0.569917)
    ops.node(2284, 0.492247, 0.340546, 0.812059)
    ops.node(2285, 0.767186, 0.708531, 0.756489)
    ops.node(2286, 0.240769, 1.048296, 1.110627)
    ops.node(2287, 0.125, 0.99, 1.0875)
    ops.node(2288, 0.25, 0.99, 0.975)
    ops.node(2289, 0.175241, 1.1775, 1.0875)
    ops.node(2290, 2.2, 0.526667, 1.5)
    ops.node(2291, 2.001553, 0.819605, 1.5)
    ops.node(2292, 2.055873, 0.661418, 1.31614)
    ops.node(2293, 2.2, 0.79, 1.5)
    ops.node(2294, 0.739203, 1.10557, 1.336592)
    ops.node(2295, 4.4, 0.425714, -0.2)
    ops.node(2296, 3.57292, 1.068827, 1.389171)
    ops.node(2297, 4.2, 1.49, 0.5125)
    ops.node(2298, 3.409294, 0.197427, 0.556675)
    ops.node(2299, 2.215288, 0.151517, -0.053698)
    ops.node(2300, 1.454646, 0.625166, 1.31863)
    ops.node(2301, 1.656228, 0.618163, 1.302912)
    ops.node(2302, 1.555272, 0.479325, 1.5)
    ops.node(2303, 1.555272, 0.718987, 1.5)
    ops.node(2304, 1.47718, 0.22872, -0.2)
    ops.node(2305, 1.677152, 0.199659, -0.2)
    ops.node(2306, 0.444951, 0.382388, 1.043968)
    ops.node(2307, 0.659937, 0.49732, 0.972611)
    ops.node(2308, 3.075989, 0.183611, 1.247441)
    ops.node(2309, 0.533577, 0.629547, 0.977396)
    ops.node(2310, 0.972181, 0.593827, 0.103321)
    ops.node(2311, 0.844613, 0.729924, -0.015872)
    ops.node(2312, 1.0575, 0.719905, -0.060851)
    ops.node(2313, 0.394847, 0.91832, 0.844638)
    ops.node(2314, 0.5, 0.99, 0.75)
    ops.node(2315, 3.605154, 0.360672, 0.657024)
    ops.node(2316, 3.399211, 0.386898, 0.75)
    ops.node(2317, 3.510398, 0.919672, 1.394688)
    ops.node(2318, 3.6, 0.789714, 1.5)
    ops.node(2319, 1.677152, 0.399318, 0.37)
    ops.node(2320, 1.845967, 0.342755, 0.230427)
    ops.node(2321, 2.844371, 0.229425, 1.246823)
    ops.node(2322, 1.323365, 1.08601, 1.180895)
    ops.node(2323, 3.765, 1.383, 1.05)
    ops.node(2324, 3.681074, 1.204757, 1.086569)
    ops.node(2325, 0.935061, 0.661412, 0.903637)
    ops.node(2326, 3.430568, 1.02646, 1.5)
    ops.node(2327, 3.6, 0.987143, 1.5)
    ops.node(2328, 0.611816, 0.835562, 0.122112)
    ops.node(2329, 0.8, 0.99, -0.01)
    ops.node(2330, 0.6, 0.792, 0.0)
    ops.node(2331, 0.77699, 0.787681, 0.112988)
    ops.node(2332, 3.205767, 0.414539, 1.308562)
    ops.node(2333, 0.252421, 0.457415, 1.449922)
    ops.node(2334, 0.194664, 0.700819, 1.467193)
    ops.node(2335, 0.212213, 0.463179, 0.728067)
    ops.node(2336, 0.072287, 0.430391, 0.870226)
    ops.node(2337, 4.174892, 0.907927, 1.5)
    ops.node(2338, 4.28102, 0.81754, 1.233975)
    ops.node(2339, 4.279167, 1.068086, 1.369628)
    ops.node(2340, 4.35827, 1.085739, 1.212882)
    ops.node(2341, 3.412503, 1.008183, 1.346824)
    ops.node(2342, 3.81, 1.49, 1.32)
    ops.node(2343, 3.908927, 1.267842, 1.5)
    ops.node(2344, 3.767812, 1.328328, 1.385107)
    ops.node(2345, 1.421328, 0.787337, 1.023562)
    ops.node(2346, 1.366285, 0.835755, 0.872646)
    ops.node(2347, 1.894365, 0.360907, 1.405032)
    ops.node(2348, 1.713962, 0.182773, 1.365018)
    ops.node(2349, 1.799881, 0.213468, 1.139908)
    ops.node(2350, 1.624533, 0.373149, 1.313516)
    ops.node(2351, 0.401274, 0.593308, 0.37587)
    ops.node(2352, 1.528571, 0.2977, -0.064364)
    ops.node(2353, 1.677152, 0.399318, -0.2)
    ops.node(2354, 1.544145, 0.477532, 0.000799)
    ops.node(2355, 1.496813, 0.505365, -0.2)
    ops.node(2356, 0.706479, 0.849513, 1.277269)
    ops.node(2357, 4.5, 0.885096, 0.821332)
    ops.node(2358, 4.5, 0.616801, 0.307776)
    ops.node(2359, 3.018021, 0.181371, 0.815829)
    ops.node(2360, 3.6, 0.592286, 1.5)
    ops.node(2361, 3.35464, 0.450829, 1.5)
    ops.node(2362, 3.634738, 0.475366, 1.342381)
    ops.node(2363, 0.903665, 0.6244, -0.110719)
    ops.node(2364, 0.8515, 0.504166, -0.038792)
    ops.node(2365, 2.37702, 0.29, 0.439912)
    ops.node(2366, 0.066988, 1.24, 1.2)
    ops.node(2367, 0.283494, 1.115, 0.975)
    ops.node(2368, 3.825138, 0.16983, 1.371938)
    ops.node(2369, 3.783184, 0.3651, 1.370956)
    ops.node(2370, 0.58, 0.248333, 1.695)
    ops.node(2371, 0.58, 0.496667, 1.695)
    ops.node(2372, 0.328615, 0.836941, 0.0)
    ops.node(2373, 0.279693, 0.566714, 0.127883)
    ops.node(2374, 0.188687, 0.654679, 0.0)
    ops.node(2375, 0.359637, 0.627766, 0.692223)
    ops.node(2376, 0.316725, 0.83914, 0.659681)
    ops.node(2377, 1.804771, 0.796631, 1.360811)
    ops.node(2378, 1.764277, 0.939621, 1.35)
    ops.node(2379, 3.813372, 0.889164, 1.243294)
    ops.node(2380, 1.857186, 0.149541, -0.077989)
    ops.node(2381, 3.899213, 0.447245, 0.699777)
    ops.node(2382, 3.808856, 0.686666, 0.75)
    ops.node(2383, 3.745441, 0.615988, 0.508765)
    ops.node(2384, 2.2, 0.263333, 1.5)
    ops.node(2385, 3.100265, 0.5331, 1.5)
    ops.node(2386, 4.054, 1.49, 1.5)
    ops.node(2387, 4.177049, 1.214384, 1.5)
    ops.node(2388, 1.238743, 0.634239, 1.061316)
    ops.node(2389, 1.122, 0.803141, 1.132631)
    ops.node(2390, 1.247545, 0.909237, 1.052416)
    ops.node(2391, 1.357973, 0.373675, -0.027565)
    ops.node(2392, 1.36884, 0.616199, 0.003455)
    ops.node(2393, 1.362472, 1.215356, 1.085487)
    ops.node(2394, 1.305312, 0.425847, -0.2)
    ops.node(2395, 2.970898, 0.229959, 1.011193)
    ops.node(2396, 4.346552, 0.32203, 0.039588)
    ops.node(2397, 4.5, 0.463333, -0.2)
    ops.node(2398, 3.721613, 0.590007, 0.034493)
    ops.node(2399, 3.856837, 0.454308, -0.2)
    ops.node(2400, 0.6, 0.198, 0.0)
    ops.node(2401, 0.441387, 0.146923, 0.0)
    ops.node(2402, 1.230126, 0.220035, 0.822574)
    ops.node(2403, 3.044519, 0.682784, 1.412493)
    ops.node(2404, 1.650759, 0.20324, 0.948168)
    ops.node(2405, 1.113221, 0.242411, 1.153317)
    ops.node(2406, 0.988471, 0.456731, 0.985984)
    ops.node(2407, 1.262551, 0.386087, 0.974426)
    ops.node(2408, 1.471807, 0.27581, 0.140471)
    ops.node(2409, 1.374867, 0.348546, 0.348803)
    ops.node(2410, 1.46184, 0.139039, 1.366192)
    ops.node(2411, 1.432389, 0.397038, 1.337319)
    ops.node(2412, 1.56123, 0.198615, 1.195014)
    ops.node(2413, 4.011824, 0.794928, 1.128737)
    ops.node(2414, 0.58, 1.49, 1.4475)
    ops.node(2415, 0.78, 1.49, 1.35)
    ops.node(2416, 0.78, 1.277143, 1.5)
    ops.node(2417, 1.109, 0.99, 0.37)
    ops.node(2418, 1.109, 0.99, 0.18)
    ops.node(2419, 3.355156, 0.182999, 0.727394)
    ops.node(2420, 3.735948, 0.368687, 1.154619)
    ops.node(2421, 1.493273, 0.508431, 0.438038)
    ops.node(2422, 1.269591, 0.4595, 0.491252)
    ops.node(2423, 0.5, 1.115, 0.8625)
    ops.node(2424, 1.209527, 0.803714, 0.106593)
    ops.node(2425, 1.321129, 0.664249, 0.190831)
    ops.node(2426, 3.515065, 0.681622, 1.412818)
    ops.node(2427, 1.103488, 1.323333, 1.05)
    ops.node(2428, 0.945753, 1.323855, 1.05047)
    ops.node(2429, 0.607422, 0.970949, 1.425543)
    ops.node(2430, 0.532339, 1.116149, 1.551812)
    ops.node(2431, 3.045087, 0.805042, 1.345346)
    ops.node(2432, 3.145124, 0.831202, 1.2)
    ops.node(2433, 0.8, 0.99, 0.75)
    ops.node(2434, 0.9545, 0.99, 0.75)
    ops.node(2435, 0.352316, 0.470217, 0.629381)
    ops.node(2436, 0.090984, 0.47696, 0.568932)
    ops.node(2437, 0.8, 0.198, -0.2)
    ops.node(2438, 4.140218, 0.423172, 0.838515)
    ops.node(2439, 4.5, 1.39, -0.2)
    ops.node(2440, 0.882556, 0.635977, 0.451767)
    ops.node(2441, 0.8, 0.99, 0.56)
    ops.node(2442, 2.761889, 0.160447, 0.422534)
    ops.node(2443, 2.586884, 0.144389, 0.419603)
    ops.node(2444, 1.985068, 0.824279, 1.35)
    ops.node(2445, 1.296692, 1.448946, 1.35)
    ops.node(2446, 1.477513, 0.935756, 0.984064)
    ops.node(2447, 2.375, 0.79, 1.5)
    ops.node(2448, 1.357962, 1.031315, 0.979212)
    ops.node(2449, 4.077743, 0.402271, 0.209921)
    ops.node(2450, 1.918244, 0.209774, 1.5)
    ops.node(2451, 1.555272, 0.239662, 1.5)
    ops.node(2452, 3.94744, 0.766971, 1.5)
    ops.node(2453, 3.944588, 0.524877, 1.5)
    ops.node(2454, 1.747651, 0.269434, -0.102771)
    ops.node(2455, 1.677152, 0.399318, -0.01)
    ops.node(2456, 0.58, 0.99, 0.75)
    ops.node(2457, 2.853925, 0.15718, 0.665479)
    ops.node(2458, 2.770428, 0.29, 0.547078)
    ops.node(2459, 2.725, 0.29, 0.75)
    ops.node(2460, 2.499208, 0.461482, 0.904333)
    ops.node(2461, 0.085098, 0.449572, 0.0)
    ops.node(2462, 1.959776, 0.156703, 1.30092)
    ops.node(2463, 1.414543, 0.110649, -0.099089)
    ops.node(2464, 0.457853, 0.666349, 0.52981)
    ops.node(2465, 0.219631, 0.356711, 1.056796)
    ops.node(2466, 1.100732, 0.745, 1.5)
    ops.node(2467, 0.59949, 0.205534, 1.471901)
    ops.node(2468, 0.888556, 1.316443, 1.253903)
    ops.node(2469, 1.175058, 1.011569, 0.985098)
    ops.node(2470, 1.216846, 0.940375, 0.843059)
    ops.node(2471, 1.106244, 1.156667, 0.9)
    ops.node(2472, 4.095, 0.593571, -0.2)
    ops.node(2473, 2.9, 0.29, -0.2)
    ops.node(2474, 0.5, 0.496667, 1.695)
    ops.node(2475, 2.798269, 0.14761, 0.16234)
    ops.node(2476, 1.100732, 1.49, 1.2)
    ops.node(2477, 0.6, 0.99, 0.0)
    ops.node(2478, 4.5, 0.926667, 1.5)
    ops.node(2479, 4.5, 0.444042, 1.161997)
    ops.node(2480, 2.890958, 0.614134, 1.175365)
    ops.node(2481, 2.9, 0.623333, 1.05)
    ops.node(2482, 0.73774, 0.635068, 0.207887)
    ops.node(2483, 0.338133, 0.409456, 1.251078)
    ops.node(2484, 0.312407, 0.527363, 1.107441)
    ops.node(2485, 0.413563, 0.652311, 1.234116)
    ops.node(2486, 4.167071, 1.49, 1.155431)
    ops.node(2487, 4.4, 1.49, 1.075)
    ops.node(2488, 1.264119, 0.519344, 1.386676)
    ops.node(2489, 1.224586, 0.55404, -0.100205)
    ops.node(2490, 1.216079, 0.795526, -0.070189)
    ops.node(2491, 1.153579, 0.573907, 0.094034)
    ops.node(2492, 1.100732, 0.496667, 1.5)
    ops.node(2493, 0.866205, 0.768812, 1.096537)
    ops.node(2494, 0.786185, 0.607328, 1.101743)
    ops.node(2495, 4.397518, 0.318653, 1.347394)
    ops.node(2496, 1.474591, 0.368566, 1.072367)
    ops.node(2497, 1.357769, 0.206137, 1.190784)
    ops.node(2498, 1.547552, 0.531977, 1.157408)
    ops.node(2499, 2.9, 0.79, 1.5)
    ops.node(2500, 2.9, 0.79, 1.35)
    ops.node(2501, 4.095508, 0.506742, 1.397753)
    ops.node(2502, 4.022076, 0.645324, 1.312287)
    ops.node(2503, 2.041391, 0.304141, 0.53838)
    ops.node(2504, 2.9, 0.29, 0.18)
    ops.node(2505, 2.08843, 0.145203, 0.475499)
    ops.node(2506, 1.327523, 0.65862, 1.5)
    ops.node(2507, 1.763056, 0.400458, 1.5)
    ops.node(2508, 4.174201, 0.644122, 1.5)
    ops.node(2509, 1.854263, 0.508827, 1.318119)
    ops.node(2510, 1.785627, 0.638869, 1.5)
    ops.node(2511, 1.707126, 0.487793, 1.215522)
    ops.node(2512, 1.862746, 0.437736, 1.167796)
    ops.node(2513, 1.664402, 0.358714, 1.093307)
    ops.node(2514, 0.512451, 0.86518, 1.305158)
    ops.node(2515, 3.355013, 0.552122, 1.035403)
    ops.node(2516, 0.975495, 0.871892, 1.104086)
    ops.node(2517, 4.424944, 0.61287, 1.345327)
    ops.node(2518, 4.5, 0.463333, 1.5)
    ops.node(2519, 3.795064, 1.311895, 1.219246)
    ops.node(2520, 0.497424, 0.26005, 0.147678)
    ops.node(2521, 4.095, 0.395714, -0.2)
    ops.node(2522, 0.373387, 0.387851, 1.574012)
    ops.node(2523, 0.5, 0.248333, 1.695)
    ops.node(2524, 4.109343, 0.86303, -0.01512)
    ops.node(2525, 3.807884, 0.532721, 1.304051)
    ops.node(2526, 0.718179, 0.803564, 1.019952)
    ops.node(2527, 0.651111, 0.999338, 0.963081)
    ops.node(2528, 1.32248, 0.220208, 1.014267)
    ops.node(2529, 1.302388, 0.455859, 1.156127)
    ops.node(2530, 1.313023, 0.674379, 0.541291)
    ops.node(2531, 3.827595, 0.661366, 0.974862)
    ops.node(2532, 3.954955, 0.896136, 0.75)
    ops.node(2533, 2.966755, 0.441033, 1.305895)
    ops.node(2534, 2.375, 0.79, 1.2)
    ops.node(2535, 2.319162, 0.79, 1.35)
    ops.node(2536, 0.789173, 0.945998, 1.154591)
    ops.node(2537, 0.437116, 0.16271, 0.729589)
    ops.node(2538, 1.176006, 0.524048, 0.891841)
    ops.node(2539, 0.316565, 0.472741, 0.902571)
    ops.node(2540, 0.176023, 0.656108, 0.787226)
    ops.node(2541, 0.139037, 0.596871, 1.074867)
    ops.node(2542, 1.24052, 0.276546, 1.313372)
    ops.node(2543, 1.291637, 0.182155, 1.5)
    ops.node(2544, 1.175373, 0.667458, 1.282556)
    ops.node(2545, 3.6, 1.382, 1.2)
    ops.node(2546, 0.6, 0.396, 0.0)
    ops.node(2547, 3.708, 1.49, 1.2)
    ops.node(2548, 3.708, 1.49, 1.35)
    ops.node(2549, 3.518674, 1.147118, 1.2)
    ops.node(2550, 0.940366, 1.49, 1.5)
    ops.node(2551, 0.940366, 1.49, 1.35)
    ops.node(2552, 0.78, 1.49, 1.5)
    ops.node(2553, 3.872, 1.49, 1.05)
    ops.node(2554, 3.518356, 0.208, -0.091813)
    ops.node(2555, 0.406277, 0.737226, 1.426703)
    ops.node(2556, 2.215051, 0.179035, 1.122737)
    ops.node(2557, 3.155144, 0.310927, -0.2)
    ops.node(2558, 1.100732, 0.248333, 1.5)
    ops.node(2559, 4.171766, 0.39737, 1.5)
    ops.node(2560, 4.208146, 0.525709, 1.182561)
    ops.node(2561, 4.4, 0.745, 1.5)
    ops.node(2562, 0.687116, 0.208517, 0.618396)
    ops.node(2563, 2.776758, 0.224882, 0.922646)
    ops.node(2564, 0.0, 0.99, 1.695)
    ops.node(2565, 0.587566, 1.183686, 1.415916)
    ops.node(2566, 0.410424, 1.321209, 1.191067)
    ops.node(2567, 0.5, 1.365, 1.0875)
    ops.node(2568, 0.750949, 0.20436, 0.087458)
    ops.node(2569, 0.58, 1.49, 1.695)
    ops.node(2570, 4.5, 1.39, 1.075)
    ops.node(2571, 4.2, 0.425714, -0.2)
    ops.node(2572, 4.252855, 0.240859, 1.406842)
    ops.node(2573, 4.166403, 0.167607, 1.5)
    ops.node(2574, 2.2, 0.79, 1.2)
    ops.node(2575, 1.445451, 1.352173, 1.2)
    ops.node(2576, 2.2, 0.79, 1.35)
    ops.node(2577, 3.878288, 0.644492, 1.155508)
    ops.node(2578, 3.898458, 0.443275, 1.031363)
    ops.node(2579, 1.564032, 0.411609, 0.903361)
    ops.node(2580, 0.78, 1.49, 1.2)
    ops.node(2581, 0.58, 1.49, 1.2)
    ops.node(2582, 1.25578, 0.210402, -0.2)
    ops.node(2583, 1.920495, 0.657198, 1.386003)
    ops.node(2584, 1.8171, 0.89857, 1.5)
    ops.node(2585, 3.399211, 0.386898, -0.2)
    ops.node(2586, 2.375, 0.29, -0.2)
    ops.node(2587, 3.708, 1.49, 1.5)
    ops.node(2588, 0.593148, 0.609888, 0.378362)
    ops.node(2589, 0.212748, 0.719905, 1.008527)
    ops.node(2590, 4.336999, 0.614262, 1.407415)
    ops.node(2591, 4.4, 0.496667, 1.5)
    ops.node(2592, 2.063507, 0.350143, 1.290758)
    ops.node(2593, 1.100732, 1.49, 1.35)
    ops.node(2594, 2.270015, 0.182732, 1.300184)
    ops.node(2595, 2.903694, 0.132173, 0.472409)
    ops.node(2596, 4.061419, 0.694321, 0.928619)
    ops.node(2597, 3.978191, 1.346871, 1.237963)
    ops.node(2598, 0.530743, 0.115353, 1.584093)
    ops.node(2599, 1.860454, 0.151322, -0.2)
    ops.node(2600, 1.488795, 0.512309, 0.213414)
    ops.node(2601, 0.5, 1.49, 1.2)
    ops.node(2602, 3.894734, 0.226072, 0.903595)
    ops.node(2603, 4.095, 1.385, 0.275)
    ops.node(2604, 1.986444, 0.482627, 1.5)
    ops.node(2605, 1.711692, 0.511111, 1.405754)
    ops.node(2606, 0.0, 0.7425, 1.695)
    ops.node(2607, 4.095, 0.197857, -0.2)
    ops.node(2608, 2.9, 0.29, 0.56)
    ops.node(2609, 3.581255, 1.196728, 1.432741)
    ops.node(2610, 3.6, 1.184571, 1.5)
    ops.node(2611, 0.58, 1.241667, 1.695)
    ops.node(2612, 0.78, 1.064286, 1.5)
    ops.node(2613, 0.9545, 0.773716, -0.2)
    ops.node(2614, 3.671986, 0.139617, 1.349023)
    ops.node(2615, 1.004216, 0.87917, -0.084362)
    ops.node(2616, 0.874108, 0.215146, 0.637141)
    ops.node(2617, 2.706608, 0.184816, 1.074588)
    ops.node(2618, 0.5, 1.49, 1.695)
    ops.node(2619, 0.262464, 0.258428, 1.373741)
    ops.node(2620, 0.310296, 1.447988, 1.695)
    ops.node(2621, 0.886911, 0.969683, 1.293664)
    ops.node(2622, 2.2, 0.29, 0.37)
    ops.node(2623, 3.62062, 0.514182, -0.2)
    ops.node(2624, 3.949714, 1.018059, 1.5)
    ops.node(2625, 2.49189, 0.79, 1.35)
    ops.node(2626, 2.9, 0.526667, 1.5)
    ops.node(2627, 2.548502, 0.164774, -0.099328)
    ops.node(2628, 1.109, 0.99, -0.2)
    ops.node(2629, 1.109, 0.792, -0.2)
    ops.node(2630, 0.275242, 0.628998, 1.322678)
    ops.node(2631, 3.748368, 0.415664, 0.868954)
    ops.node(2632, 1.357591, 0.625942, 0.348987)
    ops.node(2633, 0.9545, 0.99, 0.007545)
    ops.node(2634, 0.301846, 0.851078, 1.333221)
    ops.node(2635, 3.150203, 0.30965, 0.29668)
    ops.node(2636, 2.001553, 0.819605, 1.2)
    ops.node(2637, 0.146447, 1.343553, 1.695)
    ops.node(2638, 2.9, 0.29, 0.75)
    ops.node(2639, 0.0, 0.495, 1.695)
    ops.node(2640, 1.036341, 0.979579, 0.981768)
    ops.node(2641, 1.084126, 0.878626, 0.899408)
    ops.node(2642, 0.6, 0.594, 0.0)
    ops.node(2643, 0.0, 0.141429, 1.2)
    ops.node(2644, 4.4, 1.49, -0.2)
    ops.node(2645, 4.095, 1.385, 0.5125)
    ops.node(2646, 4.5, 1.39, 0.65)
    ops.node(2647, 4.4, 0.993333, 1.5)
    ops.node(2648, 0.8, 0.99, -0.2)
    ops.node(2649, 0.9545, 0.99, -0.2)
    ops.node(2650, 4.051912, 1.132652, -0.2)
    ops.node(2651, 4.095, 0.989286, -0.2)
    ops.node(2652, 3.63151, 0.522358, 0.271477)
    ops.node(2653, 3.940558, 0.27952, 1.5)
    ops.node(2654, 1.33867, 0.642328, -0.2)
    ops.node(2655, 0.434434, 0.829743, 1.167452)
    ops.node(2656, 3.708, 0.425714, 1.5)
    ops.node(2657, 1.827862, 0.348821, 0.007854)
    ops.node(2658, 1.666866, 1.031565, 1.5)
    ops.node(2659, 1.286358, 1.454266, 1.2)
    ops.node(2660, 0.127908, 0.544146, 0.275501)
    ops.node(2661, 0.5, 1.241667, 1.695)
    ops.node(2662, 4.021174, 0.137038, 1.402015)
    ops.node(2663, 4.2, 0.851429, -0.2)
    ops.node(2664, 2.725, 0.79, 1.5)
    ops.node(2665, 0.25, 1.423013, 1.2)
    ops.node(2666, 0.8, 0.594, -0.2)
    ops.node(2667, 4.4, 0.248333, 1.5)
    ops.node(2668, 4.046396, 1.117073, 0.574233)
    ops.node(2669, 2.2, 0.29, 0.18)
    ops.node(2670, 2.55, 0.79, 1.5)
    ops.node(2671, 0.8, 0.396, -0.2)
    ops.node(2672, 1.207957, 0.805675, -0.2)
    ops.node(2673, 1.109, 0.99, -0.01)
    ops.node(2674, 0.8, 0.792, -0.2)
    ops.node(2675, 3.360397, 0.955464, 1.2)
    ops.node(2676, 1.326003, 0.395985, 1.5)
    ops.node(2677, 1.109, 0.99, 0.75)
    ops.node(2678, 1.847145, 0.342361, -0.2)
    ops.node(2679, 2.526239, 0.29, 0.353389)
    ops.node(2680, 1.513603, 0.711785, 0.872963)
    ops.node(2681, 0.205228, 0.692626, 0.500958)
    ops.node(2682, 1.093752, 0.453764, 1.19631)
    ops.node(2683, 4.4, 0.212857, -0.2)
    ops.node(2684, 0.0, 0.99, 1.2)
    ops.node(2685, 3.539143, 1.192639, 1.5)
    ops.node(2686, 0.940366, 1.49, 1.2)
    ops.node(2687, 0.042013, 1.179705, 1.695)

    # Solid element.
    ops.model('basic', '-ndm', 3, '-ndf', 3)

    ops.nDMaterial('ElasticIsotropic', 1, MatProps[1].E, MatProps[1].v)
    ops.element('FourNodeTetrahedron', 2609, *[1462, 371, 357, 358], 1)
    ops.element('FourNodeTetrahedron', 2610, *[1206, 1242, 1466, 1127], 1)
    ops.element('FourNodeTetrahedron', 2611, *[1676, 1297, 1436, 645], 1)
    ops.element('FourNodeTetrahedron', 2612, *[233, 1374, 229, 1371], 1)
    ops.element('FourNodeTetrahedron', 2613, *[1241, 1166, 1308, 1250], 1)
    ops.element('FourNodeTetrahedron', 2614, *[1415, 745, 1579, 1485], 1)
    ops.element('FourNodeTetrahedron', 2615, *[292, 1334, 291, 1367], 1)
    ops.element('FourNodeTetrahedron', 2616, *[329, 1714, 326, 1403], 1)
    ops.element('FourNodeTetrahedron', 2617, *[721, 725, 720, 1330], 1)
    ops.element('FourNodeTetrahedron', 2618, *[1372, 344, 345, 1669], 1)
    ops.element('FourNodeTetrahedron', 2619, *[1287, 1169, 1437, 1134], 1)
    ops.element('FourNodeTetrahedron', 2620, *[292, 267, 266, 1334], 1)
    ops.element('FourNodeTetrahedron', 2621, *[1159, 1239, 1287, 1134], 1)
    ops.element('FourNodeTetrahedron', 2622, *[1517, 395, 394, 402], 1)
    ops.element('FourNodeTetrahedron', 2623, *[1742, 183, 186, 1279], 1)
    ops.element('FourNodeTetrahedron', 2624, *[1529, 470, 469, 660], 1)
    ops.element('FourNodeTetrahedron', 2625, *[1571, 1394, 297, 1564], 1)
    ops.element('FourNodeTetrahedron', 2626, *[1391, 215, 247, 1359], 1)
    ops.element('FourNodeTetrahedron', 2627, *[261, 1537, 1744, 1328], 1)
    ops.element('FourNodeTetrahedron', 2628, *[751, 752, 1668, 1162], 1)
    ops.element('FourNodeTetrahedron', 2629, *[1439, 1228, 1599, 1406], 1)
    ops.element('FourNodeTetrahedron', 2630, *[765, 379, 411, 1527], 1)
    ops.element('FourNodeTetrahedron', 2631, *[1527, 379, 411, 386], 1)
    ops.element('FourNodeTetrahedron', 2632, *[765, 1664, 379, 1527], 1)
    ops.element('FourNodeTetrahedron', 2633, *[1458, 1417, 312, 1726], 1)
    ops.element('FourNodeTetrahedron', 2634, *[180, 1269, 183, 1532], 1)
    ops.element('FourNodeTetrahedron', 2635, *[318, 1404, 289, 319], 1)
    ops.element('FourNodeTetrahedron', 2636, *[1350, 1387, 216, 1356], 1)
    ops.element('FourNodeTetrahedron', 2637, *[1325, 1330, 721, 1710], 1)
    ops.element('FourNodeTetrahedron', 2638, *[1325, 1311, 1710, 1570], 1)
    ops.element('FourNodeTetrahedron', 2639, *[528, 1745, 522, 529], 1)
    ops.element('FourNodeTetrahedron', 2640, *[1470, 1500, 396, 1516], 1)
    ops.element('FourNodeTetrahedron', 2641, *[1350, 1356, 216, 218], 1)
    ops.element('FourNodeTetrahedron', 2642, *[216, 1356, 173, 218], 1)
    ops.element('FourNodeTetrahedron', 2643, *[648, 1675, 629, 653], 1)
    ops.element('FourNodeTetrahedron', 2644, *[660, 470, 469, 474], 1)
    ops.element('FourNodeTetrahedron', 2645, *[1342, 1456, 1604, 1644], 1)
    ops.element('FourNodeTetrahedron', 2646, *[1711, 1383, 1290, 1535], 1)
    ops.element('FourNodeTetrahedron', 2647, *[1615, 1215, 1522, 1648], 1)
    ops.element('FourNodeTetrahedron', 2648, *[1280, 141, 154, 1331], 1)
    ops.element('FourNodeTetrahedron', 2649, *[1452, 1213, 1153, 1129], 1)
    ops.element('FourNodeTetrahedron', 2650, *[1411, 1390, 1483, 1568], 1)
    ops.element('FourNodeTetrahedron', 2651, *[1563, 601, 445, 450], 1)
    ops.element('FourNodeTetrahedron', 2652, *[1407, 184, 224, 1273], 1)
    ops.element('FourNodeTetrahedron', 2653, *[1386, 1354, 392, 1414], 1)
    ops.element('FourNodeTetrahedron', 2654, *[1181, 1152, 1593, 634], 1)
    ops.element('FourNodeTetrahedron', 2655, *[1385, 1664, 1527, 387], 1)
    ops.element('FourNodeTetrahedron', 2656, *[301, 295, 294, 1408], 1)
    ops.element('FourNodeTetrahedron', 2657, *[1386, 1139, 1354, 1414], 1)
    ops.element('FourNodeTetrahedron', 2658, *[1326, 1280, 154, 1331], 1)
    ops.element('FourNodeTetrahedron', 2659, *[1519, 1140, 1427, 1172], 1)
    ops.element('FourNodeTetrahedron', 2660, *[1159, 1686, 760, 1287], 1)
    ops.element('FourNodeTetrahedron', 2661, *[255, 1683, 259, 1383], 1)
    ops.element('FourNodeTetrahedron', 2662, *[1258, 1129, 1452, 1509], 1)
    ops.element('FourNodeTetrahedron', 2663, *[1491, 1318, 431, 1515], 1)
    ops.element('FourNodeTetrahedron', 2664, *[391, 1386, 392, 1681], 1)
    ops.element('FourNodeTetrahedron', 2665, *[306, 1361, 311, 312], 1)
    ops.element('FourNodeTetrahedron', 2666, *[264, 252, 250, 1276], 1)
    ops.element('FourNodeTetrahedron', 2667, *[1171, 1144, 1361, 1253], 1)
    ops.element('FourNodeTetrahedron', 2668, *[264, 1314, 252, 1276], 1)
    ops.element('FourNodeTetrahedron', 2669, *[1246, 1221, 1509, 1525], 1)
    ops.element('FourNodeTetrahedron', 2670, *[1488, 524, 1691, 523], 1)
    ops.element('FourNodeTetrahedron', 2671, *[264, 1284, 1314, 1276], 1)
    ops.element('FourNodeTetrahedron', 2672, *[304, 264, 250, 1276], 1)
    ops.element('FourNodeTetrahedron', 2673, *[294, 290, 303, 1377], 1)
    ops.element('FourNodeTetrahedron', 2674, *[532, 1249, 525, 526], 1)
    ops.element('FourNodeTetrahedron', 2675, *[304, 1332, 1276, 1551], 1)
    ops.element('FourNodeTetrahedron', 2676, *[516, 1312, 493, 520], 1)
    ops.element('FourNodeTetrahedron', 2677, *[1560, 1630, 1553, 1645], 1)
    ops.element('FourNodeTetrahedron', 2678, *[1607, 1587, 1730, 1630], 1)
    ops.element('FourNodeTetrahedron', 2679, *[1564, 1394, 297, 1309], 1)
    ops.element('FourNodeTetrahedron', 2680, *[769, 1738, 762, 1573], 1)
    ops.element('FourNodeTetrahedron', 2681, *[335, 1388, 331, 1395], 1)
    ops.element('FourNodeTetrahedron', 2682, *[448, 1299, 1539, 1563], 1)
    ops.element('FourNodeTetrahedron', 2683, *[1466, 1127, 1480, 1202], 1)
    ops.element('FourNodeTetrahedron', 2684, *[1331, 416, 415, 1515], 1)
    ops.element('FourNodeTetrahedron', 2685, *[1507, 1435, 404, 1382], 1)
    ops.element('FourNodeTetrahedron', 2686, *[326, 1679, 322, 1322], 1)
    ops.element('FourNodeTetrahedron', 2687, *[326, 1679, 327, 322], 1)
    ops.element('FourNodeTetrahedron', 2688, *[1303, 1470, 389, 1516], 1)
    ops.element('FourNodeTetrahedron', 2689, *[1277, 433, 434, 1296], 1)
    ops.element('FourNodeTetrahedron', 2690, *[230, 1713, 223, 1407], 1)
    ops.element('FourNodeTetrahedron', 2691, *[1520, 1528, 1379, 1689], 1)
    ops.element('FourNodeTetrahedron', 2692, *[230, 223, 224, 1407], 1)
    ops.element('FourNodeTetrahedron', 2693, *[1643, 1648, 1646, 1635], 1)
    ops.element('FourNodeTetrahedron', 2694, *[1348, 1297, 1543, 1288], 1)
    ops.element('FourNodeTetrahedron', 2695, *[1733, 1738, 769, 1573], 1)
    ops.element('FourNodeTetrahedron', 2696, *[1616, 1516, 402, 1518], 1)
    ops.element('FourNodeTetrahedron', 2697, *[755, 382, 381, 1666], 1)
    ops.element('FourNodeTetrahedron', 2698, *[290, 1289, 265, 1332], 1)
    ops.element('FourNodeTetrahedron', 2699, *[1348, 1411, 1543, 1297], 1)
    ops.element('FourNodeTetrahedron', 2700, *[1416, 1579, 745, 1415], 1)
    ops.element('FourNodeTetrahedron', 2701, *[1426, 663, 1704, 662], 1)
    ops.element('FourNodeTetrahedron', 2702, *[1653, 1641, 1588, 1624], 1)
    ops.element('FourNodeTetrahedron', 2703, *[1302, 1678, 1325, 1242], 1)
    ops.element('FourNodeTetrahedron', 2704, *[1587, 1406, 1586, 1639], 1)
    ops.element('FourNodeTetrahedron', 2705, *[1373, 1362, 367, 1455], 1)
    ops.element('FourNodeTetrahedron', 2706, *[1250, 1166, 1308, 1243], 1)
    ops.element('FourNodeTetrahedron', 2707, *[745, 1579, 746, 1485], 1)
    ops.element('FourNodeTetrahedron', 2708, *[1596, 1519, 1635, 1725], 1)
    ops.element('FourNodeTetrahedron', 2709, *[1596, 1635, 1567, 1725], 1)
    ops.element('FourNodeTetrahedron', 2710, *[1247, 1124, 1163, 1582], 1)
    ops.element('FourNodeTetrahedron', 2711, *[1596, 1725, 1567, 1293], 1)
    ops.element('FourNodeTetrahedron', 2712, *[1171, 1144, 1304, 1361], 1)
    ops.element('FourNodeTetrahedron', 2713, *[1336, 1401, 1558, 1471], 1)
    ops.element('FourNodeTetrahedron', 2714, *[1246, 1258, 1509, 1221], 1)
    ops.element('FourNodeTetrahedron', 2715, *[1437, 1258, 1452, 1509], 1)
    ops.element('FourNodeTetrahedron', 2716, *[362, 1612, 328, 1496], 1)
    ops.element('FourNodeTetrahedron', 2717, *[362, 376, 328, 1612], 1)
    ops.element('FourNodeTetrahedron', 2718, *[341, 1351, 340, 1659], 1)
    ops.element('FourNodeTetrahedron', 2719, *[1565, 1557, 1391, 1363], 1)
    ops.element('FourNodeTetrahedron', 2720, *[1271, 136, 179, 1269], 1)
    ops.element('FourNodeTetrahedron', 2721, *[482, 1521, 412, 413], 1)
    ops.element('FourNodeTetrahedron', 2722, *[407, 356, 410, 489], 1)
    ops.element('FourNodeTetrahedron', 2723, *[1735, 166, 172, 174], 1)
    ops.element('FourNodeTetrahedron', 2724, *[273, 1565, 1391, 1363], 1)
    ops.element('FourNodeTetrahedron', 2725, *[1385, 388, 1664, 387], 1)
    ops.element('FourNodeTetrahedron', 2726, *[1668, 1658, 343, 1590], 1)
    ops.element('FourNodeTetrahedron', 2727, *[404, 1410, 398, 405], 1)
    ops.element('FourNodeTetrahedron', 2728, *[1489, 631, 628, 627], 1)
    ops.element('FourNodeTetrahedron', 2729, *[493, 1465, 482, 483], 1)
    ops.element('FourNodeTetrahedron', 2730, *[627, 1489, 1364, 628], 1)
    ops.element('FourNodeTetrahedron', 2731, *[1344, 1588, 1272, 1624], 1)
    ops.element('FourNodeTetrahedron', 2732, *[1695, 1697, 1484, 602], 1)
    ops.element('FourNodeTetrahedron', 2733, *[748, 749, 1579, 1213], 1)
    ops.element('FourNodeTetrahedron', 2734, *[1386, 1207, 1354, 1139], 1)
    ops.element('FourNodeTetrahedron', 2735, *[1140, 146, 1190, 1270], 1)
    ops.element('FourNodeTetrahedron', 2736, *[1308, 1660, 353, 334], 1)
    ops.element('FourNodeTetrahedron', 2737, *[1417, 1357, 287, 1400], 1)
    ops.element('FourNodeTetrahedron', 2738, *[1429, 1375, 1631, 1442], 1)
    ops.element('FourNodeTetrahedron', 2739, *[1632, 1450, 366, 1373], 1)
    ops.element('FourNodeTetrahedron', 2740, *[1235, 1248, 1390, 1389], 1)
    ops.element('FourNodeTetrahedron', 2741, *[1501, 359, 358, 1446], 1)
    ops.element('FourNodeTetrahedron', 2742, *[358, 359, 365, 1446], 1)
    ops.element('FourNodeTetrahedron', 2743, *[1366, 1160, 1365, 645], 1)
    ops.element('FourNodeTetrahedron', 2744, *[1745, 1498, 1544, 522], 1)
    ops.element('FourNodeTetrahedron', 2745, *[705, 703, 706, 1422], 1)
    ops.element('FourNodeTetrahedron', 2746, *[217, 1387, 216, 1350], 1)
    ops.element('FourNodeTetrahedron', 2747, *[1359, 1387, 217, 1350], 1)
    ops.element('FourNodeTetrahedron', 2748, *[214, 1387, 174, 216], 1)
    ops.element('FourNodeTetrahedron', 2749, *[1284, 1562, 1712, 1504], 1)
    ops.element('FourNodeTetrahedron', 2750, *[1713, 1618, 1407, 1559], 1)
    ops.element('FourNodeTetrahedron', 2751, *[1170, 177, 159, 1510], 1)
    ops.element('FourNodeTetrahedron', 2752, *[1193, 1161, 1372, 1133], 1)
    ops.element('FourNodeTetrahedron', 2753, *[1530, 1370, 152, 1540], 1)
    ops.element('FourNodeTetrahedron', 2754, *[1458, 1233, 1726, 1577], 1)
    ops.element('FourNodeTetrahedron', 2755, *[346, 1372, 345, 350], 1)
    ops.element('FourNodeTetrahedron', 2756, *[1466, 1570, 1727, 1480], 1)
    ops.element('FourNodeTetrahedron', 2757, *[1397, 165, 1672, 162], 1)
    ops.element('FourNodeTetrahedron', 2758, *[1546, 1344, 1541, 1624], 1)
    ops.element('FourNodeTetrahedron', 2759, *[1733, 1300, 1738, 1573], 1)
    ops.element('FourNodeTetrahedron', 2760, *[313, 1726, 318, 1577], 1)
    ops.element('FourNodeTetrahedron', 2761, *[1370, 1376, 152, 1540], 1)
    ops.element('FourNodeTetrahedron', 2762, *[665, 1288, 658, 659], 1)
    ops.element('FourNodeTetrahedron', 2763, *[346, 1372, 341, 345], 1)
    ops.element('FourNodeTetrahedron', 2764, *[1161, 1197, 1372, 1133], 1)
    ops.element('FourNodeTetrahedron', 2765, *[1209, 1211, 1453, 1214], 1)
    ops.element('FourNodeTetrahedron', 2766, *[547, 1283, 534, 535], 1)
    ops.element('FourNodeTetrahedron', 2767, *[244, 1337, 248, 249], 1)
    ops.element('FourNodeTetrahedron', 2768, *[360, 374, 361, 1421], 1)
    ops.element('FourNodeTetrahedron', 2769, *[1599, 163, 1523, 1438], 1)
    ops.element('FourNodeTetrahedron', 2770, *[305, 1304, 310, 311], 1)
    ops.element('FourNodeTetrahedron', 2771, *[305, 738, 310, 1304], 1)
    ops.element('FourNodeTetrahedron', 2772, *[1528, 1469, 1459, 1597], 1)
    ops.element('FourNodeTetrahedron', 2773, *[765, 753, 379, 1664], 1)
    ops.element('FourNodeTetrahedron', 2774, *[1306, 1123, 1338, 1432], 1)
    ops.element('FourNodeTetrahedron', 2775, *[1404, 1123, 1338, 1306], 1)
    ops.element('FourNodeTetrahedron', 2776, *[1404, 1338, 289, 1306], 1)
    ops.element('FourNodeTetrahedron', 2777, *[319, 1404, 289, 1306], 1)
    ops.element('FourNodeTetrahedron', 2778, *[1430, 1589, 284, 1338], 1)
    ops.element('FourNodeTetrahedron', 2779, *[319, 1306, 251, 293], 1)
    ops.element('FourNodeTetrahedron', 2780, *[1426, 1550, 1445, 1295], 1)
    ops.element('FourNodeTetrahedron', 2781, *[1403, 1444, 1489, 1572], 1)
    ops.element('FourNodeTetrahedron', 2782, *[1437, 1416, 1452, 1258], 1)
    ops.element('FourNodeTetrahedron', 2783, *[1299, 607, 1563, 451], 1)
    ops.element('FourNodeTetrahedron', 2784, *[274, 1419, 1285, 263], 1)
    ops.element('FourNodeTetrahedron', 2785, *[767, 764, 766, 1527], 1)
    ops.element('FourNodeTetrahedron', 2786, *[516, 1385, 1312, 1517], 1)
    ops.element('FourNodeTetrahedron', 2787, *[702, 1743, 168, 1402], 1)
    ops.element('FourNodeTetrahedron', 2788, *[274, 1419, 1443, 1285], 1)
    ops.element('FourNodeTetrahedron', 2789, *[1493, 1451, 1627, 1448], 1)
    ops.element('FourNodeTetrahedron', 2790, *[263, 1419, 1285, 1327], 1)
    ops.element('FourNodeTetrahedron', 2791, *[1279, 1358, 1355, 1538], 1)
    ops.element('FourNodeTetrahedron', 2792, *[259, 1419, 263, 1327], 1)
    ops.element('FourNodeTetrahedron', 2793, *[1602, 337, 338, 342], 1)
    ops.element('FourNodeTetrahedron', 2794, *[493, 1312, 1521, 520], 1)
    ops.element('FourNodeTetrahedron', 2795, *[722, 727, 726, 1311], 1)
    ops.element('FourNodeTetrahedron', 2796, *[1476, 1514, 1328, 1313], 1)
    ops.element('FourNodeTetrahedron', 2797, *[284, 1338, 1342, 255], 1)
    ops.element('FourNodeTetrahedron', 2798, *[490, 1520, 485, 667], 1)
    ops.element('FourNodeTetrahedron', 2799, *[1122, 1262, 352, 1571], 1)
    ops.element('FourNodeTetrahedron', 2800, *[548, 1291, 1473, 535], 1)
    ops.element('FourNodeTetrahedron', 2801, *[548, 1473, 547, 535], 1)
    ops.element('FourNodeTetrahedron', 2802, *[149, 148, 143, 1275], 1)
    ops.element('FourNodeTetrahedron', 2803, *[1298, 143, 142, 417], 1)
    ops.element('FourNodeTetrahedron', 2804, *[1503, 550, 1596, 549], 1)
    ops.element('FourNodeTetrahedron', 2805, *[456, 613, 1299, 452], 1)
    ops.element('FourNodeTetrahedron', 2806, *[1316, 1706, 1282, 1696], 1)
    ops.element('FourNodeTetrahedron', 2807, *[449, 1299, 448, 452], 1)
    ops.element('FourNodeTetrahedron', 2808, *[1650, 1501, 1685, 1528], 1)
    ops.element('FourNodeTetrahedron', 2809, *[448, 1299, 451, 452], 1)
    ops.element('FourNodeTetrahedron', 2810, *[1508, 148, 1275, 1270], 1)
    ops.element('FourNodeTetrahedron', 2811, *[148, 147, 144, 1270], 1)
    ops.element('FourNodeTetrahedron', 2812, *[1275, 1270, 144, 418], 1)
    ops.element('FourNodeTetrahedron', 2813, *[1607, 1578, 1723, 1730], 1)
    ops.element('FourNodeTetrahedron', 2814, *[1348, 1145, 1236, 1297], 1)
    ops.element('FourNodeTetrahedron', 2815, *[1603, 1567, 1652, 1473], 1)
    ops.element('FourNodeTetrahedron', 2816, *[1446, 1384, 365, 1393], 1)
    ops.element('FourNodeTetrahedron', 2817, *[1512, 1336, 1405, 1467], 1)
    ops.element('FourNodeTetrahedron', 2818, *[1311, 1705, 1339, 1481], 1)
    ops.element('FourNodeTetrahedron', 2819, *[1275, 144, 143, 418], 1)
    ops.element('FourNodeTetrahedron', 2820, *[1555, 432, 433, 1468], 1)
    ops.element('FourNodeTetrahedron', 2821, *[148, 144, 143, 1275], 1)
    ops.element('FourNodeTetrahedron', 2822, *[630, 1181, 634, 633], 1)
    ops.element('FourNodeTetrahedron', 2823, *[1275, 418, 143, 417], 1)
    ops.element('FourNodeTetrahedron', 2824, *[1221, 1218, 1382, 1256], 1)
    ops.element('FourNodeTetrahedron', 2825, *[1264, 1252, 727, 1705], 1)
    ops.element('FourNodeTetrahedron', 2826, *[513, 1246, 1526, 1525], 1)
    ops.element('FourNodeTetrahedron', 2827, *[1264, 728, 727, 1252], 1)
    ops.element('FourNodeTetrahedron', 2828, *[513, 1150, 1647, 519], 1)
    ops.element('FourNodeTetrahedron', 2829, *[1395, 1388, 1405, 1512], 1)
    ops.element('FourNodeTetrahedron', 2830, *[1642, 1506, 1502, 1698], 1)
    ops.element('FourNodeTetrahedron', 2831, *[1464, 1496, 368, 1301], 1)
    ops.element('FourNodeTetrahedron', 2832, *[1219, 1247, 1410, 1164], 1)
    ops.element('FourNodeTetrahedron', 2833, *[300, 1401, 296, 1558], 1)
    ops.element('FourNodeTetrahedron', 2834, *[325, 1403, 329, 1329], 1)
    ops.element('FourNodeTetrahedron', 2835, *[1239, 1169, 1287, 1134], 1)
    ops.element('FourNodeTetrahedron', 2836, *[1344, 1553, 1356, 1588], 1)
    ops.element('FourNodeTetrahedron', 2837, *[290, 1289, 1332, 1377], 1)
    ops.element('FourNodeTetrahedron', 2838, *[1190, 155, 1482, 147], 1)
    ops.element('FourNodeTetrahedron', 2839, *[320, 1322, 321, 462], 1)
    ops.element('FourNodeTetrahedron', 2840, *[1490, 1190, 155, 1482], 1)
    ops.element('FourNodeTetrahedron', 2841, *[1211, 1228, 1439, 1406], 1)
    ops.element('FourNodeTetrahedron', 2842, *[1582, 1392, 406, 1595], 1)
    ops.element('FourNodeTetrahedron', 2843, *[1259, 1676, 659, 650], 1)
    ops.element('FourNodeTetrahedron', 2844, *[1500, 1452, 1435, 1509], 1)
    ops.element('FourNodeTetrahedron', 2845, *[1211, 1141, 1228, 1406], 1)
    ops.element('FourNodeTetrahedron', 2846, *[1525, 1221, 1507, 1429], 1)
    ops.element('FourNodeTetrahedron', 2847, *[1211, 1141, 1406, 1255], 1)
    ops.element('FourNodeTetrahedron', 2848, *[1466, 1570, 1633, 1399], 1)
    ops.element('FourNodeTetrahedron', 2849, *[154, 141, 140, 1331], 1)
    ops.element('FourNodeTetrahedron', 2850, *[293, 1369, 292, 1378], 1)
    ops.element('FourNodeTetrahedron', 2851, *[769, 762, 768, 1573], 1)
    ops.element('FourNodeTetrahedron', 2852, *[1250, 1243, 1308, 1667], 1)
    ops.element('FourNodeTetrahedron', 2853, *[1470, 396, 389, 1516], 1)
    ops.element('FourNodeTetrahedron', 2854, *[352, 1571, 309, 299], 1)
    ops.element('FourNodeTetrahedron', 2855, *[1694, 1294, 661, 662], 1)
    ops.element('FourNodeTetrahedron', 2856, *[1387, 162, 174, 173], 1)
    ops.element('FourNodeTetrahedron', 2857, *[1347, 1407, 1273, 1534], 1)
    ops.element('FourNodeTetrahedron', 2858, *[1552, 1572, 1364, 627], 1)
    ops.element('FourNodeTetrahedron', 2859, *[1238, 419, 418, 424], 1)
    ops.element('FourNodeTetrahedron', 2860, *[1489, 1593, 1467, 631], 1)
    ops.element('FourNodeTetrahedron', 2861, *[1582, 1124, 351, 1392], 1)
    ops.element('FourNodeTetrahedron', 2862, *[516, 1733, 769, 1573], 1)
    ops.element('FourNodeTetrahedron', 2863, *[1321, 1328, 260, 1313], 1)
    ops.element('FourNodeTetrahedron', 2864, *[250, 1276, 252, 1539], 1)
    ops.element('FourNodeTetrahedron', 2865, *[1572, 1489, 1364, 627], 1)
    ops.element('FourNodeTetrahedron', 2866, *[418, 423, 417, 525], 1)
    ops.element('FourNodeTetrahedron', 2867, *[646, 478, 472, 477], 1)
    ops.element('FourNodeTetrahedron', 2868, *[1205, 1203, 1432, 1231], 1)
    ops.element('FourNodeTetrahedron', 2869, *[1220, 1223, 1429, 1126], 1)
    ops.element('FourNodeTetrahedron', 2870, *[1645, 1639, 1654, 1608], 1)
    ops.element('FourNodeTetrahedron', 2871, *[1546, 1268, 1344, 1624], 1)
    ops.element('FourNodeTetrahedron', 2872, *[137, 138, 185, 1261], 1)
    ops.element('FourNodeTetrahedron', 2873, *[1442, 1631, 1421, 1543], 1)
    ops.element('FourNodeTetrahedron', 2874, *[1385, 388, 387, 1517], 1)
    ops.element('FourNodeTetrahedron', 2875, *[624, 1319, 458, 457], 1)
    ops.element('FourNodeTetrahedron', 2876, *[1559, 1407, 1347, 1636], 1)
    ops.element('FourNodeTetrahedron', 2877, *[1491, 1515, 431, 522], 1)
    ops.element('FourNodeTetrahedron', 2878, *[770, 1300, 1738, 1733], 1)
    ops.element('FourNodeTetrahedron', 2879, *[1393, 1294, 1663, 1529], 1)
    ops.element('FourNodeTetrahedron', 2880, *[1550, 1450, 1632, 1295], 1)
    ops.element('FourNodeTetrahedron', 2881, *[483, 1465, 414, 407], 1)
    ops.element('FourNodeTetrahedron', 2882, *[1219, 1164, 1410, 1340], 1)
    ops.element('FourNodeTetrahedron', 2883, *[1301, 1322, 320, 1552], 1)
    ops.element('FourNodeTetrahedron', 2884, *[1217, 1247, 1139, 1410], 1)
    ops.element('FourNodeTetrahedron', 2885, *[1382, 1219, 1410, 1340], 1)
    ops.element('FourNodeTetrahedron', 2886, *[334, 1660, 335, 1395], 1)
    ops.element('FourNodeTetrahedron', 2887, *[1708, 737, 1304, 1171], 1)
    ops.element('FourNodeTetrahedron', 2888, *[1462, 1650, 1685, 1528], 1)
    ops.element('FourNodeTetrahedron', 2889, *[1461, 615, 1463, 614], 1)
    ops.element('FourNodeTetrahedron', 2890, *[734, 732, 735, 1199], 1)
    ops.element('FourNodeTetrahedron', 2891, *[1731, 1646, 1728, 1635], 1)
    ops.element('FourNodeTetrahedron', 2892, *[1731, 1608, 1641, 1728], 1)
    ops.element('FourNodeTetrahedron', 2893, *[1212, 1675, 1398, 1365], 1)
    ops.element('FourNodeTetrahedron', 2894, *[1731, 1641, 1622, 1728], 1)
    ops.element('FourNodeTetrahedron', 2895, *[1317, 1583, 1349, 1391], 1)
    ops.element('FourNodeTetrahedron', 2896, *[1272, 173, 135, 153], 1)
    ops.element('FourNodeTetrahedron', 2897, *[374, 1677, 375, 1631], 1)
    ops.element('FourNodeTetrahedron', 2898, *[1330, 1710, 1583, 1570], 1)
    ops.element('FourNodeTetrahedron', 2899, *[1382, 1410, 404, 1340], 1)
    ops.element('FourNodeTetrahedron', 2900, *[1214, 1211, 1406, 1255], 1)
    ops.element('FourNodeTetrahedron', 2901, *[1704, 1373, 1687, 656], 1)
    ops.element('FourNodeTetrahedron', 2902, *[317, 1400, 288, 318], 1)
    ops.element('FourNodeTetrahedron', 2903, *[359, 1445, 365, 1446], 1)
    ops.element('FourNodeTetrahedron', 2904, *[1398, 1148, 1431, 1675], 1)
    ops.element('FourNodeTetrahedron', 2905, *[727, 1339, 726, 1311], 1)
    ops.element('FourNodeTetrahedron', 2906, *[1323, 1328, 1321, 1476], 1)
    ops.element('FourNodeTetrahedron', 2907, *[358, 364, 363, 1379], 1)
    ops.element('FourNodeTetrahedron', 2908, *[1419, 1560, 1285, 1548], 1)
    ops.element('FourNodeTetrahedron', 2909, *[656, 476, 1687, 655], 1)
    ops.element('FourNodeTetrahedron', 2910, *[213, 1333, 707, 1740], 1)
    ops.element('FourNodeTetrahedron', 2911, *[1365, 1398, 1492, 648], 1)
    ops.element('FourNodeTetrahedron', 2912, *[1332, 1290, 1284, 1504], 1)
    ops.element('FourNodeTetrahedron', 2913, *[1145, 1244, 1297, 1168], 1)
    ops.element('FourNodeTetrahedron', 2914, *[1566, 417, 1691, 524], 1)
    ops.element('FourNodeTetrahedron', 2915, *[1566, 417, 1580, 1691], 1)
    ops.element('FourNodeTetrahedron', 2916, *[214, 1735, 172, 174], 1)
    ops.element('FourNodeTetrahedron', 2917, *[1488, 1566, 1691, 524], 1)
    ops.element('FourNodeTetrahedron', 2918, *[1510, 159, 1674, 156], 1)
    ops.element('FourNodeTetrahedron', 2919, *[1494, 1597, 1707, 671], 1)
    ops.element('FourNodeTetrahedron', 2920, *[1494, 1469, 1597, 671], 1)
    ops.element('FourNodeTetrahedron', 2921, *[1520, 1528, 1597, 1707], 1)
    ops.element('FourNodeTetrahedron', 2922, *[1534, 1355, 1273, 1277], 1)
    ops.element('FourNodeTetrahedron', 2923, *[352, 1262, 309, 1571], 1)
    ops.element('FourNodeTetrahedron', 2924, *[1380, 1494, 1528, 1707], 1)
    ops.element('FourNodeTetrahedron', 2925, *[1373, 472, 471, 477], 1)
    ops.element('FourNodeTetrahedron', 2926, *[1373, 472, 477, 646], 1)
    ops.element('FourNodeTetrahedron', 2927, *[293, 1306, 251, 1369], 1)
    ops.element('FourNodeTetrahedron', 2928, *[1227, 1123, 1404, 1306], 1)
    ops.element('FourNodeTetrahedron', 2929, *[1689, 1278, 487, 669], 1)
    ops.element('FourNodeTetrahedron', 2930, *[1309, 1306, 293, 1369], 1)
    ops.element('FourNodeTetrahedron', 2931, *[1422, 1599, 1402, 1523], 1)
    ops.element('FourNodeTetrahedron', 2932, *[1383, 1327, 258, 1360], 1)
    ops.element('FourNodeTetrahedron', 2933, *[1689, 1459, 1278, 669], 1)
    ops.element('FourNodeTetrahedron', 2934, *[1487, 1409, 1441, 1701], 1)
    ops.element('FourNodeTetrahedron', 2935, *[1586, 1422, 1499, 1523], 1)
    ops.element('FourNodeTetrahedron', 2936, *[285, 1605, 280, 281], 1)
    ops.element('FourNodeTetrahedron', 2937, *[1563, 1476, 601, 607], 1)
    ops.element('FourNodeTetrahedron', 2938, *[1331, 415, 1318, 1515], 1)
    ops.element('FourNodeTetrahedron', 2939, *[1502, 1652, 1591, 1603], 1)
    ops.element('FourNodeTetrahedron', 2940, *[1318, 415, 431, 1515], 1)
    ops.element('FourNodeTetrahedron', 2941, *[518, 1518, 1616, 517], 1)
    ops.element('FourNodeTetrahedron', 2942, *[518, 1616, 520, 517], 1)
    ops.element('FourNodeTetrahedron', 2943, *[518, 1516, 1616, 1518], 1)
    ops.element('FourNodeTetrahedron', 2944, *[1595, 1226, 1392, 1341], 1)
    ops.element('FourNodeTetrahedron', 2945, *[657, 1455, 646, 647], 1)
    ops.element('FourNodeTetrahedron', 2946, *[658, 1455, 657, 647], 1)
    ops.element('FourNodeTetrahedron', 2947, *[1164, 1124, 1582, 1226], 1)
    ops.element('FourNodeTetrahedron', 2948, *[1292, 658, 1455, 657], 1)
    ops.element('FourNodeTetrahedron', 2949, *[1260, 1345, 1349, 1583], 1)
    ops.element('FourNodeTetrahedron', 2950, *[348, 1262, 309, 352], 1)
    ops.element('FourNodeTetrahedron', 2951, *[1401, 1378, 296, 1558], 1)
    ops.element('FourNodeTetrahedron', 2952, *[185, 138, 188, 1358], 1)
    ops.element('FourNodeTetrahedron', 2953, *[1579, 1386, 1485, 1681], 1)
    ops.element('FourNodeTetrahedron', 2954, *[182, 137, 185, 1279], 1)
    ops.element('FourNodeTetrahedron', 2955, *[1627, 1451, 1561, 1368], 1)
    ops.element('FourNodeTetrahedron', 2956, *[549, 537, 1293, 536], 1)
    ops.element('FourNodeTetrahedron', 2957, *[152, 154, 137, 1326], 1)
    ops.element('FourNodeTetrahedron', 2958, *[706, 170, 171, 1656], 1)
    ops.element('FourNodeTetrahedron', 2959, *[300, 1558, 295, 301], 1)
    ops.element('FourNodeTetrahedron', 2960, *[1122, 1186, 1262, 1571], 1)
    ops.element('FourNodeTetrahedron', 2961, *[300, 296, 295, 1558], 1)
    ops.element('FourNodeTetrahedron', 2962, *[1370, 1721, 158, 1376], 1)
    ops.element('FourNodeTetrahedron', 2963, *[1408, 1377, 294, 1319], 1)
    ops.element('FourNodeTetrahedron', 2964, *[303, 1332, 455, 1682], 1)
    ops.element('FourNodeTetrahedron', 2965, *[549, 1293, 1291, 536], 1)
    ops.element('FourNodeTetrahedron', 2966, *[1720, 1384, 1446, 1294], 1)
    ops.element('FourNodeTetrahedron', 2967, *[1547, 1174, 735, 1357], 1)
    ops.element('FourNodeTetrahedron', 2968, *[1518, 1497, 403, 373], 1)
    ops.element('FourNodeTetrahedron', 2969, *[1407, 1618, 1534, 1636], 1)
    ops.element('FourNodeTetrahedron', 2970, *[631, 1467, 624, 625], 1)
    ops.element('FourNodeTetrahedron', 2971, *[1492, 649, 1362, 647], 1)
    ops.element('FourNodeTetrahedron', 2972, *[485, 1520, 486, 668], 1)
    ops.element('FourNodeTetrahedron', 2973, *[184, 180, 183, 1532], 1)
    ops.element('FourNodeTetrahedron', 2974, *[1324, 1620, 1327, 1634], 1)
    ops.element('FourNodeTetrahedron', 2975, *[1200, 1136, 1400, 1201], 1)
    ops.element('FourNodeTetrahedron', 2976, *[1532, 1538, 1279, 1534], 1)
    ops.element('FourNodeTetrahedron', 2977, *[281, 1428, 280, 276], 1)
    ops.element('FourNodeTetrahedron', 2978, *[256, 261, 1328, 1323], 1)
    ops.element('FourNodeTetrahedron', 2979, *[1271, 153, 136, 1269], 1)
    ops.element('FourNodeTetrahedron', 2980, *[280, 1428, 729, 276], 1)
    ops.element('FourNodeTetrahedron', 2981, *[1612, 1341, 1423, 1389], 1)
    ops.element('FourNodeTetrahedron', 2982, *[515, 1352, 518, 513], 1)
    ops.element('FourNodeTetrahedron', 2983, *[1455, 1492, 1464, 1436], 1)
    ops.element('FourNodeTetrahedron', 2984, *[1416, 1213, 1579, 1452], 1)
    ops.element('FourNodeTetrahedron', 2985, *[1415, 744, 1470, 390], 1)
    ops.element('FourNodeTetrahedron', 2986, *[295, 1378, 292, 1367], 1)
    ops.element('FourNodeTetrahedron', 2987, *[711, 704, 710, 1228], 1)
    ops.element('FourNodeTetrahedron', 2988, *[1436, 1492, 1455, 647], 1)
    ops.element('FourNodeTetrahedron', 2989, *[1203, 1135, 1475, 1231], 1)
    ops.element('FourNodeTetrahedron', 2990, *[1203, 1251, 1475, 1135], 1)
    ops.element('FourNodeTetrahedron', 2991, *[645, 648, 1492, 647], 1)
    ops.element('FourNodeTetrahedron', 2992, *[273, 1565, 1363, 1443], 1)
    ops.element('FourNodeTetrahedron', 2993, *[723, 1264, 1311, 1147], 1)
    ops.element('FourNodeTetrahedron', 2994, *[1362, 1301, 1662, 649], 1)
    ops.element('FourNodeTetrahedron', 2995, *[1366, 1365, 1492, 645], 1)
    ops.element('FourNodeTetrahedron', 2996, *[1713, 1532, 223, 1407], 1)
    ops.element('FourNodeTetrahedron', 2997, *[1416, 748, 1579, 1213], 1)
    ops.element('FourNodeTetrahedron', 2998, *[1309, 1195, 1440, 1487], 1)
    ops.element('FourNodeTetrahedron', 2999, *[1153, 1139, 1386, 1217], 1)
    ops.element('FourNodeTetrahedron', 3000, *[1609, 1475, 1655, 1524], 1)
    ops.element('FourNodeTetrahedron', 3001, *[1208, 1209, 1453, 1214], 1)
    ops.element('FourNodeTetrahedron', 3002, *[1480, 1209, 1453, 1208], 1)
    ops.element('FourNodeTetrahedron', 3003, *[1359, 1387, 214, 217], 1)
    ops.element('FourNodeTetrahedron', 3004, *[1434, 1206, 1466, 1718], 1)
    ops.element('FourNodeTetrahedron', 3005, *[1441, 1433, 1637, 1598], 1)
    ops.element('FourNodeTetrahedron', 3006, *[1724, 1720, 1501, 1469], 1)
    ops.element('FourNodeTetrahedron', 3007, *[1436, 1366, 1492, 645], 1)
    ops.element('FourNodeTetrahedron', 3008, *[442, 1347, 440, 545], 1)
    ops.element('FourNodeTetrahedron', 3009, *[1490, 1149, 155, 1190], 1)
    ops.element('FourNodeTetrahedron', 3010, *[1519, 1190, 1508, 1140], 1)
    ops.element('FourNodeTetrahedron', 3011, *[1232, 1191, 1519, 1140], 1)
    ops.element('FourNodeTetrahedron', 3012, *[242, 1363, 247, 243], 1)
    ops.element('FourNodeTetrahedron', 3013, *[1375, 1315, 375, 1390], 1)
    ops.element('FourNodeTetrahedron', 3014, *[1202, 1208, 1589, 1251], 1)
    ops.element('FourNodeTetrahedron', 3015, *[1585, 1348, 1543, 1288], 1)
    ops.element('FourNodeTetrahedron', 3016, *[1406, 1141, 1599, 1438], 1)
    ops.element('FourNodeTetrahedron', 3017, *[1599, 1157, 1402, 163], 1)
    ops.element('FourNodeTetrahedron', 3018, *[1430, 1718, 283, 1418], 1)
    ops.element('FourNodeTetrahedron', 3019, *[1325, 1311, 1570, 1466], 1)
    ops.element('FourNodeTetrahedron', 3020, *[223, 181, 184, 1532], 1)
    ops.element('FourNodeTetrahedron', 3021, *[1459, 661, 1529, 669], 1)
    ops.element('FourNodeTetrahedron', 3022, *[277, 1565, 272, 273], 1)
    ops.element('FourNodeTetrahedron', 3023, *[1391, 1583, 1557, 1565], 1)
    ops.element('FourNodeTetrahedron', 3024, *[1532, 1530, 1269, 1538], 1)
    ops.element('FourNodeTetrahedron', 3025, *[1266, 1455, 1373, 646], 1)
    ops.element('FourNodeTetrahedron', 3026, *[237, 1744, 232, 1328], 1)
    ops.element('FourNodeTetrahedron', 3027, *[752, 743, 1658, 1143], 1)
    ops.element('FourNodeTetrahedron', 3028, *[646, 1362, 472, 478], 1)
    ops.element('FourNodeTetrahedron', 3029, *[1564, 1184, 1394, 1309], 1)
    ops.element('FourNodeTetrahedron', 3030, *[1478, 1283, 1281, 534], 1)
    ops.element('FourNodeTetrahedron', 3031, *[1362, 473, 377, 472], 1)
    ops.element('FourNodeTetrahedron', 3032, *[235, 220, 233, 1374], 1)
    ops.element('FourNodeTetrahedron', 3033, *[1523, 1438, 160, 1513], 1)
    ops.element('FourNodeTetrahedron', 3034, *[1677, 1375, 375, 1631], 1)
    ops.element('FourNodeTetrahedron', 3035, *[1330, 725, 1260, 1345], 1)
    ops.element('FourNodeTetrahedron', 3036, *[727, 717, 1339, 1705], 1)
    ops.element('FourNodeTetrahedron', 3037, *[519, 1150, 1647, 1614], 1)
    ops.element('FourNodeTetrahedron', 3038, *[516, 1312, 494, 493], 1)
    ops.element('FourNodeTetrahedron', 3039, *[1224, 1170, 1438, 1510], 1)
    ops.element('FourNodeTetrahedron', 3040, *[1281, 528, 1544, 522], 1)
    ops.element('FourNodeTetrahedron', 3041, *[1595, 1392, 406, 376], 1)
    ops.element('FourNodeTetrahedron', 3042, *[1575, 1730, 1553, 1630], 1)
    ops.element('FourNodeTetrahedron', 3043, *[248, 1337, 217, 219], 1)
    ops.element('FourNodeTetrahedron', 3044, *[1606, 1611, 353, 1308], 1)
    ops.element('FourNodeTetrahedron', 3045, *[454, 1377, 303, 1682], 1)
    ops.element('FourNodeTetrahedron', 3046, *[1491, 1318, 1358, 431], 1)
    ops.element('FourNodeTetrahedron', 3047, *[764, 753, 765, 1664], 1)
    ops.element('FourNodeTetrahedron', 3048, *[448, 1563, 447, 451], 1)
    ops.element('FourNodeTetrahedron', 3049, *[265, 253, 1314, 1284], 1)
    ops.element('FourNodeTetrahedron', 3050, *[1316, 1282, 468, 628], 1)
    ops.element('FourNodeTetrahedron', 3051, *[1314, 257, 256, 1323], 1)
    ops.element('FourNodeTetrahedron', 3052, *[1599, 163, 1402, 1523], 1)
    ops.element('FourNodeTetrahedron', 3053, *[1141, 1170, 1599, 1438], 1)
    ops.element('FourNodeTetrahedron', 3054, *[1300, 1437, 1500, 1263], 1)
    ops.element('FourNodeTetrahedron', 3055, *[617, 623, 1409, 616], 1)
    ops.element('FourNodeTetrahedron', 3056, *[675, 678, 1426, 663], 1)
    ops.element('FourNodeTetrahedron', 3057, *[1657, 1605, 285, 286], 1)
    ops.element('FourNodeTetrahedron', 3058, *[1743, 167, 168, 175], 1)
    ops.element('FourNodeTetrahedron', 3059, *[1263, 1437, 1500, 1509], 1)
    ops.element('FourNodeTetrahedron', 3060, *[454, 303, 455, 1682], 1)
    ops.element('FourNodeTetrahedron', 3061, *[1541, 1272, 222, 1271], 1)
    ops.element('FourNodeTetrahedron', 3062, *[1377, 1332, 303, 1682], 1)
    ops.element('FourNodeTetrahedron', 3063, *[1671, 1308, 354, 333], 1)
    ops.element('FourNodeTetrahedron', 3064, *[248, 1337, 219, 249], 1)
    ops.element('FourNodeTetrahedron', 3065, *[249, 1337, 219, 1344], 1)
    ops.element('FourNodeTetrahedron', 3066, *[1337, 1350, 219, 1344], 1)
    ops.element('FourNodeTetrahedron', 3067, *[249, 1337, 1344, 1285], 1)
    ops.element('FourNodeTetrahedron', 3068, *[330, 335, 331, 1395], 1)
    ops.element('FourNodeTetrahedron', 3069, *[1471, 1195, 1309, 1487], 1)
    ops.element('FourNodeTetrahedron', 3070, *[703, 169, 170, 1656], 1)
    ops.element('FourNodeTetrahedron', 3071, *[291, 1334, 1289, 1367], 1)
    ops.element('FourNodeTetrahedron', 3072, *[1471, 1309, 1378, 1487], 1)
    ops.element('FourNodeTetrahedron', 3073, *[1194, 1154, 1195, 1709], 1)
    ops.element('FourNodeTetrahedron', 3074, *[1475, 1615, 1644, 1655], 1)
    ops.element('FourNodeTetrahedron', 3075, *[1309, 1369, 1378, 1487], 1)
    ops.element('FourNodeTetrahedron', 3076, *[1446, 1445, 365, 1384], 1)
    ops.element('FourNodeTetrahedron', 3077, *[1464, 1492, 1301, 1362], 1)
    ops.element('FourNodeTetrahedron', 3078, *[1464, 1301, 368, 1362], 1)
    ops.element('FourNodeTetrahedron', 3079, *[1307, 731, 1173, 1151], 1)
    ops.element('FourNodeTetrahedron', 3080, *[1599, 1157, 163, 1170], 1)
    ops.element('FourNodeTetrahedron', 3081, *[1522, 1646, 1645, 1731], 1)
    ops.element('FourNodeTetrahedron', 3082, *[1134, 1437, 1287, 1526], 1)
    ops.element('FourNodeTetrahedron', 3083, *[1430, 1202, 1589, 1123], 1)
    ops.element('FourNodeTetrahedron', 3084, *[1356, 1387, 162, 1479], 1)
    ops.element('FourNodeTetrahedron', 3085, *[1396, 156, 149, 148], 1)
    ops.element('FourNodeTetrahedron', 3086, *[603, 1698, 1697, 548], 1)
    ops.element('FourNodeTetrahedron', 3087, *[1232, 1519, 1688, 1172], 1)
    ops.element('FourNodeTetrahedron', 3088, *[1313, 1514, 1305, 545], 1)
    ops.element('FourNodeTetrahedron', 3089, *[261, 262, 236, 1737], 1)
    ops.element('FourNodeTetrahedron', 3090, *[762, 756, 755, 1303], 1)
    ops.element('FourNodeTetrahedron', 3091, *[752, 1658, 339, 1668], 1)
    ops.element('FourNodeTetrahedron', 3092, *[1411, 1389, 1390, 1568], 1)
    ops.element('FourNodeTetrahedron', 3093, *[1387, 162, 173, 1356], 1)
    ops.element('FourNodeTetrahedron', 3094, *[1283, 1291, 529, 535], 1)
    ops.element('FourNodeTetrahedron', 3095, *[1293, 530, 1291, 536], 1)
    ops.element('FourNodeTetrahedron', 3096, *[536, 1291, 529, 530], 1)
    ops.element('FourNodeTetrahedron', 3097, *[297, 293, 296, 1309], 1)
    ops.element('FourNodeTetrahedron', 3098, *[535, 1291, 529, 536], 1)
    ops.element('FourNodeTetrahedron', 3099, *[548, 536, 1291, 535], 1)
    ops.element('FourNodeTetrahedron', 3100, *[1658, 1602, 342, 1661], 1)
    ops.element('FourNodeTetrahedron', 3101, *[1189, 1200, 1400, 1201], 1)
    ops.element('FourNodeTetrahedron', 3102, *[237, 232, 238, 1313], 1)
    ops.element('FourNodeTetrahedron', 3103, *[448, 1321, 447, 1563], 1)
    ops.element('FourNodeTetrahedron', 3104, *[1339, 1705, 717, 710], 1)
    ops.element('FourNodeTetrahedron', 3105, *[1740, 172, 221, 214], 1)
    ops.element('FourNodeTetrahedron', 3106, *[256, 1323, 1321, 1539], 1)
    ops.element('FourNodeTetrahedron', 3107, *[521, 1494, 517, 509], 1)
    ops.element('FourNodeTetrahedron', 3108, *[213, 707, 221, 1740], 1)
    ops.element('FourNodeTetrahedron', 3109, *[1417, 1200, 1357, 1400], 1)
    ops.element('FourNodeTetrahedron', 3110, *[368, 1329, 324, 1739], 1)
    ops.element('FourNodeTetrahedron', 3111, *[1687, 1373, 471, 477], 1)
    ops.element('FourNodeTetrahedron', 3112, *[1687, 477, 471, 476], 1)
    ops.element('FourNodeTetrahedron', 3113, *[1730, 1569, 1350, 1575], 1)
    ops.element('FourNodeTetrahedron', 3114, *[1635, 1549, 1619, 1556], 1)
    ops.element('FourNodeTetrahedron', 3115, *[1635, 1556, 1619, 1567], 1)
    ops.element('FourNodeTetrahedron', 3116, *[312, 1726, 317, 313], 1)
    ops.element('FourNodeTetrahedron', 3117, *[1635, 1549, 1622, 1619], 1)
    ops.element('FourNodeTetrahedron', 3118, *[484, 488, 489, 1520], 1)
    ops.element('FourNodeTetrahedron', 3119, *[253, 1324, 257, 1314], 1)
    ops.element('FourNodeTetrahedron', 3120, *[1213, 749, 1579, 1153], 1)
    ops.element('FourNodeTetrahedron', 3121, *[1463, 1637, 1693, 615], 1)
    ops.element('FourNodeTetrahedron', 3122, *[1651, 1317, 271, 1413], 1)
    ops.element('FourNodeTetrahedron', 3123, *[1603, 1635, 1652, 1567], 1)
    ops.element('FourNodeTetrahedron', 3124, *[1172, 1140, 1427, 1249], 1)
    ops.element('FourNodeTetrahedron', 3125, *[604, 1506, 1698, 548], 1)
    ops.element('FourNodeTetrahedron', 3126, *[1729, 1640, 1652, 1502], 1)
    ops.element('FourNodeTetrahedron', 3127, *[521, 1158, 1448, 1734], 1)
    ops.element('FourNodeTetrahedron', 3128, *[604, 1698, 603, 548], 1)
    ops.element('FourNodeTetrahedron', 3129, *[1433, 1486, 1638, 1637], 1)
    ops.element('FourNodeTetrahedron', 3130, *[516, 1573, 1385, 1517], 1)
    ops.element('FourNodeTetrahedron', 3131, *[135, 136, 179, 1271], 1)
    ops.element('FourNodeTetrahedron', 3132, *[1289, 1533, 1290, 1461], 1)
    ops.element('FourNodeTetrahedron', 3133, *[461, 1552, 462, 465], 1)
    ops.element('FourNodeTetrahedron', 3134, *[1489, 1512, 1405, 1467], 1)
    ops.element('FourNodeTetrahedron', 3135, *[1396, 1482, 148, 1508], 1)
    ops.element('FourNodeTetrahedron', 3136, *[1357, 1199, 1151, 1136], 1)
    ops.element('FourNodeTetrahedron', 3137, *[1700, 1627, 1460, 678], 1)
    ops.element('FourNodeTetrahedron', 3138, *[1577, 1189, 1404, 1227], 1)
    ops.element('FourNodeTetrahedron', 3139, *[1577, 1404, 319, 1394], 1)
    ops.element('FourNodeTetrahedron', 3140, *[1577, 1404, 318, 319], 1)
    ops.element('FourNodeTetrahedron', 3141, *[314, 1577, 319, 1394], 1)
    ops.element('FourNodeTetrahedron', 3142, *[314, 1577, 318, 319], 1)
    ops.element('FourNodeTetrahedron', 3143, *[347, 1661, 346, 350], 1)
    ops.element('FourNodeTetrahedron', 3144, *[288, 1718, 283, 1430], 1)
    ops.element('FourNodeTetrahedron', 3145, *[1186, 1188, 1670, 1571], 1)
    ops.element('FourNodeTetrahedron', 3146, *[1468, 1491, 431, 522], 1)
    ops.element('FourNodeTetrahedron', 3147, *[1395, 1182, 1388, 1512], 1)
    ops.element('FourNodeTetrahedron', 3148, *[607, 608, 1695, 603], 1)
    ops.element('FourNodeTetrahedron', 3149, *[1605, 1302, 1428, 1434], 1)
    ops.element('FourNodeTetrahedron', 3150, *[1441, 616, 615, 619], 1)
    ops.element('FourNodeTetrahedron', 3151, *[1137, 1182, 1512, 1152], 1)
    ops.element('FourNodeTetrahedron', 3152, *[674, 1700, 1460, 678], 1)
    ops.element('FourNodeTetrahedron', 3153, *[1449, 1461, 1377, 620], 1)
    ops.element('FourNodeTetrahedron', 3154, *[1521, 386, 412, 413], 1)
    ops.element('FourNodeTetrahedron', 3155, *[1605, 1307, 1302, 1434], 1)
    ops.element('FourNodeTetrahedron', 3156, *[1137, 1182, 1395, 1512], 1)
    ops.element('FourNodeTetrahedron', 3157, *[1717, 1554, 1334, 1715], 1)
    ops.element('FourNodeTetrahedron', 3158, *[1591, 1652, 1617, 1473], 1)
    ops.element('FourNodeTetrahedron', 3159, *[518, 1526, 1300, 1516], 1)
    ops.element('FourNodeTetrahedron', 3160, *[1197, 1198, 1669, 1187], 1)
    ops.element('FourNodeTetrahedron', 3161, *[1526, 1437, 1509, 1246], 1)
    ops.element('FourNodeTetrahedron', 3162, *[1450, 1680, 367, 1464], 1)
    ops.element('FourNodeTetrahedron', 3163, *[361, 1483, 1680, 1450], 1)
    ops.element('FourNodeTetrahedron', 3164, *[1264, 1705, 727, 1311], 1)
    ops.element('FourNodeTetrahedron', 3165, *[1440, 1205, 1231, 1138], 1)
    ops.element('FourNodeTetrahedron', 3166, *[1642, 1548, 1729, 1536], 1)
    ops.element('FourNodeTetrahedron', 3167, *[521, 1732, 509, 510], 1)
    ops.element('FourNodeTetrahedron', 3168, *[1446, 364, 1335, 1393], 1)
    ops.element('FourNodeTetrahedron', 3169, *[1346, 1402, 705, 1422], 1)
    ops.element('FourNodeTetrahedron', 3170, *[757, 744, 756, 1470], 1)
    ops.element('FourNodeTetrahedron', 3171, *[757, 1415, 744, 1470], 1)
    ops.element('FourNodeTetrahedron', 3172, *[531, 525, 1576, 524], 1)
    ops.element('FourNodeTetrahedron', 3173, *[1573, 1286, 1385, 1517], 1)
    ops.element('FourNodeTetrahedron', 3174, *[1424, 1292, 1295, 663], 1)
    ops.element('FourNodeTetrahedron', 3175, *[1671, 1250, 1308, 1667], 1)
    ops.element('FourNodeTetrahedron', 3176, *[1374, 1541, 1412, 1621], 1)
    ops.element('FourNodeTetrahedron', 3177, *[1426, 1424, 1295, 663], 1)
    ops.element('FourNodeTetrahedron', 3178, *[711, 712, 704, 1228], 1)
    ops.element('FourNodeTetrahedron', 3179, *[1292, 657, 1295, 663], 1)
    ops.element('FourNodeTetrahedron', 3180, *[1638, 1267, 1584, 1486], 1)
    ops.element('FourNodeTetrahedron', 3181, *[354, 1308, 353, 333], 1)
    ops.element('FourNodeTetrahedron', 3182, *[1267, 1135, 1475, 1524], 1)
    ops.element('FourNodeTetrahedron', 3183, *[1551, 1504, 1712, 607], 1)
    ops.element('FourNodeTetrahedron', 3184, *[1450, 1455, 1373, 1295], 1)
    ops.element('FourNodeTetrahedron', 3185, *[1279, 1326, 1261, 1358], 1)
    ops.element('FourNodeTetrahedron', 3186, *[1480, 1481, 1607, 1453], 1)
    ops.element('FourNodeTetrahedron', 3187, *[1375, 375, 1631, 1390], 1)
    ops.element('FourNodeTetrahedron', 3188, *[1621, 1622, 1624, 1530], 1)
    ops.element('FourNodeTetrahedron', 3189, *[1434, 1466, 1633, 1399], 1)
    ops.element('FourNodeTetrahedron', 3190, *[279, 1443, 274, 1419], 1)
    ops.element('FourNodeTetrahedron', 3191, *[1434, 1633, 1428, 1466], 1)
    ops.element('FourNodeTetrahedron', 3192, *[1390, 1389, 1612, 1568], 1)
    ops.element('FourNodeTetrahedron', 3193, *[1501, 1425, 359, 1445], 1)
    ops.element('FourNodeTetrahedron', 3194, *[1573, 1303, 1286, 1517], 1)
    ops.element('FourNodeTetrahedron', 3195, *[372, 359, 358, 1501], 1)
    ops.element('FourNodeTetrahedron', 3196, *[1329, 1403, 1322, 1572], 1)
    ops.element('FourNodeTetrahedron', 3197, *[1457, 1431, 1329, 1572], 1)
    ops.element('FourNodeTetrahedron', 3198, *[1572, 1364, 1322, 1552], 1)
    ops.element('FourNodeTetrahedron', 3199, *[1316, 1282, 323, 464], 1)
    ops.element('FourNodeTetrahedron', 3200, *[1357, 1307, 1605, 1434], 1)
    ops.element('FourNodeTetrahedron', 3201, *[1729, 1621, 1623, 1591], 1)
    ops.element('FourNodeTetrahedron', 3202, *[1245, 1133, 1611, 1606], 1)
    ops.element('FourNodeTetrahedron', 3203, *[1255, 1224, 1406, 1719], 1)
    ops.element('FourNodeTetrahedron', 3204, *[1340, 1225, 1164, 1595], 1)
    ops.element('FourNodeTetrahedron', 3205, *[1555, 1491, 1358, 432], 1)
    ops.element('FourNodeTetrahedron', 3206, *[1555, 1355, 433, 432], 1)
    ops.element('FourNodeTetrahedron', 3207, *[1228, 712, 704, 1599], 1)
    ops.element('FourNodeTetrahedron', 3208, *[1492, 648, 1457, 649], 1)
    ops.element('FourNodeTetrahedron', 3209, *[1162, 752, 1668, 1143], 1)
    ops.element('FourNodeTetrahedron', 3210, *[1363, 1557, 1575, 1443], 1)
    ops.element('FourNodeTetrahedron', 3211, *[1383, 1581, 1327, 1620], 1)
    ops.element('FourNodeTetrahedron', 3212, *[1495, 156, 157, 150], 1)
    ops.element('FourNodeTetrahedron', 3213, *[1598, 1420, 1637, 610], 1)
    ops.element('FourNodeTetrahedron', 3214, *[1446, 365, 364, 1393], 1)
    ops.element('FourNodeTetrahedron', 3215, *[1535, 1477, 1562, 1504], 1)
    ops.element('FourNodeTetrahedron', 3216, *[1571, 314, 309, 299], 1)
    ops.element('FourNodeTetrahedron', 3217, *[1740, 1672, 1735, 1387], 1)
    ops.element('FourNodeTetrahedron', 3218, *[1271, 180, 181, 1532], 1)
    ops.element('FourNodeTetrahedron', 3219, *[350, 1133, 1611, 1606], 1)
    ops.element('FourNodeTetrahedron', 3220, *[363, 364, 369, 1335], 1)
    ops.element('FourNodeTetrahedron', 3221, *[1335, 364, 369, 1393], 1)
    ops.element('FourNodeTetrahedron', 3222, *[709, 705, 706, 1422], 1)
    ops.element('FourNodeTetrahedron', 3223, *[363, 369, 408, 1335], 1)
    ops.element('FourNodeTetrahedron', 3224, *[1335, 369, 408, 479], 1)
    ops.element('FourNodeTetrahedron', 3225, *[1335, 369, 469, 479], 1)
    ops.element('FourNodeTetrahedron', 3226, *[1335, 469, 479, 1278], 1)
    ops.element('FourNodeTetrahedron', 3227, *[487, 1335, 408, 479], 1)
    ops.element('FourNodeTetrahedron', 3228, *[303, 290, 1332, 1377], 1)
    ops.element('FourNodeTetrahedron', 3229, *[1389, 1496, 1612, 1568], 1)
    ops.element('FourNodeTetrahedron', 3230, *[487, 1335, 479, 1278], 1)
    ops.element('FourNodeTetrahedron', 3231, *[1155, 550, 1503, 606], 1)
    ops.element('FourNodeTetrahedron', 3232, *[223, 1271, 181, 1532], 1)
    ops.element('FourNodeTetrahedron', 3233, *[1335, 1393, 369, 469], 1)
    ops.element('FourNodeTetrahedron', 3234, *[1460, 1724, 1469, 1426], 1)
    ops.element('FourNodeTetrahedron', 3235, *[1393, 1384, 378, 1663], 1)
    ops.element('FourNodeTetrahedron', 3236, *[446, 545, 444, 441], 1)
    ops.element('FourNodeTetrahedron', 3237, *[1335, 1393, 469, 1278], 1)
    ops.element('FourNodeTetrahedron', 3238, *[409, 1335, 408, 487], 1)
    ops.element('FourNodeTetrahedron', 3239, *[409, 363, 408, 1335], 1)
    ops.element('FourNodeTetrahedron', 3240, *[447, 1563, 450, 451], 1)
    ops.element('FourNodeTetrahedron', 3241, *[1459, 1393, 1335, 1278], 1)
    ops.element('FourNodeTetrahedron', 3242, *[1465, 371, 356, 1462], 1)
    ops.element('FourNodeTetrahedron', 3243, *[537, 531, 1293, 530], 1)
    ops.element('FourNodeTetrahedron', 3244, *[1465, 356, 489, 1462], 1)
    ops.element('FourNodeTetrahedron', 3245, *[1465, 356, 407, 489], 1)
    ops.element('FourNodeTetrahedron', 3246, *[1309, 1369, 293, 1378], 1)
    ops.element('FourNodeTetrahedron', 3247, *[1221, 1382, 1507, 1429], 1)
    ops.element('FourNodeTetrahedron', 3248, *[623, 1196, 1409, 611], 1)
    ops.element('FourNodeTetrahedron', 3249, *[1252, 711, 1705, 1210], 1)
    ops.element('FourNodeTetrahedron', 3250, *[1496, 1423, 1431, 1398], 1)
    ops.element('FourNodeTetrahedron', 3251, *[1579, 750, 1690, 1153], 1)
    ops.element('FourNodeTetrahedron', 3252, *[1637, 1486, 1420, 1598], 1)
    ops.element('FourNodeTetrahedron', 3253, *[1473, 1291, 1545, 1283], 1)
    ops.element('FourNodeTetrahedron', 3254, *[1616, 1518, 402, 372], 1)
    ops.element('FourNodeTetrahedron', 3255, *[1338, 1589, 1342, 1475], 1)
    ops.element('FourNodeTetrahedron', 3256, *[1503, 1648, 1596, 550], 1)
    ops.element('FourNodeTetrahedron', 3257, *[1207, 751, 1354, 1162], 1)
    ops.element('FourNodeTetrahedron', 3258, *[1182, 1131, 1574, 1194], 1)
    ops.element('FourNodeTetrahedron', 3259, *[1533, 1638, 1584, 1637], 1)
    ops.element('FourNodeTetrahedron', 3260, *[766, 765, 411, 1527], 1)
    ops.element('FourNodeTetrahedron', 3261, *[1445, 1632, 1373, 1295], 1)
    ops.element('FourNodeTetrahedron', 3262, *[1354, 1668, 385, 392], 1)
    ops.element('FourNodeTetrahedron', 3263, *[261, 237, 260, 1328], 1)
    ops.element('FourNodeTetrahedron', 3264, *[1413, 1583, 1317, 1391], 1)
    ops.element('FourNodeTetrahedron', 3265, *[1413, 1330, 1317, 1583], 1)
    ops.element('FourNodeTetrahedron', 3266, *[1461, 1441, 1637, 615], 1)
    ops.element('FourNodeTetrahedron', 3267, *[291, 1334, 266, 1289], 1)
    ops.element('FourNodeTetrahedron', 3268, *[605, 1503, 549, 604], 1)
    ops.element('FourNodeTetrahedron', 3269, *[1731, 1728, 1622, 1635], 1)
    ops.element('FourNodeTetrahedron', 3270, *[1649, 1448, 1700, 677], 1)
    ops.element('FourNodeTetrahedron', 3271, *[256, 1328, 260, 1321], 1)
    ops.element('FourNodeTetrahedron', 3272, *[1146, 1257, 1368, 684], 1)
    ops.element('FourNodeTetrahedron', 3273, *[510, 1732, 673, 509], 1)
    ops.element('FourNodeTetrahedron', 3274, *[606, 550, 1503, 605], 1)
    ops.element('FourNodeTetrahedron', 3275, *[1133, 1197, 1372, 1187], 1)
    ops.element('FourNodeTetrahedron', 3276, *[1645, 1608, 1654, 1641], 1)
    ops.element('FourNodeTetrahedron', 3277, *[1404, 1201, 1430, 1123], 1)
    ops.element('FourNodeTetrahedron', 3278, *[1443, 1337, 1363, 274], 1)
    ops.element('FourNodeTetrahedron', 3279, *[1522, 1130, 1454, 1646], 1)
    ops.element('FourNodeTetrahedron', 3280, *[512, 1493, 519, 521], 1)
    ops.element('FourNodeTetrahedron', 3281, *[1125, 1177, 1381, 1176], 1)
    ops.element('FourNodeTetrahedron', 3282, *[1483, 1568, 1612, 1464], 1)
    ops.element('FourNodeTetrahedron', 3283, *[1515, 415, 431, 420], 1)
    ops.element('FourNodeTetrahedron', 3284, *[1474, 1555, 1277, 1296], 1)
    ops.element('FourNodeTetrahedron', 3285, *[1433, 1486, 1637, 1598], 1)
    ops.element('FourNodeTetrahedron', 3286, *[1494, 1597, 1528, 1707], 1)
    ops.element('FourNodeTetrahedron', 3287, *[451, 1299, 607, 452], 1)
    ops.element('FourNodeTetrahedron', 3288, *[1583, 1710, 1345, 1723], 1)
    ops.element('FourNodeTetrahedron', 3289, *[447, 1563, 450, 445], 1)
    ops.element('FourNodeTetrahedron', 3290, *[1453, 1211, 1439, 1406], 1)
    ops.element('FourNodeTetrahedron', 3291, *[1347, 1534, 1277, 1474], 1)
    ops.element('FourNodeTetrahedron', 3292, *[1380, 1707, 1520, 667], 1)
    ops.element('FourNodeTetrahedron', 3293, *[1273, 1742, 187, 1665], 1)
    ops.element('FourNodeTetrahedron', 3294, *[265, 1290, 1360, 1284], 1)
    ops.element('FourNodeTetrahedron', 3295, *[1429, 1223, 1375, 1442], 1)
    ops.element('FourNodeTetrahedron', 3296, *[1412, 1530, 1532, 1618], 1)
    ops.element('FourNodeTetrahedron', 3297, *[1363, 217, 248, 1337], 1)
    ops.element('FourNodeTetrahedron', 3298, *[1705, 711, 710, 1703], 1)
    ops.element('FourNodeTetrahedron', 3299, *[1373, 1362, 377, 472], 1)
    ops.element('FourNodeTetrahedron', 3300, *[1495, 1510, 156, 1396], 1)
    ops.element('FourNodeTetrahedron', 3301, *[1333, 1740, 214, 1387], 1)
    ops.element('FourNodeTetrahedron', 3302, *[1559, 1623, 1618, 1636], 1)
    ops.element('FourNodeTetrahedron', 3303, *[545, 1296, 440, 439], 1)
    ops.element('FourNodeTetrahedron', 3304, *[1465, 1462, 489, 491], 1)
    ops.element('FourNodeTetrahedron', 3305, *[1420, 1155, 1503, 606], 1)
    ops.element('FourNodeTetrahedron', 3306, *[1668, 1143, 1658, 1590], 1)
    ops.element('FourNodeTetrahedron', 3307, *[1361, 1144, 1417, 1230], 1)
    ops.element('FourNodeTetrahedron', 3308, *[605, 550, 1503, 549], 1)
    ops.element('FourNodeTetrahedron', 3309, *[761, 1287, 757, 1300], 1)
    ops.element('FourNodeTetrahedron', 3310, *[723, 728, 1264, 1147], 1)
    ops.element('FourNodeTetrahedron', 3311, *[1469, 1720, 1446, 1459], 1)
    ops.element('FourNodeTetrahedron', 3312, *[1300, 1287, 1437, 1526], 1)
    ops.element('FourNodeTetrahedron', 3313, *[1300, 1437, 1415, 1500], 1)
    ops.element('FourNodeTetrahedron', 3314, *[1300, 1287, 1415, 1437], 1)
    ops.element('FourNodeTetrahedron', 3315, *[1264, 728, 1252, 1147], 1)
    ops.element('FourNodeTetrahedron', 3316, *[1158, 1448, 1265, 680], 1)
    ops.element('FourNodeTetrahedron', 3317, *[357, 363, 409, 1379], 1)
    ops.element('FourNodeTetrahedron', 3318, *[1401, 1309, 296, 1378], 1)
    ops.element('FourNodeTetrahedron', 3319, *[1562, 1634, 1324, 1484], 1)
    ops.element('FourNodeTetrahedron', 3320, *[1649, 1448, 1627, 1700], 1)
    ops.element('FourNodeTetrahedron', 3321, *[1479, 1721, 158, 1272], 1)
    ops.element('FourNodeTetrahedron', 3322, *[1232, 1172, 1688, 551], 1)
    ops.element('FourNodeTetrahedron', 3323, *[1549, 1396, 150, 1298], 1)
    ops.element('FourNodeTetrahedron', 3324, *[1509, 1435, 1507, 1221], 1)
    ops.element('FourNodeTetrahedron', 3325, *[327, 298, 323, 1282], 1)
    ops.element('FourNodeTetrahedron', 3326, *[1534, 1538, 1555, 1544], 1)
    ops.element('FourNodeTetrahedron', 3327, *[323, 1282, 298, 464], 1)
    ops.element('FourNodeTetrahedron', 3328, *[1190, 147, 1482, 1270], 1)
    ops.element('FourNodeTetrahedron', 3329, *[327, 301, 298, 1282], 1)
    ops.element('FourNodeTetrahedron', 3330, *[1366, 1212, 1398, 1365], 1)
    ops.element('FourNodeTetrahedron', 3331, *[250, 1539, 269, 448], 1)
    ops.element('FourNodeTetrahedron', 3332, *[1452, 1129, 1435, 1509], 1)
    ops.element('FourNodeTetrahedron', 3333, *[1667, 1660, 334, 1395], 1)
    ops.element('FourNodeTetrahedron', 3334, *[1509, 1129, 1435, 1221], 1)
    ops.element('FourNodeTetrahedron', 3335, *[628, 624, 1282, 468], 1)
    ops.element('FourNodeTetrahedron', 3336, *[468, 1282, 464, 457], 1)
    ops.element('FourNodeTetrahedron', 3337, *[1282, 624, 457, 468], 1)
    ops.element('FourNodeTetrahedron', 3338, *[464, 1282, 453, 457], 1)
    ops.element('FourNodeTetrahedron', 3339, *[1282, 1319, 457, 624], 1)
    ops.element('FourNodeTetrahedron', 3340, *[1282, 1319, 453, 457], 1)
    ops.element('FourNodeTetrahedron', 3341, *[1498, 1580, 1515, 523], 1)
    ops.element('FourNodeTetrahedron', 3342, *[1600, 1425, 1594, 1550], 1)
    ops.element('FourNodeTetrahedron', 3343, *[251, 1432, 1338, 1343], 1)
    ops.element('FourNodeTetrahedron', 3344, *[231, 1347, 225, 442], 1)
    ops.element('FourNodeTetrahedron', 3345, *[231, 224, 225, 1347], 1)
    ops.element('FourNodeTetrahedron', 3346, *[1347, 224, 225, 1277], 1)
    ops.element('FourNodeTetrahedron', 3347, *[520, 1616, 394, 1465], 1)
    ops.element('FourNodeTetrahedron', 3348, *[1173, 723, 1678, 1242], 1)
    ops.element('FourNodeTetrahedron', 3349, *[1539, 1323, 1321, 1476], 1)
    ops.element('FourNodeTetrahedron', 3350, *[230, 1407, 224, 1347], 1)
    ops.element('FourNodeTetrahedron', 3351, *[1473, 1567, 1545, 1291], 1)
    ops.element('FourNodeTetrahedron', 3352, *[230, 224, 231, 1347], 1)
    ops.element('FourNodeTetrahedron', 3353, *[732, 1307, 730, 1302], 1)
    ops.element('FourNodeTetrahedron', 3354, *[224, 184, 187, 1273], 1)
    ops.element('FourNodeTetrahedron', 3355, *[454, 1684, 459, 458], 1)
    ops.element('FourNodeTetrahedron', 3356, *[284, 1338, 1589, 1342], 1)
    ops.element('FourNodeTetrahedron', 3357, *[473, 1662, 461, 465], 1)
    ops.element('FourNodeTetrahedron', 3358, *[1408, 1367, 294, 1377], 1)
    ops.element('FourNodeTetrahedron', 3359, *[1408, 1367, 1377, 1449], 1)
    ops.element('FourNodeTetrahedron', 3360, *[1319, 1408, 1377, 1449], 1)
    ops.element('FourNodeTetrahedron', 3361, *[1485, 1690, 384, 391], 1)
    ops.element('FourNodeTetrahedron', 3362, *[1461, 1441, 1533, 1637], 1)
    ops.element('FourNodeTetrahedron', 3363, *[1538, 1279, 1355, 1534], 1)
    ops.element('FourNodeTetrahedron', 3364, *[1474, 1555, 1296, 1281], 1)
    ops.element('FourNodeTetrahedron', 3365, *[1653, 1731, 1641, 1622], 1)
    ops.element('FourNodeTetrahedron', 3366, *[1351, 340, 336, 341], 1)
    ops.element('FourNodeTetrahedron', 3367, *[518, 1526, 1516, 1647], 1)
    ops.element('FourNodeTetrahedron', 3368, *[319, 1306, 289, 251], 1)
    ops.element('FourNodeTetrahedron', 3369, *[1273, 1279, 1355, 1534], 1)
    ops.element('FourNodeTetrahedron', 3370, *[766, 764, 765, 1527], 1)
    ops.element('FourNodeTetrahedron', 3371, *[1411, 1389, 1568, 1366], 1)
    ops.element('FourNodeTetrahedron', 3372, *[667, 1520, 485, 668], 1)
    ops.element('FourNodeTetrahedron', 3373, *[484, 1520, 488, 485], 1)
    ops.element('FourNodeTetrahedron', 3374, *[491, 1520, 485, 490], 1)
    ops.element('FourNodeTetrahedron', 3375, *[490, 1380, 491, 509], 1)
    ops.element('FourNodeTetrahedron', 3376, *[491, 1380, 1520, 490], 1)
    ops.element('FourNodeTetrahedron', 3377, *[1404, 1123, 1430, 1338], 1)
    ops.element('FourNodeTetrahedron', 3378, *[491, 1520, 484, 485], 1)
    ops.element('FourNodeTetrahedron', 3379, *[488, 1462, 1379, 1520], 1)
    ops.element('FourNodeTetrahedron', 3380, *[486, 480, 487, 669], 1)
    ops.element('FourNodeTetrahedron', 3381, *[1387, 1397, 1499, 1629], 1)
    ops.element('FourNodeTetrahedron', 3382, *[1740, 1397, 1672, 1387], 1)
    ops.element('FourNodeTetrahedron', 3383, *[1477, 1642, 1502, 1698], 1)
    ops.element('FourNodeTetrahedron', 3384, *[1126, 1236, 1442, 1348], 1)
    ops.element('FourNodeTetrahedron', 3385, *[1528, 1379, 1462, 1520], 1)
    ops.element('FourNodeTetrahedron', 3386, *[491, 489, 484, 1520], 1)
    ops.element('FourNodeTetrahedron', 3387, *[489, 1462, 488, 1520], 1)
    ops.element('FourNodeTetrahedron', 3388, *[491, 1380, 1462, 1520], 1)
    ops.element('FourNodeTetrahedron', 3389, *[1372, 1197, 344, 1669], 1)
    ops.element('FourNodeTetrahedron', 3390, *[1272, 158, 173, 153], 1)
    ops.element('FourNodeTetrahedron', 3391, *[1380, 1528, 1462, 1520], 1)
    ops.element('FourNodeTetrahedron', 3392, *[1396, 1482, 155, 148], 1)
    ops.element('FourNodeTetrahedron', 3393, *[410, 1379, 409, 488], 1)
    ops.element('FourNodeTetrahedron', 3394, *[152, 151, 154, 1540], 1)
    ops.element('FourNodeTetrahedron', 3395, *[521, 676, 1702, 510], 1)
    ops.element('FourNodeTetrahedron', 3396, *[1694, 1704, 1294, 662], 1)
    ops.element('FourNodeTetrahedron', 3397, *[1291, 1576, 1488, 530], 1)
    ops.element('FourNodeTetrahedron', 3398, *[1336, 1471, 1558, 1511], 1)
    ops.element('FourNodeTetrahedron', 3399, *[1706, 1336, 1558, 1511], 1)
    ops.element('FourNodeTetrahedron', 3400, *[1432, 1475, 1683, 1267], 1)
    ops.element('FourNodeTetrahedron', 3401, *[1563, 1313, 443, 445], 1)
    ops.element('FourNodeTetrahedron', 3402, *[1660, 1571, 335, 1388], 1)
    ops.element('FourNodeTetrahedron', 3403, *[1512, 1472, 1574, 1467], 1)
    ops.element('FourNodeTetrahedron', 3404, *[1321, 1313, 238, 443], 1)
    ops.element('FourNodeTetrahedron', 3405, *[1741, 1241, 1606, 1671], 1)
    ops.element('FourNodeTetrahedron', 3406, *[1299, 1476, 1539, 1563], 1)
    ops.element('FourNodeTetrahedron', 3407, *[1613, 1600, 1425, 1594], 1)
    ops.element('FourNodeTetrahedron', 3408, *[488, 1379, 409, 1601], 1)
    ops.element('FourNodeTetrahedron', 3409, *[551, 1172, 1688, 1673], 1)
    ops.element('FourNodeTetrahedron', 3410, *[1688, 1172, 1427, 1673], 1)
    ops.element('FourNodeTetrahedron', 3411, *[770, 761, 1300, 1352], 1)
    ops.element('FourNodeTetrahedron', 3412, *[1247, 1124, 1582, 1164], 1)
    ops.element('FourNodeTetrahedron', 3413, *[1574, 1131, 1471, 1194], 1)
    ops.element('FourNodeTetrahedron', 3414, *[1688, 1427, 1519, 1172], 1)
    ops.element('FourNodeTetrahedron', 3415, *[738, 739, 736, 1547], 1)
    ops.element('FourNodeTetrahedron', 3416, *[738, 736, 310, 1547], 1)
    ops.element('FourNodeTetrahedron', 3417, *[1304, 738, 1547, 1144], 1)
    ops.element('FourNodeTetrahedron', 3418, *[1304, 1144, 1547, 1361], 1)
    ops.element('FourNodeTetrahedron', 3419, *[1434, 1302, 1428, 1466], 1)
    ops.element('FourNodeTetrahedron', 3420, *[1136, 1151, 1434, 1206], 1)
    ops.element('FourNodeTetrahedron', 3421, *[1434, 1151, 1302, 1206], 1)
    ops.element('FourNodeTetrahedron', 3422, *[1376, 157, 151, 150], 1)
    ops.element('FourNodeTetrahedron', 3423, *[1434, 1302, 1466, 1206], 1)
    ops.element('FourNodeTetrahedron', 3424, *[1302, 1242, 1325, 1466], 1)
    ops.element('FourNodeTetrahedron', 3425, *[288, 1400, 1434, 1430], 1)
    ops.element('FourNodeTetrahedron', 3426, *[287, 1400, 1434, 288], 1)
    ops.element('FourNodeTetrahedron', 3427, *[1507, 1382, 1677, 1429], 1)
    ops.element('FourNodeTetrahedron', 3428, *[287, 1434, 282, 288], 1)
    ops.element('FourNodeTetrahedron', 3429, *[510, 676, 1702, 673], 1)
    ops.element('FourNodeTetrahedron', 3430, *[1277, 1665, 190, 433], 1)
    ops.element('FourNodeTetrahedron', 3431, *[767, 764, 1527, 1385], 1)
    ops.element('FourNodeTetrahedron', 3432, *[1277, 1555, 1355, 433], 1)
    ops.element('FourNodeTetrahedron', 3433, *[1307, 731, 1678, 1173], 1)
    ops.element('FourNodeTetrahedron', 3434, *[1400, 1206, 1434, 1430], 1)
    ops.element('FourNodeTetrahedron', 3435, *[287, 1434, 281, 282], 1)
    ops.element('FourNodeTetrahedron', 3436, *[286, 1434, 281, 287], 1)
    ops.element('FourNodeTetrahedron', 3437, *[1222, 1126, 1447, 1451], 1)
    ops.element('FourNodeTetrahedron', 3438, *[286, 1357, 1434, 287], 1)
    ops.element('FourNodeTetrahedron', 3439, *[1304, 1547, 311, 1361], 1)
    ops.element('FourNodeTetrahedron', 3440, *[1296, 1555, 1468, 1281], 1)
    ops.element('FourNodeTetrahedron', 3441, *[1593, 1472, 1467, 631], 1)
    ops.element('FourNodeTetrahedron', 3442, *[290, 291, 1289, 1367], 1)
    ops.element('FourNodeTetrahedron', 3443, *[1521, 393, 413, 414], 1)
    ops.element('FourNodeTetrahedron', 3444, *[1398, 1431, 1457, 629], 1)
    ops.element('FourNodeTetrahedron', 3445, *[1565, 1557, 1363, 1443], 1)
    ops.element('FourNodeTetrahedron', 3446, *[1283, 1291, 1545, 529], 1)
    ops.element('FourNodeTetrahedron', 3447, *[1128, 1230, 1458, 1233], 1)
    ops.element('FourNodeTetrahedron', 3448, *[1447, 1126, 1442, 1451], 1)
    ops.element('FourNodeTetrahedron', 3449, *[362, 328, 368, 1496], 1)
    ops.element('FourNodeTetrahedron', 3450, *[1670, 1233, 1577, 1394], 1)
    ops.element('FourNodeTetrahedron', 3451, *[1298, 417, 142, 416], 1)
    ops.element('FourNodeTetrahedron', 3452, *[1280, 150, 141, 1298], 1)
    ops.element('FourNodeTetrahedron', 3453, *[1332, 1284, 1276, 1551], 1)
    ops.element('FourNodeTetrahedron', 3454, *[150, 142, 141, 1298], 1)
    ops.element('FourNodeTetrahedron', 3455, *[260, 1328, 237, 1313], 1)
    ops.element('FourNodeTetrahedron', 3456, *[1298, 141, 1331, 416], 1)
    ops.element('FourNodeTetrahedron', 3457, *[1298, 142, 141, 416], 1)
    ops.element('FourNodeTetrahedron', 3458, *[1670, 1577, 314, 1394], 1)
    ops.element('FourNodeTetrahedron', 3459, *[1670, 1394, 314, 1571], 1)
    ops.element('FourNodeTetrahedron', 3460, *[219, 1350, 218, 1344], 1)
    ops.element('FourNodeTetrahedron', 3461, *[1360, 1324, 1314, 1562], 1)
    ops.element('FourNodeTetrahedron', 3462, *[1444, 1512, 1714, 1489], 1)
    ops.element('FourNodeTetrahedron', 3463, *[1667, 1243, 1660, 1185], 1)
    ops.element('FourNodeTetrahedron', 3464, *[153, 152, 136, 1269], 1)
    ops.element('FourNodeTetrahedron', 3465, *[249, 1344, 219, 220], 1)
    ops.element('FourNodeTetrahedron', 3466, *[1285, 1344, 249, 220], 1)
    ops.element('FourNodeTetrahedron', 3467, *[1340, 1315, 375, 1375], 1)
    ops.element('FourNodeTetrahedron', 3468, *[1679, 327, 322, 1316], 1)
    ops.element('FourNodeTetrahedron', 3469, *[1544, 1468, 1555, 1281], 1)
    ops.element('FourNodeTetrahedron', 3470, *[1661, 1133, 1372, 350], 1)
    ops.element('FourNodeTetrahedron', 3471, *[624, 1511, 1408, 618], 1)
    ops.element('FourNodeTetrahedron', 3472, *[618, 1692, 1449, 620], 1)
    ops.element('FourNodeTetrahedron', 3473, *[1478, 1544, 1474, 1281], 1)
    ops.element('FourNodeTetrahedron', 3474, *[1333, 1569, 1397, 1387], 1)
    ops.element('FourNodeTetrahedron', 3475, *[1359, 1569, 1333, 1387], 1)
    ops.element('FourNodeTetrahedron', 3476, *[288, 1400, 1430, 1404], 1)
    ops.element('FourNodeTetrahedron', 3477, *[1434, 1206, 1718, 1430], 1)
    ops.element('FourNodeTetrahedron', 3478, *[1478, 1534, 1474, 1544], 1)
    ops.element('FourNodeTetrahedron', 3479, *[1257, 1236, 1348, 1145], 1)
    ops.element('FourNodeTetrahedron', 3480, *[1580, 1691, 416, 421], 1)
    ops.element('FourNodeTetrahedron', 3481, *[1478, 1617, 1534, 1544], 1)
    ops.element('FourNodeTetrahedron', 3482, *[482, 1521, 413, 414], 1)
    ops.element('FourNodeTetrahedron', 3483, *[1451, 1348, 1561, 1368], 1)
    ops.element('FourNodeTetrahedron', 3484, *[1193, 1372, 1602, 1661], 1)
    ops.element('FourNodeTetrahedron', 3485, *[758, 1416, 1415, 1287], 1)
    ops.element('FourNodeTetrahedron', 3486, *[1561, 1348, 1288, 1368], 1)
    ops.element('FourNodeTetrahedron', 3487, *[1449, 1692, 1461, 620], 1)
    ops.element('FourNodeTetrahedron', 3488, *[1741, 351, 355, 1392], 1)
    ops.element('FourNodeTetrahedron', 3489, *[1406, 1141, 1438, 1224], 1)
    ops.element('FourNodeTetrahedron', 3490, *[660, 654, 1736, 474], 1)
    ops.element('FourNodeTetrahedron', 3491, *[546, 1281, 533, 534], 1)
    ops.element('FourNodeTetrahedron', 3492, *[456, 1276, 449, 1299], 1)
    ops.element('FourNodeTetrahedron', 3493, *[1451, 1348, 1585, 1561], 1)
    ops.element('FourNodeTetrahedron', 3494, *[456, 1299, 449, 452], 1)
    ops.element('FourNodeTetrahedron', 3495, *[404, 1410, 405, 1340], 1)
    ops.element('FourNodeTetrahedron', 3496, *[613, 607, 1299, 452], 1)
    ops.element('FourNodeTetrahedron', 3497, *[1144, 1174, 1547, 1417], 1)
    ops.element('FourNodeTetrahedron', 3498, *[1331, 141, 140, 416], 1)
    ops.element('FourNodeTetrahedron', 3499, *[289, 1338, 284, 251], 1)
    ops.element('FourNodeTetrahedron', 3500, *[1142, 1171, 1659, 1253], 1)
    ops.element('FourNodeTetrahedron', 3501, *[720, 1260, 724, 1317], 1)
    ops.element('FourNodeTetrahedron', 3502, *[1368, 1167, 666, 684], 1)
    ops.element('FourNodeTetrahedron', 3503, *[1368, 1167, 1274, 666], 1)
    ops.element('FourNodeTetrahedron', 3504, *[1368, 1274, 665, 666], 1)
    ops.element('FourNodeTetrahedron', 3505, *[1307, 1173, 1302, 1151], 1)
    ops.element('FourNodeTetrahedron', 3506, *[1662, 1552, 461, 465], 1)
    ops.element('FourNodeTetrahedron', 3507, *[1368, 1257, 1274, 1167], 1)
    ops.element('FourNodeTetrahedron', 3508, *[186, 182, 185, 1279], 1)
    ops.element('FourNodeTetrahedron', 3509, *[252, 1323, 256, 1539], 1)
    ops.element('FourNodeTetrahedron', 3510, *[1257, 1274, 1348, 1368], 1)
    ops.element('FourNodeTetrahedron', 3511, *[1462, 371, 358, 1685], 1)
    ops.element('FourNodeTetrahedron', 3512, *[1527, 386, 412, 1521], 1)
    ops.element('FourNodeTetrahedron', 3513, *[1674, 159, 160, 156], 1)
    ops.element('FourNodeTetrahedron', 3514, *[1451, 1257, 1348, 1368], 1)
    ops.element('FourNodeTetrahedron', 3515, *[1348, 1274, 1288, 1368], 1)
    ops.element('FourNodeTetrahedron', 3516, *[272, 1317, 1531, 1391], 1)
    ops.element('FourNodeTetrahedron', 3517, *[1722, 1130, 1454, 1522], 1)
    ops.element('FourNodeTetrahedron', 3518, *[1204, 1130, 1722, 1522], 1)
    ops.element('FourNodeTetrahedron', 3519, *[296, 1309, 293, 1378], 1)
    ops.element('FourNodeTetrahedron', 3520, *[1586, 1499, 1629, 1654], 1)
    ops.element('FourNodeTetrahedron', 3521, *[1716, 1512, 1714, 1444], 1)
    ops.element('FourNodeTetrahedron', 3522, *[295, 291, 290, 1367], 1)
    ops.element('FourNodeTetrahedron', 3523, *[1337, 1575, 1553, 1560], 1)
    ops.element('FourNodeTetrahedron', 3524, *[1296, 433, 434, 438], 1)
    ops.element('FourNodeTetrahedron', 3525, *[1725, 1625, 1566, 1576], 1)
    ops.element('FourNodeTetrahedron', 3526, *[1735, 1672, 166, 1387], 1)
    ops.element('FourNodeTetrahedron', 3527, *[1296, 433, 438, 437], 1)
    ops.element('FourNodeTetrahedron', 3528, *[704, 702, 705, 1402], 1)
    ops.element('FourNodeTetrahedron', 3529, *[545, 1636, 1474, 546], 1)
    ops.element('FourNodeTetrahedron', 3530, *[549, 1596, 1603, 1293], 1)
    ops.element('FourNodeTetrahedron', 3531, *[756, 382, 1666, 1470], 1)
    ops.element('FourNodeTetrahedron', 3532, *[621, 1194, 1709, 622], 1)
    ops.element('FourNodeTetrahedron', 3533, *[1514, 1505, 1559, 1636], 1)
    ops.element('FourNodeTetrahedron', 3534, *[1669, 308, 348, 1262], 1)
    ops.element('FourNodeTetrahedron', 3535, *[512, 1158, 521, 511], 1)
    ops.element('FourNodeTetrahedron', 3536, *[1442, 1236, 1411, 1348], 1)
    ops.element('FourNodeTetrahedron', 3537, *[327, 1316, 323, 1282], 1)
    ops.element('FourNodeTetrahedron', 3538, *[1434, 1466, 1399, 1718], 1)
    ops.element('FourNodeTetrahedron', 3539, *[744, 383, 382, 390], 1)
    ops.element('FourNodeTetrahedron', 3540, *[1597, 1459, 1689, 672], 1)
    ops.element('FourNodeTetrahedron', 3541, *[1293, 1427, 1576, 531], 1)
    ops.element('FourNodeTetrahedron', 3542, *[463, 1316, 323, 464], 1)
    ops.element('FourNodeTetrahedron', 3543, *[649, 1457, 1301, 626], 1)
    ops.element('FourNodeTetrahedron', 3544, *[1603, 1567, 1473, 1291], 1)
    ops.element('FourNodeTetrahedron', 3545, *[1464, 1496, 1301, 1492], 1)
    ops.element('FourNodeTetrahedron', 3546, *[1703, 1228, 710, 1439], 1)
    ops.element('FourNodeTetrahedron', 3547, *[1575, 1630, 1553, 1560], 1)
    ops.element('FourNodeTetrahedron', 3548, *[1604, 1630, 1575, 1560], 1)
    ops.element('FourNodeTetrahedron', 3549, *[655, 1687, 1663, 476], 1)
    ops.element('FourNodeTetrahedron', 3550, *[1521, 386, 393, 413], 1)
    ops.element('FourNodeTetrahedron', 3551, *[1294, 1704, 1384, 1687], 1)
    ops.element('FourNodeTetrahedron', 3552, *[1704, 1687, 655, 656], 1)
    ops.element('FourNodeTetrahedron', 3553, *[1493, 1150, 1222, 1229], 1)
    ops.element('FourNodeTetrahedron', 3554, *[741, 336, 337, 1320], 1)
    ops.element('FourNodeTetrahedron', 3555, *[299, 297, 296, 1401], 1)
    ops.element('FourNodeTetrahedron', 3556, *[1704, 656, 655, 662], 1)
    ops.element('FourNodeTetrahedron', 3557, *[1175, 1137, 1444, 1181], 1)
    ops.element('FourNodeTetrahedron', 3558, *[1292, 1288, 1436, 658], 1)
    ops.element('FourNodeTetrahedron', 3559, *[742, 741, 1320, 1161], 1)
    ops.element('FourNodeTetrahedron', 3560, *[1673, 532, 1249, 525], 1)
    ops.element('FourNodeTetrahedron', 3561, *[1415, 1485, 744, 390], 1)
    ops.element('FourNodeTetrahedron', 3562, *[1283, 1545, 1544, 1498], 1)
    ops.element('FourNodeTetrahedron', 3563, *[513, 1150, 519, 512], 1)
    ops.element('FourNodeTetrahedron', 3564, *[1497, 403, 373, 374], 1)
    ops.element('FourNodeTetrahedron', 3565, *[719, 1531, 240, 271], 1)
    ops.element('FourNodeTetrahedron', 3566, *[1525, 1220, 1429, 1447], 1)
    ops.element('FourNodeTetrahedron', 3567, *[1626, 1566, 1298, 1580], 1)
    ops.element('FourNodeTetrahedron', 3568, *[614, 608, 1504, 607], 1)
    ops.element('FourNodeTetrahedron', 3569, *[1497, 1447, 1592, 1600], 1)
    ops.element('FourNodeTetrahedron', 3570, *[1506, 1596, 1603, 549], 1)
    ops.element('FourNodeTetrahedron', 3571, *[232, 1371, 230, 1559], 1)
    ops.element('FourNodeTetrahedron', 3572, *[1626, 1566, 1580, 1488], 1)
    ops.element('FourNodeTetrahedron', 3573, *[1565, 1583, 1557, 1727], 1)
    ops.element('FourNodeTetrahedron', 3574, *[517, 1614, 1518, 1613], 1)
    ops.element('FourNodeTetrahedron', 3575, *[277, 1399, 1565, 278], 1)
    ops.element('FourNodeTetrahedron', 3576, *[1444, 1137, 1512, 1181], 1)
    ops.element('FourNodeTetrahedron', 3577, *[1175, 1181, 1444, 630], 1)
    ops.element('FourNodeTetrahedron', 3578, *[440, 1296, 434, 438], 1)
    ops.element('FourNodeTetrahedron', 3579, *[1271, 1269, 180, 1532], 1)
    ops.element('FourNodeTetrahedron', 3580, *[1431, 1175, 1444, 630], 1)
    ops.element('FourNodeTetrahedron', 3581, *[1309, 1440, 1369, 1487], 1)
    ops.element('FourNodeTetrahedron', 3582, *[1309, 1240, 1306, 1440], 1)
    ops.element('FourNodeTetrahedron', 3583, *[1309, 1306, 1369, 1440], 1)
    ops.element('FourNodeTetrahedron', 3584, *[246, 1349, 1333, 1391], 1)
    ops.element('FourNodeTetrahedron', 3585, *[1306, 1205, 1432, 1440], 1)
    ops.element('FourNodeTetrahedron', 3586, *[1240, 1205, 1306, 1440], 1)
    ops.element('FourNodeTetrahedron', 3587, *[649, 629, 1457, 626], 1)
    ops.element('FourNodeTetrahedron', 3588, *[1306, 1123, 1432, 1205], 1)
    ops.element('FourNodeTetrahedron', 3589, *[545, 1347, 440, 1296], 1)
    ops.element('FourNodeTetrahedron', 3590, *[1240, 1205, 1440, 1138], 1)
    ops.element('FourNodeTetrahedron', 3591, *[1649, 1700, 1460, 1702], 1)
    ops.element('FourNodeTetrahedron', 3592, *[1242, 1147, 1311, 1466], 1)
    ops.element('FourNodeTetrahedron', 3593, *[1121, 1225, 1315, 1234], 1)
    ops.element('FourNodeTetrahedron', 3594, *[1121, 1315, 1375, 1234], 1)
    ops.element('FourNodeTetrahedron', 3595, *[1121, 1225, 1340, 1315], 1)
    ops.element('FourNodeTetrahedron', 3596, *[1121, 1315, 1340, 1375], 1)
    ops.element('FourNodeTetrahedron', 3597, *[1621, 1530, 1412, 1618], 1)
    ops.element('FourNodeTetrahedron', 3598, *[1460, 1594, 1724, 1426], 1)
    ops.element('FourNodeTetrahedron', 3599, *[1544, 1542, 1491, 1515], 1)
    ops.element('FourNodeTetrahedron', 3600, *[339, 1658, 338, 342], 1)
    ops.element('FourNodeTetrahedron', 3601, *[1653, 1731, 1622, 1621], 1)
    ops.element('FourNodeTetrahedron', 3602, *[1432, 1203, 1475, 1231], 1)
    ops.element('FourNodeTetrahedron', 3603, *[720, 725, 724, 1260], 1)
    ops.element('FourNodeTetrahedron', 3604, *[1342, 1589, 1456, 1475], 1)
    ops.element('FourNodeTetrahedron', 3605, *[1487, 1138, 1440, 1433], 1)
    ops.element('FourNodeTetrahedron', 3606, *[1388, 1564, 1401, 1574], 1)
    ops.element('FourNodeTetrahedron', 3607, *[368, 1329, 1739, 1301], 1)
    ops.element('FourNodeTetrahedron', 3608, *[1388, 1401, 300, 1336], 1)
    ops.element('FourNodeTetrahedron', 3609, *[280, 732, 729, 1428], 1)
    ops.element('FourNodeTetrahedron', 3610, *[1131, 1471, 1564, 1574], 1)
    ops.element('FourNodeTetrahedron', 3611, *[1286, 389, 381, 388], 1)
    ops.element('FourNodeTetrahedron', 3612, *[1689, 1335, 487, 1278], 1)
    ops.element('FourNodeTetrahedron', 3613, *[1231, 1216, 1486, 1156], 1)
    ops.element('FourNodeTetrahedron', 3614, *[1480, 1722, 1604, 1456], 1)
    ops.element('FourNodeTetrahedron', 3615, *[1358, 138, 188, 1318], 1)
    ops.element('FourNodeTetrahedron', 3616, *[1138, 1231, 1433, 1156], 1)
    ops.element('FourNodeTetrahedron', 3617, *[1332, 1504, 1284, 1551], 1)
    ops.element('FourNodeTetrahedron', 3618, *[1606, 1611, 350, 353], 1)
    ops.element('FourNodeTetrahedron', 3619, *[1433, 1231, 1486, 1156], 1)
    ops.element('FourNodeTetrahedron', 3620, *[1676, 1160, 645, 651], 1)
    ops.element('FourNodeTetrahedron', 3621, *[1496, 1457, 1301, 1492], 1)
    ops.element('FourNodeTetrahedron', 3622, *[399, 1163, 1124, 1582], 1)
    ops.element('FourNodeTetrahedron', 3623, *[302, 1377, 303, 454], 1)
    ops.element('FourNodeTetrahedron', 3624, *[1124, 1245, 351, 1741], 1)
    ops.element('FourNodeTetrahedron', 3625, *[1146, 1126, 1451, 1257], 1)
    ops.element('FourNodeTetrahedron', 3626, *[1420, 606, 1503, 605], 1)
    ops.element('FourNodeTetrahedron', 3627, *[216, 1387, 174, 173], 1)
    ops.element('FourNodeTetrahedron', 3628, *[368, 1496, 1329, 1301], 1)
    ops.element('FourNodeTetrahedron', 3629, *[1493, 1222, 1447, 1451], 1)
    ops.element('FourNodeTetrahedron', 3630, *[1468, 522, 431, 436], 1)
    ops.element('FourNodeTetrahedron', 3631, *[1496, 1329, 1301, 1457], 1)
    ops.element('FourNodeTetrahedron', 3632, *[1496, 1423, 1329, 1431], 1)
    ops.element('FourNodeTetrahedron', 3633, *[1496, 1431, 1329, 1457], 1)
    ops.element('FourNodeTetrahedron', 3634, *[362, 1496, 368, 1464], 1)
    ops.element('FourNodeTetrahedron', 3635, *[1341, 1381, 332, 1423], 1)
    ops.element('FourNodeTetrahedron', 3636, *[1169, 1213, 1416, 1258], 1)
    ops.element('FourNodeTetrahedron', 3637, *[1560, 1588, 1268, 1653], 1)
    ops.element('FourNodeTetrahedron', 3638, *[1214, 1255, 1406, 1454], 1)
    ops.element('FourNodeTetrahedron', 3639, *[376, 1341, 332, 1612], 1)
    ops.element('FourNodeTetrahedron', 3640, *[376, 332, 328, 1612], 1)
    ops.element('FourNodeTetrahedron', 3641, *[524, 417, 422, 525], 1)
    ops.element('FourNodeTetrahedron', 3642, *[1378, 1554, 1334, 1717], 1)
    ops.element('FourNodeTetrahedron', 3643, *[1494, 1469, 1528, 1597], 1)
    ops.element('FourNodeTetrahedron', 3644, *[1545, 1488, 1498, 529], 1)
    ops.element('FourNodeTetrahedron', 3645, *[1291, 1488, 1545, 529], 1)
    ops.element('FourNodeTetrahedron', 3646, *[1324, 1310, 1353, 1634], 1)
    ops.element('FourNodeTetrahedron', 3647, *[1333, 708, 707, 1397], 1)
    ops.element('FourNodeTetrahedron', 3648, *[1290, 1535, 1360, 1562], 1)
    ops.element('FourNodeTetrahedron', 3649, *[1343, 1683, 255, 1711], 1)
    ops.element('FourNodeTetrahedron', 3650, *[676, 674, 1702, 677], 1)
    ops.element('FourNodeTetrahedron', 3651, *[1368, 1257, 1167, 684], 1)
    ops.element('FourNodeTetrahedron', 3652, *[1503, 549, 1506, 604], 1)
    ops.element('FourNodeTetrahedron', 3653, *[1604, 1453, 1607, 1630], 1)
    ops.element('FourNodeTetrahedron', 3654, *[1270, 145, 418, 419], 1)
    ops.element('FourNodeTetrahedron', 3655, *[261, 236, 1744, 237], 1)
    ops.element('FourNodeTetrahedron', 3656, *[512, 1150, 519, 1493], 1)
    ops.element('FourNodeTetrahedron', 3657, *[1572, 1489, 1322, 1364], 1)
    ops.element('FourNodeTetrahedron', 3658, *[1541, 1624, 1271, 1621], 1)
    ops.element('FourNodeTetrahedron', 3659, *[770, 761, 1738, 1300], 1)
    ops.element('FourNodeTetrahedron', 3660, *[481, 1527, 411, 412], 1)
    ops.element('FourNodeTetrahedron', 3661, *[1465, 400, 356, 407], 1)
    ops.element('FourNodeTetrahedron', 3662, *[331, 300, 301, 1336], 1)
    ops.element('FourNodeTetrahedron', 3663, *[1204, 1130, 1522, 1215], 1)
    ops.element('FourNodeTetrahedron', 3664, *[1272, 1370, 153, 1271], 1)
    ops.element('FourNodeTetrahedron', 3665, *[1135, 1615, 1524, 1155], 1)
    ops.element('FourNodeTetrahedron', 3666, *[1272, 1370, 158, 153], 1)
    ops.element('FourNodeTetrahedron', 3667, *[1370, 158, 153, 152], 1)
    ops.element('FourNodeTetrahedron', 3668, *[1486, 1216, 1524, 1420], 1)
    ops.element('FourNodeTetrahedron', 3669, *[135, 179, 180, 1271], 1)
    ops.element('FourNodeTetrahedron', 3670, *[517, 1518, 1650, 1613], 1)
    ops.element('FourNodeTetrahedron', 3671, *[492, 1465, 489, 491], 1)
    ops.element('FourNodeTetrahedron', 3672, *[526, 1238, 423, 424], 1)
    ops.element('FourNodeTetrahedron', 3673, *[1228, 1157, 1599, 1141], 1)
    ops.element('FourNodeTetrahedron', 3674, *[1463, 1693, 1477, 608], 1)
    ops.element('FourNodeTetrahedron', 3675, *[1579, 749, 750, 1153], 1)
    ops.element('FourNodeTetrahedron', 3676, *[1330, 1710, 1345, 1583], 1)
    ops.element('FourNodeTetrahedron', 3677, *[1581, 1548, 1419, 1327], 1)
    ops.element('FourNodeTetrahedron', 3678, *[446, 1313, 601, 545], 1)
    ops.element('FourNodeTetrahedron', 3679, *[1439, 1228, 1346, 1599], 1)
    ops.element('FourNodeTetrahedron', 3680, *[670, 1707, 667, 668], 1)
    ops.element('FourNodeTetrahedron', 3681, *[1291, 1725, 1488, 1576], 1)
    ops.element('FourNodeTetrahedron', 3682, *[1251, 1208, 1456, 1204], 1)
    ops.element('FourNodeTetrahedron', 3683, *[1293, 1576, 1291, 530], 1)
    ops.element('FourNodeTetrahedron', 3684, *[530, 1576, 1488, 524], 1)
    ops.element('FourNodeTetrahedron', 3685, *[1647, 1525, 1497, 1614], 1)
    ops.element('FourNodeTetrahedron', 3686, *[1647, 1497, 1518, 1614], 1)
    ops.element('FourNodeTetrahedron', 3687, *[1588, 1370, 1272, 1624], 1)
    ops.element('FourNodeTetrahedron', 3688, *[1588, 1641, 1370, 1624], 1)
    ops.element('FourNodeTetrahedron', 3689, *[1446, 1384, 1393, 1294], 1)
    ops.element('FourNodeTetrahedron', 3690, *[724, 212, 245, 1531], 1)
    ops.element('FourNodeTetrahedron', 3691, *[1319, 1684, 458, 618], 1)
    ops.element('FourNodeTetrahedron', 3692, *[1662, 626, 1301, 649], 1)
    ops.element('FourNodeTetrahedron', 3693, *[1376, 1495, 150, 1549], 1)
    ops.element('FourNodeTetrahedron', 3694, *[748, 749, 746, 1579], 1)
    ops.element('FourNodeTetrahedron', 3695, *[304, 1276, 250, 456], 1)
    ops.element('FourNodeTetrahedron', 3696, *[272, 1565, 1391, 273], 1)
    ops.element('FourNodeTetrahedron', 3697, *[458, 1684, 620, 618], 1)
    ops.element('FourNodeTetrahedron', 3698, *[301, 1408, 294, 1319], 1)
    ops.element('FourNodeTetrahedron', 3699, *[754, 380, 753, 1664], 1)
    ops.element('FourNodeTetrahedron', 3700, *[1162, 1163, 1590, 1414], 1)
    ops.element('FourNodeTetrahedron', 3701, *[1624, 1641, 1370, 1622], 1)
    ops.element('FourNodeTetrahedron', 3702, *[728, 718, 727, 1252], 1)
    ops.element('FourNodeTetrahedron', 3703, *[1326, 154, 138, 1318], 1)
    ops.element('FourNodeTetrahedron', 3704, *[213, 1333, 1740, 214], 1)
    ops.element('FourNodeTetrahedron', 3705, *[1230, 1200, 1417, 1726], 1)
    ops.element('FourNodeTetrahedron', 3706, *[1500, 1681, 397, 1435], 1)
    ops.element('FourNodeTetrahedron', 3707, *[1274, 1254, 1259, 666], 1)
    ops.element('FourNodeTetrahedron', 3708, *[1469, 1446, 1685, 1459], 1)
    ops.element('FourNodeTetrahedron', 3709, *[1411, 1244, 1366, 1297], 1)
    ops.element('FourNodeTetrahedron', 3710, *[1588, 1654, 1721, 1641], 1)
    ops.element('FourNodeTetrahedron', 3711, *[1583, 1333, 1349, 1391], 1)
    ops.element('FourNodeTetrahedron', 3712, *[1623, 1412, 1713, 1618], 1)
    ops.element('FourNodeTetrahedron', 3713, *[1700, 1627, 678, 681], 1)
    ops.element('FourNodeTetrahedron', 3714, *[1363, 217, 247, 248], 1)
    ops.element('FourNodeTetrahedron', 3715, *[1319, 1684, 454, 458], 1)
    ops.element('FourNodeTetrahedron', 3716, *[1445, 1373, 1384, 1704], 1)
    ops.element('FourNodeTetrahedron', 3717, *[1346, 704, 705, 1402], 1)
    ops.element('FourNodeTetrahedron', 3718, *[1642, 1729, 1536, 1502], 1)
    ops.element('FourNodeTetrahedron', 3719, *[1319, 1377, 454, 1684], 1)
    ops.element('FourNodeTetrahedron', 3720, *[628, 1696, 624, 631], 1)
    ops.element('FourNodeTetrahedron', 3721, *[1273, 1665, 187, 1277], 1)
    ops.element('FourNodeTetrahedron', 3722, *[1654, 1513, 1721, 1641], 1)
    ops.element('FourNodeTetrahedron', 3723, *[1344, 1356, 218, 1272], 1)
    ops.element('FourNodeTetrahedron', 3724, *[1494, 1732, 521, 1702], 1)
    ops.element('FourNodeTetrahedron', 3725, *[513, 1525, 1647, 1150], 1)
    ops.element('FourNodeTetrahedron', 3726, *[1588, 1721, 1370, 1641], 1)
    ops.element('FourNodeTetrahedron', 3727, *[1716, 1137, 1512, 1444], 1)
    ops.element('FourNodeTetrahedron', 3728, *[154, 140, 138, 1318], 1)
    ops.element('FourNodeTetrahedron', 3729, *[358, 365, 364, 1446], 1)
    ops.element('FourNodeTetrahedron', 3730, *[314, 1394, 319, 297], 1)
    ops.element('FourNodeTetrahedron', 3731, *[1589, 1251, 1456, 1475], 1)
    ops.element('FourNodeTetrahedron', 3732, *[1455, 647, 1362, 646], 1)
    ops.element('FourNodeTetrahedron', 3733, *[1682, 1332, 1551, 614], 1)
    ops.element('FourNodeTetrahedron', 3734, *[1653, 1645, 1641, 1731], 1)
    ops.element('FourNodeTetrahedron', 3735, *[1415, 1485, 390, 1500], 1)
    ops.element('FourNodeTetrahedron', 3736, *[1202, 1251, 1589, 1203], 1)
    ops.element('FourNodeTetrahedron', 3737, *[1338, 1203, 1589, 1475], 1)
    ops.element('FourNodeTetrahedron', 3738, *[1149, 178, 155, 1190], 1)
    ops.element('FourNodeTetrahedron', 3739, *[1123, 1202, 1589, 1203], 1)
    ops.element('FourNodeTetrahedron', 3740, *[1474, 1534, 1277, 1555], 1)
    ops.element('FourNodeTetrahedron', 3741, *[1474, 1534, 1555, 1544], 1)
    ops.element('FourNodeTetrahedron', 3742, *[1188, 1227, 1394, 1184], 1)
    ops.element('FourNodeTetrahedron', 3743, *[1290, 1535, 1562, 1504], 1)
    ops.element('FourNodeTetrahedron', 3744, *[1290, 1360, 1284, 1562], 1)
    ops.element('FourNodeTetrahedron', 3745, *[1585, 1543, 1292, 1288], 1)
    ops.element('FourNodeTetrahedron', 3746, *[1585, 1288, 1292, 1561], 1)
    ops.element('FourNodeTetrahedron', 3747, *[732, 730, 1428, 1302], 1)
    ops.element('FourNodeTetrahedron', 3748, *[1280, 1298, 141, 1331], 1)
    ops.element('FourNodeTetrahedron', 3749, *[1393, 470, 469, 1529], 1)
    ops.element('FourNodeTetrahedron', 3750, *[1459, 1393, 1278, 1529], 1)
    ops.element('FourNodeTetrahedron', 3751, *[669, 661, 1529, 660], 1)
    ops.element('FourNodeTetrahedron', 3752, *[1448, 1627, 1700, 681], 1)
    ops.element('FourNodeTetrahedron', 3753, *[1393, 1663, 470, 1529], 1)
    ops.element('FourNodeTetrahedron', 3754, *[1393, 1294, 1384, 1663], 1)
    ops.element('FourNodeTetrahedron', 3755, *[147, 146, 145, 1270], 1)
    ops.element('FourNodeTetrahedron', 3756, *[377, 368, 1301, 1362], 1)
    ops.element('FourNodeTetrahedron', 3757, *[1448, 681, 1700, 677], 1)
    ops.element('FourNodeTetrahedron', 3758, *[1371, 1374, 1713, 1623], 1)
    ops.element('FourNodeTetrahedron', 3759, *[1332, 1504, 1551, 614], 1)
    ops.element('FourNodeTetrahedron', 3760, *[1551, 1504, 607, 614], 1)
    ops.element('FourNodeTetrahedron', 3761, *[304, 1276, 456, 1551], 1)
    ops.element('FourNodeTetrahedron', 3762, *[1700, 681, 678, 677], 1)
    ops.element('FourNodeTetrahedron', 3763, *[455, 1332, 304, 1551], 1)
    ops.element('FourNodeTetrahedron', 3764, *[275, 1651, 271, 276], 1)
    ops.element('FourNodeTetrahedron', 3765, *[1310, 1285, 1546, 1548], 1)
    ops.element('FourNodeTetrahedron', 3766, *[1310, 1548, 1285, 1327], 1)
    ops.element('FourNodeTetrahedron', 3767, *[361, 1680, 367, 1450], 1)
    ops.element('FourNodeTetrahedron', 3768, *[1424, 1585, 1292, 1561], 1)
    ops.element('FourNodeTetrahedron', 3769, *[1465, 1650, 371, 1462], 1)
    ops.element('FourNodeTetrahedron', 3770, *[1285, 1560, 1546, 1548], 1)
    ops.element('FourNodeTetrahedron', 3771, *[1652, 1619, 1628, 1617], 1)
    ops.element('FourNodeTetrahedron', 3772, *[1290, 1562, 1284, 1504], 1)
    ops.element('FourNodeTetrahedron', 3773, *[1348, 1236, 1411, 1297], 1)
    ops.element('FourNodeTetrahedron', 3774, *[405, 1595, 406, 376], 1)
    ops.element('FourNodeTetrahedron', 3775, *[1561, 1288, 664, 665], 1)
    ops.element('FourNodeTetrahedron', 3776, *[1417, 287, 316, 317], 1)
    ops.element('FourNodeTetrahedron', 3777, *[460, 613, 456, 452], 1)
    ops.element('FourNodeTetrahedron', 3778, *[664, 1288, 1292, 658], 1)
    ops.element('FourNodeTetrahedron', 3779, *[253, 1360, 1324, 1314], 1)
    ops.element('FourNodeTetrahedron', 3780, *[1646, 1490, 1728, 1519], 1)
    ops.element('FourNodeTetrahedron', 3781, *[1457, 1572, 1329, 1552], 1)
    ops.element('FourNodeTetrahedron', 3782, *[1454, 1130, 1719, 1646], 1)
    ops.element('FourNodeTetrahedron', 3783, *[1454, 1719, 1608, 1646], 1)
    ops.element('FourNodeTetrahedron', 3784, *[1454, 1719, 1639, 1608], 1)
    ops.element('FourNodeTetrahedron', 3785, *[1622, 1549, 1540, 1619], 1)
    ops.element('FourNodeTetrahedron', 3786, *[242, 1391, 246, 247], 1)
    ops.element('FourNodeTetrahedron', 3787, *[1406, 1224, 1438, 1719], 1)
    ops.element('FourNodeTetrahedron', 3788, *[1322, 1316, 463, 1364], 1)
    ops.element('FourNodeTetrahedron', 3789, *[1322, 1316, 322, 463], 1)
    ops.element('FourNodeTetrahedron', 3790, *[322, 1316, 323, 463], 1)
    ops.element('FourNodeTetrahedron', 3791, *[322, 327, 323, 1316], 1)
    ops.element('FourNodeTetrahedron', 3792, *[648, 1398, 1675, 629], 1)
    ops.element('FourNodeTetrahedron', 3793, *[1645, 1641, 1588, 1653], 1)
    ops.element('FourNodeTetrahedron', 3794, *[525, 1238, 418, 423], 1)
    ops.element('FourNodeTetrahedron', 3795, *[1238, 418, 423, 424], 1)
    ops.element('FourNodeTetrahedron', 3796, *[1597, 1469, 672, 671], 1)
    ops.element('FourNodeTetrahedron', 3797, *[677, 678, 1700, 674], 1)
    ops.element('FourNodeTetrahedron', 3798, *[1459, 1294, 1393, 1529], 1)
    ops.element('FourNodeTetrahedron', 3799, *[1459, 1294, 1529, 661], 1)
    ops.element('FourNodeTetrahedron', 3800, *[269, 256, 268, 1321], 1)
    ops.element('FourNodeTetrahedron', 3801, *[1585, 1421, 1550, 1543], 1)
    ops.element('FourNodeTetrahedron', 3802, *[1485, 384, 383, 391], 1)
    ops.element('FourNodeTetrahedron', 3803, *[449, 1276, 1539, 1299], 1)
    ops.element('FourNodeTetrahedron', 3804, *[1541, 1624, 1272, 1271], 1)
    ops.element('FourNodeTetrahedron', 3805, *[374, 1631, 361, 1421], 1)
    ops.element('FourNodeTetrahedron', 3806, *[1475, 1135, 1615, 1524], 1)
    ops.element('FourNodeTetrahedron', 3807, *[1376, 150, 151, 1549], 1)
    ops.element('FourNodeTetrahedron', 3808, *[1459, 1529, 1278, 669], 1)
    ops.element('FourNodeTetrahedron', 3809, *[1529, 661, 660, 654], 1)
    ops.element('FourNodeTetrahedron', 3810, *[1442, 1223, 1411, 1236], 1)
    ops.element('FourNodeTetrahedron', 3811, *[1278, 479, 480, 474], 1)
    ops.element('FourNodeTetrahedron', 3812, *[1447, 1429, 1442, 1126], 1)
    ops.element('FourNodeTetrahedron', 3813, *[1682, 1332, 455, 1551], 1)
    ops.element('FourNodeTetrahedron', 3814, *[1429, 1223, 1442, 1126], 1)
    ops.element('FourNodeTetrahedron', 3815, *[1161, 1192, 1320, 1372], 1)
    ops.element('FourNodeTetrahedron', 3816, *[341, 1192, 1351, 1197], 1)
    ops.element('FourNodeTetrahedron', 3817, *[1286, 1666, 381, 389], 1)
    ops.element('FourNodeTetrahedron', 3818, *[1372, 1192, 341, 1197], 1)
    ops.element('FourNodeTetrahedron', 3819, *[392, 1668, 1590, 1414], 1)
    ops.element('FourNodeTetrahedron', 3820, *[1542, 1580, 1331, 1515], 1)
    ops.element('FourNodeTetrahedron', 3821, *[1320, 1192, 1351, 341], 1)
    ops.element('FourNodeTetrahedron', 3822, *[1279, 1261, 185, 1358], 1)
    ops.element('FourNodeTetrahedron', 3823, *[1372, 1197, 1669, 1187], 1)
    ops.element('FourNodeTetrahedron', 3824, *[743, 1602, 1658, 1193], 1)
    ops.element('FourNodeTetrahedron', 3825, *[220, 1541, 222, 229], 1)
    ops.element('FourNodeTetrahedron', 3826, *[1401, 1564, 1471, 1574], 1)
    ops.element('FourNodeTetrahedron', 3827, *[1600, 1447, 1451, 1585], 1)
    ops.element('FourNodeTetrahedron', 3828, *[1656, 169, 170, 164], 1)
    ops.element('FourNodeTetrahedron', 3829, *[1182, 1564, 1388, 1574], 1)
    ops.element('FourNodeTetrahedron', 3830, *[313, 1726, 317, 318], 1)
    ops.element('FourNodeTetrahedron', 3831, *[1458, 1726, 313, 1577], 1)
    ops.element('FourNodeTetrahedron', 3832, *[261, 262, 1737, 1324], 1)
    ops.element('FourNodeTetrahedron', 3833, *[1305, 1559, 1347, 1636], 1)
    ops.element('FourNodeTetrahedron', 3834, *[1739, 1329, 1322, 1301], 1)
    ops.element('FourNodeTetrahedron', 3835, *[486, 1689, 487, 669], 1)
    ops.element('FourNodeTetrahedron', 3836, *[1511, 1709, 1701, 617], 1)
    ops.element('FourNodeTetrahedron', 3837, *[1279, 185, 1355, 1358], 1)
    ops.element('FourNodeTetrahedron', 3838, *[1601, 487, 409, 486], 1)
    ops.element('FourNodeTetrahedron', 3839, *[1377, 1289, 1332, 1461], 1)
    ops.element('FourNodeTetrahedron', 3840, *[1377, 1715, 1289, 1461], 1)
    ops.element('FourNodeTetrahedron', 3841, *[1319, 1377, 302, 454], 1)
    ops.element('FourNodeTetrahedron', 3842, *[1484, 1536, 1505, 1697], 1)
    ops.element('FourNodeTetrahedron', 3843, *[1536, 1502, 1505, 1697], 1)
    ops.element('FourNodeTetrahedron', 3844, *[1494, 1460, 1469, 674], 1)
    ops.element('FourNodeTetrahedron', 3845, *[1634, 1502, 1536, 1697], 1)
    ops.element('FourNodeTetrahedron', 3846, *[1528, 1501, 1685, 1469], 1)
    ops.element('FourNodeTetrahedron', 3847, *[1484, 1634, 1536, 1697], 1)
    ops.element('FourNodeTetrahedron', 3848, *[1477, 1502, 1634, 1697], 1)
    ops.element('FourNodeTetrahedron', 3849, *[1484, 1477, 1634, 1697], 1)
    ops.element('FourNodeTetrahedron', 3850, *[1468, 432, 437, 436], 1)
    ops.element('FourNodeTetrahedron', 3851, *[746, 750, 1690, 1579], 1)
    ops.element('FourNodeTetrahedron', 3852, *[1543, 1411, 1366, 1297], 1)
    ops.element('FourNodeTetrahedron', 3853, *[1625, 1238, 418, 525], 1)
    ops.element('FourNodeTetrahedron', 3854, *[1735, 1672, 172, 166], 1)
    ops.element('FourNodeTetrahedron', 3855, *[527, 1468, 436, 437], 1)
    ops.element('FourNodeTetrahedron', 3856, *[1442, 1411, 1543, 1348], 1)
    ops.element('FourNodeTetrahedron', 3857, *[1526, 1509, 1516, 1647], 1)
    ops.element('FourNodeTetrahedron', 3858, *[1699, 1146, 684, 683], 1)
    ops.element('FourNodeTetrahedron', 3859, *[1247, 1163, 1414, 1582], 1)
    ops.element('FourNodeTetrahedron', 3860, *[1604, 1722, 1630, 1644], 1)
    ops.element('FourNodeTetrahedron', 3861, *[1648, 1191, 1646, 1519], 1)
    ops.element('FourNodeTetrahedron', 3862, *[551, 1688, 550, 1673], 1)
    ops.element('FourNodeTetrahedron', 3863, *[1413, 1330, 1583, 1570], 1)
    ops.element('FourNodeTetrahedron', 3864, *[1385, 754, 1664, 388], 1)
    ops.element('FourNodeTetrahedron', 3865, *[535, 1283, 528, 529], 1)
    ops.element('FourNodeTetrahedron', 3866, *[147, 145, 144, 1270], 1)
    ops.element('FourNodeTetrahedron', 3867, *[768, 763, 1385, 1573], 1)
    ops.element('FourNodeTetrahedron', 3868, *[1411, 1568, 1483, 1543], 1)
    ops.element('FourNodeTetrahedron', 3869, *[1717, 1334, 1367, 1715], 1)
    ops.element('FourNodeTetrahedron', 3870, *[1543, 1568, 1483, 1436], 1)
    ops.element('FourNodeTetrahedron', 3871, *[1525, 1221, 1429, 1220], 1)
    ops.element('FourNodeTetrahedron', 3872, *[1681, 1414, 392, 398], 1)
    ops.element('FourNodeTetrahedron', 3873, *[1735, 166, 174, 1387], 1)
    ops.element('FourNodeTetrahedron', 3874, *[1362, 649, 478, 646], 1)
    ops.element('FourNodeTetrahedron', 3875, *[368, 1739, 320, 1301], 1)
    ops.element('FourNodeTetrahedron', 3876, *[545, 1474, 1296, 1281], 1)
    ops.element('FourNodeTetrahedron', 3877, *[1543, 1411, 1568, 1366], 1)
    ops.element('FourNodeTetrahedron', 3878, *[1543, 1366, 1568, 1436], 1)
    ops.element('FourNodeTetrahedron', 3879, *[1543, 1297, 1366, 1436], 1)
    ops.element('FourNodeTetrahedron', 3880, *[1195, 1154, 1487, 1709], 1)
    ops.element('FourNodeTetrahedron', 3881, *[1233, 1227, 1577, 1394], 1)
    ops.element('FourNodeTetrahedron', 3882, *[546, 1478, 1281, 534], 1)
    ops.element('FourNodeTetrahedron', 3883, *[289, 1430, 284, 1338], 1)
    ops.element('FourNodeTetrahedron', 3884, *[1317, 724, 1531, 1349], 1)
    ops.element('FourNodeTetrahedron', 3885, *[720, 724, 719, 1317], 1)
    ops.element('FourNodeTetrahedron', 3886, *[1592, 1429, 1631, 1442], 1)
    ops.element('FourNodeTetrahedron', 3887, *[1725, 1625, 1556, 1566], 1)
    ops.element('FourNodeTetrahedron', 3888, *[1706, 1511, 1408, 1282], 1)
    ops.element('FourNodeTetrahedron', 3889, *[456, 1551, 1299, 613], 1)
    ops.element('FourNodeTetrahedron', 3890, *[1469, 1720, 1459, 1694], 1)
    ops.element('FourNodeTetrahedron', 3891, *[620, 615, 1461, 614], 1)
    ops.element('FourNodeTetrahedron', 3892, *[1480, 1209, 1481, 1453], 1)
    ops.element('FourNodeTetrahedron', 3893, *[534, 1283, 528, 535], 1)
    ops.element('FourNodeTetrahedron', 3894, *[1407, 1532, 184, 1273], 1)
    ops.element('FourNodeTetrahedron', 3895, *[271, 1317, 1531, 272], 1)
    ops.element('FourNodeTetrahedron', 3896, *[1336, 1558, 301, 1706], 1)
    ops.element('FourNodeTetrahedron', 3897, *[1616, 1518, 372, 1650], 1)
    ops.element('FourNodeTetrahedron', 3898, *[1557, 1607, 1723, 1730], 1)
    ops.element('FourNodeTetrahedron', 3899, *[140, 154, 1331, 1318], 1)
    ops.element('FourNodeTetrahedron', 3900, *[1478, 1617, 1544, 1283], 1)
    ops.element('FourNodeTetrahedron', 3901, *[1550, 1543, 1450, 1292], 1)
    ops.element('FourNodeTetrahedron', 3902, *[626, 1552, 466, 465], 1)
    ops.element('FourNodeTetrahedron', 3903, *[1534, 1538, 1355, 1555], 1)
    ops.element('FourNodeTetrahedron', 3904, *[1534, 1355, 1277, 1555], 1)
    ops.element('FourNodeTetrahedron', 3905, *[327, 1706, 301, 1282], 1)
    ops.element('FourNodeTetrahedron', 3906, *[1539, 1476, 1321, 1563], 1)
    ops.element('FourNodeTetrahedron', 3907, *[1376, 157, 152, 151], 1)
    ops.element('FourNodeTetrahedron', 3908, *[493, 1521, 482, 1465], 1)
    ops.element('FourNodeTetrahedron', 3909, *[1373, 1362, 472, 646], 1)
    ops.element('FourNodeTetrahedron', 3910, *[1416, 1213, 1452, 1258], 1)
    ops.element('FourNodeTetrahedron', 3911, *[1627, 1561, 1424, 678], 1)
    ops.element('FourNodeTetrahedron', 3912, *[1514, 1559, 1305, 1636], 1)
    ops.element('FourNodeTetrahedron', 3913, *[1514, 1636, 1305, 545], 1)
    ops.element('FourNodeTetrahedron', 3914, *[259, 1342, 1419, 1581], 1)
    ops.element('FourNodeTetrahedron', 3915, *[1478, 1473, 1617, 1283], 1)
    ops.element('FourNodeTetrahedron', 3916, *[1196, 1156, 1598, 611], 1)
    ops.element('FourNodeTetrahedron', 3917, *[1196, 1156, 1433, 1598], 1)
    ops.element('FourNodeTetrahedron', 3918, *[1522, 1454, 1645, 1646], 1)
    ops.element('FourNodeTetrahedron', 3919, *[1276, 1284, 1712, 1551], 1)
    ops.element('FourNodeTetrahedron', 3920, *[1598, 612, 616, 611], 1)
    ops.element('FourNodeTetrahedron', 3921, *[1156, 612, 1598, 611], 1)
    ops.element('FourNodeTetrahedron', 3922, *[1598, 612, 616, 610], 1)
    ops.element('FourNodeTetrahedron', 3923, *[1472, 1574, 1511, 1467], 1)
    ops.element('FourNodeTetrahedron', 3924, *[454, 1682, 455, 459], 1)
    ops.element('FourNodeTetrahedron', 3925, *[1682, 1551, 455, 459], 1)
    ops.element('FourNodeTetrahedron', 3926, *[713, 167, 1743, 175], 1)
    ops.element('FourNodeTetrahedron', 3927, *[1336, 1574, 1511, 1467], 1)
    ops.element('FourNodeTetrahedron', 3928, *[1336, 1574, 1471, 1511], 1)
    ops.element('FourNodeTetrahedron', 3929, *[255, 1683, 1383, 1711], 1)
    ops.element('FourNodeTetrahedron', 3930, *[1705, 718, 711, 710], 1)
    ops.element('FourNodeTetrahedron', 3931, *[1252, 718, 1705, 711], 1)
    ops.element('FourNodeTetrahedron', 3932, *[1504, 1477, 1695, 608], 1)
    ops.element('FourNodeTetrahedron', 3933, *[1463, 1477, 1504, 608], 1)
    ops.element('FourNodeTetrahedron', 3934, *[1510, 177, 159, 155], 1)
    ops.element('FourNodeTetrahedron', 3935, *[1392, 1241, 1741, 1671], 1)
    ops.element('FourNodeTetrahedron', 3936, *[1283, 1745, 1544, 528], 1)
    ops.element('FourNodeTetrahedron', 3937, *[1527, 387, 386, 1521], 1)
    ops.element('FourNodeTetrahedron', 3938, *[1695, 1477, 603, 608], 1)
    ops.element('FourNodeTetrahedron', 3939, *[767, 1527, 766, 1312], 1)
    ops.element('FourNodeTetrahedron', 3940, *[1244, 1132, 1366, 1160], 1)
    ops.element('FourNodeTetrahedron', 3941, *[727, 718, 717, 1705], 1)
    ops.element('FourNodeTetrahedron', 3942, *[1256, 1121, 1375, 1223], 1)
    ops.element('FourNodeTetrahedron', 3943, *[1476, 1514, 1313, 601], 1)
    ops.element('FourNodeTetrahedron', 3944, *[251, 255, 267, 1343], 1)
    ops.element('FourNodeTetrahedron', 3945, *[727, 1252, 718, 1705], 1)
    ops.element('FourNodeTetrahedron', 3946, *[313, 1577, 318, 314], 1)
    ops.element('FourNodeTetrahedron', 3947, *[455, 1551, 456, 460], 1)
    ops.element('FourNodeTetrahedron', 3948, *[460, 1551, 456, 613], 1)
    ops.element('FourNodeTetrahedron', 3949, *[455, 1551, 460, 459], 1)
    ops.element('FourNodeTetrahedron', 3950, *[460, 1551, 613, 459], 1)
    ops.element('FourNodeTetrahedron', 3951, *[1190, 178, 147, 146], 1)
    ops.element('FourNodeTetrahedron', 3952, *[325, 329, 326, 1403], 1)
    ops.element('FourNodeTetrahedron', 3953, *[1283, 1545, 1498, 529], 1)
    ops.element('FourNodeTetrahedron', 3954, *[747, 748, 758, 1416], 1)
    ops.element('FourNodeTetrahedron', 3955, *[1484, 1697, 1505, 602], 1)
    ops.element('FourNodeTetrahedron', 3956, *[1541, 1271, 222, 1412], 1)
    ops.element('FourNodeTetrahedron', 3957, *[1282, 1319, 298, 453], 1)
    ops.element('FourNodeTetrahedron', 3958, *[1593, 1472, 631, 634], 1)
    ops.element('FourNodeTetrahedron', 3959, *[1426, 663, 662, 675], 1)
    ops.element('FourNodeTetrahedron', 3960, *[707, 706, 171, 1672], 1)
    ops.element('FourNodeTetrahedron', 3961, *[1181, 1152, 1512, 1593], 1)
    ops.element('FourNodeTetrahedron', 3962, *[1497, 1592, 373, 1425], 1)
    ops.element('FourNodeTetrahedron', 3963, *[1365, 1675, 1398, 648], 1)
    ops.element('FourNodeTetrahedron', 3964, *[1379, 364, 363, 1335], 1)
    ops.element('FourNodeTetrahedron', 3965, *[1309, 1240, 1440, 1195], 1)
    ops.element('FourNodeTetrahedron', 3966, *[1321, 1313, 443, 1563], 1)
    ops.element('FourNodeTetrahedron', 3967, *[744, 746, 383, 1485], 1)
    ops.element('FourNodeTetrahedron', 3968, *[442, 1347, 225, 440], 1)
    ops.element('FourNodeTetrahedron', 3969, *[1444, 1181, 1512, 1593], 1)
    ops.element('FourNodeTetrahedron', 3970, *[1559, 1407, 230, 1347], 1)
    ops.element('FourNodeTetrahedron', 3971, *[1512, 1152, 1472, 1593], 1)
    ops.element('FourNodeTetrahedron', 3972, *[1538, 1318, 1358, 1491], 1)
    ops.element('FourNodeTetrahedron', 3973, *[1405, 1388, 1336, 1512], 1)
    ops.element('FourNodeTetrahedron', 3974, *[1646, 1719, 1608, 1490], 1)
    ops.element('FourNodeTetrahedron', 3975, *[1602, 742, 1161, 1193], 1)
    ops.element('FourNodeTetrahedron', 3976, *[1636, 1474, 1347, 545], 1)
    ops.element('FourNodeTetrahedron', 3977, *[1631, 1390, 1483, 1411], 1)
    ops.element('FourNodeTetrahedron', 3978, *[1379, 1459, 1335, 1689], 1)
    ops.element('FourNodeTetrahedron', 3979, *[1528, 1459, 1689, 1597], 1)
    ops.element('FourNodeTetrahedron', 3980, *[519, 1150, 1614, 1493], 1)
    ops.element('FourNodeTetrahedron', 3981, *[1633, 1325, 1570, 1466], 1)
    ops.element('FourNodeTetrahedron', 3982, *[1391, 1359, 247, 1363], 1)
    ops.element('FourNodeTetrahedron', 3983, *[757, 1470, 756, 1300], 1)
    ops.element('FourNodeTetrahedron', 3984, *[1724, 1425, 1445, 1594], 1)
    ops.element('FourNodeTetrahedron', 3985, *[1174, 1199, 735, 1357], 1)
    ops.element('FourNodeTetrahedron', 3986, *[1590, 1661, 347, 351], 1)
    ops.element('FourNodeTetrahedron', 3987, *[179, 182, 183, 1269], 1)
    ops.element('FourNodeTetrahedron', 3988, *[519, 1493, 1614, 521], 1)
    ops.element('FourNodeTetrahedron', 3989, *[1720, 1384, 1294, 1704], 1)
    ops.element('FourNodeTetrahedron', 3990, *[1278, 469, 474, 660], 1)
    ops.element('FourNodeTetrahedron', 3991, *[1720, 1445, 1384, 1704], 1)
    ops.element('FourNodeTetrahedron', 3992, *[1446, 1445, 1384, 1720], 1)
    ops.element('FourNodeTetrahedron', 3993, *[1665, 186, 189, 190], 1)
    ops.element('FourNodeTetrahedron', 3994, *[1380, 1528, 1520, 1707], 1)
    ops.element('FourNodeTetrahedron', 3995, *[187, 1665, 186, 190], 1)
    ops.element('FourNodeTetrahedron', 3996, *[1193, 1161, 1602, 1372], 1)
    ops.element('FourNodeTetrahedron', 3997, *[1202, 1208, 1480, 1589], 1)
    ops.element('FourNodeTetrahedron', 3998, *[1462, 357, 410, 1379], 1)
    ops.element('FourNodeTetrahedron', 3999, *[761, 757, 756, 1300], 1)
    ops.element('FourNodeTetrahedron', 4000, *[1555, 1358, 1355, 432], 1)
    ops.element('FourNodeTetrahedron', 4001, *[1538, 1491, 1358, 1555], 1)
    ops.element('FourNodeTetrahedron', 4002, *[398, 1414, 392, 399], 1)
    ops.element('FourNodeTetrahedron', 4003, *[1352, 1159, 1134, 513], 1)
    ops.element('FourNodeTetrahedron', 4004, *[762, 1300, 1303, 1573], 1)
    ops.element('FourNodeTetrahedron', 4005, *[1269, 1326, 1279, 1538], 1)
    ops.element('FourNodeTetrahedron', 4006, *[1260, 1345, 715, 1349], 1)
    ops.element('FourNodeTetrahedron', 4007, *[679, 1265, 677, 680], 1)
    ops.element('FourNodeTetrahedron', 4008, *[1537, 1536, 1353, 1634], 1)
    ops.element('FourNodeTetrahedron', 4009, *[238, 1313, 444, 443], 1)
    ops.element('FourNodeTetrahedron', 4010, *[1210, 1228, 1439, 1211], 1)
    ops.element('FourNodeTetrahedron', 4011, *[1475, 1204, 1456, 1615], 1)
    ops.element('FourNodeTetrahedron', 4012, *[1354, 1162, 1668, 1414], 1)
    ops.element('FourNodeTetrahedron', 4013, *[1360, 1620, 1324, 1562], 1)
    ops.element('FourNodeTetrahedron', 4014, *[1135, 1215, 1615, 1155], 1)
    ops.element('FourNodeTetrahedron', 4015, *[1559, 1618, 1407, 1636], 1)
    ops.element('FourNodeTetrahedron', 4016, *[679, 1265, 1734, 677], 1)
    ops.element('FourNodeTetrahedron', 4017, *[1607, 1453, 1587, 1630], 1)
    ops.element('FourNodeTetrahedron', 4018, *[1447, 1442, 1592, 1585], 1)
    ops.element('FourNodeTetrahedron', 4019, *[1493, 1222, 1451, 1146], 1)
    ops.element('FourNodeTetrahedron', 4020, *[1215, 1646, 1522, 1648], 1)
    ops.element('FourNodeTetrahedron', 4021, *[670, 1707, 1380, 667], 1)
    ops.element('FourNodeTetrahedron', 4022, *[1147, 1252, 1705, 1210], 1)
    ops.element('FourNodeTetrahedron', 4023, *[1461, 1637, 1463, 615], 1)
    ops.element('FourNodeTetrahedron', 4024, *[1347, 1273, 224, 1277], 1)
    ops.element('FourNodeTetrahedron', 4025, *[1151, 1173, 1302, 1242], 1)
    ops.element('FourNodeTetrahedron', 4026, *[1547, 739, 734, 1174], 1)
    ops.element('FourNodeTetrahedron', 4027, *[1357, 1136, 1434, 1400], 1)
    ops.element('FourNodeTetrahedron', 4028, *[1442, 1411, 1631, 1543], 1)
    ops.element('FourNodeTetrahedron', 4029, *[294, 295, 290, 1367], 1)
    ops.element('FourNodeTetrahedron', 4030, *[1709, 1409, 1701, 617], 1)
    ops.element('FourNodeTetrahedron', 4031, *[1458, 1726, 312, 313], 1)
    ops.element('FourNodeTetrahedron', 4032, *[316, 1657, 286, 1357], 1)
    ops.element('FourNodeTetrahedron', 4033, *[1288, 1436, 658, 659], 1)
    ops.element('FourNodeTetrahedron', 4034, *[1180, 1226, 1595, 1237], 1)
    ops.element('FourNodeTetrahedron', 4035, *[1451, 1442, 1585, 1348], 1)
    ops.element('FourNodeTetrahedron', 4036, *[1517, 402, 394, 1616], 1)
    ops.element('FourNodeTetrahedron', 4037, *[394, 402, 401, 1616], 1)
    ops.element('FourNodeTetrahedron', 4038, *[1313, 545, 444, 446], 1)
    ops.element('FourNodeTetrahedron', 4039, *[520, 1517, 394, 1616], 1)
    ops.element('FourNodeTetrahedron', 4040, *[520, 394, 1521, 1465], 1)
    ops.element('FourNodeTetrahedron', 4041, *[1591, 1473, 1478, 547], 1)
    ops.element('FourNodeTetrahedron', 4042, *[335, 1571, 299, 1388], 1)
    ops.element('FourNodeTetrahedron', 4043, *[1362, 1662, 478, 649], 1)
    ops.element('FourNodeTetrahedron', 4044, *[1416, 1579, 1415, 1452], 1)
    ops.element('FourNodeTetrahedron', 4045, *[1240, 1123, 1306, 1205], 1)
    ops.element('FourNodeTetrahedron', 4046, *[135, 180, 181, 1271], 1)
    ops.element('FourNodeTetrahedron', 4047, *[290, 291, 265, 1289], 1)
    ops.element('FourNodeTetrahedron', 4048, *[1362, 1662, 473, 478], 1)
    ops.element('FourNodeTetrahedron', 4049, *[1133, 1187, 1372, 1611], 1)
    ops.element('FourNodeTetrahedron', 4050, *[1227, 1201, 1404, 1123], 1)
    ops.element('FourNodeTetrahedron', 4051, *[1493, 1600, 1614, 1649], 1)
    ops.element('FourNodeTetrahedron', 4052, *[271, 1413, 1317, 272], 1)
    ops.element('FourNodeTetrahedron', 4053, *[472, 1362, 473, 478], 1)
    ops.element('FourNodeTetrahedron', 4054, *[1122, 1186, 1571, 1183], 1)
    ops.element('FourNodeTetrahedron', 4055, *[1595, 1237, 1341, 1390], 1)
    ops.element('FourNodeTetrahedron', 4056, *[1315, 1180, 1595, 1390], 1)
    ops.element('FourNodeTetrahedron', 4057, *[1407, 1532, 1273, 1534], 1)
    ops.element('FourNodeTetrahedron', 4058, *[1180, 1237, 1595, 1390], 1)
    ops.element('FourNodeTetrahedron', 4059, *[509, 673, 1494, 670], 1)
    ops.element('FourNodeTetrahedron', 4060, *[1470, 390, 389, 396], 1)
    ops.element('FourNodeTetrahedron', 4061, *[1658, 1602, 338, 342], 1)
    ops.element('FourNodeTetrahedron', 4062, *[743, 338, 339, 1658], 1)
    ops.element('FourNodeTetrahedron', 4063, *[339, 1658, 342, 343], 1)
    ops.element('FourNodeTetrahedron', 4064, *[1658, 1193, 1602, 1661], 1)
    ops.element('FourNodeTetrahedron', 4065, *[1295, 657, 1266, 656], 1)
    ops.element('FourNodeTetrahedron', 4066, *[335, 299, 331, 1388], 1)
    ops.element('FourNodeTetrahedron', 4067, *[1572, 1444, 1489, 1593], 1)
    ops.element('FourNodeTetrahedron', 4068, *[1582, 351, 399, 406], 1)
    ops.element('FourNodeTetrahedron', 4069, *[1549, 1396, 1298, 1556], 1)
    ops.element('FourNodeTetrahedron', 4070, *[346, 1372, 342, 1661], 1)
    ops.element('FourNodeTetrahedron', 4071, *[269, 256, 1321, 1539], 1)
    ops.element('FourNodeTetrahedron', 4072, *[342, 1372, 341, 346], 1)
    ops.element('FourNodeTetrahedron', 4073, *[1457, 1572, 1552, 626], 1)
    ops.element('FourNodeTetrahedron', 4074, *[745, 748, 746, 1579], 1)
    ops.element('FourNodeTetrahedron', 4075, *[1337, 1560, 1344, 1285], 1)
    ops.element('FourNodeTetrahedron', 4076, *[1419, 1560, 1443, 1285], 1)
    ops.element('FourNodeTetrahedron', 4077, *[1458, 1417, 1361, 1230], 1)
    ops.element('FourNodeTetrahedron', 4078, *[246, 1333, 213, 215], 1)
    ops.element('FourNodeTetrahedron', 4079, *[1274, 1145, 1297, 1676], 1)
    ops.element('FourNodeTetrahedron', 4080, *[1386, 1139, 1414, 1410], 1)
    ops.element('FourNodeTetrahedron', 4081, *[1543, 1483, 1455, 1436], 1)
    ops.element('FourNodeTetrahedron', 4082, *[1443, 1560, 1337, 1285], 1)
    ops.element('FourNodeTetrahedron', 4083, *[1410, 399, 398, 405], 1)
    ops.element('FourNodeTetrahedron', 4084, *[1547, 734, 735, 1174], 1)
    ops.element('FourNodeTetrahedron', 4085, *[307, 1458, 313, 308], 1)
    ops.element('FourNodeTetrahedron', 4086, *[1532, 183, 184, 1742], 1)
    ops.element('FourNodeTetrahedron', 4087, *[466, 1364, 462, 467], 1)
    ops.element('FourNodeTetrahedron', 4088, *[627, 1364, 467, 466], 1)
    ops.element('FourNodeTetrahedron', 4089, *[1279, 137, 1261, 1326], 1)
    ops.element('FourNodeTetrahedron', 4090, *[1315, 1595, 376, 1390], 1)
    ops.element('FourNodeTetrahedron', 4091, *[1345, 708, 1349, 1569], 1)
    ops.element('FourNodeTetrahedron', 4092, *[1379, 1335, 409, 1601], 1)
    ops.element('FourNodeTetrahedron', 4093, *[1511, 1471, 1487, 1709], 1)
    ops.element('FourNodeTetrahedron', 4094, *[1709, 1154, 1487, 1409], 1)
    ops.element('FourNodeTetrahedron', 4095, *[1640, 1635, 1652, 1603], 1)
    ops.element('FourNodeTetrahedron', 4096, *[1123, 1589, 1430, 1338], 1)
    ops.element('FourNodeTetrahedron', 4097, *[1333, 708, 1397, 1569], 1)
    ops.element('FourNodeTetrahedron', 4098, *[1602, 1320, 342, 1372], 1)
    ops.element('FourNodeTetrahedron', 4099, *[726, 717, 716, 1339], 1)
    ops.element('FourNodeTetrahedron', 4100, *[1692, 615, 1461, 620], 1)
    ops.element('FourNodeTetrahedron', 4101, *[742, 337, 338, 1602], 1)
    ops.element('FourNodeTetrahedron', 4102, *[270, 719, 240, 271], 1)
    ops.element('FourNodeTetrahedron', 4103, *[719, 724, 1531, 1317], 1)
    ops.element('FourNodeTetrahedron', 4104, *[241, 1531, 246, 1391], 1)
    ops.element('FourNodeTetrahedron', 4105, *[271, 1531, 240, 241], 1)
    ops.element('FourNodeTetrahedron', 4106, *[253, 258, 257, 1324], 1)
    ops.element('FourNodeTetrahedron', 4107, *[1233, 1189, 1577, 1227], 1)
    ops.element('FourNodeTetrahedron', 4108, *[1531, 1349, 213, 246], 1)
    ops.element('FourNodeTetrahedron', 4109, *[1531, 212, 213, 246], 1)
    ops.element('FourNodeTetrahedron', 4110, *[1317, 1349, 1531, 1391], 1)
    ops.element('FourNodeTetrahedron', 4111, *[1531, 1349, 714, 213], 1)
    ops.element('FourNodeTetrahedron', 4112, *[1384, 1373, 370, 471], 1)
    ops.element('FourNodeTetrahedron', 4113, *[1596, 1519, 1725, 1688], 1)
    ops.element('FourNodeTetrahedron', 4114, *[1483, 362, 1680, 1464], 1)
    ops.element('FourNodeTetrahedron', 4115, *[1366, 1398, 1568, 1492], 1)
    ops.element('FourNodeTetrahedron', 4116, *[612, 606, 1216, 610], 1)
    ops.element('FourNodeTetrahedron', 4117, *[1420, 1216, 1155, 606], 1)
    ops.element('FourNodeTetrahedron', 4118, *[1379, 363, 409, 1335], 1)
    ops.element('FourNodeTetrahedron', 4119, *[223, 184, 224, 1407], 1)
    ops.element('FourNodeTetrahedron', 4120, *[1568, 1496, 1464, 1492], 1)
    ops.element('FourNodeTetrahedron', 4121, *[1695, 1477, 1697, 603], 1)
    ops.element('FourNodeTetrahedron', 4122, *[1637, 609, 1693, 615], 1)
    ops.element('FourNodeTetrahedron', 4123, *[263, 1285, 234, 1310], 1)
    ops.element('FourNodeTetrahedron', 4124, *[375, 1390, 376, 1612], 1)
    ops.element('FourNodeTetrahedron', 4125, *[1634, 1642, 1536, 1502], 1)
    ops.element('FourNodeTetrahedron', 4126, *[375, 1390, 1612, 1483], 1)
    ops.element('FourNodeTetrahedron', 4127, *[375, 376, 362, 1612], 1)
    ops.element('FourNodeTetrahedron', 4128, *[375, 1612, 362, 1483], 1)
    ops.element('FourNodeTetrahedron', 4129, *[455, 304, 456, 1551], 1)
    ops.element('FourNodeTetrahedron', 4130, *[362, 1612, 1496, 1464], 1)
    ops.element('FourNodeTetrahedron', 4131, *[1568, 1612, 1496, 1464], 1)
    ops.element('FourNodeTetrahedron', 4132, *[1297, 1244, 1366, 1160], 1)
    ops.element('FourNodeTetrahedron', 4133, *[1627, 1451, 1585, 1561], 1)
    ops.element('FourNodeTetrahedron', 4134, *[1402, 1743, 168, 175], 1)
    ops.element('FourNodeTetrahedron', 4135, *[1613, 1425, 372, 1501], 1)
    ops.element('FourNodeTetrahedron', 4136, *[372, 1425, 359, 1501], 1)
    ops.element('FourNodeTetrahedron', 4137, *[1144, 1200, 1417, 1230], 1)
    ops.element('FourNodeTetrahedron', 4138, *[757, 745, 744, 1415], 1)
    ops.element('FourNodeTetrahedron', 4139, *[1613, 373, 372, 1425], 1)
    ops.element('FourNodeTetrahedron', 4140, *[1401, 1378, 1558, 1471], 1)
    ops.element('FourNodeTetrahedron', 4141, *[516, 1573, 1517, 518], 1)
    ops.element('FourNodeTetrahedron', 4142, *[1384, 1373, 471, 1687], 1)
    ops.element('FourNodeTetrahedron', 4143, *[372, 373, 359, 1425], 1)
    ops.element('FourNodeTetrahedron', 4144, *[646, 649, 1362, 647], 1)
    ops.element('FourNodeTetrahedron', 4145, *[1671, 1250, 1667, 1177], 1)
    ops.element('FourNodeTetrahedron', 4146, *[1313, 1305, 444, 545], 1)
    ops.element('FourNodeTetrahedron', 4147, *[1625, 418, 1566, 525], 1)
    ops.element('FourNodeTetrahedron', 4148, *[1576, 525, 1566, 524], 1)
    ops.element('FourNodeTetrahedron', 4149, *[1329, 1431, 1403, 1572], 1)
    ops.element('FourNodeTetrahedron', 4150, *[1566, 417, 524, 525], 1)
    ops.element('FourNodeTetrahedron', 4151, *[1576, 1566, 1488, 524], 1)
    ops.element('FourNodeTetrahedron', 4152, *[1452, 1681, 1485, 1500], 1)
    ops.element('FourNodeTetrahedron', 4153, *[1138, 1231, 1440, 1433], 1)
    ops.element('FourNodeTetrahedron', 4154, *[1126, 1223, 1442, 1236], 1)
    ops.element('FourNodeTetrahedron', 4155, *[1485, 1681, 391, 397], 1)
    ops.element('FourNodeTetrahedron', 4156, *[631, 621, 1472, 634], 1)
    ops.element('FourNodeTetrahedron', 4157, *[514, 1352, 515, 513], 1)
    ops.element('FourNodeTetrahedron', 4158, *[1721, 1376, 157, 1495], 1)
    ops.element('FourNodeTetrahedron', 4159, *[1548, 1729, 1546, 1536], 1)
    ops.element('FourNodeTetrahedron', 4160, *[1546, 1729, 1374, 1536], 1)
    ops.element('FourNodeTetrahedron', 4161, *[1729, 1621, 1374, 1623], 1)
    ops.element('FourNodeTetrahedron', 4162, *[1536, 1729, 1374, 1623], 1)
    ops.element('FourNodeTetrahedron', 4163, *[1730, 1578, 1569, 1629], 1)
    ops.element('FourNodeTetrahedron', 4164, *[1536, 1729, 1623, 1502], 1)
    ops.element('FourNodeTetrahedron', 4165, *[1485, 1386, 391, 1681], 1)
    ops.element('FourNodeTetrahedron', 4166, *[1245, 1187, 1133, 1611], 1)
    ops.element('FourNodeTetrahedron', 4167, *[1275, 144, 148, 1270], 1)
    ops.element('FourNodeTetrahedron', 4168, *[1703, 709, 1578, 1439], 1)
    ops.element('FourNodeTetrahedron', 4169, *[1627, 1585, 1600, 1424], 1)
    ops.element('FourNodeTetrahedron', 4170, *[1627, 1585, 1424, 1561], 1)
    ops.element('FourNodeTetrahedron', 4171, *[1391, 215, 246, 247], 1)
    ops.element('FourNodeTetrahedron', 4172, *[493, 1312, 1521, 482], 1)
    ops.element('FourNodeTetrahedron', 4173, *[232, 1371, 1559, 1514], 1)
    ops.element('FourNodeTetrahedron', 4174, *[1706, 1558, 301, 1408], 1)
    ops.element('FourNodeTetrahedron', 4175, *[1514, 1371, 1559, 1505], 1)
    ops.element('FourNodeTetrahedron', 4176, *[735, 732, 1605, 1357], 1)
    ops.element('FourNodeTetrahedron', 4177, *[253, 1360, 258, 1324], 1)
    ops.element('FourNodeTetrahedron', 4178, *[1633, 1325, 1330, 1570], 1)
    ops.element('FourNodeTetrahedron', 4179, *[181, 180, 184, 1532], 1)
    ops.element('FourNodeTetrahedron', 4180, *[180, 179, 183, 1269], 1)
    ops.element('FourNodeTetrahedron', 4181, *[1633, 1570, 1413, 1399], 1)
    ops.element('FourNodeTetrahedron', 4182, *[736, 735, 315, 1657], 1)
    ops.element('FourNodeTetrahedron', 4183, *[1551, 614, 607, 613], 1)
    ops.element('FourNodeTetrahedron', 4184, *[1571, 297, 314, 299], 1)
    ops.element('FourNodeTetrahedron', 4185, *[237, 1744, 233, 232], 1)
    ops.element('FourNodeTetrahedron', 4186, *[520, 1616, 1465, 517], 1)
    ops.element('FourNodeTetrahedron', 4187, *[1519, 1190, 1490, 1508], 1)
    ops.element('FourNodeTetrahedron', 4188, *[1740, 707, 1672, 1397], 1)
    ops.element('FourNodeTetrahedron', 4189, *[1210, 711, 1703, 1228], 1)
    ops.element('FourNodeTetrahedron', 4190, *[1476, 1484, 1505, 602], 1)
    ops.element('FourNodeTetrahedron', 4191, *[521, 1734, 1448, 677], 1)
    ops.element('FourNodeTetrahedron', 4192, *[1398, 1431, 1496, 1457], 1)
    ops.element('FourNodeTetrahedron', 4193, *[1669, 1186, 1262, 1122], 1)
    ops.element('FourNodeTetrahedron', 4194, *[461, 462, 320, 1552], 1)
    ops.element('FourNodeTetrahedron', 4195, *[1198, 1128, 308, 1186], 1)
    ops.element('FourNodeTetrahedron', 4196, *[1671, 1667, 333, 1381], 1)
    ops.element('FourNodeTetrahedron', 4197, *[516, 767, 494, 1312], 1)
    ops.element('FourNodeTetrahedron', 4198, *[1411, 1235, 1389, 1132], 1)
    ops.element('FourNodeTetrahedron', 4199, *[1469, 1426, 1720, 1694], 1)
    ops.element('FourNodeTetrahedron', 4200, *[1729, 1652, 1621, 1591], 1)
    ops.element('FourNodeTetrahedron', 4201, *[515, 769, 516, 1733], 1)
    ops.element('FourNodeTetrahedron', 4202, *[236, 1310, 1353, 1737], 1)
    ops.element('FourNodeTetrahedron', 4203, *[332, 1671, 333, 1381], 1)
    ops.element('FourNodeTetrahedron', 4204, *[1671, 1308, 333, 1667], 1)
    ops.element('FourNodeTetrahedron', 4205, *[1378, 1369, 1334, 1554], 1)
    ops.element('FourNodeTetrahedron', 4206, *[1378, 1369, 1554, 1487], 1)
    ops.element('FourNodeTetrahedron', 4207, *[679, 1158, 1734, 511], 1)
    ops.element('FourNodeTetrahedron', 4208, *[1381, 1177, 1667, 1716], 1)
    ops.element('FourNodeTetrahedron', 4209, *[1460, 675, 1469, 674], 1)
    ops.element('FourNodeTetrahedron', 4210, *[1368, 1288, 1561, 665], 1)
    ops.element('FourNodeTetrahedron', 4211, *[1475, 1204, 1615, 1135], 1)
    ops.element('FourNodeTetrahedron', 4212, *[1369, 1343, 1334, 1554], 1)
    ops.element('FourNodeTetrahedron', 4213, *[678, 1561, 1424, 664], 1)
    ops.element('FourNodeTetrahedron', 4214, *[253, 1360, 1314, 1284], 1)
    ops.element('FourNodeTetrahedron', 4215, *[1364, 1316, 463, 628], 1)
    ops.element('FourNodeTetrahedron', 4216, *[1227, 1123, 1306, 1240], 1)
    ops.element('FourNodeTetrahedron', 4217, *[1642, 1506, 1640, 1502], 1)
    ops.element('FourNodeTetrahedron', 4218, *[258, 259, 262, 1327], 1)
    ops.element('FourNodeTetrahedron', 4219, *[1369, 1440, 1343, 1554], 1)
    ops.element('FourNodeTetrahedron', 4220, *[1369, 1440, 1554, 1487], 1)
    ops.element('FourNodeTetrahedron', 4221, *[1493, 1146, 1451, 1448], 1)
    ops.element('FourNodeTetrahedron', 4222, *[656, 1373, 477, 646], 1)
    ops.element('FourNodeTetrahedron', 4223, *[1150, 1220, 1525, 1447], 1)
    ops.element('FourNodeTetrahedron', 4224, *[1686, 747, 1416, 1169], 1)
    ops.element('FourNodeTetrahedron', 4225, *[1533, 1584, 1535, 1637], 1)
    ops.element('FourNodeTetrahedron', 4226, *[1533, 1535, 1463, 1637], 1)
    ops.element('FourNodeTetrahedron', 4227, *[1611, 348, 353, 352], 1)
    ops.element('FourNodeTetrahedron', 4228, *[392, 1590, 347, 399], 1)
    ops.element('FourNodeTetrahedron', 4229, *[1703, 710, 709, 1439], 1)
    ops.element('FourNodeTetrahedron', 4230, *[1578, 1397, 708, 1569], 1)
    ops.element('FourNodeTetrahedron', 4231, *[1389, 1423, 1612, 1496], 1)
    ops.element('FourNodeTetrahedron', 4232, *[1281, 1468, 527, 522], 1)
    ops.element('FourNodeTetrahedron', 4233, *[1683, 1581, 1383, 1609], 1)
    ops.element('FourNodeTetrahedron', 4234, *[1677, 375, 404, 374], 1)
    ops.element('FourNodeTetrahedron', 4235, *[1404, 1430, 288, 289], 1)
    ops.element('FourNodeTetrahedron', 4236, *[1510, 156, 1674, 1495], 1)
    ops.element('FourNodeTetrahedron', 4237, *[1674, 156, 157, 1495], 1)
    ops.element('FourNodeTetrahedron', 4238, *[1608, 1510, 1495, 1490], 1)
    ops.element('FourNodeTetrahedron', 4239, *[1505, 1591, 1623, 1636], 1)
    ops.element('FourNodeTetrahedron', 4240, *[274, 1363, 243, 244], 1)
    ops.element('FourNodeTetrahedron', 4241, *[616, 610, 1637, 609], 1)
    ops.element('FourNodeTetrahedron', 4242, *[1425, 1592, 360, 1421], 1)
    ops.element('FourNodeTetrahedron', 4243, *[373, 1592, 360, 1425], 1)
    ops.element('FourNodeTetrahedron', 4244, *[373, 374, 360, 1592], 1)
    ops.element('FourNodeTetrahedron', 4245, *[1592, 374, 360, 1421], 1)
    ops.element('FourNodeTetrahedron', 4246, *[1497, 374, 373, 1592], 1)
    ops.element('FourNodeTetrahedron', 4247, *[1361, 1417, 312, 1458], 1)
    ops.element('FourNodeTetrahedron', 4248, *[1728, 1490, 1396, 1508], 1)
    ops.element('FourNodeTetrahedron', 4249, *[1349, 715, 707, 708], 1)
    ops.element('FourNodeTetrahedron', 4250, *[1511, 617, 618, 625], 1)
    ops.element('FourNodeTetrahedron', 4251, *[1714, 1395, 1405, 1512], 1)
    ops.element('FourNodeTetrahedron', 4252, *[1245, 1187, 1611, 1166], 1)
    ops.element('FourNodeTetrahedron', 4253, *[1587, 1639, 1654, 1645], 1)
    ops.element('FourNodeTetrahedron', 4254, *[1285, 1560, 1344, 1546], 1)
    ops.element('FourNodeTetrahedron', 4255, *[343, 346, 342, 1661], 1)
    ops.element('FourNodeTetrahedron', 4256, *[350, 1133, 1372, 1611], 1)
    ops.element('FourNodeTetrahedron', 4257, *[1666, 382, 381, 389], 1)
    ops.element('FourNodeTetrahedron', 4258, *[736, 734, 735, 1547], 1)
    ops.element('FourNodeTetrahedron', 4259, *[1684, 1449, 620, 618], 1)
    ops.element('FourNodeTetrahedron', 4260, *[1334, 1554, 1711, 1533], 1)
    ops.element('FourNodeTetrahedron', 4261, *[763, 755, 1286, 1303], 1)
    ops.element('FourNodeTetrahedron', 4262, *[1143, 1193, 1658, 1590], 1)
    ops.element('FourNodeTetrahedron', 4263, *[1612, 332, 328, 1423], 1)
    ops.element('FourNodeTetrahedron', 4264, *[397, 1681, 398, 404], 1)
    ops.element('FourNodeTetrahedron', 4265, *[345, 1669, 349, 1611], 1)
    ops.element('FourNodeTetrahedron', 4266, *[1319, 1449, 1684, 618], 1)
    ops.element('FourNodeTetrahedron', 4267, *[1517, 1286, 388, 395], 1)
    ops.element('FourNodeTetrahedron', 4268, *[350, 1611, 349, 353], 1)
    ops.element('FourNodeTetrahedron', 4269, *[1183, 1184, 1188, 1564], 1)
    ops.element('FourNodeTetrahedron', 4270, *[1741, 1606, 355, 1671], 1)
    ops.element('FourNodeTetrahedron', 4271, *[1471, 1195, 1487, 1709], 1)
    ops.element('FourNodeTetrahedron', 4272, *[1183, 1188, 1571, 1564], 1)
    ops.element('FourNodeTetrahedron', 4273, *[1571, 297, 299, 1564], 1)
    ops.element('FourNodeTetrahedron', 4274, *[1312, 1517, 1385, 1521], 1)
    ops.element('FourNodeTetrahedron', 4275, *[1183, 1184, 1564, 1131], 1)
    ops.element('FourNodeTetrahedron', 4276, *[1542, 1626, 1331, 1580], 1)
    ops.element('FourNodeTetrahedron', 4277, *[1544, 1498, 1515, 522], 1)
    ops.element('FourNodeTetrahedron', 4278, *[1544, 1515, 1491, 522], 1)
    ops.element('FourNodeTetrahedron', 4279, *[1726, 1200, 1400, 1189], 1)
    ops.element('FourNodeTetrahedron', 4280, *[1417, 1200, 1400, 1726], 1)
    ops.element('FourNodeTetrahedron', 4281, *[649, 465, 1662, 626], 1)
    ops.element('FourNodeTetrahedron', 4282, *[1445, 1550, 1632, 1295], 1)
    ops.element('FourNodeTetrahedron', 4283, *[1565, 1727, 1443, 1418], 1)
    ops.element('FourNodeTetrahedron', 4284, *[1619, 1626, 1280, 1542], 1)
    ops.element('FourNodeTetrahedron', 4285, *[1301, 1457, 1552, 626], 1)
    ops.element('FourNodeTetrahedron', 4286, *[1364, 463, 467, 628], 1)
    ops.element('FourNodeTetrahedron', 4287, *[1147, 1210, 1705, 1481], 1)
    ops.element('FourNodeTetrahedron', 4288, *[1503, 1643, 1506, 1596], 1)
    ops.element('FourNodeTetrahedron', 4289, *[1506, 1643, 1596, 1603], 1)
    ops.element('FourNodeTetrahedron', 4290, *[752, 743, 339, 1658], 1)
    ops.element('FourNodeTetrahedron', 4291, *[1501, 1720, 1446, 1469], 1)
    ops.element('FourNodeTetrahedron', 4292, *[1711, 1683, 1609, 1638], 1)
    ops.element('FourNodeTetrahedron', 4293, *[1267, 1524, 1584, 1486], 1)
    ops.element('FourNodeTetrahedron', 4294, *[1440, 1432, 1343, 1638], 1)
    ops.element('FourNodeTetrahedron', 4295, *[1614, 1497, 1613, 1600], 1)
    ops.element('FourNodeTetrahedron', 4296, *[1613, 1497, 1425, 1600], 1)
    ops.element('FourNodeTetrahedron', 4297, *[1614, 1447, 1497, 1600], 1)
    ops.element('FourNodeTetrahedron', 4298, *[1497, 1592, 1425, 1600], 1)
    ops.element('FourNodeTetrahedron', 4299, *[1346, 1599, 1422, 1586], 1)
    ops.element('FourNodeTetrahedron', 4300, *[1352, 1526, 1300, 518], 1)
    ops.element('FourNodeTetrahedron', 4301, *[258, 1327, 262, 1324], 1)
    ops.element('FourNodeTetrahedron', 4302, *[1274, 659, 1288, 665], 1)
    ops.element('FourNodeTetrahedron', 4303, *[1439, 1599, 1346, 1586], 1)
    ops.element('FourNodeTetrahedron', 4304, *[1453, 1439, 1586, 1406], 1)
    ops.element('FourNodeTetrahedron', 4305, *[1550, 1421, 1450, 1543], 1)
    ops.element('FourNodeTetrahedron', 4306, *[1550, 1450, 1295, 1292], 1)
    ops.element('FourNodeTetrahedron', 4307, *[1232, 1140, 1519, 1172], 1)
    ops.element('FourNodeTetrahedron', 4308, *[391, 1354, 392, 1386], 1)
    ops.element('FourNodeTetrahedron', 4309, *[1295, 1455, 1450, 1292], 1)
    ops.element('FourNodeTetrahedron', 4310, *[1424, 1550, 1295, 1292], 1)
    ops.element('FourNodeTetrahedron', 4311, *[1158, 1699, 1448, 680], 1)
    ops.element('FourNodeTetrahedron', 4312, *[1158, 683, 1699, 680], 1)
    ops.element('FourNodeTetrahedron', 4313, *[1527, 764, 1664, 1385], 1)
    ops.element('FourNodeTetrahedron', 4314, *[754, 381, 380, 388], 1)
    ops.element('FourNodeTetrahedron', 4315, *[525, 417, 422, 423], 1)
    ops.element('FourNodeTetrahedron', 4316, *[1430, 1589, 1418, 284], 1)
    ops.element('FourNodeTetrahedron', 4317, *[1475, 1456, 1644, 1615], 1)
    ops.element('FourNodeTetrahedron', 4318, *[1387, 166, 174, 162], 1)
    ops.element('FourNodeTetrahedron', 4319, *[1597, 1469, 1459, 672], 1)
    ops.element('FourNodeTetrahedron', 4320, *[1643, 1646, 1731, 1635], 1)
    ops.element('FourNodeTetrahedron', 4321, *[1342, 1475, 1644, 1581], 1)
    ops.element('FourNodeTetrahedron', 4322, *[1342, 1456, 1644, 1475], 1)
    ops.element('FourNodeTetrahedron', 4323, *[1214, 1255, 1454, 1130], 1)
    ops.element('FourNodeTetrahedron', 4324, *[1678, 1311, 1325, 1242], 1)
    ops.element('FourNodeTetrahedron', 4325, *[1456, 1722, 1644, 1522], 1)
    ops.element('FourNodeTetrahedron', 4326, *[1245, 1611, 1606, 1166], 1)
    ops.element('FourNodeTetrahedron', 4327, *[1578, 1439, 1346, 1586], 1)
    ops.element('FourNodeTetrahedron', 4328, *[266, 254, 253, 1360], 1)
    ops.element('FourNodeTetrahedron', 4329, *[606, 551, 1155, 550], 1)
    ops.element('FourNodeTetrahedron', 4330, *[1578, 1346, 709, 1422], 1)
    ops.element('FourNodeTetrahedron', 4331, *[1714, 1395, 330, 1405], 1)
    ops.element('FourNodeTetrahedron', 4332, *[1455, 1483, 1464, 1436], 1)
    ops.element('FourNodeTetrahedron', 4333, *[1421, 1483, 1450, 1543], 1)
    ops.element('FourNodeTetrahedron', 4334, *[1543, 1436, 1455, 1292], 1)
    ops.element('FourNodeTetrahedron', 4335, *[331, 1388, 300, 1336], 1)
    ops.element('FourNodeTetrahedron', 4336, *[1543, 1483, 1450, 1455], 1)
    ops.element('FourNodeTetrahedron', 4337, *[1543, 1455, 1450, 1292], 1)
    ops.element('FourNodeTetrahedron', 4338, *[528, 1745, 1544, 522], 1)
    ops.element('FourNodeTetrahedron', 4339, *[1353, 1371, 233, 1537], 1)
    ops.element('FourNodeTetrahedron', 4340, *[289, 1430, 283, 284], 1)
    ops.element('FourNodeTetrahedron', 4341, *[1551, 1712, 1276, 1299], 1)
    ops.element('FourNodeTetrahedron', 4342, *[1282, 301, 298, 1319], 1)
    ops.element('FourNodeTetrahedron', 4343, *[236, 1353, 233, 1537], 1)
    ops.element('FourNodeTetrahedron', 4344, *[261, 1744, 237, 1328], 1)
    ops.element('FourNodeTetrahedron', 4345, *[1324, 1737, 261, 1537], 1)
    ops.element('FourNodeTetrahedron', 4346, *[1328, 1537, 1514, 1476], 1)
    ops.element('FourNodeTetrahedron', 4347, *[1730, 1586, 1629, 1587], 1)
    ops.element('FourNodeTetrahedron', 4348, *[1537, 1505, 1514, 1476], 1)
    ops.element('FourNodeTetrahedron', 4349, *[1488, 1580, 1498, 523], 1)
    ops.element('FourNodeTetrahedron', 4350, *[279, 1419, 274, 263], 1)
    ops.element('FourNodeTetrahedron', 4351, *[1688, 1427, 1725, 1293], 1)
    ops.element('FourNodeTetrahedron', 4352, *[261, 1537, 1328, 1323], 1)
    ops.element('FourNodeTetrahedron', 4353, *[1323, 1537, 1328, 1476], 1)
    ops.element('FourNodeTetrahedron', 4354, *[1512, 1574, 1336, 1467], 1)
    ops.element('FourNodeTetrahedron', 4355, *[1712, 1324, 1537, 1484], 1)
    ops.element('FourNodeTetrahedron', 4356, *[1632, 1450, 1373, 1295], 1)
    ops.element('FourNodeTetrahedron', 4357, *[1351, 740, 305, 1708], 1)
    ops.element('FourNodeTetrahedron', 4358, *[1351, 1708, 305, 340], 1)
    ops.element('FourNodeTetrahedron', 4359, *[1155, 1648, 1503, 550], 1)
    ops.element('FourNodeTetrahedron', 4360, *[1155, 1232, 1648, 550], 1)
    ops.element('FourNodeTetrahedron', 4361, *[1155, 1215, 1648, 1232], 1)
    ops.element('FourNodeTetrahedron', 4362, *[1524, 1615, 1643, 1648], 1)
    ops.element('FourNodeTetrahedron', 4363, *[1730, 1578, 1586, 1629], 1)
    ops.element('FourNodeTetrahedron', 4364, *[1524, 1155, 1648, 1503], 1)
    ops.element('FourNodeTetrahedron', 4365, *[1298, 416, 1331, 1580], 1)
    ops.element('FourNodeTetrahedron', 4366, *[1307, 1173, 1678, 1302], 1)
    ops.element('FourNodeTetrahedron', 4367, *[1615, 1215, 1648, 1155], 1)
    ops.element('FourNodeTetrahedron', 4368, *[1524, 1615, 1648, 1155], 1)
    ops.element('FourNodeTetrahedron', 4369, *[328, 1381, 329, 1329], 1)
    ops.element('FourNodeTetrahedron', 4370, *[1472, 1194, 1709, 621], 1)
    ops.element('FourNodeTetrahedron', 4371, *[702, 167, 168, 1743], 1)
    ops.element('FourNodeTetrahedron', 4372, *[1499, 165, 162, 161], 1)
    ops.element('FourNodeTetrahedron', 4373, *[1619, 1626, 1542, 1545], 1)
    ops.element('FourNodeTetrahedron', 4374, *[1596, 1688, 1725, 1293], 1)
    ops.element('FourNodeTetrahedron', 4375, *[1529, 1663, 1736, 654], 1)
    ops.element('FourNodeTetrahedron', 4376, *[1276, 1323, 1539, 1712], 1)
    ops.element('FourNodeTetrahedron', 4377, *[259, 1581, 1419, 1327], 1)
    ops.element('FourNodeTetrahedron', 4378, *[1337, 1553, 1350, 1344], 1)
    ops.element('FourNodeTetrahedron', 4379, *[1337, 1560, 1553, 1344], 1)
    ops.element('FourNodeTetrahedron', 4380, *[1669, 1262, 348, 1122], 1)
    ops.element('FourNodeTetrahedron', 4381, *[1350, 1553, 1356, 1344], 1)
    ops.element('FourNodeTetrahedron', 4382, *[1360, 1535, 1620, 1562], 1)
    ops.element('FourNodeTetrahedron', 4383, *[1664, 388, 380, 387], 1)
    ops.element('FourNodeTetrahedron', 4384, *[1623, 1729, 1502, 1591], 1)
    ops.element('FourNodeTetrahedron', 4385, *[1443, 1604, 1560, 1419], 1)
    ops.element('FourNodeTetrahedron', 4386, *[1651, 1325, 1330, 1633], 1)
    ops.element('FourNodeTetrahedron', 4387, *[1414, 1163, 399, 1582], 1)
    ops.element('FourNodeTetrahedron', 4388, *[1646, 1719, 1490, 1191], 1)
    ops.element('FourNodeTetrahedron', 4389, *[1566, 1275, 1298, 417], 1)
    ops.element('FourNodeTetrahedron', 4390, *[1634, 1536, 1537, 1484], 1)
    ops.element('FourNodeTetrahedron', 4391, *[1556, 1275, 1298, 1566], 1)
    ops.element('FourNodeTetrahedron', 4392, *[1349, 708, 1333, 1569], 1)
    ops.element('FourNodeTetrahedron', 4393, *[262, 1310, 234, 236], 1)
    ops.element('FourNodeTetrahedron', 4394, *[399, 1163, 1590, 1124], 1)
    ops.element('FourNodeTetrahedron', 4395, *[1432, 1231, 1267, 1433], 1)
    ops.element('FourNodeTetrahedron', 4396, *[1214, 1406, 1453, 1454], 1)
    ops.element('FourNodeTetrahedron', 4397, *[1250, 1243, 1667, 1177], 1)
    ops.element('FourNodeTetrahedron', 4398, *[1583, 1569, 1333, 1359], 1)
    ops.element('FourNodeTetrahedron', 4399, *[1583, 1569, 1359, 1557], 1)
    ops.element('FourNodeTetrahedron', 4400, *[1324, 1634, 1537, 1484], 1)
    ops.element('FourNodeTetrahedron', 4401, *[1519, 1625, 1725, 1427], 1)
    ops.element('FourNodeTetrahedron', 4402, *[1557, 1730, 1569, 1575], 1)
    ops.element('FourNodeTetrahedron', 4403, *[709, 1346, 705, 1422], 1)
    ops.element('FourNodeTetrahedron', 4404, *[1562, 1477, 1634, 1484], 1)
    ops.element('FourNodeTetrahedron', 4405, *[1488, 1566, 1580, 1691], 1)
    ops.element('FourNodeTetrahedron', 4406, *[1657, 735, 285, 1605], 1)
    ops.element('FourNodeTetrahedron', 4407, *[1437, 1169, 1416, 1258], 1)
    ops.element('FourNodeTetrahedron', 4408, *[1314, 1324, 257, 1323], 1)
    ops.element('FourNodeTetrahedron', 4409, *[1447, 1220, 1429, 1126], 1)
    ops.element('FourNodeTetrahedron', 4410, *[259, 1581, 1327, 1383], 1)
    ops.element('FourNodeTetrahedron', 4411, *[601, 1514, 545, 546], 1)
    ops.element('FourNodeTetrahedron', 4412, *[218, 1272, 173, 135], 1)
    ops.element('FourNodeTetrahedron', 4413, *[1708, 1361, 306, 1659], 1)
    ops.element('FourNodeTetrahedron', 4414, *[307, 1458, 312, 313], 1)
    ops.element('FourNodeTetrahedron', 4415, *[340, 1708, 306, 1659], 1)
    ops.element('FourNodeTetrahedron', 4416, *[667, 1707, 1520, 668], 1)
    ops.element('FourNodeTetrahedron', 4417, *[1357, 1151, 1307, 1434], 1)
    ops.element('FourNodeTetrahedron', 4418, *[1439, 1599, 1586, 1406], 1)
    ops.element('FourNodeTetrahedron', 4419, *[1468, 431, 432, 436], 1)
    ops.element('FourNodeTetrahedron', 4420, *[1527, 386, 411, 412], 1)
    ops.element('FourNodeTetrahedron', 4421, *[1369, 1343, 251, 1440], 1)
    ops.element('FourNodeTetrahedron', 4422, *[1343, 1683, 1711, 1638], 1)
    ops.element('FourNodeTetrahedron', 4423, *[1711, 1638, 1609, 1584], 1)
    ops.element('FourNodeTetrahedron', 4424, *[517, 1518, 1616, 1650], 1)
    ops.element('FourNodeTetrahedron', 4425, *[1665, 186, 189, 1355], 1)
    ops.element('FourNodeTetrahedron', 4426, *[303, 290, 304, 1332], 1)
    ops.element('FourNodeTetrahedron', 4427, *[1339, 709, 1345, 1578], 1)
    ops.element('FourNodeTetrahedron', 4428, *[517, 1616, 1465, 1650], 1)
    ops.element('FourNodeTetrahedron', 4429, *[1215, 1130, 1646, 1191], 1)
    ops.element('FourNodeTetrahedron', 4430, *[1714, 1512, 1405, 1489], 1)
    ops.element('FourNodeTetrahedron', 4431, *[301, 1558, 295, 1408], 1)
    ops.element('FourNodeTetrahedron', 4432, *[1483, 1568, 1464, 1436], 1)
    ops.element('FourNodeTetrahedron', 4433, *[1435, 1410, 404, 1382], 1)
    ops.element('FourNodeTetrahedron', 4434, *[492, 1465, 483, 489], 1)
    ops.element('FourNodeTetrahedron', 4435, *[397, 1681, 391, 398], 1)
    ops.element('FourNodeTetrahedron', 4436, *[734, 1199, 735, 1174], 1)
    ops.element('FourNodeTetrahedron', 4437, *[1583, 1333, 1349, 1569], 1)
    ops.element('FourNodeTetrahedron', 4438, *[1668, 1658, 339, 343], 1)
    ops.element('FourNodeTetrahedron', 4439, *[1583, 1345, 1349, 1569], 1)
    ops.element('FourNodeTetrahedron', 4440, *[1345, 1578, 708, 1569], 1)
    ops.element('FourNodeTetrahedron', 4441, *[521, 1649, 1494, 1702], 1)
    ops.element('FourNodeTetrahedron', 4442, *[1630, 1453, 1587, 1454], 1)
    ops.element('FourNodeTetrahedron', 4443, *[679, 1734, 676, 677], 1)
    ops.element('FourNodeTetrahedron', 4444, *[516, 769, 768, 1573], 1)
    ops.element('FourNodeTetrahedron', 4445, *[1573, 1303, 1517, 1516], 1)
    ops.element('FourNodeTetrahedron', 4446, *[518, 1573, 1517, 1516], 1)
    ops.element('FourNodeTetrahedron', 4447, *[511, 679, 1734, 510], 1)
    ops.element('FourNodeTetrahedron', 4448, *[1738, 761, 762, 1300], 1)
    ops.element('FourNodeTetrahedron', 4449, *[1549, 150, 1280, 1298], 1)
    ops.element('FourNodeTetrahedron', 4450, *[510, 679, 1734, 676], 1)
    ops.element('FourNodeTetrahedron', 4451, *[1554, 1433, 1638, 1441], 1)
    ops.element('FourNodeTetrahedron', 4452, *[1506, 1603, 1502, 548], 1)
    ops.element('FourNodeTetrahedron', 4453, *[1481, 1439, 1703, 1607], 1)
    ops.element('FourNodeTetrahedron', 4454, *[1502, 1603, 1591, 548], 1)
    ops.element('FourNodeTetrahedron', 4455, *[1591, 1603, 1473, 548], 1)
    ops.element('FourNodeTetrahedron', 4456, *[548, 1603, 1473, 1291], 1)
    ops.element('FourNodeTetrahedron', 4457, *[746, 384, 383, 1485], 1)
    ops.element('FourNodeTetrahedron', 4458, *[745, 748, 1579, 1416], 1)
    ops.element('FourNodeTetrahedron', 4459, *[549, 1603, 548, 1291], 1)
    ops.element('FourNodeTetrahedron', 4460, *[1506, 549, 1603, 548], 1)
    ops.element('FourNodeTetrahedron', 4461, *[1572, 1593, 1489, 627], 1)
    ops.element('FourNodeTetrahedron', 4462, *[1519, 1140, 1625, 1427], 1)
    ops.element('FourNodeTetrahedron', 4463, *[513, 1526, 518, 1647], 1)
    ops.element('FourNodeTetrahedron', 4464, *[1556, 1396, 1298, 1275], 1)
    ops.element('FourNodeTetrahedron', 4465, *[1678, 723, 1311, 1242], 1)
    ops.element('FourNodeTetrahedron', 4466, *[459, 614, 1551, 613], 1)
    ops.element('FourNodeTetrahedron', 4467, *[1310, 1548, 1546, 1536], 1)
    ops.element('FourNodeTetrahedron', 4468, *[1388, 1401, 1336, 1574], 1)
    ops.element('FourNodeTetrahedron', 4469, *[1124, 1241, 1741, 1392], 1)
    ops.element('FourNodeTetrahedron', 4470, *[1529, 470, 1736, 660], 1)
    ops.element('FourNodeTetrahedron', 4471, *[1286, 389, 388, 395], 1)
    ops.element('FourNodeTetrahedron', 4472, *[549, 1293, 1603, 1291], 1)
    ops.element('FourNodeTetrahedron', 4473, *[275, 1651, 720, 271], 1)
    ops.element('FourNodeTetrahedron', 4474, *[1162, 1143, 1590, 1163], 1)
    ops.element('FourNodeTetrahedron', 4475, *[1542, 1318, 1491, 1515], 1)
    ops.element('FourNodeTetrahedron', 4476, *[1354, 1668, 392, 1414], 1)
    ops.element('FourNodeTetrahedron', 4477, *[250, 252, 269, 1539], 1)
    ops.element('FourNodeTetrahedron', 4478, *[1462, 1685, 1379, 1528], 1)
    ops.element('FourNodeTetrahedron', 4479, *[448, 1539, 1321, 1563], 1)
    ops.element('FourNodeTetrahedron', 4480, *[523, 1580, 1515, 421], 1)
    ops.element('FourNodeTetrahedron', 4481, *[1580, 416, 1515, 421], 1)
    ops.element('FourNodeTetrahedron', 4482, *[1602, 1161, 1320, 1372], 1)
    ops.element('FourNodeTetrahedron', 4483, *[1584, 1609, 1620, 1610], 1)
    ops.element('FourNodeTetrahedron', 4484, *[1609, 1581, 1620, 1610], 1)
    ops.element('FourNodeTetrahedron', 4485, *[772, 759, 771, 1159], 1)
    ops.element('FourNodeTetrahedron', 4486, *[609, 1420, 605, 610], 1)
    ops.element('FourNodeTetrahedron', 4487, *[364, 378, 369, 1393], 1)
    ops.element('FourNodeTetrahedron', 4488, *[1321, 1476, 1313, 1563], 1)
    ops.element('FourNodeTetrahedron', 4489, *[255, 1342, 259, 1683], 1)
    ops.element('FourNodeTetrahedron', 4490, *[1569, 1629, 1387, 1350], 1)
    ops.element('FourNodeTetrahedron', 4491, *[656, 477, 1687, 476], 1)
    ops.element('FourNodeTetrahedron', 4492, *[1488, 1691, 1580, 523], 1)
    ops.element('FourNodeTetrahedron', 4493, *[1393, 378, 369, 470], 1)
    ops.element('FourNodeTetrahedron', 4494, *[1207, 1162, 1354, 1139], 1)
    ops.element('FourNodeTetrahedron', 4495, *[629, 630, 1572, 627], 1)
    ops.element('FourNodeTetrahedron', 4496, *[1690, 1354, 391, 1386], 1)
    ops.element('FourNodeTetrahedron', 4497, *[1538, 1542, 1491, 1544], 1)
    ops.element('FourNodeTetrahedron', 4498, *[225, 1277, 190, 440], 1)
    ops.element('FourNodeTetrahedron', 4499, *[1538, 1542, 1318, 1491], 1)
    ops.element('FourNodeTetrahedron', 4500, *[1538, 1326, 1318, 1542], 1)
    ops.element('FourNodeTetrahedron', 4501, *[1683, 1475, 1342, 1581], 1)
    ops.element('FourNodeTetrahedron', 4502, *[278, 1399, 1565, 1418], 1)
    ops.element('FourNodeTetrahedron', 4503, *[278, 1565, 1443, 1418], 1)
    ops.element('FourNodeTetrahedron', 4504, *[1714, 1405, 1679, 1489], 1)
    ops.element('FourNodeTetrahedron', 4505, *[1479, 161, 162, 158], 1)
    ops.element('FourNodeTetrahedron', 4506, *[1455, 1492, 1362, 647], 1)
    ops.element('FourNodeTetrahedron', 4507, *[278, 1418, 1443, 279], 1)
    ops.element('FourNodeTetrahedron', 4508, *[1267, 1135, 1475, 1231], 1)
    ops.element('FourNodeTetrahedron', 4509, *[278, 1565, 273, 1443], 1)
    ops.element('FourNodeTetrahedron', 4510, *[244, 1337, 249, 1285], 1)
    ops.element('FourNodeTetrahedron', 4511, *[1329, 1403, 325, 1322], 1)
    ops.element('FourNodeTetrahedron', 4512, *[278, 1443, 273, 279], 1)
    ops.element('FourNodeTetrahedron', 4513, *[399, 1590, 347, 351], 1)
    ops.element('FourNodeTetrahedron', 4514, *[1163, 1143, 1590, 1165], 1)
    ops.element('FourNodeTetrahedron', 4515, *[138, 140, 139, 1318], 1)
    ops.element('FourNodeTetrahedron', 4516, *[1458, 1230, 1726, 1233], 1)
    ops.element('FourNodeTetrahedron', 4517, *[1233, 1189, 1726, 1577], 1)
    ops.element('FourNodeTetrahedron', 4518, *[1590, 1143, 1193, 1165], 1)
    ops.element('FourNodeTetrahedron', 4519, *[737, 1304, 305, 1708], 1)
    ops.element('FourNodeTetrahedron', 4520, *[392, 1590, 343, 347], 1)
    ops.element('FourNodeTetrahedron', 4521, *[1525, 1507, 1497, 1429], 1)
    ops.element('FourNodeTetrahedron', 4522, *[1377, 1461, 1332, 1682], 1)
    ops.element('FourNodeTetrahedron', 4523, *[1195, 1138, 1487, 1154], 1)
    ops.element('FourNodeTetrahedron', 4524, *[494, 1312, 482, 493], 1)
    ops.element('FourNodeTetrahedron', 4525, *[481, 1312, 412, 482], 1)
    ops.element('FourNodeTetrahedron', 4526, *[494, 1312, 481, 482], 1)
    ops.element('FourNodeTetrahedron', 4527, *[1230, 1189, 1726, 1233], 1)
    ops.element('FourNodeTetrahedron', 4528, *[243, 1363, 247, 248], 1)
    ops.element('FourNodeTetrahedron', 4529, *[494, 766, 481, 1312], 1)
    ops.element('FourNodeTetrahedron', 4530, *[515, 1733, 516, 518], 1)
    ops.element('FourNodeTetrahedron', 4531, *[1577, 1189, 1726, 1404], 1)
    ops.element('FourNodeTetrahedron', 4532, *[1726, 1189, 1400, 1404], 1)
    ops.element('FourNodeTetrahedron', 4533, *[1577, 1726, 318, 1404], 1)
    ops.element('FourNodeTetrahedron', 4534, *[1726, 1400, 318, 1404], 1)
    ops.element('FourNodeTetrahedron', 4535, *[1292, 1455, 1295, 657], 1)
    ops.element('FourNodeTetrahedron', 4536, *[1726, 1400, 317, 318], 1)
    ops.element('FourNodeTetrahedron', 4537, *[351, 1606, 350, 354], 1)
    ops.element('FourNodeTetrahedron', 4538, *[1551, 1712, 1299, 607], 1)
    ops.element('FourNodeTetrahedron', 4539, *[1580, 416, 1331, 1515], 1)
    ops.element('FourNodeTetrahedron', 4540, *[1493, 1447, 1600, 1451], 1)
    ops.element('FourNodeTetrahedron', 4541, *[1524, 1503, 1610, 1420], 1)
    ops.element('FourNodeTetrahedron', 4542, *[1157, 175, 163, 176], 1)
    ops.element('FourNodeTetrahedron', 4543, *[1409, 1196, 1433, 1598], 1)
    ops.element('FourNodeTetrahedron', 4544, *[1610, 1503, 1506, 604], 1)
    ops.element('FourNodeTetrahedron', 4545, *[1692, 1441, 615, 619], 1)
    ops.element('FourNodeTetrahedron', 4546, *[1582, 406, 399, 405], 1)
    ops.element('FourNodeTetrahedron', 4547, *[1293, 531, 1576, 530], 1)
    ops.element('FourNodeTetrahedron', 4548, *[1378, 1334, 1367, 1717], 1)
    ops.element('FourNodeTetrahedron', 4549, *[1692, 1441, 1461, 615], 1)
    ops.element('FourNodeTetrahedron', 4550, *[631, 621, 1472, 625], 1)
    ops.element('FourNodeTetrahedron', 4551, *[1736, 1663, 475, 654], 1)
    ops.element('FourNodeTetrahedron', 4552, *[1420, 1503, 604, 605], 1)
    ops.element('FourNodeTetrahedron', 4553, *[1391, 1333, 246, 215], 1)
    ops.element('FourNodeTetrahedron', 4554, *[1515, 420, 431, 522], 1)
    ops.element('FourNodeTetrahedron', 4555, *[1420, 1503, 1610, 604], 1)
    ops.element('FourNodeTetrahedron', 4556, *[1584, 1524, 1610, 1420], 1)
    ops.element('FourNodeTetrahedron', 4557, *[276, 1651, 271, 1413], 1)
    ops.element('FourNodeTetrahedron', 4558, *[1329, 1572, 1322, 1552], 1)
    ops.element('FourNodeTetrahedron', 4559, *[1621, 1622, 1530, 1652], 1)
    ops.element('FourNodeTetrahedron', 4560, *[730, 722, 721, 1325], 1)
    ops.element('FourNodeTetrahedron', 4561, *[1222, 1220, 1447, 1126], 1)
    ops.element('FourNodeTetrahedron', 4562, *[300, 1558, 301, 1336], 1)
    ops.element('FourNodeTetrahedron', 4563, *[673, 1702, 674, 676], 1)
    ops.element('FourNodeTetrahedron', 4564, *[1631, 1390, 375, 1483], 1)
    ops.element('FourNodeTetrahedron', 4565, *[1727, 1570, 1607, 1480], 1)
    ops.element('FourNodeTetrahedron', 4566, *[374, 1631, 375, 361], 1)
    ops.element('FourNodeTetrahedron', 4567, *[1592, 1631, 374, 1421], 1)
    ops.element('FourNodeTetrahedron', 4568, *[1703, 711, 710, 1228], 1)
    ops.element('FourNodeTetrahedron', 4569, *[1408, 1701, 1449, 618], 1)
    ops.element('FourNodeTetrahedron', 4570, *[1537, 1536, 1371, 1505], 1)
    ops.element('FourNodeTetrahedron', 4571, *[1353, 1374, 1371, 1536], 1)
    ops.element('FourNodeTetrahedron', 4572, *[1353, 1536, 1371, 1537], 1)
    ops.element('FourNodeTetrahedron', 4573, *[1581, 1655, 1548, 1642], 1)
    ops.element('FourNodeTetrahedron', 4574, *[1670, 1188, 1394, 1571], 1)
    ops.element('FourNodeTetrahedron', 4575, *[254, 258, 253, 1360], 1)
    ops.element('FourNodeTetrahedron', 4576, *[252, 1314, 256, 1323], 1)
    ops.element('FourNodeTetrahedron', 4577, *[764, 1664, 765, 1527], 1)
    ops.element('FourNodeTetrahedron', 4578, *[1484, 1536, 1537, 1505], 1)
    ops.element('FourNodeTetrahedron', 4579, *[1727, 1607, 1557, 1604], 1)
    ops.element('FourNodeTetrahedron', 4580, *[1294, 1704, 1687, 655], 1)
    ops.element('FourNodeTetrahedron', 4581, *[1542, 1580, 1515, 1498], 1)
    ops.element('FourNodeTetrahedron', 4582, *[1285, 1344, 220, 1546], 1)
    ops.element('FourNodeTetrahedron', 4583, *[220, 1344, 1541, 1546], 1)
    ops.element('FourNodeTetrahedron', 4584, *[1359, 1569, 1350, 1575], 1)
    ops.element('FourNodeTetrahedron', 4585, *[1546, 1541, 220, 1374], 1)
    ops.element('FourNodeTetrahedron', 4586, *[1174, 1136, 1357, 1200], 1)
    ops.element('FourNodeTetrahedron', 4587, *[235, 1546, 220, 1374], 1)
    ops.element('FourNodeTetrahedron', 4588, *[1175, 1181, 630, 633], 1)
    ops.element('FourNodeTetrahedron', 4589, *[235, 1546, 1374, 1353], 1)
    ops.element('FourNodeTetrahedron', 4590, *[1310, 1546, 235, 1353], 1)
    ops.element('FourNodeTetrahedron', 4591, *[1353, 1546, 1374, 1536], 1)
    ops.element('FourNodeTetrahedron', 4592, *[663, 657, 1295, 656], 1)
    ops.element('FourNodeTetrahedron', 4593, *[1310, 1546, 1353, 1536], 1)
    ops.element('FourNodeTetrahedron', 4594, *[671, 675, 1469, 672], 1)
    ops.element('FourNodeTetrahedron', 4595, *[1285, 1546, 235, 1310], 1)
    ops.element('FourNodeTetrahedron', 4596, *[1285, 220, 235, 1546], 1)
    ops.element('FourNodeTetrahedron', 4597, *[1723, 1578, 1345, 1569], 1)
    ops.element('FourNodeTetrahedron', 4598, *[1729, 1640, 1621, 1652], 1)
    ops.element('FourNodeTetrahedron', 4599, *[489, 1462, 410, 488], 1)
    ops.element('FourNodeTetrahedron', 4600, *[250, 1276, 1539, 449], 1)
    ops.element('FourNodeTetrahedron', 4601, *[1623, 1621, 1412, 1618], 1)
    ops.element('FourNodeTetrahedron', 4602, *[1654, 1608, 1513, 1641], 1)
    ops.element('FourNodeTetrahedron', 4603, *[326, 1714, 330, 1405], 1)
    ops.element('FourNodeTetrahedron', 4604, *[1184, 1306, 1394, 1309], 1)
    ops.element('FourNodeTetrahedron', 4605, *[768, 762, 763, 1573], 1)
    ops.element('FourNodeTetrahedron', 4606, *[1657, 1605, 286, 1357], 1)
    ops.element('FourNodeTetrahedron', 4607, *[396, 1507, 397, 403], 1)
    ops.element('FourNodeTetrahedron', 4608, *[1305, 1636, 1347, 545], 1)
    ops.element('FourNodeTetrahedron', 4609, *[1526, 1509, 1647, 1525], 1)
    ops.element('FourNodeTetrahedron', 4610, *[265, 252, 264, 1314], 1)
    ops.element('FourNodeTetrahedron', 4611, *[1563, 1313, 445, 601], 1)
    ops.element('FourNodeTetrahedron', 4612, *[659, 1676, 1436, 645], 1)
    ops.element('FourNodeTetrahedron', 4613, *[521, 677, 1702, 676], 1)
    ops.element('FourNodeTetrahedron', 4614, *[1322, 1489, 1679, 1316], 1)
    ops.element('FourNodeTetrahedron', 4615, *[284, 1342, 279, 259], 1)
    ops.element('FourNodeTetrahedron', 4616, *[1725, 1427, 1625, 1576], 1)
    ops.element('FourNodeTetrahedron', 4617, *[518, 1517, 520, 1616], 1)
    ops.element('FourNodeTetrahedron', 4618, *[1333, 707, 1740, 1397], 1)
    ops.element('FourNodeTetrahedron', 4619, *[1313, 1305, 239, 444], 1)
    ops.element('FourNodeTetrahedron', 4620, *[1223, 1234, 1375, 1235], 1)
    ops.element('FourNodeTetrahedron', 4621, *[682, 1158, 679, 511], 1)
    ops.element('FourNodeTetrahedron', 4622, *[1520, 1528, 1689, 1597], 1)
    ops.element('FourNodeTetrahedron', 4623, *[1667, 1185, 1395, 1137], 1)
    ops.element('FourNodeTetrahedron', 4624, *[1466, 1481, 1570, 1480], 1)
    ops.element('FourNodeTetrahedron', 4625, *[1372, 1187, 1669, 1611], 1)
    ops.element('FourNodeTetrahedron', 4626, *[1427, 1625, 1576, 525], 1)
    ops.element('FourNodeTetrahedron', 4627, *[1396, 155, 156, 148], 1)
    ops.element('FourNodeTetrahedron', 4628, *[1346, 704, 1402, 1599], 1)
    ops.element('FourNodeTetrahedron', 4629, *[1429, 1375, 1677, 1631], 1)
    ops.element('FourNodeTetrahedron', 4630, *[1613, 1425, 1724, 1594], 1)
    ops.element('FourNodeTetrahedron', 4631, *[1546, 1621, 1374, 1729], 1)
    ops.element('FourNodeTetrahedron', 4632, *[1278, 1529, 469, 660], 1)
    ops.element('FourNodeTetrahedron', 4633, *[1591, 1603, 1652, 1473], 1)
    ops.element('FourNodeTetrahedron', 4634, *[1501, 1445, 1446, 1720], 1)
    ops.element('FourNodeTetrahedron', 4635, *[1126, 1236, 1348, 1257], 1)
    ops.element('FourNodeTetrahedron', 4636, *[1494, 1649, 1460, 1702], 1)
    ops.element('FourNodeTetrahedron', 4637, *[1614, 1525, 1497, 1447], 1)
    ops.element('FourNodeTetrahedron', 4638, *[1150, 1525, 1614, 1447], 1)
    ops.element('FourNodeTetrahedron', 4639, *[1150, 1222, 1447, 1493], 1)
    ops.element('FourNodeTetrahedron', 4640, *[1150, 1447, 1614, 1493], 1)
    ops.element('FourNodeTetrahedron', 4641, *[1674, 160, 161, 157], 1)
    ops.element('FourNodeTetrahedron', 4642, *[1674, 160, 157, 156], 1)
    ops.element('FourNodeTetrahedron', 4643, *[1251, 1204, 1456, 1475], 1)
    ops.element('FourNodeTetrahedron', 4644, *[1312, 1527, 412, 1521], 1)
    ops.element('FourNodeTetrahedron', 4645, *[1351, 1708, 340, 1659], 1)
    ops.element('FourNodeTetrahedron', 4646, *[1373, 367, 377, 1362], 1)
    ops.element('FourNodeTetrahedron', 4647, *[283, 1418, 279, 284], 1)
    ops.element('FourNodeTetrahedron', 4648, *[1587, 1406, 1639, 1454], 1)
    ops.element('FourNodeTetrahedron', 4649, *[1406, 1438, 1523, 1639], 1)
    ops.element('FourNodeTetrahedron', 4650, *[1265, 680, 1448, 677], 1)
    ops.element('FourNodeTetrahedron', 4651, *[1594, 1550, 1445, 1426], 1)
    ops.element('FourNodeTetrahedron', 4652, *[1267, 1475, 1609, 1524], 1)
    ops.element('FourNodeTetrahedron', 4653, *[1624, 1622, 1370, 1530], 1)
    ops.element('FourNodeTetrahedron', 4654, *[1621, 1624, 1271, 1530], 1)
    ops.element('FourNodeTetrahedron', 4655, *[517, 1650, 1465, 1462], 1)
    ops.element('FourNodeTetrahedron', 4656, *[519, 1614, 517, 521], 1)
    ops.element('FourNodeTetrahedron', 4657, *[1624, 1370, 1271, 1530], 1)
    ops.element('FourNodeTetrahedron', 4658, *[1269, 152, 137, 1326], 1)
    ops.element('FourNodeTetrahedron', 4659, *[1530, 152, 1269, 1326], 1)
    ops.element('FourNodeTetrahedron', 4660, *[1453, 1406, 1587, 1454], 1)
    ops.element('FourNodeTetrahedron', 4661, *[1453, 1406, 1586, 1587], 1)
    ops.element('FourNodeTetrahedron', 4662, *[1514, 1505, 1636, 546], 1)
    ops.element('FourNodeTetrahedron', 4663, *[1716, 1714, 1403, 1444], 1)
    ops.element('FourNodeTetrahedron', 4664, *[1514, 546, 1636, 545], 1)
    ops.element('FourNodeTetrahedron', 4665, *[1415, 390, 1470, 1500], 1)
    ops.element('FourNodeTetrahedron', 4666, *[1158, 1229, 1448, 1699], 1)
    ops.element('FourNodeTetrahedron', 4667, *[1557, 1569, 1359, 1575], 1)
    ops.element('FourNodeTetrahedron', 4668, *[1526, 1263, 1300, 1516], 1)
    ops.element('FourNodeTetrahedron', 4669, *[1298, 149, 143, 1275], 1)
    ops.element('FourNodeTetrahedron', 4670, *[1585, 1543, 1550, 1292], 1)
    ops.element('FourNodeTetrahedron', 4671, *[153, 152, 1269, 1530], 1)
    ops.element('FourNodeTetrahedron', 4672, *[1271, 1370, 153, 1530], 1)
    ops.element('FourNodeTetrahedron', 4673, *[1370, 152, 153, 1530], 1)
    ops.element('FourNodeTetrahedron', 4674, *[1594, 1424, 1550, 1426], 1)
    ops.element('FourNodeTetrahedron', 4675, *[1672, 706, 1656, 1397], 1)
    ops.element('FourNodeTetrahedron', 4676, *[1184, 1227, 1306, 1240], 1)
    ops.element('FourNodeTetrahedron', 4677, *[673, 1494, 671, 674], 1)
    ops.element('FourNodeTetrahedron', 4678, *[364, 365, 378, 1393], 1)
    ops.element('FourNodeTetrahedron', 4679, *[1646, 1191, 1490, 1519], 1)
    ops.element('FourNodeTetrahedron', 4680, *[1650, 1518, 372, 1613], 1)
    ops.element('FourNodeTetrahedron', 4681, *[1493, 1447, 1614, 1600], 1)
    ops.element('FourNodeTetrahedron', 4682, *[1460, 1424, 1594, 1426], 1)
    ops.element('FourNodeTetrahedron', 4683, *[390, 1485, 383, 391], 1)
    ops.element('FourNodeTetrahedron', 4684, *[1162, 1143, 1668, 1590], 1)
    ops.element('FourNodeTetrahedron', 4685, *[1600, 1550, 1594, 1424], 1)
    ops.element('FourNodeTetrahedron', 4686, *[1600, 1585, 1550, 1424], 1)
    ops.element('FourNodeTetrahedron', 4687, *[1522, 1130, 1646, 1215], 1)
    ops.element('FourNodeTetrahedron', 4688, *[1688, 1519, 1725, 1427], 1)
    ops.element('FourNodeTetrahedron', 4689, *[1284, 1504, 1712, 1551], 1)
    ops.element('FourNodeTetrahedron', 4690, *[714, 221, 213, 707], 1)
    ops.element('FourNodeTetrahedron', 4691, *[1579, 1153, 1386, 1681], 1)
    ops.element('FourNodeTetrahedron', 4692, *[340, 1659, 307, 344], 1)
    ops.element('FourNodeTetrahedron', 4693, *[1572, 1593, 627, 630], 1)
    ops.element('FourNodeTetrahedron', 4694, *[1358, 188, 432, 431], 1)
    ops.element('FourNodeTetrahedron', 4695, *[1380, 1650, 1528, 1494], 1)
    ops.element('FourNodeTetrahedron', 4696, *[735, 732, 285, 1605], 1)
    ops.element('FourNodeTetrahedron', 4697, *[366, 1450, 367, 1373], 1)
    ops.element('FourNodeTetrahedron', 4698, *[1305, 1347, 231, 442], 1)
    ops.element('FourNodeTetrahedron', 4699, *[1284, 1360, 1314, 1562], 1)
    ops.element('FourNodeTetrahedron', 4700, *[1149, 177, 1510, 155], 1)
    ops.element('FourNodeTetrahedron', 4701, *[286, 1357, 1605, 1434], 1)
    ops.element('FourNodeTetrahedron', 4702, *[368, 328, 324, 1329], 1)
    ops.element('FourNodeTetrahedron', 4703, *[368, 1496, 328, 1329], 1)
    ops.element('FourNodeTetrahedron', 4704, *[1315, 1595, 405, 376], 1)
    ops.element('FourNodeTetrahedron', 4705, *[250, 449, 1539, 448], 1)
    ops.element('FourNodeTetrahedron', 4706, *[286, 1605, 281, 1434], 1)
    ops.element('FourNodeTetrahedron', 4707, *[1185, 1183, 1660, 1388], 1)
    ops.element('FourNodeTetrahedron', 4708, *[705, 1402, 703, 1422], 1)
    ops.element('FourNodeTetrahedron', 4709, *[1531, 724, 714, 1349], 1)
    ops.element('FourNodeTetrahedron', 4710, *[1636, 1478, 1474, 546], 1)
    ops.element('FourNodeTetrahedron', 4711, *[1353, 1374, 233, 1371], 1)
    ops.element('FourNodeTetrahedron', 4712, *[286, 1605, 285, 281], 1)
    ops.element('FourNodeTetrahedron', 4713, *[311, 1547, 315, 316], 1)
    ops.element('FourNodeTetrahedron', 4714, *[310, 736, 315, 1547], 1)
    ops.element('FourNodeTetrahedron', 4715, *[1155, 1232, 550, 551], 1)
    ops.element('FourNodeTetrahedron', 4716, *[310, 1547, 315, 311], 1)
    ops.element('FourNodeTetrahedron', 4717, *[444, 545, 442, 441], 1)
    ops.element('FourNodeTetrahedron', 4718, *[1356, 158, 173, 1272], 1)
    ops.element('FourNodeTetrahedron', 4719, *[1306, 1338, 289, 251], 1)
    ops.element('FourNodeTetrahedron', 4720, *[736, 739, 734, 1547], 1)
    ops.element('FourNodeTetrahedron', 4721, *[1131, 1184, 1564, 1195], 1)
    ops.element('FourNodeTetrahedron', 4722, *[1564, 1195, 1309, 1471], 1)
    ops.element('FourNodeTetrahedron', 4723, *[545, 440, 442, 441], 1)
    ops.element('FourNodeTetrahedron', 4724, *[1398, 1675, 1431, 629], 1)
    ops.element('FourNodeTetrahedron', 4725, *[1304, 1547, 310, 311], 1)
    ops.element('FourNodeTetrahedron', 4726, *[1361, 1417, 311, 312], 1)
    ops.element('FourNodeTetrahedron', 4727, *[311, 1547, 316, 1417], 1)
    ops.element('FourNodeTetrahedron', 4728, *[311, 1417, 316, 312], 1)
    ops.element('FourNodeTetrahedron', 4729, *[1361, 1547, 311, 1417], 1)
    ops.element('FourNodeTetrahedron', 4730, *[492, 491, 489, 484], 1)
    ops.element('FourNodeTetrahedron', 4731, *[281, 1605, 1428, 1434], 1)
    ops.element('FourNodeTetrahedron', 4732, *[1212, 1148, 1675, 653], 1)
    ops.element('FourNodeTetrahedron', 4733, *[1361, 1144, 1547, 1417], 1)
    ops.element('FourNodeTetrahedron', 4734, *[743, 338, 1658, 1602], 1)
    ops.element('FourNodeTetrahedron', 4735, *[747, 748, 1416, 1169], 1)
    ops.element('FourNodeTetrahedron', 4736, *[233, 220, 229, 1374], 1)
    ops.element('FourNodeTetrahedron', 4737, *[1602, 1320, 337, 342], 1)
    ops.element('FourNodeTetrahedron', 4738, *[513, 1647, 518, 519], 1)
    ops.element('FourNodeTetrahedron', 4739, *[270, 720, 719, 271], 1)
    ops.element('FourNodeTetrahedron', 4740, *[261, 236, 1744, 1537], 1)
    ops.element('FourNodeTetrahedron', 4741, *[742, 1320, 337, 1602], 1)
    ops.element('FourNodeTetrahedron', 4742, *[531, 524, 1576, 530], 1)
    ops.element('FourNodeTetrahedron', 4743, *[744, 1485, 383, 390], 1)
    ops.element('FourNodeTetrahedron', 4744, *[1344, 1272, 218, 222], 1)
    ops.element('FourNodeTetrahedron', 4745, *[1347, 1474, 1277, 1296], 1)
    ops.element('FourNodeTetrahedron', 4746, *[545, 1474, 1347, 1296], 1)
    ops.element('FourNodeTetrahedron', 4747, *[398, 1414, 399, 1410], 1)
    ops.element('FourNodeTetrahedron', 4748, *[1472, 1574, 1511, 1709], 1)
    ops.element('FourNodeTetrahedron', 4749, *[1472, 1194, 1574, 1709], 1)
    ops.element('FourNodeTetrahedron', 4750, *[1607, 1439, 1586, 1453], 1)
    ops.element('FourNodeTetrahedron', 4751, *[1578, 1439, 1586, 1607], 1)
    ops.element('FourNodeTetrahedron', 4752, *[1307, 1151, 1302, 1434], 1)
    ops.element('FourNodeTetrahedron', 4753, *[1296, 1555, 433, 1468], 1)
    ops.element('FourNodeTetrahedron', 4754, *[268, 1321, 238, 447], 1)
    ops.element('FourNodeTetrahedron', 4755, *[1644, 1522, 1645, 1653], 1)
    ops.element('FourNodeTetrahedron', 4756, *[1344, 1356, 1272, 1588], 1)
    ops.element('FourNodeTetrahedron', 4757, *[631, 1472, 1467, 625], 1)
    ops.element('FourNodeTetrahedron', 4758, *[399, 1590, 351, 1124], 1)
    ops.element('FourNodeTetrahedron', 4759, *[1641, 1376, 1721, 1495], 1)
    ops.element('FourNodeTetrahedron', 4760, *[1381, 1403, 329, 1329], 1)
    ops.element('FourNodeTetrahedron', 4761, *[266, 1360, 265, 1290], 1)
    ops.element('FourNodeTetrahedron', 4762, *[290, 265, 264, 1332], 1)
    ops.element('FourNodeTetrahedron', 4763, *[361, 375, 362, 1483], 1)
    ops.element('FourNodeTetrahedron', 4764, *[1554, 1440, 1638, 1433], 1)
    ops.element('FourNodeTetrahedron', 4765, *[1478, 1283, 1544, 1281], 1)
    ops.element('FourNodeTetrahedron', 4766, *[328, 329, 325, 1329], 1)
    ops.element('FourNodeTetrahedron', 4767, *[1481, 1439, 1607, 1453], 1)
    ops.element('FourNodeTetrahedron', 4768, *[1294, 1704, 655, 662], 1)
    ops.element('FourNodeTetrahedron', 4769, *[1723, 1703, 1578, 1607], 1)
    ops.element('FourNodeTetrahedron', 4770, *[1231, 1135, 1486, 1216], 1)
    ops.element('FourNodeTetrahedron', 4771, *[1347, 1407, 1534, 1636], 1)
    ops.element('FourNodeTetrahedron', 4772, *[521, 1734, 676, 510], 1)
    ops.element('FourNodeTetrahedron', 4773, *[1472, 621, 1709, 625], 1)
    ops.element('FourNodeTetrahedron', 4774, *[1231, 1135, 1267, 1486], 1)
    ops.element('FourNodeTetrahedron', 4775, *[1523, 160, 161, 1513], 1)
    ops.element('FourNodeTetrahedron', 4776, *[1514, 1505, 546, 602], 1)
    ops.element('FourNodeTetrahedron', 4777, *[1409, 1196, 1598, 611], 1)
    ops.element('FourNodeTetrahedron', 4778, *[399, 1124, 351, 1582], 1)
    ops.element('FourNodeTetrahedron', 4779, *[1451, 1126, 1348, 1257], 1)
    ops.element('FourNodeTetrahedron', 4780, *[1519, 1625, 1556, 1725], 1)
    ops.element('FourNodeTetrahedron', 4781, *[1472, 1709, 1511, 625], 1)
    ops.element('FourNodeTetrahedron', 4782, *[1201, 1202, 1430, 1123], 1)
    ops.element('FourNodeTetrahedron', 4783, *[1219, 1225, 1340, 1121], 1)
    ops.element('FourNodeTetrahedron', 4784, *[1443, 1557, 1575, 1604], 1)
    ops.element('FourNodeTetrahedron', 4785, *[1217, 1247, 1410, 1219], 1)
    ops.element('FourNodeTetrahedron', 4786, *[1528, 1469, 1685, 1459], 1)
    ops.element('FourNodeTetrahedron', 4787, *[1499, 161, 162, 1479], 1)
    ops.element('FourNodeTetrahedron', 4788, *[1326, 1280, 1331, 1542], 1)
    ops.element('FourNodeTetrahedron', 4789, *[1428, 1325, 1651, 1633], 1)
    ops.element('FourNodeTetrahedron', 4790, *[1516, 1507, 396, 403], 1)
    ops.element('FourNodeTetrahedron', 4791, *[1600, 1585, 1421, 1550], 1)
    ops.element('FourNodeTetrahedron', 4792, *[1199, 733, 1307, 1151], 1)
    ops.element('FourNodeTetrahedron', 4793, *[1425, 1592, 1421, 1600], 1)
    ops.element('FourNodeTetrahedron', 4794, *[1524, 1155, 1503, 1420], 1)
    ops.element('FourNodeTetrahedron', 4795, *[601, 1514, 1313, 545], 1)
    ops.element('FourNodeTetrahedron', 4796, *[1600, 1592, 1421, 1585], 1)
    ops.element('FourNodeTetrahedron', 4797, *[1390, 1341, 1612, 1389], 1)
    ops.element('FourNodeTetrahedron', 4798, *[1642, 1640, 1729, 1502], 1)
    ops.element('FourNodeTetrahedron', 4799, *[1425, 360, 359, 1632], 1)
    ops.element('FourNodeTetrahedron', 4800, *[1425, 1632, 359, 1445], 1)
    ops.element('FourNodeTetrahedron', 4801, *[1590, 1193, 1658, 1661], 1)
    ops.element('FourNodeTetrahedron', 4802, *[1326, 138, 1358, 1318], 1)
    ops.element('FourNodeTetrahedron', 4803, *[1318, 139, 188, 431], 1)
    ops.element('FourNodeTetrahedron', 4804, *[1127, 1209, 1481, 1480], 1)
    ops.element('FourNodeTetrahedron', 4805, *[1594, 1425, 1445, 1550], 1)
    ops.element('FourNodeTetrahedron', 4806, *[513, 1647, 1526, 1525], 1)
    ops.element('FourNodeTetrahedron', 4807, *[513, 1246, 1525, 1150], 1)
    ops.element('FourNodeTetrahedron', 4808, *[1526, 1246, 1509, 1525], 1)
    ops.element('FourNodeTetrahedron', 4809, *[1425, 1632, 1445, 1550], 1)
    ops.element('FourNodeTetrahedron', 4810, *[1324, 1327, 1310, 1634], 1)
    ops.element('FourNodeTetrahedron', 4811, *[1645, 1654, 1588, 1641], 1)
    ops.element('FourNodeTetrahedron', 4812, *[1620, 1581, 1327, 1642], 1)
    ops.element('FourNodeTetrahedron', 4813, *[1566, 417, 1298, 1580], 1)
    ops.element('FourNodeTetrahedron', 4814, *[1347, 1534, 1273, 1277], 1)
    ops.element('FourNodeTetrahedron', 4815, *[1647, 1516, 1518, 1497], 1)
    ops.element('FourNodeTetrahedron', 4816, *[1366, 1398, 1492, 1365], 1)
    ops.element('FourNodeTetrahedron', 4817, *[1342, 1644, 1419, 1581], 1)
    ops.element('FourNodeTetrahedron', 4818, *[1438, 159, 1674, 1510], 1)
    ops.element('FourNodeTetrahedron', 4819, *[1571, 1394, 314, 297], 1)
    ops.element('FourNodeTetrahedron', 4820, *[1433, 1156, 1486, 1598], 1)
    ops.element('FourNodeTetrahedron', 4821, *[258, 261, 257, 1324], 1)
    ops.element('FourNodeTetrahedron', 4822, *[1705, 718, 717, 710], 1)
    ops.element('FourNodeTetrahedron', 4823, *[1294, 655, 1663, 661], 1)
    ops.element('FourNodeTetrahedron', 4824, *[262, 1310, 236, 1737], 1)
    ops.element('FourNodeTetrahedron', 4825, *[360, 361, 366, 1632], 1)
    ops.element('FourNodeTetrahedron', 4826, *[1589, 1208, 1480, 1456], 1)
    ops.element('FourNodeTetrahedron', 4827, *[1372, 1197, 341, 344], 1)
    ops.element('FourNodeTetrahedron', 4828, *[1465, 1616, 371, 1650], 1)
    ops.element('FourNodeTetrahedron', 4829, *[1655, 1643, 1653, 1640], 1)
    ops.element('FourNodeTetrahedron', 4830, *[462, 1322, 322, 463], 1)
    ops.element('FourNodeTetrahedron', 4831, *[1679, 1405, 1706, 1489], 1)
    ops.element('FourNodeTetrahedron', 4832, *[1679, 1706, 327, 1316], 1)
    ops.element('FourNodeTetrahedron', 4833, *[1407, 1618, 1532, 1534], 1)
    ops.element('FourNodeTetrahedron', 4834, *[1201, 1206, 1430, 1202], 1)
    ops.element('FourNodeTetrahedron', 4835, *[525, 526, 1238, 423], 1)
    ops.element('FourNodeTetrahedron', 4836, *[1336, 1401, 1471, 1574], 1)
    ops.element('FourNodeTetrahedron', 4837, *[1412, 1532, 223, 1713], 1)
    ops.element('FourNodeTetrahedron', 4838, *[1695, 1697, 602, 603], 1)
    ops.element('FourNodeTetrahedron', 4839, *[534, 1281, 527, 533], 1)
    ops.element('FourNodeTetrahedron', 4840, *[1287, 1169, 1416, 1437], 1)
    ops.element('FourNodeTetrahedron', 4841, *[317, 1417, 287, 1400], 1)
    ops.element('FourNodeTetrahedron', 4842, *[219, 1350, 216, 218], 1)
    ops.element('FourNodeTetrahedron', 4843, *[759, 1239, 1686, 1159], 1)
    ops.element('FourNodeTetrahedron', 4844, *[1239, 1169, 1686, 1287], 1)
    ops.element('FourNodeTetrahedron', 4845, *[1385, 1286, 388, 1517], 1)
    ops.element('FourNodeTetrahedron', 4846, *[1607, 1730, 1575, 1630], 1)
    ops.element('FourNodeTetrahedron', 4847, *[385, 1668, 339, 343], 1)
    ops.element('FourNodeTetrahedron', 4848, *[759, 758, 760, 1686], 1)
    ops.element('FourNodeTetrahedron', 4849, *[1165, 1245, 351, 1124], 1)
    ops.element('FourNodeTetrahedron', 4850, *[759, 1686, 760, 1159], 1)
    ops.element('FourNodeTetrahedron', 4851, *[626, 1572, 1552, 627], 1)
    ops.element('FourNodeTetrahedron', 4852, *[1363, 1359, 247, 217], 1)
    ops.element('FourNodeTetrahedron', 4853, *[271, 719, 1531, 1317], 1)
    ops.element('FourNodeTetrahedron', 4854, *[1699, 684, 681, 680], 1)
    ops.element('FourNodeTetrahedron', 4855, *[607, 601, 1563, 451], 1)
    ops.element('FourNodeTetrahedron', 4856, *[1421, 1631, 1483, 1543], 1)
    ops.element('FourNodeTetrahedron', 4857, *[1592, 1442, 1631, 1421], 1)
    ops.element('FourNodeTetrahedron', 4858, *[1430, 1206, 1718, 1202], 1)
    ops.element('FourNodeTetrahedron', 4859, *[1360, 1327, 1324, 1620], 1)
    ops.element('FourNodeTetrahedron', 4860, *[1410, 1247, 1582, 1164], 1)
    ops.element('FourNodeTetrahedron', 4861, *[1635, 1519, 1556, 1725], 1)
    ops.element('FourNodeTetrahedron', 4862, *[1556, 1298, 1549, 1626], 1)
    ops.element('FourNodeTetrahedron', 4863, *[1556, 1298, 1626, 1566], 1)
    ops.element('FourNodeTetrahedron', 4864, *[1510, 155, 156, 1396], 1)
    ops.element('FourNodeTetrahedron', 4865, *[713, 175, 1743, 1157], 1)
    ops.element('FourNodeTetrahedron', 4866, *[1619, 1556, 1626, 1567], 1)
    ops.element('FourNodeTetrahedron', 4867, *[474, 1736, 470, 660], 1)
    ops.element('FourNodeTetrahedron', 4868, *[1562, 1620, 1634, 1477], 1)
    ops.element('FourNodeTetrahedron', 4869, *[1513, 1510, 1674, 1495], 1)
    ops.element('FourNodeTetrahedron', 4870, *[1524, 1648, 1643, 1503], 1)
    ops.element('FourNodeTetrahedron', 4871, *[1524, 1643, 1610, 1503], 1)
    ops.element('FourNodeTetrahedron', 4872, *[1394, 1306, 293, 1309], 1)
    ops.element('FourNodeTetrahedron', 4873, *[1267, 1135, 1524, 1486], 1)
    ops.element('FourNodeTetrahedron', 4874, *[678, 664, 1424, 663], 1)
    ops.element('FourNodeTetrahedron', 4875, *[1610, 1643, 1506, 1503], 1)
    ops.element('FourNodeTetrahedron', 4876, *[1141, 1157, 1599, 1170], 1)
    ops.element('FourNodeTetrahedron', 4877, *[1649, 1493, 1627, 1448], 1)
    ops.element('FourNodeTetrahedron', 4878, *[1520, 1601, 488, 486], 1)
    ops.element('FourNodeTetrahedron', 4879, *[521, 1493, 1649, 1448], 1)
    ops.element('FourNodeTetrahedron', 4880, *[341, 1351, 1659, 1197], 1)
    ops.element('FourNodeTetrahedron', 4881, *[341, 1659, 340, 344], 1)
    ops.element('FourNodeTetrahedron', 4882, *[1282, 1408, 1319, 624], 1)
    ops.element('FourNodeTetrahedron', 4883, *[1421, 1483, 361, 1450], 1)
    ops.element('FourNodeTetrahedron', 4884, *[1356, 1629, 1479, 1553], 1)
    ops.element('FourNodeTetrahedron', 4885, *[1170, 176, 159, 177], 1)
    ops.element('FourNodeTetrahedron', 4886, *[523, 420, 1515, 421], 1)
    ops.element('FourNodeTetrahedron', 4887, *[1296, 527, 437, 438], 1)
    ops.element('FourNodeTetrahedron', 4888, *[1344, 1272, 1541, 1624], 1)
    ops.element('FourNodeTetrahedron', 4889, *[1567, 1725, 1626, 1488], 1)
    ops.element('FourNodeTetrahedron', 4890, *[1565, 1727, 1557, 1443], 1)
    ops.element('FourNodeTetrahedron', 4891, *[1535, 1620, 1562, 1477], 1)
    ops.element('FourNodeTetrahedron', 4892, *[1535, 1584, 1620, 1477], 1)
    ops.element('FourNodeTetrahedron', 4893, *[213, 1740, 221, 214], 1)
    ops.element('FourNodeTetrahedron', 4894, *[1548, 1653, 1546, 1621], 1)
    ops.element('FourNodeTetrahedron', 4895, *[1665, 1279, 186, 1355], 1)
    ops.element('FourNodeTetrahedron', 4896, *[1296, 1468, 437, 527], 1)
    ops.element('FourNodeTetrahedron', 4897, *[1176, 1137, 1716, 1175], 1)
    ops.element('FourNodeTetrahedron', 4898, *[1560, 1268, 1344, 1546], 1)
    ops.element('FourNodeTetrahedron', 4899, *[1522, 1646, 1731, 1643], 1)
    ops.element('FourNodeTetrahedron', 4900, *[149, 143, 142, 1298], 1)
    ops.element('FourNodeTetrahedron', 4901, *[293, 251, 267, 1369], 1)
    ops.element('FourNodeTetrahedron', 4902, *[1123, 1203, 1338, 1432], 1)
    ops.element('FourNodeTetrahedron', 4903, *[333, 334, 329, 1714], 1)
    ops.element('FourNodeTetrahedron', 4904, *[537, 1673, 531, 538], 1)
    ops.element('FourNodeTetrahedron', 4905, *[521, 1493, 1614, 1649], 1)
    ops.element('FourNodeTetrahedron', 4906, *[1310, 1642, 1536, 1634], 1)
    ops.element('FourNodeTetrahedron', 4907, *[1362, 1301, 473, 1662], 1)
    ops.element('FourNodeTetrahedron', 4908, *[326, 330, 327, 1405], 1)
    ops.element('FourNodeTetrahedron', 4909, *[1310, 1642, 1548, 1536], 1)
    ops.element('FourNodeTetrahedron', 4910, *[1546, 1624, 1541, 1621], 1)
    ops.element('FourNodeTetrahedron', 4911, *[518, 1517, 516, 520], 1)
    ops.element('FourNodeTetrahedron', 4912, *[1589, 1604, 1418, 1342], 1)
    ops.element('FourNodeTetrahedron', 4913, *[1589, 1456, 1604, 1342], 1)
    ops.element('FourNodeTetrahedron', 4914, *[1496, 1423, 328, 1329], 1)
    ops.element('FourNodeTetrahedron', 4915, *[1418, 1604, 1419, 1342], 1)
    ops.element('FourNodeTetrahedron', 4916, *[1383, 1609, 1620, 1584], 1)
    ops.element('FourNodeTetrahedron', 4917, *[1339, 717, 709, 710], 1)
    ops.element('FourNodeTetrahedron', 4918, *[1339, 716, 1345, 709], 1)
    ops.element('FourNodeTetrahedron', 4919, *[1339, 717, 716, 709], 1)
    ops.element('FourNodeTetrahedron', 4920, *[1418, 1604, 1443, 1419], 1)
    ops.element('FourNodeTetrahedron', 4921, *[1443, 1604, 1575, 1560], 1)
    ops.element('FourNodeTetrahedron', 4922, *[1540, 154, 152, 1326], 1)
    ops.element('FourNodeTetrahedron', 4923, *[1540, 151, 154, 1280], 1)
    ops.element('FourNodeTetrahedron', 4924, *[1540, 154, 1326, 1280], 1)
    ops.element('FourNodeTetrahedron', 4925, *[1376, 151, 152, 1540], 1)
    ops.element('FourNodeTetrahedron', 4926, *[1673, 525, 531, 532], 1)
    ops.element('FourNodeTetrahedron', 4927, *[1340, 1225, 1595, 1315], 1)
    ops.element('FourNodeTetrahedron', 4928, *[223, 1532, 184, 1407], 1)
    ops.element('FourNodeTetrahedron', 4929, *[1673, 1427, 531, 525], 1)
    ops.element('FourNodeTetrahedron', 4930, *[1350, 1629, 1356, 1553], 1)
    ops.element('FourNodeTetrahedron', 4931, *[1654, 1523, 1499, 1513], 1)
    ops.element('FourNodeTetrahedron', 4932, *[1540, 1376, 151, 1549], 1)
    ops.element('FourNodeTetrahedron', 4933, *[1540, 1549, 151, 1280], 1)
    ops.element('FourNodeTetrahedron', 4934, *[1351, 1142, 1708, 1659], 1)
    ops.element('FourNodeTetrahedron', 4935, *[1587, 1586, 1629, 1654], 1)
    ops.element('FourNodeTetrahedron', 4936, *[1741, 1606, 351, 355], 1)
    ops.element('FourNodeTetrahedron', 4937, *[740, 305, 336, 1351], 1)
    ops.element('FourNodeTetrahedron', 4938, *[1708, 305, 306, 340], 1)
    ops.element('FourNodeTetrahedron', 4939, *[621, 1709, 617, 622], 1)
    ops.element('FourNodeTetrahedron', 4940, *[1699, 1368, 681, 684], 1)
    ops.element('FourNodeTetrahedron', 4941, *[187, 1742, 183, 186], 1)
    ops.element('FourNodeTetrahedron', 4942, *[1517, 394, 1521, 520], 1)
    ops.element('FourNodeTetrahedron', 4943, *[1448, 1699, 1368, 681], 1)
    ops.element('FourNodeTetrahedron', 4944, *[219, 1344, 218, 220], 1)
    ops.element('FourNodeTetrahedron', 4945, *[1521, 387, 393, 394], 1)
    ops.element('FourNodeTetrahedron', 4946, *[1367, 1289, 290, 1377], 1)
    ops.element('FourNodeTetrahedron', 4947, *[366, 361, 367, 1450], 1)
    ops.element('FourNodeTetrahedron', 4948, *[1621, 1652, 1618, 1591], 1)
    ops.element('FourNodeTetrahedron', 4949, *[1609, 1524, 1584, 1610], 1)
    ops.element('FourNodeTetrahedron', 4950, *[1560, 1588, 1344, 1268], 1)
    ops.element('FourNodeTetrahedron', 4951, *[1638, 1267, 1609, 1584], 1)
    ops.element('FourNodeTetrahedron', 4952, *[1231, 1267, 1486, 1433], 1)
    ops.element('FourNodeTetrahedron', 4953, *[1350, 1629, 1387, 1356], 1)
    ops.element('FourNodeTetrahedron', 4954, *[1556, 1625, 1275, 1566], 1)
    ops.element('FourNodeTetrahedron', 4955, *[1638, 1486, 1267, 1433], 1)
    ops.element('FourNodeTetrahedron', 4956, *[341, 1197, 1659, 344], 1)
    ops.element('FourNodeTetrahedron', 4957, *[1730, 1587, 1629, 1553], 1)
    ops.element('FourNodeTetrahedron', 4958, *[1730, 1629, 1350, 1553], 1)
    ops.element('FourNodeTetrahedron', 4959, *[1575, 1730, 1350, 1553], 1)
    ops.element('FourNodeTetrahedron', 4960, *[1730, 1629, 1569, 1350], 1)
    ops.element('FourNodeTetrahedron', 4961, *[1596, 1567, 1603, 1293], 1)
    ops.element('FourNodeTetrahedron', 4962, *[1291, 1567, 1545, 1488], 1)
    ops.element('FourNodeTetrahedron', 4963, *[1603, 1293, 1567, 1291], 1)
    ops.element('FourNodeTetrahedron', 4964, *[1652, 1622, 1540, 1619], 1)
    ops.element('FourNodeTetrahedron', 4965, *[1530, 1540, 1628, 1652], 1)
    ops.element('FourNodeTetrahedron', 4966, *[1622, 1540, 1530, 1652], 1)
    ops.element('FourNodeTetrahedron', 4967, *[1704, 1295, 656, 663], 1)
    ops.element('FourNodeTetrahedron', 4968, *[1159, 1239, 1686, 1287], 1)
    ops.element('FourNodeTetrahedron', 4969, *[760, 1686, 758, 1287], 1)
    ops.element('FourNodeTetrahedron', 4970, *[1641, 1495, 1376, 1622], 1)
    ops.element('FourNodeTetrahedron', 4971, *[1540, 1549, 1280, 1619], 1)
    ops.element('FourNodeTetrahedron', 4972, *[1506, 1640, 1502, 1603], 1)
    ops.element('FourNodeTetrahedron', 4973, *[1473, 1545, 1617, 1283], 1)
    ops.element('FourNodeTetrahedron', 4974, *[763, 754, 764, 1385], 1)
    ops.element('FourNodeTetrahedron', 4975, *[1619, 1549, 1280, 1626], 1)
    ops.element('FourNodeTetrahedron', 4976, *[1657, 285, 286, 316], 1)
    ops.element('FourNodeTetrahedron', 4977, *[1651, 720, 271, 1317], 1)
    ops.element('FourNodeTetrahedron', 4978, *[1725, 1556, 1626, 1566], 1)
    ops.element('FourNodeTetrahedron', 4979, *[1702, 1700, 674, 677], 1)
    ops.element('FourNodeTetrahedron', 4980, *[1139, 1163, 1162, 1414], 1)
    ops.element('FourNodeTetrahedron', 4981, *[1617, 1628, 1538, 1542], 1)
    ops.element('FourNodeTetrahedron', 4982, *[671, 675, 1469, 674], 1)
    ops.element('FourNodeTetrahedron', 4983, *[1346, 1402, 1422, 1599], 1)
    ops.element('FourNodeTetrahedron', 4984, *[1586, 1599, 1422, 1523], 1)
    ops.element('FourNodeTetrahedron', 4985, *[367, 368, 377, 1362], 1)
    ops.element('FourNodeTetrahedron', 4986, *[1276, 1314, 1323, 1712], 1)
    ops.element('FourNodeTetrahedron', 4987, *[1617, 1619, 1628, 1542], 1)
    ops.element('FourNodeTetrahedron', 4988, *[1617, 1619, 1542, 1545], 1)
    ops.element('FourNodeTetrahedron', 4989, *[371, 372, 358, 1685], 1)
    ops.element('FourNodeTetrahedron', 4990, *[1497, 1429, 1677, 1592], 1)
    ops.element('FourNodeTetrahedron', 4991, *[218, 1272, 135, 222], 1)
    ops.element('FourNodeTetrahedron', 4992, *[1447, 1451, 1442, 1585], 1)
    ops.element('FourNodeTetrahedron', 4993, *[1595, 1392, 376, 1341], 1)
    ops.element('FourNodeTetrahedron', 4994, *[1473, 1619, 1617, 1545], 1)
    ops.element('FourNodeTetrahedron', 4995, *[1506, 1643, 1640, 1603], 1)
    ops.element('FourNodeTetrahedron', 4996, *[1583, 1723, 1569, 1557], 1)
    ops.element('FourNodeTetrahedron', 4997, *[1360, 1383, 1327, 1620], 1)
    ops.element('FourNodeTetrahedron', 4998, *[261, 1737, 236, 1537], 1)
    ops.element('FourNodeTetrahedron', 4999, *[1651, 720, 1317, 1330], 1)
    ops.element('FourNodeTetrahedron', 5000, *[306, 1361, 312, 307], 1)
    ops.element('FourNodeTetrahedron', 5001, *[1651, 1330, 1317, 1413], 1)
    ops.element('FourNodeTetrahedron', 5002, *[276, 1633, 1651, 1413], 1)
    ops.element('FourNodeTetrahedron', 5003, *[1633, 1330, 1651, 1413], 1)
    ops.element('FourNodeTetrahedron', 5004, *[1473, 1567, 1619, 1545], 1)
    ops.element('FourNodeTetrahedron', 5005, *[350, 349, 345, 1611], 1)
    ops.element('FourNodeTetrahedron', 5006, *[519, 1647, 1518, 1614], 1)
    ops.element('FourNodeTetrahedron', 5007, *[350, 1372, 345, 1611], 1)
    ops.element('FourNodeTetrahedron', 5008, *[1591, 1473, 1617, 1478], 1)
    ops.element('FourNodeTetrahedron', 5009, *[302, 294, 1377, 1319], 1)
    ops.element('FourNodeTetrahedron', 5010, *[1592, 1677, 374, 1631], 1)
    ops.element('FourNodeTetrahedron', 5011, *[1297, 1366, 1436, 645], 1)
    ops.element('FourNodeTetrahedron', 5012, *[1301, 320, 461, 1552], 1)
    ops.element('FourNodeTetrahedron', 5013, *[1352, 1159, 1287, 1134], 1)
    ops.element('FourNodeTetrahedron', 5014, *[1552, 1364, 462, 466], 1)
    ops.element('FourNodeTetrahedron', 5015, *[1324, 1620, 1634, 1562], 1)
    ops.element('FourNodeTetrahedron', 5016, *[1228, 1157, 712, 1599], 1)
    ops.element('FourNodeTetrahedron', 5017, *[1489, 1512, 1467, 1593], 1)
    ops.element('FourNodeTetrahedron', 5018, *[1629, 1499, 1387, 1479], 1)
    ops.element('FourNodeTetrahedron', 5019, *[1387, 1499, 162, 1479], 1)
    ops.element('FourNodeTetrahedron', 5020, *[1586, 1499, 1397, 1629], 1)
    ops.element('FourNodeTetrahedron', 5021, *[1470, 1500, 390, 396], 1)
    ops.element('FourNodeTetrahedron', 5022, *[1586, 1422, 1397, 1499], 1)
    ops.element('FourNodeTetrahedron', 5023, *[1578, 1422, 1397, 1586], 1)
    ops.element('FourNodeTetrahedron', 5024, *[546, 1591, 1478, 547], 1)
    ops.element('FourNodeTetrahedron', 5025, *[1572, 1444, 1593, 630], 1)
    ops.element('FourNodeTetrahedron', 5026, *[546, 1281, 545, 533], 1)
    ops.element('FourNodeTetrahedron', 5027, *[1636, 1591, 1478, 546], 1)
    ops.element('FourNodeTetrahedron', 5028, *[1477, 1502, 1697, 1698], 1)
    ops.element('FourNodeTetrahedron', 5029, *[1616, 372, 371, 1650], 1)
    ops.element('FourNodeTetrahedron', 5030, *[282, 1434, 1633, 1399], 1)
    ops.element('FourNodeTetrahedron', 5031, *[1129, 1217, 1681, 1435], 1)
    ops.element('FourNodeTetrahedron', 5032, *[517, 1613, 1650, 1494], 1)
    ops.element('FourNodeTetrahedron', 5033, *[1627, 1600, 1594, 1424], 1)
    ops.element('FourNodeTetrahedron', 5034, *[517, 1650, 1462, 1380], 1)
    ops.element('FourNodeTetrahedron', 5035, *[1627, 1424, 1594, 1460], 1)
    ops.element('FourNodeTetrahedron', 5036, *[1460, 1627, 1424, 678], 1)
    ops.element('FourNodeTetrahedron', 5037, *[276, 1428, 1651, 1633], 1)
    ops.element('FourNodeTetrahedron', 5038, *[1628, 1619, 1280, 1542], 1)
    ops.element('FourNodeTetrahedron', 5039, *[1628, 1540, 1280, 1619], 1)
    ops.element('FourNodeTetrahedron', 5040, *[1536, 1502, 1623, 1505], 1)
    ops.element('FourNodeTetrahedron', 5041, *[1630, 1587, 1553, 1645], 1)
    ops.element('FourNodeTetrahedron', 5042, *[136, 152, 137, 1269], 1)
    ops.element('FourNodeTetrahedron', 5043, *[1618, 1538, 1534, 1617], 1)
    ops.element('FourNodeTetrahedron', 5044, *[1618, 1628, 1538, 1617], 1)
    ops.element('FourNodeTetrahedron', 5045, *[1502, 1591, 1623, 1505], 1)
    ops.element('FourNodeTetrahedron', 5046, *[1519, 1508, 1556, 1625], 1)
    ops.element('FourNodeTetrahedron', 5047, *[1249, 526, 1238, 525], 1)
    ops.element('FourNodeTetrahedron', 5048, *[1541, 1271, 1412, 1621], 1)
    ops.element('FourNodeTetrahedron', 5049, *[1458, 1230, 1417, 1726], 1)
    ops.element('FourNodeTetrahedron', 5050, *[317, 1417, 1400, 1726], 1)
    ops.element('FourNodeTetrahedron', 5051, *[1545, 1626, 1542, 1580], 1)
    ops.element('FourNodeTetrahedron', 5052, *[1245, 1166, 1606, 1241], 1)
    ops.element('FourNodeTetrahedron', 5053, *[1241, 1166, 1606, 1308], 1)
    ops.element('FourNodeTetrahedron', 5054, *[547, 1283, 1478, 534], 1)
    ops.element('FourNodeTetrahedron', 5055, *[1626, 1331, 1280, 1542], 1)
    ops.element('FourNodeTetrahedron', 5056, *[1618, 1530, 1628, 1538], 1)
    ops.element('FourNodeTetrahedron', 5057, *[1426, 1295, 1445, 1704], 1)
    ops.element('FourNodeTetrahedron', 5058, *[1553, 1629, 1479, 1654], 1)
    ops.element('FourNodeTetrahedron', 5059, *[1711, 1584, 1535, 1533], 1)
    ops.element('FourNodeTetrahedron', 5060, *[1410, 1164, 1582, 1340], 1)
    ops.element('FourNodeTetrahedron', 5061, *[239, 1305, 231, 444], 1)
    ops.element('FourNodeTetrahedron', 5062, *[239, 230, 231, 1305], 1)
    ops.element('FourNodeTetrahedron', 5063, *[1683, 1609, 1383, 1711], 1)
    ops.element('FourNodeTetrahedron', 5064, *[1618, 1530, 1532, 1538], 1)
    ops.element('FourNodeTetrahedron', 5065, *[1618, 1538, 1532, 1534], 1)
    ops.element('FourNodeTetrahedron', 5066, *[1672, 171, 166, 165], 1)
    ops.element('FourNodeTetrahedron', 5067, *[725, 715, 1260, 1345], 1)
    ops.element('FourNodeTetrahedron', 5068, *[1440, 1638, 1343, 1554], 1)
    ops.element('FourNodeTetrahedron', 5069, *[1267, 1524, 1609, 1584], 1)
    ops.element('FourNodeTetrahedron', 5070, *[1622, 1495, 1376, 1549], 1)
    ops.element('FourNodeTetrahedron', 5071, *[1229, 1146, 1699, 683], 1)
    ops.element('FourNodeTetrahedron', 5072, *[1652, 1619, 1617, 1473], 1)
    ops.element('FourNodeTetrahedron', 5073, *[1553, 1587, 1629, 1654], 1)
    ops.element('FourNodeTetrahedron', 5074, *[1393, 369, 469, 470], 1)
    ops.element('FourNodeTetrahedron', 5075, *[1224, 177, 1170, 1510], 1)
    ops.element('FourNodeTetrahedron', 5076, *[1158, 1229, 1699, 683], 1)
    ops.element('FourNodeTetrahedron', 5077, *[512, 1229, 521, 1158], 1)
    ops.element('FourNodeTetrahedron', 5078, *[462, 1322, 1364, 1552], 1)
    ops.element('FourNodeTetrahedron', 5079, *[1156, 1216, 1486, 1598], 1)
    ops.element('FourNodeTetrahedron', 5080, *[1622, 1376, 1370, 1540], 1)
    ops.element('FourNodeTetrahedron', 5081, *[1356, 1629, 1387, 1479], 1)
    ops.element('FourNodeTetrahedron', 5082, *[1622, 1370, 1530, 1540], 1)
    ops.element('FourNodeTetrahedron', 5083, *[1486, 1135, 1524, 1216], 1)
    ops.element('FourNodeTetrahedron', 5084, *[518, 1647, 1518, 519], 1)
    ops.element('FourNodeTetrahedron', 5085, *[1291, 530, 1488, 529], 1)
    ops.element('FourNodeTetrahedron', 5086, *[1479, 1513, 161, 1721], 1)
    ops.element('FourNodeTetrahedron', 5087, *[1460, 678, 675, 674], 1)
    ops.element('FourNodeTetrahedron', 5088, *[1300, 1437, 1263, 1526], 1)
    ops.element('FourNodeTetrahedron', 5089, *[1403, 1679, 326, 1322], 1)
    ops.element('FourNodeTetrahedron', 5090, *[1322, 1489, 1316, 1364], 1)
    ops.element('FourNodeTetrahedron', 5091, *[1371, 1623, 1559, 1505], 1)
    ops.element('FourNodeTetrahedron', 5092, *[1536, 1374, 1371, 1623], 1)
    ops.element('FourNodeTetrahedron', 5093, *[1536, 1623, 1371, 1505], 1)
    ops.element('FourNodeTetrahedron', 5094, *[1427, 1140, 1625, 1249], 1)
    ops.element('FourNodeTetrahedron', 5095, *[1430, 1418, 283, 284], 1)
    ops.element('FourNodeTetrahedron', 5096, *[1140, 1238, 1625, 1249], 1)
    ops.element('FourNodeTetrahedron', 5097, *[1140, 1270, 1625, 1238], 1)
    ops.element('FourNodeTetrahedron', 5098, *[1320, 1351, 336, 341], 1)
    ops.element('FourNodeTetrahedron', 5099, *[1140, 1270, 1508, 1625], 1)
    ops.element('FourNodeTetrahedron', 5100, *[327, 1336, 301, 1706], 1)
    ops.element('FourNodeTetrahedron', 5101, *[1282, 1408, 301, 1319], 1)
    ops.element('FourNodeTetrahedron', 5102, *[1706, 1408, 301, 1282], 1)
    ops.element('FourNodeTetrahedron', 5103, *[1649, 1493, 1600, 1627], 1)
    ops.element('FourNodeTetrahedron', 5104, *[1540, 1280, 1326, 1628], 1)
    ops.element('FourNodeTetrahedron', 5105, *[1530, 1540, 1326, 1628], 1)
    ops.element('FourNodeTetrahedron', 5106, *[1530, 1628, 1326, 1538], 1)
    ops.element('FourNodeTetrahedron', 5107, *[1628, 1326, 1538, 1542], 1)
    ops.element('FourNodeTetrahedron', 5108, *[1174, 1199, 1357, 1136], 1)
    ops.element('FourNodeTetrahedron', 5109, *[1624, 1370, 1272, 1271], 1)
    ops.element('FourNodeTetrahedron', 5110, *[1428, 729, 1651, 276], 1)
    ops.element('FourNodeTetrahedron', 5111, *[1651, 721, 720, 1330], 1)
    ops.element('FourNodeTetrahedron', 5112, *[729, 721, 720, 1651], 1)
    ops.element('FourNodeTetrahedron', 5113, *[729, 1325, 1651, 1428], 1)
    ops.element('FourNodeTetrahedron', 5114, *[1280, 1298, 1331, 1626], 1)
    ops.element('FourNodeTetrahedron', 5115, *[1626, 1298, 1331, 1580], 1)
    ops.element('FourNodeTetrahedron', 5116, *[1545, 1626, 1580, 1488], 1)
    ops.element('FourNodeTetrahedron', 5117, *[288, 1430, 283, 289], 1)
    ops.element('FourNodeTetrahedron', 5118, *[1647, 1509, 1507, 1525], 1)
    ops.element('FourNodeTetrahedron', 5119, *[1516, 1509, 1500, 1507], 1)
    ops.element('FourNodeTetrahedron', 5120, *[1647, 1525, 1507, 1497], 1)
    ops.element('FourNodeTetrahedron', 5121, *[1516, 1509, 1507, 1647], 1)
    ops.element('FourNodeTetrahedron', 5122, *[1423, 1381, 328, 1329], 1)
    ops.element('FourNodeTetrahedron', 5123, *[1518, 373, 372, 1613], 1)
    ops.element('FourNodeTetrahedron', 5124, *[1647, 1507, 1516, 1497], 1)
    ops.element('FourNodeTetrahedron', 5125, *[332, 1381, 328, 1423], 1)
    ops.element('FourNodeTetrahedron', 5126, *[1516, 1507, 403, 1497], 1)
    ops.element('FourNodeTetrahedron', 5127, *[1195, 1138, 1440, 1487], 1)
    ops.element('FourNodeTetrahedron', 5128, *[1513, 1438, 160, 1674], 1)
    ops.element('FourNodeTetrahedron', 5129, *[1511, 1701, 1408, 618], 1)
    ops.element('FourNodeTetrahedron', 5130, *[1639, 1510, 1513, 1608], 1)
    ops.element('FourNodeTetrahedron', 5131, *[1438, 159, 160, 1674], 1)
    ops.element('FourNodeTetrahedron', 5132, *[1635, 1519, 1728, 1556], 1)
    ops.element('FourNodeTetrahedron', 5133, *[680, 1699, 1448, 681], 1)
    ops.element('FourNodeTetrahedron', 5134, *[1727, 1570, 1723, 1607], 1)
    ops.element('FourNodeTetrahedron', 5135, *[1443, 1575, 1337, 1560], 1)
    ops.element('FourNodeTetrahedron', 5136, *[1557, 1607, 1575, 1604], 1)
    ops.element('FourNodeTetrahedron', 5137, *[1554, 1638, 1533, 1441], 1)
    ops.element('FourNodeTetrahedron', 5138, *[137, 154, 138, 1326], 1)
    ops.element('FourNodeTetrahedron', 5139, *[242, 1391, 247, 1363], 1)
    ops.element('FourNodeTetrahedron', 5140, *[729, 721, 1651, 1325], 1)
    ops.element('FourNodeTetrahedron', 5141, *[1513, 1438, 1674, 1510], 1)
    ops.element('FourNodeTetrahedron', 5142, *[273, 1391, 242, 1363], 1)
    ops.element('FourNodeTetrahedron', 5143, *[1157, 175, 1402, 163], 1)
    ops.element('FourNodeTetrahedron', 5144, *[1608, 1510, 1513, 1495], 1)
    ops.element('FourNodeTetrahedron', 5145, *[1598, 610, 1637, 616], 1)
    ops.element('FourNodeTetrahedron', 5146, *[1325, 726, 1710, 1311], 1)
    ops.element('FourNodeTetrahedron', 5147, *[615, 1637, 609, 616], 1)
    ops.element('FourNodeTetrahedron', 5148, *[1441, 616, 1637, 615], 1)
    ops.element('FourNodeTetrahedron', 5149, *[1409, 1433, 1441, 1598], 1)
    ops.element('FourNodeTetrahedron', 5150, *[1440, 1432, 1638, 1433], 1)
    ops.element('FourNodeTetrahedron', 5151, *[1696, 1467, 624, 631], 1)
    ops.element('FourNodeTetrahedron', 5152, *[1340, 1582, 405, 1595], 1)
    ops.element('FourNodeTetrahedron', 5153, *[1307, 1678, 730, 1302], 1)
    ops.element('FourNodeTetrahedron', 5154, *[482, 1521, 414, 1465], 1)
    ops.element('FourNodeTetrahedron', 5155, *[770, 1738, 769, 1733], 1)
    ops.element('FourNodeTetrahedron', 5156, *[1409, 1598, 1441, 616], 1)
    ops.element('FourNodeTetrahedron', 5157, *[1158, 683, 680, 682], 1)
    ops.element('FourNodeTetrahedron', 5158, *[1461, 1533, 1463, 1637], 1)
    ops.element('FourNodeTetrahedron', 5159, *[1486, 1420, 1584, 1637], 1)
    ops.element('FourNodeTetrahedron', 5160, *[385, 1668, 343, 392], 1)
    ops.element('FourNodeTetrahedron', 5161, *[1623, 1591, 1618, 1636], 1)
    ops.element('FourNodeTetrahedron', 5162, *[1636, 1618, 1534, 1478], 1)
    ops.element('FourNodeTetrahedron', 5163, *[1539, 1712, 1323, 1476], 1)
    ops.element('FourNodeTetrahedron', 5164, *[1636, 1591, 1618, 1478], 1)
    ops.element('FourNodeTetrahedron', 5165, *[527, 1468, 436, 522], 1)
    ops.element('FourNodeTetrahedron', 5166, *[1618, 1617, 1534, 1478], 1)
    ops.element('FourNodeTetrahedron', 5167, *[1591, 1617, 1618, 1478], 1)
    ops.element('FourNodeTetrahedron', 5168, *[1298, 417, 416, 1580], 1)
    ops.element('FourNodeTetrahedron', 5169, *[273, 1443, 1363, 274], 1)
    ops.element('FourNodeTetrahedron', 5170, *[1160, 1212, 1365, 652], 1)
    ops.element('FourNodeTetrahedron', 5171, *[1268, 1588, 1344, 1624], 1)
    ops.element('FourNodeTetrahedron', 5172, *[1451, 1126, 1442, 1348], 1)
    ops.element('FourNodeTetrahedron', 5173, *[1319, 1408, 618, 624], 1)
    ops.element('FourNodeTetrahedron', 5174, *[1623, 1621, 1618, 1591], 1)
    ops.element('FourNodeTetrahedron', 5175, *[1494, 674, 1469, 671], 1)
    ops.element('FourNodeTetrahedron', 5176, *[1387, 1672, 166, 162], 1)
    ops.element('FourNodeTetrahedron', 5177, *[1586, 1599, 1523, 1406], 1)
    ops.element('FourNodeTetrahedron', 5178, *[1721, 157, 158, 1376], 1)
    ops.element('FourNodeTetrahedron', 5179, *[1568, 1398, 1496, 1492], 1)
    ops.element('FourNodeTetrahedron', 5180, *[1379, 1446, 364, 1335], 1)
    ops.element('FourNodeTetrahedron', 5181, *[275, 720, 270, 271], 1)
    ops.element('FourNodeTetrahedron', 5182, *[1519, 1140, 1508, 1625], 1)
    ops.element('FourNodeTetrahedron', 5183, *[1327, 1581, 1548, 1642], 1)
    ops.element('FourNodeTetrahedron', 5184, *[1463, 1637, 1535, 1693], 1)
    ops.element('FourNodeTetrahedron', 5185, *[669, 1529, 1278, 660], 1)
    ops.element('FourNodeTetrahedron', 5186, *[1276, 1323, 252, 1539], 1)
    ops.element('FourNodeTetrahedron', 5187, *[521, 1448, 1649, 677], 1)
    ops.element('FourNodeTetrahedron', 5188, *[1166, 1187, 1611, 1122], 1)
    ops.element('FourNodeTetrahedron', 5189, *[1649, 1600, 1594, 1627], 1)
    ops.element('FourNodeTetrahedron', 5190, *[316, 1357, 286, 287], 1)
    ops.element('FourNodeTetrahedron', 5191, *[1649, 1627, 1594, 1460], 1)
    ops.element('FourNodeTetrahedron', 5192, *[1613, 1600, 1594, 1649], 1)
    ops.element('FourNodeTetrahedron', 5193, *[1150, 1221, 1525, 1220], 1)
    ops.element('FourNodeTetrahedron', 5194, *[1461, 1463, 1504, 614], 1)
    ops.element('FourNodeTetrahedron', 5195, *[1194, 1195, 1471, 1709], 1)
    ops.element('FourNodeTetrahedron', 5196, *[771, 759, 760, 1159], 1)
    ops.element('FourNodeTetrahedron', 5197, *[1529, 1294, 1663, 661], 1)
    ops.element('FourNodeTetrahedron', 5198, *[682, 1158, 679, 680], 1)
    ops.element('FourNodeTetrahedron', 5199, *[1507, 1435, 397, 404], 1)
    ops.element('FourNodeTetrahedron', 5200, *[1477, 1698, 1697, 603], 1)
    ops.element('FourNodeTetrahedron', 5201, *[451, 601, 1563, 450], 1)
    ops.element('FourNodeTetrahedron', 5202, *[1614, 1600, 1613, 1649], 1)
    ops.element('FourNodeTetrahedron', 5203, *[1372, 1669, 345, 1611], 1)
    ops.element('FourNodeTetrahedron', 5204, *[514, 772, 771, 1159], 1)
    ops.element('FourNodeTetrahedron', 5205, *[1500, 1435, 397, 1507], 1)
    ops.element('FourNodeTetrahedron', 5206, *[517, 1614, 1613, 1649], 1)
    ops.element('FourNodeTetrahedron', 5207, *[521, 1614, 517, 1649], 1)
    ops.element('FourNodeTetrahedron', 5208, *[521, 1649, 517, 1494], 1)
    ops.element('FourNodeTetrahedron', 5209, *[517, 1649, 1613, 1494], 1)
    ops.element('FourNodeTetrahedron', 5210, *[1734, 1158, 1265, 679], 1)
    ops.element('FourNodeTetrahedron', 5211, *[276, 1428, 1633, 282], 1)
    ops.element('FourNodeTetrahedron', 5212, *[1158, 680, 1265, 679], 1)
    ops.element('FourNodeTetrahedron', 5213, *[281, 1428, 276, 282], 1)
    ops.element('FourNodeTetrahedron', 5214, *[265, 1290, 1284, 1332], 1)
    ops.element('FourNodeTetrahedron', 5215, *[1124, 1245, 1741, 1241], 1)
    ops.element('FourNodeTetrahedron', 5216, *[214, 1735, 174, 1387], 1)
    ops.element('FourNodeTetrahedron', 5217, *[321, 1322, 322, 462], 1)
    ops.element('FourNodeTetrahedron', 5218, *[216, 1387, 173, 1356], 1)
    ops.element('FourNodeTetrahedron', 5219, *[214, 1740, 1735, 1387], 1)
    ops.element('FourNodeTetrahedron', 5220, *[1504, 1477, 1562, 1695], 1)
    ops.element('FourNodeTetrahedron', 5221, *[545, 440, 441, 439], 1)
    ops.element('FourNodeTetrahedron', 5222, *[1376, 1495, 157, 150], 1)
    ops.element('FourNodeTetrahedron', 5223, *[1562, 1477, 1484, 1695], 1)
    ops.element('FourNodeTetrahedron', 5224, *[281, 1434, 1428, 282], 1)
    ops.element('FourNodeTetrahedron', 5225, *[276, 1633, 277, 282], 1)
    ops.element('FourNodeTetrahedron', 5226, *[1444, 1512, 1489, 1593], 1)
    ops.element('FourNodeTetrahedron', 5227, *[224, 1273, 187, 1277], 1)
    ops.element('FourNodeTetrahedron', 5228, *[741, 740, 336, 1351], 1)
    ops.element('FourNodeTetrahedron', 5229, *[282, 1633, 277, 1399], 1)
    ops.element('FourNodeTetrahedron', 5230, *[1271, 153, 1269, 1530], 1)
    ops.element('FourNodeTetrahedron', 5231, *[276, 1633, 1413, 277], 1)
    ops.element('FourNodeTetrahedron', 5232, *[277, 1633, 1413, 1399], 1)
    ops.element('FourNodeTetrahedron', 5233, *[1234, 1180, 1390, 1235], 1)
    ops.element('FourNodeTetrahedron', 5234, *[1676, 1168, 1160, 651], 1)
    ops.element('FourNodeTetrahedron', 5235, *[1740, 1672, 172, 1735], 1)
    ops.element('FourNodeTetrahedron', 5236, *[1428, 1302, 1325, 1466], 1)
    ops.element('FourNodeTetrahedron', 5237, *[1428, 1325, 1633, 1466], 1)
    ops.element('FourNodeTetrahedron', 5238, *[1327, 1548, 1310, 1642], 1)
    ops.element('FourNodeTetrahedron', 5239, *[1676, 1160, 1297, 645], 1)
    ops.element('FourNodeTetrahedron', 5240, *[1652, 1635, 1622, 1619], 1)
    ops.element('FourNodeTetrahedron', 5241, *[1656, 170, 165, 164], 1)
    ops.element('FourNodeTetrahedron', 5242, *[1140, 1190, 1508, 1270], 1)
    ops.element('FourNodeTetrahedron', 5243, *[1489, 1467, 1696, 631], 1)
    ops.element('FourNodeTetrahedron', 5244, *[1645, 1454, 1608, 1646], 1)
    ops.element('FourNodeTetrahedron', 5245, *[1718, 1399, 278, 1418], 1)
    ops.element('FourNodeTetrahedron', 5246, *[440, 1277, 434, 1296], 1)
    ops.element('FourNodeTetrahedron', 5247, *[714, 213, 212, 221], 1)
    ops.element('FourNodeTetrahedron', 5248, *[462, 1364, 463, 467], 1)
    ops.element('FourNodeTetrahedron', 5249, *[1645, 1646, 1608, 1731], 1)
    ops.element('FourNodeTetrahedron', 5250, *[1654, 1639, 1513, 1608], 1)
    ops.element('FourNodeTetrahedron', 5251, *[1654, 1639, 1523, 1513], 1)
    ops.element('FourNodeTetrahedron', 5252, *[1576, 1625, 1566, 525], 1)
    ops.element('FourNodeTetrahedron', 5253, *[1625, 1270, 418, 1238], 1)
    ops.element('FourNodeTetrahedron', 5254, *[1560, 1653, 1268, 1546], 1)
    ops.element('FourNodeTetrahedron', 5255, *[1625, 1270, 1275, 418], 1)
    ops.element('FourNodeTetrahedron', 5256, *[1387, 1397, 1672, 162], 1)
    ops.element('FourNodeTetrahedron', 5257, *[1202, 1127, 1480, 1208], 1)
    ops.element('FourNodeTetrahedron', 5258, *[1292, 1436, 1455, 658], 1)
    ops.element('FourNodeTetrahedron', 5259, *[1625, 418, 1275, 1566], 1)
    ops.element('FourNodeTetrahedron', 5260, *[150, 149, 142, 1298], 1)
    ops.element('FourNodeTetrahedron', 5261, *[1566, 418, 1275, 417], 1)
    ops.element('FourNodeTetrahedron', 5262, *[1431, 1444, 1572, 630], 1)
    ops.element('FourNodeTetrahedron', 5263, *[1566, 418, 417, 525], 1)
    ops.element('FourNodeTetrahedron', 5264, *[1616, 394, 401, 1465], 1)
    ops.element('FourNodeTetrahedron', 5265, *[1431, 630, 1572, 629], 1)
    ops.element('FourNodeTetrahedron', 5266, *[1606, 1166, 1611, 1308], 1)
    ops.element('FourNodeTetrahedron', 5267, *[1606, 353, 350, 354], 1)
    ops.element('FourNodeTetrahedron', 5268, *[1508, 1270, 1275, 1625], 1)
    ops.element('FourNodeTetrahedron', 5269, *[1648, 1519, 1635, 1596], 1)
    ops.element('FourNodeTetrahedron', 5270, *[1643, 1648, 1635, 1596], 1)
    ops.element('FourNodeTetrahedron', 5271, *[1727, 1480, 1607, 1604], 1)
    ops.element('FourNodeTetrahedron', 5272, *[1403, 1444, 1714, 1489], 1)
    ops.element('FourNodeTetrahedron', 5273, *[1418, 1480, 1727, 1604], 1)
    ops.element('FourNodeTetrahedron', 5274, *[1403, 1714, 1679, 1489], 1)
    ops.element('FourNodeTetrahedron', 5275, *[1648, 1519, 1596, 1688], 1)
    ops.element('FourNodeTetrahedron', 5276, *[1690, 1354, 384, 391], 1)
    ops.element('FourNodeTetrahedron', 5277, *[1515, 416, 415, 420], 1)
    ops.element('FourNodeTetrahedron', 5278, *[1508, 1482, 148, 1270], 1)
    ops.element('FourNodeTetrahedron', 5279, *[723, 1264, 727, 1311], 1)
    ops.element('FourNodeTetrahedron', 5280, *[1522, 1731, 1653, 1643], 1)
    ops.element('FourNodeTetrahedron', 5281, *[668, 671, 1597, 672], 1)
    ops.element('FourNodeTetrahedron', 5282, *[1273, 1355, 1665, 1277], 1)
    ops.element('FourNodeTetrahedron', 5283, *[1716, 1137, 1444, 1175], 1)
    ops.element('FourNodeTetrahedron', 5284, *[1577, 1227, 1404, 1394], 1)
    ops.element('FourNodeTetrahedron', 5285, *[1643, 1596, 1635, 1603], 1)
    ops.element('FourNodeTetrahedron', 5286, *[1643, 1635, 1640, 1603], 1)
    ops.element('FourNodeTetrahedron', 5287, *[707, 1672, 172, 1740], 1)
    ops.element('FourNodeTetrahedron', 5288, *[1596, 1635, 1603, 1567], 1)
    ops.element('FourNodeTetrahedron', 5289, *[1730, 1587, 1553, 1630], 1)
    ops.element('FourNodeTetrahedron', 5290, *[1351, 1142, 1659, 1197], 1)
    ops.element('FourNodeTetrahedron', 5291, *[1521, 387, 386, 393], 1)
    ops.element('FourNodeTetrahedron', 5292, *[1680, 362, 361, 1483], 1)
    ops.element('FourNodeTetrahedron', 5293, *[1459, 1720, 1294, 1694], 1)
    ops.element('FourNodeTetrahedron', 5294, *[359, 1632, 366, 1445], 1)
    ops.element('FourNodeTetrahedron', 5295, *[1621, 1530, 1618, 1652], 1)
    ops.element('FourNodeTetrahedron', 5296, *[1296, 1468, 433, 437], 1)
    ops.element('FourNodeTetrahedron', 5297, *[1686, 1416, 758, 1287], 1)
    ops.element('FourNodeTetrahedron', 5298, *[1591, 1652, 1618, 1617], 1)
    ops.element('FourNodeTetrahedron', 5299, *[1516, 1500, 396, 1507], 1)
    ops.element('FourNodeTetrahedron', 5300, *[1652, 1628, 1618, 1617], 1)
    ops.element('FourNodeTetrahedron', 5301, *[608, 609, 1693, 615], 1)
    ops.element('FourNodeTetrahedron', 5302, *[1219, 1164, 1340, 1225], 1)
    ops.element('FourNodeTetrahedron', 5303, *[494, 767, 766, 1312], 1)
    ops.element('FourNodeTetrahedron', 5304, *[1390, 1180, 1248, 1235], 1)
    ops.element('FourNodeTetrahedron', 5305, *[1494, 1732, 521, 509], 1)
    ops.element('FourNodeTetrahedron', 5306, *[1586, 1523, 1654, 1639], 1)
    ops.element('FourNodeTetrahedron', 5307, *[1586, 1523, 1499, 1654], 1)
    ops.element('FourNodeTetrahedron', 5308, *[1587, 1586, 1654, 1639], 1)
    ops.element('FourNodeTetrahedron', 5309, *[288, 1718, 282, 283], 1)
    ops.element('FourNodeTetrahedron', 5310, *[1512, 1152, 1574, 1472], 1)
    ops.element('FourNodeTetrahedron', 5311, *[1722, 1645, 1630, 1644], 1)
    ops.element('FourNodeTetrahedron', 5312, *[1571, 1188, 1394, 1564], 1)
    ops.element('FourNodeTetrahedron', 5313, *[282, 1434, 1718, 288], 1)
    ops.element('FourNodeTetrahedron', 5314, *[1737, 1353, 236, 1537], 1)
    ops.element('FourNodeTetrahedron', 5315, *[254, 1383, 258, 1360], 1)
    ops.element('FourNodeTetrahedron', 5316, *[1241, 1250, 1671, 1178], 1)
    ops.element('FourNodeTetrahedron', 5317, *[1440, 1231, 1432, 1433], 1)
    ops.element('FourNodeTetrahedron', 5318, *[1347, 1277, 225, 440], 1)
    ops.element('FourNodeTetrahedron', 5319, *[756, 744, 382, 1470], 1)
    ops.element('FourNodeTetrahedron', 5320, *[282, 1434, 1399, 1718], 1)
    ops.element('FourNodeTetrahedron', 5321, *[1330, 1345, 1260, 1583], 1)
    ops.element('FourNodeTetrahedron', 5322, *[291, 266, 265, 1289], 1)
    ops.element('FourNodeTetrahedron', 5323, *[1188, 1184, 1394, 1564], 1)
    ops.element('FourNodeTetrahedron', 5324, *[1604, 1630, 1560, 1644], 1)
    ops.element('FourNodeTetrahedron', 5325, *[1560, 1630, 1645, 1644], 1)
    ops.element('FourNodeTetrahedron', 5326, *[1555, 1491, 432, 1468], 1)
    ops.element('FourNodeTetrahedron', 5327, *[1652, 1540, 1628, 1619], 1)
    ops.element('FourNodeTetrahedron', 5328, *[1419, 1644, 1560, 1548], 1)
    ops.element('FourNodeTetrahedron', 5329, *[1419, 1604, 1560, 1644], 1)
    ops.element('FourNodeTetrahedron', 5330, *[1581, 1644, 1419, 1548], 1)
    ops.element('FourNodeTetrahedron', 5331, *[1145, 1244, 1236, 1297], 1)
    ops.element('FourNodeTetrahedron', 5332, *[1584, 1610, 1477, 1693], 1)
    ops.element('FourNodeTetrahedron', 5333, *[1641, 1376, 1370, 1622], 1)
    ops.element('FourNodeTetrahedron', 5334, *[1277, 1555, 433, 1296], 1)
    ops.element('FourNodeTetrahedron', 5335, *[621, 1709, 625, 617], 1)
    ops.element('FourNodeTetrahedron', 5336, *[515, 1352, 1733, 518], 1)
    ops.element('FourNodeTetrahedron', 5337, *[673, 1702, 1494, 674], 1)
    ops.element('FourNodeTetrahedron', 5338, *[1448, 1146, 1368, 1699], 1)
    ops.element('FourNodeTetrahedron', 5339, *[1375, 1234, 1315, 1390], 1)
    ops.element('FourNodeTetrahedron', 5340, *[1466, 1570, 1399, 1727], 1)
    ops.element('FourNodeTetrahedron', 5341, *[1432, 1267, 1638, 1433], 1)
    ops.element('FourNodeTetrahedron', 5342, *[1732, 1702, 1494, 673], 1)
    ops.element('FourNodeTetrahedron', 5343, *[1408, 1717, 1367, 1449], 1)
    ops.element('FourNodeTetrahedron', 5344, *[1281, 1283, 1544, 528], 1)
    ops.element('FourNodeTetrahedron', 5345, *[1408, 1717, 1449, 1701], 1)
    ops.element('FourNodeTetrahedron', 5346, *[1634, 1642, 1502, 1477], 1)
    ops.element('FourNodeTetrahedron', 5347, *[1620, 1642, 1634, 1477], 1)
    ops.element('FourNodeTetrahedron', 5348, *[1693, 1420, 1610, 604], 1)
    ops.element('FourNodeTetrahedron', 5349, *[1693, 1610, 1477, 604], 1)
    ops.element('FourNodeTetrahedron', 5350, *[1620, 1610, 1642, 1477], 1)
    ops.element('FourNodeTetrahedron', 5351, *[1645, 1654, 1553, 1588], 1)
    ops.element('FourNodeTetrahedron', 5352, *[762, 756, 1303, 1300], 1)
    ops.element('FourNodeTetrahedron', 5353, *[1553, 1587, 1654, 1645], 1)
    ops.element('FourNodeTetrahedron', 5354, *[1553, 1654, 1479, 1588], 1)
    ops.element('FourNodeTetrahedron', 5355, *[1448, 1146, 1451, 1368], 1)
    ops.element('FourNodeTetrahedron', 5356, *[1188, 1227, 1233, 1394], 1)
    ops.element('FourNodeTetrahedron', 5357, *[1699, 1146, 1368, 684], 1)
    ops.element('FourNodeTetrahedron', 5358, *[623, 616, 1409, 611], 1)
    ops.element('FourNodeTetrahedron', 5359, *[1414, 1590, 392, 399], 1)
    ops.element('FourNodeTetrahedron', 5360, *[1704, 656, 662, 663], 1)
    ops.element('FourNodeTetrahedron', 5361, *[1254, 1676, 1259, 650], 1)
    ops.element('FourNodeTetrahedron', 5362, *[1653, 1641, 1624, 1622], 1)
    ops.element('FourNodeTetrahedron', 5363, *[1644, 1645, 1560, 1653], 1)
    ops.element('FourNodeTetrahedron', 5364, *[1644, 1653, 1560, 1548], 1)
    ops.element('FourNodeTetrahedron', 5365, *[266, 253, 265, 1360], 1)
    ops.element('FourNodeTetrahedron', 5366, *[1560, 1645, 1588, 1653], 1)
    ops.element('FourNodeTetrahedron', 5367, *[1667, 1395, 1714, 1716], 1)
    ops.element('FourNodeTetrahedron', 5368, *[1560, 1653, 1546, 1548], 1)
    ops.element('FourNodeTetrahedron', 5369, *[1432, 1475, 1267, 1231], 1)
    ops.element('FourNodeTetrahedron', 5370, *[275, 729, 720, 1651], 1)
    ops.element('FourNodeTetrahedron', 5371, *[275, 729, 1651, 276], 1)
    ops.element('FourNodeTetrahedron', 5372, *[1609, 1524, 1655, 1610], 1)
    ops.element('FourNodeTetrahedron', 5373, *[1615, 1643, 1655, 1524], 1)
    ops.element('FourNodeTetrahedron', 5374, *[1616, 372, 401, 371], 1)
    ops.element('FourNodeTetrahedron', 5375, *[1580, 1691, 523, 421], 1)
    ops.element('FourNodeTetrahedron', 5376, *[1524, 1643, 1655, 1610], 1)
    ops.element('FourNodeTetrahedron', 5377, *[1644, 1522, 1653, 1655], 1)
    ops.element('FourNodeTetrahedron', 5378, *[1641, 1495, 1622, 1728], 1)
    ops.element('FourNodeTetrahedron', 5379, *[1222, 1126, 1451, 1146], 1)
    ops.element('FourNodeTetrahedron', 5380, *[1359, 1569, 1387, 1350], 1)
    ops.element('FourNodeTetrahedron', 5381, *[1655, 1522, 1653, 1643], 1)
    ops.element('FourNodeTetrahedron', 5382, *[1615, 1522, 1655, 1643], 1)
    ops.element('FourNodeTetrahedron', 5383, *[1615, 1522, 1644, 1655], 1)
    ops.element('FourNodeTetrahedron', 5384, *[1225, 1226, 1595, 1180], 1)
    ops.element('FourNodeTetrahedron', 5385, *[348, 1262, 308, 309], 1)
    ops.element('FourNodeTetrahedron', 5386, *[1611, 1669, 349, 348], 1)
    ops.element('FourNodeTetrahedron', 5387, *[1218, 1217, 1410, 1219], 1)
    ops.element('FourNodeTetrahedron', 5388, *[1387, 1397, 1499, 162], 1)
    ops.element('FourNodeTetrahedron', 5389, *[1636, 1534, 1347, 1474], 1)
    ops.element('FourNodeTetrahedron', 5390, *[1187, 1198, 1669, 1186], 1)
    ops.element('FourNodeTetrahedron', 5391, *[1611, 1187, 1669, 1122], 1)
    ops.element('FourNodeTetrahedron', 5392, *[1669, 1198, 308, 1186], 1)
    ops.element('FourNodeTetrahedron', 5393, *[1669, 1186, 308, 1262], 1)
    ops.element('FourNodeTetrahedron', 5394, *[1438, 163, 160, 159], 1)
    ops.element('FourNodeTetrahedron', 5395, *[1438, 1170, 163, 159], 1)
    ops.element('FourNodeTetrahedron', 5396, *[1716, 1395, 1714, 1512], 1)
    ops.element('FourNodeTetrahedron', 5397, *[252, 253, 256, 1314], 1)
    ops.element('FourNodeTetrahedron', 5398, *[1234, 1180, 1315, 1390], 1)
    ops.element('FourNodeTetrahedron', 5399, *[318, 1404, 288, 289], 1)
    ops.element('FourNodeTetrahedron', 5400, *[1342, 1604, 1419, 1644], 1)
    ops.element('FourNodeTetrahedron', 5401, *[232, 1305, 239, 1313], 1)
    ops.element('FourNodeTetrahedron', 5402, *[1405, 1336, 1706, 1467], 1)
    ops.element('FourNodeTetrahedron', 5403, *[669, 1278, 480, 660], 1)
    ops.element('FourNodeTetrahedron', 5404, *[551, 1232, 1688, 550], 1)
    ops.element('FourNodeTetrahedron', 5405, *[331, 1388, 1336, 1405], 1)
    ops.element('FourNodeTetrahedron', 5406, *[1669, 308, 344, 348], 1)
    ops.element('FourNodeTetrahedron', 5407, *[1400, 1201, 1430, 1404], 1)
    ops.element('FourNodeTetrahedron', 5408, *[1500, 397, 396, 1507], 1)
    ops.element('FourNodeTetrahedron', 5409, *[318, 1400, 288, 1404], 1)
    ops.element('FourNodeTetrahedron', 5410, *[657, 1455, 1266, 646], 1)
    ops.element('FourNodeTetrahedron', 5411, *[1511, 1709, 1487, 1701], 1)
    ops.element('FourNodeTetrahedron', 5412, *[1669, 1198, 307, 308], 1)
    ops.element('FourNodeTetrahedron', 5413, *[1595, 1341, 376, 1390], 1)
    ops.element('FourNodeTetrahedron', 5414, *[307, 1659, 1198, 1669], 1)
    ops.element('FourNodeTetrahedron', 5415, *[1723, 1578, 1569, 1730], 1)
    ops.element('FourNodeTetrahedron', 5416, *[515, 770, 769, 1733], 1)
    ops.element('FourNodeTetrahedron', 5417, *[1669, 307, 344, 308], 1)
    ops.element('FourNodeTetrahedron', 5418, *[1683, 1581, 259, 1383], 1)
    ops.element('FourNodeTetrahedron', 5419, *[1301, 1457, 1329, 1552], 1)
    ops.element('FourNodeTetrahedron', 5420, *[1301, 1329, 1322, 1552], 1)
    ops.element('FourNodeTetrahedron', 5421, *[1474, 1544, 1555, 1281], 1)
    ops.element('FourNodeTetrahedron', 5422, *[1319, 1449, 1377, 1684], 1)
    ops.element('FourNodeTetrahedron', 5423, *[743, 1193, 1658, 1143], 1)
    ops.element('FourNodeTetrahedron', 5424, *[1351, 305, 336, 340], 1)
    ops.element('FourNodeTetrahedron', 5425, *[1708, 737, 1171, 1142], 1)
    ops.element('FourNodeTetrahedron', 5426, *[740, 737, 1708, 1142], 1)
    ops.element('FourNodeTetrahedron', 5427, *[1351, 740, 1708, 1142], 1)
    ops.element('FourNodeTetrahedron', 5428, *[1708, 1304, 306, 1361], 1)
    ops.element('FourNodeTetrahedron', 5429, *[1708, 1304, 305, 306], 1)
    ops.element('FourNodeTetrahedron', 5430, *[740, 737, 305, 1708], 1)
    ops.element('FourNodeTetrahedron', 5431, *[1583, 1723, 1345, 1569], 1)
    ops.element('FourNodeTetrahedron', 5432, *[545, 533, 1296, 439], 1)
    ops.element('FourNodeTetrahedron', 5433, *[1293, 1725, 1291, 1576], 1)
    ops.element('FourNodeTetrahedron', 5434, *[1691, 416, 421, 422], 1)
    ops.element('FourNodeTetrahedron', 5435, *[1484, 1477, 1697, 1695], 1)
    ops.element('FourNodeTetrahedron', 5436, *[1734, 1265, 1448, 677], 1)
    ops.element('FourNodeTetrahedron', 5437, *[1567, 1725, 1291, 1488], 1)
    ops.element('FourNodeTetrahedron', 5438, *[1293, 1725, 1567, 1291], 1)
    ops.element('FourNodeTetrahedron', 5439, *[1725, 1566, 1488, 1576], 1)
    ops.element('FourNodeTetrahedron', 5440, *[1567, 1556, 1626, 1725], 1)
    ops.element('FourNodeTetrahedron', 5441, *[1725, 1566, 1626, 1488], 1)
    ops.element('FourNodeTetrahedron', 5442, *[391, 1354, 384, 392], 1)
    ops.element('FourNodeTetrahedron', 5443, *[1293, 1427, 1725, 1576], 1)
    ops.element('FourNodeTetrahedron', 5444, *[1635, 1556, 1567, 1725], 1)
    ops.element('FourNodeTetrahedron', 5445, *[1401, 1309, 1378, 1471], 1)
    ops.element('FourNodeTetrahedron', 5446, *[1397, 1656, 1672, 165], 1)
    ops.element('FourNodeTetrahedron', 5447, *[296, 292, 295, 1378], 1)
    ops.element('FourNodeTetrahedron', 5448, *[1607, 1586, 1578, 1730], 1)
    ops.element('FourNodeTetrahedron', 5449, *[1701, 1441, 1692, 619], 1)
    ops.element('FourNodeTetrahedron', 5450, *[1298, 1275, 143, 417], 1)
    ops.element('FourNodeTetrahedron', 5451, *[1607, 1453, 1586, 1587], 1)
    ops.element('FourNodeTetrahedron', 5452, *[1607, 1586, 1730, 1587], 1)
    ops.element('FourNodeTetrahedron', 5453, *[1194, 1154, 1709, 622], 1)
    ops.element('FourNodeTetrahedron', 5454, *[622, 623, 1709, 617], 1)
    ops.element('FourNodeTetrahedron', 5455, *[1611, 1669, 348, 1122], 1)
    ops.element('FourNodeTetrahedron', 5456, *[1709, 1154, 623, 622], 1)
    ops.element('FourNodeTetrahedron', 5457, *[183, 182, 186, 1279], 1)
    ops.element('FourNodeTetrahedron', 5458, *[1709, 1154, 1409, 623], 1)
    ops.element('FourNodeTetrahedron', 5459, *[1709, 1409, 617, 623], 1)
    ops.element('FourNodeTetrahedron', 5460, *[1221, 1218, 1435, 1382], 1)
    ops.element('FourNodeTetrahedron', 5461, *[1448, 1451, 1627, 1368], 1)
    ops.element('FourNodeTetrahedron', 5462, *[1484, 1505, 1537, 1476], 1)
    ops.element('FourNodeTetrahedron', 5463, *[297, 1394, 293, 1309], 1)
    ops.element('FourNodeTetrahedron', 5464, *[1450, 367, 1373, 1455], 1)
    ops.element('FourNodeTetrahedron', 5465, *[603, 548, 1697, 547], 1)
    ops.element('FourNodeTetrahedron', 5466, *[1698, 1506, 1502, 548], 1)
    ops.element('FourNodeTetrahedron', 5467, *[604, 1506, 548, 549], 1)
    ops.element('FourNodeTetrahedron', 5468, *[1306, 1432, 251, 1440], 1)
    ops.element('FourNodeTetrahedron', 5469, *[1574, 1471, 1511, 1709], 1)
    ops.element('FourNodeTetrahedron', 5470, *[1574, 1194, 1471, 1709], 1)
    ops.element('FourNodeTetrahedron', 5471, *[1343, 1432, 1683, 1638], 1)
    ops.element('FourNodeTetrahedron', 5472, *[1325, 1710, 1330, 1570], 1)
    ops.element('FourNodeTetrahedron', 5473, *[1311, 1339, 1710, 1570], 1)
    ops.element('FourNodeTetrahedron', 5474, *[1710, 1339, 1345, 1723], 1)
    ops.element('FourNodeTetrahedron', 5475, *[1684, 620, 459, 458], 1)
    ops.element('FourNodeTetrahedron', 5476, *[1684, 1682, 459, 620], 1)
    ops.element('FourNodeTetrahedron', 5477, *[756, 382, 755, 1666], 1)
    ops.element('FourNodeTetrahedron', 5478, *[1666, 1470, 382, 389], 1)
    ops.element('FourNodeTetrahedron', 5479, *[1303, 1470, 1666, 389], 1)
    ops.element('FourNodeTetrahedron', 5480, *[1149, 155, 1510, 1490], 1)
    ops.element('FourNodeTetrahedron', 5481, *[741, 336, 1320, 1351], 1)
    ops.element('FourNodeTetrahedron', 5482, *[1570, 1339, 1710, 1723], 1)
    ops.element('FourNodeTetrahedron', 5483, *[1665, 1355, 189, 433], 1)
    ops.element('FourNodeTetrahedron', 5484, *[1331, 140, 1318, 415], 1)
    ops.element('FourNodeTetrahedron', 5485, *[1318, 140, 139, 415], 1)
    ops.element('FourNodeTetrahedron', 5486, *[758, 1415, 757, 1287], 1)
    ops.element('FourNodeTetrahedron', 5487, *[1385, 1517, 387, 1521], 1)
    ops.element('FourNodeTetrahedron', 5488, *[724, 714, 212, 1531], 1)
    ops.element('FourNodeTetrahedron', 5489, *[1682, 620, 614, 459], 1)
    ops.element('FourNodeTetrahedron', 5490, *[1697, 1502, 1505, 547], 1)
    ops.element('FourNodeTetrahedron', 5491, *[1734, 1158, 1448, 1265], 1)
    ops.element('FourNodeTetrahedron', 5492, *[1378, 1487, 1554, 1717], 1)
    ops.element('FourNodeTetrahedron', 5493, *[325, 326, 321, 1322], 1)
    ops.element('FourNodeTetrahedron', 5494, *[349, 1669, 344, 348], 1)
    ops.element('FourNodeTetrahedron', 5495, *[1429, 1256, 1382, 1375], 1)
    ops.element('FourNodeTetrahedron', 5496, *[1705, 711, 1703, 1210], 1)
    ops.element('FourNodeTetrahedron', 5497, *[1537, 1371, 1744, 1514], 1)
    ops.element('FourNodeTetrahedron', 5498, *[1186, 1670, 308, 309], 1)
    ops.element('FourNodeTetrahedron', 5499, *[1601, 1335, 409, 487], 1)
    ops.element('FourNodeTetrahedron', 5500, *[1469, 675, 1694, 672], 1)
    ops.element('FourNodeTetrahedron', 5501, *[488, 1601, 409, 486], 1)
    ops.element('FourNodeTetrahedron', 5502, *[1458, 1233, 1577, 1670], 1)
    ops.element('FourNodeTetrahedron', 5503, *[308, 1458, 313, 1670], 1)
    ops.element('FourNodeTetrahedron', 5504, *[1458, 1577, 313, 1670], 1)
    ops.element('FourNodeTetrahedron', 5505, *[308, 1670, 313, 314], 1)
    ops.element('FourNodeTetrahedron', 5506, *[1670, 1577, 313, 314], 1)
    ops.element('FourNodeTetrahedron', 5507, *[308, 1128, 1670, 1186], 1)
    ops.element('FourNodeTetrahedron', 5508, *[308, 1128, 1458, 1670], 1)
    ops.element('FourNodeTetrahedron', 5509, *[1128, 1233, 1670, 1186], 1)
    ops.element('FourNodeTetrahedron', 5510, *[1128, 1233, 1458, 1670], 1)
    ops.element('FourNodeTetrahedron', 5511, *[746, 1690, 384, 1485], 1)
    ops.element('FourNodeTetrahedron', 5512, *[1415, 1452, 1485, 1500], 1)
    ops.element('FourNodeTetrahedron', 5513, *[746, 750, 384, 1690], 1)
    ops.element('FourNodeTetrahedron', 5514, *[1418, 1480, 1604, 1589], 1)
    ops.element('FourNodeTetrahedron', 5515, *[1690, 750, 384, 1354], 1)
    ops.element('FourNodeTetrahedron', 5516, *[750, 751, 1354, 1207], 1)
    ops.element('FourNodeTetrahedron', 5517, *[509, 1380, 490, 667], 1)
    ops.element('FourNodeTetrahedron', 5518, *[1545, 1488, 1580, 1498], 1)
    ops.element('FourNodeTetrahedron', 5519, *[1595, 1226, 1237, 1341], 1)
    ops.element('FourNodeTetrahedron', 5520, *[750, 751, 384, 1354], 1)
    ops.element('FourNodeTetrahedron', 5521, *[1229, 1146, 1448, 1699], 1)
    ops.element('FourNodeTetrahedron', 5522, *[1690, 750, 1354, 1207], 1)
    ops.element('FourNodeTetrahedron', 5523, *[1690, 1207, 1354, 1386], 1)
    ops.element('FourNodeTetrahedron', 5524, *[1690, 750, 1207, 1153], 1)
    ops.element('FourNodeTetrahedron', 5525, *[1153, 1207, 1690, 1386], 1)
    ops.element('FourNodeTetrahedron', 5526, *[1650, 1613, 372, 1501], 1)
    ops.element('FourNodeTetrahedron', 5527, *[463, 628, 468, 467], 1)
    ops.element('FourNodeTetrahedron', 5528, *[1704, 1295, 1373, 656], 1)
    ops.element('FourNodeTetrahedron', 5529, *[521, 1734, 677, 676], 1)
    ops.element('FourNodeTetrahedron', 5530, *[1456, 1522, 1644, 1615], 1)
    ops.element('FourNodeTetrahedron', 5531, *[1521, 394, 393, 400], 1)
    ops.element('FourNodeTetrahedron', 5532, *[1656, 703, 169, 1402], 1)
    ops.element('FourNodeTetrahedron', 5533, *[1397, 1422, 1656, 1499], 1)
    ops.element('FourNodeTetrahedron', 5534, *[1422, 1656, 706, 1397], 1)
    ops.element('FourNodeTetrahedron', 5535, *[229, 1412, 223, 1713], 1)
    ops.element('FourNodeTetrahedron', 5536, *[1397, 1656, 165, 1499], 1)
    ops.element('FourNodeTetrahedron', 5537, *[1656, 164, 165, 1499], 1)
    ops.element('FourNodeTetrahedron', 5538, *[609, 1420, 1693, 604], 1)
    ops.element('FourNodeTetrahedron', 5539, *[609, 1420, 604, 605], 1)
    ops.element('FourNodeTetrahedron', 5540, *[1693, 604, 1477, 608], 1)
    ops.element('FourNodeTetrahedron', 5541, *[521, 1702, 1732, 510], 1)
    ops.element('FourNodeTetrahedron', 5542, *[279, 1418, 1419, 1342], 1)
    ops.element('FourNodeTetrahedron', 5543, *[1691, 417, 416, 422], 1)
    ops.element('FourNodeTetrahedron', 5544, *[1378, 1369, 292, 1334], 1)
    ops.element('FourNodeTetrahedron', 5545, *[1424, 1561, 1292, 664], 1)
    ops.element('FourNodeTetrahedron', 5546, *[1614, 1497, 1518, 1613], 1)
    ops.element('FourNodeTetrahedron', 5547, *[459, 1682, 1551, 614], 1)
    ops.element('FourNodeTetrahedron', 5548, *[365, 366, 370, 1384], 1)
    ops.element('FourNodeTetrahedron', 5549, *[1582, 351, 406, 1392], 1)
    ops.element('FourNodeTetrahedron', 5550, *[1304, 738, 310, 1547], 1)
    ops.element('FourNodeTetrahedron', 5551, *[770, 761, 769, 1738], 1)
    ops.element('FourNodeTetrahedron', 5552, *[294, 1367, 290, 1377], 1)
    ops.element('FourNodeTetrahedron', 5553, *[1283, 529, 1745, 528], 1)
    ops.element('FourNodeTetrahedron', 5554, *[1360, 1383, 1620, 1535], 1)
    ops.element('FourNodeTetrahedron', 5555, *[608, 604, 1477, 603], 1)
    ops.element('FourNodeTetrahedron', 5556, *[1637, 1420, 1584, 1693], 1)
    ops.element('FourNodeTetrahedron', 5557, *[1719, 1149, 1490, 1191], 1)
    ops.element('FourNodeTetrahedron', 5558, *[1637, 1420, 1693, 609], 1)
    ops.element('FourNodeTetrahedron', 5559, *[1535, 1584, 1477, 1693], 1)
    ops.element('FourNodeTetrahedron', 5560, *[1348, 1145, 1297, 1274], 1)
    ops.element('FourNodeTetrahedron', 5561, *[1637, 1584, 1535, 1693], 1)
    ops.element('FourNodeTetrahedron', 5562, *[731, 1678, 730, 1307], 1)
    ops.element('FourNodeTetrahedron', 5563, *[731, 723, 730, 1678], 1)
    ops.element('FourNodeTetrahedron', 5564, *[1465, 1616, 401, 371], 1)
    ops.element('FourNodeTetrahedron', 5565, *[731, 723, 1678, 1173], 1)
    ops.element('FourNodeTetrahedron', 5566, *[730, 1678, 722, 1325], 1)
    ops.element('FourNodeTetrahedron', 5567, *[730, 1678, 1325, 1302], 1)
    ops.element('FourNodeTetrahedron', 5568, *[1261, 138, 185, 1358], 1)
    ops.element('FourNodeTetrahedron', 5569, *[1678, 722, 1325, 1311], 1)
    ops.element('FourNodeTetrahedron', 5570, *[1605, 1307, 732, 1357], 1)
    ops.element('FourNodeTetrahedron', 5571, *[1264, 1252, 1705, 1147], 1)
    ops.element('FourNodeTetrahedron', 5572, *[1235, 1389, 1390, 1411], 1)
    ops.element('FourNodeTetrahedron', 5573, *[723, 727, 722, 1311], 1)
    ops.element('FourNodeTetrahedron', 5574, *[1678, 723, 722, 1311], 1)
    ops.element('FourNodeTetrahedron', 5575, *[730, 723, 722, 1678], 1)
    ops.element('FourNodeTetrahedron', 5576, *[1653, 1622, 1624, 1621], 1)
    ops.element('FourNodeTetrahedron', 5577, *[1621, 1731, 1622, 1652], 1)
    ops.element('FourNodeTetrahedron', 5578, *[1139, 1162, 1354, 1414], 1)
    ops.element('FourNodeTetrahedron', 5579, *[1548, 1653, 1621, 1640], 1)
    ops.element('FourNodeTetrahedron', 5580, *[1516, 1263, 1500, 1509], 1)
    ops.element('FourNodeTetrahedron', 5581, *[1127, 1209, 1480, 1208], 1)
    ops.element('FourNodeTetrahedron', 5582, *[1570, 1311, 1481, 1466], 1)
    ops.element('FourNodeTetrahedron', 5583, *[1643, 1731, 1640, 1635], 1)
    ops.element('FourNodeTetrahedron', 5584, *[290, 264, 304, 1332], 1)
    ops.element('FourNodeTetrahedron', 5585, *[704, 702, 1402, 1599], 1)
    ops.element('FourNodeTetrahedron', 5586, *[1218, 1219, 1410, 1382], 1)
    ops.element('FourNodeTetrahedron', 5587, *[1643, 1731, 1653, 1640], 1)
    ops.element('FourNodeTetrahedron', 5588, *[1640, 1731, 1635, 1652], 1)
    ops.element('FourNodeTetrahedron', 5589, *[256, 257, 261, 1323], 1)
    ops.element('FourNodeTetrahedron', 5590, *[492, 489, 483, 484], 1)
    ops.element('FourNodeTetrahedron', 5591, *[253, 257, 256, 1314], 1)
    ops.element('FourNodeTetrahedron', 5592, *[1731, 1635, 1622, 1652], 1)
    ops.element('FourNodeTetrahedron', 5593, *[1445, 1295, 1373, 1704], 1)
    ops.element('FourNodeTetrahedron', 5594, *[1215, 1191, 1648, 1232], 1)
    ops.element('FourNodeTetrahedron', 5595, *[1579, 1690, 746, 1485], 1)
    ops.element('FourNodeTetrahedron', 5596, *[433, 1468, 432, 437], 1)
    ops.element('FourNodeTetrahedron', 5597, *[517, 1462, 1465, 491], 1)
    ops.element('FourNodeTetrahedron', 5598, *[762, 755, 763, 1303], 1)
    ops.element('FourNodeTetrahedron', 5599, *[454, 1377, 1682, 1684], 1)
    ops.element('FourNodeTetrahedron', 5600, *[454, 1684, 1682, 459], 1)
    ops.element('FourNodeTetrahedron', 5601, *[1345, 715, 1349, 708], 1)
    ops.element('FourNodeTetrahedron', 5602, *[1580, 417, 416, 1691], 1)
    ops.element('FourNodeTetrahedron', 5603, *[1384, 471, 378, 1663], 1)
    ops.element('FourNodeTetrahedron', 5604, *[1707, 1597, 668, 671], 1)
    ops.element('FourNodeTetrahedron', 5605, *[670, 671, 1707, 668], 1)
    ops.element('FourNodeTetrahedron', 5606, *[1311, 1264, 1705, 1147], 1)
    ops.element('FourNodeTetrahedron', 5607, *[1189, 1201, 1400, 1404], 1)
    ops.element('FourNodeTetrahedron', 5608, *[1663, 471, 470, 476], 1)
    ops.element('FourNodeTetrahedron', 5609, *[1287, 1416, 1415, 1437], 1)
    ops.element('FourNodeTetrahedron', 5610, *[1663, 476, 475, 655], 1)
    ops.element('FourNodeTetrahedron', 5611, *[1136, 1206, 1434, 1400], 1)
    ops.element('FourNodeTetrahedron', 5612, *[1569, 1578, 1397, 1629], 1)
    ops.element('FourNodeTetrahedron', 5613, *[1663, 475, 470, 476], 1)
    ops.element('FourNodeTetrahedron', 5614, *[661, 655, 1663, 654], 1)
    ops.element('FourNodeTetrahedron', 5615, *[1547, 1174, 1357, 1417], 1)
    ops.element('FourNodeTetrahedron', 5616, *[719, 724, 240, 1531], 1)
    ops.element('FourNodeTetrahedron', 5617, *[217, 1350, 216, 219], 1)
    ops.element('FourNodeTetrahedron', 5618, *[1223, 1235, 1411, 1236], 1)
    ops.element('FourNodeTetrahedron', 5619, *[1529, 661, 1663, 654], 1)
    ops.element('FourNodeTetrahedron', 5620, *[1737, 1310, 1353, 1324], 1)
    ops.element('FourNodeTetrahedron', 5621, *[655, 1663, 475, 654], 1)
    ops.element('FourNodeTetrahedron', 5622, *[1168, 1160, 1297, 1676], 1)
    ops.element('FourNodeTetrahedron', 5623, *[433, 1355, 189, 432], 1)
    ops.element('FourNodeTetrahedron', 5624, *[1366, 1132, 1389, 1398], 1)
    ops.element('FourNodeTetrahedron', 5625, *[1469, 1426, 1694, 675], 1)
    ops.element('FourNodeTetrahedron', 5626, *[272, 1413, 1391, 1565], 1)
    ops.element('FourNodeTetrahedron', 5627, *[1274, 1254, 1145, 1676], 1)
    ops.element('FourNodeTetrahedron', 5628, *[262, 1327, 1310, 1324], 1)
    ops.element('FourNodeTetrahedron', 5629, *[1457, 629, 1572, 626], 1)
    ops.element('FourNodeTetrahedron', 5630, *[1145, 1168, 1297, 1676], 1)
    ops.element('FourNodeTetrahedron', 5631, *[1254, 1168, 1676, 650], 1)
    ops.element('FourNodeTetrahedron', 5632, *[1391, 1583, 1333, 1359], 1)
    ops.element('FourNodeTetrahedron', 5633, *[1712, 1484, 1537, 1476], 1)
    ops.element('FourNodeTetrahedron', 5634, *[1706, 1467, 1511, 1282], 1)
    ops.element('FourNodeTetrahedron', 5635, *[1706, 1336, 1511, 1467], 1)
    ops.element('FourNodeTetrahedron', 5636, *[1706, 1558, 1408, 1511], 1)
    ops.element('FourNodeTetrahedron', 5637, *[282, 1718, 278, 283], 1)
    ops.element('FourNodeTetrahedron', 5638, *[365, 1384, 378, 1393], 1)
    ops.element('FourNodeTetrahedron', 5639, *[1667, 1185, 1660, 1395], 1)
    ops.element('FourNodeTetrahedron', 5640, *[1489, 1405, 1706, 1467], 1)
    ops.element('FourNodeTetrahedron', 5641, *[627, 628, 1364, 467], 1)
    ops.element('FourNodeTetrahedron', 5642, *[1492, 1301, 1362, 649], 1)
    ops.element('FourNodeTetrahedron', 5643, *[1679, 1405, 327, 1706], 1)
    ops.element('FourNodeTetrahedron', 5644, *[1308, 1660, 334, 1667], 1)
    ops.element('FourNodeTetrahedron', 5645, *[1316, 1706, 327, 1282], 1)
    ops.element('FourNodeTetrahedron', 5646, *[1679, 1489, 1706, 1316], 1)
    ops.element('FourNodeTetrahedron', 5647, *[1152, 1194, 1574, 1472], 1)
    ops.element('FourNodeTetrahedron', 5648, *[1405, 1336, 327, 1706], 1)
    ops.element('FourNodeTetrahedron', 5649, *[707, 706, 1672, 1397], 1)
    ops.element('FourNodeTetrahedron', 5650, *[478, 1662, 465, 649], 1)
    ops.element('FourNodeTetrahedron', 5651, *[665, 1288, 658, 664], 1)
    ops.element('FourNodeTetrahedron', 5652, *[1229, 1222, 1493, 1146], 1)
    ops.element('FourNodeTetrahedron', 5653, *[1259, 650, 659, 666], 1)
    ops.element('FourNodeTetrahedron', 5654, *[1221, 1435, 1507, 1382], 1)
    ops.element('FourNodeTetrahedron', 5655, *[708, 706, 707, 1397], 1)
    ops.element('FourNodeTetrahedron', 5656, *[1529, 1663, 470, 1736], 1)
    ops.element('FourNodeTetrahedron', 5657, *[707, 171, 172, 1672], 1)
    ops.element('FourNodeTetrahedron', 5658, *[172, 1672, 171, 166], 1)
    ops.element('FourNodeTetrahedron', 5659, *[1374, 1412, 229, 1713], 1)
    ops.element('FourNodeTetrahedron', 5660, *[230, 1713, 1407, 1559], 1)
    ops.element('FourNodeTetrahedron', 5661, *[1371, 1713, 230, 1559], 1)
    ops.element('FourNodeTetrahedron', 5662, *[229, 1713, 230, 1371], 1)
    ops.element('FourNodeTetrahedron', 5663, *[1185, 1388, 1395, 1182], 1)
    ops.element('FourNodeTetrahedron', 5664, *[229, 1713, 223, 230], 1)
    ops.element('FourNodeTetrahedron', 5665, *[1374, 1621, 1412, 1623], 1)
    ops.element('FourNodeTetrahedron', 5666, *[1459, 1720, 1446, 1294], 1)
    ops.element('FourNodeTetrahedron', 5667, *[1340, 1595, 405, 1315], 1)
    ops.element('FourNodeTetrahedron', 5668, *[1374, 1412, 1713, 1623], 1)
    ops.element('FourNodeTetrahedron', 5669, *[1374, 1713, 229, 1371], 1)
    ops.element('FourNodeTetrahedron', 5670, *[1186, 1670, 309, 1571], 1)
    ops.element('FourNodeTetrahedron', 5671, *[1476, 602, 1514, 601], 1)
    ops.element('FourNodeTetrahedron', 5672, *[262, 1310, 1737, 1324], 1)
    ops.element('FourNodeTetrahedron', 5673, *[1403, 1489, 1322, 1572], 1)
    ops.element('FourNodeTetrahedron', 5674, *[1403, 1679, 1322, 1489], 1)
    ops.element('FourNodeTetrahedron', 5675, *[326, 1714, 1405, 1679], 1)
    ops.element('FourNodeTetrahedron', 5676, *[741, 740, 1351, 1192], 1)
    ops.element('FourNodeTetrahedron', 5677, *[1719, 1149, 1510, 1490], 1)
    ops.element('FourNodeTetrahedron', 5678, *[135, 153, 136, 1271], 1)
    ops.element('FourNodeTetrahedron', 5679, *[1286, 381, 754, 388], 1)
    ops.element('FourNodeTetrahedron', 5680, *[1608, 1719, 1510, 1490], 1)
    ops.element('FourNodeTetrahedron', 5681, *[1130, 1224, 1719, 1149], 1)
    ops.element('FourNodeTetrahedron', 5682, *[1547, 1657, 315, 316], 1)
    ops.element('FourNodeTetrahedron', 5683, *[1454, 1255, 1406, 1719], 1)
    ops.element('FourNodeTetrahedron', 5684, *[741, 1192, 1320, 1161], 1)
    ops.element('FourNodeTetrahedron', 5685, *[1507, 397, 403, 404], 1)
    ops.element('FourNodeTetrahedron', 5686, *[1364, 1489, 1316, 628], 1)
    ops.element('FourNodeTetrahedron', 5687, *[1454, 1406, 1639, 1719], 1)
    ops.element('FourNodeTetrahedron', 5688, *[1255, 1224, 1719, 1130], 1)
    ops.element('FourNodeTetrahedron', 5689, *[1454, 1255, 1719, 1130], 1)
    ops.element('FourNodeTetrahedron', 5690, *[1255, 1141, 1406, 1224], 1)
    ops.element('FourNodeTetrahedron', 5691, *[1406, 1438, 1639, 1719], 1)
    ops.element('FourNodeTetrahedron', 5692, *[1719, 1224, 1510, 1149], 1)
    ops.element('FourNodeTetrahedron', 5693, *[1507, 404, 403, 1677], 1)
    ops.element('FourNodeTetrahedron', 5694, *[255, 259, 258, 1383], 1)
    ops.element('FourNodeTetrahedron', 5695, *[1445, 366, 365, 1384], 1)
    ops.element('FourNodeTetrahedron', 5696, *[359, 366, 365, 1445], 1)
    ops.element('FourNodeTetrahedron', 5697, *[1664, 754, 380, 388], 1)
    ops.element('FourNodeTetrahedron', 5698, *[1507, 1677, 403, 1497], 1)
    ops.element('FourNodeTetrahedron', 5699, *[1483, 1390, 1612, 1568], 1)
    ops.element('FourNodeTetrahedron', 5700, *[1744, 1371, 232, 1514], 1)
    ops.element('FourNodeTetrahedron', 5701, *[1367, 1715, 1377, 1449], 1)
    ops.element('FourNodeTetrahedron', 5702, *[1505, 1591, 546, 547], 1)
    ops.element('FourNodeTetrahedron', 5703, *[1334, 1533, 1289, 1715], 1)
    ops.element('FourNodeTetrahedron', 5704, *[359, 360, 366, 1632], 1)
    ops.element('FourNodeTetrahedron', 5705, *[403, 1677, 404, 374], 1)
    ops.element('FourNodeTetrahedron', 5706, *[1497, 1677, 403, 374], 1)
    ops.element('FourNodeTetrahedron', 5707, *[1226, 1237, 1178, 1341], 1)
    ops.element('FourNodeTetrahedron', 5708, *[279, 1418, 1443, 1419], 1)
    ops.element('FourNodeTetrahedron', 5709, *[262, 263, 234, 1310], 1)
    ops.element('FourNodeTetrahedron', 5710, *[1141, 1170, 1438, 1224], 1)
    ops.element('FourNodeTetrahedron', 5711, *[1382, 1340, 1677, 1375], 1)
    ops.element('FourNodeTetrahedron', 5712, *[654, 1736, 474, 475], 1)
    ops.element('FourNodeTetrahedron', 5713, *[1382, 1340, 404, 1677], 1)
    ops.element('FourNodeTetrahedron', 5714, *[1677, 1340, 404, 375], 1)
    ops.element('FourNodeTetrahedron', 5715, *[1340, 1315, 405, 375], 1)
    ops.element('FourNodeTetrahedron', 5716, *[232, 229, 230, 1371], 1)
    ops.element('FourNodeTetrahedron', 5717, *[1241, 1308, 1671, 1250], 1)
    ops.element('FourNodeTetrahedron', 5718, *[1452, 1153, 1579, 1681], 1)
    ops.element('FourNodeTetrahedron', 5719, *[404, 1340, 405, 375], 1)
    ops.element('FourNodeTetrahedron', 5720, *[1537, 1371, 1514, 1505], 1)
    ops.element('FourNodeTetrahedron', 5721, *[1475, 1644, 1581, 1655], 1)
    ops.element('FourNodeTetrahedron', 5722, *[1234, 1225, 1315, 1180], 1)
    ops.element('FourNodeTetrahedron', 5723, *[1249, 1238, 1625, 525], 1)
    ops.element('FourNodeTetrahedron', 5724, *[1581, 1655, 1642, 1610], 1)
    ops.element('FourNodeTetrahedron', 5725, *[1397, 1499, 165, 162], 1)
    ops.element('FourNodeTetrahedron', 5726, *[514, 1159, 1352, 513], 1)
    ops.element('FourNodeTetrahedron', 5727, *[1352, 1134, 1526, 513], 1)
    ops.element('FourNodeTetrahedron', 5728, *[303, 1332, 304, 455], 1)
    ops.element('FourNodeTetrahedron', 5729, *[1530, 1326, 1269, 1538], 1)
    ops.element('FourNodeTetrahedron', 5730, *[519, 1518, 518, 517], 1)
    ops.element('FourNodeTetrahedron', 5731, *[365, 370, 378, 1384], 1)
    ops.element('FourNodeTetrahedron', 5732, *[1384, 370, 378, 471], 1)
    ops.element('FourNodeTetrahedron', 5733, *[1450, 1464, 367, 1455], 1)
    ops.element('FourNodeTetrahedron', 5734, *[1538, 1326, 1358, 1318], 1)
    ops.element('FourNodeTetrahedron', 5735, *[1429, 1382, 1677, 1375], 1)
    ops.element('FourNodeTetrahedron', 5736, *[306, 1304, 311, 1361], 1)
    ops.element('FourNodeTetrahedron', 5737, *[1507, 1382, 404, 1677], 1)
    ops.element('FourNodeTetrahedron', 5738, *[1683, 1475, 1581, 1609], 1)
    ops.element('FourNodeTetrahedron', 5739, *[1390, 1341, 376, 1612], 1)
    ops.element('FourNodeTetrahedron', 5740, *[1177, 1667, 1716, 1137], 1)
    ops.element('FourNodeTetrahedron', 5741, *[1400, 1136, 1206, 1201], 1)
    ops.element('FourNodeTetrahedron', 5742, *[445, 1313, 446, 601], 1)
    ops.element('FourNodeTetrahedron', 5743, *[1411, 1235, 1132, 1244], 1)
    ops.element('FourNodeTetrahedron', 5744, *[444, 1305, 231, 442], 1)
    ops.element('FourNodeTetrahedron', 5745, *[761, 1287, 1300, 1352], 1)
    ops.element('FourNodeTetrahedron', 5746, *[187, 1742, 186, 1665], 1)
    ops.element('FourNodeTetrahedron', 5747, *[493, 1465, 483, 492], 1)
    ops.element('FourNodeTetrahedron', 5748, *[265, 1314, 264, 1284], 1)
    ops.element('FourNodeTetrahedron', 5749, *[1338, 1475, 1342, 1683], 1)
    ops.element('FourNodeTetrahedron', 5750, *[1521, 393, 400, 414], 1)
    ops.element('FourNodeTetrahedron', 5751, *[1492, 1398, 1457, 648], 1)
    ops.element('FourNodeTetrahedron', 5752, *[1581, 1644, 1548, 1655], 1)
    ops.element('FourNodeTetrahedron', 5753, *[1338, 1475, 1683, 1432], 1)
    ops.element('FourNodeTetrahedron', 5754, *[255, 1338, 1683, 1343], 1)
    ops.element('FourNodeTetrahedron', 5755, *[1672, 706, 171, 1656], 1)
    ops.element('FourNodeTetrahedron', 5756, *[1402, 168, 169, 163], 1)
    ops.element('FourNodeTetrahedron', 5757, *[334, 335, 330, 1395], 1)
    ops.element('FourNodeTetrahedron', 5758, *[255, 1338, 1342, 1683], 1)
    ops.element('FourNodeTetrahedron', 5759, *[1711, 1609, 1383, 1584], 1)
    ops.element('FourNodeTetrahedron', 5760, *[1649, 1627, 1460, 1700], 1)
    ops.element('FourNodeTetrahedron', 5761, *[1720, 1704, 1294, 1694], 1)
    ops.element('FourNodeTetrahedron', 5762, *[1659, 1171, 1361, 1253], 1)
    ops.element('FourNodeTetrahedron', 5763, *[1659, 1361, 307, 1458], 1)
    ops.element('FourNodeTetrahedron', 5764, *[220, 1344, 222, 1541], 1)
    ops.element('FourNodeTetrahedron', 5765, *[220, 1344, 218, 222], 1)
    ops.element('FourNodeTetrahedron', 5766, *[1659, 1253, 1361, 1458], 1)
    ops.element('FourNodeTetrahedron', 5767, *[1198, 1253, 1659, 1458], 1)
    ops.element('FourNodeTetrahedron', 5768, *[307, 1659, 1198, 1458], 1)
    ops.element('FourNodeTetrahedron', 5769, *[755, 1666, 381, 1286], 1)
    ops.element('FourNodeTetrahedron', 5770, *[1435, 1217, 1410, 1218], 1)
    ops.element('FourNodeTetrahedron', 5771, *[238, 1313, 239, 444], 1)
    ops.element('FourNodeTetrahedron', 5772, *[1659, 1361, 306, 307], 1)
    ops.element('FourNodeTetrahedron', 5773, *[1435, 1218, 1410, 1382], 1)
    ops.element('FourNodeTetrahedron', 5774, *[1197, 1142, 1659, 1198], 1)
    ops.element('FourNodeTetrahedron', 5775, *[1197, 1659, 344, 1669], 1)
    ops.element('FourNodeTetrahedron', 5776, *[1197, 1198, 1659, 1669], 1)
    ops.element('FourNodeTetrahedron', 5777, *[344, 1659, 307, 1669], 1)
    ops.element('FourNodeTetrahedron', 5778, *[340, 1659, 306, 307], 1)
    ops.element('FourNodeTetrahedron', 5779, *[1142, 1253, 1659, 1198], 1)
    ops.element('FourNodeTetrahedron', 5780, *[1509, 1221, 1507, 1525], 1)
    ops.element('FourNodeTetrahedron', 5781, *[1644, 1653, 1548, 1655], 1)
    ops.element('FourNodeTetrahedron', 5782, *[1499, 164, 165, 161], 1)
    ops.element('FourNodeTetrahedron', 5783, *[1655, 1653, 1548, 1640], 1)
    ops.element('FourNodeTetrahedron', 5784, *[1412, 1271, 223, 1532], 1)
    ops.element('FourNodeTetrahedron', 5785, *[1215, 1191, 1646, 1648], 1)
    ops.element('FourNodeTetrahedron', 5786, *[1579, 1153, 1690, 1386], 1)
    ops.element('FourNodeTetrahedron', 5787, *[766, 1527, 481, 1312], 1)
    ops.element('FourNodeTetrahedron', 5788, *[138, 139, 188, 1318], 1)
    ops.element('FourNodeTetrahedron', 5789, *[517, 1650, 1380, 1494], 1)
    ops.element('FourNodeTetrahedron', 5790, *[517, 1462, 491, 1380], 1)
    ops.element('FourNodeTetrahedron', 5791, *[1648, 1191, 1519, 1232], 1)
    ops.element('FourNodeTetrahedron', 5792, *[453, 1319, 454, 457], 1)
    ops.element('FourNodeTetrahedron', 5793, *[1411, 1483, 1631, 1543], 1)
    ops.element('FourNodeTetrahedron', 5794, *[1548, 1621, 1546, 1729], 1)
    ops.element('FourNodeTetrahedron', 5795, *[1548, 1621, 1729, 1640], 1)
    ops.element('FourNodeTetrahedron', 5796, *[1583, 1723, 1557, 1727], 1)
    ops.element('FourNodeTetrahedron', 5797, *[1727, 1723, 1557, 1607], 1)
    ops.element('FourNodeTetrahedron', 5798, *[1413, 1583, 1391, 1565], 1)
    ops.element('FourNodeTetrahedron', 5799, *[1399, 1565, 1413, 1727], 1)
    ops.element('FourNodeTetrahedron', 5800, *[238, 232, 239, 1313], 1)
    ops.element('FourNodeTetrahedron', 5801, *[1709, 1409, 1487, 1701], 1)
    ops.element('FourNodeTetrahedron', 5802, *[1413, 1570, 1583, 1727], 1)
    ops.element('FourNodeTetrahedron', 5803, *[1399, 1570, 1413, 1727], 1)
    ops.element('FourNodeTetrahedron', 5804, *[1399, 1727, 1565, 1418], 1)
    ops.element('FourNodeTetrahedron', 5805, *[1294, 1687, 1663, 655], 1)
    ops.element('FourNodeTetrahedron', 5806, *[1177, 1185, 1667, 1137], 1)
    ops.element('FourNodeTetrahedron', 5807, *[547, 1478, 546, 534], 1)
    ops.element('FourNodeTetrahedron', 5808, *[1663, 1687, 471, 476], 1)
    ops.element('FourNodeTetrahedron', 5809, *[1667, 1243, 1185, 1177], 1)
    ops.element('FourNodeTetrahedron', 5810, *[235, 1374, 233, 1353], 1)
    ops.element('FourNodeTetrahedron', 5811, *[517, 1494, 1380, 509], 1)
    ops.element('FourNodeTetrahedron', 5812, *[213, 1333, 214, 215], 1)
    ops.element('FourNodeTetrahedron', 5813, *[1630, 1453, 1454, 1722], 1)
    ops.element('FourNodeTetrahedron', 5814, *[1500, 1485, 1681, 397], 1)
    ops.element('FourNodeTetrahedron', 5815, *[1489, 631, 1696, 628], 1)
    ops.element('FourNodeTetrahedron', 5816, *[1549, 150, 151, 1280], 1)
    ops.element('FourNodeTetrahedron', 5817, *[1722, 1454, 1630, 1645], 1)
    ops.element('FourNodeTetrahedron', 5818, *[1722, 1454, 1645, 1522], 1)
    ops.element('FourNodeTetrahedron', 5819, *[1426, 1295, 1704, 663], 1)
    ops.element('FourNodeTetrahedron', 5820, *[1456, 1204, 1722, 1522], 1)
    ops.element('FourNodeTetrahedron', 5821, *[1718, 1466, 1480, 1202], 1)
    ops.element('FourNodeTetrahedron', 5822, *[1430, 1202, 1718, 1589], 1)
    ops.element('FourNodeTetrahedron', 5823, *[1373, 1455, 1362, 646], 1)
    ops.element('FourNodeTetrahedron', 5824, *[1718, 1202, 1480, 1589], 1)
    ops.element('FourNodeTetrahedron', 5825, *[1159, 1287, 760, 1352], 1)
    ops.element('FourNodeTetrahedron', 5826, *[771, 760, 770, 1352], 1)
    ops.element('FourNodeTetrahedron', 5827, *[1323, 1324, 1537, 1712], 1)
    ops.element('FourNodeTetrahedron', 5828, *[1718, 1480, 1418, 1589], 1)
    ops.element('FourNodeTetrahedron', 5829, *[1718, 1480, 1727, 1418], 1)
    ops.element('FourNodeTetrahedron', 5830, *[297, 1394, 319, 293], 1)
    ops.element('FourNodeTetrahedron', 5831, *[1312, 1385, 1527, 1521], 1)
    ops.element('FourNodeTetrahedron', 5832, *[1718, 1466, 1727, 1480], 1)
    ops.element('FourNodeTetrahedron', 5833, *[405, 1582, 406, 1595], 1)
    ops.element('FourNodeTetrahedron', 5834, *[345, 1669, 344, 349], 1)
    ops.element('FourNodeTetrahedron', 5835, *[1476, 602, 601, 607], 1)
    ops.element('FourNodeTetrahedron', 5836, *[1466, 1727, 1399, 1718], 1)
    ops.element('FourNodeTetrahedron', 5837, *[1718, 1727, 1399, 1418], 1)
    ops.element('FourNodeTetrahedron', 5838, *[1321, 1476, 1328, 1313], 1)
    ops.element('FourNodeTetrahedron', 5839, *[1563, 1476, 1313, 601], 1)
    ops.element('FourNodeTetrahedron', 5840, *[1605, 732, 1428, 1302], 1)
    ops.element('FourNodeTetrahedron', 5841, *[1697, 1698, 1502, 548], 1)
    ops.element('FourNodeTetrahedron', 5842, *[251, 1432, 1343, 1440], 1)
    ops.element('FourNodeTetrahedron', 5843, *[1623, 1618, 1713, 1559], 1)
    ops.element('FourNodeTetrahedron', 5844, *[1409, 616, 1441, 619], 1)
    ops.element('FourNodeTetrahedron', 5845, *[1350, 1356, 218, 1344], 1)
    ops.element('FourNodeTetrahedron', 5846, *[1491, 1358, 432, 431], 1)
    ops.element('FourNodeTetrahedron', 5847, *[1538, 1358, 1355, 1555], 1)
    ops.element('FourNodeTetrahedron', 5848, *[190, 1665, 189, 433], 1)
    ops.element('FourNodeTetrahedron', 5849, *[702, 713, 1743, 1157], 1)
    ops.element('FourNodeTetrahedron', 5850, *[1402, 1743, 175, 1157], 1)
    ops.element('FourNodeTetrahedron', 5851, *[1326, 138, 1261, 1358], 1)
    ops.element('FourNodeTetrahedron', 5852, *[724, 715, 714, 1349], 1)
    ops.element('FourNodeTetrahedron', 5853, *[702, 713, 167, 1743], 1)
    ops.element('FourNodeTetrahedron', 5854, *[1464, 1492, 1362, 1455], 1)
    ops.element('FourNodeTetrahedron', 5855, *[547, 1473, 1283, 535], 1)
    ops.element('FourNodeTetrahedron', 5856, *[449, 1539, 448, 1299], 1)
    ops.element('FourNodeTetrahedron', 5857, *[1277, 433, 190, 434], 1)
    ops.element('FourNodeTetrahedron', 5858, *[1522, 1645, 1653, 1731], 1)
    ops.element('FourNodeTetrahedron', 5859, *[1460, 1426, 675, 678], 1)
    ops.element('FourNodeTetrahedron', 5860, *[187, 1665, 190, 1277], 1)
    ops.element('FourNodeTetrahedron', 5861, *[1654, 1499, 1479, 1513], 1)
    ops.element('FourNodeTetrahedron', 5862, *[1221, 1256, 1429, 1220], 1)
    ops.element('FourNodeTetrahedron', 5863, *[1221, 1256, 1382, 1429], 1)
    ops.element('FourNodeTetrahedron', 5864, *[1429, 1256, 1375, 1223], 1)
    ops.element('FourNodeTetrahedron', 5865, *[320, 325, 321, 1322], 1)
    ops.element('FourNodeTetrahedron', 5866, *[1220, 1256, 1429, 1223], 1)
    ops.element('FourNodeTetrahedron', 5867, *[518, 1352, 1526, 513], 1)
    ops.element('FourNodeTetrahedron', 5868, *[1426, 1704, 1694, 662], 1)
    ops.element('FourNodeTetrahedron', 5869, *[1434, 1633, 1428, 282], 1)
    ops.element('FourNodeTetrahedron', 5870, *[732, 730, 729, 1428], 1)
    ops.element('FourNodeTetrahedron', 5871, *[1546, 1653, 1624, 1621], 1)
    ops.element('FourNodeTetrahedron', 5872, *[1300, 1263, 1500, 1516], 1)
    ops.element('FourNodeTetrahedron', 5873, *[1486, 1524, 1584, 1420], 1)
    ops.element('FourNodeTetrahedron', 5874, *[222, 135, 181, 1271], 1)
    ops.element('FourNodeTetrahedron', 5875, *[675, 662, 1694, 672], 1)
    ops.element('FourNodeTetrahedron', 5876, *[1138, 1156, 1433, 1196], 1)
    ops.element('FourNodeTetrahedron', 5877, *[1570, 1481, 1607, 1480], 1)
    ops.element('FourNodeTetrahedron', 5878, *[647, 648, 1492, 649], 1)
    ops.element('FourNodeTetrahedron', 5879, *[1426, 662, 1694, 675], 1)
    ops.element('FourNodeTetrahedron', 5880, *[1388, 1564, 299, 1401], 1)
    ops.element('FourNodeTetrahedron', 5881, *[384, 751, 385, 1354], 1)
    ops.element('FourNodeTetrahedron', 5882, *[1706, 1467, 1282, 1696], 1)
    ops.element('FourNodeTetrahedron', 5883, *[1696, 1467, 1282, 624], 1)
    ops.element('FourNodeTetrahedron', 5884, *[628, 1696, 1282, 624], 1)
    ops.element('FourNodeTetrahedron', 5885, *[334, 1660, 352, 335], 1)
    ops.element('FourNodeTetrahedron', 5886, *[1660, 1571, 352, 335], 1)
    ops.element('FourNodeTetrahedron', 5887, *[1122, 1571, 352, 1660], 1)
    ops.element('FourNodeTetrahedron', 5888, *[1660, 1122, 1183, 1185], 1)
    ops.element('FourNodeTetrahedron', 5889, *[230, 1347, 231, 1305], 1)
    ops.element('FourNodeTetrahedron', 5890, *[1470, 382, 389, 390], 1)
    ops.element('FourNodeTetrahedron', 5891, *[1470, 744, 382, 390], 1)
    ops.element('FourNodeTetrahedron', 5892, *[1347, 1277, 440, 1296], 1)
    ops.element('FourNodeTetrahedron', 5893, *[1660, 1122, 1571, 1183], 1)
    ops.element('FourNodeTetrahedron', 5894, *[1185, 1388, 1660, 1395], 1)
    ops.element('FourNodeTetrahedron', 5895, *[1396, 1508, 148, 1275], 1)
    ops.element('FourNodeTetrahedron', 5896, *[1341, 1125, 1423, 1389], 1)
    ops.element('FourNodeTetrahedron', 5897, *[1511, 1717, 1408, 1701], 1)
    ops.element('FourNodeTetrahedron', 5898, *[1660, 1183, 1571, 1388], 1)
    ops.element('FourNodeTetrahedron', 5899, *[292, 266, 291, 1334], 1)
    ops.element('FourNodeTetrahedron', 5900, *[1308, 1243, 1660, 1667], 1)
    ops.element('FourNodeTetrahedron', 5901, *[1166, 1122, 1660, 1243], 1)
    ops.element('FourNodeTetrahedron', 5902, *[1308, 1166, 1660, 1243], 1)
    ops.element('FourNodeTetrahedron', 5903, *[1308, 1166, 1611, 1660], 1)
    ops.element('FourNodeTetrahedron', 5904, *[1166, 1122, 1611, 1660], 1)
    ops.element('FourNodeTetrahedron', 5905, *[1142, 1171, 1708, 1659], 1)
    ops.element('FourNodeTetrahedron', 5906, *[1308, 1611, 353, 1660], 1)
    ops.element('FourNodeTetrahedron', 5907, *[1611, 352, 353, 1660], 1)
    ops.element('FourNodeTetrahedron', 5908, *[1611, 1122, 352, 1660], 1)
    ops.element('FourNodeTetrahedron', 5909, *[353, 1660, 352, 334], 1)
    ops.element('FourNodeTetrahedron', 5910, *[1609, 1655, 1581, 1610], 1)
    ops.element('FourNodeTetrahedron', 5911, *[225, 187, 190, 1277], 1)
    ops.element('FourNodeTetrahedron', 5912, *[648, 1457, 649, 629], 1)
    ops.element('FourNodeTetrahedron', 5913, *[1557, 1723, 1569, 1730], 1)
    ops.element('FourNodeTetrahedron', 5914, *[324, 1739, 325, 320], 1)
    ops.element('FourNodeTetrahedron', 5915, *[1532, 1742, 184, 1273], 1)
    ops.element('FourNodeTetrahedron', 5916, *[1172, 1249, 1673, 532], 1)
    ops.element('FourNodeTetrahedron', 5917, *[1172, 1249, 1427, 1673], 1)
    ops.element('FourNodeTetrahedron', 5918, *[550, 1673, 537, 538], 1)
    ops.element('FourNodeTetrahedron', 5919, *[1271, 1269, 1532, 1530], 1)
    ops.element('FourNodeTetrahedron', 5920, *[258, 262, 261, 1324], 1)
    ops.element('FourNodeTetrahedron', 5921, *[1340, 1164, 1582, 1595], 1)
    ops.element('FourNodeTetrahedron', 5922, *[378, 471, 470, 1663], 1)
    ops.element('FourNodeTetrahedron', 5923, *[1414, 1163, 1590, 399], 1)
    ops.element('FourNodeTetrahedron', 5924, *[1529, 654, 1736, 660], 1)
    ops.element('FourNodeTetrahedron', 5925, *[1149, 177, 155, 178], 1)
    ops.element('FourNodeTetrahedron', 5926, *[1561, 1288, 1292, 664], 1)
    ops.element('FourNodeTetrahedron', 5927, *[551, 1673, 550, 538], 1)
    ops.element('FourNodeTetrahedron', 5928, *[551, 1172, 1673, 538], 1)
    ops.element('FourNodeTetrahedron', 5929, *[392, 1668, 343, 1590], 1)
    ops.element('FourNodeTetrahedron', 5930, *[1673, 532, 531, 538], 1)
    ops.element('FourNodeTetrahedron', 5931, *[1326, 1331, 1318, 1542], 1)
    ops.element('FourNodeTetrahedron', 5932, *[1368, 666, 665, 684], 1)
    ops.element('FourNodeTetrahedron', 5933, *[1172, 532, 1673, 538], 1)
    ops.element('FourNodeTetrahedron', 5934, *[1610, 1506, 1642, 1698], 1)
    ops.element('FourNodeTetrahedron', 5935, *[1477, 1610, 1642, 1698], 1)
    ops.element('FourNodeTetrahedron', 5936, *[1426, 1445, 1720, 1704], 1)
    ops.element('FourNodeTetrahedron', 5937, *[254, 1383, 1360, 1290], 1)
    ops.element('FourNodeTetrahedron', 5938, *[1610, 1506, 1698, 604], 1)
    ops.element('FourNodeTetrahedron', 5939, *[1477, 1610, 1698, 604], 1)
    ops.element('FourNodeTetrahedron', 5940, *[1592, 1442, 1421, 1585], 1)
    ops.element('FourNodeTetrahedron', 5941, *[1465, 400, 414, 407], 1)
    ops.element('FourNodeTetrahedron', 5942, *[1736, 1663, 470, 475], 1)
    ops.element('FourNodeTetrahedron', 5943, *[1733, 1300, 1573, 518], 1)
    ops.element('FourNodeTetrahedron', 5944, *[627, 630, 1593, 631], 1)
    ops.element('FourNodeTetrahedron', 5945, *[356, 371, 357, 1462], 1)
    ops.element('FourNodeTetrahedron', 5946, *[356, 357, 410, 1462], 1)
    ops.element('FourNodeTetrahedron', 5947, *[533, 527, 1296, 439], 1)
    ops.element('FourNodeTetrahedron', 5948, *[295, 1378, 1367, 1408], 1)
    ops.element('FourNodeTetrahedron', 5949, *[298, 1319, 302, 454], 1)
    ops.element('FourNodeTetrahedron', 5950, *[1378, 1717, 1367, 1408], 1)
    ops.element('FourNodeTetrahedron', 5951, *[1471, 1487, 1717, 1511], 1)
    ops.element('FourNodeTetrahedron', 5952, *[1471, 1487, 1378, 1717], 1)
    ops.element('FourNodeTetrahedron', 5953, *[1471, 1717, 1378, 1408], 1)
    ops.element('FourNodeTetrahedron', 5954, *[656, 1266, 1373, 646], 1)
    ops.element('FourNodeTetrahedron', 5955, *[1461, 1533, 1290, 1463], 1)
    ops.element('FourNodeTetrahedron', 5956, *[1461, 1290, 1504, 1463], 1)
    ops.element('FourNodeTetrahedron', 5957, *[1463, 1535, 1477, 1693], 1)
    ops.element('FourNodeTetrahedron', 5958, *[1558, 1471, 1378, 1408], 1)
    ops.element('FourNodeTetrahedron', 5959, *[1558, 1471, 1408, 1511], 1)
    ops.element('FourNodeTetrahedron', 5960, *[1471, 1717, 1408, 1511], 1)
    ops.element('FourNodeTetrahedron', 5961, *[1254, 1168, 1145, 1676], 1)
    ops.element('FourNodeTetrahedron', 5962, *[1287, 1415, 757, 1300], 1)
    ops.element('FourNodeTetrahedron', 5963, *[1392, 1178, 1671, 1341], 1)
    ops.element('FourNodeTetrahedron', 5964, *[1392, 1671, 332, 1341], 1)
    ops.element('FourNodeTetrahedron', 5965, *[1341, 1671, 332, 1381], 1)
    ops.element('FourNodeTetrahedron', 5966, *[1341, 1178, 1671, 1177], 1)
    ops.element('FourNodeTetrahedron', 5967, *[1356, 1479, 1272, 1588], 1)
    ops.element('FourNodeTetrahedron', 5968, *[1738, 1300, 762, 1573], 1)
    ops.element('FourNodeTetrahedron', 5969, *[1341, 1178, 1177, 1125], 1)
    ops.element('FourNodeTetrahedron', 5970, *[1546, 1653, 1268, 1624], 1)
    ops.element('FourNodeTetrahedron', 5971, *[1341, 1177, 1671, 1381], 1)
    ops.element('FourNodeTetrahedron', 5972, *[355, 1606, 354, 1671], 1)
    ops.element('FourNodeTetrahedron', 5973, *[1125, 1381, 1423, 1176], 1)
    ops.element('FourNodeTetrahedron', 5974, *[1392, 1741, 355, 1671], 1)
    ops.element('FourNodeTetrahedron', 5975, *[1392, 1671, 355, 332], 1)
    ops.element('FourNodeTetrahedron', 5976, *[1671, 1177, 1667, 1381], 1)
    ops.element('FourNodeTetrahedron', 5977, *[184, 1742, 187, 1273], 1)
    ops.element('FourNodeTetrahedron', 5978, *[1446, 1393, 1335, 1459], 1)
    ops.element('FourNodeTetrahedron', 5979, *[1742, 1279, 186, 1665], 1)
    ops.element('FourNodeTetrahedron', 5980, *[1357, 1136, 1151, 1434], 1)
    ops.element('FourNodeTetrahedron', 5981, *[1178, 1250, 1671, 1177], 1)
    ops.element('FourNodeTetrahedron', 5982, *[1381, 1177, 1716, 1176], 1)
    ops.element('FourNodeTetrahedron', 5983, *[1379, 358, 364, 1446], 1)
    ops.element('FourNodeTetrahedron', 5984, *[1501, 1445, 359, 1446], 1)
    ops.element('FourNodeTetrahedron', 5985, *[1176, 1716, 1431, 1175], 1)
    ops.element('FourNodeTetrahedron', 5986, *[1183, 1131, 1564, 1182], 1)
    ops.element('FourNodeTetrahedron', 5987, *[1431, 1716, 1444, 1175], 1)
    ops.element('FourNodeTetrahedron', 5988, *[1564, 1184, 1309, 1195], 1)
    ops.element('FourNodeTetrahedron', 5989, *[1430, 1718, 1418, 1589], 1)
    ops.element('FourNodeTetrahedron', 5990, *[1519, 1508, 1728, 1556], 1)
    ops.element('FourNodeTetrahedron', 5991, *[312, 1417, 317, 1726], 1)
    ops.element('FourNodeTetrahedron', 5992, *[1495, 1396, 150, 1549], 1)
    ops.element('FourNodeTetrahedron', 5993, *[1423, 1176, 1716, 1431], 1)
    ops.element('FourNodeTetrahedron', 5994, *[1423, 1716, 1381, 1176], 1)
    ops.element('FourNodeTetrahedron', 5995, *[1494, 1724, 1469, 1460], 1)
    ops.element('FourNodeTetrahedron', 5996, *[1391, 1557, 1359, 1363], 1)
    ops.element('FourNodeTetrahedron', 5997, *[218, 1356, 173, 1272], 1)
    ops.element('FourNodeTetrahedron', 5998, *[1396, 149, 1298, 1275], 1)
    ops.element('FourNodeTetrahedron', 5999, *[1278, 1393, 469, 1529], 1)
    ops.element('FourNodeTetrahedron', 6000, *[1423, 1716, 1381, 1329], 1)
    ops.element('FourNodeTetrahedron', 6001, *[1423, 1716, 1329, 1431], 1)
    ops.element('FourNodeTetrahedron', 6002, *[1716, 1444, 1403, 1431], 1)
    ops.element('FourNodeTetrahedron', 6003, *[1740, 1735, 172, 214], 1)
    ops.element('FourNodeTetrahedron', 6004, *[1431, 1444, 1403, 1572], 1)
    ops.element('FourNodeTetrahedron', 6005, *[1588, 1721, 1272, 1370], 1)
    ops.element('FourNodeTetrahedron', 6006, *[1654, 1513, 1479, 1721], 1)
    ops.element('FourNodeTetrahedron', 6007, *[1654, 1721, 1479, 1588], 1)
    ops.element('FourNodeTetrahedron', 6008, *[1329, 1716, 1403, 1431], 1)
    ops.element('FourNodeTetrahedron', 6009, *[1381, 1716, 1403, 1329], 1)
    ops.element('FourNodeTetrahedron', 6010, *[1384, 471, 1663, 1687], 1)
    ops.element('FourNodeTetrahedron', 6011, *[1704, 1373, 1384, 1687], 1)
    ops.element('FourNodeTetrahedron', 6012, *[1380, 1494, 1707, 670], 1)
    ops.element('FourNodeTetrahedron', 6013, *[1601, 1335, 487, 1689], 1)
    ops.element('FourNodeTetrahedron', 6014, *[1520, 1379, 1601, 1689], 1)
    ops.element('FourNodeTetrahedron', 6015, *[1528, 1459, 1379, 1689], 1)
    ops.element('FourNodeTetrahedron', 6016, *[1520, 1597, 1689, 668], 1)
    ops.element('FourNodeTetrahedron', 6017, *[449, 1276, 250, 456], 1)
    ops.element('FourNodeTetrahedron', 6018, *[252, 1314, 1323, 1276], 1)
    ops.element('FourNodeTetrahedron', 6019, *[1198, 1128, 1458, 308], 1)
    ops.element('FourNodeTetrahedron', 6020, *[1689, 672, 1459, 669], 1)
    ops.element('FourNodeTetrahedron', 6021, *[1182, 1574, 1388, 1512], 1)
    ops.element('FourNodeTetrahedron', 6022, *[486, 1689, 669, 668], 1)
    ops.element('FourNodeTetrahedron', 6023, *[487, 1601, 1689, 486], 1)
    ops.element('FourNodeTetrahedron', 6024, *[1273, 1279, 1665, 1355], 1)
    ops.element('FourNodeTetrahedron', 6025, *[1373, 377, 370, 472], 1)
    ops.element('FourNodeTetrahedron', 6026, *[1184, 1240, 1306, 1309], 1)
    ops.element('FourNodeTetrahedron', 6027, *[370, 367, 377, 1373], 1)
    ops.element('FourNodeTetrahedron', 6028, *[1520, 668, 1689, 486], 1)
    ops.element('FourNodeTetrahedron', 6029, *[1520, 1689, 1601, 486], 1)
    ops.element('FourNodeTetrahedron', 6030, *[1601, 1379, 1335, 1689], 1)
    ops.element('FourNodeTetrahedron', 6031, *[549, 1688, 1293, 537], 1)
    ops.element('FourNodeTetrahedron', 6032, *[549, 1688, 1596, 1293], 1)
    ops.element('FourNodeTetrahedron', 6033, *[550, 1688, 1596, 549], 1)
    ops.element('FourNodeTetrahedron', 6034, *[518, 1647, 1516, 1518], 1)
    ops.element('FourNodeTetrahedron', 6035, *[1599, 1170, 163, 1438], 1)
    ops.element('FourNodeTetrahedron', 6036, *[550, 1673, 1688, 537], 1)
    ops.element('FourNodeTetrahedron', 6037, *[1688, 537, 1293, 531], 1)
    ops.element('FourNodeTetrahedron', 6038, *[1688, 1673, 531, 537], 1)
    ops.element('FourNodeTetrahedron', 6039, *[1688, 1427, 1293, 531], 1)
    ops.element('FourNodeTetrahedron', 6040, *[1688, 1673, 1427, 531], 1)
    ops.element('FourNodeTetrahedron', 6041, *[1354, 751, 1668, 1162], 1)
    ops.element('FourNodeTetrahedron', 6042, *[751, 752, 385, 1668], 1)
    ops.element('FourNodeTetrahedron', 6043, *[751, 1668, 385, 1354], 1)
    ops.element('FourNodeTetrahedron', 6044, *[1306, 1338, 251, 1432], 1)
    ops.element('FourNodeTetrahedron', 6045, *[1586, 1406, 1523, 1639], 1)
    ops.element('FourNodeTetrahedron', 6046, *[272, 1531, 241, 1391], 1)
    ops.element('FourNodeTetrahedron', 6047, *[1305, 1347, 442, 545], 1)
    ops.element('FourNodeTetrahedron', 6048, *[516, 1517, 1312, 520], 1)
    ops.element('FourNodeTetrahedron', 6049, *[384, 1354, 385, 392], 1)
    ops.element('FourNodeTetrahedron', 6050, *[706, 703, 1656, 1422], 1)
    ops.element('FourNodeTetrahedron', 6051, *[1437, 1258, 1509, 1246], 1)
    ops.element('FourNodeTetrahedron', 6052, *[1248, 1125, 1341, 1389], 1)
    ops.element('FourNodeTetrahedron', 6053, *[1662, 1301, 1552, 626], 1)
    ops.element('FourNodeTetrahedron', 6054, *[1716, 1137, 1395, 1512], 1)
    ops.element('FourNodeTetrahedron', 6055, *[1378, 1334, 292, 1367], 1)
    ops.element('FourNodeTetrahedron', 6056, *[1650, 372, 371, 1685], 1)
    ops.element('FourNodeTetrahedron', 6057, *[372, 1501, 358, 1685], 1)
    ops.element('FourNodeTetrahedron', 6058, *[1584, 1610, 1620, 1477], 1)
    ops.element('FourNodeTetrahedron', 6059, *[1404, 1430, 289, 1338], 1)
    ops.element('FourNodeTetrahedron', 6060, *[366, 367, 370, 1373], 1)
    ops.element('FourNodeTetrahedron', 6061, *[1390, 1180, 1237, 1248], 1)
    ops.element('FourNodeTetrahedron', 6062, *[1256, 1121, 1382, 1375], 1)
    ops.element('FourNodeTetrahedron', 6063, *[1564, 1309, 297, 1401], 1)
    ops.element('FourNodeTetrahedron', 6064, *[299, 1564, 297, 1401], 1)
    ops.element('FourNodeTetrahedron', 6065, *[385, 752, 339, 1668], 1)
    ops.element('FourNodeTetrahedron', 6066, *[1650, 1613, 1724, 1494], 1)
    ops.element('FourNodeTetrahedron', 6067, *[1571, 1564, 299, 1388], 1)
    ops.element('FourNodeTetrahedron', 6068, *[1183, 1564, 1571, 1388], 1)
    ops.element('FourNodeTetrahedron', 6069, *[1190, 146, 147, 1270], 1)
    ops.element('FourNodeTetrahedron', 6070, *[1477, 604, 1698, 603], 1)
    ops.element('FourNodeTetrahedron', 6071, *[274, 1363, 1337, 244], 1)
    ops.element('FourNodeTetrahedron', 6072, *[1650, 1724, 1528, 1494], 1)
    ops.element('FourNodeTetrahedron', 6073, *[1650, 1613, 1501, 1724], 1)
    ops.element('FourNodeTetrahedron', 6074, *[1650, 1724, 1501, 1528], 1)
    ops.element('FourNodeTetrahedron', 6075, *[1528, 1724, 1501, 1469], 1)
    ops.element('FourNodeTetrahedron', 6076, *[1494, 1724, 1528, 1469], 1)
    ops.element('FourNodeTetrahedron', 6077, *[1452, 1153, 1681, 1129], 1)
    ops.element('FourNodeTetrahedron', 6078, *[1153, 1386, 1681, 1217], 1)
    ops.element('FourNodeTetrahedron', 6079, *[1435, 1217, 1681, 1410], 1)
    ops.element('FourNodeTetrahedron', 6080, *[1681, 1217, 1386, 1410], 1)
    ops.element('FourNodeTetrahedron', 6081, *[1435, 1681, 397, 404], 1)
    ops.element('FourNodeTetrahedron', 6082, *[1681, 1386, 1414, 1410], 1)
    ops.element('FourNodeTetrahedron', 6083, *[1681, 392, 391, 398], 1)
    ops.element('FourNodeTetrahedron', 6084, *[1681, 1414, 398, 1410], 1)
    ops.element('FourNodeTetrahedron', 6085, *[1386, 1414, 392, 1681], 1)
    ops.element('FourNodeTetrahedron', 6086, *[1299, 1712, 1476, 607], 1)
    ops.element('FourNodeTetrahedron', 6087, *[1712, 1562, 1484, 1695], 1)
    ops.element('FourNodeTetrahedron', 6088, *[1284, 1562, 1314, 1712], 1)
    ops.element('FourNodeTetrahedron', 6089, *[1712, 1484, 1476, 607], 1)
    ops.element('FourNodeTetrahedron', 6090, *[1504, 1562, 1712, 1695], 1)
    ops.element('FourNodeTetrahedron', 6091, *[1712, 1695, 1484, 607], 1)
    ops.element('FourNodeTetrahedron', 6092, *[1504, 1695, 1712, 607], 1)
    ops.element('FourNodeTetrahedron', 6093, *[1590, 1661, 343, 347], 1)
    ops.element('FourNodeTetrahedron', 6094, *[1343, 1638, 1711, 1554], 1)
    ops.element('FourNodeTetrahedron', 6095, *[343, 1658, 342, 1661], 1)
    ops.element('FourNodeTetrahedron', 6096, *[1554, 1638, 1711, 1533], 1)
    ops.element('FourNodeTetrahedron', 6097, *[252, 256, 269, 1539], 1)
    ops.element('FourNodeTetrahedron', 6098, *[1602, 1372, 342, 1661], 1)
    ops.element('FourNodeTetrahedron', 6099, *[1417, 1174, 1357, 1200], 1)
    ops.element('FourNodeTetrahedron', 6100, *[1661, 1133, 350, 1606], 1)
    ops.element('FourNodeTetrahedron', 6101, *[1661, 1245, 1133, 1606], 1)
    ops.element('FourNodeTetrahedron', 6102, *[1368, 665, 1561, 681], 1)
    ops.element('FourNodeTetrahedron', 6103, *[1355, 185, 188, 1358], 1)
    ops.element('FourNodeTetrahedron', 6104, *[1584, 1420, 1610, 1693], 1)
    ops.element('FourNodeTetrahedron', 6105, *[1622, 1376, 1540, 1549], 1)
    ops.element('FourNodeTetrahedron', 6106, *[1708, 1171, 1361, 1659], 1)
    ops.element('FourNodeTetrahedron', 6107, *[1165, 1245, 1661, 351], 1)
    ops.element('FourNodeTetrahedron', 6108, *[280, 729, 275, 276], 1)
    ops.element('FourNodeTetrahedron', 6109, *[1475, 1615, 1655, 1524], 1)
    ops.element('FourNodeTetrahedron', 6110, *[1210, 1228, 1703, 1439], 1)
    ops.element('FourNodeTetrahedron', 6111, *[351, 1245, 1661, 1606], 1)
    ops.element('FourNodeTetrahedron', 6112, *[1590, 1165, 1661, 351], 1)
    ops.element('FourNodeTetrahedron', 6113, *[347, 1661, 350, 351], 1)
    ops.element('FourNodeTetrahedron', 6114, *[351, 1661, 350, 1606], 1)
    ops.element('FourNodeTetrahedron', 6115, *[1165, 1133, 1661, 1245], 1)
    ops.element('FourNodeTetrahedron', 6116, *[1193, 1133, 1661, 1165], 1)
    ops.element('FourNodeTetrahedron', 6117, *[1711, 1584, 1383, 1535], 1)
    ops.element('FourNodeTetrahedron', 6118, *[1334, 1343, 267, 1711], 1)
    ops.element('FourNodeTetrahedron', 6119, *[736, 1657, 315, 1547], 1)
    ops.element('FourNodeTetrahedron', 6120, *[1369, 1343, 267, 1334], 1)
    ops.element('FourNodeTetrahedron', 6121, *[1479, 161, 158, 1721], 1)
    ops.element('FourNodeTetrahedron', 6122, *[1480, 1208, 1722, 1456], 1)
    ops.element('FourNodeTetrahedron', 6123, *[265, 1360, 253, 1284], 1)
    ops.element('FourNodeTetrahedron', 6124, *[265, 253, 252, 1314], 1)
    ops.element('FourNodeTetrahedron', 6125, *[1604, 1453, 1630, 1722], 1)
    ops.element('FourNodeTetrahedron', 6126, *[1456, 1722, 1604, 1644], 1)
    ops.element('FourNodeTetrahedron', 6127, *[1167, 1254, 1274, 666], 1)
    ops.element('FourNodeTetrahedron', 6128, *[1334, 1554, 1533, 1715], 1)
    ops.element('FourNodeTetrahedron', 6129, *[736, 735, 1657, 1547], 1)
    ops.element('FourNodeTetrahedron', 6130, *[315, 735, 285, 1657], 1)
    ops.element('FourNodeTetrahedron', 6131, *[315, 1657, 285, 316], 1)
    ops.element('FourNodeTetrahedron', 6132, *[1212, 1148, 1398, 1675], 1)
    ops.element('FourNodeTetrahedron', 6133, *[1683, 1267, 1609, 1638], 1)
    ops.element('FourNodeTetrahedron', 6134, *[1274, 1254, 1676, 1259], 1)
    ops.element('FourNodeTetrahedron', 6135, *[1675, 632, 629, 653], 1)
    ops.element('FourNodeTetrahedron', 6136, *[653, 1148, 1675, 632], 1)
    ops.element('FourNodeTetrahedron', 6137, *[1148, 1175, 1675, 632], 1)
    ops.element('FourNodeTetrahedron', 6138, *[1148, 1175, 1431, 1675], 1)
    ops.element('FourNodeTetrahedron', 6139, *[1675, 1431, 629, 630], 1)
    ops.element('FourNodeTetrahedron', 6140, *[1675, 1175, 1431, 630], 1)
    ops.element('FourNodeTetrahedron', 6141, *[1675, 630, 629, 632], 1)
    ops.element('FourNodeTetrahedron', 6142, *[1675, 1175, 630, 632], 1)
    ops.element('FourNodeTetrahedron', 6143, *[632, 1175, 630, 633], 1)
    ops.element('FourNodeTetrahedron', 6144, *[666, 1259, 1274, 659], 1)
    ops.element('FourNodeTetrahedron', 6145, *[1716, 1667, 1395, 1137], 1)
    ops.element('FourNodeTetrahedron', 6146, *[1646, 1728, 1635, 1519], 1)
    ops.element('FourNodeTetrahedron', 6147, *[1648, 1646, 1635, 1519], 1)
    ops.element('FourNodeTetrahedron', 6148, *[1311, 1147, 1705, 1481], 1)
    ops.element('FourNodeTetrahedron', 6149, *[1532, 1269, 1279, 1538], 1)
    ops.element('FourNodeTetrahedron', 6150, *[1385, 763, 1286, 1573], 1)
    ops.element('FourNodeTetrahedron', 6151, *[1733, 1352, 1300, 518], 1)
    ops.element('FourNodeTetrahedron', 6152, *[1728, 1396, 1549, 1556], 1)
    ops.element('FourNodeTetrahedron', 6153, *[1157, 176, 163, 1170], 1)
    ops.element('FourNodeTetrahedron', 6154, *[1519, 1490, 1728, 1508], 1)
    ops.element('FourNodeTetrahedron', 6155, *[1170, 176, 163, 159], 1)
    ops.element('FourNodeTetrahedron', 6156, *[1272, 1721, 158, 1370], 1)
    ops.element('FourNodeTetrahedron', 6157, *[534, 1281, 527, 528], 1)
    ops.element('FourNodeTetrahedron', 6158, *[1369, 1306, 251, 1440], 1)
    ops.element('FourNodeTetrahedron', 6159, *[1407, 1273, 224, 1347], 1)
    ops.element('FourNodeTetrahedron', 6160, *[1326, 1331, 154, 1318], 1)
    ops.element('FourNodeTetrahedron', 6161, *[1728, 1490, 1495, 1396], 1)
    ops.element('FourNodeTetrahedron', 6162, *[1189, 1201, 1404, 1227], 1)
    ops.element('FourNodeTetrahedron', 6163, *[1415, 1579, 1485, 1452], 1)
    ops.element('FourNodeTetrahedron', 6164, *[1728, 1396, 1495, 1549], 1)
    ops.element('FourNodeTetrahedron', 6165, *[1646, 1490, 1608, 1728], 1)
    ops.element('FourNodeTetrahedron', 6166, *[1641, 1608, 1495, 1728], 1)
    ops.element('FourNodeTetrahedron', 6167, *[1324, 1353, 1737, 1537], 1)
    ops.element('FourNodeTetrahedron', 6168, *[763, 1303, 1286, 1573], 1)
    ops.element('FourNodeTetrahedron', 6169, *[240, 724, 245, 1531], 1)
    ops.element('FourNodeTetrahedron', 6170, *[1686, 747, 758, 1416], 1)
    ops.element('FourNodeTetrahedron', 6171, *[759, 747, 1686, 1239], 1)
    ops.element('FourNodeTetrahedron', 6172, *[1469, 1694, 1459, 672], 1)
    ops.element('FourNodeTetrahedron', 6173, *[1401, 1564, 1309, 1471], 1)
    ops.element('FourNodeTetrahedron', 6174, *[1702, 1700, 1460, 674], 1)
    ops.element('FourNodeTetrahedron', 6175, *[1613, 1425, 1501, 1724], 1)
    ops.element('FourNodeTetrahedron', 6176, *[1649, 1594, 1724, 1460], 1)
    ops.element('FourNodeTetrahedron', 6177, *[1269, 182, 183, 1279], 1)
    ops.element('FourNodeTetrahedron', 6178, *[759, 747, 758, 1686], 1)
    ops.element('FourNodeTetrahedron', 6179, *[1681, 1410, 398, 404], 1)
    ops.element('FourNodeTetrahedron', 6180, *[545, 1281, 1296, 533], 1)
    ops.element('FourNodeTetrahedron', 6181, *[669, 1278, 487, 480], 1)
    ops.element('FourNodeTetrahedron', 6182, *[523, 524, 1691, 421], 1)
    ops.element('FourNodeTetrahedron', 6183, *[274, 1443, 1337, 1285], 1)
    ops.element('FourNodeTetrahedron', 6184, *[1270, 145, 144, 418], 1)
    ops.element('FourNodeTetrahedron', 6185, *[1396, 149, 150, 1298], 1)
    ops.element('FourNodeTetrahedron', 6186, *[1527, 1664, 379, 387], 1)
    ops.element('FourNodeTetrahedron', 6187, *[764, 754, 753, 1664], 1)
    ops.element('FourNodeTetrahedron', 6188, *[753, 380, 379, 1664], 1)
    ops.element('FourNodeTetrahedron', 6189, *[1664, 380, 379, 387], 1)
    ops.element('FourNodeTetrahedron', 6190, *[1527, 379, 386, 387], 1)
    ops.element('FourNodeTetrahedron', 6191, *[756, 1666, 755, 1303], 1)
    ops.element('FourNodeTetrahedron', 6192, *[756, 1470, 1666, 1303], 1)
    ops.element('FourNodeTetrahedron', 6193, *[1303, 1666, 1286, 389], 1)
    ops.element('FourNodeTetrahedron', 6194, *[1286, 755, 1666, 1303], 1)
    ops.element('FourNodeTetrahedron', 6195, *[1680, 362, 361, 367], 1)
    ops.element('FourNodeTetrahedron', 6196, *[1680, 362, 367, 1464], 1)
    ops.element('FourNodeTetrahedron', 6197, *[1366, 1132, 1398, 1212], 1)
    ops.element('FourNodeTetrahedron', 6198, *[1713, 1532, 1407, 1618], 1)
    ops.element('FourNodeTetrahedron', 6199, *[1684, 1377, 1682, 620], 1)
    ops.element('FourNodeTetrahedron', 6200, *[1253, 1361, 1458, 1230], 1)
    ops.element('FourNodeTetrahedron', 6201, *[727, 1705, 1339, 1311], 1)
    ops.element('FourNodeTetrahedron', 6202, *[1622, 1728, 1495, 1549], 1)
    ops.element('FourNodeTetrahedron', 6203, *[1253, 1144, 1361, 1230], 1)
    ops.element('FourNodeTetrahedron', 6204, *[283, 1718, 278, 1418], 1)
    ops.element('FourNodeTetrahedron', 6205, *[677, 680, 1448, 681], 1)
    ops.element('FourNodeTetrahedron', 6206, *[1279, 185, 186, 1355], 1)
    ops.element('FourNodeTetrahedron', 6207, *[546, 1474, 545, 1281], 1)
    ops.element('FourNodeTetrahedron', 6208, *[1402, 169, 164, 163], 1)
    ops.element('FourNodeTetrahedron', 6209, *[1394, 1227, 1404, 1306], 1)
    ops.element('FourNodeTetrahedron', 6210, *[1490, 1510, 1495, 1396], 1)
    ops.element('FourNodeTetrahedron', 6211, *[1481, 1210, 1439, 1453], 1)
    ops.element('FourNodeTetrahedron', 6212, *[367, 362, 368, 1464], 1)
    ops.element('FourNodeTetrahedron', 6213, *[656, 1266, 646, 657], 1)
    ops.element('FourNodeTetrahedron', 6214, *[1129, 1218, 1435, 1221], 1)
    ops.element('FourNodeTetrahedron', 6215, *[1438, 1170, 159, 1510], 1)
    ops.element('FourNodeTetrahedron', 6216, *[1715, 1533, 1289, 1461], 1)
    ops.element('FourNodeTetrahedron', 6217, *[1424, 1585, 1550, 1292], 1)
    ops.element('FourNodeTetrahedron', 6218, *[658, 1436, 1455, 647], 1)
    ops.element('FourNodeTetrahedron', 6219, *[1715, 1533, 1461, 1441], 1)
    ops.element('FourNodeTetrahedron', 6220, *[1449, 1441, 1715, 1692], 1)
    ops.element('FourNodeTetrahedron', 6221, *[1715, 1441, 1461, 1692], 1)
    ops.element('FourNodeTetrahedron', 6222, *[1449, 1715, 1461, 1692], 1)
    ops.element('FourNodeTetrahedron', 6223, *[1367, 1715, 1289, 1377], 1)
    ops.element('FourNodeTetrahedron', 6224, *[1377, 1715, 1461, 1449], 1)
    ops.element('FourNodeTetrahedron', 6225, *[515, 770, 1733, 1352], 1)
    ops.element('FourNodeTetrahedron', 6226, *[1717, 1715, 1367, 1449], 1)
    ops.element('FourNodeTetrahedron', 6227, *[1717, 1441, 1449, 1701], 1)
    ops.element('FourNodeTetrahedron', 6228, *[1717, 1441, 1715, 1449], 1)
    ops.element('FourNodeTetrahedron', 6229, *[1717, 1554, 1715, 1441], 1)
    ops.element('FourNodeTetrahedron', 6230, *[1717, 1487, 1554, 1441], 1)
    ops.element('FourNodeTetrahedron', 6231, *[490, 1380, 1520, 667], 1)
    ops.element('FourNodeTetrahedron', 6232, *[1715, 1554, 1533, 1441], 1)
    ops.element('FourNodeTetrahedron', 6233, *[1705, 1210, 1703, 1481], 1)
    ops.element('FourNodeTetrahedron', 6234, *[712, 713, 702, 1157], 1)
    ops.element('FourNodeTetrahedron', 6235, *[712, 1157, 702, 1599], 1)
    ops.element('FourNodeTetrahedron', 6236, *[1481, 1703, 1723, 1607], 1)
    ops.element('FourNodeTetrahedron', 6237, *[236, 233, 1744, 237], 1)
    ops.element('FourNodeTetrahedron', 6238, *[1269, 137, 1279, 1326], 1)
    ops.element('FourNodeTetrahedron', 6239, *[1685, 1446, 1379, 1459], 1)
    ops.element('FourNodeTetrahedron', 6240, *[668, 672, 1689, 669], 1)
    ops.element('FourNodeTetrahedron', 6241, *[1650, 372, 1501, 1685], 1)
    ops.element('FourNodeTetrahedron', 6242, *[1530, 1540, 152, 1326], 1)
    ops.element('FourNodeTetrahedron', 6243, *[1578, 1586, 1397, 1629], 1)
    ops.element('FourNodeTetrahedron', 6244, *[1578, 1422, 708, 1397], 1)
    ops.element('FourNodeTetrahedron', 6245, *[1703, 1439, 1578, 1607], 1)
    ops.element('FourNodeTetrahedron', 6246, *[1723, 1339, 1703, 1578], 1)
    ops.element('FourNodeTetrahedron', 6247, *[1723, 1339, 1703, 1481], 1)
    ops.element('FourNodeTetrahedron', 6248, *[734, 733, 732, 1199], 1)
    ops.element('FourNodeTetrahedron', 6249, *[1339, 1705, 1703, 1481], 1)
    ops.element('FourNodeTetrahedron', 6250, *[1339, 1705, 710, 1703], 1)
    ops.element('FourNodeTetrahedron', 6251, *[267, 1343, 255, 1711], 1)
    ops.element('FourNodeTetrahedron', 6252, *[1296, 1281, 1468, 527], 1)
    ops.element('FourNodeTetrahedron', 6253, *[267, 255, 254, 1711], 1)
    ops.element('FourNodeTetrahedron', 6254, *[254, 255, 1383, 1711], 1)
    ops.element('FourNodeTetrahedron', 6255, *[1334, 267, 266, 1711], 1)
    ops.element('FourNodeTetrahedron', 6256, *[707, 172, 221, 1740], 1)
    ops.element('FourNodeTetrahedron', 6257, *[328, 325, 324, 1329], 1)
    ops.element('FourNodeTetrahedron', 6258, *[1289, 1711, 266, 1290], 1)
    ops.element('FourNodeTetrahedron', 6259, *[1334, 1711, 266, 1289], 1)
    ops.element('FourNodeTetrahedron', 6260, *[274, 1337, 244, 1285], 1)
    ops.element('FourNodeTetrahedron', 6261, *[1198, 1458, 307, 308], 1)
    ops.element('FourNodeTetrahedron', 6262, *[1198, 1253, 1458, 1128], 1)
    ops.element('FourNodeTetrahedron', 6263, *[1642, 1548, 1729, 1640], 1)
    ops.element('FourNodeTetrahedron', 6264, *[1253, 1230, 1458, 1128], 1)
    ops.element('FourNodeTetrahedron', 6265, *[1352, 1287, 1300, 1526], 1)
    ops.element('FourNodeTetrahedron', 6266, *[1334, 1711, 1289, 1533], 1)
    ops.element('FourNodeTetrahedron', 6267, *[1279, 1326, 1358, 1538], 1)
    ops.element('FourNodeTetrahedron', 6268, *[1289, 1711, 1290, 1533], 1)
    ops.element('FourNodeTetrahedron', 6269, *[267, 254, 266, 1711], 1)
    ops.element('FourNodeTetrahedron', 6270, *[1366, 1160, 1212, 1365], 1)
    ops.element('FourNodeTetrahedron', 6271, *[1366, 1132, 1212, 1160], 1)
    ops.element('FourNodeTetrahedron', 6272, *[137, 138, 1261, 1326], 1)
    ops.element('FourNodeTetrahedron', 6273, *[1426, 1704, 1720, 1694], 1)
    ops.element('FourNodeTetrahedron', 6274, *[1411, 1132, 1389, 1366], 1)
    ops.element('FourNodeTetrahedron', 6275, *[266, 1711, 254, 1290], 1)
    ops.element('FourNodeTetrahedron', 6276, *[1711, 1383, 254, 1290], 1)
    ops.element('FourNodeTetrahedron', 6277, *[1469, 1724, 1720, 1426], 1)
    ops.element('FourNodeTetrahedron', 6278, *[1724, 1594, 1445, 1426], 1)
    ops.element('FourNodeTetrahedron', 6279, *[509, 1732, 1494, 673], 1)
    ops.element('FourNodeTetrahedron', 6280, *[1724, 1445, 1720, 1426], 1)
    ops.element('FourNodeTetrahedron', 6281, *[722, 726, 721, 1325], 1)
    ops.element('FourNodeTetrahedron', 6282, *[721, 726, 725, 1710], 1)
    ops.element('FourNodeTetrahedron', 6283, *[721, 725, 1330, 1710], 1)
    ops.element('FourNodeTetrahedron', 6284, *[1330, 1710, 725, 1345], 1)
    ops.element('FourNodeTetrahedron', 6285, *[1365, 1212, 1675, 653], 1)
    ops.element('FourNodeTetrahedron', 6286, *[726, 716, 725, 1710], 1)
    ops.element('FourNodeTetrahedron', 6287, *[1710, 716, 725, 1345], 1)
    ops.element('FourNodeTetrahedron', 6288, *[1710, 1339, 716, 1345], 1)
    ops.element('FourNodeTetrahedron', 6289, *[1710, 726, 716, 1339], 1)
    ops.element('FourNodeTetrahedron', 6290, *[1459, 1446, 1393, 1294], 1)
    ops.element('FourNodeTetrahedron', 6291, *[1721, 1674, 157, 1495], 1)
    ops.element('FourNodeTetrahedron', 6292, *[1513, 160, 161, 1674], 1)
    ops.element('FourNodeTetrahedron', 6293, *[518, 1300, 1573, 1516], 1)
    ops.element('FourNodeTetrahedron', 6294, *[217, 1387, 214, 216], 1)
    ops.element('FourNodeTetrahedron', 6295, *[618, 1701, 1692, 619], 1)
    ops.element('FourNodeTetrahedron', 6296, *[729, 730, 721, 1325], 1)
    ops.element('FourNodeTetrahedron', 6297, *[1710, 726, 1339, 1311], 1)
    ops.element('FourNodeTetrahedron', 6298, *[262, 263, 1310, 1327], 1)
    ops.element('FourNodeTetrahedron', 6299, *[522, 420, 431, 435], 1)
    ops.element('FourNodeTetrahedron', 6300, *[709, 706, 708, 1422], 1)
    ops.element('FourNodeTetrahedron', 6301, *[1641, 1513, 1721, 1495], 1)
    ops.element('FourNodeTetrahedron', 6302, *[1150, 1220, 1447, 1222], 1)
    ops.element('FourNodeTetrahedron', 6303, *[1381, 1667, 333, 1714], 1)
    ops.element('FourNodeTetrahedron', 6304, *[1567, 1626, 1619, 1545], 1)
    ops.element('FourNodeTetrahedron', 6305, *[1400, 1201, 1206, 1430], 1)
    ops.element('FourNodeTetrahedron', 6306, *[333, 1667, 334, 1714], 1)
    ops.element('FourNodeTetrahedron', 6307, *[1381, 333, 329, 1714], 1)
    ops.element('FourNodeTetrahedron', 6308, *[1459, 1694, 1294, 661], 1)
    ops.element('FourNodeTetrahedron', 6309, *[672, 1694, 1459, 661], 1)
    ops.element('FourNodeTetrahedron', 6310, *[448, 1299, 1563, 451], 1)
    ops.element('FourNodeTetrahedron', 6311, *[529, 1498, 1745, 522], 1)
    ops.element('FourNodeTetrahedron', 6312, *[1744, 1371, 233, 1537], 1)
    ops.element('FourNodeTetrahedron', 6313, *[1381, 1667, 1714, 1716], 1)
    ops.element('FourNodeTetrahedron', 6314, *[1656, 1402, 169, 164], 1)
    ops.element('FourNodeTetrahedron', 6315, *[749, 750, 746, 1579], 1)
    ops.element('FourNodeTetrahedron', 6316, *[1667, 1395, 334, 1714], 1)
    ops.element('FourNodeTetrahedron', 6317, *[329, 334, 330, 1714], 1)
    ops.element('FourNodeTetrahedron', 6318, *[334, 1395, 330, 1714], 1)
    ops.element('FourNodeTetrahedron', 6319, *[1381, 1714, 329, 1403], 1)
    ops.element('FourNodeTetrahedron', 6320, *[1582, 1226, 1392, 1595], 1)
    ops.element('FourNodeTetrahedron', 6321, *[456, 1551, 1276, 1299], 1)
    ops.element('FourNodeTetrahedron', 6322, *[1299, 613, 1551, 607], 1)
    ops.element('FourNodeTetrahedron', 6323, *[607, 1695, 1484, 602], 1)
    ops.element('FourNodeTetrahedron', 6324, *[1695, 603, 602, 607], 1)
    ops.element('FourNodeTetrahedron', 6325, *[514, 1159, 771, 1352], 1)
    ops.element('FourNodeTetrahedron', 6326, *[1135, 1155, 1524, 1216], 1)
    ops.element('FourNodeTetrahedron', 6327, *[1299, 1476, 1563, 607], 1)
    ops.element('FourNodeTetrahedron', 6328, *[1358, 1318, 188, 431], 1)
    ops.element('FourNodeTetrahedron', 6329, *[1381, 1716, 1714, 1403], 1)
    ops.element('FourNodeTetrahedron', 6330, *[1721, 1513, 161, 1674], 1)
    ops.element('FourNodeTetrahedron', 6331, *[489, 356, 410, 1462], 1)
    ops.element('FourNodeTetrahedron', 6332, *[522, 431, 436, 435], 1)
    ops.element('FourNodeTetrahedron', 6333, *[1370, 1376, 158, 152], 1)
    ops.element('FourNodeTetrahedron', 6334, *[1499, 1523, 164, 161], 1)
    ops.element('FourNodeTetrahedron', 6335, *[1502, 1652, 1729, 1591], 1)
    ops.element('FourNodeTetrahedron', 6336, *[1288, 1676, 1436, 659], 1)
    ops.element('FourNodeTetrahedron', 6337, *[1288, 1297, 1436, 1676], 1)
    ops.element('FourNodeTetrahedron', 6338, *[1676, 651, 645, 659], 1)
    ops.element('FourNodeTetrahedron', 6339, *[1274, 1297, 1288, 1676], 1)
    ops.element('FourNodeTetrahedron', 6340, *[1274, 1676, 1288, 659], 1)
    ops.element('FourNodeTetrahedron', 6341, *[725, 715, 724, 1260], 1)
    ops.element('FourNodeTetrahedron', 6342, *[1317, 1260, 724, 1349], 1)
    ops.element('FourNodeTetrahedron', 6343, *[666, 659, 1274, 665], 1)
    ops.element('FourNodeTetrahedron', 6344, *[185, 1261, 137, 1279], 1)
    ops.element('FourNodeTetrahedron', 6345, *[650, 1168, 1676, 651], 1)
    ops.element('FourNodeTetrahedron', 6346, *[650, 1676, 659, 651], 1)
    ops.element('FourNodeTetrahedron', 6347, *[720, 1260, 1317, 1330], 1)
    ops.element('FourNodeTetrahedron', 6348, *[1442, 1375, 1631, 1411], 1)
    ops.element('FourNodeTetrahedron', 6349, *[518, 1516, 1517, 1616], 1)
    ops.element('FourNodeTetrahedron', 6350, *[724, 1260, 715, 1349], 1)
    ops.element('FourNodeTetrahedron', 6351, *[1295, 1455, 1373, 1266], 1)
    ops.element('FourNodeTetrahedron', 6352, *[444, 1305, 442, 545], 1)
    ops.element('FourNodeTetrahedron', 6353, *[1645, 1608, 1641, 1731], 1)
    ops.element('FourNodeTetrahedron', 6354, *[766, 411, 481, 1527], 1)
    ops.element('FourNodeTetrahedron', 6355, *[1660, 1388, 335, 1395], 1)
    ops.element('FourNodeTetrahedron', 6356, *[537, 1293, 536, 530], 1)
    ops.element('FourNodeTetrahedron', 6357, *[1385, 387, 1527, 1521], 1)
    ops.element('FourNodeTetrahedron', 6358, *[550, 1688, 549, 537], 1)
    ops.element('FourNodeTetrahedron', 6359, *[302, 294, 303, 1377], 1)
    ops.element('FourNodeTetrahedron', 6360, *[1127, 1147, 1481, 1209], 1)
    ops.element('FourNodeTetrahedron', 6361, *[1609, 1475, 1581, 1655], 1)
    ops.element('FourNodeTetrahedron', 6362, *[1518, 403, 402, 373], 1)
    ops.element('FourNodeTetrahedron', 6363, *[1289, 266, 265, 1290], 1)
    ops.element('FourNodeTetrahedron', 6364, *[481, 1312, 1527, 412], 1)
    ops.element('FourNodeTetrahedron', 6365, *[1289, 1290, 265, 1332], 1)
    ops.element('FourNodeTetrahedron', 6366, *[1328, 1537, 1744, 1514], 1)
    ops.element('FourNodeTetrahedron', 6367, *[1570, 1723, 1583, 1727], 1)
    ops.element('FourNodeTetrahedron', 6368, *[1147, 1210, 1481, 1209], 1)
    ops.element('FourNodeTetrahedron', 6369, *[1130, 1149, 1719, 1191], 1)
    ops.element('FourNodeTetrahedron', 6370, *[1500, 1485, 390, 397], 1)
    ops.element('FourNodeTetrahedron', 6371, *[1441, 1433, 1638, 1637], 1)
    ops.element('FourNodeTetrahedron', 6372, *[390, 1485, 391, 397], 1)
    ops.element('FourNodeTetrahedron', 6373, *[1642, 1655, 1548, 1640], 1)
    ops.element('FourNodeTetrahedron', 6374, *[1376, 157, 158, 152], 1)
    ops.element('FourNodeTetrahedron', 6375, *[279, 1443, 273, 274], 1)
    ops.element('FourNodeTetrahedron', 6376, *[1558, 1378, 295, 1408], 1)
    ops.element('FourNodeTetrahedron', 6377, *[1597, 672, 1689, 668], 1)
    ops.element('FourNodeTetrahedron', 6378, *[516, 1733, 1573, 518], 1)
    ops.element('FourNodeTetrahedron', 6379, *[1547, 1357, 316, 1417], 1)
    ops.element('FourNodeTetrahedron', 6380, *[624, 1511, 618, 625], 1)
    ops.element('FourNodeTetrahedron', 6381, *[1273, 1279, 1742, 1665], 1)
    ops.element('FourNodeTetrahedron', 6382, *[1312, 1521, 412, 482], 1)
    ops.element('FourNodeTetrahedron', 6383, *[1363, 1359, 217, 1350], 1)
    ops.element('FourNodeTetrahedron', 6384, *[1186, 1188, 1571, 1183], 1)
    ops.element('FourNodeTetrahedron', 6385, *[1526, 1437, 1263, 1509], 1)
    ops.element('FourNodeTetrahedron', 6386, *[1642, 1655, 1640, 1506], 1)
    ops.element('FourNodeTetrahedron', 6387, *[276, 1413, 271, 272], 1)
    ops.element('FourNodeTetrahedron', 6388, *[276, 1413, 272, 277], 1)
    ops.element('FourNodeTetrahedron', 6389, *[1532, 1279, 1273, 1534], 1)
    ops.element('FourNodeTetrahedron', 6390, *[1419, 1548, 1285, 1327], 1)
    ops.element('FourNodeTetrahedron', 6391, *[1517, 1303, 1286, 395], 1)
    ops.element('FourNodeTetrahedron', 6392, *[1303, 389, 1286, 395], 1)
    ops.element('FourNodeTetrahedron', 6393, *[1525, 1429, 1497, 1447], 1)
    ops.element('FourNodeTetrahedron', 6394, *[658, 645, 1436, 659], 1)
    ops.element('FourNodeTetrahedron', 6395, *[251, 1338, 284, 255], 1)
    ops.element('FourNodeTetrahedron', 6396, *[283, 1418, 278, 279], 1)
    ops.element('FourNodeTetrahedron', 6397, *[1152, 1194, 1472, 621], 1)
    ops.element('FourNodeTetrahedron', 6398, *[752, 1658, 1668, 1143], 1)
    ops.element('FourNodeTetrahedron', 6399, *[1262, 1186, 308, 309], 1)
    ops.element('FourNodeTetrahedron', 6400, *[1122, 1262, 348, 352], 1)
    ops.element('FourNodeTetrahedron', 6401, *[342, 1320, 337, 341], 1)
    ops.element('FourNodeTetrahedron', 6402, *[1697, 547, 1505, 602], 1)
    ops.element('FourNodeTetrahedron', 6403, *[1339, 1703, 709, 1578], 1)
    ops.element('FourNodeTetrahedron', 6404, *[1560, 1645, 1553, 1588], 1)
    ops.element('FourNodeTetrahedron', 6405, *[1383, 1609, 1581, 1620], 1)
    ops.element('FourNodeTetrahedron', 6406, *[1394, 1306, 319, 293], 1)
    ops.element('FourNodeTetrahedron', 6407, *[1297, 1160, 1366, 645], 1)
    ops.element('FourNodeTetrahedron', 6408, *[1556, 1508, 1275, 1625], 1)
    ops.element('FourNodeTetrahedron', 6409, *[440, 1277, 190, 434], 1)
    ops.element('FourNodeTetrahedron', 6410, *[658, 645, 1436, 647], 1)
    ops.element('FourNodeTetrahedron', 6411, *[1611, 348, 349, 353], 1)
    ops.element('FourNodeTetrahedron', 6412, *[743, 742, 1602, 1193], 1)
    ops.element('FourNodeTetrahedron', 6413, *[271, 1531, 241, 272], 1)
    ops.element('FourNodeTetrahedron', 6414, *[1457, 1431, 1572, 629], 1)
    ops.element('FourNodeTetrahedron', 6415, *[1523, 1438, 163, 160], 1)
    ops.element('FourNodeTetrahedron', 6416, *[1394, 1227, 1306, 1184], 1)
    ops.element('FourNodeTetrahedron', 6417, *[1333, 1397, 1740, 1387], 1)
    ops.element('FourNodeTetrahedron', 6418, *[1467, 1511, 1282, 624], 1)
    ops.element('FourNodeTetrahedron', 6419, *[337, 1320, 336, 341], 1)
    ops.element('FourNodeTetrahedron', 6420, *[1523, 163, 164, 160], 1)
    ops.element('FourNodeTetrahedron', 6421, *[1282, 1511, 1408, 624], 1)
    ops.element('FourNodeTetrahedron', 6422, *[1124, 1741, 351, 1392], 1)
    ops.element('FourNodeTetrahedron', 6423, *[524, 422, 1691, 421], 1)
    ops.element('FourNodeTetrahedron', 6424, *[1411, 1244, 1132, 1366], 1)
    ops.element('FourNodeTetrahedron', 6425, *[1269, 137, 182, 1279], 1)
    ops.element('FourNodeTetrahedron', 6426, *[1186, 1233, 1670, 1188], 1)
    ops.element('FourNodeTetrahedron', 6427, *[1371, 1623, 1713, 1559], 1)
    ops.element('FourNodeTetrahedron', 6428, *[1246, 1221, 1525, 1150], 1)
    ops.element('FourNodeTetrahedron', 6429, *[1523, 164, 161, 160], 1)
    ops.element('FourNodeTetrahedron', 6430, *[1450, 1483, 1680, 1464], 1)
    ops.element('FourNodeTetrahedron', 6431, *[1125, 1176, 1423, 1179], 1)
    ops.element('FourNodeTetrahedron', 6432, *[288, 1434, 1718, 1430], 1)
    ops.element('FourNodeTetrahedron', 6433, *[1618, 1530, 1628, 1652], 1)
    ops.element('FourNodeTetrahedron', 6434, *[1534, 1617, 1538, 1544], 1)
    ops.element('FourNodeTetrahedron', 6435, *[529, 1488, 1498, 523], 1)
    ops.element('FourNodeTetrahedron', 6436, *[619, 615, 1692, 620], 1)
    ops.element('FourNodeTetrahedron', 6437, *[530, 1488, 529, 523], 1)
    ops.element('FourNodeTetrahedron', 6438, *[1285, 249, 235, 220], 1)
    ops.element('FourNodeTetrahedron', 6439, *[1629, 1499, 1479, 1654], 1)
    ops.element('FourNodeTetrahedron', 6440, *[234, 1285, 235, 1310], 1)
    ops.element('FourNodeTetrahedron', 6441, *[234, 1285, 249, 235], 1)
    ops.element('FourNodeTetrahedron', 6442, *[263, 1285, 274, 234], 1)
    ops.element('FourNodeTetrahedron', 6443, *[244, 1285, 249, 234], 1)
    ops.element('FourNodeTetrahedron', 6444, *[274, 1285, 244, 234], 1)
    ops.element('FourNodeTetrahedron', 6445, *[1440, 1205, 1432, 1231], 1)
    ops.element('FourNodeTetrahedron', 6446, *[1320, 1192, 341, 1372], 1)
    ops.element('FourNodeTetrahedron', 6447, *[1621, 1271, 1412, 1530], 1)
    ops.element('FourNodeTetrahedron', 6448, *[375, 1315, 405, 376], 1)
    ops.element('FourNodeTetrahedron', 6449, *[1472, 1511, 1467, 625], 1)
    ops.element('FourNodeTetrahedron', 6450, *[729, 730, 1325, 1428], 1)
    ops.element('FourNodeTetrahedron', 6451, *[1445, 1632, 366, 1373], 1)
    ops.element('FourNodeTetrahedron', 6452, *[1493, 1451, 1600, 1627], 1)
    ops.element('FourNodeTetrahedron', 6453, *[1213, 1153, 1579, 1452], 1)
    ops.element('FourNodeTetrahedron', 6454, *[375, 1315, 376, 1390], 1)
    ops.element('FourNodeTetrahedron', 6455, *[1482, 147, 148, 1270], 1)
    ops.element('FourNodeTetrahedron', 6456, *[742, 741, 337, 1320], 1)
    ops.element('FourNodeTetrahedron', 6457, *[1602, 742, 1320, 1161], 1)
    ops.element('FourNodeTetrahedron', 6458, *[1356, 1479, 158, 1272], 1)
    ops.element('FourNodeTetrahedron', 6459, *[1648, 1688, 1596, 550], 1)
    ops.element('FourNodeTetrahedron', 6460, *[1131, 1195, 1471, 1194], 1)
    ops.element('FourNodeTetrahedron', 6461, *[1121, 1234, 1375, 1223], 1)
    ops.element('FourNodeTetrahedron', 6462, *[1641, 1721, 1370, 1376], 1)
    ops.element('FourNodeTetrahedron', 6463, *[1518, 402, 372, 373], 1)
    ops.element('FourNodeTetrahedron', 6464, *[669, 1459, 661, 672], 1)
    ops.element('FourNodeTetrahedron', 6465, *[1672, 165, 166, 162], 1)
    ops.element('FourNodeTetrahedron', 6466, *[1608, 1490, 1495, 1728], 1)
    ops.element('FourNodeTetrahedron', 6467, *[1146, 1257, 1451, 1368], 1)
    ops.element('FourNodeTetrahedron', 6468, *[1282, 298, 453, 464], 1)
    ops.element('FourNodeTetrahedron', 6469, *[1392, 1241, 1671, 1178], 1)
    ops.element('FourNodeTetrahedron', 6470, *[1432, 1267, 1683, 1638], 1)
    ops.element('FourNodeTetrahedron', 6471, *[1500, 390, 396, 397], 1)
    ops.element('FourNodeTetrahedron', 6472, *[601, 1514, 546, 602], 1)
    ops.element('FourNodeTetrahedron', 6473, *[1475, 1251, 1204, 1135], 1)
    ops.element('FourNodeTetrahedron', 6474, *[330, 1395, 331, 1405], 1)
    ops.element('FourNodeTetrahedron', 6475, *[1300, 1500, 1470, 1516], 1)
    ops.element('FourNodeTetrahedron', 6476, *[1300, 1470, 1303, 1516], 1)
    ops.element('FourNodeTetrahedron', 6477, *[1300, 1415, 1470, 1500], 1)
    ops.element('FourNodeTetrahedron', 6478, *[1303, 756, 1470, 1300], 1)
    ops.element('FourNodeTetrahedron', 6479, *[1502, 548, 1591, 547], 1)
    ops.element('FourNodeTetrahedron', 6480, *[1641, 1608, 1513, 1495], 1)
    ops.element('FourNodeTetrahedron', 6481, *[1391, 1333, 215, 1359], 1)
    ops.element('FourNodeTetrahedron', 6482, *[273, 1363, 243, 274], 1)
    ops.element('FourNodeTetrahedron', 6483, *[1195, 1240, 1440, 1138], 1)
    ops.element('FourNodeTetrahedron', 6484, *[1733, 770, 1300, 1352], 1)
    ops.element('FourNodeTetrahedron', 6485, *[1319, 1408, 1449, 618], 1)
    ops.element('FourNodeTetrahedron', 6486, *[743, 742, 338, 1602], 1)
    ops.element('FourNodeTetrahedron', 6487, *[1365, 653, 1675, 648], 1)
    ops.element('FourNodeTetrahedron', 6488, *[745, 746, 744, 1485], 1)
    ops.element('FourNodeTetrahedron', 6489, *[321, 326, 322, 1322], 1)
    ops.element('FourNodeTetrahedron', 6490, *[1359, 1333, 214, 1387], 1)
    ops.element('FourNodeTetrahedron', 6491, *[708, 1422, 706, 1397], 1)
    ops.element('FourNodeTetrahedron', 6492, *[514, 771, 515, 1352], 1)
    ops.element('FourNodeTetrahedron', 6493, *[757, 1415, 1470, 1300], 1)
    ops.element('FourNodeTetrahedron', 6494, *[1552, 1364, 466, 627], 1)
    ops.element('FourNodeTetrahedron', 6495, *[1590, 1165, 351, 1124], 1)
    ops.element('FourNodeTetrahedron', 6496, *[1163, 1165, 1590, 1124], 1)
    ops.element('FourNodeTetrahedron', 6497, *[320, 1322, 462, 1552], 1)
    ops.element('FourNodeTetrahedron', 6498, *[1531, 1349, 246, 1391], 1)
    ops.element('FourNodeTetrahedron', 6499, *[1278, 469, 479, 474], 1)
    ops.element('FourNodeTetrahedron', 6500, *[251, 1343, 267, 1369], 1)
    ops.element('FourNodeTetrahedron', 6501, *[1363, 1575, 1350, 1337], 1)
    ops.element('FourNodeTetrahedron', 6502, *[222, 1272, 135, 1271], 1)
    ops.element('FourNodeTetrahedron', 6503, *[1272, 153, 135, 1271], 1)
    ops.element('FourNodeTetrahedron', 6504, *[351, 1245, 1606, 1741], 1)
    ops.element('FourNodeTetrahedron', 6505, *[293, 267, 292, 1369], 1)
    ops.element('FourNodeTetrahedron', 6506, *[292, 1369, 267, 1334], 1)
    ops.element('FourNodeTetrahedron', 6507, *[630, 1593, 631, 634], 1)
    ops.element('FourNodeTetrahedron', 6508, *[513, 1134, 1526, 1246], 1)
    ops.element('FourNodeTetrahedron', 6509, *[1533, 1535, 1290, 1463], 1)
    ops.element('FourNodeTetrahedron', 6510, *[439, 1296, 527, 438], 1)
    ops.element('FourNodeTetrahedron', 6511, *[1274, 1259, 1676, 659], 1)
    ops.element('FourNodeTetrahedron', 6512, *[284, 1418, 279, 1342], 1)
    ops.element('FourNodeTetrahedron', 6513, *[1732, 1702, 673, 510], 1)
    ops.element('FourNodeTetrahedron', 6514, *[1494, 671, 1707, 670], 1)
    ops.element('FourNodeTetrahedron', 6515, *[1502, 1640, 1652, 1603], 1)
    ops.element('FourNodeTetrahedron', 6516, *[1318, 139, 415, 431], 1)
    ops.element('FourNodeTetrahedron', 6517, *[1498, 523, 522, 529], 1)
    ops.element('FourNodeTetrahedron', 6518, *[305, 1304, 311, 306], 1)
    ops.element('FourNodeTetrahedron', 6519, *[1342, 1419, 279, 259], 1)
    ops.element('FourNodeTetrahedron', 6520, *[1549, 1298, 1280, 1626], 1)
    ops.element('FourNodeTetrahedron', 6521, *[300, 1401, 1558, 1336], 1)
    ops.element('FourNodeTetrahedron', 6522, *[627, 1593, 1489, 631], 1)
    ops.element('FourNodeTetrahedron', 6523, *[266, 254, 1360, 1290], 1)
    ops.element('FourNodeTetrahedron', 6524, *[215, 1333, 214, 1359], 1)
    ops.element('FourNodeTetrahedron', 6525, *[1359, 214, 215, 217], 1)
    ops.element('FourNodeTetrahedron', 6526, *[1413, 1565, 1583, 1727], 1)
    ops.element('FourNodeTetrahedron', 6527, *[247, 1359, 215, 217], 1)
    ops.element('FourNodeTetrahedron', 6528, *[1328, 232, 237, 1313], 1)
    ops.element('FourNodeTetrahedron', 6529, *[1375, 1235, 1390, 1411], 1)
    ops.element('FourNodeTetrahedron', 6530, *[1199, 1151, 1307, 1357], 1)
    ops.element('FourNodeTetrahedron', 6531, *[1497, 1677, 374, 1592], 1)
    ops.element('FourNodeTetrahedron', 6532, *[1199, 1307, 732, 1357], 1)
    ops.element('FourNodeTetrahedron', 6533, *[1171, 738, 1304, 1144], 1)
    ops.element('FourNodeTetrahedron', 6534, *[1441, 1638, 1533, 1637], 1)
    ops.element('FourNodeTetrahedron', 6535, *[1627, 1368, 1561, 681], 1)
    ops.element('FourNodeTetrahedron', 6536, *[1616, 402, 401, 372], 1)
    ops.element('FourNodeTetrahedron', 6537, *[287, 1357, 1434, 1400], 1)
    ops.element('FourNodeTetrahedron', 6538, *[1647, 1150, 1525, 1614], 1)
    ops.element('FourNodeTetrahedron', 6539, *[457, 1319, 454, 458], 1)
    ops.element('FourNodeTetrahedron', 6540, *[1570, 1710, 1583, 1723], 1)
    ops.element('FourNodeTetrahedron', 6541, *[317, 1400, 287, 288], 1)
    ops.element('FourNodeTetrahedron', 6542, *[1604, 1607, 1575, 1630], 1)
    ops.element('FourNodeTetrahedron', 6543, *[1283, 1498, 1544, 1745], 1)
    ops.element('FourNodeTetrahedron', 6544, *[1553, 1479, 1356, 1588], 1)
    ops.element('FourNodeTetrahedron', 6545, *[625, 1709, 1511, 617], 1)
    ops.element('FourNodeTetrahedron', 6546, *[1456, 1204, 1522, 1615], 1)
    ops.element('FourNodeTetrahedron', 6547, *[1393, 378, 470, 1663], 1)
    ops.element('FourNodeTetrahedron', 6548, *[1398, 1457, 1496, 1492], 1)
    ops.element('FourNodeTetrahedron', 6549, *[265, 1284, 264, 1332], 1)
    ops.element('FourNodeTetrahedron', 6550, *[1185, 1183, 1388, 1182], 1)
    ops.element('FourNodeTetrahedron', 6551, *[1216, 1155, 1524, 1420], 1)
    ops.element('FourNodeTetrahedron', 6552, *[764, 754, 1664, 1385], 1)
    ops.element('FourNodeTetrahedron', 6553, *[1157, 702, 1402, 1599], 1)
    ops.element('FourNodeTetrahedron', 6554, *[1270, 146, 145, 419], 1)
    ops.element('FourNodeTetrahedron', 6555, *[1702, 1649, 1700, 677], 1)
    ops.element('FourNodeTetrahedron', 6556, *[521, 1734, 510, 511], 1)
    ops.element('FourNodeTetrahedron', 6557, *[704, 712, 702, 1599], 1)
    ops.element('FourNodeTetrahedron', 6558, *[664, 1292, 657, 658], 1)
    ops.element('FourNodeTetrahedron', 6559, *[1319, 618, 458, 624], 1)
    ops.element('FourNodeTetrahedron', 6560, *[664, 1292, 657, 663], 1)
    ops.element('FourNodeTetrahedron', 6561, *[1237, 1178, 1341, 1125], 1)
    ops.element('FourNodeTetrahedron', 6562, *[1736, 475, 470, 474], 1)
    ops.element('FourNodeTetrahedron', 6563, *[1556, 1508, 1396, 1275], 1)
    ops.element('FourNodeTetrahedron', 6564, *[373, 360, 359, 1425], 1)
    ops.element('FourNodeTetrahedron', 6565, *[1620, 1642, 1327, 1634], 1)
    ops.element('FourNodeTetrahedron', 6566, *[1363, 1359, 1350, 1575], 1)
    ops.element('FourNodeTetrahedron', 6567, *[485, 1520, 488, 486], 1)
    ops.element('FourNodeTetrahedron', 6568, *[332, 333, 329, 1381], 1)
    ops.element('FourNodeTetrahedron', 6569, *[1723, 1339, 1345, 1578], 1)
    ops.element('FourNodeTetrahedron', 6570, *[1570, 1339, 1723, 1481], 1)
    ops.element('FourNodeTetrahedron', 6571, *[343, 1661, 346, 347], 1)
    ops.element('FourNodeTetrahedron', 6572, *[342, 1320, 341, 1372], 1)
    ops.element('FourNodeTetrahedron', 6573, *[1321, 238, 443, 447], 1)
    ops.element('FourNodeTetrahedron', 6574, *[758, 745, 757, 1415], 1)
    ops.element('FourNodeTetrahedron', 6575, *[1673, 1249, 1427, 525], 1)
    ops.element('FourNodeTetrahedron', 6576, *[1325, 722, 726, 1311], 1)
    ops.element('FourNodeTetrahedron', 6577, *[1500, 1452, 1681, 1435], 1)
    ops.element('FourNodeTetrahedron', 6578, *[277, 1399, 1413, 1565], 1)
    ops.element('FourNodeTetrahedron', 6579, *[298, 1319, 454, 453], 1)
    ops.element('FourNodeTetrahedron', 6580, *[1444, 1181, 1593, 630], 1)
    ops.element('FourNodeTetrahedron', 6581, *[1368, 1274, 1288, 665], 1)
    ops.element('FourNodeTetrahedron', 6582, *[1132, 1179, 1398, 1212], 1)
    ops.element('FourNodeTetrahedron', 6583, *[1422, 1656, 1499, 1523], 1)
    ops.element('FourNodeTetrahedron', 6584, *[1713, 1412, 1532, 1618], 1)
    ops.element('FourNodeTetrahedron', 6585, *[758, 1416, 745, 1415], 1)
    ops.element('FourNodeTetrahedron', 6586, *[1314, 1324, 1323, 1712], 1)
    ops.element('FourNodeTetrahedron', 6587, *[1345, 709, 708, 1578], 1)
    ops.element('FourNodeTetrahedron', 6588, *[1615, 1522, 1643, 1648], 1)
    ops.element('FourNodeTetrahedron', 6589, *[1661, 1372, 346, 350], 1)
    ops.element('FourNodeTetrahedron', 6590, *[256, 260, 268, 1321], 1)
    ops.element('FourNodeTetrahedron', 6591, *[269, 1321, 268, 447], 1)
    ops.element('FourNodeTetrahedron', 6592, *[1140, 146, 1270, 1238], 1)
    ops.element('FourNodeTetrahedron', 6593, *[1236, 1235, 1411, 1244], 1)
    ops.element('FourNodeTetrahedron', 6594, *[224, 187, 225, 1277], 1)
    ops.element('FourNodeTetrahedron', 6595, *[741, 1351, 1320, 1192], 1)
    ops.element('FourNodeTetrahedron', 6596, *[1192, 740, 1351, 1142], 1)
    ops.element('FourNodeTetrahedron', 6597, *[1182, 1131, 1564, 1574], 1)
    ops.element('FourNodeTetrahedron', 6598, *[1200, 1136, 1357, 1400], 1)
    ops.element('FourNodeTetrahedron', 6599, *[282, 1718, 1399, 278], 1)
    ops.element('FourNodeTetrahedron', 6600, *[331, 299, 300, 1388], 1)
    ops.element('FourNodeTetrahedron', 6601, *[1187, 1186, 1669, 1122], 1)
    ops.element('FourNodeTetrahedron', 6602, *[1258, 1213, 1452, 1129], 1)
    ops.element('FourNodeTetrahedron', 6603, *[760, 1287, 761, 1352], 1)
    ops.element('FourNodeTetrahedron', 6604, *[1605, 1428, 280, 281], 1)
    ops.element('FourNodeTetrahedron', 6605, *[1360, 1327, 258, 1324], 1)
    ops.element('FourNodeTetrahedron', 6606, *[1547, 739, 1174, 1144], 1)
    ops.element('FourNodeTetrahedron', 6607, *[735, 1199, 732, 1357], 1)
    ops.element('FourNodeTetrahedron', 6608, *[738, 739, 1547, 1144], 1)
    ops.element('FourNodeTetrahedron', 6609, *[1332, 1284, 264, 1276], 1)
    ops.element('FourNodeTetrahedron', 6610, *[770, 760, 761, 1352], 1)
    ops.element('FourNodeTetrahedron', 6611, *[410, 357, 409, 1379], 1)
    ops.element('FourNodeTetrahedron', 6612, *[357, 358, 363, 1379], 1)
    ops.element('FourNodeTetrahedron', 6613, *[1310, 1536, 1353, 1634], 1)
    ops.element('FourNodeTetrahedron', 6614, *[254, 255, 258, 1383], 1)
    ops.element('FourNodeTetrahedron', 6615, *[602, 547, 1505, 546], 1)
    ops.element('FourNodeTetrahedron', 6616, *[602, 1697, 547, 603], 1)
    ops.element('FourNodeTetrahedron', 6617, *[1321, 260, 238, 1313], 1)
    ops.element('FourNodeTetrahedron', 6618, *[443, 1313, 444, 445], 1)
    ops.element('FourNodeTetrahedron', 6619, *[1490, 155, 1510, 1396], 1)
    ops.element('FourNodeTetrahedron', 6620, *[260, 237, 238, 1313], 1)
    ops.element('FourNodeTetrahedron', 6621, *[445, 1313, 444, 446], 1)
    ops.element('FourNodeTetrahedron', 6622, *[488, 1379, 1601, 1520], 1)
    ops.element('FourNodeTetrahedron', 6623, *[767, 1385, 1527, 1312], 1)
    ops.element('FourNodeTetrahedron', 6624, *[1697, 548, 1502, 547], 1)
    ops.element('FourNodeTetrahedron', 6625, *[1648, 1232, 1519, 1688], 1)
    ops.element('FourNodeTetrahedron', 6626, *[284, 1589, 1418, 1342], 1)
    ops.element('FourNodeTetrahedron', 6627, *[547, 1473, 1478, 1283], 1)
    ops.element('FourNodeTetrahedron', 6628, *[1473, 1291, 1283, 535], 1)
    ops.element('FourNodeTetrahedron', 6629, *[1185, 1182, 1395, 1137], 1)
    ops.element('FourNodeTetrahedron', 6630, *[517, 1380, 491, 509], 1)
    ops.element('FourNodeTetrahedron', 6631, *[1489, 1467, 1706, 1696], 1)
    ops.element('FourNodeTetrahedron', 6632, *[297, 1309, 296, 1401], 1)
    ops.element('FourNodeTetrahedron', 6633, *[1600, 1451, 1585, 1627], 1)
    ops.element('FourNodeTetrahedron', 6634, *[1338, 1203, 1475, 1432], 1)
    ops.element('FourNodeTetrahedron', 6635, *[232, 230, 239, 1305], 1)
    ops.element('FourNodeTetrahedron', 6636, *[232, 1559, 230, 1305], 1)
    ops.element('FourNodeTetrahedron', 6637, *[1377, 1461, 1682, 620], 1)
    ops.element('FourNodeTetrahedron', 6638, *[1677, 1340, 375, 1375], 1)
    ops.element('FourNodeTetrahedron', 6639, *[1328, 1514, 232, 1313], 1)
    ops.element('FourNodeTetrahedron', 6640, *[1640, 1731, 1621, 1652], 1)
    ops.element('FourNodeTetrahedron', 6641, *[1639, 1719, 1438, 1510], 1)
    ops.element('FourNodeTetrahedron', 6642, *[1428, 730, 1325, 1302], 1)
    ops.element('FourNodeTetrahedron', 6643, *[1531, 714, 212, 213], 1)
    ops.element('FourNodeTetrahedron', 6644, *[1489, 1706, 1316, 1696], 1)
    ops.element('FourNodeTetrahedron', 6645, *[151, 150, 154, 1280], 1)
    ops.element('FourNodeTetrahedron', 6646, *[1719, 1224, 1438, 1510], 1)
    ops.element('FourNodeTetrahedron', 6647, *[377, 368, 320, 1301], 1)
    ops.element('FourNodeTetrahedron', 6648, *[377, 1301, 320, 473], 1)
    ops.element('FourNodeTetrahedron', 6649, *[1362, 1301, 377, 473], 1)
    ops.element('FourNodeTetrahedron', 6650, *[309, 1670, 314, 1571], 1)
    ops.element('FourNodeTetrahedron', 6651, *[1363, 1350, 217, 1337], 1)
    ops.element('FourNodeTetrahedron', 6652, *[1639, 1719, 1510, 1608], 1)
    ops.element('FourNodeTetrahedron', 6653, *[320, 1739, 1322, 1301], 1)
    ops.element('FourNodeTetrahedron', 6654, *[1653, 1731, 1621, 1640], 1)
    ops.element('FourNodeTetrahedron', 6655, *[517, 1465, 492, 491], 1)
    ops.element('FourNodeTetrahedron', 6656, *[1505, 1623, 1559, 1636], 1)
    ops.element('FourNodeTetrahedron', 6657, *[1639, 1438, 1523, 1513], 1)
    ops.element('FourNodeTetrahedron', 6658, *[473, 1301, 320, 461], 1)
    ops.element('FourNodeTetrahedron', 6659, *[1153, 1207, 1386, 1139], 1)
    ops.element('FourNodeTetrahedron', 6660, *[1489, 1696, 1316, 628], 1)
    ops.element('FourNodeTetrahedron', 6661, *[1316, 1696, 1282, 628], 1)
    ops.element('FourNodeTetrahedron', 6662, *[662, 1294, 661, 655], 1)
    ops.element('FourNodeTetrahedron', 6663, *[1702, 1460, 1494, 674], 1)
    ops.element('FourNodeTetrahedron', 6664, *[1462, 1379, 410, 488], 1)
    ops.element('FourNodeTetrahedron', 6665, *[1297, 1244, 1160, 1168], 1)
    ops.element('FourNodeTetrahedron', 6666, *[1191, 1190, 1490, 1519], 1)
    ops.element('FourNodeTetrahedron', 6667, *[1589, 1480, 1604, 1456], 1)
    ops.element('FourNodeTetrahedron', 6668, *[1466, 1147, 1481, 1127], 1)
    ops.element('FourNodeTetrahedron', 6669, *[1466, 1242, 1147, 1127], 1)
    ops.element('FourNodeTetrahedron', 6670, *[1242, 1311, 1325, 1466], 1)
    ops.element('FourNodeTetrahedron', 6671, *[1423, 1176, 1431, 1398], 1)
    ops.element('FourNodeTetrahedron', 6672, *[1179, 1176, 1423, 1398], 1)
    ops.element('FourNodeTetrahedron', 6673, *[1176, 1175, 1431, 1148], 1)
    ops.element('FourNodeTetrahedron', 6674, *[1367, 1334, 1289, 1715], 1)
    ops.element('FourNodeTetrahedron', 6675, *[1717, 1487, 1441, 1701], 1)
    ops.element('FourNodeTetrahedron', 6676, *[683, 684, 1699, 680], 1)
    ops.element('FourNodeTetrahedron', 6677, *[1226, 1178, 1392, 1341], 1)
    ops.element('FourNodeTetrahedron', 6678, *[1721, 1513, 1674, 1495], 1)
    ops.element('FourNodeTetrahedron', 6679, *[222, 1271, 223, 1412], 1)
    ops.element('FourNodeTetrahedron', 6680, *[229, 222, 223, 1412], 1)
    ops.element('FourNodeTetrahedron', 6681, *[1389, 1423, 1496, 1398], 1)
    ops.element('FourNodeTetrahedron', 6682, *[1483, 1612, 362, 1464], 1)
    ops.element('FourNodeTetrahedron', 6683, *[1728, 1508, 1396, 1556], 1)
    ops.element('FourNodeTetrahedron', 6684, *[1635, 1728, 1549, 1556], 1)
    ops.element('FourNodeTetrahedron', 6685, *[1731, 1646, 1608, 1728], 1)
    ops.element('FourNodeTetrahedron', 6686, *[272, 1391, 242, 273], 1)
    ops.element('FourNodeTetrahedron', 6687, *[626, 1552, 466, 627], 1)
    ops.element('FourNodeTetrahedron', 6688, *[1208, 1214, 1453, 1722], 1)
    ops.element('FourNodeTetrahedron', 6689, *[333, 1308, 353, 334], 1)
    ops.element('FourNodeTetrahedron', 6690, *[1480, 1208, 1453, 1722], 1)
    ops.element('FourNodeTetrahedron', 6691, *[1683, 1475, 1609, 1267], 1)
    ops.element('FourNodeTetrahedron', 6692, *[1154, 1196, 1409, 623], 1)
    ops.element('FourNodeTetrahedron', 6693, *[1225, 1226, 1164, 1595], 1)
    ops.element('FourNodeTetrahedron', 6694, *[1164, 1226, 1582, 1595], 1)
    ops.element('FourNodeTetrahedron', 6695, *[229, 1541, 222, 1412], 1)
    ops.element('FourNodeTetrahedron', 6696, *[271, 720, 719, 1317], 1)
    ops.element('FourNodeTetrahedron', 6697, *[1627, 1561, 678, 681], 1)
    ops.element('FourNodeTetrahedron', 6698, *[320, 1739, 325, 1322], 1)
    ops.element('FourNodeTetrahedron', 6699, *[1437, 1452, 1500, 1509], 1)
    ops.element('FourNodeTetrahedron', 6700, *[1239, 747, 1686, 1169], 1)
    ops.element('FourNodeTetrahedron', 6701, *[1453, 1211, 1406, 1214], 1)
    ops.element('FourNodeTetrahedron', 6702, *[1461, 1504, 1332, 614], 1)
    ops.element('FourNodeTetrahedron', 6703, *[1721, 1674, 161, 157], 1)
    ops.element('FourNodeTetrahedron', 6704, *[1721, 161, 158, 157], 1)
    ops.element('FourNodeTetrahedron', 6705, *[1379, 1446, 1335, 1459], 1)
    ops.element('FourNodeTetrahedron', 6706, *[330, 331, 327, 1405], 1)
    ops.element('FourNodeTetrahedron', 6707, *[547, 1473, 1591, 548], 1)
    ops.element('FourNodeTetrahedron', 6708, *[487, 1278, 479, 480], 1)
    ops.element('FourNodeTetrahedron', 6709, *[440, 1296, 438, 439], 1)
    ops.element('FourNodeTetrahedron', 6710, *[1744, 233, 232, 1371], 1)
    ops.element('FourNodeTetrahedron', 6711, *[515, 771, 770, 1352], 1)
    ops.element('FourNodeTetrahedron', 6712, *[1452, 1579, 1485, 1681], 1)
    ops.element('FourNodeTetrahedron', 6713, *[1382, 1219, 1340, 1121], 1)
    ops.element('FourNodeTetrahedron', 6714, *[463, 1316, 464, 468], 1)
    ops.element('FourNodeTetrahedron', 6715, *[1161, 1192, 1372, 1197], 1)
    ops.element('FourNodeTetrahedron', 6716, *[762, 1303, 763, 1573], 1)
    ops.element('FourNodeTetrahedron', 6717, *[1542, 1331, 1318, 1515], 1)
    ops.element('FourNodeTetrahedron', 6718, *[1544, 1542, 1515, 1498], 1)
    ops.element('FourNodeTetrahedron', 6719, *[1316, 1282, 464, 468], 1)
    ops.element('FourNodeTetrahedron', 6720, *[1366, 1492, 1568, 1436], 1)
    ops.element('FourNodeTetrahedron', 6721, *[1181, 634, 1593, 630], 1)
    ops.element('FourNodeTetrahedron', 6722, *[1512, 1472, 1467, 1593], 1)
    ops.element('FourNodeTetrahedron', 6723, *[1499, 1523, 161, 1513], 1)
    ops.element('FourNodeTetrahedron', 6724, *[1479, 1499, 161, 1513], 1)
    ops.element('FourNodeTetrahedron', 6725, *[1516, 403, 1518, 1497], 1)
    ops.element('FourNodeTetrahedron', 6726, *[1600, 1447, 1592, 1585], 1)
    ops.element('FourNodeTetrahedron', 6727, *[1191, 1190, 1519, 1140], 1)
    ops.element('FourNodeTetrahedron', 6728, *[1657, 735, 1605, 1357], 1)
    ops.element('FourNodeTetrahedron', 6729, *[1290, 1383, 1360, 1535], 1)
    ops.element('FourNodeTetrahedron', 6730, *[1448, 1368, 1627, 681], 1)
    ops.element('FourNodeTetrahedron', 6731, *[1461, 1290, 1332, 1504], 1)
    ops.element('FourNodeTetrahedron', 6732, *[1504, 1535, 1477, 1463], 1)
    ops.element('FourNodeTetrahedron', 6733, *[1344, 1272, 222, 1541], 1)
    ops.element('FourNodeTetrahedron', 6734, *[462, 1322, 463, 1364], 1)
    ops.element('FourNodeTetrahedron', 6735, *[1281, 522, 527, 528], 1)
    ops.element('FourNodeTetrahedron', 6736, *[1617, 1545, 1542, 1544], 1)
    ops.element('FourNodeTetrahedron', 6737, *[1476, 1505, 1514, 602], 1)
    ops.element('FourNodeTetrahedron', 6738, *[1651, 721, 1330, 1325], 1)
    ops.element('FourNodeTetrahedron', 6739, *[656, 1373, 1687, 477], 1)
    ops.element('FourNodeTetrahedron', 6740, *[136, 137, 182, 1269], 1)
    ops.element('FourNodeTetrahedron', 6741, *[1592, 1429, 1677, 1631], 1)
    ops.element('FourNodeTetrahedron', 6742, *[243, 1363, 248, 244], 1)
    ops.element('FourNodeTetrahedron', 6743, *[1283, 1498, 1745, 529], 1)
    ops.element('FourNodeTetrahedron', 6744, *[277, 1565, 273, 278], 1)
    ops.element('FourNodeTetrahedron', 6745, *[1243, 1122, 1660, 1185], 1)
    ops.element('FourNodeTetrahedron', 6746, *[1590, 1193, 1661, 1165], 1)
    ops.element('FourNodeTetrahedron', 6747, *[1262, 1186, 309, 1571], 1)
    ops.element('FourNodeTetrahedron', 6748, *[1462, 1650, 371, 1685], 1)
    ops.element('FourNodeTetrahedron', 6749, *[1388, 1183, 1564, 1182], 1)
    ops.element('FourNodeTetrahedron', 6750, *[1509, 1435, 1500, 1507], 1)
    ops.element('FourNodeTetrahedron', 6751, *[521, 1649, 1702, 677], 1)
    ops.element('FourNodeTetrahedron', 6752, *[1632, 361, 366, 1450], 1)
    ops.element('FourNodeTetrahedron', 6753, *[376, 1392, 355, 332], 1)
    ops.element('FourNodeTetrahedron', 6754, *[1363, 1557, 1359, 1575], 1)
    ops.element('FourNodeTetrahedron', 6755, *[1302, 1173, 1678, 1242], 1)
    ops.element('FourNodeTetrahedron', 6756, *[1272, 1479, 1721, 1588], 1)
    ops.element('FourNodeTetrahedron', 6757, *[533, 1281, 1296, 527], 1)
    ops.element('FourNodeTetrahedron', 6758, *[1325, 726, 721, 1710], 1)
    ops.element('FourNodeTetrahedron', 6759, *[1579, 1690, 1485, 1386], 1)
    ops.element('FourNodeTetrahedron', 6760, *[1462, 1685, 358, 1379], 1)
    ops.element('FourNodeTetrahedron', 6761, *[1467, 625, 1511, 624], 1)
    ops.element('FourNodeTetrahedron', 6762, *[1517, 1516, 402, 1616], 1)
    ops.element('FourNodeTetrahedron', 6763, *[1589, 1208, 1456, 1251], 1)
    ops.element('FourNodeTetrahedron', 6764, *[1516, 403, 402, 1518], 1)
    ops.element('FourNodeTetrahedron', 6765, *[1711, 1535, 1290, 1533], 1)
    ops.element('FourNodeTetrahedron', 6766, *[710, 705, 709, 1346], 1)
    ops.element('FourNodeTetrahedron', 6767, *[710, 704, 1346, 1228], 1)
    ops.element('FourNodeTetrahedron', 6768, *[710, 704, 705, 1346], 1)
    ops.element('FourNodeTetrahedron', 6769, *[727, 717, 726, 1339], 1)
    ops.element('FourNodeTetrahedron', 6770, *[186, 185, 189, 1355], 1)
    ops.element('FourNodeTetrahedron', 6771, *[406, 351, 355, 1392], 1)
    ops.element('FourNodeTetrahedron', 6772, *[189, 185, 188, 1355], 1)
    ops.element('FourNodeTetrahedron', 6773, *[406, 1392, 355, 376], 1)
    ops.element('FourNodeTetrahedron', 6774, *[1124, 1241, 1392, 1226], 1)
    ops.element('FourNodeTetrahedron', 6775, *[277, 1413, 272, 1565], 1)
    ops.element('FourNodeTetrahedron', 6776, *[546, 1478, 1474, 1281], 1)
    ops.element('FourNodeTetrahedron', 6777, *[1226, 1241, 1392, 1178], 1)
    ops.element('FourNodeTetrahedron', 6778, *[1517, 387, 1521, 394], 1)
    ops.element('FourNodeTetrahedron', 6779, *[1312, 1517, 1521, 520], 1)
    ops.element('FourNodeTetrahedron', 6780, *[1355, 188, 189, 432], 1)
    ops.element('FourNodeTetrahedron', 6781, *[1585, 1348, 1288, 1561], 1)
    ops.element('FourNodeTetrahedron', 6782, *[1684, 1449, 1377, 620], 1)
    ops.element('FourNodeTetrahedron', 6783, *[1460, 1426, 1469, 675], 1)
    ops.element('FourNodeTetrahedron', 6784, *[1485, 1690, 391, 1386], 1)
    ops.element('FourNodeTetrahedron', 6785, *[1532, 1269, 183, 1279], 1)
    ops.element('FourNodeTetrahedron', 6786, *[1410, 1247, 1414, 1582], 1)
    ops.element('FourNodeTetrahedron', 6787, *[1410, 1414, 399, 1582], 1)
    ops.element('FourNodeTetrahedron', 6788, *[301, 294, 298, 1319], 1)
    ops.element('FourNodeTetrahedron', 6789, *[298, 294, 302, 1319], 1)
    ops.element('FourNodeTetrahedron', 6790, *[1391, 1583, 1359, 1557], 1)
    ops.element('FourNodeTetrahedron', 6791, *[1611, 1122, 348, 352], 1)
    ops.element('FourNodeTetrahedron', 6792, *[1152, 621, 1472, 634], 1)
    ops.element('FourNodeTetrahedron', 6793, *[1683, 1342, 259, 1581], 1)
    ops.element('FourNodeTetrahedron', 6794, *[706, 703, 170, 1656], 1)
    ops.element('FourNodeTetrahedron', 6795, *[1412, 1271, 1532, 1530], 1)
    ops.element('FourNodeTetrahedron', 6796, *[1382, 1218, 1219, 1121], 1)
    ops.element('FourNodeTetrahedron', 6797, *[355, 1671, 354, 332], 1)
    ops.element('FourNodeTetrahedron', 6798, *[1256, 1218, 1382, 1121], 1)
    ops.element('FourNodeTetrahedron', 6799, *[1643, 1522, 1646, 1648], 1)
    ops.element('FourNodeTetrahedron', 6800, *[1637, 610, 1420, 609], 1)
    ops.element('FourNodeTetrahedron', 6801, *[1598, 1216, 610, 612], 1)
    ops.element('FourNodeTetrahedron', 6802, *[1156, 1216, 1598, 612], 1)
    ops.element('FourNodeTetrahedron', 6803, *[1598, 1216, 1420, 610], 1)
    ops.element('FourNodeTetrahedron', 6804, *[1301, 1552, 461, 1662], 1)
    ops.element('FourNodeTetrahedron', 6805, *[1662, 626, 1552, 465], 1)
    ops.element('FourNodeTetrahedron', 6806, *[1277, 1355, 1665, 433], 1)
    ops.element('FourNodeTetrahedron', 6807, *[1151, 1242, 1302, 1206], 1)
    ops.element('FourNodeTetrahedron', 6808, *[1491, 431, 432, 1468], 1)
    ops.element('FourNodeTetrahedron', 6809, *[1481, 1209, 1210, 1453], 1)
    ops.element('FourNodeTetrahedron', 6810, *[1486, 1216, 1420, 1598], 1)
    ops.element('FourNodeTetrahedron', 6811, *[296, 293, 292, 1378], 1)
    ops.element('FourNodeTetrahedron', 6812, *[368, 1739, 324, 320], 1)
    ops.element('FourNodeTetrahedron', 6813, *[272, 1391, 241, 242], 1)
    ops.element('FourNodeTetrahedron', 6814, *[1515, 416, 420, 421], 1)
    ops.element('FourNodeTetrahedron', 6815, *[1373, 472, 370, 471], 1)
    ops.element('FourNodeTetrahedron', 6816, *[1384, 366, 370, 1373], 1)
    ops.element('FourNodeTetrahedron', 6817, *[241, 1391, 246, 242], 1)
    ops.element('FourNodeTetrahedron', 6818, *[473, 1301, 461, 1662], 1)
    ops.element('FourNodeTetrahedron', 6819, *[725, 716, 715, 1345], 1)
    ops.element('FourNodeTetrahedron', 6820, *[1345, 716, 715, 708], 1)
    ops.element('FourNodeTetrahedron', 6821, *[1345, 716, 708, 709], 1)
    ops.element('FourNodeTetrahedron', 6822, *[1224, 177, 1510, 1149], 1)
    ops.element('FourNodeTetrahedron', 6823, *[1570, 1481, 1723, 1607], 1)
    ops.element('FourNodeTetrahedron', 6824, *[1330, 1260, 1317, 1583], 1)
    ops.element('FourNodeTetrahedron', 6825, *[1636, 1534, 1474, 1478], 1)
    ops.element('FourNodeTetrahedron', 6826, *[1317, 1260, 1349, 1583], 1)
    ops.element('FourNodeTetrahedron', 6827, *[1154, 1196, 1487, 1409], 1)
    ops.element('FourNodeTetrahedron', 6828, *[1154, 1138, 1487, 1196], 1)
    ops.element('FourNodeTetrahedron', 6829, *[733, 731, 1307, 1151], 1)
    ops.element('FourNodeTetrahedron', 6830, *[333, 1308, 334, 1667], 1)
    ops.element('FourNodeTetrahedron', 6831, *[233, 229, 232, 1371], 1)
    ops.element('FourNodeTetrahedron', 6832, *[1670, 1188, 1233, 1394], 1)
    ops.element('FourNodeTetrahedron', 6833, *[1356, 1479, 162, 158], 1)
    ops.element('FourNodeTetrahedron', 6834, *[1691, 417, 422, 524], 1)
    ops.element('FourNodeTetrahedron', 6835, *[1303, 389, 395, 1516], 1)
    ops.element('FourNodeTetrahedron', 6836, *[1516, 396, 395, 402], 1)
    ops.element('FourNodeTetrahedron', 6837, *[1355, 1358, 188, 432], 1)
    ops.element('FourNodeTetrahedron', 6838, *[1712, 1537, 1323, 1476], 1)
    ops.element('FourNodeTetrahedron', 6839, *[1271, 179, 180, 1269], 1)
    ops.element('FourNodeTetrahedron', 6840, *[1532, 1279, 1742, 1273], 1)
    ops.element('FourNodeTetrahedron', 6841, *[325, 1403, 326, 1322], 1)
    ops.element('FourNodeTetrahedron', 6842, *[760, 758, 757, 1287], 1)
    ops.element('FourNodeTetrahedron', 6843, *[1339, 710, 709, 1703], 1)
    ops.element('FourNodeTetrahedron', 6844, *[1694, 662, 661, 672], 1)
    ops.element('FourNodeTetrahedron', 6845, *[179, 136, 182, 1269], 1)
    ops.element('FourNodeTetrahedron', 6846, *[308, 1670, 314, 309], 1)
    ops.element('FourNodeTetrahedron', 6847, *[1505, 1502, 1591, 547], 1)
    ops.element('FourNodeTetrahedron', 6848, *[1510, 159, 156, 155], 1)
    ops.element('FourNodeTetrahedron', 6849, *[256, 261, 260, 1328], 1)
    ops.element('FourNodeTetrahedron', 6850, *[1504, 608, 1695, 607], 1)
    ops.element('FourNodeTetrahedron', 6851, *[1517, 395, 388, 394], 1)
    ops.element('FourNodeTetrahedron', 6852, *[1447, 1429, 1592, 1442], 1)
    ops.element('FourNodeTetrahedron', 6853, *[1497, 1429, 1592, 1447], 1)
    ops.element('FourNodeTetrahedron', 6854, *[376, 1392, 332, 1341], 1)
    ops.element('FourNodeTetrahedron', 6855, *[1481, 1210, 1703, 1439], 1)
    ops.element('FourNodeTetrahedron', 6856, *[1569, 1397, 1387, 1629], 1)
    ops.element('FourNodeTetrahedron', 6857, *[1511, 1487, 1717, 1701], 1)
    ops.element('FourNodeTetrahedron', 6858, *[521, 1158, 1734, 511], 1)
    ops.element('FourNodeTetrahedron', 6859, *[1514, 1305, 232, 1313], 1)
    ops.element('FourNodeTetrahedron', 6860, *[1612, 1341, 332, 1423], 1)
    ops.element('FourNodeTetrahedron', 6861, *[1545, 1580, 1542, 1498], 1)
    ops.element('FourNodeTetrahedron', 6862, *[1328, 1744, 232, 1514], 1)
    ops.element('FourNodeTetrahedron', 6863, *[1236, 1244, 1411, 1297], 1)
    ops.element('FourNodeTetrahedron', 6864, *[1492, 1457, 1301, 649], 1)
    ops.element('FourNodeTetrahedron', 6865, *[259, 1419, 279, 263], 1)
    ops.element('FourNodeTetrahedron', 6866, *[1334, 1343, 1711, 1554], 1)
    ops.element('FourNodeTetrahedron', 6867, *[1593, 1152, 1472, 634], 1)
    ops.element('FourNodeTetrahedron', 6868, *[1208, 1214, 1722, 1204], 1)
    ops.element('FourNodeTetrahedron', 6869, *[1600, 1421, 1425, 1550], 1)
    ops.element('FourNodeTetrahedron', 6870, *[1177, 1137, 1716, 1176], 1)
    ops.element('FourNodeTetrahedron', 6871, *[1396, 148, 149, 1275], 1)
    ops.element('FourNodeTetrahedron', 6872, *[1722, 1214, 1454, 1130], 1)
    ops.element('FourNodeTetrahedron', 6873, *[1134, 1258, 1437, 1246], 1)
    ops.element('FourNodeTetrahedron', 6874, *[1526, 1134, 1437, 1246], 1)
    ops.element('FourNodeTetrahedron', 6875, *[1134, 1169, 1437, 1258], 1)
    ops.element('FourNodeTetrahedron', 6876, *[232, 1559, 1305, 1514], 1)
    ops.element('FourNodeTetrahedron', 6877, *[352, 1571, 299, 335], 1)
    ops.element('FourNodeTetrahedron', 6878, *[273, 1363, 242, 243], 1)
    ops.element('FourNodeTetrahedron', 6879, *[1204, 1214, 1722, 1130], 1)
    ops.element('FourNodeTetrahedron', 6880, *[1214, 1454, 1453, 1722], 1)
    ops.element('FourNodeTetrahedron', 6881, *[1613, 1497, 373, 1425], 1)
    ops.element('FourNodeTetrahedron', 6882, *[1518, 1497, 373, 1613], 1)
    ops.element('FourNodeTetrahedron', 6883, *[240, 1531, 245, 246], 1)
    ops.element('FourNodeTetrahedron', 6884, *[1383, 1584, 1620, 1535], 1)
    ops.element('FourNodeTetrahedron', 6885, *[1652, 1567, 1619, 1473], 1)
    ops.element('FourNodeTetrahedron', 6886, *[1228, 704, 1346, 1599], 1)
    ops.element('FourNodeTetrahedron', 6887, *[1545, 1542, 1544, 1498], 1)
    ops.element('FourNodeTetrahedron', 6888, *[184, 1742, 183, 187], 1)
    ops.element('FourNodeTetrahedron', 6889, *[652, 1212, 1365, 653], 1)
    ops.element('FourNodeTetrahedron', 6890, *[282, 1399, 277, 278], 1)
    ops.element('FourNodeTetrahedron', 6891, *[758, 748, 745, 1416], 1)
    ops.element('FourNodeTetrahedron', 6892, *[1169, 748, 1416, 1213], 1)
    ops.element('FourNodeTetrahedron', 6893, *[1410, 1582, 405, 1340], 1)
    ops.element('FourNodeTetrahedron', 6894, *[1278, 474, 480, 660], 1)
    ops.element('FourNodeTetrahedron', 6895, *[1129, 1153, 1681, 1217], 1)
    ops.element('FourNodeTetrahedron', 6896, *[1480, 1453, 1604, 1722], 1)
    ops.element('FourNodeTetrahedron', 6897, *[259, 263, 262, 1327], 1)
    ops.element('FourNodeTetrahedron', 6898, *[1242, 723, 1311, 1147], 1)
    ops.element('FourNodeTetrahedron', 6899, *[1466, 1127, 1481, 1480], 1)
    ops.element('FourNodeTetrahedron', 6900, *[519, 1518, 517, 1614], 1)
    ops.element('FourNodeTetrahedron', 6901, *[512, 1150, 1493, 1229], 1)
    ops.element('FourNodeTetrahedron', 6902, *[1130, 1719, 1646, 1191], 1)
    ops.element('FourNodeTetrahedron', 6903, *[1206, 1466, 1718, 1202], 1)
    ops.element('FourNodeTetrahedron', 6904, *[1206, 1127, 1466, 1202], 1)
    ops.element('FourNodeTetrahedron', 6905, *[1617, 1545, 1544, 1283], 1)
    ops.element('FourNodeTetrahedron', 6906, *[1585, 1442, 1421, 1543], 1)
    ops.element('FourNodeTetrahedron', 6907, *[1420, 1216, 606, 610], 1)
    ops.element('FourNodeTetrahedron', 6908, *[1420, 606, 605, 610], 1)
    ops.element('FourNodeTetrahedron', 6909, *[1398, 629, 1457, 648], 1)
    ops.element('FourNodeTetrahedron', 6910, *[1557, 1607, 1730, 1575], 1)
    ops.element('FourNodeTetrahedron', 6911, *[710, 1228, 1346, 1439], 1)
    ops.element('FourNodeTetrahedron', 6912, *[703, 702, 168, 1402], 1)
    ops.element('FourNodeTetrahedron', 6913, *[236, 233, 1744, 1537], 1)
    ops.element('FourNodeTetrahedron', 6914, *[703, 168, 169, 1402], 1)
    ops.element('FourNodeTetrahedron', 6915, *[367, 1464, 368, 1362], 1)
    ops.element('FourNodeTetrahedron', 6916, *[617, 1409, 619, 616], 1)
    ops.element('FourNodeTetrahedron', 6917, *[1217, 1139, 1386, 1410], 1)
    ops.element('FourNodeTetrahedron', 6918, *[684, 665, 1368, 681], 1)
    ops.element('FourNodeTetrahedron', 6919, *[236, 1310, 235, 1353], 1)
    ops.element('FourNodeTetrahedron', 6920, *[354, 1606, 353, 1308], 1)
    ops.element('FourNodeTetrahedron', 6921, *[608, 609, 1693, 604], 1)
    ops.element('FourNodeTetrahedron', 6922, *[257, 1324, 261, 1323], 1)
    ops.element('FourNodeTetrahedron', 6923, *[1290, 1535, 1504, 1463], 1)
    ops.element('FourNodeTetrahedron', 6924, *[1295, 1455, 1266, 657], 1)
    ops.element('FourNodeTetrahedron', 6925, *[1314, 1562, 1324, 1712], 1)
    ops.element('FourNodeTetrahedron', 6926, *[1129, 1217, 1435, 1218], 1)
    ops.element('FourNodeTetrahedron', 6927, *[1532, 183, 1742, 1279], 1)
    ops.element('FourNodeTetrahedron', 6928, *[1712, 1562, 1324, 1484], 1)
    ops.element('FourNodeTetrahedron', 6929, *[1442, 1223, 1375, 1411], 1)
    ops.element('FourNodeTetrahedron', 6930, *[285, 732, 280, 1605], 1)
    ops.element('FourNodeTetrahedron', 6931, *[255, 1342, 284, 259], 1)
    ops.element('FourNodeTetrahedron', 6932, *[294, 295, 1367, 1408], 1)
    ops.element('FourNodeTetrahedron', 6933, *[295, 292, 291, 1367], 1)
    ops.element('FourNodeTetrahedron', 6934, *[1375, 1234, 1390, 1235], 1)
    ops.element('FourNodeTetrahedron', 6935, *[1223, 1235, 1375, 1411], 1)
    ops.element('FourNodeTetrahedron', 6936, *[1617, 1542, 1538, 1544], 1)
    ops.element('FourNodeTetrahedron', 6937, *[1352, 1134, 1287, 1526], 1)
    ops.element('FourNodeTetrahedron', 6938, *[1280, 150, 154, 141], 1)
    ops.element('FourNodeTetrahedron', 6939, *[1435, 1410, 1681, 404], 1)
    ops.element('FourNodeTetrahedron', 6940, *[296, 1378, 295, 1558], 1)
    ops.element('FourNodeTetrahedron', 6941, *[1645, 1454, 1639, 1608], 1)
    ops.element('FourNodeTetrahedron', 6942, *[1620, 1581, 1642, 1610], 1)
    ops.element('FourNodeTetrahedron', 6943, *[1707, 1597, 1520, 668], 1)
    ops.element('FourNodeTetrahedron', 6944, *[307, 1361, 312, 1458], 1)
    ops.element('FourNodeTetrahedron', 6945, *[327, 331, 301, 1336], 1)
    ops.element('FourNodeTetrahedron', 6946, *[1619, 1556, 1549, 1626], 1)
    ops.element('FourNodeTetrahedron', 6947, *[272, 1413, 1317, 1391], 1)
    ops.element('FourNodeTetrahedron', 6948, *[1402, 163, 164, 1523], 1)
    ops.element('FourNodeTetrahedron', 6949, *[483, 1465, 407, 489], 1)
    ops.element('FourNodeTetrahedron', 6950, *[447, 1563, 443, 445], 1)
    ops.element('FourNodeTetrahedron', 6951, *[448, 1321, 269, 447], 1)
    ops.element('FourNodeTetrahedron', 6952, *[268, 260, 238, 1321], 1)
    ops.element('FourNodeTetrahedron', 6953, *[1162, 1590, 1668, 1414], 1)
    ops.element('FourNodeTetrahedron', 6954, *[1417, 1357, 316, 287], 1)
    ops.element('FourNodeTetrahedron', 6955, *[312, 1417, 316, 317], 1)
    ops.element('FourNodeTetrahedron', 6956, *[1144, 1174, 1417, 1200], 1)
    ops.element('FourNodeTetrahedron', 6957, *[1476, 1484, 602, 607], 1)
    ops.element('FourNodeTetrahedron', 6958, *[1389, 1248, 1179, 1132], 1)
    ops.element('FourNodeTetrahedron', 6959, *[1235, 1248, 1389, 1132], 1)
    ops.element('FourNodeTetrahedron', 6960, *[1498, 523, 1515, 522], 1)
    ops.element('FourNodeTetrahedron', 6961, *[522, 523, 1515, 420], 1)
    ops.element('FourNodeTetrahedron', 6962, *[670, 1494, 1380, 509], 1)
    ops.element('FourNodeTetrahedron', 6963, *[332, 329, 328, 1381], 1)
    ops.element('FourNodeTetrahedron', 6964, *[1516, 396, 402, 403], 1)
    ops.element('FourNodeTetrahedron', 6965, *[1612, 1423, 328, 1496], 1)
    ops.element('FourNodeTetrahedron', 6966, *[1547, 1657, 316, 1357], 1)
    ops.element('FourNodeTetrahedron', 6967, *[1547, 735, 1657, 1357], 1)
    ops.element('FourNodeTetrahedron', 6968, *[1655, 1643, 1640, 1506], 1)
    ops.element('FourNodeTetrahedron', 6969, *[673, 1494, 670, 671], 1)
    ops.element('FourNodeTetrahedron', 6970, *[1228, 1141, 1599, 1406], 1)
    ops.element('FourNodeTetrahedron', 6971, *[1302, 1242, 1466, 1206], 1)
    ops.element('FourNodeTetrahedron', 6972, *[1388, 1574, 1336, 1512], 1)
    ops.element('FourNodeTetrahedron', 6973, *[229, 1541, 1412, 1374], 1)
    ops.element('FourNodeTetrahedron', 6974, *[1402, 702, 1743, 1157], 1)
    ops.element('FourNodeTetrahedron', 6975, *[1395, 1388, 331, 1405], 1)
    ops.element('FourNodeTetrahedron', 6976, *[1450, 1483, 1464, 1455], 1)
    ops.element('FourNodeTetrahedron', 6977, *[1727, 1557, 1443, 1604], 1)
    ops.element('FourNodeTetrahedron', 6978, *[1418, 1727, 1443, 1604], 1)
    ops.element('FourNodeTetrahedron', 6979, *[1445, 366, 1384, 1373], 1)
    ops.element('FourNodeTetrahedron', 6980, *[1348, 1297, 1288, 1274], 1)
    ops.element('FourNodeTetrahedron', 6981, *[491, 1462, 489, 1520], 1)
    ops.element('FourNodeTetrahedron', 6982, *[1610, 1655, 1642, 1506], 1)
    ops.element('FourNodeTetrahedron', 6983, *[1610, 1643, 1655, 1506], 1)
    ops.element('FourNodeTetrahedron', 6984, *[1633, 1330, 1413, 1570], 1)
    ops.element('FourNodeTetrahedron', 6985, *[1258, 1129, 1509, 1221], 1)
    ops.element('FourNodeTetrahedron', 6986, *[1139, 1163, 1414, 1247], 1)
    ops.element('FourNodeTetrahedron', 6987, *[1139, 1247, 1414, 1410], 1)
    ops.element('FourNodeTetrahedron', 6988, *[626, 1572, 627, 629], 1)
    ops.element('FourNodeTetrahedron', 6989, *[1552, 462, 466, 465], 1)
    ops.element('FourNodeTetrahedron', 6990, *[1230, 1200, 1726, 1189], 1)
    ops.element('FourNodeTetrahedron', 6991, *[1605, 732, 280, 1428], 1)
    ops.element('FourNodeTetrahedron', 6992, *[1605, 1307, 732, 1302], 1)
    ops.element('FourNodeTetrahedron', 6993, *[1421, 1631, 361, 1483], 1)
    ops.element('FourNodeTetrahedron', 6994, *[1192, 1142, 1351, 1197], 1)
    ops.element('FourNodeTetrahedron', 6995, *[269, 1539, 1321, 448], 1)
    ops.element('FourNodeTetrahedron', 6996, *[1167, 1145, 1274, 1254], 1)
    ops.element('FourNodeTetrahedron', 6997, *[1257, 1145, 1348, 1274], 1)
    ops.element('FourNodeTetrahedron', 6998, *[1257, 1145, 1274, 1167], 1)
    ops.element('FourNodeTetrahedron', 6999, *[1578, 1346, 709, 1439], 1)
    ops.element('FourNodeTetrahedron', 7000, *[1578, 709, 708, 1422], 1)
    ops.element('FourNodeTetrahedron', 7001, *[1639, 1438, 1513, 1510], 1)
    ops.element('FourNodeTetrahedron', 7002, *[1331, 140, 415, 416], 1)
    ops.element('FourNodeTetrahedron', 7003, *[1480, 1453, 1607, 1604], 1)
    ops.element('FourNodeTetrahedron', 7004, *[1210, 1211, 1439, 1453], 1)
    ops.element('FourNodeTetrahedron', 7005, *[1209, 1211, 1210, 1453], 1)
    ops.element('FourNodeTetrahedron', 7006, *[1741, 1245, 1606, 1241], 1)
    ops.element('FourNodeTetrahedron', 7007, *[1382, 1121, 1340, 1375], 1)
    ops.element('FourNodeTetrahedron', 7008, *[1182, 1194, 1574, 1152], 1)
    ops.element('FourNodeTetrahedron', 7009, *[1512, 1182, 1574, 1152], 1)
    ops.element('FourNodeTetrahedron', 7010, *[1409, 611, 1598, 616], 1)
    ops.element('FourNodeTetrahedron', 7011, *[1441, 1598, 1637, 616], 1)
    ops.element('FourNodeTetrahedron', 7012, *[1487, 1433, 1441, 1409], 1)
    ops.element('FourNodeTetrahedron', 7013, *[1487, 1196, 1433, 1409], 1)
    ops.element('FourNodeTetrahedron', 7014, *[1487, 1138, 1433, 1196], 1)
    ops.element('FourNodeTetrahedron', 7015, *[618, 1692, 620, 619], 1)
    ops.element('FourNodeTetrahedron', 7016, *[1701, 1441, 1449, 1692], 1)
    ops.element('FourNodeTetrahedron', 7017, *[1701, 1409, 1441, 619], 1)
    ops.element('FourNodeTetrahedron', 7018, *[1701, 1692, 1449, 618], 1)
    ops.element('FourNodeTetrahedron', 7019, *[1365, 653, 648, 652], 1)
    ops.element('FourNodeTetrahedron', 7020, *[645, 1365, 1492, 648], 1)
    ops.element('FourNodeTetrahedron', 7021, *[326, 1405, 327, 1679], 1)
    ops.element('FourNodeTetrahedron', 7022, *[1426, 1424, 1550, 1295], 1)
    ops.element('FourNodeTetrahedron', 7023, *[1648, 1232, 1688, 550], 1)
    ops.element('FourNodeTetrahedron', 7024, *[645, 1365, 648, 652], 1)
    ops.element('FourNodeTetrahedron', 7025, *[769, 761, 762, 1738], 1)
    ops.element('FourNodeTetrahedron', 7026, *[645, 1160, 1365, 652], 1)
    ops.element('FourNodeTetrahedron', 7027, *[645, 1160, 652, 651], 1)
    ops.element('FourNodeTetrahedron', 7028, *[395, 389, 396, 1516], 1)
    ops.element('FourNodeTetrahedron', 7029, *[1517, 1516, 395, 402], 1)
    ops.element('FourNodeTetrahedron', 7030, *[1517, 1303, 395, 1516], 1)
    ops.element('FourNodeTetrahedron', 7031, *[549, 1291, 548, 536], 1)
    ops.element('FourNodeTetrahedron', 7032, *[516, 768, 1385, 1573], 1)
    ops.element('FourNodeTetrahedron', 7033, *[666, 1254, 1259, 650], 1)
    ops.element('FourNodeTetrahedron', 7034, *[710, 1346, 709, 1439], 1)
    ops.element('FourNodeTetrahedron', 7035, *[760, 757, 761, 1287], 1)
    ops.element('FourNodeTetrahedron', 7036, *[1436, 645, 1492, 647], 1)
    ops.element('FourNodeTetrahedron', 7037, *[1517, 388, 387, 394], 1)
    ops.element('FourNodeTetrahedron', 7038, *[1385, 1286, 754, 388], 1)
    ops.element('FourNodeTetrahedron', 7039, *[1488, 524, 523, 530], 1)
    ops.element('FourNodeTetrahedron', 7040, *[1184, 1240, 1309, 1195], 1)
    ops.element('FourNodeTetrahedron', 7041, *[304, 1332, 264, 1276], 1)
    ops.element('FourNodeTetrahedron', 7042, *[1415, 745, 744, 1485], 1)
    ops.element('FourNodeTetrahedron', 7043, *[516, 1385, 767, 1312], 1)
    ops.element('FourNodeTetrahedron', 7044, *[1503, 1596, 1506, 549], 1)
    ops.element('FourNodeTetrahedron', 7045, *[516, 768, 767, 1385], 1)
    ops.element('FourNodeTetrahedron', 7046, *[768, 763, 767, 1385], 1)
    ops.element('FourNodeTetrahedron', 7047, *[767, 763, 764, 1385], 1)
    ops.element('FourNodeTetrahedron', 7048, *[1460, 1424, 1426, 678], 1)
    ops.element('FourNodeTetrahedron', 7049, *[1628, 1280, 1326, 1542], 1)
    ops.element('FourNodeTetrahedron', 7050, *[1724, 1445, 1501, 1720], 1)
    ops.element('FourNodeTetrahedron', 7051, *[251, 1338, 255, 1343], 1)
    ops.element('FourNodeTetrahedron', 7052, *[1560, 1553, 1344, 1588], 1)
    ops.element('FourNodeTetrahedron', 7053, *[1294, 1384, 1663, 1687], 1)
    ops.element('FourNodeTetrahedron', 7054, *[1644, 1722, 1645, 1522], 1)
    ops.element('FourNodeTetrahedron', 7055, *[1208, 1722, 1456, 1204], 1)
    ops.element('FourNodeTetrahedron', 7056, *[1452, 1129, 1681, 1435], 1)
    ops.element('FourNodeTetrahedron', 7057, *[1511, 1701, 618, 617], 1)
    ops.element('FourNodeTetrahedron', 7058, *[617, 619, 1701, 618], 1)
    ops.element('FourNodeTetrahedron', 7059, *[1701, 1409, 619, 617], 1)
    ops.element('FourNodeTetrahedron', 7060, *[1578, 1346, 1422, 1586], 1)
    ops.element('FourNodeTetrahedron', 7061, *[1539, 1712, 1476, 1299], 1)
    ops.element('FourNodeTetrahedron', 7062, *[1505, 1591, 1636, 546], 1)
    ops.element('FourNodeTetrahedron', 7063, *[1427, 1249, 1625, 525], 1)
    ops.element('FourNodeTetrahedron', 7064, *[512, 1229, 1493, 521], 1)
    ops.element('FourNodeTetrahedron', 7065, *[1229, 1146, 1493, 1448], 1)
    ops.element('FourNodeTetrahedron', 7066, *[521, 1229, 1448, 1158], 1)
    ops.element('FourNodeTetrahedron', 7067, *[521, 1229, 1493, 1448], 1)
    ops.element('FourNodeTetrahedron', 7068, *[1406, 1599, 1523, 1438], 1)
    ops.element('FourNodeTetrahedron', 7069, *[737, 738, 305, 1304], 1)
    ops.element('FourNodeTetrahedron', 7070, *[1652, 1635, 1619, 1567], 1)
    ops.element('FourNodeTetrahedron', 7071, *[327, 331, 1336, 1405], 1)
    ops.element('FourNodeTetrahedron', 7072, *[1573, 1300, 1303, 1516], 1)
    ops.element('FourNodeTetrahedron', 7073, *[1672, 1656, 171, 165], 1)
    ops.element('FourNodeTetrahedron', 7074, *[723, 728, 727, 1264], 1)
    ops.element('FourNodeTetrahedron', 7075, *[1276, 1712, 1539, 1299], 1)
    ops.element('FourNodeTetrahedron', 7076, *[737, 738, 1304, 1171], 1)
    ops.element('FourNodeTetrahedron', 7077, *[1567, 1626, 1545, 1488], 1)
    ops.element('FourNodeTetrahedron', 7078, *[241, 1531, 240, 246], 1)
    ops.element('FourNodeTetrahedron', 7079, *[324, 1329, 325, 1739], 1)
    ops.element('FourNodeTetrahedron', 7080, *[1437, 1416, 1415, 1452], 1)
    ops.element('FourNodeTetrahedron', 7081, *[1437, 1452, 1415, 1500], 1)
    ops.element('FourNodeTetrahedron', 7082, *[1410, 1582, 399, 405], 1)
    ops.element('FourNodeTetrahedron', 7083, *[670, 1380, 667, 509], 1)
    ops.element('FourNodeTetrahedron', 7084, *[263, 1285, 1310, 1327], 1)
    ops.element('FourNodeTetrahedron', 7085, *[463, 628, 1316, 468], 1)
    ops.element('FourNodeTetrahedron', 7086, *[222, 1271, 181, 223], 1)
    ops.element('FourNodeTetrahedron', 7087, *[1739, 1329, 325, 1322], 1)
    ops.element('FourNodeTetrahedron', 7088, *[1454, 1639, 1587, 1645], 1)
    ops.element('FourNodeTetrahedron', 7089, *[1630, 1454, 1587, 1645], 1)
    ops.element('FourNodeTetrahedron', 7090, *[1190, 178, 155, 147], 1)
    ops.element('FourNodeTetrahedron', 7091, *[1490, 155, 1396, 1482], 1)
    ops.element('FourNodeTetrahedron', 7092, *[1427, 525, 1576, 531], 1)
    ops.element('FourNodeTetrahedron', 7093, *[1590, 1658, 343, 1661], 1)
    ops.element('FourNodeTetrahedron', 7094, *[681, 665, 1561, 664], 1)
    ops.element('FourNodeTetrahedron', 7095, *[1402, 175, 168, 163], 1)
    ops.element('FourNodeTetrahedron', 7096, *[1443, 1575, 1363, 1337], 1)
    ops.element('FourNodeTetrahedron', 7097, *[761, 756, 762, 1300], 1)
    ops.element('FourNodeTetrahedron', 7098, *[1638, 1486, 1584, 1637], 1)
    ops.element('FourNodeTetrahedron', 7099, *[1683, 1338, 1432, 1343], 1)
    ops.element('FourNodeTetrahedron', 7100, *[1615, 1204, 1522, 1215], 1)
    ops.element('FourNodeTetrahedron', 7101, *[1135, 1204, 1615, 1215], 1)
    ops.element('FourNodeTetrahedron', 7102, *[733, 1307, 732, 1199], 1)
    ops.element('FourNodeTetrahedron', 7103, *[1241, 1308, 1606, 1671], 1)
    ops.element('FourNodeTetrahedron', 7104, *[1289, 1290, 1332, 1461], 1)
    ops.element('FourNodeTetrahedron', 7105, *[1137, 1152, 1512, 1181], 1)
    ops.element('FourNodeTetrahedron', 7106, *[1568, 1389, 1496, 1398], 1)
    ops.element('FourNodeTetrahedron', 7107, *[329, 1714, 330, 326], 1)
    ops.element('FourNodeTetrahedron', 7108, *[1570, 1311, 1339, 1481], 1)
    ops.element('FourNodeTetrahedron', 7109, *[1403, 1714, 326, 1679], 1)
    ops.element('FourNodeTetrahedron', 7110, *[1311, 1147, 1481, 1466], 1)
    ops.element('FourNodeTetrahedron', 7111, *[1582, 1124, 1392, 1226], 1)
    ops.element('FourNodeTetrahedron', 7112, *[1689, 1459, 1335, 1278], 1)
    ops.element('FourNodeTetrahedron', 7113, *[171, 1656, 170, 165], 1)
    ops.element('FourNodeTetrahedron', 7114, *[678, 681, 1561, 664], 1)
    ops.element('FourNodeTetrahedron', 7115, *[220, 1541, 229, 1374], 1)
    ops.element('FourNodeTetrahedron', 7116, *[1315, 1225, 1595, 1180], 1)
    ops.element('FourNodeTetrahedron', 7117, *[1363, 1337, 248, 244], 1)
    ops.element('FourNodeTetrahedron', 7118, *[1375, 1390, 1631, 1411], 1)
    ops.element('FourNodeTetrahedron', 7119, *[1366, 1389, 1568, 1398], 1)
    ops.element('FourNodeTetrahedron', 7120, *[246, 1349, 213, 1333], 1)
    ops.element('FourNodeTetrahedron', 7121, *[1568, 1492, 1464, 1436], 1)
    ops.element('FourNodeTetrahedron', 7122, *[1349, 707, 213, 1333], 1)
    ops.element('FourNodeTetrahedron', 7123, *[1349, 714, 213, 707], 1)
    ops.element('FourNodeTetrahedron', 7124, *[1349, 715, 714, 707], 1)
    ops.element('FourNodeTetrahedron', 7125, *[1349, 708, 707, 1333], 1)
    ops.element('FourNodeTetrahedron', 7126, *[1708, 1171, 1304, 1361], 1)
    ops.element('FourNodeTetrahedron', 7127, *[1191, 1149, 1490, 1190], 1)
    ops.element('FourNodeTetrahedron', 7128, *[1281, 1544, 1468, 522], 1)
    ops.element('FourNodeTetrahedron', 7129, *[1388, 299, 300, 1401], 1)
    ops.element('FourNodeTetrahedron', 7130, *[299, 296, 300, 1401], 1)
    ops.element('FourNodeTetrahedron', 7131, *[1544, 1491, 1468, 522], 1)
    ops.element('FourNodeTetrahedron', 7132, *[1270, 419, 418, 1238], 1)
    ops.element('FourNodeTetrahedron', 7133, *[1544, 1491, 1555, 1468], 1)
    ops.element('FourNodeTetrahedron', 7134, *[1270, 146, 419, 1238], 1)
    ops.element('FourNodeTetrahedron', 7135, *[1372, 341, 345, 344], 1)
    ops.element('FourNodeTetrahedron', 7136, *[1724, 1425, 1501, 1445], 1)
    ops.element('FourNodeTetrahedron', 7137, *[615, 608, 1463, 614], 1)
    ops.element('FourNodeTetrahedron', 7138, *[1295, 1266, 1373, 656], 1)
    ops.element('FourNodeTetrahedron', 7139, *[367, 1464, 1362, 1455], 1)
    ops.element('FourNodeTetrahedron', 7140, *[234, 1310, 235, 236], 1)
    ops.element('FourNodeTetrahedron', 7141, *[1538, 1491, 1555, 1544], 1)
    ops.element('FourNodeTetrahedron', 7142, *[1632, 1421, 361, 1450], 1)
    ops.element('FourNodeTetrahedron', 7143, *[236, 235, 233, 1353], 1)
    ops.element('FourNodeTetrahedron', 7144, *[1686, 1169, 1416, 1287], 1)
    ops.element('FourNodeTetrahedron', 7145, *[1613, 1594, 1724, 1649], 1)
    ops.element('FourNodeTetrahedron', 7146, *[1327, 1642, 1310, 1634], 1)
    ops.element('FourNodeTetrahedron', 7147, *[1585, 1442, 1543, 1348], 1)
    ops.element('FourNodeTetrahedron', 7148, *[1649, 1613, 1724, 1494], 1)
    ops.element('FourNodeTetrahedron', 7149, *[614, 1463, 1504, 608], 1)
    ops.element('FourNodeTetrahedron', 7150, *[1494, 1649, 1724, 1460], 1)
    ops.element('FourNodeTetrahedron', 7151, *[1337, 1350, 217, 219], 1)
    ops.element('FourNodeTetrahedron', 7152, *[1531, 212, 245, 246], 1)
    ops.element('FourNodeTetrahedron', 7153, *[1622, 1728, 1549, 1635], 1)
    ops.element('FourNodeTetrahedron', 7154, *[1389, 1179, 1423, 1398], 1)
    ops.element('FourNodeTetrahedron', 7155, *[1398, 1176, 1431, 1148], 1)
    ops.element('FourNodeTetrahedron', 7156, *[1179, 1176, 1398, 1148], 1)
    ops.element('FourNodeTetrahedron', 7157, *[1179, 1148, 1398, 1212], 1)
    ops.element('FourNodeTetrahedron', 7158, *[1132, 1179, 1389, 1398], 1)
    ops.element('FourNodeTetrahedron', 7159, *[256, 1323, 1328, 1321], 1)
    ops.element('FourNodeTetrahedron', 7160, *[1575, 1553, 1350, 1337], 1)
    ops.element('FourNodeTetrahedron', 7161, *[771, 1159, 760, 1352], 1)
    ops.element('FourNodeTetrahedron', 7162, *[1711, 1638, 1584, 1533], 1)
    ops.element('FourNodeTetrahedron', 7163, *[1190, 1482, 1508, 1270], 1)
    ops.element('FourNodeTetrahedron', 7164, *[1193, 1372, 1661, 1133], 1)
    ops.element('FourNodeTetrahedron', 7165, *[1324, 1353, 1537, 1634], 1)
    ops.element('FourNodeTetrahedron', 7166, *[678, 1424, 1426, 663], 1)
    ops.element('FourNodeTetrahedron', 7167, *[1203, 1251, 1589, 1475], 1)
    ops.element('FourNodeTetrahedron', 7168, *[1123, 1589, 1338, 1203], 1)
    ops.element('FourNodeTetrahedron', 7169, *[534, 1283, 1281, 528], 1)
    ops.element('FourNodeTetrahedron', 7170, *[351, 1606, 354, 355], 1)
    ops.element('FourNodeTetrahedron', 7171, *[1462, 358, 357, 1379], 1)
    ops.element('FourNodeTetrahedron', 7172, *[720, 725, 1260, 1330], 1)
    ops.element('FourNodeTetrahedron', 7173, *[1394, 1404, 319, 1306], 1)
    ops.element('FourNodeTetrahedron', 7174, *[615, 1693, 1463, 608], 1)
    ops.element('FourNodeTetrahedron', 7175, *[1424, 1292, 663, 664], 1)
    ops.element('FourNodeTetrahedron', 7176, *[1528, 1650, 1462, 1380], 1)
    ops.element('FourNodeTetrahedron', 7177, *[1497, 1507, 1677, 1429], 1)
    ops.element('FourNodeTetrahedron', 7178, *[1276, 1284, 1314, 1712], 1)
    ops.element('FourNodeTetrahedron', 7179, *[258, 259, 1327, 1383], 1)
    ops.element('FourNodeTetrahedron', 7180, *[354, 1606, 1308, 1671], 1)
    ops.element('FourNodeTetrahedron', 7181, *[400, 401, 394, 1465], 1)
    ops.element('FourNodeTetrahedron', 7182, *[1521, 394, 400, 1465], 1)
    ops.element('FourNodeTetrahedron', 7183, *[1543, 1297, 1436, 1288], 1)
    ops.element('FourNodeTetrahedron', 7184, *[1292, 1543, 1436, 1288], 1)
    ops.element('FourNodeTetrahedron', 7185, *[1465, 401, 400, 356], 1)
    ops.element('FourNodeTetrahedron', 7186, *[1521, 400, 414, 1465], 1)
    ops.element('FourNodeTetrahedron', 7187, *[520, 1521, 493, 1465], 1)
    ops.element('FourNodeTetrahedron', 7188, *[482, 1465, 414, 483], 1)
    ops.element('FourNodeTetrahedron', 7189, *[1268, 1653, 1588, 1624], 1)
    ops.element('FourNodeTetrahedron', 7190, *[520, 1465, 493, 492], 1)
    ops.element('FourNodeTetrahedron', 7191, *[1465, 401, 356, 371], 1)
    ops.element('FourNodeTetrahedron', 7192, *[360, 1421, 361, 1632], 1)
    ops.element('FourNodeTetrahedron', 7193, *[1425, 1421, 1632, 1550], 1)
    ops.element('FourNodeTetrahedron', 7194, *[1425, 1421, 360, 1632], 1)
    ops.element('FourNodeTetrahedron', 7195, *[1632, 1421, 1450, 1550], 1)
    ops.element('FourNodeTetrahedron', 7196, *[1503, 1648, 1643, 1596], 1)
    ops.element('FourNodeTetrahedron', 7197, *[1487, 1433, 1554, 1441], 1)
    ops.element('FourNodeTetrahedron', 7198, *[520, 1465, 492, 517], 1)
    ops.element('FourNodeTetrahedron', 7199, *[1396, 156, 150, 149], 1)
    ops.element('FourNodeTetrahedron', 7200, *[1495, 1396, 156, 150], 1)
    ops.element('FourNodeTetrahedron', 7201, *[1631, 375, 361, 1483], 1)
    ops.element('FourNodeTetrahedron', 7202, *[1324, 1537, 261, 1323], 1)
    ops.element('FourNodeTetrahedron', 7203, *[1656, 1402, 703, 1422], 1)
    ops.element('FourNodeTetrahedron', 7204, *[1482, 155, 148, 147], 1)
    ops.element('FourNodeTetrahedron', 7205, *[1490, 1482, 1396, 1508], 1)
    ops.element('FourNodeTetrahedron', 7206, *[1685, 1501, 1446, 1469], 1)
    ops.element('FourNodeTetrahedron', 7207, *[1671, 333, 354, 332], 1)
    ops.element('FourNodeTetrahedron', 7208, *[1528, 1685, 1379, 1459], 1)
    ops.element('FourNodeTetrahedron', 7209, *[1341, 1125, 1177, 1381], 1)
    ops.element('FourNodeTetrahedron', 7210, *[1685, 358, 1379, 1446], 1)
    ops.element('FourNodeTetrahedron', 7211, *[1685, 1501, 358, 1446], 1)
    ops.element('FourNodeTetrahedron', 7212, *[1341, 1125, 1381, 1423], 1)
    ops.element('FourNodeTetrahedron', 7213, *[1422, 1402, 1656, 1523], 1)
    ops.element('FourNodeTetrahedron', 7214, *[1682, 1461, 1332, 614], 1)
    ops.element('FourNodeTetrahedron', 7215, *[1682, 1461, 614, 620], 1)
    ops.element('FourNodeTetrahedron', 7216, *[732, 731, 730, 1307], 1)
    ops.element('FourNodeTetrahedron', 7217, *[733, 731, 732, 1307], 1)
    ops.element('FourNodeTetrahedron', 7218, *[447, 1321, 443, 1563], 1)
    ops.element('FourNodeTetrahedron', 7219, *[1123, 1203, 1432, 1205], 1)
    ops.element('FourNodeTetrahedron', 7220, *[1131, 1195, 1564, 1471], 1)
    ops.element('FourNodeTetrahedron', 7221, *[478, 1662, 473, 465], 1)
    ops.element('FourNodeTetrahedron', 7222, *[755, 381, 754, 1286], 1)
    ops.element('FourNodeTetrahedron', 7223, *[763, 755, 754, 1286], 1)
    ops.element('FourNodeTetrahedron', 7224, *[1385, 763, 754, 1286], 1)
    ops.element('FourNodeTetrahedron', 7225, *[1356, 162, 173, 158], 1)
    ops.element('FourNodeTetrahedron', 7226, *[1499, 1656, 164, 1523], 1)
    ops.element('FourNodeTetrahedron', 7227, *[1656, 1402, 164, 1523], 1)
    ops.element('FourNodeTetrahedron', 7228, *[1490, 1190, 1482, 1508], 1)
    ops.element('FourNodeTetrahedron', 7229, *[1526, 1263, 1516, 1509], 1)
    ops.element('FourNodeTetrahedron', 7230, *[1237, 1125, 1341, 1248], 1)
    ops.element('FourNodeTetrahedron', 7231, *[1389, 1125, 1423, 1179], 1)
    ops.element('FourNodeTetrahedron', 7232, *[1389, 1248, 1125, 1179], 1)
    ops.element('FourNodeTetrahedron', 7233, *[1390, 1237, 1341, 1248], 1)
    ops.element('FourNodeTetrahedron', 7234, *[1390, 1248, 1341, 1389], 1)
    ops.element('FourNodeTetrahedron', 7235, *[705, 702, 703, 1402], 1)
    ops.element('FourNodeTetrahedron', 7236, *[1487, 1440, 1554, 1433], 1)
    ops.element('FourNodeTetrahedron', 7237, *[1546, 1541, 1374, 1621], 1)
    ops.element('FourNodeTetrahedron', 7238, *[1322, 1679, 322, 1316], 1)
    ops.element('FourNodeTetrahedron', 7239, *[1559, 1347, 230, 1305], 1)
    ops.element('FourNodeTetrahedron', 7240, *[1747, 1749, 1746, 1748], 1)
    ops.element('FourNodeTetrahedron', 7241, *[1206, 1750, 1242, 1127], 1)
    ops.element('FourNodeTetrahedron', 7242, *[1751, 1754, 1753, 1752], 1)
    ops.element('FourNodeTetrahedron', 7243, *[1757, 1756, 1755, 1758], 1)
    ops.element('FourNodeTetrahedron', 7244, *[1241, 1759, 1166, 1250], 1)
    ops.element('FourNodeTetrahedron', 7245, *[1762, 1760, 1761, 1763], 1)
    ops.element('FourNodeTetrahedron', 7246, *[1767, 1766, 1764, 1765], 1)
    ops.element('FourNodeTetrahedron', 7247, *[1770, 1769, 1768, 1771], 1)
    ops.element('FourNodeTetrahedron', 7248, *[1775, 1773, 1774, 1772], 1)
    ops.element('FourNodeTetrahedron', 7249, *[1779, 1777, 1778, 1776], 1)
    ops.element('FourNodeTetrahedron', 7250, *[1780, 1781, 1169, 1134], 1)
    ops.element('FourNodeTetrahedron', 7251, *[1767, 1782, 1783, 1764], 1)
    ops.element('FourNodeTetrahedron', 7252, *[1159, 1780, 1239, 1134], 1)
    ops.element('FourNodeTetrahedron', 7253, *[1784, 1787, 1786, 1785], 1)
    ops.element('FourNodeTetrahedron', 7254, *[1788, 1789, 1791, 1790], 1)
    ops.element('FourNodeTetrahedron', 7255, *[1792, 1794, 1793, 1795], 1)
    ops.element('FourNodeTetrahedron', 7256, *[1797, 1798, 1799, 1796], 1)
    ops.element('FourNodeTetrahedron', 7257, *[1800, 1802, 1801, 1803], 1)
    ops.element('FourNodeTetrahedron', 7258, *[1805, 1804, 1806, 1807], 1)
    ops.element('FourNodeTetrahedron', 7259, *[751, 1808, 752, 1162], 1)
    ops.element('FourNodeTetrahedron', 7260, *[1810, 1809, 1228, 1811], 1)
    ops.element('FourNodeTetrahedron', 7261, *[1815, 1812, 1813, 1814], 1)
    ops.element('FourNodeTetrahedron', 7262, *[1814, 1815, 1812, 1816], 1)
    ops.element('FourNodeTetrahedron', 7263, *[1813, 1812, 1817, 1814], 1)
    ops.element('FourNodeTetrahedron', 7264, *[1819, 1820, 1821, 1818], 1)
    ops.element('FourNodeTetrahedron', 7265, *[1822, 1791, 1824, 1823], 1)
    ops.element('FourNodeTetrahedron', 7266, *[1827, 1826, 1825, 1828], 1)
    ops.element('FourNodeTetrahedron', 7267, *[1830, 1831, 1832, 1829], 1)
    ops.element('FourNodeTetrahedron', 7268, *[1834, 1774, 1772, 1833], 1)
    ops.element('FourNodeTetrahedron', 7269, *[1834, 1833, 1835, 1836], 1)
    ops.element('FourNodeTetrahedron', 7270, *[1839, 1838, 1837, 1840], 1)
    ops.element('FourNodeTetrahedron', 7271, *[1841, 1843, 1842, 1844], 1)
    ops.element('FourNodeTetrahedron', 7272, *[1830, 1831, 1829, 1845], 1)
    ops.element('FourNodeTetrahedron', 7273, *[1831, 1846, 1829, 1845], 1)
    ops.element('FourNodeTetrahedron', 7274, *[1849, 1848, 1847, 653], 1)
    ops.element('FourNodeTetrahedron', 7275, *[1795, 1794, 1793, 1850], 1)
    ops.element('FourNodeTetrahedron', 7276, *[1854, 1852, 1853, 1851], 1)
    ops.element('FourNodeTetrahedron', 7277, *[1855, 1857, 1856, 1858], 1)
    ops.element('FourNodeTetrahedron', 7278, *[1861, 1860, 1215, 1859], 1)
    ops.element('FourNodeTetrahedron', 7279, *[1865, 1863, 1864, 1862], 1)
    ops.element('FourNodeTetrahedron', 7280, *[1866, 1153, 1213, 1129], 1)
    ops.element('FourNodeTetrahedron', 7281, *[1870, 1868, 1869, 1867], 1)
    ops.element('FourNodeTetrahedron', 7282, *[1871, 1873, 1872, 1874], 1)
    ops.element('FourNodeTetrahedron', 7283, *[1878, 1876, 1877, 1875], 1)
    ops.element('FourNodeTetrahedron', 7284, *[1880, 1881, 1882, 1879], 1)
    ops.element('FourNodeTetrahedron', 7285, *[1181, 1883, 1152, 634], 1)
    ops.element('FourNodeTetrahedron', 7286, *[1884, 1814, 1817, 1885], 1)
    ops.element('FourNodeTetrahedron', 7287, *[1887, 1888, 1889, 1886], 1)
    ops.element('FourNodeTetrahedron', 7288, *[1880, 1882, 1139, 1879], 1)
    ops.element('FourNodeTetrahedron', 7289, *[1890, 1863, 1865, 1862], 1)
    ops.element('FourNodeTetrahedron', 7290, *[1891, 1892, 1140, 1172], 1)
    ops.element('FourNodeTetrahedron', 7291, *[1159, 1894, 1893, 1780], 1)
    ops.element('FourNodeTetrahedron', 7292, *[1897, 1896, 1895, 1856], 1)
    ops.element('FourNodeTetrahedron', 7293, *[1258, 1866, 1129, 1898], 1)
    ops.element('FourNodeTetrahedron', 7294, *[1902, 1900, 1901, 1899], 1)
    ops.element('FourNodeTetrahedron', 7295, *[1904, 1881, 1880, 1903], 1)
    ops.element('FourNodeTetrahedron', 7296, *[1907, 1906, 1905, 1820], 1)
    ops.element('FourNodeTetrahedron', 7297, *[1909, 1910, 1911, 1908], 1)
    ops.element('FourNodeTetrahedron', 7298, *[1171, 1905, 1144, 1253], 1)
    ops.element('FourNodeTetrahedron', 7299, *[1909, 1911, 1912, 1908], 1)
    ops.element('FourNodeTetrahedron', 7300, *[1246, 1898, 1221, 1913], 1)
    ops.element('FourNodeTetrahedron', 7301, *[1917, 1914, 1915, 1916], 1)
    ops.element('FourNodeTetrahedron', 7302, *[1909, 1912, 1918, 1908], 1)
    ops.element('FourNodeTetrahedron', 7303, *[1919, 1910, 1909, 1908], 1)
    ops.element('FourNodeTetrahedron', 7304, *[1888, 1922, 1921, 1920], 1)
    ops.element('FourNodeTetrahedron', 7305, *[532, 1923, 1249, 526], 1)
    ops.element('FourNodeTetrahedron', 7306, *[1919, 1908, 1924, 1925], 1)
    ops.element('FourNodeTetrahedron', 7307, *[1927, 1926, 1928, 1929], 1)
    ops.element('FourNodeTetrahedron', 7308, *[1931, 1932, 1933, 1930], 1)
    ops.element('FourNodeTetrahedron', 7309, *[1935, 1934, 1936, 1933], 1)
    ops.element('FourNodeTetrahedron', 7310, *[1796, 1798, 1799, 1937], 1)
    ops.element('FourNodeTetrahedron', 7311, *[1940, 1939, 1938, 1941], 1)
    ops.element('FourNodeTetrahedron', 7312, *[1944, 1945, 1943, 1942], 1)
    ops.element('FourNodeTetrahedron', 7313, *[1947, 1946, 1948, 1871], 1)
    ops.element('FourNodeTetrahedron', 7314, *[1750, 1949, 1127, 1202], 1)
    ops.element('FourNodeTetrahedron', 7315, *[1862, 1951, 1950, 1899], 1)
    ops.element('FourNodeTetrahedron', 7316, *[1955, 1954, 1952, 1953], 1)
    ops.element('FourNodeTetrahedron', 7317, *[1769, 1957, 1956, 1958], 1)
    ops.element('FourNodeTetrahedron', 7318, *[1769, 1959, 1956, 1957], 1)
    ops.element('FourNodeTetrahedron', 7319, *[1961, 1960, 1841, 1844], 1)
    ops.element('FourNodeTetrahedron', 7320, *[1963, 1965, 1962, 1964], 1)
    ops.element('FourNodeTetrahedron', 7321, *[1968, 1967, 1966, 1878], 1)
    ops.element('FourNodeTetrahedron', 7322, *[1970, 1972, 1969, 1971], 1)
    ops.element('FourNodeTetrahedron', 7323, *[1968, 1876, 1967, 1878], 1)
    ops.element('FourNodeTetrahedron', 7324, *[1974, 1975, 1859, 1973], 1)
    ops.element('FourNodeTetrahedron', 7325, *[1978, 1976, 1753, 1977], 1)
    ops.element('FourNodeTetrahedron', 7326, *[1979, 1940, 1938, 1941], 1)
    ops.element('FourNodeTetrahedron', 7327, *[1980, 1785, 1844, 1981], 1)
    ops.element('FourNodeTetrahedron', 7328, *[1985, 1983, 1984, 1982], 1)
    ops.element('FourNodeTetrahedron', 7329, *[1921, 1987, 1986, 1924], 1)
    ops.element('FourNodeTetrahedron', 7330, *[1978, 1976, 1870, 1753], 1)
    ops.element('FourNodeTetrahedron', 7331, *[1988, 1761, 1760, 1762], 1)
    ops.element('FourNodeTetrahedron', 7332, *[1992, 1989, 1990, 1991], 1)
    ops.element('FourNodeTetrahedron', 7333, *[1993, 1994, 1996, 1995], 1)
    ops.element('FourNodeTetrahedron', 7334, *[1998, 1834, 1997, 1242], 1)
    ops.element('FourNodeTetrahedron', 7335, *[1936, 2000, 1811, 1999], 1)
    ops.element('FourNodeTetrahedron', 7336, *[2002, 2003, 2001, 2004], 1)
    ops.element('FourNodeTetrahedron', 7337, *[1250, 1759, 1166, 1243], 1)
    ops.element('FourNodeTetrahedron', 7338, *[1761, 2005, 1760, 1763], 1)
    ops.element('FourNodeTetrahedron', 7339, *[2007, 1973, 1891, 2006], 1)
    ops.element('FourNodeTetrahedron', 7340, *[2007, 2008, 1973, 2006], 1)
    ops.element('FourNodeTetrahedron', 7341, *[1247, 1124, 1163, 2009], 1)
    ops.element('FourNodeTetrahedron', 7342, *[2007, 2008, 2006, 2010], 1)
    ops.element('FourNodeTetrahedron', 7343, *[1171, 2011, 1144, 1905], 1)
    ops.element('FourNodeTetrahedron', 7344, *[2014, 2012, 2015, 2013], 1)
    ops.element('FourNodeTetrahedron', 7345, *[1246, 1898, 1258, 1221], 1)
    ops.element('FourNodeTetrahedron', 7346, *[1781, 1866, 1258, 1898], 1)
    ops.element('FourNodeTetrahedron', 7347, *[2018, 2017, 2016, 2019], 1)
    ops.element('FourNodeTetrahedron', 7348, *[2018, 2017, 2020, 2016], 1)
    ops.element('FourNodeTetrahedron', 7349, *[2022, 2023, 2024, 2021], 1)
    ops.element('FourNodeTetrahedron', 7350, *[2025, 1800, 2026, 2027], 1)
    ops.element('FourNodeTetrahedron', 7351, *[2030, 2028, 2029, 1824], 1)
    ops.element('FourNodeTetrahedron', 7352, *[2033, 2032, 2031, 2034], 1)
    ops.element('FourNodeTetrahedron', 7353, *[2038, 2036, 2037, 2035], 1)
    ops.element('FourNodeTetrahedron', 7354, *[2039, 2042, 2041, 2040], 1)
    ops.element('FourNodeTetrahedron', 7355, *[2043, 1800, 2025, 2027], 1)
    ops.element('FourNodeTetrahedron', 7356, *[1884, 1817, 2044, 1885], 1)
    ops.element('FourNodeTetrahedron', 7357, *[1808, 2045, 2047, 2046], 1)
    ops.element('FourNodeTetrahedron', 7358, *[1954, 2050, 2048, 2049], 1)
    ops.element('FourNodeTetrahedron', 7359, *[2051, 2053, 2052, 2054], 1)
    ops.element('FourNodeTetrahedron', 7360, *[1927, 2033, 2055, 2056], 1)
    ops.element('FourNodeTetrahedron', 7361, *[2054, 2057, 2051, 2053], 1)
    ops.element('FourNodeTetrahedron', 7362, *[2058, 2059, 1994, 1995], 1)
    ops.element('FourNodeTetrahedron', 7363, *[2060, 2061, 2063, 2062], 1)
    ops.element('FourNodeTetrahedron', 7364, *[748, 1760, 749, 1213], 1)
    ops.element('FourNodeTetrahedron', 7365, *[1880, 1882, 1207, 1139], 1)
    ops.element('FourNodeTetrahedron', 7366, *[1140, 146, 1190, 2064], 1)
    ops.element('FourNodeTetrahedron', 7367, *[1759, 2067, 2065, 2066], 1)
    ops.element('FourNodeTetrahedron', 7368, *[1821, 2069, 2070, 2068], 1)
    ops.element('FourNodeTetrahedron', 7369, *[2073, 2071, 2074, 2072], 1)
    ops.element('FourNodeTetrahedron', 7370, *[2075, 2077, 2076, 2002], 1)
    ops.element('FourNodeTetrahedron', 7371, *[1235, 1869, 1248, 2078], 1)
    ops.element('FourNodeTetrahedron', 7372, *[2080, 1748, 2081, 2079], 1)
    ops.element('FourNodeTetrahedron', 7373, *[1748, 2082, 2081, 2079], 1)
    ops.element('FourNodeTetrahedron', 7374, *[2083, 2084, 1160, 1752], 1)
    ops.element('FourNodeTetrahedron', 7375, *[1837, 2086, 2085, 1838], 1)
    ops.element('FourNodeTetrahedron', 7376, *[2090, 2089, 2087, 2088], 1)
    ops.element('FourNodeTetrahedron', 7377, *[2091, 1831, 1832, 1830], 1)
    ops.element('FourNodeTetrahedron', 7378, *[1803, 2091, 1832, 1830], 1)
    ops.element('FourNodeTetrahedron', 7379, *[2092, 2040, 1832, 1831], 1)
    ops.element('FourNodeTetrahedron', 7380, *[1918, 2093, 2094, 2095], 1)
    ops.element('FourNodeTetrahedron', 7381, *[1966, 1878, 2097, 2096], 1)
    ops.element('FourNodeTetrahedron', 7382, *[1170, 2099, 177, 2098], 1)
    ops.element('FourNodeTetrahedron', 7383, *[1193, 1779, 1161, 1133], 1)
    ops.element('FourNodeTetrahedron', 7384, *[2103, 2101, 2102, 2100], 1)
    ops.element('FourNodeTetrahedron', 7385, *[1819, 1818, 1233, 2104], 1)
    ops.element('FourNodeTetrahedron', 7386, *[2105, 1777, 1779, 2106], 1)
    ops.element('FourNodeTetrahedron', 7387, *[1750, 2107, 1836, 1949], 1)
    ops.element('FourNodeTetrahedron', 7388, *[2111, 2108, 2109, 2110], 1)
    ops.element('FourNodeTetrahedron', 7389, *[2113, 2112, 2058, 1995], 1)
    ops.element('FourNodeTetrahedron', 7390, *[1979, 1938, 2114, 1941], 1)
    ops.element('FourNodeTetrahedron', 7391, *[2115, 1827, 1818, 2104], 1)
    ops.element('FourNodeTetrahedron', 7392, *[2102, 2101, 2116, 2100], 1)
    ops.element('FourNodeTetrahedron', 7393, *[2118, 2117, 1977, 2119], 1)
    ops.element('FourNodeTetrahedron', 7394, *[2105, 2022, 1779, 1777], 1)
    ops.element('FourNodeTetrahedron', 7395, *[1161, 1779, 1197, 1133], 1)
    ops.element('FourNodeTetrahedron', 7396, *[1209, 2120, 1211, 1214], 1)
    ops.element('FourNodeTetrahedron', 7397, *[2123, 2122, 2121, 2124], 1)
    ops.element('FourNodeTetrahedron', 7398, *[2128, 2127, 2125, 2126], 1)
    ops.element('FourNodeTetrahedron', 7399, *[2131, 2132, 2130, 2129], 1)
    ops.element('FourNodeTetrahedron', 7400, *[1809, 2135, 2134, 2133], 1)
    ops.element('FourNodeTetrahedron', 7401, *[2137, 2136, 2011, 1906], 1)
    ops.element('FourNodeTetrahedron', 7402, *[2137, 2136, 738, 2011], 1)
    ops.element('FourNodeTetrahedron', 7403, *[1969, 2139, 2140, 2138], 1)
    ops.element('FourNodeTetrahedron', 7404, *[1813, 1812, 2141, 1817], 1)
    ops.element('FourNodeTetrahedron', 7405, *[2143, 2144, 1123, 2142], 1)
    ops.element('FourNodeTetrahedron', 7406, *[1825, 2144, 1123, 2143], 1)
    ops.element('FourNodeTetrahedron', 7407, *[1825, 1826, 2144, 2143], 1)
    ops.element('FourNodeTetrahedron', 7408, *[1828, 1826, 1825, 2143], 1)
    ops.element('FourNodeTetrahedron', 7409, *[2147, 2146, 2145, 2144], 1)
    ops.element('FourNodeTetrahedron', 7410, *[1828, 2148, 2143, 2149], 1)
    ops.element('FourNodeTetrahedron', 7411, *[1992, 2151, 2150, 2152], 1)
    ops.element('FourNodeTetrahedron', 7412, *[1771, 2051, 2154, 2153], 1)
    ops.element('FourNodeTetrahedron', 7413, *[1781, 1866, 1988, 1258], 1)
    ops.element('FourNodeTetrahedron', 7414, *[1948, 1871, 2155, 2156], 1)
    ops.element('FourNodeTetrahedron', 7415, *[2158, 2160, 2157, 2159], 1)
    ops.element('FourNodeTetrahedron', 7416, *[2163, 2161, 2162, 1814], 1)
    ops.element('FourNodeTetrahedron', 7417, *[1928, 1926, 1884, 1784], 1)
    ops.element('FourNodeTetrahedron', 7418, *[2166, 2165, 2164, 2167], 1)
    ops.element('FourNodeTetrahedron', 7419, *[2158, 2168, 2157, 2160], 1)
    ops.element('FourNodeTetrahedron', 7420, *[2171, 2169, 2172, 2170], 1)
    ops.element('FourNodeTetrahedron', 7421, *[2159, 2160, 2157, 2173], 1)
    ops.element('FourNodeTetrahedron', 7422, *[1790, 2175, 2176, 2174], 1)
    ops.element('FourNodeTetrahedron', 7423, *[1896, 2159, 2157, 2173], 1)
    ops.element('FourNodeTetrahedron', 7424, *[2178, 2180, 2177, 2179], 1)
    ops.element('FourNodeTetrahedron', 7425, *[1927, 2031, 1926, 1929], 1)
    ops.element('FourNodeTetrahedron', 7426, *[2183, 2181, 2182, 1835], 1)
    ops.element('FourNodeTetrahedron', 7427, *[2186, 1807, 2184, 2185], 1)
    ops.element('FourNodeTetrahedron', 7428, *[2146, 1854, 2144, 1897], 1)
    ops.element('FourNodeTetrahedron', 7429, *[2188, 2187, 1970, 2189], 1)
    ops.element('FourNodeTetrahedron', 7430, *[1122, 2191, 2190, 1797], 1)
    ops.element('FourNodeTetrahedron', 7431, *[2194, 2192, 2193, 2124], 1)
    ops.element('FourNodeTetrahedron', 7432, *[2123, 2192, 2194, 2124], 1)
    ops.element('FourNodeTetrahedron', 7433, *[2197, 2198, 2196, 2195], 1)
    ops.element('FourNodeTetrahedron', 7434, *[2199, 2201, 2198, 2200], 1)
    ops.element('FourNodeTetrahedron', 7435, *[2204, 2007, 2202, 2203], 1)
    ops.element('FourNodeTetrahedron', 7436, *[2207, 1948, 2205, 2206], 1)
    ops.element('FourNodeTetrahedron', 7437, *[2210, 2211, 2209, 2208], 1)
    ops.element('FourNodeTetrahedron', 7438, *[2212, 1947, 1948, 2206], 1)
    ops.element('FourNodeTetrahedron', 7439, *[2214, 2213, 2080, 1969], 1)
    ops.element('FourNodeTetrahedron', 7440, *[1947, 2156, 1948, 2206], 1)
    ops.element('FourNodeTetrahedron', 7441, *[2215, 2195, 2196, 2064], 1)
    ops.element('FourNodeTetrahedron', 7442, *[2196, 2217, 2216, 2064], 1)
    ops.element('FourNodeTetrahedron', 7443, *[2195, 2217, 2064, 2218], 1)
    ops.element('FourNodeTetrahedron', 7444, *[1935, 2220, 2219, 1934], 1)
    ops.element('FourNodeTetrahedron', 7445, *[1978, 1236, 1145, 1753], 1)
    ops.element('FourNodeTetrahedron', 7446, *[2222, 2221, 2008, 2192], 1)
    ops.element('FourNodeTetrahedron', 7447, *[2079, 2082, 2224, 2223], 1)
    ops.element('FourNodeTetrahedron', 7448, *[2225, 2227, 2014, 2226], 1)
    ops.element('FourNodeTetrahedron', 7449, *[1835, 2230, 2228, 2229], 1)
    ops.element('FourNodeTetrahedron', 7450, *[2195, 2198, 2217, 2218], 1)
    ops.element('FourNodeTetrahedron', 7451, *[2231, 1962, 2232, 2233], 1)
    ops.element('FourNodeTetrahedron', 7452, *[2196, 2198, 2217, 2195], 1)
    ops.element('FourNodeTetrahedron', 7453, *[2234, 634, 1181, 633], 1)
    ops.element('FourNodeTetrahedron', 7454, *[2195, 2198, 2218, 2200], 1)
    ops.element('FourNodeTetrahedron', 7455, *[1221, 1953, 1218, 1256], 1)
    ops.element('FourNodeTetrahedron', 7456, *[2235, 2182, 1252, 2228], 1)
    ops.element('FourNodeTetrahedron', 7457, *[513, 2236, 1246, 1913], 1)
    ops.element('FourNodeTetrahedron', 7458, *[2235, 2182, 728, 1252], 1)
    ops.element('FourNodeTetrahedron', 7459, *[513, 2237, 1150, 2238], 1)
    ops.element('FourNodeTetrahedron', 7460, *[1942, 2227, 1943, 2225], 1)
    ops.element('FourNodeTetrahedron', 7461, *[2240, 2241, 2242, 2239], 1)
    ops.element('FourNodeTetrahedron', 7462, *[2245, 2244, 2019, 2243], 1)
    ops.element('FourNodeTetrahedron', 7463, *[1219, 2048, 1247, 1164], 1)
    ops.element('FourNodeTetrahedron', 7464, *[2246, 2247, 2015, 2012], 1)
    ops.element('FourNodeTetrahedron', 7465, *[2249, 1770, 1771, 2248], 1)
    ops.element('FourNodeTetrahedron', 7466, *[1239, 1780, 1169, 1134], 1)
    ops.element('FourNodeTetrahedron', 7467, *[2058, 1829, 1932, 1994], 1)
    ops.element('FourNodeTetrahedron', 7468, *[1921, 1924, 1986, 1920], 1)
    ops.element('FourNodeTetrahedron', 7469, *[1190, 2251, 2250, 2216], 1)
    ops.element('FourNodeTetrahedron', 7470, *[2252, 2254, 1958, 2253], 1)
    ops.element('FourNodeTetrahedron', 7471, *[2255, 2250, 1190, 2251], 1)
    ops.element('FourNodeTetrahedron', 7472, *[1211, 1810, 1228, 1811], 1)
    ops.element('FourNodeTetrahedron', 7473, *[2009, 2257, 2258, 2256], 1)
    ops.element('FourNodeTetrahedron', 7474, *[2259, 2119, 1751, 650], 1)
    ops.element('FourNodeTetrahedron', 7475, *[1842, 1952, 1866, 1898], 1)
    ops.element('FourNodeTetrahedron', 7476, *[1211, 1141, 1228, 1811], 1)
    ops.element('FourNodeTetrahedron', 7477, *[1913, 1955, 1221, 2073], 1)
    ops.element('FourNodeTetrahedron', 7478, *[1211, 1811, 1141, 1255], 1)
    ops.element('FourNodeTetrahedron', 7479, *[1750, 2260, 1836, 2261], 1)
    ops.element('FourNodeTetrahedron', 7480, *[1863, 2262, 1864, 1862], 1)
    ops.element('FourNodeTetrahedron', 7481, *[2149, 1767, 2263, 2264], 1)
    ops.element('FourNodeTetrahedron', 7482, *[2265, 1939, 1940, 1941], 1)
    ops.element('FourNodeTetrahedron', 7483, *[1250, 1759, 1243, 2266], 1)
    ops.element('FourNodeTetrahedron', 7484, *[1841, 1960, 1843, 1844], 1)
    ops.element('FourNodeTetrahedron', 7485, *[2191, 2268, 1797, 2267], 1)
    ops.element('FourNodeTetrahedron', 7486, *[2269, 2270, 2271, 1991], 1)
    ops.element('FourNodeTetrahedron', 7487, *[1832, 2040, 2110, 1846], 1)
    ops.element('FourNodeTetrahedron', 7488, *[2273, 1875, 1878, 2272], 1)
    ops.element('FourNodeTetrahedron', 7489, *[2274, 2057, 2153, 2054], 1)
    ops.element('FourNodeTetrahedron', 7490, *[1238, 2218, 419, 424], 1)
    ops.element('FourNodeTetrahedron', 7491, *[2051, 2226, 1883, 2052], 1)
    ops.element('FourNodeTetrahedron', 7492, *[2009, 2275, 1124, 2258], 1)
    ops.element('FourNodeTetrahedron', 7493, *[1928, 1940, 1979, 1941], 1)
    ops.element('FourNodeTetrahedron', 7494, *[2277, 2276, 1807, 2185], 1)
    ops.element('FourNodeTetrahedron', 7495, *[1910, 1911, 1908, 1946], 1)
    ops.element('FourNodeTetrahedron', 7496, *[2153, 2057, 2051, 2054], 1)
    ops.element('FourNodeTetrahedron', 7497, *[2200, 2278, 2218, 1923], 1)
    ops.element('FourNodeTetrahedron', 7498, *[2280, 2279, 2281, 2282], 1)
    ops.element('FourNodeTetrahedron', 7499, *[1205, 2142, 1203, 1231], 1)
    ops.element('FourNodeTetrahedron', 7500, *[1220, 2073, 1223, 1126], 1)
    ops.element('FourNodeTetrahedron', 7501, *[1930, 2283, 1999, 2284], 1)
    ops.element('FourNodeTetrahedron', 7502, *[2113, 2058, 2285, 1995], 1)
    ops.element('FourNodeTetrahedron', 7503, *[2288, 2289, 2287, 2286], 1)
    ops.element('FourNodeTetrahedron', 7504, *[2072, 2129, 2071, 1976], 1)
    ops.element('FourNodeTetrahedron', 7505, *[1884, 1885, 2044, 1784], 1)
    ops.element('FourNodeTetrahedron', 7506, *[2290, 2291, 2292, 2293], 1)
    ops.element('FourNodeTetrahedron', 7507, *[2096, 2273, 1878, 2294], 1)
    ops.element('FourNodeTetrahedron', 7508, *[1902, 1900, 1899, 1838], 1)
    ops.element('FourNodeTetrahedron', 7509, *[2295, 1938, 2114, 1979], 1)
    ops.element('FourNodeTetrahedron', 7510, *[2223, 2296, 2271, 1792], 1)
    ops.element('FourNodeTetrahedron', 7511, *[2150, 2075, 2076, 2152], 1)
    ops.element('FourNodeTetrahedron', 7512, *[2056, 2297, 2055, 2038], 1)
    ops.element('FourNodeTetrahedron', 7513, *[1219, 2048, 1164, 2298], 1)
    ops.element('FourNodeTetrahedron', 7514, *[2243, 2252, 1958, 2274], 1)
    ops.element('FourNodeTetrahedron', 7515, *[1217, 1247, 1139, 2048], 1)
    ops.element('FourNodeTetrahedron', 7516, *[1953, 2048, 1219, 2298], 1)
    ops.element('FourNodeTetrahedron', 7517, *[2066, 1944, 2065, 1942], 1)
    ops.element('FourNodeTetrahedron', 7518, *[2299, 2011, 737, 1171], 1)
    ops.element('FourNodeTetrahedron', 7519, *[1747, 2213, 2214, 1969], 1)
    ops.element('FourNodeTetrahedron', 7520, *[2301, 2300, 2302, 2303], 1)
    ops.element('FourNodeTetrahedron', 7521, *[2305, 2304, 734, 1199], 1)
    ops.element('FourNodeTetrahedron', 7522, *[2307, 2306, 1975, 1973], 1)
    ops.element('FourNodeTetrahedron', 7523, *[2307, 1996, 2284, 2306], 1)
    ops.element('FourNodeTetrahedron', 7524, *[1212, 2308, 1847, 2084], 1)
    ops.element('FourNodeTetrahedron', 7525, *[2307, 2309, 1996, 2306], 1)
    ops.element('FourNodeTetrahedron', 7526, *[2312, 2311, 2310, 1800], 1)
    ops.element('FourNodeTetrahedron', 7527, *[2059, 1846, 2314, 2313], 1)
    ops.element('FourNodeTetrahedron', 7528, *[2130, 2316, 2315, 2071], 1)
    ops.element('FourNodeTetrahedron', 7529, *[1772, 2310, 1833, 1836], 1)
    ops.element('FourNodeTetrahedron', 7530, *[1953, 1954, 2048, 2298], 1)
    ops.element('FourNodeTetrahedron', 7531, *[1214, 1811, 1211, 1255], 1)
    ops.element('FourNodeTetrahedron', 7532, *[1989, 2317, 2002, 2318], 1)
    ops.element('FourNodeTetrahedron', 7533, *[2320, 2319, 2068, 1827], 1)
    ops.element('FourNodeTetrahedron', 7534, *[2081, 2082, 2151, 2079], 1)
    ops.element('FourNodeTetrahedron', 7535, *[2308, 2321, 1148, 1847], 1)
    ops.element('FourNodeTetrahedron', 7536, *[2181, 2230, 2182, 1835], 1)
    ops.element('FourNodeTetrahedron', 7537, *[2322, 2277, 1807, 2186], 1)
    ops.element('FourNodeTetrahedron', 7538, *[1748, 2323, 2324, 1972], 1)
    ops.element('FourNodeTetrahedron', 7539, *[2157, 2160, 1931, 2325], 1)
    ops.element('FourNodeTetrahedron', 7540, *[2318, 2317, 2326, 2327], 1)
    ops.element('FourNodeTetrahedron', 7541, *[2329, 2330, 2331, 2328], 1)
    ops.element('FourNodeTetrahedron', 7542, *[2084, 2332, 2308, 1849], 1)
    ops.element('FourNodeTetrahedron', 7543, *[1924, 1918, 1857, 2095], 1)
    ops.element('FourNodeTetrahedron', 7544, *[1145, 1753, 1244, 1168], 1)
    ops.element('FourNodeTetrahedron', 7545, *[2333, 1914, 2200, 1915], 1)
    ops.element('FourNodeTetrahedron', 7546, *[2333, 2334, 2200, 1914], 1)
    ops.element('FourNodeTetrahedron', 7547, *[2092, 2042, 2039, 2040], 1)
    ops.element('FourNodeTetrahedron', 7548, *[1917, 1914, 2333, 1915], 1)
    ops.element('FourNodeTetrahedron', 7549, *[2098, 2335, 2099, 2336], 1)
    ops.element('FourNodeTetrahedron', 7550, *[2338, 2339, 2138, 2337], 1)
    ops.element('FourNodeTetrahedron', 7551, *[2338, 2138, 2140, 2337], 1)
    ops.element('FourNodeTetrahedron', 7552, *[1970, 2138, 1969, 2339], 1)
    ops.element('FourNodeTetrahedron', 7553, *[2272, 1875, 2175, 1963], 1)
    ops.element('FourNodeTetrahedron', 7554, *[2191, 2268, 2190, 1797], 1)
    ops.element('FourNodeTetrahedron', 7555, *[2340, 1969, 2338, 2339], 1)
    ops.element('FourNodeTetrahedron', 7556, *[2002, 2341, 2279, 2282], 1)
    ops.element('FourNodeTetrahedron', 7557, *[2002, 2282, 2279, 2280], 1)
    ops.element('FourNodeTetrahedron', 7558, *[2149, 2148, 2143, 2263], 1)
    ops.element('FourNodeTetrahedron', 7559, *[1227, 1825, 1123, 2143], 1)
    ops.element('FourNodeTetrahedron', 7560, *[1971, 2342, 2344, 2343], 1)
    ops.element('FourNodeTetrahedron', 7561, *[1937, 2149, 2143, 2263], 1)
    ops.element('FourNodeTetrahedron', 7562, *[2088, 2167, 1809, 2135], 1)
    ops.element('FourNodeTetrahedron', 7563, *[1856, 2346, 2173, 2345], 1)
    ops.element('FourNodeTetrahedron', 7564, *[1971, 2344, 2139, 2343], 1)
    ops.element('FourNodeTetrahedron', 7565, *[2349, 2350, 2348, 2347], 1)
    ops.element('FourNodeTetrahedron', 7566, *[2000, 2351, 2088, 2135], 1)
    ops.element('FourNodeTetrahedron', 7567, *[2353, 2355, 2352, 2354], 1)
    ops.element('FourNodeTetrahedron', 7568, *[1871, 1872, 2186, 2155], 1)
    ops.element('FourNodeTetrahedron', 7569, *[1862, 1901, 1951, 1899], 1)
    ops.element('FourNodeTetrahedron', 7570, *[2241, 2356, 2221, 2222], 1)
    ops.element('FourNodeTetrahedron', 7571, *[1901, 1900, 1951, 1899], 1)
    ops.element('FourNodeTetrahedron', 7572, *[2358, 1980, 1981, 2357], 1)
    ops.element('FourNodeTetrahedron', 7573, *[1929, 1980, 2358, 2357], 1)
    ops.element('FourNodeTetrahedron', 7574, *[2358, 1980, 1844, 1981], 1)
    ops.element('FourNodeTetrahedron', 7575, *[2256, 2258, 1226, 2359], 1)
    ops.element('FourNodeTetrahedron', 7576, *[2360, 2280, 2004, 2361], 1)
    ops.element('FourNodeTetrahedron', 7577, *[2360, 2004, 2117, 2361], 1)
    ops.element('FourNodeTetrahedron', 7578, *[1164, 2009, 1124, 1226], 1)
    ops.element('FourNodeTetrahedron', 7579, *[2362, 2004, 2117, 2360], 1)
    ops.element('FourNodeTetrahedron', 7580, *[2363, 2311, 2364, 2310], 1)
    ops.element('FourNodeTetrahedron', 7581, *[2365, 2268, 2190, 2191], 1)
    ops.element('FourNodeTetrahedron', 7582, *[2015, 2247, 2264, 2012], 1)
    ops.element('FourNodeTetrahedron', 7583, *[2289, 2366, 2287, 2176], 1)
    ops.element('FourNodeTetrahedron', 7584, *[1760, 1763, 1880, 1903], 1)
    ops.element('FourNodeTetrahedron', 7585, *[2367, 2289, 2288, 1790], 1)
    ops.element('FourNodeTetrahedron', 7586, *[2169, 2369, 2172, 2368], 1)
    ops.element('FourNodeTetrahedron', 7587, *[2203, 2010, 2370, 2371], 1)
    ops.element('FourNodeTetrahedron', 7588, *[2101, 2288, 1863, 1890], 1)
    ops.element('FourNodeTetrahedron', 7589, *[2089, 2372, 2374, 2373], 1)
    ops.element('FourNodeTetrahedron', 7590, *[2246, 1889, 2012, 1887], 1)
    ops.element('FourNodeTetrahedron', 7591, *[1122, 2190, 1186, 1797], 1)
    ops.element('FourNodeTetrahedron', 7592, *[2246, 1889, 2247, 2012], 1)
    ops.element('FourNodeTetrahedron', 7593, *[2102, 2376, 2375, 2116], 1)
    ops.element('FourNodeTetrahedron', 7594, *[1886, 1888, 1920, 2292], 1)
    ops.element('FourNodeTetrahedron', 7595, *[1922, 2378, 1924, 2377], 1)
    ops.element('FourNodeTetrahedron', 7596, *[2203, 2193, 2010, 2371], 1)
    ops.element('FourNodeTetrahedron', 7597, *[2379, 2079, 2224, 2271], 1)
    ops.element('FourNodeTetrahedron', 7598, *[2380, 2305, 1174, 2070], 1)
    ops.element('FourNodeTetrahedron', 7599, *[1981, 2383, 2381, 2382], 1)
    ops.element('FourNodeTetrahedron', 7600, *[1878, 2272, 2097, 2294], 1)
    ops.element('FourNodeTetrahedron', 7601, *[2052, 2290, 2226, 2384], 1)
    ops.element('FourNodeTetrahedron', 7602, *[2332, 2001, 2385, 2361], 1)
    ops.element('FourNodeTetrahedron', 7603, *[2187, 2386, 1970, 2387], 1)
    ops.element('FourNodeTetrahedron', 7604, *[1877, 1791, 1822, 1823], 1)
    ops.element('FourNodeTetrahedron', 7605, *[2390, 2173, 2388, 2389], 1)
    ops.element('FourNodeTetrahedron', 7606, *[1200, 2068, 1136, 1201], 1)
    ops.element('FourNodeTetrahedron', 7607, *[1823, 1790, 2174, 2272], 1)
    ops.element('FourNodeTetrahedron', 7608, *[2354, 2355, 2391, 2392], 1)
    ops.element('FourNodeTetrahedron', 7609, *[2393, 1807, 1805, 2322], 1)
    ops.element('FourNodeTetrahedron', 7610, *[2030, 2029, 2313, 1824], 1)
    ops.element('FourNodeTetrahedron', 7611, *[2355, 2394, 2391, 2392], 1)
    ops.element('FourNodeTetrahedron', 7612, *[2016, 2395, 2359, 2078], 1)
    ops.element('FourNodeTetrahedron', 7613, *[2358, 2396, 2397, 513], 1)
    ops.element('FourNodeTetrahedron', 7614, *[2004, 2245, 2332, 1754], 1)
    ops.element('FourNodeTetrahedron', 7615, *[1988, 1760, 1213, 1866], 1)
    ops.element('FourNodeTetrahedron', 7616, *[1762, 1841, 2399, 2398], 1)
    ops.element('FourNodeTetrahedron', 7617, *[1889, 1767, 2264, 1765], 1)
    ops.element('FourNodeTetrahedron', 7618, *[2400, 2401, 711, 1228], 1)
    ops.element('FourNodeTetrahedron', 7619, *[1754, 2004, 2332, 2361], 1)
    ops.element('FourNodeTetrahedron', 7620, *[1203, 2402, 1135, 1231], 1)
    ops.element('FourNodeTetrahedron', 7621, *[1203, 2402, 1251, 1135], 1)
    ops.element('FourNodeTetrahedron', 7622, *[1752, 2332, 1849, 2361], 1)
    ops.element('FourNodeTetrahedron', 7623, *[2043, 2027, 2025, 2168], 1)
    ops.element('FourNodeTetrahedron', 7624, *[723, 1835, 2235, 1147], 1)
    ops.element('FourNodeTetrahedron', 7625, *[2001, 2403, 2243, 2385], 1)
    ops.element('FourNodeTetrahedron', 7626, *[2083, 2332, 2084, 1752], 1)
    ops.element('FourNodeTetrahedron', 7627, *[1966, 1967, 1823, 1878], 1)
    ops.element('FourNodeTetrahedron', 7628, *[1988, 1760, 748, 1213], 1)
    ops.element('FourNodeTetrahedron', 7629, *[1937, 2404, 1195, 2349], 1)
    ops.element('FourNodeTetrahedron', 7630, *[1153, 1880, 1139, 1217], 1)
    ops.element('FourNodeTetrahedron', 7631, *[2407, 2406, 2402, 2405], 1)
    ops.element('FourNodeTetrahedron', 7632, *[1208, 2120, 1209, 1214], 1)
    ops.element('FourNodeTetrahedron', 7633, *[1949, 2120, 1209, 1208], 1)
    ops.element('FourNodeTetrahedron', 7634, *[1803, 2092, 1832, 2091], 1)
    ops.element('FourNodeTetrahedron', 7635, *[2408, 1750, 1206, 2409], 1)
    ops.element('FourNodeTetrahedron', 7636, *[2350, 2411, 2412, 2410], 1)
    ops.element('FourNodeTetrahedron', 7637, *[2413, 2080, 2379, 2140], 1)
    ops.element('FourNodeTetrahedron', 7638, *[1754, 2332, 2083, 1752], 1)
    ops.element('FourNodeTetrahedron', 7639, *[2415, 2414, 2273, 2416], 1)
    ops.element('FourNodeTetrahedron', 7640, *[2255, 2250, 1149, 1190], 1)
    ops.element('FourNodeTetrahedron', 7641, *[1891, 2215, 1190, 1140], 1)
    ops.element('FourNodeTetrahedron', 7642, *[1232, 1891, 1191, 1140], 1)
    ops.element('FourNodeTetrahedron', 7643, *[2418, 1802, 2027, 2417], 1)
    ops.element('FourNodeTetrahedron', 7644, *[2074, 2316, 2419, 1869], 1)
    ops.element('FourNodeTetrahedron', 7645, *[1202, 2145, 1208, 1251], 1)
    ops.element('FourNodeTetrahedron', 7646, *[2420, 1976, 1978, 1977], 1)
    ops.element('FourNodeTetrahedron', 7647, *[1811, 1809, 1141, 2133], 1)
    ops.element('FourNodeTetrahedron', 7648, *[1809, 2167, 1157, 2134], 1)
    ops.element('FourNodeTetrahedron', 7649, *[2147, 2421, 2409, 2422], 1)
    ops.element('FourNodeTetrahedron', 7650, *[1834, 1836, 1835, 1750], 1)
    ops.element('FourNodeTetrahedron', 7651, *[1967, 1877, 2423, 1823], 1)
    ops.element('FourNodeTetrahedron', 7652, *[2139, 1792, 2270, 2343], 1)
    ops.element('FourNodeTetrahedron', 7653, *[2425, 2424, 2025, 2043], 1)
    ops.element('FourNodeTetrahedron', 7654, *[1800, 2026, 2310, 2025], 1)
    ops.element('FourNodeTetrahedron', 7655, *[1823, 1824, 2103, 2174], 1)
    ops.element('FourNodeTetrahedron', 7656, *[2426, 2002, 2004, 2280], 1)
    ops.element('FourNodeTetrahedron', 7657, *[2427, 2428, 1804, 1807], 1)
    ops.element('FourNodeTetrahedron', 7658, *[752, 2047, 743, 1143], 1)
    ops.element('FourNodeTetrahedron', 7659, *[2280, 2279, 2001, 2281], 1)
    ops.element('FourNodeTetrahedron', 7660, *[1796, 1799, 1184, 1937], 1)
    ops.element('FourNodeTetrahedron', 7661, *[2429, 2430, 2121, 2122], 1)
    ops.element('FourNodeTetrahedron', 7662, *[2001, 2432, 2431, 2279], 1)
    ops.element('FourNodeTetrahedron', 7663, *[2434, 1757, 2433, 1755], 1)
    ops.element('FourNodeTetrahedron', 7664, *[2135, 2436, 2133, 2435], 1)
    ops.element('FourNodeTetrahedron', 7665, *[2315, 2316, 2074, 2071], 1)
    ops.element('FourNodeTetrahedron', 7666, *[1772, 2363, 1773, 2364], 1)
    ops.element('FourNodeTetrahedron', 7667, *[2182, 2230, 2437, 2228], 1)
    ops.element('FourNodeTetrahedron', 7668, *[2238, 2237, 1150, 2438], 1)
    ops.element('FourNodeTetrahedron', 7669, *[2439, 1926, 1928, 1927], 1)
    ops.element('FourNodeTetrahedron', 7670, *[1224, 2133, 1170, 2098], 1)
    ops.element('FourNodeTetrahedron', 7671, *[2430, 2086, 1839, 1838], 1)
    ops.element('FourNodeTetrahedron', 7672, *[2256, 2257, 2258, 2020], 1)
    ops.element('FourNodeTetrahedron', 7673, *[2440, 1932, 1934, 1933], 1)
    ops.element('FourNodeTetrahedron', 7674, *[2127, 2091, 2125, 2441], 1)
    ops.element('FourNodeTetrahedron', 7675, *[2442, 2067, 2443, 1759], 1)
    ops.element('FourNodeTetrahedron', 7676, *[2444, 1922, 1920, 2377], 1)
    ops.element('FourNodeTetrahedron', 7677, *[1902, 2176, 1901, 1900], 1)
    ops.element('FourNodeTetrahedron', 7678, *[1813, 2141, 2161, 1817], 1)
    ops.element('FourNodeTetrahedron', 7679, *[1947, 2445, 1871, 2156], 1)
    ops.element('FourNodeTetrahedron', 7680, *[1987, 1912, 2446, 1918], 1)
    ops.element('FourNodeTetrahedron', 7681, *[2210, 2447, 2211, 2053], 1)
    ops.element('FourNodeTetrahedron', 7682, *[1912, 2393, 2448, 2322], 1)
    ops.element('FourNodeTetrahedron', 7683, *[1809, 2167, 2134, 2135], 1)
    ops.element('FourNodeTetrahedron', 7684, *[1141, 1809, 1170, 2133], 1)
    ops.element('FourNodeTetrahedron', 7685, *[2114, 1842, 1781, 2449], 1)
    ops.element('FourNodeTetrahedron', 7686, *[2450, 2348, 623, 2451], 1)
    ops.element('FourNodeTetrahedron', 7687, *[2452, 1992, 2453, 1990], 1)
    ops.element('FourNodeTetrahedron', 7688, *[2454, 2353, 2352, 2455], 1)
    ops.element('FourNodeTetrahedron', 7689, *[2164, 2165, 167, 175], 1)
    ops.element('FourNodeTetrahedron', 7690, *[2449, 1842, 1781, 1898], 1)
    ops.element('FourNodeTetrahedron', 7691, *[2444, 2378, 1922, 2377], 1)
    ops.element('FourNodeTetrahedron', 7692, *[2112, 2456, 2059, 2030], 1)
    ops.element('FourNodeTetrahedron', 7693, *[1920, 1922, 1924, 2377], 1)
    ops.element('FourNodeTetrahedron', 7694, *[2457, 2458, 1759, 2459], 1)
    ops.element('FourNodeTetrahedron', 7695, *[2127, 2441, 2125, 2126], 1)
    ops.element('FourNodeTetrahedron', 7696, *[2126, 2441, 2125, 2058], 1)
    ops.element('FourNodeTetrahedron', 7697, *[2125, 2441, 1830, 2058], 1)
    ops.element('FourNodeTetrahedron', 7698, *[2126, 2058, 2125, 2160], 1)
    ops.element('FourNodeTetrahedron', 7699, *[2460, 1945, 1944, 1942], 1)
    ops.element('FourNodeTetrahedron', 7700, *[2013, 1937, 1195, 2349], 1)
    ops.element('FourNodeTetrahedron', 7701, *[2087, 2374, 2461, 2373], 1)
    ops.element('FourNodeTetrahedron', 7702, *[1766, 1986, 1764, 1765], 1)
    ops.element('FourNodeTetrahedron', 7703, *[2013, 2264, 1937, 2349], 1)
    ops.element('FourNodeTetrahedron', 7704, *[1194, 1154, 1195, 2462], 1)
    ops.element('FourNodeTetrahedron', 7705, *[2402, 1851, 1861, 2406], 1)
    ops.element('FourNodeTetrahedron', 7706, *[1937, 2264, 2263, 2349], 1)
    ops.element('FourNodeTetrahedron', 7707, *[2079, 2082, 2151, 2224], 1)
    ops.element('FourNodeTetrahedron', 7708, *[2245, 2243, 2332, 2001], 1)
    ops.element('FourNodeTetrahedron', 7709, *[2245, 2244, 2243, 2001], 1)
    ops.element('FourNodeTetrahedron', 7710, *[2463, 1173, 731, 1151], 1)
    ops.element('FourNodeTetrahedron', 7711, *[1809, 2134, 1157, 1170], 1)
    ops.element('FourNodeTetrahedron', 7712, *[1860, 1930, 1975, 2307], 1)
    ops.element('FourNodeTetrahedron', 7713, *[1134, 1780, 1781, 2236], 1)
    ops.element('FourNodeTetrahedron', 7714, *[2147, 2145, 1202, 1123], 1)
    ops.element('FourNodeTetrahedron', 7715, *[1829, 2110, 1832, 2464], 1)
    ops.element('FourNodeTetrahedron', 7716, *[2465, 2197, 2336, 2196], 1)
    ops.element('FourNodeTetrahedron', 7717, *[2466, 2063, 2239, 2194], 1)
    ops.element('FourNodeTetrahedron', 7718, *[1232, 2467, 1891, 1172], 1)
    ops.element('FourNodeTetrahedron', 7719, *[2185, 2468, 2184, 2416], 1)
    ops.element('FourNodeTetrahedron', 7720, *[1805, 2471, 2470, 2469], 1)
    ops.element('FourNodeTetrahedron', 7721, *[1939, 1985, 2472, 1961], 1)
    ops.element('FourNodeTetrahedron', 7722, *[752, 2473, 2047, 1808], 1)
    ops.element('FourNodeTetrahedron', 7723, *[1870, 1869, 2078, 1867], 1)
    ops.element('FourNodeTetrahedron', 7724, *[1832, 1846, 2110, 1829], 1)
    ops.element('FourNodeTetrahedron', 7725, *[2121, 1840, 2193, 2124], 1)
    ops.element('FourNodeTetrahedron', 7726, *[2010, 2193, 2474, 2371], 1)
    ops.element('FourNodeTetrahedron', 7727, *[2371, 1840, 2193, 2474], 1)
    ops.element('FourNodeTetrahedron', 7728, *[1798, 2247, 2149, 1937], 1)
    ops.element('FourNodeTetrahedron', 7729, *[2124, 1840, 2193, 2371], 1)
    ops.element('FourNodeTetrahedron', 7730, *[2194, 2193, 2371, 2124], 1)
    ops.element('FourNodeTetrahedron', 7731, *[2047, 2179, 2178, 2475], 1)
    ops.element('FourNodeTetrahedron', 7732, *[1189, 2068, 1200, 1201], 1)
    ops.element('FourNodeTetrahedron', 7733, *[2427, 2476, 2428, 2185], 1)
    ops.element('FourNodeTetrahedron', 7734, *[1947, 2445, 2277, 1871], 1)
    ops.element('FourNodeTetrahedron', 7735, *[2230, 2437, 2228, 2400], 1)
    ops.element('FourNodeTetrahedron', 7736, *[2328, 2477, 2042, 2092], 1)
    ops.element('FourNodeTetrahedron', 7737, *[2393, 2277, 2322, 1946], 1)
    ops.element('FourNodeTetrahedron', 7738, *[2357, 2338, 2479, 2478], 1)
    ops.element('FourNodeTetrahedron', 7739, *[2329, 2477, 2330, 2328], 1)
    ops.element('FourNodeTetrahedron', 7740, *[1821, 2070, 1200, 2068], 1)
    ops.element('FourNodeTetrahedron', 7741, *[2244, 2481, 2248, 2480], 1)
    ops.element('FourNodeTetrahedron', 7742, *[2317, 2341, 2002, 2282], 1)
    ops.element('FourNodeTetrahedron', 7743, *[2317, 2341, 2282, 2326], 1)
    ops.element('FourNodeTetrahedron', 7744, *[1934, 1830, 2482, 2440], 1)
    ops.element('FourNodeTetrahedron', 7745, *[1973, 2485, 2484, 2483], 1)
    ops.element('FourNodeTetrahedron', 7746, *[1973, 2485, 2483, 2008], 1)
    ops.element('FourNodeTetrahedron', 7747, *[1820, 2320, 1818, 2115], 1)
    ops.element('FourNodeTetrahedron', 7748, *[1973, 2309, 2484, 2485], 1)
    ops.element('FourNodeTetrahedron', 7749, *[2487, 2486, 2035, 1970], 1)
    ops.element('FourNodeTetrahedron', 7750, *[2446, 2448, 2390, 1912], 1)
    ops.element('FourNodeTetrahedron', 7751, *[1213, 1760, 749, 1153], 1)
    ops.element('FourNodeTetrahedron', 7752, *[2300, 2488, 2411, 2302], 1)
    ops.element('FourNodeTetrahedron', 7753, *[2489, 2490, 2312, 2491], 1)
    ops.element('FourNodeTetrahedron', 7754, *[2222, 2221, 1973, 2008], 1)
    ops.element('FourNodeTetrahedron', 7755, *[1172, 1892, 1140, 1249], 1)
    ops.element('FourNodeTetrahedron', 7756, *[2239, 2194, 2242, 2492], 1)
    ops.element('FourNodeTetrahedron', 7757, *[2493, 2221, 2494, 2241], 1)
    ops.element('FourNodeTetrahedron', 7758, *[2479, 2170, 1158, 2495], 1)
    ops.element('FourNodeTetrahedron', 7759, *[2466, 2239, 2492, 2194], 1)
    ops.element('FourNodeTetrahedron', 7760, *[2412, 2496, 2497, 2411], 1)
    ops.element('FourNodeTetrahedron', 7761, *[1928, 1884, 1941, 1784], 1)
    ops.element('FourNodeTetrahedron', 7762, *[2314, 2028, 2029, 2030], 1)
    ops.element('FourNodeTetrahedron', 7763, *[1986, 1857, 2498, 2301], 1)
    ops.element('FourNodeTetrahedron', 7764, *[2500, 2253, 2274, 2499], 1)
    ops.element('FourNodeTetrahedron', 7765, *[2051, 2227, 2225, 2226], 1)
    ops.element('FourNodeTetrahedron', 7766, *[2465, 2196, 2251, 2215], 1)
    ops.element('FourNodeTetrahedron', 7767, *[2070, 1151, 1199, 1136], 1)
    ops.element('FourNodeTetrahedron', 7768, *[2501, 2502, 2169, 2453], 1)
    ops.element('FourNodeTetrahedron', 7769, *[2104, 1825, 1189, 1227], 1)
    ops.element('FourNodeTetrahedron', 7770, *[2104, 1828, 1825, 1799], 1)
    ops.element('FourNodeTetrahedron', 7771, *[2104, 1827, 1825, 1828], 1)
    ops.element('FourNodeTetrahedron', 7772, *[2503, 1828, 2104, 1799], 1)
    ops.element('FourNodeTetrahedron', 7773, *[2503, 1827, 2104, 1828], 1)
    ops.element('FourNodeTetrahedron', 7774, *[2504, 2105, 2475, 2106], 1)
    ops.element('FourNodeTetrahedron', 7775, *[2319, 2421, 2409, 2147], 1)
    ops.element('FourNodeTetrahedron', 7776, *[1186, 2505, 1188, 1797], 1)
    ops.element('FourNodeTetrahedron', 7777, *[2233, 1900, 1902, 1838], 1)
    ops.element('FourNodeTetrahedron', 7778, *[1942, 1943, 1182, 2225], 1)
    ops.element('FourNodeTetrahedron', 7779, *[2155, 2060, 2506, 2466], 1)
    ops.element('FourNodeTetrahedron', 7780, *[2352, 2391, 1998, 2408], 1)
    ops.element('FourNodeTetrahedron', 7781, *[2350, 2302, 2451, 2507], 1)
    ops.element('FourNodeTetrahedron', 7782, *[1137, 2225, 1182, 1152], 1)
    ops.element('FourNodeTetrahedron', 7783, *[2508, 2502, 2501, 2453], 1)
    ops.element('FourNodeTetrahedron', 7784, *[2509, 1920, 2301, 2510], 1)
    ops.element('FourNodeTetrahedron', 7785, *[2031, 2032, 1816, 2034], 1)
    ops.element('FourNodeTetrahedron', 7786, *[2352, 1998, 2463, 2408], 1)
    ops.element('FourNodeTetrahedron', 7787, *[1137, 1942, 1182, 2225], 1)
    ops.element('FourNodeTetrahedron', 7788, *[2512, 1764, 2513, 2511], 1)
    ops.element('FourNodeTetrahedron', 7789, *[2356, 2514, 2221, 2192], 1)
    ops.element('FourNodeTetrahedron', 7790, *[2358, 2114, 2236, 1844], 1)
    ops.element('FourNodeTetrahedron', 7791, *[1197, 1776, 1198, 1187], 1)
    ops.element('FourNodeTetrahedron', 7792, *[2236, 1898, 1781, 1246], 1)
    ops.element('FourNodeTetrahedron', 7793, *[2076, 2003, 2515, 2245], 1)
    ops.element('FourNodeTetrahedron', 7794, *[2132, 2515, 1868, 2076], 1)
    ops.element('FourNodeTetrahedron', 7795, *[2235, 2182, 2228, 1835], 1)
    ops.element('FourNodeTetrahedron', 7796, *[2404, 1231, 1205, 1138], 1)
    ops.element('FourNodeTetrahedron', 7797, *[2240, 2493, 2325, 2516], 1)
    ops.element('FourNodeTetrahedron', 7798, *[2478, 2517, 2479, 2518], 1)
    ops.element('FourNodeTetrahedron', 7799, *[2079, 2519, 2324, 2223], 1)
    ops.element('FourNodeTetrahedron', 7800, *[2520, 2090, 2167, 2088], 1)
    ops.element('FourNodeTetrahedron', 7801, *[2472, 2399, 2521, 1841], 1)
    ops.element('FourNodeTetrahedron', 7802, *[2521, 2399, 1762, 1841], 1)
    ops.element('FourNodeTetrahedron', 7803, *[2523, 2522, 1923, 1915], 1)
    ops.element('FourNodeTetrahedron', 7804, *[1941, 1884, 2524, 1784], 1)
    ops.element('FourNodeTetrahedron', 7805, *[2525, 2152, 2362, 1990], 1)
    ops.element('FourNodeTetrahedron', 7806, *[2457, 1759, 1250, 2266], 1)
    ops.element('FourNodeTetrahedron', 7807, *[1755, 2527, 2112, 2526], 1)
    ops.element('FourNodeTetrahedron', 7808, *[1992, 2152, 2525, 1990], 1)
    ops.element('FourNodeTetrahedron', 7809, *[711, 2401, 712, 1228], 1)
    ops.element('FourNodeTetrahedron', 7810, *[2362, 2152, 2360, 1990], 1)
    ops.element('FourNodeTetrahedron', 7811, *[2496, 2529, 2528, 2497], 1)
    ops.element('FourNodeTetrahedron', 7812, *[2458, 2067, 1759, 2459], 1)
    ops.element('FourNodeTetrahedron', 7813, *[2528, 2402, 1135, 2405], 1)
    ops.element('FourNodeTetrahedron', 7814, *[1925, 2093, 2095, 2155], 1)
    ops.element('FourNodeTetrahedron', 7815, *[2076, 2002, 2004, 2152], 1)
    ops.element('FourNodeTetrahedron', 7816, *[1790, 2286, 1890, 2176], 1)
    ops.element('FourNodeTetrahedron', 7817, *[1949, 1935, 2229, 2120], 1)
    ops.element('FourNodeTetrahedron', 7818, *[2074, 2071, 2316, 1869], 1)
    ops.element('FourNodeTetrahedron', 7819, *[2526, 1995, 2309, 2103], 1)
    ops.element('FourNodeTetrahedron', 7820, *[2408, 2260, 1750, 2261], 1)
    ops.element('FourNodeTetrahedron', 7821, *[2530, 2158, 2168, 2157], 1)
    ops.element('FourNodeTetrahedron', 7822, *[2408, 2391, 2260, 1750], 1)
    ops.element('FourNodeTetrahedron', 7823, *[1869, 2016, 2078, 1867], 1)
    ops.element('FourNodeTetrahedron', 7824, *[2080, 2081, 2531, 2151], 1)
    ops.element('FourNodeTetrahedron', 7825, *[1941, 2524, 1961, 1784], 1)
    ops.element('FourNodeTetrahedron', 7826, *[2532, 1748, 2081, 2080], 1)
    ops.element('FourNodeTetrahedron', 7827, *[2248, 1958, 1771, 2153], 1)
    ops.element('FourNodeTetrahedron', 7828, *[2533, 2248, 2321, 2153], 1)
    ops.element('FourNodeTetrahedron', 7829, *[2153, 1958, 2057, 2274], 1)
    ops.element('FourNodeTetrahedron', 7830, *[2210, 2534, 2211, 2535], 1)
    ops.element('FourNodeTetrahedron', 7831, *[2070, 2352, 2463, 2408], 1)
    ops.element('FourNodeTetrahedron', 7832, *[2493, 2536, 2526, 2356], 1)
    ops.element('FourNodeTetrahedron', 7833, *[1245, 2443, 1133, 2442], 1)
    ops.element('FourNodeTetrahedron', 7834, *[1255, 1811, 1224, 2537], 1)
    ops.element('FourNodeTetrahedron', 7835, *[2298, 1164, 1225, 2256], 1)
    ops.element('FourNodeTetrahedron', 7836, *[2231, 2176, 1902, 2232], 1)
    ops.element('FourNodeTetrahedron', 7837, *[2231, 1962, 2175, 2232], 1)
    ops.element('FourNodeTetrahedron', 7838, *[1228, 2401, 712, 1809], 1)
    ops.element('FourNodeTetrahedron', 7839, *[2332, 2533, 1849, 2385], 1)
    ops.element('FourNodeTetrahedron', 7840, *[1162, 1808, 752, 1143], 1)
    ops.element('FourNodeTetrahedron', 7841, *[2027, 2440, 2026, 2168], 1)
    ops.element('FourNodeTetrahedron', 7842, *[1856, 2173, 2538, 2388], 1)
    ops.element('FourNodeTetrahedron', 7843, *[2539, 2540, 2336, 2541], 1)
    ops.element('FourNodeTetrahedron', 7844, *[2410, 2411, 2542, 2543], 1)
    ops.element('FourNodeTetrahedron', 7845, *[2079, 2324, 2082, 2223], 1)
    ops.element('FourNodeTetrahedron', 7846, *[1858, 2094, 2544, 2095], 1)
    ops.element('FourNodeTetrahedron', 7847, *[1797, 2268, 2503, 2267], 1)
    ops.element('FourNodeTetrahedron', 7848, *[2328, 2039, 2108, 1832], 1)
    ops.element('FourNodeTetrahedron', 7849, *[2030, 2423, 1822, 1823], 1)
    ops.element('FourNodeTetrahedron', 7850, *[2106, 2443, 1133, 2442], 1)
    ops.element('FourNodeTetrahedron', 7851, *[2323, 2545, 2324, 2519], 1)
    ops.element('FourNodeTetrahedron', 7852, *[2519, 2545, 2324, 2223], 1)
    ops.element('FourNodeTetrahedron', 7853, *[2546, 2089, 2090, 2088], 1)
    ops.element('FourNodeTetrahedron', 7854, *[2323, 2547, 2545, 2519], 1)
    ops.element('FourNodeTetrahedron', 7855, *[2519, 2547, 2545, 2548], 1)
    ops.element('FourNodeTetrahedron', 7856, *[2519, 2545, 1794, 2548], 1)
    ops.element('FourNodeTetrahedron', 7857, *[2519, 2548, 1794, 2344], 1)
    ops.element('FourNodeTetrahedron', 7858, *[2342, 2547, 2519, 2548], 1)
    ops.element('FourNodeTetrahedron', 7859, *[1922, 1924, 1921, 1920], 1)
    ops.element('FourNodeTetrahedron', 7860, *[2078, 2016, 2019, 1867], 1)
    ops.element('FourNodeTetrahedron', 7861, *[2342, 2548, 2519, 2344], 1)
    ops.element('FourNodeTetrahedron', 7862, *[1155, 2204, 2202, 606], 1)
    ops.element('FourNodeTetrahedron', 7863, *[1967, 2423, 2030, 1823], 1)
    ops.element('FourNodeTetrahedron', 7864, *[2519, 2545, 2223, 1794], 1)
    ops.element('FourNodeTetrahedron', 7865, *[2502, 2140, 2413, 1992], 1)
    ops.element('FourNodeTetrahedron', 7866, *[2223, 2549, 2224, 2296], 1)
    ops.element('FourNodeTetrahedron', 7867, *[2551, 2550, 2416, 2552], 1)
    ops.element('FourNodeTetrahedron', 7868, *[2519, 1794, 2223, 2344], 1)
    ops.element('FourNodeTetrahedron', 7869, *[2553, 2547, 2519, 2342], 1)
    ops.element('FourNodeTetrahedron', 7870, *[2553, 2547, 2323, 2519], 1)
    ops.element('FourNodeTetrahedron', 7871, *[2445, 1874, 1871, 2156], 1)
    ops.element('FourNodeTetrahedron', 7872, *[2139, 2519, 2223, 2344], 1)
    ops.element('FourNodeTetrahedron', 7873, *[2055, 2037, 1746, 1747], 1)
    ops.element('FourNodeTetrahedron', 7874, *[2370, 2010, 2523, 2474], 1)
    ops.element('FourNodeTetrahedron', 7875, *[2055, 2035, 2037, 1747], 1)
    ops.element('FourNodeTetrahedron', 7876, *[2055, 2038, 2037, 2035], 1)
    ops.element('FourNodeTetrahedron', 7877, *[1937, 2149, 2263, 2264], 1)
    ops.element('FourNodeTetrahedron', 7878, *[1221, 1955, 1953, 2073], 1)
    ops.element('FourNodeTetrahedron', 7879, *[623, 2348, 1196, 611], 1)
    ops.element('FourNodeTetrahedron', 7880, *[1252, 2228, 711, 1210], 1)
    ops.element('FourNodeTetrahedron', 7881, *[2019, 2321, 2395, 2308], 1)
    ops.element('FourNodeTetrahedron', 7882, *[1760, 2554, 750, 1153], 1)
    ops.element('FourNodeTetrahedron', 7883, *[2411, 2542, 2497, 2410], 1)
    ops.element('FourNodeTetrahedron', 7884, *[2192, 2555, 2193, 2121], 1)
    ops.element('FourNodeTetrahedron', 7885, *[1980, 1785, 1981, 2532], 1)
    ops.element('FourNodeTetrahedron', 7886, *[2144, 1854, 2145, 2402], 1)
    ops.element('FourNodeTetrahedron', 7887, *[2204, 2007, 1859, 2202], 1)
    ops.element('FourNodeTetrahedron', 7888, *[1207, 1882, 751, 1162], 1)
    ops.element('FourNodeTetrahedron', 7889, *[1182, 2556, 1131, 1194], 1)
    ops.element('FourNodeTetrahedron', 7890, *[2498, 2529, 2496, 2411], 1)
    ops.element('FourNodeTetrahedron', 7891, *[2163, 1815, 1813, 1814], 1)
    ops.element('FourNodeTetrahedron', 7892, *[2151, 2002, 2075, 2152], 1)
    ops.element('FourNodeTetrahedron', 7893, *[1882, 2557, 1808, 1881], 1)
    ops.element('FourNodeTetrahedron', 7894, *[1805, 2276, 2427, 1807], 1)
    ops.element('FourNodeTetrahedron', 7895, *[2491, 2312, 2310, 1800], 1)
    ops.element('FourNodeTetrahedron', 7896, *[2491, 2312, 1772, 2310], 1)
    ops.element('FourNodeTetrahedron', 7897, *[2301, 2411, 2350, 2302], 1)
    ops.element('FourNodeTetrahedron', 7898, *[1766, 1782, 1764, 1986], 1)
    ops.element('FourNodeTetrahedron', 7899, *[2558, 2203, 2204, 2492], 1)
    ops.element('FourNodeTetrahedron', 7900, *[2307, 2309, 2306, 1973], 1)
    ops.element('FourNodeTetrahedron', 7901, *[2560, 2501, 2170, 2559], 1)
    ops.element('FourNodeTetrahedron', 7902, *[2393, 2276, 1807, 2277], 1)
    ops.element('FourNodeTetrahedron', 7903, *[1146, 2368, 1257, 684], 1)
    ops.element('FourNodeTetrahedron', 7904, *[2518, 2561, 2517, 2478], 1)
    ops.element('FourNodeTetrahedron', 7905, *[606, 2204, 2202, 2558], 1)
    ops.element('FourNodeTetrahedron', 7906, *[1133, 1779, 1197, 1187], 1)
    ops.element('FourNodeTetrahedron', 7907, *[1930, 2283, 2284, 1996], 1)
    ops.element('FourNodeTetrahedron', 7908, *[1825, 2147, 1201, 1123], 1)
    ops.element('FourNodeTetrahedron', 7909, *[2168, 2027, 2125, 2158], 1)
    ops.element('FourNodeTetrahedron', 7910, *[1860, 2562, 1130, 1975], 1)
    ops.element('FourNodeTetrahedron', 7911, *[2238, 2171, 512, 2479], 1)
    ops.element('FourNodeTetrahedron', 7912, *[1125, 2563, 1177, 1176], 1)
    ops.element('FourNodeTetrahedron', 7913, *[1868, 2016, 1867, 2245], 1)
    ops.element('FourNodeTetrahedron', 7914, *[1899, 1900, 1951, 2564], 1)
    ops.element('FourNodeTetrahedron', 7915, *[2565, 1963, 2231, 1964], 1)
    ops.element('FourNodeTetrahedron', 7916, *[2412, 2411, 2497, 2410], 1)
    ops.element('FourNodeTetrahedron', 7917, *[2338, 1969, 2138, 2339], 1)
    ops.element('FourNodeTetrahedron', 7918, *[2156, 2155, 1948, 2206], 1)
    ops.element('FourNodeTetrahedron', 7919, *[2310, 2364, 1833, 2220], 1)
    ops.element('FourNodeTetrahedron', 7920, *[2445, 1874, 1871, 1873], 1)
    ops.element('FourNodeTetrahedron', 7921, *[2120, 1810, 1211, 1811], 1)
    ops.element('FourNodeTetrahedron', 7922, *[2273, 1963, 2272, 2565], 1)
    ops.element('FourNodeTetrahedron', 7923, *[2340, 1970, 2339, 2189], 1)
    ops.element('FourNodeTetrahedron', 7924, *[1875, 2567, 1788, 2566], 1)
    ops.element('FourNodeTetrahedron', 7925, *[1987, 2345, 1857, 1918], 1)
    ops.element('FourNodeTetrahedron', 7926, *[2073, 2074, 1223, 2072], 1)
    ops.element('FourNodeTetrahedron', 7927, *[2527, 1823, 2103, 2097], 1)
    ops.element('FourNodeTetrahedron', 7928, *[2027, 2127, 2091, 2125], 1)
    ops.element('FourNodeTetrahedron', 7929, *[2228, 2400, 711, 2568], 1)
    ops.element('FourNodeTetrahedron', 7930, *[2002, 2432, 2001, 2279], 1)
    ops.element('FourNodeTetrahedron', 7931, *[2539, 2336, 2098, 2465], 1)
    ops.element('FourNodeTetrahedron', 7932, *[2331, 2092, 2328, 1832], 1)
    ops.element('FourNodeTetrahedron', 7933, *[2096, 2097, 2536, 2294], 1)
    ops.element('FourNodeTetrahedron', 7934, *[2416, 2414, 1964, 2569], 1)
    ops.element('FourNodeTetrahedron', 7935, *[2055, 2035, 1747, 2570], 1)
    ops.element('FourNodeTetrahedron', 7936, *[2542, 2204, 1155, 606], 1)
    ops.element('FourNodeTetrahedron', 7937, *[1808, 2047, 1143, 2046], 1)
    ops.element('FourNodeTetrahedron', 7938, *[1905, 1821, 1144, 1230], 1)
    ops.element('FourNodeTetrahedron', 7939, *[2558, 2204, 2202, 2203], 1)
    ops.element('FourNodeTetrahedron', 7940, *[2571, 2521, 1780, 2114], 1)
    ops.element('FourNodeTetrahedron', 7941, *[723, 2235, 728, 1147], 1)
    ops.element('FourNodeTetrahedron', 7942, *[2140, 2079, 2379, 2139], 1)
    ops.element('FourNodeTetrahedron', 7943, *[2114, 1781, 1780, 2236], 1)
    ops.element('FourNodeTetrahedron', 7944, *[2114, 1762, 1781, 1842], 1)
    ops.element('FourNodeTetrahedron', 7945, *[2114, 1762, 1780, 1781], 1)
    ops.element('FourNodeTetrahedron', 7946, *[2235, 1252, 728, 1147], 1)
    ops.element('FourNodeTetrahedron', 7947, *[1158, 2572, 2170, 2573], 1)
    ops.element('FourNodeTetrahedron', 7948, *[1749, 2553, 2323, 1972], 1)
    ops.element('FourNodeTetrahedron', 7949, *[2015, 2247, 1937, 2264], 1)
    ops.element('FourNodeTetrahedron', 7950, *[2094, 2390, 2389, 2061], 1)
    ops.element('FourNodeTetrahedron', 7951, *[2560, 2169, 2170, 2501], 1)
    ops.element('FourNodeTetrahedron', 7952, *[2464, 2376, 2375, 2059], 1)
    ops.element('FourNodeTetrahedron', 7953, *[1232, 2467, 1172, 551], 1)
    ops.element('FourNodeTetrahedron', 7954, *[2484, 2541, 2465, 2199], 1)
    ops.element('FourNodeTetrahedron', 7955, *[1898, 1955, 1952, 1221], 1)
    ops.element('FourNodeTetrahedron', 7956, *[1959, 2534, 2574, 2211], 1)
    ops.element('FourNodeTetrahedron', 7957, *[2272, 2231, 2174, 2086], 1)
    ops.element('FourNodeTetrahedron', 7958, *[2534, 2574, 2211, 2535], 1)
    ops.element('FourNodeTetrahedron', 7959, *[1190, 2251, 2216, 2064], 1)
    ops.element('FourNodeTetrahedron', 7960, *[1959, 2574, 1887, 2211], 1)
    ops.element('FourNodeTetrahedron', 7961, *[2083, 2308, 1212, 2084], 1)
    ops.element('FourNodeTetrahedron', 7962, *[1910, 2575, 1946, 1947], 1)
    ops.element('FourNodeTetrahedron', 7963, *[1866, 1952, 1129, 1898], 1)
    ops.element('FourNodeTetrahedron', 7964, *[2266, 2066, 2065, 1942], 1)
    ops.element('FourNodeTetrahedron', 7965, *[1898, 1952, 1129, 1221], 1)
    ops.element('FourNodeTetrahedron', 7966, *[2053, 2211, 2290, 2447], 1)
    ops.element('FourNodeTetrahedron', 7967, *[2447, 2535, 2211, 2293], 1)
    ops.element('FourNodeTetrahedron', 7968, *[2211, 2293, 2290, 2447], 1)
    ops.element('FourNodeTetrahedron', 7969, *[2535, 2576, 2211, 2293], 1)
    ops.element('FourNodeTetrahedron', 7970, *[2211, 2293, 2292, 2290], 1)
    ops.element('FourNodeTetrahedron', 7971, *[2211, 2576, 2292, 2293], 1)
    ops.element('FourNodeTetrahedron', 7972, *[2085, 1899, 2334, 1916], 1)
    ops.element('FourNodeTetrahedron', 7973, *[2578, 2577, 2531, 2150], 1)
    ops.element('FourNodeTetrahedron', 7974, *[2148, 2144, 2142, 2579], 1)
    ops.element('FourNodeTetrahedron', 7975, *[2580, 2581, 2273, 2415], 1)
    ops.element('FourNodeTetrahedron', 7976, *[2580, 2581, 1876, 2273], 1)
    ops.element('FourNodeTetrahedron', 7977, *[2273, 2581, 1876, 1963], 1)
    ops.element('FourNodeTetrahedron', 7978, *[1929, 1787, 1980, 2055], 1)
    ops.element('FourNodeTetrahedron', 7979, *[1173, 1997, 723, 1242], 1)
    ops.element('FourNodeTetrahedron', 7980, *[1946, 2277, 2322, 2186], 1)
    ops.element('FourNodeTetrahedron', 7981, *[1968, 1876, 1878, 2273], 1)
    ops.element('FourNodeTetrahedron', 7982, *[2192, 2555, 2008, 2193], 1)
    ops.element('FourNodeTetrahedron', 7983, *[1968, 2580, 1876, 2273], 1)
    ops.element('FourNodeTetrahedron', 7984, *[2304, 2582, 2463, 1998], 1)
    ops.element('FourNodeTetrahedron', 7985, *[1876, 2567, 1877, 1875], 1)
    ops.element('FourNodeTetrahedron', 7986, *[2444, 2584, 2583, 2291], 1)
    ops.element('FourNodeTetrahedron', 7987, *[2146, 2145, 2144, 1854], 1)
    ops.element('FourNodeTetrahedron', 7988, *[2431, 2500, 2403, 2499], 1)
    ops.element('FourNodeTetrahedron', 7989, *[1886, 1888, 1765, 1920], 1)
    ops.element('FourNodeTetrahedron', 7990, *[1886, 1920, 1765, 2509], 1)
    ops.element('FourNodeTetrahedron', 7991, *[2292, 1920, 1886, 2509], 1)
    ops.element('FourNodeTetrahedron', 7992, *[1763, 2585, 2554, 1904], 1)
    ops.element('FourNodeTetrahedron', 7993, *[2301, 2498, 2350, 2411], 1)
    ops.element('FourNodeTetrahedron', 7994, *[2174, 2175, 1790, 2272], 1)
    ops.element('FourNodeTetrahedron', 7995, *[2565, 1964, 2231, 2430], 1)
    ops.element('FourNodeTetrahedron', 7996, *[1993, 1996, 2307, 2309], 1)
    ops.element('FourNodeTetrahedron', 7997, *[2024, 2586, 2023, 2022], 1)
    ops.element('FourNodeTetrahedron', 7998, *[2358, 1844, 2236, 2237], 1)
    ops.element('FourNodeTetrahedron', 7999, *[1828, 1826, 2143, 2148], 1)
    ops.element('FourNodeTetrahedron', 8000, *[1875, 2175, 1790, 2272], 1)
    ops.element('FourNodeTetrahedron', 8001, *[2163, 1813, 2161, 1814], 1)
    ops.element('FourNodeTetrahedron', 8002, *[1870, 1867, 2078, 2083], 1)
    ops.element('FourNodeTetrahedron', 8003, *[2187, 1970, 2189, 2387], 1)
    ops.element('FourNodeTetrahedron', 8004, *[2487, 2486, 1970, 2187], 1)
    ops.element('FourNodeTetrahedron', 8005, *[2570, 2187, 1970, 2188], 1)
    ops.element('FourNodeTetrahedron', 8006, *[2570, 2188, 2340, 2478], 1)
    ops.element('FourNodeTetrahedron', 8007, *[2570, 1970, 2340, 2188], 1)
    ops.element('FourNodeTetrahedron', 8008, *[1825, 2147, 1123, 2144], 1)
    ops.element('FourNodeTetrahedron', 8009, *[2570, 2487, 1970, 2187], 1)
    ops.element('FourNodeTetrahedron', 8010, *[2486, 1972, 1747, 1970], 1)
    ops.element('FourNodeTetrahedron', 8011, *[2386, 2587, 2342, 2343], 1)
    ops.element('FourNodeTetrahedron', 8012, *[1832, 2351, 2111, 2588], 1)
    ops.element('FourNodeTetrahedron', 8013, *[2328, 2108, 2111, 1832], 1)
    ops.element('FourNodeTetrahedron', 8014, *[2544, 2241, 2240, 2239], 1)
    ops.element('FourNodeTetrahedron', 8015, *[1126, 2072, 1236, 1978], 1)
    ops.element('FourNodeTetrahedron', 8016, *[1969, 1747, 1972, 1970], 1)
    ops.element('FourNodeTetrahedron', 8017, *[2570, 2487, 2035, 1970], 1)
    ops.element('FourNodeTetrahedron', 8018, *[2035, 2486, 1747, 1970], 1)
    ops.element('FourNodeTetrahedron', 8019, *[2570, 1747, 2340, 1970], 1)
    ops.element('FourNodeTetrahedron', 8020, *[1779, 1778, 1197, 1776], 1)
    ops.element('FourNodeTetrahedron', 8021, *[2059, 1846, 2376, 2313], 1)
    ops.element('FourNodeTetrahedron', 8022, *[2340, 1747, 1969, 1970], 1)
    ops.element('FourNodeTetrahedron', 8023, *[2465, 2250, 2251, 2196], 1)
    ops.element('FourNodeTetrahedron', 8024, *[2036, 2553, 1972, 2486], 1)
    ops.element('FourNodeTetrahedron', 8025, *[2101, 1863, 2589, 2100], 1)
    ops.element('FourNodeTetrahedron', 8026, *[2479, 2590, 2591, 2518], 1)
    ops.element('FourNodeTetrahedron', 8027, *[2269, 2271, 1989, 1991], 1)
    ops.element('FourNodeTetrahedron', 8028, *[2193, 1917, 2522, 2474], 1)
    ops.element('FourNodeTetrahedron', 8029, *[2014, 2012, 2013, 2592], 1)
    ops.element('FourNodeTetrahedron', 8030, *[2209, 2012, 2014, 2592], 1)
    ops.element('FourNodeTetrahedron', 8031, *[2142, 1895, 2402, 2528], 1)
    ops.element('FourNodeTetrahedron', 8032, *[1871, 2593, 2185, 1873], 1)
    ops.element('FourNodeTetrahedron', 8033, *[2065, 1944, 1797, 1943], 1)
    ops.element('FourNodeTetrahedron', 8034, *[2225, 2556, 2594, 2226], 1)
    ops.element('FourNodeTetrahedron', 8035, *[2277, 2476, 2185, 2593], 1)
    ops.element('FourNodeTetrahedron', 8036, *[2595, 2442, 1241, 2457], 1)
    ops.element('FourNodeTetrahedron', 8037, *[1948, 1946, 2186, 1871], 1)
    ops.element('FourNodeTetrahedron', 8038, *[2596, 2531, 2578, 2577], 1)
    ops.element('FourNodeTetrahedron', 8039, *[2486, 2553, 1972, 2597], 1)
    ops.element('FourNodeTetrahedron', 8040, *[551, 2467, 1172, 2598], 1)
    ops.element('FourNodeTetrahedron', 8041, *[2467, 1892, 1172, 2598], 1)
    ops.element('FourNodeTetrahedron', 8042, *[2295, 2114, 2571, 2396], 1)
    ops.element('FourNodeTetrahedron', 8043, *[1247, 2009, 1124, 1164], 1)
    ops.element('FourNodeTetrahedron', 8044, *[2556, 2013, 1131, 1194], 1)
    ops.element('FourNodeTetrahedron', 8045, *[2467, 1891, 1892, 1172], 1)
    ops.element('FourNodeTetrahedron', 8046, *[738, 2599, 739, 2380], 1)
    ops.element('FourNodeTetrahedron', 8047, *[738, 2136, 2599, 2380], 1)
    ops.element('FourNodeTetrahedron', 8048, *[2011, 2380, 738, 1144], 1)
    ops.element('FourNodeTetrahedron', 8049, *[2011, 2380, 1144, 1905], 1)
    ops.element('FourNodeTetrahedron', 8050, *[2408, 2391, 1998, 1750], 1)
    ops.element('FourNodeTetrahedron', 8051, *[1136, 2408, 1151, 1206], 1)
    ops.element('FourNodeTetrahedron', 8052, *[2408, 1998, 1151, 1206], 1)
    ops.element('FourNodeTetrahedron', 8053, *[2116, 2589, 2540, 2541], 1)
    ops.element('FourNodeTetrahedron', 8054, *[2408, 1750, 1998, 1206], 1)
    ops.element('FourNodeTetrahedron', 8055, *[1998, 1834, 1242, 1750], 1)
    ops.element('FourNodeTetrahedron', 8056, *[2319, 2408, 2068, 2147], 1)
    ops.element('FourNodeTetrahedron', 8057, *[2069, 2408, 2068, 2319], 1)
    ops.element('FourNodeTetrahedron', 8058, *[1955, 2315, 1953, 2073], 1)
    ops.element('FourNodeTetrahedron', 8059, *[2069, 2600, 2408, 2319], 1)
    ops.element('FourNodeTetrahedron', 8060, *[2518, 2590, 2591, 2561], 1)
    ops.element('FourNodeTetrahedron', 8061, *[1963, 2601, 2566, 1962], 1)
    ops.element('FourNodeTetrahedron', 8062, *[2162, 1814, 2161, 1884], 1)
    ops.element('FourNodeTetrahedron', 8063, *[1963, 2175, 2231, 1962], 1)
    ops.element('FourNodeTetrahedron', 8064, *[2463, 1997, 731, 1173], 1)
    ops.element('FourNodeTetrahedron', 8065, *[2068, 2408, 1206, 2147], 1)
    ops.element('FourNodeTetrahedron', 8066, *[2069, 2354, 2408, 2600], 1)
    ops.element('FourNodeTetrahedron', 8067, *[2455, 2354, 2408, 2069], 1)
    ops.element('FourNodeTetrahedron', 8068, *[1222, 2602, 1126, 2172], 1)
    ops.element('FourNodeTetrahedron', 8069, *[2455, 2408, 2070, 2069], 1)
    ops.element('FourNodeTetrahedron', 8070, *[2011, 1906, 2380, 1905], 1)
    ops.element('FourNodeTetrahedron', 8071, *[1964, 2233, 2231, 2430], 1)
    ops.element('FourNodeTetrahedron', 8072, *[1883, 2226, 2594, 2052], 1)
    ops.element('FourNodeTetrahedron', 8073, *[1921, 1986, 1766, 1765], 1)
    ops.element('FourNodeTetrahedron', 8074, *[2031, 2034, 2603, 2297], 1)
    ops.element('FourNodeTetrahedron', 8075, *[2308, 2533, 2321, 1848], 1)
    ops.element('FourNodeTetrahedron', 8076, *[2025, 2027, 2026, 2168], 1)
    ops.element('FourNodeTetrahedron', 8077, *[2121, 2555, 2193, 1840], 1)
    ops.element('FourNodeTetrahedron', 8078, *[1128, 1819, 1230, 1233], 1)
    ops.element('FourNodeTetrahedron', 8079, *[2602, 2072, 1126, 2172], 1)
    ops.element('FourNodeTetrahedron', 8080, *[2018, 2244, 2017, 2019], 1)
    ops.element('FourNodeTetrahedron', 8081, *[2505, 2104, 1233, 1799], 1)
    ops.element('FourNodeTetrahedron', 8082, *[2199, 2201, 2200, 1950], 1)
    ops.element('FourNodeTetrahedron', 8083, *[1865, 1864, 2541, 2199], 1)
    ops.element('FourNodeTetrahedron', 8084, *[1924, 1908, 1918, 1925], 1)
    ops.element('FourNodeTetrahedron', 8085, *[2541, 1864, 2201, 2199], 1)
    ops.element('FourNodeTetrahedron', 8086, *[2276, 2427, 1807, 2185], 1)
    ops.element('FourNodeTetrahedron', 8087, *[2199, 1862, 1864, 1950], 1)
    ops.element('FourNodeTetrahedron', 8088, *[2199, 1864, 2201, 1950], 1)
    ops.element('FourNodeTetrahedron', 8089, *[2505, 2503, 2104, 1799], 1)
    ops.element('FourNodeTetrahedron', 8090, *[2505, 2503, 1799, 1797], 1)
    ops.element('FourNodeTetrahedron', 8091, *[2441, 1845, 1830, 2058], 1)
    ops.element('FourNodeTetrahedron', 8092, *[2345, 1912, 2390, 2094], 1)
    ops.element('FourNodeTetrahedron', 8093, *[2154, 1768, 2225, 2051], 1)
    ops.element('FourNodeTetrahedron', 8094, *[2266, 2065, 1243, 1185], 1)
    ops.element('FourNodeTetrahedron', 8095, *[2313, 2029, 2101, 1824], 1)
    ops.element('FourNodeTetrahedron', 8096, *[2126, 2441, 2058, 2433], 1)
    ops.element('FourNodeTetrahedron', 8097, *[2160, 2126, 2058, 2433], 1)
    ops.element('FourNodeTetrahedron', 8098, *[2298, 2316, 2419, 2074], 1)
    ops.element('FourNodeTetrahedron', 8099, *[1956, 1957, 1959, 2210], 1)
    ops.element('FourNodeTetrahedron', 8100, *[2086, 2231, 2233, 2430], 1)
    ops.element('FourNodeTetrahedron', 8101, *[2475, 1779, 1133, 2106], 1)
    ops.element('FourNodeTetrahedron', 8102, *[2290, 1886, 2592, 2604], 1)
    ops.element('FourNodeTetrahedron', 8103, *[2604, 2509, 2605, 2510], 1)
    ops.element('FourNodeTetrahedron', 8104, *[2429, 2565, 2086, 2430], 1)
    ops.element('FourNodeTetrahedron', 8105, *[2331, 2111, 2482, 1832], 1)
    ops.element('FourNodeTetrahedron', 8106, *[1803, 2331, 2482, 1832], 1)
    ops.element('FourNodeTetrahedron', 8107, *[2319, 2147, 2068, 1825], 1)
    ops.element('FourNodeTetrahedron', 8108, *[2408, 2409, 1206, 2147], 1)
    ops.element('FourNodeTetrahedron', 8109, *[2429, 2565, 2272, 2086], 1)
    ops.element('FourNodeTetrahedron', 8110, *[1257, 1978, 1236, 1145], 1)
    ops.element('FourNodeTetrahedron', 8111, *[2334, 1950, 1914, 2606], 1)
    ops.element('FourNodeTetrahedron', 8112, *[2429, 2272, 2514, 2086], 1)
    ops.element('FourNodeTetrahedron', 8113, *[2033, 2034, 2031, 2297], 1)
    ops.element('FourNodeTetrahedron', 8114, *[2172, 2369, 1978, 2368], 1)
    ops.element('FourNodeTetrahedron', 8115, *[1193, 2178, 1779, 2475], 1)
    ops.element('FourNodeTetrahedron', 8116, *[2607, 1762, 1988, 1780], 1)
    ops.element('FourNodeTetrahedron', 8117, *[2369, 1977, 1978, 2368], 1)
    ops.element('FourNodeTetrahedron', 8118, *[2509, 2301, 2605, 2510], 1)
    ops.element('FourNodeTetrahedron', 8119, *[2595, 2275, 2608, 2258], 1)
    ops.element('FourNodeTetrahedron', 8120, *[1811, 2133, 1141, 1224], 1)
    ops.element('FourNodeTetrahedron', 8121, *[1795, 2609, 2610, 1850], 1)
    ops.element('FourNodeTetrahedron', 8122, *[2612, 2611, 2430, 2122], 1)
    ops.element('FourNodeTetrahedron', 8123, *[2207, 2212, 1908, 1948], 1)
    ops.element('FourNodeTetrahedron', 8124, *[2172, 2420, 1978, 2369], 1)
    ops.element('FourNodeTetrahedron', 8125, *[2207, 2212, 1948, 2206], 1)
    ops.element('FourNodeTetrahedron', 8126, *[1954, 2049, 2048, 2298], 1)
    ops.element('FourNodeTetrahedron', 8127, *[2205, 1948, 2155, 2206], 1)
    ops.element('FourNodeTetrahedron', 8128, *[1144, 2380, 1174, 1821], 1)
    ops.element('FourNodeTetrahedron', 8129, *[1862, 2262, 1864, 1950], 1)
    ops.element('FourNodeTetrahedron', 8130, *[1826, 2146, 2144, 2148], 1)
    ops.element('FourNodeTetrahedron', 8131, *[1142, 2021, 1171, 1253], 1)
    ops.element('FourNodeTetrahedron', 8132, *[1775, 2613, 2363, 2312], 1)
    ops.element('FourNodeTetrahedron', 8133, *[2368, 666, 1167, 684], 1)
    ops.element('FourNodeTetrahedron', 8134, *[2368, 2614, 1167, 666], 1)
    ops.element('FourNodeTetrahedron', 8135, *[2368, 2118, 2614, 666], 1)
    ops.element('FourNodeTetrahedron', 8136, *[2463, 1998, 1173, 1151], 1)
    ops.element('FourNodeTetrahedron', 8137, *[2403, 2500, 2274, 2499], 1)
    ops.element('FourNodeTetrahedron', 8138, *[2368, 2614, 1257, 1167], 1)
    ops.element('FourNodeTetrahedron', 8139, *[1789, 2289, 2367, 1790], 1)
    ops.element('FourNodeTetrahedron', 8140, *[1911, 2393, 2322, 1946], 1)
    ops.element('FourNodeTetrahedron', 8141, *[1257, 1978, 2614, 2368], 1)
    ops.element('FourNodeTetrahedron', 8142, *[1747, 1748, 1746, 2213], 1)
    ops.element('FourNodeTetrahedron', 8143, *[1814, 2032, 1816, 2031], 1)
    ops.element('FourNodeTetrahedron', 8144, *[2335, 2436, 2099, 2336], 1)
    ops.element('FourNodeTetrahedron', 8145, *[2172, 1978, 1257, 2368], 1)
    ops.element('FourNodeTetrahedron', 8146, *[1978, 1977, 2614, 2368], 1)
    ops.element('FourNodeTetrahedron', 8147, *[2424, 2615, 2312, 1800], 1)
    ops.element('FourNodeTetrahedron', 8148, *[2616, 2562, 1130, 1860], 1)
    ops.element('FourNodeTetrahedron', 8149, *[1204, 2616, 1130, 1860], 1)
    ops.element('FourNodeTetrahedron', 8150, *[2247, 2149, 1937, 2264], 1)
    ops.element('FourNodeTetrahedron', 8151, *[2000, 2588, 2351, 2283], 1)
    ops.element('FourNodeTetrahedron', 8152, *[2617, 1768, 2225, 2154], 1)
    ops.element('FourNodeTetrahedron', 8153, *[1889, 1921, 1766, 1765], 1)
    ops.element('FourNodeTetrahedron', 8154, *[2125, 1932, 2440, 1931], 1)
    ops.element('FourNodeTetrahedron', 8155, *[1964, 1965, 1962, 2618], 1)
    ops.element('FourNodeTetrahedron', 8156, *[2006, 2333, 2619, 2522], 1)
    ops.element('FourNodeTetrahedron', 8157, *[2039, 2041, 2108, 1832], 1)
    ops.element('FourNodeTetrahedron', 8158, *[1964, 2618, 1962, 2620], 1)
    ops.element('FourNodeTetrahedron', 8159, *[2401, 2090, 2166, 2167], 1)
    ops.element('FourNodeTetrahedron', 8160, *[2416, 2565, 2294, 2612], 1)
    ops.element('FourNodeTetrahedron', 8161, *[2203, 2222, 2007, 2010], 1)
    ops.element('FourNodeTetrahedron', 8162, *[2472, 1982, 1984, 1841], 1)
    ops.element('FourNodeTetrahedron', 8163, *[621, 2462, 1194, 622], 1)
    ops.element('FourNodeTetrahedron', 8164, *[2184, 2096, 2621, 2294], 1)
    ops.element('FourNodeTetrahedron', 8165, *[1776, 2365, 2622, 2190], 1)
    ops.element('FourNodeTetrahedron', 8166, *[2479, 1158, 512, 511], 1)
    ops.element('FourNodeTetrahedron', 8167, *[2072, 1870, 1236, 1978], 1)
    ops.element('FourNodeTetrahedron', 8168, *[1959, 2534, 2210, 2211], 1)
    ops.element('FourNodeTetrahedron', 8169, *[2408, 2261, 1750, 2409], 1)
    ops.element('FourNodeTetrahedron', 8170, *[2399, 1984, 2623, 2398], 1)
    ops.element('FourNodeTetrahedron', 8171, *[2138, 1971, 2139, 2624], 1)
    ops.element('FourNodeTetrahedron', 8172, *[2010, 2522, 1892, 2523], 1)
    ops.element('FourNodeTetrahedron', 8173, *[2625, 2534, 2210, 2535], 1)
    ops.element('FourNodeTetrahedron', 8174, *[2385, 2243, 2533, 2626], 1)
    ops.element('FourNodeTetrahedron', 8175, *[2222, 2192, 2008, 2193], 1)
    ops.element('FourNodeTetrahedron', 8176, *[2245, 2243, 2019, 2332], 1)
    ops.element('FourNodeTetrahedron', 8177, *[2568, 2400, 1228, 1810], 1)
    ops.element('FourNodeTetrahedron', 8178, *[2440, 1932, 1933, 1931], 1)
    ops.element('FourNodeTetrahedron', 8179, *[1852, 2440, 1933, 1931], 1)
    ops.element('FourNodeTetrahedron', 8180, *[2327, 2296, 2317, 2326], 1)
    ops.element('FourNodeTetrahedron', 8181, *[2031, 1816, 2603, 2034], 1)
    ops.element('FourNodeTetrahedron', 8182, *[2271, 2224, 1989, 2317], 1)
    ops.element('FourNodeTetrahedron', 8183, *[1989, 2327, 2317, 2318], 1)
    ops.element('FourNodeTetrahedron', 8184, *[2171, 1222, 1150, 1229], 1)
    ops.element('FourNodeTetrahedron', 8185, *[2177, 2586, 741, 2627], 1)
    ops.element('FourNodeTetrahedron', 8186, *[2267, 2247, 1798, 2015], 1)
    ops.element('FourNodeTetrahedron', 8187, *[1989, 2327, 2318, 1991], 1)
    ops.element('FourNodeTetrahedron', 8188, *[1175, 2154, 1137, 1181], 1)
    ops.element('FourNodeTetrahedron', 8189, *[2362, 1754, 1977, 2117], 1)
    ops.element('FourNodeTetrahedron', 8190, *[742, 2627, 741, 1161], 1)
    ops.element('FourNodeTetrahedron', 8191, *[2598, 1923, 1249, 532], 1)
    ops.element('FourNodeTetrahedron', 8192, *[1762, 2399, 1763, 2398], 1)
    ops.element('FourNodeTetrahedron', 8193, *[2121, 2086, 2555, 2085], 1)
    ops.element('FourNodeTetrahedron', 8194, *[2238, 1150, 513, 512], 1)
    ops.element('FourNodeTetrahedron', 8195, *[2381, 2382, 2383, 2130], 1)
    ops.element('FourNodeTetrahedron', 8196, *[2628, 2615, 2629, 2490], 1)
    ops.element('FourNodeTetrahedron', 8197, *[1913, 2073, 1220, 2602], 1)
    ops.element('FourNodeTetrahedron', 8198, *[2630, 2199, 2333, 2334], 1)
    ops.element('FourNodeTetrahedron', 8199, *[2303, 2095, 2506, 2155], 1)
    ops.element('FourNodeTetrahedron', 8200, *[2381, 2631, 2602, 2578], 1)
    ops.element('FourNodeTetrahedron', 8201, *[2242, 2222, 2007, 2203], 1)
    ops.element('FourNodeTetrahedron', 8202, *[2428, 1968, 1758, 2096], 1)
    ops.element('FourNodeTetrahedron', 8203, *[2630, 2334, 2333, 1917], 1)
    ops.element('FourNodeTetrahedron', 8204, *[2025, 2026, 2310, 2107], 1)
    ops.element('FourNodeTetrahedron', 8205, *[2357, 1981, 2438, 2596], 1)
    ops.element('FourNodeTetrahedron', 8206, *[2425, 2025, 2261, 2632], 1)
    ops.element('FourNodeTetrahedron', 8207, *[2154, 2225, 1137, 1181], 1)
    ops.element('FourNodeTetrahedron', 8208, *[1175, 2154, 1181, 2234], 1)
    ops.element('FourNodeTetrahedron', 8209, *[2414, 1965, 1964, 2618], 1)
    ops.element('FourNodeTetrahedron', 8210, *[2030, 1822, 1824, 1823], 1)
    ops.element('FourNodeTetrahedron', 8211, *[2321, 2154, 1175, 2234], 1)
    ops.element('FourNodeTetrahedron', 8212, *[1937, 2263, 2404, 2349], 1)
    ops.element('FourNodeTetrahedron', 8213, *[1937, 2143, 1240, 2404], 1)
    ops.element('FourNodeTetrahedron', 8214, *[1937, 2263, 2143, 2404], 1)
    ops.element('FourNodeTetrahedron', 8215, *[2633, 2331, 2311, 1800], 1)
    ops.element('FourNodeTetrahedron', 8216, *[2143, 2142, 1205, 2404], 1)
    ops.element('FourNodeTetrahedron', 8217, *[1240, 2143, 1205, 2404], 1)
    ops.element('FourNodeTetrahedron', 8218, *[2385, 2533, 1848, 2626], 1)
    ops.element('FourNodeTetrahedron', 8219, *[2143, 2142, 1123, 1205], 1)
    ops.element('FourNodeTetrahedron', 8220, *[2416, 2414, 2273, 1964], 1)
    ops.element('FourNodeTetrahedron', 8221, *[1240, 2404, 1205, 1138], 1)
    ops.element('FourNodeTetrahedron', 8222, *[2560, 2502, 2501, 2590], 1)
    ops.element('FourNodeTetrahedron', 8223, *[1242, 1835, 1147, 1750], 1)
    ops.element('FourNodeTetrahedron', 8224, *[1121, 2419, 1225, 1234], 1)
    ops.element('FourNodeTetrahedron', 8225, *[1121, 2074, 2419, 1234], 1)
    ops.element('FourNodeTetrahedron', 8226, *[1121, 2298, 1225, 2419], 1)
    ops.element('FourNodeTetrahedron', 8227, *[1121, 2298, 2419, 2074], 1)
    ops.element('FourNodeTetrahedron', 8228, *[2526, 2527, 2103, 2097], 1)
    ops.element('FourNodeTetrahedron', 8229, *[2502, 2413, 2577, 1992], 1)
    ops.element('FourNodeTetrahedron', 8230, *[2086, 1902, 2634, 1899], 1)
    ops.element('FourNodeTetrahedron', 8231, *[2473, 2180, 2047, 2179], 1)
    ops.element('FourNodeTetrahedron', 8232, *[1993, 2309, 2307, 2526], 1)
    ops.element('FourNodeTetrahedron', 8233, *[2142, 2402, 1203, 1231], 1)
    ops.element('FourNodeTetrahedron', 8234, *[1775, 2613, 1773, 2363], 1)
    ops.element('FourNodeTetrahedron', 8235, *[1854, 1853, 2145, 2402], 1)
    ops.element('FourNodeTetrahedron', 8236, *[2349, 2404, 1138, 2412], 1)
    ops.element('FourNodeTetrahedron', 8237, *[1943, 2015, 1796, 2556], 1)
    ops.element('FourNodeTetrahedron', 8238, *[2244, 2480, 2248, 2243], 1)
    ops.element('FourNodeTetrahedron', 8239, *[1943, 2246, 2015, 2014], 1)
    ops.element('FourNodeTetrahedron', 8240, *[2355, 2394, 2304, 2391], 1)
    ops.element('FourNodeTetrahedron', 8241, *[1131, 1796, 2013, 2556], 1)
    ops.element('FourNodeTetrahedron', 8242, *[2524, 1983, 1960, 2044], 1)
    ops.element('FourNodeTetrahedron', 8243, *[1971, 2342, 2519, 2344], 1)
    ops.element('FourNodeTetrahedron', 8244, *[1231, 2497, 1216, 1156], 1)
    ops.element('FourNodeTetrahedron', 8245, *[1949, 1852, 2616, 1853], 1)
    ops.element('FourNodeTetrahedron', 8246, *[2176, 2366, 2287, 1901], 1)
    ops.element('FourNodeTetrahedron', 8247, *[1138, 2412, 1231, 1156], 1)
    ops.element('FourNodeTetrahedron', 8248, *[1924, 1918, 2095, 1925], 1)
    ops.element('FourNodeTetrahedron', 8249, *[2442, 2106, 2443, 2067], 1)
    ops.element('FourNodeTetrahedron', 8250, *[2412, 2497, 1231, 1156], 1)
    ops.element('FourNodeTetrahedron', 8251, *[1751, 1752, 1160, 651], 1)
    ops.element('FourNodeTetrahedron', 8252, *[2019, 2243, 2533, 2332], 1)
    ops.element('FourNodeTetrahedron', 8253, *[2635, 1124, 1163, 2009], 1)
    ops.element('FourNodeTetrahedron', 8254, *[2636, 1922, 1920, 2444], 1)
    ops.element('FourNodeTetrahedron', 8255, *[1124, 2275, 1245, 2595], 1)
    ops.element('FourNodeTetrahedron', 8256, *[1146, 2172, 1126, 1257], 1)
    ops.element('FourNodeTetrahedron', 8257, *[2542, 2204, 606, 2558], 1)
    ops.element('FourNodeTetrahedron', 8258, *[1831, 2040, 1832, 1846], 1)
    ops.element('FourNodeTetrahedron', 8259, *[2244, 2248, 2019, 2243], 1)
    ops.element('FourNodeTetrahedron', 8260, *[2171, 2602, 1222, 2172], 1)
    ops.element('FourNodeTetrahedron', 8261, *[2233, 2637, 1900, 1838], 1)
    ops.element('FourNodeTetrahedron', 8262, *[2019, 2243, 2248, 2533], 1)
    ops.element('FourNodeTetrahedron', 8263, *[2019, 2248, 2395, 2321], 1)
    ops.element('FourNodeTetrahedron', 8264, *[2019, 2248, 2321, 2533], 1)
    ops.element('FourNodeTetrahedron', 8265, *[2018, 2244, 2019, 2245], 1)
    ops.element('FourNodeTetrahedron', 8266, *[2359, 2638, 2563, 2395], 1)
    ops.element('FourNodeTetrahedron', 8267, *[1169, 1988, 1213, 1258], 1)
    ops.element('FourNodeTetrahedron', 8268, *[1931, 2285, 1994, 1993], 1)
    ops.element('FourNodeTetrahedron', 8269, *[1214, 1811, 1255, 2562], 1)
    ops.element('FourNodeTetrahedron', 8270, *[2020, 2638, 2359, 2016], 1)
    ops.element('FourNodeTetrahedron', 8271, *[2020, 2017, 2638, 2016], 1)
    ops.element('FourNodeTetrahedron', 8272, *[1915, 2639, 2200, 1923], 1)
    ops.element('FourNodeTetrahedron', 8273, *[2264, 1764, 2513, 2512], 1)
    ops.element('FourNodeTetrahedron', 8274, *[2338, 1969, 2140, 2138], 1)
    ops.element('FourNodeTetrahedron', 8275, *[2555, 2085, 1917, 1840], 1)
    ops.element('FourNodeTetrahedron', 8276, *[2193, 2555, 1917, 1840], 1)
    ops.element('FourNodeTetrahedron', 8277, *[2390, 2640, 2641, 2389], 1)
    ops.element('FourNodeTetrahedron', 8278, *[2331, 2330, 2642, 2111], 1)
    ops.element('FourNodeTetrahedron', 8279, *[1857, 2345, 1858, 2094], 1)
    ops.element('FourNodeTetrahedron', 8280, *[2579, 1897, 1895, 1855], 1)
    ops.element('FourNodeTetrahedron', 8281, *[2591, 2590, 2508, 2559], 1)
    ops.element('FourNodeTetrahedron', 8282, *[2368, 1167, 1257, 684], 1)
    ops.element('FourNodeTetrahedron', 8283, *[2204, 2242, 2203, 2492], 1)
    ops.element('FourNodeTetrahedron', 8284, *[1852, 1935, 2120, 1933], 1)
    ops.element('FourNodeTetrahedron', 8285, *[2064, 2218, 2643, 419], 1)
    ops.element('FourNodeTetrahedron', 8286, *[1805, 1804, 2471, 2427], 1)
    ops.element('FourNodeTetrahedron', 8287, *[2238, 1150, 512, 2171], 1)
    ops.element('FourNodeTetrahedron', 8288, *[2153, 1958, 2051, 2057], 1)
    ops.element('FourNodeTetrahedron', 8289, *[2112, 2030, 1995, 2526], 1)
    ops.element('FourNodeTetrahedron', 8290, *[2295, 1938, 2571, 2114], 1)
    ops.element('FourNodeTetrahedron', 8291, *[2644, 1815, 1814, 2032], 1)
    ops.element('FourNodeTetrahedron', 8292, *[2055, 2645, 2037, 2038], 1)
    ops.element('FourNodeTetrahedron', 8293, *[1945, 1887, 2246, 2014], 1)
    ops.element('FourNodeTetrahedron', 8294, *[1204, 1860, 1130, 1215], 1)
    ops.element('FourNodeTetrahedron', 8295, *[2059, 2313, 2102, 2030], 1)
    ops.element('FourNodeTetrahedron', 8296, *[1135, 2405, 1861, 1155], 1)
    ops.element('FourNodeTetrahedron', 8297, *[2059, 2376, 2102, 2313], 1)
    ops.element('FourNodeTetrahedron', 8298, *[2102, 2313, 2376, 2101], 1)
    ops.element('FourNodeTetrahedron', 8299, *[2497, 2405, 1216, 2542], 1)
    ops.element('FourNodeTetrahedron', 8300, *[2314, 1822, 2028, 2030], 1)
    ops.element('FourNodeTetrahedron', 8301, *[2357, 2214, 1981, 2596], 1)
    ops.element('FourNodeTetrahedron', 8302, *[2646, 2035, 2055, 2570], 1)
    ops.element('FourNodeTetrahedron', 8303, *[526, 2278, 1238, 424], 1)
    ops.element('FourNodeTetrahedron', 8304, *[1228, 1809, 1157, 1141], 1)
    ops.element('FourNodeTetrahedron', 8305, *[2300, 2544, 2488, 2506], 1)
    ops.element('FourNodeTetrahedron', 8306, *[1760, 750, 749, 1153], 1)
    ops.element('FourNodeTetrahedron', 8307, *[1772, 2364, 1833, 2310], 1)
    ops.element('FourNodeTetrahedron', 8308, *[2538, 2157, 2325, 2173], 1)
    ops.element('FourNodeTetrahedron', 8309, *[2185, 2550, 1872, 2416], 1)
    ops.element('FourNodeTetrahedron', 8310, *[1810, 2520, 1228, 1809], 1)
    ops.element('FourNodeTetrahedron', 8311, *[2189, 2339, 2647, 2387], 1)
    ops.element('FourNodeTetrahedron', 8312, *[2193, 1917, 2006, 2522], 1)
    ops.element('FourNodeTetrahedron', 8313, *[1251, 1853, 1208, 1204], 1)
    ops.element('FourNodeTetrahedron', 8314, *[2010, 2193, 2522, 2474], 1)
    ops.element('FourNodeTetrahedron', 8315, *[2474, 1917, 2522, 1915], 1)
    ops.element('FourNodeTetrahedron', 8316, *[2237, 2381, 1913, 2438], 1)
    ops.element('FourNodeTetrahedron', 8317, *[2237, 1981, 2381, 2438], 1)
    ops.element('FourNodeTetrahedron', 8318, *[1994, 2059, 2102, 1995], 1)
    ops.element('FourNodeTetrahedron', 8319, *[1994, 2102, 1996, 1995], 1)
    ops.element('FourNodeTetrahedron', 8320, *[2079, 2223, 2224, 2271], 1)
    ops.element('FourNodeTetrahedron', 8321, *[2649, 2648, 2613, 2615], 1)
    ops.element('FourNodeTetrahedron', 8322, *[2292, 2583, 2604, 2291], 1)
    ops.element('FourNodeTetrahedron', 8323, *[2403, 2243, 2626, 2385], 1)
    ops.element('FourNodeTetrahedron', 8324, *[2116, 2541, 2539, 2484], 1)
    ops.element('FourNodeTetrahedron', 8325, *[748, 2005, 749, 1760], 1)
    ops.element('FourNodeTetrahedron', 8326, *[1919, 1910, 1908, 2207], 1)
    ops.element('FourNodeTetrahedron', 8327, *[2424, 1800, 2025, 2043], 1)
    ops.element('FourNodeTetrahedron', 8328, *[2291, 2510, 2583, 2604], 1)
    ops.element('FourNodeTetrahedron', 8329, *[1887, 1888, 1886, 2292], 1)
    ops.element('FourNodeTetrahedron', 8330, *[2141, 2650, 2651, 1817], 1)
    ops.element('FourNodeTetrahedron', 8331, *[1162, 2046, 1163, 1879], 1)
    ops.element('FourNodeTetrahedron', 8332, *[1995, 2102, 1996, 2309], 1)
    ops.element('FourNodeTetrahedron', 8333, *[2182, 718, 728, 1252], 1)
    ops.element('FourNodeTetrahedron', 8334, *[1890, 2287, 1863, 1901], 1)
    ops.element('FourNodeTetrahedron', 8335, *[2329, 2328, 2331, 2092], 1)
    ops.element('FourNodeTetrahedron', 8336, *[1230, 1821, 1200, 1818], 1)
    ops.element('FourNodeTetrahedron', 8337, *[1842, 2652, 1903, 1952], 1)
    ops.element('FourNodeTetrahedron', 8338, *[2614, 2259, 1254, 666], 1)
    ops.element('FourNodeTetrahedron', 8339, *[2140, 2213, 2079, 2139], 1)
    ops.element('FourNodeTetrahedron', 8340, *[1870, 2083, 1244, 1753], 1)
    ops.element('FourNodeTetrahedron', 8341, *[1994, 2375, 2283, 1996], 1)
    ops.element('FourNodeTetrahedron', 8342, *[2310, 2311, 2331, 1800], 1)
    ops.element('FourNodeTetrahedron', 8343, *[2536, 1966, 2527, 2097], 1)
    ops.element('FourNodeTetrahedron', 8344, *[2501, 2453, 2169, 2653], 1)
    ops.element('FourNodeTetrahedron', 8345, *[2027, 1802, 2091, 2127], 1)
    ops.element('FourNodeTetrahedron', 8346, *[2292, 2444, 2583, 2291], 1)
    ops.element('FourNodeTetrahedron', 8347, *[2151, 2224, 2002, 1989], 1)
    ops.element('FourNodeTetrahedron', 8348, *[2520, 2090, 2401, 2167], 1)
    ops.element('FourNodeTetrahedron', 8349, *[2240, 2516, 2493, 2241], 1)
    ops.element('FourNodeTetrahedron', 8350, *[2292, 2444, 1920, 2583], 1)
    ops.element('FourNodeTetrahedron', 8351, *[2053, 2290, 2208, 2052], 1)
    ops.element('FourNodeTetrahedron', 8352, *[1875, 2567, 2566, 1963], 1)
    ops.element('FourNodeTetrahedron', 8353, *[2283, 2375, 2435, 1996], 1)
    ops.element('FourNodeTetrahedron', 8354, *[2058, 1845, 1829, 2059], 1)
    ops.element('FourNodeTetrahedron', 8355, *[2517, 2338, 2479, 2590], 1)
    ops.element('FourNodeTetrahedron', 8356, *[513, 2237, 1913, 1150], 1)
    ops.element('FourNodeTetrahedron', 8357, *[1994, 2102, 2375, 1996], 1)
    ops.element('FourNodeTetrahedron', 8358, *[2617, 2225, 1137, 2154], 1)
    ops.element('FourNodeTetrahedron', 8359, *[1863, 2287, 2262, 1901], 1)
    ops.element('FourNodeTetrahedron', 8360, *[1748, 2324, 2082, 2079], 1)
    ops.element('FourNodeTetrahedron', 8361, *[2503, 1828, 1799, 1798], 1)
    ops.element('FourNodeTetrahedron', 8362, *[2145, 1853, 1251, 2402], 1)
    ops.element('FourNodeTetrahedron', 8363, *[2004, 2001, 2361, 2280], 1)
    ops.element('FourNodeTetrahedron', 8364, *[2377, 1925, 1924, 2303], 1)
    ops.element('FourNodeTetrahedron', 8365, *[1993, 1996, 1930, 2307], 1)
    ops.element('FourNodeTetrahedron', 8366, *[1762, 2398, 1763, 1842], 1)
    ops.element('FourNodeTetrahedron', 8367, *[1202, 2145, 1251, 1203], 1)
    ops.element('FourNodeTetrahedron', 8368, *[2144, 2145, 1203, 2402], 1)
    ops.element('FourNodeTetrahedron', 8369, *[1149, 2250, 178, 1190], 1)
    ops.element('FourNodeTetrahedron', 8370, *[1123, 2145, 1202, 1203], 1)
    ops.element('FourNodeTetrahedron', 8371, *[2565, 1963, 2272, 2231], 1)
    ops.element('FourNodeTetrahedron', 8372, *[2565, 2231, 2272, 2086], 1)
    ops.element('FourNodeTetrahedron', 8373, *[1188, 1799, 1227, 1184], 1)
    ops.element('FourNodeTetrahedron', 8374, *[1857, 2094, 1858, 2095], 1)
    ops.element('FourNodeTetrahedron', 8375, *[1857, 1918, 2345, 2094], 1)
    ops.element('FourNodeTetrahedron', 8376, *[2420, 2362, 1976, 1977], 1)
    ops.element('FourNodeTetrahedron', 8377, *[2420, 2362, 1977, 2369], 1)
    ops.element('FourNodeTetrahedron', 8378, *[2304, 2391, 2582, 1998], 1)
    ops.element('FourNodeTetrahedron', 8379, *[1865, 1864, 2199, 1862], 1)
    ops.element('FourNodeTetrahedron', 8380, *[2223, 1794, 1793, 1792], 1)
    ops.element('FourNodeTetrahedron', 8381, *[2139, 2344, 2223, 1792], 1)
    ops.element('FourNodeTetrahedron', 8382, *[2343, 1792, 2270, 1795], 1)
    ops.element('FourNodeTetrahedron', 8383, *[2170, 2501, 2169, 2653], 1)
    ops.element('FourNodeTetrahedron', 8384, *[2223, 1793, 2296, 1792], 1)
    ops.element('FourNodeTetrahedron', 8385, *[2223, 2224, 2271, 2296], 1)
    ops.element('FourNodeTetrahedron', 8386, *[2216, 2643, 146, 2064], 1)
    ops.element('FourNodeTetrahedron', 8387, *[2432, 2243, 2244, 2001], 1)
    ops.element('FourNodeTetrahedron', 8388, *[2170, 2501, 2653, 2559], 1)
    ops.element('FourNodeTetrahedron', 8389, *[1758, 1966, 1755, 2536], 1)
    ops.element('FourNodeTetrahedron', 8390, *[1924, 1925, 2095, 2303], 1)
    ops.element('FourNodeTetrahedron', 8391, *[1925, 2095, 2303, 2155], 1)
    ops.element('FourNodeTetrahedron', 8392, *[1919, 2207, 1908, 1925], 1)
    ops.element('FourNodeTetrahedron', 8393, *[2501, 2453, 2653, 2559], 1)
    ops.element('FourNodeTetrahedron', 8394, *[2378, 1919, 1924, 1925], 1)
    ops.element('FourNodeTetrahedron', 8395, *[2654, 2490, 2489, 2392], 1)
    ops.element('FourNodeTetrahedron', 8396, *[2641, 2113, 2160, 2325], 1)
    ops.element('FourNodeTetrahedron', 8397, *[2641, 2160, 2325, 2173], 1)
    ops.element('FourNodeTetrahedron', 8398, *[2132, 2003, 2515, 2076], 1)
    ops.element('FourNodeTetrahedron', 8399, *[2525, 2362, 2420, 2369], 1)
    ops.element('FourNodeTetrahedron', 8400, *[2055, 1746, 2214, 1747], 1)
    ops.element('FourNodeTetrahedron', 8401, *[2160, 2113, 1931, 2325], 1)
    ops.element('FourNodeTetrahedron', 8402, *[2221, 2655, 2485, 2514], 1)
    ops.element('FourNodeTetrahedron', 8403, *[1857, 1918, 2094, 2095], 1)
    ops.element('FourNodeTetrahedron', 8404, *[1978, 1870, 1236, 1753], 1)
    ops.element('FourNodeTetrahedron', 8405, *[2049, 2257, 2256, 2020], 1)
    ops.element('FourNodeTetrahedron', 8406, *[2369, 2656, 1977, 2118], 1)
    ops.element('FourNodeTetrahedron', 8407, *[1821, 2657, 2069, 2320], 1)
    ops.element('FourNodeTetrahedron', 8408, *[2658, 2207, 2205, 2206], 1)
    ops.element('FourNodeTetrahedron', 8409, *[2656, 2362, 1977, 2117], 1)
    ops.element('FourNodeTetrahedron', 8410, *[2446, 2390, 2345, 1912], 1)
    ops.element('FourNodeTetrahedron', 8411, *[1975, 2306, 2255, 1891], 1)
    ops.element('FourNodeTetrahedron', 8412, *[2533, 2248, 2153, 2274], 1)
    ops.element('FourNodeTetrahedron', 8413, *[2562, 2537, 1130, 1975], 1)
    ops.element('FourNodeTetrahedron', 8414, *[2562, 2284, 2537, 1975], 1)
    ops.element('FourNodeTetrahedron', 8415, *[2562, 1999, 2537, 2284], 1)
    ops.element('FourNodeTetrahedron', 8416, *[2309, 2100, 2484, 2485], 1)
    ops.element('FourNodeTetrahedron', 8417, *[2418, 2633, 1800, 1802], 1)
    ops.element('FourNodeTetrahedron', 8418, *[1811, 2133, 1224, 2537], 1)
    ops.element('FourNodeTetrahedron', 8419, *[1958, 2625, 2210, 2057], 1)
    ops.element('FourNodeTetrahedron', 8420, *[1958, 1957, 2210, 2625], 1)
    ops.element('FourNodeTetrahedron', 8421, *[1957, 2534, 2210, 2625], 1)
    ops.element('FourNodeTetrahedron', 8422, *[1957, 2534, 1959, 2210], 1)
    ops.element('FourNodeTetrahedron', 8423, *[1849, 1847, 2308, 1848], 1)
    ops.element('FourNodeTetrahedron', 8424, *[1930, 1994, 1996, 1993], 1)
    ops.element('FourNodeTetrahedron', 8425, *[1923, 2218, 1238, 2278], 1)
    ops.element('FourNodeTetrahedron', 8426, *[1238, 2278, 2218, 424], 1)
    ops.element('FourNodeTetrahedron', 8427, *[2138, 2624, 2140, 2337], 1)
    ops.element('FourNodeTetrahedron', 8428, *[2559, 2501, 2453, 2508], 1)
    ops.element('FourNodeTetrahedron', 8429, *[2139, 2223, 2271, 1792], 1)
    ops.element('FourNodeTetrahedron', 8430, *[2139, 1792, 2271, 2270], 1)
    ops.element('FourNodeTetrahedron', 8431, *[2575, 2659, 2393, 2277], 1)
    ops.element('FourNodeTetrahedron', 8432, *[2420, 2150, 2129, 1976], 1)
    ops.element('FourNodeTetrahedron', 8433, *[1763, 2623, 2585, 1904], 1)
    ops.element('FourNodeTetrahedron', 8434, *[2212, 1946, 1908, 1948], 1)
    ops.element('FourNodeTetrahedron', 8435, *[2112, 2059, 1995, 2030], 1)
    ops.element('FourNodeTetrahedron', 8436, *[2130, 2132, 2071, 2129], 1)
    ops.element('FourNodeTetrahedron', 8437, *[2402, 1861, 1135, 2405], 1)
    ops.element('FourNodeTetrahedron', 8438, *[2116, 2589, 2541, 2484], 1)
    ops.element('FourNodeTetrahedron', 8439, *[2139, 2344, 1792, 2343], 1)
    ops.element('FourNodeTetrahedron', 8440, *[1792, 1795, 2270, 2610], 1)
    ops.element('FourNodeTetrahedron', 8441, *[2072, 1870, 1223, 1236], 1)
    ops.element('FourNodeTetrahedron', 8442, *[2344, 2548, 2587, 1850], 1)
    ops.element('FourNodeTetrahedron', 8443, *[2602, 2072, 2073, 1126], 1)
    ops.element('FourNodeTetrahedron', 8444, *[2377, 2378, 1924, 1925], 1)
    ops.element('FourNodeTetrahedron', 8445, *[2073, 2072, 1223, 1126], 1)
    ops.element('FourNodeTetrahedron', 8446, *[1161, 2627, 1192, 1779], 1)
    ops.element('FourNodeTetrahedron', 8447, *[2022, 2024, 1192, 1197], 1)
    ops.element('FourNodeTetrahedron', 8448, *[2524, 1983, 1982, 1960], 1)
    ops.element('FourNodeTetrahedron', 8449, *[1779, 2022, 1192, 1197], 1)
    ops.element('FourNodeTetrahedron', 8450, *[1881, 2046, 1808, 1879], 1)
    ops.element('FourNodeTetrahedron', 8451, *[2634, 1862, 2334, 1899], 1)
    ops.element('FourNodeTetrahedron', 8452, *[2627, 2024, 1192, 2022], 1)
    ops.element('FourNodeTetrahedron', 8453, *[1790, 2289, 2286, 2176], 1)
    ops.element('FourNodeTetrahedron', 8454, *[1779, 1776, 1197, 1187], 1)
    ops.element('FourNodeTetrahedron', 8455, *[743, 2047, 2178, 1193], 1)
    ops.element('FourNodeTetrahedron', 8456, *[2433, 2456, 2112, 1756], 1)
    ops.element('FourNodeTetrahedron', 8457, *[2015, 2013, 1796, 2556], 1)
    ops.element('FourNodeTetrahedron', 8458, *[2578, 2172, 2602, 2420], 1)
    ops.element('FourNodeTetrahedron', 8459, *[2373, 2374, 2461, 2660], 1)
    ops.element('FourNodeTetrahedron', 8460, *[1182, 1943, 1796, 2556], 1)
    ops.element('FourNodeTetrahedron', 8461, *[2115, 2320, 1818, 1827], 1)
    ops.element('FourNodeTetrahedron', 8462, *[1819, 2115, 1818, 2104], 1)
    ops.element('FourNodeTetrahedron', 8463, *[1805, 2469, 2470, 2390], 1)
    ops.element('FourNodeTetrahedron', 8464, *[2468, 2273, 2096, 2294], 1)
    ops.element('FourNodeTetrahedron', 8465, *[2480, 1958, 2248, 2243], 1)
    ops.element('FourNodeTetrahedron', 8466, *[2386, 2342, 1971, 2343], 1)
    ops.element('FourNodeTetrahedron', 8467, *[2592, 2347, 2462, 2450], 1)
    ops.element('FourNodeTetrahedron', 8468, *[1790, 2175, 2289, 2176], 1)
    ops.element('FourNodeTetrahedron', 8469, *[2597, 2553, 2342, 2386], 1)
    ops.element('FourNodeTetrahedron', 8470, *[1920, 1924, 1986, 2301], 1)
    ops.element('FourNodeTetrahedron', 8471, *[1920, 1986, 2511, 2301], 1)
    ops.element('FourNodeTetrahedron', 8472, *[2292, 2636, 1920, 2444], 1)
    ops.element('FourNodeTetrahedron', 8473, *[2061, 2621, 2516, 2063], 1)
    ops.element('FourNodeTetrahedron', 8474, *[2516, 2621, 2241, 2063], 1)
    ops.element('FourNodeTetrahedron', 8475, *[2338, 2140, 2502, 2508], 1)
    ops.element('FourNodeTetrahedron', 8476, *[2389, 2516, 2241, 2063], 1)
    ops.element('FourNodeTetrahedron', 8477, *[1969, 2213, 2080, 2140], 1)
    ops.element('FourNodeTetrahedron', 8478, *[2061, 2516, 2389, 2063], 1)
    ops.element('FourNodeTetrahedron', 8479, *[2544, 2389, 2241, 2063], 1)
    ops.element('FourNodeTetrahedron', 8480, *[2061, 2389, 2544, 2063], 1)
    ops.element('FourNodeTetrahedron', 8481, *[2233, 2620, 2232, 2637], 1)
    ops.element('FourNodeTetrahedron', 8482, *[2005, 2554, 750, 1760], 1)
    ops.element('FourNodeTetrahedron', 8483, *[1976, 2083, 1870, 1753], 1)
    ops.element('FourNodeTetrahedron', 8484, *[2619, 2218, 1238, 1923], 1)
    ops.element('FourNodeTetrahedron', 8485, *[2039, 2042, 2108, 2041], 1)
    ops.element('FourNodeTetrahedron', 8486, *[2661, 2637, 2233, 2620], 1)
    ops.element('FourNodeTetrahedron', 8487, *[2072, 1976, 1870, 1978], 1)
    ops.element('FourNodeTetrahedron', 8488, *[2236, 1844, 1898, 2237], 1)
    ops.element('FourNodeTetrahedron', 8489, *[2662, 684, 1146, 683], 1)
    ops.element('FourNodeTetrahedron', 8490, *[1247, 1879, 1163, 2009], 1)
    ops.element('FourNodeTetrahedron', 8491, *[1852, 1933, 2616, 1851], 1)
    ops.element('FourNodeTetrahedron', 8492, *[1859, 1975, 1191, 1891], 1)
    ops.element('FourNodeTetrahedron', 8493, *[2202, 2467, 551, 2598], 1)
    ops.element('FourNodeTetrahedron', 8494, *[2491, 2310, 1772, 1836], 1)
    ops.element('FourNodeTetrahedron', 8495, *[1884, 1817, 2651, 2044], 1)
    ops.element('FourNodeTetrahedron', 8496, *[2124, 1839, 2121, 1840], 1)
    ops.element('FourNodeTetrahedron', 8497, *[2216, 2217, 2643, 2064], 1)
    ops.element('FourNodeTetrahedron', 8498, *[2265, 1884, 2663, 1941], 1)
    ops.element('FourNodeTetrahedron', 8499, *[1870, 1868, 1867, 1976], 1)
    ops.element('FourNodeTetrahedron', 8500, *[2512, 1765, 1764, 2511], 1)
    ops.element('FourNodeTetrahedron', 8501, *[1976, 1868, 1867, 1754], 1)
    ops.element('FourNodeTetrahedron', 8502, *[1913, 2073, 1221, 1220], 1)
    ops.element('FourNodeTetrahedron', 8503, *[1903, 1881, 1879, 2050], 1)
    ops.element('FourNodeTetrahedron', 8504, *[2039, 2040, 2041, 1832], 1)
    ops.element('FourNodeTetrahedron', 8505, *[2001, 2281, 2385, 2280], 1)
    ops.element('FourNodeTetrahedron', 8506, *[2244, 2252, 2480, 2243], 1)
    ops.element('FourNodeTetrahedron', 8507, *[2416, 1964, 2565, 2430], 1)
    ops.element('FourNodeTetrahedron', 8508, *[1976, 1867, 1870, 2083], 1)
    ops.element('FourNodeTetrahedron', 8509, *[1976, 1867, 2083, 1754], 1)
    ops.element('FourNodeTetrahedron', 8510, *[1976, 2083, 1753, 1754], 1)
    ops.element('FourNodeTetrahedron', 8511, *[1195, 2349, 1154, 2462], 1)
    ops.element('FourNodeTetrahedron', 8512, *[1233, 2104, 1227, 1799], 1)
    ops.element('FourNodeTetrahedron', 8513, *[2612, 2430, 2429, 2122], 1)
    ops.element('FourNodeTetrahedron', 8514, *[1826, 2146, 2147, 2144], 1)
    ops.element('FourNodeTetrahedron', 8515, *[2312, 2615, 2613, 2311], 1)
    ops.element('FourNodeTetrahedron', 8516, *[2629, 2613, 1775, 2312], 1)
    ops.element('FourNodeTetrahedron', 8517, *[2631, 2071, 2073, 2072], 1)
    ops.element('FourNodeTetrahedron', 8518, *[2006, 2483, 2619, 2333], 1)
    ops.element('FourNodeTetrahedron', 8519, *[2209, 1886, 2592, 2211], 1)
    ops.element('FourNodeTetrahedron', 8520, *[2207, 1948, 1925, 2205], 1)
    ops.element('FourNodeTetrahedron', 8521, *[2140, 2139, 2379, 2269], 1)
    ops.element('FourNodeTetrahedron', 8522, *[2510, 2301, 2302, 2303], 1)
    ops.element('FourNodeTetrahedron', 8523, *[1949, 2229, 1209, 2120], 1)
    ops.element('FourNodeTetrahedron', 8524, *[2122, 1839, 2121, 2124], 1)
    ops.element('FourNodeTetrahedron', 8525, *[1878, 1877, 1823, 1875], 1)
    ops.element('FourNodeTetrahedron', 8526, *[2490, 2615, 2312, 2424], 1)
    ops.element('FourNodeTetrahedron', 8527, *[2014, 1887, 2012, 2209], 1)
    ops.element('FourNodeTetrahedron', 8528, *[1980, 2532, 1981, 2214], 1)
    ops.element('FourNodeTetrahedron', 8529, *[2026, 2220, 1935, 1934], 1)
    ops.element('FourNodeTetrahedron', 8530, *[1863, 2262, 1862, 1901], 1)
    ops.element('FourNodeTetrahedron', 8531, *[2429, 2086, 2514, 2121], 1)
    ops.element('FourNodeTetrahedron', 8532, *[2150, 2076, 1976, 2362], 1)
    ops.element('FourNodeTetrahedron', 8533, *[2626, 2664, 2274, 2499], 1)
    ops.element('FourNodeTetrahedron', 8534, *[2272, 2175, 2174, 2231], 1)
    ops.element('FourNodeTetrahedron', 8535, *[2272, 1963, 2175, 2231], 1)
    ops.element('FourNodeTetrahedron', 8536, *[1959, 1887, 2209, 2211], 1)
    ops.element('FourNodeTetrahedron', 8537, *[1946, 2277, 2186, 1871], 1)
    ops.element('FourNodeTetrahedron', 8538, *[2116, 2101, 2540, 2589], 1)
    ops.element('FourNodeTetrahedron', 8539, *[1927, 2033, 2031, 2055], 1)
    ops.element('FourNodeTetrahedron', 8540, *[2002, 2279, 2001, 2280], 1)
    ops.element('FourNodeTetrahedron', 8541, *[1988, 1866, 1213, 1258], 1)
    ops.element('FourNodeTetrahedron', 8542, *[2169, 2525, 2369, 2453], 1)
    ops.element('FourNodeTetrahedron', 8543, *[2184, 2468, 2096, 2294], 1)
    ops.element('FourNodeTetrahedron', 8544, *[2184, 2468, 2294, 2416], 1)
    ops.element('FourNodeTetrahedron', 8545, *[1896, 2157, 1854, 2538], 1)
    ops.element('FourNodeTetrahedron', 8546, *[2429, 2514, 2192, 2121], 1)
    ops.element('FourNodeTetrahedron', 8547, *[1196, 2410, 1156, 611], 1)
    ops.element('FourNodeTetrahedron', 8548, *[1196, 2412, 1156, 2410], 1)
    ops.element('FourNodeTetrahedron', 8549, *[1860, 1930, 2562, 1975], 1)
    ops.element('FourNodeTetrahedron', 8550, *[1908, 2093, 1918, 1925], 1)
    ops.element('FourNodeTetrahedron', 8551, *[612, 2410, 2451, 611], 1)
    ops.element('FourNodeTetrahedron', 8552, *[1156, 2410, 612, 611], 1)
    ops.element('FourNodeTetrahedron', 8553, *[612, 2410, 2451, 2543], 1)
    ops.element('FourNodeTetrahedron', 8554, *[2594, 2592, 2556, 2226], 1)
    ops.element('FourNodeTetrahedron', 8555, *[2444, 2378, 2377, 2584], 1)
    ops.element('FourNodeTetrahedron', 8556, *[2377, 2378, 1925, 2584], 1)
    ops.element('FourNodeTetrahedron', 8557, *[713, 2164, 167, 175], 1)
    ops.element('FourNodeTetrahedron', 8558, *[2014, 2592, 2556, 2226], 1)
    ops.element('FourNodeTetrahedron', 8559, *[2014, 2013, 2556, 2592], 1)
    ops.element('FourNodeTetrahedron', 8560, *[1897, 1856, 1895, 1855], 1)
    ops.element('FourNodeTetrahedron', 8561, *[2228, 711, 718, 2400], 1)
    ops.element('FourNodeTetrahedron', 8562, *[1252, 2228, 718, 711], 1)
    ops.element('FourNodeTetrahedron', 8563, *[2095, 2060, 2544, 2506], 1)
    ops.element('FourNodeTetrahedron', 8564, *[2300, 2095, 2544, 2506], 1)
    ops.element('FourNodeTetrahedron', 8565, *[2098, 2099, 177, 2250], 1)
    ops.element('FourNodeTetrahedron', 8566, *[2258, 2595, 1241, 2457], 1)
    ops.element('FourNodeTetrahedron', 8567, *[2121, 2086, 1837, 1839], 1)
    ops.element('FourNodeTetrahedron', 8568, *[1814, 1816, 1885, 2031], 1)
    ops.element('FourNodeTetrahedron', 8569, *[2060, 2466, 2544, 2506], 1)
    ops.element('FourNodeTetrahedron', 8570, *[2163, 1814, 2162, 1926], 1)
    ops.element('FourNodeTetrahedron', 8571, *[1244, 2083, 1132, 1160], 1)
    ops.element('FourNodeTetrahedron', 8572, *[2182, 2437, 718, 2228], 1)
    ops.element('FourNodeTetrahedron', 8573, *[1256, 2074, 1121, 1223], 1)
    ops.element('FourNodeTetrahedron', 8574, *[2186, 2185, 2184, 1872], 1)
    ops.element('FourNodeTetrahedron', 8575, *[2148, 1783, 1897, 2579], 1)
    ops.element('FourNodeTetrahedron', 8576, *[2182, 718, 1252, 2228], 1)
    ops.element('FourNodeTetrahedron', 8577, *[2115, 1827, 2104, 2503], 1)
    ops.element('FourNodeTetrahedron', 8578, *[2378, 2207, 1925, 2658], 1)
    ops.element('FourNodeTetrahedron', 8579, *[2658, 2207, 1925, 2205], 1)
    ops.element('FourNodeTetrahedron', 8580, *[2378, 2658, 1925, 2584], 1)
    ops.element('FourNodeTetrahedron', 8581, *[2658, 2205, 1925, 2584], 1)
    ops.element('FourNodeTetrahedron', 8582, *[1190, 2216, 178, 146], 1)
    ops.element('FourNodeTetrahedron', 8583, *[2249, 1769, 1770, 1771], 1)
    ops.element('FourNodeTetrahedron', 8584, *[2121, 2085, 2555, 1840], 1)
    ops.element('FourNodeTetrahedron', 8585, *[2607, 748, 747, 1988], 1)
    ops.element('FourNodeTetrahedron', 8586, *[2061, 2621, 2063, 2062], 1)
    ops.element('FourNodeTetrahedron', 8587, *[2112, 2456, 2030, 2527], 1)
    ops.element('FourNodeTetrahedron', 8588, *[2211, 2574, 2292, 2576], 1)
    ops.element('FourNodeTetrahedron', 8589, *[1883, 2052, 2594, 634], 1)
    ops.element('FourNodeTetrahedron', 8590, *[1992, 1991, 1990, 2452], 1)
    ops.element('FourNodeTetrahedron', 8591, *[2330, 2372, 2089, 2108], 1)
    ops.element('FourNodeTetrahedron', 8592, *[1181, 2225, 1152, 1883], 1)
    ops.element('FourNodeTetrahedron', 8593, *[2381, 2382, 2631, 2531], 1)
    ops.element('FourNodeTetrahedron', 8594, *[2084, 2308, 1847, 1849], 1)
    ops.element('FourNodeTetrahedron', 8595, *[1972, 2323, 2324, 2519], 1)
    ops.element('FourNodeTetrahedron', 8596, *[1937, 2404, 1240, 1195], 1)
    ops.element('FourNodeTetrahedron', 8597, *[2277, 2593, 2185, 1871], 1)
    ops.element('FourNodeTetrahedron', 8598, *[2399, 2623, 2005, 1763], 1)
    ops.element('FourNodeTetrahedron', 8599, *[2415, 2581, 2273, 2414], 1)
    ops.element('FourNodeTetrahedron', 8600, *[2154, 2225, 1181, 1883], 1)
    ops.element('FourNodeTetrahedron', 8601, *[2096, 1968, 1878, 2273], 1)
    ops.element('FourNodeTetrahedron', 8602, *[2225, 2594, 1152, 1883], 1)
    ops.element('FourNodeTetrahedron', 8603, *[2174, 2176, 1901, 1902], 1)
    ops.element('FourNodeTetrahedron', 8604, *[2227, 2014, 1943, 2225], 1)
    ops.element('FourNodeTetrahedron', 8605, *[1975, 2284, 2537, 2255], 1)
    ops.element('FourNodeTetrahedron', 8606, *[2178, 1161, 742, 1193], 1)
    ops.element('FourNodeTetrahedron', 8607, *[2294, 2273, 2565, 2416], 1)
    ops.element('FourNodeTetrahedron', 8608, *[2071, 1868, 1869, 1870], 1)
    ops.element('FourNodeTetrahedron', 8609, *[1972, 2519, 2139, 1971], 1)
    ops.element('FourNodeTetrahedron', 8610, *[1969, 1971, 2139, 2138], 1)
    ops.element('FourNodeTetrahedron', 8611, *[2238, 2438, 1150, 2171], 1)
    ops.element('FourNodeTetrahedron', 8612, *[2260, 1836, 1834, 1750], 1)
    ops.element('FourNodeTetrahedron', 8613, *[1800, 1802, 1803, 2027], 1)
    ops.element('FourNodeTetrahedron', 8614, *[2472, 1841, 2521, 2114], 1)
    ops.element('FourNodeTetrahedron', 8615, *[2413, 2151, 2531, 2577], 1)
    ops.element('FourNodeTetrahedron', 8616, *[1174, 2305, 1199, 2070], 1)
    ops.element('FourNodeTetrahedron', 8617, *[2046, 2504, 2475, 2275], 1)
    ops.element('FourNodeTetrahedron', 8618, *[2028, 1791, 2367, 1824], 1)
    ops.element('FourNodeTetrahedron', 8619, *[2238, 2438, 2171, 2479], 1)
    ops.element('FourNodeTetrahedron', 8620, *[2379, 2271, 2224, 1989], 1)
    ops.element('FourNodeTetrahedron', 8621, *[2344, 1794, 1850, 1795], 1)
    ops.element('FourNodeTetrahedron', 8622, *[2379, 2224, 2151, 1989], 1)
    ops.element('FourNodeTetrahedron', 8623, *[2079, 2224, 2151, 2379], 1)
    ops.element('FourNodeTetrahedron', 8624, *[2566, 2665, 1789, 2601], 1)
    ops.element('FourNodeTetrahedron', 8625, *[2340, 1970, 1969, 2339], 1)
    ops.element('FourNodeTetrahedron', 8626, *[2567, 1789, 2566, 2601], 1)
    ops.element('FourNodeTetrahedron', 8627, *[1193, 2178, 1161, 1779], 1)
    ops.element('FourNodeTetrahedron', 8628, *[1202, 1949, 1208, 2145], 1)
    ops.element('FourNodeTetrahedron', 8629, *[1747, 2036, 1749, 1972], 1)
    ops.element('FourNodeTetrahedron', 8630, *[2571, 2472, 2521, 2114], 1)
    ops.element('FourNodeTetrahedron', 8631, *[2231, 2175, 2176, 2232], 1)
    ops.element('FourNodeTetrahedron', 8632, *[2174, 2176, 1902, 2231], 1)
    ops.element('FourNodeTetrahedron', 8633, *[2050, 1881, 1879, 2635], 1)
    ops.element('FourNodeTetrahedron', 8634, *[2396, 1134, 1159, 513], 1)
    ops.element('FourNodeTetrahedron', 8635, *[1939, 1961, 2114, 1941], 1)
    ops.element('FourNodeTetrahedron', 8636, *[1824, 1790, 1890, 2174], 1)
    ops.element('FourNodeTetrahedron', 8637, *[2363, 2666, 2364, 2311], 1)
    ops.element('FourNodeTetrahedron', 8638, *[2667, 2559, 2572, 2573], 1)
    ops.element('FourNodeTetrahedron', 8639, *[1806, 2640, 2516, 2389], 1)
    ops.element('FourNodeTetrahedron', 8640, *[2476, 2551, 2185, 2593], 1)
    ops.element('FourNodeTetrahedron', 8641, *[1210, 1810, 1228, 1211], 1)
    ops.element('FourNodeTetrahedron', 8642, *[2402, 1853, 1204, 1861], 1)
    ops.element('FourNodeTetrahedron', 8643, *[1882, 1808, 1162, 1879], 1)
    ops.element('FourNodeTetrahedron', 8644, *[2345, 2390, 2388, 2094], 1)
    ops.element('FourNodeTetrahedron', 8645, *[1135, 1861, 1215, 1155], 1)
    ops.element('FourNodeTetrahedron', 8646, *[2096, 1878, 2097, 2294], 1)
    ops.element('FourNodeTetrahedron', 8647, *[2667, 2495, 2572, 2559], 1)
    ops.element('FourNodeTetrahedron', 8648, *[1935, 1936, 2120, 1933], 1)
    ops.element('FourNodeTetrahedron', 8649, *[2602, 2631, 2072, 2420], 1)
    ops.element('FourNodeTetrahedron', 8650, *[2171, 2172, 1222, 1146], 1)
    ops.element('FourNodeTetrahedron', 8651, *[1215, 1860, 1975, 1859], 1)
    ops.element('FourNodeTetrahedron', 8652, *[2647, 2340, 2339, 2189], 1)
    ops.element('FourNodeTetrahedron', 8653, *[1147, 2228, 1252, 1210], 1)
    ops.element('FourNodeTetrahedron', 8654, *[2301, 2300, 2411, 2302], 1)
    ops.element('FourNodeTetrahedron', 8655, *[2273, 1876, 1875, 1963], 1)
    ops.element('FourNodeTetrahedron', 8656, *[1151, 1998, 1173, 1242], 1)
    ops.element('FourNodeTetrahedron', 8657, *[2380, 734, 739, 1174], 1)
    ops.element('FourNodeTetrahedron', 8658, *[2070, 2408, 1136, 2068], 1)
    ops.element('FourNodeTetrahedron', 8659, *[2072, 2071, 1870, 1976], 1)
    ops.element('FourNodeTetrahedron', 8660, *[1888, 1921, 1889, 1765], 1)
    ops.element('FourNodeTetrahedron', 8661, *[2462, 2347, 2348, 2450], 1)
    ops.element('FourNodeTetrahedron', 8662, *[1819, 1820, 1818, 2115], 1)
    ops.element('FourNodeTetrahedron', 8663, *[2657, 2455, 2454, 2070], 1)
    ops.element('FourNodeTetrahedron', 8664, *[1977, 2117, 1754, 2119], 1)
    ops.element('FourNodeTetrahedron', 8665, *[1180, 2256, 1226, 1237], 1)
    ops.element('FourNodeTetrahedron', 8666, *[2172, 2420, 2072, 1978], 1)
    ops.element('FourNodeTetrahedron', 8667, *[1784, 1787, 1785, 1980], 1)
    ops.element('FourNodeTetrahedron', 8668, *[1785, 1787, 2668, 1980], 1)
    ops.element('FourNodeTetrahedron', 8669, *[2185, 2551, 2416, 2550], 1)
    ops.element('FourNodeTetrahedron', 8670, *[1929, 1787, 1784, 1980], 1)
    ops.element('FourNodeTetrahedron', 8671, *[1929, 2031, 1787, 2055], 1)
    ops.element('FourNodeTetrahedron', 8672, *[2356, 2429, 2192, 2123], 1)
    ops.element('FourNodeTetrahedron', 8673, *[1944, 2267, 1797, 1943], 1)
    ops.element('FourNodeTetrahedron', 8674, *[2001, 2403, 2385, 2281], 1)
    ops.element('FourNodeTetrahedron', 8675, *[1988, 1762, 1760, 1866], 1)
    ops.element('FourNodeTetrahedron', 8676, *[1240, 2143, 1123, 1205], 1)
    ops.element('FourNodeTetrahedron', 8677, *[2423, 1822, 2314, 2030], 1)
    ops.element('FourNodeTetrahedron', 8678, *[1921, 1987, 1766, 1986], 1)
    ops.element('FourNodeTetrahedron', 8679, *[2001, 2431, 2403, 2281], 1)
    ops.element('FourNodeTetrahedron', 8680, *[1133, 1779, 1187, 2443], 1)
    ops.element('FourNodeTetrahedron', 8681, *[1227, 1825, 1201, 1123], 1)
    ops.element('FourNodeTetrahedron', 8682, *[2171, 2438, 2578, 2560], 1)
    ops.element('FourNodeTetrahedron', 8683, *[2490, 2312, 2491, 2424], 1)
    ops.element('FourNodeTetrahedron', 8684, *[2279, 2431, 2001, 2281], 1)
    ops.element('FourNodeTetrahedron', 8685, *[1122, 1797, 1186, 1183], 1)
    ops.element('FourNodeTetrahedron', 8686, *[2256, 2359, 1237, 1869], 1)
    ops.element('FourNodeTetrahedron', 8687, *[2419, 2256, 1180, 1869], 1)
    ops.element('FourNodeTetrahedron', 8688, *[1878, 1875, 1823, 2272], 1)
    ops.element('FourNodeTetrahedron', 8689, *[1180, 2256, 1237, 1869], 1)
    ops.element('FourNodeTetrahedron', 8690, *[2478, 2338, 2561, 2647], 1)
    ops.element('FourNodeTetrahedron', 8691, *[1841, 1960, 2398, 1843], 1)
    ops.element('FourNodeTetrahedron', 8692, *[2047, 2180, 2178, 2179], 1)
    ops.element('FourNodeTetrahedron', 8693, *[2473, 2180, 743, 2047], 1)
    ops.element('FourNodeTetrahedron', 8694, *[2473, 2179, 2047, 2045], 1)
    ops.element('FourNodeTetrahedron', 8695, *[2047, 2178, 1193, 2475], 1)
    ops.element('FourNodeTetrahedron', 8696, *[2152, 2426, 2360, 2318], 1)
    ops.element('FourNodeTetrahedron', 8697, *[1944, 1945, 2267, 1943], 1)
    ops.element('FourNodeTetrahedron', 8698, *[2153, 2051, 2154, 1883], 1)
    ops.element('FourNodeTetrahedron', 8699, *[2009, 2635, 2275, 2257], 1)
    ops.element('FourNodeTetrahedron', 8700, *[2484, 2199, 2465, 2483], 1)
    ops.element('FourNodeTetrahedron', 8701, *[2105, 2179, 1779, 2475], 1)
    ops.element('FourNodeTetrahedron', 8702, *[2575, 2277, 2393, 1946], 1)
    ops.element('FourNodeTetrahedron', 8703, *[2179, 2022, 1779, 2105], 1)
    ops.element('FourNodeTetrahedron', 8704, *[2533, 2274, 2153, 2626], 1)
    ops.element('FourNodeTetrahedron', 8705, *[1761, 2005, 748, 1760], 1)
    ops.element('FourNodeTetrahedron', 8706, *[2125, 2058, 1931, 2160], 1)
    ops.element('FourNodeTetrahedron', 8707, *[2157, 2168, 1931, 2160], 1)
    ops.element('FourNodeTetrahedron', 8708, *[1819, 1905, 1821, 1230], 1)
    ops.element('FourNodeTetrahedron', 8709, *[2633, 2329, 2331, 1801], 1)
    ops.element('FourNodeTetrahedron', 8710, *[2614, 1753, 1145, 1751], 1)
    ops.element('FourNodeTetrahedron', 8711, *[1880, 1879, 1139, 2048], 1)
    ops.element('FourNodeTetrahedron', 8712, *[1976, 2004, 1868, 1754], 1)
    ops.element('FourNodeTetrahedron', 8713, *[2168, 2125, 1931, 2160], 1)
    ops.element('FourNodeTetrahedron', 8714, *[2048, 2050, 2635, 2049], 1)
    ops.element('FourNodeTetrahedron', 8715, *[2380, 2305, 734, 1174], 1)
    ops.element('FourNodeTetrahedron', 8716, *[2669, 2115, 1819, 2622], 1)
    ops.element('FourNodeTetrahedron', 8717, *[1823, 1877, 1791, 1788], 1)
    ops.element('FourNodeTetrahedron', 8718, *[2664, 2253, 2057, 2670], 1)
    ops.element('FourNodeTetrahedron', 8719, *[2054, 2670, 2057, 2664], 1)
    ops.element('FourNodeTetrahedron', 8720, *[1790, 2286, 2288, 1890], 1)
    ops.element('FourNodeTetrahedron', 8721, *[2419, 2020, 2256, 1869], 1)
    ops.element('FourNodeTetrahedron', 8722, *[2364, 2311, 2642, 2482], 1)
    ops.element('FourNodeTetrahedron', 8723, *[1972, 2553, 2519, 2597], 1)
    ops.element('FourNodeTetrahedron', 8724, *[2592, 2349, 2013, 2462], 1)
    ops.element('FourNodeTetrahedron', 8725, *[2462, 2349, 1154, 2348], 1)
    ops.element('FourNodeTetrahedron', 8726, *[2494, 2221, 1973, 2222], 1)
    ops.element('FourNodeTetrahedron', 8727, *[1123, 2147, 2145, 2144], 1)
    ops.element('FourNodeTetrahedron', 8728, *[2331, 2111, 2642, 2482], 1)
    ops.element('FourNodeTetrahedron', 8729, *[2178, 2179, 2627, 1779], 1)
    ops.element('FourNodeTetrahedron', 8730, *[2181, 2671, 2437, 2230], 1)
    ops.element('FourNodeTetrahedron', 8731, *[2510, 2301, 2605, 2302], 1)
    ops.element('FourNodeTetrahedron', 8732, *[2180, 2177, 742, 2178], 1)
    ops.element('FourNodeTetrahedron', 8733, *[2672, 2628, 2629, 2490], 1)
    ops.element('FourNodeTetrahedron', 8734, *[2629, 2615, 2613, 2312], 1)
    ops.element('FourNodeTetrahedron', 8735, *[2673, 2633, 2615, 1800], 1)
    ops.element('FourNodeTetrahedron', 8736, *[2490, 2628, 2615, 2673], 1)
    ops.element('FourNodeTetrahedron', 8737, *[2446, 2448, 2346, 2390], 1)
    ops.element('FourNodeTetrahedron', 8738, *[1233, 2104, 1189, 1227], 1)
    ops.element('FourNodeTetrahedron', 8739, *[2615, 2329, 2311, 2633], 1)
    ops.element('FourNodeTetrahedron', 8740, *[2615, 2648, 2329, 2633], 1)
    ops.element('FourNodeTetrahedron', 8741, *[2312, 2615, 2311, 1800], 1)
    ops.element('FourNodeTetrahedron', 8742, *[2615, 2674, 2311, 2329], 1)
    ops.element('FourNodeTetrahedron', 8743, *[2224, 2675, 2002, 2341], 1)
    ops.element('FourNodeTetrahedron', 8744, *[2007, 2006, 1891, 2467], 1)
    ops.element('FourNodeTetrahedron', 8745, *[1868, 2515, 2018, 2245], 1)
    ops.element('FourNodeTetrahedron', 8746, *[2083, 1867, 2308, 2332], 1)
    ops.element('FourNodeTetrahedron', 8747, *[612, 606, 1216, 2543], 1)
    ops.element('FourNodeTetrahedron', 8748, *[2542, 1155, 1216, 606], 1)
    ops.element('FourNodeTetrahedron', 8749, *[1972, 2553, 2323, 2519], 1)
    ops.element('FourNodeTetrahedron', 8750, *[1876, 1877, 1967, 1878], 1)
    ops.element('FourNodeTetrahedron', 8751, *[1867, 2245, 2019, 2332], 1)
    ops.element('FourNodeTetrahedron', 8752, *[2060, 2063, 2544, 2466], 1)
    ops.element('FourNodeTetrahedron', 8753, *[2411, 2488, 2676, 2302], 1)
    ops.element('FourNodeTetrahedron', 8754, *[2159, 2677, 2160, 2641], 1)
    ops.element('FourNodeTetrahedron', 8755, *[2316, 2020, 1869, 2016], 1)
    ops.element('FourNodeTetrahedron', 8756, *[2389, 2516, 2240, 2241], 1)
    ops.element('FourNodeTetrahedron', 8757, *[2316, 2016, 1869, 1868], 1)
    ops.element('FourNodeTetrahedron', 8758, *[2316, 2018, 2020, 2016], 1)
    ops.element('FourNodeTetrahedron', 8759, *[2316, 2018, 2016, 1868], 1)
    ops.element('FourNodeTetrahedron', 8760, *[2378, 2207, 1919, 1925], 1)
    ops.element('FourNodeTetrahedron', 8761, *[2018, 2019, 2016, 2245], 1)
    ops.element('FourNodeTetrahedron', 8762, *[1867, 2019, 2016, 2245], 1)
    ops.element('FourNodeTetrahedron', 8763, *[1753, 2083, 1244, 1160], 1)
    ops.element('FourNodeTetrahedron', 8764, *[2169, 2420, 2172, 2369], 1)
    ops.element('FourNodeTetrahedron', 8765, *[2167, 2165, 2164, 175], 1)
    ops.element('FourNodeTetrahedron', 8766, *[2596, 2532, 2531, 2080], 1)
    ops.element('FourNodeTetrahedron', 8767, *[2532, 2081, 2531, 2080], 1)
    ops.element('FourNodeTetrahedron', 8768, *[1144, 1821, 1200, 1230], 1)
    ops.element('FourNodeTetrahedron', 8769, *[2521, 2399, 1761, 1762], 1)
    ops.element('FourNodeTetrahedron', 8770, *[2596, 2532, 2382, 2531], 1)
    ops.element('FourNodeTetrahedron', 8771, *[2015, 2012, 2264, 2013], 1)
    ops.element('FourNodeTetrahedron', 8772, *[1928, 1784, 1941, 2358], 1)
    ops.element('FourNodeTetrahedron', 8773, *[2224, 2341, 2002, 2317], 1)
    ops.element('FourNodeTetrahedron', 8774, *[2532, 2081, 2382, 2531], 1)
    ops.element('FourNodeTetrahedron', 8775, *[2280, 2001, 2385, 2361], 1)
    ops.element('FourNodeTetrahedron', 8776, *[2457, 2266, 1250, 1177], 1)
    ops.element('FourNodeTetrahedron', 8777, *[2185, 2551, 2468, 2416], 1)
    ops.element('FourNodeTetrahedron', 8778, *[2619, 2333, 2218, 1923], 1)
    ops.element('FourNodeTetrahedron', 8779, *[2522, 2333, 1923, 1915], 1)
    ops.element('FourNodeTetrahedron', 8780, *[2248, 1771, 2321, 2153], 1)
    ops.element('FourNodeTetrahedron', 8781, *[2333, 1915, 2200, 1923], 1)
    ops.element('FourNodeTetrahedron', 8782, *[2522, 1917, 2333, 1915], 1)
    ops.element('FourNodeTetrahedron', 8783, *[1866, 1763, 1903, 1842], 1)
    ops.element('FourNodeTetrahedron', 8784, *[1138, 2404, 1231, 2412], 1)
    ops.element('FourNodeTetrahedron', 8785, *[1126, 2072, 1223, 1236], 1)
    ops.element('FourNodeTetrahedron', 8786, *[1763, 1904, 1903, 2652], 1)
    ops.element('FourNodeTetrahedron', 8787, *[2052, 2594, 621, 634], 1)
    ops.element('FourNodeTetrahedron', 8788, *[2397, 2396, 514, 513], 1)
    ops.element('FourNodeTetrahedron', 8789, *[2375, 2540, 2116, 2539], 1)
    ops.element('FourNodeTetrahedron', 8790, *[2325, 2113, 2493, 2516], 1)
    ops.element('FourNodeTetrahedron', 8791, *[2113, 1755, 2493, 2516], 1)
    ops.element('FourNodeTetrahedron', 8792, *[2493, 1755, 2526, 2536], 1)
    ops.element('FourNodeTetrahedron', 8793, *[2516, 1755, 2493, 2536], 1)
    ops.element('FourNodeTetrahedron', 8794, *[1934, 2482, 2219, 2588], 1)
    ops.element('FourNodeTetrahedron', 8795, *[2516, 2536, 2493, 2241], 1)
    ops.element('FourNodeTetrahedron', 8796, *[1763, 1904, 1880, 1903], 1)
    ops.element('FourNodeTetrahedron', 8797, *[1245, 1187, 1133, 2443], 1)
    ops.element('FourNodeTetrahedron', 8798, *[2195, 2196, 2217, 2064], 1)
    ops.element('FourNodeTetrahedron', 8799, *[2568, 2219, 2546, 1810], 1)
    ops.element('FourNodeTetrahedron', 8800, *[2169, 2578, 2420, 2525], 1)
    ops.element('FourNodeTetrahedron', 8801, *[2169, 2525, 2420, 2369], 1)
    ops.element('FourNodeTetrahedron', 8802, *[1800, 2633, 1801, 1802], 1)
    ops.element('FourNodeTetrahedron', 8803, *[1927, 2031, 1926, 2033], 1)
    ops.element('FourNodeTetrahedron', 8804, *[2428, 2096, 1758, 2184], 1)
    ops.element('FourNodeTetrahedron', 8805, *[2209, 1887, 2012, 1886], 1)
    ops.element('FourNodeTetrahedron', 8806, *[2184, 2096, 1758, 2621], 1)
    ops.element('FourNodeTetrahedron', 8807, *[2305, 2352, 2304, 2070], 1)
    ops.element('FourNodeTetrahedron', 8808, *[2446, 2346, 2345, 2390], 1)
    ops.element('FourNodeTetrahedron', 8809, *[2260, 1772, 1834, 1836], 1)
    ops.element('FourNodeTetrahedron', 8810, *[1877, 1822, 2423, 1823], 1)
    ops.element('FourNodeTetrahedron', 8811, *[1822, 1791, 2028, 1824], 1)
    ops.element('FourNodeTetrahedron', 8812, *[2260, 2491, 1836, 2261], 1)
    ops.element('FourNodeTetrahedron', 8813, *[2599, 2678, 2305, 2454], 1)
    ops.element('FourNodeTetrahedron', 8814, *[1925, 2155, 2303, 2205], 1)
    ops.element('FourNodeTetrahedron', 8815, *[1797, 2503, 1798, 2267], 1)
    ops.element('FourNodeTetrahedron', 8816, *[2427, 1757, 1804, 2428], 1)
    ops.element('FourNodeTetrahedron', 8817, *[1929, 2055, 1980, 2357], 1)
    ops.element('FourNodeTetrahedron', 8818, *[1891, 2255, 1190, 2215], 1)
    ops.element('FourNodeTetrahedron', 8819, *[2328, 2108, 2330, 2111], 1)
    ops.element('FourNodeTetrahedron', 8820, *[1210, 2568, 711, 1228], 1)
    ops.element('FourNodeTetrahedron', 8821, *[2186, 2621, 2061, 2062], 1)
    ops.element('FourNodeTetrahedron', 8822, *[2479, 2170, 2495, 2559], 1)
    ops.element('FourNodeTetrahedron', 8823, *[2308, 2019, 2321, 2533], 1)
    ops.element('FourNodeTetrahedron', 8824, *[1776, 2190, 1186, 1122], 1)
    ops.element('FourNodeTetrahedron', 8825, *[2500, 2253, 2252, 2274], 1)
    ops.element('FourNodeTetrahedron', 8826, *[1198, 2622, 1128, 1186], 1)
    ops.element('FourNodeTetrahedron', 8827, *[2457, 2459, 2266, 2563], 1)
    ops.element('FourNodeTetrahedron', 8828, *[2439, 2162, 1928, 1926], 1)
    ops.element('FourNodeTetrahedron', 8829, *[1870, 2078, 1235, 1132], 1)
    ops.element('FourNodeTetrahedron', 8830, *[2140, 2379, 1992, 2269], 1)
    ops.element('FourNodeTetrahedron', 8831, *[2493, 2526, 2221, 2356], 1)
    ops.element('FourNodeTetrahedron', 8832, *[1928, 1940, 2397, 1979], 1)
    ops.element('FourNodeTetrahedron', 8833, *[2471, 2640, 2641, 2469], 1)
    ops.element('FourNodeTetrahedron', 8834, *[2638, 2459, 2457, 2563], 1)
    ops.element('FourNodeTetrahedron', 8835, *[2457, 2459, 1759, 2266], 1)
    ops.element('FourNodeTetrahedron', 8836, *[2264, 1764, 2263, 2513], 1)
    ops.element('FourNodeTetrahedron', 8837, *[2264, 2513, 2263, 2349], 1)
    ops.element('FourNodeTetrahedron', 8838, *[2667, 2495, 1158, 511], 1)
    ops.element('FourNodeTetrahedron', 8839, *[2563, 2266, 1177, 2617], 1)
    ops.element('FourNodeTetrahedron', 8840, *[2502, 2140, 2452, 2508], 1)
    ops.element('FourNodeTetrahedron', 8841, *[2368, 2369, 1977, 2118], 1)
    ops.element('FourNodeTetrahedron', 8842, *[2402, 1861, 1204, 1135], 1)
    ops.element('FourNodeTetrahedron', 8843, *[2263, 1764, 2579, 2513], 1)
    ops.element('FourNodeTetrahedron', 8844, *[2453, 2525, 2369, 2656], 1)
    ops.element('FourNodeTetrahedron', 8845, *[2446, 1912, 2345, 1918], 1)
    ops.element('FourNodeTetrahedron', 8846, *[2057, 2625, 2210, 2053], 1)
    ops.element('FourNodeTetrahedron', 8847, *[1227, 2143, 1123, 1240], 1)
    ops.element('FourNodeTetrahedron', 8848, *[2240, 2494, 2242, 2241], 1)
    ops.element('FourNodeTetrahedron', 8849, *[2346, 2470, 1896, 2173], 1)
    ops.element('FourNodeTetrahedron', 8850, *[2263, 2579, 2404, 2513], 1)
    ops.element('FourNodeTetrahedron', 8851, *[2263, 2513, 2404, 2349], 1)
    ops.element('FourNodeTetrahedron', 8852, *[2171, 2172, 1146, 2170], 1)
    ops.element('FourNodeTetrahedron', 8853, *[2318, 2282, 2002, 2280], 1)
    ops.element('FourNodeTetrahedron', 8854, *[1150, 1913, 1220, 2602], 1)
    ops.element('FourNodeTetrahedron', 8855, *[1893, 1988, 747, 1169], 1)
    ops.element('FourNodeTetrahedron', 8856, *[2498, 1858, 2529, 2411], 1)
    ops.element('FourNodeTetrahedron', 8857, *[2498, 2300, 1858, 2411], 1)
    ops.element('FourNodeTetrahedron', 8858, *[2443, 2067, 2365, 2191], 1)
    ops.element('FourNodeTetrahedron', 8859, *[1881, 2504, 2046, 2635], 1)
    ops.element('FourNodeTetrahedron', 8860, *[2568, 2546, 2400, 1810], 1)
    ops.element('FourNodeTetrahedron', 8861, *[2219, 2642, 2111, 2482], 1)
    ops.element('FourNodeTetrahedron', 8862, *[2078, 2016, 2395, 2019], 1)
    ops.element('FourNodeTetrahedron', 8863, *[2430, 2661, 2233, 1838], 1)
    ops.element('FourNodeTetrahedron', 8864, *[1895, 1856, 2538, 2407], 1)
    ops.element('FourNodeTetrahedron', 8865, *[2315, 1954, 2316, 2130], 1)
    ops.element('FourNodeTetrahedron', 8866, *[1825, 2319, 2147, 1826], 1)
    ops.element('FourNodeTetrahedron', 8867, *[2098, 2335, 2336, 2539], 1)
    ops.element('FourNodeTetrahedron', 8868, *[2335, 2540, 2336, 2539], 1)
    ops.element('FourNodeTetrahedron', 8869, *[2284, 2539, 2098, 2255], 1)
    ops.element('FourNodeTetrahedron', 8870, *[2621, 2536, 2356, 2294], 1)
    ops.element('FourNodeTetrahedron', 8871, *[2158, 2417, 2027, 2128], 1)
    ops.element('FourNodeTetrahedron', 8872, *[2451, 2411, 2543, 2676], 1)
    ops.element('FourNodeTetrahedron', 8873, *[2531, 2131, 2631, 2129], 1)
    ops.element('FourNodeTetrahedron', 8874, *[2382, 2131, 2631, 2531], 1)
    ops.element('FourNodeTetrahedron', 8875, *[2382, 2131, 2130, 2631], 1)
    ops.element('FourNodeTetrahedron', 8876, *[2631, 2131, 2130, 2129], 1)
    ops.element('FourNodeTetrahedron', 8877, *[2381, 2382, 2130, 2631], 1)
    ops.element('FourNodeTetrahedron', 8878, *[1905, 1820, 1821, 1819], 1)
    ops.element('FourNodeTetrahedron', 8879, *[2306, 2465, 2255, 2215], 1)
    ops.element('FourNodeTetrahedron', 8880, *[2311, 2330, 2666, 2642], 1)
    ops.element('FourNodeTetrahedron', 8881, *[2592, 2604, 2450, 2384], 1)
    ops.element('FourNodeTetrahedron', 8882, *[1768, 2227, 1942, 2225], 1)
    ops.element('FourNodeTetrahedron', 8883, *[1245, 2443, 1187, 1166], 1)
    ops.element('FourNodeTetrahedron', 8884, *[1936, 2283, 1999, 1930], 1)
    ops.element('FourNodeTetrahedron', 8885, *[2160, 2058, 1931, 2113], 1)
    ops.element('FourNodeTetrahedron', 8886, *[2045, 2105, 2179, 2475], 1)
    ops.element('FourNodeTetrahedron', 8887, *[2106, 1779, 1133, 2443], 1)
    ops.element('FourNodeTetrahedron', 8888, *[1982, 1983, 1984, 1960], 1)
    ops.element('FourNodeTetrahedron', 8889, *[2599, 2305, 734, 2380], 1)
    ops.element('FourNodeTetrahedron', 8890, *[2583, 2510, 2509, 2604], 1)
    ops.element('FourNodeTetrahedron', 8891, *[1764, 1855, 2513, 2498], 1)
    ops.element('FourNodeTetrahedron', 8892, *[2663, 2524, 1985, 1961], 1)
    ops.element('FourNodeTetrahedron', 8893, *[1143, 2047, 1193, 2046], 1)
    ops.element('FourNodeTetrahedron', 8894, *[2016, 2017, 2638, 2395], 1)
    ops.element('FourNodeTetrahedron', 8895, *[2652, 2050, 1903, 1954], 1)
    ops.element('FourNodeTetrahedron', 8896, *[1777, 2679, 1776, 2443], 1)
    ops.element('FourNodeTetrahedron', 8897, *[2292, 2583, 2509, 2604], 1)
    ops.element('FourNodeTetrahedron', 8898, *[1784, 2044, 2524, 1786], 1)
    ops.element('FourNodeTetrahedron', 8899, *[2106, 2679, 2443, 2067], 1)
    ops.element('FourNodeTetrahedron', 8900, *[1183, 1184, 1188, 1796], 1)
    ops.element('FourNodeTetrahedron', 8901, *[2595, 2608, 2442, 2457], 1)
    ops.element('FourNodeTetrahedron', 8902, *[2013, 2349, 1195, 2462], 1)
    ops.element('FourNodeTetrahedron', 8903, *[1183, 1797, 1188, 1796], 1)
    ops.element('FourNodeTetrahedron', 8904, *[1797, 2267, 1798, 1796], 1)
    ops.element('FourNodeTetrahedron', 8905, *[1926, 1884, 1784, 2031], 1)
    ops.element('FourNodeTetrahedron', 8906, *[1183, 1796, 1184, 1131], 1)
    ops.element('FourNodeTetrahedron', 8907, *[2634, 1862, 2630, 2334], 1)
    ops.element('FourNodeTetrahedron', 8908, *[2086, 1899, 2085, 1838], 1)
    ops.element('FourNodeTetrahedron', 8909, *[2086, 1902, 1899, 1838], 1)
    ops.element('FourNodeTetrahedron', 8910, *[1818, 2068, 1200, 1189], 1)
    ops.element('FourNodeTetrahedron', 8911, *[1821, 2068, 1200, 1818], 1)
    ops.element('FourNodeTetrahedron', 8912, *[2385, 2403, 2499, 2626], 1)
    ops.element('FourNodeTetrahedron', 8913, *[2151, 2075, 2150, 2152], 1)
    ops.element('FourNodeTetrahedron', 8914, *[2025, 2168, 2107, 2422], 1)
    ops.element('FourNodeTetrahedron', 8915, *[2485, 1865, 2630, 2634], 1)
    ops.element('FourNodeTetrahedron', 8916, *[2243, 2274, 2533, 2626], 1)
    ops.element('FourNodeTetrahedron', 8917, *[2057, 2670, 2625, 2053], 1)
    ops.element('FourNodeTetrahedron', 8918, *[1147, 2228, 1210, 2229], 1)
    ops.element('FourNodeTetrahedron', 8919, *[2204, 2242, 1974, 2007], 1)
    ops.element('FourNodeTetrahedron', 8920, *[2242, 2007, 1974, 2222], 1)
    ops.element('FourNodeTetrahedron', 8921, *[752, 2473, 743, 2047], 1)
    ops.element('FourNodeTetrahedron', 8922, *[2080, 2079, 2379, 2140], 1)
    ops.element('FourNodeTetrahedron', 8923, *[1855, 2407, 1895, 2496], 1)
    ops.element('FourNodeTetrahedron', 8924, *[2528, 2529, 2405, 2497], 1)
    ops.element('FourNodeTetrahedron', 8925, *[2404, 2579, 2142, 2496], 1)
    ops.element('FourNodeTetrahedron', 8926, *[2438, 2596, 2381, 2578], 1)
    ops.element('FourNodeTetrahedron', 8927, *[2596, 2531, 2381, 2578], 1)
    ops.element('FourNodeTetrahedron', 8928, *[2438, 2381, 2602, 2578], 1)
    ops.element('FourNodeTetrahedron', 8929, *[2381, 2531, 2631, 2578], 1)
    ops.element('FourNodeTetrahedron', 8930, *[2520, 2088, 1809, 2000], 1)
    ops.element('FourNodeTetrahedron', 8931, *[2396, 2114, 2236, 2358], 1)
    ops.element('FourNodeTetrahedron', 8932, *[2346, 2470, 2173, 2390], 1)
    ops.element('FourNodeTetrahedron', 8933, *[2614, 1977, 2119, 2118], 1)
    ops.element('FourNodeTetrahedron', 8934, *[1810, 2520, 1809, 2000], 1)
    ops.element('FourNodeTetrahedron', 8935, *[2120, 2000, 1810, 1811], 1)
    ops.element('FourNodeTetrahedron', 8936, *[2150, 2076, 2129, 1976], 1)
    ops.element('FourNodeTetrahedron', 8937, *[2150, 2152, 2076, 2362], 1)
    ops.element('FourNodeTetrahedron', 8938, *[1232, 1891, 1140, 1172], 1)
    ops.element('FourNodeTetrahedron', 8939, *[1904, 1881, 1882, 1880], 1)
    ops.element('FourNodeTetrahedron', 8940, *[2152, 2076, 2004, 2362], 1)
    ops.element('FourNodeTetrahedron', 8941, *[2525, 2152, 2150, 2362], 1)
    ops.element('FourNodeTetrahedron', 8942, *[1158, 2170, 2662, 2573], 1)
    ops.element('FourNodeTetrahedron', 8943, *[1158, 2662, 683, 2573], 1)
    ops.element('FourNodeTetrahedron', 8944, *[1814, 1817, 2161, 1884], 1)
    ops.element('FourNodeTetrahedron', 8945, *[2651, 2650, 1983, 2044], 1)
    ops.element('FourNodeTetrahedron', 8946, *[1923, 2639, 2200, 2278], 1)
    ops.element('FourNodeTetrahedron', 8947, *[2147, 2422, 2145, 2146], 1)
    ops.element('FourNodeTetrahedron', 8948, *[2402, 1851, 1853, 1861], 1)
    ops.element('FourNodeTetrahedron', 8949, *[1832, 2040, 2041, 2110], 1)
    ops.element('FourNodeTetrahedron', 8950, *[2138, 2139, 2140, 2624], 1)
    ops.element('FourNodeTetrahedron', 8951, *[1974, 2307, 1975, 1973], 1)
    ops.element('FourNodeTetrahedron', 8952, *[1854, 1851, 2402, 2538], 1)
    ops.element('FourNodeTetrahedron', 8953, *[1854, 1851, 1853, 2402], 1)
    ops.element('FourNodeTetrahedron', 8954, *[1214, 2562, 1255, 1130], 1)
    ops.element('FourNodeTetrahedron', 8955, *[1997, 1834, 1835, 1242], 1)
    ops.element('FourNodeTetrahedron', 8956, *[1853, 1851, 2616, 1860], 1)
    ops.element('FourNodeTetrahedron', 8957, *[1245, 2442, 2443, 1166], 1)
    ops.element('FourNodeTetrahedron', 8958, *[2219, 2520, 1810, 2000], 1)
    ops.element('FourNodeTetrahedron', 8959, *[1782, 2446, 2680, 2345], 1)
    ops.element('FourNodeTetrahedron', 8960, *[606, 551, 1155, 2202], 1)
    ops.element('FourNodeTetrahedron', 8961, *[2219, 2546, 2520, 2088], 1)
    ops.element('FourNodeTetrahedron', 8962, *[1768, 2460, 1942, 2227], 1)
    ops.element('FourNodeTetrahedron', 8963, *[2004, 2245, 1868, 1754], 1)
    ops.element('FourNodeTetrahedron', 8964, *[2129, 2076, 1868, 1976], 1)
    ops.element('FourNodeTetrahedron', 8965, *[1976, 2004, 1754, 2362], 1)
    ops.element('FourNodeTetrahedron', 8966, *[1945, 2246, 1943, 2014], 1)
    ops.element('FourNodeTetrahedron', 8967, *[1976, 2076, 1868, 2004], 1)
    ops.element('FourNodeTetrahedron', 8968, *[1976, 2076, 2004, 2362], 1)
    ops.element('FourNodeTetrahedron', 8969, *[1839, 2086, 1837, 1838], 1)
    ops.element('FourNodeTetrahedron', 8970, *[2640, 1757, 1758, 1806], 1)
    ops.element('FourNodeTetrahedron', 8971, *[1826, 2421, 2147, 2146], 1)
    ops.element('FourNodeTetrahedron', 8972, *[1925, 1908, 2093, 1948], 1)
    ops.element('FourNodeTetrahedron', 8973, *[2211, 2574, 1887, 2292], 1)
    ops.element('FourNodeTetrahedron', 8974, *[2471, 1757, 2640, 1806], 1)
    ops.element('FourNodeTetrahedron', 8975, *[1805, 2427, 1804, 1807], 1)
    ops.element('FourNodeTetrahedron', 8976, *[2390, 1805, 2469, 1806], 1)
    ops.element('FourNodeTetrahedron', 8977, *[1807, 2184, 1806, 2186], 1)
    ops.element('FourNodeTetrahedron', 8978, *[1934, 2588, 2000, 1936], 1)
    ops.element('FourNodeTetrahedron', 8979, *[1806, 2184, 2621, 2186], 1)
    ops.element('FourNodeTetrahedron', 8980, *[1917, 2085, 2334, 1916], 1)
    ops.element('FourNodeTetrahedron', 8981, *[2530, 2158, 2157, 2159], 1)
    ops.element('FourNodeTetrahedron', 8982, *[2467, 2006, 1892, 2010], 1)
    ops.element('FourNodeTetrahedron', 8983, *[1805, 1807, 1806, 2322], 1)
    ops.element('FourNodeTetrahedron', 8984, *[2322, 1807, 1806, 2186], 1)
    ops.element('FourNodeTetrahedron', 8985, *[2225, 2014, 2556, 2226], 1)
    ops.element('FourNodeTetrahedron', 8986, *[2093, 1806, 2390, 2061], 1)
    ops.element('FourNodeTetrahedron', 8987, *[2075, 2002, 2076, 2152], 1)
    ops.element('FourNodeTetrahedron', 8988, *[2024, 2137, 740, 2299], 1)
    ops.element('FourNodeTetrahedron', 8989, *[2024, 2137, 2299, 2023], 1)
    ops.element('FourNodeTetrahedron', 8990, *[1155, 2204, 1859, 2202], 1)
    ops.element('FourNodeTetrahedron', 8991, *[1155, 1859, 1232, 2202], 1)
    ops.element('FourNodeTetrahedron', 8992, *[1155, 1859, 1215, 1232], 1)
    ops.element('FourNodeTetrahedron', 8993, *[2405, 1974, 1861, 1859], 1)
    ops.element('FourNodeTetrahedron', 8994, *[1934, 2000, 2219, 2588], 1)
    ops.element('FourNodeTetrahedron', 8995, *[2405, 1859, 1155, 2204], 1)
    ops.element('FourNodeTetrahedron', 8996, *[2199, 1862, 1950, 2334], 1)
    ops.element('FourNodeTetrahedron', 8997, *[2463, 1997, 1173, 1998], 1)
    ops.element('FourNodeTetrahedron', 8998, *[1861, 1859, 1215, 1155], 1)
    ops.element('FourNodeTetrahedron', 8999, *[2405, 1859, 1861, 1155], 1)
    ops.element('FourNodeTetrahedron', 9000, *[2017, 1770, 2563, 2248], 1)
    ops.element('FourNodeTetrahedron', 9001, *[2594, 2462, 1194, 621], 1)
    ops.element('FourNodeTetrahedron', 9002, *[2166, 2165, 167, 2164], 1)
    ops.element('FourNodeTetrahedron', 9003, *[2351, 2110, 2109, 2681], 1)
    ops.element('FourNodeTetrahedron', 9004, *[2485, 2634, 2630, 2555], 1)
    ops.element('FourNodeTetrahedron', 9005, *[2007, 2006, 2467, 2010], 1)
    ops.element('FourNodeTetrahedron', 9006, *[1792, 2609, 2296, 2610], 1)
    ops.element('FourNodeTetrahedron', 9007, *[1908, 1946, 2322, 2093], 1)
    ops.element('FourNodeTetrahedron', 9008, *[1896, 2157, 2538, 2173], 1)
    ops.element('FourNodeTetrahedron', 9009, *[2125, 1830, 1932, 2058], 1)
    ops.element('FourNodeTetrahedron', 9010, *[2125, 1932, 1931, 2058], 1)
    ops.element('FourNodeTetrahedron', 9011, *[1776, 2365, 2190, 1122], 1)
    ops.element('FourNodeTetrahedron', 9012, *[1830, 1829, 1932, 2058], 1)
    ops.element('FourNodeTetrahedron', 9013, *[2345, 2388, 1858, 2094], 1)
    ops.element('FourNodeTetrahedron', 9014, *[1817, 2650, 2044, 1885], 1)
    ops.element('FourNodeTetrahedron', 9015, *[2493, 2536, 2241, 2356], 1)
    ops.element('FourNodeTetrahedron', 9016, *[2168, 1931, 1852, 2157], 1)
    ops.element('FourNodeTetrahedron', 9017, *[2489, 1772, 1834, 2260], 1)
    ops.element('FourNodeTetrahedron', 9018, *[1879, 2635, 1163, 2009], 1)
    ops.element('FourNodeTetrahedron', 9019, *[1975, 2255, 2537, 1191], 1)
    ops.element('FourNodeTetrahedron', 9020, *[2333, 2199, 2195, 2200], 1)
    ops.element('FourNodeTetrahedron', 9021, *[2389, 1806, 2516, 2061], 1)
    ops.element('FourNodeTetrahedron', 9022, *[2483, 2199, 2195, 2333], 1)
    ops.element('FourNodeTetrahedron', 9023, *[2311, 2331, 2642, 2482], 1)
    ops.element('FourNodeTetrahedron', 9024, *[2470, 2677, 2641, 2471], 1)
    ops.element('FourNodeTetrahedron', 9025, *[2635, 2046, 1163, 1124], 1)
    ops.element('FourNodeTetrahedron', 9026, *[2142, 2528, 1231, 2412], 1)
    ops.element('FourNodeTetrahedron', 9027, *[1214, 2120, 1811, 2562], 1)
    ops.element('FourNodeTetrahedron', 9028, *[1250, 2266, 1243, 1177], 1)
    ops.element('FourNodeTetrahedron', 9029, *[2310, 2331, 2482, 1803], 1)
    ops.element('FourNodeTetrahedron', 9030, *[2310, 1803, 2482, 2026], 1)
    ops.element('FourNodeTetrahedron', 9031, *[2390, 1806, 2389, 2061], 1)
    ops.element('FourNodeTetrahedron', 9032, *[1891, 2006, 2619, 1892], 1)
    ops.element('FourNodeTetrahedron', 9033, *[2026, 2482, 1934, 2440], 1)
    ops.element('FourNodeTetrahedron', 9034, *[2546, 2090, 2520, 2088], 1)
    ops.element('FourNodeTetrahedron', 9035, *[2094, 2389, 2544, 2061], 1)
    ops.element('FourNodeTetrahedron', 9036, *[1917, 2334, 2333, 1914], 1)
    ops.element('FourNodeTetrahedron', 9037, *[2454, 2353, 2305, 2352], 1)
    ops.element('FourNodeTetrahedron', 9038, *[1781, 1988, 1169, 1258], 1)
    ops.element('FourNodeTetrahedron', 9039, *[1912, 2448, 2390, 2322], 1)
    ops.element('FourNodeTetrahedron', 9040, *[2602, 2073, 1220, 1126], 1)
    ops.element('FourNodeTetrahedron', 9041, *[1896, 2173, 2538, 1856], 1)
    ops.element('FourNodeTetrahedron', 9042, *[1872, 2416, 2184, 2612], 1)
    ops.element('FourNodeTetrahedron', 9043, *[1845, 1846, 2059, 2314], 1)
    ops.element('FourNodeTetrahedron', 9044, *[2299, 1907, 1905, 2021], 1)
    ops.element('FourNodeTetrahedron', 9045, *[2669, 1820, 1819, 2115], 1)
    ops.element('FourNodeTetrahedron', 9046, *[2023, 1907, 2299, 2021], 1)
    ops.element('FourNodeTetrahedron', 9047, *[2189, 1970, 2339, 2387], 1)
    ops.element('FourNodeTetrahedron', 9048, *[2070, 2463, 1151, 2408], 1)
    ops.element('FourNodeTetrahedron', 9049, *[1810, 2000, 1809, 1811], 1)
    ops.element('FourNodeTetrahedron', 9050, *[2233, 2232, 1900, 2637], 1)
    ops.element('FourNodeTetrahedron', 9051, *[1814, 1815, 1816, 2032], 1)
    ops.element('FourNodeTetrahedron', 9052, *[2263, 2148, 2579, 2404], 1)
    ops.element('FourNodeTetrahedron', 9053, *[2579, 1855, 1895, 2496], 1)
    ops.element('FourNodeTetrahedron', 9054, *[1855, 2407, 2496, 2529], 1)
    ops.element('FourNodeTetrahedron', 9055, *[2357, 1980, 1981, 2214], 1)
    ops.element('FourNodeTetrahedron', 9056, *[2566, 2665, 1789, 2175], 1)
    ops.element('FourNodeTetrahedron', 9057, *[1922, 1919, 1921, 1924], 1)
    ops.element('FourNodeTetrahedron', 9058, *[2364, 2546, 2230, 2219], 1)
    ops.element('FourNodeTetrahedron', 9059, *[2357, 2055, 1980, 2214], 1)
    ops.element('FourNodeTetrahedron', 9060, *[1215, 1975, 1130, 1191], 1)
    ops.element('FourNodeTetrahedron', 9061, *[1768, 2227, 2225, 2051], 1)
    ops.element('FourNodeTetrahedron', 9062, *[1887, 1889, 2012, 1886], 1)
    ops.element('FourNodeTetrahedron', 9063, *[1868, 2245, 1867, 1754], 1)
    ops.element('FourNodeTetrahedron', 9064, *[1952, 1954, 2048, 1953], 1)
    ops.element('FourNodeTetrahedron', 9065, *[2646, 2056, 2055, 2035], 1)
    ops.element('FourNodeTetrahedron', 9066, *[2652, 1904, 1903, 2050], 1)
    ops.element('FourNodeTetrahedron', 9067, *[2305, 1199, 734, 1174], 1)
    ops.element('FourNodeTetrahedron', 9068, *[2310, 2311, 2331, 2482], 1)
    ops.element('FourNodeTetrahedron', 9069, *[1808, 2473, 2047, 2045], 1)
    ops.element('FourNodeTetrahedron', 9070, *[2310, 2311, 2364, 2482], 1)
    ops.element('FourNodeTetrahedron', 9071, *[2364, 2642, 2219, 2482], 1)
    ops.element('FourNodeTetrahedron', 9072, *[2479, 2338, 2560, 2590], 1)
    ops.element('FourNodeTetrahedron', 9073, *[1933, 1936, 2120, 2562], 1)
    ops.element('FourNodeTetrahedron', 9074, *[2591, 2495, 2667, 2559], 1)
    ops.element('FourNodeTetrahedron', 9075, *[1928, 2265, 1940, 1941], 1)
    ops.element('FourNodeTetrahedron', 9076, *[1941, 1784, 1961, 1844], 1)
    ops.element('FourNodeTetrahedron', 9077, *[2358, 1784, 1941, 1844], 1)
    ops.element('FourNodeTetrahedron', 9078, *[511, 2495, 2667, 2518], 1)
    ops.element('FourNodeTetrahedron', 9079, *[1938, 1939, 2571, 2114], 1)
    ops.element('FourNodeTetrahedron', 9080, *[2484, 1865, 2541, 2199], 1)
    ops.element('FourNodeTetrahedron', 9081, *[2518, 2495, 2667, 2591], 1)
    ops.element('FourNodeTetrahedron', 9082, *[2513, 2496, 2412, 2350], 1)
    ops.element('FourNodeTetrahedron', 9083, *[2242, 2241, 2222, 2194], 1)
    ops.element('FourNodeTetrahedron', 9084, *[2229, 2568, 1810, 1935], 1)
    ops.element('FourNodeTetrahedron', 9085, *[2241, 2356, 2222, 2194], 1)
    ops.element('FourNodeTetrahedron', 9086, *[2356, 2192, 2222, 2194], 1)
    ops.element('FourNodeTetrahedron', 9087, *[2194, 2192, 2222, 2193], 1)
    ops.element('FourNodeTetrahedron', 9088, *[2005, 2623, 2585, 1763], 1)
    ops.element('FourNodeTetrahedron', 9089, *[1761, 1760, 748, 1988], 1)
    ops.element('FourNodeTetrahedron', 9090, *[2194, 2222, 2203, 2193], 1)
    ops.element('FourNodeTetrahedron', 9091, *[2242, 2222, 2203, 2194], 1)
    ops.element('FourNodeTetrahedron', 9092, *[2153, 2051, 1883, 2054], 1)
    ops.element('FourNodeTetrahedron', 9093, *[1891, 2619, 1140, 1892], 1)
    ops.element('FourNodeTetrahedron', 9094, *[2358, 2236, 513, 2237], 1)
    ops.element('FourNodeTetrahedron', 9095, *[2483, 2199, 2465, 2195], 1)
    ops.element('FourNodeTetrahedron', 9096, *[1997, 1835, 723, 1242], 1)
    ops.element('FourNodeTetrahedron', 9097, *[2584, 1925, 2303, 2205], 1)
    ops.element('FourNodeTetrahedron', 9098, *[2641, 2113, 2325, 2516], 1)
    ops.element('FourNodeTetrahedron', 9099, *[1943, 2014, 2015, 2556], 1)
    ops.element('FourNodeTetrahedron', 9100, *[1124, 2595, 1241, 2258], 1)
    ops.element('FourNodeTetrahedron', 9101, *[1792, 2609, 1793, 1795], 1)
    ops.element('FourNodeTetrahedron', 9102, *[2524, 2044, 1960, 1786], 1)
    ops.element('FourNodeTetrahedron', 9103, *[2203, 2222, 2010, 2193], 1)
    ops.element('FourNodeTetrahedron', 9104, *[2654, 1775, 2489, 2490], 1)
    ops.element('FourNodeTetrahedron', 9105, *[1162, 2046, 1143, 1163], 1)
    ops.element('FourNodeTetrahedron', 9106, *[2634, 1902, 1901, 1899], 1)
    ops.element('FourNodeTetrahedron', 9107, *[1882, 1881, 1808, 1879], 1)
    ops.element('FourNodeTetrahedron', 9108, *[1910, 2575, 1911, 1946], 1)
    ops.element('FourNodeTetrahedron', 9109, *[1747, 1972, 2213, 1969], 1)
    ops.element('FourNodeTetrahedron', 9110, *[1947, 2277, 1946, 1871], 1)
    ops.element('FourNodeTetrahedron', 9111, *[1916, 1899, 2334, 2606], 1)
    ops.element('FourNodeTetrahedron', 9112, *[2334, 1899, 1950, 2606], 1)
    ops.element('FourNodeTetrahedron', 9113, *[2178, 2627, 1161, 1779], 1)
    ops.element('FourNodeTetrahedron', 9114, *[2529, 2388, 2407, 2682], 1)
    ops.element('FourNodeTetrahedron', 9115, *[2407, 2388, 2538, 2682], 1)
    ops.element('FourNodeTetrahedron', 9116, *[2683, 759, 772, 1159], 1)
    ops.element('FourNodeTetrahedron', 9117, *[2676, 2558, 2542, 2543], 1)
    ops.element('FourNodeTetrahedron', 9118, *[2324, 2545, 2549, 2223], 1)
    ops.element('FourNodeTetrahedron', 9119, *[2277, 2185, 2186, 1871], 1)
    ops.element('FourNodeTetrahedron', 9120, *[1897, 1896, 1854, 1895], 1)
    ops.element('FourNodeTetrahedron', 9121, *[2482, 1832, 2588, 1830], 1)
    ops.element('FourNodeTetrahedron', 9122, *[2318, 2317, 2282, 2326], 1)
    ops.element('FourNodeTetrahedron', 9123, *[1917, 2334, 1914, 1916], 1)
    ops.element('FourNodeTetrahedron', 9124, *[2223, 2545, 2549, 1793], 1)
    ops.element('FourNodeTetrahedron', 9125, *[1207, 1882, 1162, 1139], 1)
    ops.element('FourNodeTetrahedron', 9126, *[1848, 2153, 2234, 2054], 1)
    ops.element('FourNodeTetrahedron', 9127, *[2554, 1904, 1882, 1880], 1)
    ops.element('FourNodeTetrahedron', 9128, *[2174, 1902, 2634, 2086], 1)
    ops.element('FourNodeTetrahedron', 9129, *[2581, 2601, 1963, 2414], 1)
    ops.element('FourNodeTetrahedron', 9130, *[2174, 1901, 2634, 1902], 1)
    ops.element('FourNodeTetrahedron', 9131, *[2174, 1901, 1890, 2634], 1)
    ops.element('FourNodeTetrahedron', 9132, *[1895, 1854, 2402, 2538], 1)
    ops.element('FourNodeTetrahedron', 9133, *[2632, 2025, 2261, 2422], 1)
    ops.element('FourNodeTetrahedron', 9134, *[2632, 2168, 2025, 2422], 1)
    ops.element('FourNodeTetrahedron', 9135, *[1768, 1956, 2227, 2051], 1)
    ops.element('FourNodeTetrahedron', 9136, *[2464, 2110, 2681, 2376], 1)
    ops.element('FourNodeTetrahedron', 9137, *[2004, 2001, 2332, 2361], 1)
    ops.element('FourNodeTetrahedron', 9138, *[2632, 2168, 2422, 2530], 1)
    ops.element('FourNodeTetrahedron', 9139, *[2528, 2402, 1135, 1231], 1)
    ops.element('FourNodeTetrahedron', 9140, *[2632, 2043, 2025, 2168], 1)
    ops.element('FourNodeTetrahedron', 9141, *[2128, 2126, 2125, 2160], 1)
    ops.element('FourNodeTetrahedron', 9142, *[2248, 2249, 1771, 1958], 1)
    ops.element('FourNodeTetrahedron', 9143, *[2632, 2043, 2168, 2530], 1)
    ops.element('FourNodeTetrahedron', 9144, *[2635, 2504, 2046, 2275], 1)
    ops.element('FourNodeTetrahedron', 9145, *[1163, 2046, 1143, 1165], 1)
    ops.element('FourNodeTetrahedron', 9146, *[2287, 2684, 2262, 1901], 1)
    ops.element('FourNodeTetrahedron', 9147, *[1819, 1818, 1230, 1233], 1)
    ops.element('FourNodeTetrahedron', 9148, *[1233, 1818, 1189, 2104], 1)
    ops.element('FourNodeTetrahedron', 9149, *[2046, 1193, 1143, 1165], 1)
    ops.element('FourNodeTetrahedron', 9150, *[2137, 2011, 737, 2299], 1)
    ops.element('FourNodeTetrahedron', 9151, *[1881, 2045, 2046, 2504], 1)
    ops.element('FourNodeTetrahedron', 9152, *[1913, 2381, 1955, 2073], 1)
    ops.element('FourNodeTetrahedron', 9153, *[1920, 1924, 2301, 2377], 1)
    ops.element('FourNodeTetrahedron', 9154, *[1195, 2349, 1138, 1154], 1)
    ops.element('FourNodeTetrahedron', 9155, *[2439, 2033, 1926, 1927], 1)
    ops.element('FourNodeTetrahedron', 9156, *[2644, 2032, 1926, 2033], 1)
    ops.element('FourNodeTetrahedron', 9157, *[2439, 2644, 1926, 2033], 1)
    ops.element('FourNodeTetrahedron', 9158, *[1230, 1818, 1189, 1233], 1)
    ops.element('FourNodeTetrahedron', 9159, *[2417, 1802, 2027, 2127], 1)
    ops.element('FourNodeTetrahedron', 9160, *[2439, 2644, 2163, 1926], 1)
    ops.element('FourNodeTetrahedron', 9161, *[1928, 1979, 2397, 2358], 1)
    ops.element('FourNodeTetrahedron', 9162, *[2104, 1818, 1189, 1825], 1)
    ops.element('FourNodeTetrahedron', 9163, *[1818, 2068, 1189, 1825], 1)
    ops.element('FourNodeTetrahedron', 9164, *[2104, 1827, 1818, 1825], 1)
    ops.element('FourNodeTetrahedron', 9165, *[1818, 1827, 2068, 1825], 1)
    ops.element('FourNodeTetrahedron', 9166, *[2362, 2152, 2004, 2360], 1)
    ops.element('FourNodeTetrahedron', 9167, *[1818, 2320, 2068, 1827], 1)
    ops.element('FourNodeTetrahedron', 9168, *[2275, 2106, 2442, 2458], 1)
    ops.element('FourNodeTetrahedron', 9169, *[1925, 1948, 2093, 2155], 1)
    ops.element('FourNodeTetrahedron', 9170, *[2334, 1862, 1950, 1899], 1)
    ops.element('FourNodeTetrahedron', 9171, *[2171, 2578, 2602, 2172], 1)
    ops.element('FourNodeTetrahedron', 9172, *[2405, 2682, 2204, 2542], 1)
    ops.element('FourNodeTetrahedron', 9173, *[1157, 2134, 175, 176], 1)
    ops.element('FourNodeTetrahedron', 9174, *[2348, 2412, 1196, 2410], 1)
    ops.element('FourNodeTetrahedron', 9175, *[2682, 2242, 2204, 2492], 1)
    ops.element('FourNodeTetrahedron', 9176, *[2605, 2302, 2350, 2507], 1)
    ops.element('FourNodeTetrahedron', 9177, *[2009, 2635, 2257, 2049], 1)
    ops.element('FourNodeTetrahedron', 9178, *[2010, 2522, 2523, 2474], 1)
    ops.element('FourNodeTetrahedron', 9179, *[2264, 1765, 1764, 2512], 1)
    ops.element('FourNodeTetrahedron', 9180, *[2605, 2301, 2350, 2302], 1)
    ops.element('FourNodeTetrahedron', 9181, *[2052, 2594, 621, 2384], 1)
    ops.element('FourNodeTetrahedron', 9182, *[2609, 2685, 2296, 2610], 1)
    ops.element('FourNodeTetrahedron', 9183, *[2542, 2492, 2204, 2558], 1)
    ops.element('FourNodeTetrahedron', 9184, *[1800, 2633, 2331, 1801], 1)
    ops.element('FourNodeTetrahedron', 9185, *[1838, 1900, 1899, 2564], 1)
    ops.element('FourNodeTetrahedron', 9186, *[2542, 2682, 2204, 2492], 1)
    ops.element('FourNodeTetrahedron', 9187, *[2529, 2682, 2405, 2542], 1)
    ops.element('FourNodeTetrahedron', 9188, *[2392, 2490, 2489, 2491], 1)
    ops.element('FourNodeTetrahedron', 9189, *[2248, 1958, 2153, 2274], 1)
    ops.element('FourNodeTetrahedron', 9190, *[2526, 2103, 2309, 2221], 1)
    ops.element('FourNodeTetrahedron', 9191, *[2582, 1774, 2183, 1834], 1)
    ops.element('FourNodeTetrahedron', 9192, *[1222, 2602, 1220, 1126], 1)
    ops.element('FourNodeTetrahedron', 9193, *[1887, 2012, 2246, 2014], 1)
    ops.element('FourNodeTetrahedron', 9194, *[2561, 2508, 2590, 2591], 1)
    ops.element('FourNodeTetrahedron', 9195, *[2071, 2316, 1869, 1868], 1)
    ops.element('FourNodeTetrahedron', 9196, *[2107, 1935, 1836, 1949], 1)
    ops.element('FourNodeTetrahedron', 9197, *[2130, 2316, 2071, 2132], 1)
    ops.element('FourNodeTetrahedron', 9198, *[2631, 2130, 2071, 2129], 1)
    ops.element('FourNodeTetrahedron', 9199, *[2568, 2400, 711, 1228], 1)
    ops.element('FourNodeTetrahedron', 9200, *[1886, 2509, 2347, 2604], 1)
    ops.element('FourNodeTetrahedron', 9201, *[1806, 1758, 2516, 2621], 1)
    ops.element('FourNodeTetrahedron', 9202, *[2640, 1758, 1755, 2516], 1)
    ops.element('FourNodeTetrahedron', 9203, *[2640, 1758, 2516, 1806], 1)
    ops.element('FourNodeTetrahedron', 9204, *[2538, 2325, 2406, 2240], 1)
    ops.element('FourNodeTetrahedron', 9205, *[2505, 1799, 1188, 1797], 1)
    ops.element('FourNodeTetrahedron', 9206, *[2680, 2446, 2346, 2345], 1)
    ops.element('FourNodeTetrahedron', 9207, *[1911, 2393, 1912, 2322], 1)
    ops.element('FourNodeTetrahedron', 9208, *[1813, 1817, 2161, 1814], 1)
    ops.element('FourNodeTetrahedron', 9209, *[2061, 1806, 2516, 2621], 1)
    ops.element('FourNodeTetrahedron', 9210, *[2107, 2026, 1935, 1852], 1)
    ops.element('FourNodeTetrahedron', 9211, *[2271, 2317, 1989, 2327], 1)
    ops.element('FourNodeTetrahedron', 9212, *[2634, 1899, 2334, 2085], 1)
    ops.element('FourNodeTetrahedron', 9213, *[2160, 2433, 2058, 2113], 1)
    ops.element('FourNodeTetrahedron', 9214, *[2433, 2112, 2058, 2113], 1)
    ops.element('FourNodeTetrahedron', 9215, *[1803, 1830, 2482, 2440], 1)
    ops.element('FourNodeTetrahedron', 9216, *[2113, 2433, 2112, 1755], 1)
    ops.element('FourNodeTetrahedron', 9217, *[1174, 2070, 1136, 1200], 1)
    ops.element('FourNodeTetrahedron', 9218, *[2434, 2433, 2113, 1755], 1)
    ops.element('FourNodeTetrahedron', 9219, *[1175, 2234, 1181, 633], 1)
    ops.element('FourNodeTetrahedron', 9220, *[2434, 1755, 2113, 2640], 1)
    ops.element('FourNodeTetrahedron', 9221, *[2641, 2434, 2113, 2640], 1)
    ops.element('FourNodeTetrahedron', 9222, *[2640, 1755, 2113, 2516], 1)
    ops.element('FourNodeTetrahedron', 9223, *[1990, 2152, 2360, 2318], 1)
    ops.element('FourNodeTetrahedron', 9224, *[2641, 2640, 2113, 2516], 1)
    ops.element('FourNodeTetrahedron', 9225, *[2337, 2140, 2452, 2624], 1)
    ops.element('FourNodeTetrahedron', 9226, *[2160, 2434, 2113, 2641], 1)
    ops.element('FourNodeTetrahedron', 9227, *[2160, 2434, 2433, 2113], 1)
    ops.element('FourNodeTetrahedron', 9228, *[2220, 2364, 2219, 2482], 1)
    ops.element('FourNodeTetrahedron', 9229, *[2493, 2526, 2494, 2221], 1)
    ops.element('FourNodeTetrahedron', 9230, *[2035, 2036, 1747, 2486], 1)
    ops.element('FourNodeTetrahedron', 9231, *[1910, 1946, 1908, 2212], 1)
    ops.element('FourNodeTetrahedron', 9232, *[2536, 2527, 2526, 2097], 1)
    ops.element('FourNodeTetrahedron', 9233, *[2283, 2435, 2284, 1996], 1)
    ops.element('FourNodeTetrahedron', 9234, *[1769, 2460, 1768, 2227], 1)
    ops.element('FourNodeTetrahedron', 9235, *[1184, 1799, 2143, 1937], 1)
    ops.element('FourNodeTetrahedron', 9236, *[2265, 2663, 1939, 1941], 1)
    ops.element('FourNodeTetrahedron', 9237, *[2454, 2455, 2352, 2070], 1)
    ops.element('FourNodeTetrahedron', 9238, *[1843, 2652, 1955, 2383], 1)
    ops.element('FourNodeTetrahedron', 9239, *[2468, 2273, 2294, 2416], 1)
    ops.element('FourNodeTetrahedron', 9240, *[2236, 2237, 1898, 1913], 1)
    ops.element('FourNodeTetrahedron', 9241, *[1987, 1909, 1911, 1912], 1)
    ops.element('FourNodeTetrahedron', 9242, *[1871, 1873, 2185, 1872], 1)
    ops.element('FourNodeTetrahedron', 9243, *[2119, 1754, 1751, 1752], 1)
    ops.element('FourNodeTetrahedron', 9244, *[2479, 2590, 2559, 2591], 1)
    ops.element('FourNodeTetrahedron', 9245, *[1958, 1956, 2051, 2210], 1)
    ops.element('FourNodeTetrahedron', 9246, *[2146, 2530, 1854, 1896], 1)
    ops.element('FourNodeTetrahedron', 9247, *[2006, 2619, 1892, 2522], 1)
    ops.element('FourNodeTetrahedron', 9248, *[1929, 1784, 2358, 1980], 1)
    ops.element('FourNodeTetrahedron', 9249, *[2331, 2328, 2330, 2111], 1)
    ops.element('FourNodeTetrahedron', 9250, *[2185, 2686, 2468, 2551], 1)
    ops.element('FourNodeTetrahedron', 9251, *[1223, 2074, 1234, 1235], 1)
    ops.element('FourNodeTetrahedron', 9252, *[2667, 1158, 682, 511], 1)
    ops.element('FourNodeTetrahedron', 9253, *[1970, 1971, 1969, 2138], 1)
    ops.element('FourNodeTetrahedron', 9254, *[2266, 1942, 1185, 1137], 1)
    ops.element('FourNodeTetrahedron', 9255, *[1750, 1836, 2229, 1949], 1)
    ops.element('FourNodeTetrahedron', 9256, *[1779, 1776, 1187, 2443], 1)
    ops.element('FourNodeTetrahedron', 9257, *[1892, 2522, 2619, 1923], 1)
    ops.element('FourNodeTetrahedron', 9258, *[2465, 2336, 2250, 2196], 1)
    ops.element('FourNodeTetrahedron', 9259, *[2520, 2167, 2401, 1809], 1)
    ops.element('FourNodeTetrahedron', 9260, *[2073, 2315, 2074, 2071], 1)
    ops.element('FourNodeTetrahedron', 9261, *[2596, 2413, 2531, 2577], 1)
    ops.element('FourNodeTetrahedron', 9262, *[2113, 1755, 2526, 2493], 1)
    ops.element('FourNodeTetrahedron', 9263, *[2344, 1794, 1792, 1795], 1)
    ops.element('FourNodeTetrahedron', 9264, *[2356, 2221, 2222, 2192], 1)
    ops.element('FourNodeTetrahedron', 9265, *[2080, 2079, 2151, 2379], 1)
    ops.element('FourNodeTetrahedron', 9266, *[1126, 1978, 1236, 1257], 1)
    ops.element('FourNodeTetrahedron', 9267, *[2338, 2502, 2560, 2590], 1)
    ops.element('FourNodeTetrahedron', 9268, *[2438, 2381, 1913, 2602], 1)
    ops.element('FourNodeTetrahedron', 9269, *[1150, 2438, 1913, 2602], 1)
    ops.element('FourNodeTetrahedron', 9270, *[1150, 2602, 1222, 2171], 1)
    ops.element('FourNodeTetrahedron', 9271, *[1150, 2438, 2602, 2171], 1)
    ops.element('FourNodeTetrahedron', 9272, *[2335, 2681, 2436, 2540], 1)
    ops.element('FourNodeTetrahedron', 9273, *[2335, 2540, 2436, 2336], 1)
    ops.element('FourNodeTetrahedron', 9274, *[1251, 1853, 1204, 2402], 1)
    ops.element('FourNodeTetrahedron', 9275, *[1926, 2032, 1814, 2031], 1)
    ops.element('FourNodeTetrahedron', 9276, *[2024, 2023, 2299, 2021], 1)
    ops.element('FourNodeTetrahedron', 9277, *[2002, 2432, 2003, 2001], 1)
    ops.element('FourNodeTetrahedron', 9278, *[2421, 2530, 2422, 2146], 1)
    ops.element('FourNodeTetrahedron', 9279, *[1936, 1999, 1811, 2562], 1)
    ops.element('FourNodeTetrahedron', 9280, *[1811, 2135, 2133, 1999], 1)
    ops.element('FourNodeTetrahedron', 9281, *[2572, 2170, 2573, 2559], 1)
    ops.element('FourNodeTetrahedron', 9282, *[2577, 2151, 2150, 1992], 1)
    ops.element('FourNodeTetrahedron', 9283, *[2528, 2407, 2402, 2405], 1)
    ops.element('FourNodeTetrahedron', 9284, *[1995, 2102, 2309, 2103], 1)
    ops.element('FourNodeTetrahedron', 9285, *[2526, 2030, 1995, 2103], 1)
    ops.element('FourNodeTetrahedron', 9286, *[2357, 2055, 2214, 1747], 1)
    ops.element('FourNodeTetrahedron', 9287, *[2357, 2438, 2238, 2479], 1)
    ops.element('FourNodeTetrahedron', 9288, *[1995, 2030, 2102, 2103], 1)
    ops.element('FourNodeTetrahedron', 9289, *[1824, 2288, 2101, 1890], 1)
    ops.element('FourNodeTetrahedron', 9290, *[2103, 1824, 2101, 1890], 1)
    ops.element('FourNodeTetrahedron', 9291, *[2120, 1936, 1811, 2562], 1)
    ops.element('FourNodeTetrahedron', 9292, *[2120, 2000, 1811, 1936], 1)
    ops.element('FourNodeTetrahedron', 9293, *[2184, 2294, 2621, 2612], 1)
    ops.element('FourNodeTetrahedron', 9294, *[2617, 1771, 1768, 2154], 1)
    ops.element('FourNodeTetrahedron', 9295, *[2184, 2294, 2612, 2416], 1)
    ops.element('FourNodeTetrahedron', 9296, *[1762, 1841, 2398, 1842], 1)
    ops.element('FourNodeTetrahedron', 9297, *[1158, 2170, 1229, 2662], 1)
    ops.element('FourNodeTetrahedron', 9298, *[2026, 1803, 2482, 2440], 1)
    ops.element('FourNodeTetrahedron', 9299, *[2236, 2114, 2449, 1844], 1)
    ops.element('FourNodeTetrahedron', 9300, *[2199, 2198, 2197, 2195], 1)
    ops.element('FourNodeTetrahedron', 9301, *[2420, 2150, 1976, 2362], 1)
    ops.element('FourNodeTetrahedron', 9302, *[2101, 2313, 1824, 2103], 1)
    ops.element('FourNodeTetrahedron', 9303, *[2030, 2313, 2102, 2103], 1)
    ops.element('FourNodeTetrahedron', 9304, *[2102, 2313, 2101, 2103], 1)
    ops.element('FourNodeTetrahedron', 9305, *[2577, 2150, 2525, 1992], 1)
    ops.element('FourNodeTetrahedron', 9306, *[2108, 2373, 2089, 2111], 1)
    ops.element('FourNodeTetrahedron', 9307, *[1184, 2143, 1227, 1240], 1)
    ops.element('FourNodeTetrahedron', 9308, *[2561, 2337, 2338, 2508], 1)
    ops.element('FourNodeTetrahedron', 9309, *[2324, 2549, 2082, 2223], 1)
    ops.element('FourNodeTetrahedron', 9310, *[1975, 2255, 1191, 1891], 1)
    ops.element('FourNodeTetrahedron', 9311, *[2214, 2532, 1981, 2596], 1)
    ops.element('FourNodeTetrahedron', 9312, *[2171, 2438, 2602, 2578], 1)
    ops.element('FourNodeTetrahedron', 9313, *[2502, 2577, 2525, 1992], 1)
    ops.element('FourNodeTetrahedron', 9314, *[2398, 2623, 1763, 1904], 1)
    ops.element('FourNodeTetrahedron', 9315, *[1162, 1808, 1143, 2046], 1)
    ops.element('FourNodeTetrahedron', 9316, *[2578, 2577, 2150, 2525], 1)
    ops.element('FourNodeTetrahedron', 9317, *[2578, 2150, 2420, 2525], 1)
    ops.element('FourNodeTetrahedron', 9318, *[1860, 1975, 1130, 1215], 1)
    ops.element('FourNodeTetrahedron', 9319, *[2467, 2006, 1891, 1892], 1)
    ops.element('FourNodeTetrahedron', 9320, *[1918, 2093, 2095, 1925], 1)
    ops.element('FourNodeTetrahedron', 9321, *[2329, 2477, 2674, 2330], 1)
    ops.element('FourNodeTetrahedron', 9322, *[1760, 1880, 1153, 1903], 1)
    ops.element('FourNodeTetrahedron', 9323, *[2023, 2669, 2021, 1778], 1)
    ops.element('FourNodeTetrahedron', 9324, *[2153, 2054, 1883, 2234], 1)
    ops.element('FourNodeTetrahedron', 9325, *[2176, 2232, 2366, 1900], 1)
    ops.element('FourNodeTetrahedron', 9326, *[2340, 1969, 2214, 2338], 1)
    ops.element('FourNodeTetrahedron', 9327, *[2353, 2304, 2305, 2352], 1)
    ops.element('FourNodeTetrahedron', 9328, *[2077, 2003, 2076, 2002], 1)
    ops.element('FourNodeTetrahedron', 9329, *[2468, 2580, 2273, 2415], 1)
    ops.element('FourNodeTetrahedron', 9330, *[1918, 1912, 2345, 2094], 1)
    ops.element('FourNodeTetrahedron', 9331, *[1149, 2098, 177, 2250], 1)
    ops.element('FourNodeTetrahedron', 9332, *[2455, 2352, 2070, 2408], 1)
    ops.element('FourNodeTetrahedron', 9333, *[2244, 2481, 2017, 2248], 1)
    ops.element('FourNodeTetrahedron', 9334, *[2244, 2017, 2019, 2248], 1)
    ops.element('FourNodeTetrahedron', 9335, *[2419, 2049, 2256, 2020], 1)
    ops.element('FourNodeTetrahedron', 9336, *[2212, 1946, 1910, 1947], 1)
    ops.element('FourNodeTetrahedron', 9337, *[2455, 2354, 2352, 2408], 1)
    ops.element('FourNodeTetrahedron', 9338, *[1185, 2065, 1183, 1943], 1)
    ops.element('FourNodeTetrahedron', 9339, *[2090, 2087, 2167, 2088], 1)
    ops.element('FourNodeTetrahedron', 9340, *[2615, 2674, 2613, 2311], 1)
    ops.element('FourNodeTetrahedron', 9341, *[2294, 2565, 2429, 2612], 1)
    ops.element('FourNodeTetrahedron', 9342, *[2640, 1757, 1755, 1758], 1)
    ops.element('FourNodeTetrahedron', 9343, *[2353, 2455, 2352, 2354], 1)
    ops.element('FourNodeTetrahedron', 9344, *[1906, 2678, 2380, 2657], 1)
    ops.element('FourNodeTetrahedron', 9345, *[2136, 2678, 2599, 2380], 1)
    ops.element('FourNodeTetrahedron', 9346, *[1155, 2202, 1232, 551], 1)
    ops.element('FourNodeTetrahedron', 9347, *[2136, 2678, 2380, 1906], 1)
    ops.element('FourNodeTetrahedron', 9348, *[2551, 2415, 2416, 2552], 1)
    ops.element('FourNodeTetrahedron', 9349, *[1829, 1846, 2376, 2059], 1)
    ops.element('FourNodeTetrahedron', 9350, *[2143, 1826, 2144, 2148], 1)
    ops.element('FourNodeTetrahedron', 9351, *[2599, 734, 739, 2380], 1)
    ops.element('FourNodeTetrahedron', 9352, *[1131, 1796, 1184, 1195], 1)
    ops.element('FourNodeTetrahedron', 9353, *[1796, 1937, 1195, 2013], 1)
    ops.element('FourNodeTetrahedron', 9354, *[2552, 2414, 2415, 2416], 1)
    ops.element('FourNodeTetrahedron', 9355, *[2308, 2321, 1847, 1848], 1)
    ops.element('FourNodeTetrahedron', 9356, *[2011, 2136, 2380, 1906], 1)
    ops.element('FourNodeTetrahedron', 9357, *[1905, 1906, 1821, 1820], 1)
    ops.element('FourNodeTetrahedron', 9358, *[1906, 2657, 2380, 1821], 1)
    ops.element('FourNodeTetrahedron', 9359, *[1906, 2657, 1821, 1820], 1)
    ops.element('FourNodeTetrahedron', 9360, *[1905, 1906, 2380, 1821], 1)
    ops.element('FourNodeTetrahedron', 9361, *[2570, 2035, 2646, 2487], 1)
    ops.element('FourNodeTetrahedron', 9362, *[2354, 2391, 2352, 2408], 1)
    ops.element('FourNodeTetrahedron', 9363, *[1212, 1847, 1148, 653], 1)
    ops.element('FourNodeTetrahedron', 9364, *[1905, 2380, 1144, 1821], 1)
    ops.element('FourNodeTetrahedron', 9365, *[743, 2047, 2180, 2178], 1)
    ops.element('FourNodeTetrahedron', 9366, *[747, 1988, 748, 1169], 1)
    ops.element('FourNodeTetrahedron', 9367, *[1757, 1756, 2433, 1755], 1)
    ops.element('FourNodeTetrahedron', 9368, *[2178, 2177, 2627, 2179], 1)
    ops.element('FourNodeTetrahedron', 9369, *[2358, 2237, 513, 2238], 1)
    ops.element('FourNodeTetrahedron', 9370, *[2672, 2629, 1775, 2490], 1)
    ops.element('FourNodeTetrahedron', 9371, *[1805, 1804, 2471, 1806], 1)
    ops.element('FourNodeTetrahedron', 9372, *[742, 2177, 2627, 2178], 1)
    ops.element('FourNodeTetrahedron', 9373, *[2523, 2522, 1915, 2474], 1)
    ops.element('FourNodeTetrahedron', 9374, *[2399, 2623, 1763, 2398], 1)
    ops.element('FourNodeTetrahedron', 9375, *[2058, 1845, 2059, 2456], 1)
    ops.element('FourNodeTetrahedron', 9376, *[2273, 1963, 2565, 1964], 1)
    ops.element('FourNodeTetrahedron', 9377, *[2416, 2273, 2565, 1964], 1)
    ops.element('FourNodeTetrahedron', 9378, *[2050, 2635, 1879, 2048], 1)
    ops.element('FourNodeTetrahedron', 9379, *[2594, 2592, 2556, 2462], 1)
    ops.element('FourNodeTetrahedron', 9380, *[2594, 2556, 1194, 2462], 1)
    ops.element('FourNodeTetrahedron', 9381, *[1935, 2000, 1810, 2120], 1)
    ops.element('FourNodeTetrahedron', 9382, *[2219, 2000, 1810, 1935], 1)
    ops.element('FourNodeTetrahedron', 9383, *[2463, 1998, 1151, 2408], 1)
    ops.element('FourNodeTetrahedron', 9384, *[1964, 1962, 2231, 2233], 1)
    ops.element('FourNodeTetrahedron', 9385, *[2659, 2476, 2277, 2445], 1)
    ops.element('FourNodeTetrahedron', 9386, *[1851, 1930, 1860, 1993], 1)
    ops.element('FourNodeTetrahedron', 9387, *[2058, 2059, 1829, 1994], 1)
    ops.element('FourNodeTetrahedron', 9388, *[2052, 2226, 2594, 2384], 1)
    ops.element('FourNodeTetrahedron', 9389, *[2635, 2275, 2046, 1124], 1)
    ops.element('FourNodeTetrahedron', 9390, *[1996, 2375, 2116, 2539], 1)
    ops.element('FourNodeTetrahedron', 9391, *[2563, 1770, 1771, 2248], 1)
    ops.element('FourNodeTetrahedron', 9392, *[1782, 1987, 2345, 1857], 1)
    ops.element('FourNodeTetrahedron', 9393, *[1921, 1909, 1987, 1924], 1)
    ops.element('FourNodeTetrahedron', 9394, *[2132, 2018, 2316, 1868], 1)
    ops.element('FourNodeTetrahedron', 9395, *[2513, 2496, 2404, 2412], 1)
    ops.element('FourNodeTetrahedron', 9396, *[2429, 2086, 2121, 2430], 1)
    ops.element('FourNodeTetrahedron', 9397, *[2017, 2249, 1770, 2248], 1)
    ops.element('FourNodeTetrahedron', 9398, *[2229, 1935, 1810, 2120], 1)
    ops.element('FourNodeTetrahedron', 9399, *[2271, 2327, 1989, 1991], 1)
    ops.element('FourNodeTetrahedron', 9400, *[2220, 2219, 2568, 1935], 1)
    ops.element('FourNodeTetrahedron', 9401, *[1231, 2497, 1135, 1216], 1)
    ops.element('FourNodeTetrahedron', 9402, *[2273, 2272, 1878, 2294], 1)
    ops.element('FourNodeTetrahedron', 9403, *[2479, 2591, 2495, 2518], 1)
    ops.element('FourNodeTetrahedron', 9404, *[2594, 2462, 621, 2384], 1)
    ops.element('FourNodeTetrahedron', 9405, *[1231, 2528, 1135, 2497], 1)
    ops.element('FourNodeTetrahedron', 9406, *[2135, 2681, 2436, 2435], 1)
    ops.element('FourNodeTetrahedron', 9407, *[2184, 2612, 2621, 2062], 1)
    ops.element('FourNodeTetrahedron', 9408, *[2348, 2410, 1196, 611], 1)
    ops.element('FourNodeTetrahedron', 9409, *[2635, 2275, 1124, 2009], 1)
    ops.element('FourNodeTetrahedron', 9410, *[2172, 1978, 1126, 1257], 1)
    ops.element('FourNodeTetrahedron', 9411, *[1891, 2483, 2619, 2006], 1)
    ops.element('FourNodeTetrahedron', 9412, *[2594, 2592, 2462, 2384], 1)
    ops.element('FourNodeTetrahedron', 9413, *[1201, 2147, 1202, 1123], 1)
    ops.element('FourNodeTetrahedron', 9414, *[1219, 2298, 1225, 1121], 1)
    ops.element('FourNodeTetrahedron', 9415, *[2168, 2440, 2026, 1852], 1)
    ops.element('FourNodeTetrahedron', 9416, *[1217, 2048, 1247, 1219], 1)
    ops.element('FourNodeTetrahedron', 9417, *[1969, 2213, 2140, 2139], 1)
    ops.element('FourNodeTetrahedron', 9418, *[2351, 2110, 2681, 2464], 1)
    ops.element('FourNodeTetrahedron', 9419, *[1890, 1862, 1865, 2634], 1)
    ops.element('FourNodeTetrahedron', 9420, *[2391, 2489, 1834, 2260], 1)
    ops.element('FourNodeTetrahedron', 9421, *[1844, 1843, 1955, 2383], 1)
    ops.element('FourNodeTetrahedron', 9422, *[2578, 2129, 2420, 2150], 1)
    ops.element('FourNodeTetrahedron', 9423, *[1199, 2463, 733, 1151], 1)
    ops.element('FourNodeTetrahedron', 9424, *[2531, 2129, 2631, 2578], 1)
    ops.element('FourNodeTetrahedron', 9425, *[2405, 2204, 1155, 2542], 1)
    ops.element('FourNodeTetrahedron', 9426, *[1872, 2185, 2184, 2416], 1)
    ops.element('FourNodeTetrahedron', 9427, *[2578, 2129, 2631, 2420], 1)
    ops.element('FourNodeTetrahedron', 9428, *[1869, 2016, 2359, 2078], 1)
    ops.element('FourNodeTetrahedron', 9429, *[2240, 2493, 2494, 2241], 1)
    ops.element('FourNodeTetrahedron', 9430, *[2531, 2081, 2131, 2075], 1)
    ops.element('FourNodeTetrahedron', 9431, *[2531, 2081, 2075, 2151], 1)
    ops.element('FourNodeTetrahedron', 9432, *[2046, 2047, 1193, 2475], 1)
    ops.element('FourNodeTetrahedron', 9433, *[1890, 2176, 2287, 1901], 1)
    ops.element('FourNodeTetrahedron', 9434, *[1901, 2366, 2684, 1900], 1)
    ops.element('FourNodeTetrahedron', 9435, *[1127, 2229, 1209, 1949], 1)
    ops.element('FourNodeTetrahedron', 9436, *[2577, 2151, 2531, 2150], 1)
    ops.element('FourNodeTetrahedron', 9437, *[513, 2236, 2237, 1913], 1)
    ops.element('FourNodeTetrahedron', 9438, *[513, 1913, 1246, 1150], 1)
    ops.element('FourNodeTetrahedron', 9439, *[2236, 1898, 1246, 1913], 1)
    ops.element('FourNodeTetrahedron', 9440, *[2531, 2151, 2075, 2150], 1)
    ops.element('FourNodeTetrahedron', 9441, *[2390, 2641, 2173, 2389], 1)
    ops.element('FourNodeTetrahedron', 9442, *[1930, 1994, 2283, 1996], 1)
    ops.element('FourNodeTetrahedron', 9443, *[2388, 2173, 2538, 2240], 1)
    ops.element('FourNodeTetrahedron', 9444, *[2333, 2199, 2200, 2334], 1)
    ops.element('FourNodeTetrahedron', 9445, *[2273, 1875, 2272, 1963], 1)
    ops.element('FourNodeTetrahedron', 9446, *[2237, 1981, 1844, 2381], 1)
    ops.element('FourNodeTetrahedron', 9447, *[2083, 2332, 2308, 2084], 1)
    ops.element('FourNodeTetrahedron', 9448, *[1854, 2157, 1851, 2538], 1)
    ops.element('FourNodeTetrahedron', 9449, *[2133, 2335, 2099, 2098], 1)
    ops.element('FourNodeTetrahedron', 9450, *[1797, 2503, 1799, 1798], 1)
    ops.element('FourNodeTetrahedron', 9451, *[2412, 2497, 1156, 2410], 1)
    ops.element('FourNodeTetrahedron', 9452, *[2346, 2448, 1805, 2390], 1)
    ops.element('FourNodeTetrahedron', 9453, *[2228, 2437, 718, 2400], 1)
    ops.element('FourNodeTetrahedron', 9454, *[2271, 2296, 2327, 2270], 1)
    ops.element('FourNodeTetrahedron', 9455, *[2470, 2471, 2641, 2469], 1)
    ops.element('FourNodeTetrahedron', 9456, *[2131, 2077, 2132, 2075], 1)
    ops.element('FourNodeTetrahedron', 9457, *[2145, 1949, 1208, 1853], 1)
    ops.element('FourNodeTetrahedron', 9458, *[1779, 2022, 1197, 1778], 1)
    ops.element('FourNodeTetrahedron', 9459, *[2055, 1746, 1980, 2214], 1)
    ops.element('FourNodeTetrahedron', 9460, *[2406, 1993, 1974, 2494], 1)
    ops.element('FourNodeTetrahedron', 9461, *[2253, 1957, 1958, 2625], 1)
    ops.element('FourNodeTetrahedron', 9462, *[1956, 2209, 2227, 2051], 1)
    ops.element('FourNodeTetrahedron', 9463, *[1956, 1959, 2209, 2210], 1)
    ops.element('FourNodeTetrahedron', 9464, *[1878, 1823, 2097, 2272], 1)
    ops.element('FourNodeTetrahedron', 9465, *[1201, 2147, 1206, 1202], 1)
    ops.element('FourNodeTetrahedron', 9466, *[1923, 1238, 526, 2278], 1)
    ops.element('FourNodeTetrahedron', 9467, *[2014, 2013, 2015, 2556], 1)
    ops.element('FourNodeTetrahedron', 9468, *[2527, 1967, 1823, 1966], 1)
    ops.element('FourNodeTetrahedron', 9469, *[2060, 2062, 2063, 2466], 1)
    ops.element('FourNodeTetrahedron', 9470, *[2122, 2661, 2430, 2611], 1)
    ops.element('FourNodeTetrahedron', 9471, *[1780, 1988, 1169, 1781], 1)
    ops.element('FourNodeTetrahedron', 9472, *[2320, 2069, 1821, 2068], 1)
    ops.element('FourNodeTetrahedron', 9473, *[2441, 1831, 1830, 1845], 1)
    ops.element('FourNodeTetrahedron', 9474, *[759, 1893, 1239, 1159], 1)
    ops.element('FourNodeTetrahedron', 9475, *[1239, 1893, 1169, 1780], 1)
    ops.element('FourNodeTetrahedron', 9476, *[1884, 2044, 2524, 1784], 1)
    ops.element('FourNodeTetrahedron', 9477, *[1935, 2440, 1934, 1933], 1)
    ops.element('FourNodeTetrahedron', 9478, *[2557, 2473, 1808, 2045], 1)
    ops.element('FourNodeTetrahedron', 9479, *[1894, 2607, 759, 1893], 1)
    ops.element('FourNodeTetrahedron', 9480, *[1165, 2275, 1245, 1124], 1)
    ops.element('FourNodeTetrahedron', 9481, *[1894, 1893, 759, 1159], 1)
    ops.element('FourNodeTetrahedron', 9482, *[2626, 2274, 2153, 2054], 1)
    ops.element('FourNodeTetrahedron', 9483, *[2027, 1802, 1803, 2091], 1)
    ops.element('FourNodeTetrahedron', 9484, *[2490, 2615, 2629, 2312], 1)
    ops.element('FourNodeTetrahedron', 9485, *[2662, 2653, 684, 2573], 1)
    ops.element('FourNodeTetrahedron', 9486, *[2155, 1871, 1872, 2156], 1)
    ops.element('FourNodeTetrahedron', 9487, *[2129, 1868, 2071, 1976], 1)
    ops.element('FourNodeTetrahedron', 9488, *[2631, 2071, 2072, 2129], 1)
    ops.element('FourNodeTetrahedron', 9489, *[2147, 2409, 1206, 1202], 1)
    ops.element('FourNodeTetrahedron', 9490, *[2345, 2390, 2173, 2388], 1)
    ops.element('FourNodeTetrahedron', 9491, *[2048, 2009, 1247, 1164], 1)
    ops.element('FourNodeTetrahedron', 9492, *[1973, 2483, 1891, 2006], 1)
    ops.element('FourNodeTetrahedron', 9493, *[2483, 2484, 2199, 2630], 1)
    ops.element('FourNodeTetrahedron', 9494, *[2483, 2630, 2199, 2333], 1)
    ops.element('FourNodeTetrahedron', 9495, *[2098, 2336, 2250, 2465], 1)
    ops.element('FourNodeTetrahedron', 9496, *[713, 2164, 175, 1157], 1)
    ops.element('FourNodeTetrahedron', 9497, *[2485, 2630, 2483, 2008], 1)
    ops.element('FourNodeTetrahedron', 9498, *[1850, 1793, 2609, 1795], 1)
    ops.element('FourNodeTetrahedron', 9499, *[2094, 2389, 2388, 2544], 1)
    ops.element('FourNodeTetrahedron', 9500, *[2435, 2335, 2098, 2539], 1)
    ops.element('FourNodeTetrahedron', 9501, *[2405, 1974, 1859, 2204], 1)
    ops.element('FourNodeTetrahedron', 9502, *[2405, 2682, 1974, 2204], 1)
    ops.element('FourNodeTetrahedron', 9503, *[1799, 2149, 2143, 1937], 1)
    ops.element('FourNodeTetrahedron', 9504, *[2528, 2405, 1135, 2497], 1)
    ops.element('FourNodeTetrahedron', 9505, *[2453, 2525, 2656, 1990], 1)
    ops.element('FourNodeTetrahedron', 9506, *[2682, 2242, 1974, 2204], 1)
    ops.element('FourNodeTetrahedron', 9507, *[1141, 1809, 1157, 1170], 1)
    ops.element('FourNodeTetrahedron', 9508, *[2560, 2169, 2171, 2170], 1)
    ops.element('FourNodeTetrahedron', 9509, *[1970, 2486, 2597, 2386], 1)
    ops.element('FourNodeTetrahedron', 9510, *[2479, 2560, 2171, 2170], 1)
    ops.element('FourNodeTetrahedron', 9511, *[2022, 2021, 2024, 1197], 1)
    ops.element('FourNodeTetrahedron', 9512, *[2022, 2023, 2021, 1778], 1)
    ops.element('FourNodeTetrahedron', 9513, *[2211, 2292, 1886, 2290], 1)
    ops.element('FourNodeTetrahedron', 9514, *[2129, 2132, 1868, 2076], 1)
    ops.element('FourNodeTetrahedron', 9515, *[1829, 2464, 2588, 1932], 1)
    ops.element('FourNodeTetrahedron', 9516, *[1170, 2099, 176, 177], 1)
    ops.element('FourNodeTetrahedron', 9517, *[1916, 1899, 2564, 2606], 1)
    ops.element('FourNodeTetrahedron', 9518, *[1964, 2620, 2661, 2618], 1)
    ops.element('FourNodeTetrahedron', 9519, *[2058, 2112, 2059, 1995], 1)
    ops.element('FourNodeTetrahedron', 9520, *[2008, 2630, 2006, 1917], 1)
    ops.element('FourNodeTetrahedron', 9521, *[2025, 2026, 2107, 2168], 1)
    ops.element('FourNodeTetrahedron', 9522, *[1858, 2094, 2388, 2544], 1)
    ops.element('FourNodeTetrahedron', 9523, *[1858, 2388, 2529, 2544], 1)
    ops.element('FourNodeTetrahedron', 9524, *[2329, 2477, 2328, 2092], 1)
    ops.element('FourNodeTetrahedron', 9525, *[2325, 2113, 1993, 2526], 1)
    ops.element('FourNodeTetrahedron', 9526, *[2566, 1789, 1790, 2175], 1)
    ops.element('FourNodeTetrahedron', 9527, *[1964, 2620, 2233, 2661], 1)
    ops.element('FourNodeTetrahedron', 9528, *[1176, 2617, 1137, 1175], 1)
    ops.element('FourNodeTetrahedron', 9529, *[1931, 2058, 2285, 2113], 1)
    ops.element('FourNodeTetrahedron', 9530, *[1860, 2307, 1975, 1974], 1)
    ops.element('FourNodeTetrahedron', 9531, *[2197, 2201, 2198, 2199], 1)
    ops.element('FourNodeTetrahedron', 9532, *[2149, 1783, 2148, 2263], 1)
    ops.element('FourNodeTetrahedron', 9533, *[1123, 2144, 1203, 2142], 1)
    ops.element('FourNodeTetrahedron', 9534, *[2459, 1770, 2066, 1768], 1)
    ops.element('FourNodeTetrahedron', 9535, *[2370, 2523, 2598, 538], 1)
    ops.element('FourNodeTetrahedron', 9536, *[2479, 2438, 2171, 2560], 1)
    ops.element('FourNodeTetrahedron', 9537, *[2641, 2516, 2240, 2389], 1)
    ops.element('FourNodeTetrahedron', 9538, *[2001, 2431, 2243, 2403], 1)
    ops.element('FourNodeTetrahedron', 9539, *[1769, 1959, 2460, 2227], 1)
    ops.element('FourNodeTetrahedron', 9540, *[2641, 2325, 2240, 2516], 1)
    ops.element('FourNodeTetrahedron', 9541, *[2113, 2112, 1995, 2526], 1)
    ops.element('FourNodeTetrahedron', 9542, *[1928, 1784, 2358, 1929], 1)
    ops.element('FourNodeTetrahedron', 9543, *[2145, 2422, 1852, 1854], 1)
    ops.element('FourNodeTetrahedron', 9544, *[2145, 1852, 1853, 1854], 1)
    ops.element('FourNodeTetrahedron', 9545, *[2019, 2017, 2395, 2248], 1)
    ops.element('FourNodeTetrahedron', 9546, *[2422, 2157, 1852, 1854], 1)
    ops.element('FourNodeTetrahedron', 9547, *[1856, 2388, 2407, 2529], 1)
    ops.element('FourNodeTetrahedron', 9548, *[2230, 2546, 2437, 2400], 1)
    ops.element('FourNodeTetrahedron', 9549, *[2364, 2671, 2230, 2546], 1)
    ops.element('FourNodeTetrahedron', 9550, *[2230, 2671, 2437, 2546], 1)
    ops.element('FourNodeTetrahedron', 9551, *[2422, 2168, 1852, 2157], 1)
    ops.element('FourNodeTetrahedron', 9552, *[2168, 2440, 1852, 1931], 1)
    ops.element('FourNodeTetrahedron', 9553, *[2100, 2101, 1863, 1890], 1)
    ops.element('FourNodeTetrahedron', 9554, *[2100, 1863, 2589, 1865], 1)
    ops.element('FourNodeTetrahedron', 9555, *[2100, 1890, 1863, 1865], 1)
    ops.element('FourNodeTetrahedron', 9556, *[2116, 2101, 2589, 2100], 1)
    ops.element('FourNodeTetrahedron', 9557, *[2598, 2523, 1923, 532], 1)
    ops.element('FourNodeTetrahedron', 9558, *[2298, 2256, 1225, 2419], 1)
    ops.element('FourNodeTetrahedron', 9559, *[1967, 1877, 1823, 1878], 1)
    ops.element('FourNodeTetrahedron', 9560, *[2598, 2523, 1892, 1923], 1)
    ops.element('FourNodeTetrahedron', 9561, *[1830, 1829, 2588, 1932], 1)
    ops.element('FourNodeTetrahedron', 9562, *[2283, 2351, 2135, 2435], 1)
    ops.element('FourNodeTetrahedron', 9563, *[2100, 2589, 2116, 2484], 1)
    ops.element('FourNodeTetrahedron', 9564, *[2100, 2589, 2484, 1865], 1)
    ops.element('FourNodeTetrahedron', 9565, *[2024, 2299, 1142, 2021], 1)
    ops.element('FourNodeTetrahedron', 9566, *[1936, 2588, 2000, 2283], 1)
    ops.element('FourNodeTetrahedron', 9567, *[2595, 2275, 2442, 2608], 1)
    ops.element('FourNodeTetrahedron', 9568, *[2586, 2137, 740, 2024], 1)
    ops.element('FourNodeTetrahedron', 9569, *[2299, 2137, 1907, 2023], 1)
    ops.element('FourNodeTetrahedron', 9570, *[621, 2450, 2462, 622], 1)
    ops.element('FourNodeTetrahedron', 9571, *[2662, 2653, 2368, 684], 1)
    ops.element('FourNodeTetrahedron', 9572, *[2567, 1791, 1788, 1789], 1)
    ops.element('FourNodeTetrahedron', 9573, *[1784, 2031, 1787, 1929], 1)
    ops.element('FourNodeTetrahedron', 9574, *[2170, 2368, 2662, 2653], 1)
    ops.element('FourNodeTetrahedron', 9575, *[2441, 1845, 2058, 2433], 1)
    ops.element('FourNodeTetrahedron', 9576, *[2031, 2603, 1885, 1787], 1)
    ops.element('FourNodeTetrahedron', 9577, *[1765, 1921, 1986, 1920], 1)
    ops.element('FourNodeTetrahedron', 9578, *[2077, 2003, 2132, 2076], 1)
    ops.element('FourNodeTetrahedron', 9579, *[2526, 2097, 2221, 2356], 1)
    ops.element('FourNodeTetrahedron', 9580, *[2405, 2407, 2529, 2682], 1)
    ops.element('FourNodeTetrahedron', 9581, *[1931, 2058, 1994, 2285], 1)
    ops.element('FourNodeTetrahedron', 9582, *[2496, 2407, 2528, 2529], 1)
    ops.element('FourNodeTetrahedron', 9583, *[1231, 2497, 2528, 2412], 1)
    ops.element('FourNodeTetrahedron', 9584, *[1830, 1832, 2588, 1829], 1)
    ops.element('FourNodeTetrahedron', 9585, *[2483, 2195, 2619, 2333], 1)
    ops.element('FourNodeTetrahedron', 9586, *[2496, 2528, 2497, 2412], 1)
    ops.element('FourNodeTetrahedron', 9587, *[2022, 2021, 1197, 1778], 1)
    ops.element('FourNodeTetrahedron', 9588, *[1934, 2588, 1936, 1932], 1)
    ops.element('FourNodeTetrahedron', 9589, *[1934, 1830, 2588, 1932], 1)
    ops.element('FourNodeTetrahedron', 9590, *[2440, 1830, 1934, 1932], 1)
    ops.element('FourNodeTetrahedron', 9591, *[1934, 2482, 2588, 1830], 1)
    ops.element('FourNodeTetrahedron', 9592, *[2007, 2222, 2008, 2010], 1)
    ops.element('FourNodeTetrahedron', 9593, *[2193, 2555, 2008, 1917], 1)
    ops.element('FourNodeTetrahedron', 9594, *[2222, 2008, 2010, 2193], 1)
    ops.element('FourNodeTetrahedron', 9595, *[2221, 2100, 2309, 2485], 1)
    ops.element('FourNodeTetrahedron', 9596, *[2103, 2655, 2100, 2221], 1)
    ops.element('FourNodeTetrahedron', 9597, *[2309, 2103, 2100, 2221], 1)
    ops.element('FourNodeTetrahedron', 9598, *[1989, 2318, 2152, 1990], 1)
    ops.element('FourNodeTetrahedron', 9599, *[1159, 1893, 1239, 1780], 1)
    ops.element('FourNodeTetrahedron', 9600, *[1894, 2607, 1893, 1780], 1)
    ops.element('FourNodeTetrahedron', 9601, *[1996, 2116, 2539, 2309], 1)
    ops.element('FourNodeTetrahedron', 9602, *[2100, 1865, 2484, 2485], 1)
    ops.element('FourNodeTetrahedron', 9603, *[2242, 2241, 2494, 2222], 1)
    ops.element('FourNodeTetrahedron', 9604, *[2192, 2514, 2555, 2121], 1)
    ops.element('FourNodeTetrahedron', 9605, *[2161, 2651, 2663, 1884], 1)
    ops.element('FourNodeTetrahedron', 9606, *[2485, 1865, 2484, 2630], 1)
    ops.element('FourNodeTetrahedron', 9607, *[2454, 2353, 2455, 2657], 1)
    ops.element('FourNodeTetrahedron', 9608, *[2489, 2490, 1775, 2312], 1)
    ops.element('FourNodeTetrahedron', 9609, *[2006, 2630, 2483, 2333], 1)
    ops.element('FourNodeTetrahedron', 9610, *[2590, 2508, 2501, 2559], 1)
    ops.element('FourNodeTetrahedron', 9611, *[1139, 1163, 1162, 1879], 1)
    ops.element('FourNodeTetrahedron', 9612, *[2514, 2174, 2655, 2634], 1)
    ops.element('FourNodeTetrahedron', 9613, *[2337, 2140, 2452, 2508], 1)
    ops.element('FourNodeTetrahedron', 9614, *[2520, 2088, 2167, 1809], 1)
    ops.element('FourNodeTetrahedron', 9615, *[2000, 2088, 1809, 2135], 1)
    ops.element('FourNodeTetrahedron', 9616, *[2003, 2432, 2244, 2001], 1)
    ops.element('FourNodeTetrahedron', 9617, *[1908, 2322, 1912, 2093], 1)
    ops.element('FourNodeTetrahedron', 9618, *[2514, 2655, 2485, 2634], 1)
    ops.element('FourNodeTetrahedron', 9619, *[2514, 2634, 2485, 2555], 1)
    ops.element('FourNodeTetrahedron', 9620, *[1746, 1748, 2532, 2213], 1)
    ops.element('FourNodeTetrahedron', 9621, *[2381, 2315, 2073, 2631], 1)
    ops.element('FourNodeTetrahedron', 9622, *[1845, 2314, 2059, 2456], 1)
    ops.element('FourNodeTetrahedron', 9623, *[2602, 2072, 2172, 2420], 1)
    ops.element('FourNodeTetrahedron', 9624, *[2256, 2020, 2258, 2359], 1)
    ops.element('FourNodeTetrahedron', 9625, *[2192, 2514, 2485, 2555], 1)
    ops.element('FourNodeTetrahedron', 9626, *[2242, 2494, 1974, 2222], 1)
    ops.element('FourNodeTetrahedron', 9627, *[2310, 2482, 2220, 2026], 1)
    ops.element('FourNodeTetrahedron', 9628, *[2345, 2173, 1856, 2388], 1)
    ops.element('FourNodeTetrahedron', 9629, *[1805, 2471, 2469, 1806], 1)
    ops.element('FourNodeTetrahedron', 9630, *[2489, 2312, 1775, 1772], 1)
    ops.element('FourNodeTetrahedron', 9631, *[1907, 1820, 1905, 2669], 1)
    ops.element('FourNodeTetrahedron', 9632, *[2489, 2312, 1772, 2491], 1)
    ops.element('FourNodeTetrahedron', 9633, *[2392, 2489, 2260, 2491], 1)
    ops.element('FourNodeTetrahedron', 9634, *[2260, 2489, 1772, 2491], 1)
    ops.element('FourNodeTetrahedron', 9635, *[2192, 2485, 2008, 2555], 1)
    ops.element('FourNodeTetrahedron', 9636, *[2106, 2679, 1777, 2443], 1)
    ops.element('FourNodeTetrahedron', 9637, *[2238, 1981, 2237, 2438], 1)
    ops.element('FourNodeTetrahedron', 9638, *[2106, 1777, 1779, 2443], 1)
    ops.element('FourNodeTetrahedron', 9639, *[2356, 2514, 2192, 2429], 1)
    ops.element('FourNodeTetrahedron', 9640, *[2636, 1920, 1888, 2292], 1)
    ops.element('FourNodeTetrahedron', 9641, *[2631, 2130, 2315, 2071], 1)
    ops.element('FourNodeTetrahedron', 9642, *[1753, 1754, 2083, 1752], 1)
    ops.element('FourNodeTetrahedron', 9643, *[2243, 2252, 2500, 2274], 1)
    ops.element('FourNodeTetrahedron', 9644, *[2396, 1780, 1159, 1134], 1)
    ops.element('FourNodeTetrahedron', 9645, *[2274, 2253, 2057, 2664], 1)
    ops.element('FourNodeTetrahedron', 9646, *[2390, 2389, 2388, 2094], 1)
    ops.element('FourNodeTetrahedron', 9647, *[1228, 1157, 712, 1809], 1)
    ops.element('FourNodeTetrahedron', 9648, *[2051, 2226, 2225, 1883], 1)
    ops.element('FourNodeTetrahedron', 9649, *[2588, 1832, 2351, 2464], 1)
    ops.element('FourNodeTetrahedron', 9650, *[1832, 2110, 2351, 2464], 1)
    ops.element('FourNodeTetrahedron', 9651, *[2000, 2111, 2351, 2588], 1)
    ops.element('FourNodeTetrahedron', 9652, *[1841, 2398, 1842, 1843], 1)
    ops.element('FourNodeTetrahedron', 9653, *[2000, 2111, 2088, 2351], 1)
    ops.element('FourNodeTetrahedron', 9654, *[2219, 2111, 2088, 2000], 1)
    ops.element('FourNodeTetrahedron', 9655, *[2612, 2429, 2356, 2123], 1)
    ops.element('FourNodeTetrahedron', 9656, *[2153, 1883, 2154, 2234], 1)
    ops.element('FourNodeTetrahedron', 9657, *[2416, 2430, 2612, 2611], 1)
    ops.element('FourNodeTetrahedron', 9658, *[2294, 2429, 2356, 2612], 1)
    ops.element('FourNodeTetrahedron', 9659, *[2544, 2063, 2241, 2239], 1)
    ops.element('FourNodeTetrahedron', 9660, *[1980, 1746, 2532, 2214], 1)
    ops.element('FourNodeTetrahedron', 9661, *[2600, 2260, 2408, 2261], 1)
    ops.element('FourNodeTetrahedron', 9662, *[1129, 1903, 1217, 1952], 1)
    ops.element('FourNodeTetrahedron', 9663, *[2357, 2214, 2596, 2338], 1)
    ops.element('FourNodeTetrahedron', 9664, *[2169, 2577, 2578, 2525], 1)
    ops.element('FourNodeTetrahedron', 9665, *[2357, 1747, 2214, 2340], 1)
    ops.element('FourNodeTetrahedron', 9666, *[2169, 2577, 2525, 2502], 1)
    ops.element('FourNodeTetrahedron', 9667, *[2502, 2525, 2169, 2453], 1)
    ops.element('FourNodeTetrahedron', 9668, *[2392, 2489, 2391, 2260], 1)
    ops.element('FourNodeTetrahedron', 9669, *[2655, 1865, 2485, 2634], 1)
    ops.element('FourNodeTetrahedron', 9670, *[2655, 1865, 2100, 2485], 1)
    ops.element('FourNodeTetrahedron', 9671, *[2516, 2536, 2241, 2621], 1)
    ops.element('FourNodeTetrahedron', 9672, *[1933, 1932, 1936, 1930], 1)
    ops.element('FourNodeTetrahedron', 9673, *[2029, 2288, 2101, 1824], 1)
    ops.element('FourNodeTetrahedron', 9674, *[2097, 2272, 2174, 2514], 1)
    ops.element('FourNodeTetrahedron', 9675, *[2097, 2174, 2655, 2514], 1)
    ops.element('FourNodeTetrahedron', 9676, *[2241, 2536, 2356, 2621], 1)
    ops.element('FourNodeTetrahedron', 9677, *[1891, 2483, 2215, 2619], 1)
    ops.element('FourNodeTetrahedron', 9678, *[1249, 526, 1238, 1923], 1)
    ops.element('FourNodeTetrahedron', 9679, *[2112, 2527, 2030, 2526], 1)
    ops.element('FourNodeTetrahedron', 9680, *[1819, 1821, 1230, 1818], 1)
    ops.element('FourNodeTetrahedron', 9681, *[2320, 2068, 1821, 1818], 1)
    ops.element('FourNodeTetrahedron', 9682, *[2555, 2634, 2630, 2334], 1)
    ops.element('FourNodeTetrahedron', 9683, *[1245, 2442, 1166, 1241], 1)
    ops.element('FourNodeTetrahedron', 9684, *[1241, 2442, 1166, 1759], 1)
    ops.element('FourNodeTetrahedron', 9685, *[2123, 2429, 2121, 2122], 1)
    ops.element('FourNodeTetrahedron', 9686, *[2630, 1865, 1862, 2634], 1)
    ops.element('FourNodeTetrahedron', 9687, *[2097, 2655, 2103, 2174], 1)
    ops.element('FourNodeTetrahedron', 9688, *[1992, 2151, 2152, 1989], 1)
    ops.element('FourNodeTetrahedron', 9689, *[1932, 2464, 2588, 2283], 1)
    ops.element('FourNodeTetrahedron', 9690, *[1855, 1858, 2529, 2498], 1)
    ops.element('FourNodeTetrahedron', 9691, *[2048, 2009, 1164, 2298], 1)
    ops.element('FourNodeTetrahedron', 9692, *[2686, 2580, 2468, 2551], 1)
    ops.element('FourNodeTetrahedron', 9693, *[2686, 2580, 1968, 2468], 1)
    ops.element('FourNodeTetrahedron', 9694, *[1895, 1856, 2407, 1855], 1)
    ops.element('FourNodeTetrahedron', 9695, *[2097, 1823, 2103, 2174], 1)
    ops.element('FourNodeTetrahedron', 9696, *[2097, 1823, 2174, 2272], 1)
    ops.element('FourNodeTetrahedron', 9697, *[2108, 2041, 2372, 2109], 1)
    ops.element('FourNodeTetrahedron', 9698, *[1773, 2363, 2666, 2364], 1)
    ops.element('FourNodeTetrahedron', 9699, *[2404, 2579, 2496, 2513], 1)
    ops.element('FourNodeTetrahedron', 9700, *[2528, 2407, 2405, 2529], 1)
    ops.element('FourNodeTetrahedron', 9701, *[2309, 2116, 2539, 2484], 1)
    ops.element('FourNodeTetrahedron', 9702, *[1229, 2662, 1146, 683], 1)
    ops.element('FourNodeTetrahedron', 9703, *[2221, 2514, 2485, 2192], 1)
    ops.element('FourNodeTetrahedron', 9704, *[1932, 2588, 1936, 2283], 1)
    ops.element('FourNodeTetrahedron', 9705, *[2223, 2545, 1794, 1793], 1)
    ops.element('FourNodeTetrahedron', 9706, *[1224, 177, 1170, 2098], 1)
    ops.element('FourNodeTetrahedron', 9707, *[1158, 2662, 1229, 683], 1)
    ops.element('FourNodeTetrahedron', 9708, *[2479, 1229, 512, 1158], 1)
    ops.element('FourNodeTetrahedron', 9709, *[2253, 2057, 1958, 2274], 1)
    ops.element('FourNodeTetrahedron', 9710, *[1156, 2497, 1216, 2410], 1)
    ops.element('FourNodeTetrahedron', 9711, *[2309, 2102, 2116, 2100], 1)
    ops.element('FourNodeTetrahedron', 9712, *[1829, 1832, 2588, 2464], 1)
    ops.element('FourNodeTetrahedron', 9713, *[2309, 2103, 2102, 2100], 1)
    ops.element('FourNodeTetrahedron', 9714, *[2497, 2405, 1135, 1216], 1)
    ops.element('FourNodeTetrahedron', 9715, *[2358, 1981, 2237, 2238], 1)
    ops.element('FourNodeTetrahedron', 9716, *[2193, 1917, 2474, 1840], 1)
    ops.element('FourNodeTetrahedron', 9717, *[2464, 2681, 2435, 2375], 1)
    ops.element('FourNodeTetrahedron', 9718, *[2502, 2452, 2453, 2508], 1)
    ops.element('FourNodeTetrahedron', 9719, *[2114, 2449, 1781, 2236], 1)
    ops.element('FourNodeTetrahedron', 9720, *[1771, 1769, 1956, 1958], 1)
    ops.element('FourNodeTetrahedron', 9721, *[1958, 2210, 2051, 2057], 1)
    ops.element('FourNodeTetrahedron', 9722, *[1758, 2096, 2536, 2621], 1)
    ops.element('FourNodeTetrahedron', 9723, *[2516, 1758, 1755, 2536], 1)
    ops.element('FourNodeTetrahedron', 9724, *[2516, 1758, 2536, 2621], 1)
    ops.element('FourNodeTetrahedron', 9725, *[1892, 2619, 1140, 1249], 1)
    ops.element('FourNodeTetrahedron', 9726, *[2147, 2421, 2422, 2146], 1)
    ops.element('FourNodeTetrahedron', 9727, *[1140, 2619, 1238, 1249], 1)
    ops.element('FourNodeTetrahedron', 9728, *[1140, 2619, 2064, 1238], 1)
    ops.element('FourNodeTetrahedron', 9729, *[2627, 2586, 2024, 2022], 1)
    ops.element('FourNodeTetrahedron', 9730, *[1140, 2215, 2064, 2619], 1)
    ops.element('FourNodeTetrahedron', 9731, *[1959, 1887, 2014, 2209], 1)
    ops.element('FourNodeTetrahedron', 9732, *[2211, 1887, 1886, 2292], 1)
    ops.element('FourNodeTetrahedron', 9733, *[2209, 1887, 1886, 2211], 1)
    ops.element('FourNodeTetrahedron', 9734, *[2560, 2578, 2171, 2169], 1)
    ops.element('FourNodeTetrahedron', 9735, *[2100, 1890, 1865, 2655], 1)
    ops.element('FourNodeTetrahedron', 9736, *[2103, 1890, 2100, 2655], 1)
    ops.element('FourNodeTetrahedron', 9737, *[2103, 1890, 2655, 2174], 1)
    ops.element('FourNodeTetrahedron', 9738, *[2655, 2174, 1890, 2634], 1)
    ops.element('FourNodeTetrahedron', 9739, *[1174, 2070, 1199, 1136], 1)
    ops.element('FourNodeTetrahedron', 9740, *[1995, 2059, 2102, 2030], 1)
    ops.element('FourNodeTetrahedron', 9741, *[2391, 2489, 2394, 2392], 1)
    ops.element('FourNodeTetrahedron', 9742, *[2489, 1775, 1774, 1772], 1)
    ops.element('FourNodeTetrahedron', 9743, *[2394, 1775, 1774, 2489], 1)
    ops.element('FourNodeTetrahedron', 9744, *[2394, 2489, 1834, 2391], 1)
    ops.element('FourNodeTetrahedron', 9745, *[1865, 1862, 2199, 2630], 1)
    ops.element('FourNodeTetrahedron', 9746, *[2630, 1862, 2199, 2334], 1)
    ops.element('FourNodeTetrahedron', 9747, *[2555, 2334, 2630, 1917], 1)
    ops.element('FourNodeTetrahedron', 9748, *[2319, 2421, 2147, 1826], 1)
    ops.element('FourNodeTetrahedron', 9749, *[2237, 1955, 1898, 1913], 1)
    ops.element('FourNodeTetrahedron', 9750, *[1844, 1842, 1898, 1955], 1)
    ops.element('FourNodeTetrahedron', 9751, *[2237, 1955, 1913, 2381], 1)
    ops.element('FourNodeTetrahedron', 9752, *[1844, 1955, 1898, 2237], 1)
    ops.element('FourNodeTetrahedron', 9753, *[2395, 2017, 2563, 2248], 1)
    ops.element('FourNodeTetrahedron', 9754, *[1981, 2532, 2382, 2596], 1)
    ops.element('FourNodeTetrahedron', 9755, *[2237, 1844, 1955, 2381], 1)
    ops.element('FourNodeTetrahedron', 9756, *[2017, 2563, 2638, 2395], 1)
    ops.element('FourNodeTetrahedron', 9757, *[1844, 2383, 1955, 2381], 1)
    ops.element('FourNodeTetrahedron', 9758, *[1195, 2404, 1138, 2349], 1)
    ops.element('FourNodeTetrahedron', 9759, *[2435, 2436, 2133, 2335], 1)
    ops.element('FourNodeTetrahedron', 9760, *[2592, 1886, 2347, 2604], 1)
    ops.element('FourNodeTetrahedron', 9761, *[1999, 2435, 2098, 2284], 1)
    ops.element('FourNodeTetrahedron', 9762, *[2133, 2436, 2099, 2335], 1)
    ops.element('FourNodeTetrahedron', 9763, *[1973, 2306, 1891, 2483], 1)
    ops.element('FourNodeTetrahedron', 9764, *[2573, 2170, 2662, 2653], 1)
    ops.element('FourNodeTetrahedron', 9765, *[2107, 2220, 1836, 1935], 1)
    ops.element('FourNodeTetrahedron', 9766, *[2168, 2125, 2440, 1931], 1)
    ops.element('FourNodeTetrahedron', 9767, *[2026, 2440, 1935, 1852], 1)
    ops.element('FourNodeTetrahedron', 9768, *[2513, 2498, 2496, 2350], 1)
    ops.element('FourNodeTetrahedron', 9769, *[2288, 2287, 1863, 1890], 1)
    ops.element('FourNodeTetrahedron', 9770, *[2418, 1802, 1800, 2027], 1)
    ops.element('FourNodeTetrahedron', 9771, *[2394, 2489, 1774, 1834], 1)
    ops.element('FourNodeTetrahedron', 9772, *[2435, 2335, 2133, 2098], 1)
    ops.element('FourNodeTetrahedron', 9773, *[2043, 2418, 1800, 2027], 1)
    ops.element('FourNodeTetrahedron', 9774, *[1157, 2167, 175, 2134], 1)
    ops.element('FourNodeTetrahedron', 9775, *[2284, 2435, 2098, 2539], 1)
    ops.element('FourNodeTetrahedron', 9776, *[2410, 2411, 2543, 2451], 1)
    ops.element('FourNodeTetrahedron', 9777, *[1834, 1833, 2181, 1835], 1)
    ops.element('FourNodeTetrahedron', 9778, *[2302, 2676, 2411, 2451], 1)
    ops.element('FourNodeTetrahedron', 9779, *[2350, 2411, 2451, 2302], 1)
    ops.element('FourNodeTetrahedron', 9780, *[2348, 2350, 2412, 2410], 1)
    ops.element('FourNodeTetrahedron', 9781, *[2404, 2496, 2142, 2412], 1)
    ops.element('FourNodeTetrahedron', 9782, *[2208, 2290, 2226, 2052], 1)
    ops.element('FourNodeTetrahedron', 9783, *[2298, 2049, 2009, 2256], 1)
    ops.element('FourNodeTetrahedron', 9784, *[2463, 2582, 1997, 1998], 1)
    ops.element('FourNodeTetrahedron', 9785, *[2033, 2297, 2031, 2055], 1)
    ops.element('FourNodeTetrahedron', 9786, *[1940, 1938, 2295, 1979], 1)
    ops.element('FourNodeTetrahedron', 9787, *[2348, 2350, 2410, 2451], 1)
    ops.element('FourNodeTetrahedron', 9788, *[1158, 2573, 683, 682], 1)
    ops.element('FourNodeTetrahedron', 9789, *[2301, 2300, 2498, 2411], 1)
    ops.element('FourNodeTetrahedron', 9790, *[2497, 2529, 2542, 2411], 1)
    ops.element('FourNodeTetrahedron', 9791, *[2557, 2045, 1808, 1881], 1)
    ops.element('FourNodeTetrahedron', 9792, *[2536, 2097, 2356, 2294], 1)
    ops.element('FourNodeTetrahedron', 9793, *[2294, 2272, 2097, 2429], 1)
    ops.element('FourNodeTetrahedron', 9794, *[1946, 2322, 2093, 2186], 1)
    ops.element('FourNodeTetrahedron', 9795, *[2294, 2097, 2356, 2429], 1)
    ops.element('FourNodeTetrahedron', 9796, *[2661, 2637, 2233, 1838], 1)
    ops.element('FourNodeTetrahedron', 9797, *[2097, 2272, 2514, 2429], 1)
    ops.element('FourNodeTetrahedron', 9798, *[2356, 2097, 2514, 2429], 1)
    ops.element('FourNodeTetrahedron', 9799, *[2199, 1950, 2200, 2334], 1)
    ops.element('FourNodeTetrahedron', 9800, *[2043, 2027, 2168, 2158], 1)
    ops.element('FourNodeTetrahedron', 9801, *[1160, 2084, 1212, 652], 1)
    ops.element('FourNodeTetrahedron', 9802, *[2285, 2058, 1994, 1995], 1)
    ops.element('FourNodeTetrahedron', 9803, *[2172, 2072, 1126, 1978], 1)
    ops.element('FourNodeTetrahedron', 9804, *[2292, 2604, 1886, 2290], 1)
    ops.element('FourNodeTetrahedron', 9805, *[2536, 2097, 2526, 2356], 1)
    ops.element('FourNodeTetrahedron', 9806, *[2338, 2140, 2508, 2337], 1)
    ops.element('FourNodeTetrahedron', 9807, *[1832, 2041, 2108, 2110], 1)
    ops.element('FourNodeTetrahedron', 9808, *[2000, 2135, 1809, 1811], 1)
    ops.element('FourNodeTetrahedron', 9809, *[2375, 2376, 2540, 2116], 1)
    ops.element('FourNodeTetrahedron', 9810, *[1867, 2019, 2308, 2332], 1)
    ops.element('FourNodeTetrahedron', 9811, *[1972, 2324, 2079, 2519], 1)
    ops.element('FourNodeTetrahedron', 9812, *[2654, 2672, 1775, 2490], 1)
    ops.element('FourNodeTetrahedron', 9813, *[1891, 2215, 1140, 2619], 1)
    ops.element('FourNodeTetrahedron', 9814, *[2173, 2325, 2538, 2240], 1)
    ops.element('FourNodeTetrahedron', 9815, *[2300, 1858, 2411, 2488], 1)
    ops.element('FourNodeTetrahedron', 9816, *[2343, 2344, 1792, 1795], 1)
    ops.element('FourNodeTetrahedron', 9817, *[1908, 1911, 2322, 1946], 1)
    ops.element('FourNodeTetrahedron', 9818, *[2479, 2560, 2170, 2559], 1)
    ops.element('FourNodeTetrahedron', 9819, *[1166, 2443, 1187, 1122], 1)
    ops.element('FourNodeTetrahedron', 9820, *[2560, 2577, 2578, 2169], 1)
    ops.element('FourNodeTetrahedron', 9821, *[2657, 2455, 2070, 2069], 1)
    ops.element('FourNodeTetrahedron', 9822, *[2560, 2577, 2169, 2502], 1)
    ops.element('FourNodeTetrahedron', 9823, *[2596, 2577, 2578, 2560], 1)
    ops.element('FourNodeTetrahedron', 9824, *[1150, 1913, 1221, 1220], 1)
    ops.element('FourNodeTetrahedron', 9825, *[2301, 2095, 2300, 2303], 1)
    ops.element('FourNodeTetrahedron', 9826, *[1194, 2013, 1195, 2462], 1)
    ops.element('FourNodeTetrahedron', 9827, *[2683, 1894, 759, 1159], 1)
    ops.element('FourNodeTetrahedron', 9828, *[1792, 2296, 2271, 2270], 1)
    ops.element('FourNodeTetrahedron', 9829, *[2667, 1158, 682, 2573], 1)
    ops.element('FourNodeTetrahedron', 9830, *[1955, 2652, 1952, 1954], 1)
    ops.element('FourNodeTetrahedron', 9831, *[2544, 2063, 2239, 2466], 1)
    ops.element('FourNodeTetrahedron', 9832, *[2156, 1871, 1872, 1874], 1)
    ops.element('FourNodeTetrahedron', 9833, *[2438, 2596, 2578, 2560], 1)
    ops.element('FourNodeTetrahedron', 9834, *[1779, 1777, 1776, 2443], 1)
    ops.element('FourNodeTetrahedron', 9835, *[514, 2683, 772, 1159], 1)
    ops.element('FourNodeTetrahedron', 9836, *[1842, 2652, 1952, 1955], 1)
    ops.element('FourNodeTetrahedron', 9837, *[2357, 2596, 2438, 2560], 1)
    ops.element('FourNodeTetrahedron', 9838, *[2357, 2438, 2479, 2560], 1)
    ops.element('FourNodeTetrahedron', 9839, *[2357, 2560, 2479, 2338], 1)
    ops.element('FourNodeTetrahedron', 9840, *[2357, 2596, 2560, 2338], 1)
    ops.element('FourNodeTetrahedron', 9841, *[2495, 2572, 1158, 2667], 1)
    ops.element('FourNodeTetrahedron', 9842, *[2392, 2260, 2391, 2600], 1)
    ops.element('FourNodeTetrahedron', 9843, *[1158, 2572, 2573, 2667], 1)
    ops.element('FourNodeTetrahedron', 9844, *[2354, 2392, 2391, 2600], 1)
    ops.element('FourNodeTetrahedron', 9845, *[1987, 1918, 1857, 1924], 1)
    ops.element('FourNodeTetrahedron', 9846, *[1124, 2595, 1245, 1241], 1)
    ops.element('FourNodeTetrahedron', 9847, *[2092, 2040, 2039, 1832], 1)
    ops.element('FourNodeTetrahedron', 9848, *[2254, 1957, 1958, 2253], 1)
    ops.element('FourNodeTetrahedron', 9849, *[1831, 1846, 1832, 1829], 1)
    ops.element('FourNodeTetrahedron', 9850, *[2092, 2039, 2328, 1832], 1)
    ops.element('FourNodeTetrahedron', 9851, *[2095, 2094, 2544, 2060], 1)
    ops.element('FourNodeTetrahedron', 9852, *[2552, 2414, 2416, 2569], 1)
    ops.element('FourNodeTetrahedron', 9853, *[2116, 2540, 2539, 2541], 1)
    ops.element('FourNodeTetrahedron', 9854, *[2094, 2061, 2544, 2060], 1)
    ops.element('FourNodeTetrahedron', 9855, *[2354, 2391, 2408, 2600], 1)
    ops.element('FourNodeTetrahedron', 9856, *[2392, 2425, 2260, 2600], 1)
    ops.element('FourNodeTetrahedron', 9857, *[2154, 2051, 2225, 1883], 1)
    ops.element('FourNodeTetrahedron', 9858, *[1876, 2567, 1875, 1963], 1)
    ops.element('FourNodeTetrahedron', 9859, *[741, 2586, 740, 2024], 1)
    ops.element('FourNodeTetrahedron', 9860, *[2600, 2425, 2260, 2261], 1)
    ops.element('FourNodeTetrahedron', 9861, *[2030, 1824, 2313, 2103], 1)
    ops.element('FourNodeTetrahedron', 9862, *[2392, 2491, 2260, 2425], 1)
    ops.element('FourNodeTetrahedron', 9863, *[2425, 2491, 2260, 2261], 1)
    ops.element('FourNodeTetrahedron', 9864, *[1234, 1869, 1180, 1235], 1)
    ops.element('FourNodeTetrahedron', 9865, *[1751, 1160, 1168, 651], 1)
    ops.element('FourNodeTetrahedron', 9866, *[2328, 2042, 2108, 2039], 1)
    ops.element('FourNodeTetrahedron', 9867, *[2391, 1834, 1998, 1750], 1)
    ops.element('FourNodeTetrahedron', 9868, *[2391, 2260, 1834, 1750], 1)
    ops.element('FourNodeTetrahedron', 9869, *[2173, 2641, 2325, 2240], 1)
    ops.element('FourNodeTetrahedron', 9870, *[1751, 1753, 1160, 1752], 1)
    ops.element('FourNodeTetrahedron', 9871, *[2221, 2309, 1973, 2485], 1)
    ops.element('FourNodeTetrahedron', 9872, *[2373, 2109, 2374, 2660], 1)
    ops.element('FourNodeTetrahedron', 9873, *[1140, 2215, 1190, 2064], 1)
    ops.element('FourNodeTetrahedron', 9874, *[2051, 2208, 2226, 2052], 1)
    ops.element('FourNodeTetrahedron', 9875, *[1930, 2284, 2562, 1975], 1)
    ops.element('FourNodeTetrahedron', 9876, *[2409, 2632, 2261, 2422], 1)
    ops.element('FourNodeTetrahedron', 9877, *[2414, 1965, 1963, 1964], 1)
    ops.element('FourNodeTetrahedron', 9878, *[2329, 2674, 2648, 2477], 1)
    ops.element('FourNodeTetrahedron', 9879, *[2253, 2625, 2057, 2670], 1)
    ops.element('FourNodeTetrahedron', 9880, *[1930, 2284, 1975, 2307], 1)
    ops.element('FourNodeTetrahedron', 9881, *[2283, 2435, 1999, 2284], 1)
    ops.element('FourNodeTetrahedron', 9882, *[2283, 2135, 1999, 2435], 1)
    ops.element('FourNodeTetrahedron', 9883, *[2522, 2333, 2619, 1923], 1)
    ops.element('FourNodeTetrahedron', 9884, *[2619, 2218, 2064, 1238], 1)
    ops.element('FourNodeTetrahedron', 9885, *[1931, 2285, 1993, 2113], 1)
    ops.element('FourNodeTetrahedron', 9886, *[2619, 2195, 2064, 2218], 1)
    ops.element('FourNodeTetrahedron', 9887, *[1832, 2108, 2111, 2110], 1)
    ops.element('FourNodeTetrahedron', 9888, *[1202, 1949, 1127, 1208], 1)
    ops.element('FourNodeTetrahedron', 9889, *[2362, 2004, 1754, 2117], 1)
    ops.element('FourNodeTetrahedron', 9890, *[2619, 2195, 2218, 2333], 1)
    ops.element('FourNodeTetrahedron', 9891, *[2541, 2201, 2197, 2199], 1)
    ops.element('FourNodeTetrahedron', 9892, *[2333, 2195, 2218, 2200], 1)
    ops.element('FourNodeTetrahedron', 9893, *[2321, 2153, 2154, 2234], 1)
    ops.element('FourNodeTetrahedron', 9894, *[2333, 2200, 2218, 1923], 1)
    ops.element('FourNodeTetrahedron', 9895, *[1980, 2668, 1787, 2055], 1)
    ops.element('FourNodeTetrahedron', 9896, *[2321, 2153, 2234, 1848], 1)
    ops.element('FourNodeTetrahedron', 9897, *[2442, 2443, 1166, 1759], 1)
    ops.element('FourNodeTetrahedron', 9898, *[2442, 2106, 2067, 2458], 1)
    ops.element('FourNodeTetrahedron', 9899, *[2215, 2195, 2064, 2619], 1)
    ops.element('FourNodeTetrahedron', 9900, *[1859, 1973, 1891, 2007], 1)
    ops.element('FourNodeTetrahedron', 9901, *[1974, 1973, 1859, 2007], 1)
    ops.element('FourNodeTetrahedron', 9902, *[2107, 1935, 1949, 1852], 1)
    ops.element('FourNodeTetrahedron', 9903, *[1771, 1768, 2154, 2051], 1)
    ops.element('FourNodeTetrahedron', 9904, *[2422, 2107, 1949, 1852], 1)
    ops.element('FourNodeTetrahedron', 9905, *[1771, 1956, 1768, 2051], 1)
    ops.element('FourNodeTetrahedron', 9906, *[1859, 2007, 1891, 2467], 1)
    ops.element('FourNodeTetrahedron', 9907, *[2554, 2585, 1882, 1904], 1)
    ops.element('FourNodeTetrahedron', 9908, *[1899, 1951, 1950, 2564], 1)
    ops.element('FourNodeTetrahedron', 9909, *[2215, 2196, 2251, 2064], 1)
    ops.element('FourNodeTetrahedron', 9910, *[723, 2182, 2235, 1835], 1)
    ops.element('FourNodeTetrahedron', 9911, *[1860, 1993, 2307, 1974], 1)
    ops.element('FourNodeTetrahedron', 9912, *[2387, 2138, 2337, 2624], 1)
    ops.element('FourNodeTetrahedron', 9913, *[1875, 2566, 2175, 1963], 1)
    ops.element('FourNodeTetrahedron', 9914, *[2617, 2154, 1137, 1175], 1)
    ops.element('FourNodeTetrahedron', 9915, *[2104, 1825, 1227, 1799], 1)
    ops.element('FourNodeTetrahedron', 9916, *[1974, 1973, 2007, 2222], 1)
    ops.element('FourNodeTetrahedron', 9917, *[1974, 2494, 1973, 2222], 1)
    ops.element('FourNodeTetrahedron', 9918, *[2330, 2042, 2108, 2328], 1)
    ops.element('FourNodeTetrahedron', 9919, *[2007, 2222, 1973, 2008], 1)
    ops.element('FourNodeTetrahedron', 9920, *[1934, 1932, 1936, 1933], 1)
    ops.element('FourNodeTetrahedron', 9921, *[2024, 2021, 1142, 1197], 1)
    ops.element('FourNodeTetrahedron', 9922, *[2031, 1816, 1885, 2603], 1)
    ops.element('FourNodeTetrahedron', 9923, *[2018, 2515, 2132, 1868], 1)
    ops.element('FourNodeTetrahedron', 9924, *[2139, 2271, 2379, 2269], 1)
    ops.element('FourNodeTetrahedron', 9925, *[2081, 2077, 2075, 2151], 1)
    ops.element('FourNodeTetrahedron', 9926, *[2526, 2097, 2103, 2221], 1)
    ops.element('FourNodeTetrahedron', 9927, *[1964, 1962, 2233, 2620], 1)
    ops.element('FourNodeTetrahedron', 9928, *[1893, 2607, 1988, 1780], 1)
    ops.element('FourNodeTetrahedron', 9929, *[2356, 2097, 2221, 2514], 1)
    ops.element('FourNodeTetrahedron', 9930, *[1844, 1843, 1842, 1955], 1)
    ops.element('FourNodeTetrahedron', 9931, *[2221, 2097, 2655, 2514], 1)
    ops.element('FourNodeTetrahedron', 9932, *[2506, 2488, 2676, 2302], 1)
    ops.element('FourNodeTetrahedron', 9933, *[1219, 2298, 1164, 1225], 1)
    ops.element('FourNodeTetrahedron', 9934, *[2439, 2163, 2162, 1926], 1)
    ops.element('FourNodeTetrahedron', 9935, *[1869, 1248, 1180, 1235], 1)
    ops.element('FourNodeTetrahedron', 9936, *[2517, 2338, 2479, 2478], 1)
    ops.element('FourNodeTetrahedron', 9937, *[2000, 2283, 2135, 1999], 1)
    ops.element('FourNodeTetrahedron', 9938, *[2000, 2351, 2135, 2283], 1)
    ops.element('FourNodeTetrahedron', 9939, *[1936, 2283, 2000, 1999], 1)
    ops.element('FourNodeTetrahedron', 9940, *[2319, 2600, 2409, 2421], 1)
    ops.element('FourNodeTetrahedron', 9941, *[2225, 2556, 1152, 2594], 1)
    ops.element('FourNodeTetrahedron', 9942, *[2616, 1933, 1930, 1851], 1)
    ops.element('FourNodeTetrahedron', 9943, *[1797, 1799, 1188, 1796], 1)
    ops.element('FourNodeTetrahedron', 9944, *[2600, 2409, 2408, 2319], 1)
    ops.element('FourNodeTetrahedron', 9945, *[2469, 2471, 2640, 1806], 1)
    ops.element('FourNodeTetrahedron', 9946, *[2680, 2346, 1856, 2345], 1)
    ops.element('FourNodeTetrahedron', 9947, *[1241, 2457, 1250, 1178], 1)
    ops.element('FourNodeTetrahedron', 9948, *[2404, 2142, 1231, 2412], 1)
    ops.element('FourNodeTetrahedron', 9949, *[2273, 2581, 1963, 2414], 1)
    ops.element('FourNodeTetrahedron', 9950, *[2472, 1984, 2399, 1841], 1)
    ops.element('FourNodeTetrahedron', 9951, *[2600, 2261, 2408, 2409], 1)
    ops.element('FourNodeTetrahedron', 9952, *[1772, 2363, 2364, 2310], 1)
    ops.element('FourNodeTetrahedron', 9953, *[1766, 1987, 1782, 1986], 1)
    ops.element('FourNodeTetrahedron', 9954, *[1188, 1799, 1184, 1796], 1)
    ops.element('FourNodeTetrahedron', 9955, *[1852, 1931, 1933, 1851], 1)
    ops.element('FourNodeTetrahedron', 9956, *[1931, 1930, 1933, 1851], 1)
    ops.element('FourNodeTetrahedron', 9957, *[2231, 2232, 1902, 2233], 1)
    ops.element('FourNodeTetrahedron', 9958, *[2221, 2655, 2100, 2485], 1)
    ops.element('FourNodeTetrahedron', 9959, *[2157, 1931, 1851, 2325], 1)
    ops.element('FourNodeTetrahedron', 9960, *[2157, 1931, 1852, 1851], 1)
    ops.element('FourNodeTetrahedron', 9961, *[2538, 2157, 1851, 2325], 1)
    ops.element('FourNodeTetrahedron', 9962, *[1145, 1244, 1236, 1753], 1)
    ops.element('FourNodeTetrahedron', 9963, *[2529, 2544, 2682, 2488], 1)
    ops.element('FourNodeTetrahedron', 9964, *[1996, 2102, 2116, 2309], 1)
    ops.element('FourNodeTetrahedron', 9965, *[1963, 1962, 2231, 1964], 1)
    ops.element('FourNodeTetrahedron', 9966, *[2384, 2462, 621, 2450], 1)
    ops.element('FourNodeTetrahedron', 9967, *[2397, 1979, 2396, 2358], 1)
    ops.element('FourNodeTetrahedron', 9968, *[2561, 2338, 2590, 2508], 1)
    ops.element('FourNodeTetrahedron', 9969, *[2170, 2368, 1146, 2662], 1)
    ops.element('FourNodeTetrahedron', 9970, *[2074, 2419, 1234, 1869], 1)
    ops.element('FourNodeTetrahedron', 9971, *[1750, 2261, 1836, 2107], 1)
    ops.element('FourNodeTetrahedron', 9972, *[2142, 2496, 2528, 2412], 1)
    ops.element('FourNodeTetrahedron', 9973, *[2517, 2338, 2590, 2561], 1)
    ops.element('FourNodeTetrahedron', 9974, *[1886, 1765, 2512, 2509], 1)
    ops.element('FourNodeTetrahedron', 9975, *[2430, 2086, 2121, 1839], 1)
    ops.element('FourNodeTetrahedron', 9976, *[1886, 2509, 2512, 2347], 1)
    ops.element('FourNodeTetrahedron', 9977, *[2389, 2241, 2240, 2544], 1)
    ops.element('FourNodeTetrahedron', 9978, *[2388, 2389, 2240, 2544], 1)
    ops.element('FourNodeTetrahedron', 9979, *[2488, 2682, 2542, 2492], 1)
    ops.element('FourNodeTetrahedron', 9980, *[2488, 2544, 2682, 2492], 1)
    ops.element('FourNodeTetrahedron', 9981, *[2388, 2240, 2682, 2544], 1)
    ops.element('FourNodeTetrahedron', 9982, *[1930, 1932, 2283, 1994], 1)
    ops.element('FourNodeTetrahedron', 9983, *[1939, 1961, 2472, 2114], 1)
    ops.element('FourNodeTetrahedron', 9984, *[1932, 2283, 1936, 1930], 1)
    ops.element('FourNodeTetrahedron', 9985, *[1932, 2464, 2283, 1994], 1)
    ops.element('FourNodeTetrahedron', 9986, *[2170, 2172, 1146, 2368], 1)
    ops.element('FourNodeTetrahedron', 9987, *[1188, 1227, 1233, 1799], 1)
    ops.element('FourNodeTetrahedron', 9988, *[2662, 2368, 1146, 684], 1)
    ops.element('FourNodeTetrahedron', 9989, *[623, 2348, 2451, 611], 1)
    ops.element('FourNodeTetrahedron', 9990, *[1879, 1881, 2046, 2635], 1)
    ops.element('FourNodeTetrahedron', 9991, *[2318, 1989, 1991, 1990], 1)
    ops.element('FourNodeTetrahedron', 9992, *[1254, 2259, 1751, 650], 1)
    ops.element('FourNodeTetrahedron', 9993, *[1993, 1995, 1996, 2309], 1)
    ops.element('FourNodeTetrahedron', 9994, *[1851, 1931, 1930, 1993], 1)
    ops.element('FourNodeTetrahedron', 9995, *[1851, 1931, 1993, 2325], 1)
    ops.element('FourNodeTetrahedron', 9996, *[1782, 1987, 2446, 2345], 1)
    ops.element('FourNodeTetrahedron', 9997, *[1931, 1994, 1930, 1993], 1)
    ops.element('FourNodeTetrahedron', 9998, *[2266, 1768, 1942, 2617], 1)
    ops.element('FourNodeTetrahedron', 9999, *[1931, 2113, 1993, 2325], 1)
    ops.element('FourNodeTetrahedron', 10000, *[2142, 2528, 2402, 1231], 1)
    ops.element('FourNodeTetrahedron', 10001, *[2654, 1775, 2394, 2489], 1)
    ops.element('FourNodeTetrahedron', 10002, *[2654, 2489, 2394, 2392], 1)
    ops.element('FourNodeTetrahedron', 10003, *[2407, 2406, 2405, 2682], 1)
    ops.element('FourNodeTetrahedron', 10004, *[1861, 2406, 1974, 2405], 1)
    ops.element('FourNodeTetrahedron', 10005, *[1980, 2668, 2532, 1746], 1)
    ops.element('FourNodeTetrahedron', 10006, *[1914, 2334, 1916, 2606], 1)
    ops.element('FourNodeTetrahedron', 10007, *[2405, 2406, 1974, 2682], 1)
    ops.element('FourNodeTetrahedron', 10008, *[1851, 1993, 1860, 2406], 1)
    ops.element('FourNodeTetrahedron', 10009, *[1996, 2309, 2539, 2306], 1)
    ops.element('FourNodeTetrahedron', 10010, *[1222, 2172, 1126, 1146], 1)
    ops.element('FourNodeTetrahedron', 10011, *[1803, 1832, 2482, 1830], 1)
    ops.element('FourNodeTetrahedron', 10012, *[2406, 1993, 1860, 1974], 1)
    ops.element('FourNodeTetrahedron', 10013, *[1861, 2406, 1860, 1974], 1)
    ops.element('FourNodeTetrahedron', 10014, *[1861, 1851, 1860, 2406], 1)
    ops.element('FourNodeTetrahedron', 10015, *[1225, 2256, 1226, 1180], 1)
    ops.element('FourNodeTetrahedron', 10016, *[2365, 2622, 2190, 2268], 1)
    ops.element('FourNodeTetrahedron', 10017, *[2443, 2679, 1776, 2365], 1)
    ops.element('FourNodeTetrahedron', 10018, *[1218, 2048, 1217, 1219], 1)
    ops.element('FourNodeTetrahedron', 10019, *[1832, 2351, 2111, 2110], 1)
    ops.element('FourNodeTetrahedron', 10020, *[2294, 2273, 2272, 2565], 1)
    ops.element('FourNodeTetrahedron', 10021, *[1187, 1776, 1198, 1186], 1)
    ops.element('FourNodeTetrahedron', 10022, *[2443, 1776, 1187, 1122], 1)
    ops.element('FourNodeTetrahedron', 10023, *[1776, 2622, 1198, 1186], 1)
    ops.element('FourNodeTetrahedron', 10024, *[1776, 2622, 1186, 2190], 1)
    ops.element('FourNodeTetrahedron', 10025, *[2133, 2436, 2134, 2099], 1)
    ops.element('FourNodeTetrahedron', 10026, *[2133, 2134, 1170, 2099], 1)
    ops.element('FourNodeTetrahedron', 10027, *[2617, 1768, 1942, 2225], 1)
    ops.element('FourNodeTetrahedron', 10028, *[1911, 2393, 2446, 1912], 1)
    ops.element('FourNodeTetrahedron', 10029, *[1234, 2419, 1180, 1869], 1)
    ops.element('FourNodeTetrahedron', 10030, *[1827, 2319, 1825, 1826], 1)
    ops.element('FourNodeTetrahedron', 10031, *[1854, 2157, 1852, 1851], 1)
    ops.element('FourNodeTetrahedron', 10032, *[2428, 2686, 2468, 2185], 1)
    ops.element('FourNodeTetrahedron', 10033, *[2227, 2209, 2014, 2226], 1)
    ops.element('FourNodeTetrahedron', 10034, *[2343, 2587, 2344, 1795], 1)
    ops.element('FourNodeTetrahedron', 10035, *[551, 2467, 1232, 2202], 1)
    ops.element('FourNodeTetrahedron', 10036, *[1945, 2014, 1943, 2227], 1)
    ops.element('FourNodeTetrahedron', 10037, *[1776, 1778, 2622, 2365], 1)
    ops.element('FourNodeTetrahedron', 10038, *[2068, 2147, 1201, 1825], 1)
    ops.element('FourNodeTetrahedron', 10039, *[1842, 1843, 2652, 1955], 1)
    ops.element('FourNodeTetrahedron', 10040, *[1827, 2319, 2068, 1825], 1)
    ops.element('FourNodeTetrahedron', 10041, *[2360, 2426, 2004, 2280], 1)
    ops.element('FourNodeTetrahedron', 10042, *[2592, 2349, 2462, 2347], 1)
    ops.element('FourNodeTetrahedron', 10043, *[1776, 2669, 1198, 2622], 1)
    ops.element('FourNodeTetrahedron', 10044, *[2256, 2020, 2359, 1869], 1)
    ops.element('FourNodeTetrahedron', 10045, *[2021, 2669, 1198, 1776], 1)
    ops.element('FourNodeTetrahedron', 10046, *[2220, 2482, 2219, 1934], 1)
    ops.element('FourNodeTetrahedron', 10047, *[2397, 1940, 2295, 1979], 1)
    ops.element('FourNodeTetrahedron', 10048, *[1776, 1778, 2669, 2622], 1)
    ops.element('FourNodeTetrahedron', 10049, *[1895, 1896, 2538, 1856], 1)
    ops.element('FourNodeTetrahedron', 10050, *[2243, 2248, 2533, 2274], 1)
    ops.element('FourNodeTetrahedron', 10051, *[2243, 1958, 2248, 2274], 1)
    ops.element('FourNodeTetrahedron', 10052, *[2565, 2231, 2086, 2430], 1)
    ops.element('FourNodeTetrahedron', 10053, *[2292, 1920, 2509, 2583], 1)
    ops.element('FourNodeTetrahedron', 10054, *[743, 2047, 1193, 1143], 1)
    ops.element('FourNodeTetrahedron', 10055, *[2024, 2586, 2137, 2023], 1)
    ops.element('FourNodeTetrahedron', 10056, *[2299, 1171, 737, 1142], 1)
    ops.element('FourNodeTetrahedron', 10057, *[740, 2299, 737, 1142], 1)
    ops.element('FourNodeTetrahedron', 10058, *[2024, 2299, 740, 1142], 1)
    ops.element('FourNodeTetrahedron', 10059, *[2299, 1907, 2011, 1905], 1)
    ops.element('FourNodeTetrahedron', 10060, *[2299, 2137, 2011, 1907], 1)
    ops.element('FourNodeTetrahedron', 10061, *[740, 2137, 737, 2299], 1)
    ops.element('FourNodeTetrahedron', 10062, *[2310, 2364, 2220, 2482], 1)
    ops.element('FourNodeTetrahedron', 10063, *[2416, 1964, 2611, 2569], 1)
    ops.element('FourNodeTetrahedron', 10064, *[2010, 2193, 2006, 2522], 1)
    ops.element('FourNodeTetrahedron', 10065, *[1914, 2606, 1950, 2639], 1)
    ops.element('FourNodeTetrahedron', 10066, *[2061, 2063, 2544, 2060], 1)
    ops.element('FourNodeTetrahedron', 10067, *[2495, 2170, 2572, 2559], 1)
    ops.element('FourNodeTetrahedron', 10068, *[2006, 2008, 2193, 1917], 1)
    ops.element('FourNodeTetrahedron', 10069, *[2010, 2008, 2006, 2193], 1)
    ops.element('FourNodeTetrahedron', 10070, *[2006, 1917, 2333, 2522], 1)
    ops.element('FourNodeTetrahedron', 10071, *[2008, 2630, 2483, 2006], 1)
    ops.element('FourNodeTetrahedron', 10072, *[2006, 2630, 2333, 1917], 1)
    ops.element('FourNodeTetrahedron', 10073, *[1904, 2585, 1882, 1881], 1)
    ops.element('FourNodeTetrahedron', 10074, *[2010, 2006, 1892, 2522], 1)
    ops.element('FourNodeTetrahedron', 10075, *[1973, 2008, 2483, 2006], 1)
    ops.element('FourNodeTetrahedron', 10076, *[2015, 2264, 1937, 2013], 1)
    ops.element('FourNodeTetrahedron', 10077, *[2111, 2108, 2373, 2109], 1)
    ops.element('FourNodeTetrahedron', 10078, *[2247, 1889, 1767, 2264], 1)
    ops.element('FourNodeTetrahedron', 10079, *[1935, 2219, 2000, 1934], 1)
    ops.element('FourNodeTetrahedron', 10080, *[2347, 2605, 2350, 2507], 1)
    ops.element('FourNodeTetrahedron', 10081, *[2199, 2198, 2195, 2200], 1)
    ops.element('FourNodeTetrahedron', 10082, *[1935, 2000, 2120, 1936], 1)
    ops.element('FourNodeTetrahedron', 10083, *[1935, 1934, 2000, 1936], 1)
    ops.element('FourNodeTetrahedron', 10084, *[1194, 2462, 1154, 622], 1)
    ops.element('FourNodeTetrahedron', 10085, *[622, 2462, 623, 2450], 1)
    ops.element('FourNodeTetrahedron', 10086, *[2443, 2365, 1776, 1122], 1)
    ops.element('FourNodeTetrahedron', 10087, *[2462, 623, 1154, 622], 1)
    ops.element('FourNodeTetrahedron', 10088, *[1791, 1789, 2367, 1790], 1)
    ops.element('FourNodeTetrahedron', 10089, *[2462, 2348, 1154, 623], 1)
    ops.element('FourNodeTetrahedron', 10090, *[2462, 2450, 2348, 623], 1)
    ops.element('FourNodeTetrahedron', 10091, *[1221, 1952, 1218, 1953], 1)
    ops.element('FourNodeTetrahedron', 10092, *[2170, 2169, 2172, 2368], 1)
    ops.element('FourNodeTetrahedron', 10093, *[2061, 1806, 2621, 2186], 1)
    ops.element('FourNodeTetrahedron', 10094, *[1798, 2149, 1799, 1937], 1)
    ops.element('FourNodeTetrahedron', 10095, *[2076, 2002, 2003, 2004], 1)
    ops.element('FourNodeTetrahedron', 10096, *[2466, 2063, 2194, 2123], 1)
    ops.element('FourNodeTetrahedron', 10097, *[2239, 2241, 2242, 2194], 1)
    ops.element('FourNodeTetrahedron', 10098, *[2492, 2194, 2242, 2203], 1)
    ops.element('FourNodeTetrahedron', 10099, *[2143, 2148, 2142, 2404], 1)
    ops.element('FourNodeTetrahedron', 10100, *[2556, 2592, 2013, 2462], 1)
    ops.element('FourNodeTetrahedron', 10101, *[2556, 2013, 1194, 2462], 1)
    ops.element('FourNodeTetrahedron', 10102, *[2579, 1895, 2142, 2496], 1)
    ops.element('FourNodeTetrahedron', 10103, *[1834, 1772, 1833, 1836], 1)
    ops.element('FourNodeTetrahedron', 10104, *[1835, 1833, 2230, 1836], 1)
    ops.element('FourNodeTetrahedron', 10105, *[1833, 2364, 2230, 2220], 1)
    ops.element('FourNodeTetrahedron', 10106, *[2583, 2584, 2510, 2291], 1)
    ops.element('FourNodeTetrahedron', 10107, *[2583, 2377, 2510, 2584], 1)
    ops.element('FourNodeTetrahedron', 10108, *[1985, 1984, 2472, 1982], 1)
    ops.element('FourNodeTetrahedron', 10109, *[1982, 1984, 1841, 1960], 1)
    ops.element('FourNodeTetrahedron', 10110, *[1961, 1982, 1841, 1960], 1)
    ops.element('FourNodeTetrahedron', 10111, *[1149, 2098, 2250, 2255], 1)
    ops.element('FourNodeTetrahedron', 10112, *[741, 2627, 2586, 2024], 1)
    ops.element('FourNodeTetrahedron', 10113, *[1836, 1833, 2230, 2220], 1)
    ops.element('FourNodeTetrahedron', 10114, *[2566, 2665, 2175, 1962], 1)
    ops.element('FourNodeTetrahedron', 10115, *[1862, 1901, 2262, 1951], 1)
    ops.element('FourNodeTetrahedron', 10116, *[1901, 2684, 2262, 1951], 1)
    ops.element('FourNodeTetrahedron', 10117, *[2521, 1762, 2607, 1780], 1)
    ops.element('FourNodeTetrahedron', 10118, *[1884, 1885, 1784, 2031], 1)
    ops.element('FourNodeTetrahedron', 10119, *[2613, 2648, 2674, 2615], 1)
    ops.element('FourNodeTetrahedron', 10120, *[2377, 2303, 2510, 2584], 1)
    ops.element('FourNodeTetrahedron', 10121, *[2063, 2621, 2241, 2123], 1)
    ops.element('FourNodeTetrahedron', 10122, *[2495, 2170, 1158, 2572], 1)
    ops.element('FourNodeTetrahedron', 10123, *[2264, 2513, 2349, 2512], 1)
    ops.element('FourNodeTetrahedron', 10124, *[2249, 2254, 1769, 1958], 1)
    ops.element('FourNodeTetrahedron', 10125, *[2679, 1778, 1776, 2365], 1)
    ops.element('FourNodeTetrahedron', 10126, *[2073, 1953, 1256, 2074], 1)
    ops.element('FourNodeTetrahedron', 10127, *[2228, 2568, 711, 1210], 1)
    ops.element('FourNodeTetrahedron', 10128, *[1806, 1804, 1758, 2184], 1)
    ops.element('FourNodeTetrahedron', 10129, *[1186, 2622, 2505, 2268], 1)
    ops.element('FourNodeTetrahedron', 10130, *[2597, 2553, 2519, 2342], 1)
    ops.element('FourNodeTetrahedron', 10131, *[2140, 2269, 2452, 2624], 1)
    ops.element('FourNodeTetrahedron', 10132, *[2486, 2553, 2597, 2386], 1)
    ops.element('FourNodeTetrahedron', 10133, *[1819, 2104, 1233, 2505], 1)
    ops.element('FourNodeTetrahedron', 10134, *[2622, 2115, 1819, 2505], 1)
    ops.element('FourNodeTetrahedron', 10135, *[1819, 2115, 2104, 2505], 1)
    ops.element('FourNodeTetrahedron', 10136, *[2622, 2115, 2505, 2503], 1)
    ops.element('FourNodeTetrahedron', 10137, *[2505, 2115, 2104, 2503], 1)
    ops.element('FourNodeTetrahedron', 10138, *[2622, 2505, 1128, 1186], 1)
    ops.element('FourNodeTetrahedron', 10139, *[2622, 1819, 1128, 2505], 1)
    ops.element('FourNodeTetrahedron', 10140, *[1128, 2505, 1233, 1186], 1)
    ops.element('FourNodeTetrahedron', 10141, *[1128, 1819, 1233, 2505], 1)
    ops.element('FourNodeTetrahedron', 10142, *[2005, 2585, 2554, 1763], 1)
    ops.element('FourNodeTetrahedron', 10143, *[1762, 1763, 1866, 1842], 1)
    ops.element('FourNodeTetrahedron', 10144, *[2005, 2585, 750, 2554], 1)
    ops.element('FourNodeTetrahedron', 10145, *[2422, 1852, 1949, 2145], 1)
    ops.element('FourNodeTetrahedron', 10146, *[2554, 2585, 750, 1882], 1)
    ops.element('FourNodeTetrahedron', 10147, *[750, 1882, 751, 1207], 1)
    ops.element('FourNodeTetrahedron', 10148, *[2188, 2340, 2478, 2189], 1)
    ops.element('FourNodeTetrahedron', 10149, *[2555, 2334, 1917, 2085], 1)
    ops.element('FourNodeTetrahedron', 10150, *[2256, 1237, 1226, 2359], 1)
    ops.element('FourNodeTetrahedron', 10151, *[750, 2585, 751, 1882], 1)
    ops.element('FourNodeTetrahedron', 10152, *[1229, 2170, 1146, 2662], 1)
    ops.element('FourNodeTetrahedron', 10153, *[2554, 1882, 750, 1207], 1)
    ops.element('FourNodeTetrahedron', 10154, *[2554, 1882, 1207, 1880], 1)
    ops.element('FourNodeTetrahedron', 10155, *[2554, 1207, 750, 1153], 1)
    ops.element('FourNodeTetrahedron', 10156, *[1153, 2554, 1207, 1880], 1)
    ops.element('FourNodeTetrahedron', 10157, *[2214, 2532, 2596, 2080], 1)
    ops.element('FourNodeTetrahedron', 10158, *[2625, 2447, 2053, 2670], 1)
    ops.element('FourNodeTetrahedron', 10159, *[1989, 2002, 2152, 2318], 1)
    ops.element('FourNodeTetrahedron', 10160, *[2479, 2559, 2495, 2591], 1)
    ops.element('FourNodeTetrahedron', 10161, *[1853, 1851, 1860, 1861], 1)
    ops.element('FourNodeTetrahedron', 10162, *[2031, 2603, 1787, 2645], 1)
    ops.element('FourNodeTetrahedron', 10163, *[2373, 2461, 2087, 2167], 1)
    ops.element('FourNodeTetrahedron', 10164, *[2111, 2373, 2088, 2351], 1)
    ops.element('FourNodeTetrahedron', 10165, *[2088, 2089, 2373, 2111], 1)
    ops.element('FourNodeTetrahedron', 10166, *[1756, 1967, 2527, 1966], 1)
    ops.element('FourNodeTetrahedron', 10167, *[2111, 2109, 2373, 2351], 1)
    ops.element('FourNodeTetrahedron', 10168, *[2373, 2109, 2660, 2351], 1)
    ops.element('FourNodeTetrahedron', 10169, *[2488, 2492, 2542, 2676], 1)
    ops.element('FourNodeTetrahedron', 10170, *[2676, 2492, 2542, 2558], 1)
    ops.element('FourNodeTetrahedron', 10171, *[2488, 2544, 2492, 2506], 1)
    ops.element('FourNodeTetrahedron', 10172, *[2479, 2517, 2590, 2518], 1)
    ops.element('FourNodeTetrahedron', 10173, *[2530, 2157, 2422, 1854], 1)
    ops.element('FourNodeTetrahedron', 10174, *[1914, 1950, 2200, 2639], 1)
    ops.element('FourNodeTetrahedron', 10175, *[2264, 1767, 2263, 1764], 1)
    ops.element('FourNodeTetrahedron', 10176, *[2525, 2362, 2369, 2656], 1)
    ops.element('FourNodeTetrahedron', 10177, *[2438, 1981, 2381, 2596], 1)
    ops.element('FourNodeTetrahedron', 10178, *[2584, 1925, 2377, 2303], 1)
    ops.element('FourNodeTetrahedron', 10179, *[2082, 2675, 2077, 2224], 1)
    ops.element('FourNodeTetrahedron', 10180, *[2009, 2257, 2275, 2258], 1)
    ops.element('FourNodeTetrahedron', 10181, *[2011, 2136, 738, 2380], 1)
    ops.element('FourNodeTetrahedron', 10182, *[1940, 2571, 2295, 1938], 1)
    ops.element('FourNodeTetrahedron', 10183, *[1888, 1921, 1765, 1920], 1)
    ops.element('FourNodeTetrahedron', 10184, *[2121, 1837, 1840, 1839], 1)
    ops.element('FourNodeTetrahedron', 10185, *[2345, 2388, 1856, 1858], 1)
    ops.element('FourNodeTetrahedron', 10186, *[2506, 2544, 2492, 2466], 1)
    ops.element('FourNodeTetrahedron', 10187, *[2411, 2529, 2542, 2488], 1)
    ops.element('FourNodeTetrahedron', 10188, *[2537, 2255, 1149, 1191], 1)
    ops.element('FourNodeTetrahedron', 10189, *[2411, 2488, 2542, 2676], 1)
    ops.element('FourNodeTetrahedron', 10190, *[1858, 2544, 2529, 2488], 1)
    ops.element('FourNodeTetrahedron', 10191, *[1978, 1753, 1145, 2614], 1)
    ops.element('FourNodeTetrahedron', 10192, *[2411, 1858, 2529, 2488], 1)
    ops.element('FourNodeTetrahedron', 10193, *[731, 2582, 1997, 2463], 1)
    ops.element('FourNodeTetrahedron', 10194, *[731, 2582, 723, 1997], 1)
    ops.element('FourNodeTetrahedron', 10195, *[2055, 2668, 1980, 1746], 1)
    ops.element('FourNodeTetrahedron', 10196, *[731, 1997, 723, 1173], 1)
    ops.element('FourNodeTetrahedron', 10197, *[2582, 2183, 1997, 1834], 1)
    ops.element('FourNodeTetrahedron', 10198, *[2582, 1834, 1997, 1998], 1)
    ops.element('FourNodeTetrahedron', 10199, *[2286, 2289, 2287, 2176], 1)
    ops.element('FourNodeTetrahedron', 10200, *[1997, 1834, 2183, 1835], 1)
    ops.element('FourNodeTetrahedron', 10201, *[2352, 2304, 2463, 2070], 1)
    ops.element('FourNodeTetrahedron', 10202, *[2235, 2228, 1252, 1147], 1)
    ops.element('FourNodeTetrahedron', 10203, *[1235, 1869, 2078, 1870], 1)
    ops.element('FourNodeTetrahedron', 10204, *[2183, 2182, 723, 1835], 1)
    ops.element('FourNodeTetrahedron', 10205, *[1997, 2183, 723, 1835], 1)
    ops.element('FourNodeTetrahedron', 10206, *[2582, 2183, 723, 1997], 1)
    ops.element('FourNodeTetrahedron', 10207, *[1993, 1995, 2309, 2526], 1)
    ops.element('FourNodeTetrahedron', 10208, *[2526, 2309, 2307, 2221], 1)
    ops.element('FourNodeTetrahedron', 10209, *[1139, 1882, 1162, 1879], 1)
    ops.element('FourNodeTetrahedron', 10210, *[2325, 2526, 1993, 2494], 1)
    ops.element('FourNodeTetrahedron', 10211, *[1844, 1842, 2449, 1898], 1)
    ops.element('FourNodeTetrahedron', 10212, *[1127, 1949, 1209, 1208], 1)
    ops.element('FourNodeTetrahedron', 10213, *[1836, 2229, 1835, 1750], 1)
    ops.element('FourNodeTetrahedron', 10214, *[1974, 2494, 2307, 1973], 1)
    ops.element('FourNodeTetrahedron', 10215, *[1921, 1919, 1909, 1924], 1)
    ops.element('FourNodeTetrahedron', 10216, *[2401, 2167, 2166, 1809], 1)
    ops.element('FourNodeTetrahedron', 10217, *[1218, 2048, 1219, 1953], 1)
    ops.element('FourNodeTetrahedron', 10218, *[1974, 1993, 2307, 2494], 1)
    ops.element('FourNodeTetrahedron', 10219, *[2494, 1973, 2307, 2221], 1)
    ops.element('FourNodeTetrahedron', 10220, *[2393, 1805, 2448, 2322], 1)
    ops.element('FourNodeTetrahedron', 10221, *[2646, 2056, 2035, 2487], 1)
    ops.element('FourNodeTetrahedron', 10222, *[2446, 2393, 2448, 1912], 1)
    ops.element('FourNodeTetrahedron', 10223, *[2307, 2309, 1973, 2221], 1)
    ops.element('FourNodeTetrahedron', 10224, *[2151, 2002, 2152, 1989], 1)
    ops.element('FourNodeTetrahedron', 10225, *[1215, 1859, 1191, 1232], 1)
    ops.element('FourNodeTetrahedron', 10226, *[1760, 2005, 2554, 1763], 1)
    ops.element('FourNodeTetrahedron', 10227, *[1962, 2232, 2233, 2620], 1)
    ops.element('FourNodeTetrahedron', 10228, *[2357, 2055, 1747, 2570], 1)
    ops.element('FourNodeTetrahedron', 10229, *[2663, 1985, 1939, 1961], 1)
    ops.element('FourNodeTetrahedron', 10230, *[2444, 2377, 1920, 2583], 1)
    ops.element('FourNodeTetrahedron', 10231, *[2444, 2377, 2583, 2584], 1)
    ops.element('FourNodeTetrahedron', 10232, *[2364, 2311, 2666, 2642], 1)
    ops.element('FourNodeTetrahedron', 10233, *[2334, 1950, 2200, 1914], 1)
    ops.element('FourNodeTetrahedron', 10234, *[2224, 2549, 2341, 2296], 1)
    ops.element('FourNodeTetrahedron', 10235, *[2339, 2387, 2138, 2337], 1)
    ops.element('FourNodeTetrahedron', 10236, *[2647, 2339, 2337, 2387], 1)
    ops.element('FourNodeTetrahedron', 10237, *[1835, 2228, 2235, 1147], 1)
    ops.element('FourNodeTetrahedron', 10238, *[1189, 2068, 1201, 1825], 1)
    ops.element('FourNodeTetrahedron', 10239, *[2296, 1793, 2341, 2326], 1)
    ops.element('FourNodeTetrahedron', 10240, *[1780, 1762, 1988, 1781], 1)
    ops.element('FourNodeTetrahedron', 10241, *[2296, 2685, 2326, 2327], 1)
    ops.element('FourNodeTetrahedron', 10242, *[1136, 2408, 1206, 2068], 1)
    ops.element('FourNodeTetrahedron', 10243, *[2482, 2111, 2219, 2588], 1)
    ops.element('FourNodeTetrahedron', 10244, *[2296, 1793, 2685, 2326], 1)
    ops.element('FourNodeTetrahedron', 10245, *[2270, 2296, 2327, 2610], 1)
    ops.element('FourNodeTetrahedron', 10246, *[2380, 2070, 1174, 1821], 1)
    ops.element('FourNodeTetrahedron', 10247, *[2628, 2613, 2629, 2615], 1)
    ops.element('FourNodeTetrahedron', 10248, *[2091, 1831, 1830, 2441], 1)
    ops.element('FourNodeTetrahedron', 10249, *[1223, 1870, 1235, 1236], 1)
    ops.element('FourNodeTetrahedron', 10250, *[1792, 2296, 2270, 2610], 1)
    ops.element('FourNodeTetrahedron', 10251, *[2469, 2640, 2641, 2390], 1)
    ops.element('FourNodeTetrahedron', 10252, *[2327, 2685, 2296, 2610], 1)
    ops.element('FourNodeTetrahedron', 10253, *[1168, 1753, 1160, 1751], 1)
    ops.element('FourNodeTetrahedron', 10254, *[1962, 2665, 2175, 2232], 1)
    ops.element('FourNodeTetrahedron', 10255, *[2083, 2078, 1132, 2308], 1)
    ops.element('FourNodeTetrahedron', 10256, *[2140, 2269, 1992, 2452], 1)
    ops.element('FourNodeTetrahedron', 10257, *[2424, 1800, 2491, 2025], 1)
    ops.element('FourNodeTetrahedron', 10258, *[2614, 1145, 1254, 1751], 1)
    ops.element('FourNodeTetrahedron', 10259, *[2470, 2641, 2173, 2390], 1)
    ops.element('FourNodeTetrahedron', 10260, *[2533, 2153, 1848, 2626], 1)
    ops.element('FourNodeTetrahedron', 10261, *[1145, 1753, 1168, 1751], 1)
    ops.element('FourNodeTetrahedron', 10262, *[1254, 1751, 1168, 650], 1)
    ops.element('FourNodeTetrahedron', 10263, *[1800, 2331, 2310, 1803], 1)
    ops.element('FourNodeTetrahedron', 10264, *[2093, 1806, 2061, 2186], 1)
    ops.element('FourNodeTetrahedron', 10265, *[2209, 2592, 2226, 2211], 1)
    ops.element('FourNodeTetrahedron', 10266, *[2209, 2592, 2014, 2226], 1)
    ops.element('FourNodeTetrahedron', 10267, *[2209, 1886, 2012, 2592], 1)
    ops.element('FourNodeTetrahedron', 10268, *[2600, 2632, 2409, 2421], 1)
    ops.element('FourNodeTetrahedron', 10269, *[2082, 2549, 2224, 2223], 1)
    ops.element('FourNodeTetrahedron', 10270, *[2266, 2065, 1185, 1942], 1)
    ops.element('FourNodeTetrahedron', 10271, *[2051, 2209, 2227, 2226], 1)
    ops.element('FourNodeTetrahedron', 10272, *[2054, 2057, 2053, 2670], 1)
    ops.element('FourNodeTetrahedron', 10273, *[2332, 2001, 2243, 2385], 1)
    ops.element('FourNodeTetrahedron', 10274, *[1956, 1959, 2227, 2209], 1)
    ops.element('FourNodeTetrahedron', 10275, *[1759, 2066, 2065, 2266], 1)
    ops.element('FourNodeTetrahedron', 10276, *[2209, 2210, 1959, 2211], 1)
    ops.element('FourNodeTetrahedron', 10277, *[1956, 2209, 2051, 2210], 1)
    ops.element('FourNodeTetrahedron', 10278, *[1152, 2556, 1194, 2594], 1)
    ops.element('FourNodeTetrahedron', 10279, *[2227, 1959, 2014, 2209], 1)
    ops.element('FourNodeTetrahedron', 10280, *[2330, 2108, 2089, 2111], 1)
    ops.element('FourNodeTetrahedron', 10281, *[2281, 2499, 2403, 2385], 1)
    ops.element('FourNodeTetrahedron', 10282, *[2118, 2117, 1977, 2656], 1)
    ops.element('FourNodeTetrahedron', 10283, *[1229, 2171, 1222, 1146], 1)
    ops.element('FourNodeTetrahedron', 10284, *[2259, 2119, 650, 666], 1)
    ops.element('FourNodeTetrahedron', 10285, *[1221, 1955, 1952, 1953], 1)
    ops.element('FourNodeTetrahedron', 10286, *[2330, 2089, 2642, 2111], 1)
    ops.element('FourNodeTetrahedron', 10287, *[1792, 1793, 2296, 2609], 1)
    ops.element('FourNodeTetrahedron', 10288, *[2330, 2042, 2372, 2108], 1)
    ops.element('FourNodeTetrahedron', 10289, *[2042, 2372, 2108, 2041], 1)
    ops.element('FourNodeTetrahedron', 10290, *[1755, 1756, 2527, 1966], 1)
    ops.element('FourNodeTetrahedron', 10291, *[1968, 1878, 1966, 2096], 1)
    ops.element('FourNodeTetrahedron', 10292, *[1758, 1968, 1966, 2096], 1)
    ops.element('FourNodeTetrahedron', 10293, *[1756, 1968, 1966, 1758], 1)
    ops.element('FourNodeTetrahedron', 10294, *[1185, 1942, 1943, 1182], 1)
    ops.element('FourNodeTetrahedron', 10295, *[1756, 1967, 1966, 1968], 1)
    ops.element('FourNodeTetrahedron', 10296, *[1755, 2527, 2526, 2536], 1)
    ops.element('FourNodeTetrahedron', 10297, *[2139, 2079, 2379, 2271], 1)
    ops.element('FourNodeTetrahedron', 10298, *[2298, 2049, 2256, 2419], 1)
    ops.element('FourNodeTetrahedron', 10299, *[1755, 1966, 2527, 2536], 1)
    ops.element('FourNodeTetrahedron', 10300, *[1755, 1756, 1966, 1758], 1)
    ops.element('FourNodeTetrahedron', 10301, *[1186, 2268, 2505, 1797], 1)
    ops.element('FourNodeTetrahedron', 10302, *[2186, 2184, 2062, 1872], 1)
    ops.element('FourNodeTetrahedron', 10303, *[2470, 2469, 2641, 2390], 1)
    ops.element('FourNodeTetrahedron', 10304, *[1771, 1958, 2051, 2153], 1)
    ops.element('FourNodeTetrahedron', 10305, *[1771, 1958, 1956, 2051], 1)
    ops.element('FourNodeTetrahedron', 10306, *[1769, 2227, 1768, 1956], 1)
    ops.element('FourNodeTetrahedron', 10307, *[741, 2024, 740, 1192], 1)
    ops.element('FourNodeTetrahedron', 10308, *[2537, 2098, 1149, 2255], 1)
    ops.element('FourNodeTetrahedron', 10309, *[2314, 2029, 2313, 2030], 1)
    ops.element('FourNodeTetrahedron', 10310, *[2524, 2651, 1983, 2044], 1)
    ops.element('FourNodeTetrahedron', 10311, *[2284, 2098, 2537, 2255], 1)
    ops.element('FourNodeTetrahedron', 10312, *[1130, 2537, 1224, 1149], 1)
    ops.element('FourNodeTetrahedron', 10313, *[2380, 2678, 2454, 2657], 1)
    ops.element('FourNodeTetrahedron', 10314, *[2562, 1811, 1255, 2537], 1)
    ops.element('FourNodeTetrahedron', 10315, *[741, 2627, 1192, 1161], 1)
    ops.element('FourNodeTetrahedron', 10316, *[1955, 2383, 2652, 1954], 1)
    ops.element('FourNodeTetrahedron', 10317, *[2057, 2210, 2051, 2053], 1)
    ops.element('FourNodeTetrahedron', 10318, *[2562, 1999, 1811, 2537], 1)
    ops.element('FourNodeTetrahedron', 10319, *[1255, 2537, 1224, 1130], 1)
    ops.element('FourNodeTetrahedron', 10320, *[2562, 2537, 1255, 1130], 1)
    ops.element('FourNodeTetrahedron', 10321, *[1255, 1811, 1141, 1224], 1)
    ops.element('FourNodeTetrahedron', 10322, *[1811, 1999, 2133, 2537], 1)
    ops.element('FourNodeTetrahedron', 10323, *[2537, 2098, 1224, 1149], 1)
    ops.element('FourNodeTetrahedron', 10324, *[1955, 2383, 1954, 2315], 1)
    ops.element('FourNodeTetrahedron', 10325, *[1897, 2346, 1896, 1856], 1)
    ops.element('FourNodeTetrahedron', 10326, *[2151, 2082, 2077, 2224], 1)
    ops.element('FourNodeTetrahedron', 10327, *[2081, 2082, 2077, 2151], 1)
    ops.element('FourNodeTetrahedron', 10328, *[1817, 2650, 2651, 2044], 1)
    ops.element('FourNodeTetrahedron', 10329, *[1955, 2383, 2315, 2381], 1)
    ops.element('FourNodeTetrahedron', 10330, *[1868, 2016, 1869, 1867], 1)
    ops.element('FourNodeTetrahedron', 10331, *[1804, 2428, 1758, 2184], 1)
    ops.element('FourNodeTetrahedron', 10332, *[2511, 1765, 1920, 2509], 1)
    ops.element('FourNodeTetrahedron', 10333, *[2621, 2612, 2356, 2123], 1)
    ops.element('FourNodeTetrahedron', 10334, *[1764, 1986, 2498, 2511], 1)
    ops.element('FourNodeTetrahedron', 10335, *[2081, 2077, 2131, 2075], 1)
    ops.element('FourNodeTetrahedron', 10336, *[2383, 1954, 2315, 2130], 1)
    ops.element('FourNodeTetrahedron', 10337, *[2381, 2383, 2315, 2130], 1)
    ops.element('FourNodeTetrahedron', 10338, *[1226, 1237, 1178, 2359], 1)
    ops.element('FourNodeTetrahedron', 10339, *[2530, 2168, 2422, 2157], 1)
    ops.element('FourNodeTetrahedron', 10340, *[2470, 2677, 2159, 2641], 1)
    ops.element('FourNodeTetrahedron', 10341, *[1141, 2133, 1170, 1224], 1)
    ops.element('FourNodeTetrahedron', 10342, *[1953, 2315, 2298, 2074], 1)
    ops.element('FourNodeTetrahedron', 10343, *[1850, 2609, 2610, 2685], 1)
    ops.element('FourNodeTetrahedron', 10344, *[1953, 1954, 2298, 2315], 1)
    ops.element('FourNodeTetrahedron', 10345, *[2315, 1954, 2298, 2316], 1)
    ops.element('FourNodeTetrahedron', 10346, *[2298, 2049, 2419, 2316], 1)
    ops.element('FourNodeTetrahedron', 10347, *[2428, 1968, 1756, 1758], 1)
    ops.element('FourNodeTetrahedron', 10348, *[1241, 2457, 1759, 1250], 1)
    ops.element('FourNodeTetrahedron', 10349, *[1866, 1760, 1153, 1903], 1)
    ops.element('FourNodeTetrahedron', 10350, *[1954, 2049, 2298, 2316], 1)
    ops.element('FourNodeTetrahedron', 10351, *[1806, 2184, 1758, 2621], 1)
    ops.element('FourNodeTetrahedron', 10352, *[2402, 2538, 1851, 2406], 1)
    ops.element('FourNodeTetrahedron', 10353, *[1234, 2419, 1225, 1180], 1)
    ops.element('FourNodeTetrahedron', 10354, *[1249, 2619, 1238, 1923], 1)
    ops.element('FourNodeTetrahedron', 10355, *[2538, 2240, 2406, 2682], 1)
    ops.element('FourNodeTetrahedron', 10356, *[2111, 2109, 2351, 2110], 1)
    ops.element('FourNodeTetrahedron', 10357, *[514, 2396, 1159, 513], 1)
    ops.element('FourNodeTetrahedron', 10358, *[2396, 2236, 1134, 513], 1)
    ops.element('FourNodeTetrahedron', 10359, *[1922, 1919, 1924, 2378], 1)
    ops.element('FourNodeTetrahedron', 10360, *[2103, 1824, 1890, 2174], 1)
    ops.element('FourNodeTetrahedron', 10361, *[2358, 1981, 2238, 2357], 1)
    ops.element('FourNodeTetrahedron', 10362, *[2082, 2549, 2675, 2224], 1)
    ops.element('FourNodeTetrahedron', 10363, *[2224, 2549, 2675, 2341], 1)
    ops.element('FourNodeTetrahedron', 10364, *[2076, 2003, 2245, 2004], 1)
    ops.element('FourNodeTetrahedron', 10365, *[2174, 2176, 1890, 1901], 1)
    ops.element('FourNodeTetrahedron', 10366, *[2073, 2315, 1953, 2074], 1)
    ops.element('FourNodeTetrahedron', 10367, *[1907, 1906, 2011, 1905], 1)
    ops.element('FourNodeTetrahedron', 10368, *[1955, 1954, 1953, 2315], 1)
    ops.element('FourNodeTetrahedron', 10369, *[1895, 2538, 2402, 2407], 1)
    ops.element('FourNodeTetrahedron', 10370, *[1869, 2020, 2359, 2016], 1)
    ops.element('FourNodeTetrahedron', 10371, *[1177, 2617, 2266, 1137], 1)
    ops.element('FourNodeTetrahedron', 10372, *[2068, 1206, 1136, 1201], 1)
    ops.element('FourNodeTetrahedron', 10373, *[1873, 2550, 2185, 1872], 1)
    ops.element('FourNodeTetrahedron', 10374, *[1870, 1132, 1235, 1244], 1)
    ops.element('FourNodeTetrahedron', 10375, *[2551, 2580, 2468, 2415], 1)
    ops.element('FourNodeTetrahedron', 10376, *[2571, 2114, 1780, 2396], 1)
    ops.element('FourNodeTetrahedron', 10377, *[2567, 1789, 1788, 2566], 1)
    ops.element('FourNodeTetrahedron', 10378, *[1927, 2056, 2055, 2646], 1)
    ops.element('FourNodeTetrahedron', 10379, *[1987, 1909, 1912, 1918], 1)
    ops.element('FourNodeTetrahedron', 10380, *[2144, 1854, 2402, 1895], 1)
    ops.element('FourNodeTetrahedron', 10381, *[2031, 2603, 2645, 2297], 1)
    ops.element('FourNodeTetrahedron', 10382, *[2332, 2533, 2308, 1849], 1)
    ops.element('FourNodeTetrahedron', 10383, *[2538, 2325, 1851, 2406], 1)
    ops.element('FourNodeTetrahedron', 10384, *[2144, 1895, 2402, 2142], 1)
    ops.element('FourNodeTetrahedron', 10385, *[1897, 1895, 2144, 2579], 1)
    ops.element('FourNodeTetrahedron', 10386, *[2108, 2372, 2089, 2373], 1)
    ops.element('FourNodeTetrahedron', 10387, *[2167, 2461, 2165, 2134], 1)
    ops.element('FourNodeTetrahedron', 10388, *[2066, 2460, 1944, 1942], 1)
    ops.element('FourNodeTetrahedron', 10389, *[1897, 1854, 2144, 1895], 1)
    ops.element('FourNodeTetrahedron', 10390, *[1855, 1856, 2407, 2529], 1)
    ops.element('FourNodeTetrahedron', 10391, *[2560, 2502, 2169, 2501], 1)
    ops.element('FourNodeTetrahedron', 10392, *[2379, 2271, 1989, 2269], 1)
    ops.element('FourNodeTetrahedron', 10393, *[2021, 1905, 1171, 1253], 1)
    ops.element('FourNodeTetrahedron', 10394, *[2021, 2669, 1905, 1819], 1)
    ops.element('FourNodeTetrahedron', 10395, *[2433, 2456, 2058, 2112], 1)
    ops.element('FourNodeTetrahedron', 10396, *[2433, 1845, 2058, 2456], 1)
    ops.element('FourNodeTetrahedron', 10397, *[2021, 1905, 1253, 1819], 1)
    ops.element('FourNodeTetrahedron', 10398, *[1198, 2021, 1253, 1819], 1)
    ops.element('FourNodeTetrahedron', 10399, *[2021, 2669, 1198, 1819], 1)
    ops.element('FourNodeTetrahedron', 10400, *[1985, 1983, 1982, 2524], 1)
    ops.element('FourNodeTetrahedron', 10401, *[1952, 2048, 1217, 1218], 1)
    ops.element('FourNodeTetrahedron', 10402, *[2476, 2686, 2185, 2551], 1)
    ops.element('FourNodeTetrahedron', 10403, *[2021, 1907, 1905, 2669], 1)
    ops.element('FourNodeTetrahedron', 10404, *[1952, 2048, 1218, 1953], 1)
    ops.element('FourNodeTetrahedron', 10405, *[1197, 2021, 1142, 1198], 1)
    ops.element('FourNodeTetrahedron', 10406, *[1197, 1778, 2021, 1776], 1)
    ops.element('FourNodeTetrahedron', 10407, *[1197, 2021, 1198, 1776], 1)
    ops.element('FourNodeTetrahedron', 10408, *[1778, 2669, 2021, 1776], 1)
    ops.element('FourNodeTetrahedron', 10409, *[2023, 1907, 2021, 2669], 1)
    ops.element('FourNodeTetrahedron', 10410, *[1142, 2021, 1253, 1198], 1)
    ops.element('FourNodeTetrahedron', 10411, *[1898, 1955, 1221, 1913], 1)
    ops.element('FourNodeTetrahedron', 10412, *[1851, 2325, 1993, 2406], 1)
    ops.element('FourNodeTetrahedron', 10413, *[2351, 2109, 2660, 2681], 1)
    ops.element('FourNodeTetrahedron', 10414, *[2406, 2325, 1993, 2494], 1)
    ops.element('FourNodeTetrahedron', 10415, *[2527, 1967, 2030, 1823], 1)
    ops.element('FourNodeTetrahedron', 10416, *[1215, 1975, 1191, 1859], 1)
    ops.element('FourNodeTetrahedron', 10417, *[1760, 2554, 1153, 1880], 1)
    ops.element('FourNodeTetrahedron', 10418, *[2644, 1814, 2163, 1926], 1)
    ops.element('FourNodeTetrahedron', 10419, *[2287, 2366, 2684, 1901], 1)
    ops.element('FourNodeTetrahedron', 10420, *[2357, 2340, 2214, 2338], 1)
    ops.element('FourNodeTetrahedron', 10421, *[2570, 1747, 2357, 2340], 1)
    ops.element('FourNodeTetrahedron', 10422, *[1859, 1891, 1191, 1232], 1)
    ops.element('FourNodeTetrahedron', 10423, *[2576, 2444, 2292, 2293], 1)
    ops.element('FourNodeTetrahedron', 10424, *[1870, 2071, 1868, 1976], 1)
    ops.element('FourNodeTetrahedron', 10425, *[2325, 2113, 2526, 2493], 1)
    ops.element('FourNodeTetrahedron', 10426, *[2325, 2493, 2526, 2494], 1)
    ops.element('FourNodeTetrahedron', 10427, *[2310, 2026, 2220, 2107], 1)
    ops.element('FourNodeTetrahedron', 10428, *[2107, 2026, 2220, 1935], 1)
    ops.element('FourNodeTetrahedron', 10429, *[2491, 1800, 2310, 2025], 1)
    ops.element('FourNodeTetrahedron', 10430, *[2261, 2491, 2025, 2107], 1)
    ops.element('FourNodeTetrahedron', 10431, *[2476, 2686, 2428, 2185], 1)
    ops.element('FourNodeTetrahedron', 10432, *[2462, 2349, 2348, 2347], 1)
    ops.element('FourNodeTetrahedron', 10433, *[2491, 2310, 1836, 2107], 1)
    ops.element('FourNodeTetrahedron', 10434, *[2261, 2491, 1836, 2107], 1)
    ops.element('FourNodeTetrahedron', 10435, *[2261, 2025, 2107, 2422], 1)
    ops.element('FourNodeTetrahedron', 10436, *[2271, 2296, 2317, 2327], 1)
    ops.element('FourNodeTetrahedron', 10437, *[1177, 2266, 1185, 1137], 1)
    ops.element('FourNodeTetrahedron', 10438, *[2612, 2429, 2123, 2122], 1)
    ops.element('FourNodeTetrahedron', 10439, *[2296, 2341, 2317, 2326], 1)
    ops.element('FourNodeTetrahedron', 10440, *[2266, 1185, 1243, 1177], 1)
    ops.element('FourNodeTetrahedron', 10441, *[2434, 1757, 1755, 2640], 1)
    ops.element('FourNodeTetrahedron', 10442, *[2357, 2340, 2338, 2478], 1)
    ops.element('FourNodeTetrahedron', 10443, *[2329, 2092, 2331, 1801], 1)
    ops.element('FourNodeTetrahedron', 10444, *[1933, 2562, 2120, 2616], 1)
    ops.element('FourNodeTetrahedron', 10445, *[1842, 1903, 1763, 2652], 1)
    ops.element('FourNodeTetrahedron', 10446, *[2051, 2208, 2052, 2053], 1)
    ops.element('FourNodeTetrahedron', 10447, *[2484, 2589, 2541, 1865], 1)
    ops.element('FourNodeTetrahedron', 10448, *[2616, 1933, 2562, 1930], 1)
    ops.element('FourNodeTetrahedron', 10449, *[2616, 1930, 2562, 1860], 1)
    ops.element('FourNodeTetrahedron', 10450, *[1992, 1989, 2152, 1990], 1)
    ops.element('FourNodeTetrahedron', 10451, *[1853, 2616, 1204, 1860], 1)
    ops.element('FourNodeTetrahedron', 10452, *[2409, 1949, 1750, 1202], 1)
    ops.element('FourNodeTetrahedron', 10453, *[2147, 2409, 1202, 2145], 1)
    ops.element('FourNodeTetrahedron', 10454, *[2002, 2001, 2004, 2280], 1)
    ops.element('FourNodeTetrahedron', 10455, *[2409, 1949, 1202, 2145], 1)
    ops.element('FourNodeTetrahedron', 10456, *[1159, 1894, 1780, 2396], 1)
    ops.element('FourNodeTetrahedron', 10457, *[2295, 1894, 2683, 2396], 1)
    ops.element('FourNodeTetrahedron', 10458, *[2322, 1806, 2390, 2093], 1)
    ops.element('FourNodeTetrahedron', 10459, *[2409, 2422, 1949, 2145], 1)
    ops.element('FourNodeTetrahedron', 10460, *[2409, 2107, 1949, 2422], 1)
    ops.element('FourNodeTetrahedron', 10461, *[1798, 1828, 1799, 2149], 1)
    ops.element('FourNodeTetrahedron', 10462, *[1926, 1814, 1884, 2031], 1)
    ops.element('FourNodeTetrahedron', 10463, *[2409, 2107, 1750, 1949], 1)
    ops.element('FourNodeTetrahedron', 10464, *[2049, 2257, 2009, 2256], 1)
    ops.element('FourNodeTetrahedron', 10465, *[1777, 1778, 1776, 2679], 1)
    ops.element('FourNodeTetrahedron', 10466, *[2186, 1872, 2062, 2155], 1)
    ops.element('FourNodeTetrahedron', 10467, *[1750, 2261, 2107, 2409], 1)
    ops.element('FourNodeTetrahedron', 10468, *[2409, 2261, 2107, 2422], 1)
    ops.element('FourNodeTetrahedron', 10469, *[2277, 1807, 2186, 2185], 1)
    ops.element('FourNodeTetrahedron', 10470, *[1871, 2185, 2186, 1872], 1)
    ops.element('FourNodeTetrahedron', 10471, *[2352, 2391, 2304, 1998], 1)
    ops.element('FourNodeTetrahedron', 10472, *[2063, 2241, 2239, 2194], 1)
    ops.element('FourNodeTetrahedron', 10473, *[2148, 2579, 2142, 2404], 1)
    ops.element('FourNodeTetrahedron', 10474, *[2536, 1966, 2097, 2096], 1)
    ops.element('FourNodeTetrahedron', 10475, *[2348, 2350, 2451, 2507], 1)
    ops.element('FourNodeTetrahedron', 10476, *[1830, 1845, 1829, 2058], 1)
    ops.element('FourNodeTetrahedron', 10477, *[1902, 2232, 2176, 1900], 1)
    ops.element('FourNodeTetrahedron', 10478, *[2174, 2175, 2176, 2231], 1)
    ops.element('FourNodeTetrahedron', 10479, *[2601, 2665, 2566, 1962], 1)
    ops.element('FourNodeTetrahedron', 10480, *[2166, 2164, 713, 1157], 1)
    ops.element('FourNodeTetrahedron', 10481, *[2167, 175, 2164, 1157], 1)
    ops.element('FourNodeTetrahedron', 10482, *[1890, 2286, 2287, 2176], 1)
    ops.element('FourNodeTetrahedron', 10483, *[2613, 2674, 2666, 2311], 1)
    ops.element('FourNodeTetrahedron', 10484, *[2166, 167, 713, 2164], 1)
    ops.element('FourNodeTetrahedron', 10485, *[2245, 2001, 2332, 2004], 1)
    ops.element('FourNodeTetrahedron', 10486, *[2123, 2121, 2192, 2124], 1)
    ops.element('FourNodeTetrahedron', 10487, *[2212, 1947, 1946, 1948], 1)
    ops.element('FourNodeTetrahedron', 10488, *[1963, 2601, 1962, 1965], 1)
    ops.element('FourNodeTetrahedron', 10489, *[1860, 1993, 1930, 2307], 1)
    ops.element('FourNodeTetrahedron', 10490, *[2502, 2452, 1992, 2453], 1)
    ops.element('FourNodeTetrahedron', 10491, *[2601, 2566, 2567, 1963], 1)
    ops.element('FourNodeTetrahedron', 10492, *[2283, 2464, 2351, 2435], 1)
    ops.element('FourNodeTetrahedron', 10493, *[1221, 2073, 1256, 1220], 1)
    ops.element('FourNodeTetrahedron', 10494, *[1221, 1953, 1256, 2073], 1)
    ops.element('FourNodeTetrahedron', 10495, *[2073, 2074, 1256, 1223], 1)
    ops.element('FourNodeTetrahedron', 10496, *[2252, 2254, 2249, 1958], 1)
    ops.element('FourNodeTetrahedron', 10497, *[1220, 2073, 1256, 1223], 1)
    ops.element('FourNodeTetrahedron', 10498, *[2358, 2236, 2396, 513], 1)
    ops.element('FourNodeTetrahedron', 10499, *[1992, 2269, 1989, 1991], 1)
    ops.element('FourNodeTetrahedron', 10500, *[2408, 2391, 2260, 2600], 1)
    ops.element('FourNodeTetrahedron', 10501, *[2304, 2394, 2582, 2391], 1)
    ops.element('FourNodeTetrahedron', 10502, *[2113, 1995, 1993, 2526], 1)
    ops.element('FourNodeTetrahedron', 10503, *[2114, 1842, 2449, 1844], 1)
    ops.element('FourNodeTetrahedron', 10504, *[2497, 2529, 2405, 2542], 1)
    ops.element('FourNodeTetrahedron', 10505, *[2456, 2423, 2314, 2030], 1)
    ops.element('FourNodeTetrahedron', 10506, *[2452, 2269, 1991, 2624], 1)
    ops.element('FourNodeTetrahedron', 10507, *[1138, 2412, 1156, 1196], 1)
    ops.element('FourNodeTetrahedron', 10508, *[1836, 1935, 2229, 1949], 1)
    ops.element('FourNodeTetrahedron', 10509, *[2361, 2332, 1849, 2385], 1)
    ops.element('FourNodeTetrahedron', 10510, *[1992, 2269, 1991, 2452], 1)
    ops.element('FourNodeTetrahedron', 10511, *[1943, 2267, 1796, 2015], 1)
    ops.element('FourNodeTetrahedron', 10512, *[2585, 2557, 751, 1882], 1)
    ops.element('FourNodeTetrahedron', 10513, *[2209, 2211, 2226, 2208], 1)
    ops.element('FourNodeTetrahedron', 10514, *[2208, 2211, 2226, 2290], 1)
    ops.element('FourNodeTetrahedron', 10515, *[2053, 2211, 2208, 2290], 1)
    ops.element('FourNodeTetrahedron', 10516, *[2066, 2191, 2065, 1944], 1)
    ops.element('FourNodeTetrahedron', 10517, *[2065, 2191, 1797, 1944], 1)
    ops.element('FourNodeTetrahedron', 10518, *[1122, 2191, 1797, 2065], 1)
    ops.element('FourNodeTetrahedron', 10519, *[2065, 1183, 1122, 1185], 1)
    ops.element('FourNodeTetrahedron', 10520, *[1968, 2580, 2273, 2468], 1)
    ops.element('FourNodeTetrahedron', 10521, *[1841, 1960, 1984, 2398], 1)
    ops.element('FourNodeTetrahedron', 10522, *[1841, 1984, 2399, 2398], 1)
    ops.element('FourNodeTetrahedron', 10523, *[2273, 2414, 1963, 1964], 1)
    ops.element('FourNodeTetrahedron', 10524, *[2065, 1797, 1122, 1183], 1)
    ops.element('FourNodeTetrahedron', 10525, *[1185, 2065, 1943, 1942], 1)
    ops.element('FourNodeTetrahedron', 10526, *[2465, 2196, 2215, 2195], 1)
    ops.element('FourNodeTetrahedron', 10527, *[2359, 2395, 1125, 2078], 1)
    ops.element('FourNodeTetrahedron', 10528, *[2592, 1886, 2512, 2347], 1)
    ops.element('FourNodeTetrahedron', 10529, *[2065, 1797, 1183, 1943], 1)
    ops.element('FourNodeTetrahedron', 10530, *[1767, 1766, 1782, 1764], 1)
    ops.element('FourNodeTetrahedron', 10531, *[1759, 2065, 1243, 2266], 1)
    ops.element('FourNodeTetrahedron', 10532, *[1166, 2065, 1122, 1243], 1)
    ops.element('FourNodeTetrahedron', 10533, *[1759, 2065, 1166, 1243], 1)
    ops.element('FourNodeTetrahedron', 10534, *[1759, 2443, 1166, 2065], 1)
    ops.element('FourNodeTetrahedron', 10535, *[1166, 2443, 1122, 2065], 1)
    ops.element('FourNodeTetrahedron', 10536, *[1142, 2299, 1171, 2021], 1)
    ops.element('FourNodeTetrahedron', 10537, *[1759, 2067, 2443, 2065], 1)
    ops.element('FourNodeTetrahedron', 10538, *[2443, 2067, 2191, 2065], 1)
    ops.element('FourNodeTetrahedron', 10539, *[2443, 2191, 1122, 2065], 1)
    ops.element('FourNodeTetrahedron', 10540, *[2067, 2191, 2065, 2066], 1)
    ops.element('FourNodeTetrahedron', 10541, *[2407, 2538, 2406, 2682], 1)
    ops.element('FourNodeTetrahedron', 10542, *[2581, 2601, 2567, 1963], 1)
    ops.element('FourNodeTetrahedron', 10543, *[1849, 2385, 2533, 1848], 1)
    ops.element('FourNodeTetrahedron', 10544, *[2026, 2482, 2220, 1934], 1)
    ops.element('FourNodeTetrahedron', 10545, *[2481, 2249, 2480, 2252], 1)
    ops.element('FourNodeTetrahedron', 10546, *[1823, 1877, 1788, 1875], 1)
    ops.element('FourNodeTetrahedron', 10547, *[1172, 2598, 1249, 532], 1)
    ops.element('FourNodeTetrahedron', 10548, *[1172, 1892, 1249, 2598], 1)
    ops.element('FourNodeTetrahedron', 10549, *[2202, 2370, 2598, 538], 1)
    ops.element('FourNodeTetrahedron', 10550, *[2030, 1823, 1824, 2103], 1)
    ops.element('FourNodeTetrahedron', 10551, *[2346, 1805, 2470, 2390], 1)
    ops.element('FourNodeTetrahedron', 10552, *[2298, 2009, 1164, 2256], 1)
    ops.element('FourNodeTetrahedron', 10553, *[2341, 2549, 1793, 2296], 1)
    ops.element('FourNodeTetrahedron', 10554, *[1879, 2046, 1163, 2635], 1)
    ops.element('FourNodeTetrahedron', 10555, *[1792, 2609, 2610, 1795], 1)
    ops.element('FourNodeTetrahedron', 10556, *[1149, 2250, 177, 178], 1)
    ops.element('FourNodeTetrahedron', 10557, *[2369, 2362, 1977, 2656], 1)
    ops.element('FourNodeTetrahedron', 10558, *[2202, 2598, 551, 538], 1)
    ops.element('FourNodeTetrahedron', 10559, *[551, 2598, 1172, 538], 1)
    ops.element('FourNodeTetrahedron', 10560, *[1881, 2045, 1808, 2046], 1)
    ops.element('FourNodeTetrahedron', 10561, *[2598, 2523, 532, 538], 1)
    ops.element('FourNodeTetrahedron', 10562, *[1890, 1901, 1862, 2634], 1)
    ops.element('FourNodeTetrahedron', 10563, *[2368, 2118, 666, 684], 1)
    ops.element('FourNodeTetrahedron', 10564, *[1172, 2598, 532, 538], 1)
    ops.element('FourNodeTetrahedron', 10565, *[2682, 2240, 2242, 2239], 1)
    ops.element('FourNodeTetrahedron', 10566, *[2544, 2240, 2682, 2239], 1)
    ops.element('FourNodeTetrahedron', 10567, *[1992, 2379, 2151, 1989], 1)
    ops.element('FourNodeTetrahedron', 10568, *[2680, 2345, 1856, 1857], 1)
    ops.element('FourNodeTetrahedron', 10569, *[2682, 2239, 2242, 2492], 1)
    ops.element('FourNodeTetrahedron', 10570, *[2544, 2239, 2682, 2492], 1)
    ops.element('FourNodeTetrahedron', 10571, *[2631, 2129, 2072, 2420], 1)
    ops.element('FourNodeTetrahedron', 10572, *[2055, 2297, 2645, 2038], 1)
    ops.element('FourNodeTetrahedron', 10573, *[2609, 1793, 2296, 2685], 1)
    ops.element('FourNodeTetrahedron', 10574, *[1979, 1941, 2114, 2358], 1)
    ops.element('FourNodeTetrahedron', 10575, *[2054, 1883, 2234, 2052], 1)
    ops.element('FourNodeTetrahedron', 10576, *[2037, 1749, 1746, 1747], 1)
    ops.element('FourNodeTetrahedron', 10577, *[2037, 2036, 1749, 1747], 1)
    ops.element('FourNodeTetrahedron', 10578, *[2611, 1964, 2661, 2569], 1)
    ops.element('FourNodeTetrahedron', 10579, *[1889, 1765, 2264, 1886], 1)
    ops.element('FourNodeTetrahedron', 10580, *[2574, 2636, 2292, 2444], 1)
    ops.element('FourNodeTetrahedron', 10581, *[2264, 1765, 2512, 1886], 1)
    ops.element('FourNodeTetrahedron', 10582, *[2013, 2512, 2349, 2592], 1)
    ops.element('FourNodeTetrahedron', 10583, *[2013, 2264, 2349, 2512], 1)
    ops.element('FourNodeTetrahedron', 10584, *[2013, 2264, 2512, 1886], 1)
    ops.element('FourNodeTetrahedron', 10585, *[2318, 2002, 2426, 2280], 1)
    ops.element('FourNodeTetrahedron', 10586, *[2301, 1857, 2498, 2300], 1)
    ops.element('FourNodeTetrahedron', 10587, *[2301, 2095, 1857, 2300], 1)
    ops.element('FourNodeTetrahedron', 10588, *[2300, 2544, 1858, 2488], 1)
    ops.element('FourNodeTetrahedron', 10589, *[2012, 2264, 2013, 1886], 1)
    ops.element('FourNodeTetrahedron', 10590, *[2012, 1886, 2013, 2592], 1)
    ops.element('FourNodeTetrahedron', 10591, *[2013, 1886, 2512, 2592], 1)
    ops.element('FourNodeTetrahedron', 10592, *[1254, 1168, 1145, 1751], 1)
    ops.element('FourNodeTetrahedron', 10593, *[1780, 2521, 1762, 2114], 1)
    ops.element('FourNodeTetrahedron', 10594, *[2258, 2457, 1178, 2359], 1)
    ops.element('FourNodeTetrahedron', 10595, *[2258, 2638, 2457, 2359], 1)
    ops.element('FourNodeTetrahedron', 10596, *[2359, 2638, 2457, 2563], 1)
    ops.element('FourNodeTetrahedron', 10597, *[2359, 2457, 1178, 1177], 1)
    ops.element('FourNodeTetrahedron', 10598, *[1829, 2059, 2464, 1994], 1)
    ops.element('FourNodeTetrahedron', 10599, *[1938, 1939, 2114, 1941], 1)
    ops.element('FourNodeTetrahedron', 10600, *[2359, 1177, 1178, 1125], 1)
    ops.element('FourNodeTetrahedron', 10601, *[2113, 2285, 1993, 1995], 1)
    ops.element('FourNodeTetrahedron', 10602, *[2359, 2457, 1177, 2563], 1)
    ops.element('FourNodeTetrahedron', 10603, *[2608, 2458, 2442, 2457], 1)
    ops.element('FourNodeTetrahedron', 10604, *[1125, 2395, 2563, 1176], 1)
    ops.element('FourNodeTetrahedron', 10605, *[2258, 2608, 2595, 2457], 1)
    ops.element('FourNodeTetrahedron', 10606, *[2258, 2608, 2457, 2638], 1)
    ops.element('FourNodeTetrahedron', 10607, *[2457, 2266, 1177, 2563], 1)
    ops.element('FourNodeTetrahedron', 10608, *[2567, 1788, 1877, 1875], 1)
    ops.element('FourNodeTetrahedron', 10609, *[2079, 2519, 2223, 2139], 1)
    ops.element('FourNodeTetrahedron', 10610, *[1788, 1789, 1790, 2566], 1)
    ops.element('FourNodeTetrahedron', 10611, *[2070, 1151, 1136, 2408], 1)
    ops.element('FourNodeTetrahedron', 10612, *[1178, 2457, 1250, 1177], 1)
    ops.element('FourNodeTetrahedron', 10613, *[2563, 2617, 1177, 1176], 1)
    ops.element('FourNodeTetrahedron', 10614, *[1972, 2324, 1748, 2079], 1)
    ops.element('FourNodeTetrahedron', 10615, *[2080, 2081, 2151, 2079], 1)
    ops.element('FourNodeTetrahedron', 10616, *[1176, 2321, 2617, 1175], 1)
    ops.element('FourNodeTetrahedron', 10617, *[1183, 1796, 1131, 1182], 1)
    ops.element('FourNodeTetrahedron', 10618, *[2321, 2154, 2617, 1175], 1)
    ops.element('FourNodeTetrahedron', 10619, *[1796, 1937, 1184, 1195], 1)
    ops.element('FourNodeTetrahedron', 10620, *[2147, 2422, 2409, 2145], 1)
    ops.element('FourNodeTetrahedron', 10621, *[1891, 2306, 2215, 2483], 1)
    ops.element('FourNodeTetrahedron', 10622, *[1820, 2320, 1821, 1818], 1)
    ops.element('FourNodeTetrahedron', 10623, *[2539, 2541, 2465, 2484], 1)
    ops.element('FourNodeTetrahedron', 10624, *[2395, 2617, 1176, 2321], 1)
    ops.element('FourNodeTetrahedron', 10625, *[2395, 2563, 2617, 1176], 1)
    ops.element('FourNodeTetrahedron', 10626, *[2338, 2140, 2413, 2502], 1)
    ops.element('FourNodeTetrahedron', 10627, *[1800, 1803, 2026, 2027], 1)
    ops.element('FourNodeTetrahedron', 10628, *[1845, 1846, 1829, 2059], 1)
    ops.element('FourNodeTetrahedron', 10629, *[2465, 2199, 2197, 2195], 1)
    ops.element('FourNodeTetrahedron', 10630, *[2344, 1794, 2223, 1792], 1)
    ops.element('FourNodeTetrahedron', 10631, *[2395, 2563, 2617, 2248], 1)
    ops.element('FourNodeTetrahedron', 10632, *[2395, 2248, 2617, 2321], 1)
    ops.element('FourNodeTetrahedron', 10633, *[2617, 1771, 2154, 2321], 1)
    ops.element('FourNodeTetrahedron', 10634, *[2328, 2042, 2039, 2092], 1)
    ops.element('FourNodeTetrahedron', 10635, *[2321, 1771, 2154, 2153], 1)
    ops.element('FourNodeTetrahedron', 10636, *[1994, 2059, 2375, 2102], 1)
    ops.element('FourNodeTetrahedron', 10637, *[2283, 2464, 2435, 2375], 1)
    ops.element('FourNodeTetrahedron', 10638, *[2283, 2464, 2375, 1994], 1)
    ops.element('FourNodeTetrahedron', 10639, *[2248, 1771, 2617, 2321], 1)
    ops.element('FourNodeTetrahedron', 10640, *[2563, 1771, 2617, 2248], 1)
    ops.element('FourNodeTetrahedron', 10641, *[2224, 2296, 2341, 2317], 1)
    ops.element('FourNodeTetrahedron', 10642, *[1989, 2224, 2002, 2317], 1)
    ops.element('FourNodeTetrahedron', 10643, *[2340, 2339, 2338, 2647], 1)
    ops.element('FourNodeTetrahedron', 10644, *[2597, 2342, 2519, 1971], 1)
    ops.element('FourNodeTetrahedron', 10645, *[1970, 2597, 1972, 1971], 1)
    ops.element('FourNodeTetrahedron', 10646, *[1969, 1972, 2139, 1971], 1)
    ops.element('FourNodeTetrahedron', 10647, *[1970, 1971, 2138, 2387], 1)
    ops.element('FourNodeTetrahedron', 10648, *[1910, 2212, 1908, 2207], 1)
    ops.element('FourNodeTetrahedron', 10649, *[1911, 2322, 1912, 1908], 1)
    ops.element('FourNodeTetrahedron', 10650, *[1198, 1819, 1128, 2622], 1)
    ops.element('FourNodeTetrahedron', 10651, *[1971, 2139, 2624, 2343], 1)
    ops.element('FourNodeTetrahedron', 10652, *[1182, 1943, 2556, 2225], 1)
    ops.element('FourNodeTetrahedron', 10653, *[2386, 2343, 1971, 2387], 1)
    ops.element('FourNodeTetrahedron', 10654, *[2597, 2342, 1971, 2386], 1)
    ops.element('FourNodeTetrahedron', 10655, *[1875, 2566, 1790, 2175], 1)
    ops.element('FourNodeTetrahedron', 10656, *[2002, 2675, 2432, 2279], 1)
    ops.element('FourNodeTetrahedron', 10657, *[1184, 2143, 1240, 1937], 1)
    ops.element('FourNodeTetrahedron', 10658, *[2675, 2432, 2003, 2002], 1)
    ops.element('FourNodeTetrahedron', 10659, *[1970, 1971, 2387, 2386], 1)
    ops.element('FourNodeTetrahedron', 10660, *[1970, 2597, 1971, 2386], 1)
    ops.element('FourNodeTetrahedron', 10661, *[2597, 2519, 1972, 1971], 1)
    ops.element('FourNodeTetrahedron', 10662, *[2203, 2010, 2467, 2370], 1)
    ops.element('FourNodeTetrahedron', 10663, *[2203, 2007, 2467, 2010], 1)
    ops.element('FourNodeTetrahedron', 10664, *[2202, 2007, 2467, 2203], 1)
    ops.element('FourNodeTetrahedron', 10665, *[2358, 1844, 2237, 1981], 1)
    ops.element('FourNodeTetrahedron', 10666, *[1809, 2134, 1170, 2133], 1)
    ops.element('FourNodeTetrahedron', 10667, *[2202, 2467, 2598, 2370], 1)
    ops.element('FourNodeTetrahedron', 10668, *[2467, 2010, 2370, 2523], 1)
    ops.element('FourNodeTetrahedron', 10669, *[2467, 2523, 2598, 2370], 1)
    ops.element('FourNodeTetrahedron', 10670, *[2467, 2010, 1892, 2523], 1)
    ops.element('FourNodeTetrahedron', 10671, *[2467, 1892, 2598, 2523], 1)
    ops.element('FourNodeTetrahedron', 10672, *[1882, 1808, 751, 1162], 1)
    ops.element('FourNodeTetrahedron', 10673, *[751, 2557, 752, 1808], 1)
    ops.element('FourNodeTetrahedron', 10674, *[751, 2557, 1808, 1882], 1)
    ops.element('FourNodeTetrahedron', 10675, *[2143, 2148, 2144, 2142], 1)
    ops.element('FourNodeTetrahedron', 10676, *[2000, 2135, 1811, 1999], 1)
    ops.element('FourNodeTetrahedron', 10677, *[2424, 2673, 2615, 1800], 1)
    ops.element('FourNodeTetrahedron', 10678, *[2468, 2415, 2273, 2416], 1)
    ops.element('FourNodeTetrahedron', 10679, *[1928, 1926, 1784, 1929], 1)
    ops.element('FourNodeTetrahedron', 10680, *[2585, 2557, 1882, 1881], 1)
    ops.element('FourNodeTetrahedron', 10681, *[2089, 2373, 2087, 2088], 1)
    ops.element('FourNodeTetrahedron', 10682, *[1781, 1898, 1258, 1246], 1)
    ops.element('FourNodeTetrahedron', 10683, *[1248, 2359, 1125, 2078], 1)
    ops.element('FourNodeTetrahedron', 10684, *[2403, 2274, 2243, 2626], 1)
    ops.element('FourNodeTetrahedron', 10685, *[2617, 1942, 1137, 2225], 1)
    ops.element('FourNodeTetrahedron', 10686, *[2264, 1767, 1764, 1765], 1)
    ops.element('FourNodeTetrahedron', 10687, *[2214, 1746, 2532, 2213], 1)
    ops.element('FourNodeTetrahedron', 10688, *[2532, 1748, 2080, 2213], 1)
    ops.element('FourNodeTetrahedron', 10689, *[2529, 2388, 2682, 2544], 1)
    ops.element('FourNodeTetrahedron', 10690, *[1825, 1826, 2147, 2144], 1)
    ops.element('FourNodeTetrahedron', 10691, *[2077, 2675, 2003, 2002], 1)
    ops.element('FourNodeTetrahedron', 10692, *[1869, 1237, 1180, 1248], 1)
    ops.element('FourNodeTetrahedron', 10693, *[1256, 1953, 1121, 2074], 1)
    ops.element('FourNodeTetrahedron', 10694, *[1796, 1798, 1937, 2015], 1)
    ops.element('FourNodeTetrahedron', 10695, *[2267, 1798, 1796, 2015], 1)
    ops.element('FourNodeTetrahedron', 10696, *[2557, 2473, 752, 1808], 1)
    ops.element('FourNodeTetrahedron', 10697, *[2214, 2413, 2596, 2338], 1)
    ops.element('FourNodeTetrahedron', 10698, *[1797, 2267, 1796, 1943], 1)
    ops.element('FourNodeTetrahedron', 10699, *[1183, 1797, 1796, 1943], 1)
    ops.element('FourNodeTetrahedron', 10700, *[1190, 2216, 146, 2064], 1)
    ops.element('FourNodeTetrahedron', 10701, *[2544, 2239, 2492, 2466], 1)
    ops.element('FourNodeTetrahedron', 10702, *[2158, 2125, 2027, 2128], 1)
    ops.element('FourNodeTetrahedron', 10703, *[2413, 2214, 1969, 2338], 1)
    ops.element('FourNodeTetrahedron', 10704, *[2214, 2080, 2596, 2413], 1)
    ops.element('FourNodeTetrahedron', 10705, *[2214, 2080, 2413, 1969], 1)
    ops.element('FourNodeTetrahedron', 10706, *[1969, 2080, 2413, 2140], 1)
    ops.element('FourNodeTetrahedron', 10707, *[2338, 1969, 2413, 2140], 1)
    ops.element('FourNodeTetrahedron', 10708, *[1866, 1903, 1153, 1129], 1)
    ops.element('FourNodeTetrahedron', 10709, *[1153, 1903, 1880, 1217], 1)
    ops.element('FourNodeTetrahedron', 10710, *[1952, 1903, 1217, 2048], 1)
    ops.element('FourNodeTetrahedron', 10711, *[1903, 1880, 1217, 2048], 1)
    ops.element('FourNodeTetrahedron', 10712, *[1952, 2652, 1903, 1954], 1)
    ops.element('FourNodeTetrahedron', 10713, *[1903, 1879, 1880, 2048], 1)
    ops.element('FourNodeTetrahedron', 10714, *[1903, 1904, 1881, 2050], 1)
    ops.element('FourNodeTetrahedron', 10715, *[1903, 2050, 1879, 2048], 1)
    ops.element('FourNodeTetrahedron', 10716, *[1880, 1881, 1879, 1903], 1)
    ops.element('FourNodeTetrahedron', 10717, *[1948, 2186, 2093, 2155], 1)
    ops.element('FourNodeTetrahedron', 10718, *[2093, 2061, 2094, 2060], 1)
    ops.element('FourNodeTetrahedron', 10719, *[1918, 1912, 2094, 2093], 1)
    ops.element('FourNodeTetrahedron', 10720, *[2093, 2186, 2061, 2155], 1)
    ops.element('FourNodeTetrahedron', 10721, *[2095, 2093, 2094, 2060], 1)
    ops.element('FourNodeTetrahedron', 10722, *[2093, 2061, 2060, 2155], 1)
    ops.element('FourNodeTetrahedron', 10723, *[2095, 2093, 2060, 2155], 1)
    ops.element('FourNodeTetrahedron', 10724, *[2046, 2045, 2475, 2504], 1)
    ops.element('FourNodeTetrahedron', 10725, *[2579, 1855, 2496, 2513], 1)
    ops.element('FourNodeTetrahedron', 10726, *[2045, 2179, 2047, 2475], 1)
    ops.element('FourNodeTetrahedron', 10727, *[2513, 1855, 2496, 2498], 1)
    ops.element('FourNodeTetrahedron', 10728, *[1911, 2575, 2393, 1946], 1)
    ops.element('FourNodeTetrahedron', 10729, *[2178, 2179, 1779, 2475], 1)
    ops.element('FourNodeTetrahedron', 10730, *[1821, 2070, 1174, 1200], 1)
    ops.element('FourNodeTetrahedron', 10731, *[2475, 2106, 1133, 2442], 1)
    ops.element('FourNodeTetrahedron', 10732, *[2475, 1133, 1245, 2442], 1)
    ops.element('FourNodeTetrahedron', 10733, *[2368, 2369, 2118, 2653], 1)
    ops.element('FourNodeTetrahedron', 10734, *[2175, 2366, 2289, 2176], 1)
    ops.element('FourNodeTetrahedron', 10735, *[2529, 2682, 2542, 2488], 1)
    ops.element('FourNodeTetrahedron', 10736, *[2309, 2100, 2116, 2484], 1)
    ops.element('FourNodeTetrahedron', 10737, *[2299, 1905, 1171, 2021], 1)
    ops.element('FourNodeTetrahedron', 10738, *[1165, 2475, 1245, 2275], 1)
    ops.element('FourNodeTetrahedron', 10739, *[2355, 2654, 2394, 2392], 1)
    ops.element('FourNodeTetrahedron', 10740, *[2402, 2406, 1861, 2405], 1)
    ops.element('FourNodeTetrahedron', 10741, *[1210, 2568, 1228, 1810], 1)
    ops.element('FourNodeTetrahedron', 10742, *[2275, 2475, 1245, 2442], 1)
    ops.element('FourNodeTetrahedron', 10743, *[2046, 2475, 1165, 2275], 1)
    ops.element('FourNodeTetrahedron', 10744, *[2504, 2106, 2475, 2275], 1)
    ops.element('FourNodeTetrahedron', 10745, *[2275, 2106, 2475, 2442], 1)
    ops.element('FourNodeTetrahedron', 10746, *[1165, 2475, 1133, 1245], 1)
    ops.element('FourNodeTetrahedron', 10747, *[1193, 2475, 1133, 1165], 1)
    ops.element('FourNodeTetrahedron', 10748, *[1855, 1856, 2529, 1858], 1)
    ops.element('FourNodeTetrahedron', 10749, *[1764, 1783, 2579, 1855], 1)
    ops.element('FourNodeTetrahedron', 10750, *[2599, 2678, 2454, 2380], 1)
    ops.element('FourNodeTetrahedron', 10751, *[2263, 1783, 2579, 1764], 1)
    ops.element('FourNodeTetrahedron', 10752, *[2464, 2376, 2681, 2375], 1)
    ops.element('FourNodeTetrahedron', 10753, *[1949, 2616, 1208, 1853], 1)
    ops.element('FourNodeTetrahedron', 10754, *[1987, 2446, 2345, 1918], 1)
    ops.element('FourNodeTetrahedron', 10755, *[1987, 1911, 2446, 1912], 1)
    ops.element('FourNodeTetrahedron', 10756, *[1852, 1933, 2120, 2616], 1)
    ops.element('FourNodeTetrahedron', 10757, *[1853, 1852, 2616, 1851], 1)
    ops.element('FourNodeTetrahedron', 10758, *[1167, 2614, 1254, 666], 1)
    ops.element('FourNodeTetrahedron', 10759, *[1764, 2498, 2513, 2511], 1)
    ops.element('FourNodeTetrahedron', 10760, *[2599, 2454, 2305, 2380], 1)
    ops.element('FourNodeTetrahedron', 10761, *[2678, 2353, 2305, 2454], 1)
    ops.element('FourNodeTetrahedron', 10762, *[2678, 2353, 2454, 2657], 1)
    ops.element('FourNodeTetrahedron', 10763, *[1212, 2308, 1148, 1847], 1)
    ops.element('FourNodeTetrahedron', 10764, *[1895, 2407, 2528, 2496], 1)
    ops.element('FourNodeTetrahedron', 10765, *[2614, 1751, 1254, 2259], 1)
    ops.element('FourNodeTetrahedron', 10766, *[1847, 1848, 632, 653], 1)
    ops.element('FourNodeTetrahedron', 10767, *[653, 1847, 1148, 632], 1)
    ops.element('FourNodeTetrahedron', 10768, *[1148, 1847, 1175, 632], 1)
    ops.element('FourNodeTetrahedron', 10769, *[1148, 2321, 1175, 1847], 1)
    ops.element('FourNodeTetrahedron', 10770, *[1847, 1848, 2321, 2234], 1)
    ops.element('FourNodeTetrahedron', 10771, *[1847, 2321, 1175, 2234], 1)
    ops.element('FourNodeTetrahedron', 10772, *[1847, 1848, 2234, 632], 1)
    ops.element('FourNodeTetrahedron', 10773, *[1847, 2234, 1175, 632], 1)
    ops.element('FourNodeTetrahedron', 10774, *[632, 2234, 1175, 633], 1)
    ops.element('FourNodeTetrahedron', 10775, *[666, 2614, 2259, 2119], 1)
    ops.element('FourNodeTetrahedron', 10776, *[2617, 1942, 2266, 1137], 1)
    ops.element('FourNodeTetrahedron', 10777, *[1975, 1973, 2306, 1891], 1)
    ops.element('FourNodeTetrahedron', 10778, *[1859, 1973, 1975, 1891], 1)
    ops.element('FourNodeTetrahedron', 10779, *[1835, 2228, 1147, 2229], 1)
    ops.element('FourNodeTetrahedron', 10780, *[1823, 1790, 1824, 2174], 1)
    ops.element('FourNodeTetrahedron', 10781, *[1884, 2524, 2663, 1941], 1)
    ops.element('FourNodeTetrahedron', 10782, *[1979, 2114, 2396, 2358], 1)
    ops.element('FourNodeTetrahedron', 10783, *[2306, 2484, 2465, 2483], 1)
    ops.element('FourNodeTetrahedron', 10784, *[1157, 2134, 176, 1170], 1)
    ops.element('FourNodeTetrahedron', 10785, *[1891, 2306, 2255, 2215], 1)
    ops.element('FourNodeTetrahedron', 10786, *[1170, 2134, 176, 2099], 1)
    ops.element('FourNodeTetrahedron', 10787, *[2059, 2376, 2375, 2102], 1)
    ops.element('FourNodeTetrahedron', 10788, *[2122, 2661, 2430, 1839], 1)
    ops.element('FourNodeTetrahedron', 10789, *[2263, 2148, 2143, 2404], 1)
    ops.element('FourNodeTetrahedron', 10790, *[1878, 1876, 1875, 2273], 1)
    ops.element('FourNodeTetrahedron', 10791, *[1890, 1863, 1862, 1901], 1)
    ops.element('FourNodeTetrahedron', 10792, *[2306, 2539, 2255, 2465], 1)
    ops.element('FourNodeTetrahedron', 10793, *[1189, 1825, 1201, 1227], 1)
    ops.element('FourNodeTetrahedron', 10794, *[1762, 1763, 1760, 1866], 1)
    ops.element('FourNodeTetrahedron', 10795, *[2306, 2539, 2465, 2484], 1)
    ops.element('FourNodeTetrahedron', 10796, *[1975, 2284, 2255, 2306], 1)
    ops.element('FourNodeTetrahedron', 10797, *[1996, 2539, 2284, 2306], 1)
    ops.element('FourNodeTetrahedron', 10798, *[2390, 2469, 2640, 1806], 1)
    ops.element('FourNodeTetrahedron', 10799, *[2663, 2524, 1961, 1941], 1)
    ops.element('FourNodeTetrahedron', 10800, *[2628, 2649, 2613, 2615], 1)
    ops.element('FourNodeTetrahedron', 10801, *[1893, 2607, 747, 1988], 1)
    ops.element('FourNodeTetrahedron', 10802, *[759, 1893, 747, 1239], 1)
    ops.element('FourNodeTetrahedron', 10803, *[2140, 2139, 2269, 2624], 1)
    ops.element('FourNodeTetrahedron', 10804, *[2015, 1937, 1796, 2013], 1)
    ops.element('FourNodeTetrahedron', 10805, *[2590, 2502, 2501, 2508], 1)
    ops.element('FourNodeTetrahedron', 10806, *[2596, 2080, 2531, 2413], 1)
    ops.element('FourNodeTetrahedron', 10807, *[2560, 2413, 2577, 2502], 1)
    ops.element('FourNodeTetrahedron', 10808, *[1824, 1791, 2367, 1790], 1)
    ops.element('FourNodeTetrahedron', 10809, *[759, 2607, 747, 1893], 1)
    ops.element('FourNodeTetrahedron', 10810, *[1903, 2050, 2048, 1954], 1)
    ops.element('FourNodeTetrahedron', 10811, *[2416, 1964, 2430, 2611], 1)
    ops.element('FourNodeTetrahedron', 10812, *[2343, 2342, 2344, 2587], 1)
    ops.element('FourNodeTetrahedron', 10813, *[1916, 1914, 1915, 2606], 1)
    ops.element('FourNodeTetrahedron', 10814, *[2158, 2125, 2168, 2160], 1)
    ops.element('FourNodeTetrahedron', 10815, *[2064, 2217, 2643, 2218], 1)
    ops.element('FourNodeTetrahedron', 10816, *[2465, 2541, 2197, 2199], 1)
    ops.element('FourNodeTetrahedron', 10817, *[1814, 1812, 1817, 1885], 1)
    ops.element('FourNodeTetrahedron', 10818, *[2161, 2141, 2651, 1817], 1)
    ops.element('FourNodeTetrahedron', 10819, *[1812, 2650, 2141, 1817], 1)
    ops.element('FourNodeTetrahedron', 10820, *[1817, 1812, 2650, 1885], 1)
    ops.element('FourNodeTetrahedron', 10821, *[1814, 1812, 1816, 1885], 1)
    ops.element('FourNodeTetrahedron', 10822, *[1985, 1982, 2472, 1961], 1)
    ops.element('FourNodeTetrahedron', 10823, *[2472, 1982, 1841, 1961], 1)
    ops.element('FourNodeTetrahedron', 10824, *[1961, 2524, 1982, 1960], 1)
    ops.element('FourNodeTetrahedron', 10825, *[2524, 1982, 1985, 1961], 1)
    ops.element('FourNodeTetrahedron', 10826, *[2018, 2515, 2132, 2003], 1)
    ops.element('FourNodeTetrahedron', 10827, *[2515, 2003, 2018, 2245], 1)
    ops.element('FourNodeTetrahedron', 10828, *[2083, 2308, 1132, 1212], 1)
    ops.element('FourNodeTetrahedron', 10829, *[1966, 1878, 1823, 2097], 1)
    ops.element('FourNodeTetrahedron', 10830, *[2583, 2377, 1920, 2510], 1)
    ops.element('FourNodeTetrahedron', 10831, *[1253, 1819, 1905, 1230], 1)
    ops.element('FourNodeTetrahedron', 10832, *[2182, 2230, 2228, 1835], 1)
    ops.element('FourNodeTetrahedron', 10833, *[2309, 2539, 2306, 2484], 1)
    ops.element('FourNodeTetrahedron', 10834, *[1253, 1905, 1144, 1230], 1)
    ops.element('FourNodeTetrahedron', 10835, *[2421, 2632, 2409, 2422], 1)
    ops.element('FourNodeTetrahedron', 10836, *[2559, 2170, 2573, 2653], 1)
    ops.element('FourNodeTetrahedron', 10837, *[1790, 1789, 2289, 2175], 1)
    ops.element('FourNodeTetrahedron', 10838, *[2416, 2565, 2612, 2430], 1)
    ops.element('FourNodeTetrahedron', 10839, *[2167, 2660, 2461, 2134], 1)
    ops.element('FourNodeTetrahedron', 10840, *[1799, 1825, 1227, 2143], 1)
    ops.element('FourNodeTetrahedron', 10841, *[2255, 2539, 2098, 2465], 1)
    ops.element('FourNodeTetrahedron', 10842, *[2229, 1810, 1210, 2120], 1)
    ops.element('FourNodeTetrahedron', 10843, *[2003, 2244, 2018, 2245], 1)
    ops.element('FourNodeTetrahedron', 10844, *[2318, 2280, 2426, 2360], 1)
    ops.element('FourNodeTetrahedron', 10845, *[1129, 1952, 1218, 1221], 1)
    ops.element('FourNodeTetrahedron', 10846, *[2133, 2099, 1170, 2098], 1)
    ops.element('FourNodeTetrahedron', 10847, *[2511, 1986, 2498, 2301], 1)
    ops.element('FourNodeTetrahedron', 10848, *[2525, 2150, 2420, 2362], 1)
    ops.element('FourNodeTetrahedron', 10849, *[2117, 2004, 1754, 2361], 1)
    ops.element('FourNodeTetrahedron', 10850, *[2511, 2301, 2498, 2350], 1)
    ops.element('FourNodeTetrahedron', 10851, *[2509, 2511, 2350, 2605], 1)
    ops.element('FourNodeTetrahedron', 10852, *[2511, 2301, 2350, 2605], 1)
    ops.element('FourNodeTetrahedron', 10853, *[2509, 2301, 2511, 2605], 1)
    ops.element('FourNodeTetrahedron', 10854, *[1765, 1986, 2511, 1920], 1)
    ops.element('FourNodeTetrahedron', 10855, *[1920, 2301, 2511, 2509], 1)
    ops.element('FourNodeTetrahedron', 10856, *[2397, 1979, 2295, 2396], 1)
    ops.element('FourNodeTetrahedron', 10857, *[2512, 1765, 2511, 2509], 1)
    ops.element('FourNodeTetrahedron', 10858, *[2512, 2509, 2350, 2347], 1)
    ops.element('FourNodeTetrahedron', 10859, *[2512, 2511, 2350, 2509], 1)
    ops.element('FourNodeTetrahedron', 10860, *[2512, 2511, 2513, 2350], 1)
    ops.element('FourNodeTetrahedron', 10861, *[2512, 2513, 2349, 2350], 1)
    ops.element('FourNodeTetrahedron', 10862, *[2188, 1970, 2340, 2189], 1)
    ops.element('FourNodeTetrahedron', 10863, *[2511, 2498, 2513, 2350], 1)
    ops.element('FourNodeTetrahedron', 10864, *[2228, 2568, 1210, 2229], 1)
    ops.element('FourNodeTetrahedron', 10865, *[712, 2166, 713, 1157], 1)
    ops.element('FourNodeTetrahedron', 10866, *[712, 2166, 1157, 1809], 1)
    ops.element('FourNodeTetrahedron', 10867, *[2229, 2220, 2568, 1935], 1)
    ops.element('FourNodeTetrahedron', 10868, *[2471, 1804, 1757, 2427], 1)
    ops.element('FourNodeTetrahedron', 10869, *[1824, 1790, 2288, 1890], 1)
    ops.element('FourNodeTetrahedron', 10870, *[2213, 1972, 2079, 2139], 1)
    ops.element('FourNodeTetrahedron', 10871, *[2387, 1971, 2624, 2343], 1)
    ops.element('FourNodeTetrahedron', 10872, *[2214, 2080, 2532, 2213], 1)
    ops.element('FourNodeTetrahedron', 10873, *[2103, 2101, 2100, 1890], 1)
    ops.element('FourNodeTetrahedron', 10874, *[2219, 2111, 2000, 2588], 1)
    ops.element('FourNodeTetrahedron', 10875, *[2219, 2642, 2088, 2111], 1)
    ops.element('FourNodeTetrahedron', 10876, *[2568, 2219, 1810, 1935], 1)
    ops.element('FourNodeTetrahedron', 10877, *[2220, 2568, 2230, 2219], 1)
    ops.element('FourNodeTetrahedron', 10878, *[2220, 2568, 2230, 2229], 1)
    ops.element('FourNodeTetrahedron', 10879, *[734, 2304, 733, 1199], 1)
    ops.element('FourNodeTetrahedron', 10880, *[2230, 2568, 2228, 2229], 1)
    ops.element('FourNodeTetrahedron', 10881, *[2230, 2400, 2228, 2568], 1)
    ops.element('FourNodeTetrahedron', 10882, *[1783, 1897, 2579, 1855], 1)
    ops.element('FourNodeTetrahedron', 10883, *[1964, 2233, 2430, 2661], 1)
    ops.element('FourNodeTetrahedron', 10884, *[1783, 2680, 1897, 1855], 1)
    ops.element('FourNodeTetrahedron', 10885, *[2680, 1856, 1897, 1855], 1)
    ops.element('FourNodeTetrahedron', 10886, *[1764, 1782, 1783, 1855], 1)
    ops.element('FourNodeTetrahedron', 10887, *[2477, 2042, 2330, 2328], 1)
    ops.element('FourNodeTetrahedron', 10888, *[2481, 2249, 2017, 2248], 1)
    ops.element('FourNodeTetrahedron', 10889, *[1986, 1782, 1855, 1857], 1)
    ops.element('FourNodeTetrahedron', 10890, *[1764, 1782, 1855, 1986], 1)
    ops.element('FourNodeTetrahedron', 10891, *[2158, 2128, 2125, 2160], 1)
    ops.element('FourNodeTetrahedron', 10892, *[1198, 2669, 1819, 2622], 1)
    ops.element('FourNodeTetrahedron', 10893, *[1198, 1819, 1253, 1128], 1)
    ops.element('FourNodeTetrahedron', 10894, *[2240, 2493, 2325, 2494], 1)
    ops.element('FourNodeTetrahedron', 10895, *[1253, 1819, 1230, 1128], 1)
    ops.element('FourNodeTetrahedron', 10896, *[2396, 2114, 1780, 2236], 1)
    ops.element('FourNodeTetrahedron', 10897, *[1764, 1986, 1855, 2498], 1)
    ops.element('FourNodeTetrahedron', 10898, *[1790, 2176, 1890, 2174], 1)
    ops.element('FourNodeTetrahedron', 10899, *[1986, 1857, 1855, 2498], 1)
    ops.element('FourNodeTetrahedron', 10900, *[1783, 1782, 2680, 1855], 1)
    ops.element('FourNodeTetrahedron', 10901, *[2083, 1212, 1160, 2084], 1)
    ops.element('FourNodeTetrahedron', 10902, *[2083, 1212, 1132, 1160], 1)
    ops.element('FourNodeTetrahedron', 10903, *[2288, 2286, 2287, 1890], 1)
    ops.element('FourNodeTetrahedron', 10904, *[1992, 2379, 1989, 2269], 1)
    ops.element('FourNodeTetrahedron', 10905, *[1870, 2078, 1132, 2083], 1)
    ops.element('FourNodeTetrahedron', 10906, *[1782, 2680, 1855, 1857], 1)
    ops.element('FourNodeTetrahedron', 10907, *[1855, 2680, 1856, 1857], 1)
    ops.element('FourNodeTetrahedron', 10908, *[2140, 2379, 2413, 1992], 1)
    ops.element('FourNodeTetrahedron', 10909, *[2413, 2151, 2577, 1992], 1)
    ops.element('FourNodeTetrahedron', 10910, *[2478, 2338, 2517, 2561], 1)
    ops.element('FourNodeTetrahedron', 10911, *[2413, 2379, 2151, 1992], 1)
    ops.element('FourNodeTetrahedron', 10912, *[1774, 2181, 2183, 1834], 1)
    ops.element('FourNodeTetrahedron', 10913, *[1774, 1773, 2181, 1833], 1)
    ops.element('FourNodeTetrahedron', 10914, *[1774, 1772, 1773, 1833], 1)
    ops.element('FourNodeTetrahedron', 10915, *[1772, 1773, 1833, 2364], 1)
    ops.element('FourNodeTetrahedron', 10916, *[2084, 1847, 1212, 653], 1)
    ops.element('FourNodeTetrahedron', 10917, *[1773, 2671, 2181, 1833], 1)
    ops.element('FourNodeTetrahedron', 10918, *[1833, 1773, 2671, 2364], 1)
    ops.element('FourNodeTetrahedron', 10919, *[1833, 2671, 2230, 2364], 1)
    ops.element('FourNodeTetrahedron', 10920, *[1833, 2671, 2181, 2230], 1)
    ops.element('FourNodeTetrahedron', 10921, *[2139, 2223, 2079, 2271], 1)
    ops.element('FourNodeTetrahedron', 10922, *[2375, 2540, 2335, 2539], 1)
    ops.element('FourNodeTetrahedron', 10923, *[2435, 2681, 2436, 2335], 1)
    ops.element('FourNodeTetrahedron', 10924, *[2358, 1941, 2114, 1844], 1)
    ops.element('FourNodeTetrahedron', 10925, *[2091, 2092, 1832, 1831], 1)
    ops.element('FourNodeTetrahedron', 10926, *[2604, 2605, 2347, 2507], 1)
    ops.element('FourNodeTetrahedron', 10927, *[2394, 1774, 2582, 1834], 1)
    ops.element('FourNodeTetrahedron', 10928, *[1833, 2230, 2181, 1835], 1)
    ops.element('FourNodeTetrahedron', 10929, *[2470, 2641, 2159, 2173], 1)
    ops.element('FourNodeTetrahedron', 10930, *[1838, 1900, 2564, 2687], 1)
    ops.element('FourNodeTetrahedron', 10931, *[2642, 2089, 2546, 2088], 1)
    ops.element('FourNodeTetrahedron', 10932, *[1996, 2375, 2435, 2539], 1)
    ops.element('FourNodeTetrahedron', 10933, *[1150, 2602, 1220, 1222], 1)
    ops.element('FourNodeTetrahedron', 10934, *[2563, 2459, 2266, 1768], 1)
    ops.element('FourNodeTetrahedron', 10935, *[2008, 2485, 2630, 2555], 1)
    ops.element('FourNodeTetrahedron', 10936, *[2068, 1206, 1201, 2147], 1)
    ops.element('FourNodeTetrahedron', 10937, *[2459, 2066, 2266, 1768], 1)
    ops.element('FourNodeTetrahedron', 10938, *[2563, 1770, 2459, 1768], 1)
    ops.element('FourNodeTetrahedron', 10939, *[2139, 2271, 2269, 2270], 1)
    ops.element('FourNodeTetrahedron', 10940, *[2624, 2139, 2269, 2270], 1)
    ops.element('FourNodeTetrahedron', 10941, *[1947, 1871, 1948, 2156], 1)
    ops.element('FourNodeTetrahedron', 10942, *[1840, 1837, 2085, 1838], 1)
    ops.element('FourNodeTetrahedron', 10943, *[1804, 1757, 1758, 1806], 1)
    ops.element('FourNodeTetrahedron', 10944, *[2563, 1768, 2266, 2617], 1)
    ops.element('FourNodeTetrahedron', 10945, *[2373, 2461, 2167, 2660], 1)
    ops.element('FourNodeTetrahedron', 10946, *[749, 2005, 750, 1760], 1)
    ops.element('FourNodeTetrahedron', 10947, *[2266, 2066, 1942, 1768], 1)
    ops.element('FourNodeTetrahedron', 10948, *[1770, 2460, 2066, 1768], 1)
    ops.element('FourNodeTetrahedron', 10949, *[2066, 2460, 1942, 1768], 1)
    ops.element('FourNodeTetrahedron', 10950, *[2563, 1770, 1768, 1771], 1)
    ops.element('FourNodeTetrahedron', 10951, *[2009, 2258, 1226, 2256], 1)
    ops.element('FourNodeTetrahedron', 10952, *[2207, 1908, 1925, 1948], 1)
    ops.element('FourNodeTetrahedron', 10953, *[2205, 1948, 1925, 2155], 1)
    ops.element('FourNodeTetrahedron', 10954, *[2155, 2061, 2060, 2062], 1)
    ops.element('FourNodeTetrahedron', 10955, *[2060, 2062, 2466, 2155], 1)
    ops.element('FourNodeTetrahedron', 10956, *[514, 2683, 1159, 2396], 1)
    ops.element('FourNodeTetrahedron', 10957, *[1135, 2405, 1155, 1216], 1)
    ops.element('FourNodeTetrahedron', 10958, *[1948, 1871, 2186, 2155], 1)
    ops.element('FourNodeTetrahedron', 10959, *[2176, 2366, 1901, 1900], 1)
    ops.element('FourNodeTetrahedron', 10960, *[2563, 1768, 2617, 1771], 1)
    ops.element('FourNodeTetrahedron', 10961, *[2375, 2681, 2435, 2335], 1)
    ops.element('FourNodeTetrahedron', 10962, *[2035, 2036, 2037, 1747], 1)
    ops.element('FourNodeTetrahedron', 10963, *[1838, 2637, 1900, 2687], 1)
    ops.element('FourNodeTetrahedron', 10964, *[2102, 2376, 2116, 2101], 1)
    ops.element('FourNodeTetrahedron', 10965, *[2351, 2660, 2135, 2681], 1)
    ops.element('FourNodeTetrahedron', 10966, *[2241, 2493, 2221, 2356], 1)
    ops.element('FourNodeTetrahedron', 10967, *[1977, 1754, 1751, 2119], 1)
    ops.element('FourNodeTetrahedron', 10968, *[1977, 1754, 1753, 1751], 1)
    ops.element('FourNodeTetrahedron', 10969, *[1751, 1752, 651, 2119], 1)
    ops.element('FourNodeTetrahedron', 10970, *[2614, 1977, 1753, 1751], 1)
    ops.element('FourNodeTetrahedron', 10971, *[2614, 1977, 1751, 2119], 1)
    ops.element('FourNodeTetrahedron', 10972, *[2613, 2666, 1773, 2363], 1)
    ops.element('FourNodeTetrahedron', 10973, *[2312, 2613, 2363, 2311], 1)
    ops.element('FourNodeTetrahedron', 10974, *[666, 2614, 2119, 2118], 1)
    ops.element('FourNodeTetrahedron', 10975, *[2286, 2289, 2288, 1790], 1)
    ops.element('FourNodeTetrahedron', 10976, *[650, 1751, 1168, 651], 1)
    ops.element('FourNodeTetrahedron', 10977, *[2119, 1751, 650, 651], 1)
    ops.element('FourNodeTetrahedron', 10978, *[1775, 2312, 2363, 1772], 1)
    ops.element('FourNodeTetrahedron', 10979, *[2072, 2071, 2074, 1870], 1)
    ops.element('FourNodeTetrahedron', 10980, *[2358, 1784, 1844, 1980], 1)
    ops.element('FourNodeTetrahedron', 10981, *[2613, 2666, 2363, 2311], 1)
    ops.element('FourNodeTetrahedron', 10982, *[2152, 2002, 2004, 2426], 1)
    ops.element('FourNodeTetrahedron', 10983, *[2551, 2415, 2468, 2416], 1)
    ops.element('FourNodeTetrahedron', 10984, *[1930, 1996, 2284, 2307], 1)
    ops.element('FourNodeTetrahedron', 10985, *[2644, 1815, 2163, 1814], 1)
    ops.element('FourNodeTetrahedron', 10986, *[2065, 1944, 1943, 1942], 1)
    ops.element('FourNodeTetrahedron', 10987, *[2371, 2010, 2370, 2474], 1)
    ops.element('FourNodeTetrahedron', 10988, *[1884, 1814, 1885, 2031], 1)
    ops.element('FourNodeTetrahedron', 10989, *[2203, 2467, 2202, 2370], 1)
    ops.element('FourNodeTetrahedron', 10990, *[2636, 1922, 1888, 1920], 1)
    ops.element('FourNodeTetrahedron', 10991, *[1127, 2229, 1147, 1209], 1)
    ops.element('FourNodeTetrahedron', 10992, *[2407, 2538, 2402, 2406], 1)
    ops.element('FourNodeTetrahedron', 10993, *[1981, 1785, 2383, 2382], 1)
    ops.element('FourNodeTetrahedron', 10994, *[1986, 1987, 1782, 1857], 1)
    ops.element('FourNodeTetrahedron', 10995, *[2644, 1814, 1926, 2032], 1)
    ops.element('FourNodeTetrahedron', 10996, *[1986, 1987, 1857, 1924], 1)
    ops.element('FourNodeTetrahedron', 10997, *[1807, 1804, 1806, 2184], 1)
    ops.element('FourNodeTetrahedron', 10998, *[1836, 2310, 2220, 2107], 1)
    ops.element('FourNodeTetrahedron', 10999, *[1147, 2229, 1210, 1209], 1)
    ops.element('FourNodeTetrahedron', 11000, *[1130, 2537, 1149, 1191], 1)
    ops.element('FourNodeTetrahedron', 11001, *[1842, 2398, 1763, 2652], 1)
    ops.element('FourNodeTetrahedron', 11002, *[2350, 2496, 2412, 2411], 1)
    ops.element('FourNodeTetrahedron', 11003, *[2398, 1904, 1763, 2652], 1)
    ops.element('FourNodeTetrahedron', 11004, *[2240, 2325, 2406, 2494], 1)
    ops.element('FourNodeTetrahedron', 11005, *[2116, 2376, 2540, 2101], 1)
    ops.element('FourNodeTetrahedron', 11006, *[2530, 2043, 2168, 2158], 1)
    ops.element('FourNodeTetrahedron', 11007, *[2012, 1889, 2264, 1886], 1)
    ops.element('FourNodeTetrahedron', 11008, *[2387, 1971, 2138, 2624], 1)
    ops.element('FourNodeTetrahedron', 11009, *[1928, 1941, 1979, 2358], 1)
    ops.element('FourNodeTetrahedron', 11010, *[2380, 2657, 2070, 1821], 1)
    ops.element('FourNodeTetrahedron', 11011, *[2290, 2604, 2592, 2384], 1)
    ops.element('FourNodeTetrahedron', 11012, *[1875, 1788, 1790, 2566], 1)
    ops.element('FourNodeTetrahedron', 11013, *[1926, 2032, 2031, 2033], 1)
    ops.element('FourNodeTetrahedron', 11014, *[2027, 2091, 1803, 1830], 1)
    ops.element('FourNodeTetrahedron', 11015, *[1186, 1797, 1188, 1183], 1)
    ops.element('FourNodeTetrahedron', 11016, *[2236, 2449, 1781, 1898], 1)
    ops.element('FourNodeTetrahedron', 11017, *[2240, 2494, 2406, 2242], 1)
    ops.element('FourNodeTetrahedron', 11018, *[2392, 2490, 2491, 2424], 1)
    ops.element('FourNodeTetrahedron', 11019, *[2392, 2424, 2491, 2425], 1)
    ops.element('FourNodeTetrahedron', 11020, *[1823, 1875, 1790, 2272], 1)
    ops.element('FourNodeTetrahedron', 11021, *[2157, 2160, 2325, 2173], 1)
    ops.element('FourNodeTetrahedron', 11022, *[1784, 2524, 1961, 1786], 1)
    ops.element('FourNodeTetrahedron', 11023, *[1961, 2524, 1960, 1786], 1)
    ops.element('FourNodeTetrahedron', 11024, *[1913, 2381, 2073, 2602], 1)
    ops.element('FourNodeTetrahedron', 11025, *[2117, 1754, 1752, 2119], 1)
    ops.element('FourNodeTetrahedron', 11026, *[2148, 2146, 2144, 1897], 1)
    ops.element('FourNodeTetrahedron', 11027, *[2421, 2632, 2422, 2530], 1)
    ops.element('FourNodeTetrahedron', 11028, *[1152, 2594, 1194, 621], 1)
    ops.element('FourNodeTetrahedron', 11029, *[752, 1808, 2047, 1143], 1)
    ops.element('FourNodeTetrahedron', 11030, *[2190, 2622, 1186, 2268], 1)
    ops.element('FourNodeTetrahedron', 11031, *[1122, 2365, 2190, 2191], 1)
    ops.element('FourNodeTetrahedron', 11032, *[2179, 2177, 2627, 2022], 1)
    ops.element('FourNodeTetrahedron', 11033, *[2063, 2621, 2123, 2062], 1)
    ops.element('FourNodeTetrahedron', 11034, *[2230, 2546, 2568, 2219], 1)
    ops.element('FourNodeTetrahedron', 11035, *[1931, 1932, 1930, 1994], 1)
    ops.element('FourNodeTetrahedron', 11036, *[1856, 2538, 2407, 2388], 1)
    ops.element('FourNodeTetrahedron', 11037, *[1799, 1828, 2143, 2149], 1)
    ops.element('FourNodeTetrahedron', 11038, *[1753, 2083, 1160, 1752], 1)
    ops.element('FourNodeTetrahedron', 11039, *[2483, 2195, 2215, 2619], 1)
    ops.element('FourNodeTetrahedron', 11040, *[2414, 2601, 1963, 1965], 1)
    ops.element('FourNodeTetrahedron', 11041, *[2117, 1754, 1752, 2361], 1)
    ops.element('FourNodeTetrahedron', 11042, *[2443, 2679, 2365, 2067], 1)
    ops.element('FourNodeTetrahedron', 11043, *[743, 2178, 742, 1193], 1)
    ops.element('FourNodeTetrahedron', 11044, *[2490, 2673, 2615, 2424], 1)
    ops.element('FourNodeTetrahedron', 11045, *[2533, 2153, 2321, 1848], 1)
    ops.element('FourNodeTetrahedron', 11046, *[2135, 2134, 2133, 2436], 1)
    ops.element('FourNodeTetrahedron', 11047, *[1799, 2143, 1227, 1184], 1)
    ops.element('FourNodeTetrahedron', 11048, *[2331, 2328, 2111, 1832], 1)
    ops.element('FourNodeTetrahedron', 11049, *[2226, 2211, 2592, 2290], 1)
    ops.element('FourNodeTetrahedron', 11050, *[2177, 2586, 2627, 2022], 1)
    ops.element('FourNodeTetrahedron', 11051, *[2135, 2660, 2134, 2436], 1)
    ops.element('FourNodeTetrahedron', 11052, *[2211, 1886, 2592, 2290], 1)
    ops.element('FourNodeTetrahedron', 11053, *[1124, 2275, 2595, 2258], 1)
    ops.element('FourNodeTetrahedron', 11054, *[1915, 1914, 2639, 2606], 1)
    ops.element('FourNodeTetrahedron', 11055, *[1870, 1132, 1244, 2083], 1)
    ops.element('FourNodeTetrahedron', 11056, *[1824, 2367, 2288, 1790], 1)
    ops.element('FourNodeTetrahedron', 11057, *[1186, 2505, 1233, 1188], 1)
    ops.element('FourNodeTetrahedron', 11058, *[1758, 1966, 2536, 2096], 1)
    ops.element('FourNodeTetrahedron', 11059, *[1246, 1913, 1221, 1150], 1)
    ops.element('FourNodeTetrahedron', 11060, *[2135, 2681, 2660, 2436], 1)
    ops.element('FourNodeTetrahedron', 11061, *[2076, 2515, 1868, 2245], 1)
    ops.element('FourNodeTetrahedron', 11062, *[1125, 2395, 1176, 1179], 1)
    ops.element('FourNodeTetrahedron', 11063, *[2319, 2409, 2408, 2147], 1)
    ops.element('FourNodeTetrahedron', 11064, *[2097, 2655, 2103, 2221], 1)
    ops.element('FourNodeTetrahedron', 11065, *[2272, 2174, 2514, 2086], 1)
    ops.element('FourNodeTetrahedron', 11066, *[1840, 2085, 1917, 1916], 1)
    ops.element('FourNodeTetrahedron', 11067, *[2507, 2605, 2302, 2510], 1)
    ops.element('FourNodeTetrahedron', 11068, *[1840, 1917, 2474, 1916], 1)
    ops.element('FourNodeTetrahedron', 11069, *[2160, 2126, 2434, 2433], 1)
    ops.element('FourNodeTetrahedron', 11070, *[2588, 2464, 2351, 2283], 1)
    ops.element('FourNodeTetrahedron', 11071, *[2677, 2434, 2160, 2641], 1)
    ops.element('FourNodeTetrahedron', 11072, *[2677, 2126, 2160, 2434], 1)
    ops.element('FourNodeTetrahedron', 11073, *[2159, 2158, 2160, 2677], 1)
    ops.element('FourNodeTetrahedron', 11074, *[2128, 2126, 2160, 2677], 1)
    ops.element('FourNodeTetrahedron', 11075, *[2158, 2128, 2160, 2677], 1)
    ops.element('FourNodeTetrahedron', 11076, *[2404, 2142, 1205, 1231], 1)
    ops.element('FourNodeTetrahedron', 11077, *[2627, 2022, 1192, 1779], 1)
    ops.element('FourNodeTetrahedron', 11078, *[2526, 2527, 2030, 2103], 1)
    ops.element('FourNodeTetrahedron', 11079, *[2316, 2049, 2419, 2020], 1)
    ops.element('FourNodeTetrahedron', 11080, *[2226, 2592, 2594, 2384], 1)
    ops.element('FourNodeTetrahedron', 11081, *[2394, 1834, 2582, 2391], 1)
    ops.element('FourNodeTetrahedron', 11082, *[2151, 2077, 2075, 2002], 1)
    ops.element('FourNodeTetrahedron', 11083, *[2171, 2578, 2172, 2169], 1)
    ops.element('FourNodeTetrahedron', 11084, *[1213, 1760, 1153, 1866], 1)
    ops.element('FourNodeTetrahedron', 11085, *[2316, 2020, 2419, 1869], 1)
    ops.element('FourNodeTetrahedron', 11086, *[2251, 2196, 2216, 2064], 1)
    ops.element('FourNodeTetrahedron', 11087, *[742, 2177, 741, 2627], 1)
    ops.element('FourNodeTetrahedron', 11088, *[2178, 2627, 742, 1161], 1)
    ops.element('FourNodeTetrahedron', 11089, *[1829, 2376, 2464, 2059], 1)
    ops.element('FourNodeTetrahedron', 11090, *[1859, 2007, 2467, 2202], 1)
    ops.element('FourNodeTetrahedron', 11091, *[1131, 2013, 1195, 1194], 1)
    ops.element('FourNodeTetrahedron', 11092, *[1121, 2074, 1234, 1223], 1)
    ops.element('FourNodeTetrahedron', 11093, *[1996, 2102, 2375, 2116], 1)
    ops.element('FourNodeTetrahedron', 11094, *[1981, 2532, 1785, 2382], 1)
    ops.element('FourNodeTetrahedron', 11095, *[2343, 2270, 2139, 2624], 1)
    ops.element('FourNodeTetrahedron', 11096, *[2108, 2041, 2109, 2110], 1)
    ops.element('FourNodeTetrahedron', 11097, *[2284, 2539, 2255, 2306], 1)
    ops.element('FourNodeTetrahedron', 11098, *[1146, 2172, 1257, 2368], 1)
    ops.element('FourNodeTetrahedron', 11099, *[2211, 2574, 2576, 2535], 1)
    ops.element('FourNodeTetrahedron', 11100, *[2258, 2457, 1241, 1178], 1)
    ops.element('FourNodeTetrahedron', 11101, *[2142, 1895, 2528, 2496], 1)
    ops.element('FourNodeTetrahedron', 11102, *[1842, 1843, 2398, 2652], 1)
    ops.element('FourNodeTetrahedron', 11103, *[1872, 2612, 2184, 2062], 1)
    ops.element('FourNodeTetrahedron', 11104, *[2402, 1204, 1251, 1135], 1)
    ops.element('FourNodeTetrahedron', 11105, *[2460, 1945, 1942, 2227], 1)
    ops.element('FourNodeTetrahedron', 11106, *[2114, 1841, 1842, 1844], 1)
    ops.element('FourNodeTetrahedron', 11107, *[2114, 1961, 1841, 1844], 1)
    ops.element('FourNodeTetrahedron', 11108, *[2114, 1841, 1762, 1842], 1)
    ops.element('FourNodeTetrahedron', 11109, *[1961, 1841, 2472, 2114], 1)
    ops.element('FourNodeTetrahedron', 11110, *[2241, 2356, 2194, 2123], 1)
    ops.element('FourNodeTetrahedron', 11111, *[1996, 2435, 2284, 2539], 1)
    ops.element('FourNodeTetrahedron', 11112, *[1800, 1801, 2331, 1803], 1)
    ops.element('FourNodeTetrahedron', 11113, *[2043, 2417, 2027, 2158], 1)
    ops.element('FourNodeTetrahedron', 11114, *[1195, 2404, 1240, 1138], 1)
    ops.element('FourNodeTetrahedron', 11115, *[1979, 2114, 2295, 2396], 1)
    ops.element('FourNodeTetrahedron', 11116, *[2292, 2509, 1886, 2604], 1)
    ops.element('FourNodeTetrahedron', 11117, *[743, 2180, 742, 2178], 1)
    ops.element('FourNodeTetrahedron', 11118, *[2084, 1847, 653, 1849], 1)
    ops.element('FourNodeTetrahedron', 11119, *[1761, 2399, 2005, 1763], 1)
    ops.element('FourNodeTetrahedron', 11120, *[2254, 1957, 1769, 1958], 1)
    ops.element('FourNodeTetrahedron', 11121, *[1803, 2092, 2331, 1832], 1)
    ops.element('FourNodeTetrahedron', 11122, *[2642, 2089, 2088, 2111], 1)
    ops.element('FourNodeTetrahedron', 11123, *[2397, 2683, 514, 2396], 1)
    ops.element('FourNodeTetrahedron', 11124, *[2521, 1841, 1762, 2114], 1)
    ops.element('FourNodeTetrahedron', 11125, *[2274, 2664, 2057, 2054], 1)
    ops.element('FourNodeTetrahedron', 11126, *[2046, 2275, 1165, 1124], 1)
    ops.element('FourNodeTetrahedron', 11127, *[1163, 2046, 1165, 1124], 1)
    ops.element('FourNodeTetrahedron', 11128, *[2252, 2253, 1958, 2274], 1)
    ops.element('FourNodeTetrahedron', 11129, *[2615, 2633, 2311, 1800], 1)
    ops.element('FourNodeTetrahedron', 11130, *[2344, 2548, 1794, 1850], 1)
    ops.element('FourNodeTetrahedron', 11131, *[2148, 1783, 2579, 2263], 1)
    ops.element('FourNodeTetrahedron', 11132, *[2027, 1830, 2440, 2125], 1)
    ops.element('FourNodeTetrahedron', 11133, *[2456, 2314, 2059, 2030], 1)
    ops.element('FourNodeTetrahedron', 11134, *[2059, 2314, 2313, 2030], 1)
    ops.element('FourNodeTetrahedron', 11135, *[2275, 2442, 1245, 2595], 1)
    ops.element('FourNodeTetrahedron', 11136, *[2149, 1767, 1783, 2263], 1)
    ops.element('FourNodeTetrahedron', 11137, *[1767, 1783, 2263, 1764], 1)
    ops.element('FourNodeTetrahedron', 11138, *[2234, 2052, 1883, 634], 1)
    ops.element('FourNodeTetrahedron', 11139, *[513, 2236, 1134, 1246], 1)
    ops.element('FourNodeTetrahedron', 11140, *[2498, 1857, 1858, 2300], 1)
    ops.element('FourNodeTetrahedron', 11141, *[2569, 2661, 1964, 2618], 1)
    ops.element('FourNodeTetrahedron', 11142, *[2614, 1751, 2259, 2119], 1)
    ops.element('FourNodeTetrahedron', 11143, *[2146, 2530, 2422, 1854], 1)
    ops.element('FourNodeTetrahedron', 11144, *[2517, 2561, 2590, 2518], 1)
    ops.element('FourNodeTetrahedron', 11145, *[2338, 2339, 2337, 2647], 1)
    ops.element('FourNodeTetrahedron', 11146, *[2241, 2221, 2494, 2222], 1)
    ops.element('FourNodeTetrahedron', 11147, *[1901, 2684, 1951, 1900], 1)
    ops.element('FourNodeTetrahedron', 11148, *[2085, 1838, 1916, 1840], 1)
    ops.element('FourNodeTetrahedron', 11149, *[2137, 1906, 2011, 1907], 1)
    ops.element('FourNodeTetrahedron', 11150, *[1854, 2530, 2157, 1896], 1)
    ops.element('FourNodeTetrahedron', 11151, *[2484, 1865, 2199, 2630], 1)
    ops.element('FourNodeTetrahedron', 11152, *[2246, 2012, 2015, 2014], 1)
    ops.element('FourNodeTetrahedron', 11153, *[2054, 2051, 1883, 2052], 1)
    ops.element('FourNodeTetrahedron', 11154, *[1782, 2345, 2680, 1857], 1)
    ops.element('FourNodeTetrahedron', 11155, *[1801, 2092, 2331, 1803], 1)
    ops.element('FourNodeTetrahedron', 11156, *[1803, 1801, 2092, 2091], 1)
    ops.element('FourNodeTetrahedron', 11157, *[2491, 2310, 2025, 2107], 1)
    ops.element('FourNodeTetrahedron', 11158, *[1802, 1801, 1803, 2091], 1)
    ops.element('FourNodeTetrahedron', 11159, *[1807, 2427, 2428, 2185], 1)
    ops.element('FourNodeTetrahedron', 11160, *[2074, 1869, 1235, 1870], 1)
    ops.element('FourNodeTetrahedron', 11161, *[1199, 2463, 1151, 2070], 1)
    ops.element('FourNodeTetrahedron', 11162, *[2381, 2130, 2315, 2631], 1)
    ops.element('FourNodeTetrahedron', 11163, *[1199, 2304, 2463, 2070], 1)
    ops.element('FourNodeTetrahedron', 11164, *[1171, 2011, 738, 1144], 1)
    ops.element('FourNodeTetrahedron', 11165, *[2350, 2498, 2496, 2411], 1)
    ops.element('FourNodeTetrahedron', 11166, *[2169, 2369, 2368, 2653], 1)
    ops.element('FourNodeTetrahedron', 11167, *[1980, 2668, 1785, 2532], 1)
    ops.element('FourNodeTetrahedron', 11168, *[2069, 2408, 2070, 2068], 1)
    ops.element('FourNodeTetrahedron', 11169, *[2237, 1913, 1150, 2438], 1)
    ops.element('FourNodeTetrahedron', 11170, *[2293, 2444, 2292, 2291], 1)
    ops.element('FourNodeTetrahedron', 11171, *[1836, 2310, 1833, 2220], 1)
    ops.element('FourNodeTetrahedron', 11172, *[2320, 2069, 2068, 2319], 1)
    ops.element('FourNodeTetrahedron', 11173, *[1852, 2440, 1935, 1933], 1)
    ops.element('FourNodeTetrahedron', 11174, *[2121, 2086, 2085, 1837], 1)
    ops.element('FourNodeTetrahedron', 11175, *[1932, 1829, 2464, 1994], 1)
    ops.element('FourNodeTetrahedron', 11176, *[2384, 2592, 2462, 2450], 1)
    ops.element('FourNodeTetrahedron', 11177, *[1853, 1860, 1204, 1861], 1)
    ops.element('FourNodeTetrahedron', 11178, *[2223, 1793, 2549, 2296], 1)
    ops.element('FourNodeTetrahedron', 11179, *[2308, 2019, 2533, 2332], 1)
    ops.element('FourNodeTetrahedron', 11180, *[1987, 1909, 1918, 1924], 1)
    ops.element('FourNodeTetrahedron', 11181, *[1185, 1943, 1183, 1182], 1)
    ops.element('FourNodeTetrahedron', 11182, *[1216, 2405, 1155, 2542], 1)
    ops.element('FourNodeTetrahedron', 11183, *[2161, 1817, 2651, 1884], 1)
    ops.element('FourNodeTetrahedron', 11184, *[1157, 2167, 2166, 1809], 1)
    ops.element('FourNodeTetrahedron', 11185, *[2064, 2643, 146, 419], 1)
    ops.element('FourNodeTetrahedron', 11186, *[2590, 2501, 2560, 2559], 1)
    ops.element('FourNodeTetrahedron', 11187, *[2479, 2518, 2495, 511], 1)
    ops.element('FourNodeTetrahedron', 11188, *[2401, 2166, 712, 1809], 1)
    ops.element('FourNodeTetrahedron', 11189, *[2656, 2360, 2362, 2117], 1)
    ops.element('FourNodeTetrahedron', 11190, *[2292, 2291, 2604, 2290], 1)
    ops.element('FourNodeTetrahedron', 11191, *[2656, 2360, 2362, 1990], 1)
    ops.element('FourNodeTetrahedron', 11192, *[1237, 2359, 1178, 1125], 1)
    ops.element('FourNodeTetrahedron', 11193, *[2609, 1793, 2685, 1850], 1)
    ops.element('FourNodeTetrahedron', 11194, *[2483, 2465, 2215, 2195], 1)
    ops.element('FourNodeTetrahedron', 11195, *[2382, 2081, 2131, 2531], 1)
    ops.element('FourNodeTetrahedron', 11196, *[2388, 2173, 2240, 2389], 1)
    ops.element('FourNodeTetrahedron', 11197, *[2027, 1830, 1803, 2440], 1)
    ops.element('FourNodeTetrahedron', 11198, *[2187, 2486, 1970, 2386], 1)
    ops.element('FourNodeTetrahedron', 11199, *[2638, 1770, 2459, 2563], 1)
    ops.element('FourNodeTetrahedron', 11200, *[2220, 2364, 2230, 2219], 1)
    ops.element('FourNodeTetrahedron', 11201, *[1836, 2220, 2230, 2229], 1)
    ops.element('FourNodeTetrahedron', 11202, *[2045, 2105, 2475, 2504], 1)
    ops.element('FourNodeTetrahedron', 11203, *[2179, 2022, 2627, 1779], 1)
    ops.element('FourNodeTetrahedron', 11204, *[2277, 2476, 2593, 2445], 1)
    ops.element('FourNodeTetrahedron', 11205, *[2521, 1761, 2607, 1762], 1)
    ops.element('FourNodeTetrahedron', 11206, *[2598, 1892, 1249, 1923], 1)
    ops.element('FourNodeTetrahedron', 11207, *[1834, 2181, 2183, 1835], 1)
    ops.element('FourNodeTetrahedron', 11208, *[1842, 1903, 1866, 1952], 1)
    ops.element('FourNodeTetrahedron', 11209, *[2425, 2491, 2261, 2025], 1)
    ops.element('FourNodeTetrahedron', 11210, *[2574, 2444, 2292, 2576], 1)
    ops.element('FourNodeTetrahedron', 11211, *[2154, 1883, 1181, 2234], 1)
    ops.element('FourNodeTetrahedron', 11212, *[2368, 1977, 2614, 2118], 1)
    ops.element('FourNodeTetrahedron', 11213, *[1132, 2308, 1179, 1212], 1)
    ops.element('FourNodeTetrahedron', 11214, *[2088, 2351, 2373, 2135], 1)
    ops.element('FourNodeTetrahedron', 11215, *[1966, 1823, 2527, 2097], 1)
    ops.element('FourNodeTetrahedron', 11216, *[2607, 1761, 1988, 1762], 1)
    ops.element('FourNodeTetrahedron', 11217, *[1912, 2322, 2390, 2093], 1)
    ops.element('FourNodeTetrahedron', 11218, *[2364, 2642, 2546, 2219], 1)
    ops.element('FourNodeTetrahedron', 11219, *[1861, 1974, 1860, 1859], 1)
    ops.element('FourNodeTetrahedron', 11220, *[2475, 2105, 1779, 2106], 1)
    ops.element('FourNodeTetrahedron', 11221, *[2393, 2659, 2276, 2277], 1)
    ops.element('FourNodeTetrahedron', 11222, *[2575, 2659, 2277, 2445], 1)
    ops.element('FourNodeTetrahedron', 11223, *[1140, 2064, 146, 1238], 1)
    ops.element('FourNodeTetrahedron', 11224, *[1236, 1870, 1235, 1244], 1)
    ops.element('FourNodeTetrahedron', 11225, *[2581, 2567, 1876, 1963], 1)
    ops.element('FourNodeTetrahedron', 11226, *[741, 2627, 2024, 1192], 1)
    ops.element('FourNodeTetrahedron', 11227, *[1192, 2024, 740, 1142], 1)
    ops.element('FourNodeTetrahedron', 11228, *[1182, 1796, 1131, 2556], 1)
    ops.element('FourNodeTetrahedron', 11229, *[1200, 2070, 1136, 2068], 1)
    ops.element('FourNodeTetrahedron', 11230, *[2600, 2261, 2409, 2632], 1)
    ops.element('FourNodeTetrahedron', 11231, *[1945, 2246, 2267, 1943], 1)
    ops.element('FourNodeTetrahedron', 11232, *[1187, 1776, 1186, 1122], 1)
    ops.element('FourNodeTetrahedron', 11233, *[1258, 1866, 1213, 1129], 1)
    ops.element('FourNodeTetrahedron', 11234, *[2571, 1780, 1894, 2396], 1)
    ops.element('FourNodeTetrahedron', 11235, *[2352, 2355, 2391, 2354], 1)
    ops.element('FourNodeTetrahedron', 11236, *[2345, 2346, 2173, 2390], 1)
    ops.element('FourNodeTetrahedron', 11237, *[2380, 1174, 739, 1144], 1)
    ops.element('FourNodeTetrahedron', 11238, *[2305, 2304, 1199, 2070], 1)
    ops.element('FourNodeTetrahedron', 11239, *[738, 2380, 739, 1144], 1)
    ops.element('FourNodeTetrahedron', 11240, *[1924, 1909, 1918, 1908], 1)
    ops.element('FourNodeTetrahedron', 11241, *[2295, 2571, 1894, 2396], 1)
    ops.element('FourNodeTetrahedron', 11242, *[2036, 2553, 1749, 1972], 1)
    ops.element('FourNodeTetrahedron', 11243, *[1749, 2323, 1748, 1972], 1)
    ops.element('FourNodeTetrahedron', 11244, *[2641, 2640, 2516, 2389], 1)
    ops.element('FourNodeTetrahedron', 11245, *[2680, 2346, 1897, 1856], 1)
    ops.element('FourNodeTetrahedron', 11246, *[2062, 2621, 2123, 2612], 1)
    ops.element('FourNodeTetrahedron', 11247, *[2062, 2123, 2063, 2466], 1)
    ops.element('FourNodeTetrahedron', 11248, *[2277, 2476, 2276, 2185], 1)
    ops.element('FourNodeTetrahedron', 11249, *[2593, 2551, 2185, 1873], 1)
    ops.element('FourNodeTetrahedron', 11250, *[2255, 2098, 2250, 2465], 1)
    ops.element('FourNodeTetrahedron', 11251, *[2276, 2476, 2427, 2185], 1)
    ops.element('FourNodeTetrahedron', 11252, *[1873, 2551, 2185, 2550], 1)
    ops.element('FourNodeTetrahedron', 11253, *[2486, 2597, 1972, 1970], 1)
    ops.element('FourNodeTetrahedron', 11254, *[2162, 1814, 1884, 1926], 1)
    ops.element('FourNodeTetrahedron', 11255, *[2063, 2241, 2194, 2123], 1)
    ops.element('FourNodeTetrahedron', 11256, *[1859, 1891, 1232, 2467], 1)
    ops.element('FourNodeTetrahedron', 11257, *[2146, 2422, 2145, 1854], 1)
    ops.element('FourNodeTetrahedron', 11258, *[2123, 2429, 2192, 2121], 1)
    ops.element('FourNodeTetrahedron', 11259, *[2192, 2121, 2193, 2124], 1)
    ops.element('FourNodeTetrahedron', 11260, *[1185, 1942, 1182, 1137], 1)
    ops.element('FourNodeTetrahedron', 11261, *[2570, 2340, 2357, 2478], 1)
    ops.element('FourNodeTetrahedron', 11262, *[2051, 2209, 2226, 2208], 1)
    ops.element('FourNodeTetrahedron', 11263, *[1798, 2247, 1937, 2015], 1)
    ops.element('FourNodeTetrahedron', 11264, *[2578, 2420, 2172, 2169], 1)
    ops.element('FourNodeTetrahedron', 11265, *[2144, 2402, 1203, 2142], 1)
    ops.element('FourNodeTetrahedron', 11266, *[2428, 2686, 1968, 2468], 1)
    ops.element('FourNodeTetrahedron', 11267, *[2428, 1968, 2096, 2468], 1)
    ops.element('FourNodeTetrahedron', 11268, *[1920, 2377, 2301, 2510], 1)
    ops.element('FourNodeTetrahedron', 11269, *[2315, 2316, 2298, 2074], 1)
    ops.element('FourNodeTetrahedron', 11270, *[1807, 2428, 2184, 2185], 1)
    ops.element('FourNodeTetrahedron', 11271, *[2494, 2526, 2307, 2221], 1)
    ops.element('FourNodeTetrahedron', 11272, *[1999, 2133, 2537, 2098], 1)
    ops.element('FourNodeTetrahedron', 11273, *[2391, 1834, 2582, 1998], 1)
    ops.element('FourNodeTetrahedron', 11274, *[2615, 2648, 2674, 2329], 1)
    ops.element('FourNodeTetrahedron', 11275, *[2051, 2210, 2209, 2208], 1)
    ops.element('FourNodeTetrahedron', 11276, *[2589, 1863, 2541, 1865], 1)
    ops.element('FourNodeTetrahedron', 11277, *[2537, 2133, 1224, 2098], 1)
    ops.element('FourNodeTetrahedron', 11278, *[2432, 2252, 2244, 2243], 1)
    ops.element('FourNodeTetrahedron', 11279, *[2432, 2252, 2243, 2431], 1)
    ops.element('FourNodeTetrahedron', 11280, *[2001, 2432, 2243, 2431], 1)
    ops.element('FourNodeTetrahedron', 11281, *[2268, 2503, 2505, 1797], 1)
    ops.element('FourNodeTetrahedron', 11282, *[2027, 2091, 1830, 2125], 1)
    ops.element('FourNodeTetrahedron', 11283, *[1999, 2098, 2537, 2284], 1)
    ops.element('FourNodeTetrahedron', 11284, *[2252, 1958, 2480, 2243], 1)
    ops.element('FourNodeTetrahedron', 11285, *[1993, 2526, 2307, 2494], 1)
    ops.element('FourNodeTetrahedron', 11286, *[2646, 2055, 2357, 2570], 1)
    ops.element('FourNodeTetrahedron', 11287, *[2621, 2096, 2536, 2294], 1)
    ops.element('FourNodeTetrahedron', 11288, *[1999, 2135, 2133, 2435], 1)
    ops.element('FourNodeTetrahedron', 11289, *[2431, 2252, 2243, 2500], 1)
    ops.element('FourNodeTetrahedron', 11290, *[1153, 1880, 1207, 1139], 1)
    ops.element('FourNodeTetrahedron', 11291, *[2051, 2210, 2208, 2053], 1)
    ops.element('FourNodeTetrahedron', 11292, *[2210, 2211, 2208, 2053], 1)
    ops.element('FourNodeTetrahedron', 11293, *[2270, 2271, 1991, 2327], 1)
    ops.element('FourNodeTetrahedron', 11294, *[2590, 2338, 2502, 2508], 1)
    ops.element('FourNodeTetrahedron', 11295, *[1747, 2036, 1972, 2486], 1)
    ops.element('FourNodeTetrahedron', 11296, *[1753, 1160, 1244, 1168], 1)
    ops.element('FourNodeTetrahedron', 11297, *[1191, 2255, 1190, 1891], 1)
    ops.element('FourNodeTetrahedron', 11298, *[2145, 1852, 1949, 1853], 1)
    ops.element('FourNodeTetrahedron', 11299, *[1750, 2229, 1147, 1127], 1)
    ops.element('FourNodeTetrahedron', 11300, *[1750, 1147, 1242, 1127], 1)
    ops.element('FourNodeTetrahedron', 11301, *[1242, 1834, 1835, 1750], 1)
    ops.element('FourNodeTetrahedron', 11302, *[2395, 2321, 1176, 2308], 1)
    ops.element('FourNodeTetrahedron', 11303, *[1179, 2395, 1176, 2308], 1)
    ops.element('FourNodeTetrahedron', 11304, *[1176, 2321, 1175, 1148], 1)
    ops.element('FourNodeTetrahedron', 11305, *[1765, 1986, 1764, 2511], 1)
    ops.element('FourNodeTetrahedron', 11306, *[2512, 2350, 2349, 2347], 1)
    ops.element('FourNodeTetrahedron', 11307, *[683, 2662, 684, 2573], 1)
    ops.element('FourNodeTetrahedron', 11308, *[1226, 2258, 1178, 2359], 1)
    ops.element('FourNodeTetrahedron', 11309, *[2375, 2335, 2435, 2539], 1)
    ops.element('FourNodeTetrahedron', 11310, *[1967, 2030, 2456, 2527], 1)
    ops.element('FourNodeTetrahedron', 11311, *[1756, 1967, 2456, 2527], 1)
    ops.element('FourNodeTetrahedron', 11312, *[2078, 2019, 2395, 2308], 1)
    ops.element('FourNodeTetrahedron', 11313, *[1868, 2018, 2016, 2245], 1)
    ops.element('FourNodeTetrahedron', 11314, *[2306, 2465, 2215, 2483], 1)
    ops.element('FourNodeTetrahedron', 11315, *[1973, 2484, 2306, 2483], 1)
    ops.element('FourNodeTetrahedron', 11316, *[2307, 2284, 1975, 2306], 1)
    ops.element('FourNodeTetrahedron', 11317, *[2424, 2418, 1800, 2043], 1)
    ops.element('FourNodeTetrahedron', 11318, *[2626, 2664, 2274, 2054], 1)
    ops.element('FourNodeTetrahedron', 11319, *[1208, 2120, 1214, 2616], 1)
    ops.element('FourNodeTetrahedron', 11320, *[2459, 2067, 1759, 2066], 1)
    ops.element('FourNodeTetrahedron', 11321, *[1949, 2120, 1208, 2616], 1)
    ops.element('FourNodeTetrahedron', 11322, *[1895, 2407, 2402, 2528], 1)
    ops.element('FourNodeTetrahedron', 11323, *[1154, 2348, 1196, 623], 1)
    ops.element('FourNodeTetrahedron', 11324, *[1225, 1226, 1164, 2256], 1)
    ops.element('FourNodeTetrahedron', 11325, *[1164, 2009, 1226, 2256], 1)
    ops.element('FourNodeTetrahedron', 11326, *[1756, 2456, 2112, 2527], 1)
    ops.element('FourNodeTetrahedron', 11327, *[2490, 2629, 1775, 2312], 1)
    ops.element('FourNodeTetrahedron', 11328, *[2169, 2453, 2369, 2653], 1)
    ops.element('FourNodeTetrahedron', 11329, *[2252, 2249, 2480, 1958], 1)
    ops.element('FourNodeTetrahedron', 11330, *[1781, 1842, 1866, 1898], 1)
    ops.element('FourNodeTetrahedron', 11331, *[1239, 1893, 747, 1169], 1)
    ops.element('FourNodeTetrahedron', 11332, *[2120, 1811, 1211, 1214], 1)
    ops.element('FourNodeTetrahedron', 11333, *[2301, 1924, 2095, 2303], 1)
    ops.element('FourNodeTetrahedron', 11334, *[2375, 2681, 2335, 2540], 1)
    ops.element('FourNodeTetrahedron', 11335, *[2375, 2376, 2681, 2540], 1)
    ops.element('FourNodeTetrahedron', 11336, *[1972, 2519, 2079, 2139], 1)
    ops.element('FourNodeTetrahedron', 11337, *[2460, 1959, 1945, 2227], 1)
    ops.element('FourNodeTetrahedron', 11338, *[2123, 2356, 2192, 2194], 1)
    ops.element('FourNodeTetrahedron', 11339, *[2342, 2548, 2344, 2587], 1)
    ops.element('FourNodeTetrahedron', 11340, *[2414, 2618, 1964, 2569], 1)
    ops.element('FourNodeTetrahedron', 11341, *[1804, 2428, 1757, 1758], 1)
    ops.element('FourNodeTetrahedron', 11342, *[2397, 2295, 2683, 2396], 1)
    ops.element('FourNodeTetrahedron', 11343, *[1866, 1763, 1760, 1903], 1)
    ops.element('FourNodeTetrahedron', 11344, *[1953, 2298, 1219, 1121], 1)
    ops.element('FourNodeTetrahedron', 11345, *[2625, 2535, 2210, 2447], 1)
    ops.element('FourNodeTetrahedron', 11346, *[1161, 1779, 1192, 1197], 1)
    ops.element('FourNodeTetrahedron', 11347, *[2663, 1961, 1939, 1941], 1)
    ops.element('FourNodeTetrahedron', 11348, *[2634, 1901, 1862, 1899], 1)
    ops.element('FourNodeTetrahedron', 11349, *[2086, 1899, 2634, 2085], 1)
    ops.element('FourNodeTetrahedron', 11350, *[2210, 2535, 2211, 2447], 1)
    ops.element('FourNodeTetrahedron', 11351, *[2083, 1867, 2332, 1754], 1)
    ops.element('FourNodeTetrahedron', 11352, *[1181, 1883, 634, 2234], 1)
    ops.element('FourNodeTetrahedron', 11353, *[2225, 2226, 2594, 1883], 1)
    ops.element('FourNodeTetrahedron', 11354, *[2351, 2681, 2135, 2435], 1)
    ops.element('FourNodeTetrahedron', 11355, *[2464, 2681, 2351, 2435], 1)
    ops.element('FourNodeTetrahedron', 11356, *[1844, 1981, 2383, 2381], 1)
    ops.element('FourNodeTetrahedron', 11357, *[2578, 2631, 2602, 2420], 1)
    ops.element('FourNodeTetrahedron', 11358, *[1191, 1891, 1190, 1140], 1)
    ops.element('FourNodeTetrahedron', 11359, *[2454, 2352, 2305, 2070], 1)
    ops.element('FourNodeTetrahedron', 11360, *[1857, 2345, 1856, 1858], 1)
    ops.element('FourNodeTetrahedron', 11361, *[2170, 2169, 2368, 2653], 1)
    ops.element('FourNodeTetrahedron', 11362, *[2301, 1924, 1857, 2095], 1)
    ops.element('FourNodeTetrahedron', 11363, *[2095, 2544, 1858, 2300], 1)
    ops.element('FourNodeTetrahedron', 11364, *[2058, 2456, 2059, 2112], 1)
    ops.element('FourNodeTetrahedron', 11365, *[2253, 2625, 1958, 2057], 1)
    ops.element('FourNodeTetrahedron', 11366, *[2430, 2661, 1838, 1839], 1)
    ops.element('FourNodeTetrahedron', 11367, *[2514, 2634, 2555, 2086], 1)
    ops.element('FourNodeTetrahedron', 11368, *[2186, 2184, 2621, 2062], 1)
    ops.element('FourNodeTetrahedron', 11369, *[2489, 1772, 1774, 1834], 1)
    ops.element('FourNodeTetrahedron', 11370, *[2317, 2282, 2002, 2318], 1)
    ops.element('FourNodeTetrahedron', 11371, *[2029, 2367, 2288, 1824], 1)
    ops.element('FourNodeTetrahedron', 11372, *[2631, 2315, 2073, 2071], 1)
    ops.element('FourNodeTetrahedron', 11373, *[2417, 2127, 2027, 2128], 1)
    ops.element('FourNodeTetrahedron', 11374, *[2121, 1837, 2085, 1840], 1)
    ops.element('FourNodeTetrahedron', 11375, *[2425, 2043, 2025, 2632], 1)
    ops.element('FourNodeTetrahedron', 11376, *[1243, 2065, 1122, 1185], 1)
    ops.element('FourNodeTetrahedron', 11377, *[2046, 2475, 1193, 1165], 1)
    ops.element('FourNodeTetrahedron', 11378, *[2190, 2268, 1186, 1797], 1)
    ops.element('FourNodeTetrahedron', 11379, *[1747, 1746, 2214, 2213], 1)
    ops.element('FourNodeTetrahedron', 11380, *[1943, 1796, 1183, 1182], 1)
    ops.element('FourNodeTetrahedron', 11381, *[1898, 1842, 1952, 1955], 1)
    ops.element('FourNodeTetrahedron', 11382, *[2479, 2590, 2560, 2559], 1)
    ops.element('FourNodeTetrahedron', 11383, *[2075, 2077, 2132, 2076], 1)
    ops.element('FourNodeTetrahedron', 11384, *[2020, 2608, 2258, 2638], 1)
    ops.element('FourNodeTetrahedron', 11385, *[2027, 1803, 2026, 2440], 1)
    ops.element('FourNodeTetrahedron', 11386, *[1998, 1997, 1173, 1242], 1)
    ops.element('FourNodeTetrahedron', 11387, *[2059, 2375, 2464, 1994], 1)
    ops.element('FourNodeTetrahedron', 11388, *[2611, 1964, 2430, 2661], 1)
    ops.element('FourNodeTetrahedron', 11389, *[1834, 1774, 2181, 1833], 1)
    ops.element('FourNodeTetrahedron', 11390, *[1760, 1763, 2554, 1880], 1)
    ops.element('FourNodeTetrahedron', 11391, *[1747, 1748, 2213, 1972], 1)
    ops.element('FourNodeTetrahedron', 11392, *[2226, 2592, 2384, 2290], 1)
    ops.element('FourNodeTetrahedron', 11393, *[1784, 1785, 1844, 1980], 1)
    ops.element('FourNodeTetrahedron', 11394, *[2145, 1853, 1208, 1251], 1)
    ops.element('FourNodeTetrahedron', 11395, *[1844, 1785, 2383, 1981], 1)
    ops.element('FourNodeTetrahedron', 11396, *[1855, 1857, 1858, 2498], 1)
    ops.element('FourNodeTetrahedron', 11397, *[2546, 2090, 2400, 2520], 1)
    ops.element('FourNodeTetrahedron', 11398, *[2400, 2520, 2401, 1228], 1)
    ops.element('FourNodeTetrahedron', 11399, *[2400, 2090, 2401, 2520], 1)
    ops.element('FourNodeTetrahedron', 11400, *[2181, 2437, 2182, 2230], 1)
    ops.element('FourNodeTetrahedron', 11401, *[1789, 2665, 2289, 2175], 1)
    ops.element('FourNodeTetrahedron', 11402, *[2257, 2275, 2608, 2258], 1)
    ops.element('FourNodeTetrahedron', 11403, *[2665, 2366, 2289, 2175], 1)
    ops.element('FourNodeTetrahedron', 11404, *[2257, 2608, 2258, 2020], 1)
    ops.element('FourNodeTetrahedron', 11405, *[1124, 2258, 1241, 1226], 1)
    ops.element('FourNodeTetrahedron', 11406, *[2425, 2424, 2491, 2025], 1)
    ops.element('FourNodeTetrahedron', 11407, *[2612, 2565, 2429, 2430], 1)
    ops.element('FourNodeTetrahedron', 11408, *[1226, 2258, 1241, 1178], 1)
    ops.element('FourNodeTetrahedron', 11409, *[1784, 2031, 1885, 1787], 1)
    ops.element('FourNodeTetrahedron', 11410, *[1926, 2031, 1784, 1929], 1)
    ops.element('FourNodeTetrahedron', 11411, *[2175, 2665, 2366, 2232], 1)
    ops.element('FourNodeTetrahedron', 11412, *[2420, 1977, 1978, 2369], 1)
    ops.element('FourNodeTetrahedron', 11413, *[2583, 1920, 2509, 2510], 1)
    ops.element('FourNodeTetrahedron', 11414, *[2502, 2140, 1992, 2452], 1)
    ops.element('FourNodeTetrahedron', 11415, *[1763, 1904, 2554, 1880], 1)
    ops.element('FourNodeTetrahedron', 11416, *[1823, 1791, 1824, 1790], 1)
    ops.element('FourNodeTetrahedron', 11417, *[2048, 1879, 1247, 2009], 1)
    ops.element('FourNodeTetrahedron', 11418, *[2048, 2635, 1879, 2009], 1)
    ops.element('FourNodeTetrahedron', 11419, *[2574, 1888, 1887, 2292], 1)
    ops.element('FourNodeTetrahedron', 11420, *[2574, 2636, 1888, 2292], 1)
    ops.element('FourNodeTetrahedron', 11421, *[1800, 1803, 2310, 2026], 1)
    ops.element('FourNodeTetrahedron', 11422, *[2443, 2365, 1122, 2191], 1)
    ops.element('FourNodeTetrahedron', 11423, *[1152, 2594, 621, 634], 1)
    ops.element('FourNodeTetrahedron', 11424, *[1895, 1896, 1854, 2538], 1)
    ops.element('FourNodeTetrahedron', 11425, *[2089, 2374, 2087, 2373], 1)
    ops.element('FourNodeTetrahedron', 11426, *[2527, 1823, 2030, 2103], 1)
    ops.element('FourNodeTetrahedron', 11427, *[1953, 1219, 1218, 1121], 1)
    ops.element('FourNodeTetrahedron', 11428, *[2608, 2458, 2457, 2638], 1)
    ops.element('FourNodeTetrahedron', 11429, *[1256, 1953, 1218, 1121], 1)
    ops.element('FourNodeTetrahedron', 11430, *[1974, 1975, 1860, 1859], 1)
    ops.element('FourNodeTetrahedron', 11431, *[2411, 2542, 2543, 2676], 1)
    ops.element('FourNodeTetrahedron', 11432, *[2410, 2543, 1216, 612], 1)
    ops.element('FourNodeTetrahedron', 11433, *[1156, 2410, 1216, 612], 1)
    ops.element('FourNodeTetrahedron', 11434, *[2410, 2542, 1216, 2543], 1)
    ops.element('FourNodeTetrahedron', 11435, *[2243, 2500, 2274, 2403], 1)
    ops.element('FourNodeTetrahedron', 11436, *[2403, 2274, 2626, 2499], 1)
    ops.element('FourNodeTetrahedron', 11437, *[1963, 2566, 2175, 1962], 1)
    ops.element('FourNodeTetrahedron', 11438, *[1151, 1998, 1242, 1206], 1)
    ops.element('FourNodeTetrahedron', 11439, *[1902, 2232, 1900, 2233], 1)
    ops.element('FourNodeTetrahedron', 11440, *[2229, 1210, 1209, 2120], 1)
    ops.element('FourNodeTetrahedron', 11441, *[2497, 2542, 1216, 2410], 1)
    ops.element('FourNodeTetrahedron', 11442, *[2247, 1767, 2149, 2264], 1)
    ops.element('FourNodeTetrahedron', 11443, *[2244, 2481, 2480, 2252], 1)
    ops.element('FourNodeTetrahedron', 11444, *[2424, 2673, 1800, 2418], 1)
    ops.element('FourNodeTetrahedron', 11445, *[1899, 2564, 1950, 2606], 1)
    ops.element('FourNodeTetrahedron', 11446, *[2002, 2675, 2279, 2341], 1)
    ops.element('FourNodeTetrahedron', 11447, *[2224, 2675, 2077, 2002], 1)
    ops.element('FourNodeTetrahedron', 11448, *[2673, 2633, 1800, 2418], 1)
    ops.element('FourNodeTetrahedron', 11449, *[2431, 2500, 2243, 2403], 1)
    ops.element('FourNodeTetrahedron', 11450, *[1773, 2666, 2671, 2364], 1)
    ops.element('FourNodeTetrahedron', 11451, *[2364, 2666, 2671, 2642], 1)
    ops.element('FourNodeTetrahedron', 11452, *[2364, 2642, 2671, 2546], 1)
    ops.element('FourNodeTetrahedron', 11453, *[1224, 2098, 177, 1149], 1)
    ops.element('FourNodeTetrahedron', 11454, *[1836, 2220, 2229, 1935], 1)
    ops.element('FourNodeTetrahedron', 11455, *[2312, 2363, 1772, 2310], 1)
    ops.element('FourNodeTetrahedron', 11456, *[2294, 2565, 2272, 2429], 1)
    ops.element('FourNodeTetrahedron', 11457, *[2312, 2311, 2363, 2310], 1)
    ops.element('FourNodeTetrahedron', 11458, *[1154, 2349, 1196, 2348], 1)
    ops.element('FourNodeTetrahedron', 11459, *[1154, 2349, 1138, 1196], 1)
    ops.element('FourNodeTetrahedron', 11460, *[733, 2463, 731, 1151], 1)
    ops.element('FourNodeTetrahedron', 11461, *[2459, 2066, 1759, 2266], 1)
    ops.element('FourNodeTetrahedron', 11462, *[1757, 2428, 1756, 1758], 1)
    ops.element('FourNodeTetrahedron', 11463, *[2505, 1233, 1188, 1799], 1)
    ops.element('FourNodeTetrahedron', 11464, *[1829, 2110, 2464, 2376], 1)
    ops.element('FourNodeTetrahedron', 11465, *[1914, 2639, 2200, 1915], 1)
    ops.element('FourNodeTetrahedron', 11466, *[1961, 1786, 1960, 1844], 1)
    ops.element('FourNodeTetrahedron', 11467, *[1844, 1786, 1843, 1785], 1)
    ops.element('FourNodeTetrahedron', 11468, *[2175, 2366, 2176, 2232], 1)
    ops.element('FourNodeTetrahedron', 11469, *[2093, 2322, 1806, 2186], 1)
    ops.element('FourNodeTetrahedron', 11470, *[2030, 1822, 2028, 1824], 1)
    ops.element('FourNodeTetrahedron', 11471, *[1823, 1788, 1790, 1875], 1)
    ops.element('FourNodeTetrahedron', 11472, *[2249, 1769, 1771, 1958], 1)
    ops.element('FourNodeTetrahedron', 11473, *[1894, 2521, 2607, 1780], 1)
    ops.element('FourNodeTetrahedron', 11474, *[2230, 2546, 2400, 2568], 1)
    ops.element('FourNodeTetrahedron', 11475, *[2269, 2270, 1991, 2624], 1)
    ops.element('FourNodeTetrahedron', 11476, *[2028, 2367, 2029, 1824], 1)
    ops.element('FourNodeTetrahedron', 11477, *[2622, 2503, 2505, 2268], 1)
    ops.element('FourNodeTetrahedron', 11478, *[2621, 2356, 2241, 2123], 1)
    ops.element('FourNodeTetrahedron', 11479, *[2098, 2336, 2099, 2250], 1)
    ops.element('FourNodeTetrahedron', 11480, *[2393, 2276, 1805, 1807], 1)
    ops.element('FourNodeTetrahedron', 11481, *[2095, 2060, 2506, 2155], 1)
    ops.element('FourNodeTetrahedron', 11482, *[1784, 2044, 1786, 1787], 1)
    ops.element('FourNodeTetrahedron', 11483, *[2602, 2631, 2073, 2072], 1)
    ops.element('FourNodeTetrahedron', 11484, *[2381, 2631, 2073, 2602], 1)
    ops.element('FourNodeTetrahedron', 11485, *[2020, 2638, 2258, 2359], 1)
    ops.element('FourNodeTetrahedron', 11486, *[2229, 2568, 1210, 1810], 1)
    ops.element('FourNodeTetrahedron', 11487, *[2482, 1832, 2111, 2588], 1)
    ops.element('FourNodeTetrahedron', 11488, *[2592, 2512, 2349, 2347], 1)
    ops.element('FourNodeTetrahedron', 11489, *[2479, 2495, 1158, 511], 1)
    ops.element('FourNodeTetrahedron', 11490, *[2184, 2428, 2468, 2185], 1)
    ops.element('FourNodeTetrahedron', 11491, *[2016, 2638, 2359, 2395], 1)
    ops.element('FourNodeTetrahedron', 11492, *[2555, 2634, 2334, 2085], 1)
    ops.element('FourNodeTetrahedron', 11493, *[1807, 2428, 1804, 2184], 1)
    ops.element('FourNodeTetrahedron', 11494, *[1236, 1870, 1244, 1753], 1)
    ops.element('FourNodeTetrahedron', 11495, *[2332, 2243, 2533, 2385], 1)
    ops.element('FourNodeTetrahedron', 11496, *[1896, 2530, 2157, 2159], 1)
    ops.element('FourNodeTetrahedron', 11497, *[1764, 1855, 2579, 2513], 1)
    ops.element('FourNodeTetrahedron', 11498, *[1883, 2594, 1152, 634], 1)
    ops.element('FourNodeTetrahedron', 11499, *[1208, 2616, 1214, 1204], 1)
    ops.element('FourNodeTetrahedron', 11500, *[2578, 2531, 2129, 2150], 1)
    ops.element('FourNodeTetrahedron', 11501, *[1177, 2617, 1137, 1176], 1)
    ops.element('FourNodeTetrahedron', 11502, *[2465, 2197, 2196, 2195], 1)
    ops.element('FourNodeTetrahedron', 11503, *[2616, 2562, 1214, 1130], 1)
    ops.element('FourNodeTetrahedron', 11504, *[1134, 1781, 1258, 1246], 1)
    ops.element('FourNodeTetrahedron', 11505, *[2236, 1781, 1134, 1246], 1)
    ops.element('FourNodeTetrahedron', 11506, *[1134, 1781, 1169, 1258], 1)
    ops.element('FourNodeTetrahedron', 11507, *[2428, 2468, 2096, 2184], 1)
    ops.element('FourNodeTetrahedron', 11508, *[2191, 2267, 1797, 1944], 1)
    ops.element('FourNodeTetrahedron', 11509, *[2043, 2418, 2027, 2417], 1)
    ops.element('FourNodeTetrahedron', 11510, *[1204, 2616, 1214, 1130], 1)
    ops.element('FourNodeTetrahedron', 11511, *[1214, 2120, 2562, 2616], 1)
    ops.element('FourNodeTetrahedron', 11512, *[2596, 2382, 2381, 2531], 1)
    ops.element('FourNodeTetrahedron', 11513, *[1981, 2382, 2381, 2596], 1)
    ops.element('FourNodeTetrahedron', 11514, *[2628, 2649, 2615, 2633], 1)
    ops.element('FourNodeTetrahedron', 11515, *[1856, 2388, 2529, 1858], 1)
    ops.element('FourNodeTetrahedron', 11516, *[2221, 2485, 2008, 2192], 1)
    ops.element('FourNodeTetrahedron', 11517, *[1228, 2520, 2401, 1809], 1)
    ops.element('FourNodeTetrahedron', 11518, *[2555, 2086, 2634, 2085], 1)
    ops.element('FourNodeTetrahedron', 11519, *[1877, 1791, 1788, 2567], 1)
    ops.element('FourNodeTetrahedron', 11520, *[652, 2084, 1212, 653], 1)
    ops.element('FourNodeTetrahedron', 11521, *[2600, 2425, 2261, 2632], 1)
    ops.element('FourNodeTetrahedron', 11522, *[2607, 1761, 748, 1988], 1)
    ops.element('FourNodeTetrahedron', 11523, *[1169, 1988, 748, 1213], 1)
    ops.element('FourNodeTetrahedron', 11524, *[2048, 2049, 2009, 2298], 1)
    ops.element('FourNodeTetrahedron', 11525, *[2344, 2587, 1850, 1795], 1)
    ops.element('FourNodeTetrahedron', 11526, *[1129, 1903, 1153, 1217], 1)
    ops.element('FourNodeTetrahedron', 11527, *[1949, 1852, 2120, 2616], 1)
    ops.element('FourNodeTetrahedron', 11528, *[1896, 2470, 2159, 2173], 1)
    ops.element('FourNodeTetrahedron', 11529, *[1242, 1835, 723, 1147], 1)
    ops.element('FourNodeTetrahedron', 11530, *[1750, 2229, 1127, 1949], 1)
    ops.element('FourNodeTetrahedron', 11531, *[2357, 1981, 2238, 2438], 1)
    ops.element('FourNodeTetrahedron', 11532, *[512, 2171, 1150, 1229], 1)
    ops.element('FourNodeTetrahedron', 11533, *[1130, 1975, 2537, 1191], 1)
    ops.element('FourNodeTetrahedron', 11534, *[1206, 2409, 1750, 1202], 1)
    ops.element('FourNodeTetrahedron', 11535, *[1206, 1750, 1127, 1202], 1)
    ops.element('FourNodeTetrahedron', 11536, *[2514, 2086, 2555, 2121], 1)
    ops.element('FourNodeTetrahedron', 11537, *[2420, 2129, 2072, 1976], 1)
    ops.element('FourNodeTetrahedron', 11538, *[2542, 606, 1216, 2543], 1)
    ops.element('FourNodeTetrahedron', 11539, *[2542, 2558, 606, 2543], 1)
    ops.element('FourNodeTetrahedron', 11540, *[2308, 2533, 1848, 1849], 1)
    ops.element('FourNodeTetrahedron', 11541, *[2026, 1934, 1935, 2440], 1)
    ops.element('FourNodeTetrahedron', 11542, *[2400, 2520, 1228, 1810], 1)
    ops.element('FourNodeTetrahedron', 11543, *[2087, 2165, 2166, 2167], 1)
    ops.element('FourNodeTetrahedron', 11544, *[2471, 1804, 1757, 1806], 1)
    ops.element('FourNodeTetrahedron', 11545, *[2087, 2461, 2165, 2167], 1)
    ops.element('FourNodeTetrahedron', 11546, *[2003, 2244, 2245, 2001], 1)
    ops.element('FourNodeTetrahedron', 11547, *[2450, 2507, 2348, 2451], 1)
    ops.element('FourNodeTetrahedron', 11548, *[1217, 1880, 1139, 2048], 1)
    ops.element('FourNodeTetrahedron', 11549, *[684, 2368, 2118, 2653], 1)
    ops.element('FourNodeTetrahedron', 11550, *[2471, 2434, 2641, 2640], 1)
    ops.element('FourNodeTetrahedron', 11551, *[2458, 2067, 2442, 1759], 1)
    ops.element('FourNodeTetrahedron', 11552, *[2506, 2488, 2676, 2492], 1)
    ops.element('FourNodeTetrahedron', 11553, *[2448, 1805, 2390, 2322], 1)
    ops.element('FourNodeTetrahedron', 11554, *[1857, 2095, 1858, 2300], 1)
    ops.element('FourNodeTetrahedron', 11555, *[2152, 2426, 2004, 2360], 1)
    ops.element('FourNodeTetrahedron', 11556, *[1912, 2390, 2094, 2093], 1)
    ops.element('FourNodeTetrahedron', 11557, *[1129, 1952, 1217, 1218], 1)
    ops.element('FourNodeTetrahedron', 11558, *[1823, 1788, 1791, 1790], 1)
    ops.element('FourNodeTetrahedron', 11559, *[2093, 2390, 2094, 2061], 1)
    ops.element('FourNodeTetrahedron', 11560, *[2072, 2074, 1223, 1870], 1)
    ops.element('FourNodeTetrahedron', 11561, *[2353, 2355, 2304, 2352], 1)
    ops.element('FourNodeTetrahedron', 11562, *[1897, 2146, 1854, 1896], 1)
    ops.element('FourNodeTetrahedron', 11563, *[1888, 1765, 1889, 1886], 1)
    ops.element('FourNodeTetrahedron', 11564, *[1889, 1766, 1767, 1765], 1)
    ops.element('FourNodeTetrahedron', 11565, *[2074, 1869, 1234, 1235], 1)
    ops.element('FourNodeTetrahedron', 11566, *[1223, 2074, 1235, 1870], 1)
    ops.element('FourNodeTetrahedron', 11567, *[2514, 2174, 2634, 2086], 1)
    ops.element('FourNodeTetrahedron', 11568, *[2396, 1780, 1134, 2236], 1)
    ops.element('FourNodeTetrahedron', 11569, *[1865, 1863, 2541, 1864], 1)
    ops.element('FourNodeTetrahedron', 11570, *[1952, 1903, 2048, 1954], 1)
    ops.element('FourNodeTetrahedron', 11571, *[2247, 1889, 2264, 2012], 1)
    ops.element('FourNodeTetrahedron', 11572, *[1930, 1999, 2562, 2284], 1)
    ops.element('FourNodeTetrahedron', 11573, *[2388, 2240, 2538, 2682], 1)
    ops.element('FourNodeTetrahedron', 11574, *[2339, 1970, 2138, 2387], 1)
    ops.element('FourNodeTetrahedron', 11575, *[2669, 1820, 1905, 1819], 1)
    ops.element('FourNodeTetrahedron', 11576, *[1959, 1887, 1945, 2014], 1)
    ops.element('FourNodeTetrahedron', 11577, *[2485, 2484, 2483, 2630], 1)
    ops.element('FourNodeTetrahedron', 11578, *[2424, 2312, 2491, 1800], 1)
    ops.element('FourNodeTetrahedron', 11579, *[2167, 2660, 2134, 2135], 1)
    ops.element('FourNodeTetrahedron', 11580, *[2056, 2038, 2055, 2035], 1)
    ops.element('FourNodeTetrahedron', 11581, *[2445, 2593, 1871, 1873], 1)
    ops.element('FourNodeTetrahedron', 11582, *[1947, 2575, 2277, 2445], 1)
    ops.element('FourNodeTetrahedron', 11583, *[2659, 2476, 2276, 2277], 1)
    ops.element('FourNodeTetrahedron', 11584, *[1162, 1808, 2046, 1879], 1)
    ops.element('FourNodeTetrahedron', 11585, *[1821, 2657, 2070, 2069], 1)
    ops.element('FourNodeTetrahedron', 11586, *[1820, 2657, 1821, 2320], 1)
    ops.element('FourNodeTetrahedron', 11587, *[1144, 1821, 1174, 1200], 1)
    ops.element('FourNodeTetrahedron', 11588, *[2186, 2062, 2061, 2155], 1)
    ops.element('FourNodeTetrahedron', 11589, *[2078, 1179, 1248, 1132], 1)
    ops.element('FourNodeTetrahedron', 11590, *[1235, 2078, 1248, 1132], 1)
    ops.element('FourNodeTetrahedron', 11591, *[2085, 1899, 1916, 1838], 1)
    ops.element('FourNodeTetrahedron', 11592, *[1838, 1899, 1916, 2564], 1)
    ops.element('FourNodeTetrahedron', 11593, *[2647, 2340, 2338, 2478], 1)
    ops.element('FourNodeTetrahedron', 11594, *[2017, 1770, 2638, 2563], 1)
    ops.element('FourNodeTetrahedron', 11595, *[1844, 1785, 1843, 2383], 1)
    ops.element('FourNodeTetrahedron', 11596, *[2016, 2017, 2395, 2019], 1)
    ops.element('FourNodeTetrahedron', 11597, *[2380, 2657, 2454, 2070], 1)
    ops.element('FourNodeTetrahedron', 11598, *[2380, 2454, 2305, 2070], 1)
    ops.element('FourNodeTetrahedron', 11599, *[2406, 2494, 1974, 2242], 1)
    ops.element('FourNodeTetrahedron', 11600, *[2647, 2338, 2561, 2337], 1)
    ops.element('FourNodeTetrahedron', 11601, *[1228, 1809, 1141, 1811], 1)
    ops.element('FourNodeTetrahedron', 11602, *[1998, 1750, 1242, 1206], 1)
    ops.element('FourNodeTetrahedron', 11603, *[1943, 2014, 2556, 2225], 1)
    ops.element('FourNodeTetrahedron', 11604, *[1756, 2527, 2112, 1755], 1)
    ops.element('FourNodeTetrahedron', 11605, *[2167, 2164, 2166, 1157], 1)
    ops.element('FourNodeTetrahedron', 11606, *[1942, 1945, 1943, 2227], 1)
    ops.element('FourNodeTetrahedron', 11607, *[2076, 2245, 1868, 2004], 1)
    ops.element('FourNodeTetrahedron', 11608, *[2107, 2168, 2026, 1852], 1)
    ops.element('FourNodeTetrahedron', 11609, *[2422, 2168, 2107, 1852], 1)
    ops.element('FourNodeTetrahedron', 11610, *[2151, 2224, 2077, 2002], 1)
    ops.element('FourNodeTetrahedron', 11611, *[1978, 1977, 1753, 2614], 1)
    ops.element('FourNodeTetrahedron', 11612, *[2570, 2035, 1747, 1970], 1)
    ops.element('FourNodeTetrahedron', 11613, *[2682, 2240, 2406, 2242], 1)
    ops.element('FourNodeTetrahedron', 11614, *[2682, 2406, 1974, 2242], 1)
    ops.element('FourNodeTetrahedron', 11615, *[2260, 2491, 1772, 1836], 1)
    ops.element('FourNodeTetrahedron', 11616, *[1258, 1898, 1129, 1221], 1)
    ops.element('FourNodeTetrahedron', 11617, *[1139, 1879, 1163, 1247], 1)
    ops.element('FourNodeTetrahedron', 11618, *[1139, 1879, 1247, 2048], 1)
    ops.element('FourNodeTetrahedron', 11619, *[2626, 2054, 2153, 1848], 1)
    ops.element('FourNodeTetrahedron', 11620, *[2274, 2664, 2253, 2499], 1)
    ops.element('FourNodeTetrahedron', 11621, *[1230, 1818, 1200, 1189], 1)
    ops.element('FourNodeTetrahedron', 11622, *[2352, 2355, 2304, 2391], 1)
    ops.element('FourNodeTetrahedron', 11623, *[2352, 2304, 2463, 1998], 1)
    ops.element('FourNodeTetrahedron', 11624, *[2129, 2132, 2071, 1868], 1)
    ops.element('FourNodeTetrahedron', 11625, *[1192, 2024, 1142, 1197], 1)
    ops.element('FourNodeTetrahedron', 11626, *[2575, 2277, 1946, 1947], 1)
    ops.element('FourNodeTetrahedron', 11627, *[1167, 2614, 1145, 1254], 1)
    ops.element('FourNodeTetrahedron', 11628, *[1257, 1978, 1145, 2614], 1)
    ops.element('FourNodeTetrahedron', 11629, *[1257, 2614, 1145, 1167], 1)
    ops.element('FourNodeTetrahedron', 11630, *[2219, 2546, 2520, 1810], 1)
    ops.element('FourNodeTetrahedron', 11631, *[2219, 2642, 2546, 2088], 1)
    ops.element('FourNodeTetrahedron', 11632, *[1999, 2435, 2133, 2098], 1)
    ops.element('FourNodeTetrahedron', 11633, *[1862, 1951, 2262, 1950], 1)
    ops.element('FourNodeTetrahedron', 11634, *[1949, 1935, 2120, 1852], 1)
    ops.element('FourNodeTetrahedron', 11635, *[1210, 1810, 1211, 2120], 1)
    ops.element('FourNodeTetrahedron', 11636, *[1209, 1211, 1210, 2120], 1)
    ops.element('FourNodeTetrahedron', 11637, *[2595, 2442, 1245, 1241], 1)
    ops.element('FourNodeTetrahedron', 11638, *[1953, 2298, 1121, 2074], 1)
    ops.element('FourNodeTetrahedron', 11639, *[1182, 2556, 1194, 1152], 1)
    ops.element('FourNodeTetrahedron', 11640, *[2225, 2556, 1182, 1152], 1)
    ops.element('FourNodeTetrahedron', 11641, *[2348, 2410, 611, 2451], 1)
    ops.element('FourNodeTetrahedron', 11642, *[2350, 2411, 2410, 2451], 1)
    ops.element('FourNodeTetrahedron', 11643, *[2349, 2350, 2412, 2348], 1)
    ops.element('FourNodeTetrahedron', 11644, *[2349, 2412, 1196, 2348], 1)
    ops.element('FourNodeTetrahedron', 11645, *[2349, 2412, 1138, 1196], 1)
    ops.element('FourNodeTetrahedron', 11646, *[2604, 2510, 2605, 2507], 1)
    ops.element('FourNodeTetrahedron', 11647, *[2347, 2509, 2350, 2605], 1)
    ops.element('FourNodeTetrahedron', 11648, *[2347, 2350, 2348, 2507], 1)
    ops.element('FourNodeTetrahedron', 11649, *[2347, 2509, 2605, 2604], 1)
    ops.element('FourNodeTetrahedron', 11650, *[2084, 1849, 653, 652], 1)
    ops.element('FourNodeTetrahedron', 11651, *[1752, 2332, 2084, 1849], 1)
    ops.element('FourNodeTetrahedron', 11652, *[1769, 1959, 2227, 1956], 1)
    ops.element('FourNodeTetrahedron', 11653, *[1992, 2150, 2525, 2152], 1)
    ops.element('FourNodeTetrahedron', 11654, *[1859, 2467, 1232, 2202], 1)
    ops.element('FourNodeTetrahedron', 11655, *[1752, 1849, 2084, 652], 1)
    ops.element('FourNodeTetrahedron', 11656, *[1940, 1939, 2571, 1938], 1)
    ops.element('FourNodeTetrahedron', 11657, *[1752, 2084, 1160, 652], 1)
    ops.element('FourNodeTetrahedron', 11658, *[1752, 652, 1160, 651], 1)
    ops.element('FourNodeTetrahedron', 11659, *[1786, 1843, 1960, 1844], 1)
    ops.element('FourNodeTetrahedron', 11660, *[1784, 1786, 1844, 1785], 1)
    ops.element('FourNodeTetrahedron', 11661, *[1784, 1786, 1961, 1844], 1)
    ops.element('FourNodeTetrahedron', 11662, *[2194, 2193, 2203, 2371], 1)
    ops.element('FourNodeTetrahedron', 11663, *[1928, 1884, 2265, 1941], 1)
    ops.element('FourNodeTetrahedron', 11664, *[666, 2259, 1254, 650], 1)
    ops.element('FourNodeTetrahedron', 11665, *[2546, 2520, 2400, 1810], 1)
    ops.element('FourNodeTetrahedron', 11666, *[2571, 2521, 1894, 1780], 1)
    ops.element('FourNodeTetrahedron', 11667, *[1754, 2332, 1752, 2361], 1)
    ops.element('FourNodeTetrahedron', 11668, *[1784, 1885, 2044, 1787], 1)
    ops.element('FourNodeTetrahedron', 11669, *[1884, 2651, 2524, 2044], 1)
    ops.element('FourNodeTetrahedron', 11670, *[1917, 1916, 1915, 2474], 1)
    ops.element('FourNodeTetrahedron', 11671, *[1184, 1937, 1240, 1195], 1)
    ops.element('FourNodeTetrahedron', 11672, *[1919, 1909, 1924, 1908], 1)
    ops.element('FourNodeTetrahedron', 11673, *[1762, 2399, 1761, 1763], 1)
    ops.element('FourNodeTetrahedron', 11674, *[1928, 2162, 1884, 1926], 1)
    ops.element('FourNodeTetrahedron', 11675, *[2204, 2242, 2007, 2203], 1)
    ops.element('FourNodeTetrahedron', 11676, *[1928, 2162, 2265, 1884], 1)
    ops.element('FourNodeTetrahedron', 11677, *[2162, 2663, 2265, 1884], 1)
    ops.element('FourNodeTetrahedron', 11678, *[2162, 2161, 2663, 1884], 1)
    ops.element('FourNodeTetrahedron', 11679, *[2502, 1992, 2525, 2453], 1)
    ops.element('FourNodeTetrahedron', 11680, *[2655, 1890, 1865, 2634], 1)
    ops.element('FourNodeTetrahedron', 11681, *[2413, 2080, 2151, 2379], 1)
    ops.element('FourNodeTetrahedron', 11682, *[2148, 1897, 2144, 2579], 1)
    ops.element('FourNodeTetrahedron', 11683, *[1931, 2058, 1932, 1994], 1)
    ops.element('FourNodeTetrahedron', 11684, *[2271, 2296, 2224, 2317], 1)
    ops.element('FourNodeTetrahedron', 11685, *[1851, 1930, 2616, 1860], 1)
    ops.element('FourNodeTetrahedron', 11686, *[1208, 1853, 2616, 1204], 1)
    ops.element('FourNodeTetrahedron', 11687, *[1866, 1903, 1129, 1952], 1)
    ops.element('FourNodeTetrahedron', 11688, *[2592, 2604, 2347, 2450], 1)
    ops.element('FourNodeTetrahedron', 11689, *[2450, 2347, 2507, 2604], 1)
    ops.element('FourNodeTetrahedron', 11690, *[2347, 2507, 2348, 2450], 1)
    ops.element('FourNodeTetrahedron', 11691, *[2219, 2088, 2520, 2000], 1)
    ops.element('FourNodeTetrahedron', 11692, *[1946, 2186, 2093, 1948], 1)
    ops.element('FourNodeTetrahedron', 11693, *[2621, 2294, 2356, 2612], 1)
    ops.element('FourNodeTetrahedron', 11694, *[1892, 2619, 1249, 1923], 1)
    ops.element('FourNodeTetrahedron', 11695, *[512, 2171, 1229, 2479], 1)
    ops.element('FourNodeTetrahedron', 11696, *[1229, 2171, 1146, 2170], 1)
    ops.element('FourNodeTetrahedron', 11697, *[2479, 2170, 1229, 1158], 1)
    ops.element('FourNodeTetrahedron', 11698, *[2479, 2171, 1229, 2170], 1)
    ops.element('FourNodeTetrahedron', 11699, *[1811, 2135, 1809, 2133], 1)
    ops.element('FourNodeTetrahedron', 11700, *[2137, 738, 737, 2011], 1)
    ops.element('FourNodeTetrahedron', 11701, *[2221, 2485, 1973, 2008], 1)
    ops.element('FourNodeTetrahedron', 11702, *[1959, 2014, 1945, 2227], 1)
    ops.element('FourNodeTetrahedron', 11703, *[1941, 1961, 2114, 1844], 1)
    ops.element('FourNodeTetrahedron', 11704, *[2108, 2372, 2373, 2109], 1)
    ops.element('FourNodeTetrahedron', 11705, *[723, 2182, 728, 2235], 1)
    ops.element('FourNodeTetrahedron', 11706, *[1908, 1946, 2093, 1948], 1)
    ops.element('FourNodeTetrahedron', 11707, *[737, 2011, 738, 1171], 1)
    ops.element('FourNodeTetrahedron', 11708, *[2008, 2555, 2630, 1917], 1)
    ops.element('FourNodeTetrahedron', 11709, *[2628, 2673, 2615, 2633], 1)
    ops.element('FourNodeTetrahedron', 11710, *[2481, 2249, 2248, 2480], 1)
    ops.element('FourNodeTetrahedron', 11711, *[1781, 1762, 1988, 1866], 1)
    ops.element('FourNodeTetrahedron', 11712, *[1781, 1762, 1866, 1842], 1)
    ops.element('FourNodeTetrahedron', 11713, *[2048, 2635, 2009, 2049], 1)
    ops.element('FourNodeTetrahedron', 11714, *[2189, 2340, 2647, 2478], 1)
    ops.element('FourNodeTetrahedron', 11715, *[2159, 2641, 2160, 2173], 1)
    ops.element('FourNodeTetrahedron', 11716, *[2625, 2210, 2053, 2447], 1)
    ops.element('FourNodeTetrahedron', 11717, *[2456, 2423, 2030, 1967], 1)
    ops.element('FourNodeTetrahedron', 11718, *[2480, 2249, 2248, 1958], 1)
    ops.element('FourNodeTetrahedron', 11719, *[2562, 1936, 1999, 1930], 1)
    ops.element('FourNodeTetrahedron', 11720, *[1933, 1936, 2562, 1930], 1)
    ops.element('FourNodeTetrahedron', 11721, *[1190, 2250, 178, 2216], 1)
    ops.element('FourNodeTetrahedron', 11722, *[2255, 2465, 2250, 2251], 1)
    ops.element('FourNodeTetrahedron', 11723, *[1892, 2522, 1923, 2523], 1)
    ops.element('FourNodeTetrahedron', 11724, *[2046, 2045, 2047, 2475], 1)
    ops.element('FourNodeTetrahedron', 11725, *[2653, 2369, 2118, 2656], 1)
    ops.element('FourNodeTetrahedron', 11726, *[2167, 2165, 175, 2134], 1)
    ops.element('FourNodeTetrahedron', 11727, *[2168, 2027, 2440, 2125], 1)
    ops.element('FourNodeTetrahedron', 11728, *[1939, 2472, 2571, 2114], 1)
    ops.element('FourNodeTetrahedron', 11729, *[2496, 2529, 2497, 2411], 1)
    ops.element('FourNodeTetrahedron', 11730, *[2144, 1895, 2142, 2579], 1)
    ops.element('FourNodeTetrahedron', 11731, *[1861, 1860, 1204, 1215], 1)
    ops.element('FourNodeTetrahedron', 11732, *[1135, 1861, 1204, 1215], 1)
    ops.element('FourNodeTetrahedron', 11733, *[733, 2304, 2463, 1199], 1)
    ops.element('FourNodeTetrahedron', 11734, *[1241, 2442, 1759, 2457], 1)
    ops.element('FourNodeTetrahedron', 11735, *[1986, 1924, 1857, 2301], 1)
    ops.element('FourNodeTetrahedron', 11736, *[1137, 2225, 1152, 1181], 1)
    ops.element('FourNodeTetrahedron', 11737, *[1867, 2019, 2078, 2308], 1)
    ops.element('FourNodeTetrahedron', 11738, *[1770, 2460, 1768, 1769], 1)
    ops.element('FourNodeTetrahedron', 11739, *[1836, 2230, 1835, 2229], 1)
    ops.element('FourNodeTetrahedron', 11740, *[1771, 1769, 1768, 1956], 1)
    ops.element('FourNodeTetrahedron', 11741, *[1835, 2229, 1147, 1750], 1)
    ops.element('FourNodeTetrahedron', 11742, *[2009, 2258, 1124, 1226], 1)
    ops.element('FourNodeTetrahedron', 11743, *[1971, 2519, 2139, 2344], 1)
    ops.element('FourNodeTetrahedron', 11744, *[2372, 2374, 2373, 2109], 1)
    ops.element('FourNodeTetrahedron', 11745, *[2453, 2369, 2653, 2656], 1)
    ops.element('FourNodeTetrahedron', 11746, *[2433, 1756, 2112, 1755], 1)
    ops.element('FourNodeTetrahedron', 11747, *[2419, 2256, 1225, 1180], 1)
    ops.element('FourNodeTetrahedron', 11748, *[2027, 2127, 2125, 2128], 1)
    ops.element('FourNodeTetrahedron', 11749, *[2074, 2071, 1869, 1870], 1)
    ops.element('FourNodeTetrahedron', 11750, *[2083, 1867, 2078, 2308], 1)
    ops.element('FourNodeTetrahedron', 11751, *[2633, 2329, 2311, 2331], 1)
    ops.element('FourNodeTetrahedron', 11752, *[1867, 2245, 2332, 1754], 1)
    ops.element('FourNodeTetrahedron', 11753, *[2311, 2329, 2330, 2331], 1)
    ops.element('FourNodeTetrahedron', 11754, *[2311, 2329, 2674, 2330], 1)
    ops.element('FourNodeTetrahedron', 11755, *[2311, 2674, 2666, 2330], 1)
    ops.element('FourNodeTetrahedron', 11756, *[2311, 2330, 2642, 2331], 1)
    ops.element('FourNodeTetrahedron', 11757, *[2299, 2011, 1171, 1905], 1)
    ops.element('FourNodeTetrahedron', 11758, *[1191, 2255, 1149, 1190], 1)
    ops.element('FourNodeTetrahedron', 11759, *[2430, 2233, 2086, 1838], 1)
    ops.element('FourNodeTetrahedron', 11760, *[1943, 2246, 2267, 2015], 1)
    ops.element('FourNodeTetrahedron', 11761, *[2246, 2247, 2267, 2015], 1)
    ops.element('FourNodeTetrahedron', 11762, *[2086, 2233, 1902, 1838], 1)
    ops.element('FourNodeTetrahedron', 11763, *[2064, 2218, 419, 1238], 1)
    ops.element('FourNodeTetrahedron', 11764, *[2086, 2231, 1902, 2233], 1)
    ops.element('FourNodeTetrahedron', 11765, *[2064, 146, 419, 1238], 1)
    ops.element('FourNodeTetrahedron', 11766, *[1779, 1777, 2022, 1778], 1)
    ops.element('FourNodeTetrahedron', 11767, *[2413, 2080, 2531, 2151], 1)
    ops.element('FourNodeTetrahedron', 11768, *[2302, 2300, 2506, 2303], 1)
    ops.element('FourNodeTetrahedron', 11769, *[2152, 2002, 2426, 2318], 1)
    ops.element('FourNodeTetrahedron', 11770, *[2003, 2001, 2245, 2004], 1)
    ops.element('FourNodeTetrahedron', 11771, *[2677, 2434, 2641, 2471], 1)
    ops.element('FourNodeTetrahedron', 11772, *[2174, 2231, 1902, 2086], 1)
    ops.element('FourNodeTetrahedron', 11773, *[2075, 2132, 2129, 2076], 1)
    ops.element('FourNodeTetrahedron', 11774, *[2471, 1757, 2434, 2640], 1)
    ops.element('FourNodeTetrahedron', 11775, *[1893, 1988, 1169, 1780], 1)
    ops.element('FourNodeTetrahedron', 11776, *[2596, 2413, 2577, 2560], 1)
    ops.element('FourNodeTetrahedron', 11777, *[2173, 2641, 2240, 2389], 1)
    ops.element('FourNodeTetrahedron', 11778, *[2420, 1976, 2072, 1978], 1)
    ops.element('FourNodeTetrahedron', 11779, *[2560, 2413, 2596, 2338], 1)
    ops.element('FourNodeTetrahedron', 11780, *[2303, 2095, 2300, 2506], 1)
    ops.element('FourNodeTetrahedron', 11781, *[2338, 2413, 2560, 2502], 1)
    ops.element('FourNodeTetrahedron', 11782, *[2125, 2091, 1830, 2441], 1)
    ops.element('FourNodeTetrahedron', 11783, *[2615, 2649, 2648, 2633], 1)
    ops.element('FourNodeTetrahedron', 11784, *[2309, 2484, 2306, 1973], 1)
    ops.element('FourNodeTetrahedron', 11785, *[2078, 2395, 1179, 2308], 1)
    ops.element('FourNodeTetrahedron', 11786, *[2308, 2321, 1176, 1148], 1)
    ops.element('FourNodeTetrahedron', 11787, *[1179, 2308, 1176, 1148], 1)
    ops.element('FourNodeTetrahedron', 11788, *[1179, 2308, 1148, 1212], 1)
    ops.element('FourNodeTetrahedron', 11789, *[1132, 2078, 1179, 2308], 1)
    ops.element('FourNodeTetrahedron', 11790, *[2393, 1807, 2322, 2277], 1)
    ops.element('FourNodeTetrahedron', 11791, *[2440, 1830, 1932, 2125], 1)
    ops.element('FourNodeTetrahedron', 11792, *[2683, 1894, 1159, 2396], 1)
    ops.element('FourNodeTetrahedron', 11793, *[1855, 2529, 2496, 2498], 1)
    ops.element('FourNodeTetrahedron', 11794, *[1190, 2215, 2251, 2064], 1)
    ops.element('FourNodeTetrahedron', 11795, *[1193, 2475, 1779, 1133], 1)
    ops.element('FourNodeTetrahedron', 11796, *[2390, 1806, 2640, 2389], 1)
    ops.element('FourNodeTetrahedron', 11797, *[2453, 1992, 2525, 1990], 1)
    ops.element('FourNodeTetrahedron', 11798, *[1203, 2145, 1251, 2402], 1)
    ops.element('FourNodeTetrahedron', 11799, *[1123, 2144, 2145, 1203], 1)
    ops.element('FourNodeTetrahedron', 11800, *[2122, 2430, 2121, 1839], 1)
    ops.element('FourNodeTetrahedron', 11801, *[2275, 2458, 2442, 2608], 1)
    ops.element('FourNodeTetrahedron', 11802, *[1747, 1749, 1748, 1972], 1)
    ops.element('FourNodeTetrahedron', 11803, *[1775, 2363, 1773, 1772], 1)
    ops.element('FourNodeTetrahedron', 11804, *[1799, 1828, 1825, 2143], 1)
    ops.element('FourNodeTetrahedron', 11805, *[2302, 2300, 2488, 2506], 1)
    ops.element('FourNodeTetrahedron', 11806, *[2525, 1990, 2362, 2656], 1)
    ops.element('FourNodeTetrahedron', 11807, *[1969, 1747, 2214, 2340], 1)
    ops.element('FourNodeTetrahedron', 11808, *[2381, 2315, 1955, 2073], 1)
    ops.element('FourNodeTetrahedron', 11809, *[1908, 1912, 1918, 2093], 1)
    ops.element('FourNodeTetrahedron', 11810, *[2346, 2173, 1896, 1856], 1)
    ops.element('FourNodeTetrahedron', 11811, *[2458, 1759, 2442, 2457], 1)
    ops.element('FourNodeTetrahedron', 11812, *[2645, 1787, 2668, 2055], 1)
    ops.element('FourNodeTetrahedron', 11813, *[2031, 2645, 1787, 2055], 1)
    ops.element('FourNodeTetrahedron', 11814, *[1976, 1754, 1753, 1977], 1)
    ops.element('FourNodeTetrahedron', 11815, *[2362, 1754, 1976, 1977], 1)
    ops.element('FourNodeTetrahedron', 11816, *[2055, 2645, 2668, 2037], 1)
    ops.element('FourNodeTetrahedron', 11817, *[2031, 2297, 2645, 2055], 1)
    ops.element('FourNodeTetrahedron', 11818, *[1927, 2031, 1929, 2055], 1)
    ops.element('FourNodeTetrahedron', 11819, *[2033, 2297, 2055, 2056], 1)
    ops.element('FourNodeTetrahedron', 11820, *[2285, 1994, 1993, 1995], 1)
    ops.element('FourNodeTetrahedron', 11821, *[1927, 2055, 1929, 2646], 1)
    ops.element('FourNodeTetrahedron', 11822, *[2055, 2037, 2668, 1746], 1)
    ops.element('FourNodeTetrahedron', 11823, *[2131, 2132, 2129, 2075], 1)
    ops.element('FourNodeTetrahedron', 11824, *[2531, 2075, 2129, 2150], 1)
    ops.element('FourNodeTetrahedron', 11825, *[2531, 2131, 2129, 2075], 1)
    ops.element('FourNodeTetrahedron', 11826, *[2075, 2076, 2129, 2150], 1)
    ops.element('FourNodeTetrahedron', 11827, *[2204, 1974, 1859, 2007], 1)
    ops.element('FourNodeTetrahedron', 11828, *[2349, 2513, 2412, 2350], 1)
    ops.element('FourNodeTetrahedron', 11829, *[2646, 2055, 1929, 2357], 1)
    ops.element('FourNodeTetrahedron', 11830, *[2465, 2541, 2336, 2197], 1)
    ops.element('FourNodeTetrahedron', 11831, *[2539, 2336, 2465, 2541], 1)
    ops.element('FourNodeTetrahedron', 11832, *[2071, 2132, 2316, 1868], 1)
    ops.element('FourNodeTetrahedron', 11833, *[2390, 1805, 1806, 2322], 1)
    ops.element('FourNodeTetrahedron', 11834, *[2373, 2087, 2167, 2088], 1)
    ops.element('FourNodeTetrahedron', 11835, *[2251, 2196, 2250, 2216], 1)
    ops.element('FourNodeTetrahedron', 11836, *[2255, 2465, 2251, 2215], 1)
    ops.element('FourNodeTetrahedron', 11837, *[2213, 2079, 2080, 2140], 1)
    ops.element('FourNodeTetrahedron', 11838, *[2457, 2458, 2459, 2638], 1)
    ops.element('FourNodeTetrahedron', 11839, *[1969, 1972, 2213, 2139], 1)
    ops.element('FourNodeTetrahedron', 11840, *[2359, 1177, 1125, 2563], 1)
    ops.element('FourNodeTetrahedron', 11841, *[2213, 1972, 1748, 2079], 1)
    ops.element('FourNodeTetrahedron', 11842, *[2213, 1748, 2080, 2079], 1)
    ops.element('FourNodeTetrahedron', 11843, *[2359, 2563, 1125, 2395], 1)
    ops.element('FourNodeTetrahedron', 11844, *[2088, 2373, 2167, 2135], 1)
    ops.element('FourNodeTetrahedron', 11845, *[2377, 1924, 2301, 2303], 1)
    ops.element('FourNodeTetrahedron', 11846, *[2377, 2303, 2301, 2510], 1)
    ops.element('FourNodeTetrahedron', 11847, *[2304, 2582, 731, 2463], 1)
    ops.element('FourNodeTetrahedron', 11848, *[733, 2304, 731, 2463], 1)
    ops.element('FourNodeTetrahedron', 11849, *[2445, 2593, 2277, 1871], 1)
    ops.element('FourNodeTetrahedron', 11850, *[1123, 2142, 1203, 1205], 1)
    ops.element('FourNodeTetrahedron', 11851, *[1131, 1796, 1195, 2013], 1)
    ops.element('FourNodeTetrahedron', 11852, *[2281, 2431, 2403, 2499], 1)
    ops.element('FourNodeTetrahedron', 11853, *[2651, 1983, 1985, 2524], 1)
    ops.element('FourNodeTetrahedron', 11854, *[2663, 2651, 1985, 2524], 1)
    ops.element('FourNodeTetrahedron', 11855, *[1884, 2651, 2663, 2524], 1)
    ops.element('FourNodeTetrahedron', 11856, *[1829, 1846, 2110, 2376], 1)
    ops.element('FourNodeTetrahedron', 11857, *[2351, 2660, 2373, 2135], 1)
    ops.element('FourNodeTetrahedron', 11858, *[2373, 2660, 2167, 2135], 1)
    ops.element('FourNodeTetrahedron', 11859, *[2255, 2251, 1190, 2215], 1)
    ops.element('FourNodeTetrahedron', 11860, *[2236, 1844, 2449, 1898], 1)
    ops.element('FourNodeTetrahedron', 11861, *[1237, 2359, 1125, 1248], 1)
    ops.element('FourNodeTetrahedron', 11862, *[2078, 2395, 1125, 1179], 1)
    ops.element('FourNodeTetrahedron', 11863, *[2078, 1125, 1248, 1179], 1)
    ops.element('FourNodeTetrahedron', 11864, *[1869, 2359, 1237, 1248], 1)
    ops.element('FourNodeTetrahedron', 11865, *[1869, 2359, 1248, 2078], 1)
    ops.element('FourNodeTetrahedron', 11866, *[2090, 2087, 2166, 2167], 1)
    ops.element('FourNodeTetrahedron', 11867, *[2349, 2513, 2404, 2412], 1)
    ops.element('FourNodeTetrahedron', 11868, *[2113, 1755, 2112, 2526], 1)
    ops.element('FourNodeTetrahedron', 11869, *[1958, 1957, 1956, 2210], 1)
    ops.element('FourNodeTetrahedron', 11870, *[2096, 1968, 2273, 2468], 1)

    # Fix the node.
    ops.fix(167, *[1, 1, 1, 1, 1, 1])
    ops.fix(168, *[1, 1, 1, 1, 1, 1])
    ops.fix(169, *[1, 1, 1, 1, 1, 1])
    ops.fix(170, *[1, 1, 1, 1, 1, 1])
    ops.fix(171, *[1, 1, 1, 1, 1, 1])
    ops.fix(172, *[1, 1, 1, 1, 1, 1])
    ops.fix(212, *[1, 1, 1, 1, 1, 1])
    ops.fix(221, *[1, 1, 1, 1, 1, 1])
    ops.fix(240, *[1, 1, 1, 1, 1, 1])
    ops.fix(245, *[1, 1, 1, 1, 1, 1])
    ops.fix(270, *[1, 1, 1, 1, 1, 1])
    ops.fix(275, *[1, 1, 1, 1, 1, 1])
    ops.fix(280, *[1, 1, 1, 1, 1, 1])
    ops.fix(285, *[1, 1, 1, 1, 1, 1])
    ops.fix(305, *[1, 1, 1, 1, 1, 1])
    ops.fix(310, *[1, 1, 1, 1, 1, 1])
    ops.fix(315, *[1, 1, 1, 1, 1, 1])
    ops.fix(336, *[1, 1, 1, 1, 1, 1])
    ops.fix(337, *[1, 1, 1, 1, 1, 1])
    ops.fix(338, *[1, 1, 1, 1, 1, 1])
    ops.fix(339, *[1, 1, 1, 1, 1, 1])
    ops.fix(379, *[1, 1, 1, 1, 1, 1])
    ops.fix(380, *[1, 1, 1, 1, 1, 1])
    ops.fix(381, *[1, 1, 1, 1, 1, 1])
    ops.fix(382, *[1, 1, 1, 1, 1, 1])
    ops.fix(383, *[1, 1, 1, 1, 1, 1])
    ops.fix(384, *[1, 1, 1, 1, 1, 1])
    ops.fix(385, *[1, 1, 1, 1, 1, 1])
    ops.fix(411, *[1, 1, 1, 1, 1, 1])
    ops.fix(481, *[1, 1, 1, 1, 1, 1])
    ops.fix(494, *[1, 1, 1, 1, 1, 1])
    ops.fix(514, *[1, 1, 1, 1, 1, 1])
    ops.fix(515, *[1, 1, 1, 1, 1, 1])
    ops.fix(516, *[1, 1, 1, 1, 1, 1])
    ops.fix(702, *[1, 1, 1, 1, 1, 1])
    ops.fix(703, *[1, 1, 1, 1, 1, 1])
    ops.fix(704, *[1, 1, 1, 1, 1, 1])
    ops.fix(705, *[1, 1, 1, 1, 1, 1])
    ops.fix(706, *[1, 1, 1, 1, 1, 1])
    ops.fix(707, *[1, 1, 1, 1, 1, 1])
    ops.fix(708, *[1, 1, 1, 1, 1, 1])
    ops.fix(709, *[1, 1, 1, 1, 1, 1])
    ops.fix(710, *[1, 1, 1, 1, 1, 1])
    ops.fix(711, *[1, 1, 1, 1, 1, 1])
    ops.fix(712, *[1, 1, 1, 1, 1, 1])
    ops.fix(713, *[1, 1, 1, 1, 1, 1])
    ops.fix(714, *[1, 1, 1, 1, 1, 1])
    ops.fix(715, *[1, 1, 1, 1, 1, 1])
    ops.fix(716, *[1, 1, 1, 1, 1, 1])
    ops.fix(717, *[1, 1, 1, 1, 1, 1])
    ops.fix(718, *[1, 1, 1, 1, 1, 1])
    ops.fix(719, *[1, 1, 1, 1, 1, 1])
    ops.fix(720, *[1, 1, 1, 1, 1, 1])
    ops.fix(721, *[1, 1, 1, 1, 1, 1])
    ops.fix(722, *[1, 1, 1, 1, 1, 1])
    ops.fix(723, *[1, 1, 1, 1, 1, 1])
    ops.fix(724, *[1, 1, 1, 1, 1, 1])
    ops.fix(725, *[1, 1, 1, 1, 1, 1])
    ops.fix(726, *[1, 1, 1, 1, 1, 1])
    ops.fix(727, *[1, 1, 1, 1, 1, 1])
    ops.fix(728, *[1, 1, 1, 1, 1, 1])
    ops.fix(729, *[1, 1, 1, 1, 1, 1])
    ops.fix(730, *[1, 1, 1, 1, 1, 1])
    ops.fix(731, *[1, 1, 1, 1, 1, 1])
    ops.fix(732, *[1, 1, 1, 1, 1, 1])
    ops.fix(733, *[1, 1, 1, 1, 1, 1])
    ops.fix(734, *[1, 1, 1, 1, 1, 1])
    ops.fix(735, *[1, 1, 1, 1, 1, 1])
    ops.fix(736, *[1, 1, 1, 1, 1, 1])
    ops.fix(737, *[1, 1, 1, 1, 1, 1])
    ops.fix(738, *[1, 1, 1, 1, 1, 1])
    ops.fix(739, *[1, 1, 1, 1, 1, 1])
    ops.fix(740, *[1, 1, 1, 1, 1, 1])
    ops.fix(741, *[1, 1, 1, 1, 1, 1])
    ops.fix(742, *[1, 1, 1, 1, 1, 1])
    ops.fix(743, *[1, 1, 1, 1, 1, 1])
    ops.fix(744, *[1, 1, 1, 1, 1, 1])
    ops.fix(745, *[1, 1, 1, 1, 1, 1])
    ops.fix(746, *[1, 1, 1, 1, 1, 1])
    ops.fix(747, *[1, 1, 1, 1, 1, 1])
    ops.fix(748, *[1, 1, 1, 1, 1, 1])
    ops.fix(749, *[1, 1, 1, 1, 1, 1])
    ops.fix(750, *[1, 1, 1, 1, 1, 1])
    ops.fix(751, *[1, 1, 1, 1, 1, 1])
    ops.fix(752, *[1, 1, 1, 1, 1, 1])
    ops.fix(753, *[1, 1, 1, 1, 1, 1])
    ops.fix(754, *[1, 1, 1, 1, 1, 1])
    ops.fix(755, *[1, 1, 1, 1, 1, 1])
    ops.fix(756, *[1, 1, 1, 1, 1, 1])
    ops.fix(757, *[1, 1, 1, 1, 1, 1])
    ops.fix(758, *[1, 1, 1, 1, 1, 1])
    ops.fix(759, *[1, 1, 1, 1, 1, 1])
    ops.fix(760, *[1, 1, 1, 1, 1, 1])
    ops.fix(761, *[1, 1, 1, 1, 1, 1])
    ops.fix(762, *[1, 1, 1, 1, 1, 1])
    ops.fix(763, *[1, 1, 1, 1, 1, 1])
    ops.fix(764, *[1, 1, 1, 1, 1, 1])
    ops.fix(765, *[1, 1, 1, 1, 1, 1])
    ops.fix(766, *[1, 1, 1, 1, 1, 1])
    ops.fix(767, *[1, 1, 1, 1, 1, 1])
    ops.fix(768, *[1, 1, 1, 1, 1, 1])
    ops.fix(769, *[1, 1, 1, 1, 1, 1])
    ops.fix(770, *[1, 1, 1, 1, 1, 1])
    ops.fix(771, *[1, 1, 1, 1, 1, 1])
    ops.fix(772, *[1, 1, 1, 1, 1, 1])
    ops.fix(1761, *[1, 1, 1, 1, 1, 1])
    ops.fix(1773, *[1, 1, 1, 1, 1, 1])
    ops.fix(1774, *[1, 1, 1, 1, 1, 1])
    ops.fix(1775, *[1, 1, 1, 1, 1, 1])
    ops.fix(1812, *[1, 1, 1, 1, 1, 1])
    ops.fix(1813, *[1, 1, 1, 1, 1, 1])
    ops.fix(1815, *[1, 1, 1, 1, 1, 1])
    ops.fix(1894, *[1, 1, 1, 1, 1, 1])
    ops.fix(1928, *[1, 1, 1, 1, 1, 1])
    ops.fix(1939, *[1, 1, 1, 1, 1, 1])
    ops.fix(1940, *[1, 1, 1, 1, 1, 1])
    ops.fix(1983, *[1, 1, 1, 1, 1, 1])
    ops.fix(1984, *[1, 1, 1, 1, 1, 1])
    ops.fix(1985, *[1, 1, 1, 1, 1, 1])
    ops.fix(2005, *[1, 1, 1, 1, 1, 1])
    ops.fix(2042, *[1, 1, 1, 1, 1, 1])
    ops.fix(2087, *[1, 1, 1, 1, 1, 1])
    ops.fix(2089, *[1, 1, 1, 1, 1, 1])
    ops.fix(2090, *[1, 1, 1, 1, 1, 1])
    ops.fix(2136, *[1, 1, 1, 1, 1, 1])
    ops.fix(2137, *[1, 1, 1, 1, 1, 1])
    ops.fix(2141, *[1, 1, 1, 1, 1, 1])
    ops.fix(2161, *[1, 1, 1, 1, 1, 1])
    ops.fix(2162, *[1, 1, 1, 1, 1, 1])
    ops.fix(2163, *[1, 1, 1, 1, 1, 1])
    ops.fix(2165, *[1, 1, 1, 1, 1, 1])
    ops.fix(2166, *[1, 1, 1, 1, 1, 1])
    ops.fix(2177, *[1, 1, 1, 1, 1, 1])
    ops.fix(2180, *[1, 1, 1, 1, 1, 1])
    ops.fix(2181, *[1, 1, 1, 1, 1, 1])
    ops.fix(2182, *[1, 1, 1, 1, 1, 1])
    ops.fix(2183, *[1, 1, 1, 1, 1, 1])
    ops.fix(2265, *[1, 1, 1, 1, 1, 1])
    ops.fix(2295, *[1, 1, 1, 1, 1, 1])
    ops.fix(2304, *[1, 1, 1, 1, 1, 1])
    ops.fix(2305, *[1, 1, 1, 1, 1, 1])
    ops.fix(2330, *[1, 1, 1, 1, 1, 1])
    ops.fix(2353, *[1, 1, 1, 1, 1, 1])
    ops.fix(2355, *[1, 1, 1, 1, 1, 1])
    ops.fix(2372, *[1, 1, 1, 1, 1, 1])
    ops.fix(2374, *[1, 1, 1, 1, 1, 1])
    ops.fix(2394, *[1, 1, 1, 1, 1, 1])
    ops.fix(2397, *[1, 1, 1, 1, 1, 1])
    ops.fix(2399, *[1, 1, 1, 1, 1, 1])
    ops.fix(2400, *[1, 1, 1, 1, 1, 1])
    ops.fix(2401, *[1, 1, 1, 1, 1, 1])
    ops.fix(2437, *[1, 1, 1, 1, 1, 1])
    ops.fix(2439, *[1, 1, 1, 1, 1, 1])
    ops.fix(2461, *[1, 1, 1, 1, 1, 1])
    ops.fix(2472, *[1, 1, 1, 1, 1, 1])
    ops.fix(2473, *[1, 1, 1, 1, 1, 1])
    ops.fix(2477, *[1, 1, 1, 1, 1, 1])
    ops.fix(2521, *[1, 1, 1, 1, 1, 1])
    ops.fix(2546, *[1, 1, 1, 1, 1, 1])
    ops.fix(2557, *[1, 1, 1, 1, 1, 1])
    ops.fix(2571, *[1, 1, 1, 1, 1, 1])
    ops.fix(2582, *[1, 1, 1, 1, 1, 1])
    ops.fix(2585, *[1, 1, 1, 1, 1, 1])
    ops.fix(2586, *[1, 1, 1, 1, 1, 1])
    ops.fix(2599, *[1, 1, 1, 1, 1, 1])
    ops.fix(2607, *[1, 1, 1, 1, 1, 1])
    ops.fix(2613, *[1, 1, 1, 1, 1, 1])
    ops.fix(2623, *[1, 1, 1, 1, 1, 1])
    ops.fix(2628, *[1, 1, 1, 1, 1, 1])
    ops.fix(2629, *[1, 1, 1, 1, 1, 1])
    ops.fix(2642, *[1, 1, 1, 1, 1, 1])
    ops.fix(2644, *[1, 1, 1, 1, 1, 1])
    ops.fix(2648, *[1, 1, 1, 1, 1, 1])
    ops.fix(2649, *[1, 1, 1, 1, 1, 1])
    ops.fix(2650, *[1, 1, 1, 1, 1, 1])
    ops.fix(2651, *[1, 1, 1, 1, 1, 1])
    ops.fix(2654, *[1, 1, 1, 1, 1, 1])
    ops.fix(2663, *[1, 1, 1, 1, 1, 1])
    ops.fix(2666, *[1, 1, 1, 1, 1, 1])
    ops.fix(2671, *[1, 1, 1, 1, 1, 1])
    ops.fix(2672, *[1, 1, 1, 1, 1, 1])
    ops.fix(2674, *[1, 1, 1, 1, 1, 1])
    ops.fix(2678, *[1, 1, 1, 1, 1, 1])
    ops.fix(2683, *[1, 1, 1, 1, 1, 1])

    # Set the mass at a node.
    ops.mass(135, *[0.0003, 0.0003, 0.0003])
    ops.mass(136, *[0.0002, 0.0002, 0.0002])
    ops.mass(137, *[0.0004, 0.0004, 0.0004])
    ops.mass(138, *[0.0006, 0.0006, 0.0006])
    ops.mass(139, *[0.0004, 0.0004, 0.0004])
    ops.mass(140, *[0.0005, 0.0005, 0.0005])
    ops.mass(141, *[0.0006, 0.0006, 0.0006])
    ops.mass(142, *[0.0004, 0.0004, 0.0004])
    ops.mass(143, *[0.0003, 0.0003, 0.0003])
    ops.mass(144, *[0.0002, 0.0002, 0.0002])
    ops.mass(145, *[0.0002, 0.0002, 0.0002])
    ops.mass(146, *[0.0009, 0.0009, 0.0009])
    ops.mass(147, *[0.0006, 0.0006, 0.0006])
    ops.mass(148, *[0.0006, 0.0006, 0.0006])
    ops.mass(149, *[0.0004, 0.0004, 0.0004])
    ops.mass(150, *[0.0011, 0.0011, 0.0011])
    ops.mass(151, *[0.0005, 0.0005, 0.0005])
    ops.mass(152, *[0.001, 0.001, 0.001])
    ops.mass(153, *[0.0006, 0.0006, 0.0006])
    ops.mass(154, *[0.0007, 0.0007, 0.0007])
    ops.mass(155, *[0.0019, 0.0019, 0.0019])
    ops.mass(156, *[0.0014, 0.0014, 0.0014])
    ops.mass(157, *[0.0011, 0.0011, 0.0011])
    ops.mass(158, *[0.0014, 0.0014, 0.0014])
    ops.mass(159, *[0.002, 0.002, 0.002])
    ops.mass(160, *[0.0016, 0.0016, 0.0016])
    ops.mass(161, *[0.0018, 0.0018, 0.0018])
    ops.mass(162, *[0.0015, 0.0015, 0.0015])
    ops.mass(163, *[0.003, 0.003, 0.003])
    ops.mass(164, *[0.0017, 0.0017, 0.0017])
    ops.mass(165, *[0.0011, 0.0011, 0.0011])
    ops.mass(166, *[0.0004, 0.0004, 0.0004])
    ops.mass(167, *[0.0004, 0.0004, 0.0004])
    ops.mass(168, *[0.0008, 0.0008, 0.0008])
    ops.mass(169, *[0.0007, 0.0007, 0.0007])
    ops.mass(170, *[0.0004, 0.0004, 0.0004])
    ops.mass(171, *[0.0005, 0.0005, 0.0005])
    ops.mass(172, *[0.0004, 0.0004, 0.0004])
    ops.mass(173, *[0.0008, 0.0008, 0.0008])
    ops.mass(174, *[0.0004, 0.0004, 0.0004])
    ops.mass(175, *[0.0019, 0.0019, 0.0019])
    ops.mass(176, *[0.0014, 0.0014, 0.0014])
    ops.mass(177, *[0.0024, 0.0024, 0.0024])
    ops.mass(178, *[0.001, 0.001, 0.001])
    ops.mass(179, *[0.0001, 0.0001, 0.0001])
    ops.mass(180, *[0.0002, 0.0002, 0.0002])
    ops.mass(181, *[0.0001, 0.0001, 0.0001])
    ops.mass(182, *[0.0002, 0.0002, 0.0002])
    ops.mass(183, *[0.0003, 0.0003, 0.0003])
    ops.mass(184, *[0.0003, 0.0003, 0.0003])
    ops.mass(185, *[0.0005, 0.0005, 0.0005])
    ops.mass(186, *[0.0004, 0.0004, 0.0004])
    ops.mass(187, *[0.0003, 0.0003, 0.0003])
    ops.mass(188, *[0.0009, 0.0009, 0.0009])
    ops.mass(189, *[0.0006, 0.0006, 0.0006])
    ops.mass(190, *[0.0004, 0.0004, 0.0004])
    ops.mass(212, *[0.0003, 0.0003, 0.0003])
    ops.mass(213, *[0.001, 0.001, 0.001])
    ops.mass(214, *[0.0008, 0.0008, 0.0008])
    ops.mass(215, *[0.0006, 0.0006, 0.0006])
    ops.mass(216, *[0.0006, 0.0006, 0.0006])
    ops.mass(217, *[0.001, 0.001, 0.001])
    ops.mass(218, *[0.0007, 0.0007, 0.0007])
    ops.mass(219, *[0.0006, 0.0006, 0.0006])
    ops.mass(220, *[0.0009, 0.0009, 0.0009])
    ops.mass(221, *[0.0003, 0.0003, 0.0003])
    ops.mass(222, *[0.0006, 0.0006, 0.0006])
    ops.mass(223, *[0.0007, 0.0007, 0.0007])
    ops.mass(224, *[0.0006, 0.0006, 0.0006])
    ops.mass(225, *[0.0005, 0.0005, 0.0005])
    ops.mass(229, *[0.0008, 0.0008, 0.0008])
    ops.mass(230, *[0.001, 0.001, 0.001])
    ops.mass(231, *[0.0005, 0.0005, 0.0005])
    ops.mass(232, *[0.0011, 0.0011, 0.0011])
    ops.mass(233, *[0.0007, 0.0007, 0.0007])
    ops.mass(234, *[0.0005, 0.0005, 0.0005])
    ops.mass(235, *[0.0008, 0.0008, 0.0008])
    ops.mass(236, *[0.0006, 0.0006, 0.0006])
    ops.mass(237, *[0.0005, 0.0005, 0.0005])
    ops.mass(238, *[0.0006, 0.0006, 0.0006])
    ops.mass(239, *[0.0004, 0.0004, 0.0004])
    ops.mass(240, *[0.0003, 0.0003, 0.0003])
    ops.mass(241, *[0.0004, 0.0004, 0.0004])
    ops.mass(242, *[0.0006, 0.0006, 0.0006])
    ops.mass(243, *[0.0004, 0.0004, 0.0004])
    ops.mass(244, *[0.0005, 0.0005, 0.0005])
    ops.mass(245, *[0.0002, 0.0002, 0.0002])
    ops.mass(246, *[0.0008, 0.0008, 0.0008])
    ops.mass(247, *[0.0007, 0.0007, 0.0007])
    ops.mass(248, *[0.0005, 0.0005, 0.0005])
    ops.mass(249, *[0.0005, 0.0005, 0.0005])
    ops.mass(250, *[0.0003, 0.0003, 0.0003])
    ops.mass(251, *[0.001, 0.001, 0.001])
    ops.mass(252, *[0.0004, 0.0004, 0.0004])
    ops.mass(253, *[0.0005, 0.0005, 0.0005])
    ops.mass(254, *[0.0006, 0.0006, 0.0006])
    ops.mass(255, *[0.001, 0.001, 0.001])
    ops.mass(256, *[0.0006, 0.0006, 0.0006])
    ops.mass(257, *[0.0003, 0.0003, 0.0003])
    ops.mass(258, *[0.0008, 0.0008, 0.0008])
    ops.mass(259, *[0.0012, 0.0012, 0.0012])
    ops.mass(260, *[0.0005, 0.0005, 0.0005])
    ops.mass(261, *[0.0008, 0.0008, 0.0008])
    ops.mass(262, *[0.0006, 0.0006, 0.0006])
    ops.mass(263, *[0.0007, 0.0007, 0.0007])
    ops.mass(264, *[0.0004, 0.0004, 0.0004])
    ops.mass(265, *[0.0007, 0.0007, 0.0007])
    ops.mass(266, *[0.0006, 0.0006, 0.0006])
    ops.mass(267, *[0.0007, 0.0007, 0.0007])
    ops.mass(268, *[0.0002, 0.0002, 0.0002])
    ops.mass(269, *[0.0004, 0.0004, 0.0004])
    ops.mass(270, *[0.0001, 0.0001, 0.0001])
    ops.mass(271, *[0.0009, 0.0009, 0.0009])
    ops.mass(272, *[0.0011, 0.0011, 0.0011])
    ops.mass(273, *[0.0012, 0.0012, 0.0012])
    ops.mass(274, *[0.0012, 0.0012, 0.0012])
    ops.mass(275, *[0.0004, 0.0004, 0.0004])
    ops.mass(276, *[0.0012, 0.0012, 0.0012])
    ops.mass(277, *[0.0008, 0.0008, 0.0008])
    ops.mass(278, *[0.0011, 0.0011, 0.0011])
    ops.mass(279, *[0.0012, 0.0012, 0.0012])
    ops.mass(280, *[0.0007, 0.0007, 0.0007])
    ops.mass(281, *[0.0008, 0.0008, 0.0008])
    ops.mass(282, *[0.0014, 0.0014, 0.0014])
    ops.mass(283, *[0.0009, 0.0009, 0.0009])
    ops.mass(284, *[0.0012, 0.0012, 0.0012])
    ops.mass(285, *[0.0005, 0.0005, 0.0005])
    ops.mass(286, *[0.0006, 0.0006, 0.0006])
    ops.mass(287, *[0.001, 0.001, 0.001])
    ops.mass(288, *[0.0014, 0.0014, 0.0014])
    ops.mass(289, *[0.001, 0.001, 0.001])
    ops.mass(290, *[0.0008, 0.0008, 0.0008])
    ops.mass(291, *[0.0004, 0.0004, 0.0004])
    ops.mass(292, *[0.0007, 0.0007, 0.0007])
    ops.mass(293, *[0.0008, 0.0008, 0.0008])
    ops.mass(294, *[0.0009, 0.0009, 0.0009])
    ops.mass(295, *[0.001, 0.001, 0.001])
    ops.mass(296, *[0.0007, 0.0007, 0.0007])
    ops.mass(297, *[0.0008, 0.0008, 0.0008])
    ops.mass(298, *[0.0006, 0.0006, 0.0006])
    ops.mass(299, *[0.0007, 0.0007, 0.0007])
    ops.mass(300, *[0.0006, 0.0006, 0.0006])
    ops.mass(301, *[0.0013, 0.0013, 0.0013])
    ops.mass(302, *[0.0003, 0.0003, 0.0003])
    ops.mass(303, *[0.0006, 0.0006, 0.0006])
    ops.mass(304, *[0.0005, 0.0005, 0.0005])
    ops.mass(305, *[0.0007, 0.0007, 0.0007])
    ops.mass(306, *[0.0005, 0.0005, 0.0005])
    ops.mass(307, *[0.0009, 0.0009, 0.0009])
    ops.mass(308, *[0.0013, 0.0013, 0.0013])
    ops.mass(309, *[0.0006, 0.0006, 0.0006])
    ops.mass(310, *[0.0004, 0.0004, 0.0004])
    ops.mass(311, *[0.0007, 0.0007, 0.0007])
    ops.mass(312, *[0.0007, 0.0007, 0.0007])
    ops.mass(313, *[0.0007, 0.0007, 0.0007])
    ops.mass(314, *[0.0008, 0.0008, 0.0008])
    ops.mass(315, *[0.0003, 0.0003, 0.0003])
    ops.mass(316, *[0.0008, 0.0008, 0.0008])
    ops.mass(317, *[0.0007, 0.0007, 0.0007])
    ops.mass(318, *[0.0009, 0.0009, 0.0009])
    ops.mass(319, *[0.0007, 0.0007, 0.0007])
    ops.mass(320, *[0.0008, 0.0008, 0.0008])
    ops.mass(321, *[0.0003, 0.0003, 0.0003])
    ops.mass(322, *[0.0007, 0.0007, 0.0007])
    ops.mass(323, *[0.0004, 0.0004, 0.0004])
    ops.mass(324, *[0.0003, 0.0003, 0.0003])
    ops.mass(325, *[0.0007, 0.0007, 0.0007])
    ops.mass(326, *[0.001, 0.001, 0.001])
    ops.mass(327, *[0.0012, 0.0012, 0.0012])
    ops.mass(328, *[0.0015, 0.0015, 0.0015])
    ops.mass(329, *[0.001, 0.001, 0.001])
    ops.mass(330, *[0.0007, 0.0007, 0.0007])
    ops.mass(331, *[0.0008, 0.0008, 0.0008])
    ops.mass(332, *[0.0011, 0.0011, 0.0011])
    ops.mass(333, *[0.0007, 0.0007, 0.0007])
    ops.mass(334, *[0.0008, 0.0008, 0.0008])
    ops.mass(335, *[0.0007, 0.0007, 0.0007])
    ops.mass(336, *[0.0004, 0.0004, 0.0004])
    ops.mass(337, *[0.0004, 0.0004, 0.0004])
    ops.mass(338, *[0.0003, 0.0003, 0.0003])
    ops.mass(339, *[0.0005, 0.0005, 0.0005])
    ops.mass(340, *[0.0004, 0.0004, 0.0004])
    ops.mass(341, *[0.0011, 0.0011, 0.0011])
    ops.mass(342, *[0.0008, 0.0008, 0.0008])
    ops.mass(343, *[0.0009, 0.0009, 0.0009])
    ops.mass(344, *[0.0009, 0.0009, 0.0009])
    ops.mass(345, *[0.0006, 0.0006, 0.0006])
    ops.mass(346, *[0.0005, 0.0005, 0.0005])
    ops.mass(347, *[0.0006, 0.0006, 0.0006])
    ops.mass(348, *[0.0008, 0.0008, 0.0008])
    ops.mass(349, *[0.0004, 0.0004, 0.0004])
    ops.mass(350, *[0.001, 0.001, 0.001])
    ops.mass(351, *[0.0018, 0.0018, 0.0018])
    ops.mass(352, *[0.0008, 0.0008, 0.0008])
    ops.mass(353, *[0.0008, 0.0008, 0.0008])
    ops.mass(354, *[0.0005, 0.0005, 0.0005])
    ops.mass(355, *[0.0006, 0.0006, 0.0006])
    ops.mass(356, *[0.001, 0.001, 0.001])
    ops.mass(357, *[0.0008, 0.0008, 0.0008])
    ops.mass(358, *[0.0016, 0.0016, 0.0016])
    ops.mass(359, *[0.0015, 0.0015, 0.0015])
    ops.mass(360, *[0.0009, 0.0009, 0.0009])
    ops.mass(361, *[0.0013, 0.0013, 0.0013])
    ops.mass(362, *[0.0013, 0.0013, 0.0013])
    ops.mass(363, *[0.0006, 0.0006, 0.0006])
    ops.mass(364, *[0.0008, 0.0008, 0.0008])
    ops.mass(365, *[0.001, 0.001, 0.001])
    ops.mass(366, *[0.0013, 0.0013, 0.0013])
    ops.mass(367, *[0.0016, 0.0016, 0.0016])
    ops.mass(368, *[0.0015, 0.0015, 0.0015])
    ops.mass(369, *[0.0005, 0.0005, 0.0005])
    ops.mass(370, *[0.0008, 0.0008, 0.0008])
    ops.mass(371, *[0.0016, 0.0016, 0.0016])
    ops.mass(372, *[0.0025, 0.0025, 0.0025])
    ops.mass(373, *[0.0019, 0.0019, 0.0019])
    ops.mass(374, *[0.0013, 0.0013, 0.0013])
    ops.mass(375, *[0.0019, 0.0019, 0.0019])
    ops.mass(376, *[0.0014, 0.0014, 0.0014])
    ops.mass(377, *[0.0009, 0.0009, 0.0009])
    ops.mass(378, *[0.0006, 0.0006, 0.0006])
    ops.mass(379, *[0.0004, 0.0004, 0.0004])
    ops.mass(380, *[0.0002, 0.0002, 0.0002])
    ops.mass(381, *[0.0005, 0.0005, 0.0005])
    ops.mass(382, *[0.0008, 0.0008, 0.0008])
    ops.mass(383, *[0.0007, 0.0007, 0.0007])
    ops.mass(384, *[0.0012, 0.0012, 0.0012])
    ops.mass(385, *[0.0008, 0.0008, 0.0008])
    ops.mass(386, *[0.0006, 0.0006, 0.0006])
    ops.mass(387, *[0.0015, 0.0015, 0.0015])
    ops.mass(388, *[0.0013, 0.0013, 0.0013])
    ops.mass(389, *[0.0014, 0.0014, 0.0014])
    ops.mass(390, *[0.0016, 0.0016, 0.0016])
    ops.mass(391, *[0.0014, 0.0014, 0.0014])
    ops.mass(392, *[0.0017, 0.0017, 0.0017])
    ops.mass(393, *[0.0006, 0.0006, 0.0006])
    ops.mass(394, *[0.0031, 0.0031, 0.0031])
    ops.mass(395, *[0.0018, 0.0018, 0.0018])
    ops.mass(396, *[0.0019, 0.0019, 0.0019])
    ops.mass(397, *[0.0017, 0.0017, 0.0017])
    ops.mass(398, *[0.0011, 0.0011, 0.0011])
    ops.mass(399, *[0.0016, 0.0016, 0.0016])
    ops.mass(400, *[0.0011, 0.0011, 0.0011])
    ops.mass(401, *[0.0011, 0.0011, 0.0011])
    ops.mass(402, *[0.0028, 0.0028, 0.0028])
    ops.mass(403, *[0.0026, 0.0026, 0.0026])
    ops.mass(404, *[0.0021, 0.0021, 0.0021])
    ops.mass(405, *[0.0014, 0.0014, 0.0014])
    ops.mass(406, *[0.0007, 0.0007, 0.0007])
    ops.mass(407, *[0.0005, 0.0005, 0.0005])
    ops.mass(408, *[0.0002, 0.0002, 0.0002])
    ops.mass(409, *[0.001, 0.001, 0.001])
    ops.mass(410, *[0.0008, 0.0008, 0.0008])
    ops.mass(411, *[0.0004, 0.0004, 0.0004])
    ops.mass(412, *[0.0011, 0.0011, 0.0011])
    ops.mass(413, *[0.0005, 0.0005, 0.0005])
    ops.mass(414, *[0.0012, 0.0012, 0.0012])
    ops.mass(415, *[0.0008, 0.0008, 0.0008])
    ops.mass(416, *[0.0015, 0.0015, 0.0015])
    ops.mass(417, *[0.0019, 0.0019, 0.0019])
    ops.mass(418, *[0.0018, 0.0018, 0.0018])
    ops.mass(419, *[0.0006, 0.0006, 0.0006])
    ops.mass(420, *[0.0008, 0.0008, 0.0008])
    ops.mass(421, *[0.0008, 0.0008, 0.0008])
    ops.mass(422, *[0.0006, 0.0006, 0.0006])
    ops.mass(423, *[0.0008, 0.0008, 0.0008])
    ops.mass(424, *[0.0007, 0.0007, 0.0007])
    ops.mass(431, *[0.0018, 0.0018, 0.0018])
    ops.mass(432, *[0.0013, 0.0013, 0.0013])
    ops.mass(433, *[0.0013, 0.0013, 0.0013])
    ops.mass(434, *[0.0003, 0.0003, 0.0003])
    ops.mass(435, *[0.0003, 0.0003, 0.0003])
    ops.mass(436, *[0.0008, 0.0008, 0.0008])
    ops.mass(437, *[0.0007, 0.0007, 0.0007])
    ops.mass(438, *[0.0003, 0.0003, 0.0003])
    ops.mass(439, *[0.0004, 0.0004, 0.0004])
    ops.mass(440, *[0.0009, 0.0009, 0.0009])
    ops.mass(441, *[0.0003, 0.0003, 0.0003])
    ops.mass(442, *[0.0006, 0.0006, 0.0006])
    ops.mass(443, *[0.0004, 0.0004, 0.0004])
    ops.mass(444, *[0.0007, 0.0007, 0.0007])
    ops.mass(445, *[0.0005, 0.0005, 0.0005])
    ops.mass(446, *[0.0004, 0.0004, 0.0004])
    ops.mass(447, *[0.0005, 0.0005, 0.0005])
    ops.mass(448, *[0.0005, 0.0005, 0.0005])
    ops.mass(449, *[0.0003, 0.0003, 0.0003])
    ops.mass(450, *[0.0002, 0.0002, 0.0002])
    ops.mass(451, *[0.0006, 0.0006, 0.0006])
    ops.mass(452, *[0.0004, 0.0004, 0.0004])
    ops.mass(453, *[0.0003, 0.0003, 0.0003])
    ops.mass(454, *[0.0007, 0.0007, 0.0007])
    ops.mass(455, *[0.0005, 0.0005, 0.0005])
    ops.mass(456, *[0.0005, 0.0005, 0.0005])
    ops.mass(457, *[0.0005, 0.0005, 0.0005])
    ops.mass(458, *[0.0006, 0.0006, 0.0006])
    ops.mass(459, *[0.0007, 0.0007, 0.0007])
    ops.mass(460, *[0.0002, 0.0002, 0.0002])
    ops.mass(461, *[0.0004, 0.0004, 0.0004])
    ops.mass(462, *[0.0007, 0.0007, 0.0007])
    ops.mass(463, *[0.0007, 0.0007, 0.0007])
    ops.mass(464, *[0.0003, 0.0003, 0.0003])
    ops.mass(465, *[0.0005, 0.0005, 0.0005])
    ops.mass(466, *[0.0004, 0.0004, 0.0004])
    ops.mass(467, *[0.0004, 0.0004, 0.0004])
    ops.mass(468, *[0.0006, 0.0006, 0.0006])
    ops.mass(469, *[0.0005, 0.0005, 0.0005])
    ops.mass(470, *[0.0005, 0.0005, 0.0005])
    ops.mass(471, *[0.0007, 0.0007, 0.0007])
    ops.mass(472, *[0.0008, 0.0008, 0.0008])
    ops.mass(473, *[0.0005, 0.0005, 0.0005])
    ops.mass(474, *[0.0002, 0.0002, 0.0002])
    ops.mass(475, *[0.0001, 0.0001, 0.0001])
    ops.mass(476, *[0.0003, 0.0003, 0.0003])
    ops.mass(477, *[0.0007, 0.0007, 0.0007])
    ops.mass(478, *[0.0006, 0.0006, 0.0006])
    ops.mass(479, *[0.0003, 0.0003, 0.0003])
    ops.mass(480, *[0.0004, 0.0004, 0.0004])
    ops.mass(481, *[0.0008, 0.0008, 0.0008])
    ops.mass(482, *[0.0019, 0.0019, 0.0019])
    ops.mass(483, *[0.0009, 0.0009, 0.0009])
    ops.mass(484, *[0.0007, 0.0007, 0.0007])
    ops.mass(485, *[0.0012, 0.0012, 0.0012])
    ops.mass(486, *[0.0017, 0.0017, 0.0017])
    ops.mass(487, *[0.001, 0.001, 0.001])
    ops.mass(488, *[0.0018, 0.0018, 0.0018])
    ops.mass(489, *[0.0019, 0.0019, 0.0019])
    ops.mass(490, *[0.001, 0.001, 0.001])
    ops.mass(491, *[0.0043, 0.0043, 0.0043])
    ops.mass(492, *[0.0019, 0.0019, 0.0019])
    ops.mass(493, *[0.0021, 0.0021, 0.0021])
    ops.mass(494, *[0.0007, 0.0007, 0.0007])
    ops.mass(509, *[0.0027, 0.0027, 0.0027])
    ops.mass(510, *[0.0007, 0.0007, 0.0007])
    ops.mass(511, *[0.0018, 0.0018, 0.0018])
    ops.mass(512, *[0.0072, 0.0072, 0.0072])
    ops.mass(513, *[0.0129, 0.0129, 0.0129])
    ops.mass(514, *[0.002, 0.002, 0.002])
    ops.mass(515, *[0.0017, 0.0017, 0.0017])
    ops.mass(516, *[0.0031, 0.0031, 0.0031])
    ops.mass(517, *[0.0124, 0.0124, 0.0124])
    ops.mass(518, *[0.0102, 0.0102, 0.0102])
    ops.mass(519, *[0.0077, 0.0077, 0.0077])
    ops.mass(520, *[0.0053, 0.0053, 0.0053])
    ops.mass(521, *[0.0079, 0.0079, 0.0079])
    ops.mass(522, *[0.0021, 0.0021, 0.0021])
    ops.mass(523, *[0.0013, 0.0013, 0.0013])
    ops.mass(524, *[0.0013, 0.0013, 0.0013])
    ops.mass(525, *[0.0027, 0.0027, 0.0027])
    ops.mass(526, *[0.001, 0.001, 0.001])
    ops.mass(527, *[0.0009, 0.0009, 0.0009])
    ops.mass(528, *[0.0005, 0.0005, 0.0005])
    ops.mass(529, *[0.001, 0.001, 0.001])
    ops.mass(530, *[0.0008, 0.0008, 0.0008])
    ops.mass(531, *[0.0008, 0.0008, 0.0008])
    ops.mass(532, *[0.0007, 0.0007, 0.0007])
    ops.mass(533, *[0.0005, 0.0005, 0.0005])
    ops.mass(534, *[0.0007, 0.0007, 0.0007])
    ops.mass(535, *[0.0007, 0.0007, 0.0007])
    ops.mass(536, *[0.0005, 0.0005, 0.0005])
    ops.mass(537, *[0.0006, 0.0006, 0.0006])
    ops.mass(538, *[0.0006, 0.0006, 0.0006])
    ops.mass(545, *[0.0024, 0.0024, 0.0024])
    ops.mass(546, *[0.0017, 0.0017, 0.0017])
    ops.mass(547, *[0.0017, 0.0017, 0.0017])
    ops.mass(548, *[0.0021, 0.0021, 0.0021])
    ops.mass(549, *[0.002, 0.002, 0.002])
    ops.mass(550, *[0.0022, 0.0022, 0.0022])
    ops.mass(551, *[0.0016, 0.0016, 0.0016])
    ops.mass(601, *[0.0016, 0.0016, 0.0016])
    ops.mass(602, *[0.0016, 0.0016, 0.0016])
    ops.mass(603, *[0.0011, 0.0011, 0.0011])
    ops.mass(604, *[0.0022, 0.0022, 0.0022])
    ops.mass(605, *[0.0011, 0.0011, 0.0011])
    ops.mass(606, *[0.003, 0.003, 0.003])
    ops.mass(607, *[0.002, 0.002, 0.002])
    ops.mass(608, *[0.0013, 0.0013, 0.0013])
    ops.mass(609, *[0.0008, 0.0008, 0.0008])
    ops.mass(610, *[0.0011, 0.0011, 0.0011])
    ops.mass(611, *[0.001, 0.001, 0.001])
    ops.mass(612, *[0.001, 0.001, 0.001])
    ops.mass(613, *[0.0005, 0.0005, 0.0005])
    ops.mass(614, *[0.0016, 0.0016, 0.0016])
    ops.mass(615, *[0.0013, 0.0013, 0.0013])
    ops.mass(616, *[0.0013, 0.0013, 0.0013])
    ops.mass(617, *[0.0013, 0.0013, 0.0013])
    ops.mass(618, *[0.0014, 0.0014, 0.0014])
    ops.mass(619, *[0.0007, 0.0007, 0.0007])
    ops.mass(620, *[0.0011, 0.0011, 0.0011])
    ops.mass(621, *[0.0023, 0.0023, 0.0023])
    ops.mass(622, *[0.0009, 0.0009, 0.0009])
    ops.mass(623, *[0.0014, 0.0014, 0.0014])
    ops.mass(624, *[0.0017, 0.0017, 0.0017])
    ops.mass(625, *[0.0014, 0.0014, 0.0014])
    ops.mass(626, *[0.001, 0.001, 0.001])
    ops.mass(627, *[0.0015, 0.0015, 0.0015])
    ops.mass(628, *[0.0012, 0.0012, 0.0012])
    ops.mass(629, *[0.0017, 0.0017, 0.0017])
    ops.mass(630, *[0.0018, 0.0018, 0.0018])
    ops.mass(631, *[0.0014, 0.0014, 0.0014])
    ops.mass(632, *[0.0008, 0.0008, 0.0008])
    ops.mass(633, *[0.0005, 0.0005, 0.0005])
    ops.mass(634, *[0.0015, 0.0015, 0.0015])
    ops.mass(645, *[0.0014, 0.0014, 0.0014])
    ops.mass(646, *[0.0013, 0.0013, 0.0013])
    ops.mass(647, *[0.0013, 0.0013, 0.0013])
    ops.mass(648, *[0.0014, 0.0014, 0.0014])
    ops.mass(649, *[0.0014, 0.0014, 0.0014])
    ops.mass(650, *[0.0003, 0.0003, 0.0003])
    ops.mass(651, *[0.0005, 0.0005, 0.0005])
    ops.mass(652, *[0.0007, 0.0007, 0.0007])
    ops.mass(653, *[0.001, 0.001, 0.001])
    ops.mass(654, *[0.0002, 0.0002, 0.0002])
    ops.mass(655, *[0.0004, 0.0004, 0.0004])
    ops.mass(656, *[0.0008, 0.0008, 0.0008])
    ops.mass(657, *[0.0007, 0.0007, 0.0007])
    ops.mass(658, *[0.0008, 0.0008, 0.0008])
    ops.mass(659, *[0.0005, 0.0005, 0.0005])
    ops.mass(660, *[0.0004, 0.0004, 0.0004])
    ops.mass(661, *[0.0007, 0.0007, 0.0007])
    ops.mass(662, *[0.0006, 0.0006, 0.0006])
    ops.mass(663, *[0.0009, 0.0009, 0.0009])
    ops.mass(664, *[0.0007, 0.0007, 0.0007])
    ops.mass(665, *[0.0006, 0.0006, 0.0006])
    ops.mass(666, *[0.0006, 0.0006, 0.0006])
    ops.mass(667, *[0.0009, 0.0009, 0.0009])
    ops.mass(668, *[0.0016, 0.0016, 0.0016])
    ops.mass(669, *[0.0011, 0.0011, 0.0011])
    ops.mass(670, *[0.0009, 0.0009, 0.0009])
    ops.mass(671, *[0.0015, 0.0015, 0.0015])
    ops.mass(672, *[0.0012, 0.0012, 0.0012])
    ops.mass(673, *[0.0008, 0.0008, 0.0008])
    ops.mass(674, *[0.0014, 0.0014, 0.0014])
    ops.mass(675, *[0.0012, 0.0012, 0.0012])
    ops.mass(676, *[0.0006, 0.0006, 0.0006])
    ops.mass(677, *[0.0018, 0.0018, 0.0018])
    ops.mass(678, *[0.0014, 0.0014, 0.0014])
    ops.mass(679, *[0.0007, 0.0007, 0.0007])
    ops.mass(680, *[0.001, 0.001, 0.001])
    ops.mass(681, *[0.0014, 0.0014, 0.0014])
    ops.mass(682, *[0.0005, 0.0005, 0.0005])
    ops.mass(683, *[0.001, 0.001, 0.001])
    ops.mass(684, *[0.0015, 0.0015, 0.0015])
    ops.mass(702, *[0.001, 0.001, 0.001])
    ops.mass(703, *[0.0007, 0.0007, 0.0007])
    ops.mass(704, *[0.0008, 0.0008, 0.0008])
    ops.mass(705, *[0.0008, 0.0008, 0.0008])
    ops.mass(706, *[0.001, 0.001, 0.001])
    ops.mass(707, *[0.0012, 0.0012, 0.0012])
    ops.mass(708, *[0.0015, 0.0015, 0.0015])
    ops.mass(709, *[0.0014, 0.0014, 0.0014])
    ops.mass(710, *[0.0011, 0.0011, 0.0011])
    ops.mass(711, *[0.0012, 0.0012, 0.0012])
    ops.mass(712, *[0.0012, 0.0012, 0.0012])
    ops.mass(713, *[0.0006, 0.0006, 0.0006])
    ops.mass(714, *[0.0007, 0.0007, 0.0007])
    ops.mass(715, *[0.0006, 0.0006, 0.0006])
    ops.mass(716, *[0.0006, 0.0006, 0.0006])
    ops.mass(717, *[0.0005, 0.0005, 0.0005])
    ops.mass(718, *[0.0007, 0.0007, 0.0007])
    ops.mass(719, *[0.0003, 0.0003, 0.0003])
    ops.mass(720, *[0.0007, 0.0007, 0.0007])
    ops.mass(721, *[0.0006, 0.0006, 0.0006])
    ops.mass(722, *[0.0004, 0.0004, 0.0004])
    ops.mass(723, *[0.0011, 0.0011, 0.0011])
    ops.mass(724, *[0.0006, 0.0006, 0.0006])
    ops.mass(725, *[0.0005, 0.0005, 0.0005])
    ops.mass(726, *[0.0006, 0.0006, 0.0006])
    ops.mass(727, *[0.0006, 0.0006, 0.0006])
    ops.mass(728, *[0.0003, 0.0003, 0.0003])
    ops.mass(729, *[0.0008, 0.0008, 0.0008])
    ops.mass(730, *[0.0007, 0.0007, 0.0007])
    ops.mass(731, *[0.0006, 0.0006, 0.0006])
    ops.mass(732, *[0.0011, 0.0011, 0.0011])
    ops.mass(733, *[0.0005, 0.0005, 0.0005])
    ops.mass(734, *[0.0007, 0.0007, 0.0007])
    ops.mass(735, *[0.0008, 0.0008, 0.0008])
    ops.mass(736, *[0.0003, 0.0003, 0.0003])
    ops.mass(737, *[0.0008, 0.0008, 0.0008])
    ops.mass(738, *[0.001, 0.001, 0.001])
    ops.mass(739, *[0.0005, 0.0005, 0.0005])
    ops.mass(740, *[0.001, 0.001, 0.001])
    ops.mass(741, *[0.0008, 0.0008, 0.0008])
    ops.mass(742, *[0.0009, 0.0009, 0.0009])
    ops.mass(743, *[0.0009, 0.0009, 0.0009])
    ops.mass(744, *[0.0012, 0.0012, 0.0012])
    ops.mass(745, *[0.0009, 0.0009, 0.0009])
    ops.mass(746, *[0.001, 0.001, 0.001])
    ops.mass(747, *[0.0005, 0.0005, 0.0005])
    ops.mass(748, *[0.0012, 0.0012, 0.0012])
    ops.mass(749, *[0.0007, 0.0007, 0.0007])
    ops.mass(750, *[0.0016, 0.0016, 0.0016])
    ops.mass(751, *[0.0013, 0.0013, 0.0013])
    ops.mass(752, *[0.0011, 0.0011, 0.0011])
    ops.mass(753, *[0.0001, 0.0001, 0.0001])
    ops.mass(754, *[0.0006, 0.0006, 0.0006])
    ops.mass(755, *[0.0005, 0.0005, 0.0005])
    ops.mass(756, *[0.0009, 0.0009, 0.0009])
    ops.mass(757, *[0.0009, 0.0009, 0.0009])
    ops.mass(758, *[0.0006, 0.0006, 0.0006])
    ops.mass(759, *[0.0006, 0.0006, 0.0006])
    ops.mass(760, *[0.0009, 0.0009, 0.0009])
    ops.mass(761, *[0.0008, 0.0008, 0.0008])
    ops.mass(762, *[0.0008, 0.0008, 0.0008])
    ops.mass(763, *[0.0008, 0.0008, 0.0008])
    ops.mass(764, *[0.0005, 0.0005, 0.0005])
    ops.mass(765, *[0.0003, 0.0003, 0.0003])
    ops.mass(766, *[0.0005, 0.0005, 0.0005])
    ops.mass(767, *[0.0007, 0.0007, 0.0007])
    ops.mass(768, *[0.0005, 0.0005, 0.0005])
    ops.mass(769, *[0.0007, 0.0007, 0.0007])
    ops.mass(770, *[0.0009, 0.0009, 0.0009])
    ops.mass(771, *[0.0007, 0.0007, 0.0007])
    ops.mass(772, *[0.0002, 0.0002, 0.0002])
    ops.mass(1121, *[0.0016, 0.0016, 0.0016])
    ops.mass(1122, *[0.0029, 0.0029, 0.0029])
    ops.mass(1123, *[0.0042, 0.0042, 0.0042])
    ops.mass(1124, *[0.0033, 0.0033, 0.0033])
    ops.mass(1125, *[0.0021, 0.0021, 0.0021])
    ops.mass(1126, *[0.0028, 0.0028, 0.0028])
    ops.mass(1127, *[0.0027, 0.0027, 0.0027])
    ops.mass(1128, *[0.0011, 0.0011, 0.0011])
    ops.mass(1129, *[0.0032, 0.0032, 0.0032])
    ops.mass(1130, *[0.0043, 0.0043, 0.0043])
    ops.mass(1131, *[0.0017, 0.0017, 0.0017])
    ops.mass(1132, *[0.0019, 0.0019, 0.0019])
    ops.mass(1133, *[0.0019, 0.0019, 0.0019])
    ops.mass(1134, *[0.0037, 0.0037, 0.0037])
    ops.mass(1135, *[0.0044, 0.0044, 0.0044])
    ops.mass(1136, *[0.0018, 0.0018, 0.0018])
    ops.mass(1137, *[0.0037, 0.0037, 0.0037])
    ops.mass(1138, *[0.0025, 0.0025, 0.0025])
    ops.mass(1139, *[0.0019, 0.0019, 0.0019])
    ops.mass(1140, *[0.0035, 0.0035, 0.0035])
    ops.mass(1141, *[0.0021, 0.0021, 0.0021])
    ops.mass(1142, *[0.0012, 0.0012, 0.0012])
    ops.mass(1143, *[0.0013, 0.0013, 0.0013])
    ops.mass(1144, *[0.0017, 0.0017, 0.0017])
    ops.mass(1145, *[0.0009, 0.0009, 0.0009])
    ops.mass(1146, *[0.0033, 0.0033, 0.0033])
    ops.mass(1147, *[0.0024, 0.0024, 0.0024])
    ops.mass(1148, *[0.0014, 0.0014, 0.0014])
    ops.mass(1149, *[0.0034, 0.0034, 0.0034])
    ops.mass(1150, *[0.0112, 0.0112, 0.0112])
    ops.mass(1151, *[0.0017, 0.0017, 0.0017])
    ops.mass(1152, *[0.0025, 0.0025, 0.0025])
    ops.mass(1153, *[0.003, 0.003, 0.003])
    ops.mass(1154, *[0.0019, 0.0019, 0.0019])
    ops.mass(1155, *[0.0059, 0.0059, 0.0059])
    ops.mass(1156, *[0.0017, 0.0017, 0.0017])
    ops.mass(1157, *[0.0034, 0.0034, 0.0034])
    ops.mass(1158, *[0.0053, 0.0053, 0.0053])
    ops.mass(1159, *[0.0031, 0.0031, 0.0031])
    ops.mass(1160, *[0.0016, 0.0016, 0.0016])
    ops.mass(1161, *[0.001, 0.001, 0.001])
    ops.mass(1162, *[0.0018, 0.0018, 0.0018])
    ops.mass(1163, *[0.002, 0.002, 0.002])
    ops.mass(1164, *[0.0016, 0.0016, 0.0016])
    ops.mass(1165, *[0.0019, 0.0019, 0.0019])
    ops.mass(1166, *[0.0015, 0.0015, 0.0015])
    ops.mass(1167, *[0.0005, 0.0005, 0.0005])
    ops.mass(1168, *[0.0005, 0.0005, 0.0005])
    ops.mass(1169, *[0.0013, 0.0013, 0.0013])
    ops.mass(1170, *[0.0043, 0.0043, 0.0043])
    ops.mass(1171, *[0.001, 0.001, 0.001])
    ops.mass(1172, *[0.002, 0.002, 0.002])
    ops.mass(1173, *[0.0005, 0.0005, 0.0005])
    ops.mass(1174, *[0.0016, 0.0016, 0.0016])
    ops.mass(1175, *[0.0027, 0.0027, 0.0027])
    ops.mass(1176, *[0.003, 0.003, 0.003])
    ops.mass(1177, *[0.0026, 0.0026, 0.0026])
    ops.mass(1178, *[0.0013, 0.0013, 0.0013])
    ops.mass(1179, *[0.0017, 0.0017, 0.0017])
    ops.mass(1180, *[0.0011, 0.0011, 0.0011])
    ops.mass(1181, *[0.0021, 0.0021, 0.0021])
    ops.mass(1182, *[0.0033, 0.0033, 0.0033])
    ops.mass(1183, *[0.0026, 0.0026, 0.0026])
    ops.mass(1184, *[0.0022, 0.0022, 0.0022])
    ops.mass(1185, *[0.0024, 0.0024, 0.0024])
    ops.mass(1186, *[0.0028, 0.0028, 0.0028])
    ops.mass(1187, *[0.0017, 0.0017, 0.0017])
    ops.mass(1188, *[0.0016, 0.0016, 0.0016])
    ops.mass(1189, *[0.0017, 0.0017, 0.0017])
    ops.mass(1190, *[0.0038, 0.0038, 0.0038])
    ops.mass(1191, *[0.0045, 0.0045, 0.0045])
    ops.mass(1192, *[0.0011, 0.0011, 0.0011])
    ops.mass(1193, *[0.0017, 0.0017, 0.0017])
    ops.mass(1194, *[0.0028, 0.0028, 0.0028])
    ops.mass(1195, *[0.0036, 0.0036, 0.0036])
    ops.mass(1196, *[0.0018, 0.0018, 0.0018])
    ops.mass(1197, *[0.0023, 0.0023, 0.0023])
    ops.mass(1198, *[0.0022, 0.0022, 0.0022])
    ops.mass(1199, *[0.0013, 0.0013, 0.0013])
    ops.mass(1200, *[0.0018, 0.0018, 0.0018])
    ops.mass(1201, *[0.0029, 0.0029, 0.0029])
    ops.mass(1202, *[0.0046, 0.0046, 0.0046])
    ops.mass(1203, *[0.0032, 0.0032, 0.0032])
    ops.mass(1204, *[0.004, 0.004, 0.004])
    ops.mass(1205, *[0.0017, 0.0017, 0.0017])
    ops.mass(1206, *[0.0043, 0.0043, 0.0043])
    ops.mass(1207, *[0.0011, 0.0011, 0.0011])
    ops.mass(1208, *[0.0036, 0.0036, 0.0036])
    ops.mass(1209, *[0.0023, 0.0023, 0.0023])
    ops.mass(1210, *[0.0024, 0.0024, 0.0024])
    ops.mass(1211, *[0.0019, 0.0019, 0.0019])
    ops.mass(1212, *[0.0017, 0.0017, 0.0017])
    ops.mass(1213, *[0.0016, 0.0016, 0.0016])
    ops.mass(1214, *[0.0026, 0.0026, 0.0026])
    ops.mass(1215, *[0.0041, 0.0041, 0.0041])
    ops.mass(1216, *[0.0035, 0.0035, 0.0035])
    ops.mass(1217, *[0.0023, 0.0023, 0.0023])
    ops.mass(1218, *[0.002, 0.002, 0.002])
    ops.mass(1219, *[0.0015, 0.0015, 0.0015])
    ops.mass(1220, *[0.0027, 0.0027, 0.0027])
    ops.mass(1221, *[0.005, 0.005, 0.005])
    ops.mass(1222, *[0.0026, 0.0026, 0.0026])
    ops.mass(1223, *[0.0025, 0.0025, 0.0025])
    ops.mass(1224, *[0.0028, 0.0028, 0.0028])
    ops.mass(1225, *[0.0012, 0.0012, 0.0012])
    ops.mass(1226, *[0.0017, 0.0017, 0.0017])
    ops.mass(1227, *[0.0022, 0.0022, 0.0022])
    ops.mass(1228, *[0.0031, 0.0031, 0.0031])
    ops.mass(1229, *[0.0053, 0.0053, 0.0053])
    ops.mass(1230, *[0.0015, 0.0015, 0.0015])
    ops.mass(1231, *[0.0036, 0.0036, 0.0036])
    ops.mass(1232, *[0.0036, 0.0036, 0.0036])
    ops.mass(1233, *[0.0016, 0.0016, 0.0016])
    ops.mass(1234, *[0.001, 0.001, 0.001])
    ops.mass(1235, *[0.0022, 0.0022, 0.0022])
    ops.mass(1236, *[0.0018, 0.0018, 0.0018])
    ops.mass(1237, *[0.0011, 0.0011, 0.0011])
    ops.mass(1238, *[0.0034, 0.0034, 0.0034])
    ops.mass(1239, *[0.0006, 0.0006, 0.0006])
    ops.mass(1240, *[0.0023, 0.0023, 0.0023])
    ops.mass(1241, *[0.0016, 0.0016, 0.0016])
    ops.mass(1242, *[0.002, 0.002, 0.002])
    ops.mass(1243, *[0.0009, 0.0009, 0.0009])
    ops.mass(1244, *[0.0011, 0.0011, 0.0011])
    ops.mass(1245, *[0.002, 0.002, 0.002])
    ops.mass(1246, *[0.0042, 0.0042, 0.0042])
    ops.mass(1247, *[0.0016, 0.0016, 0.0016])
    ops.mass(1248, *[0.0014, 0.0014, 0.0014])
    ops.mass(1249, *[0.0022, 0.0022, 0.0022])
    ops.mass(1250, *[0.0008, 0.0008, 0.0008])
    ops.mass(1251, *[0.0022, 0.0022, 0.0022])
    ops.mass(1252, *[0.0007, 0.0007, 0.0007])
    ops.mass(1253, *[0.0012, 0.0012, 0.0012])
    ops.mass(1254, *[0.0003, 0.0003, 0.0003])
    ops.mass(1255, *[0.0017, 0.0017, 0.0017])
    ops.mass(1256, *[0.0015, 0.0015, 0.0015])
    ops.mass(1257, *[0.0016, 0.0016, 0.0016])
    ops.mass(1258, *[0.0026, 0.0026, 0.0026])
    ops.mass(1259, *[0.0001, 0.0001, 0.0001])
    ops.mass(1260, *[0.0006, 0.0006, 0.0006])
    ops.mass(1261, *[0.0002, 0.0002, 0.0002])
    ops.mass(1262, *[0.0008, 0.0008, 0.0008])
    ops.mass(1263, *[0.0009, 0.0009, 0.0009])
    ops.mass(1264, *[0.0003, 0.0003, 0.0003])
    ops.mass(1265, *[0.0006, 0.0006, 0.0006])
    ops.mass(1266, *[0.0004, 0.0004, 0.0004])
    ops.mass(1267, *[0.0017, 0.0017, 0.0017])
    ops.mass(1268, *[0.0004, 0.0004, 0.0004])
    ops.mass(1269, *[0.0009, 0.0009, 0.0009])
    ops.mass(1270, *[0.0014, 0.0014, 0.0014])
    ops.mass(1271, *[0.001, 0.001, 0.001])
    ops.mass(1272, *[0.0016, 0.0016, 0.0016])
    ops.mass(1273, *[0.0007, 0.0007, 0.0007])
    ops.mass(1274, *[0.0007, 0.0007, 0.0007])
    ops.mass(1275, *[0.0013, 0.0013, 0.0013])
    ops.mass(1276, *[0.001, 0.001, 0.001])
    ops.mass(1277, *[0.0015, 0.0015, 0.0015])
    ops.mass(1278, *[0.0009, 0.0009, 0.0009])
    ops.mass(1279, *[0.001, 0.001, 0.001])
    ops.mass(1280, *[0.0011, 0.0011, 0.0011])
    ops.mass(1281, *[0.0016, 0.0016, 0.0016])
    ops.mass(1282, *[0.002, 0.002, 0.002])
    ops.mass(1283, *[0.0013, 0.0013, 0.0013])
    ops.mass(1284, *[0.0009, 0.0009, 0.0009])
    ops.mass(1285, *[0.0021, 0.0021, 0.0021])
    ops.mass(1286, *[0.0014, 0.0014, 0.0014])
    ops.mass(1287, *[0.0021, 0.0021, 0.0021])
    ops.mass(1288, *[0.0012, 0.0012, 0.0012])
    ops.mass(1289, *[0.0011, 0.0011, 0.0011])
    ops.mass(1290, *[0.0013, 0.0013, 0.0013])
    ops.mass(1291, *[0.0017, 0.0017, 0.0017])
    ops.mass(1292, *[0.0016, 0.0016, 0.0016])
    ops.mass(1293, *[0.0015, 0.0015, 0.0015])
    ops.mass(1294, *[0.0009, 0.0009, 0.0009])
    ops.mass(1295, *[0.0015, 0.0015, 0.0015])
    ops.mass(1296, *[0.0019, 0.0019, 0.0019])
    ops.mass(1297, *[0.0012, 0.0012, 0.0012])
    ops.mass(1298, *[0.0019, 0.0019, 0.0019])
    ops.mass(1299, *[0.0013, 0.0013, 0.0013])
    ops.mass(1300, *[0.0044, 0.0044, 0.0044])
    ops.mass(1301, *[0.0022, 0.0022, 0.0022])
    ops.mass(1302, *[0.0013, 0.0013, 0.0013])
    ops.mass(1303, *[0.0021, 0.0021, 0.0021])
    ops.mass(1304, *[0.0009, 0.0009, 0.0009])
    ops.mass(1305, *[0.0013, 0.0013, 0.0013])
    ops.mass(1306, *[0.0025, 0.0025, 0.0025])
    ops.mass(1307, *[0.0009, 0.0009, 0.0009])
    ops.mass(1308, *[0.0012, 0.0012, 0.0012])
    ops.mass(1309, *[0.0022, 0.0022, 0.0022])
    ops.mass(1310, *[0.0015, 0.0015, 0.0015])
    ops.mass(1311, *[0.0017, 0.0017, 0.0017])
    ops.mass(1312, *[0.0032, 0.0032, 0.0032])
    ops.mass(1313, *[0.0021, 0.0021, 0.0021])
    ops.mass(1314, *[0.0008, 0.0008, 0.0008])
    ops.mass(1315, *[0.0011, 0.0011, 0.0011])
    ops.mass(1316, *[0.0015, 0.0015, 0.0015])
    ops.mass(1317, *[0.0013, 0.0013, 0.0013])
    ops.mass(1318, *[0.0016, 0.0016, 0.0016])
    ops.mass(1319, *[0.0018, 0.0018, 0.0018])
    ops.mass(1320, *[0.0009, 0.0009, 0.0009])
    ops.mass(1321, *[0.0012, 0.0012, 0.0012])
    ops.mass(1322, *[0.002, 0.002, 0.002])
    ops.mass(1323, *[0.001, 0.001, 0.001])
    ops.mass(1324, *[0.0018, 0.0018, 0.0018])
    ops.mass(1325, *[0.0018, 0.0018, 0.0018])
    ops.mass(1326, *[0.0014, 0.0014, 0.0014])
    ops.mass(1327, *[0.002, 0.002, 0.002])
    ops.mass(1328, *[0.0011, 0.0011, 0.0011])
    ops.mass(1329, *[0.0024, 0.0024, 0.0024])
    ops.mass(1330, *[0.0012, 0.0012, 0.0012])
    ops.mass(1331, *[0.0016, 0.0016, 0.0016])
    ops.mass(1332, *[0.0018, 0.0018, 0.0018])
    ops.mass(1333, *[0.0016, 0.0016, 0.0016])
    ops.mass(1334, *[0.0012, 0.0012, 0.0012])
    ops.mass(1335, *[0.0016, 0.0016, 0.0016])
    ops.mass(1336, *[0.0016, 0.0016, 0.0016])
    ops.mass(1337, *[0.0016, 0.0016, 0.0016])
    ops.mass(1338, *[0.0026, 0.0026, 0.0026])
    ops.mass(1339, *[0.0017, 0.0017, 0.0017])
    ops.mass(1340, *[0.0021, 0.0021, 0.0021])
    ops.mass(1341, *[0.0021, 0.0021, 0.0021])
    ops.mass(1342, *[0.0024, 0.0024, 0.0024])
    ops.mass(1343, *[0.0012, 0.0012, 0.0012])
    ops.mass(1344, *[0.0019, 0.0019, 0.0019])
    ops.mass(1345, *[0.0016, 0.0016, 0.0016])
    ops.mass(1346, *[0.0013, 0.0013, 0.0013])
    ops.mass(1347, *[0.002, 0.002, 0.002])
    ops.mass(1348, *[0.0016, 0.0016, 0.0016])
    ops.mass(1349, *[0.0019, 0.0019, 0.0019])
    ops.mass(1350, *[0.0017, 0.0017, 0.0017])
    ops.mass(1351, *[0.0011, 0.0011, 0.0011])
    ops.mass(1352, *[0.0046, 0.0046, 0.0046])
    ops.mass(1353, *[0.001, 0.001, 0.001])
    ops.mass(1354, *[0.0019, 0.0019, 0.0019])
    ops.mass(1355, *[0.0015, 0.0015, 0.0015])
    ops.mass(1356, *[0.0016, 0.0016, 0.0016])
    ops.mass(1357, *[0.0022, 0.0022, 0.0022])
    ops.mass(1358, *[0.0013, 0.0013, 0.0013])
    ops.mass(1359, *[0.0016, 0.0016, 0.0016])
    ops.mass(1360, *[0.0012, 0.0012, 0.0012])
    ops.mass(1361, *[0.0014, 0.0014, 0.0014])
    ops.mass(1362, *[0.0025, 0.0025, 0.0025])
    ops.mass(1363, *[0.0021, 0.0021, 0.0021])
    ops.mass(1364, *[0.0012, 0.0012, 0.0012])
    ops.mass(1365, *[0.0012, 0.0012, 0.0012])
    ops.mass(1366, *[0.0018, 0.0018, 0.0018])
    ops.mass(1367, *[0.0012, 0.0012, 0.0012])
    ops.mass(1368, *[0.0019, 0.0019, 0.0019])
    ops.mass(1369, *[0.0012, 0.0012, 0.0012])
    ops.mass(1370, *[0.0014, 0.0014, 0.0014])
    ops.mass(1371, *[0.0013, 0.0013, 0.0013])
    ops.mass(1372, *[0.002, 0.002, 0.002])
    ops.mass(1373, *[0.0028, 0.0028, 0.0028])
    ops.mass(1374, *[0.0014, 0.0014, 0.0014])
    ops.mass(1375, *[0.0022, 0.0022, 0.0022])
    ops.mass(1376, *[0.0013, 0.0013, 0.0013])
    ops.mass(1377, *[0.0016, 0.0016, 0.0016])
    ops.mass(1378, *[0.0017, 0.0017, 0.0017])
    ops.mass(1379, *[0.0028, 0.0028, 0.0028])
    ops.mass(1380, *[0.0044, 0.0044, 0.0044])
    ops.mass(1381, *[0.0021, 0.0021, 0.0021])
    ops.mass(1382, *[0.0023, 0.0023, 0.0023])
    ops.mass(1383, *[0.0015, 0.0015, 0.0015])
    ops.mass(1384, *[0.0016, 0.0016, 0.0016])
    ops.mass(1385, *[0.0023, 0.0023, 0.0023])
    ops.mass(1386, *[0.0017, 0.0017, 0.0017])
    ops.mass(1387, *[0.0023, 0.0023, 0.0023])
    ops.mass(1388, *[0.0023, 0.0023, 0.0023])
    ops.mass(1389, *[0.002, 0.002, 0.002])
    ops.mass(1390, *[0.0025, 0.0025, 0.0025])
    ops.mass(1391, *[0.0023, 0.0023, 0.0023])
    ops.mass(1392, *[0.0016, 0.0016, 0.0016])
    ops.mass(1393, *[0.0013, 0.0013, 0.0013])
    ops.mass(1394, *[0.0018, 0.0018, 0.0018])
    ops.mass(1395, *[0.0021, 0.0021, 0.0021])
    ops.mass(1396, *[0.002, 0.002, 0.002])
    ops.mass(1397, *[0.0022, 0.0022, 0.0022])
    ops.mass(1398, *[0.003, 0.003, 0.003])
    ops.mass(1399, *[0.0015, 0.0015, 0.0015])
    ops.mass(1400, *[0.0027, 0.0027, 0.0027])
    ops.mass(1401, *[0.0012, 0.0012, 0.0012])
    ops.mass(1402, *[0.0028, 0.0028, 0.0028])
    ops.mass(1403, *[0.0016, 0.0016, 0.0016])
    ops.mass(1404, *[0.0025, 0.0025, 0.0025])
    ops.mass(1405, *[0.0016, 0.0016, 0.0016])
    ops.mass(1406, *[0.0029, 0.0029, 0.0029])
    ops.mass(1407, *[0.0011, 0.0011, 0.0011])
    ops.mass(1408, *[0.0023, 0.0023, 0.0023])
    ops.mass(1409, *[0.002, 0.002, 0.002])
    ops.mass(1410, *[0.003, 0.003, 0.003])
    ops.mass(1411, *[0.0023, 0.0023, 0.0023])
    ops.mass(1412, *[0.001, 0.001, 0.001])
    ops.mass(1413, *[0.0017, 0.0017, 0.0017])
    ops.mass(1414, *[0.0021, 0.0021, 0.0021])
    ops.mass(1415, *[0.0025, 0.0025, 0.0025])
    ops.mass(1416, *[0.0015, 0.0015, 0.0015])
    ops.mass(1417, *[0.0019, 0.0019, 0.0019])
    ops.mass(1418, *[0.0025, 0.0025, 0.0025])
    ops.mass(1419, *[0.0025, 0.0025, 0.0025])
    ops.mass(1420, *[0.0031, 0.0031, 0.0031])
    ops.mass(1421, *[0.0021, 0.0021, 0.0021])
    ops.mass(1422, *[0.0021, 0.0021, 0.0021])
    ops.mass(1423, *[0.0024, 0.0024, 0.0024])
    ops.mass(1424, *[0.0016, 0.0016, 0.0016])
    ops.mass(1425, *[0.0027, 0.0027, 0.0027])
    ops.mass(1426, *[0.0019, 0.0019, 0.0019])
    ops.mass(1427, *[0.0017, 0.0017, 0.0017])
    ops.mass(1428, *[0.0019, 0.0019, 0.0019])
    ops.mass(1429, *[0.0032, 0.0032, 0.0032])
    ops.mass(1430, *[0.0034, 0.0034, 0.0034])
    ops.mass(1431, *[0.0026, 0.0026, 0.0026])
    ops.mass(1432, *[0.0023, 0.0023, 0.0023])
    ops.mass(1433, *[0.0024, 0.0024, 0.0024])
    ops.mass(1434, *[0.0033, 0.0033, 0.0033])
    ops.mass(1435, *[0.0027, 0.0027, 0.0027])
    ops.mass(1436, *[0.002, 0.002, 0.002])
    ops.mass(1437, *[0.0024, 0.0024, 0.0024])
    ops.mass(1438, *[0.0031, 0.0031, 0.0031])
    ops.mass(1439, *[0.0021, 0.0021, 0.0021])
    ops.mass(1440, *[0.0024, 0.0024, 0.0024])
    ops.mass(1441, *[0.0023, 0.0023, 0.0023])
    ops.mass(1442, *[0.0023, 0.0023, 0.0023])
    ops.mass(1443, *[0.0024, 0.0024, 0.0024])
    ops.mass(1444, *[0.0019, 0.0019, 0.0019])
    ops.mass(1445, *[0.0022, 0.0022, 0.0022])
    ops.mass(1446, *[0.0021, 0.0021, 0.0021])
    ops.mass(1447, *[0.0037, 0.0037, 0.0037])
    ops.mass(1448, *[0.0039, 0.0039, 0.0039])
    ops.mass(1449, *[0.0011, 0.0011, 0.0011])
    ops.mass(1450, *[0.0019, 0.0019, 0.0019])
    ops.mass(1451, *[0.0027, 0.0027, 0.0027])
    ops.mass(1452, *[0.0026, 0.0026, 0.0026])
    ops.mass(1453, *[0.0031, 0.0031, 0.0031])
    ops.mass(1454, *[0.0025, 0.0025, 0.0025])
    ops.mass(1455, *[0.0024, 0.0024, 0.0024])
    ops.mass(1456, *[0.0026, 0.0026, 0.0026])
    ops.mass(1457, *[0.0021, 0.0021, 0.0021])
    ops.mass(1458, *[0.0016, 0.0016, 0.0016])
    ops.mass(1459, *[0.0023, 0.0023, 0.0023])
    ops.mass(1460, *[0.0022, 0.0022, 0.0022])
    ops.mass(1461, *[0.002, 0.002, 0.002])
    ops.mass(1462, *[0.0054, 0.0054, 0.0054])
    ops.mass(1463, *[0.0013, 0.0013, 0.0013])
    ops.mass(1464, *[0.0021, 0.0021, 0.0021])
    ops.mass(1465, *[0.0077, 0.0077, 0.0077])
    ops.mass(1466, *[0.0033, 0.0033, 0.0033])
    ops.mass(1467, *[0.0019, 0.0019, 0.0019])
    ops.mass(1468, *[0.0019, 0.0019, 0.0019])
    ops.mass(1469, *[0.0029, 0.0029, 0.0029])
    ops.mass(1470, *[0.0025, 0.0025, 0.0025])
    ops.mass(1471, *[0.0022, 0.0022, 0.0022])
    ops.mass(1472, *[0.002, 0.002, 0.002])
    ops.mass(1473, *[0.0016, 0.0016, 0.0016])
    ops.mass(1474, *[0.0012, 0.0012, 0.0012])
    ops.mass(1475, *[0.004, 0.004, 0.004])
    ops.mass(1476, *[0.002, 0.002, 0.002])
    ops.mass(1477, *[0.0026, 0.0026, 0.0026])
    ops.mass(1478, *[0.0015, 0.0015, 0.0015])
    ops.mass(1479, *[0.0018, 0.0018, 0.0018])
    ops.mass(1480, *[0.0037, 0.0037, 0.0037])
    ops.mass(1481, *[0.0027, 0.0027, 0.0027])
    ops.mass(1482, *[0.0007, 0.0007, 0.0007])
    ops.mass(1483, *[0.0023, 0.0023, 0.0023])
    ops.mass(1484, *[0.0016, 0.0016, 0.0016])
    ops.mass(1485, *[0.0028, 0.0028, 0.0028])
    ops.mass(1486, *[0.002, 0.002, 0.002])
    ops.mass(1487, *[0.003, 0.003, 0.003])
    ops.mass(1488, *[0.0018, 0.0018, 0.0018])
    ops.mass(1489, *[0.0026, 0.0026, 0.0026])
    ops.mass(1490, *[0.0026, 0.0026, 0.0026])
    ops.mass(1491, *[0.0014, 0.0014, 0.0014])
    ops.mass(1492, *[0.0027, 0.0027, 0.0027])
    ops.mass(1493, *[0.0061, 0.0061, 0.0061])
    ops.mass(1494, *[0.0063, 0.0063, 0.0063])
    ops.mass(1495, *[0.0023, 0.0023, 0.0023])
    ops.mass(1496, *[0.0023, 0.0023, 0.0023])
    ops.mass(1497, *[0.0051, 0.0051, 0.0051])
    ops.mass(1498, *[0.0012, 0.0012, 0.0012])
    ops.mass(1499, *[0.0025, 0.0025, 0.0025])
    ops.mass(1500, *[0.0036, 0.0036, 0.0036])
    ops.mass(1501, *[0.0022, 0.0022, 0.0022])
    ops.mass(1502, *[0.0023, 0.0023, 0.0023])
    ops.mass(1503, *[0.0032, 0.0032, 0.0032])
    ops.mass(1504, *[0.0018, 0.0018, 0.0018])
    ops.mass(1505, *[0.0022, 0.0022, 0.0022])
    ops.mass(1506, *[0.0023, 0.0023, 0.0023])
    ops.mass(1507, *[0.0045, 0.0045, 0.0045])
    ops.mass(1508, *[0.0016, 0.0016, 0.0016])
    ops.mass(1509, *[0.0037, 0.0037, 0.0037])
    ops.mass(1510, *[0.0034, 0.0034, 0.0034])
    ops.mass(1511, *[0.0026, 0.0026, 0.0026])
    ops.mass(1512, *[0.0028, 0.0028, 0.0028])
    ops.mass(1513, *[0.0022, 0.0022, 0.0022])
    ops.mass(1514, *[0.0022, 0.0022, 0.0022])
    ops.mass(1515, *[0.0023, 0.0023, 0.0023])
    ops.mass(1516, *[0.0086, 0.0086, 0.0086])
    ops.mass(1517, *[0.0063, 0.0063, 0.0063])
    ops.mass(1518, *[0.0074, 0.0074, 0.0074])
    ops.mass(1519, *[0.0038, 0.0038, 0.0038])
    ops.mass(1520, *[0.0043, 0.0043, 0.0043])
    ops.mass(1521, *[0.0042, 0.0042, 0.0042])
    ops.mass(1522, *[0.0034, 0.0034, 0.0034])
    ops.mass(1523, *[0.0034, 0.0034, 0.0034])
    ops.mass(1524, *[0.0033, 0.0033, 0.0033])
    ops.mass(1525, *[0.0046, 0.0046, 0.0046])
    ops.mass(1526, *[0.005, 0.005, 0.005])
    ops.mass(1527, *[0.0018, 0.0018, 0.0018])
    ops.mass(1528, *[0.0028, 0.0028, 0.0028])
    ops.mass(1529, *[0.0007, 0.0007, 0.0007])
    ops.mass(1530, *[0.0017, 0.0017, 0.0017])
    ops.mass(1531, *[0.0013, 0.0013, 0.0013])
    ops.mass(1532, *[0.0012, 0.0012, 0.0012])
    ops.mass(1533, *[0.0012, 0.0012, 0.0012])
    ops.mass(1534, *[0.0016, 0.0016, 0.0016])
    ops.mass(1535, *[0.0013, 0.0013, 0.0013])
    ops.mass(1536, *[0.0017, 0.0017, 0.0017])
    ops.mass(1537, *[0.0017, 0.0017, 0.0017])
    ops.mass(1538, *[0.0016, 0.0016, 0.0016])
    ops.mass(1539, *[0.0009, 0.0009, 0.0009])
    ops.mass(1540, *[0.0013, 0.0013, 0.0013])
    ops.mass(1541, *[0.001, 0.001, 0.001])
    ops.mass(1542, *[0.0017, 0.0017, 0.0017])
    ops.mass(1543, *[0.0022, 0.0022, 0.0022])
    ops.mass(1544, *[0.0021, 0.0021, 0.0021])
    ops.mass(1545, *[0.0014, 0.0014, 0.0014])
    ops.mass(1546, *[0.0019, 0.0019, 0.0019])
    ops.mass(1547, *[0.0015, 0.0015, 0.0015])
    ops.mass(1548, *[0.0024, 0.0024, 0.0024])
    ops.mass(1549, *[0.0017, 0.0017, 0.0017])
    ops.mass(1550, *[0.0017, 0.0017, 0.0017])
    ops.mass(1551, *[0.0016, 0.0016, 0.0016])
    ops.mass(1552, *[0.0016, 0.0016, 0.0016])
    ops.mass(1553, *[0.0017, 0.0017, 0.0017])
    ops.mass(1554, *[0.0014, 0.0014, 0.0014])
    ops.mass(1555, *[0.0016, 0.0016, 0.0016])
    ops.mass(1556, *[0.0018, 0.0018, 0.0018])
    ops.mass(1557, *[0.0017, 0.0017, 0.0017])
    ops.mass(1558, *[0.0012, 0.0012, 0.0012])
    ops.mass(1559, *[0.0011, 0.0011, 0.0011])
    ops.mass(1560, *[0.0024, 0.0024, 0.0024])
    ops.mass(1561, *[0.0014, 0.0014, 0.0014])
    ops.mass(1562, *[0.0012, 0.0012, 0.0012])
    ops.mass(1563, *[0.0015, 0.0015, 0.0015])
    ops.mass(1564, *[0.002, 0.002, 0.002])
    ops.mass(1565, *[0.0017, 0.0017, 0.0017])
    ops.mass(1566, *[0.0021, 0.0021, 0.0021])
    ops.mass(1567, *[0.0015, 0.0015, 0.0015])
    ops.mass(1568, *[0.0016, 0.0016, 0.0016])
    ops.mass(1569, *[0.002, 0.002, 0.002])
    ops.mass(1570, *[0.0022, 0.0022, 0.0022])
    ops.mass(1571, *[0.0019, 0.0019, 0.0019])
    ops.mass(1572, *[0.0023, 0.0023, 0.0023])
    ops.mass(1573, *[0.0029, 0.0029, 0.0029])
    ops.mass(1574, *[0.0022, 0.0022, 0.0022])
    ops.mass(1575, *[0.0016, 0.0016, 0.0016])
    ops.mass(1576, *[0.0013, 0.0013, 0.0013])
    ops.mass(1577, *[0.0012, 0.0012, 0.0012])
    ops.mass(1578, *[0.0021, 0.0021, 0.0021])
    ops.mass(1579, *[0.0021, 0.0021, 0.0021])
    ops.mass(1580, *[0.0019, 0.0019, 0.0019])
    ops.mass(1581, *[0.0022, 0.0022, 0.0022])
    ops.mass(1582, *[0.002, 0.002, 0.002])
    ops.mass(1583, *[0.0019, 0.0019, 0.0019])
    ops.mass(1584, *[0.0021, 0.0021, 0.0021])
    ops.mass(1585, *[0.002, 0.002, 0.002])
    ops.mass(1586, *[0.0026, 0.0026, 0.0026])
    ops.mass(1587, *[0.0017, 0.0017, 0.0017])
    ops.mass(1588, *[0.0017, 0.0017, 0.0017])
    ops.mass(1589, *[0.0033, 0.0033, 0.0033])
    ops.mass(1590, *[0.0023, 0.0023, 0.0023])
    ops.mass(1591, *[0.0019, 0.0019, 0.0019])
    ops.mass(1592, *[0.0022, 0.0022, 0.0022])
    ops.mass(1593, *[0.0019, 0.0019, 0.0019])
    ops.mass(1594, *[0.0018, 0.0018, 0.0018])
    ops.mass(1595, *[0.0017, 0.0017, 0.0017])
    ops.mass(1596, *[0.0021, 0.0021, 0.0021])
    ops.mass(1597, *[0.0016, 0.0016, 0.0016])
    ops.mass(1598, *[0.0018, 0.0018, 0.0018])
    ops.mass(1599, *[0.0031, 0.0031, 0.0031])
    ops.mass(1600, *[0.0036, 0.0036, 0.0036])
    ops.mass(1601, *[0.0012, 0.0012, 0.0012])
    ops.mass(1602, *[0.001, 0.001, 0.001])
    ops.mass(1603, *[0.0022, 0.0022, 0.0022])
    ops.mass(1604, *[0.0032, 0.0032, 0.0032])
    ops.mass(1605, *[0.0012, 0.0012, 0.0012])
    ops.mass(1606, *[0.0013, 0.0013, 0.0013])
    ops.mass(1607, *[0.0026, 0.0026, 0.0026])
    ops.mass(1608, *[0.0022, 0.0022, 0.0022])
    ops.mass(1609, *[0.0016, 0.0016, 0.0016])
    ops.mass(1610, *[0.0027, 0.0027, 0.0027])
    ops.mass(1611, *[0.002, 0.002, 0.002])
    ops.mass(1612, *[0.002, 0.002, 0.002])
    ops.mass(1613, *[0.0048, 0.0048, 0.0048])
    ops.mass(1614, *[0.007, 0.007, 0.007])
    ops.mass(1615, *[0.0031, 0.0031, 0.0031])
    ops.mass(1616, *[0.0066, 0.0066, 0.0066])
    ops.mass(1617, *[0.0014, 0.0014, 0.0014])
    ops.mass(1618, *[0.0017, 0.0017, 0.0017])
    ops.mass(1619, *[0.0017, 0.0017, 0.0017])
    ops.mass(1620, *[0.0016, 0.0016, 0.0016])
    ops.mass(1621, *[0.002, 0.002, 0.002])
    ops.mass(1622, *[0.0021, 0.0021, 0.0021])
    ops.mass(1623, *[0.0012, 0.0012, 0.0012])
    ops.mass(1624, *[0.0014, 0.0014, 0.0014])
    ops.mass(1625, *[0.0024, 0.0024, 0.0024])
    ops.mass(1626, *[0.0013, 0.0013, 0.0013])
    ops.mass(1627, *[0.0026, 0.0026, 0.0026])
    ops.mass(1628, *[0.0009, 0.0009, 0.0009])
    ops.mass(1629, *[0.0016, 0.0016, 0.0016])
    ops.mass(1630, *[0.0017, 0.0017, 0.0017])
    ops.mass(1631, *[0.002, 0.002, 0.002])
    ops.mass(1632, *[0.0013, 0.0013, 0.0013])
    ops.mass(1633, *[0.0015, 0.0015, 0.0015])
    ops.mass(1634, *[0.0015, 0.0015, 0.0015])
    ops.mass(1635, *[0.0027, 0.0027, 0.0027])
    ops.mass(1636, *[0.0017, 0.0017, 0.0017])
    ops.mass(1637, *[0.0024, 0.0024, 0.0024])
    ops.mass(1638, *[0.0018, 0.0018, 0.0018])
    ops.mass(1639, *[0.0019, 0.0019, 0.0019])
    ops.mass(1640, *[0.002, 0.002, 0.002])
    ops.mass(1641, *[0.0018, 0.0018, 0.0018])
    ops.mass(1642, *[0.0022, 0.0022, 0.0022])
    ops.mass(1643, *[0.0028, 0.0028, 0.0028])
    ops.mass(1644, *[0.0032, 0.0032, 0.0032])
    ops.mass(1645, *[0.0027, 0.0027, 0.0027])
    ops.mass(1646, *[0.0035, 0.0035, 0.0035])
    ops.mass(1647, *[0.0066, 0.0066, 0.0066])
    ops.mass(1648, *[0.0037, 0.0037, 0.0037])
    ops.mass(1649, *[0.0057, 0.0057, 0.0057])
    ops.mass(1650, *[0.0047, 0.0047, 0.0047])
    ops.mass(1651, *[0.0012, 0.0012, 0.0012])
    ops.mass(1652, *[0.0023, 0.0023, 0.0023])
    ops.mass(1653, *[0.0024, 0.0024, 0.0024])
    ops.mass(1654, *[0.002, 0.002, 0.002])
    ops.mass(1655, *[0.0027, 0.0027, 0.0027])
    ops.mass(1656, *[0.0019, 0.0019, 0.0019])
    ops.mass(1657, *[0.0006, 0.0006, 0.0006])
    ops.mass(1658, *[0.0012, 0.0012, 0.0012])
    ops.mass(1659, *[0.0016, 0.0016, 0.0016])
    ops.mass(1660, *[0.0019, 0.0019, 0.0019])
    ops.mass(1661, *[0.0018, 0.0018, 0.0018])
    ops.mass(1662, *[0.0007, 0.0007, 0.0007])
    ops.mass(1663, *[0.0008, 0.0008, 0.0008])
    ops.mass(1664, *[0.0007, 0.0007, 0.0007])
    ops.mass(1665, *[0.0007, 0.0007, 0.0007])
    ops.mass(1666, *[0.0007, 0.0007, 0.0007])
    ops.mass(1667, *[0.0017, 0.0017, 0.0017])
    ops.mass(1668, *[0.0017, 0.0017, 0.0017])
    ops.mass(1669, *[0.002, 0.002, 0.002])
    ops.mass(1670, *[0.0012, 0.0012, 0.0012])
    ops.mass(1671, *[0.0015, 0.0015, 0.0015])
    ops.mass(1672, *[0.0012, 0.0012, 0.0012])
    ops.mass(1673, *[0.001, 0.001, 0.001])
    ops.mass(1674, *[0.0015, 0.0015, 0.0015])
    ops.mass(1675, *[0.0013, 0.0013, 0.0013])
    ops.mass(1676, *[0.0007, 0.0007, 0.0007])
    ops.mass(1677, *[0.002, 0.002, 0.002])
    ops.mass(1678, *[0.0006, 0.0006, 0.0006])
    ops.mass(1679, *[0.0011, 0.0011, 0.0011])
    ops.mass(1680, *[0.0004, 0.0004, 0.0004])
    ops.mass(1681, *[0.0031, 0.0031, 0.0031])
    ops.mass(1682, *[0.0011, 0.0011, 0.0011])
    ops.mass(1683, *[0.0015, 0.0015, 0.0015])
    ops.mass(1684, *[0.0007, 0.0007, 0.0007])
    ops.mass(1685, *[0.0018, 0.0018, 0.0018])
    ops.mass(1686, *[0.0004, 0.0004, 0.0004])
    ops.mass(1687, *[0.0007, 0.0007, 0.0007])
    ops.mass(1688, *[0.002, 0.002, 0.002])
    ops.mass(1689, *[0.0021, 0.0021, 0.0021])
    ops.mass(1690, *[0.0013, 0.0013, 0.0013])
    ops.mass(1691, *[0.001, 0.001, 0.001])
    ops.mass(1692, *[0.0007, 0.0007, 0.0007])
    ops.mass(1693, *[0.0016, 0.0016, 0.0016])
    ops.mass(1694, *[0.001, 0.001, 0.001])
    ops.mass(1695, *[0.0011, 0.0011, 0.0011])
    ops.mass(1696, *[0.0007, 0.0007, 0.0007])
    ops.mass(1697, *[0.0016, 0.0016, 0.0016])
    ops.mass(1698, *[0.0012, 0.0012, 0.0012])
    ops.mass(1699, *[0.0013, 0.0013, 0.0013])
    ops.mass(1700, *[0.0012, 0.0012, 0.0012])
    ops.mass(1701, *[0.0015, 0.0015, 0.0015])
    ops.mass(1702, *[0.0016, 0.0016, 0.0016])
    ops.mass(1703, *[0.0015, 0.0015, 0.0015])
    ops.mass(1704, *[0.001, 0.001, 0.001])
    ops.mass(1705, *[0.0013, 0.0013, 0.0013])
    ops.mass(1706, *[0.0014, 0.0014, 0.0014])
    ops.mass(1707, *[0.0013, 0.0013, 0.0013])
    ops.mass(1708, *[0.0008, 0.0008, 0.0008])
    ops.mass(1709, *[0.0027, 0.0027, 0.0027])
    ops.mass(1710, *[0.001, 0.001, 0.001])
    ops.mass(1711, *[0.0015, 0.0015, 0.0015])
    ops.mass(1712, *[0.0015, 0.0015, 0.0015])
    ops.mass(1713, *[0.0009, 0.0009, 0.0009])
    ops.mass(1714, *[0.0019, 0.0019, 0.0019])
    ops.mass(1715, *[0.0008, 0.0008, 0.0008])
    ops.mass(1716, *[0.0022, 0.0022, 0.0022])
    ops.mass(1717, *[0.0013, 0.0013, 0.0013])
    ops.mass(1718, *[0.0026, 0.0026, 0.0026])
    ops.mass(1719, *[0.0025, 0.0025, 0.0025])
    ops.mass(1720, *[0.0011, 0.0011, 0.0011])
    ops.mass(1721, *[0.0016, 0.0016, 0.0016])
    ops.mass(1722, *[0.0025, 0.0025, 0.0025])
    ops.mass(1723, *[0.0016, 0.0016, 0.0016])
    ops.mass(1724, *[0.0024, 0.0024, 0.0024])
    ops.mass(1725, *[0.0018, 0.0018, 0.0018])
    ops.mass(1726, *[0.0015, 0.0015, 0.0015])
    ops.mass(1727, *[0.002, 0.002, 0.002])
    ops.mass(1728, *[0.0019, 0.0019, 0.0019])
    ops.mass(1729, *[0.0011, 0.0011, 0.0011])
    ops.mass(1730, *[0.0014, 0.0014, 0.0014])
    ops.mass(1731, *[0.002, 0.002, 0.002])
    ops.mass(1732, *[0.0006, 0.0006, 0.0006])
    ops.mass(1733, *[0.0017, 0.0017, 0.0017])
    ops.mass(1734, *[0.0014, 0.0014, 0.0014])
    ops.mass(1735, *[0.0004, 0.0004, 0.0004])
    ops.mass(1736, *[0.0001, 0.0001, 0.0001])
    ops.mass(1737, *[0.0003, 0.0003, 0.0003])
    ops.mass(1738, *[0.0006, 0.0006, 0.0006])
    ops.mass(1739, *[0.0005, 0.0005, 0.0005])
    ops.mass(1740, *[0.0007, 0.0007, 0.0007])
    ops.mass(1741, *[0.0006, 0.0006, 0.0006])
    ops.mass(1742, *[0.0003, 0.0003, 0.0003])
    ops.mass(1743, *[0.0007, 0.0007, 0.0007])
    ops.mass(1744, *[0.0006, 0.0006, 0.0006])
    ops.mass(1745, *[0.0004, 0.0004, 0.0004])
    ops.mass(1746, *[0.0016, 0.0016, 0.0016])
    ops.mass(1747, *[0.0054, 0.0054, 0.0054])
    ops.mass(1748, *[0.0016, 0.0016, 0.0016])
    ops.mass(1749, *[0.0008, 0.0008, 0.0008])
    ops.mass(1750, *[0.0033, 0.0033, 0.0033])
    ops.mass(1751, *[0.0007, 0.0007, 0.0007])
    ops.mass(1752, *[0.0014, 0.0014, 0.0014])
    ops.mass(1753, *[0.0012, 0.0012, 0.0012])
    ops.mass(1754, *[0.002, 0.002, 0.002])
    ops.mass(1755, *[0.0014, 0.0014, 0.0014])
    ops.mass(1756, *[0.0008, 0.0008, 0.0008])
    ops.mass(1757, *[0.0007, 0.0007, 0.0007])
    ops.mass(1758, *[0.0013, 0.0013, 0.0013])
    ops.mass(1759, *[0.0012, 0.0012, 0.0012])
    ops.mass(1760, *[0.0021, 0.0021, 0.0021])
    ops.mass(1761, *[0.0009, 0.0009, 0.0009])
    ops.mass(1762, *[0.0025, 0.0025, 0.0025])
    ops.mass(1763, *[0.0028, 0.0028, 0.0028])
    ops.mass(1764, *[0.0012, 0.0012, 0.0012])
    ops.mass(1765, *[0.0012, 0.0012, 0.0012])
    ops.mass(1766, *[0.0004, 0.0004, 0.0004])
    ops.mass(1767, *[0.0007, 0.0007, 0.0007])
    ops.mass(1768, *[0.0019, 0.0019, 0.0019])
    ops.mass(1769, *[0.001, 0.001, 0.001])
    ops.mass(1770, *[0.001, 0.001, 0.001])
    ops.mass(1771, *[0.0016, 0.0016, 0.0016])
    ops.mass(1772, *[0.0012, 0.0012, 0.0012])
    ops.mass(1773, *[0.0005, 0.0005, 0.0005])
    ops.mass(1774, *[0.0006, 0.0006, 0.0006])
    ops.mass(1775, *[0.0007, 0.0007, 0.0007])
    ops.mass(1776, *[0.002, 0.002, 0.002])
    ops.mass(1777, *[0.0006, 0.0006, 0.0006])
    ops.mass(1778, *[0.0009, 0.0009, 0.0009])
    ops.mass(1779, *[0.002, 0.002, 0.002])
    ops.mass(1780, *[0.0021, 0.0021, 0.0021])
    ops.mass(1781, *[0.0024, 0.0024, 0.0024])
    ops.mass(1782, *[0.0006, 0.0006, 0.0006])
    ops.mass(1783, *[0.0007, 0.0007, 0.0007])
    ops.mass(1784, *[0.0063, 0.0063, 0.0063])
    ops.mass(1785, *[0.0028, 0.0028, 0.0028])
    ops.mass(1786, *[0.0018, 0.0018, 0.0018])
    ops.mass(1787, *[0.0031, 0.0031, 0.0031])
    ops.mass(1788, *[0.0003, 0.0003, 0.0003])
    ops.mass(1789, *[0.0004, 0.0004, 0.0004])
    ops.mass(1790, *[0.001, 0.001, 0.001])
    ops.mass(1791, *[0.0003, 0.0003, 0.0003])
    ops.mass(1792, *[0.0007, 0.0007, 0.0007])
    ops.mass(1793, *[0.0005, 0.0005, 0.0005])
    ops.mass(1794, *[0.0005, 0.0005, 0.0005])
    ops.mass(1795, *[0.0004, 0.0004, 0.0004])
    ops.mass(1796, *[0.002, 0.002, 0.002])
    ops.mass(1797, *[0.0019, 0.0019, 0.0019])
    ops.mass(1798, *[0.0008, 0.0008, 0.0008])
    ops.mass(1799, *[0.0018, 0.0018, 0.0018])
    ops.mass(1800, *[0.0023, 0.0023, 0.0023])
    ops.mass(1801, *[0.0006, 0.0006, 0.0006])
    ops.mass(1802, *[0.0007, 0.0007, 0.0007])
    ops.mass(1803, *[0.0016, 0.0016, 0.0016])
    ops.mass(1804, *[0.0006, 0.0006, 0.0006])
    ops.mass(1805, *[0.0008, 0.0008, 0.0008])
    ops.mass(1806, *[0.0017, 0.0017, 0.0017])
    ops.mass(1807, *[0.0011, 0.0011, 0.0011])
    ops.mass(1808, *[0.0017, 0.0017, 0.0017])
    ops.mass(1809, *[0.0031, 0.0031, 0.0031])
    ops.mass(1810, *[0.0021, 0.0021, 0.0021])
    ops.mass(1811, *[0.0029, 0.0029, 0.0029])
    ops.mass(1812, *[0.0004, 0.0004, 0.0004])
    ops.mass(1813, *[0.0003, 0.0003, 0.0003])
    ops.mass(1814, *[0.0018, 0.0018, 0.0018])
    ops.mass(1815, *[0.0004, 0.0004, 0.0004])
    ops.mass(1816, *[0.0006, 0.0006, 0.0006])
    ops.mass(1817, *[0.0007, 0.0007, 0.0007])
    ops.mass(1818, *[0.0015, 0.0015, 0.0015])
    ops.mass(1819, *[0.0016, 0.0016, 0.0016])
    ops.mass(1820, *[0.0007, 0.0007, 0.0007])
    ops.mass(1821, *[0.0019, 0.0019, 0.0019])
    ops.mass(1822, *[0.0002, 0.0002, 0.0002])
    ops.mass(1823, *[0.0012, 0.0012, 0.0012])
    ops.mass(1824, *[0.0009, 0.0009, 0.0009])
    ops.mass(1825, *[0.0025, 0.0025, 0.0025])
    ops.mass(1826, *[0.001, 0.001, 0.001])
    ops.mass(1827, *[0.0009, 0.0009, 0.0009])
    ops.mass(1828, *[0.0007, 0.0007, 0.0007])
    ops.mass(1829, *[0.0016, 0.0016, 0.0016])
    ops.mass(1830, *[0.0017, 0.0017, 0.0017])
    ops.mass(1831, *[0.0006, 0.0006, 0.0006])
    ops.mass(1832, *[0.0023, 0.0023, 0.0023])
    ops.mass(1833, *[0.001, 0.001, 0.001])
    ops.mass(1834, *[0.0018, 0.0018, 0.0018])
    ops.mass(1835, *[0.0017, 0.0017, 0.0017])
    ops.mass(1836, *[0.0022, 0.0022, 0.0022])
    ops.mass(1837, *[0.0004, 0.0004, 0.0004])
    ops.mass(1838, *[0.0021, 0.0021, 0.0021])
    ops.mass(1839, *[0.0005, 0.0005, 0.0005])
    ops.mass(1840, *[0.001, 0.001, 0.001])
    ops.mass(1841, *[0.0025, 0.0025, 0.0025])
    ops.mass(1842, *[0.0036, 0.0036, 0.0036])
    ops.mass(1843, *[0.0019, 0.0019, 0.0019])
    ops.mass(1844, *[0.0086, 0.0086, 0.0086])
    ops.mass(1845, *[0.0007, 0.0007, 0.0007])
    ops.mass(1846, *[0.0008, 0.0008, 0.0008])
    ops.mass(1847, *[0.0013, 0.0013, 0.0013])
    ops.mass(1848, *[0.0017, 0.0017, 0.0017])
    ops.mass(1849, *[0.0014, 0.0014, 0.0014])
    ops.mass(1850, *[0.0002, 0.0002, 0.0002])
    ops.mass(1851, *[0.0032, 0.0032, 0.0032])
    ops.mass(1852, *[0.0032, 0.0032, 0.0032])
    ops.mass(1853, *[0.0026, 0.0026, 0.0026])
    ops.mass(1854, *[0.0024, 0.0024, 0.0024])
    ops.mass(1855, *[0.0015, 0.0015, 0.0015])
    ops.mass(1856, *[0.0015, 0.0015, 0.0015])
    ops.mass(1857, *[0.0013, 0.0013, 0.0013])
    ops.mass(1858, *[0.0013, 0.0013, 0.0013])
    ops.mass(1859, *[0.0037, 0.0037, 0.0037])
    ops.mass(1860, *[0.0034, 0.0034, 0.0034])
    ops.mass(1861, *[0.0031, 0.0031, 0.0031])
    ops.mass(1862, *[0.0016, 0.0016, 0.0016])
    ops.mass(1863, *[0.0007, 0.0007, 0.0007])
    ops.mass(1864, *[0.0006, 0.0006, 0.0006])
    ops.mass(1865, *[0.0011, 0.0011, 0.0011])
    ops.mass(1866, *[0.0026, 0.0026, 0.0026])
    ops.mass(1867, *[0.0016, 0.0016, 0.0016])
    ops.mass(1868, *[0.0023, 0.0023, 0.0023])
    ops.mass(1869, *[0.0025, 0.0025, 0.0025])
    ops.mass(1870, *[0.0023, 0.0023, 0.0023])
    ops.mass(1871, *[0.0015, 0.0015, 0.0015])
    ops.mass(1872, *[0.0016, 0.0016, 0.0016])
    ops.mass(1873, *[0.0005, 0.0005, 0.0005])
    ops.mass(1874, *[0.0002, 0.0002, 0.0002])
    ops.mass(1875, *[0.0007, 0.0007, 0.0007])
    ops.mass(1876, *[0.0006, 0.0006, 0.0006])
    ops.mass(1877, *[0.0003, 0.0003, 0.0003])
    ops.mass(1878, *[0.0011, 0.0011, 0.0011])
    ops.mass(1879, *[0.0021, 0.0021, 0.0021])
    ops.mass(1880, *[0.0017, 0.0017, 0.0017])
    ops.mass(1881, *[0.0017, 0.0017, 0.0017])
    ops.mass(1882, *[0.0019, 0.0019, 0.0019])
    ops.mass(1883, *[0.0019, 0.0019, 0.0019])
    ops.mass(1884, *[0.0023, 0.0023, 0.0023])
    ops.mass(1885, *[0.0015, 0.0015, 0.0015])
    ops.mass(1886, *[0.0023, 0.0023, 0.0023])
    ops.mass(1887, *[0.0013, 0.0013, 0.0013])
    ops.mass(1888, *[0.0009, 0.0009, 0.0009])
    ops.mass(1889, *[0.001, 0.001, 0.001])
    ops.mass(1890, *[0.0014, 0.0014, 0.0014])
    ops.mass(1891, *[0.0038, 0.0038, 0.0038])
    ops.mass(1892, *[0.0017, 0.0017, 0.0017])
    ops.mass(1893, *[0.0004, 0.0004, 0.0004])
    ops.mass(1894, *[0.0009, 0.0009, 0.0009])
    ops.mass(1895, *[0.0015, 0.0015, 0.0015])
    ops.mass(1896, *[0.0012, 0.0012, 0.0012])
    ops.mass(1897, *[0.001, 0.001, 0.001])
    ops.mass(1898, *[0.0037, 0.0037, 0.0037])
    ops.mass(1899, *[0.0023, 0.0023, 0.0023])
    ops.mass(1900, *[0.0018, 0.0018, 0.0018])
    ops.mass(1901, *[0.0016, 0.0016, 0.0016])
    ops.mass(1902, *[0.0014, 0.0014, 0.0014])
    ops.mass(1903, *[0.0031, 0.0031, 0.0031])
    ops.mass(1904, *[0.0014, 0.0014, 0.0014])
    ops.mass(1905, *[0.0014, 0.0014, 0.0014])
    ops.mass(1906, *[0.0007, 0.0007, 0.0007])
    ops.mass(1907, *[0.0005, 0.0005, 0.0005])
    ops.mass(1908, *[0.001, 0.001, 0.001])
    ops.mass(1909, *[0.0004, 0.0004, 0.0004])
    ops.mass(1910, *[0.0003, 0.0003, 0.0003])
    ops.mass(1911, *[0.0004, 0.0004, 0.0004])
    ops.mass(1912, *[0.0008, 0.0008, 0.0008])
    ops.mass(1913, *[0.0046, 0.0046, 0.0046])
    ops.mass(1914, *[0.001, 0.001, 0.001])
    ops.mass(1915, *[0.0013, 0.0013, 0.0013])
    ops.mass(1916, *[0.0013, 0.0013, 0.0013])
    ops.mass(1917, *[0.0018, 0.0018, 0.0018])
    ops.mass(1918, *[0.0009, 0.0009, 0.0009])
    ops.mass(1919, *[0.0005, 0.0005, 0.0005])
    ops.mass(1920, *[0.0016, 0.0016, 0.0016])
    ops.mass(1921, *[0.0008, 0.0008, 0.0008])
    ops.mass(1922, *[0.0006, 0.0006, 0.0006])
    ops.mass(1923, *[0.0027, 0.0027, 0.0027])
    ops.mass(1924, *[0.0018, 0.0018, 0.0018])
    ops.mass(1925, *[0.0016, 0.0016, 0.0016])
    ops.mass(1926, *[0.0032, 0.0032, 0.0032])
    ops.mass(1927, *[0.0021, 0.0021, 0.0021])
    ops.mass(1928, *[0.0031, 0.0031, 0.0031])
    ops.mass(1929, *[0.0053, 0.0053, 0.0053])
    ops.mass(1930, *[0.0027, 0.0027, 0.0027])
    ops.mass(1931, *[0.0024, 0.0024, 0.0024])
    ops.mass(1932, *[0.0017, 0.0017, 0.0017])
    ops.mass(1933, *[0.0017, 0.0017, 0.0017])
    ops.mass(1934, *[0.0014, 0.0014, 0.0014])
    ops.mass(1935, *[0.0026, 0.0026, 0.0026])
    ops.mass(1936, *[0.0017, 0.0017, 0.0017])
    ops.mass(1937, *[0.0022, 0.0022, 0.0022])
    ops.mass(1938, *[0.0006, 0.0006, 0.0006])
    ops.mass(1939, *[0.0008, 0.0008, 0.0008])
    ops.mass(1940, *[0.0007, 0.0007, 0.0007])
    ops.mass(1941, *[0.0029, 0.0029, 0.0029])
    ops.mass(1942, *[0.0021, 0.0021, 0.0021])
    ops.mass(1943, *[0.0023, 0.0023, 0.0023])
    ops.mass(1944, *[0.0007, 0.0007, 0.0007])
    ops.mass(1945, *[0.0008, 0.0008, 0.0008])
    ops.mass(1946, *[0.0009, 0.0009, 0.0009])
    ops.mass(1947, *[0.0005, 0.0005, 0.0005])
    ops.mass(1948, *[0.0013, 0.0013, 0.0013])
    ops.mass(1949, *[0.0037, 0.0037, 0.0037])
    ops.mass(1950, *[0.0015, 0.0015, 0.0015])
    ops.mass(1951, *[0.0008, 0.0008, 0.0008])
    ops.mass(1952, *[0.0027, 0.0027, 0.0027])
    ops.mass(1953, *[0.0023, 0.0023, 0.0023])
    ops.mass(1954, *[0.0021, 0.0021, 0.0021])
    ops.mass(1955, *[0.0045, 0.0045, 0.0045])
    ops.mass(1956, *[0.0011, 0.0011, 0.0011])
    ops.mass(1957, *[0.0007, 0.0007, 0.0007])
    ops.mass(1958, *[0.002, 0.002, 0.002])
    ops.mass(1959, *[0.0012, 0.0012, 0.0012])
    ops.mass(1960, *[0.0014, 0.0014, 0.0014])
    ops.mass(1961, *[0.0021, 0.0021, 0.0021])
    ops.mass(1962, *[0.0013, 0.0013, 0.0013])
    ops.mass(1963, *[0.0015, 0.0015, 0.0015])
    ops.mass(1964, *[0.0019, 0.0019, 0.0019])
    ops.mass(1965, *[0.0003, 0.0003, 0.0003])
    ops.mass(1966, *[0.0009, 0.0009, 0.0009])
    ops.mass(1967, *[0.0007, 0.0007, 0.0007])
    ops.mass(1968, *[0.001, 0.001, 0.001])
    ops.mass(1969, *[0.0028, 0.0028, 0.0028])
    ops.mass(1970, *[0.0043, 0.0043, 0.0043])
    ops.mass(1971, *[0.0021, 0.0021, 0.0021])
    ops.mass(1972, *[0.0028, 0.0028, 0.0028])
    ops.mass(1973, *[0.0027, 0.0027, 0.0027])
    ops.mass(1974, *[0.0028, 0.0028, 0.0028])
    ops.mass(1975, *[0.0035, 0.0035, 0.0035])
    ops.mass(1976, *[0.0022, 0.0022, 0.0022])
    ops.mass(1977, *[0.0012, 0.0012, 0.0012])
    ops.mass(1978, *[0.0016, 0.0016, 0.0016])
    ops.mass(1979, *[0.0017, 0.0017, 0.0017])
    ops.mass(1980, *[0.0066, 0.0066, 0.0066])
    ops.mass(1981, *[0.0074, 0.0074, 0.0074])
    ops.mass(1982, *[0.0007, 0.0007, 0.0007])
    ops.mass(1983, *[0.0005, 0.0005, 0.0005])
    ops.mass(1984, *[0.0008, 0.0008, 0.0008])
    ops.mass(1985, *[0.0005, 0.0005, 0.0005])
    ops.mass(1986, *[0.0011, 0.0011, 0.0011])
    ops.mass(1987, *[0.0007, 0.0007, 0.0007])
    ops.mass(1988, *[0.0015, 0.0015, 0.0015])
    ops.mass(1989, *[0.001, 0.001, 0.001])
    ops.mass(1990, *[0.0009, 0.0009, 0.0009])
    ops.mass(1991, *[0.0006, 0.0006, 0.0006])
    ops.mass(1992, *[0.0019, 0.0019, 0.0019])
    ops.mass(1993, *[0.0024, 0.0024, 0.0024])
    ops.mass(1994, *[0.0017, 0.0017, 0.0017])
    ops.mass(1995, *[0.0014, 0.0014, 0.0014])
    ops.mass(1996, *[0.0018, 0.0018, 0.0018])
    ops.mass(1997, *[0.0006, 0.0006, 0.0006])
    ops.mass(1998, *[0.0013, 0.0013, 0.0013])
    ops.mass(1999, *[0.0019, 0.0019, 0.0019])
    ops.mass(2000, *[0.0026, 0.0026, 0.0026])
    ops.mass(2001, *[0.0025, 0.0025, 0.0025])
    ops.mass(2002, *[0.0028, 0.0028, 0.0028])
    ops.mass(2003, *[0.0016, 0.0016, 0.0016])
    ops.mass(2004, *[0.0024, 0.0024, 0.0024])
    ops.mass(2005, *[0.001, 0.001, 0.001])
    ops.mass(2006, *[0.0018, 0.0018, 0.0018])
    ops.mass(2007, *[0.0021, 0.0021, 0.0021])
    ops.mass(2008, *[0.0015, 0.0015, 0.0015])
    ops.mass(2009, *[0.002, 0.002, 0.002])
    ops.mass(2010, *[0.0015, 0.0015, 0.0015])
    ops.mass(2011, *[0.0009, 0.0009, 0.0009])
    ops.mass(2012, *[0.0012, 0.0012, 0.0012])
    ops.mass(2013, *[0.0022, 0.0022, 0.0022])
    ops.mass(2014, *[0.0016, 0.0016, 0.0016])
    ops.mass(2015, *[0.0012, 0.0012, 0.0012])
    ops.mass(2016, *[0.002, 0.002, 0.002])
    ops.mass(2017, *[0.0015, 0.0015, 0.0015])
    ops.mass(2018, *[0.0013, 0.0013, 0.0013])
    ops.mass(2019, *[0.0023, 0.0023, 0.0023])
    ops.mass(2020, *[0.0014, 0.0014, 0.0014])
    ops.mass(2021, *[0.0016, 0.0016, 0.0016])
    ops.mass(2022, *[0.0011, 0.0011, 0.0011])
    ops.mass(2023, *[0.0004, 0.0004, 0.0004])
    ops.mass(2024, *[0.0011, 0.0011, 0.0011])
    ops.mass(2025, *[0.0017, 0.0017, 0.0017])
    ops.mass(2026, *[0.0017, 0.0017, 0.0017])
    ops.mass(2027, *[0.0021, 0.0021, 0.0021])
    ops.mass(2028, *[0.0001, 0.0001, 0.0001])
    ops.mass(2029, *[0.0002, 0.0002, 0.0002])
    ops.mass(2030, *[0.001, 0.001, 0.001])
    ops.mass(2031, *[0.0042, 0.0042, 0.0042])
    ops.mass(2032, *[0.0011, 0.0011, 0.0011])
    ops.mass(2033, *[0.0019, 0.0019, 0.0019])
    ops.mass(2034, *[0.0005, 0.0005, 0.0005])
    ops.mass(2035, *[0.0019, 0.0019, 0.0019])
    ops.mass(2036, *[0.0008, 0.0008, 0.0008])
    ops.mass(2037, *[0.001, 0.001, 0.001])
    ops.mass(2038, *[0.0005, 0.0005, 0.0005])
    ops.mass(2039, *[0.0004, 0.0004, 0.0004])
    ops.mass(2040, *[0.0004, 0.0004, 0.0004])
    ops.mass(2041, *[0.0004, 0.0004, 0.0004])
    ops.mass(2042, *[0.0004, 0.0004, 0.0004])
    ops.mass(2043, *[0.0012, 0.0012, 0.0012])
    ops.mass(2044, *[0.0013, 0.0013, 0.0013])
    ops.mass(2045, *[0.0009, 0.0009, 0.0009])
    ops.mass(2046, *[0.0023, 0.0023, 0.0023])
    ops.mass(2047, *[0.0012, 0.0012, 0.0012])
    ops.mass(2048, *[0.003, 0.003, 0.003])
    ops.mass(2049, *[0.0014, 0.0014, 0.0014])
    ops.mass(2050, *[0.0011, 0.0011, 0.0011])
    ops.mass(2051, *[0.0026, 0.0026, 0.0026])
    ops.mass(2052, *[0.0014, 0.0014, 0.0014])
    ops.mass(2053, *[0.0012, 0.0012, 0.0012])
    ops.mass(2054, *[0.0015, 0.0015, 0.0015])
    ops.mass(2055, *[0.0077, 0.0077, 0.0077])
    ops.mass(2056, *[0.0009, 0.0009, 0.0009])
    ops.mass(2057, *[0.0012, 0.0012, 0.0012])
    ops.mass(2058, *[0.0019, 0.0019, 0.0019])
    ops.mass(2059, *[0.0016, 0.0016, 0.0016])
    ops.mass(2060, *[0.0011, 0.0011, 0.0011])
    ops.mass(2061, *[0.0016, 0.0016, 0.0016])
    ops.mass(2062, *[0.0016, 0.0016, 0.0016])
    ops.mass(2063, *[0.0016, 0.0016, 0.0016])
    ops.mass(2064, *[0.0014, 0.0014, 0.0014])
    ops.mass(2065, *[0.0019, 0.0019, 0.0019])
    ops.mass(2066, *[0.0008, 0.0008, 0.0008])
    ops.mass(2067, *[0.0008, 0.0008, 0.0008])
    ops.mass(2068, *[0.0027, 0.0027, 0.0027])
    ops.mass(2069, *[0.001, 0.001, 0.001])
    ops.mass(2070, *[0.0022, 0.0022, 0.0022])
    ops.mass(2071, *[0.002, 0.002, 0.002])
    ops.mass(2072, *[0.0023, 0.0023, 0.0023])
    ops.mass(2073, *[0.0032, 0.0032, 0.0032])
    ops.mass(2074, *[0.0022, 0.0022, 0.0022])
    ops.mass(2075, *[0.0013, 0.0013, 0.0013])
    ops.mass(2076, *[0.0019, 0.0019, 0.0019])
    ops.mass(2077, *[0.0013, 0.0013, 0.0013])
    ops.mass(2078, *[0.002, 0.002, 0.002])
    ops.mass(2079, *[0.0021, 0.0021, 0.0021])
    ops.mass(2080, *[0.0022, 0.0022, 0.0022])
    ops.mass(2081, *[0.0015, 0.0015, 0.0015])
    ops.mass(2082, *[0.001, 0.001, 0.001])
    ops.mass(2083, *[0.0018, 0.0018, 0.0018])
    ops.mass(2084, *[0.0012, 0.0012, 0.0012])
    ops.mass(2085, *[0.0012, 0.0012, 0.0012])
    ops.mass(2086, *[0.0021, 0.0021, 0.0021])
    ops.mass(2087, *[0.0007, 0.0007, 0.0007])
    ops.mass(2088, *[0.0021, 0.0021, 0.0021])
    ops.mass(2089, *[0.001, 0.001, 0.001])
    ops.mass(2090, *[0.0008, 0.0008, 0.0008])
    ops.mass(2091, *[0.001, 0.001, 0.001])
    ops.mass(2092, *[0.0008, 0.0008, 0.0008])
    ops.mass(2093, *[0.0015, 0.0015, 0.0015])
    ops.mass(2094, *[0.0012, 0.0012, 0.0012])
    ops.mass(2095, *[0.0018, 0.0018, 0.0018])
    ops.mass(2096, *[0.0011, 0.0011, 0.0011])
    ops.mass(2097, *[0.0017, 0.0017, 0.0017])
    ops.mass(2098, *[0.0034, 0.0034, 0.0034])
    ops.mass(2099, *[0.002, 0.002, 0.002])
    ops.mass(2100, *[0.0013, 0.0013, 0.0013])
    ops.mass(2101, *[0.001, 0.001, 0.001])
    ops.mass(2102, *[0.0014, 0.0014, 0.0014])
    ops.mass(2103, *[0.0017, 0.0017, 0.0017])
    ops.mass(2104, *[0.0012, 0.0012, 0.0012])
    ops.mass(2105, *[0.0005, 0.0005, 0.0005])
    ops.mass(2106, *[0.001, 0.001, 0.001])
    ops.mass(2107, *[0.002, 0.002, 0.002])
    ops.mass(2108, *[0.0012, 0.0012, 0.0012])
    ops.mass(2109, *[0.0011, 0.0011, 0.0011])
    ops.mass(2110, *[0.0015, 0.0015, 0.0015])
    ops.mass(2111, *[0.0022, 0.0022, 0.0022])
    ops.mass(2112, *[0.001, 0.001, 0.001])
    ops.mass(2113, *[0.0019, 0.0019, 0.0019])
    ops.mass(2114, *[0.0044, 0.0044, 0.0044])
    ops.mass(2115, *[0.0007, 0.0007, 0.0007])
    ops.mass(2116, *[0.0013, 0.0013, 0.0013])
    ops.mass(2117, *[0.0008, 0.0008, 0.0008])
    ops.mass(2118, *[0.0006, 0.0006, 0.0006])
    ops.mass(2119, *[0.0005, 0.0005, 0.0005])
    ops.mass(2120, *[0.0031, 0.0031, 0.0031])
    ops.mass(2121, *[0.0013, 0.0013, 0.0013])
    ops.mass(2122, *[0.0007, 0.0007, 0.0007])
    ops.mass(2123, *[0.0017, 0.0017, 0.0017])
    ops.mass(2124, *[0.0007, 0.0007, 0.0007])
    ops.mass(2125, *[0.0016, 0.0016, 0.0016])
    ops.mass(2126, *[0.0005, 0.0005, 0.0005])
    ops.mass(2127, *[0.0005, 0.0005, 0.0005])
    ops.mass(2128, *[0.0005, 0.0005, 0.0005])
    ops.mass(2129, *[0.0021, 0.0021, 0.0021])
    ops.mass(2130, *[0.0013, 0.0013, 0.0013])
    ops.mass(2131, *[0.0009, 0.0009, 0.0009])
    ops.mass(2132, *[0.0013, 0.0013, 0.0013])
    ops.mass(2133, *[0.0031, 0.0031, 0.0031])
    ops.mass(2134, *[0.003, 0.003, 0.003])
    ops.mass(2135, *[0.0034, 0.0034, 0.0034])
    ops.mass(2136, *[0.0004, 0.0004, 0.0004])
    ops.mass(2137, *[0.0007, 0.0007, 0.0007])
    ops.mass(2138, *[0.0016, 0.0016, 0.0016])
    ops.mass(2139, *[0.0023, 0.0023, 0.0023])
    ops.mass(2140, *[0.0029, 0.0029, 0.0029])
    ops.mass(2141, *[0.0001, 0.0001, 0.0001])
    ops.mass(2142, *[0.0023, 0.0023, 0.0023])
    ops.mass(2143, *[0.0025, 0.0025, 0.0025])
    ops.mass(2144, *[0.0026, 0.0026, 0.0026])
    ops.mass(2145, *[0.0033, 0.0033, 0.0033])
    ops.mass(2146, *[0.0012, 0.0012, 0.0012])
    ops.mass(2147, *[0.0034, 0.0034, 0.0034])
    ops.mass(2148, *[0.001, 0.001, 0.001])
    ops.mass(2149, *[0.0008, 0.0008, 0.0008])
    ops.mass(2150, *[0.0017, 0.0017, 0.0017])
    ops.mass(2151, *[0.0022, 0.0022, 0.0022])
    ops.mass(2152, *[0.0015, 0.0015, 0.0015])
    ops.mass(2153, *[0.0023, 0.0023, 0.0023])
    ops.mass(2154, *[0.0019, 0.0019, 0.0019])
    ops.mass(2155, *[0.002, 0.002, 0.002])
    ops.mass(2156, *[0.0006, 0.0006, 0.0006])
    ops.mass(2157, *[0.0025, 0.0025, 0.0025])
    ops.mass(2158, *[0.0012, 0.0012, 0.0012])
    ops.mass(2159, *[0.0007, 0.0007, 0.0007])
    ops.mass(2160, *[0.0021, 0.0021, 0.0021])
    ops.mass(2161, *[0.0005, 0.0005, 0.0005])
    ops.mass(2162, *[0.0007, 0.0007, 0.0007])
    ops.mass(2163, *[0.0005, 0.0005, 0.0005])
    ops.mass(2164, *[0.0007, 0.0007, 0.0007])
    ops.mass(2165, *[0.0008, 0.0008, 0.0008])
    ops.mass(2166, *[0.001, 0.001, 0.001])
    ops.mass(2167, *[0.0028, 0.0028, 0.0028])
    ops.mass(2168, *[0.0024, 0.0024, 0.0024])
    ops.mass(2169, *[0.0026, 0.0026, 0.0026])
    ops.mass(2170, *[0.0039, 0.0039, 0.0039])
    ops.mass(2171, *[0.0061, 0.0061, 0.0061])
    ops.mass(2172, *[0.0027, 0.0027, 0.0027])
    ops.mass(2173, *[0.002, 0.002, 0.002])
    ops.mass(2174, *[0.0016, 0.0016, 0.0016])
    ops.mass(2175, *[0.0015, 0.0015, 0.0015])
    ops.mass(2176, *[0.0013, 0.0013, 0.0013])
    ops.mass(2177, *[0.0004, 0.0004, 0.0004])
    ops.mass(2178, *[0.001, 0.001, 0.001])
    ops.mass(2179, *[0.0008, 0.0008, 0.0008])
    ops.mass(2180, *[0.0003, 0.0003, 0.0003])
    ops.mass(2181, *[0.0006, 0.0006, 0.0006])
    ops.mass(2182, *[0.0006, 0.0006, 0.0006])
    ops.mass(2183, *[0.0004, 0.0004, 0.0004])
    ops.mass(2184, *[0.0022, 0.0022, 0.0022])
    ops.mass(2185, *[0.0021, 0.0021, 0.0021])
    ops.mass(2186, *[0.002, 0.002, 0.002])
    ops.mass(2187, *[0.0012, 0.0012, 0.0012])
    ops.mass(2188, *[0.001, 0.001, 0.001])
    ops.mass(2189, *[0.0009, 0.0009, 0.0009])
    ops.mass(2190, *[0.0008, 0.0008, 0.0008])
    ops.mass(2191, *[0.0008, 0.0008, 0.0008])
    ops.mass(2192, *[0.0016, 0.0016, 0.0016])
    ops.mass(2193, *[0.0017, 0.0017, 0.0017])
    ops.mass(2194, *[0.0021, 0.0021, 0.0021])
    ops.mass(2195, *[0.0013, 0.0013, 0.0013])
    ops.mass(2196, *[0.0006, 0.0006, 0.0006])
    ops.mass(2197, *[0.0004, 0.0004, 0.0004])
    ops.mass(2198, *[0.0003, 0.0003, 0.0003])
    ops.mass(2199, *[0.0019, 0.0019, 0.0019])
    ops.mass(2200, *[0.0019, 0.0019, 0.0019])
    ops.mass(2201, *[0.0004, 0.0004, 0.0004])
    ops.mass(2202, *[0.0022, 0.0022, 0.0022])
    ops.mass(2203, *[0.002, 0.002, 0.002])
    ops.mass(2204, *[0.0032, 0.0032, 0.0032])
    ops.mass(2205, *[0.0005, 0.0005, 0.0005])
    ops.mass(2206, *[0.0004, 0.0004, 0.0004])
    ops.mass(2207, *[0.0005, 0.0005, 0.0005])
    ops.mass(2208, *[0.0007, 0.0007, 0.0007])
    ops.mass(2209, *[0.0014, 0.0014, 0.0014])
    ops.mass(2210, *[0.0015, 0.0015, 0.0015])
    ops.mass(2211, *[0.002, 0.002, 0.002])
    ops.mass(2212, *[0.0003, 0.0003, 0.0003])
    ops.mass(2213, *[0.0018, 0.0018, 0.0018])
    ops.mass(2214, *[0.0047, 0.0047, 0.0047])
    ops.mass(2215, *[0.0016, 0.0016, 0.0016])
    ops.mass(2216, *[0.0006, 0.0006, 0.0006])
    ops.mass(2217, *[0.0002, 0.0002, 0.0002])
    ops.mass(2218, *[0.0018, 0.0018, 0.0018])
    ops.mass(2219, *[0.0021, 0.0021, 0.0021])
    ops.mass(2220, *[0.0016, 0.0016, 0.0016])
    ops.mass(2221, *[0.0023, 0.0023, 0.0023])
    ops.mass(2222, *[0.0022, 0.0022, 0.0022])
    ops.mass(2223, *[0.0013, 0.0013, 0.0013])
    ops.mass(2224, *[0.0016, 0.0016, 0.0016])
    ops.mass(2225, *[0.0028, 0.0028, 0.0028])
    ops.mass(2226, *[0.0019, 0.0019, 0.0019])
    ops.mass(2227, *[0.0016, 0.0016, 0.0016])
    ops.mass(2228, *[0.0013, 0.0013, 0.0013])
    ops.mass(2229, *[0.0027, 0.0027, 0.0027])
    ops.mass(2230, *[0.0017, 0.0017, 0.0017])
    ops.mass(2231, *[0.0016, 0.0016, 0.0016])
    ops.mass(2232, *[0.0013, 0.0013, 0.0013])
    ops.mass(2233, *[0.0019, 0.0019, 0.0019])
    ops.mass(2234, *[0.0018, 0.0018, 0.0018])
    ops.mass(2235, *[0.0003, 0.0003, 0.0003])
    ops.mass(2236, *[0.005, 0.005, 0.005])
    ops.mass(2237, *[0.0066, 0.0066, 0.0066])
    ops.mass(2238, *[0.0077, 0.0077, 0.0077])
    ops.mass(2239, *[0.0012, 0.0012, 0.0012])
    ops.mass(2240, *[0.0022, 0.0022, 0.0022])
    ops.mass(2241, *[0.0023, 0.0023, 0.0023])
    ops.mass(2242, *[0.0023, 0.0023, 0.0023])
    ops.mass(2243, *[0.0022, 0.0022, 0.0022])
    ops.mass(2244, *[0.0015, 0.0015, 0.0015])
    ops.mass(2245, *[0.0021, 0.0021, 0.0021])
    ops.mass(2246, *[0.0006, 0.0006, 0.0006])
    ops.mass(2247, *[0.0007, 0.0007, 0.0007])
    ops.mass(2248, *[0.0024, 0.0024, 0.0024])
    ops.mass(2249, *[0.0007, 0.0007, 0.0007])
    ops.mass(2250, *[0.0019, 0.0019, 0.0019])
    ops.mass(2251, *[0.0007, 0.0007, 0.0007])
    ops.mass(2252, *[0.0008, 0.0008, 0.0008])
    ops.mass(2253, *[0.0007, 0.0007, 0.0007])
    ops.mass(2254, *[0.0003, 0.0003, 0.0003])
    ops.mass(2255, *[0.0026, 0.0026, 0.0026])
    ops.mass(2256, *[0.0017, 0.0017, 0.0017])
    ops.mass(2257, *[0.0007, 0.0007, 0.0007])
    ops.mass(2258, *[0.0016, 0.0016, 0.0016])
    ops.mass(2259, *[0.0001, 0.0001, 0.0001])
    ops.mass(2260, *[0.0015, 0.0015, 0.0015])
    ops.mass(2261, *[0.0015, 0.0015, 0.0015])
    ops.mass(2262, *[0.0005, 0.0005, 0.0005])
    ops.mass(2263, *[0.0012, 0.0012, 0.0012])
    ops.mass(2264, *[0.0017, 0.0017, 0.0017])
    ops.mass(2265, *[0.0005, 0.0005, 0.0005])
    ops.mass(2266, *[0.0017, 0.0017, 0.0017])
    ops.mass(2267, *[0.0007, 0.0007, 0.0007])
    ops.mass(2268, *[0.0006, 0.0006, 0.0006])
    ops.mass(2269, *[0.001, 0.001, 0.001])
    ops.mass(2270, *[0.0007, 0.0007, 0.0007])
    ops.mass(2271, *[0.0009, 0.0009, 0.0009])
    ops.mass(2272, *[0.0016, 0.0016, 0.0016])
    ops.mass(2273, *[0.002, 0.002, 0.002])
    ops.mass(2274, *[0.0016, 0.0016, 0.0016])
    ops.mass(2275, *[0.0018, 0.0018, 0.0018])
    ops.mass(2276, *[0.0005, 0.0005, 0.0005])
    ops.mass(2277, *[0.0012, 0.0012, 0.0012])
    ops.mass(2278, *[0.0008, 0.0008, 0.0008])
    ops.mass(2279, *[0.0008, 0.0008, 0.0008])
    ops.mass(2280, *[0.0013, 0.0013, 0.0013])
    ops.mass(2281, *[0.0006, 0.0006, 0.0006])
    ops.mass(2282, *[0.0007, 0.0007, 0.0007])
    ops.mass(2283, *[0.002, 0.002, 0.002])
    ops.mass(2284, *[0.0022, 0.0022, 0.0022])
    ops.mass(2285, *[0.0004, 0.0004, 0.0004])
    ops.mass(2286, *[0.0002, 0.0002, 0.0002])
    ops.mass(2287, *[0.0006, 0.0006, 0.0006])
    ops.mass(2288, *[0.0004, 0.0004, 0.0004])
    ops.mass(2289, *[0.0005, 0.0005, 0.0005])
    ops.mass(2290, *[0.0017, 0.0017, 0.0017])
    ops.mass(2291, *[0.0006, 0.0006, 0.0006])
    ops.mass(2292, *[0.0018, 0.0018, 0.0018])
    ops.mass(2293, *[0.0005, 0.0005, 0.0005])
    ops.mass(2294, *[0.0017, 0.0017, 0.0017])
    ops.mass(2295, *[0.0009, 0.0009, 0.0009])
    ops.mass(2296, *[0.0008, 0.0008, 0.0008])
    ops.mass(2297, *[0.0012, 0.0012, 0.0012])
    ops.mass(2298, *[0.0021, 0.0021, 0.0021])
    ops.mass(2299, *[0.0008, 0.0008, 0.0008])
    ops.mass(2300, *[0.0013, 0.0013, 0.0013])
    ops.mass(2301, *[0.002, 0.002, 0.002])
    ops.mass(2302, *[0.0013, 0.0013, 0.0013])
    ops.mass(2303, *[0.0016, 0.0016, 0.0016])
    ops.mass(2304, *[0.0011, 0.0011, 0.0011])
    ops.mass(2305, *[0.0008, 0.0008, 0.0008])
    ops.mass(2306, *[0.0019, 0.0019, 0.0019])
    ops.mass(2307, *[0.002, 0.002, 0.002])
    ops.mass(2308, *[0.003, 0.003, 0.003])
    ops.mass(2309, *[0.0021, 0.0021, 0.0021])
    ops.mass(2310, *[0.0019, 0.0019, 0.0019])
    ops.mass(2311, *[0.0019, 0.0019, 0.0019])
    ops.mass(2312, *[0.0013, 0.0013, 0.0013])
    ops.mass(2313, *[0.0006, 0.0006, 0.0006])
    ops.mass(2314, *[0.0003, 0.0003, 0.0003])
    ops.mass(2315, *[0.002, 0.002, 0.002])
    ops.mass(2316, *[0.0019, 0.0019, 0.0019])
    ops.mass(2317, *[0.0007, 0.0007, 0.0007])
    ops.mass(2318, *[0.0008, 0.0008, 0.0008])
    ops.mass(2319, *[0.0014, 0.0014, 0.0014])
    ops.mass(2320, *[0.0007, 0.0007, 0.0007])
    ops.mass(2321, *[0.0026, 0.0026, 0.0026])
    ops.mass(2322, *[0.001, 0.001, 0.001])
    ops.mass(2323, *[0.0006, 0.0006, 0.0006])
    ops.mass(2324, *[0.0008, 0.0008, 0.0008])
    ops.mass(2325, *[0.0024, 0.0024, 0.0024])
    ops.mass(2326, *[0.0003, 0.0003, 0.0003])
    ops.mass(2327, *[0.0004, 0.0004, 0.0004])
    ops.mass(2328, *[0.0007, 0.0007, 0.0007])
    ops.mass(2329, *[0.001, 0.001, 0.001])
    ops.mass(2330, *[0.0012, 0.0012, 0.0012])
    ops.mass(2331, *[0.0016, 0.0016, 0.0016])
    ops.mass(2332, *[0.0027, 0.0027, 0.0027])
    ops.mass(2333, *[0.0021, 0.0021, 0.0021])
    ops.mass(2334, *[0.0019, 0.0019, 0.0019])
    ops.mass(2335, *[0.0015, 0.0015, 0.0015])
    ops.mass(2336, *[0.0014, 0.0014, 0.0014])
    ops.mass(2337, *[0.0015, 0.0015, 0.0015])
    ops.mass(2338, *[0.0063, 0.0063, 0.0063])
    ops.mass(2339, *[0.0013, 0.0013, 0.0013])
    ops.mass(2340, *[0.0044, 0.0044, 0.0044])
    ops.mass(2341, *[0.0007, 0.0007, 0.0007])
    ops.mass(2342, *[0.001, 0.001, 0.001])
    ops.mass(2343, *[0.0011, 0.0011, 0.0011])
    ops.mass(2344, *[0.0009, 0.0009, 0.0009])
    ops.mass(2345, *[0.0012, 0.0012, 0.0012])
    ops.mass(2346, *[0.0008, 0.0008, 0.0008])
    ops.mass(2347, *[0.0015, 0.0015, 0.0015])
    ops.mass(2348, *[0.002, 0.002, 0.002])
    ops.mass(2349, *[0.003, 0.003, 0.003])
    ops.mass(2350, *[0.0023, 0.0023, 0.0023])
    ops.mass(2351, *[0.0025, 0.0025, 0.0025])
    ops.mass(2352, *[0.0012, 0.0012, 0.0012])
    ops.mass(2353, *[0.0005, 0.0005, 0.0005])
    ops.mass(2354, *[0.0008, 0.0008, 0.0008])
    ops.mass(2355, *[0.0007, 0.0007, 0.0007])
    ops.mass(2356, *[0.0019, 0.0019, 0.0019])
    ops.mass(2357, *[0.0124, 0.0124, 0.0124])
    ops.mass(2358, *[0.0102, 0.0102, 0.0102])
    ops.mass(2359, *[0.0021, 0.0021, 0.0021])
    ops.mass(2360, *[0.0007, 0.0007, 0.0007])
    ops.mass(2361, *[0.0013, 0.0013, 0.0013])
    ops.mass(2362, *[0.0016, 0.0016, 0.0016])
    ops.mass(2363, *[0.0006, 0.0006, 0.0006])
    ops.mass(2364, *[0.0016, 0.0016, 0.0016])
    ops.mass(2365, *[0.0008, 0.0008, 0.0008])
    ops.mass(2366, *[0.0009, 0.0009, 0.0009])
    ops.mass(2367, *[0.0002, 0.0002, 0.0002])
    ops.mass(2368, *[0.0019, 0.0019, 0.0019])
    ops.mass(2369, *[0.0014, 0.0014, 0.0014])
    ops.mass(2370, *[0.0006, 0.0006, 0.0006])
    ops.mass(2371, *[0.0005, 0.0005, 0.0005])
    ops.mass(2372, *[0.0005, 0.0005, 0.0005])
    ops.mass(2373, *[0.0019, 0.0019, 0.0019])
    ops.mass(2374, *[0.0004, 0.0004, 0.0004])
    ops.mass(2375, *[0.0016, 0.0016, 0.0016])
    ops.mass(2376, *[0.0014, 0.0014, 0.0014])
    ops.mass(2377, *[0.0011, 0.0011, 0.0011])
    ops.mass(2378, *[0.0005, 0.0005, 0.0005])
    ops.mass(2379, *[0.0011, 0.0011, 0.0011])
    ops.mass(2380, *[0.0015, 0.0015, 0.0015])
    ops.mass(2381, *[0.0051, 0.0051, 0.0051])
    ops.mass(2382, *[0.0019, 0.0019, 0.0019])
    ops.mass(2383, *[0.0026, 0.0026, 0.0026])
    ops.mass(2384, *[0.0014, 0.0014, 0.0014])
    ops.mass(2385, *[0.0014, 0.0014, 0.0014])
    ops.mass(2386, *[0.0017, 0.0017, 0.0017])
    ops.mass(2387, *[0.0016, 0.0016, 0.0016])
    ops.mass(2388, *[0.0016, 0.0016, 0.0016])
    ops.mass(2389, *[0.0015, 0.0015, 0.0015])
    ops.mass(2390, *[0.0018, 0.0018, 0.0018])
    ops.mass(2391, *[0.0019, 0.0019, 0.0019])
    ops.mass(2392, *[0.0012, 0.0012, 0.0012])
    ops.mass(2393, *[0.0006, 0.0006, 0.0006])
    ops.mass(2394, *[0.0008, 0.0008, 0.0008])
    ops.mass(2395, *[0.0024, 0.0024, 0.0024])
    ops.mass(2396, *[0.0046, 0.0046, 0.0046])
    ops.mass(2397, *[0.0017, 0.0017, 0.0017])
    ops.mass(2398, *[0.0016, 0.0016, 0.0016])
    ops.mass(2399, *[0.0012, 0.0012, 0.0012])
    ops.mass(2400, *[0.0011, 0.0011, 0.0011])
    ops.mass(2401, *[0.0008, 0.0008, 0.0008])
    ops.mass(2402, *[0.004, 0.004, 0.004])
    ops.mass(2403, *[0.0007, 0.0007, 0.0007])
    ops.mass(2404, *[0.0024, 0.0024, 0.0024])
    ops.mass(2405, *[0.0033, 0.0033, 0.0033])
    ops.mass(2406, *[0.0027, 0.0027, 0.0027])
    ops.mass(2407, *[0.0016, 0.0016, 0.0016])
    ops.mass(2408, *[0.0033, 0.0033, 0.0033])
    ops.mass(2409, *[0.0026, 0.0026, 0.0026])
    ops.mass(2410, *[0.0018, 0.0018, 0.0018])
    ops.mass(2411, *[0.0024, 0.0024, 0.0024])
    ops.mass(2412, *[0.0024, 0.0024, 0.0024])
    ops.mass(2413, *[0.0024, 0.0024, 0.0024])
    ops.mass(2414, *[0.0009, 0.0009, 0.0009])
    ops.mass(2415, *[0.0006, 0.0006, 0.0006])
    ops.mass(2416, *[0.0024, 0.0024, 0.0024])
    ops.mass(2417, *[0.0004, 0.0004, 0.0004])
    ops.mass(2418, *[0.0006, 0.0006, 0.0006])
    ops.mass(2419, *[0.0011, 0.0011, 0.0011])
    ops.mass(2420, *[0.002, 0.002, 0.002])
    ops.mass(2421, *[0.0009, 0.0009, 0.0009])
    ops.mass(2422, *[0.0025, 0.0025, 0.0025])
    ops.mass(2423, *[0.0001, 0.0001, 0.0001])
    ops.mass(2424, *[0.0011, 0.0011, 0.0011])
    ops.mass(2425, *[0.0008, 0.0008, 0.0008])
    ops.mass(2426, *[0.0004, 0.0004, 0.0004])
    ops.mass(2427, *[0.0005, 0.0005, 0.0005])
    ops.mass(2428, *[0.0011, 0.0011, 0.0011])
    ops.mass(2429, *[0.0015, 0.0015, 0.0015])
    ops.mass(2430, *[0.0016, 0.0016, 0.0016])
    ops.mass(2431, *[0.0005, 0.0005, 0.0005])
    ops.mass(2432, *[0.0009, 0.0009, 0.0009])
    ops.mass(2433, *[0.0009, 0.0009, 0.0009])
    ops.mass(2434, *[0.0008, 0.0008, 0.0008])
    ops.mass(2435, *[0.0022, 0.0022, 0.0022])
    ops.mass(2436, *[0.0016, 0.0016, 0.0016])
    ops.mass(2437, *[0.0005, 0.0005, 0.0005])
    ops.mass(2438, *[0.007, 0.007, 0.007])
    ops.mass(2439, *[0.0007, 0.0007, 0.0007])
    ops.mass(2440, *[0.0016, 0.0016, 0.0016])
    ops.mass(2441, *[0.0006, 0.0006, 0.0006])
    ops.mass(2442, *[0.0013, 0.0013, 0.0013])
    ops.mass(2443, *[0.002, 0.002, 0.002])
    ops.mass(2444, *[0.0007, 0.0007, 0.0007])
    ops.mass(2445, *[0.0005, 0.0005, 0.0005])
    ops.mass(2446, *[0.0005, 0.0005, 0.0005])
    ops.mass(2447, *[0.0006, 0.0006, 0.0006])
    ops.mass(2448, *[0.0003, 0.0003, 0.0003])
    ops.mass(2449, *[0.0009, 0.0009, 0.0009])
    ops.mass(2450, *[0.0013, 0.0013, 0.0013])
    ops.mass(2451, *[0.0013, 0.0013, 0.0013])
    ops.mass(2452, *[0.0012, 0.0012, 0.0012])
    ops.mass(2453, *[0.0014, 0.0014, 0.0014])
    ops.mass(2454, *[0.0006, 0.0006, 0.0006])
    ops.mass(2455, *[0.0006, 0.0006, 0.0006])
    ops.mass(2456, *[0.0006, 0.0006, 0.0006])
    ops.mass(2457, *[0.0015, 0.0015, 0.0015])
    ops.mass(2458, *[0.0005, 0.0005, 0.0005])
    ops.mass(2459, *[0.0007, 0.0007, 0.0007])
    ops.mass(2460, *[0.0007, 0.0007, 0.0007])
    ops.mass(2461, *[0.0007, 0.0007, 0.0007])
    ops.mass(2462, *[0.0027, 0.0027, 0.0027])
    ops.mass(2463, *[0.0009, 0.0009, 0.0009])
    ops.mass(2464, *[0.0018, 0.0018, 0.0018])
    ops.mass(2465, *[0.002, 0.002, 0.002])
    ops.mass(2466, *[0.0011, 0.0011, 0.0011])
    ops.mass(2467, *[0.002, 0.002, 0.002])
    ops.mass(2468, *[0.0013, 0.0013, 0.0013])
    ops.mass(2469, *[0.0003, 0.0003, 0.0003])
    ops.mass(2470, *[0.0006, 0.0006, 0.0006])
    ops.mass(2471, *[0.0006, 0.0006, 0.0006])
    ops.mass(2472, *[0.0009, 0.0009, 0.0009])
    ops.mass(2473, *[0.0005, 0.0005, 0.0005])
    ops.mass(2474, *[0.0008, 0.0008, 0.0008])
    ops.mass(2475, *[0.0018, 0.0018, 0.0018])
    ops.mass(2476, *[0.0006, 0.0006, 0.0006])
    ops.mass(2477, *[0.0003, 0.0003, 0.0003])
    ops.mass(2478, *[0.0027, 0.0027, 0.0027])
    ops.mass(2479, *[0.0079, 0.0079, 0.0079])
    ops.mass(2480, *[0.0005, 0.0005, 0.0005])
    ops.mass(2481, *[0.0003, 0.0003, 0.0003])
    ops.mass(2482, *[0.002, 0.002, 0.002])
    ops.mass(2483, *[0.0018, 0.0018, 0.0018])
    ops.mass(2484, *[0.0017, 0.0017, 0.0017])
    ops.mass(2485, *[0.0017, 0.0017, 0.0017])
    ops.mass(2486, *[0.0018, 0.0018, 0.0018])
    ops.mass(2487, *[0.0007, 0.0007, 0.0007])
    ops.mass(2488, *[0.0016, 0.0016, 0.0016])
    ops.mass(2489, *[0.0012, 0.0012, 0.0012])
    ops.mass(2490, *[0.0009, 0.0009, 0.0009])
    ops.mass(2491, *[0.0017, 0.0017, 0.0017])
    ops.mass(2492, *[0.0022, 0.0022, 0.0022])
    ops.mass(2493, *[0.0011, 0.0011, 0.0011])
    ops.mass(2494, *[0.002, 0.002, 0.002])
    ops.mass(2495, *[0.0014, 0.0014, 0.0014])
    ops.mass(2496, *[0.0018, 0.0018, 0.0018])
    ops.mass(2497, *[0.002, 0.002, 0.002])
    ops.mass(2498, *[0.0012, 0.0012, 0.0012])
    ops.mass(2499, *[0.0005, 0.0005, 0.0005])
    ops.mass(2500, *[0.0004, 0.0004, 0.0004])
    ops.mass(2501, *[0.0012, 0.0012, 0.0012])
    ops.mass(2502, *[0.0022, 0.0022, 0.0022])
    ops.mass(2503, *[0.0008, 0.0008, 0.0008])
    ops.mass(2504, *[0.0006, 0.0006, 0.0006])
    ops.mass(2505, *[0.0012, 0.0012, 0.0012])
    ops.mass(2506, *[0.0013, 0.0013, 0.0013])
    ops.mass(2507, *[0.0007, 0.0007, 0.0007])
    ops.mass(2508, *[0.0014, 0.0014, 0.0014])
    ops.mass(2509, *[0.0011, 0.0011, 0.0011])
    ops.mass(2510, *[0.0011, 0.0011, 0.0011])
    ops.mass(2511, *[0.0008, 0.0008, 0.0008])
    ops.mass(2512, *[0.0013, 0.0013, 0.0013])
    ops.mass(2513, *[0.0014, 0.0014, 0.0014])
    ops.mass(2514, *[0.0014, 0.0014, 0.0014])
    ops.mass(2515, *[0.0004, 0.0004, 0.0004])
    ops.mass(2516, *[0.0017, 0.0017, 0.0017])
    ops.mass(2517, *[0.0006, 0.0006, 0.0006])
    ops.mass(2518, *[0.0007, 0.0007, 0.0007])
    ops.mass(2519, *[0.0016, 0.0016, 0.0016])
    ops.mass(2520, *[0.0013, 0.0013, 0.0013])
    ops.mass(2521, *[0.0009, 0.0009, 0.0009])
    ops.mass(2522, *[0.0013, 0.0013, 0.0013])
    ops.mass(2523, *[0.0008, 0.0008, 0.0008])
    ops.mass(2524, *[0.0014, 0.0014, 0.0014])
    ops.mass(2525, *[0.0016, 0.0016, 0.0016])
    ops.mass(2526, *[0.002, 0.002, 0.002])
    ops.mass(2527, *[0.001, 0.001, 0.001])
    ops.mass(2528, *[0.0017, 0.0017, 0.0017])
    ops.mass(2529, *[0.0021, 0.0021, 0.0021])
    ops.mass(2530, *[0.0012, 0.0012, 0.0012])
    ops.mass(2531, *[0.0027, 0.0027, 0.0027])
    ops.mass(2532, *[0.0025, 0.0025, 0.0025])
    ops.mass(2533, *[0.0021, 0.0021, 0.0021])
    ops.mass(2534, *[0.0004, 0.0004, 0.0004])
    ops.mass(2535, *[0.0003, 0.0003, 0.0003])
    ops.mass(2536, *[0.0012, 0.0012, 0.0012])
    ops.mass(2537, *[0.0025, 0.0025, 0.0025])
    ops.mass(2538, *[0.0022, 0.0022, 0.0022])
    ops.mass(2539, *[0.0023, 0.0023, 0.0023])
    ops.mass(2540, *[0.0011, 0.0011, 0.0011])
    ops.mass(2541, *[0.0011, 0.0011, 0.0011])
    ops.mass(2542, *[0.0031, 0.0031, 0.0031])
    ops.mass(2543, *[0.0011, 0.0011, 0.0011])
    ops.mass(2544, *[0.0026, 0.0026, 0.0026])
    ops.mass(2545, *[0.0005, 0.0005, 0.0005])
    ops.mass(2546, *[0.0014, 0.0014, 0.0014])
    ops.mass(2547, *[0.0002, 0.0002, 0.0002])
    ops.mass(2548, *[0.0003, 0.0003, 0.0003])
    ops.mass(2549, *[0.0006, 0.0006, 0.0006])
    ops.mass(2550, *[0.0004, 0.0004, 0.0004])
    ops.mass(2551, *[0.0007, 0.0007, 0.0007])
    ops.mass(2552, *[0.0003, 0.0003, 0.0003])
    ops.mass(2553, *[0.001, 0.001, 0.001])
    ops.mass(2554, *[0.0013, 0.0013, 0.0013])
    ops.mass(2555, *[0.0014, 0.0014, 0.0014])
    ops.mass(2556, *[0.0022, 0.0022, 0.0022])
    ops.mass(2557, *[0.0008, 0.0008, 0.0008])
    ops.mass(2558, *[0.0011, 0.0011, 0.0011])
    ops.mass(2559, *[0.0018, 0.0018, 0.0018])
    ops.mass(2560, *[0.0057, 0.0057, 0.0057])
    ops.mass(2561, *[0.0008, 0.0008, 0.0008])
    ops.mass(2562, *[0.0025, 0.0025, 0.0025])
    ops.mass(2563, *[0.0021, 0.0021, 0.0021])
    ops.mass(2564, *[0.0008, 0.0008, 0.0008])
    ops.mass(2565, *[0.0012, 0.0012, 0.0012])
    ops.mass(2566, *[0.0007, 0.0007, 0.0007])
    ops.mass(2567, *[0.0003, 0.0003, 0.0003])
    ops.mass(2568, *[0.0015, 0.0015, 0.0015])
    ops.mass(2569, *[0.0004, 0.0004, 0.0004])
    ops.mass(2570, *[0.0043, 0.0043, 0.0043])
    ops.mass(2571, *[0.0008, 0.0008, 0.0008])
    ops.mass(2572, *[0.0006, 0.0006, 0.0006])
    ops.mass(2573, *[0.001, 0.001, 0.001])
    ops.mass(2574, *[0.0006, 0.0006, 0.0006])
    ops.mass(2575, *[0.0004, 0.0004, 0.0004])
    ops.mass(2576, *[0.0003, 0.0003, 0.0003])
    ops.mass(2577, *[0.0018, 0.0018, 0.0018])
    ops.mass(2578, *[0.0036, 0.0036, 0.0036])
    ops.mass(2579, *[0.0012, 0.0012, 0.0012])
    ops.mass(2580, *[0.0005, 0.0005, 0.0005])
    ops.mass(2581, *[0.0005, 0.0005, 0.0005])
    ops.mass(2582, *[0.0007, 0.0007, 0.0007])
    ops.mass(2583, *[0.0007, 0.0007, 0.0007])
    ops.mass(2584, *[0.0007, 0.0007, 0.0007])
    ops.mass(2585, *[0.0012, 0.0012, 0.0012])
    ops.mass(2586, *[0.0004, 0.0004, 0.0004])
    ops.mass(2587, *[0.0004, 0.0004, 0.0004])
    ops.mass(2588, *[0.0016, 0.0016, 0.0016])
    ops.mass(2589, *[0.0005, 0.0005, 0.0005])
    ops.mass(2590, *[0.0016, 0.0016, 0.0016])
    ops.mass(2591, *[0.0006, 0.0006, 0.0006])
    ops.mass(2592, *[0.0026, 0.0026, 0.0026])
    ops.mass(2593, *[0.0004, 0.0004, 0.0004])
    ops.mass(2594, *[0.002, 0.002, 0.002])
    ops.mass(2595, *[0.0006, 0.0006, 0.0006])
    ops.mass(2596, *[0.0048, 0.0048, 0.0048])
    ops.mass(2597, *[0.0012, 0.0012, 0.0012])
    ops.mass(2598, *[0.001, 0.001, 0.001])
    ops.mass(2599, *[0.0003, 0.0003, 0.0003])
    ops.mass(2600, *[0.0014, 0.0014, 0.0014])
    ops.mass(2601, *[0.0004, 0.0004, 0.0004])
    ops.mass(2602, *[0.0037, 0.0037, 0.0037])
    ops.mass(2603, *[0.0006, 0.0006, 0.0006])
    ops.mass(2604, *[0.0014, 0.0014, 0.0014])
    ops.mass(2605, *[0.0007, 0.0007, 0.0007])
    ops.mass(2606, *[0.0008, 0.0008, 0.0008])
    ops.mass(2607, *[0.0006, 0.0006, 0.0006])
    ops.mass(2608, *[0.0006, 0.0006, 0.0006])
    ops.mass(2609, *[0.0001, 0.0001, 0.0001])
    ops.mass(2610, *[0.0002, 0.0002, 0.0002])
    ops.mass(2611, *[0.0005, 0.0005, 0.0005])
    ops.mass(2612, *[0.0017, 0.0017, 0.0017])
    ops.mass(2613, *[0.0006, 0.0006, 0.0006])
    ops.mass(2614, *[0.0007, 0.0007, 0.0007])
    ops.mass(2615, *[0.0013, 0.0013, 0.0013])
    ops.mass(2616, *[0.0025, 0.0025, 0.0025])
    ops.mass(2617, *[0.0022, 0.0022, 0.0022])
    ops.mass(2618, *[0.0003, 0.0003, 0.0003])
    ops.mass(2619, *[0.0024, 0.0024, 0.0024])
    ops.mass(2620, *[0.0007, 0.0007, 0.0007])
    ops.mass(2621, *[0.0022, 0.0022, 0.0022])
    ops.mass(2622, *[0.0013, 0.0013, 0.0013])
    ops.mass(2623, *[0.0007, 0.0007, 0.0007])
    ops.mass(2624, *[0.0012, 0.0012, 0.0012])
    ops.mass(2625, *[0.0007, 0.0007, 0.0007])
    ops.mass(2626, *[0.001, 0.001, 0.001])
    ops.mass(2627, *[0.0009, 0.0009, 0.0009])
    ops.mass(2628, *[0.0003, 0.0003, 0.0003])
    ops.mass(2629, *[0.0003, 0.0003, 0.0003])
    ops.mass(2630, *[0.0013, 0.0013, 0.0013])
    ops.mass(2631, *[0.0022, 0.0022, 0.0022])
    ops.mass(2632, *[0.0011, 0.0011, 0.0011])
    ops.mass(2633, *[0.0008, 0.0008, 0.0008])
    ops.mass(2634, *[0.0017, 0.0017, 0.0017])
    ops.mass(2635, *[0.0016, 0.0016, 0.0016])
    ops.mass(2636, *[0.0003, 0.0003, 0.0003])
    ops.mass(2637, *[0.0008, 0.0008, 0.0008])
    ops.mass(2638, *[0.0011, 0.0011, 0.0011])
    ops.mass(2639, *[0.0006, 0.0006, 0.0006])
    ops.mass(2640, *[0.001, 0.001, 0.001])
    ops.mass(2641, *[0.0015, 0.0015, 0.0015])
    ops.mass(2642, *[0.0015, 0.0015, 0.0015])
    ops.mass(2643, *[0.0002, 0.0002, 0.0002])
    ops.mass(2644, *[0.0008, 0.0008, 0.0008])
    ops.mass(2645, *[0.0011, 0.0011, 0.0011])
    ops.mass(2646, *[0.0019, 0.0019, 0.0019])
    ops.mass(2647, *[0.0009, 0.0009, 0.0009])
    ops.mass(2648, *[0.0003, 0.0003, 0.0003])
    ops.mass(2649, *[0.0002, 0.0002, 0.0002])
    ops.mass(2650, *[0.0002, 0.0002, 0.0002])
    ops.mass(2651, *[0.0006, 0.0006, 0.0006])
    ops.mass(2652, *[0.0017, 0.0017, 0.0017])
    ops.mass(2653, *[0.0014, 0.0014, 0.0014])
    ops.mass(2654, *[0.0004, 0.0004, 0.0004])
    ops.mass(2655, *[0.0009, 0.0009, 0.0009])
    ops.mass(2656, *[0.0007, 0.0007, 0.0007])
    ops.mass(2657, *[0.0008, 0.0008, 0.0008])
    ops.mass(2658, *[0.0002, 0.0002, 0.0002])
    ops.mass(2659, *[0.0002, 0.0002, 0.0002])
    ops.mass(2660, *[0.0017, 0.0017, 0.0017])
    ops.mass(2661, *[0.0009, 0.0009, 0.0009])
    ops.mass(2662, *[0.0013, 0.0013, 0.0013])
    ops.mass(2663, *[0.0008, 0.0008, 0.0008])
    ops.mass(2664, *[0.0004, 0.0004, 0.0004])
    ops.mass(2665, *[0.0006, 0.0006, 0.0006])
    ops.mass(2666, *[0.0006, 0.0006, 0.0006])
    ops.mass(2667, *[0.0007, 0.0007, 0.0007])
    ops.mass(2668, *[0.0011, 0.0011, 0.0011])
    ops.mass(2669, *[0.0009, 0.0009, 0.0009])
    ops.mass(2670, *[0.0004, 0.0004, 0.0004])
    ops.mass(2671, *[0.0006, 0.0006, 0.0006])
    ops.mass(2672, *[0.0001, 0.0001, 0.0001])
    ops.mass(2673, *[0.0004, 0.0004, 0.0004])
    ops.mass(2674, *[0.0007, 0.0007, 0.0007])
    ops.mass(2675, *[0.0008, 0.0008, 0.0008])
    ops.mass(2676, *[0.0008, 0.0008, 0.0008])
    ops.mass(2677, *[0.0005, 0.0005, 0.0005])
    ops.mass(2678, *[0.0003, 0.0003, 0.0003])
    ops.mass(2679, *[0.0004, 0.0004, 0.0004])
    ops.mass(2680, *[0.0006, 0.0006, 0.0006])
    ops.mass(2681, *[0.0018, 0.0018, 0.0018])
    ops.mass(2682, *[0.0027, 0.0027, 0.0027])
    ops.mass(2683, *[0.0007, 0.0007, 0.0007])
    ops.mass(2684, *[0.0004, 0.0004, 0.0004])
    ops.mass(2685, *[0.0001, 0.0001, 0.0001])
    ops.mass(2686, *[0.0004, 0.0004, 0.0004])
    ops.mass(2687, *[0.0003, 0.0003, 0.0003])
