# Contributing

We appreciate any contributions to the Python SDK - documentation or code changes - though we'd like to enforce some guidelines.

## Type-checking

To keep DX standards high, we ask you use the `Pylance/Pyright` type-checker set to `standard` mode. If you use your own type-checker such as `Ruff` or others, this should suffice.

Don't worry about this too much, we'll fix any type errors in PRs: the crux of the PR is the most important to us.

## Documenting code changes

If you make a breaking change (or any change that requires documentation to be updated), please include the documentation changes in the same pull-request.

We use NumPy style docstrings.

## Pull-requests

- Ensure your pull-requests are strict in their scope. Please don't open pull-requests that make seemingly unrelated changes to many parts of the SDK.
- When opening your pull-requests, follow the PR template please.
- We ask you follow PEP 8 guidelines to the best of your ability.

## Issues

- Please follow the issue templates, it makes solving your issue a lot tougher if we don't have all the information.

We welcome contributions from everyone. Don't worry if you don't meet these guidelines perfectly - they exist to speed up the development process.
