import locale
from byzerllm.utils import format_str_jinja2

MESSAGES = {
    "en": {
        "auto_command_analyzing": "Analyzing Command Request",
        "mcp_remove_error": "Error removing MCP server: {{error}}",
        "mcp_remove_success": "Successfully removed MCP server: {{result}}",
        "mcp_list_running_error": "Error listing running MCP servers: {{error}}",
        "mcp_list_running_title": "Running MCP servers:",
        "mcp_list_builtin_error": "Error listing builtin MCP servers: {{error}}",
        "mcp_list_builtin_title": "Available builtin MCP servers:",
        "mcp_refresh_error": "Error refreshing MCP servers: {{error}}",
        "mcp_refresh_success": "Successfully refreshed MCP servers",
        "mcp_install_error": "Error installing MCP server: {{error}}",
        "mcp_install_success": "Successfully installed MCP server: {{result}}",
        "mcp_query_empty": "Please enter your query.",
        "mcp_error_title": "Error",
        "mcp_response_title": "MCP Response",
        "initializing": "🚀 Initializing system...",
        "not_initialized": "The current directory is not initialized as an auto-coder project.",
        "init_prompt": "Do you want to initialize the project now? (y/n): ",
        "init_success": "Project initialized successfully.",
        "init_fail": "Failed to initialize the project.",
        "init_manual": "Please try manually: auto-coder init --source_dir .",
        "exit_no_init": "Exiting without initialization.",
        "created_dir": "Created directory: {{path}}",
        "init_complete": "Project initialization completed.",
        "checking_ray": "Checking Ray status...",
        "ray_not_running": "Ray is not running. Starting Ray...",
        "ray_start_success": "Ray started successfully.",
        "ray_start_fail": "Failed to start Ray. Please start it manually.",
        "ray_running": "Ray is already running.",
        "checking_model": "Checking deepseek_chat model availability...",
        "model_available": "deepseek_chat model is available.",
        "model_timeout": "Command timed out. deepseek_chat model might not be available.",
        "model_error": "Error occurred while checking deepseek_chat model.",
        "model_not_available": "deepseek_chat model is not available.",
        "provider_selection": "Select a provider for deepseek_chat model:",
        "no_provider": "No provider selected. Exiting initialization.",
        "enter_api_key": "Please enter your API key（https://www.deepseek.com/）: ",
        "deploying_model": "Deploying deepseek_chat model using {}...",
        "deploy_complete": "Deployment completed.",
        "deploy_fail": "Deployment failed. Please try again or deploy manually.",
        "validating_deploy": "Validating the deployment...",
        "validation_success": "Validation successful. deepseek_chat model is now available.",
        "validation_fail": "Validation failed. The model might not be deployed correctly.",
        "manual_start": "Please try to start the model manually using:",
        "init_complete_final": "Initialization completed.",
        "project_type_config": "Project Type Configuration",
        "project_type_supports": "The project_type supports:",
        "language_suffixes": "  - Language suffixes (e.g., .py, .java, .ts)",
        "predefined_types": "  - Predefined types: py (Python), ts (TypeScript/JavaScript)",
        "mixed_projects": "For mixed language projects, use comma-separated values.",
        "examples": "Examples: '.java,.scala' or '.py,.ts'",
        "default_type": "Default is 'py' if left empty.",
        "enter_project_type": "Enter the project type: ",
        "project_type_set": "Project type set to:",
        "using_default_type": "Using default project type: py",
        "change_setting_later": "You can change this setting later using",
        "supported_commands": "Supported commands:",
        "commands": "Commands",
        "description": "Description",
        "add_files_desc": "Add files to the current session",
        "remove_files_desc": "Remove files from the current session",
        "chat_desc": "Chat with the AI about the current active files to get insights",
        "coding_desc": "Request the AI to modify code based on requirements",
        "ask_desc": "Ask the AI any questions or get insights about the current project, without modifying code",
        "summon_desc": "Summon the AI to perform complex tasks using the auto_tool agent",
        "revert_desc": "Revert commits from last coding chat",
        "conf_desc": "Set configuration. Use /conf project_type:<type> to set project type for indexing",
        "index_query_desc": "Query the project index",
        "index_build_desc": "Trigger building the project index",
        "list_files_desc": "List all active files in the current session",
        "help_desc": "Show this help message",
        "exclude_dirs_desc": "Add directories to exclude from project",
        "shell_desc": "Execute a shell command",
        "index_export_success": "Successfully exported index to {{ path }}",
        "index_export_fail": "Failed to export index to {{ path }}",
        "index_import_success": "Successfully imported index from {{ path }}",
        "index_import_fail": "Failed to import index from {{ path }}",
        "index_not_found": "Index file not found at {{ path }}",
        "index_backup_success": "Backed up existing index to {{ path }}",
        "index_convert_path_fail": "Could not convert path {{ path }}",
        "index_error": "Error in index operation: {{ error }}",
        "voice_input_desc": "Convert voice input to text",
        "mode_desc": "Switch input mode",
        "conf_key": "Key",
        "conf_value": "Value",
        "conf_title": "Configuration Settings",
        "conf_subtitle": "Use /conf <key>:<value> to modify these settings",
        "lib_desc": "Manage libraries",
        "exit_desc": "Exit the program",
        "design_desc": "Generate SVG image based on the provided description",
        "commit_desc": "Auto generate yaml file and commit changes based on user's manual changes",
        "models_desc": "Manage model configurations, only available in lite mode",
        "models_usage": "Usage: /models <command>\nAvailable subcommands:\n  /list - List all models\n  /add <name> <api_key> - Add a built-in model\n  /add_model - Add a custom model\n  /remove <name> - Remove a model\n  /input_price <name> <value> - Set model input price\n  /output_price <name> <value> - Set model output price\n  /speed <name> <value> - Set model speed\n  /speed-test - Test models speed\n  /speed-test-long - Test models speed with long context",
        "models_added": "Added/Updated model '{{name}}' successfully.",
        "models_add_failed": "Failed to add model '{{name}}'. Model not found in defaults.",
        "models_add_usage": "Usage: /models /add <name> <api_key> or\n/models /add <name> <model_type> <model_name> <base_url> <api_key_path> [description]",
        "models_add_model_params": "Please provide parameters in key=value format",
        "models_add_model_name_required": "'name' parameter is required",
        "models_add_model_exists": "Model '{{name}}' already exists.",
        "models_add_model_success": "Successfully added custom model: {{name}}",
        "models_add_model_remove": "Model '{{name}}' not found.",
        "models_add_model_removed": "Removed model: {{name}}",
        "models_unknown_subcmd": "Unknown subcommand: {{subcmd}}",
        "models_input_price_updated": "Updated input price for model {{name}} to {{price}} M/token",
        "models_output_price_updated": "Updated output price for model {{name}} to {{price}} M/token",
        "models_invalid_price": "Invalid price value: {{error}}",
        "models_input_price_usage": "Usage: /models /input_price <name> <value>",
        "models_output_price_usage": "Usage: /models /output_price <name> <value>",
        "models_speed_updated": "Updated speed for model {{name}} to {{speed}} s/request",
        "models_invalid_speed": "Invalid speed value: {{error}}",
        "models_speed_usage": "Usage: /models /speed <name> <value>",
        "models_title": "All Models (内置 + models.json)",
        "models_no_models": "No models found.",
        "models_lite_only": "The /models command is only available in lite mode",
        "models_api_key_exists": "API key file exists: {{path}}",
        "config_invalid_format": "Error: Invalid configuration format. Use 'key:value' or '/drop key'.",
        "config_value_empty": "Error: Value cannot be empty. Use 'key:value'.",
        "config_set_success": "Set {{key}} to {{value}}",
        "config_delete_success": "Deleted configuration: {{key}}",
        "config_not_found": "Configuration not found: {{key}}",
        "add_files_matched": "All specified files are already in the current session or no matches found.",
        "add_files_added_files": "Added Files",
        "add_files_no_args": "Please provide arguments for the /add_files command.",
        "remove_files_all": "Removed all files.",
        "remove_files_removed": "Removed Files",
        "remove_files_none": "No files were removed.",
        "files_removed": "Files Removed",
        "models_api_key_empty": "Warning : {{name}} API key is empty. Please set a valid API key.",
        "commit_generating": "{{ model_name }} Generating commit message...",
        "auto_command_reasoning_title": "Reply",
        "commit_message": "{{ model_name }} Generated commit message: {{ message }}",
        "commit_failed": "{{ model_name }} Failed to generate commit message: {{ error }}",
        "confirm_execute": "Do you want to execute this script?",
        "official_doc": "Official Documentation: https://uelng8wukz.feishu.cn/wiki/NhPNwSRcWimKFIkQINIckloBncI",
        "plugins_desc": "Manage plugins",
        "plugins_usage": "Usage: /plugins <command>\nAvailable subcommands:\n  /plugins /list - List all available plugins\n  /plugins /load <name> - Load a plugin\n  /plugins /unload <name> - Unload a plugin\n  /plugins/dirs - List plugin directories\n  /plugins/dirs /add <path> - Add a plugin directory\n  /plugins/dirs /remove <path> - Remove a plugin directory\n  /plugins/dirs /clear - Clear all plugin directories",
        "mcp_server_info_error": "Error getting MCP server info: {{ error }}",
        "mcp_server_info_title": "Connected MCP Server Info",
    },
    "zh": {
        "auto_command_analyzing": "正在分析命令请求",
        "commit_generating": "{{ model_name }} 正在生成提交信息...",
        "auto_command_reasoning_title": "回复",
        "commit_message": "{{ model_name }} 生成的提交信息: {{ message }}",
        "commit_failed": "{{ model_name }} 生成提交信息失败: {{ error }}",
        "mcp_remove_error": "移除 MCP 服务器时出错:{{error}}",
        "mcp_remove_success": "成功移除 MCP 服务器：{{result}}",
        "mcp_list_running_error": "列出运行中的 MCP 服务器时出错：{{error}}",
        "mcp_list_running_title": "正在运行的 MCP 服务器：",
        "mcp_list_builtin_error": "列出内置 MCP 服务器时出错：{{error}}",
        "mcp_list_builtin_title": "可用的内置 MCP 服务器：",
        "mcp_refresh_error": "刷新 MCP 服务器时出错：{{error}}",
        "mcp_refresh_success": "成功刷新 MCP 服务器",
        "mcp_install_error": "安装 MCP 服务器时出错：{{error}}",
        "mcp_install_success": "成功安装 MCP 服务器：{{result}}",
        "mcp_query_empty": "请输入您的查询。",
        "mcp_error_title": "错误",
        "mcp_response_title": "MCP 响应",
        "initializing": "🚀 正在初始化系统...",
        "not_initialized": "当前目录未初始化为auto-coder项目。",
        "init_prompt": "是否现在初始化项目？(y/n): ",
        "init_success": "项目初始化成功。",
        "init_fail": "项目初始化失败。",
        "init_manual": "请尝试手动初始化：auto-coder init --source_dir .",
        "exit_no_init": "退出而不初始化。",
        "created_dir": "创建目录：{{path}}",
        "init_complete": "项目初始化完成。",
        "checking_ray": "正在检查Ray状态...",
        "ray_not_running": "Ray未运行。正在启动Ray...",
        "ray_start_success": "Ray启动成功。",
        "ray_start_fail": "Ray启动失败。请手动启动。",
        "ray_running": "Ray已经在运行。",
        "checking_model": "正在检查deepseek_chat模型可用性...",
        "model_available": "deepseek_chat模型可用。",
        "model_timeout": "命令超时。deepseek_chat模型可能不可用。",
        "model_error": "检查deepseek_chat模型时出错。",
        "model_not_available": "deepseek_chat模型不可用。",
        "provider_selection": "为deepseek_chat模型选择一个提供商：",
        "no_provider": "未选择提供商。退出初始化。",
        "enter_api_key": "请输入您的API密钥（https://www.deepseek.com/）：",
        "deploying_model": "正在使用{}部署deepseek_chat模型...",
        "deploy_complete": "部署完成。",
        "deploy_fail": "部署失败。请重试或手动部署。",
        "validating_deploy": "正在验证部署...",
        "validation_success": "验证成功。deepseek_chat模型现在可用。",
        "validation_fail": "验证失败。模型可能未正确部署。",
        "manual_start": "请尝试使用以下命令手动启动模型：",
        "init_complete_final": "初始化完成。",
        "project_type_config": "项目类型配置",
        "project_type_supports": "项目类型支持：",
        "language_suffixes": "  - 语言后缀（例如：.py, .java, .ts）",
        "predefined_types": "  - 预定义类型：py（Python）, ts（TypeScript/JavaScript）",
        "mixed_projects": "对于混合语言项目，使用逗号分隔的值。",
        "examples": "示例：'.java,.scala' 或 '.py,.ts'",
        "default_type": "如果留空，默认为 'py'。",
        "enter_project_type": "请输入项目类型：",
        "project_type_set": "项目类型设置为：",
        "using_default_type": "使用默认项目类型：py",
        "change_setting_later": "您可以稍后使用以下命令更改此设置",
        "supported_commands": "支持的命令：",
        "commands": "命令",
        "description": "描述",
        "add_files_desc": "将文件添加到当前会话",
        "remove_files_desc": "从当前会话中移除文件",
        "chat_desc": "与AI聊天，获取关于当前活动文件的见解",
        "coding_desc": "根据需求请求AI修改代码",
        "ask_desc": "向AI提问或获取关于当前项目的见解，不修改代码",
        "summon_desc": "召唤AI使用auto_tool代理执行复杂任务",
        "revert_desc": "撤销上次代码聊天的提交",
        "conf_desc": "设置配置。使用 /conf project_type:<type> 设置索引的项目类型",
        "index_query_desc": "查询项目索引",
        "index_build_desc": "触发构建项目索引",
        "list_files_desc": "列出当前会话中的所有活动文件",
        "help_desc": "显示此帮助消息",
        "exclude_dirs_desc": "添加要从项目中排除的目录",
        "shell_desc": "执行shell命令",
        "index_export_success": "成功导出索引到 {{ path }}",
        "index_export_fail": "导出索引到 {{ path }} 失败",
        "index_import_success": "成功从 {{ path }} 导入索引",
        "index_import_fail": "从 {{ path }} 导入索引失败",
        "index_not_found": "在 {{ path }} 未找到索引文件",
        "index_backup_success": "已备份现有索引到 {{ path }}",
        "index_convert_path_fail": "无法转换路径 {{ path }}",
        "index_error": "索引操作出错：{{ error }}",
        "voice_input_desc": "将语音输入转换为文本",
        "mode_desc": "切换输入模式",
        "lib_desc": "管理库",
        "exit_desc": "退出程序",
        "design_desc": "根据需求设计SVG图片",
        "commit_desc": "根据用户人工修改的代码自动生成yaml文件并提交更改",
        "models_desc": "管理模型配置，仅在lite模式下可用",
        "conf_key": "键",
        "conf_value": "值",
        "conf_title": "配置设置",
        "conf_subtitle": "使用 /conf <key>:<value> 修改这些设置",
        "models_usage": "用法: /models <命令>\n可用的子命令:\n  /list - 列出所有模型\n  /add <名称> <API密钥> - 添加内置模型\n  /add_model - 添加自定义模型\n  /remove <名称> - 移除模型\n  /input_price <名称> <价格> - 设置模型输入价格\n  /output_price <名称> <价格> - 设置模型输出价格\n  /speed <名称> <速度> - 设置模型速度\n  /speed-test - 测试模型速度\n  /speed-test-long - 使用长文本上下文测试模型速度",
        "models_added": "成功添加/更新模型 '{{name}}'。",
        "models_add_failed": "添加模型 '{{name}}' 失败。在默认模型中未找到该模型。",
        "models_add_usage": "用法: /models /add <name> <api_key> 或\n/models /add <name> <model_type> <model_name> <base_url> <api_key_path> [description]",
        "models_add_model_params": "请提供 key=value 格式的参数",
        "models_add_model_name_required": "缺少必需的 'name' 参数",
        "models_add_model_exists": "模型 '{{name}}' 已存在。",
        "models_add_model_success": "成功添加自定义模型: {{name}}",
        "models_add_model_remove": "找不到模型 '{{name}}'。",
        "models_add_model_removed": "已移除模型: {{name}}",
        "models_unknown_subcmd": "未知的子命令: {{subcmd}}",
        "models_input_price_updated": "已更新模型 {{name}} 的输入价格为 {{price}} M/token",
        "models_output_price_updated": "已更新模型 {{name}} 的输出价格为 {{price}} M/token",
        "models_invalid_price": "无效的价格值: {{error}}",
        "models_input_price_usage": "用法: /models /input_price <name> <value>",
        "models_output_price_usage": "用法: /models /output_price <name> <value>",
        "models_speed_updated": "已更新模型 {{name}} 的速度为 {{speed}} 秒/请求",
        "models_invalid_speed": "无效的速度值: {{error}}",
        "models_speed_usage": "用法: /models /speed <name> <value>",
        "models_title": "所有模型 (内置 + models.json)",
        "models_no_models": "未找到任何模型。",
        "models_lite_only": "/models 命令仅在 lite 模式下可用",
        "models_api_key_exists": "API密钥文件存在: {{path}}",
        "config_invalid_format": "错误：配置格式无效。请使用 'key:value' 或 '/drop key'。",
        "config_value_empty": "错误：值不能为空。请使用 'key:value'。",
        "config_set_success": "已设置 {{key}} 为 {{value}}",
        "config_delete_success": "已删除配置：{{key}}",
        "config_not_found": "未找到配置：{{key}}",
        "add_files_matched": "所有指定的文件都已在当前会话中或未找到匹配项。",
        "add_files_added_files": "已添加的文件",
        "add_files_no_args": "请为 /add_files 命令提供参数。",
        "remove_files_all": "已移除所有文件。",
        "remove_files_removed": "已移除的文件",
        "remove_files_none": "没有文件被移除。",
        "files_removed": "移除的文件",
        "models_api_key_empty": "警告:  {{name}}  API key 为空。请设置一个有效的 API key。",
        "confirm_execute": "是否执行此脚本?",
        "official_doc": "官方文档: https://uelng8wukz.feishu.cn/wiki/NhPNwSRcWimKFIkQINIckloBncI",
        "plugins_desc": "管理插件",
        "plugins_usage": "用法: /plugins <命令>\n可用的子命令:\n  /plugins /list - 列出所有可用插件\n  /plugins /load <名称> - 加载一个插件\n  /plugins /unload <名称> - 卸载一个插件\n  /plugins/dirs - 列出插件目录\n  /plugins/dirs /add <路径> - 添加一个插件目录\n  /plugins/dirs /remove <路径> - 移除一个插件目录\n  /plugins/dirs /clear - 清除所有插件目录",
        "mcp_server_info_error": "获取MCP服务器信息时出错: {{ error }}",
        "mcp_server_info_title": "已连接的MCP服务器信息",
    },
}


def get_system_language():
    try:
        return locale.getdefaultlocale()[0][:2]
    except:
        return "en"


def get_message(key):
    lang = get_system_language()
    return MESSAGES.get(lang, MESSAGES["en"]).get(key, MESSAGES["en"][key])


def get_message_with_format(msg_key: str, **kwargs):
    return format_str_jinja2(get_message(msg_key), **kwargs)
