import * as iam from 'aws-cdk-lib/aws-iam';
import * as customresources from 'aws-cdk-lib/custom-resources';
import * as constructs from 'constructs';
import * as network from './network';
/**
 * Creates custom resources to enroll admin and register user
 * identities with the CA using the fabric-ca-client SDK.
 * Admin identity is enrolled by default. User identities are
 * registered and enrolled, if provided.
 */
export declare class HyperledgerFabricIdentity extends constructs.Construct {
    /**
     * Role for custom resource lambda to assume
     */
    static customRole: iam.Role;
    /**
     * Custom provider to register user identity
     */
    static userProvider: customresources.Provider;
    /**
     * Custom provider to enroll admin identity
     */
    readonly adminProvider: customresources.Provider;
    constructor(scope: network.HyperledgerFabricNetwork, id: string);
}
