# Generated by Django 4.2.8 on 2024-02-13 17:18

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('esi', '0012_fix_token_type_choices'),
        ('eveonline', '0017_alliance_and_corp_names_are_not_unique'),
    ]

    operations = [
        migrations.CreateModel(
            name='General',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
            ],
            options={
                'permissions': (('view_contacts', 'Can view alliance contacts'),),
                'managed': False,
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='AllianceToken',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('last_update', models.DateTimeField(default=django.utils.timezone.now)),
                ('alliance', models.OneToOneField(on_delete=django.db.models.deletion.RESTRICT, related_name='+', to='eveonline.eveallianceinfo')),
                ('token', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='esi.token')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='AllianceContactLabel',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label_id', models.BigIntegerField()),
                ('label_name', models.CharField(max_length=255)),
                ('alliance', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, related_name='contact_labels', to='eveonline.eveallianceinfo')),
            ],
            options={
                'default_permissions': (),
            },
        ),
        migrations.CreateModel(
            name='AllianceContact',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('contact_id', models.BigIntegerField()),
                ('contact_type', models.CharField(choices=[('character', 'Character'), ('corporation', 'Corporation'), ('alliance', 'Alliance'), ('faction', 'Faction')], max_length=11)),
                ('standing', models.FloatField()),
                ('notes', models.TextField(blank=True, default='')),
                ('alliance', models.ForeignKey(on_delete=django.db.models.deletion.RESTRICT, related_name='contacts', to='eveonline.eveallianceinfo')),
                ('labels', models.ManyToManyField(related_name='contacts', to='aa_contacts.alliancecontactlabel')),
            ],
            options={
                'default_permissions': (),
            },
        ),
    ]
