# type: ignore
"""add version tables

Revision ID: 0b45de1602a6
Revises: d66a8276ba0a
Create Date: 2025-01-14 11:18:19.196147

"""

import sqlalchemy as sa
from alembic import op

# Revision identifiers, used by Alembic.
revision = "0b45de1602a6"
down_revision = "d66a8276ba0a"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "iamc_datapoint_universal_version",
        sa.Column("value", sa.Float(), autoincrement=False, nullable=True),
        sa.Column("type", sa.String(length=255), autoincrement=False, nullable=True),
        sa.Column(
            "step_category", sa.String(length=1023), autoincrement=False, nullable=True
        ),
        sa.Column("step_year", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("step_datetime", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column("time_series__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint(
            "id", "transaction_id", name=op.f("pk_iamc_datapoint_universal_version")
        ),
    )
    with op.batch_alter_table(
        "iamc_datapoint_universal_version", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_step_category"),
            ["step_category"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_step_datetime"),
            ["step_datetime"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_step_year"),
            ["step_year"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_time_series__id"),
            ["time_series__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_datapoint_universal_version_type"),
            ["type"],
            unique=False,
        )

    op.create_table(
        "iamc_measurand_version",
        sa.Column("variable__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("unit__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("created_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "created_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint(
            "id", "transaction_id", name=op.f("pk_iamc_measurand_version")
        ),
    )
    with op.batch_alter_table("iamc_measurand_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_iamc_measurand_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_measurand_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_measurand_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_measurand_version_unit__id"), ["unit__id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_measurand_version_variable__id"),
            ["variable__id"],
            unique=False,
        )

    op.create_table(
        "iamc_timeseries_version",
        sa.Column("region__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("measurand__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("run__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint(
            "id", "transaction_id", name=op.f("pk_iamc_timeseries_version")
        ),
    )
    with op.batch_alter_table("iamc_timeseries_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_iamc_timeseries_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_timeseries_version_measurand__id"),
            ["measurand__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_timeseries_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_timeseries_version_region__id"),
            ["region__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_timeseries_version_run__id"), ["run__id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_timeseries_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    op.create_table(
        "iamc_variable_version",
        sa.Column("name", sa.String(length=255), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("created_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "created_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint(
            "id", "transaction_id", name=op.f("pk_iamc_variable_version")
        ),
    )
    with op.batch_alter_table("iamc_variable_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_iamc_variable_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_variable_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_iamc_variable_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    op.create_table(
        "model_version",
        sa.Column("name", sa.String(length=255), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("created_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "created_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint("id", "transaction_id", name=op.f("pk_model_version")),
    )
    with op.batch_alter_table("model_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_model_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_model_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_model_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    op.create_table(
        "region_version",
        sa.Column("name", sa.String(length=255), autoincrement=False, nullable=True),
        sa.Column(
            "hierarchy", sa.String(length=1023), autoincrement=False, nullable=True
        ),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("created_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "created_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint("id", "transaction_id", name=op.f("pk_region_version")),
    )
    with op.batch_alter_table("region_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_region_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_region_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_region_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    op.create_table(
        "run_version",
        sa.Column("model__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("scenario__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("version", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("is_default", sa.Boolean(), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("updated_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "updated_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column("created_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "created_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint("id", "transaction_id", name=op.f("pk_run_version")),
    )
    with op.batch_alter_table("run_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_run_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_run_version_model__id"), ["model__id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_run_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_run_version_scenario__id"), ["scenario__id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_run_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    op.create_table(
        "runmetaentry_version",
        sa.Column("run__id", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column("key", sa.String(length=1023), autoincrement=False, nullable=True),
        sa.Column("dtype", sa.String(length=20), autoincrement=False, nullable=True),
        sa.Column("value_int", sa.Integer(), autoincrement=False, nullable=True),
        sa.Column(
            "value_str", sa.String(length=1023), autoincrement=False, nullable=True
        ),
        sa.Column("value_float", sa.Float(), autoincrement=False, nullable=True),
        sa.Column("value_bool", sa.Boolean(), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint(
            "id", "transaction_id", name=op.f("pk_runmetaentry_version")
        ),
    )
    with op.batch_alter_table("runmetaentry_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_runmetaentry_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_runmetaentry_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_runmetaentry_version_run__id"), ["run__id"], unique=False
        )
        batch_op.create_index(
            batch_op.f("ix_runmetaentry_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    op.create_table(
        "scenario_version",
        sa.Column("name", sa.String(length=255), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("created_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "created_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint(
            "id", "transaction_id", name=op.f("pk_scenario_version")
        ),
    )
    with op.batch_alter_table("scenario_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_scenario_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_scenario_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_scenario_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    op.create_table(
        "transaction",
        sa.Column("id", sa.BigInteger(), autoincrement=True, nullable=False),
        sa.Column("remote_addr", sa.String(length=50), nullable=True),
        sa.Column("issued_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id", name=op.f("pk_transaction")),
    )
    op.create_table(
        "unit_version",
        sa.Column("name", sa.String(length=255), autoincrement=False, nullable=True),
        sa.Column("id", sa.Integer(), autoincrement=False, nullable=False),
        sa.Column("created_at", sa.DateTime(), autoincrement=False, nullable=True),
        sa.Column(
            "created_by", sa.String(length=255), autoincrement=False, nullable=True
        ),
        sa.Column(
            "transaction_id", sa.BigInteger(), autoincrement=False, nullable=False
        ),
        sa.Column("end_transaction_id", sa.BigInteger(), nullable=True),
        sa.Column("operation_type", sa.SmallInteger(), nullable=False),
        sa.PrimaryKeyConstraint("id", "transaction_id", name=op.f("pk_unit_version")),
    )
    with op.batch_alter_table("unit_version", schema=None) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_unit_version_end_transaction_id"),
            ["end_transaction_id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_unit_version_operation_type"),
            ["operation_type"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_unit_version_transaction_id"),
            ["transaction_id"],
            unique=False,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("unit_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_unit_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_unit_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_unit_version_end_transaction_id"))

    op.drop_table("unit_version")
    op.drop_table("transaction")
    with op.batch_alter_table("scenario_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_scenario_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_scenario_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_scenario_version_end_transaction_id"))

    op.drop_table("scenario_version")
    with op.batch_alter_table("runmetaentry_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_runmetaentry_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_runmetaentry_version_run__id"))
        batch_op.drop_index(batch_op.f("ix_runmetaentry_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_runmetaentry_version_end_transaction_id"))

    op.drop_table("runmetaentry_version")
    with op.batch_alter_table("run_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_run_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_run_version_scenario__id"))
        batch_op.drop_index(batch_op.f("ix_run_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_run_version_model__id"))
        batch_op.drop_index(batch_op.f("ix_run_version_end_transaction_id"))

    op.drop_table("run_version")
    with op.batch_alter_table("region_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_region_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_region_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_region_version_end_transaction_id"))

    op.drop_table("region_version")
    with op.batch_alter_table("model_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_model_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_model_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_model_version_end_transaction_id"))

    op.drop_table("model_version")
    with op.batch_alter_table("iamc_variable_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_iamc_variable_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_iamc_variable_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_iamc_variable_version_end_transaction_id"))

    op.drop_table("iamc_variable_version")
    with op.batch_alter_table("iamc_timeseries_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_iamc_timeseries_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_iamc_timeseries_version_run__id"))
        batch_op.drop_index(batch_op.f("ix_iamc_timeseries_version_region__id"))
        batch_op.drop_index(batch_op.f("ix_iamc_timeseries_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_iamc_timeseries_version_measurand__id"))
        batch_op.drop_index(batch_op.f("ix_iamc_timeseries_version_end_transaction_id"))

    op.drop_table("iamc_timeseries_version")
    with op.batch_alter_table("iamc_measurand_version", schema=None) as batch_op:
        batch_op.drop_index(batch_op.f("ix_iamc_measurand_version_variable__id"))
        batch_op.drop_index(batch_op.f("ix_iamc_measurand_version_unit__id"))
        batch_op.drop_index(batch_op.f("ix_iamc_measurand_version_transaction_id"))
        batch_op.drop_index(batch_op.f("ix_iamc_measurand_version_operation_type"))
        batch_op.drop_index(batch_op.f("ix_iamc_measurand_version_end_transaction_id"))

    op.drop_table("iamc_measurand_version")
    with op.batch_alter_table(
        "iamc_datapoint_universal_version", schema=None
    ) as batch_op:
        batch_op.drop_index(batch_op.f("ix_iamc_datapoint_universal_version_type"))
        batch_op.drop_index(
            batch_op.f("ix_iamc_datapoint_universal_version_transaction_id")
        )
        batch_op.drop_index(
            batch_op.f("ix_iamc_datapoint_universal_version_time_series__id")
        )
        batch_op.drop_index(batch_op.f("ix_iamc_datapoint_universal_version_step_year"))
        batch_op.drop_index(
            batch_op.f("ix_iamc_datapoint_universal_version_step_datetime")
        )
        batch_op.drop_index(
            batch_op.f("ix_iamc_datapoint_universal_version_step_category")
        )
        batch_op.drop_index(
            batch_op.f("ix_iamc_datapoint_universal_version_operation_type")
        )
        batch_op.drop_index(
            batch_op.f("ix_iamc_datapoint_universal_version_end_transaction_id")
        )

    op.drop_table("iamc_datapoint_universal_version")
    # ### end Alembic commands ###
