# type: ignore
"""Introduce optimization item delete()

Revision ID: 1e5554a164e6
Revises: 8fd96526b04f
Create Date: 2025-05-08 12:13:39.340523

"""

from alembic import op

# Revision identifiers, used by Alembic.
revision = "1e5554a164e6"
down_revision = "8fd96526b04f"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "optimization_equationindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            "fk_optimization_equationindexsetassociation_equation__i_be8b",
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_optimization_equationindexsetassociation_equation__i_be8b"),
            "optimization_equation",
            ["equation__id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table("optimization_indexsetdata", schema=None) as batch_op:
        batch_op.drop_constraint(
            "fk_optimization_indexsetdata_indexset__id_optimization_indexset",
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f(
                "fk_optimization_indexsetdata_indexset__id_optimization_indexset"
            ),
            "optimization_indexset",
            ["indexset__id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table(
        "optimization_parameterindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            "fk_optimization_parameterindexsetassociation_parameter__8a6d",
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_optimization_parameterindexsetassociation_parameter__8a6d"),
            "optimization_parameter",
            ["parameter__id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table(
        "optimization_tableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            "fk_optimization_tableindexsetassociation_table__id_opti_5cfe",
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_optimization_tableindexsetassociation_table__id_opti_5cfe"),
            "optimization_table",
            ["table__id"],
            ["id"],
            ondelete="CASCADE",
        )

    with op.batch_alter_table(
        "optimization_variableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            "fk_optimization_variableindexsetassociation_variable__i_02a8",
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            batch_op.f("fk_optimization_variableindexsetassociation_variable__i_02a8"),
            "optimization_optimizationvariable",
            ["variable__id"],
            ["id"],
            ondelete="CASCADE",
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "optimization_variableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_optimization_variableindexsetassociation_variable__i_02a8"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_optimization_variableindexsetassociation_variable__i_02a8",
            "optimization_optimizationvariable",
            ["variable__id"],
            ["id"],
        )

    with op.batch_alter_table(
        "optimization_tableindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_optimization_tableindexsetassociation_table__id_opti_5cfe"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_optimization_tableindexsetassociation_table__id_opti_5cfe",
            "optimization_table",
            ["table__id"],
            ["id"],
        )

    with op.batch_alter_table(
        "optimization_parameterindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_optimization_parameterindexsetassociation_parameter__8a6d"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_optimization_parameterindexsetassociation_parameter__8a6d",
            "optimization_parameter",
            ["parameter__id"],
            ["id"],
        )

    with op.batch_alter_table("optimization_indexsetdata", schema=None) as batch_op:
        batch_op.drop_constraint(
            batch_op.f(
                "fk_optimization_indexsetdata_indexset__id_optimization_indexset"
            ),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_optimization_indexsetdata_indexset__id_optimization_indexset",
            "optimization_indexset",
            ["indexset__id"],
            ["id"],
        )

    with op.batch_alter_table(
        "optimization_equationindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_constraint(
            batch_op.f("fk_optimization_equationindexsetassociation_equation__i_be8b"),
            type_="foreignkey",
        )
        batch_op.create_foreign_key(
            "fk_optimization_equationindexsetassociation_equation__i_be8b",
            "optimization_equation",
            ["equation__id"],
            ["id"],
        )

    # ### end Alembic commands ###
