# type: ignore
"""Remove Column class for Parameter

Revision ID: 86fd6ecaae8a
Revises: bc2e195788ba
Create Date: 2025-04-28 11:29:06.675241

"""

import sqlalchemy as sa
from alembic import op

# Revision identifiers, used by Alembic.
revision = "86fd6ecaae8a"
down_revision = "bc2e195788ba"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "optimization_parameterindexsetassociation",
        sa.Column("parameter__id", sa.Integer(), nullable=False),
        sa.Column("indexset__id", sa.Integer(), nullable=False),
        sa.Column("column_name", sa.String(length=255), nullable=True),
        sa.Column(
            "id",
            sa.Integer(),
            sa.Identity(always=False, on_null=True, start=1, increment=1),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["indexset__id"],
            ["optimization_indexset.id"],
            name=op.f("fk_optimization_parameterindexsetassociation_indexset___7045"),
        ),
        sa.ForeignKeyConstraint(
            ["parameter__id"],
            ["optimization_parameter.id"],
            name=op.f("fk_optimization_parameterindexsetassociation_parameter__8a6d"),
        ),
        sa.PrimaryKeyConstraint(
            "id", name=op.f("pk_optimization_parameterindexsetassociation")
        ),
    )
    with op.batch_alter_table(
        "optimization_parameterindexsetassociation", schema=None
    ) as batch_op:
        batch_op.create_index(
            batch_op.f("ix_optimization_parameterindexsetassociation_indexset__id"),
            ["indexset__id"],
            unique=False,
        )
        batch_op.create_index(
            batch_op.f("ix_optimization_parameterindexsetassociation_parameter__id"),
            ["parameter__id"],
            unique=False,
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "optimization_parameterindexsetassociation", schema=None
    ) as batch_op:
        batch_op.drop_index(
            batch_op.f("ix_optimization_parameterindexsetassociation_parameter__id")
        )
        batch_op.drop_index(
            batch_op.f("ix_optimization_parameterindexsetassociation_indexset__id")
        )

    op.drop_table("optimization_parameterindexsetassociation")
    # ### end Alembic commands ###
