# In[1]

# import libraries
import os
import geopandas as gpd
from shapely.geometry import Point
from tlpytools.log import logger
from tlpytools.config import run_yaml
import yaml


def get_adls_url():
    """Get ADLS URL with https:// prefix if needed"""
    adls_base = os.getenv("ORCA_ADLS_URL", "yourstorageaccount.dfs.core.windows.net")
    return f"https://{adls_base}" if adls_base else None


# define main class
class mydataproject(logger, run_yaml):

    # init method or constructor
    def __init__(self):
        # declare used variables
        self.dfs = None  # shared data frame of input and intermediate data
        self.clearMem = None  # flag for clear mem
        self.s = None  # master config for instance

        # load yaml data and config
        self.load_yaml()

        # initialize logger
        self.init_logger()

    def main(self):
        """method to run all steps specified in yaml"""
        self.run_steps(self.s, self.log)

    def process_data(self, spec, files):
        """example method to process data - to be implemented

        Args:
            spec (dict): specification for this function
            files (dict): list of files from master specification
        """
        self.log.info("process_data completed")

        # try with geopstial data on Azure ADLS
        if "example_spatial" in self.gdfs.keys():
            print("example_spatial had been successfully read.")
        else:
            self.gdfs["example_spatial"] = gpd.GeoDataFrame(
                self.dfs["example_csv"].copy()
            )
            self.gdfs["example_spatial"]["geometry"] = Point(1, 1)


class mydataproject_yaml:
    @staticmethod
    def generate_default_yaml(filename="mydataproject.yaml"):
        # yaml config
        yaml_data = {
            "__COMMENT__": "THIS IS AN AUTOGENERATED YAML FILE",
            "FILES": {
                "INPUTS": {
                    # example data
                    # "example_csv": "src/examples/data_files/example.csv",
                    "example_csv": "td_2023.example.azuresql",
                },
                "SPATIALS": {
                    # example data
                    "example_spatial": f"{get_adls_url()}/dev/temp_tables/example.geojson",
                },
                # table col select, if not specify, load all cols
                "INPUT_COLUMNS": {
                    "example_csv": ["ID", "Example_Data", "Example_Data2"]
                },
                "OUTPUTS": {
                    # "example_csv": "data_files/outputs/example_out.csv",
                    "example_csv": "td_2023.example.azuresql",
                    "example_spatial": f"{get_adls_url()}/dev/temp_tables/example.geojson",
                },
            },
            "VARS": {"clearMem": True},
            "STEPS": [
                "process_data",
                "export_data",  # from config.run_yaml
                # "export_data_csv",  # from config.run_yaml
            ],
            "process_data": {
                # to be determined
                "placeholder": True
            },
        }

        with open(filename, "w") as yamlfile:
            data = yaml.dump(yaml_data, yamlfile, sort_keys=False)
            print("Write successful: {}".format(filename))


# In[3]
if __name__ == "__main__":

    # run example data project
    mydataproject_yaml.generate_default_yaml()
    example_instance = mydataproject()
    example_instance.main()

    print("done")
