# domolibrary: a powerful pydomo alternative

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Formatting

use_snake_case for everything except class names is_bool - prefix any
boolean parameters with is_bool

## Patterns to recycle

### UPSERT

domolibrary.classes.DomoUser upsert_user

### search entity

user_routes.SearchUser_NoResults()

## What is it?

**domolibrary** is a Python package that provides a OOP (class-based)
and a functional approach to interacting with Domo’s API framework.

All accessed APIs are documented under DataCrew’s
<a href ="https://documenter.getpostman.com/view/5049119/UyxbppB2" target="_blank">Domo
Documentation</a> page.

This library was created by
<a href ="https://datacrew.circle.so" target = "_blank">DataCrew</a>
contributor Jae Wilson.

## Install

The DataCrew team is hard at work expanding the list of available
`classes` and `routes`. We have a ton of work completed, it’s just a
matter of migrating and documenting the code into this library.

```sh
pip install domolibrary
```

## How to use

### Authentication

For each task, consider the appropriate
[`DomoAuth`](https://jaewilson07.github.io/domo_library/client/domoauth.html#domoauth)
mechanism. In most cases
[`DomoFullAuth`](https://jaewilson07.github.io/domo_library/client/domoauth.html#domofullauth)
or
[`DomoTokenAuth`](https://jaewilson07.github.io/domo_library/client/domoauth.html#domotokenauth)
will be appropriate as this library predominately accesses private APIs.

Any Public routes or methods will be labeled appropriately in which case
you should use
[`DomoDeveloperAuth`](https://jaewilson07.github.io/domo_library/client/domoauth.html#domodeveloperauth).
Public routes are APIs enumerated and documented under
<a href = "https://developer.domo.com/" target="_blank">Developer.Domo.com</a>.

Typically each project will begin with configuring an auth object. If
you are accessing multiple Domo instances, you’ll probably need multiple
auth objects.

```python
# configure an auth method
import os
import domolibrary.client.DomoAuth as dmda

token_auth = dmda.DomoTokenAuth(
    domo_instance=os.environ['DOMO_INSTANCE'],
    domo_access_token=os.environ["DOMO_ACCESS_TOKEN"],
)
```

### Option 1: class based programming

In this project domo entities,
[`DomoActivityLog`](https://jaewilson07.github.io/domo_library/classes/domoactivitylog.html#domoactivitylog),
[`DomoDataset`](https://jaewilson07.github.io/domo_library/classes/domodataset.html#domodataset)
are all prefixed ‘Domo’ and can be found in the `classes` folder. Each
class method will call one or more `routes`. Each route will interact
with one and only one API.

Although most methods will be standard methods that will be called after
creating an instance of the class, some methods will be classmethods
which return an instance of the class.

In the example below,
[`DomoDataset.get_from_id`](https://jaewilson07.github.io/domo_library/classes/domodataset.html#domodataset.get_from_id)
is a classmethod.

Note: DomoLibrary uses the asynchronous `aiohttp` requests library to
offer users the ability to write concurrently executing code.

```python
# import domolibrary.classes.DomoDataset as dmds

# # this is a class method
# domo_ds = await dmds.DomoDataset.get_from_id(auth=token_auth, dataset_id=os.environ['DOJO_DATASET_ID'])
# domo_ds
```

Once instantiated, you can call methods to interact with that object.
You typically won’t have to pass auth creds again because they are saved
to the object.

In the example below we are retrieving the
[`DomoDataset_Schema`](https://jaewilson07.github.io/domo_library/classes/domodataset.html#domodataset_schema)
which consists of subclass
[`DomoDataset_Schema_Column`](https://jaewilson07.github.io/domo_library/classes/domodataset.html#domodataset_schema_column)
using the
[`DomoDataset_Schema.get`](https://jaewilson07.github.io/domo_library/classes/domodataset.html#domodataset_schema.get)
method.

We take the approach of where possible converting dictionaries from Domo
APIs into classes because it provides greater predictability when users
are creating integrations between platforms (ex. Domo to Trello).

```python
# await domo_ds.schema.get()
```

Typically all information about an entity is saved in the object

```python
# domo_ds.__dict__
```

### Option 2 functional programming

Although classes add a pretty wrapper for interacting with Domo APIs,
users can opt to interact directly with APIs by way of `routes`.

All route functions will exclusively call one API and will always return
a
[`ResponseGetData`](https://jaewilson07.github.io/domo_library/client/responsegetdata.html#responsegetdata)
object OR raise an `Exception` if appropriate.

For example we can implement similar functionality as the Option 1
example by calling the
[`get_dataset_by_id`](https://jaewilson07.github.io/domo_library/routes/dataset.html#get_dataset_by_id)
function.

```python
import domolibrary.routes.dataset as dataset_routes

ds_res = await dataset_routes.get_dataset_by_id(
    auth=token_auth, dataset_id=os.environ["DOJO_DATASET_ID"]
)
ds_res
```

    adjusting num_stacks_to_drop, consider revising `get_traceback` call
    {16, 3, 12}

    ResponseGetData(status=200, response={'id': '04c1574e-c8be-4721-9846-c6ffa491144b', 'displayType': 'domo-jupyterdata', 'dataProviderType': 'domo-jupyterdata', 'type': 'Jupyter', 'name': 'domo_kbs', 'owner': {'id': '1893952720', 'name': 'Jae Wilson1', 'type': 'USER', 'group': False}, 'status': 'SUCCESS', 'created': 1668379680000, 'lastTouched': 1694281720000, 'lastUpdated': 1668385822045, 'rowCount': 1185, 'columnCount': 7, 'cardInfo': {'cardCount': 2, 'cardViewCount': 0}, 'properties': {'formulas': {'formulas': {'calculation_ca9d4b1c-f73a-4f76-9f94-d3c4ca6871c5': {'templateId': 2664, 'id': 'calculation_ca9d4b1c-f73a-4f76-9f94-d3c4ca6871c5', 'name': 'rowcount', 'formula': 'sum(1)', 'status': 'VALID', 'dataType': 'LONG', 'persistedOnDataSource': True, 'isAggregatable': True, 'bignumber': False}, 'calculation_38846559-d190-4ab1-809b-bcd361db5670': {'templateId': 2665, 'id': 'calculation_38846559-d190-4ab1-809b-bcd361db5670', 'name': 'max_views', 'formula': 'max(views)', 'status': 'VALID', 'dataType': 'LONG', 'persistedOnDataSource': True, 'isAggregatable': True, 'bignumber': False, 'columnPositions': [{'columnName': 'views', 'columnPosition': 4}]}}}}, 'state': 'SUCCESS', 'validConfiguration': True, 'validAccount': True, 'streamId': 825, 'transportType': 'API', 'adc': False, 'adcExternal': False, 'cloudId': 'domo', 'cloudName': 'Domo', 'permissions': 'READ_WRITE_DELETE_SHARE_ADMIN', 'hidden': False, 'tags': '["Sep-09-2023 17:48","developer_documentation","hackercore"]', 'scheduleActive': True, 'cardCount': 2, 'cryoStatus': 'ADRENALINE'}, is_success=True, parent_class=None, traceback_details=TracebackDetails(function_name='get_dataset_by_id', file_name='/workspaces/domo_library/domolibrary/routes/dataset.py', function_trail='<module> -> get_dataset_by_id', traceback_stack=[<FrameSummary file /tmp/ipykernel_16238/1373906764.py, line 3 in <module>>, <FrameSummary file /workspaces/domo_library/domolibrary/routes/dataset.py, line 171 in get_dataset_by_id>], parent_class=None))

[`ResponseGetData`](https://jaewilson07.github.io/domo_library/client/responsegetdata.html#responsegetdata)
will always include a boolean `is_success`, the API `status`, and raw
API `response`.

Typically the route methods will not alter the response unless the API
does not include a descriptive response (ex,
`routes.dataset.set_dataset_tags` does not return a response so we
artificially alter the response in the function.)

```python
[
    (prop, type(getattr(ds_res, prop)))
    for prop in dir(ds_res)
    if not prop.startswith("_")
]
```

    [('auth', domolibrary.client.DomoAuth.DomoTokenAuth),
     ('is_success', bool),
     ('parent_class', NoneType),
     ('response', dict),
     ('set_response', method),
     ('status', int),
     ('traceback_details', domolibrary.client.Logger.TracebackDetails)]

```python
ds_res.response
```

    {'id': '04c1574e-c8be-4721-9846-c6ffa491144b',
     'displayType': 'domo-jupyterdata',
     'dataProviderType': 'domo-jupyterdata',
     'type': 'Jupyter',
     'name': 'domo_kbs',
     'owner': {'id': '1893952720',
      'name': 'Jae Wilson1',
      'type': 'USER',
      'group': False},
     'status': 'SUCCESS',
     'created': 1668379680000,
     'lastTouched': 1694281720000,
     'lastUpdated': 1668385822045,
     'rowCount': 1185,
     'columnCount': 7,
     'cardInfo': {'cardCount': 2, 'cardViewCount': 0},
     'properties': {'formulas': {'formulas': {'calculation_ca9d4b1c-f73a-4f76-9f94-d3c4ca6871c5': {'templateId': 2664,
         'id': 'calculation_ca9d4b1c-f73a-4f76-9f94-d3c4ca6871c5',
         'name': 'rowcount',
         'formula': 'sum(1)',
         'status': 'VALID',
         'dataType': 'LONG',
         'persistedOnDataSource': True,
         'isAggregatable': True,
         'bignumber': False},
        'calculation_38846559-d190-4ab1-809b-bcd361db5670': {'templateId': 2665,
         'id': 'calculation_38846559-d190-4ab1-809b-bcd361db5670',
         'name': 'max_views',
         'formula': 'max(views)',
         'status': 'VALID',
         'dataType': 'LONG',
         'persistedOnDataSource': True,
         'isAggregatable': True,
         'bignumber': False,
         'columnPositions': [{'columnName': 'views', 'columnPosition': 4}]}}}},
     'state': 'SUCCESS',
     'validConfiguration': True,
     'validAccount': True,
     'streamId': 825,
     'transportType': 'API',
     'adc': False,
     'adcExternal': False,
     'cloudId': 'domo',
     'cloudName': 'Domo',
     'permissions': 'READ_WRITE_DELETE_SHARE_ADMIN',
     'hidden': False,
     'tags': '["Sep-09-2023 17:48","developer_documentation","hackercore"]',
     'scheduleActive': True,
     'cardCount': 2,
     'cryoStatus': 'ADRENALINE'}

### Access Paginated APIs using the Looper

A hidden advantage of using the DomoLibrary is that paginated API
requests are baked into the route’s definition.

Consider
[`query_dataset_private`](https://jaewilson07.github.io/domo_library/routes/dataset.html#query_dataset_private)
from the `routes.dataset`.

Inside this function we are using
[`looper`](https://jaewilson07.github.io/domo_library/client/get_data.html#looper)
from `client.get_data` to paginate over the API response.

# known errors

- utils/upload_data is using a general try/except
- bootstrap route raising a general exception
- integrations/role_hierarchy raising general exception
- integrations/domoJupyter raising general exception
- DomoUser general Exception
