# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/classes/50_DomoSandbox.ipynb.

# %% auto 0
__all__ = ['DomoRepository', 'DomoSandbox']

# %% ../../nbs/classes/50_DomoSandbox.ipynb 3
from dataclasses import dataclass, field
from typing import List, Any
import datetime as dt
import pandas as pd

import dateutil.parser as dtut

import domolibrary.utils.DictDot as util_dd
import domolibrary.client.DomoAuth as dmda
import domolibrary.routes.sandbox as sandbox_routes

import domolibrary.classes.DomoLineage as dmdl

# %% ../../nbs/classes/50_DomoSandbox.ipynb 6
@dataclass
class DomoRepository:
    id: str
    auth: dmda.DomoAuth = field(repr = False)

    name: str
    last_updated_dt: dt.datetime
    commit_dt: dt.datetime
    commit_version: str
    
    content_page_id_ls: List[str] = None
    content_card_id_ls: List[str] = None
    content_dataflow_id_ls: List[str] = None
    content_view_id_ls: List[str] = None

    Lineage :dmdl.DomoLineage = None

    def __post_init__(self):
        self.Lineage = dmdl.DomoLineage(parent=self, auth = self.auth)

    @classmethod
    def _from_json(cls, auth : dmda.DomoAuth, obj ):

        dd = util_dd.DictDot(obj)

        return cls(
            id=dd.id,
            auth=auth,
            name=dd.name,
            content_page_id_ls=dd.repositoryContent.pageIds,
            content_card_id_ls=dd.repositoryContent.cardIds,
            content_dataflow_id_ls=dd.repositoryContent.dataflowIds,
            content_view_id_ls=dd.repositoryContent.viewIds,
            last_updated_dt=dtut.parse(dd.updated).replace(tzinfo=None),
            commit_dt=dtut.parse(dd.lastCommit.completed).replace(tzinfo=None),
            commit_version=dd.lastCommit.commitName,
        )

    @classmethod
    async def get_from_id(cls, repository_id: str, auth: dmda.DomoAuth):
        res = await sandbox_routes.get_repo_from_id(
            repository_id=repository_id, auth=auth
        )

        return cls._from_json(res.response, auth=auth)

    def convert_lineage_to_dataframe(self, return_raw: bool = False):

        flat_lineage_ls = self.Lineage._flatten_lineage()

        output_ls = [
            {
                "sandbox_id": self.id,
                "sandbox_name": self.name,
                "version": self.commit_version,
                "commit_dt": self.commit_dt,
                "last_updated_dt": self.last_updated_dt,
                "entity_type": row.get("entity_type"),
                "entity_id": row.get("entity_id"),
            }
            for row in flat_lineage_ls
        ]

        if return_raw:
            return output_ls

        return pd.DataFrame(output_ls)


@dataclass
class DomoSandbox:
    auth: dmda.DomoAuth = field(repr=False)

    repositories: List[DomoRepository] = None

    async def get_repositories(self):
        res = await sandbox_routes.get_shared_repos(self.auth)

        self.repositories = [
            DomoRepository._from_json(obj = obj, auth=self.auth) for obj in res.response
        ]

        return self.repositories
