# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/appdb.ipynb.

# %% auto 0
__all__ = ['AppDb_GET_Exception', 'AppDb_CRUD_Exception', 'get_datastores', 'get_datastore_by_id',
           'get_collections_from_datastore', 'create_datastore', 'create_collection', 'get_collections',
           'get_collection_by_id', 'get_documents_from_collection', 'Collection_Permission_Enum',
           'modify_collection_permissions', 'get_collection_document_by_id', 'create_document', 'update_document']

# %% ../../nbs/routes/appdb.ipynb 2
import httpx
import domolibrary.client.get_data as gd
import domolibrary.client.DomoAuth as dmda
import domolibrary.client.DomoError as de

from enum import Enum

# %% ../../nbs/routes/appdb.ipynb 4
class AppDb_GET_Exception(de.DomoError):
    def __init__(self, res, message=None):
        super().__init__(
            status=res.status,
            message=message or res.response,
            domo_instance=res.auth.domo_instance,
            function_name=res.traceback_details.function_name,
            parent_class=res.traceback_details.parent_class,
        )


class AppDb_CRUD_Exception(de.DomoError):
    def __init__(self, res, message=None):
        super().__init__(
            status=res.status,
            message=message or res.response,
            domo_instance=res.auth.domo_instance,
            function_name=res.traceback_details.function_name,
            parent_class=res.traceback_details.parent_class,
        )

# %% ../../nbs/routes/appdb.ipynb 7
gd.route_function


async def get_datastores(
    auth: dmda.DomoAuth,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_GET_Exception(res)

    return res

# %% ../../nbs/routes/appdb.ipynb 9
gd.route_function


async def get_datastore_by_id(
    auth: dmda.DomoAuth,
    datastore_id: str,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/{datastore_id}"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_GET_Exception(res)

    return res

# %% ../../nbs/routes/appdb.ipynb 11
gd.route_function


async def get_collections_from_datastore(
    auth: dmda.DomoAuth,
    datastore_id: str,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/{datastore_id}/collections"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_GET_Exception(res)

    return res

# %% ../../nbs/routes/appdb.ipynb 14
@gd.route_function
async def create_datastore(
    auth: dmda.DomoAuth,
    datastore_name=None,  # in UI shows up as appName,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/"

    body = {"name": datastore_name}

    res = await gd.get_data(
        auth=auth,
        method="POST",
        url=url,
        body=body,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_CRUD_Exception(res)

    return res


@gd.route_function
async def create_collection(
    auth: dmda.DomoAuth,
    datastore_id: str,  # collections must be created inside a datastore which will show as the associated app_name
    collection_name: str,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/{datastore_id}/collections"

    body = {"name": collection_name}

    res = await gd.get_data(
        auth=auth,
        method="POST",
        url=url,
        body=body,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_CRUD_Exception(res)

    return res


# NOT SUPPORTED
# @gd.route_function
# async def update_datastore_name(
#     auth: dmda.DomoAuth,
#     datastore_id :str,
#     datastore_name = None, # in UI shows up as appName,
#     parent_class: str = None,
#     debug_api: bool = False,
#     session: httpx.AsyncClient = None,
#     debug_num_stacks_to_drop=1,

# ):

#     url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/{datastore_id}"

#     body = {"name": datastore_name}


#     res = await gd.get_data(
#         auth=auth,
#         method="PUT",
#         url=url,
#         body = body,
#         parent_class=parent_class,
#         debug_api=debug_api,
#         session=session,
#         num_stacks_to_drop=debug_num_stacks_to_drop,
#     )

#     if not res.is_success:
#         raise AppDb_CRUD_Exception(res)

#     return res

# %% ../../nbs/routes/appdb.ipynb 16
gd.route_function


async def get_collections(
    auth: dmda.DomoAuth,
    datastore_id: str = None,  # filters for a specific datastoreId
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/collections/"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        params={"datastoreId": datastore_id},
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success and res.status == 400:
        raise AppDb_GET_Exception(
            res,
            message=f"invalid datastoreId  - {datastore_id} or ensure it's shared with authenticated user",
        )

    if not res.is_success:
        raise AppDb_GET_Exception(res)

    return res

# %% ../../nbs/routes/appdb.ipynb 18
@gd.route_function
async def get_collection_by_id(
    auth: dmda.DomoAuth,
    collection_id,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/collections/{collection_id}"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_GET_Exception(res)

    return res

# %% ../../nbs/routes/appdb.ipynb 20
@gd.route_function
async def get_documents_from_collection(
    auth: dmda.DomoAuth,
    collection_id: str,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    body=None,
    debug_num_stacks_to_drop=1,
    query : dict = None
):
    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v2/collections/{collection_id}/documents/query"

    query = query or {}

    res = await gd.get_data(
        auth=auth,
        method="POST",
        url=url,
        body=query,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_GET_Exception(
            res, message=f"unable to query documents in collection - {collection_id}"
        )

    return res

# %% ../../nbs/routes/appdb.ipynb 23
class Collection_Permission_Enum(Enum):
    READ_CONTENT = "READ_CONTENT"
    ADMIN = "ADMIN"
    UPDATE_CONTENT = "UPDATE_CONTENT"


@gd.route_function
async def modify_collection_permissions(
    collection_id: str,
    auth: dmda.DomoAuth,
    user_id: str = None,
    group_id: str = None,
    permission=Collection_Permission_Enum.READ_CONTENT,
    debug_api: bool = False,
    return_raw: bool = False,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/collections/{collection_id}/permission/{'USER' if user_id else {'GROUP'}}/{user_id or group_id}"

    params = {
        "overwrite": False,
        "permissions": (
            permission.value
            if isinstance(permission, Collection_Permission_Enum)
            else permission
        ),
    }

    res = await gd.get_data(
        auth=auth,
        method="PUT",
        params=params,
        url=url,
        debug_api=debug_api,
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        session=session,
    )

    if return_raw:
        return res

    if not res.is_success:
        raise AppDb_CRUD_Exception(
            res,
            message="unable to set permissions for {user_id} to {permission.value} in collection {collection_id}",
        )

    res.response = f"set permissions for {user_id} to {permission.value} in collection {collection_id}"

    return res

# %% ../../nbs/routes/appdb.ipynb 27
@gd.route_function
async def get_collection_document_by_id(
    auth: dmda.DomoAuth,
    collection_id: str,
    document_id: str,
    query: dict = None,
    parent_class: str = None,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/collections/{collection_id}/documents/{document_id}"

    res = await gd.get_data(
        auth=auth,
        method="GET",
        url=url,
        body=query,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_GET_Exception(res)

    return res

# %% ../../nbs/routes/appdb.ipynb 30
@gd.route_function
async def create_document(
    auth: dmda.DomoAuth,
    collection_id: str,
    content: dict,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    parent_class: str = None,
    debug_num_stacks_to_drop: int = 1,
):
    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v1/collections/{collection_id}/documents"

    res = await gd.get_data(
        auth=auth,
        method="POST",
        url=url,
        body={"content": content},
        session=session,
        debug_api=debug_api,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_CRUD_Exception(res)

    return res


@gd.route_function
async def update_document(
    auth: dmda.DomoAuth,
    collection_id: str,
    document_id: str,
    content: dict,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    parent_class: str = None,
    debug_num_stacks_to_drop: int = 1,
):
    url = f"https://{auth.domo_instance}.domo.com/api/datastores/v2/collections/{collection_id}/documents/{document_id}"

    res = await gd.get_data(
        auth=auth,
        method="PUT",
        url=url,
        body={"content": content},
        session=session,
        debug_api=debug_api,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise AppDb_CRUD_Exception(res)

    return res
