# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/dataflow.ipynb.

# %% auto 0
__all__ = ['GET_Dataflow_Error', 'CRUD_Dataflow_Error', 'get_dataflows', 'get_dataflow_by_id', 'get_dataflow_versions',
           'get_dataflow_by_id_and_version', 'get_dataflow_execution_history', 'get_dataflow_execution_by_id',
           'execute_dataflow']

# %% ../../nbs/routes/dataflow.ipynb 2
import httpx

import domolibrary.client.get_data as gd
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda
import domolibrary.client.DomoError as dmde

# %% ../../nbs/routes/dataflow.ipynb 5
class GET_Dataflow_Error(dmde.RouteError):
    def __init__(self, res: rgd.ResponseGetData):
        super().__init__(res=res)


class CRUD_Dataflow_Error(dmde.RouteError):
    def __init__(self, res: rgd.ResponseGetData):
        super().__init__(res=res)

# %% ../../nbs/routes/dataflow.ipynb 6
@gd.route_function
async def get_dataflows(
    auth: dmda.DomoAuth,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class: str = None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:
    domo_instance = auth.domo_instance

    url = f"https://{domo_instance}.domo.com/api/dataprocessing/v1/dataflows"

    res= await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise GET_Dataflow_Error(res)

    return res

# %% ../../nbs/routes/dataflow.ipynb 8
@gd.route_function
async def get_dataflow_by_id(
    dataflow_id: int,
    auth: dmda.DomoAuth,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class: str = None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:
    domo_instance = auth.domo_instance

    url = f"https://{domo_instance}.domo.com/api/dataprocessing/v1/dataflows/{dataflow_id}"

    res= await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise GET_Dataflow_Error(res)

    return res

# %% ../../nbs/routes/dataflow.ipynb 12
@gd.route_function
async def get_dataflow_versions(
    dataflow_id: int,
    auth: dmda.DomoAuth,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
    debug_api: bool = False,
):

    url = f"https://{auth.domo_instance}.domo.com/api/dataprocessing/v1/dataflows/{dataflow_id}/versions"

    res = await gd.get_data(
        auth=auth,
        session=session,
        url=url,
        method="GET",
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        debug_api=debug_api,
    )

    if not res.is_success:
        raise GET_Dataflow_Error(res = res)

    return res

# %% ../../nbs/routes/dataflow.ipynb 14
@gd.route_function
async def get_dataflow_by_id_and_version(
    dataflow_id: int,
    version_id: int,
    auth: dmda.DomoAuth,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
    debug_api: bool = False,
):

    url = f"https://{auth.domo_instance}.domo.com/api/dataprocessing/v2/dataflows/{dataflow_id}/versions/{version_id}"

    res = await gd.get_data(
        auth=auth,
        session=session,
        url=url,
        method="GET",
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        debug_api=debug_api,
    )

    if not res.is_success:
        raise GET_Dataflow_Error(res)

    return res

# %% ../../nbs/routes/dataflow.ipynb 16
@gd.route_function
async def get_dataflow_execution_history(
    dataflow_id: int,
    auth: dmda.DomoAuth,
    maximum: int = None,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
    debug_loop: bool = False,
    debug_api: bool = False,
):

    url = f"https://{auth.domo_instance}.domo.com/api/dataprocessing/v1/dataflows/{dataflow_id}/executions"

    def arr_fn(res):
        return res.response

    res = await gd.looper(
        auth=auth,
        session=session,
        url=url,
        loop_until_end=True if not maximum else False,
        method="GET",
        offset_params_in_body=False,
        offset_params={"offset": "offset", "limit": "limit"},
        arr_fn=arr_fn,
        maximum=maximum,
        limit=100,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        debug_api=debug_api,
        debug_loop=debug_loop,
    )

    if not res.is_success:
        raise GET_Dataflow_Error(res)

    return res

# %% ../../nbs/routes/dataflow.ipynb 19
@gd.route_function
async def get_dataflow_execution_by_id(
    auth: dmda.DomoAuth,
    dataflow_id: int,
    execution_id: int,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
) -> rgd.ResponseGetData:
    url = f"https://{auth.domo_instance}.domo.com/api/dataprocessing/v1/dataflows/{dataflow_id}/executions/{execution_id}"

    res= await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
    )

    if not res.is_success:
        raise GET_Dataflow_Error(res)
    
    return res

# %% ../../nbs/routes/dataflow.ipynb 22
@gd.route_function
async def execute_dataflow(
    auth: dmda.DomoAuth,
    dataflow_id: int,
    debug_api: bool = False,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    session: httpx.AsyncClient = None,
) -> rgd.ResponseGetData:
    url = f"https://{auth.domo_instance}.domo.com/api/dataprocessing/v1/dataflows/{dataflow_id}/executions"

    res= await gd.get_data(
        auth=auth,
        url=url,
        method="POST",
        num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        debug_api=debug_api,
        session=session,
    )
    if not res.is_success:
        raise CRUD_Dataflow_Error(res)
    
    return res
