# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/instance_config.ipynb.

# %% auto 0
__all__ = ['ToggleSocialUsers_Error', 'get_is_invite_social_users_enabled', 'get_is_user_invite_notifications_enabled',
           'ToggleUserInvite_Error', 'toggle_is_user_invite_enabled', 'Config_GET_Error', 'get_allowlist',
           'Allowlist_UnableToUpdate', 'set_allowlist', 'GetDomains_NotFound', 'get_authorized_domains',
           'set_authorized_domains', 'InstanceConfig_Error', 'get_is_weekly_digest_enabled',
           'toggle_is_weekly_digest_enabled', 'GetAppDomains_NotFound', 'get_authorized_custom_app_domains',
           'set_authorized_custom_app_domains']

# %% ../../nbs/routes/instance_config.ipynb 2
import httpx

from typing import List

import domolibrary.client.get_data as gd
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda
import domolibrary.client.DomoError as dmde

from domolibrary.utils.convert import convert_string_to_bool

import domolibrary.routes.user as user_routes

# %% ../../nbs/routes/instance_config.ipynb 5
class ToggleSocialUsers_Error(dmde.RouteError):
    def __init__(
        self, res: rgd.ResponseGetData, message="failure to toggle social users"
    ):
        super().__init__(res=res, message=message)


@gd.route_function
async def get_is_invite_social_users_enabled(
    auth: dmda.DomoAuth,
    customer_id: str,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    parent_class=None,
    return_raw: bool = False,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:

    # must pass the customer as the short form API endpoint (without customer_id) does not support a GET request
    # url = f"https://{auth.domo_instance}.domo.com/api/content/v3/customers/features/free-invite"

    url = f"https://{auth.domo_instance}.domo.com/api/content/v3/customers/{customer_id}/features/free-invite"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        session=session,
        debug_api=debug_api,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise ToggleSocialUsers_Error(
            res = res,
        )

    if return_raw:
        return res

    res.response = {"name": "free-invite", "is_enabled": res.response["enabled"]}

    return res

# %% ../../nbs/routes/instance_config.ipynb 7
@gd.route_function
async def get_is_user_invite_notifications_enabled(
    auth: dmda.DomoFullAuth,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    parent_class=None,
    debug_num_stacks_to_drop=1,
    return_raw: bool = False,
) -> rgd.ResponseGetData:


    url = f"https://{auth.domo_instance}.domo.com/api/customer/v1/properties/user.invite.email.enabled"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        session=session,
        debug_api=debug_api,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise ToggleSocialUsers_Error(
            res = res)

    if return_raw:
        return res

    res.response = {
        "name": "user.invite.email.enabled",
        "is_enabled": convert_string_to_bool(res.response["value"]),
    }

    return res

# %% ../../nbs/routes/instance_config.ipynb 8
class ToggleUserInvite_Error(dmde.RouteError):
    def __init__(
        self, res : rgd.ResponseGetData,
        message="failure to toggle user invite enabled"
    ):
        super().__init__(res = res, message=message)


@gd.route_function
async def toggle_is_user_invite_enabled(
    auth: dmda.DomoFullAuth,
    is_enabled: bool,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    return_raw: bool = False,
    parent_class=None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:
    """
    Admin > Company Settings > Notifications
    """

    url = f"https://{auth.domo_instance}.domo.com/api/customer/v1/properties/user.invite.email.enabled"

    body = {"value": is_enabled}

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="PUT",
        body=body,
        session=session,
        debug_api=debug_api,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise ToggleUserInvite_Error(
            res = res,
            message=res.response
        )

    if return_raw:
        return res

    return await get_is_user_invite_notifications_enabled(
        auth = auth,
        debug_api = debug_api,
        session = session,
        parent_class = parent_class,
        debug_num_stacks_to_drop = debug_num_stacks_to_drop
    )

# %% ../../nbs/routes/instance_config.ipynb 11
class Config_GET_Error(dmde.RouteError):
    def __init__(self, res: rgd.ResponseGetData, message: str = None):
        super().__init__(res=res, message=message)


@gd.route_function
async def get_allowlist(
    auth: dmda.DomoAuth,
    session: httpx.AsyncClient = None,
    return_raw: bool = False,
    debug_api: bool = False,
    parent_class=None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:

    url = f"https://{auth.domo_instance}.domo.com/admin/companysettings/whitelist"
   
    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        headers={"accept": "*/*"},
        session=session,
        debug_api=debug_api,
        is_follow_redirects=True,
        return_raw=return_raw,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise Config_GET_Error(res=res)

    return res

# %% ../../nbs/routes/instance_config.ipynb 13
class Allowlist_UnableToUpdate(dmde.RouteError):
    def __init__(
        self, res: rgd.ResponseGetData, reason: str = None, message: str = None
    ):
        super().__init__(
            res=res,
            message=message or f"unable to update allowlist: {reason}",
        )

# %% ../../nbs/routes/instance_config.ipynb 14
@gd.route_function
async def set_allowlist(
    auth: dmda.DomoAuth,
    ip_address_ls: list[str],
    debug_api: bool = False,
    return_raw: bool = False,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
) -> rgd.ResponseGetData:
    """companysettings/whitelist API only allows users to SET the allowlist does not allow INSERT or UPDATE"""

    url = f"https://{auth.domo_instance}.domo.com/admin/companysettings/whitelist"

    body = {"addresses": ip_address_ls}

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="PUT",
        body=body,
        debug_api=debug_api,
        is_follow_redirects=True,
        session=session,
        headers={"accept": "text/plain"},
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )
    if not res.is_success:
        raise Allowlist_UnableToUpdate(res=res, reason=res.response)

    if return_raw:
        return res
    try:
        return await get_allowlist(
            auth=auth,
            debug_api=debug_api,
            session=session,
            debug_num_stacks_to_drop=debug_num_stacks_to_drop,
            parent_class=parent_class,
        )
    
    except dmda.InvalidAuthTypeError as e :
        raise Allowlist_UnableToUpdate(res = res, message = "unable to GET allowlist - either pass FullAuth or return_raw = True" ) from e 


# %% ../../nbs/routes/instance_config.ipynb 16
class GetDomains_NotFound(dmde.RouteError):
    def __init__(self, res : rgd.ResponseGetData, message : str = None):
        super().__init__(res = res , message=message)


@gd.route_function
async def get_authorized_domains(
    auth: dmda.DomoAuth,
    return_raw: bool = False,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
):


    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/customer-states/authorized-domains"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if return_raw:
        return res

    # domo raises a 404 error even if the success is valid but there are no approved domains
    if res.status == 404 and res.response == "Not Found":
        res_test = await user_routes.get_all_users(auth=auth)

        if not res_test.is_success:
            raise GetDomains_NotFound(
                res = res
            )

        if res_test.is_success:
            res.status = 200
            res.is_success = True
            res.response = []

        return res

    res.response = [domain.strip() for domain in res.response.get("value").split(",")]
    return res

# %% ../../nbs/routes/instance_config.ipynb 18
@gd.route_function
async def set_authorized_domains(
    auth: dmda.DomoAuth,
    authorized_domain_ls: List[str],
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
):

    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/customer-states/authorized-domains"

    body = {"name": "authorized-domains", "value": ",".join(authorized_domain_ls)}

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="PUT",
        body=body,
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise Config_GET_Error(res = res)

    return await get_authorized_domains(auth=auth, 
                                        debug_api=debug_api,
                                        session = session,
                                        debug_num_stacks_to_drop = debug_num_stacks_to_drop,
                                        parent_class = parent_class
                                        )

# %% ../../nbs/routes/instance_config.ipynb 19
class InstanceConfig_Error(dmde.RouteError):
    def __init__(self, res: rgd.ResponseGetData, message: str = None):
        super().__init__(res=res, message=message)


@gd.route_function
async def get_is_weekly_digest_enabled(
    auth: dmda.DomoAuth,
    return_raw: bool = False,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
):
    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/customer-states/come-back-to-domo-all-users"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if return_raw:
        return res

    if res.status == 404 and res.response == "Not Found":
        raise InstanceConfig_Error(res=res)

    res.response = {
        "is_enabled": convert_string_to_bool(res.response["value"]),
        "feature": "come-back-to-domo-all-users",
    }

    return res

# %% ../../nbs/routes/instance_config.ipynb 21
@gd.route_function
async def toggle_is_weekly_digest_enabled(
    auth: dmda.DomoAuth,
    return_raw: bool = False,
    debug_api: bool = False,
    is_enabled: bool = True,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
):
    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/customer-states/come-back-to-domo-all-users"

    body = {"name": "come-back-to-domo-all-users", "value": is_enabled}

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="PUT",
        body=body,
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if return_raw:
        return res

    if not res.is_success:
        raise Config_GET_Error(res=res)

    return await get_is_weekly_digest_enabled(
        auth=auth,
        debug_api=debug_api,
        parent_class=parent_class,
        session=session,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
    )

# %% ../../nbs/routes/instance_config.ipynb 23
class GetAppDomains_NotFound(dmde.DomoError):
    def __init__(self, res: rgd.ResponseGetData, message: str = None):
        super().__init__(res=res, message=message)


@gd.route_function
async def get_authorized_custom_app_domains(
    auth: dmda.DomoAuth,
    return_raw: bool = False,
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
):
    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/customer-states/authorized-app-domains"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if return_raw:
        return res

    # domo raises a 404 error even if the success is valid but there are no approved domains
    if res.status == 404 and res.response == "Not Found":
        res_test = await user_routes.get_all_users(auth=auth)

        if not res_test.is_success:
            raise GetAppDomains_NotFound(
                res = res
            )

        if res_test.is_success:
            res.status = 200
            res.is_success = True
            res.response = []

        return res

    res.response = [domain.strip() for domain in res.response.get("value").split(",")]
    return res

# %% ../../nbs/routes/instance_config.ipynb 25
@gd.route_function
async def set_authorized_custom_app_domains(
    auth: dmda.DomoAuth,
    authorized_custom_app_domain_ls: List[str],
    debug_api: bool = False,
    session: httpx.AsyncClient = None,
    parent_class=None,
    debug_num_stacks_to_drop=1,
):
    url = f"https://{auth.domo_instance}.domo.com/api/content/v1/customer-states/authorized-app-domains"

    body = {
        "name": "authorized-app-domains",
        "value": ",".join(authorized_custom_app_domain_ls),
    }

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="PUT",
        body=body,
        debug_api=debug_api,
        session=session,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise InstanceConfig_Error(res = res)

    return await get_authorized_custom_app_domains(auth=auth,
                                                   debug_api=debug_api,
                                                   parent_class = parent_class,
                                                   debug_num_stacks_to_drop = debug_num_stacks_to_drop,
                                                   session = session
                                                   )
