# AUTOGENERATED! DO NOT EDIT! File to edit: ../../nbs/routes/stream.ipynb.

# %% auto 0
__all__ = ['Streams_GET_Error', 'get_streams', 'get_stream_by_id', 'Streams_CRUD_Error', 'update_stream', 'create_stream',
           'execute_stream']

# %% ../../nbs/routes/stream.ipynb 2
import httpx

import domolibrary.client.get_data as gd
import domolibrary.client.ResponseGetData as rgd
import domolibrary.client.DomoAuth as dmda

import domolibrary.client.DomoError as dmde

# %% ../../nbs/routes/stream.ipynb 5
class Streams_GET_Error(dmde.RouteError):
    def __init__(self, res, message=None):
        super().__init__(self, res=res, message=message or res.response)


@gd.route_function
async def get_streams(
    auth: dmda.DomoAuth,
    loop_until_end: bool = True,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop=1,
    parent_class: str = None,
    debug_api: bool = False,
    debug_loop: bool = False,
    return_raw: bool = False,
    skip: int = 0,
    maximum: int = 1000,
) -> rgd.ResponseGetData:
    """
    streams do not appear to be reycled, not recommended for use as will return a virtually limiltess number of streams
    instead use get_by_id
    """
    
    url = f"https://{auth.domo_instance}.domo.com/api/data/v1/streams/"

    def arr_fn(res):
        return res.response


    res = await gd.looper(
        auth=auth,
        session=session,
        url=url,
        offset_params={"limit": "limit", "offset": "offet"},
        arr_fn=arr_fn,
        loop_until_end=loop_until_end,
        method="GET",
        offset_params_in_body=False,
        limit=500,
        skip=skip,
        maximum=maximum,
        debug_api=debug_api,
        debug_loop=debug_loop,
        debug_num_stacks_to_drop=debug_num_stacks_to_drop,
        parent_class=parent_class,
        return_raw=return_raw,
    )

    if return_raw:
        return res

    if not res.is_success:
        raise Streams_GET_Error(res=res)

    return res

# %% ../../nbs/routes/stream.ipynb 7
@gd.route_function
async def get_stream_by_id(
    auth: dmda.DomoAuth,
    stream_id: str,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop: int = 1,
    parent_class: str = None,
) -> rgd.ResponseGetData:
    url = f"https://{auth.domo_instance}.domo.com/api/data/v1/streams/{stream_id}"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="GET",
        session=session,
        debug_api=debug_api,
        parent_class=parent_class,
        num_stacks_to_drop=debug_num_stacks_to_drop,
    )

    if not res.is_success:
        raise Streams_GET_Error(res=res)

    return res

# %% ../../nbs/routes/stream.ipynb 8
class Streams_CRUD_Error(dmde.RouteError):
    def __init__(self, res, message=None):
        super().__init__(self, res=res, message=message or res.response)


@gd.route_function
async def update_stream(
    auth: dmda.DomoAuth,
    stream_id: str,
    body: dict,
    session: httpx.AsyncClient = None,
    debug_num_stacks_to_drop = 1,
    debug_api: bool = False,
    parent_class : str = None

) -> rgd.ResponseGetData:
    url = f"https://{auth.domo_instance}.domo.com/api/data/v1/streams/{stream_id}"

    res = await gd.get_data(
        auth=auth,
        url=url,
        body=body,
        method="PUT",
        session=session,
        debug_api=debug_api,
        parent_class = parent_class,
        num_stacks_to_drop = debug_num_stacks_to_drop 

    )

    if not res.is_success:
        raise Streams_CRUD_Error(res = res)
    
    return res

@gd.route_function
async def create_stream(
    auth: dmda.DomoAuth,
    body: dict,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    debug_num_stacks_to_drop: bool = False,
    parent_class : str = None
) -> rgd.ResponseGetData:
    url = f"https://{auth.domo_instance}.domo.com/api/data/v1/streams"


    res = await gd.get_data(
        auth=auth,
        url=url,
        body=body,
        method="POST",
        session=session,
        debug_api=debug_api,
        parent_class = parent_class,
        num_stacks_to_drop = debug_num_stacks_to_drop
    )

    if not res.is_success:
        raise Streams_CRUD_Error(res = res)
    
    return res


@gd.route_function
async def execute_stream(
    auth: dmda.DomoAuth,
    stream_id: str,
    session: httpx.AsyncClient = None,
    debug_api: bool = False,
    parent_class : str = None,
    debug_num_stacks_to_drop = 1
) -> rgd.ResponseGetData:
    url = f"https://{auth.domo_instance}.domo.com/api/data/v1/streams/{stream_id}/executions"

    res = await gd.get_data(
        auth=auth,
        url=url,
        method="POST",
        session=session,
        debug_api=debug_api,
        parent_class = parent_class,
        num_stacks_to_drop = debug_num_stacks_to_drop
    )

    if not res.is_success:
        raise Streams_CRUD_Error(res = res)
    
    return res
