# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuthorizationRuleUpdateRankArgs', 'AuthorizationRuleUpdateRank']

@pulumi.input_type
class AuthorizationRuleUpdateRankArgs:
    def __init__(__self__, *,
                 policy_set_id: pulumi.Input[_builtins.str],
                 rank: pulumi.Input[_builtins.int],
                 rule_id: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a AuthorizationRuleUpdateRank resource.
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] rule_id: Authorization rule ID
        """
        pulumi.set(__self__, "policy_set_id", policy_set_id)
        pulumi.set(__self__, "rank", rank)
        pulumi.set(__self__, "rule_id", rule_id)

    @_builtins.property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> pulumi.Input[_builtins.str]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @policy_set_id.setter
    def policy_set_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "policy_set_id", value)

    @_builtins.property
    @pulumi.getter
    def rank(self) -> pulumi.Input[_builtins.int]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "rank", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Input[_builtins.str]:
        """
        Authorization rule ID
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "rule_id", value)


@pulumi.input_type
class _AuthorizationRuleUpdateRankState:
    def __init__(__self__, *,
                 policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AuthorizationRuleUpdateRank resources.
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] rule_id: Authorization rule ID
        """
        if policy_set_id is not None:
            pulumi.set(__self__, "policy_set_id", policy_set_id)
        if rank is not None:
            pulumi.set(__self__, "rank", rank)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)

    @_builtins.property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @policy_set_id.setter
    def policy_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "policy_set_id", value)

    @_builtins.property
    @pulumi.getter
    def rank(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @rank.setter
    def rank(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rank", value)

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Authorization rule ID
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rule_id", value)


@pulumi.type_token("ise:networkaccess/authorizationRuleUpdateRank:AuthorizationRuleUpdateRank")
class AuthorizationRuleUpdateRank(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource is used to update rank field in network access authorization rule. It serves as a workaround for the ISE API/Backend limitation which restricts rank assignments to a strictly incremental sequence. By utilizing this resource and network_access_authorization_rule resource, you can bypass the APIs limitation. Creation of this resource is performing PUT operation (Update) and it only tracks rank field. When this resource is destroyed, no action is performed on ISE and resource is just removed from state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.networkaccess.AuthorizationRuleUpdateRank("example",
            rule_id="9b3680da-0165-44f6-9cff-88e778d98020",
            policy_set_id="d82952cb-b901-4b09-b363-5ebf39bdbaf9",
            rank=0)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] rule_id: Authorization rule ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthorizationRuleUpdateRankArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource is used to update rank field in network access authorization rule. It serves as a workaround for the ISE API/Backend limitation which restricts rank assignments to a strictly incremental sequence. By utilizing this resource and network_access_authorization_rule resource, you can bypass the APIs limitation. Creation of this resource is performing PUT operation (Update) and it only tracks rank field. When this resource is destroyed, no action is performed on ISE and resource is just removed from state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.networkaccess.AuthorizationRuleUpdateRank("example",
            rule_id="9b3680da-0165-44f6-9cff-88e778d98020",
            policy_set_id="d82952cb-b901-4b09-b363-5ebf39bdbaf9",
            rank=0)
        ```

        :param str resource_name: The name of the resource.
        :param AuthorizationRuleUpdateRankArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthorizationRuleUpdateRankArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 rank: Optional[pulumi.Input[_builtins.int]] = None,
                 rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthorizationRuleUpdateRankArgs.__new__(AuthorizationRuleUpdateRankArgs)

            if policy_set_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_set_id'")
            __props__.__dict__["policy_set_id"] = policy_set_id
            if rank is None and not opts.urn:
                raise TypeError("Missing required property 'rank'")
            __props__.__dict__["rank"] = rank
            if rule_id is None and not opts.urn:
                raise TypeError("Missing required property 'rule_id'")
            __props__.__dict__["rule_id"] = rule_id
        super(AuthorizationRuleUpdateRank, __self__).__init__(
            'ise:networkaccess/authorizationRuleUpdateRank:AuthorizationRuleUpdateRank',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            policy_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            rank: Optional[pulumi.Input[_builtins.int]] = None,
            rule_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'AuthorizationRuleUpdateRank':
        """
        Get an existing AuthorizationRuleUpdateRank resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] policy_set_id: Policy set ID
        :param pulumi.Input[_builtins.int] rank: The rank (priority) in relation to other rules. Lower rank is higher priority.
        :param pulumi.Input[_builtins.str] rule_id: Authorization rule ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthorizationRuleUpdateRankState.__new__(_AuthorizationRuleUpdateRankState)

        __props__.__dict__["policy_set_id"] = policy_set_id
        __props__.__dict__["rank"] = rank
        __props__.__dict__["rule_id"] = rule_id
        return AuthorizationRuleUpdateRank(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="policySetId")
    def policy_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        Policy set ID
        """
        return pulumi.get(self, "policy_set_id")

    @_builtins.property
    @pulumi.getter
    def rank(self) -> pulumi.Output[_builtins.int]:
        """
        The rank (priority) in relation to other rules. Lower rank is higher priority.
        """
        return pulumi.get(self, "rank")

    @_builtins.property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[_builtins.str]:
        """
        Authorization rule ID
        """
        return pulumi.get(self, "rule_id")

