# Generated by Django 4.2.17 on 2024-12-05 18:54

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('core', '0091_systemid'),
    ]

    operations = [
        migrations.CreateModel(
            name='DistributionTree',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_distributiontree', serialize=False, to='core.content')),
                ('header_version', models.CharField(max_length=10)),
                ('release_name', models.CharField(max_length=50)),
                ('release_short', models.CharField(max_length=20)),
                ('release_version', models.CharField(max_length=10)),
                ('release_is_layered', models.BooleanField(default=False)),
                ('base_product_name', models.CharField(max_length=50, null=True)),
                ('base_product_short', models.CharField(max_length=20, null=True)),
                ('base_product_version', models.CharField(max_length=10, null=True)),
                ('arch', models.CharField(max_length=30)),
                ('build_timestamp', models.FloatField()),
                ('instimage', models.CharField(max_length=50, null=True)),
                ('mainimage', models.CharField(max_length=50, null=True)),
                ('discnum', models.IntegerField(null=True)),
                ('totaldiscs', models.IntegerField(null=True)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('header_version', 'release_name', 'release_short', 'release_version', 'arch', 'build_timestamp')},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='ModulemdDefaults',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_modulemddefaults', serialize=False, to='core.content')),
                ('module', models.CharField(max_length=255)),
                ('stream', models.CharField(max_length=255)),
                ('profiles', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('digest', models.CharField(max_length=64, unique=True)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='Package',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_package', serialize=False, to='core.content')),
                ('name', models.CharField(max_length=255)),
                ('epoch', models.CharField(max_length=10)),
                ('version', models.CharField(max_length=255)),
                ('release', models.CharField(max_length=255)),
                ('arch', models.CharField(max_length=20)),
                ('pkgId', models.CharField(max_length=128, unique=True)),
                ('checksum_type', models.CharField(choices=[('unknown', 'unknown'), ('md5', 'md5'), ('sha1', 'sha1'), ('sha1', 'sha1'), ('sha224', 'sha224'), ('sha256', 'sha256'), ('sha384', 'sha384'), ('sha512', 'sha512')], max_length=10)),
                ('summary', models.TextField()),
                ('description', models.TextField()),
                ('url', models.TextField()),
                ('changelogs', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('files', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('requires', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('provides', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('conflicts', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('obsoletes', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('suggests', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('enhances', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('recommends', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('supplements', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('location_base', models.TextField()),
                ('location_href', models.TextField()),
                ('rpm_buildhost', models.TextField()),
                ('rpm_group', models.TextField()),
                ('rpm_license', models.TextField()),
                ('rpm_packager', models.TextField()),
                ('rpm_sourcerpm', models.TextField()),
                ('rpm_vendor', models.TextField()),
                ('rpm_header_start', models.BigIntegerField(null=True)),
                ('rpm_header_end', models.BigIntegerField(null=True)),
                ('is_modular', models.BooleanField(default=False)),
                ('size_archive', models.BigIntegerField(null=True)),
                ('size_installed', models.BigIntegerField(null=True)),
                ('size_package', models.BigIntegerField(null=True)),
                ('time_build', models.BigIntegerField(null=True)),
                ('time_file', models.BigIntegerField(null=True)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('name', 'epoch', 'version', 'release', 'arch', 'checksum_type', 'pkgId')},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='PackageLangpacks',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_packagelangpacks', serialize=False, to='core.content')),
                ('matches', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('digest', models.CharField(max_length=64, unique=True)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='RpmPublication',
            fields=[
                ('publication_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_rpmpublication', serialize=False, to='core.publication')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.publication',),
        ),
        migrations.CreateModel(
            name='RpmRemote',
            fields=[
                ('remote_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_rpmremote', serialize=False, to='core.remote')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.remote',),
        ),
        migrations.CreateModel(
            name='RpmRepository',
            fields=[
                ('repository_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_rpmrepository', serialize=False, to='core.repository')),
                ('sub_repo', models.BooleanField(default=False)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.repository',),
        ),
        migrations.CreateModel(
            name='UpdateCollection',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.TextField()),
                ('shortname', models.TextField()),
                ('module', models.TextField(default='')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UpdateRecord',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_updaterecord', serialize=False, to='core.content')),
                ('id', models.CharField(db_index=True, max_length=255)),
                ('updated_date', models.TextField()),
                ('description', models.TextField()),
                ('issued_date', models.TextField()),
                ('fromstr', models.TextField()),
                ('status', models.TextField()),
                ('title', models.TextField()),
                ('summary', models.TextField()),
                ('version', models.TextField()),
                ('type', models.TextField()),
                ('severity', models.TextField()),
                ('solution', models.TextField()),
                ('release', models.TextField()),
                ('rights', models.TextField()),
                ('pushcount', models.TextField(blank=True)),
                ('digest', models.CharField(max_length=64, unique=True)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='UpdateReference',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('href', models.TextField()),
                ('ref_id', models.TextField(null=True)),
                ('title', models.TextField(null=True)),
                ('ref_type', models.TextField()),
                ('update_record', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='references', to='rpm.updaterecord')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='UpdateCollectionPackage',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('arch', models.TextField()),
                ('epoch', models.TextField()),
                ('filename', models.TextField()),
                ('name', models.TextField()),
                ('reboot_suggested', models.BooleanField(default=False)),
                ('release', models.TextField()),
                ('src', models.TextField()),
                ('sum', models.TextField()),
                ('sum_type', models.TextField()),
                ('version', models.TextField()),
                ('update_collection', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='packages', to='rpm.updatecollection')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='updatecollection',
            name='update_record',
            field=models.ManyToManyField(related_name='collections', to='rpm.updaterecord'),
        ),
        migrations.CreateModel(
            name='RpmDistribution',
            fields=[
                ('basedistribution_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_rpmdistribution', serialize=False, to='core.basedistribution')),
                ('publication', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='rpm_rpmdistribution', to='core.publication')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.basedistribution',),
        ),
        migrations.CreateModel(
            name='RepoMetadataFile',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_repometadatafile', serialize=False, to='core.content')),
                ('data_type', models.CharField(max_length=20)),
                ('checksum_type', models.CharField(max_length=6)),
                ('checksum', models.CharField(max_length=128)),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('data_type', 'checksum')},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='PackageGroup',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_packagegroup', serialize=False, to='core.content')),
                ('id', models.CharField(max_length=255)),
                ('default', models.BooleanField(default=False)),
                ('user_visible', models.BooleanField(default=False)),
                ('display_order', models.IntegerField(null=True)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(default='')),
                ('packages', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('biarch_only', models.BooleanField(default=False)),
                ('desc_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('name_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('digest', models.CharField(max_length=64, unique=True)),
                ('related_packages', models.ManyToManyField(related_name='rpm_packagegroup', to='rpm.package')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='PackageEnvironment',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_packageenvironment', serialize=False, to='core.content')),
                ('id', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(default='')),
                ('display_order', models.IntegerField(null=True)),
                ('group_ids', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('option_ids', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('desc_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('name_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('digest', models.CharField(max_length=64, unique=True)),
                ('optionalgroups', models.ManyToManyField(related_name='optionalgroups_to_env', to='rpm.packagegroup')),
                ('packagegroups', models.ManyToManyField(related_name='packagegroups_to_env', to='rpm.packagegroup')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='PackageCategory',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_packagecategory', serialize=False, to='core.content')),
                ('id', models.CharField(max_length=255)),
                ('name', models.CharField(max_length=255)),
                ('description', models.TextField(default='')),
                ('display_order', models.IntegerField(null=True)),
                ('group_ids', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('desc_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('name_by_lang', django.contrib.postgres.fields.jsonb.JSONField(default=dict)),
                ('digest', models.CharField(max_length=64, unique=True)),
                ('packagegroups', models.ManyToManyField(related_name='rpm_packagecategory', to='rpm.packagegroup')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='Variant',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('variant_id', models.CharField(max_length=50)),
                ('uid', models.CharField(max_length=50)),
                ('name', models.CharField(max_length=50)),
                ('type', models.CharField(max_length=20)),
                ('packages', models.CharField(max_length=50)),
                ('source_packages', models.CharField(max_length=50, null=True)),
                ('source_repository', models.CharField(max_length=50, null=True)),
                ('debug_packages', models.CharField(max_length=50, null=True)),
                ('debug_repository', models.CharField(max_length=50, null=True)),
                ('identity', models.CharField(max_length=50, null=True)),
                ('distribution_tree', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='variants', to='rpm.distributiontree')),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='+', to='core.repository')),
            ],
            options={
                'unique_together': {('variant_id', 'uid', 'name', 'type', 'packages', 'distribution_tree')},
            },
        ),
        migrations.CreateModel(
            name='Modulemd',
            fields=[
                ('content_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, related_name='rpm_modulemd', serialize=False, to='core.content')),
                ('name', models.CharField(max_length=255)),
                ('stream', models.CharField(max_length=255)),
                ('version', models.CharField(max_length=255)),
                ('context', models.CharField(max_length=255)),
                ('arch', models.CharField(max_length=255)),
                ('dependencies', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('artifacts', django.contrib.postgres.fields.jsonb.JSONField(default=list)),
                ('packages', models.ManyToManyField(related_name='rpm_modulemd', to='rpm.package')),
            ],
            options={
                'default_related_name': '%(app_label)s_%(model_name)s',
                'unique_together': {('name', 'stream', 'version', 'context', 'arch')},
            },
            bases=('core.content',),
        ),
        migrations.CreateModel(
            name='Image',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('name', models.CharField(max_length=20)),
                ('path', models.CharField(max_length=128)),
                ('platforms', models.CharField(max_length=20)),
                ('distribution_tree', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='images', to='rpm.distributiontree')),
            ],
            options={
                'unique_together': {('name', 'path', 'platforms', 'distribution_tree')},
            },
        ),
        migrations.CreateModel(
            name='Checksum',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('path', models.CharField(max_length=128)),
                ('checksum', models.CharField(max_length=128, null=True)),
                ('distribution_tree', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='checksums', to='rpm.distributiontree')),
            ],
            options={
                'unique_together': {('path', 'checksum', 'distribution_tree')},
            },
        ),
        migrations.CreateModel(
            name='Addon',
            fields=[
                ('pulp_id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('pulp_created', models.DateTimeField(auto_now_add=True)),
                ('pulp_last_updated', models.DateTimeField(auto_now=True, null=True)),
                ('addon_id', models.CharField(max_length=50)),
                ('uid', models.CharField(max_length=50)),
                ('name', models.CharField(max_length=50)),
                ('type', models.CharField(max_length=20)),
                ('packages', models.CharField(max_length=50)),
                ('distribution_tree', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='addons', to='rpm.distributiontree')),
                ('repository', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='addons', to='core.repository')),
            ],
            options={
                'unique_together': {('addon_id', 'uid', 'name', 'type', 'packages', 'distribution_tree')},
            },
        ),
    ]
